<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class CollectionLogSearch extends CollectionLog
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "CollectionLogSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "collectionlogsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->location->setVisibility();
        $this->agent->setVisibility();
        $this->account_no->setVisibility();
        $this->emi_no->setVisibility();
        $this->amount->setVisibility();
        $this->panel->Visible = false;
        $this->dated->setVisibility();
        $this->revised_date->setVisibility();
        $this->updated->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->url->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'collection_log';
        $this->TableName = 'collection_log';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (collection_log)
        if (!isset($GLOBALS["collection_log"]) || $GLOBALS["collection_log"]::class == PROJECT_NAMESPACE . "collection_log") {
            $GLOBALS["collection_log"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'collection_log');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "collectionlogview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->agent);
        $this->setupLookupOptions($this->account_no);
        $this->setupLookupOptions($this->updated);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "collectionloglist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->location); // location
        $this->buildSearchUrl($srchUrl, $this->agent); // agent
        $this->buildSearchUrl($srchUrl, $this->account_no); // account_no
        $this->buildSearchUrl($srchUrl, $this->emi_no); // emi_no
        $this->buildSearchUrl($srchUrl, $this->amount); // amount
        $this->buildSearchUrl($srchUrl, $this->dated); // dated
        $this->buildSearchUrl($srchUrl, $this->revised_date); // revised_date
        $this->buildSearchUrl($srchUrl, $this->updated); // updated
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // location
        if ($this->location->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // agent
        if ($this->agent->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // account_no
        if ($this->account_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // emi_no
        if ($this->emi_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dated
        if ($this->dated->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // revised_date
        if ($this->revised_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // updated
        if ($this->updated->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // account_no
        $this->account_no->RowCssClass = "row";

        // emi_no
        $this->emi_no->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // panel
        $this->panel->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // revised_date
        $this->revised_date->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // agent
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->ViewValue = FormatNumber($this->agent->CurrentValue, $this->agent->formatPattern());
                    }
                }
            } else {
                $this->agent->ViewValue = null;
            }

            // account_no
            $this->account_no->ViewValue = $this->account_no->CurrentValue;
            $curVal = strval($this->account_no->CurrentValue);
            if ($curVal != "") {
                $this->account_no->ViewValue = $this->account_no->lookupCacheOption($curVal);
                if ($this->account_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->account_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->account_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->account_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->account_no->Lookup->renderViewRow($rswrk[0]);
                        $this->account_no->ViewValue = $this->account_no->displayValue($arwrk);
                    } else {
                        $this->account_no->ViewValue = FormatNumber($this->account_no->CurrentValue, $this->account_no->formatPattern());
                    }
                }
            } else {
                $this->account_no->ViewValue = null;
            }

            // emi_no
            $this->emi_no->ViewValue = $this->emi_no->CurrentValue;
            $this->emi_no->ViewValue = FormatNumber($this->emi_no->ViewValue, $this->emi_no->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // revised_date
            $this->revised_date->ViewValue = $this->revised_date->CurrentValue;
            $this->revised_date->ViewValue = FormatDateTime($this->revised_date->ViewValue, $this->revised_date->formatPattern());

            // updated
            if (strval($this->updated->CurrentValue) != "") {
                $this->updated->ViewValue = $this->updated->optionCaption($this->updated->CurrentValue);
            } else {
                $this->updated->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // agent
            $this->agent->HrefValue = "";
            $this->agent->TooltipValue = "";

            // account_no
            $this->account_no->HrefValue = "";
            $this->account_no->TooltipValue = "";

            // emi_no
            $this->emi_no->HrefValue = "";
            $this->emi_no->TooltipValue = "";

            // amount
            if (!EmptyValue($this->url->CurrentValue)) {
                $this->amount->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
                $this->amount->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->amount->HrefValue = FullUrl($this->amount->HrefValue, "href");
                }
            } else {
                $this->amount->HrefValue = "";
            }
            $this->amount->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";

            // revised_date
            $this->revised_date->HrefValue = "";
            $this->revised_date->TooltipValue = "";

            // updated
            $this->updated->HrefValue = "";
            $this->updated->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->AdvancedSearch->SearchValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // agent
            $this->agent->setupEditAttributes();
            $curVal = trim(strval($this->agent->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->agent->AdvancedSearch->ViewValue = $this->agent->lookupCacheOption($curVal);
            } else {
                $this->agent->AdvancedSearch->ViewValue = $this->agent->Lookup !== null && is_array($this->agent->lookupOptions()) && count($this->agent->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->agent->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->agent->EditValue = array_values($this->agent->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->agent->AdvancedSearch->SearchValue, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                $sqlWrk = $this->agent->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->agent->EditValue = $arwrk;
            }
            $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

            // account_no
            $this->account_no->setupEditAttributes();
            $this->account_no->EditValue = $this->account_no->AdvancedSearch->SearchValue;
            $curVal = strval($this->account_no->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->account_no->EditValue = $this->account_no->lookupCacheOption($curVal);
                if ($this->account_no->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->account_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->account_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->account_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->account_no->Lookup->renderViewRow($rswrk[0]);
                        $this->account_no->EditValue = $this->account_no->displayValue($arwrk);
                    } else {
                        $this->account_no->EditValue = HtmlEncode(FormatNumber($this->account_no->AdvancedSearch->SearchValue, $this->account_no->formatPattern()));
                    }
                }
            } else {
                $this->account_no->EditValue = null;
            }
            $this->account_no->PlaceHolder = RemoveHtml($this->account_no->caption());

            // emi_no
            $this->emi_no->setupEditAttributes();
            $this->emi_no->EditValue = $this->emi_no->AdvancedSearch->SearchValue;
            $this->emi_no->PlaceHolder = RemoveHtml($this->emi_no->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->AdvancedSearch->SearchValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue, $this->dated->formatPattern()), $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // revised_date
            $this->revised_date->setupEditAttributes();
            $this->revised_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->revised_date->AdvancedSearch->SearchValue, $this->revised_date->formatPattern()), $this->revised_date->formatPattern()));
            $this->revised_date->PlaceHolder = RemoveHtml($this->revised_date->caption());
            $this->revised_date->setupEditAttributes();
            $this->revised_date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->revised_date->AdvancedSearch->SearchValue2, $this->revised_date->formatPattern()), $this->revised_date->formatPattern()));
            $this->revised_date->PlaceHolder = RemoveHtml($this->revised_date->caption());

            // updated
            $this->updated->setupEditAttributes();
            $this->updated->EditValue = $this->updated->options(true);
            $this->updated->PlaceHolder = RemoveHtml($this->updated->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->account_no->AdvancedSearch->SearchValue)) {
            $this->account_no->addErrorMessage($this->account_no->getErrorMessage(false));
        }
        if (!CheckInteger($this->emi_no->AdvancedSearch->SearchValue)) {
            $this->emi_no->addErrorMessage($this->emi_no->getErrorMessage(false));
        }
        if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
            $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
        }
        if (!CheckDate($this->dated->AdvancedSearch->SearchValue, $this->dated->formatPattern())) {
            $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
        }
        if (!CheckDate($this->revised_date->AdvancedSearch->SearchValue, $this->revised_date->formatPattern())) {
            $this->revised_date->addErrorMessage($this->revised_date->getErrorMessage(false));
        }
        if (!CheckDate($this->revised_date->AdvancedSearch->SearchValue2, $this->revised_date->formatPattern())) {
            $this->revised_date->addErrorMessage($this->revised_date->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->location->AdvancedSearch->load();
        $this->agent->AdvancedSearch->load();
        $this->account_no->AdvancedSearch->load();
        $this->emi_no->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->dated->AdvancedSearch->load();
        $this->revised_date->AdvancedSearch->load();
        $this->updated->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("collectionloglist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_account_no":
                    break;
                case "x_updated":
                    break;
                case "x_operator":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
