<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ClientHardwareDataView extends ClientHardwareData
{
    use MessagesTrait;

    // Page ID
    public $PageID = "view";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ClientHardwareDataView";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "clienthardwaredataview";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->customer_grp->setVisibility();
        $this->ref->setVisibility();
        $this->partner_id->setVisibility();
        $this->name_ref->setVisibility();
        $this->city_name->setVisibility();
        $this->area->setVisibility();
        $this->billing_name->setVisibility();
        $this->address->setVisibility();
        $this->personal_ref->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->rid_1->setVisibility();
        $this->harward_code->setVisibility();
        $this->serial_no->setVisibility();
        $this->invoice_no->setVisibility();
        $this->invoice_date->setVisibility();
        $this->first_counter->setVisibility();
        $this->guarantee->setVisibility();
        $this->valid_till->setVisibility();
        $this->valid_till_counter->setVisibility();
        $this->free_service->setVisibility();
        $this->toner_life->setVisibility();
        $this->drum_life->setVisibility();
        $this->developer_life->setVisibility();
        $this->date_install->setVisibility();
        $this->date_start->setVisibility();
        $this->remark->setVisibility();
        $this->status->setVisibility();
        $this->schedule_service_type->setVisibility();
        $this->schedule_service_interval_days->setVisibility();
        $this->schedule_service_updated_till->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->copy_average_1->setVisibility();
        $this->copy_average_2->setVisibility();
        $this->copy_average_3->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'client_hardware_data';
        $this->TableName = 'client_hardware_data';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (client_hardware_data)
        if (!isset($GLOBALS["client_hardware_data"]) || $GLOBALS["client_hardware_data"]::class == PROJECT_NAMESPACE . "client_hardware_data") {
            $GLOBALS["client_hardware_data"] = &$this;
        }

        // Set up record key
        if (($keyValue = Get("id") ?? Route("id")) !== null) {
            $this->RecKey["id"] = $keyValue;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'client_hardware_data');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "clienthardwaredataview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $ExportOptions; // Export options
    public $OtherOptions; // Other options
    public $DisplayRecords = 1;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecKey = [];
    public $IsModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->customer_grp);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->personal_ref);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->guarantee);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->schedule_service_type);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }

        // Load current record
        $loadCurrentRecord = false;
        $returnUrl = "";
        $matchRecord = false;
        if (($keyValue = Get("id") ?? Route("id")) !== null) {
            $this->id->setQueryStringValue($keyValue);
            $this->RecKey["id"] = $this->id->QueryStringValue;
        } elseif (Post("id") !== null) {
            $this->id->setFormValue(Post("id"));
            $this->RecKey["id"] = $this->id->FormValue;
        } elseif (IsApi() && ($keyValue = Key(0) ?? Route(2)) !== null) {
            $this->id->setQueryStringValue($keyValue);
            $this->RecKey["id"] = $this->id->QueryStringValue;
        } elseif (!$loadCurrentRecord) {
            $returnUrl = "clienthardwaredatalist"; // Return to list
        }

        // Get action
        $this->CurrentAction = "show"; // Display
        switch ($this->CurrentAction) {
            case "show": // Get a record to display

                    // Load record based on key
                    if (IsApi()) {
                        $filter = $this->getRecordFilter();
                        $this->CurrentFilter = $filter;
                        $sql = $this->getCurrentSql();
                        $conn = $this->getConnection();
                        $res = ($this->Recordset = ExecuteQuery($sql, $conn));
                    } else {
                        $res = $this->loadRow();
                    }
                    if (!$res) { // Load record based on key
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $returnUrl = "clienthardwaredatalist"; // No matching record, return to list
                    }
                break;
        }
        if ($returnUrl != "") {
            $this->terminate($returnUrl);
            return;
        }

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Render row
        $this->RowType = RowType::VIEW;
        $this->resetAttributes();
        $this->renderRow();

        // Set up detail parameters
        $this->setupDetailParms();

        // Normal return
        if (IsApi()) {
            if (!$this->isExport()) {
                $row = $this->getRecordsFromRecordset($this->Recordset, true); // Get current record only
                $this->Recordset?->free();
                WriteJson(["success" => true, "action" => Config("API_VIEW_ACTION"), $this->TableVar => $row]);
                $this->terminate(true);
            }
            return;
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Disable Add/Edit/Copy/Delete for Modal and UseAjaxActions
        /*
        if ($this->IsModal && $this->UseAjaxActions) {
            $this->AddUrl = "";
            $this->EditUrl = "";
            $this->CopyUrl = "";
            $this->DeleteUrl = "";
        }
        */
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();

        // Edit
        $item = &$option->add("edit");
        $editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
        }
        $item->Visible = $this->EditUrl != "" && $Security->canEdit();

        // Copy
        $item = &$option->add("copy");
        $copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
        }
        $item->Visible = $this->CopyUrl != "" && $Security->canAdd();

        // Delete
        $item = &$option->add("delete");
        $url = GetUrl($this->DeleteUrl);
        $item->Body = "<a class=\"ew-action ew-delete\"" .
            ($this->InlineDelete || $this->IsModal ? " data-ew-action=\"inline-delete\"" : "") .
            " title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) .
            "\" href=\"" . HtmlEncode($url) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
        $item->Visible = $this->DeleteUrl != "" && $Security->canDelete();
        $option = $options["detail"];
        $detailTableLink = "";
        $detailViewTblVar = "";
        $detailCopyTblVar = "";
        $detailEditTblVar = "";

        // "detail_service_schedule"
        $item = &$option->add("detail_service_schedule");
        $body = $Language->phrase("ViewPageDetailLink") . $Language->tablePhrase("service_schedule", "TblCaption");
        $body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode(GetUrl("serviceschedulelist?" . Config("TABLE_SHOW_MASTER") . "=client_hardware_data&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue) . "")) . "\">" . $body . "</a>";
        $links = "";
        $detailPageObj = Container("ServiceScheduleGrid");
        if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'client_hardware_data')) {
            $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=service_schedule"))) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            if ($detailViewTblVar != "") {
                $detailViewTblVar .= ",";
            }
            $detailViewTblVar .= "service_schedule";
        }
        if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'client_hardware_data')) {
            $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=service_schedule"))) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            if ($detailEditTblVar != "") {
                $detailEditTblVar .= ",";
            }
            $detailEditTblVar .= "service_schedule";
        }
        if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'client_hardware_data')) {
            $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=service_schedule"))) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            if ($detailCopyTblVar != "") {
                $detailCopyTblVar .= ",";
            }
            $detailCopyTblVar .= "service_schedule";
        }
        if ($links != "") {
            $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
            $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
        } else {
            $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
        }
        $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
        $item->Body = $body;
        $item->Visible = $Security->allowList(CurrentProjectID() . 'service_schedule');
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "service_schedule";
        }
        if ($this->ShowMultipleDetails) {
            $item->Visible = false;
        }

        // Multiple details
        if ($this->ShowMultipleDetails) {
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
            $links = "";
            if ($detailViewTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailViewLink", true)) . "\" href=\"" . HtmlEncode(GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar))) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            }
            if ($detailEditTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailEditLink", true)) . "\" href=\"" . HtmlEncode(GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar))) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            }
            if ($detailCopyTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailCopyLink", true)) . "\" href=\"" . HtmlEncode(GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar))) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlEncode($Language->phrase("MultipleMasterDetails", true)) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
                $body .= "<ul class=\"dropdown-menu ew-dropdown-menu\">" . $links . "</ul>";
            }
            $body .= "</div>";
            // Multiple details
            $item = &$option->add("details");
            $item->Body = $body;
        }

        // Set up detail default
        $option = $options["detail"];
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $ar = explode(",", $detailTableLink);
        $cnt = count($ar);
        $option->UseDropDownButton = ($cnt > 1);
        $option->UseButtonGroup = true;
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Set up action default
        $option = $options["action"];
        $option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
        $option->UseDropDownButton = !IsJsonResponse() && false;
        $option->UseButtonGroup = true;
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        if ($this->AuditTrailOnView) {
            $this->writeAuditTrailOnView($row);
        }
        $this->id->setDbValue($row['id']);
        $this->customer_grp->setDbValue($row['customer_grp']);
        $this->ref->setDbValue($row['ref']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->name_ref->setDbValue($row['name_ref']);
        $this->city_name->setDbValue($row['city_name']);
        $this->area->setDbValue($row['area']);
        $this->billing_name->setDbValue($row['billing_name']);
        $this->address->setDbValue($row['address']);
        $this->personal_ref->setDbValue($row['personal_ref']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->harward_code->setDbValue($row['harward_code']);
        $this->serial_no->setDbValue($row['serial_no']);
        $this->invoice_no->setDbValue($row['invoice_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->first_counter->setDbValue($row['first_counter']);
        $this->guarantee->setDbValue($row['guarantee']);
        $this->valid_till->setDbValue($row['valid_till']);
        $this->valid_till_counter->setDbValue($row['valid_till_counter']);
        $this->free_service->setDbValue($row['free_service']);
        $this->toner_life->setDbValue($row['toner_life']);
        $this->drum_life->setDbValue($row['drum_life']);
        $this->developer_life->setDbValue($row['developer_life']);
        $this->date_install->setDbValue($row['date_install']);
        $this->date_start->setDbValue($row['date_start']);
        $this->remark->setDbValue($row['remark']);
        $this->status->setDbValue($row['status']);
        $this->schedule_service_type->setDbValue($row['schedule_service_type']);
        $this->schedule_service_interval_days->setDbValue($row['schedule_service_interval_days']);
        $this->schedule_service_updated_till->setDbValue($row['schedule_service_updated_till']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->copy_average_1->setDbValue($row['copy_average_1']);
        $this->copy_average_2->setDbValue($row['copy_average_2']);
        $this->copy_average_3->setDbValue($row['copy_average_3']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['customer_grp'] = $this->customer_grp->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['name_ref'] = $this->name_ref->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['area'] = $this->area->DefaultValue;
        $row['billing_name'] = $this->billing_name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['personal_ref'] = $this->personal_ref->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['harward_code'] = $this->harward_code->DefaultValue;
        $row['serial_no'] = $this->serial_no->DefaultValue;
        $row['invoice_no'] = $this->invoice_no->DefaultValue;
        $row['invoice_date'] = $this->invoice_date->DefaultValue;
        $row['first_counter'] = $this->first_counter->DefaultValue;
        $row['guarantee'] = $this->guarantee->DefaultValue;
        $row['valid_till'] = $this->valid_till->DefaultValue;
        $row['valid_till_counter'] = $this->valid_till_counter->DefaultValue;
        $row['free_service'] = $this->free_service->DefaultValue;
        $row['toner_life'] = $this->toner_life->DefaultValue;
        $row['drum_life'] = $this->drum_life->DefaultValue;
        $row['developer_life'] = $this->developer_life->DefaultValue;
        $row['date_install'] = $this->date_install->DefaultValue;
        $row['date_start'] = $this->date_start->DefaultValue;
        $row['remark'] = $this->remark->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['schedule_service_type'] = $this->schedule_service_type->DefaultValue;
        $row['schedule_service_interval_days'] = $this->schedule_service_interval_days->DefaultValue;
        $row['schedule_service_updated_till'] = $this->schedule_service_updated_till->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['copy_average_1'] = $this->copy_average_1->DefaultValue;
        $row['copy_average_2'] = $this->copy_average_2->DefaultValue;
        $row['copy_average_3'] = $this->copy_average_3->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->AddUrl = $this->getAddUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();
        $this->ListUrl = $this->getListUrl();
        $this->setupOtherOptions();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // customer_grp

        // ref

        // partner_id

        // name_ref

        // city_name

        // area

        // billing_name

        // address

        // personal_ref

        // grp

        // s_grp

        // product

        // rid

        // rid_1

        // harward_code

        // serial_no

        // invoice_no

        // invoice_date

        // first_counter

        // guarantee

        // valid_till

        // valid_till_counter

        // free_service

        // toner_life

        // drum_life

        // developer_life

        // date_install

        // date_start

        // remark

        // status

        // schedule_service_type

        // schedule_service_interval_days

        // schedule_service_updated_till

        // operator

        // datetime

        // copy_average_1

        // copy_average_2

        // copy_average_3

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // customer_grp
            $curVal = strval($this->customer_grp->CurrentValue);
            if ($curVal != "") {
                $this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
                if ($this->customer_grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->customer_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->customer_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->customer_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->customer_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->customer_grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->customer_grp->Lookup->renderViewRow($row);
                            $this->customer_grp->ViewValue->add($this->customer_grp->displayValue($arwrk));
                        }
                    } else {
                        $this->customer_grp->ViewValue = $this->customer_grp->CurrentValue;
                    }
                }
            } else {
                $this->customer_grp->ViewValue = null;
            }

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // name_ref
            $this->name_ref->ViewValue = $this->name_ref->CurrentValue;

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // area
            $this->area->ViewValue = $this->area->CurrentValue;

            // billing_name
            $this->billing_name->ViewValue = $this->billing_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // personal_ref
            $curVal = strval($this->personal_ref->CurrentValue);
            if ($curVal != "") {
                $this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
                if ($this->personal_ref->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->personal_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->personal_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->personal_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->personal_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->personal_ref->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->personal_ref->Lookup->renderViewRow($row);
                            $this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
                        }
                    } else {
                        $this->personal_ref->ViewValue = $this->personal_ref->CurrentValue;
                    }
                }
            } else {
                $this->personal_ref->ViewValue = null;
            }

            // harward_code
            $this->harward_code->ViewValue = $this->harward_code->CurrentValue;

            // serial_no
            $this->serial_no->ViewValue = $this->serial_no->CurrentValue;

            // invoice_no
            $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

            // first_counter
            $this->first_counter->ViewValue = $this->first_counter->CurrentValue;
            $this->first_counter->ViewValue = FormatNumber($this->first_counter->ViewValue, $this->first_counter->formatPattern());

            // guarantee
            if (strval($this->guarantee->CurrentValue) != "") {
                $this->guarantee->ViewValue = $this->guarantee->optionCaption($this->guarantee->CurrentValue);
            } else {
                $this->guarantee->ViewValue = null;
            }

            // valid_till
            $this->valid_till->ViewValue = $this->valid_till->CurrentValue;
            $this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, $this->valid_till->formatPattern());

            // valid_till_counter
            $this->valid_till_counter->ViewValue = $this->valid_till_counter->CurrentValue;
            $this->valid_till_counter->ViewValue = FormatNumber($this->valid_till_counter->ViewValue, $this->valid_till_counter->formatPattern());

            // free_service
            $this->free_service->ViewValue = $this->free_service->CurrentValue;
            $this->free_service->ViewValue = FormatNumber($this->free_service->ViewValue, $this->free_service->formatPattern());

            // toner_life
            $this->toner_life->ViewValue = $this->toner_life->CurrentValue;
            $this->toner_life->ViewValue = FormatNumber($this->toner_life->ViewValue, $this->toner_life->formatPattern());

            // drum_life
            $this->drum_life->ViewValue = $this->drum_life->CurrentValue;
            $this->drum_life->ViewValue = FormatNumber($this->drum_life->ViewValue, $this->drum_life->formatPattern());

            // developer_life
            $this->developer_life->ViewValue = $this->developer_life->CurrentValue;
            $this->developer_life->ViewValue = FormatNumber($this->developer_life->ViewValue, $this->developer_life->formatPattern());

            // date_install
            $this->date_install->ViewValue = $this->date_install->CurrentValue;
            $this->date_install->ViewValue = FormatDateTime($this->date_install->ViewValue, $this->date_install->formatPattern());

            // date_start
            $this->date_start->ViewValue = $this->date_start->CurrentValue;
            $this->date_start->ViewValue = FormatDateTime($this->date_start->ViewValue, $this->date_start->formatPattern());

            // remark
            $this->remark->ViewValue = $this->remark->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // schedule_service_type
            $curVal = strval($this->schedule_service_type->CurrentValue);
            if ($curVal != "") {
                $this->schedule_service_type->ViewValue = $this->schedule_service_type->lookupCacheOption($curVal);
                if ($this->schedule_service_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->schedule_service_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->schedule_service_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->schedule_service_type->Lookup->renderViewRow($rswrk[0]);
                        $this->schedule_service_type->ViewValue = $this->schedule_service_type->displayValue($arwrk);
                    } else {
                        $this->schedule_service_type->ViewValue = FormatNumber($this->schedule_service_type->CurrentValue, $this->schedule_service_type->formatPattern());
                    }
                }
            } else {
                $this->schedule_service_type->ViewValue = null;
            }

            // schedule_service_interval_days
            $this->schedule_service_interval_days->ViewValue = $this->schedule_service_interval_days->CurrentValue;
            $this->schedule_service_interval_days->ViewValue = FormatNumber($this->schedule_service_interval_days->ViewValue, $this->schedule_service_interval_days->formatPattern());

            // schedule_service_updated_till
            $this->schedule_service_updated_till->ViewValue = $this->schedule_service_updated_till->CurrentValue;
            $this->schedule_service_updated_till->ViewValue = FormatDateTime($this->schedule_service_updated_till->ViewValue, $this->schedule_service_updated_till->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // copy_average_1
            $this->copy_average_1->ViewValue = $this->copy_average_1->CurrentValue;
            $this->copy_average_1->ViewValue = FormatNumber($this->copy_average_1->ViewValue, $this->copy_average_1->formatPattern());

            // copy_average_2
            $this->copy_average_2->ViewValue = $this->copy_average_2->CurrentValue;
            $this->copy_average_2->ViewValue = FormatNumber($this->copy_average_2->ViewValue, $this->copy_average_2->formatPattern());

            // copy_average_3
            $this->copy_average_3->ViewValue = $this->copy_average_3->CurrentValue;
            $this->copy_average_3->ViewValue = FormatNumber($this->copy_average_3->ViewValue, $this->copy_average_3->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // customer_grp
            $this->customer_grp->HrefValue = "";
            $this->customer_grp->TooltipValue = "";

            // ref
            $this->ref->HrefValue = "";
            $this->ref->TooltipValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";
            $this->partner_id->TooltipValue = "";

            // name_ref
            $this->name_ref->HrefValue = "";
            $this->name_ref->TooltipValue = "";

            // city_name
            $this->city_name->HrefValue = "";
            $this->city_name->TooltipValue = "";

            // area
            $this->area->HrefValue = "";
            $this->area->TooltipValue = "";

            // billing_name
            $this->billing_name->HrefValue = "";
            $this->billing_name->TooltipValue = "";

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";

            // personal_ref
            $this->personal_ref->HrefValue = "";
            $this->personal_ref->TooltipValue = "";

            // harward_code
            $this->harward_code->HrefValue = "";
            $this->harward_code->TooltipValue = "";

            // serial_no
            $this->serial_no->HrefValue = "";
            $this->serial_no->TooltipValue = "";

            // invoice_no
            $this->invoice_no->HrefValue = "";
            $this->invoice_no->TooltipValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";

            // first_counter
            $this->first_counter->HrefValue = "";
            $this->first_counter->TooltipValue = "";

            // guarantee
            $this->guarantee->HrefValue = "";
            $this->guarantee->TooltipValue = "";

            // valid_till
            $this->valid_till->HrefValue = "";
            $this->valid_till->TooltipValue = "";

            // valid_till_counter
            $this->valid_till_counter->HrefValue = "";
            $this->valid_till_counter->TooltipValue = "";

            // free_service
            $this->free_service->HrefValue = "";
            $this->free_service->TooltipValue = "";

            // toner_life
            $this->toner_life->HrefValue = "";
            $this->toner_life->TooltipValue = "";

            // drum_life
            $this->drum_life->HrefValue = "";
            $this->drum_life->TooltipValue = "";

            // developer_life
            $this->developer_life->HrefValue = "";
            $this->developer_life->TooltipValue = "";

            // date_install
            $this->date_install->HrefValue = "";
            $this->date_install->TooltipValue = "";

            // date_start
            $this->date_start->HrefValue = "";
            $this->date_start->TooltipValue = "";

            // remark
            $this->remark->HrefValue = "";
            $this->remark->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // schedule_service_type
            $this->schedule_service_type->HrefValue = "";
            $this->schedule_service_type->TooltipValue = "";

            // schedule_service_interval_days
            $this->schedule_service_interval_days->HrefValue = "";
            $this->schedule_service_interval_days->TooltipValue = "";

            // schedule_service_updated_till
            $this->schedule_service_updated_till->HrefValue = "";
            $this->schedule_service_updated_till->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // copy_average_1
            $this->copy_average_1->HrefValue = "";
            $this->copy_average_1->TooltipValue = "";

            // copy_average_2
            $this->copy_average_2->HrefValue = "";
            $this->copy_average_2->TooltipValue = "";

            // copy_average_3
            $this->copy_average_3->HrefValue = "";
            $this->copy_average_3->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("service_schedule", $detailTblVar)) {
                $detailPageObj = Container("ServiceScheduleGrid");
                if ($detailPageObj->DetailView) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    $detailPageObj->CurrentMode = "view";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->hardware_id->IsDetailKey = true;
                    $detailPageObj->hardware_id->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->hardware_id->setSessionValue($detailPageObj->hardware_id->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("clienthardwaredatalist"), "", $this->TableVar, true);
        $pageId = "view";
        $Breadcrumb->add("view", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_customer_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_area":
                    break;
                case "x_personal_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_guarantee":
                    break;
                case "x_status":
                    break;
                case "x_schedule_service_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'client_hardware_data');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }
}
