<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ClientHardwareDataSearch extends ClientHardwareData
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ClientHardwareDataSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "clienthardwaredatasearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->customer_grp->setVisibility();
        $this->ref->setVisibility();
        $this->partner_id->setVisibility();
        $this->name_ref->setVisibility();
        $this->city_name->setVisibility();
        $this->area->setVisibility();
        $this->billing_name->setVisibility();
        $this->address->setVisibility();
        $this->personal_ref->setVisibility();
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->product->Visible = false;
        $this->rid->Visible = false;
        $this->rid_1->Visible = false;
        $this->harward_code->setVisibility();
        $this->serial_no->setVisibility();
        $this->invoice_no->setVisibility();
        $this->invoice_date->setVisibility();
        $this->first_counter->setVisibility();
        $this->guarantee->setVisibility();
        $this->valid_till->setVisibility();
        $this->valid_till_counter->setVisibility();
        $this->free_service->setVisibility();
        $this->toner_life->setVisibility();
        $this->drum_life->setVisibility();
        $this->developer_life->setVisibility();
        $this->date_install->setVisibility();
        $this->date_start->setVisibility();
        $this->remark->setVisibility();
        $this->status->setVisibility();
        $this->schedule_service_type->setVisibility();
        $this->schedule_service_interval_days->setVisibility();
        $this->schedule_service_updated_till->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->copy_average_1->setVisibility();
        $this->copy_average_2->setVisibility();
        $this->copy_average_3->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'client_hardware_data';
        $this->TableName = 'client_hardware_data';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (client_hardware_data)
        if (!isset($GLOBALS["client_hardware_data"]) || $GLOBALS["client_hardware_data"]::class == PROJECT_NAMESPACE . "client_hardware_data") {
            $GLOBALS["client_hardware_data"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'client_hardware_data');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "clienthardwaredataview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->customer_grp);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->personal_ref);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->guarantee);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->schedule_service_type);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "clienthardwaredatalist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->customer_grp); // customer_grp
        $this->buildSearchUrl($srchUrl, $this->ref); // ref
        $this->buildSearchUrl($srchUrl, $this->partner_id); // partner_id
        $this->buildSearchUrl($srchUrl, $this->name_ref); // name_ref
        $this->buildSearchUrl($srchUrl, $this->city_name); // city_name
        $this->buildSearchUrl($srchUrl, $this->area); // area
        $this->buildSearchUrl($srchUrl, $this->billing_name); // billing_name
        $this->buildSearchUrl($srchUrl, $this->address); // address
        $this->buildSearchUrl($srchUrl, $this->personal_ref); // personal_ref
        $this->buildSearchUrl($srchUrl, $this->harward_code); // harward_code
        $this->buildSearchUrl($srchUrl, $this->serial_no); // serial_no
        $this->buildSearchUrl($srchUrl, $this->invoice_no); // invoice_no
        $this->buildSearchUrl($srchUrl, $this->invoice_date); // invoice_date
        $this->buildSearchUrl($srchUrl, $this->first_counter); // first_counter
        $this->buildSearchUrl($srchUrl, $this->guarantee); // guarantee
        $this->buildSearchUrl($srchUrl, $this->valid_till); // valid_till
        $this->buildSearchUrl($srchUrl, $this->valid_till_counter); // valid_till_counter
        $this->buildSearchUrl($srchUrl, $this->free_service); // free_service
        $this->buildSearchUrl($srchUrl, $this->toner_life); // toner_life
        $this->buildSearchUrl($srchUrl, $this->drum_life); // drum_life
        $this->buildSearchUrl($srchUrl, $this->developer_life); // developer_life
        $this->buildSearchUrl($srchUrl, $this->date_install); // date_install
        $this->buildSearchUrl($srchUrl, $this->date_start); // date_start
        $this->buildSearchUrl($srchUrl, $this->remark); // remark
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->schedule_service_type); // schedule_service_type
        $this->buildSearchUrl($srchUrl, $this->schedule_service_interval_days); // schedule_service_interval_days
        $this->buildSearchUrl($srchUrl, $this->schedule_service_updated_till); // schedule_service_updated_till
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->copy_average_1); // copy_average_1
        $this->buildSearchUrl($srchUrl, $this->copy_average_2); // copy_average_2
        $this->buildSearchUrl($srchUrl, $this->copy_average_3); // copy_average_3
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // customer_grp
        if ($this->customer_grp->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->customer_grp->AdvancedSearch->SearchValue)) {
            $this->customer_grp->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->customer_grp->AdvancedSearch->SearchValue);
        }
        if (is_array($this->customer_grp->AdvancedSearch->SearchValue2)) {
            $this->customer_grp->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->customer_grp->AdvancedSearch->SearchValue2);
        }

        // ref
        if ($this->ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // partner_id
        if ($this->partner_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // name_ref
        if ($this->name_ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // city_name
        if ($this->city_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // area
        if ($this->area->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // billing_name
        if ($this->billing_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // address
        if ($this->address->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // personal_ref
        if ($this->personal_ref->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->personal_ref->AdvancedSearch->SearchValue)) {
            $this->personal_ref->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->personal_ref->AdvancedSearch->SearchValue);
        }
        if (is_array($this->personal_ref->AdvancedSearch->SearchValue2)) {
            $this->personal_ref->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->personal_ref->AdvancedSearch->SearchValue2);
        }

        // harward_code
        if ($this->harward_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // serial_no
        if ($this->serial_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // invoice_no
        if ($this->invoice_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // invoice_date
        if ($this->invoice_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // first_counter
        if ($this->first_counter->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // guarantee
        if ($this->guarantee->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // valid_till
        if ($this->valid_till->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // valid_till_counter
        if ($this->valid_till_counter->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // free_service
        if ($this->free_service->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // toner_life
        if ($this->toner_life->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // drum_life
        if ($this->drum_life->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // developer_life
        if ($this->developer_life->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // date_install
        if ($this->date_install->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // date_start
        if ($this->date_start->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remark
        if ($this->remark->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // schedule_service_type
        if ($this->schedule_service_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // schedule_service_interval_days
        if ($this->schedule_service_interval_days->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // schedule_service_updated_till
        if ($this->schedule_service_updated_till->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // copy_average_1
        if ($this->copy_average_1->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // copy_average_2
        if ($this->copy_average_2->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // copy_average_3
        if ($this->copy_average_3->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // customer_grp
        $this->customer_grp->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // name_ref
        $this->name_ref->RowCssClass = "row";

        // city_name
        $this->city_name->RowCssClass = "row";

        // area
        $this->area->RowCssClass = "row";

        // billing_name
        $this->billing_name->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // personal_ref
        $this->personal_ref->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // rid_1
        $this->rid_1->RowCssClass = "row";

        // harward_code
        $this->harward_code->RowCssClass = "row";

        // serial_no
        $this->serial_no->RowCssClass = "row";

        // invoice_no
        $this->invoice_no->RowCssClass = "row";

        // invoice_date
        $this->invoice_date->RowCssClass = "row";

        // first_counter
        $this->first_counter->RowCssClass = "row";

        // guarantee
        $this->guarantee->RowCssClass = "row";

        // valid_till
        $this->valid_till->RowCssClass = "row";

        // valid_till_counter
        $this->valid_till_counter->RowCssClass = "row";

        // free_service
        $this->free_service->RowCssClass = "row";

        // toner_life
        $this->toner_life->RowCssClass = "row";

        // drum_life
        $this->drum_life->RowCssClass = "row";

        // developer_life
        $this->developer_life->RowCssClass = "row";

        // date_install
        $this->date_install->RowCssClass = "row";

        // date_start
        $this->date_start->RowCssClass = "row";

        // remark
        $this->remark->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // schedule_service_type
        $this->schedule_service_type->RowCssClass = "row";

        // schedule_service_interval_days
        $this->schedule_service_interval_days->RowCssClass = "row";

        // schedule_service_updated_till
        $this->schedule_service_updated_till->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // copy_average_1
        $this->copy_average_1->RowCssClass = "row";

        // copy_average_2
        $this->copy_average_2->RowCssClass = "row";

        // copy_average_3
        $this->copy_average_3->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // customer_grp
            $curVal = strval($this->customer_grp->CurrentValue);
            if ($curVal != "") {
                $this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
                if ($this->customer_grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->customer_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->customer_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->customer_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->customer_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->customer_grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->customer_grp->Lookup->renderViewRow($row);
                            $this->customer_grp->ViewValue->add($this->customer_grp->displayValue($arwrk));
                        }
                    } else {
                        $this->customer_grp->ViewValue = $this->customer_grp->CurrentValue;
                    }
                }
            } else {
                $this->customer_grp->ViewValue = null;
            }

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // name_ref
            $this->name_ref->ViewValue = $this->name_ref->CurrentValue;

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // area
            $this->area->ViewValue = $this->area->CurrentValue;

            // billing_name
            $this->billing_name->ViewValue = $this->billing_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // personal_ref
            $curVal = strval($this->personal_ref->CurrentValue);
            if ($curVal != "") {
                $this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
                if ($this->personal_ref->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->personal_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->personal_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->personal_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->personal_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->personal_ref->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->personal_ref->Lookup->renderViewRow($row);
                            $this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
                        }
                    } else {
                        $this->personal_ref->ViewValue = $this->personal_ref->CurrentValue;
                    }
                }
            } else {
                $this->personal_ref->ViewValue = null;
            }

            // harward_code
            $this->harward_code->ViewValue = $this->harward_code->CurrentValue;

            // serial_no
            $this->serial_no->ViewValue = $this->serial_no->CurrentValue;

            // invoice_no
            $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

            // first_counter
            $this->first_counter->ViewValue = $this->first_counter->CurrentValue;
            $this->first_counter->ViewValue = FormatNumber($this->first_counter->ViewValue, $this->first_counter->formatPattern());

            // guarantee
            if (strval($this->guarantee->CurrentValue) != "") {
                $this->guarantee->ViewValue = $this->guarantee->optionCaption($this->guarantee->CurrentValue);
            } else {
                $this->guarantee->ViewValue = null;
            }

            // valid_till
            $this->valid_till->ViewValue = $this->valid_till->CurrentValue;
            $this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, $this->valid_till->formatPattern());

            // valid_till_counter
            $this->valid_till_counter->ViewValue = $this->valid_till_counter->CurrentValue;
            $this->valid_till_counter->ViewValue = FormatNumber($this->valid_till_counter->ViewValue, $this->valid_till_counter->formatPattern());

            // free_service
            $this->free_service->ViewValue = $this->free_service->CurrentValue;
            $this->free_service->ViewValue = FormatNumber($this->free_service->ViewValue, $this->free_service->formatPattern());

            // toner_life
            $this->toner_life->ViewValue = $this->toner_life->CurrentValue;
            $this->toner_life->ViewValue = FormatNumber($this->toner_life->ViewValue, $this->toner_life->formatPattern());

            // drum_life
            $this->drum_life->ViewValue = $this->drum_life->CurrentValue;
            $this->drum_life->ViewValue = FormatNumber($this->drum_life->ViewValue, $this->drum_life->formatPattern());

            // developer_life
            $this->developer_life->ViewValue = $this->developer_life->CurrentValue;
            $this->developer_life->ViewValue = FormatNumber($this->developer_life->ViewValue, $this->developer_life->formatPattern());

            // date_install
            $this->date_install->ViewValue = $this->date_install->CurrentValue;
            $this->date_install->ViewValue = FormatDateTime($this->date_install->ViewValue, $this->date_install->formatPattern());

            // date_start
            $this->date_start->ViewValue = $this->date_start->CurrentValue;
            $this->date_start->ViewValue = FormatDateTime($this->date_start->ViewValue, $this->date_start->formatPattern());

            // remark
            $this->remark->ViewValue = $this->remark->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // schedule_service_type
            $curVal = strval($this->schedule_service_type->CurrentValue);
            if ($curVal != "") {
                $this->schedule_service_type->ViewValue = $this->schedule_service_type->lookupCacheOption($curVal);
                if ($this->schedule_service_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->schedule_service_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->schedule_service_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->schedule_service_type->Lookup->renderViewRow($rswrk[0]);
                        $this->schedule_service_type->ViewValue = $this->schedule_service_type->displayValue($arwrk);
                    } else {
                        $this->schedule_service_type->ViewValue = FormatNumber($this->schedule_service_type->CurrentValue, $this->schedule_service_type->formatPattern());
                    }
                }
            } else {
                $this->schedule_service_type->ViewValue = null;
            }

            // schedule_service_interval_days
            $this->schedule_service_interval_days->ViewValue = $this->schedule_service_interval_days->CurrentValue;
            $this->schedule_service_interval_days->ViewValue = FormatNumber($this->schedule_service_interval_days->ViewValue, $this->schedule_service_interval_days->formatPattern());

            // schedule_service_updated_till
            $this->schedule_service_updated_till->ViewValue = $this->schedule_service_updated_till->CurrentValue;
            $this->schedule_service_updated_till->ViewValue = FormatDateTime($this->schedule_service_updated_till->ViewValue, $this->schedule_service_updated_till->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // copy_average_1
            $this->copy_average_1->ViewValue = $this->copy_average_1->CurrentValue;
            $this->copy_average_1->ViewValue = FormatNumber($this->copy_average_1->ViewValue, $this->copy_average_1->formatPattern());

            // copy_average_2
            $this->copy_average_2->ViewValue = $this->copy_average_2->CurrentValue;
            $this->copy_average_2->ViewValue = FormatNumber($this->copy_average_2->ViewValue, $this->copy_average_2->formatPattern());

            // copy_average_3
            $this->copy_average_3->ViewValue = $this->copy_average_3->CurrentValue;
            $this->copy_average_3->ViewValue = FormatNumber($this->copy_average_3->ViewValue, $this->copy_average_3->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // customer_grp
            $this->customer_grp->HrefValue = "";
            $this->customer_grp->TooltipValue = "";

            // ref
            $this->ref->HrefValue = "";
            $this->ref->TooltipValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";
            $this->partner_id->TooltipValue = "";

            // name_ref
            $this->name_ref->HrefValue = "";
            $this->name_ref->TooltipValue = "";

            // city_name
            $this->city_name->HrefValue = "";
            $this->city_name->TooltipValue = "";

            // area
            $this->area->HrefValue = "";
            $this->area->TooltipValue = "";

            // billing_name
            $this->billing_name->HrefValue = "";
            $this->billing_name->TooltipValue = "";

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";

            // personal_ref
            $this->personal_ref->HrefValue = "";
            $this->personal_ref->TooltipValue = "";

            // harward_code
            $this->harward_code->HrefValue = "";
            $this->harward_code->TooltipValue = "";

            // serial_no
            $this->serial_no->HrefValue = "";
            $this->serial_no->TooltipValue = "";

            // invoice_no
            $this->invoice_no->HrefValue = "";
            $this->invoice_no->TooltipValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";

            // first_counter
            $this->first_counter->HrefValue = "";
            $this->first_counter->TooltipValue = "";

            // guarantee
            $this->guarantee->HrefValue = "";
            $this->guarantee->TooltipValue = "";

            // valid_till
            $this->valid_till->HrefValue = "";
            $this->valid_till->TooltipValue = "";

            // valid_till_counter
            $this->valid_till_counter->HrefValue = "";
            $this->valid_till_counter->TooltipValue = "";

            // free_service
            $this->free_service->HrefValue = "";
            $this->free_service->TooltipValue = "";

            // toner_life
            $this->toner_life->HrefValue = "";
            $this->toner_life->TooltipValue = "";

            // drum_life
            $this->drum_life->HrefValue = "";
            $this->drum_life->TooltipValue = "";

            // developer_life
            $this->developer_life->HrefValue = "";
            $this->developer_life->TooltipValue = "";

            // date_install
            $this->date_install->HrefValue = "";
            $this->date_install->TooltipValue = "";

            // date_start
            $this->date_start->HrefValue = "";
            $this->date_start->TooltipValue = "";

            // remark
            $this->remark->HrefValue = "";
            $this->remark->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // schedule_service_type
            $this->schedule_service_type->HrefValue = "";
            $this->schedule_service_type->TooltipValue = "";

            // schedule_service_interval_days
            $this->schedule_service_interval_days->HrefValue = "";
            $this->schedule_service_interval_days->TooltipValue = "";

            // schedule_service_updated_till
            $this->schedule_service_updated_till->HrefValue = "";
            $this->schedule_service_updated_till->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // copy_average_1
            $this->copy_average_1->HrefValue = "";
            $this->copy_average_1->TooltipValue = "";

            // copy_average_2
            $this->copy_average_2->HrefValue = "";
            $this->copy_average_2->TooltipValue = "";

            // copy_average_3
            $this->copy_average_3->HrefValue = "";
            $this->copy_average_3->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // customer_grp
            $curVal = trim(strval($this->customer_grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->customer_grp->AdvancedSearch->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
            } else {
                $this->customer_grp->AdvancedSearch->ViewValue = $this->customer_grp->Lookup !== null && is_array($this->customer_grp->lookupOptions()) && count($this->customer_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->customer_grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->customer_grp->EditValue = array_values($this->customer_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->customer_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->customer_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->customer_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->customer_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->customer_grp->EditValue = $arwrk;
            }
            $this->customer_grp->PlaceHolder = RemoveHtml($this->customer_grp->caption());

            // ref
            $this->ref->setupEditAttributes();
            if (!$this->ref->Raw) {
                $this->ref->AdvancedSearch->SearchValue = HtmlDecode($this->ref->AdvancedSearch->SearchValue);
            }
            $this->ref->EditValue = HtmlEncode($this->ref->AdvancedSearch->SearchValue);
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->AdvancedSearch->SearchValue;
            $curVal = strval($this->partner_id->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->partner_id->EditValue = null;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue2 = $this->partner_id->AdvancedSearch->SearchValue2;
            $curVal = strval($this->partner_id->AdvancedSearch->SearchValue2);
            if ($curVal != "") {
                $this->partner_id->EditValue2 = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue2 === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue2 = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue2 = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue2);
                    }
                }
            } else {
                $this->partner_id->EditValue2 = null;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

            // name_ref
            $this->name_ref->setupEditAttributes();
            if (!$this->name_ref->Raw) {
                $this->name_ref->AdvancedSearch->SearchValue = HtmlDecode($this->name_ref->AdvancedSearch->SearchValue);
            }
            $this->name_ref->EditValue = HtmlEncode($this->name_ref->AdvancedSearch->SearchValue);
            $this->name_ref->PlaceHolder = RemoveHtml($this->name_ref->caption());

            // city_name
            $this->city_name->setupEditAttributes();
            if (!$this->city_name->Raw) {
                $this->city_name->AdvancedSearch->SearchValue = HtmlDecode($this->city_name->AdvancedSearch->SearchValue);
            }
            $this->city_name->EditValue = HtmlEncode($this->city_name->AdvancedSearch->SearchValue);
            $this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

            // area
            $this->area->setupEditAttributes();
            if (!$this->area->Raw) {
                $this->area->AdvancedSearch->SearchValue = HtmlDecode($this->area->AdvancedSearch->SearchValue);
            }
            $this->area->EditValue = HtmlEncode($this->area->AdvancedSearch->SearchValue);
            $arwrk = [];
            $arwrk["lf"] = $this->area->CurrentValue;
            $arwrk["df"] = $this->area->CurrentValue;
            $arwrk = $this->area->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->area->displayValue($arwrk);
            if ($dispVal != "") {
                $this->area->EditValue = $dispVal;
            }
            $this->area->PlaceHolder = RemoveHtml($this->area->caption());

            // billing_name
            $this->billing_name->setupEditAttributes();
            if (!$this->billing_name->Raw) {
                $this->billing_name->AdvancedSearch->SearchValue = HtmlDecode($this->billing_name->AdvancedSearch->SearchValue);
            }
            $this->billing_name->EditValue = HtmlEncode($this->billing_name->AdvancedSearch->SearchValue);
            $this->billing_name->PlaceHolder = RemoveHtml($this->billing_name->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->AdvancedSearch->SearchValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // personal_ref
            $curVal = trim(strval($this->personal_ref->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->personal_ref->AdvancedSearch->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
            } else {
                $this->personal_ref->AdvancedSearch->ViewValue = $this->personal_ref->Lookup !== null && is_array($this->personal_ref->lookupOptions()) && count($this->personal_ref->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->personal_ref->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->personal_ref->EditValue = array_values($this->personal_ref->lookupOptions());
                if ($this->personal_ref->AdvancedSearch->ViewValue == "") {
                    $this->personal_ref->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->personal_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->personal_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->personal_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->personal_ref->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->personal_ref->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->personal_ref->Lookup->renderViewRow($row);
                        $this->personal_ref->AdvancedSearch->ViewValue->add($this->personal_ref->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->personal_ref->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->personal_ref->Lookup->renderViewRow($row);
                }
                $this->personal_ref->EditValue = $arwrk;
            }
            $this->personal_ref->PlaceHolder = RemoveHtml($this->personal_ref->caption());

            // harward_code
            $this->harward_code->setupEditAttributes();
            if (!$this->harward_code->Raw) {
                $this->harward_code->AdvancedSearch->SearchValue = HtmlDecode($this->harward_code->AdvancedSearch->SearchValue);
            }
            $this->harward_code->EditValue = HtmlEncode($this->harward_code->AdvancedSearch->SearchValue);
            $this->harward_code->PlaceHolder = RemoveHtml($this->harward_code->caption());

            // serial_no
            $this->serial_no->setupEditAttributes();
            if (!$this->serial_no->Raw) {
                $this->serial_no->AdvancedSearch->SearchValue = HtmlDecode($this->serial_no->AdvancedSearch->SearchValue);
            }
            $this->serial_no->EditValue = HtmlEncode($this->serial_no->AdvancedSearch->SearchValue);
            $this->serial_no->PlaceHolder = RemoveHtml($this->serial_no->caption());

            // invoice_no
            $this->invoice_no->setupEditAttributes();
            if (!$this->invoice_no->Raw) {
                $this->invoice_no->AdvancedSearch->SearchValue = HtmlDecode($this->invoice_no->AdvancedSearch->SearchValue);
            }
            $this->invoice_no->EditValue = HtmlEncode($this->invoice_no->AdvancedSearch->SearchValue);
            $this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

            // invoice_date
            $this->invoice_date->setupEditAttributes();
            $this->invoice_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue, $this->invoice_date->formatPattern()), $this->invoice_date->formatPattern()));
            $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

            // first_counter
            $this->first_counter->setupEditAttributes();
            $this->first_counter->EditValue = $this->first_counter->AdvancedSearch->SearchValue;
            $this->first_counter->PlaceHolder = RemoveHtml($this->first_counter->caption());

            // guarantee
            $this->guarantee->setupEditAttributes();
            $this->guarantee->EditValue = $this->guarantee->options(true);
            $this->guarantee->PlaceHolder = RemoveHtml($this->guarantee->caption());

            // valid_till
            $this->valid_till->setupEditAttributes();
            $this->valid_till->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->valid_till->AdvancedSearch->SearchValue, $this->valid_till->formatPattern()), $this->valid_till->formatPattern()));
            $this->valid_till->PlaceHolder = RemoveHtml($this->valid_till->caption());

            // valid_till_counter
            $this->valid_till_counter->setupEditAttributes();
            $this->valid_till_counter->EditValue = $this->valid_till_counter->AdvancedSearch->SearchValue;
            $this->valid_till_counter->PlaceHolder = RemoveHtml($this->valid_till_counter->caption());

            // free_service
            $this->free_service->setupEditAttributes();
            $this->free_service->EditValue = $this->free_service->AdvancedSearch->SearchValue;
            $this->free_service->PlaceHolder = RemoveHtml($this->free_service->caption());

            // toner_life
            $this->toner_life->setupEditAttributes();
            $this->toner_life->EditValue = $this->toner_life->AdvancedSearch->SearchValue;
            $this->toner_life->PlaceHolder = RemoveHtml($this->toner_life->caption());

            // drum_life
            $this->drum_life->setupEditAttributes();
            $this->drum_life->EditValue = $this->drum_life->AdvancedSearch->SearchValue;
            $this->drum_life->PlaceHolder = RemoveHtml($this->drum_life->caption());

            // developer_life
            $this->developer_life->setupEditAttributes();
            $this->developer_life->EditValue = $this->developer_life->AdvancedSearch->SearchValue;
            $this->developer_life->PlaceHolder = RemoveHtml($this->developer_life->caption());

            // date_install
            $this->date_install->setupEditAttributes();
            $this->date_install->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->date_install->AdvancedSearch->SearchValue, $this->date_install->formatPattern()), $this->date_install->formatPattern()));
            $this->date_install->PlaceHolder = RemoveHtml($this->date_install->caption());

            // date_start
            $this->date_start->setupEditAttributes();
            $this->date_start->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->date_start->AdvancedSearch->SearchValue, $this->date_start->formatPattern()), $this->date_start->formatPattern()));
            $this->date_start->PlaceHolder = RemoveHtml($this->date_start->caption());

            // remark
            $this->remark->setupEditAttributes();
            if (!$this->remark->Raw) {
                $this->remark->AdvancedSearch->SearchValue = HtmlDecode($this->remark->AdvancedSearch->SearchValue);
            }
            $this->remark->EditValue = HtmlEncode($this->remark->AdvancedSearch->SearchValue);
            $this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // schedule_service_type
            $this->schedule_service_type->setupEditAttributes();
            $curVal = trim(strval($this->schedule_service_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->schedule_service_type->AdvancedSearch->ViewValue = $this->schedule_service_type->lookupCacheOption($curVal);
            } else {
                $this->schedule_service_type->AdvancedSearch->ViewValue = $this->schedule_service_type->Lookup !== null && is_array($this->schedule_service_type->lookupOptions()) && count($this->schedule_service_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->schedule_service_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->schedule_service_type->EditValue = array_values($this->schedule_service_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->schedule_service_type->AdvancedSearch->SearchValue, $this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->schedule_service_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->schedule_service_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->schedule_service_type->EditValue = $arwrk;
            }
            $this->schedule_service_type->PlaceHolder = RemoveHtml($this->schedule_service_type->caption());
            $this->schedule_service_type->setupEditAttributes();
            $curVal = trim(strval($this->schedule_service_type->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->schedule_service_type->AdvancedSearch->ViewValue2 = $this->schedule_service_type->lookupCacheOption($curVal);
            } else {
                $this->schedule_service_type->AdvancedSearch->ViewValue2 = $this->schedule_service_type->Lookup !== null && is_array($this->schedule_service_type->lookupOptions()) && count($this->schedule_service_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->schedule_service_type->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->schedule_service_type->EditValue2 = array_values($this->schedule_service_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->schedule_service_type->AdvancedSearch->SearchValue2, $this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->schedule_service_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->schedule_service_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->schedule_service_type->EditValue2 = $arwrk;
            }
            $this->schedule_service_type->PlaceHolder = RemoveHtml($this->schedule_service_type->caption());

            // schedule_service_interval_days
            $this->schedule_service_interval_days->setupEditAttributes(["step" => "1"]);
            $this->schedule_service_interval_days->EditValue = $this->schedule_service_interval_days->AdvancedSearch->SearchValue;
            $this->schedule_service_interval_days->PlaceHolder = RemoveHtml($this->schedule_service_interval_days->caption());

            // schedule_service_updated_till
            $this->schedule_service_updated_till->setupEditAttributes();
            $this->schedule_service_updated_till->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->schedule_service_updated_till->AdvancedSearch->SearchValue, $this->schedule_service_updated_till->formatPattern()), $this->schedule_service_updated_till->formatPattern()));
            $this->schedule_service_updated_till->PlaceHolder = RemoveHtml($this->schedule_service_updated_till->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // copy_average_1
            $this->copy_average_1->setupEditAttributes();
            $this->copy_average_1->EditValue = $this->copy_average_1->AdvancedSearch->SearchValue;
            $this->copy_average_1->PlaceHolder = RemoveHtml($this->copy_average_1->caption());

            // copy_average_2
            $this->copy_average_2->setupEditAttributes();
            $this->copy_average_2->EditValue = $this->copy_average_2->AdvancedSearch->SearchValue;
            $this->copy_average_2->PlaceHolder = RemoveHtml($this->copy_average_2->caption());

            // copy_average_3
            $this->copy_average_3->setupEditAttributes();
            $this->copy_average_3->EditValue = $this->copy_average_3->AdvancedSearch->SearchValue;
            $this->copy_average_3->PlaceHolder = RemoveHtml($this->copy_average_3->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->partner_id->AdvancedSearch->SearchValue)) {
            $this->partner_id->addErrorMessage($this->partner_id->getErrorMessage(false));
        }
        if (!CheckInteger($this->partner_id->AdvancedSearch->SearchValue2)) {
            $this->partner_id->addErrorMessage($this->partner_id->getErrorMessage(false));
        }
        if (!CheckDate($this->invoice_date->AdvancedSearch->SearchValue, $this->invoice_date->formatPattern())) {
            $this->invoice_date->addErrorMessage($this->invoice_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->first_counter->AdvancedSearch->SearchValue)) {
            $this->first_counter->addErrorMessage($this->first_counter->getErrorMessage(false));
        }
        if (!CheckDate($this->valid_till->AdvancedSearch->SearchValue, $this->valid_till->formatPattern())) {
            $this->valid_till->addErrorMessage($this->valid_till->getErrorMessage(false));
        }
        if (!CheckInteger($this->valid_till_counter->AdvancedSearch->SearchValue)) {
            $this->valid_till_counter->addErrorMessage($this->valid_till_counter->getErrorMessage(false));
        }
        if (!CheckInteger($this->free_service->AdvancedSearch->SearchValue)) {
            $this->free_service->addErrorMessage($this->free_service->getErrorMessage(false));
        }
        if (!CheckInteger($this->toner_life->AdvancedSearch->SearchValue)) {
            $this->toner_life->addErrorMessage($this->toner_life->getErrorMessage(false));
        }
        if (!CheckInteger($this->drum_life->AdvancedSearch->SearchValue)) {
            $this->drum_life->addErrorMessage($this->drum_life->getErrorMessage(false));
        }
        if (!CheckInteger($this->developer_life->AdvancedSearch->SearchValue)) {
            $this->developer_life->addErrorMessage($this->developer_life->getErrorMessage(false));
        }
        if (!CheckDate($this->date_install->AdvancedSearch->SearchValue, $this->date_install->formatPattern())) {
            $this->date_install->addErrorMessage($this->date_install->getErrorMessage(false));
        }
        if (!CheckDate($this->date_start->AdvancedSearch->SearchValue, $this->date_start->formatPattern())) {
            $this->date_start->addErrorMessage($this->date_start->getErrorMessage(false));
        }
        if (!CheckInteger($this->schedule_service_interval_days->AdvancedSearch->SearchValue)) {
            $this->schedule_service_interval_days->addErrorMessage($this->schedule_service_interval_days->getErrorMessage(false));
        }
        if (!CheckDate($this->schedule_service_updated_till->AdvancedSearch->SearchValue, $this->schedule_service_updated_till->formatPattern())) {
            $this->schedule_service_updated_till->addErrorMessage($this->schedule_service_updated_till->getErrorMessage(false));
        }
        if (!CheckInteger($this->copy_average_1->AdvancedSearch->SearchValue)) {
            $this->copy_average_1->addErrorMessage($this->copy_average_1->getErrorMessage(false));
        }
        if (!CheckInteger($this->copy_average_2->AdvancedSearch->SearchValue)) {
            $this->copy_average_2->addErrorMessage($this->copy_average_2->getErrorMessage(false));
        }
        if (!CheckInteger($this->copy_average_3->AdvancedSearch->SearchValue)) {
            $this->copy_average_3->addErrorMessage($this->copy_average_3->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->customer_grp->AdvancedSearch->load();
        $this->ref->AdvancedSearch->load();
        $this->partner_id->AdvancedSearch->load();
        $this->name_ref->AdvancedSearch->load();
        $this->city_name->AdvancedSearch->load();
        $this->area->AdvancedSearch->load();
        $this->billing_name->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->personal_ref->AdvancedSearch->load();
        $this->harward_code->AdvancedSearch->load();
        $this->serial_no->AdvancedSearch->load();
        $this->invoice_no->AdvancedSearch->load();
        $this->invoice_date->AdvancedSearch->load();
        $this->first_counter->AdvancedSearch->load();
        $this->guarantee->AdvancedSearch->load();
        $this->valid_till->AdvancedSearch->load();
        $this->valid_till_counter->AdvancedSearch->load();
        $this->free_service->AdvancedSearch->load();
        $this->toner_life->AdvancedSearch->load();
        $this->drum_life->AdvancedSearch->load();
        $this->developer_life->AdvancedSearch->load();
        $this->date_install->AdvancedSearch->load();
        $this->date_start->AdvancedSearch->load();
        $this->remark->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->schedule_service_type->AdvancedSearch->load();
        $this->schedule_service_interval_days->AdvancedSearch->load();
        $this->schedule_service_updated_till->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->copy_average_1->AdvancedSearch->load();
        $this->copy_average_2->AdvancedSearch->load();
        $this->copy_average_3->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("clienthardwaredatalist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_customer_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_area":
                    break;
                case "x_personal_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_guarantee":
                    break;
                case "x_status":
                    break;
                case "x_schedule_service_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'client_hardware_data');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
