<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ClientHardwareDataList extends ClientHardwareData
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ClientHardwareDataList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fclient_hardware_datalist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "clienthardwaredatalist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->customer_grp->Visible = false;
        $this->ref->setVisibility();
        $this->partner_id->setVisibility();
        $this->name_ref->setVisibility();
        $this->city_name->setVisibility();
        $this->area->setVisibility();
        $this->billing_name->Visible = false;
        $this->address->Visible = false;
        $this->personal_ref->Visible = false;
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->product->Visible = false;
        $this->rid->Visible = false;
        $this->rid_1->Visible = false;
        $this->harward_code->setVisibility();
        $this->serial_no->setVisibility();
        $this->invoice_no->Visible = false;
        $this->invoice_date->Visible = false;
        $this->first_counter->Visible = false;
        $this->guarantee->Visible = false;
        $this->valid_till->Visible = false;
        $this->valid_till_counter->Visible = false;
        $this->free_service->Visible = false;
        $this->toner_life->Visible = false;
        $this->drum_life->Visible = false;
        $this->developer_life->Visible = false;
        $this->date_install->setVisibility();
        $this->date_start->Visible = false;
        $this->remark->setVisibility();
        $this->status->Visible = false;
        $this->schedule_service_type->setVisibility();
        $this->schedule_service_interval_days->setVisibility();
        $this->schedule_service_updated_till->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->copy_average_1->setVisibility();
        $this->copy_average_2->setVisibility();
        $this->copy_average_3->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'client_hardware_data';
        $this->TableName = 'client_hardware_data';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (client_hardware_data)
        if (!isset($GLOBALS["client_hardware_data"]) || $GLOBALS["client_hardware_data"]::class == PROJECT_NAMESPACE . "client_hardware_data") {
            $GLOBALS["client_hardware_data"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "clienthardwaredataadd?" . Config("TABLE_SHOW_DETAIL") . "=";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "clienthardwaredatadelete";
        $this->MultiUpdateUrl = "clienthardwaredataupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'client_hardware_data');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "clienthardwaredataview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "20,50,100,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->customer_grp);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->personal_ref);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->guarantee);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->schedule_service_type);
        $this->setupLookupOptions($this->operator);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fclient_hardware_datagrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);

        // Export selected records
        if ($this->isExport()) {
            $this->CurrentFilter = $this->buildExportSelectedFilter();
        }
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }

            // Audit trail on search
            if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
                $searchParm = ServerVar("QUERY_STRING");
                $searchSql = $this->getSessionWhere();
                $this->writeAuditTrailOnSearch($searchParm, $searchSql);
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fclient_hardware_datasrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->customer_grp->AdvancedSearch->toJson(), ","); // Field customer_grp
        $filterList = Concat($filterList, $this->ref->AdvancedSearch->toJson(), ","); // Field ref
        $filterList = Concat($filterList, $this->partner_id->AdvancedSearch->toJson(), ","); // Field partner_id
        $filterList = Concat($filterList, $this->name_ref->AdvancedSearch->toJson(), ","); // Field name_ref
        $filterList = Concat($filterList, $this->city_name->AdvancedSearch->toJson(), ","); // Field city_name
        $filterList = Concat($filterList, $this->area->AdvancedSearch->toJson(), ","); // Field area
        $filterList = Concat($filterList, $this->billing_name->AdvancedSearch->toJson(), ","); // Field billing_name
        $filterList = Concat($filterList, $this->address->AdvancedSearch->toJson(), ","); // Field address
        $filterList = Concat($filterList, $this->personal_ref->AdvancedSearch->toJson(), ","); // Field personal_ref
        $filterList = Concat($filterList, $this->rid_1->AdvancedSearch->toJson(), ","); // Field rid_1
        $filterList = Concat($filterList, $this->harward_code->AdvancedSearch->toJson(), ","); // Field harward_code
        $filterList = Concat($filterList, $this->serial_no->AdvancedSearch->toJson(), ","); // Field serial_no
        $filterList = Concat($filterList, $this->invoice_no->AdvancedSearch->toJson(), ","); // Field invoice_no
        $filterList = Concat($filterList, $this->invoice_date->AdvancedSearch->toJson(), ","); // Field invoice_date
        $filterList = Concat($filterList, $this->first_counter->AdvancedSearch->toJson(), ","); // Field first_counter
        $filterList = Concat($filterList, $this->guarantee->AdvancedSearch->toJson(), ","); // Field guarantee
        $filterList = Concat($filterList, $this->valid_till->AdvancedSearch->toJson(), ","); // Field valid_till
        $filterList = Concat($filterList, $this->valid_till_counter->AdvancedSearch->toJson(), ","); // Field valid_till_counter
        $filterList = Concat($filterList, $this->free_service->AdvancedSearch->toJson(), ","); // Field free_service
        $filterList = Concat($filterList, $this->toner_life->AdvancedSearch->toJson(), ","); // Field toner_life
        $filterList = Concat($filterList, $this->drum_life->AdvancedSearch->toJson(), ","); // Field drum_life
        $filterList = Concat($filterList, $this->developer_life->AdvancedSearch->toJson(), ","); // Field developer_life
        $filterList = Concat($filterList, $this->date_install->AdvancedSearch->toJson(), ","); // Field date_install
        $filterList = Concat($filterList, $this->date_start->AdvancedSearch->toJson(), ","); // Field date_start
        $filterList = Concat($filterList, $this->remark->AdvancedSearch->toJson(), ","); // Field remark
        $filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
        $filterList = Concat($filterList, $this->schedule_service_type->AdvancedSearch->toJson(), ","); // Field schedule_service_type
        $filterList = Concat($filterList, $this->schedule_service_interval_days->AdvancedSearch->toJson(), ","); // Field schedule_service_interval_days
        $filterList = Concat($filterList, $this->schedule_service_updated_till->AdvancedSearch->toJson(), ","); // Field schedule_service_updated_till
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        $filterList = Concat($filterList, $this->copy_average_1->AdvancedSearch->toJson(), ","); // Field copy_average_1
        $filterList = Concat($filterList, $this->copy_average_2->AdvancedSearch->toJson(), ","); // Field copy_average_2
        $filterList = Concat($filterList, $this->copy_average_3->AdvancedSearch->toJson(), ","); // Field copy_average_3
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fclient_hardware_datasrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field customer_grp
        $this->customer_grp->AdvancedSearch->SearchValue = @$filter["x_customer_grp"];
        $this->customer_grp->AdvancedSearch->SearchOperator = @$filter["z_customer_grp"];
        $this->customer_grp->AdvancedSearch->SearchCondition = @$filter["v_customer_grp"];
        $this->customer_grp->AdvancedSearch->SearchValue2 = @$filter["y_customer_grp"];
        $this->customer_grp->AdvancedSearch->SearchOperator2 = @$filter["w_customer_grp"];
        $this->customer_grp->AdvancedSearch->save();

        // Field ref
        $this->ref->AdvancedSearch->SearchValue = @$filter["x_ref"];
        $this->ref->AdvancedSearch->SearchOperator = @$filter["z_ref"];
        $this->ref->AdvancedSearch->SearchCondition = @$filter["v_ref"];
        $this->ref->AdvancedSearch->SearchValue2 = @$filter["y_ref"];
        $this->ref->AdvancedSearch->SearchOperator2 = @$filter["w_ref"];
        $this->ref->AdvancedSearch->save();

        // Field partner_id
        $this->partner_id->AdvancedSearch->SearchValue = @$filter["x_partner_id"];
        $this->partner_id->AdvancedSearch->SearchOperator = @$filter["z_partner_id"];
        $this->partner_id->AdvancedSearch->SearchCondition = @$filter["v_partner_id"];
        $this->partner_id->AdvancedSearch->SearchValue2 = @$filter["y_partner_id"];
        $this->partner_id->AdvancedSearch->SearchOperator2 = @$filter["w_partner_id"];
        $this->partner_id->AdvancedSearch->save();

        // Field name_ref
        $this->name_ref->AdvancedSearch->SearchValue = @$filter["x_name_ref"];
        $this->name_ref->AdvancedSearch->SearchOperator = @$filter["z_name_ref"];
        $this->name_ref->AdvancedSearch->SearchCondition = @$filter["v_name_ref"];
        $this->name_ref->AdvancedSearch->SearchValue2 = @$filter["y_name_ref"];
        $this->name_ref->AdvancedSearch->SearchOperator2 = @$filter["w_name_ref"];
        $this->name_ref->AdvancedSearch->save();

        // Field city_name
        $this->city_name->AdvancedSearch->SearchValue = @$filter["x_city_name"];
        $this->city_name->AdvancedSearch->SearchOperator = @$filter["z_city_name"];
        $this->city_name->AdvancedSearch->SearchCondition = @$filter["v_city_name"];
        $this->city_name->AdvancedSearch->SearchValue2 = @$filter["y_city_name"];
        $this->city_name->AdvancedSearch->SearchOperator2 = @$filter["w_city_name"];
        $this->city_name->AdvancedSearch->save();

        // Field area
        $this->area->AdvancedSearch->SearchValue = @$filter["x_area"];
        $this->area->AdvancedSearch->SearchOperator = @$filter["z_area"];
        $this->area->AdvancedSearch->SearchCondition = @$filter["v_area"];
        $this->area->AdvancedSearch->SearchValue2 = @$filter["y_area"];
        $this->area->AdvancedSearch->SearchOperator2 = @$filter["w_area"];
        $this->area->AdvancedSearch->save();

        // Field billing_name
        $this->billing_name->AdvancedSearch->SearchValue = @$filter["x_billing_name"];
        $this->billing_name->AdvancedSearch->SearchOperator = @$filter["z_billing_name"];
        $this->billing_name->AdvancedSearch->SearchCondition = @$filter["v_billing_name"];
        $this->billing_name->AdvancedSearch->SearchValue2 = @$filter["y_billing_name"];
        $this->billing_name->AdvancedSearch->SearchOperator2 = @$filter["w_billing_name"];
        $this->billing_name->AdvancedSearch->save();

        // Field address
        $this->address->AdvancedSearch->SearchValue = @$filter["x_address"];
        $this->address->AdvancedSearch->SearchOperator = @$filter["z_address"];
        $this->address->AdvancedSearch->SearchCondition = @$filter["v_address"];
        $this->address->AdvancedSearch->SearchValue2 = @$filter["y_address"];
        $this->address->AdvancedSearch->SearchOperator2 = @$filter["w_address"];
        $this->address->AdvancedSearch->save();

        // Field personal_ref
        $this->personal_ref->AdvancedSearch->SearchValue = @$filter["x_personal_ref"];
        $this->personal_ref->AdvancedSearch->SearchOperator = @$filter["z_personal_ref"];
        $this->personal_ref->AdvancedSearch->SearchCondition = @$filter["v_personal_ref"];
        $this->personal_ref->AdvancedSearch->SearchValue2 = @$filter["y_personal_ref"];
        $this->personal_ref->AdvancedSearch->SearchOperator2 = @$filter["w_personal_ref"];
        $this->personal_ref->AdvancedSearch->save();

        // Field rid_1
        $this->rid_1->AdvancedSearch->SearchValue = @$filter["x_rid_1"];
        $this->rid_1->AdvancedSearch->SearchOperator = @$filter["z_rid_1"];
        $this->rid_1->AdvancedSearch->SearchCondition = @$filter["v_rid_1"];
        $this->rid_1->AdvancedSearch->SearchValue2 = @$filter["y_rid_1"];
        $this->rid_1->AdvancedSearch->SearchOperator2 = @$filter["w_rid_1"];
        $this->rid_1->AdvancedSearch->save();

        // Field harward_code
        $this->harward_code->AdvancedSearch->SearchValue = @$filter["x_harward_code"];
        $this->harward_code->AdvancedSearch->SearchOperator = @$filter["z_harward_code"];
        $this->harward_code->AdvancedSearch->SearchCondition = @$filter["v_harward_code"];
        $this->harward_code->AdvancedSearch->SearchValue2 = @$filter["y_harward_code"];
        $this->harward_code->AdvancedSearch->SearchOperator2 = @$filter["w_harward_code"];
        $this->harward_code->AdvancedSearch->save();

        // Field serial_no
        $this->serial_no->AdvancedSearch->SearchValue = @$filter["x_serial_no"];
        $this->serial_no->AdvancedSearch->SearchOperator = @$filter["z_serial_no"];
        $this->serial_no->AdvancedSearch->SearchCondition = @$filter["v_serial_no"];
        $this->serial_no->AdvancedSearch->SearchValue2 = @$filter["y_serial_no"];
        $this->serial_no->AdvancedSearch->SearchOperator2 = @$filter["w_serial_no"];
        $this->serial_no->AdvancedSearch->save();

        // Field invoice_no
        $this->invoice_no->AdvancedSearch->SearchValue = @$filter["x_invoice_no"];
        $this->invoice_no->AdvancedSearch->SearchOperator = @$filter["z_invoice_no"];
        $this->invoice_no->AdvancedSearch->SearchCondition = @$filter["v_invoice_no"];
        $this->invoice_no->AdvancedSearch->SearchValue2 = @$filter["y_invoice_no"];
        $this->invoice_no->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_no"];
        $this->invoice_no->AdvancedSearch->save();

        // Field invoice_date
        $this->invoice_date->AdvancedSearch->SearchValue = @$filter["x_invoice_date"];
        $this->invoice_date->AdvancedSearch->SearchOperator = @$filter["z_invoice_date"];
        $this->invoice_date->AdvancedSearch->SearchCondition = @$filter["v_invoice_date"];
        $this->invoice_date->AdvancedSearch->SearchValue2 = @$filter["y_invoice_date"];
        $this->invoice_date->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_date"];
        $this->invoice_date->AdvancedSearch->save();

        // Field first_counter
        $this->first_counter->AdvancedSearch->SearchValue = @$filter["x_first_counter"];
        $this->first_counter->AdvancedSearch->SearchOperator = @$filter["z_first_counter"];
        $this->first_counter->AdvancedSearch->SearchCondition = @$filter["v_first_counter"];
        $this->first_counter->AdvancedSearch->SearchValue2 = @$filter["y_first_counter"];
        $this->first_counter->AdvancedSearch->SearchOperator2 = @$filter["w_first_counter"];
        $this->first_counter->AdvancedSearch->save();

        // Field guarantee
        $this->guarantee->AdvancedSearch->SearchValue = @$filter["x_guarantee"];
        $this->guarantee->AdvancedSearch->SearchOperator = @$filter["z_guarantee"];
        $this->guarantee->AdvancedSearch->SearchCondition = @$filter["v_guarantee"];
        $this->guarantee->AdvancedSearch->SearchValue2 = @$filter["y_guarantee"];
        $this->guarantee->AdvancedSearch->SearchOperator2 = @$filter["w_guarantee"];
        $this->guarantee->AdvancedSearch->save();

        // Field valid_till
        $this->valid_till->AdvancedSearch->SearchValue = @$filter["x_valid_till"];
        $this->valid_till->AdvancedSearch->SearchOperator = @$filter["z_valid_till"];
        $this->valid_till->AdvancedSearch->SearchCondition = @$filter["v_valid_till"];
        $this->valid_till->AdvancedSearch->SearchValue2 = @$filter["y_valid_till"];
        $this->valid_till->AdvancedSearch->SearchOperator2 = @$filter["w_valid_till"];
        $this->valid_till->AdvancedSearch->save();

        // Field valid_till_counter
        $this->valid_till_counter->AdvancedSearch->SearchValue = @$filter["x_valid_till_counter"];
        $this->valid_till_counter->AdvancedSearch->SearchOperator = @$filter["z_valid_till_counter"];
        $this->valid_till_counter->AdvancedSearch->SearchCondition = @$filter["v_valid_till_counter"];
        $this->valid_till_counter->AdvancedSearch->SearchValue2 = @$filter["y_valid_till_counter"];
        $this->valid_till_counter->AdvancedSearch->SearchOperator2 = @$filter["w_valid_till_counter"];
        $this->valid_till_counter->AdvancedSearch->save();

        // Field free_service
        $this->free_service->AdvancedSearch->SearchValue = @$filter["x_free_service"];
        $this->free_service->AdvancedSearch->SearchOperator = @$filter["z_free_service"];
        $this->free_service->AdvancedSearch->SearchCondition = @$filter["v_free_service"];
        $this->free_service->AdvancedSearch->SearchValue2 = @$filter["y_free_service"];
        $this->free_service->AdvancedSearch->SearchOperator2 = @$filter["w_free_service"];
        $this->free_service->AdvancedSearch->save();

        // Field toner_life
        $this->toner_life->AdvancedSearch->SearchValue = @$filter["x_toner_life"];
        $this->toner_life->AdvancedSearch->SearchOperator = @$filter["z_toner_life"];
        $this->toner_life->AdvancedSearch->SearchCondition = @$filter["v_toner_life"];
        $this->toner_life->AdvancedSearch->SearchValue2 = @$filter["y_toner_life"];
        $this->toner_life->AdvancedSearch->SearchOperator2 = @$filter["w_toner_life"];
        $this->toner_life->AdvancedSearch->save();

        // Field drum_life
        $this->drum_life->AdvancedSearch->SearchValue = @$filter["x_drum_life"];
        $this->drum_life->AdvancedSearch->SearchOperator = @$filter["z_drum_life"];
        $this->drum_life->AdvancedSearch->SearchCondition = @$filter["v_drum_life"];
        $this->drum_life->AdvancedSearch->SearchValue2 = @$filter["y_drum_life"];
        $this->drum_life->AdvancedSearch->SearchOperator2 = @$filter["w_drum_life"];
        $this->drum_life->AdvancedSearch->save();

        // Field developer_life
        $this->developer_life->AdvancedSearch->SearchValue = @$filter["x_developer_life"];
        $this->developer_life->AdvancedSearch->SearchOperator = @$filter["z_developer_life"];
        $this->developer_life->AdvancedSearch->SearchCondition = @$filter["v_developer_life"];
        $this->developer_life->AdvancedSearch->SearchValue2 = @$filter["y_developer_life"];
        $this->developer_life->AdvancedSearch->SearchOperator2 = @$filter["w_developer_life"];
        $this->developer_life->AdvancedSearch->save();

        // Field date_install
        $this->date_install->AdvancedSearch->SearchValue = @$filter["x_date_install"];
        $this->date_install->AdvancedSearch->SearchOperator = @$filter["z_date_install"];
        $this->date_install->AdvancedSearch->SearchCondition = @$filter["v_date_install"];
        $this->date_install->AdvancedSearch->SearchValue2 = @$filter["y_date_install"];
        $this->date_install->AdvancedSearch->SearchOperator2 = @$filter["w_date_install"];
        $this->date_install->AdvancedSearch->save();

        // Field date_start
        $this->date_start->AdvancedSearch->SearchValue = @$filter["x_date_start"];
        $this->date_start->AdvancedSearch->SearchOperator = @$filter["z_date_start"];
        $this->date_start->AdvancedSearch->SearchCondition = @$filter["v_date_start"];
        $this->date_start->AdvancedSearch->SearchValue2 = @$filter["y_date_start"];
        $this->date_start->AdvancedSearch->SearchOperator2 = @$filter["w_date_start"];
        $this->date_start->AdvancedSearch->save();

        // Field remark
        $this->remark->AdvancedSearch->SearchValue = @$filter["x_remark"];
        $this->remark->AdvancedSearch->SearchOperator = @$filter["z_remark"];
        $this->remark->AdvancedSearch->SearchCondition = @$filter["v_remark"];
        $this->remark->AdvancedSearch->SearchValue2 = @$filter["y_remark"];
        $this->remark->AdvancedSearch->SearchOperator2 = @$filter["w_remark"];
        $this->remark->AdvancedSearch->save();

        // Field status
        $this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
        $this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
        $this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
        $this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
        $this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
        $this->status->AdvancedSearch->save();

        // Field schedule_service_type
        $this->schedule_service_type->AdvancedSearch->SearchValue = @$filter["x_schedule_service_type"];
        $this->schedule_service_type->AdvancedSearch->SearchOperator = @$filter["z_schedule_service_type"];
        $this->schedule_service_type->AdvancedSearch->SearchCondition = @$filter["v_schedule_service_type"];
        $this->schedule_service_type->AdvancedSearch->SearchValue2 = @$filter["y_schedule_service_type"];
        $this->schedule_service_type->AdvancedSearch->SearchOperator2 = @$filter["w_schedule_service_type"];
        $this->schedule_service_type->AdvancedSearch->save();

        // Field schedule_service_interval_days
        $this->schedule_service_interval_days->AdvancedSearch->SearchValue = @$filter["x_schedule_service_interval_days"];
        $this->schedule_service_interval_days->AdvancedSearch->SearchOperator = @$filter["z_schedule_service_interval_days"];
        $this->schedule_service_interval_days->AdvancedSearch->SearchCondition = @$filter["v_schedule_service_interval_days"];
        $this->schedule_service_interval_days->AdvancedSearch->SearchValue2 = @$filter["y_schedule_service_interval_days"];
        $this->schedule_service_interval_days->AdvancedSearch->SearchOperator2 = @$filter["w_schedule_service_interval_days"];
        $this->schedule_service_interval_days->AdvancedSearch->save();

        // Field schedule_service_updated_till
        $this->schedule_service_updated_till->AdvancedSearch->SearchValue = @$filter["x_schedule_service_updated_till"];
        $this->schedule_service_updated_till->AdvancedSearch->SearchOperator = @$filter["z_schedule_service_updated_till"];
        $this->schedule_service_updated_till->AdvancedSearch->SearchCondition = @$filter["v_schedule_service_updated_till"];
        $this->schedule_service_updated_till->AdvancedSearch->SearchValue2 = @$filter["y_schedule_service_updated_till"];
        $this->schedule_service_updated_till->AdvancedSearch->SearchOperator2 = @$filter["w_schedule_service_updated_till"];
        $this->schedule_service_updated_till->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();

        // Field copy_average_1
        $this->copy_average_1->AdvancedSearch->SearchValue = @$filter["x_copy_average_1"];
        $this->copy_average_1->AdvancedSearch->SearchOperator = @$filter["z_copy_average_1"];
        $this->copy_average_1->AdvancedSearch->SearchCondition = @$filter["v_copy_average_1"];
        $this->copy_average_1->AdvancedSearch->SearchValue2 = @$filter["y_copy_average_1"];
        $this->copy_average_1->AdvancedSearch->SearchOperator2 = @$filter["w_copy_average_1"];
        $this->copy_average_1->AdvancedSearch->save();

        // Field copy_average_2
        $this->copy_average_2->AdvancedSearch->SearchValue = @$filter["x_copy_average_2"];
        $this->copy_average_2->AdvancedSearch->SearchOperator = @$filter["z_copy_average_2"];
        $this->copy_average_2->AdvancedSearch->SearchCondition = @$filter["v_copy_average_2"];
        $this->copy_average_2->AdvancedSearch->SearchValue2 = @$filter["y_copy_average_2"];
        $this->copy_average_2->AdvancedSearch->SearchOperator2 = @$filter["w_copy_average_2"];
        $this->copy_average_2->AdvancedSearch->save();

        // Field copy_average_3
        $this->copy_average_3->AdvancedSearch->SearchValue = @$filter["x_copy_average_3"];
        $this->copy_average_3->AdvancedSearch->SearchOperator = @$filter["z_copy_average_3"];
        $this->copy_average_3->AdvancedSearch->SearchCondition = @$filter["v_copy_average_3"];
        $this->copy_average_3->AdvancedSearch->SearchValue2 = @$filter["y_copy_average_3"];
        $this->copy_average_3->AdvancedSearch->SearchOperator2 = @$filter["w_copy_average_3"];
        $this->copy_average_3->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->customer_grp, $default, true); // customer_grp
        $this->buildSearchSql($where, $this->ref, $default, false); // ref
        $this->buildSearchSql($where, $this->partner_id, $default, false); // partner_id
        $this->buildSearchSql($where, $this->name_ref, $default, false); // name_ref
        $this->buildSearchSql($where, $this->city_name, $default, false); // city_name
        $this->buildSearchSql($where, $this->area, $default, false); // area
        $this->buildSearchSql($where, $this->billing_name, $default, false); // billing_name
        $this->buildSearchSql($where, $this->address, $default, false); // address
        $this->buildSearchSql($where, $this->personal_ref, $default, true); // personal_ref
        $this->buildSearchSql($where, $this->rid_1, $default, false); // rid_1
        $this->buildSearchSql($where, $this->harward_code, $default, false); // harward_code
        $this->buildSearchSql($where, $this->serial_no, $default, false); // serial_no
        $this->buildSearchSql($where, $this->invoice_no, $default, false); // invoice_no
        $this->buildSearchSql($where, $this->invoice_date, $default, false); // invoice_date
        $this->buildSearchSql($where, $this->first_counter, $default, false); // first_counter
        $this->buildSearchSql($where, $this->guarantee, $default, false); // guarantee
        $this->buildSearchSql($where, $this->valid_till, $default, false); // valid_till
        $this->buildSearchSql($where, $this->valid_till_counter, $default, false); // valid_till_counter
        $this->buildSearchSql($where, $this->free_service, $default, false); // free_service
        $this->buildSearchSql($where, $this->toner_life, $default, false); // toner_life
        $this->buildSearchSql($where, $this->drum_life, $default, false); // drum_life
        $this->buildSearchSql($where, $this->developer_life, $default, false); // developer_life
        $this->buildSearchSql($where, $this->date_install, $default, false); // date_install
        $this->buildSearchSql($where, $this->date_start, $default, false); // date_start
        $this->buildSearchSql($where, $this->remark, $default, false); // remark
        $this->buildSearchSql($where, $this->status, $default, false); // status
        $this->buildSearchSql($where, $this->schedule_service_type, $default, false); // schedule_service_type
        $this->buildSearchSql($where, $this->schedule_service_interval_days, $default, false); // schedule_service_interval_days
        $this->buildSearchSql($where, $this->schedule_service_updated_till, $default, false); // schedule_service_updated_till
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime
        $this->buildSearchSql($where, $this->copy_average_1, $default, false); // copy_average_1
        $this->buildSearchSql($where, $this->copy_average_2, $default, false); // copy_average_2
        $this->buildSearchSql($where, $this->copy_average_3, $default, false); // copy_average_3

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->customer_grp->AdvancedSearch->save(); // customer_grp
            $this->ref->AdvancedSearch->save(); // ref
            $this->partner_id->AdvancedSearch->save(); // partner_id
            $this->name_ref->AdvancedSearch->save(); // name_ref
            $this->city_name->AdvancedSearch->save(); // city_name
            $this->area->AdvancedSearch->save(); // area
            $this->billing_name->AdvancedSearch->save(); // billing_name
            $this->address->AdvancedSearch->save(); // address
            $this->personal_ref->AdvancedSearch->save(); // personal_ref
            $this->rid_1->AdvancedSearch->save(); // rid_1
            $this->harward_code->AdvancedSearch->save(); // harward_code
            $this->serial_no->AdvancedSearch->save(); // serial_no
            $this->invoice_no->AdvancedSearch->save(); // invoice_no
            $this->invoice_date->AdvancedSearch->save(); // invoice_date
            $this->first_counter->AdvancedSearch->save(); // first_counter
            $this->guarantee->AdvancedSearch->save(); // guarantee
            $this->valid_till->AdvancedSearch->save(); // valid_till
            $this->valid_till_counter->AdvancedSearch->save(); // valid_till_counter
            $this->free_service->AdvancedSearch->save(); // free_service
            $this->toner_life->AdvancedSearch->save(); // toner_life
            $this->drum_life->AdvancedSearch->save(); // drum_life
            $this->developer_life->AdvancedSearch->save(); // developer_life
            $this->date_install->AdvancedSearch->save(); // date_install
            $this->date_start->AdvancedSearch->save(); // date_start
            $this->remark->AdvancedSearch->save(); // remark
            $this->status->AdvancedSearch->save(); // status
            $this->schedule_service_type->AdvancedSearch->save(); // schedule_service_type
            $this->schedule_service_interval_days->AdvancedSearch->save(); // schedule_service_interval_days
            $this->schedule_service_updated_till->AdvancedSearch->save(); // schedule_service_updated_till
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->copy_average_1->AdvancedSearch->save(); // copy_average_1
            $this->copy_average_2->AdvancedSearch->save(); // copy_average_2
            $this->copy_average_3->AdvancedSearch->save(); // copy_average_3

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->customer_grp->AdvancedSearch->save(); // customer_grp
            $this->ref->AdvancedSearch->save(); // ref
            $this->partner_id->AdvancedSearch->save(); // partner_id
            $this->name_ref->AdvancedSearch->save(); // name_ref
            $this->city_name->AdvancedSearch->save(); // city_name
            $this->area->AdvancedSearch->save(); // area
            $this->billing_name->AdvancedSearch->save(); // billing_name
            $this->address->AdvancedSearch->save(); // address
            $this->personal_ref->AdvancedSearch->save(); // personal_ref
            $this->rid_1->AdvancedSearch->save(); // rid_1
            $this->harward_code->AdvancedSearch->save(); // harward_code
            $this->serial_no->AdvancedSearch->save(); // serial_no
            $this->invoice_no->AdvancedSearch->save(); // invoice_no
            $this->invoice_date->AdvancedSearch->save(); // invoice_date
            $this->first_counter->AdvancedSearch->save(); // first_counter
            $this->guarantee->AdvancedSearch->save(); // guarantee
            $this->valid_till->AdvancedSearch->save(); // valid_till
            $this->valid_till_counter->AdvancedSearch->save(); // valid_till_counter
            $this->free_service->AdvancedSearch->save(); // free_service
            $this->toner_life->AdvancedSearch->save(); // toner_life
            $this->drum_life->AdvancedSearch->save(); // drum_life
            $this->developer_life->AdvancedSearch->save(); // developer_life
            $this->date_install->AdvancedSearch->save(); // date_install
            $this->date_start->AdvancedSearch->save(); // date_start
            $this->remark->AdvancedSearch->save(); // remark
            $this->status->AdvancedSearch->save(); // status
            $this->schedule_service_type->AdvancedSearch->save(); // schedule_service_type
            $this->schedule_service_interval_days->AdvancedSearch->save(); // schedule_service_interval_days
            $this->schedule_service_updated_till->AdvancedSearch->save(); // schedule_service_updated_till
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->copy_average_1->AdvancedSearch->save(); // copy_average_1
            $this->copy_average_2->AdvancedSearch->save(); // copy_average_2
            $this->copy_average_3->AdvancedSearch->save(); // copy_average_3
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ref
        $filter = $this->queryBuilderWhere("ref");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ref, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ref->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field partner_id
        $filter = $this->queryBuilderWhere("partner_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->partner_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->partner_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field name_ref
        $filter = $this->queryBuilderWhere("name_ref");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->name_ref, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->name_ref->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field city_name
        $filter = $this->queryBuilderWhere("city_name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->city_name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->city_name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field area
        $filter = $this->queryBuilderWhere("area");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->area, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->area->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field harward_code
        $filter = $this->queryBuilderWhere("harward_code");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->harward_code, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->harward_code->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field serial_no
        $filter = $this->queryBuilderWhere("serial_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->serial_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->serial_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field date_install
        $filter = $this->queryBuilderWhere("date_install");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->date_install, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->date_install->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field remark
        $filter = $this->queryBuilderWhere("remark");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->remark, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->remark->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field schedule_service_type
        $filter = $this->queryBuilderWhere("schedule_service_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->schedule_service_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->schedule_service_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field schedule_service_interval_days
        $filter = $this->queryBuilderWhere("schedule_service_interval_days");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->schedule_service_interval_days, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->schedule_service_interval_days->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field schedule_service_updated_till
        $filter = $this->queryBuilderWhere("schedule_service_updated_till");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->schedule_service_updated_till, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->schedule_service_updated_till->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field copy_average_1
        $filter = $this->queryBuilderWhere("copy_average_1");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->copy_average_1, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->copy_average_1->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field copy_average_2
        $filter = $this->queryBuilderWhere("copy_average_2");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->copy_average_2, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->copy_average_2->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field copy_average_3
        $filter = $this->queryBuilderWhere("copy_average_3");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->copy_average_3, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->copy_average_3->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->customer_grp;
        $searchFlds[] = &$this->ref;
        $searchFlds[] = &$this->partner_id;
        $searchFlds[] = &$this->name_ref;
        $searchFlds[] = &$this->city_name;
        $searchFlds[] = &$this->area;
        $searchFlds[] = &$this->address;
        $searchFlds[] = &$this->personal_ref;
        $searchFlds[] = &$this->s_grp;
        $searchFlds[] = &$this->harward_code;
        $searchFlds[] = &$this->serial_no;
        $searchFlds[] = &$this->invoice_no;
        $searchFlds[] = &$this->remark;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->customer_grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ref->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->partner_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->name_ref->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->city_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->area->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->billing_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->address->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->personal_ref->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->rid_1->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->harward_code->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->serial_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->invoice_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->invoice_date->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->first_counter->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->guarantee->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->valid_till->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->valid_till_counter->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->free_service->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->toner_life->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->drum_life->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->developer_life->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->date_install->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->date_start->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->remark->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->schedule_service_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->schedule_service_interval_days->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->schedule_service_updated_till->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->copy_average_1->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->copy_average_2->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->copy_average_3->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->customer_grp->AdvancedSearch->unsetSession();
        $this->ref->AdvancedSearch->unsetSession();
        $this->partner_id->AdvancedSearch->unsetSession();
        $this->name_ref->AdvancedSearch->unsetSession();
        $this->city_name->AdvancedSearch->unsetSession();
        $this->area->AdvancedSearch->unsetSession();
        $this->billing_name->AdvancedSearch->unsetSession();
        $this->address->AdvancedSearch->unsetSession();
        $this->personal_ref->AdvancedSearch->unsetSession();
        $this->rid_1->AdvancedSearch->unsetSession();
        $this->harward_code->AdvancedSearch->unsetSession();
        $this->serial_no->AdvancedSearch->unsetSession();
        $this->invoice_no->AdvancedSearch->unsetSession();
        $this->invoice_date->AdvancedSearch->unsetSession();
        $this->first_counter->AdvancedSearch->unsetSession();
        $this->guarantee->AdvancedSearch->unsetSession();
        $this->valid_till->AdvancedSearch->unsetSession();
        $this->valid_till_counter->AdvancedSearch->unsetSession();
        $this->free_service->AdvancedSearch->unsetSession();
        $this->toner_life->AdvancedSearch->unsetSession();
        $this->drum_life->AdvancedSearch->unsetSession();
        $this->developer_life->AdvancedSearch->unsetSession();
        $this->date_install->AdvancedSearch->unsetSession();
        $this->date_start->AdvancedSearch->unsetSession();
        $this->remark->AdvancedSearch->unsetSession();
        $this->status->AdvancedSearch->unsetSession();
        $this->schedule_service_type->AdvancedSearch->unsetSession();
        $this->schedule_service_interval_days->AdvancedSearch->unsetSession();
        $this->schedule_service_updated_till->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
        $this->copy_average_1->AdvancedSearch->unsetSession();
        $this->copy_average_2->AdvancedSearch->unsetSession();
        $this->copy_average_3->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->customer_grp->AdvancedSearch->load();
        $this->ref->AdvancedSearch->load();
        $this->partner_id->AdvancedSearch->load();
        $this->name_ref->AdvancedSearch->load();
        $this->city_name->AdvancedSearch->load();
        $this->area->AdvancedSearch->load();
        $this->billing_name->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->personal_ref->AdvancedSearch->load();
        $this->rid_1->AdvancedSearch->load();
        $this->harward_code->AdvancedSearch->load();
        $this->serial_no->AdvancedSearch->load();
        $this->invoice_no->AdvancedSearch->load();
        $this->invoice_date->AdvancedSearch->load();
        $this->first_counter->AdvancedSearch->load();
        $this->guarantee->AdvancedSearch->load();
        $this->valid_till->AdvancedSearch->load();
        $this->valid_till_counter->AdvancedSearch->load();
        $this->free_service->AdvancedSearch->load();
        $this->toner_life->AdvancedSearch->load();
        $this->drum_life->AdvancedSearch->load();
        $this->developer_life->AdvancedSearch->load();
        $this->date_install->AdvancedSearch->load();
        $this->date_start->AdvancedSearch->load();
        $this->remark->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->schedule_service_type->AdvancedSearch->load();
        $this->schedule_service_interval_days->AdvancedSearch->load();
        $this->schedule_service_updated_till->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->copy_average_1->AdvancedSearch->load();
        $this->copy_average_2->AdvancedSearch->load();
        $this->copy_average_3->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id); // id
            $this->updateSort($this->ref); // ref
            $this->updateSort($this->partner_id); // partner_id
            $this->updateSort($this->name_ref); // name_ref
            $this->updateSort($this->city_name); // city_name
            $this->updateSort($this->area); // area
            $this->updateSort($this->harward_code); // harward_code
            $this->updateSort($this->serial_no); // serial_no
            $this->updateSort($this->date_install); // date_install
            $this->updateSort($this->remark); // remark
            $this->updateSort($this->schedule_service_type); // schedule_service_type
            $this->updateSort($this->schedule_service_interval_days); // schedule_service_interval_days
            $this->updateSort($this->schedule_service_updated_till); // schedule_service_updated_till
            $this->updateSort($this->copy_average_1); // copy_average_1
            $this->updateSort($this->copy_average_2); // copy_average_2
            $this->updateSort($this->copy_average_3); // copy_average_3
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->customer_grp->setSort("");
                $this->ref->setSort("");
                $this->partner_id->setSort("");
                $this->name_ref->setSort("");
                $this->city_name->setSort("");
                $this->area->setSort("");
                $this->billing_name->setSort("");
                $this->address->setSort("");
                $this->personal_ref->setSort("");
                $this->grp->setSort("");
                $this->s_grp->setSort("");
                $this->product->setSort("");
                $this->rid->setSort("");
                $this->rid_1->setSort("");
                $this->harward_code->setSort("");
                $this->serial_no->setSort("");
                $this->invoice_no->setSort("");
                $this->invoice_date->setSort("");
                $this->first_counter->setSort("");
                $this->guarantee->setSort("");
                $this->valid_till->setSort("");
                $this->valid_till_counter->setSort("");
                $this->free_service->setSort("");
                $this->toner_life->setSort("");
                $this->drum_life->setSort("");
                $this->developer_life->setSort("");
                $this->date_install->setSort("");
                $this->date_start->setSort("");
                $this->remark->setSort("");
                $this->status->setSort("");
                $this->schedule_service_type->setSort("");
                $this->schedule_service_interval_days->setSort("");
                $this->schedule_service_updated_till->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->copy_average_1->setSort("");
                $this->copy_average_2->setSort("");
                $this->copy_average_3->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // "detail_service_schedule"
        $item = &$this->ListOptions->add("detail_service_schedule");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'service_schedule');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // Multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$this->ListOptions->add("details");
            $item->CssClass = "text-nowrap";
            $item->Visible = $this->ShowMultipleDetails && $this->ListOptions->detailVisible();
            $item->OnLeft = true;
            $item->ShowInButtonGroup = false;
            $this->ListOptions->hideDetailItems();
        }

        // Set up detail pages
        $pages = new SubPages();
        $pages->add("service_schedule");
        $this->DetailPages = $pages;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = true;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"client_hardware_data\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"client_hardware_data\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"client_hardware_data\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fclient_hardware_datalist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fclient_hardware_datalist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }
        $detailViewTblVar = "";
        $detailCopyTblVar = "";
        $detailEditTblVar = "";

        // "detail_service_schedule"
        $opt = $this->ListOptions["detail_service_schedule"];
        if ($Security->allowList(CurrentProjectID() . 'service_schedule')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("service_schedule", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("serviceschedulelist?" . Config("TABLE_SHOW_MASTER") . "=client_hardware_data&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("ServiceScheduleGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'client_hardware_data')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=service_schedule");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "service_schedule";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'client_hardware_data')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=service_schedule");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "service_schedule";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'client_hardware_data')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=service_schedule");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "service_schedule";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }
        if ($this->ShowMultipleDetails) {
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
            $links = "";
            if ($detailViewTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailViewLink", true)) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar)) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            }
            if ($detailEditTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailEditLink", true)) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar)) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            }
            if ($detailCopyTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailCopyLink", true)) . "\" href=\"" . HtmlEncode($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar)) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlEncode($Language->phrase("MultipleMasterDetails", true)) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
                $body .= "<ul class=\"dropdown-menu ew-dropdown-menu\">" . $links . "</ul>";
            }
            $body .= "</div>";
            // Multiple details
            $opt = $this->ListOptions["details"];
            $opt->Body = $body;
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;

        // Preview extension
        $links = "";
        $detailFilters = [];
        $masterKeys = []; // Reset
        $masterKeys["id"] = strval($this->id->DbValue);

        // Column "detail_service_schedule"
        if ($this->DetailPages?->getItem("service_schedule")?->Visible && $Security->allowList(CurrentProjectID() . 'service_schedule')) {
            $link = "";
            $option = $this->ListOptions["detail_service_schedule"];
            $detailTbl = Container("service_schedule");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "serviceschedulepreview?t=client_hardware_data&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"service_schedule\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'client_hardware_data')) {
                $label = $Language->tablePhrase("service_schedule", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"service_schedule\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("serviceschedulelist?" . Config("TABLE_SHOW_MASTER") . "=client_hardware_data");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("service_schedule", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . $title . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("ServiceScheduleGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'client_hardware_data')) {
                $caption = $Language->phrase("MasterDetailViewLink");
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=service_schedule"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'client_hardware_data')) {
                $caption = $Language->phrase("MasterDetailEditLink");
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=service_schedule"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'client_hardware_data')) {
                $caption = $Language->phrase("MasterDetailCopyLink");
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=service_schedule"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }

        // Add row attributes for expandable row
        if ($this->RowType == RowType::VIEW) {
            $this->RowAttrs["data-widget"] = "expandable-table";
            $this->RowAttrs["aria-expanded"] = "false";
        }

        // Column "preview"
        $option = $this->ListOptions["preview"];
        if (!$option) { // Add preview column
            $option = &$this->ListOptions->add("preview");
            $option->OnLeft = true;
            $checkboxPos = $this->ListOptions->itemPos("checkbox");
            $pos = $checkboxPos === false
                ? ($option->OnLeft ? 0 : -1)
                : ($option->OnLeft ? $checkboxPos + 1 : $checkboxPos);
            $option->moveTo($pos);
            $option->Visible = !($this->isExport() || $this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit());
            $option->ShowInDropDown = false;
            $option->ShowInButtonGroup = false;
        }
        if ($option) {
            $icon = "fa-solid fa-caret-right fa-fw"; // Right
            if (property_exists($this, "MultiColumnLayout") && $this->MultiColumnLayout == "table") {
                $option->CssStyle = "width: 1%;";
                if (!$option->OnLeft) {
                    $icon = preg_replace('/\\bright\\b/', "left", $icon);
                }
            }
            if (IsRTL()) { // Reverse
                if (preg_match('/\\bleft\\b/', $icon)) {
                    $icon = preg_replace('/\\bleft\\b/', "right", $icon);
                } elseif (preg_match('/\\bright\\b/', $icon)) {
                    $icon = preg_replace('/\\bright\\b/', "left", $icon);
                }
            }
            $option->Body = "<i role=\"button\" class=\"ew-preview-btn expandable-table-caret ew-icon " . $icon . "\"></i>" .
                "<div class=\"ew-preview d-none\">" . $links . "</div>";
            if ($option->Visible) {
                $option->Visible = $links != "";
            }
        }

        // Column "details" (Multiple details)
        $option = $this->ListOptions["details"];
        if ($option) {
            $option->Body .= "<div class=\"ew-preview d-none\">" . $links . "</div>";
            if ($option->Visible) {
                $option->Visible = $links != "";
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"client_hardware_data\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["detail"];
        $detailTableLink = "";
        $item = &$option->add("detailadd_service_schedule");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=service_schedule");
        $detailPage = Container("ServiceScheduleGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'client_hardware_data') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "service_schedule";
        }

        // Add multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$option->add("detailsadd");
            $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailTableLink);
            $caption = $Language->phrase("AddMasterDetailLink");
            $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
            $item->Visible = $detailTableLink != "" && $Security->canAdd();
            // Hide single master/detail items
            $ar = explode(",", $detailTableLink);
            $cnt = count($ar);
            for ($i = 0; $i < $cnt; $i++) {
                if ($item = $option["detailadd_" . $ar[$i]]) {
                    $item->Visible = false;
                }
            }
        }
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "ref");
            $this->createColumnOption($option, "partner_id");
            $this->createColumnOption($option, "name_ref");
            $this->createColumnOption($option, "city_name");
            $this->createColumnOption($option, "area");
            $this->createColumnOption($option, "harward_code");
            $this->createColumnOption($option, "serial_no");
            $this->createColumnOption($option, "date_install");
            $this->createColumnOption($option, "remark");
            $this->createColumnOption($option, "schedule_service_type");
            $this->createColumnOption($option, "schedule_service_interval_days");
            $this->createColumnOption($option, "schedule_service_updated_till");
            $this->createColumnOption($option, "copy_average_1");
            $this->createColumnOption($option, "copy_average_2");
            $this->createColumnOption($option, "copy_average_3");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fclient_hardware_datasrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fclient_hardware_datasrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fclient_hardware_datalist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_client_hardware_data", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_client_hardware_data",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // customer_grp
        if ($this->customer_grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->customer_grp->AdvancedSearch->SearchValue != "" || $this->customer_grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->customer_grp->AdvancedSearch->SearchValue)) {
            $this->customer_grp->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->customer_grp->AdvancedSearch->SearchValue);
        }
        if (is_array($this->customer_grp->AdvancedSearch->SearchValue2)) {
            $this->customer_grp->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->customer_grp->AdvancedSearch->SearchValue2);
        }

        // ref
        if ($this->ref->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ref->AdvancedSearch->SearchValue != "" || $this->ref->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // partner_id
        if ($this->partner_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->partner_id->AdvancedSearch->SearchValue != "" || $this->partner_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // name_ref
        if ($this->name_ref->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->name_ref->AdvancedSearch->SearchValue != "" || $this->name_ref->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // city_name
        if ($this->city_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->city_name->AdvancedSearch->SearchValue != "" || $this->city_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // area
        if ($this->area->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->area->AdvancedSearch->SearchValue != "" || $this->area->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // billing_name
        if ($this->billing_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->billing_name->AdvancedSearch->SearchValue != "" || $this->billing_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // address
        if ($this->address->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->address->AdvancedSearch->SearchValue != "" || $this->address->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // personal_ref
        if ($this->personal_ref->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->personal_ref->AdvancedSearch->SearchValue != "" || $this->personal_ref->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->personal_ref->AdvancedSearch->SearchValue)) {
            $this->personal_ref->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->personal_ref->AdvancedSearch->SearchValue);
        }
        if (is_array($this->personal_ref->AdvancedSearch->SearchValue2)) {
            $this->personal_ref->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->personal_ref->AdvancedSearch->SearchValue2);
        }

        // harward_code
        if ($this->harward_code->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->harward_code->AdvancedSearch->SearchValue != "" || $this->harward_code->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // serial_no
        if ($this->serial_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->serial_no->AdvancedSearch->SearchValue != "" || $this->serial_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // invoice_no
        if ($this->invoice_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->invoice_no->AdvancedSearch->SearchValue != "" || $this->invoice_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // invoice_date
        if ($this->invoice_date->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->invoice_date->AdvancedSearch->SearchValue != "" || $this->invoice_date->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // first_counter
        if ($this->first_counter->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->first_counter->AdvancedSearch->SearchValue != "" || $this->first_counter->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // guarantee
        if ($this->guarantee->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->guarantee->AdvancedSearch->SearchValue != "" || $this->guarantee->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // valid_till
        if ($this->valid_till->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->valid_till->AdvancedSearch->SearchValue != "" || $this->valid_till->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // valid_till_counter
        if ($this->valid_till_counter->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->valid_till_counter->AdvancedSearch->SearchValue != "" || $this->valid_till_counter->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // free_service
        if ($this->free_service->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->free_service->AdvancedSearch->SearchValue != "" || $this->free_service->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // toner_life
        if ($this->toner_life->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->toner_life->AdvancedSearch->SearchValue != "" || $this->toner_life->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // drum_life
        if ($this->drum_life->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->drum_life->AdvancedSearch->SearchValue != "" || $this->drum_life->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // developer_life
        if ($this->developer_life->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->developer_life->AdvancedSearch->SearchValue != "" || $this->developer_life->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // date_install
        if ($this->date_install->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->date_install->AdvancedSearch->SearchValue != "" || $this->date_install->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // date_start
        if ($this->date_start->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->date_start->AdvancedSearch->SearchValue != "" || $this->date_start->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // remark
        if ($this->remark->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->remark->AdvancedSearch->SearchValue != "" || $this->remark->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status->AdvancedSearch->SearchValue != "" || $this->status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // schedule_service_type
        if ($this->schedule_service_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->schedule_service_type->AdvancedSearch->SearchValue != "" || $this->schedule_service_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // schedule_service_interval_days
        if ($this->schedule_service_interval_days->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->schedule_service_interval_days->AdvancedSearch->SearchValue != "" || $this->schedule_service_interval_days->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // schedule_service_updated_till
        if ($this->schedule_service_updated_till->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->schedule_service_updated_till->AdvancedSearch->SearchValue != "" || $this->schedule_service_updated_till->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // copy_average_1
        if ($this->copy_average_1->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->copy_average_1->AdvancedSearch->SearchValue != "" || $this->copy_average_1->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // copy_average_2
        if ($this->copy_average_2->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->copy_average_2->AdvancedSearch->SearchValue != "" || $this->copy_average_2->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // copy_average_3
        if ($this->copy_average_3->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->copy_average_3->AdvancedSearch->SearchValue != "" || $this->copy_average_3->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->customer_grp->setDbValue($row['customer_grp']);
        $this->ref->setDbValue($row['ref']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->name_ref->setDbValue($row['name_ref']);
        $this->city_name->setDbValue($row['city_name']);
        $this->area->setDbValue($row['area']);
        $this->billing_name->setDbValue($row['billing_name']);
        $this->address->setDbValue($row['address']);
        $this->personal_ref->setDbValue($row['personal_ref']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->harward_code->setDbValue($row['harward_code']);
        $this->serial_no->setDbValue($row['serial_no']);
        $this->invoice_no->setDbValue($row['invoice_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->first_counter->setDbValue($row['first_counter']);
        $this->guarantee->setDbValue($row['guarantee']);
        $this->valid_till->setDbValue($row['valid_till']);
        $this->valid_till_counter->setDbValue($row['valid_till_counter']);
        $this->free_service->setDbValue($row['free_service']);
        $this->toner_life->setDbValue($row['toner_life']);
        $this->drum_life->setDbValue($row['drum_life']);
        $this->developer_life->setDbValue($row['developer_life']);
        $this->date_install->setDbValue($row['date_install']);
        $this->date_start->setDbValue($row['date_start']);
        $this->remark->setDbValue($row['remark']);
        $this->status->setDbValue($row['status']);
        $this->schedule_service_type->setDbValue($row['schedule_service_type']);
        $this->schedule_service_interval_days->setDbValue($row['schedule_service_interval_days']);
        $this->schedule_service_updated_till->setDbValue($row['schedule_service_updated_till']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->copy_average_1->setDbValue($row['copy_average_1']);
        $this->copy_average_2->setDbValue($row['copy_average_2']);
        $this->copy_average_3->setDbValue($row['copy_average_3']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['customer_grp'] = $this->customer_grp->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['name_ref'] = $this->name_ref->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['area'] = $this->area->DefaultValue;
        $row['billing_name'] = $this->billing_name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['personal_ref'] = $this->personal_ref->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['harward_code'] = $this->harward_code->DefaultValue;
        $row['serial_no'] = $this->serial_no->DefaultValue;
        $row['invoice_no'] = $this->invoice_no->DefaultValue;
        $row['invoice_date'] = $this->invoice_date->DefaultValue;
        $row['first_counter'] = $this->first_counter->DefaultValue;
        $row['guarantee'] = $this->guarantee->DefaultValue;
        $row['valid_till'] = $this->valid_till->DefaultValue;
        $row['valid_till_counter'] = $this->valid_till_counter->DefaultValue;
        $row['free_service'] = $this->free_service->DefaultValue;
        $row['toner_life'] = $this->toner_life->DefaultValue;
        $row['drum_life'] = $this->drum_life->DefaultValue;
        $row['developer_life'] = $this->developer_life->DefaultValue;
        $row['date_install'] = $this->date_install->DefaultValue;
        $row['date_start'] = $this->date_start->DefaultValue;
        $row['remark'] = $this->remark->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['schedule_service_type'] = $this->schedule_service_type->DefaultValue;
        $row['schedule_service_interval_days'] = $this->schedule_service_interval_days->DefaultValue;
        $row['schedule_service_updated_till'] = $this->schedule_service_updated_till->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['copy_average_1'] = $this->copy_average_1->DefaultValue;
        $row['copy_average_2'] = $this->copy_average_2->DefaultValue;
        $row['copy_average_3'] = $this->copy_average_3->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // customer_grp

        // ref

        // partner_id

        // name_ref

        // city_name

        // area

        // billing_name

        // address

        // personal_ref

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // product
        $this->product->CellCssStyle = "white-space: nowrap;";

        // rid
        $this->rid->CellCssStyle = "white-space: nowrap;";

        // rid_1
        $this->rid_1->CellCssStyle = "white-space: nowrap;";

        // harward_code

        // serial_no

        // invoice_no

        // invoice_date

        // first_counter

        // guarantee

        // valid_till

        // valid_till_counter

        // free_service

        // toner_life

        // drum_life

        // developer_life

        // date_install

        // date_start

        // remark

        // status

        // schedule_service_type

        // schedule_service_interval_days

        // schedule_service_updated_till

        // operator

        // datetime

        // copy_average_1

        // copy_average_2

        // copy_average_3

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // customer_grp
            $curVal = strval($this->customer_grp->CurrentValue);
            if ($curVal != "") {
                $this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
                if ($this->customer_grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->customer_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->customer_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->customer_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->customer_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->customer_grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->customer_grp->Lookup->renderViewRow($row);
                            $this->customer_grp->ViewValue->add($this->customer_grp->displayValue($arwrk));
                        }
                    } else {
                        $this->customer_grp->ViewValue = $this->customer_grp->CurrentValue;
                    }
                }
            } else {
                $this->customer_grp->ViewValue = null;
            }

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // name_ref
            $this->name_ref->ViewValue = $this->name_ref->CurrentValue;

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // area
            $this->area->ViewValue = $this->area->CurrentValue;

            // billing_name
            $this->billing_name->ViewValue = $this->billing_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // personal_ref
            $curVal = strval($this->personal_ref->CurrentValue);
            if ($curVal != "") {
                $this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
                if ($this->personal_ref->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->personal_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->personal_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->personal_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->personal_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->personal_ref->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->personal_ref->Lookup->renderViewRow($row);
                            $this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
                        }
                    } else {
                        $this->personal_ref->ViewValue = $this->personal_ref->CurrentValue;
                    }
                }
            } else {
                $this->personal_ref->ViewValue = null;
            }

            // harward_code
            $this->harward_code->ViewValue = $this->harward_code->CurrentValue;

            // serial_no
            $this->serial_no->ViewValue = $this->serial_no->CurrentValue;

            // invoice_no
            $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

            // first_counter
            $this->first_counter->ViewValue = $this->first_counter->CurrentValue;
            $this->first_counter->ViewValue = FormatNumber($this->first_counter->ViewValue, $this->first_counter->formatPattern());

            // guarantee
            if (strval($this->guarantee->CurrentValue) != "") {
                $this->guarantee->ViewValue = $this->guarantee->optionCaption($this->guarantee->CurrentValue);
            } else {
                $this->guarantee->ViewValue = null;
            }

            // valid_till
            $this->valid_till->ViewValue = $this->valid_till->CurrentValue;
            $this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, $this->valid_till->formatPattern());

            // valid_till_counter
            $this->valid_till_counter->ViewValue = $this->valid_till_counter->CurrentValue;
            $this->valid_till_counter->ViewValue = FormatNumber($this->valid_till_counter->ViewValue, $this->valid_till_counter->formatPattern());

            // free_service
            $this->free_service->ViewValue = $this->free_service->CurrentValue;
            $this->free_service->ViewValue = FormatNumber($this->free_service->ViewValue, $this->free_service->formatPattern());

            // toner_life
            $this->toner_life->ViewValue = $this->toner_life->CurrentValue;
            $this->toner_life->ViewValue = FormatNumber($this->toner_life->ViewValue, $this->toner_life->formatPattern());

            // drum_life
            $this->drum_life->ViewValue = $this->drum_life->CurrentValue;
            $this->drum_life->ViewValue = FormatNumber($this->drum_life->ViewValue, $this->drum_life->formatPattern());

            // developer_life
            $this->developer_life->ViewValue = $this->developer_life->CurrentValue;
            $this->developer_life->ViewValue = FormatNumber($this->developer_life->ViewValue, $this->developer_life->formatPattern());

            // date_install
            $this->date_install->ViewValue = $this->date_install->CurrentValue;
            $this->date_install->ViewValue = FormatDateTime($this->date_install->ViewValue, $this->date_install->formatPattern());

            // date_start
            $this->date_start->ViewValue = $this->date_start->CurrentValue;
            $this->date_start->ViewValue = FormatDateTime($this->date_start->ViewValue, $this->date_start->formatPattern());

            // remark
            $this->remark->ViewValue = $this->remark->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // schedule_service_type
            $curVal = strval($this->schedule_service_type->CurrentValue);
            if ($curVal != "") {
                $this->schedule_service_type->ViewValue = $this->schedule_service_type->lookupCacheOption($curVal);
                if ($this->schedule_service_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->schedule_service_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->schedule_service_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->schedule_service_type->Lookup->renderViewRow($rswrk[0]);
                        $this->schedule_service_type->ViewValue = $this->schedule_service_type->displayValue($arwrk);
                    } else {
                        $this->schedule_service_type->ViewValue = FormatNumber($this->schedule_service_type->CurrentValue, $this->schedule_service_type->formatPattern());
                    }
                }
            } else {
                $this->schedule_service_type->ViewValue = null;
            }

            // schedule_service_interval_days
            $this->schedule_service_interval_days->ViewValue = $this->schedule_service_interval_days->CurrentValue;
            $this->schedule_service_interval_days->ViewValue = FormatNumber($this->schedule_service_interval_days->ViewValue, $this->schedule_service_interval_days->formatPattern());

            // schedule_service_updated_till
            $this->schedule_service_updated_till->ViewValue = $this->schedule_service_updated_till->CurrentValue;
            $this->schedule_service_updated_till->ViewValue = FormatDateTime($this->schedule_service_updated_till->ViewValue, $this->schedule_service_updated_till->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // copy_average_1
            $this->copy_average_1->ViewValue = $this->copy_average_1->CurrentValue;
            $this->copy_average_1->ViewValue = FormatNumber($this->copy_average_1->ViewValue, $this->copy_average_1->formatPattern());

            // copy_average_2
            $this->copy_average_2->ViewValue = $this->copy_average_2->CurrentValue;
            $this->copy_average_2->ViewValue = FormatNumber($this->copy_average_2->ViewValue, $this->copy_average_2->formatPattern());

            // copy_average_3
            $this->copy_average_3->ViewValue = $this->copy_average_3->CurrentValue;
            $this->copy_average_3->ViewValue = FormatNumber($this->copy_average_3->ViewValue, $this->copy_average_3->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // ref
            $this->ref->HrefValue = "";
            $this->ref->TooltipValue = "";
            if (!$this->isExport()) {
                $this->ref->ViewValue = $this->highlightValue($this->ref);
            }

            // partner_id
            $this->partner_id->HrefValue = "";
            $this->partner_id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->partner_id->ViewValue = $this->highlightValue($this->partner_id);
            }

            // name_ref
            $this->name_ref->HrefValue = "";
            $this->name_ref->TooltipValue = "";
            if (!$this->isExport()) {
                $this->name_ref->ViewValue = $this->highlightValue($this->name_ref);
            }

            // city_name
            $this->city_name->HrefValue = "";
            $this->city_name->TooltipValue = "";
            if (!$this->isExport()) {
                $this->city_name->ViewValue = $this->highlightValue($this->city_name);
            }

            // area
            $this->area->HrefValue = "";
            $this->area->TooltipValue = "";
            if (!$this->isExport()) {
                $this->area->ViewValue = $this->highlightValue($this->area);
            }

            // harward_code
            $this->harward_code->HrefValue = "";
            $this->harward_code->TooltipValue = "";
            if (!$this->isExport()) {
                $this->harward_code->ViewValue = $this->highlightValue($this->harward_code);
            }

            // serial_no
            $this->serial_no->HrefValue = "";
            $this->serial_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->serial_no->ViewValue = $this->highlightValue($this->serial_no);
            }

            // date_install
            $this->date_install->HrefValue = "";
            $this->date_install->TooltipValue = "";
            if (!$this->isExport()) {
                $this->date_install->ViewValue = $this->highlightValue($this->date_install);
            }

            // remark
            $this->remark->HrefValue = "";
            $this->remark->TooltipValue = "";
            if (!$this->isExport()) {
                $this->remark->ViewValue = $this->highlightValue($this->remark);
            }

            // schedule_service_type
            $this->schedule_service_type->HrefValue = "";
            $this->schedule_service_type->TooltipValue = "";

            // schedule_service_interval_days
            $this->schedule_service_interval_days->HrefValue = "";
            $this->schedule_service_interval_days->TooltipValue = "";

            // schedule_service_updated_till
            $this->schedule_service_updated_till->HrefValue = "";
            $this->schedule_service_updated_till->TooltipValue = "";
            if (!$this->isExport()) {
                $this->schedule_service_updated_till->ViewValue = $this->highlightValue($this->schedule_service_updated_till);
            }

            // copy_average_1
            $this->copy_average_1->HrefValue = "";
            $this->copy_average_1->TooltipValue = "";

            // copy_average_2
            $this->copy_average_2->HrefValue = "";
            $this->copy_average_2->TooltipValue = "";

            // copy_average_3
            $this->copy_average_3->HrefValue = "";
            $this->copy_average_3->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // ref
            $this->ref->setupEditAttributes();
            if (!$this->ref->Raw) {
                $this->ref->AdvancedSearch->SearchValue = HtmlDecode($this->ref->AdvancedSearch->SearchValue);
            }
            $this->ref->EditValue = HtmlEncode($this->ref->AdvancedSearch->SearchValue);
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->AdvancedSearch->SearchValue;
            $curVal = strval($this->partner_id->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->partner_id->EditValue = null;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue2 = $this->partner_id->AdvancedSearch->SearchValue2;
            $curVal = strval($this->partner_id->AdvancedSearch->SearchValue2);
            if ($curVal != "") {
                $this->partner_id->EditValue2 = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue2 === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue2 = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue2 = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue2);
                    }
                }
            } else {
                $this->partner_id->EditValue2 = null;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

            // name_ref
            $this->name_ref->setupEditAttributes();
            if (!$this->name_ref->Raw) {
                $this->name_ref->AdvancedSearch->SearchValue = HtmlDecode($this->name_ref->AdvancedSearch->SearchValue);
            }
            $this->name_ref->EditValue = HtmlEncode($this->name_ref->AdvancedSearch->SearchValue);
            $this->name_ref->PlaceHolder = RemoveHtml($this->name_ref->caption());

            // city_name
            $this->city_name->setupEditAttributes();
            if (!$this->city_name->Raw) {
                $this->city_name->AdvancedSearch->SearchValue = HtmlDecode($this->city_name->AdvancedSearch->SearchValue);
            }
            $this->city_name->EditValue = HtmlEncode($this->city_name->AdvancedSearch->SearchValue);
            $this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

            // area
            $this->area->setupEditAttributes();
            if (!$this->area->Raw) {
                $this->area->AdvancedSearch->SearchValue = HtmlDecode($this->area->AdvancedSearch->SearchValue);
            }
            $this->area->EditValue = HtmlEncode($this->area->AdvancedSearch->SearchValue);
            $this->area->PlaceHolder = RemoveHtml($this->area->caption());

            // harward_code
            $this->harward_code->setupEditAttributes();
            if (!$this->harward_code->Raw) {
                $this->harward_code->AdvancedSearch->SearchValue = HtmlDecode($this->harward_code->AdvancedSearch->SearchValue);
            }
            $this->harward_code->EditValue = HtmlEncode($this->harward_code->AdvancedSearch->SearchValue);
            $this->harward_code->PlaceHolder = RemoveHtml($this->harward_code->caption());

            // serial_no
            $this->serial_no->setupEditAttributes();
            if (!$this->serial_no->Raw) {
                $this->serial_no->AdvancedSearch->SearchValue = HtmlDecode($this->serial_no->AdvancedSearch->SearchValue);
            }
            $this->serial_no->EditValue = HtmlEncode($this->serial_no->AdvancedSearch->SearchValue);
            $this->serial_no->PlaceHolder = RemoveHtml($this->serial_no->caption());

            // date_install
            $this->date_install->setupEditAttributes();
            $this->date_install->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->date_install->AdvancedSearch->SearchValue, $this->date_install->formatPattern()), $this->date_install->formatPattern()));
            $this->date_install->PlaceHolder = RemoveHtml($this->date_install->caption());

            // remark
            $this->remark->setupEditAttributes();
            if (!$this->remark->Raw) {
                $this->remark->AdvancedSearch->SearchValue = HtmlDecode($this->remark->AdvancedSearch->SearchValue);
            }
            $this->remark->EditValue = HtmlEncode($this->remark->AdvancedSearch->SearchValue);
            $this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

            // schedule_service_type
            $this->schedule_service_type->setupEditAttributes();
            $this->schedule_service_type->PlaceHolder = RemoveHtml($this->schedule_service_type->caption());
            $this->schedule_service_type->setupEditAttributes();
            $this->schedule_service_type->PlaceHolder = RemoveHtml($this->schedule_service_type->caption());

            // schedule_service_interval_days
            $this->schedule_service_interval_days->setupEditAttributes(["step" => "1"]);
            $this->schedule_service_interval_days->EditValue = $this->schedule_service_interval_days->AdvancedSearch->SearchValue;
            $this->schedule_service_interval_days->PlaceHolder = RemoveHtml($this->schedule_service_interval_days->caption());

            // schedule_service_updated_till
            $this->schedule_service_updated_till->setupEditAttributes();
            $this->schedule_service_updated_till->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->schedule_service_updated_till->AdvancedSearch->SearchValue, $this->schedule_service_updated_till->formatPattern()), $this->schedule_service_updated_till->formatPattern()));
            $this->schedule_service_updated_till->PlaceHolder = RemoveHtml($this->schedule_service_updated_till->caption());

            // copy_average_1
            $this->copy_average_1->setupEditAttributes();
            $this->copy_average_1->EditValue = $this->copy_average_1->AdvancedSearch->SearchValue;
            $this->copy_average_1->PlaceHolder = RemoveHtml($this->copy_average_1->caption());

            // copy_average_2
            $this->copy_average_2->setupEditAttributes();
            $this->copy_average_2->EditValue = $this->copy_average_2->AdvancedSearch->SearchValue;
            $this->copy_average_2->PlaceHolder = RemoveHtml($this->copy_average_2->caption());

            // copy_average_3
            $this->copy_average_3->setupEditAttributes();
            $this->copy_average_3->EditValue = $this->copy_average_3->AdvancedSearch->SearchValue;
            $this->copy_average_3->PlaceHolder = RemoveHtml($this->copy_average_3->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->partner_id->AdvancedSearch->SearchValue)) {
            $this->partner_id->addErrorMessage($this->partner_id->getErrorMessage(false));
        }
        if (!CheckInteger($this->partner_id->AdvancedSearch->SearchValue2)) {
            $this->partner_id->addErrorMessage($this->partner_id->getErrorMessage(false));
        }
        if (!CheckDate($this->schedule_service_updated_till->AdvancedSearch->SearchValue, $this->schedule_service_updated_till->formatPattern())) {
            $this->schedule_service_updated_till->addErrorMessage($this->schedule_service_updated_till->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->customer_grp->AdvancedSearch->load();
        $this->ref->AdvancedSearch->load();
        $this->partner_id->AdvancedSearch->load();
        $this->name_ref->AdvancedSearch->load();
        $this->city_name->AdvancedSearch->load();
        $this->area->AdvancedSearch->load();
        $this->billing_name->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->personal_ref->AdvancedSearch->load();
        $this->harward_code->AdvancedSearch->load();
        $this->serial_no->AdvancedSearch->load();
        $this->invoice_no->AdvancedSearch->load();
        $this->invoice_date->AdvancedSearch->load();
        $this->first_counter->AdvancedSearch->load();
        $this->guarantee->AdvancedSearch->load();
        $this->valid_till->AdvancedSearch->load();
        $this->valid_till_counter->AdvancedSearch->load();
        $this->free_service->AdvancedSearch->load();
        $this->toner_life->AdvancedSearch->load();
        $this->drum_life->AdvancedSearch->load();
        $this->developer_life->AdvancedSearch->load();
        $this->date_install->AdvancedSearch->load();
        $this->date_start->AdvancedSearch->load();
        $this->remark->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->schedule_service_type->AdvancedSearch->load();
        $this->schedule_service_interval_days->AdvancedSearch->load();
        $this->schedule_service_updated_till->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->copy_average_1->AdvancedSearch->load();
        $this->copy_average_2->AdvancedSearch->load();
        $this->copy_average_3->AdvancedSearch->load();
    }

    // Build export filter for selected records
    protected function buildExportSelectedFilter()
    {
        global $Language;
        $wrkFilter = "";
        if ($this->isExport()) {
            $wrkFilter = $this->getFilterFromRecordKeys();
        }
        return $wrkFilter;
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fclient_hardware_datalist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fclient_hardware_datalist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fclient_hardware_datalist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fclient_hardware_datalist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fclient_hardware_datalist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fclient_hardware_datalist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            }
        } elseif (SameText($type, "html")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" form=\"fclient_hardware_datalist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"html\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToHtml") . "</button>";
        } elseif (SameText($type, "xml")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" form=\"fclient_hardware_datalist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"xml\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToXml") . "</button>";
        } elseif (SameText($type, "csv")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" form=\"fclient_hardware_datalist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"csv\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToCsv") . "</button>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fclient_hardware_datalist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="true"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" form=\"fclient_hardware_datalist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"print\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("PrinterFriendly") . "</button>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fclient_hardware_datasrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"client_hardware_data\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"clienthardwaredatasearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"clienthardwaredatasearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fclient_hardware_datasrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_customer_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_area":
                    break;
                case "x_personal_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_guarantee":
                    break;
                case "x_status":
                    break;
                case "x_schedule_service_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'client_hardware_data');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
