<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ClientHardwareDataDelete extends ClientHardwareData
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ClientHardwareDataDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "clienthardwaredatadelete";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->customer_grp->Visible = false;
        $this->ref->setVisibility();
        $this->partner_id->setVisibility();
        $this->name_ref->setVisibility();
        $this->city_name->setVisibility();
        $this->area->setVisibility();
        $this->billing_name->Visible = false;
        $this->address->Visible = false;
        $this->personal_ref->Visible = false;
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->product->Visible = false;
        $this->rid->Visible = false;
        $this->rid_1->Visible = false;
        $this->harward_code->setVisibility();
        $this->serial_no->setVisibility();
        $this->invoice_no->Visible = false;
        $this->invoice_date->Visible = false;
        $this->first_counter->Visible = false;
        $this->guarantee->Visible = false;
        $this->valid_till->Visible = false;
        $this->valid_till_counter->Visible = false;
        $this->free_service->Visible = false;
        $this->toner_life->Visible = false;
        $this->drum_life->Visible = false;
        $this->developer_life->Visible = false;
        $this->date_install->setVisibility();
        $this->date_start->Visible = false;
        $this->remark->setVisibility();
        $this->status->Visible = false;
        $this->schedule_service_type->setVisibility();
        $this->schedule_service_interval_days->setVisibility();
        $this->schedule_service_updated_till->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->copy_average_1->setVisibility();
        $this->copy_average_2->setVisibility();
        $this->copy_average_3->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'client_hardware_data';
        $this->TableName = 'client_hardware_data';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (client_hardware_data)
        if (!isset($GLOBALS["client_hardware_data"]) || $GLOBALS["client_hardware_data"]::class == PROJECT_NAMESPACE . "client_hardware_data") {
            $GLOBALS["client_hardware_data"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'client_hardware_data');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->customer_grp);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->personal_ref);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->guarantee);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->schedule_service_type);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("clienthardwaredatalist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("clienthardwaredatalist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->customer_grp->setDbValue($row['customer_grp']);
        $this->ref->setDbValue($row['ref']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->name_ref->setDbValue($row['name_ref']);
        $this->city_name->setDbValue($row['city_name']);
        $this->area->setDbValue($row['area']);
        $this->billing_name->setDbValue($row['billing_name']);
        $this->address->setDbValue($row['address']);
        $this->personal_ref->setDbValue($row['personal_ref']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->harward_code->setDbValue($row['harward_code']);
        $this->serial_no->setDbValue($row['serial_no']);
        $this->invoice_no->setDbValue($row['invoice_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->first_counter->setDbValue($row['first_counter']);
        $this->guarantee->setDbValue($row['guarantee']);
        $this->valid_till->setDbValue($row['valid_till']);
        $this->valid_till_counter->setDbValue($row['valid_till_counter']);
        $this->free_service->setDbValue($row['free_service']);
        $this->toner_life->setDbValue($row['toner_life']);
        $this->drum_life->setDbValue($row['drum_life']);
        $this->developer_life->setDbValue($row['developer_life']);
        $this->date_install->setDbValue($row['date_install']);
        $this->date_start->setDbValue($row['date_start']);
        $this->remark->setDbValue($row['remark']);
        $this->status->setDbValue($row['status']);
        $this->schedule_service_type->setDbValue($row['schedule_service_type']);
        $this->schedule_service_interval_days->setDbValue($row['schedule_service_interval_days']);
        $this->schedule_service_updated_till->setDbValue($row['schedule_service_updated_till']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->copy_average_1->setDbValue($row['copy_average_1']);
        $this->copy_average_2->setDbValue($row['copy_average_2']);
        $this->copy_average_3->setDbValue($row['copy_average_3']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['customer_grp'] = $this->customer_grp->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['name_ref'] = $this->name_ref->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['area'] = $this->area->DefaultValue;
        $row['billing_name'] = $this->billing_name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['personal_ref'] = $this->personal_ref->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['harward_code'] = $this->harward_code->DefaultValue;
        $row['serial_no'] = $this->serial_no->DefaultValue;
        $row['invoice_no'] = $this->invoice_no->DefaultValue;
        $row['invoice_date'] = $this->invoice_date->DefaultValue;
        $row['first_counter'] = $this->first_counter->DefaultValue;
        $row['guarantee'] = $this->guarantee->DefaultValue;
        $row['valid_till'] = $this->valid_till->DefaultValue;
        $row['valid_till_counter'] = $this->valid_till_counter->DefaultValue;
        $row['free_service'] = $this->free_service->DefaultValue;
        $row['toner_life'] = $this->toner_life->DefaultValue;
        $row['drum_life'] = $this->drum_life->DefaultValue;
        $row['developer_life'] = $this->developer_life->DefaultValue;
        $row['date_install'] = $this->date_install->DefaultValue;
        $row['date_start'] = $this->date_start->DefaultValue;
        $row['remark'] = $this->remark->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['schedule_service_type'] = $this->schedule_service_type->DefaultValue;
        $row['schedule_service_interval_days'] = $this->schedule_service_interval_days->DefaultValue;
        $row['schedule_service_updated_till'] = $this->schedule_service_updated_till->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['copy_average_1'] = $this->copy_average_1->DefaultValue;
        $row['copy_average_2'] = $this->copy_average_2->DefaultValue;
        $row['copy_average_3'] = $this->copy_average_3->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // customer_grp

        // ref

        // partner_id

        // name_ref

        // city_name

        // area

        // billing_name

        // address

        // personal_ref

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // product
        $this->product->CellCssStyle = "white-space: nowrap;";

        // rid
        $this->rid->CellCssStyle = "white-space: nowrap;";

        // rid_1
        $this->rid_1->CellCssStyle = "white-space: nowrap;";

        // harward_code

        // serial_no

        // invoice_no

        // invoice_date

        // first_counter

        // guarantee

        // valid_till

        // valid_till_counter

        // free_service

        // toner_life

        // drum_life

        // developer_life

        // date_install

        // date_start

        // remark

        // status

        // schedule_service_type

        // schedule_service_interval_days

        // schedule_service_updated_till

        // operator

        // datetime

        // copy_average_1

        // copy_average_2

        // copy_average_3

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // customer_grp
            $curVal = strval($this->customer_grp->CurrentValue);
            if ($curVal != "") {
                $this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
                if ($this->customer_grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->customer_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->customer_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->customer_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->customer_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->customer_grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->customer_grp->Lookup->renderViewRow($row);
                            $this->customer_grp->ViewValue->add($this->customer_grp->displayValue($arwrk));
                        }
                    } else {
                        $this->customer_grp->ViewValue = $this->customer_grp->CurrentValue;
                    }
                }
            } else {
                $this->customer_grp->ViewValue = null;
            }

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // name_ref
            $this->name_ref->ViewValue = $this->name_ref->CurrentValue;

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // area
            $this->area->ViewValue = $this->area->CurrentValue;

            // billing_name
            $this->billing_name->ViewValue = $this->billing_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // personal_ref
            $curVal = strval($this->personal_ref->CurrentValue);
            if ($curVal != "") {
                $this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
                if ($this->personal_ref->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->personal_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->personal_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->personal_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->personal_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->personal_ref->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->personal_ref->Lookup->renderViewRow($row);
                            $this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
                        }
                    } else {
                        $this->personal_ref->ViewValue = $this->personal_ref->CurrentValue;
                    }
                }
            } else {
                $this->personal_ref->ViewValue = null;
            }

            // harward_code
            $this->harward_code->ViewValue = $this->harward_code->CurrentValue;

            // serial_no
            $this->serial_no->ViewValue = $this->serial_no->CurrentValue;

            // invoice_no
            $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

            // first_counter
            $this->first_counter->ViewValue = $this->first_counter->CurrentValue;
            $this->first_counter->ViewValue = FormatNumber($this->first_counter->ViewValue, $this->first_counter->formatPattern());

            // guarantee
            if (strval($this->guarantee->CurrentValue) != "") {
                $this->guarantee->ViewValue = $this->guarantee->optionCaption($this->guarantee->CurrentValue);
            } else {
                $this->guarantee->ViewValue = null;
            }

            // valid_till
            $this->valid_till->ViewValue = $this->valid_till->CurrentValue;
            $this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, $this->valid_till->formatPattern());

            // valid_till_counter
            $this->valid_till_counter->ViewValue = $this->valid_till_counter->CurrentValue;
            $this->valid_till_counter->ViewValue = FormatNumber($this->valid_till_counter->ViewValue, $this->valid_till_counter->formatPattern());

            // free_service
            $this->free_service->ViewValue = $this->free_service->CurrentValue;
            $this->free_service->ViewValue = FormatNumber($this->free_service->ViewValue, $this->free_service->formatPattern());

            // toner_life
            $this->toner_life->ViewValue = $this->toner_life->CurrentValue;
            $this->toner_life->ViewValue = FormatNumber($this->toner_life->ViewValue, $this->toner_life->formatPattern());

            // drum_life
            $this->drum_life->ViewValue = $this->drum_life->CurrentValue;
            $this->drum_life->ViewValue = FormatNumber($this->drum_life->ViewValue, $this->drum_life->formatPattern());

            // developer_life
            $this->developer_life->ViewValue = $this->developer_life->CurrentValue;
            $this->developer_life->ViewValue = FormatNumber($this->developer_life->ViewValue, $this->developer_life->formatPattern());

            // date_install
            $this->date_install->ViewValue = $this->date_install->CurrentValue;
            $this->date_install->ViewValue = FormatDateTime($this->date_install->ViewValue, $this->date_install->formatPattern());

            // date_start
            $this->date_start->ViewValue = $this->date_start->CurrentValue;
            $this->date_start->ViewValue = FormatDateTime($this->date_start->ViewValue, $this->date_start->formatPattern());

            // remark
            $this->remark->ViewValue = $this->remark->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // schedule_service_type
            $curVal = strval($this->schedule_service_type->CurrentValue);
            if ($curVal != "") {
                $this->schedule_service_type->ViewValue = $this->schedule_service_type->lookupCacheOption($curVal);
                if ($this->schedule_service_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->schedule_service_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->schedule_service_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->schedule_service_type->Lookup->renderViewRow($rswrk[0]);
                        $this->schedule_service_type->ViewValue = $this->schedule_service_type->displayValue($arwrk);
                    } else {
                        $this->schedule_service_type->ViewValue = FormatNumber($this->schedule_service_type->CurrentValue, $this->schedule_service_type->formatPattern());
                    }
                }
            } else {
                $this->schedule_service_type->ViewValue = null;
            }

            // schedule_service_interval_days
            $this->schedule_service_interval_days->ViewValue = $this->schedule_service_interval_days->CurrentValue;
            $this->schedule_service_interval_days->ViewValue = FormatNumber($this->schedule_service_interval_days->ViewValue, $this->schedule_service_interval_days->formatPattern());

            // schedule_service_updated_till
            $this->schedule_service_updated_till->ViewValue = $this->schedule_service_updated_till->CurrentValue;
            $this->schedule_service_updated_till->ViewValue = FormatDateTime($this->schedule_service_updated_till->ViewValue, $this->schedule_service_updated_till->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // copy_average_1
            $this->copy_average_1->ViewValue = $this->copy_average_1->CurrentValue;
            $this->copy_average_1->ViewValue = FormatNumber($this->copy_average_1->ViewValue, $this->copy_average_1->formatPattern());

            // copy_average_2
            $this->copy_average_2->ViewValue = $this->copy_average_2->CurrentValue;
            $this->copy_average_2->ViewValue = FormatNumber($this->copy_average_2->ViewValue, $this->copy_average_2->formatPattern());

            // copy_average_3
            $this->copy_average_3->ViewValue = $this->copy_average_3->CurrentValue;
            $this->copy_average_3->ViewValue = FormatNumber($this->copy_average_3->ViewValue, $this->copy_average_3->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // ref
            $this->ref->HrefValue = "";
            $this->ref->TooltipValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";
            $this->partner_id->TooltipValue = "";

            // name_ref
            $this->name_ref->HrefValue = "";
            $this->name_ref->TooltipValue = "";

            // city_name
            $this->city_name->HrefValue = "";
            $this->city_name->TooltipValue = "";

            // area
            $this->area->HrefValue = "";
            $this->area->TooltipValue = "";

            // harward_code
            $this->harward_code->HrefValue = "";
            $this->harward_code->TooltipValue = "";

            // serial_no
            $this->serial_no->HrefValue = "";
            $this->serial_no->TooltipValue = "";

            // date_install
            $this->date_install->HrefValue = "";
            $this->date_install->TooltipValue = "";

            // remark
            $this->remark->HrefValue = "";
            $this->remark->TooltipValue = "";

            // schedule_service_type
            $this->schedule_service_type->HrefValue = "";
            $this->schedule_service_type->TooltipValue = "";

            // schedule_service_interval_days
            $this->schedule_service_interval_days->HrefValue = "";
            $this->schedule_service_interval_days->TooltipValue = "";

            // schedule_service_updated_till
            $this->schedule_service_updated_till->HrefValue = "";
            $this->schedule_service_updated_till->TooltipValue = "";

            // copy_average_1
            $this->copy_average_1->HrefValue = "";
            $this->copy_average_1->TooltipValue = "";

            // copy_average_2
            $this->copy_average_2->HrefValue = "";
            $this->copy_average_2->TooltipValue = "";

            // copy_average_3
            $this->copy_average_3->HrefValue = "";
            $this->copy_average_3->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->AuditTrailOnDelete) {
            $this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
            if ($this->AuditTrailOnDelete) {
                $this->writeAuditTrailDummy($Language->phrase("BatchDeleteSuccess")); // Batch delete success
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnDelete) {
                $this->writeAuditTrailDummy($Language->phrase("BatchDeleteRollback")); // Batch delete rollback
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("clienthardwaredatalist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_customer_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_area":
                    break;
                case "x_personal_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_guarantee":
                    break;
                case "x_status":
                    break;
                case "x_schedule_service_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'client_hardware_data');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
