<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ClientHardwareDataAdd extends ClientHardwareData
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ClientHardwareDataAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "clienthardwaredataadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->customer_grp->setVisibility();
        $this->ref->setVisibility();
        $this->partner_id->setVisibility();
        $this->name_ref->setVisibility();
        $this->city_name->setVisibility();
        $this->area->setVisibility();
        $this->billing_name->setVisibility();
        $this->address->setVisibility();
        $this->personal_ref->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->rid_1->setVisibility();
        $this->harward_code->setVisibility();
        $this->serial_no->setVisibility();
        $this->invoice_no->setVisibility();
        $this->invoice_date->setVisibility();
        $this->first_counter->setVisibility();
        $this->guarantee->setVisibility();
        $this->valid_till->setVisibility();
        $this->valid_till_counter->setVisibility();
        $this->free_service->setVisibility();
        $this->toner_life->setVisibility();
        $this->drum_life->setVisibility();
        $this->developer_life->setVisibility();
        $this->date_install->setVisibility();
        $this->date_start->setVisibility();
        $this->remark->setVisibility();
        $this->status->setVisibility();
        $this->schedule_service_type->setVisibility();
        $this->schedule_service_interval_days->setVisibility();
        $this->schedule_service_updated_till->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->copy_average_1->Visible = false;
        $this->copy_average_2->Visible = false;
        $this->copy_average_3->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'client_hardware_data';
        $this->TableName = 'client_hardware_data';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (client_hardware_data)
        if (!isset($GLOBALS["client_hardware_data"]) || $GLOBALS["client_hardware_data"]::class == PROJECT_NAMESPACE . "client_hardware_data") {
            $GLOBALS["client_hardware_data"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'client_hardware_data');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "clienthardwaredataview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->customer_grp);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->personal_ref);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->guarantee);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->schedule_service_type);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Set up detail parameters
        $this->setupDetailParms();

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("clienthardwaredatalist"); // No matching record, return to list
                    return;
                }

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    if ($this->getCurrentDetailTable() != "") { // Master/detail add
                        $returnUrl = $this->getDetailUrl();
                    } else {
                        $returnUrl = $this->getReturnUrl();
                    }
                    if (GetPageName($returnUrl) == "clienthardwaredatalist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "clienthardwaredataview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "clienthardwaredatalist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "clienthardwaredatalist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'customer_grp' first before field var 'x_customer_grp'
        $val = $CurrentForm->hasValue("customer_grp") ? $CurrentForm->getValue("customer_grp") : $CurrentForm->getValue("x_customer_grp");
        if (!$this->customer_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->customer_grp->Visible = false; // Disable update for API request
            } else {
                $this->customer_grp->setFormValue($val);
            }
        }

        // Check field name 'ref' first before field var 'x_ref'
        $val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
        if (!$this->ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ref->Visible = false; // Disable update for API request
            } else {
                $this->ref->setFormValue($val);
            }
        }

        // Check field name 'partner_id' first before field var 'x_partner_id'
        $val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
        if (!$this->partner_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_id->Visible = false; // Disable update for API request
            } else {
                $this->partner_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'name_ref' first before field var 'x_name_ref'
        $val = $CurrentForm->hasValue("name_ref") ? $CurrentForm->getValue("name_ref") : $CurrentForm->getValue("x_name_ref");
        if (!$this->name_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name_ref->Visible = false; // Disable update for API request
            } else {
                $this->name_ref->setFormValue($val);
            }
        }

        // Check field name 'city_name' first before field var 'x_city_name'
        $val = $CurrentForm->hasValue("city_name") ? $CurrentForm->getValue("city_name") : $CurrentForm->getValue("x_city_name");
        if (!$this->city_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->city_name->Visible = false; // Disable update for API request
            } else {
                $this->city_name->setFormValue($val);
            }
        }

        // Check field name 'area' first before field var 'x_area'
        $val = $CurrentForm->hasValue("area") ? $CurrentForm->getValue("area") : $CurrentForm->getValue("x_area");
        if (!$this->area->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->area->Visible = false; // Disable update for API request
            } else {
                $this->area->setFormValue($val);
            }
        }

        // Check field name 'billing_name' first before field var 'x_billing_name'
        $val = $CurrentForm->hasValue("billing_name") ? $CurrentForm->getValue("billing_name") : $CurrentForm->getValue("x_billing_name");
        if (!$this->billing_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->billing_name->Visible = false; // Disable update for API request
            } else {
                $this->billing_name->setFormValue($val);
            }
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }

        // Check field name 'personal_ref' first before field var 'x_personal_ref'
        $val = $CurrentForm->hasValue("personal_ref") ? $CurrentForm->getValue("personal_ref") : $CurrentForm->getValue("x_personal_ref");
        if (!$this->personal_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->personal_ref->Visible = false; // Disable update for API request
            } else {
                $this->personal_ref->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }

        // Check field name 'rid_1' first before field var 'x_rid_1'
        $val = $CurrentForm->hasValue("rid_1") ? $CurrentForm->getValue("rid_1") : $CurrentForm->getValue("x_rid_1");
        if (!$this->rid_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid_1->Visible = false; // Disable update for API request
            } else {
                $this->rid_1->setFormValue($val);
            }
        }

        // Check field name 'harward_code' first before field var 'x_harward_code'
        $val = $CurrentForm->hasValue("harward_code") ? $CurrentForm->getValue("harward_code") : $CurrentForm->getValue("x_harward_code");
        if (!$this->harward_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->harward_code->Visible = false; // Disable update for API request
            } else {
                $this->harward_code->setFormValue($val);
            }
        }

        // Check field name 'serial_no' first before field var 'x_serial_no'
        $val = $CurrentForm->hasValue("serial_no") ? $CurrentForm->getValue("serial_no") : $CurrentForm->getValue("x_serial_no");
        if (!$this->serial_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->serial_no->Visible = false; // Disable update for API request
            } else {
                $this->serial_no->setFormValue($val);
            }
        }

        // Check field name 'invoice_no' first before field var 'x_invoice_no'
        $val = $CurrentForm->hasValue("invoice_no") ? $CurrentForm->getValue("invoice_no") : $CurrentForm->getValue("x_invoice_no");
        if (!$this->invoice_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoice_no->Visible = false; // Disable update for API request
            } else {
                $this->invoice_no->setFormValue($val);
            }
        }

        // Check field name 'invoice_date' first before field var 'x_invoice_date'
        $val = $CurrentForm->hasValue("invoice_date") ? $CurrentForm->getValue("invoice_date") : $CurrentForm->getValue("x_invoice_date");
        if (!$this->invoice_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoice_date->Visible = false; // Disable update for API request
            } else {
                $this->invoice_date->setFormValue($val, true, $validate);
            }
            $this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern());
        }

        // Check field name 'first_counter' first before field var 'x_first_counter'
        $val = $CurrentForm->hasValue("first_counter") ? $CurrentForm->getValue("first_counter") : $CurrentForm->getValue("x_first_counter");
        if (!$this->first_counter->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->first_counter->Visible = false; // Disable update for API request
            } else {
                $this->first_counter->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'guarantee' first before field var 'x_guarantee'
        $val = $CurrentForm->hasValue("guarantee") ? $CurrentForm->getValue("guarantee") : $CurrentForm->getValue("x_guarantee");
        if (!$this->guarantee->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->guarantee->Visible = false; // Disable update for API request
            } else {
                $this->guarantee->setFormValue($val);
            }
        }

        // Check field name 'valid_till' first before field var 'x_valid_till'
        $val = $CurrentForm->hasValue("valid_till") ? $CurrentForm->getValue("valid_till") : $CurrentForm->getValue("x_valid_till");
        if (!$this->valid_till->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->valid_till->Visible = false; // Disable update for API request
            } else {
                $this->valid_till->setFormValue($val, true, $validate);
            }
            $this->valid_till->CurrentValue = UnFormatDateTime($this->valid_till->CurrentValue, $this->valid_till->formatPattern());
        }

        // Check field name 'valid_till_counter' first before field var 'x_valid_till_counter'
        $val = $CurrentForm->hasValue("valid_till_counter") ? $CurrentForm->getValue("valid_till_counter") : $CurrentForm->getValue("x_valid_till_counter");
        if (!$this->valid_till_counter->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->valid_till_counter->Visible = false; // Disable update for API request
            } else {
                $this->valid_till_counter->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'free_service' first before field var 'x_free_service'
        $val = $CurrentForm->hasValue("free_service") ? $CurrentForm->getValue("free_service") : $CurrentForm->getValue("x_free_service");
        if (!$this->free_service->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->free_service->Visible = false; // Disable update for API request
            } else {
                $this->free_service->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'toner_life' first before field var 'x_toner_life'
        $val = $CurrentForm->hasValue("toner_life") ? $CurrentForm->getValue("toner_life") : $CurrentForm->getValue("x_toner_life");
        if (!$this->toner_life->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->toner_life->Visible = false; // Disable update for API request
            } else {
                $this->toner_life->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'drum_life' first before field var 'x_drum_life'
        $val = $CurrentForm->hasValue("drum_life") ? $CurrentForm->getValue("drum_life") : $CurrentForm->getValue("x_drum_life");
        if (!$this->drum_life->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->drum_life->Visible = false; // Disable update for API request
            } else {
                $this->drum_life->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'developer_life' first before field var 'x_developer_life'
        $val = $CurrentForm->hasValue("developer_life") ? $CurrentForm->getValue("developer_life") : $CurrentForm->getValue("x_developer_life");
        if (!$this->developer_life->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->developer_life->Visible = false; // Disable update for API request
            } else {
                $this->developer_life->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'date_install' first before field var 'x_date_install'
        $val = $CurrentForm->hasValue("date_install") ? $CurrentForm->getValue("date_install") : $CurrentForm->getValue("x_date_install");
        if (!$this->date_install->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->date_install->Visible = false; // Disable update for API request
            } else {
                $this->date_install->setFormValue($val, true, $validate);
            }
            $this->date_install->CurrentValue = UnFormatDateTime($this->date_install->CurrentValue, $this->date_install->formatPattern());
        }

        // Check field name 'date_start' first before field var 'x_date_start'
        $val = $CurrentForm->hasValue("date_start") ? $CurrentForm->getValue("date_start") : $CurrentForm->getValue("x_date_start");
        if (!$this->date_start->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->date_start->Visible = false; // Disable update for API request
            } else {
                $this->date_start->setFormValue($val, true, $validate);
            }
            $this->date_start->CurrentValue = UnFormatDateTime($this->date_start->CurrentValue, $this->date_start->formatPattern());
        }

        // Check field name 'remark' first before field var 'x_remark'
        $val = $CurrentForm->hasValue("remark") ? $CurrentForm->getValue("remark") : $CurrentForm->getValue("x_remark");
        if (!$this->remark->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remark->Visible = false; // Disable update for API request
            } else {
                $this->remark->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'schedule_service_type' first before field var 'x_schedule_service_type'
        $val = $CurrentForm->hasValue("schedule_service_type") ? $CurrentForm->getValue("schedule_service_type") : $CurrentForm->getValue("x_schedule_service_type");
        if (!$this->schedule_service_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->schedule_service_type->Visible = false; // Disable update for API request
            } else {
                $this->schedule_service_type->setFormValue($val);
            }
        }

        // Check field name 'schedule_service_interval_days' first before field var 'x_schedule_service_interval_days'
        $val = $CurrentForm->hasValue("schedule_service_interval_days") ? $CurrentForm->getValue("schedule_service_interval_days") : $CurrentForm->getValue("x_schedule_service_interval_days");
        if (!$this->schedule_service_interval_days->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->schedule_service_interval_days->Visible = false; // Disable update for API request
            } else {
                $this->schedule_service_interval_days->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->customer_grp->CurrentValue = $this->customer_grp->FormValue;
        $this->ref->CurrentValue = $this->ref->FormValue;
        $this->partner_id->CurrentValue = $this->partner_id->FormValue;
        $this->name_ref->CurrentValue = $this->name_ref->FormValue;
        $this->city_name->CurrentValue = $this->city_name->FormValue;
        $this->area->CurrentValue = $this->area->FormValue;
        $this->billing_name->CurrentValue = $this->billing_name->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->personal_ref->CurrentValue = $this->personal_ref->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->rid_1->CurrentValue = $this->rid_1->FormValue;
        $this->harward_code->CurrentValue = $this->harward_code->FormValue;
        $this->serial_no->CurrentValue = $this->serial_no->FormValue;
        $this->invoice_no->CurrentValue = $this->invoice_no->FormValue;
        $this->invoice_date->CurrentValue = $this->invoice_date->FormValue;
        $this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern());
        $this->first_counter->CurrentValue = $this->first_counter->FormValue;
        $this->guarantee->CurrentValue = $this->guarantee->FormValue;
        $this->valid_till->CurrentValue = $this->valid_till->FormValue;
        $this->valid_till->CurrentValue = UnFormatDateTime($this->valid_till->CurrentValue, $this->valid_till->formatPattern());
        $this->valid_till_counter->CurrentValue = $this->valid_till_counter->FormValue;
        $this->free_service->CurrentValue = $this->free_service->FormValue;
        $this->toner_life->CurrentValue = $this->toner_life->FormValue;
        $this->drum_life->CurrentValue = $this->drum_life->FormValue;
        $this->developer_life->CurrentValue = $this->developer_life->FormValue;
        $this->date_install->CurrentValue = $this->date_install->FormValue;
        $this->date_install->CurrentValue = UnFormatDateTime($this->date_install->CurrentValue, $this->date_install->formatPattern());
        $this->date_start->CurrentValue = $this->date_start->FormValue;
        $this->date_start->CurrentValue = UnFormatDateTime($this->date_start->CurrentValue, $this->date_start->formatPattern());
        $this->remark->CurrentValue = $this->remark->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->schedule_service_type->CurrentValue = $this->schedule_service_type->FormValue;
        $this->schedule_service_interval_days->CurrentValue = $this->schedule_service_interval_days->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->customer_grp->setDbValue($row['customer_grp']);
        $this->ref->setDbValue($row['ref']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->name_ref->setDbValue($row['name_ref']);
        $this->city_name->setDbValue($row['city_name']);
        $this->area->setDbValue($row['area']);
        $this->billing_name->setDbValue($row['billing_name']);
        $this->address->setDbValue($row['address']);
        $this->personal_ref->setDbValue($row['personal_ref']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->harward_code->setDbValue($row['harward_code']);
        $this->serial_no->setDbValue($row['serial_no']);
        $this->invoice_no->setDbValue($row['invoice_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->first_counter->setDbValue($row['first_counter']);
        $this->guarantee->setDbValue($row['guarantee']);
        $this->valid_till->setDbValue($row['valid_till']);
        $this->valid_till_counter->setDbValue($row['valid_till_counter']);
        $this->free_service->setDbValue($row['free_service']);
        $this->toner_life->setDbValue($row['toner_life']);
        $this->drum_life->setDbValue($row['drum_life']);
        $this->developer_life->setDbValue($row['developer_life']);
        $this->date_install->setDbValue($row['date_install']);
        $this->date_start->setDbValue($row['date_start']);
        $this->remark->setDbValue($row['remark']);
        $this->status->setDbValue($row['status']);
        $this->schedule_service_type->setDbValue($row['schedule_service_type']);
        $this->schedule_service_interval_days->setDbValue($row['schedule_service_interval_days']);
        $this->schedule_service_updated_till->setDbValue($row['schedule_service_updated_till']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->copy_average_1->setDbValue($row['copy_average_1']);
        $this->copy_average_2->setDbValue($row['copy_average_2']);
        $this->copy_average_3->setDbValue($row['copy_average_3']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['customer_grp'] = $this->customer_grp->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['name_ref'] = $this->name_ref->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['area'] = $this->area->DefaultValue;
        $row['billing_name'] = $this->billing_name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['personal_ref'] = $this->personal_ref->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['harward_code'] = $this->harward_code->DefaultValue;
        $row['serial_no'] = $this->serial_no->DefaultValue;
        $row['invoice_no'] = $this->invoice_no->DefaultValue;
        $row['invoice_date'] = $this->invoice_date->DefaultValue;
        $row['first_counter'] = $this->first_counter->DefaultValue;
        $row['guarantee'] = $this->guarantee->DefaultValue;
        $row['valid_till'] = $this->valid_till->DefaultValue;
        $row['valid_till_counter'] = $this->valid_till_counter->DefaultValue;
        $row['free_service'] = $this->free_service->DefaultValue;
        $row['toner_life'] = $this->toner_life->DefaultValue;
        $row['drum_life'] = $this->drum_life->DefaultValue;
        $row['developer_life'] = $this->developer_life->DefaultValue;
        $row['date_install'] = $this->date_install->DefaultValue;
        $row['date_start'] = $this->date_start->DefaultValue;
        $row['remark'] = $this->remark->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['schedule_service_type'] = $this->schedule_service_type->DefaultValue;
        $row['schedule_service_interval_days'] = $this->schedule_service_interval_days->DefaultValue;
        $row['schedule_service_updated_till'] = $this->schedule_service_updated_till->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['copy_average_1'] = $this->copy_average_1->DefaultValue;
        $row['copy_average_2'] = $this->copy_average_2->DefaultValue;
        $row['copy_average_3'] = $this->copy_average_3->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // customer_grp
        $this->customer_grp->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // name_ref
        $this->name_ref->RowCssClass = "row";

        // city_name
        $this->city_name->RowCssClass = "row";

        // area
        $this->area->RowCssClass = "row";

        // billing_name
        $this->billing_name->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // personal_ref
        $this->personal_ref->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // rid_1
        $this->rid_1->RowCssClass = "row";

        // harward_code
        $this->harward_code->RowCssClass = "row";

        // serial_no
        $this->serial_no->RowCssClass = "row";

        // invoice_no
        $this->invoice_no->RowCssClass = "row";

        // invoice_date
        $this->invoice_date->RowCssClass = "row";

        // first_counter
        $this->first_counter->RowCssClass = "row";

        // guarantee
        $this->guarantee->RowCssClass = "row";

        // valid_till
        $this->valid_till->RowCssClass = "row";

        // valid_till_counter
        $this->valid_till_counter->RowCssClass = "row";

        // free_service
        $this->free_service->RowCssClass = "row";

        // toner_life
        $this->toner_life->RowCssClass = "row";

        // drum_life
        $this->drum_life->RowCssClass = "row";

        // developer_life
        $this->developer_life->RowCssClass = "row";

        // date_install
        $this->date_install->RowCssClass = "row";

        // date_start
        $this->date_start->RowCssClass = "row";

        // remark
        $this->remark->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // schedule_service_type
        $this->schedule_service_type->RowCssClass = "row";

        // schedule_service_interval_days
        $this->schedule_service_interval_days->RowCssClass = "row";

        // schedule_service_updated_till
        $this->schedule_service_updated_till->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // copy_average_1
        $this->copy_average_1->RowCssClass = "row";

        // copy_average_2
        $this->copy_average_2->RowCssClass = "row";

        // copy_average_3
        $this->copy_average_3->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // customer_grp
            $curVal = strval($this->customer_grp->CurrentValue);
            if ($curVal != "") {
                $this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
                if ($this->customer_grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->customer_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->customer_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->customer_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->customer_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->customer_grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->customer_grp->Lookup->renderViewRow($row);
                            $this->customer_grp->ViewValue->add($this->customer_grp->displayValue($arwrk));
                        }
                    } else {
                        $this->customer_grp->ViewValue = $this->customer_grp->CurrentValue;
                    }
                }
            } else {
                $this->customer_grp->ViewValue = null;
            }

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // name_ref
            $this->name_ref->ViewValue = $this->name_ref->CurrentValue;

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // area
            $this->area->ViewValue = $this->area->CurrentValue;

            // billing_name
            $this->billing_name->ViewValue = $this->billing_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // personal_ref
            $curVal = strval($this->personal_ref->CurrentValue);
            if ($curVal != "") {
                $this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
                if ($this->personal_ref->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->personal_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->personal_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->personal_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->personal_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->personal_ref->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->personal_ref->Lookup->renderViewRow($row);
                            $this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
                        }
                    } else {
                        $this->personal_ref->ViewValue = $this->personal_ref->CurrentValue;
                    }
                }
            } else {
                $this->personal_ref->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // rid_1
            $this->rid_1->ViewValue = $this->rid_1->CurrentValue;

            // harward_code
            $this->harward_code->ViewValue = $this->harward_code->CurrentValue;

            // serial_no
            $this->serial_no->ViewValue = $this->serial_no->CurrentValue;

            // invoice_no
            $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

            // first_counter
            $this->first_counter->ViewValue = $this->first_counter->CurrentValue;
            $this->first_counter->ViewValue = FormatNumber($this->first_counter->ViewValue, $this->first_counter->formatPattern());

            // guarantee
            if (strval($this->guarantee->CurrentValue) != "") {
                $this->guarantee->ViewValue = $this->guarantee->optionCaption($this->guarantee->CurrentValue);
            } else {
                $this->guarantee->ViewValue = null;
            }

            // valid_till
            $this->valid_till->ViewValue = $this->valid_till->CurrentValue;
            $this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, $this->valid_till->formatPattern());

            // valid_till_counter
            $this->valid_till_counter->ViewValue = $this->valid_till_counter->CurrentValue;
            $this->valid_till_counter->ViewValue = FormatNumber($this->valid_till_counter->ViewValue, $this->valid_till_counter->formatPattern());

            // free_service
            $this->free_service->ViewValue = $this->free_service->CurrentValue;
            $this->free_service->ViewValue = FormatNumber($this->free_service->ViewValue, $this->free_service->formatPattern());

            // toner_life
            $this->toner_life->ViewValue = $this->toner_life->CurrentValue;
            $this->toner_life->ViewValue = FormatNumber($this->toner_life->ViewValue, $this->toner_life->formatPattern());

            // drum_life
            $this->drum_life->ViewValue = $this->drum_life->CurrentValue;
            $this->drum_life->ViewValue = FormatNumber($this->drum_life->ViewValue, $this->drum_life->formatPattern());

            // developer_life
            $this->developer_life->ViewValue = $this->developer_life->CurrentValue;
            $this->developer_life->ViewValue = FormatNumber($this->developer_life->ViewValue, $this->developer_life->formatPattern());

            // date_install
            $this->date_install->ViewValue = $this->date_install->CurrentValue;
            $this->date_install->ViewValue = FormatDateTime($this->date_install->ViewValue, $this->date_install->formatPattern());

            // date_start
            $this->date_start->ViewValue = $this->date_start->CurrentValue;
            $this->date_start->ViewValue = FormatDateTime($this->date_start->ViewValue, $this->date_start->formatPattern());

            // remark
            $this->remark->ViewValue = $this->remark->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // schedule_service_type
            $curVal = strval($this->schedule_service_type->CurrentValue);
            if ($curVal != "") {
                $this->schedule_service_type->ViewValue = $this->schedule_service_type->lookupCacheOption($curVal);
                if ($this->schedule_service_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->schedule_service_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->schedule_service_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->schedule_service_type->Lookup->renderViewRow($rswrk[0]);
                        $this->schedule_service_type->ViewValue = $this->schedule_service_type->displayValue($arwrk);
                    } else {
                        $this->schedule_service_type->ViewValue = FormatNumber($this->schedule_service_type->CurrentValue, $this->schedule_service_type->formatPattern());
                    }
                }
            } else {
                $this->schedule_service_type->ViewValue = null;
            }

            // schedule_service_interval_days
            $this->schedule_service_interval_days->ViewValue = $this->schedule_service_interval_days->CurrentValue;
            $this->schedule_service_interval_days->ViewValue = FormatNumber($this->schedule_service_interval_days->ViewValue, $this->schedule_service_interval_days->formatPattern());

            // schedule_service_updated_till
            $this->schedule_service_updated_till->ViewValue = $this->schedule_service_updated_till->CurrentValue;
            $this->schedule_service_updated_till->ViewValue = FormatDateTime($this->schedule_service_updated_till->ViewValue, $this->schedule_service_updated_till->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // copy_average_1
            $this->copy_average_1->ViewValue = $this->copy_average_1->CurrentValue;
            $this->copy_average_1->ViewValue = FormatNumber($this->copy_average_1->ViewValue, $this->copy_average_1->formatPattern());

            // copy_average_2
            $this->copy_average_2->ViewValue = $this->copy_average_2->CurrentValue;
            $this->copy_average_2->ViewValue = FormatNumber($this->copy_average_2->ViewValue, $this->copy_average_2->formatPattern());

            // copy_average_3
            $this->copy_average_3->ViewValue = $this->copy_average_3->CurrentValue;
            $this->copy_average_3->ViewValue = FormatNumber($this->copy_average_3->ViewValue, $this->copy_average_3->formatPattern());

            // customer_grp
            $this->customer_grp->HrefValue = "";

            // ref
            $this->ref->HrefValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";

            // name_ref
            $this->name_ref->HrefValue = "";

            // city_name
            $this->city_name->HrefValue = "";

            // area
            $this->area->HrefValue = "";

            // billing_name
            $this->billing_name->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // personal_ref
            $this->personal_ref->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            $this->rid->HrefValue = "";

            // rid_1
            $this->rid_1->HrefValue = "";

            // harward_code
            $this->harward_code->HrefValue = "";

            // serial_no
            $this->serial_no->HrefValue = "";

            // invoice_no
            $this->invoice_no->HrefValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";

            // first_counter
            $this->first_counter->HrefValue = "";

            // guarantee
            $this->guarantee->HrefValue = "";

            // valid_till
            $this->valid_till->HrefValue = "";

            // valid_till_counter
            $this->valid_till_counter->HrefValue = "";

            // free_service
            $this->free_service->HrefValue = "";

            // toner_life
            $this->toner_life->HrefValue = "";

            // drum_life
            $this->drum_life->HrefValue = "";

            // developer_life
            $this->developer_life->HrefValue = "";

            // date_install
            $this->date_install->HrefValue = "";

            // date_start
            $this->date_start->HrefValue = "";

            // remark
            $this->remark->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // schedule_service_type
            $this->schedule_service_type->HrefValue = "";

            // schedule_service_interval_days
            $this->schedule_service_interval_days->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // customer_grp
            $curVal = trim(strval($this->customer_grp->CurrentValue));
            if ($curVal != "") {
                $this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
            } else {
                $this->customer_grp->ViewValue = $this->customer_grp->Lookup !== null && is_array($this->customer_grp->lookupOptions()) && count($this->customer_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->customer_grp->ViewValue !== null) { // Load from cache
                $this->customer_grp->EditValue = array_values($this->customer_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->customer_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->customer_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->customer_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->customer_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->customer_grp->EditValue = $arwrk;
            }
            $this->customer_grp->PlaceHolder = RemoveHtml($this->customer_grp->caption());

            // ref
            $this->ref->setupEditAttributes();
            if (!$this->ref->Raw) {
                $this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
            }
            $this->ref->EditValue = HtmlEncode($this->ref->CurrentValue);
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue = HtmlEncode($this->partner_id->CurrentValue);
                    }
                }
            } else {
                $this->partner_id->EditValue = null;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

            // name_ref
            $this->name_ref->setupEditAttributes();
            if (!$this->name_ref->Raw) {
                $this->name_ref->CurrentValue = HtmlDecode($this->name_ref->CurrentValue);
            }
            $this->name_ref->EditValue = HtmlEncode($this->name_ref->CurrentValue);
            $this->name_ref->PlaceHolder = RemoveHtml($this->name_ref->caption());

            // city_name
            $this->city_name->setupEditAttributes();
            if (!$this->city_name->Raw) {
                $this->city_name->CurrentValue = HtmlDecode($this->city_name->CurrentValue);
            }
            $this->city_name->EditValue = HtmlEncode($this->city_name->CurrentValue);
            $this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

            // area
            $this->area->setupEditAttributes();
            if (!$this->area->Raw) {
                $this->area->CurrentValue = HtmlDecode($this->area->CurrentValue);
            }
            $this->area->EditValue = HtmlEncode($this->area->CurrentValue);
            $arwrk = [];
            $arwrk["lf"] = $this->area->CurrentValue;
            $arwrk["df"] = $this->area->CurrentValue;
            $arwrk = $this->area->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->area->displayValue($arwrk);
            if ($dispVal != "") {
                $this->area->EditValue = $dispVal;
            }
            $this->area->PlaceHolder = RemoveHtml($this->area->caption());

            // billing_name
            $this->billing_name->setupEditAttributes();
            if (!$this->billing_name->Raw) {
                $this->billing_name->CurrentValue = HtmlDecode($this->billing_name->CurrentValue);
            }
            $this->billing_name->EditValue = HtmlEncode($this->billing_name->CurrentValue);
            $this->billing_name->PlaceHolder = RemoveHtml($this->billing_name->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // personal_ref
            $curVal = trim(strval($this->personal_ref->CurrentValue));
            if ($curVal != "") {
                $this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
            } else {
                $this->personal_ref->ViewValue = $this->personal_ref->Lookup !== null && is_array($this->personal_ref->lookupOptions()) && count($this->personal_ref->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->personal_ref->ViewValue !== null) { // Load from cache
                $this->personal_ref->EditValue = array_values($this->personal_ref->lookupOptions());
                if ($this->personal_ref->ViewValue == "") {
                    $this->personal_ref->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->personal_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->personal_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->personal_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->personal_ref->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->personal_ref->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->personal_ref->Lookup->renderViewRow($row);
                        $this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->personal_ref->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->personal_ref->Lookup->renderViewRow($row);
                }
                $this->personal_ref->EditValue = $arwrk;
            }
            $this->personal_ref->PlaceHolder = RemoveHtml($this->personal_ref->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->EditValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
                    }
                }
            } else {
                $this->rid->EditValue = null;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // rid_1
            $this->rid_1->setupEditAttributes();
            $this->rid_1->EditCustomAttributes = $this->rid_1->getEditCustomAttributes(); // PHP
            if (!$this->rid_1->Raw) {
                $this->rid_1->CurrentValue = HtmlDecode($this->rid_1->CurrentValue);
            }
            $this->rid_1->EditValue = HtmlEncode($this->rid_1->CurrentValue);
            $this->rid_1->PlaceHolder = RemoveHtml($this->rid_1->caption());

            // harward_code
            $this->harward_code->setupEditAttributes();
            if (!$this->harward_code->Raw) {
                $this->harward_code->CurrentValue = HtmlDecode($this->harward_code->CurrentValue);
            }
            $this->harward_code->EditValue = HtmlEncode($this->harward_code->CurrentValue);
            $this->harward_code->PlaceHolder = RemoveHtml($this->harward_code->caption());

            // serial_no
            $this->serial_no->setupEditAttributes();
            if (!$this->serial_no->Raw) {
                $this->serial_no->CurrentValue = HtmlDecode($this->serial_no->CurrentValue);
            }
            $this->serial_no->EditValue = HtmlEncode($this->serial_no->CurrentValue);
            $this->serial_no->PlaceHolder = RemoveHtml($this->serial_no->caption());

            // invoice_no
            $this->invoice_no->setupEditAttributes();
            if (!$this->invoice_no->Raw) {
                $this->invoice_no->CurrentValue = HtmlDecode($this->invoice_no->CurrentValue);
            }
            $this->invoice_no->EditValue = HtmlEncode($this->invoice_no->CurrentValue);
            $this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

            // invoice_date
            $this->invoice_date->setupEditAttributes();
            $this->invoice_date->EditValue = HtmlEncode(FormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern()));
            $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

            // first_counter
            $this->first_counter->setupEditAttributes();
            $this->first_counter->EditValue = $this->first_counter->CurrentValue;
            $this->first_counter->PlaceHolder = RemoveHtml($this->first_counter->caption());
            if (strval($this->first_counter->EditValue) != "" && is_numeric($this->first_counter->EditValue)) {
                $this->first_counter->EditValue = FormatNumber($this->first_counter->EditValue, null);
            }

            // guarantee
            $this->guarantee->setupEditAttributes();
            $this->guarantee->EditValue = $this->guarantee->options(true);
            $this->guarantee->PlaceHolder = RemoveHtml($this->guarantee->caption());

            // valid_till
            $this->valid_till->setupEditAttributes();
            $this->valid_till->EditValue = HtmlEncode(FormatDateTime($this->valid_till->CurrentValue, $this->valid_till->formatPattern()));
            $this->valid_till->PlaceHolder = RemoveHtml($this->valid_till->caption());

            // valid_till_counter
            $this->valid_till_counter->setupEditAttributes();
            $this->valid_till_counter->EditValue = $this->valid_till_counter->CurrentValue;
            $this->valid_till_counter->PlaceHolder = RemoveHtml($this->valid_till_counter->caption());
            if (strval($this->valid_till_counter->EditValue) != "" && is_numeric($this->valid_till_counter->EditValue)) {
                $this->valid_till_counter->EditValue = FormatNumber($this->valid_till_counter->EditValue, null);
            }

            // free_service
            $this->free_service->setupEditAttributes();
            $this->free_service->EditValue = $this->free_service->CurrentValue;
            $this->free_service->PlaceHolder = RemoveHtml($this->free_service->caption());
            if (strval($this->free_service->EditValue) != "" && is_numeric($this->free_service->EditValue)) {
                $this->free_service->EditValue = FormatNumber($this->free_service->EditValue, null);
            }

            // toner_life
            $this->toner_life->setupEditAttributes();
            $this->toner_life->EditValue = $this->toner_life->CurrentValue;
            $this->toner_life->PlaceHolder = RemoveHtml($this->toner_life->caption());
            if (strval($this->toner_life->EditValue) != "" && is_numeric($this->toner_life->EditValue)) {
                $this->toner_life->EditValue = FormatNumber($this->toner_life->EditValue, null);
            }

            // drum_life
            $this->drum_life->setupEditAttributes();
            $this->drum_life->EditValue = $this->drum_life->CurrentValue;
            $this->drum_life->PlaceHolder = RemoveHtml($this->drum_life->caption());
            if (strval($this->drum_life->EditValue) != "" && is_numeric($this->drum_life->EditValue)) {
                $this->drum_life->EditValue = FormatNumber($this->drum_life->EditValue, null);
            }

            // developer_life
            $this->developer_life->setupEditAttributes();
            $this->developer_life->EditValue = $this->developer_life->CurrentValue;
            $this->developer_life->PlaceHolder = RemoveHtml($this->developer_life->caption());
            if (strval($this->developer_life->EditValue) != "" && is_numeric($this->developer_life->EditValue)) {
                $this->developer_life->EditValue = FormatNumber($this->developer_life->EditValue, null);
            }

            // date_install
            $this->date_install->setupEditAttributes();
            $this->date_install->EditValue = HtmlEncode(FormatDateTime($this->date_install->CurrentValue, $this->date_install->formatPattern()));
            $this->date_install->PlaceHolder = RemoveHtml($this->date_install->caption());

            // date_start
            $this->date_start->setupEditAttributes();
            $this->date_start->EditValue = HtmlEncode(FormatDateTime($this->date_start->CurrentValue, $this->date_start->formatPattern()));
            $this->date_start->PlaceHolder = RemoveHtml($this->date_start->caption());

            // remark
            $this->remark->setupEditAttributes();
            if (!$this->remark->Raw) {
                $this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
            }
            $this->remark->EditValue = HtmlEncode($this->remark->CurrentValue);
            $this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // schedule_service_type
            $this->schedule_service_type->setupEditAttributes();
            $curVal = trim(strval($this->schedule_service_type->CurrentValue));
            if ($curVal != "") {
                $this->schedule_service_type->ViewValue = $this->schedule_service_type->lookupCacheOption($curVal);
            } else {
                $this->schedule_service_type->ViewValue = $this->schedule_service_type->Lookup !== null && is_array($this->schedule_service_type->lookupOptions()) && count($this->schedule_service_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->schedule_service_type->ViewValue !== null) { // Load from cache
                $this->schedule_service_type->EditValue = array_values($this->schedule_service_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->schedule_service_type->CurrentValue, $this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->schedule_service_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->schedule_service_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->schedule_service_type->EditValue = $arwrk;
            }
            $this->schedule_service_type->PlaceHolder = RemoveHtml($this->schedule_service_type->caption());

            // schedule_service_interval_days
            $this->schedule_service_interval_days->setupEditAttributes(["step" => "1"]);
            $this->schedule_service_interval_days->EditValue = $this->schedule_service_interval_days->CurrentValue;
            $this->schedule_service_interval_days->PlaceHolder = RemoveHtml($this->schedule_service_interval_days->caption());
            if (strval($this->schedule_service_interval_days->EditValue) != "" && is_numeric($this->schedule_service_interval_days->EditValue)) {
                $this->schedule_service_interval_days->EditValue = FormatNumber($this->schedule_service_interval_days->EditValue, null);
            }

            // operator

            // datetime

            // Add refer script

            // customer_grp
            $this->customer_grp->HrefValue = "";

            // ref
            $this->ref->HrefValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";

            // name_ref
            $this->name_ref->HrefValue = "";

            // city_name
            $this->city_name->HrefValue = "";

            // area
            $this->area->HrefValue = "";

            // billing_name
            $this->billing_name->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // personal_ref
            $this->personal_ref->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            $this->rid->HrefValue = "";

            // rid_1
            $this->rid_1->HrefValue = "";

            // harward_code
            $this->harward_code->HrefValue = "";

            // serial_no
            $this->serial_no->HrefValue = "";

            // invoice_no
            $this->invoice_no->HrefValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";

            // first_counter
            $this->first_counter->HrefValue = "";

            // guarantee
            $this->guarantee->HrefValue = "";

            // valid_till
            $this->valid_till->HrefValue = "";

            // valid_till_counter
            $this->valid_till_counter->HrefValue = "";

            // free_service
            $this->free_service->HrefValue = "";

            // toner_life
            $this->toner_life->HrefValue = "";

            // drum_life
            $this->drum_life->HrefValue = "";

            // developer_life
            $this->developer_life->HrefValue = "";

            // date_install
            $this->date_install->HrefValue = "";

            // date_start
            $this->date_start->HrefValue = "";

            // remark
            $this->remark->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // schedule_service_type
            $this->schedule_service_type->HrefValue = "";

            // schedule_service_interval_days
            $this->schedule_service_interval_days->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Render add option
    public function renderAddOpt($row)
    {
        global $Security, $Language, $CurrentLanguage;

        // Set up CurrentValue
        $this->customer_grp->CurrentValue = $row["customer_grp"] ?? null;
        $this->ref->CurrentValue = $row["ref"] ?? null;
        $this->partner_id->CurrentValue = $row["partner_id"] ?? null;
        $this->name_ref->CurrentValue = $row["name_ref"] ?? null;
        $this->city_name->CurrentValue = $row["city_name"] ?? null;
        $this->area->CurrentValue = $row["area"] ?? null;
        $this->billing_name->CurrentValue = $row["billing_name"] ?? null;
        $this->address->CurrentValue = $row["address"] ?? null;
        $this->personal_ref->CurrentValue = $row["personal_ref"] ?? null;
        $this->grp->CurrentValue = $row["grp"] ?? null;
        $this->s_grp->CurrentValue = $row["s_grp"] ?? null;
        $this->product->CurrentValue = $row["product"] ?? null;
        $this->rid->CurrentValue = $row["rid"] ?? null;
        $this->rid_1->CurrentValue = $row["rid_1"] ?? null;
        $this->harward_code->CurrentValue = $row["harward_code"] ?? null;
        $this->serial_no->CurrentValue = $row["serial_no"] ?? null;
        $this->invoice_no->CurrentValue = $row["invoice_no"] ?? null;
        $this->invoice_date->CurrentValue = $row["invoice_date"] ?? null;
        $this->first_counter->CurrentValue = $row["first_counter"] ?? null;
        $this->guarantee->CurrentValue = $row["guarantee"] ?? null;
        $this->valid_till->CurrentValue = $row["valid_till"] ?? null;
        $this->valid_till_counter->CurrentValue = $row["valid_till_counter"] ?? null;
        $this->free_service->CurrentValue = $row["free_service"] ?? null;
        $this->toner_life->CurrentValue = $row["toner_life"] ?? null;
        $this->drum_life->CurrentValue = $row["drum_life"] ?? null;
        $this->developer_life->CurrentValue = $row["developer_life"] ?? null;
        $this->date_install->CurrentValue = $row["date_install"] ?? null;
        $this->date_start->CurrentValue = $row["date_start"] ?? null;
        $this->remark->CurrentValue = $row["remark"] ?? null;
        $this->status->CurrentValue = $row["status"] ?? null;
        $this->schedule_service_type->CurrentValue = $row["schedule_service_type"] ?? null;
        $this->schedule_service_interval_days->CurrentValue = $row["schedule_service_interval_days"] ?? null;
        $this->operator->CurrentValue = $row["operator"] ?? null;
        $this->datetime->CurrentValue = $row["datetime"] ?? null;

        // customer_grp
        $curVal = strval($this->customer_grp->CurrentValue);
        if ($curVal != "") {
            $this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
            if ($this->customer_grp->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->customer_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->customer_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->customer_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->customer_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->customer_grp->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->customer_grp->Lookup->renderViewRow($row);
                        $this->customer_grp->ViewValue->add($this->customer_grp->displayValue($arwrk));
                    }
                } else {
                    $this->customer_grp->ViewValue = $this->customer_grp->CurrentValue;
                }
            }
        } else {
            $this->customer_grp->ViewValue = null;
        }

        // ref
        $this->ref->ViewValue = $this->ref->CurrentValue;

        // partner_id
        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
        $curVal = strval($this->partner_id->CurrentValue);
        if ($curVal != "") {
            $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
            if ($this->partner_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                    $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                } else {
                    $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                }
            }
        } else {
            $this->partner_id->ViewValue = null;
        }

        // name_ref
        $this->name_ref->ViewValue = $this->name_ref->CurrentValue;

        // city_name
        $this->city_name->ViewValue = $this->city_name->CurrentValue;

        // area
        $this->area->ViewValue = $this->area->CurrentValue;

        // billing_name
        $this->billing_name->ViewValue = $this->billing_name->CurrentValue;

        // address
        $this->address->ViewValue = $this->address->CurrentValue;

        // personal_ref
        $curVal = strval($this->personal_ref->CurrentValue);
        if ($curVal != "") {
            $this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
            if ($this->personal_ref->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->personal_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->personal_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->personal_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->personal_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->personal_ref->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->personal_ref->Lookup->renderViewRow($row);
                        $this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
                    }
                } else {
                    $this->personal_ref->ViewValue = $this->personal_ref->CurrentValue;
                }
            }
        } else {
            $this->personal_ref->ViewValue = null;
        }

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = $this->grp->CurrentValue;
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $this->product->CurrentValue;
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // rid
        $this->rid->ViewValue = $this->rid->CurrentValue;
        $curVal = strval($this->rid->CurrentValue);
        if ($curVal != "") {
            $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
            if ($this->rid->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                    $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                } else {
                    $this->rid->ViewValue = $this->rid->CurrentValue;
                }
            }
        } else {
            $this->rid->ViewValue = null;
        }

        // rid_1
        $this->rid_1->ViewValue = $this->rid_1->CurrentValue;

        // harward_code
        $this->harward_code->ViewValue = $this->harward_code->CurrentValue;

        // serial_no
        $this->serial_no->ViewValue = $this->serial_no->CurrentValue;

        // invoice_no
        $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;

        // invoice_date
        $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
        $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

        // first_counter
        $this->first_counter->ViewValue = $this->first_counter->CurrentValue;
        $this->first_counter->ViewValue = FormatNumber($this->first_counter->ViewValue, $this->first_counter->formatPattern());

        // guarantee
        if (strval($this->guarantee->CurrentValue) != "") {
            $this->guarantee->ViewValue = $this->guarantee->optionCaption($this->guarantee->CurrentValue);
        } else {
            $this->guarantee->ViewValue = null;
        }

        // valid_till
        $this->valid_till->ViewValue = $this->valid_till->CurrentValue;
        $this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, $this->valid_till->formatPattern());

        // valid_till_counter
        $this->valid_till_counter->ViewValue = $this->valid_till_counter->CurrentValue;
        $this->valid_till_counter->ViewValue = FormatNumber($this->valid_till_counter->ViewValue, $this->valid_till_counter->formatPattern());

        // free_service
        $this->free_service->ViewValue = $this->free_service->CurrentValue;
        $this->free_service->ViewValue = FormatNumber($this->free_service->ViewValue, $this->free_service->formatPattern());

        // toner_life
        $this->toner_life->ViewValue = $this->toner_life->CurrentValue;
        $this->toner_life->ViewValue = FormatNumber($this->toner_life->ViewValue, $this->toner_life->formatPattern());

        // drum_life
        $this->drum_life->ViewValue = $this->drum_life->CurrentValue;
        $this->drum_life->ViewValue = FormatNumber($this->drum_life->ViewValue, $this->drum_life->formatPattern());

        // developer_life
        $this->developer_life->ViewValue = $this->developer_life->CurrentValue;
        $this->developer_life->ViewValue = FormatNumber($this->developer_life->ViewValue, $this->developer_life->formatPattern());

        // date_install
        $this->date_install->ViewValue = $this->date_install->CurrentValue;
        $this->date_install->ViewValue = FormatDateTime($this->date_install->ViewValue, $this->date_install->formatPattern());

        // date_start
        $this->date_start->ViewValue = $this->date_start->CurrentValue;
        $this->date_start->ViewValue = FormatDateTime($this->date_start->ViewValue, $this->date_start->formatPattern());

        // remark
        $this->remark->ViewValue = $this->remark->CurrentValue;

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // schedule_service_type
        $curVal = strval($this->schedule_service_type->CurrentValue);
        if ($curVal != "") {
            $this->schedule_service_type->ViewValue = $this->schedule_service_type->lookupCacheOption($curVal);
            if ($this->schedule_service_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->schedule_service_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->schedule_service_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->schedule_service_type->Lookup->renderViewRow($rswrk[0]);
                    $this->schedule_service_type->ViewValue = $this->schedule_service_type->displayValue($arwrk);
                } else {
                    $this->schedule_service_type->ViewValue = FormatNumber($this->schedule_service_type->CurrentValue, $this->schedule_service_type->formatPattern());
                }
            }
        } else {
            $this->schedule_service_type->ViewValue = null;
        }

        // schedule_service_interval_days
        $this->schedule_service_interval_days->ViewValue = $this->schedule_service_interval_days->CurrentValue;
        $this->schedule_service_interval_days->ViewValue = FormatNumber($this->schedule_service_interval_days->ViewValue, $this->schedule_service_interval_days->formatPattern());

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // Set up $row
        $row["customer_grp"] = $this->customer_grp->ViewValue;
        $row["ref"] = $this->ref->ViewValue;
        $row["name_ref"] = $this->name_ref->ViewValue;
        $row["city_name"] = $this->city_name->ViewValue;
        $row["area"] = $this->area->ViewValue;
        $row["billing_name"] = $this->billing_name->ViewValue;
        $row["address"] = $this->address->ViewValue;
        $row["personal_ref"] = $this->personal_ref->ViewValue;
        $row["grp"] = $this->grp->ViewValue;
        $row["s_grp"] = $this->s_grp->ViewValue;
        $row["product"] = $this->product->ViewValue;
        $row["rid"] = $this->rid->ViewValue;
        $row["rid_1"] = $this->rid_1->ViewValue;
        $row["harward_code"] = $this->harward_code->ViewValue;
        $row["serial_no"] = $this->serial_no->ViewValue;
        $row["invoice_no"] = $this->invoice_no->ViewValue;
        $row["invoice_date"] = $this->invoice_date->ViewValue;
        $row["first_counter"] = $this->first_counter->ViewValue;
        $row["guarantee"] = $this->guarantee->ViewValue;
        $row["valid_till"] = $this->valid_till->ViewValue;
        $row["valid_till_counter"] = $this->valid_till_counter->ViewValue;
        $row["free_service"] = $this->free_service->ViewValue;
        $row["toner_life"] = $this->toner_life->ViewValue;
        $row["drum_life"] = $this->drum_life->ViewValue;
        $row["developer_life"] = $this->developer_life->ViewValue;
        $row["date_install"] = $this->date_install->ViewValue;
        $row["date_start"] = $this->date_start->ViewValue;
        $row["remark"] = $this->remark->ViewValue;
        $row["status"] = $this->status->ViewValue;
        $row["schedule_service_type"] = $this->schedule_service_type->ViewValue;
        $row["schedule_service_interval_days"] = $this->schedule_service_interval_days->ViewValue;
        $row["operator"] = $this->operator->ViewValue;
        $row["datetime"] = $this->datetime->ViewValue;
        return $row;
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->customer_grp->Visible && $this->customer_grp->Required) {
                if ($this->customer_grp->FormValue == "") {
                    $this->customer_grp->addErrorMessage(str_replace("%s", $this->customer_grp->caption(), $this->customer_grp->RequiredErrorMessage));
                }
            }
            if ($this->ref->Visible && $this->ref->Required) {
                if (!$this->ref->IsDetailKey && EmptyValue($this->ref->FormValue)) {
                    $this->ref->addErrorMessage(str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
                }
            }
            if ($this->partner_id->Visible && $this->partner_id->Required) {
                if (!$this->partner_id->IsDetailKey && EmptyValue($this->partner_id->FormValue)) {
                    $this->partner_id->addErrorMessage(str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->partner_id->FormValue)) {
                $this->partner_id->addErrorMessage($this->partner_id->getErrorMessage(false));
            }
            if ($this->name_ref->Visible && $this->name_ref->Required) {
                if (!$this->name_ref->IsDetailKey && EmptyValue($this->name_ref->FormValue)) {
                    $this->name_ref->addErrorMessage(str_replace("%s", $this->name_ref->caption(), $this->name_ref->RequiredErrorMessage));
                }
            }
            if ($this->city_name->Visible && $this->city_name->Required) {
                if (!$this->city_name->IsDetailKey && EmptyValue($this->city_name->FormValue)) {
                    $this->city_name->addErrorMessage(str_replace("%s", $this->city_name->caption(), $this->city_name->RequiredErrorMessage));
                }
            }
            if ($this->area->Visible && $this->area->Required) {
                if (!$this->area->IsDetailKey && EmptyValue($this->area->FormValue)) {
                    $this->area->addErrorMessage(str_replace("%s", $this->area->caption(), $this->area->RequiredErrorMessage));
                }
            }
            if ($this->billing_name->Visible && $this->billing_name->Required) {
                if (!$this->billing_name->IsDetailKey && EmptyValue($this->billing_name->FormValue)) {
                    $this->billing_name->addErrorMessage(str_replace("%s", $this->billing_name->caption(), $this->billing_name->RequiredErrorMessage));
                }
            }
            if ($this->address->Visible && $this->address->Required) {
                if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->personal_ref->Visible && $this->personal_ref->Required) {
                if ($this->personal_ref->FormValue == "") {
                    $this->personal_ref->addErrorMessage(str_replace("%s", $this->personal_ref->caption(), $this->personal_ref->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->rid_1->Visible && $this->rid_1->Required) {
                if (!$this->rid_1->IsDetailKey && EmptyValue($this->rid_1->FormValue)) {
                    $this->rid_1->addErrorMessage(str_replace("%s", $this->rid_1->caption(), $this->rid_1->RequiredErrorMessage));
                }
            }
            if ($this->harward_code->Visible && $this->harward_code->Required) {
                if (!$this->harward_code->IsDetailKey && EmptyValue($this->harward_code->FormValue)) {
                    $this->harward_code->addErrorMessage(str_replace("%s", $this->harward_code->caption(), $this->harward_code->RequiredErrorMessage));
                }
            }
            if ($this->serial_no->Visible && $this->serial_no->Required) {
                if (!$this->serial_no->IsDetailKey && EmptyValue($this->serial_no->FormValue)) {
                    $this->serial_no->addErrorMessage(str_replace("%s", $this->serial_no->caption(), $this->serial_no->RequiredErrorMessage));
                }
            }
            if ($this->invoice_no->Visible && $this->invoice_no->Required) {
                if (!$this->invoice_no->IsDetailKey && EmptyValue($this->invoice_no->FormValue)) {
                    $this->invoice_no->addErrorMessage(str_replace("%s", $this->invoice_no->caption(), $this->invoice_no->RequiredErrorMessage));
                }
            }
            if ($this->invoice_date->Visible && $this->invoice_date->Required) {
                if (!$this->invoice_date->IsDetailKey && EmptyValue($this->invoice_date->FormValue)) {
                    $this->invoice_date->addErrorMessage(str_replace("%s", $this->invoice_date->caption(), $this->invoice_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->invoice_date->FormValue, $this->invoice_date->formatPattern())) {
                $this->invoice_date->addErrorMessage($this->invoice_date->getErrorMessage(false));
            }
            if ($this->first_counter->Visible && $this->first_counter->Required) {
                if (!$this->first_counter->IsDetailKey && EmptyValue($this->first_counter->FormValue)) {
                    $this->first_counter->addErrorMessage(str_replace("%s", $this->first_counter->caption(), $this->first_counter->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->first_counter->FormValue)) {
                $this->first_counter->addErrorMessage($this->first_counter->getErrorMessage(false));
            }
            if ($this->guarantee->Visible && $this->guarantee->Required) {
                if (!$this->guarantee->IsDetailKey && EmptyValue($this->guarantee->FormValue)) {
                    $this->guarantee->addErrorMessage(str_replace("%s", $this->guarantee->caption(), $this->guarantee->RequiredErrorMessage));
                }
            }
            if ($this->valid_till->Visible && $this->valid_till->Required) {
                if (!$this->valid_till->IsDetailKey && EmptyValue($this->valid_till->FormValue)) {
                    $this->valid_till->addErrorMessage(str_replace("%s", $this->valid_till->caption(), $this->valid_till->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->valid_till->FormValue, $this->valid_till->formatPattern())) {
                $this->valid_till->addErrorMessage($this->valid_till->getErrorMessage(false));
            }
            if ($this->valid_till_counter->Visible && $this->valid_till_counter->Required) {
                if (!$this->valid_till_counter->IsDetailKey && EmptyValue($this->valid_till_counter->FormValue)) {
                    $this->valid_till_counter->addErrorMessage(str_replace("%s", $this->valid_till_counter->caption(), $this->valid_till_counter->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->valid_till_counter->FormValue)) {
                $this->valid_till_counter->addErrorMessage($this->valid_till_counter->getErrorMessage(false));
            }
            if ($this->free_service->Visible && $this->free_service->Required) {
                if (!$this->free_service->IsDetailKey && EmptyValue($this->free_service->FormValue)) {
                    $this->free_service->addErrorMessage(str_replace("%s", $this->free_service->caption(), $this->free_service->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->free_service->FormValue)) {
                $this->free_service->addErrorMessage($this->free_service->getErrorMessage(false));
            }
            if ($this->toner_life->Visible && $this->toner_life->Required) {
                if (!$this->toner_life->IsDetailKey && EmptyValue($this->toner_life->FormValue)) {
                    $this->toner_life->addErrorMessage(str_replace("%s", $this->toner_life->caption(), $this->toner_life->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->toner_life->FormValue)) {
                $this->toner_life->addErrorMessage($this->toner_life->getErrorMessage(false));
            }
            if ($this->drum_life->Visible && $this->drum_life->Required) {
                if (!$this->drum_life->IsDetailKey && EmptyValue($this->drum_life->FormValue)) {
                    $this->drum_life->addErrorMessage(str_replace("%s", $this->drum_life->caption(), $this->drum_life->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->drum_life->FormValue)) {
                $this->drum_life->addErrorMessage($this->drum_life->getErrorMessage(false));
            }
            if ($this->developer_life->Visible && $this->developer_life->Required) {
                if (!$this->developer_life->IsDetailKey && EmptyValue($this->developer_life->FormValue)) {
                    $this->developer_life->addErrorMessage(str_replace("%s", $this->developer_life->caption(), $this->developer_life->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->developer_life->FormValue)) {
                $this->developer_life->addErrorMessage($this->developer_life->getErrorMessage(false));
            }
            if ($this->date_install->Visible && $this->date_install->Required) {
                if (!$this->date_install->IsDetailKey && EmptyValue($this->date_install->FormValue)) {
                    $this->date_install->addErrorMessage(str_replace("%s", $this->date_install->caption(), $this->date_install->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->date_install->FormValue, $this->date_install->formatPattern())) {
                $this->date_install->addErrorMessage($this->date_install->getErrorMessage(false));
            }
            if ($this->date_start->Visible && $this->date_start->Required) {
                if (!$this->date_start->IsDetailKey && EmptyValue($this->date_start->FormValue)) {
                    $this->date_start->addErrorMessage(str_replace("%s", $this->date_start->caption(), $this->date_start->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->date_start->FormValue, $this->date_start->formatPattern())) {
                $this->date_start->addErrorMessage($this->date_start->getErrorMessage(false));
            }
            if ($this->remark->Visible && $this->remark->Required) {
                if (!$this->remark->IsDetailKey && EmptyValue($this->remark->FormValue)) {
                    $this->remark->addErrorMessage(str_replace("%s", $this->remark->caption(), $this->remark->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->schedule_service_type->Visible && $this->schedule_service_type->Required) {
                if (!$this->schedule_service_type->IsDetailKey && EmptyValue($this->schedule_service_type->FormValue)) {
                    $this->schedule_service_type->addErrorMessage(str_replace("%s", $this->schedule_service_type->caption(), $this->schedule_service_type->RequiredErrorMessage));
                }
            }
            if ($this->schedule_service_interval_days->Visible && $this->schedule_service_interval_days->Required) {
                if (!$this->schedule_service_interval_days->IsDetailKey && EmptyValue($this->schedule_service_interval_days->FormValue)) {
                    $this->schedule_service_interval_days->addErrorMessage(str_replace("%s", $this->schedule_service_interval_days->caption(), $this->schedule_service_interval_days->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->schedule_service_interval_days->FormValue)) {
                $this->schedule_service_interval_days->addErrorMessage($this->schedule_service_interval_days->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("ServiceScheduleGrid");
        if (in_array("service_schedule", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->ref->CurrentValue != "") { // Check field with unique index
            $filter = "(`ref` = '" . AdjustSql($this->ref->CurrentValue, $this->Dbid) . "')";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->ref->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->ref->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Begin transaction
        if ($this->getCurrentDetailTable() != "" && $this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }

        // Add detail records
        if ($addRow) {
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("ServiceScheduleGrid");
            if (in_array("service_schedule", $detailTblVar) && $detailPage->DetailAdd && $addRow) {
                $detailPage->hardware_id->setSessionValue($this->id->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "service_schedule"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->hardware_id->setSessionValue(""); // Clear master key if insert failed
                }
            }
        }

        // Commit/Rollback transaction
        if ($this->getCurrentDetailTable() != "") {
            if ($addRow) {
                if ($this->UseTransaction) { // Commit transaction
                    if ($conn->isTransactionActive()) {
                        $conn->commit();
                    }
                }
            } else {
                if ($this->UseTransaction) { // Rollback transaction
                    if ($conn->isTransactionActive()) {
                        $conn->rollback();
                    }
                }
            }
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            if (Post("addopt") == "1") { // Render for add option response
                $row = $this->renderAddOpt($row);
            }
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // customer_grp
        $this->customer_grp->setDbValueDef($rsnew, $this->customer_grp->CurrentValue, false);

        // ref
        $this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, false);

        // partner_id
        $this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, false);

        // name_ref
        $this->name_ref->setDbValueDef($rsnew, $this->name_ref->CurrentValue, false);

        // city_name
        $this->city_name->setDbValueDef($rsnew, $this->city_name->CurrentValue, false);

        // area
        $this->area->setDbValueDef($rsnew, $this->area->CurrentValue, false);

        // billing_name
        $this->billing_name->setDbValueDef($rsnew, $this->billing_name->CurrentValue, false);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, false);

        // personal_ref
        $this->personal_ref->setDbValueDef($rsnew, $this->personal_ref->CurrentValue, false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, false);

        // rid_1
        $this->rid_1->setDbValueDef($rsnew, $this->rid_1->CurrentValue, false);

        // harward_code
        $this->harward_code->setDbValueDef($rsnew, $this->harward_code->CurrentValue, false);

        // serial_no
        $this->serial_no->setDbValueDef($rsnew, $this->serial_no->CurrentValue, false);

        // invoice_no
        $this->invoice_no->setDbValueDef($rsnew, $this->invoice_no->CurrentValue, false);

        // invoice_date
        $this->invoice_date->setDbValueDef($rsnew, UnFormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern()), false);

        // first_counter
        $this->first_counter->setDbValueDef($rsnew, $this->first_counter->CurrentValue, false);

        // guarantee
        $this->guarantee->setDbValueDef($rsnew, $this->guarantee->CurrentValue, false);

        // valid_till
        $this->valid_till->setDbValueDef($rsnew, UnFormatDateTime($this->valid_till->CurrentValue, $this->valid_till->formatPattern()), false);

        // valid_till_counter
        $this->valid_till_counter->setDbValueDef($rsnew, $this->valid_till_counter->CurrentValue, false);

        // free_service
        $this->free_service->setDbValueDef($rsnew, $this->free_service->CurrentValue, false);

        // toner_life
        $this->toner_life->setDbValueDef($rsnew, $this->toner_life->CurrentValue, false);

        // drum_life
        $this->drum_life->setDbValueDef($rsnew, $this->drum_life->CurrentValue, false);

        // developer_life
        $this->developer_life->setDbValueDef($rsnew, $this->developer_life->CurrentValue, false);

        // date_install
        $this->date_install->setDbValueDef($rsnew, UnFormatDateTime($this->date_install->CurrentValue, $this->date_install->formatPattern()), false);

        // date_start
        $this->date_start->setDbValueDef($rsnew, UnFormatDateTime($this->date_start->CurrentValue, $this->date_start->formatPattern()), false);

        // remark
        $this->remark->setDbValueDef($rsnew, $this->remark->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // schedule_service_type
        $this->schedule_service_type->setDbValueDef($rsnew, $this->schedule_service_type->CurrentValue, false);

        // schedule_service_interval_days
        $this->schedule_service_interval_days->setDbValueDef($rsnew, $this->schedule_service_interval_days->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['customer_grp'])) { // customer_grp
            $this->customer_grp->setFormValue($row['customer_grp']);
        }
        if (isset($row['ref'])) { // ref
            $this->ref->setFormValue($row['ref']);
        }
        if (isset($row['partner_id'])) { // partner_id
            $this->partner_id->setFormValue($row['partner_id']);
        }
        if (isset($row['name_ref'])) { // name_ref
            $this->name_ref->setFormValue($row['name_ref']);
        }
        if (isset($row['city_name'])) { // city_name
            $this->city_name->setFormValue($row['city_name']);
        }
        if (isset($row['area'])) { // area
            $this->area->setFormValue($row['area']);
        }
        if (isset($row['billing_name'])) { // billing_name
            $this->billing_name->setFormValue($row['billing_name']);
        }
        if (isset($row['address'])) { // address
            $this->address->setFormValue($row['address']);
        }
        if (isset($row['personal_ref'])) { // personal_ref
            $this->personal_ref->setFormValue($row['personal_ref']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['rid'])) { // rid
            $this->rid->setFormValue($row['rid']);
        }
        if (isset($row['rid_1'])) { // rid_1
            $this->rid_1->setFormValue($row['rid_1']);
        }
        if (isset($row['harward_code'])) { // harward_code
            $this->harward_code->setFormValue($row['harward_code']);
        }
        if (isset($row['serial_no'])) { // serial_no
            $this->serial_no->setFormValue($row['serial_no']);
        }
        if (isset($row['invoice_no'])) { // invoice_no
            $this->invoice_no->setFormValue($row['invoice_no']);
        }
        if (isset($row['invoice_date'])) { // invoice_date
            $this->invoice_date->setFormValue($row['invoice_date']);
        }
        if (isset($row['first_counter'])) { // first_counter
            $this->first_counter->setFormValue($row['first_counter']);
        }
        if (isset($row['guarantee'])) { // guarantee
            $this->guarantee->setFormValue($row['guarantee']);
        }
        if (isset($row['valid_till'])) { // valid_till
            $this->valid_till->setFormValue($row['valid_till']);
        }
        if (isset($row['valid_till_counter'])) { // valid_till_counter
            $this->valid_till_counter->setFormValue($row['valid_till_counter']);
        }
        if (isset($row['free_service'])) { // free_service
            $this->free_service->setFormValue($row['free_service']);
        }
        if (isset($row['toner_life'])) { // toner_life
            $this->toner_life->setFormValue($row['toner_life']);
        }
        if (isset($row['drum_life'])) { // drum_life
            $this->drum_life->setFormValue($row['drum_life']);
        }
        if (isset($row['developer_life'])) { // developer_life
            $this->developer_life->setFormValue($row['developer_life']);
        }
        if (isset($row['date_install'])) { // date_install
            $this->date_install->setFormValue($row['date_install']);
        }
        if (isset($row['date_start'])) { // date_start
            $this->date_start->setFormValue($row['date_start']);
        }
        if (isset($row['remark'])) { // remark
            $this->remark->setFormValue($row['remark']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['schedule_service_type'])) { // schedule_service_type
            $this->schedule_service_type->setFormValue($row['schedule_service_type']);
        }
        if (isset($row['schedule_service_interval_days'])) { // schedule_service_interval_days
            $this->schedule_service_interval_days->setFormValue($row['schedule_service_interval_days']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("service_schedule", $detailTblVar)) {
                $detailPageObj = Container("ServiceScheduleGrid");
                if ($detailPageObj->DetailAdd) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->hardware_id->IsDetailKey = true;
                    $detailPageObj->hardware_id->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->hardware_id->setSessionValue($detailPageObj->hardware_id->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("clienthardwaredatalist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_customer_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_area":
                    break;
                case "x_personal_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_guarantee":
                    break;
                case "x_status":
                    break;
                case "x_schedule_service_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'client_hardware_data');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
