<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for client_hardware_data
 */
class ClientHardwareData extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $customer_grp;
    public $ref;
    public $partner_id;
    public $name_ref;
    public $city_name;
    public $area;
    public $billing_name;
    public $address;
    public $personal_ref;
    public $grp;
    public $s_grp;
    public $product;
    public $rid;
    public $rid_1;
    public $harward_code;
    public $serial_no;
    public $invoice_no;
    public $invoice_date;
    public $first_counter;
    public $guarantee;
    public $valid_till;
    public $valid_till_counter;
    public $free_service;
    public $toner_life;
    public $drum_life;
    public $developer_life;
    public $date_install;
    public $date_start;
    public $remark;
    public $status;
    public $schedule_service_type;
    public $schedule_service_interval_days;
    public $schedule_service_updated_till;
    public $operator;
    public $datetime;
    public $copy_average_1;
    public $copy_average_2;
    public $copy_average_3;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "client_hardware_data";
        $this->TableName = 'client_hardware_data';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "client_hardware_data";
        $this->Dbid = 'DB';
        $this->ExportAll = false;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->IsForeignKey = true; // Foreign key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // customer_grp
        $this->customer_grp = new DbField(
            $this, // Table
            'x_customer_grp', // Variable name
            'customer_grp', // Name
            '`customer_grp`', // Expression
            '`customer_grp`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`customer_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->customer_grp->addMethod("getSelectFilter", fn() => "`status`=1 and `id` > 100");
        $this->customer_grp->InputTextType = "text";
        $this->customer_grp->Nullable = false; // NOT NULL field
        $this->customer_grp->Required = true; // Required field
        $this->customer_grp->Lookup = new Lookup($this->customer_grp, 'client_category', false, 'id', ["category","","",""], '', '', [], [], [], [], [], [], false, '`category` ASC', '', "`category`");
        $this->customer_grp->SearchOperators = ["=", "<>"];
        $this->Fields['customer_grp'] = &$this->customer_grp;

        // ref
        $this->ref = new DbField(
            $this, // Table
            'x_ref', // Variable name
            'ref', // Name
            '`ref`', // Expression
            '`ref`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ref->InputTextType = "text";
        $this->ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ref'] = &$this->ref;

        // partner_id
        $this->partner_id = new DbField(
            $this, // Table
            'x_partner_id', // Variable name
            'partner_id', // Name
            '`partner_id`', // Expression
            '`partner_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`partner_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->partner_id->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->partner_id->InputTextType = "text";
        $this->partner_id->Raw = true;
        $this->partner_id->Required = true; // Required field
        $this->partner_id->Lookup = new Lookup($this->partner_id, 'buyer', false, 'id', ["name","code","mobile",""], '', '', [], [], [], [], ["city_name"], ["x_city_name"], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->partner_id) . "',COALESCE(`code`,''),'" . ValueSeparator(2, $this->partner_id) . "',COALESCE(`mobile`,''))");
        $this->partner_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->partner_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['partner_id'] = &$this->partner_id;

        // name_ref
        $this->name_ref = new DbField(
            $this, // Table
            'x_name_ref', // Variable name
            'name_ref', // Name
            '`name_ref`', // Expression
            '`name_ref`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`name_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->name_ref->InputTextType = "text";
        $this->name_ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['name_ref'] = &$this->name_ref;

        // city_name
        $this->city_name = new DbField(
            $this, // Table
            'x_city_name', // Variable name
            'city_name', // Name
            '`city_name`', // Expression
            '`city_name`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`city_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->city_name->InputTextType = "text";
        $this->city_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['city_name'] = &$this->city_name;

        // area
        $this->area = new DbField(
            $this, // Table
            'x_area', // Variable name
            'area', // Name
            '`area`', // Expression
            '`area`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`area`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->area->InputTextType = "text";
        $this->area->Lookup = new Lookup($this->area, 'client_hardware_data', true, 'area', ["area","","",""], '', '', ["x_city_name"], [], ["city_name"], ["x_city_name"], [], [], false, '`area` ASC', '', "`area`");
        $this->area->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['area'] = &$this->area;

        // billing_name
        $this->billing_name = new DbField(
            $this, // Table
            'x_billing_name', // Variable name
            'billing_name', // Name
            '`billing_name`', // Expression
            '`billing_name`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`billing_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->billing_name->InputTextType = "text";
        $this->billing_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['billing_name'] = &$this->billing_name;

        // address
        $this->address = new DbField(
            $this, // Table
            'x_address', // Variable name
            'address', // Name
            '`address`', // Expression
            '`address`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`address`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->address->InputTextType = "text";
        $this->address->Nullable = false; // NOT NULL field
        $this->address->Required = true; // Required field
        $this->address->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['address'] = &$this->address;

        // personal_ref
        $this->personal_ref = new DbField(
            $this, // Table
            'x_personal_ref', // Variable name
            'personal_ref', // Name
            '`personal_ref`', // Expression
            '`personal_ref`', // Basic search expression
            200, // Type
            252, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`personal_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->personal_ref->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->personal_ref->InputTextType = "text";
        $this->personal_ref->Lookup = new Lookup($this->personal_ref, 'personal_info', false, 'id', ["formal_name","work_details","mobile",""], '', '', [], [], [], [], [], [], false, '`formal_name` ASC', '', "CONCAT(COALESCE(`formal_name`, ''),'" . ValueSeparator(1, $this->personal_ref) . "',COALESCE(`work_details`,''),'" . ValueSeparator(2, $this->personal_ref) . "',COALESCE(`mobile`,''))");
        $this->personal_ref->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['personal_ref'] = &$this->personal_ref;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->grp->addMethod("getLinkPrefix", fn() => "productcartblist?x_grp=");
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->Sortable = false; // Allow sort
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], ["x_s_grp","x_rid"], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->s_grp->addMethod("getLinkPrefix", fn() => "productcartblist?x_s_grp=");
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Nullable = false; // NOT NULL field
        $this->s_grp->Required = true; // Required field
        $this->s_grp->Sortable = false; // Allow sort
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', false, 'id', ["product_group","","",""], '', '', ["x_grp"], ["x_product","x_rid"], ["grp"], ["x_grp"], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->product->addMethod("getLinkPrefix", fn() => "productcartblist?x_product=");
        $this->product->InputTextType = "text";
        $this->product->Required = true; // Required field
        $this->product->Sortable = false; // Allow sort
        $this->product->setSelectMultiple(false); // Select one
        $this->product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product->Lookup = new Lookup($this->product, 'product_view2', true, 'id', ["product","","",""], '', '', ["x_s_grp"], ["x_rid"], ["s_grp"], ["x_s_grp"], [], [], false, '`product` ASC', '', "`product`");
        $this->product->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['product'] = &$this->product;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid->addMethod("getSelectFilter", fn() => "`status` =1");
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->Nullable = false; // NOT NULL field
        $this->rid->Required = true; // Required field
        $this->rid->Sortable = false; // Allow sort
        $this->rid->Lookup = new Lookup($this->rid, 'ref', false, 'id', ["product_code","","",""], '', '', ["x_grp","x_s_grp","x_product"], [], ["grp","s_grp","product"], ["x_grp","x_s_grp","x_product"], ["product_code","v_00"], ["x_rid_1","x_harward_code"], false, '`product_code` ASC', '', "`product_code`");
        $this->rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['rid'] = &$this->rid;

        // rid_1
        $this->rid_1 = new DbField(
            $this, // Table
            'x_rid_1', // Variable name
            'rid_1', // Name
            '`rid_1`', // Expression
            '`rid_1`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid_1`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid_1->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->rid_1->InputTextType = "text";
        $this->rid_1->Required = true; // Required field
        $this->rid_1->Sortable = false; // Allow sort
        $this->rid_1->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid_1'] = &$this->rid_1;

        // harward_code
        $this->harward_code = new DbField(
            $this, // Table
            'x_harward_code', // Variable name
            'harward_code', // Name
            '`harward_code`', // Expression
            '`harward_code`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`harward_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->harward_code->InputTextType = "text";
        $this->harward_code->Required = true; // Required field
        $this->harward_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['harward_code'] = &$this->harward_code;

        // serial_no
        $this->serial_no = new DbField(
            $this, // Table
            'x_serial_no', // Variable name
            'serial_no', // Name
            '`serial_no`', // Expression
            '`serial_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`serial_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->serial_no->InputTextType = "text";
        $this->serial_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['serial_no'] = &$this->serial_no;

        // invoice_no
        $this->invoice_no = new DbField(
            $this, // Table
            'x_invoice_no', // Variable name
            'invoice_no', // Name
            '`invoice_no`', // Expression
            '`invoice_no`', // Basic search expression
            200, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`invoice_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->invoice_no->InputTextType = "text";
        $this->invoice_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['invoice_no'] = &$this->invoice_no;

        // invoice_date
        $this->invoice_date = new DbField(
            $this, // Table
            'x_invoice_date', // Variable name
            'invoice_date', // Name
            '`invoice_date`', // Expression
            CastDateFieldForLike("`invoice_date`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`invoice_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->invoice_date->InputTextType = "text";
        $this->invoice_date->Raw = true;
        $this->invoice_date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->invoice_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['invoice_date'] = &$this->invoice_date;

        // first_counter
        $this->first_counter = new DbField(
            $this, // Table
            'x_first_counter', // Variable name
            'first_counter', // Name
            '`first_counter`', // Expression
            '`first_counter`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`first_counter`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->first_counter->InputTextType = "text";
        $this->first_counter->Raw = true;
        $this->first_counter->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->first_counter->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['first_counter'] = &$this->first_counter;

        // guarantee
        $this->guarantee = new DbField(
            $this, // Table
            'x_guarantee', // Variable name
            'guarantee', // Name
            '`guarantee`', // Expression
            '`guarantee`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`guarantee`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->guarantee->InputTextType = "text";
        $this->guarantee->Raw = true;
        $this->guarantee->setSelectMultiple(false); // Select one
        $this->guarantee->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->guarantee->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->guarantee->Lookup = new Lookup($this->guarantee, 'client_hardware_data', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->guarantee->OptionCount = 3;
        $this->guarantee->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->guarantee->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['guarantee'] = &$this->guarantee;

        // valid_till
        $this->valid_till = new DbField(
            $this, // Table
            'x_valid_till', // Variable name
            'valid_till', // Name
            '`valid_till`', // Expression
            CastDateFieldForLike("`valid_till`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`valid_till`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->valid_till->InputTextType = "text";
        $this->valid_till->Raw = true;
        $this->valid_till->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->valid_till->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['valid_till'] = &$this->valid_till;

        // valid_till_counter
        $this->valid_till_counter = new DbField(
            $this, // Table
            'x_valid_till_counter', // Variable name
            'valid_till_counter', // Name
            '`valid_till_counter`', // Expression
            '`valid_till_counter`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`valid_till_counter`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->valid_till_counter->InputTextType = "text";
        $this->valid_till_counter->Raw = true;
        $this->valid_till_counter->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->valid_till_counter->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['valid_till_counter'] = &$this->valid_till_counter;

        // free_service
        $this->free_service = new DbField(
            $this, // Table
            'x_free_service', // Variable name
            'free_service', // Name
            '`free_service`', // Expression
            '`free_service`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`free_service`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->free_service->InputTextType = "text";
        $this->free_service->Raw = true;
        $this->free_service->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->free_service->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['free_service'] = &$this->free_service;

        // toner_life
        $this->toner_life = new DbField(
            $this, // Table
            'x_toner_life', // Variable name
            'toner_life', // Name
            '`toner_life`', // Expression
            '`toner_life`', // Basic search expression
            3, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`toner_life`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->toner_life->InputTextType = "text";
        $this->toner_life->Raw = true;
        $this->toner_life->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->toner_life->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['toner_life'] = &$this->toner_life;

        // drum_life
        $this->drum_life = new DbField(
            $this, // Table
            'x_drum_life', // Variable name
            'drum_life', // Name
            '`drum_life`', // Expression
            '`drum_life`', // Basic search expression
            3, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`drum_life`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->drum_life->InputTextType = "text";
        $this->drum_life->Raw = true;
        $this->drum_life->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->drum_life->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['drum_life'] = &$this->drum_life;

        // developer_life
        $this->developer_life = new DbField(
            $this, // Table
            'x_developer_life', // Variable name
            'developer_life', // Name
            '`developer_life`', // Expression
            '`developer_life`', // Basic search expression
            3, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`developer_life`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->developer_life->InputTextType = "text";
        $this->developer_life->Raw = true;
        $this->developer_life->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->developer_life->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['developer_life'] = &$this->developer_life;

        // date_install
        $this->date_install = new DbField(
            $this, // Table
            'x_date_install', // Variable name
            'date_install', // Name
            '`date_install`', // Expression
            CastDateFieldForLike("`date_install`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`date_install`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->date_install->InputTextType = "text";
        $this->date_install->Raw = true;
        $this->date_install->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->date_install->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['date_install'] = &$this->date_install;

        // date_start
        $this->date_start = new DbField(
            $this, // Table
            'x_date_start', // Variable name
            'date_start', // Name
            '`date_start`', // Expression
            CastDateFieldForLike("`date_start`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`date_start`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->date_start->InputTextType = "text";
        $this->date_start->Raw = true;
        $this->date_start->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->date_start->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['date_start'] = &$this->date_start;

        // remark
        $this->remark = new DbField(
            $this, // Table
            'x_remark', // Variable name
            'remark', // Name
            '`remark`', // Expression
            '`remark`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remark`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remark->InputTextType = "text";
        $this->remark->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remark'] = &$this->remark;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Nullable = false; // NOT NULL field
        $this->status->Required = true; // Required field
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'client_hardware_data', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 2;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status'] = &$this->status;

        // schedule_service_type
        $this->schedule_service_type = new DbField(
            $this, // Table
            'x_schedule_service_type', // Variable name
            'schedule_service_type', // Name
            '`schedule_service_type`', // Expression
            '`schedule_service_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`schedule_service_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->schedule_service_type->addMethod("getSelectFilter", fn() => "`grp`=11  and `status` = 1");
        $this->schedule_service_type->InputTextType = "text";
        $this->schedule_service_type->Raw = true;
        $this->schedule_service_type->Nullable = false; // NOT NULL field
        $this->schedule_service_type->Required = true; // Required field
        $this->schedule_service_type->setSelectMultiple(false); // Select one
        $this->schedule_service_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->schedule_service_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->schedule_service_type->Lookup = new Lookup($this->schedule_service_type, 'service_misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->schedule_service_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->schedule_service_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['schedule_service_type'] = &$this->schedule_service_type;

        // schedule_service_interval_days
        $this->schedule_service_interval_days = new DbField(
            $this, // Table
            'x_schedule_service_interval_days', // Variable name
            'schedule_service_interval_days', // Name
            '`schedule_service_interval_days`', // Expression
            '`schedule_service_interval_days`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`schedule_service_interval_days`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->schedule_service_interval_days->InputTextType = "number";
        $this->schedule_service_interval_days->Raw = true;
        $this->schedule_service_interval_days->Nullable = false; // NOT NULL field
        $this->schedule_service_interval_days->Required = true; // Required field
        $this->schedule_service_interval_days->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->schedule_service_interval_days->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['schedule_service_interval_days'] = &$this->schedule_service_interval_days;

        // schedule_service_updated_till
        $this->schedule_service_updated_till = new DbField(
            $this, // Table
            'x_schedule_service_updated_till', // Variable name
            'schedule_service_updated_till', // Name
            '`schedule_service_updated_till`', // Expression
            CastDateFieldForLike("`schedule_service_updated_till`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`schedule_service_updated_till`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->schedule_service_updated_till->InputTextType = "text";
        $this->schedule_service_updated_till->Raw = true;
        $this->schedule_service_updated_till->Nullable = false; // NOT NULL field
        $this->schedule_service_updated_till->Required = true; // Required field
        $this->schedule_service_updated_till->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->schedule_service_updated_till->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['schedule_service_updated_till'] = &$this->schedule_service_updated_till;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 7, "DB"), // Basic search expression
            135, // Type
            19, // Size
            7, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // copy_average_1
        $this->copy_average_1 = new DbField(
            $this, // Table
            'x_copy_average_1', // Variable name
            'copy_average_1', // Name
            '`copy_average_1`', // Expression
            '`copy_average_1`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`copy_average_1`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->copy_average_1->InputTextType = "text";
        $this->copy_average_1->Raw = true;
        $this->copy_average_1->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->copy_average_1->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['copy_average_1'] = &$this->copy_average_1;

        // copy_average_2
        $this->copy_average_2 = new DbField(
            $this, // Table
            'x_copy_average_2', // Variable name
            'copy_average_2', // Name
            '`copy_average_2`', // Expression
            '`copy_average_2`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`copy_average_2`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->copy_average_2->InputTextType = "text";
        $this->copy_average_2->Raw = true;
        $this->copy_average_2->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->copy_average_2->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['copy_average_2'] = &$this->copy_average_2;

        // copy_average_3
        $this->copy_average_3 = new DbField(
            $this, // Table
            'x_copy_average_3', // Variable name
            'copy_average_3', // Name
            '`copy_average_3`', // Expression
            '`copy_average_3`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`copy_average_3`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->copy_average_3->InputTextType = "text";
        $this->copy_average_3->Raw = true;
        $this->copy_average_3->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->copy_average_3->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['copy_average_3'] = &$this->copy_average_3;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current detail table name
    public function getCurrentDetailTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")) ?? "";
    }

    public function setCurrentDetailTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
    }

    // Get detail url
    public function getDetailUrl()
    {
        // Detail url
        $detailUrl = "";
        if ($this->getCurrentDetailTable() == "service_schedule") {
            $detailUrl = Container("service_schedule")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue);
        }
        if ($detailUrl == "") {
            $detailUrl = "clienthardwaredatalist";
        }
        return $detailUrl;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "client_hardware_data";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->customer_grp->DbValue = $row['customer_grp'];
        $this->ref->DbValue = $row['ref'];
        $this->partner_id->DbValue = $row['partner_id'];
        $this->name_ref->DbValue = $row['name_ref'];
        $this->city_name->DbValue = $row['city_name'];
        $this->area->DbValue = $row['area'];
        $this->billing_name->DbValue = $row['billing_name'];
        $this->address->DbValue = $row['address'];
        $this->personal_ref->DbValue = $row['personal_ref'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->product->DbValue = $row['product'];
        $this->rid->DbValue = $row['rid'];
        $this->rid_1->DbValue = $row['rid_1'];
        $this->harward_code->DbValue = $row['harward_code'];
        $this->serial_no->DbValue = $row['serial_no'];
        $this->invoice_no->DbValue = $row['invoice_no'];
        $this->invoice_date->DbValue = $row['invoice_date'];
        $this->first_counter->DbValue = $row['first_counter'];
        $this->guarantee->DbValue = $row['guarantee'];
        $this->valid_till->DbValue = $row['valid_till'];
        $this->valid_till_counter->DbValue = $row['valid_till_counter'];
        $this->free_service->DbValue = $row['free_service'];
        $this->toner_life->DbValue = $row['toner_life'];
        $this->drum_life->DbValue = $row['drum_life'];
        $this->developer_life->DbValue = $row['developer_life'];
        $this->date_install->DbValue = $row['date_install'];
        $this->date_start->DbValue = $row['date_start'];
        $this->remark->DbValue = $row['remark'];
        $this->status->DbValue = $row['status'];
        $this->schedule_service_type->DbValue = $row['schedule_service_type'];
        $this->schedule_service_interval_days->DbValue = $row['schedule_service_interval_days'];
        $this->schedule_service_updated_till->DbValue = $row['schedule_service_updated_till'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->copy_average_1->DbValue = $row['copy_average_1'];
        $this->copy_average_2->DbValue = $row['copy_average_2'];
        $this->copy_average_3->DbValue = $row['copy_average_3'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("clienthardwaredatalist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "clienthardwaredataview" => $Language->phrase("View"),
            "clienthardwaredataedit" => $Language->phrase("Edit"),
            "clienthardwaredataadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "clienthardwaredatalist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ClientHardwareDataView",
            Config("API_ADD_ACTION") => "ClientHardwareDataAdd",
            Config("API_EDIT_ACTION") => "ClientHardwareDataEdit",
            Config("API_DELETE_ACTION") => "ClientHardwareDataDelete",
            Config("API_LIST_ACTION") => "ClientHardwareDataList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "clienthardwaredatalist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("clienthardwaredataview", $parm);
        } else {
            $url = $this->keyUrl("clienthardwaredataview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "clienthardwaredataadd?" . $parm;
        } else {
            $url = "clienthardwaredataadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("clienthardwaredataedit", $parm);
        } else {
            $url = $this->keyUrl("clienthardwaredataedit", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("clienthardwaredatalist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("clienthardwaredataadd", $parm);
        } else {
            $url = $this->keyUrl("clienthardwaredataadd", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("clienthardwaredatalist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("clienthardwaredatadelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->customer_grp->setDbValue($row['customer_grp']);
        $this->ref->setDbValue($row['ref']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->name_ref->setDbValue($row['name_ref']);
        $this->city_name->setDbValue($row['city_name']);
        $this->area->setDbValue($row['area']);
        $this->billing_name->setDbValue($row['billing_name']);
        $this->address->setDbValue($row['address']);
        $this->personal_ref->setDbValue($row['personal_ref']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->harward_code->setDbValue($row['harward_code']);
        $this->serial_no->setDbValue($row['serial_no']);
        $this->invoice_no->setDbValue($row['invoice_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->first_counter->setDbValue($row['first_counter']);
        $this->guarantee->setDbValue($row['guarantee']);
        $this->valid_till->setDbValue($row['valid_till']);
        $this->valid_till_counter->setDbValue($row['valid_till_counter']);
        $this->free_service->setDbValue($row['free_service']);
        $this->toner_life->setDbValue($row['toner_life']);
        $this->drum_life->setDbValue($row['drum_life']);
        $this->developer_life->setDbValue($row['developer_life']);
        $this->date_install->setDbValue($row['date_install']);
        $this->date_start->setDbValue($row['date_start']);
        $this->remark->setDbValue($row['remark']);
        $this->status->setDbValue($row['status']);
        $this->schedule_service_type->setDbValue($row['schedule_service_type']);
        $this->schedule_service_interval_days->setDbValue($row['schedule_service_interval_days']);
        $this->schedule_service_updated_till->setDbValue($row['schedule_service_updated_till']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->copy_average_1->setDbValue($row['copy_average_1']);
        $this->copy_average_2->setDbValue($row['copy_average_2']);
        $this->copy_average_3->setDbValue($row['copy_average_3']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ClientHardwareDataList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // customer_grp

        // ref

        // partner_id

        // name_ref

        // city_name

        // area

        // billing_name

        // address

        // personal_ref

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // product
        $this->product->CellCssStyle = "white-space: nowrap;";

        // rid
        $this->rid->CellCssStyle = "white-space: nowrap;";

        // rid_1
        $this->rid_1->CellCssStyle = "white-space: nowrap;";

        // harward_code

        // serial_no

        // invoice_no

        // invoice_date

        // first_counter

        // guarantee

        // valid_till

        // valid_till_counter

        // free_service

        // toner_life

        // drum_life

        // developer_life

        // date_install

        // date_start

        // remark

        // status

        // schedule_service_type

        // schedule_service_interval_days

        // schedule_service_updated_till

        // operator

        // datetime

        // copy_average_1

        // copy_average_2

        // copy_average_3

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // customer_grp
        $curVal = strval($this->customer_grp->CurrentValue);
        if ($curVal != "") {
            $this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
            if ($this->customer_grp->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->customer_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->customer_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->customer_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->customer_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->customer_grp->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->customer_grp->Lookup->renderViewRow($row);
                        $this->customer_grp->ViewValue->add($this->customer_grp->displayValue($arwrk));
                    }
                } else {
                    $this->customer_grp->ViewValue = $this->customer_grp->CurrentValue;
                }
            }
        } else {
            $this->customer_grp->ViewValue = null;
        }

        // ref
        $this->ref->ViewValue = $this->ref->CurrentValue;

        // partner_id
        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
        $curVal = strval($this->partner_id->CurrentValue);
        if ($curVal != "") {
            $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
            if ($this->partner_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                    $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                } else {
                    $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                }
            }
        } else {
            $this->partner_id->ViewValue = null;
        }

        // name_ref
        $this->name_ref->ViewValue = $this->name_ref->CurrentValue;

        // city_name
        $this->city_name->ViewValue = $this->city_name->CurrentValue;

        // area
        $this->area->ViewValue = $this->area->CurrentValue;

        // billing_name
        $this->billing_name->ViewValue = $this->billing_name->CurrentValue;

        // address
        $this->address->ViewValue = $this->address->CurrentValue;

        // personal_ref
        $curVal = strval($this->personal_ref->CurrentValue);
        if ($curVal != "") {
            $this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
            if ($this->personal_ref->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->personal_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->personal_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->personal_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->personal_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->personal_ref->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->personal_ref->Lookup->renderViewRow($row);
                        $this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
                    }
                } else {
                    $this->personal_ref->ViewValue = $this->personal_ref->CurrentValue;
                }
            }
        } else {
            $this->personal_ref->ViewValue = null;
        }

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = $this->grp->CurrentValue;
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $this->product->CurrentValue;
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // rid
        $this->rid->ViewValue = $this->rid->CurrentValue;
        $curVal = strval($this->rid->CurrentValue);
        if ($curVal != "") {
            $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
            if ($this->rid->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                    $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                } else {
                    $this->rid->ViewValue = $this->rid->CurrentValue;
                }
            }
        } else {
            $this->rid->ViewValue = null;
        }

        // rid_1
        $this->rid_1->ViewValue = $this->rid_1->CurrentValue;

        // harward_code
        $this->harward_code->ViewValue = $this->harward_code->CurrentValue;

        // serial_no
        $this->serial_no->ViewValue = $this->serial_no->CurrentValue;

        // invoice_no
        $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;

        // invoice_date
        $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
        $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

        // first_counter
        $this->first_counter->ViewValue = $this->first_counter->CurrentValue;
        $this->first_counter->ViewValue = FormatNumber($this->first_counter->ViewValue, $this->first_counter->formatPattern());

        // guarantee
        if (strval($this->guarantee->CurrentValue) != "") {
            $this->guarantee->ViewValue = $this->guarantee->optionCaption($this->guarantee->CurrentValue);
        } else {
            $this->guarantee->ViewValue = null;
        }

        // valid_till
        $this->valid_till->ViewValue = $this->valid_till->CurrentValue;
        $this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, $this->valid_till->formatPattern());

        // valid_till_counter
        $this->valid_till_counter->ViewValue = $this->valid_till_counter->CurrentValue;
        $this->valid_till_counter->ViewValue = FormatNumber($this->valid_till_counter->ViewValue, $this->valid_till_counter->formatPattern());

        // free_service
        $this->free_service->ViewValue = $this->free_service->CurrentValue;
        $this->free_service->ViewValue = FormatNumber($this->free_service->ViewValue, $this->free_service->formatPattern());

        // toner_life
        $this->toner_life->ViewValue = $this->toner_life->CurrentValue;
        $this->toner_life->ViewValue = FormatNumber($this->toner_life->ViewValue, $this->toner_life->formatPattern());

        // drum_life
        $this->drum_life->ViewValue = $this->drum_life->CurrentValue;
        $this->drum_life->ViewValue = FormatNumber($this->drum_life->ViewValue, $this->drum_life->formatPattern());

        // developer_life
        $this->developer_life->ViewValue = $this->developer_life->CurrentValue;
        $this->developer_life->ViewValue = FormatNumber($this->developer_life->ViewValue, $this->developer_life->formatPattern());

        // date_install
        $this->date_install->ViewValue = $this->date_install->CurrentValue;
        $this->date_install->ViewValue = FormatDateTime($this->date_install->ViewValue, $this->date_install->formatPattern());

        // date_start
        $this->date_start->ViewValue = $this->date_start->CurrentValue;
        $this->date_start->ViewValue = FormatDateTime($this->date_start->ViewValue, $this->date_start->formatPattern());

        // remark
        $this->remark->ViewValue = $this->remark->CurrentValue;

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // schedule_service_type
        $curVal = strval($this->schedule_service_type->CurrentValue);
        if ($curVal != "") {
            $this->schedule_service_type->ViewValue = $this->schedule_service_type->lookupCacheOption($curVal);
            if ($this->schedule_service_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->schedule_service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->schedule_service_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->schedule_service_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->schedule_service_type->Lookup->renderViewRow($rswrk[0]);
                    $this->schedule_service_type->ViewValue = $this->schedule_service_type->displayValue($arwrk);
                } else {
                    $this->schedule_service_type->ViewValue = FormatNumber($this->schedule_service_type->CurrentValue, $this->schedule_service_type->formatPattern());
                }
            }
        } else {
            $this->schedule_service_type->ViewValue = null;
        }

        // schedule_service_interval_days
        $this->schedule_service_interval_days->ViewValue = $this->schedule_service_interval_days->CurrentValue;
        $this->schedule_service_interval_days->ViewValue = FormatNumber($this->schedule_service_interval_days->ViewValue, $this->schedule_service_interval_days->formatPattern());

        // schedule_service_updated_till
        $this->schedule_service_updated_till->ViewValue = $this->schedule_service_updated_till->CurrentValue;
        $this->schedule_service_updated_till->ViewValue = FormatDateTime($this->schedule_service_updated_till->ViewValue, $this->schedule_service_updated_till->formatPattern());

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // copy_average_1
        $this->copy_average_1->ViewValue = $this->copy_average_1->CurrentValue;
        $this->copy_average_1->ViewValue = FormatNumber($this->copy_average_1->ViewValue, $this->copy_average_1->formatPattern());

        // copy_average_2
        $this->copy_average_2->ViewValue = $this->copy_average_2->CurrentValue;
        $this->copy_average_2->ViewValue = FormatNumber($this->copy_average_2->ViewValue, $this->copy_average_2->formatPattern());

        // copy_average_3
        $this->copy_average_3->ViewValue = $this->copy_average_3->CurrentValue;
        $this->copy_average_3->ViewValue = FormatNumber($this->copy_average_3->ViewValue, $this->copy_average_3->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // customer_grp
        $this->customer_grp->HrefValue = "";
        $this->customer_grp->TooltipValue = "";

        // ref
        $this->ref->HrefValue = "";
        $this->ref->TooltipValue = "";

        // partner_id
        $this->partner_id->HrefValue = "";
        $this->partner_id->TooltipValue = "";

        // name_ref
        $this->name_ref->HrefValue = "";
        $this->name_ref->TooltipValue = "";

        // city_name
        $this->city_name->HrefValue = "";
        $this->city_name->TooltipValue = "";

        // area
        $this->area->HrefValue = "";
        $this->area->TooltipValue = "";

        // billing_name
        $this->billing_name->HrefValue = "";
        $this->billing_name->TooltipValue = "";

        // address
        $this->address->HrefValue = "";
        $this->address->TooltipValue = "";

        // personal_ref
        $this->personal_ref->HrefValue = "";
        $this->personal_ref->TooltipValue = "";

        // grp
        if (!EmptyValue($this->grp->CurrentValue)) {
            $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
            $this->grp->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
            }
        } else {
            $this->grp->HrefValue = "";
        }
        $this->grp->TooltipValue = "";

        // s_grp
        if (!EmptyValue($this->s_grp->CurrentValue)) {
            $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
            $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
            }
        } else {
            $this->s_grp->HrefValue = "";
        }
        $this->s_grp->TooltipValue = "";

        // product
        if (!EmptyValue($this->product->CurrentValue)) {
            $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
            $this->product->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
            }
        } else {
            $this->product->HrefValue = "";
        }
        $this->product->TooltipValue = "";

        // rid
        $this->rid->HrefValue = "";
        $this->rid->TooltipValue = "";

        // rid_1
        $this->rid_1->HrefValue = "";
        $this->rid_1->TooltipValue = "";

        // harward_code
        $this->harward_code->HrefValue = "";
        $this->harward_code->TooltipValue = "";

        // serial_no
        $this->serial_no->HrefValue = "";
        $this->serial_no->TooltipValue = "";

        // invoice_no
        $this->invoice_no->HrefValue = "";
        $this->invoice_no->TooltipValue = "";

        // invoice_date
        $this->invoice_date->HrefValue = "";
        $this->invoice_date->TooltipValue = "";

        // first_counter
        $this->first_counter->HrefValue = "";
        $this->first_counter->TooltipValue = "";

        // guarantee
        $this->guarantee->HrefValue = "";
        $this->guarantee->TooltipValue = "";

        // valid_till
        $this->valid_till->HrefValue = "";
        $this->valid_till->TooltipValue = "";

        // valid_till_counter
        $this->valid_till_counter->HrefValue = "";
        $this->valid_till_counter->TooltipValue = "";

        // free_service
        $this->free_service->HrefValue = "";
        $this->free_service->TooltipValue = "";

        // toner_life
        $this->toner_life->HrefValue = "";
        $this->toner_life->TooltipValue = "";

        // drum_life
        $this->drum_life->HrefValue = "";
        $this->drum_life->TooltipValue = "";

        // developer_life
        $this->developer_life->HrefValue = "";
        $this->developer_life->TooltipValue = "";

        // date_install
        $this->date_install->HrefValue = "";
        $this->date_install->TooltipValue = "";

        // date_start
        $this->date_start->HrefValue = "";
        $this->date_start->TooltipValue = "";

        // remark
        $this->remark->HrefValue = "";
        $this->remark->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // schedule_service_type
        $this->schedule_service_type->HrefValue = "";
        $this->schedule_service_type->TooltipValue = "";

        // schedule_service_interval_days
        $this->schedule_service_interval_days->HrefValue = "";
        $this->schedule_service_interval_days->TooltipValue = "";

        // schedule_service_updated_till
        $this->schedule_service_updated_till->HrefValue = "";
        $this->schedule_service_updated_till->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // copy_average_1
        $this->copy_average_1->HrefValue = "";
        $this->copy_average_1->TooltipValue = "";

        // copy_average_2
        $this->copy_average_2->HrefValue = "";
        $this->copy_average_2->TooltipValue = "";

        // copy_average_3
        $this->copy_average_3->HrefValue = "";
        $this->copy_average_3->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // customer_grp
        $this->customer_grp->PlaceHolder = RemoveHtml($this->customer_grp->caption());

        // ref
        $this->ref->setupEditAttributes();
        if (!$this->ref->Raw) {
            $this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
        }
        $this->ref->EditValue = $this->ref->CurrentValue;
        $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

        // partner_id
        $this->partner_id->setupEditAttributes();
        $this->partner_id->EditValue = $this->partner_id->CurrentValue;
        $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

        // name_ref
        $this->name_ref->setupEditAttributes();
        if (!$this->name_ref->Raw) {
            $this->name_ref->CurrentValue = HtmlDecode($this->name_ref->CurrentValue);
        }
        $this->name_ref->EditValue = $this->name_ref->CurrentValue;
        $this->name_ref->PlaceHolder = RemoveHtml($this->name_ref->caption());

        // city_name
        $this->city_name->setupEditAttributes();
        if (!$this->city_name->Raw) {
            $this->city_name->CurrentValue = HtmlDecode($this->city_name->CurrentValue);
        }
        $this->city_name->EditValue = $this->city_name->CurrentValue;
        $this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

        // area
        $this->area->setupEditAttributes();
        if (!$this->area->Raw) {
            $this->area->CurrentValue = HtmlDecode($this->area->CurrentValue);
        }
        $this->area->EditValue = $this->area->CurrentValue;
        $this->area->PlaceHolder = RemoveHtml($this->area->caption());

        // billing_name
        $this->billing_name->setupEditAttributes();
        if (!$this->billing_name->Raw) {
            $this->billing_name->CurrentValue = HtmlDecode($this->billing_name->CurrentValue);
        }
        $this->billing_name->EditValue = $this->billing_name->CurrentValue;
        $this->billing_name->PlaceHolder = RemoveHtml($this->billing_name->caption());

        // address
        $this->address->setupEditAttributes();
        $this->address->EditValue = $this->address->CurrentValue;
        $this->address->PlaceHolder = RemoveHtml($this->address->caption());

        // personal_ref
        $this->personal_ref->PlaceHolder = RemoveHtml($this->personal_ref->caption());

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

        // product
        $this->product->setupEditAttributes();
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());

        // rid
        $this->rid->setupEditAttributes();
        $this->rid->EditValue = $this->rid->CurrentValue;
        $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

        // rid_1
        $this->rid_1->setupEditAttributes();
        $this->rid_1->EditCustomAttributes = $this->rid_1->getEditCustomAttributes(); // PHP
        if (!$this->rid_1->Raw) {
            $this->rid_1->CurrentValue = HtmlDecode($this->rid_1->CurrentValue);
        }
        $this->rid_1->EditValue = $this->rid_1->CurrentValue;
        $this->rid_1->PlaceHolder = RemoveHtml($this->rid_1->caption());

        // harward_code
        $this->harward_code->setupEditAttributes();
        if (!$this->harward_code->Raw) {
            $this->harward_code->CurrentValue = HtmlDecode($this->harward_code->CurrentValue);
        }
        $this->harward_code->EditValue = $this->harward_code->CurrentValue;
        $this->harward_code->PlaceHolder = RemoveHtml($this->harward_code->caption());

        // serial_no
        $this->serial_no->setupEditAttributes();
        if (!$this->serial_no->Raw) {
            $this->serial_no->CurrentValue = HtmlDecode($this->serial_no->CurrentValue);
        }
        $this->serial_no->EditValue = $this->serial_no->CurrentValue;
        $this->serial_no->PlaceHolder = RemoveHtml($this->serial_no->caption());

        // invoice_no
        $this->invoice_no->setupEditAttributes();
        if (!$this->invoice_no->Raw) {
            $this->invoice_no->CurrentValue = HtmlDecode($this->invoice_no->CurrentValue);
        }
        $this->invoice_no->EditValue = $this->invoice_no->CurrentValue;
        $this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

        // invoice_date
        $this->invoice_date->setupEditAttributes();
        $this->invoice_date->EditValue = FormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern());
        $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

        // first_counter
        $this->first_counter->setupEditAttributes();
        $this->first_counter->EditValue = $this->first_counter->CurrentValue;
        $this->first_counter->PlaceHolder = RemoveHtml($this->first_counter->caption());
        if (strval($this->first_counter->EditValue) != "" && is_numeric($this->first_counter->EditValue)) {
            $this->first_counter->EditValue = FormatNumber($this->first_counter->EditValue, null);
        }

        // guarantee
        $this->guarantee->setupEditAttributes();
        $this->guarantee->EditValue = $this->guarantee->options(true);
        $this->guarantee->PlaceHolder = RemoveHtml($this->guarantee->caption());

        // valid_till
        $this->valid_till->setupEditAttributes();
        $this->valid_till->EditValue = FormatDateTime($this->valid_till->CurrentValue, $this->valid_till->formatPattern());
        $this->valid_till->PlaceHolder = RemoveHtml($this->valid_till->caption());

        // valid_till_counter
        $this->valid_till_counter->setupEditAttributes();
        $this->valid_till_counter->EditValue = $this->valid_till_counter->CurrentValue;
        $this->valid_till_counter->PlaceHolder = RemoveHtml($this->valid_till_counter->caption());
        if (strval($this->valid_till_counter->EditValue) != "" && is_numeric($this->valid_till_counter->EditValue)) {
            $this->valid_till_counter->EditValue = FormatNumber($this->valid_till_counter->EditValue, null);
        }

        // free_service
        $this->free_service->setupEditAttributes();
        $this->free_service->EditValue = $this->free_service->CurrentValue;
        $this->free_service->PlaceHolder = RemoveHtml($this->free_service->caption());
        if (strval($this->free_service->EditValue) != "" && is_numeric($this->free_service->EditValue)) {
            $this->free_service->EditValue = FormatNumber($this->free_service->EditValue, null);
        }

        // toner_life
        $this->toner_life->setupEditAttributes();
        $this->toner_life->EditValue = $this->toner_life->CurrentValue;
        $this->toner_life->PlaceHolder = RemoveHtml($this->toner_life->caption());
        if (strval($this->toner_life->EditValue) != "" && is_numeric($this->toner_life->EditValue)) {
            $this->toner_life->EditValue = FormatNumber($this->toner_life->EditValue, null);
        }

        // drum_life
        $this->drum_life->setupEditAttributes();
        $this->drum_life->EditValue = $this->drum_life->CurrentValue;
        $this->drum_life->PlaceHolder = RemoveHtml($this->drum_life->caption());
        if (strval($this->drum_life->EditValue) != "" && is_numeric($this->drum_life->EditValue)) {
            $this->drum_life->EditValue = FormatNumber($this->drum_life->EditValue, null);
        }

        // developer_life
        $this->developer_life->setupEditAttributes();
        $this->developer_life->EditValue = $this->developer_life->CurrentValue;
        $this->developer_life->PlaceHolder = RemoveHtml($this->developer_life->caption());
        if (strval($this->developer_life->EditValue) != "" && is_numeric($this->developer_life->EditValue)) {
            $this->developer_life->EditValue = FormatNumber($this->developer_life->EditValue, null);
        }

        // date_install
        $this->date_install->setupEditAttributes();
        $this->date_install->EditValue = FormatDateTime($this->date_install->CurrentValue, $this->date_install->formatPattern());
        $this->date_install->PlaceHolder = RemoveHtml($this->date_install->caption());

        // date_start
        $this->date_start->setupEditAttributes();
        $this->date_start->EditValue = FormatDateTime($this->date_start->CurrentValue, $this->date_start->formatPattern());
        $this->date_start->PlaceHolder = RemoveHtml($this->date_start->caption());

        // remark
        $this->remark->setupEditAttributes();
        if (!$this->remark->Raw) {
            $this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
        }
        $this->remark->EditValue = $this->remark->CurrentValue;
        $this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // schedule_service_type
        $this->schedule_service_type->setupEditAttributes();
        $this->schedule_service_type->PlaceHolder = RemoveHtml($this->schedule_service_type->caption());

        // schedule_service_interval_days
        $this->schedule_service_interval_days->setupEditAttributes(["step" => "1"]);
        $this->schedule_service_interval_days->EditValue = $this->schedule_service_interval_days->CurrentValue;
        $this->schedule_service_interval_days->PlaceHolder = RemoveHtml($this->schedule_service_interval_days->caption());
        if (strval($this->schedule_service_interval_days->EditValue) != "" && is_numeric($this->schedule_service_interval_days->EditValue)) {
            $this->schedule_service_interval_days->EditValue = FormatNumber($this->schedule_service_interval_days->EditValue, null);
        }

        // schedule_service_updated_till
        $this->schedule_service_updated_till->setupEditAttributes();
        $this->schedule_service_updated_till->EditValue = FormatDateTime($this->schedule_service_updated_till->CurrentValue, $this->schedule_service_updated_till->formatPattern());
        $this->schedule_service_updated_till->PlaceHolder = RemoveHtml($this->schedule_service_updated_till->caption());

        // operator

        // datetime

        // copy_average_1
        $this->copy_average_1->setupEditAttributes();
        $this->copy_average_1->EditValue = $this->copy_average_1->CurrentValue;
        $this->copy_average_1->PlaceHolder = RemoveHtml($this->copy_average_1->caption());
        if (strval($this->copy_average_1->EditValue) != "" && is_numeric($this->copy_average_1->EditValue)) {
            $this->copy_average_1->EditValue = FormatNumber($this->copy_average_1->EditValue, null);
        }

        // copy_average_2
        $this->copy_average_2->setupEditAttributes();
        $this->copy_average_2->EditValue = $this->copy_average_2->CurrentValue;
        $this->copy_average_2->PlaceHolder = RemoveHtml($this->copy_average_2->caption());
        if (strval($this->copy_average_2->EditValue) != "" && is_numeric($this->copy_average_2->EditValue)) {
            $this->copy_average_2->EditValue = FormatNumber($this->copy_average_2->EditValue, null);
        }

        // copy_average_3
        $this->copy_average_3->setupEditAttributes();
        $this->copy_average_3->EditValue = $this->copy_average_3->CurrentValue;
        $this->copy_average_3->PlaceHolder = RemoveHtml($this->copy_average_3->caption());
        if (strval($this->copy_average_3->EditValue) != "" && is_numeric($this->copy_average_3->EditValue)) {
            $this->copy_average_3->EditValue = FormatNumber($this->copy_average_3->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->customer_grp);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->partner_id);
                    $doc->exportCaption($this->name_ref);
                    $doc->exportCaption($this->city_name);
                    $doc->exportCaption($this->area);
                    $doc->exportCaption($this->billing_name);
                    $doc->exportCaption($this->address);
                    $doc->exportCaption($this->personal_ref);
                    $doc->exportCaption($this->harward_code);
                    $doc->exportCaption($this->serial_no);
                    $doc->exportCaption($this->invoice_no);
                    $doc->exportCaption($this->invoice_date);
                    $doc->exportCaption($this->first_counter);
                    $doc->exportCaption($this->guarantee);
                    $doc->exportCaption($this->valid_till);
                    $doc->exportCaption($this->valid_till_counter);
                    $doc->exportCaption($this->free_service);
                    $doc->exportCaption($this->toner_life);
                    $doc->exportCaption($this->drum_life);
                    $doc->exportCaption($this->developer_life);
                    $doc->exportCaption($this->date_install);
                    $doc->exportCaption($this->date_start);
                    $doc->exportCaption($this->remark);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->schedule_service_type);
                    $doc->exportCaption($this->schedule_service_interval_days);
                    $doc->exportCaption($this->schedule_service_updated_till);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->copy_average_1);
                    $doc->exportCaption($this->copy_average_2);
                    $doc->exportCaption($this->copy_average_3);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->customer_grp);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->partner_id);
                    $doc->exportCaption($this->name_ref);
                    $doc->exportCaption($this->city_name);
                    $doc->exportCaption($this->area);
                    $doc->exportCaption($this->billing_name);
                    $doc->exportCaption($this->address);
                    $doc->exportCaption($this->personal_ref);
                    $doc->exportCaption($this->harward_code);
                    $doc->exportCaption($this->serial_no);
                    $doc->exportCaption($this->invoice_no);
                    $doc->exportCaption($this->invoice_date);
                    $doc->exportCaption($this->first_counter);
                    $doc->exportCaption($this->guarantee);
                    $doc->exportCaption($this->valid_till);
                    $doc->exportCaption($this->valid_till_counter);
                    $doc->exportCaption($this->free_service);
                    $doc->exportCaption($this->toner_life);
                    $doc->exportCaption($this->drum_life);
                    $doc->exportCaption($this->developer_life);
                    $doc->exportCaption($this->date_install);
                    $doc->exportCaption($this->date_start);
                    $doc->exportCaption($this->remark);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->schedule_service_type);
                    $doc->exportCaption($this->schedule_service_interval_days);
                    $doc->exportCaption($this->schedule_service_updated_till);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->copy_average_1);
                    $doc->exportCaption($this->copy_average_2);
                    $doc->exportCaption($this->copy_average_3);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->customer_grp);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->partner_id);
                        $doc->exportField($this->name_ref);
                        $doc->exportField($this->city_name);
                        $doc->exportField($this->area);
                        $doc->exportField($this->billing_name);
                        $doc->exportField($this->address);
                        $doc->exportField($this->personal_ref);
                        $doc->exportField($this->harward_code);
                        $doc->exportField($this->serial_no);
                        $doc->exportField($this->invoice_no);
                        $doc->exportField($this->invoice_date);
                        $doc->exportField($this->first_counter);
                        $doc->exportField($this->guarantee);
                        $doc->exportField($this->valid_till);
                        $doc->exportField($this->valid_till_counter);
                        $doc->exportField($this->free_service);
                        $doc->exportField($this->toner_life);
                        $doc->exportField($this->drum_life);
                        $doc->exportField($this->developer_life);
                        $doc->exportField($this->date_install);
                        $doc->exportField($this->date_start);
                        $doc->exportField($this->remark);
                        $doc->exportField($this->status);
                        $doc->exportField($this->schedule_service_type);
                        $doc->exportField($this->schedule_service_interval_days);
                        $doc->exportField($this->schedule_service_updated_till);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->copy_average_1);
                        $doc->exportField($this->copy_average_2);
                        $doc->exportField($this->copy_average_3);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->customer_grp);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->partner_id);
                        $doc->exportField($this->name_ref);
                        $doc->exportField($this->city_name);
                        $doc->exportField($this->area);
                        $doc->exportField($this->billing_name);
                        $doc->exportField($this->address);
                        $doc->exportField($this->personal_ref);
                        $doc->exportField($this->harward_code);
                        $doc->exportField($this->serial_no);
                        $doc->exportField($this->invoice_no);
                        $doc->exportField($this->invoice_date);
                        $doc->exportField($this->first_counter);
                        $doc->exportField($this->guarantee);
                        $doc->exportField($this->valid_till);
                        $doc->exportField($this->valid_till_counter);
                        $doc->exportField($this->free_service);
                        $doc->exportField($this->toner_life);
                        $doc->exportField($this->drum_life);
                        $doc->exportField($this->developer_life);
                        $doc->exportField($this->date_install);
                        $doc->exportField($this->date_start);
                        $doc->exportField($this->remark);
                        $doc->exportField($this->status);
                        $doc->exportField($this->schedule_service_type);
                        $doc->exportField($this->schedule_service_interval_days);
                        $doc->exportField($this->schedule_service_updated_till);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->copy_average_1);
                        $doc->exportField($this->copy_average_2);
                        $doc->exportField($this->copy_average_3);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'client_hardware_data');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'client_hardware_data', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'client_hardware_data', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'client_hardware_data', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
