<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class CarpetSetupAdd extends CarpetSetup
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "CarpetSetupAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "carpetsetupadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->cs_min_width->setVisibility();
        $this->cs_min_qty->setVisibility();
        $this->payment_sqm->setVisibility();
        $this->payment_sqm_byepass_category->setVisibility();
        $this->process_byepass->setVisibility();
        $this->jc_bom_wastage->setVisibility();
        $this->bom_1000->setVisibility();
        $this->batch_authorized_id->setVisibility();
        $this->tufting_plan_active->setVisibility();
        $this->tufting_plan_sgrp->setVisibility();
        $this->tufting_plan_loom_group->setVisibility();
        $this->tufting_performance_percent->setVisibility();
        $this->jc_weeks->setVisibility();
        $this->required_material_overall_update->setVisibility();
        $this->jc_material_issue->setVisibility();
        $this->jc_qr->setVisibility();
        $this->jc_mrlot->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->max_jobcard->setVisibility();
        $this->jc_pending_delete_days->setVisibility();
        $this->batch_pp_id->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'carpet_setup';
        $this->TableName = 'carpet_setup';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (carpet_setup)
        if (!isset($GLOBALS["carpet_setup"]) || $GLOBALS["carpet_setup"]::class == PROJECT_NAMESPACE . "carpet_setup") {
            $GLOBALS["carpet_setup"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'carpet_setup');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "carpetsetupview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->payment_sqm);
        $this->setupLookupOptions($this->payment_sqm_byepass_category);
        $this->setupLookupOptions($this->process_byepass);
        $this->setupLookupOptions($this->jc_bom_wastage);
        $this->setupLookupOptions($this->batch_authorized_id);
        $this->setupLookupOptions($this->tufting_plan_active);
        $this->setupLookupOptions($this->tufting_plan_sgrp);
        $this->setupLookupOptions($this->tufting_plan_loom_group);
        $this->setupLookupOptions($this->jc_material_issue);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("carpetsetuplist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "carpetsetuplist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "carpetsetupview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "carpetsetuplist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "carpetsetuplist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->cs_min_width->DefaultValue = $this->cs_min_width->getDefault(); // PHP
        $this->cs_min_width->OldValue = $this->cs_min_width->DefaultValue;
        $this->cs_min_qty->DefaultValue = $this->cs_min_qty->getDefault(); // PHP
        $this->cs_min_qty->OldValue = $this->cs_min_qty->DefaultValue;
        $this->payment_sqm->DefaultValue = $this->payment_sqm->getDefault(); // PHP
        $this->payment_sqm->OldValue = $this->payment_sqm->DefaultValue;
        $this->payment_sqm_byepass_category->DefaultValue = $this->payment_sqm_byepass_category->getDefault(); // PHP
        $this->payment_sqm_byepass_category->OldValue = $this->payment_sqm_byepass_category->DefaultValue;
        $this->process_byepass->DefaultValue = $this->process_byepass->getDefault(); // PHP
        $this->process_byepass->OldValue = $this->process_byepass->DefaultValue;
        $this->jc_bom_wastage->DefaultValue = $this->jc_bom_wastage->getDefault(); // PHP
        $this->jc_bom_wastage->OldValue = $this->jc_bom_wastage->DefaultValue;
        $this->bom_1000->DefaultValue = $this->bom_1000->getDefault(); // PHP
        $this->bom_1000->OldValue = $this->bom_1000->DefaultValue;
        $this->batch_authorized_id->DefaultValue = $this->batch_authorized_id->getDefault(); // PHP
        $this->batch_authorized_id->OldValue = $this->batch_authorized_id->DefaultValue;
        $this->tufting_plan_active->DefaultValue = $this->tufting_plan_active->getDefault(); // PHP
        $this->tufting_plan_active->OldValue = $this->tufting_plan_active->DefaultValue;
        $this->tufting_plan_loom_group->DefaultValue = $this->tufting_plan_loom_group->getDefault(); // PHP
        $this->tufting_plan_loom_group->OldValue = $this->tufting_plan_loom_group->DefaultValue;
        $this->required_material_overall_update->DefaultValue = $this->required_material_overall_update->getDefault(); // PHP
        $this->required_material_overall_update->OldValue = $this->required_material_overall_update->DefaultValue;
        $this->jc_material_issue->DefaultValue = $this->jc_material_issue->getDefault(); // PHP
        $this->jc_material_issue->OldValue = $this->jc_material_issue->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->max_jobcard->DefaultValue = $this->max_jobcard->getDefault(); // PHP
        $this->max_jobcard->OldValue = $this->max_jobcard->DefaultValue;
        $this->jc_pending_delete_days->DefaultValue = $this->jc_pending_delete_days->getDefault(); // PHP
        $this->jc_pending_delete_days->OldValue = $this->jc_pending_delete_days->DefaultValue;
        $this->batch_pp_id->DefaultValue = $this->batch_pp_id->getDefault(); // PHP
        $this->batch_pp_id->OldValue = $this->batch_pp_id->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->id->Visible = false; // Disable update for API request
            } else {
                $this->id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'cs_min_width' first before field var 'x_cs_min_width'
        $val = $CurrentForm->hasValue("cs_min_width") ? $CurrentForm->getValue("cs_min_width") : $CurrentForm->getValue("x_cs_min_width");
        if (!$this->cs_min_width->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cs_min_width->Visible = false; // Disable update for API request
            } else {
                $this->cs_min_width->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'cs_min_qty' first before field var 'x_cs_min_qty'
        $val = $CurrentForm->hasValue("cs_min_qty") ? $CurrentForm->getValue("cs_min_qty") : $CurrentForm->getValue("x_cs_min_qty");
        if (!$this->cs_min_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cs_min_qty->Visible = false; // Disable update for API request
            } else {
                $this->cs_min_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'payment_sqm' first before field var 'x_payment_sqm'
        $val = $CurrentForm->hasValue("payment_sqm") ? $CurrentForm->getValue("payment_sqm") : $CurrentForm->getValue("x_payment_sqm");
        if (!$this->payment_sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment_sqm->Visible = false; // Disable update for API request
            } else {
                $this->payment_sqm->setFormValue($val);
            }
        }

        // Check field name 'payment_sqm_byepass_category' first before field var 'x_payment_sqm_byepass_category'
        $val = $CurrentForm->hasValue("payment_sqm_byepass_category") ? $CurrentForm->getValue("payment_sqm_byepass_category") : $CurrentForm->getValue("x_payment_sqm_byepass_category");
        if (!$this->payment_sqm_byepass_category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment_sqm_byepass_category->Visible = false; // Disable update for API request
            } else {
                $this->payment_sqm_byepass_category->setFormValue($val);
            }
        }

        // Check field name 'process_byepass' first before field var 'x_process_byepass'
        $val = $CurrentForm->hasValue("process_byepass") ? $CurrentForm->getValue("process_byepass") : $CurrentForm->getValue("x_process_byepass");
        if (!$this->process_byepass->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process_byepass->Visible = false; // Disable update for API request
            } else {
                $this->process_byepass->setFormValue($val);
            }
        }

        // Check field name 'jc_bom_wastage' first before field var 'x_jc_bom_wastage'
        $val = $CurrentForm->hasValue("jc_bom_wastage") ? $CurrentForm->getValue("jc_bom_wastage") : $CurrentForm->getValue("x_jc_bom_wastage");
        if (!$this->jc_bom_wastage->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_bom_wastage->Visible = false; // Disable update for API request
            } else {
                $this->jc_bom_wastage->setFormValue($val);
            }
        }

        // Check field name 'bom_1000' first before field var 'x_bom_1000'
        $val = $CurrentForm->hasValue("bom_1000") ? $CurrentForm->getValue("bom_1000") : $CurrentForm->getValue("x_bom_1000");
        if (!$this->bom_1000->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bom_1000->Visible = false; // Disable update for API request
            } else {
                $this->bom_1000->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'batch_authorized_id' first before field var 'x_batch_authorized_id'
        $val = $CurrentForm->hasValue("batch_authorized_id") ? $CurrentForm->getValue("batch_authorized_id") : $CurrentForm->getValue("x_batch_authorized_id");
        if (!$this->batch_authorized_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_authorized_id->Visible = false; // Disable update for API request
            } else {
                $this->batch_authorized_id->setFormValue($val);
            }
        }

        // Check field name 'tufting_plan_active' first before field var 'x_tufting_plan_active'
        $val = $CurrentForm->hasValue("tufting_plan_active") ? $CurrentForm->getValue("tufting_plan_active") : $CurrentForm->getValue("x_tufting_plan_active");
        if (!$this->tufting_plan_active->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->tufting_plan_active->Visible = false; // Disable update for API request
            } else {
                $this->tufting_plan_active->setFormValue($val);
            }
        }

        // Check field name 'tufting_plan_sgrp' first before field var 'x_tufting_plan_sgrp'
        $val = $CurrentForm->hasValue("tufting_plan_sgrp") ? $CurrentForm->getValue("tufting_plan_sgrp") : $CurrentForm->getValue("x_tufting_plan_sgrp");
        if (!$this->tufting_plan_sgrp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->tufting_plan_sgrp->Visible = false; // Disable update for API request
            } else {
                $this->tufting_plan_sgrp->setFormValue($val);
            }
        }

        // Check field name 'tufting_plan_loom_group' first before field var 'x_tufting_plan_loom_group'
        $val = $CurrentForm->hasValue("tufting_plan_loom_group") ? $CurrentForm->getValue("tufting_plan_loom_group") : $CurrentForm->getValue("x_tufting_plan_loom_group");
        if (!$this->tufting_plan_loom_group->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->tufting_plan_loom_group->Visible = false; // Disable update for API request
            } else {
                $this->tufting_plan_loom_group->setFormValue($val);
            }
        }

        // Check field name 'tufting_performance_percent' first before field var 'x_tufting_performance_percent'
        $val = $CurrentForm->hasValue("tufting_performance_percent") ? $CurrentForm->getValue("tufting_performance_percent") : $CurrentForm->getValue("x_tufting_performance_percent");
        if (!$this->tufting_performance_percent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->tufting_performance_percent->Visible = false; // Disable update for API request
            } else {
                $this->tufting_performance_percent->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'jc_weeks' first before field var 'x_jc_weeks'
        $val = $CurrentForm->hasValue("jc_weeks") ? $CurrentForm->getValue("jc_weeks") : $CurrentForm->getValue("x_jc_weeks");
        if (!$this->jc_weeks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_weeks->Visible = false; // Disable update for API request
            } else {
                $this->jc_weeks->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'required_material_overall_update' first before field var 'x_required_material_overall_update'
        $val = $CurrentForm->hasValue("required_material_overall_update") ? $CurrentForm->getValue("required_material_overall_update") : $CurrentForm->getValue("x_required_material_overall_update");
        if (!$this->required_material_overall_update->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->required_material_overall_update->Visible = false; // Disable update for API request
            } else {
                $this->required_material_overall_update->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'jc_material_issue' first before field var 'x_jc_material_issue'
        $val = $CurrentForm->hasValue("jc_material_issue") ? $CurrentForm->getValue("jc_material_issue") : $CurrentForm->getValue("x_jc_material_issue");
        if (!$this->jc_material_issue->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_material_issue->Visible = false; // Disable update for API request
            } else {
                $this->jc_material_issue->setFormValue($val);
            }
        }

        // Check field name 'jc_qr' first before field var 'x_jc_qr'
        $val = $CurrentForm->hasValue("jc_qr") ? $CurrentForm->getValue("jc_qr") : $CurrentForm->getValue("x_jc_qr");
        if (!$this->jc_qr->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_qr->Visible = false; // Disable update for API request
            } else {
                $this->jc_qr->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'jc_mrlot' first before field var 'x_jc_mrlot'
        $val = $CurrentForm->hasValue("jc_mrlot") ? $CurrentForm->getValue("jc_mrlot") : $CurrentForm->getValue("x_jc_mrlot");
        if (!$this->jc_mrlot->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_mrlot->Visible = false; // Disable update for API request
            } else {
                $this->jc_mrlot->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'max_jobcard' first before field var 'x_max_jobcard'
        $val = $CurrentForm->hasValue("max_jobcard") ? $CurrentForm->getValue("max_jobcard") : $CurrentForm->getValue("x_max_jobcard");
        if (!$this->max_jobcard->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->max_jobcard->Visible = false; // Disable update for API request
            } else {
                $this->max_jobcard->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'jc_pending_delete_days' first before field var 'x_jc_pending_delete_days'
        $val = $CurrentForm->hasValue("jc_pending_delete_days") ? $CurrentForm->getValue("jc_pending_delete_days") : $CurrentForm->getValue("x_jc_pending_delete_days");
        if (!$this->jc_pending_delete_days->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_pending_delete_days->Visible = false; // Disable update for API request
            } else {
                $this->jc_pending_delete_days->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'batch_pp_id' first before field var 'x_batch_pp_id'
        $val = $CurrentForm->hasValue("batch_pp_id") ? $CurrentForm->getValue("batch_pp_id") : $CurrentForm->getValue("x_batch_pp_id");
        if (!$this->batch_pp_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_pp_id->Visible = false; // Disable update for API request
            } else {
                $this->batch_pp_id->setFormValue($val, true, $validate);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->cs_min_width->CurrentValue = $this->cs_min_width->FormValue;
        $this->cs_min_qty->CurrentValue = $this->cs_min_qty->FormValue;
        $this->payment_sqm->CurrentValue = $this->payment_sqm->FormValue;
        $this->payment_sqm_byepass_category->CurrentValue = $this->payment_sqm_byepass_category->FormValue;
        $this->process_byepass->CurrentValue = $this->process_byepass->FormValue;
        $this->jc_bom_wastage->CurrentValue = $this->jc_bom_wastage->FormValue;
        $this->bom_1000->CurrentValue = $this->bom_1000->FormValue;
        $this->batch_authorized_id->CurrentValue = $this->batch_authorized_id->FormValue;
        $this->tufting_plan_active->CurrentValue = $this->tufting_plan_active->FormValue;
        $this->tufting_plan_sgrp->CurrentValue = $this->tufting_plan_sgrp->FormValue;
        $this->tufting_plan_loom_group->CurrentValue = $this->tufting_plan_loom_group->FormValue;
        $this->tufting_performance_percent->CurrentValue = $this->tufting_performance_percent->FormValue;
        $this->jc_weeks->CurrentValue = $this->jc_weeks->FormValue;
        $this->required_material_overall_update->CurrentValue = $this->required_material_overall_update->FormValue;
        $this->jc_material_issue->CurrentValue = $this->jc_material_issue->FormValue;
        $this->jc_qr->CurrentValue = $this->jc_qr->FormValue;
        $this->jc_mrlot->CurrentValue = $this->jc_mrlot->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->max_jobcard->CurrentValue = $this->max_jobcard->FormValue;
        $this->jc_pending_delete_days->CurrentValue = $this->jc_pending_delete_days->FormValue;
        $this->batch_pp_id->CurrentValue = $this->batch_pp_id->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->cs_min_width->setDbValue($row['cs_min_width']);
        $this->cs_min_qty->setDbValue($row['cs_min_qty']);
        $this->payment_sqm->setDbValue($row['payment_sqm']);
        $this->payment_sqm_byepass_category->setDbValue($row['payment_sqm_byepass_category']);
        $this->process_byepass->setDbValue($row['process_byepass']);
        $this->jc_bom_wastage->setDbValue($row['jc_bom_wastage']);
        $this->bom_1000->setDbValue($row['bom_1000']);
        $this->batch_authorized_id->setDbValue($row['batch_authorized_id']);
        $this->tufting_plan_active->setDbValue($row['tufting_plan_active']);
        $this->tufting_plan_sgrp->setDbValue($row['tufting_plan_sgrp']);
        $this->tufting_plan_loom_group->setDbValue($row['tufting_plan_loom_group']);
        $this->tufting_performance_percent->setDbValue($row['tufting_performance_percent']);
        $this->jc_weeks->setDbValue($row['jc_weeks']);
        $this->required_material_overall_update->setDbValue($row['required_material_overall_update']);
        $this->jc_material_issue->setDbValue($row['jc_material_issue']);
        $this->jc_qr->setDbValue($row['jc_qr']);
        $this->jc_mrlot->setDbValue($row['jc_mrlot']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->max_jobcard->setDbValue($row['max_jobcard']);
        $this->jc_pending_delete_days->setDbValue($row['jc_pending_delete_days']);
        $this->batch_pp_id->setDbValue($row['batch_pp_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['cs_min_width'] = $this->cs_min_width->DefaultValue;
        $row['cs_min_qty'] = $this->cs_min_qty->DefaultValue;
        $row['payment_sqm'] = $this->payment_sqm->DefaultValue;
        $row['payment_sqm_byepass_category'] = $this->payment_sqm_byepass_category->DefaultValue;
        $row['process_byepass'] = $this->process_byepass->DefaultValue;
        $row['jc_bom_wastage'] = $this->jc_bom_wastage->DefaultValue;
        $row['bom_1000'] = $this->bom_1000->DefaultValue;
        $row['batch_authorized_id'] = $this->batch_authorized_id->DefaultValue;
        $row['tufting_plan_active'] = $this->tufting_plan_active->DefaultValue;
        $row['tufting_plan_sgrp'] = $this->tufting_plan_sgrp->DefaultValue;
        $row['tufting_plan_loom_group'] = $this->tufting_plan_loom_group->DefaultValue;
        $row['tufting_performance_percent'] = $this->tufting_performance_percent->DefaultValue;
        $row['jc_weeks'] = $this->jc_weeks->DefaultValue;
        $row['required_material_overall_update'] = $this->required_material_overall_update->DefaultValue;
        $row['jc_material_issue'] = $this->jc_material_issue->DefaultValue;
        $row['jc_qr'] = $this->jc_qr->DefaultValue;
        $row['jc_mrlot'] = $this->jc_mrlot->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['max_jobcard'] = $this->max_jobcard->DefaultValue;
        $row['jc_pending_delete_days'] = $this->jc_pending_delete_days->DefaultValue;
        $row['batch_pp_id'] = $this->batch_pp_id->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // cs_min_width
        $this->cs_min_width->RowCssClass = "row";

        // cs_min_qty
        $this->cs_min_qty->RowCssClass = "row";

        // payment_sqm
        $this->payment_sqm->RowCssClass = "row";

        // payment_sqm_byepass_category
        $this->payment_sqm_byepass_category->RowCssClass = "row";

        // process_byepass
        $this->process_byepass->RowCssClass = "row";

        // jc_bom_wastage
        $this->jc_bom_wastage->RowCssClass = "row";

        // bom_1000
        $this->bom_1000->RowCssClass = "row";

        // batch_authorized_id
        $this->batch_authorized_id->RowCssClass = "row";

        // tufting_plan_active
        $this->tufting_plan_active->RowCssClass = "row";

        // tufting_plan_sgrp
        $this->tufting_plan_sgrp->RowCssClass = "row";

        // tufting_plan_loom_group
        $this->tufting_plan_loom_group->RowCssClass = "row";

        // tufting_performance_percent
        $this->tufting_performance_percent->RowCssClass = "row";

        // jc_weeks
        $this->jc_weeks->RowCssClass = "row";

        // required_material_overall_update
        $this->required_material_overall_update->RowCssClass = "row";

        // jc_material_issue
        $this->jc_material_issue->RowCssClass = "row";

        // jc_qr
        $this->jc_qr->RowCssClass = "row";

        // jc_mrlot
        $this->jc_mrlot->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // max_jobcard
        $this->max_jobcard->RowCssClass = "row";

        // jc_pending_delete_days
        $this->jc_pending_delete_days->RowCssClass = "row";

        // batch_pp_id
        $this->batch_pp_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // cs_min_width
            $this->cs_min_width->ViewValue = $this->cs_min_width->CurrentValue;
            $this->cs_min_width->ViewValue = FormatNumber($this->cs_min_width->ViewValue, $this->cs_min_width->formatPattern());

            // cs_min_qty
            $this->cs_min_qty->ViewValue = $this->cs_min_qty->CurrentValue;
            $this->cs_min_qty->ViewValue = FormatNumber($this->cs_min_qty->ViewValue, $this->cs_min_qty->formatPattern());

            // payment_sqm
            if (strval($this->payment_sqm->CurrentValue) != "") {
                $this->payment_sqm->ViewValue = $this->payment_sqm->optionCaption($this->payment_sqm->CurrentValue);
            } else {
                $this->payment_sqm->ViewValue = null;
            }

            // payment_sqm_byepass_category
            $curVal = strval($this->payment_sqm_byepass_category->CurrentValue);
            if ($curVal != "") {
                $this->payment_sqm_byepass_category->ViewValue = $this->payment_sqm_byepass_category->lookupCacheOption($curVal);
                if ($this->payment_sqm_byepass_category->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->payment_sqm_byepass_category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment_sqm_byepass_category->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->payment_sqm_byepass_category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->payment_sqm_byepass_category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->payment_sqm_byepass_category->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->payment_sqm_byepass_category->Lookup->renderViewRow($row);
                            $this->payment_sqm_byepass_category->ViewValue->add($this->payment_sqm_byepass_category->displayValue($arwrk));
                        }
                    } else {
                        $this->payment_sqm_byepass_category->ViewValue = $this->payment_sqm_byepass_category->CurrentValue;
                    }
                }
            } else {
                $this->payment_sqm_byepass_category->ViewValue = null;
            }

            // process_byepass
            if (strval($this->process_byepass->CurrentValue) != "") {
                $this->process_byepass->ViewValue = $this->process_byepass->optionCaption($this->process_byepass->CurrentValue);
            } else {
                $this->process_byepass->ViewValue = null;
            }

            // jc_bom_wastage
            if (strval($this->jc_bom_wastage->CurrentValue) != "") {
                $this->jc_bom_wastage->ViewValue = $this->jc_bom_wastage->optionCaption($this->jc_bom_wastage->CurrentValue);
            } else {
                $this->jc_bom_wastage->ViewValue = null;
            }

            // bom_1000
            $this->bom_1000->ViewValue = $this->bom_1000->CurrentValue;
            $this->bom_1000->ViewValue = FormatNumber($this->bom_1000->ViewValue, $this->bom_1000->formatPattern());

            // batch_authorized_id
            $curVal = strval($this->batch_authorized_id->CurrentValue);
            if ($curVal != "") {
                $this->batch_authorized_id->ViewValue = $this->batch_authorized_id->lookupCacheOption($curVal);
                if ($this->batch_authorized_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_authorized_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_authorized_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_authorized_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_authorized_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_authorized_id->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_authorized_id->ViewValue = $this->batch_authorized_id->displayValue($arwrk);
                    } else {
                        $this->batch_authorized_id->ViewValue = $this->batch_authorized_id->CurrentValue;
                    }
                }
            } else {
                $this->batch_authorized_id->ViewValue = null;
            }

            // tufting_plan_active
            if (strval($this->tufting_plan_active->CurrentValue) != "") {
                $this->tufting_plan_active->ViewValue = $this->tufting_plan_active->optionCaption($this->tufting_plan_active->CurrentValue);
            } else {
                $this->tufting_plan_active->ViewValue = null;
            }

            // tufting_plan_sgrp
            $curVal = strval($this->tufting_plan_sgrp->CurrentValue);
            if ($curVal != "") {
                $this->tufting_plan_sgrp->ViewValue = $this->tufting_plan_sgrp->lookupCacheOption($curVal);
                if ($this->tufting_plan_sgrp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->tufting_plan_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->tufting_plan_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->tufting_plan_sgrp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->tufting_plan_sgrp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->tufting_plan_sgrp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->tufting_plan_sgrp->Lookup->renderViewRow($row);
                            $this->tufting_plan_sgrp->ViewValue->add($this->tufting_plan_sgrp->displayValue($arwrk));
                        }
                    } else {
                        $this->tufting_plan_sgrp->ViewValue = $this->tufting_plan_sgrp->CurrentValue;
                    }
                }
            } else {
                $this->tufting_plan_sgrp->ViewValue = null;
            }

            // tufting_plan_loom_group
            if (strval($this->tufting_plan_loom_group->CurrentValue) != "") {
                $this->tufting_plan_loom_group->ViewValue = $this->tufting_plan_loom_group->optionCaption($this->tufting_plan_loom_group->CurrentValue);
            } else {
                $this->tufting_plan_loom_group->ViewValue = null;
            }

            // tufting_performance_percent
            $this->tufting_performance_percent->ViewValue = $this->tufting_performance_percent->CurrentValue;
            $this->tufting_performance_percent->ViewValue = FormatNumber($this->tufting_performance_percent->ViewValue, $this->tufting_performance_percent->formatPattern());

            // jc_weeks
            $this->jc_weeks->ViewValue = $this->jc_weeks->CurrentValue;
            $this->jc_weeks->ViewValue = FormatNumber($this->jc_weeks->ViewValue, $this->jc_weeks->formatPattern());

            // required_material_overall_update
            $this->required_material_overall_update->ViewValue = $this->required_material_overall_update->CurrentValue;
            $this->required_material_overall_update->ViewValue = FormatNumber($this->required_material_overall_update->ViewValue, $this->required_material_overall_update->formatPattern());

            // jc_material_issue
            if (strval($this->jc_material_issue->CurrentValue) != "") {
                $this->jc_material_issue->ViewValue = $this->jc_material_issue->optionCaption($this->jc_material_issue->CurrentValue);
            } else {
                $this->jc_material_issue->ViewValue = null;
            }

            // jc_qr
            $this->jc_qr->ViewValue = $this->jc_qr->CurrentValue;
            $this->jc_qr->ViewValue = FormatNumber($this->jc_qr->ViewValue, $this->jc_qr->formatPattern());

            // jc_mrlot
            $this->jc_mrlot->ViewValue = $this->jc_mrlot->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // max_jobcard
            $this->max_jobcard->ViewValue = $this->max_jobcard->CurrentValue;
            $this->max_jobcard->ViewValue = FormatNumber($this->max_jobcard->ViewValue, $this->max_jobcard->formatPattern());

            // jc_pending_delete_days
            $this->jc_pending_delete_days->ViewValue = $this->jc_pending_delete_days->CurrentValue;
            $this->jc_pending_delete_days->ViewValue = FormatNumber($this->jc_pending_delete_days->ViewValue, $this->jc_pending_delete_days->formatPattern());

            // batch_pp_id
            $this->batch_pp_id->ViewValue = $this->batch_pp_id->CurrentValue;
            $this->batch_pp_id->ViewValue = FormatNumber($this->batch_pp_id->ViewValue, $this->batch_pp_id->formatPattern());

            // id
            $this->id->HrefValue = "";

            // cs_min_width
            $this->cs_min_width->HrefValue = "";

            // cs_min_qty
            $this->cs_min_qty->HrefValue = "";

            // payment_sqm
            $this->payment_sqm->HrefValue = "";

            // payment_sqm_byepass_category
            $this->payment_sqm_byepass_category->HrefValue = "";

            // process_byepass
            $this->process_byepass->HrefValue = "";

            // jc_bom_wastage
            $this->jc_bom_wastage->HrefValue = "";

            // bom_1000
            $this->bom_1000->HrefValue = "";

            // batch_authorized_id
            $this->batch_authorized_id->HrefValue = "";

            // tufting_plan_active
            $this->tufting_plan_active->HrefValue = "";

            // tufting_plan_sgrp
            $this->tufting_plan_sgrp->HrefValue = "";

            // tufting_plan_loom_group
            $this->tufting_plan_loom_group->HrefValue = "";

            // tufting_performance_percent
            $this->tufting_performance_percent->HrefValue = "";

            // jc_weeks
            $this->jc_weeks->HrefValue = "";

            // required_material_overall_update
            $this->required_material_overall_update->HrefValue = "";

            // jc_material_issue
            $this->jc_material_issue->HrefValue = "";

            // jc_qr
            $this->jc_qr->HrefValue = "";

            // jc_mrlot
            $this->jc_mrlot->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // max_jobcard
            $this->max_jobcard->HrefValue = "";

            // jc_pending_delete_days
            $this->jc_pending_delete_days->HrefValue = "";

            // batch_pp_id
            $this->batch_pp_id->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());
            if (strval($this->id->EditValue) != "" && is_numeric($this->id->EditValue)) {
                $this->id->EditValue = FormatNumber($this->id->EditValue, null);
            }

            // cs_min_width
            $this->cs_min_width->setupEditAttributes();
            $this->cs_min_width->EditValue = $this->cs_min_width->CurrentValue;
            $this->cs_min_width->PlaceHolder = RemoveHtml($this->cs_min_width->caption());
            if (strval($this->cs_min_width->EditValue) != "" && is_numeric($this->cs_min_width->EditValue)) {
                $this->cs_min_width->EditValue = FormatNumber($this->cs_min_width->EditValue, null);
            }

            // cs_min_qty
            $this->cs_min_qty->setupEditAttributes();
            $this->cs_min_qty->EditValue = $this->cs_min_qty->CurrentValue;
            $this->cs_min_qty->PlaceHolder = RemoveHtml($this->cs_min_qty->caption());
            if (strval($this->cs_min_qty->EditValue) != "" && is_numeric($this->cs_min_qty->EditValue)) {
                $this->cs_min_qty->EditValue = FormatNumber($this->cs_min_qty->EditValue, null);
            }

            // payment_sqm
            $this->payment_sqm->setupEditAttributes();
            $this->payment_sqm->EditValue = $this->payment_sqm->options(true);
            $this->payment_sqm->PlaceHolder = RemoveHtml($this->payment_sqm->caption());

            // payment_sqm_byepass_category
            $curVal = trim(strval($this->payment_sqm_byepass_category->CurrentValue));
            if ($curVal != "") {
                $this->payment_sqm_byepass_category->ViewValue = $this->payment_sqm_byepass_category->lookupCacheOption($curVal);
            } else {
                $this->payment_sqm_byepass_category->ViewValue = $this->payment_sqm_byepass_category->Lookup !== null && is_array($this->payment_sqm_byepass_category->lookupOptions()) && count($this->payment_sqm_byepass_category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->payment_sqm_byepass_category->ViewValue !== null) { // Load from cache
                $this->payment_sqm_byepass_category->EditValue = array_values($this->payment_sqm_byepass_category->lookupOptions());
                if ($this->payment_sqm_byepass_category->ViewValue == "") {
                    $this->payment_sqm_byepass_category->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->payment_sqm_byepass_category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment_sqm_byepass_category->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->payment_sqm_byepass_category->getSelectFilter($this); // PHP
                $sqlWrk = $this->payment_sqm_byepass_category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->payment_sqm_byepass_category->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->payment_sqm_byepass_category->Lookup->renderViewRow($row);
                        $this->payment_sqm_byepass_category->ViewValue->add($this->payment_sqm_byepass_category->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->payment_sqm_byepass_category->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->payment_sqm_byepass_category->EditValue = $arwrk;
            }
            $this->payment_sqm_byepass_category->PlaceHolder = RemoveHtml($this->payment_sqm_byepass_category->caption());

            // process_byepass
            $this->process_byepass->setupEditAttributes();
            $this->process_byepass->EditValue = $this->process_byepass->options(true);
            $this->process_byepass->PlaceHolder = RemoveHtml($this->process_byepass->caption());

            // jc_bom_wastage
            $this->jc_bom_wastage->setupEditAttributes();
            $this->jc_bom_wastage->EditValue = $this->jc_bom_wastage->options(true);
            $this->jc_bom_wastage->PlaceHolder = RemoveHtml($this->jc_bom_wastage->caption());

            // bom_1000
            $this->bom_1000->setupEditAttributes();
            $this->bom_1000->EditValue = $this->bom_1000->CurrentValue;
            $this->bom_1000->PlaceHolder = RemoveHtml($this->bom_1000->caption());
            if (strval($this->bom_1000->EditValue) != "" && is_numeric($this->bom_1000->EditValue)) {
                $this->bom_1000->EditValue = FormatNumber($this->bom_1000->EditValue, null);
            }

            // batch_authorized_id
            $this->batch_authorized_id->setupEditAttributes();
            $curVal = trim(strval($this->batch_authorized_id->CurrentValue));
            if ($curVal != "") {
                $this->batch_authorized_id->ViewValue = $this->batch_authorized_id->lookupCacheOption($curVal);
            } else {
                $this->batch_authorized_id->ViewValue = $this->batch_authorized_id->Lookup !== null && is_array($this->batch_authorized_id->lookupOptions()) && count($this->batch_authorized_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->batch_authorized_id->ViewValue !== null) { // Load from cache
                $this->batch_authorized_id->EditValue = array_values($this->batch_authorized_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->batch_authorized_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->batch_authorized_id->CurrentValue, $this->batch_authorized_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->batch_authorized_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_authorized_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->batch_authorized_id->EditValue = $arwrk;
            }
            $this->batch_authorized_id->PlaceHolder = RemoveHtml($this->batch_authorized_id->caption());

            // tufting_plan_active
            $this->tufting_plan_active->setupEditAttributes();
            $this->tufting_plan_active->EditValue = $this->tufting_plan_active->options(true);
            $this->tufting_plan_active->PlaceHolder = RemoveHtml($this->tufting_plan_active->caption());

            // tufting_plan_sgrp
            $this->tufting_plan_sgrp->setupEditAttributes();
            $curVal = trim(strval($this->tufting_plan_sgrp->CurrentValue));
            if ($curVal != "") {
                $this->tufting_plan_sgrp->ViewValue = $this->tufting_plan_sgrp->lookupCacheOption($curVal);
            } else {
                $this->tufting_plan_sgrp->ViewValue = $this->tufting_plan_sgrp->Lookup !== null && is_array($this->tufting_plan_sgrp->lookupOptions()) && count($this->tufting_plan_sgrp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->tufting_plan_sgrp->ViewValue !== null) { // Load from cache
                $this->tufting_plan_sgrp->EditValue = array_values($this->tufting_plan_sgrp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->tufting_plan_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->tufting_plan_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->tufting_plan_sgrp->getSelectFilter($this); // PHP
                $sqlWrk = $this->tufting_plan_sgrp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->tufting_plan_sgrp->EditValue = $arwrk;
            }
            $this->tufting_plan_sgrp->PlaceHolder = RemoveHtml($this->tufting_plan_sgrp->caption());

            // tufting_plan_loom_group
            $this->tufting_plan_loom_group->setupEditAttributes();
            $this->tufting_plan_loom_group->EditValue = $this->tufting_plan_loom_group->options(true);
            $this->tufting_plan_loom_group->PlaceHolder = RemoveHtml($this->tufting_plan_loom_group->caption());

            // tufting_performance_percent
            $this->tufting_performance_percent->setupEditAttributes();
            $this->tufting_performance_percent->EditValue = $this->tufting_performance_percent->CurrentValue;
            $this->tufting_performance_percent->PlaceHolder = RemoveHtml($this->tufting_performance_percent->caption());
            if (strval($this->tufting_performance_percent->EditValue) != "" && is_numeric($this->tufting_performance_percent->EditValue)) {
                $this->tufting_performance_percent->EditValue = FormatNumber($this->tufting_performance_percent->EditValue, null);
            }

            // jc_weeks
            $this->jc_weeks->setupEditAttributes();
            $this->jc_weeks->EditValue = $this->jc_weeks->CurrentValue;
            $this->jc_weeks->PlaceHolder = RemoveHtml($this->jc_weeks->caption());
            if (strval($this->jc_weeks->EditValue) != "" && is_numeric($this->jc_weeks->EditValue)) {
                $this->jc_weeks->EditValue = FormatNumber($this->jc_weeks->EditValue, null);
            }

            // required_material_overall_update
            $this->required_material_overall_update->setupEditAttributes();
            $this->required_material_overall_update->EditValue = $this->required_material_overall_update->CurrentValue;
            $this->required_material_overall_update->PlaceHolder = RemoveHtml($this->required_material_overall_update->caption());
            if (strval($this->required_material_overall_update->EditValue) != "" && is_numeric($this->required_material_overall_update->EditValue)) {
                $this->required_material_overall_update->EditValue = FormatNumber($this->required_material_overall_update->EditValue, null);
            }

            // jc_material_issue
            $this->jc_material_issue->setupEditAttributes();
            $this->jc_material_issue->EditValue = $this->jc_material_issue->options(true);
            $this->jc_material_issue->PlaceHolder = RemoveHtml($this->jc_material_issue->caption());

            // jc_qr
            $this->jc_qr->setupEditAttributes();
            $this->jc_qr->EditValue = $this->jc_qr->CurrentValue;
            $this->jc_qr->PlaceHolder = RemoveHtml($this->jc_qr->caption());
            if (strval($this->jc_qr->EditValue) != "" && is_numeric($this->jc_qr->EditValue)) {
                $this->jc_qr->EditValue = FormatNumber($this->jc_qr->EditValue, null);
            }

            // jc_mrlot
            $this->jc_mrlot->setupEditAttributes();
            if (!$this->jc_mrlot->Raw) {
                $this->jc_mrlot->CurrentValue = HtmlDecode($this->jc_mrlot->CurrentValue);
            }
            $this->jc_mrlot->EditValue = HtmlEncode($this->jc_mrlot->CurrentValue);
            $this->jc_mrlot->PlaceHolder = RemoveHtml($this->jc_mrlot->caption());

            // operator

            // datetime

            // max_jobcard
            $this->max_jobcard->setupEditAttributes();
            $this->max_jobcard->EditValue = $this->max_jobcard->CurrentValue;
            $this->max_jobcard->PlaceHolder = RemoveHtml($this->max_jobcard->caption());
            if (strval($this->max_jobcard->EditValue) != "" && is_numeric($this->max_jobcard->EditValue)) {
                $this->max_jobcard->EditValue = FormatNumber($this->max_jobcard->EditValue, null);
            }

            // jc_pending_delete_days
            $this->jc_pending_delete_days->setupEditAttributes();
            $this->jc_pending_delete_days->EditValue = $this->jc_pending_delete_days->CurrentValue;
            $this->jc_pending_delete_days->PlaceHolder = RemoveHtml($this->jc_pending_delete_days->caption());
            if (strval($this->jc_pending_delete_days->EditValue) != "" && is_numeric($this->jc_pending_delete_days->EditValue)) {
                $this->jc_pending_delete_days->EditValue = FormatNumber($this->jc_pending_delete_days->EditValue, null);
            }

            // batch_pp_id
            $this->batch_pp_id->setupEditAttributes();
            $this->batch_pp_id->EditValue = $this->batch_pp_id->CurrentValue;
            $this->batch_pp_id->PlaceHolder = RemoveHtml($this->batch_pp_id->caption());
            if (strval($this->batch_pp_id->EditValue) != "" && is_numeric($this->batch_pp_id->EditValue)) {
                $this->batch_pp_id->EditValue = FormatNumber($this->batch_pp_id->EditValue, null);
            }

            // Add refer script

            // id
            $this->id->HrefValue = "";

            // cs_min_width
            $this->cs_min_width->HrefValue = "";

            // cs_min_qty
            $this->cs_min_qty->HrefValue = "";

            // payment_sqm
            $this->payment_sqm->HrefValue = "";

            // payment_sqm_byepass_category
            $this->payment_sqm_byepass_category->HrefValue = "";

            // process_byepass
            $this->process_byepass->HrefValue = "";

            // jc_bom_wastage
            $this->jc_bom_wastage->HrefValue = "";

            // bom_1000
            $this->bom_1000->HrefValue = "";

            // batch_authorized_id
            $this->batch_authorized_id->HrefValue = "";

            // tufting_plan_active
            $this->tufting_plan_active->HrefValue = "";

            // tufting_plan_sgrp
            $this->tufting_plan_sgrp->HrefValue = "";

            // tufting_plan_loom_group
            $this->tufting_plan_loom_group->HrefValue = "";

            // tufting_performance_percent
            $this->tufting_performance_percent->HrefValue = "";

            // jc_weeks
            $this->jc_weeks->HrefValue = "";

            // required_material_overall_update
            $this->required_material_overall_update->HrefValue = "";

            // jc_material_issue
            $this->jc_material_issue->HrefValue = "";

            // jc_qr
            $this->jc_qr->HrefValue = "";

            // jc_mrlot
            $this->jc_mrlot->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // max_jobcard
            $this->max_jobcard->HrefValue = "";

            // jc_pending_delete_days
            $this->jc_pending_delete_days->HrefValue = "";

            // batch_pp_id
            $this->batch_pp_id->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->id->FormValue)) {
                $this->id->addErrorMessage($this->id->getErrorMessage(false));
            }
            if ($this->cs_min_width->Visible && $this->cs_min_width->Required) {
                if (!$this->cs_min_width->IsDetailKey && EmptyValue($this->cs_min_width->FormValue)) {
                    $this->cs_min_width->addErrorMessage(str_replace("%s", $this->cs_min_width->caption(), $this->cs_min_width->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->cs_min_width->FormValue)) {
                $this->cs_min_width->addErrorMessage($this->cs_min_width->getErrorMessage(false));
            }
            if ($this->cs_min_qty->Visible && $this->cs_min_qty->Required) {
                if (!$this->cs_min_qty->IsDetailKey && EmptyValue($this->cs_min_qty->FormValue)) {
                    $this->cs_min_qty->addErrorMessage(str_replace("%s", $this->cs_min_qty->caption(), $this->cs_min_qty->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->cs_min_qty->FormValue)) {
                $this->cs_min_qty->addErrorMessage($this->cs_min_qty->getErrorMessage(false));
            }
            if ($this->payment_sqm->Visible && $this->payment_sqm->Required) {
                if (!$this->payment_sqm->IsDetailKey && EmptyValue($this->payment_sqm->FormValue)) {
                    $this->payment_sqm->addErrorMessage(str_replace("%s", $this->payment_sqm->caption(), $this->payment_sqm->RequiredErrorMessage));
                }
            }
            if ($this->payment_sqm_byepass_category->Visible && $this->payment_sqm_byepass_category->Required) {
                if ($this->payment_sqm_byepass_category->FormValue == "") {
                    $this->payment_sqm_byepass_category->addErrorMessage(str_replace("%s", $this->payment_sqm_byepass_category->caption(), $this->payment_sqm_byepass_category->RequiredErrorMessage));
                }
            }
            if ($this->process_byepass->Visible && $this->process_byepass->Required) {
                if (!$this->process_byepass->IsDetailKey && EmptyValue($this->process_byepass->FormValue)) {
                    $this->process_byepass->addErrorMessage(str_replace("%s", $this->process_byepass->caption(), $this->process_byepass->RequiredErrorMessage));
                }
            }
            if ($this->jc_bom_wastage->Visible && $this->jc_bom_wastage->Required) {
                if (!$this->jc_bom_wastage->IsDetailKey && EmptyValue($this->jc_bom_wastage->FormValue)) {
                    $this->jc_bom_wastage->addErrorMessage(str_replace("%s", $this->jc_bom_wastage->caption(), $this->jc_bom_wastage->RequiredErrorMessage));
                }
            }
            if ($this->bom_1000->Visible && $this->bom_1000->Required) {
                if (!$this->bom_1000->IsDetailKey && EmptyValue($this->bom_1000->FormValue)) {
                    $this->bom_1000->addErrorMessage(str_replace("%s", $this->bom_1000->caption(), $this->bom_1000->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->bom_1000->FormValue)) {
                $this->bom_1000->addErrorMessage($this->bom_1000->getErrorMessage(false));
            }
            if ($this->batch_authorized_id->Visible && $this->batch_authorized_id->Required) {
                if (!$this->batch_authorized_id->IsDetailKey && EmptyValue($this->batch_authorized_id->FormValue)) {
                    $this->batch_authorized_id->addErrorMessage(str_replace("%s", $this->batch_authorized_id->caption(), $this->batch_authorized_id->RequiredErrorMessage));
                }
            }
            if ($this->tufting_plan_active->Visible && $this->tufting_plan_active->Required) {
                if (!$this->tufting_plan_active->IsDetailKey && EmptyValue($this->tufting_plan_active->FormValue)) {
                    $this->tufting_plan_active->addErrorMessage(str_replace("%s", $this->tufting_plan_active->caption(), $this->tufting_plan_active->RequiredErrorMessage));
                }
            }
            if ($this->tufting_plan_sgrp->Visible && $this->tufting_plan_sgrp->Required) {
                if ($this->tufting_plan_sgrp->FormValue == "") {
                    $this->tufting_plan_sgrp->addErrorMessage(str_replace("%s", $this->tufting_plan_sgrp->caption(), $this->tufting_plan_sgrp->RequiredErrorMessage));
                }
            }
            if ($this->tufting_plan_loom_group->Visible && $this->tufting_plan_loom_group->Required) {
                if (!$this->tufting_plan_loom_group->IsDetailKey && EmptyValue($this->tufting_plan_loom_group->FormValue)) {
                    $this->tufting_plan_loom_group->addErrorMessage(str_replace("%s", $this->tufting_plan_loom_group->caption(), $this->tufting_plan_loom_group->RequiredErrorMessage));
                }
            }
            if ($this->tufting_performance_percent->Visible && $this->tufting_performance_percent->Required) {
                if (!$this->tufting_performance_percent->IsDetailKey && EmptyValue($this->tufting_performance_percent->FormValue)) {
                    $this->tufting_performance_percent->addErrorMessage(str_replace("%s", $this->tufting_performance_percent->caption(), $this->tufting_performance_percent->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->tufting_performance_percent->FormValue)) {
                $this->tufting_performance_percent->addErrorMessage($this->tufting_performance_percent->getErrorMessage(false));
            }
            if ($this->jc_weeks->Visible && $this->jc_weeks->Required) {
                if (!$this->jc_weeks->IsDetailKey && EmptyValue($this->jc_weeks->FormValue)) {
                    $this->jc_weeks->addErrorMessage(str_replace("%s", $this->jc_weeks->caption(), $this->jc_weeks->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jc_weeks->FormValue)) {
                $this->jc_weeks->addErrorMessage($this->jc_weeks->getErrorMessage(false));
            }
            if ($this->required_material_overall_update->Visible && $this->required_material_overall_update->Required) {
                if (!$this->required_material_overall_update->IsDetailKey && EmptyValue($this->required_material_overall_update->FormValue)) {
                    $this->required_material_overall_update->addErrorMessage(str_replace("%s", $this->required_material_overall_update->caption(), $this->required_material_overall_update->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->required_material_overall_update->FormValue)) {
                $this->required_material_overall_update->addErrorMessage($this->required_material_overall_update->getErrorMessage(false));
            }
            if ($this->jc_material_issue->Visible && $this->jc_material_issue->Required) {
                if (!$this->jc_material_issue->IsDetailKey && EmptyValue($this->jc_material_issue->FormValue)) {
                    $this->jc_material_issue->addErrorMessage(str_replace("%s", $this->jc_material_issue->caption(), $this->jc_material_issue->RequiredErrorMessage));
                }
            }
            if ($this->jc_qr->Visible && $this->jc_qr->Required) {
                if (!$this->jc_qr->IsDetailKey && EmptyValue($this->jc_qr->FormValue)) {
                    $this->jc_qr->addErrorMessage(str_replace("%s", $this->jc_qr->caption(), $this->jc_qr->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jc_qr->FormValue)) {
                $this->jc_qr->addErrorMessage($this->jc_qr->getErrorMessage(false));
            }
            if ($this->jc_mrlot->Visible && $this->jc_mrlot->Required) {
                if (!$this->jc_mrlot->IsDetailKey && EmptyValue($this->jc_mrlot->FormValue)) {
                    $this->jc_mrlot->addErrorMessage(str_replace("%s", $this->jc_mrlot->caption(), $this->jc_mrlot->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->max_jobcard->Visible && $this->max_jobcard->Required) {
                if (!$this->max_jobcard->IsDetailKey && EmptyValue($this->max_jobcard->FormValue)) {
                    $this->max_jobcard->addErrorMessage(str_replace("%s", $this->max_jobcard->caption(), $this->max_jobcard->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->max_jobcard->FormValue)) {
                $this->max_jobcard->addErrorMessage($this->max_jobcard->getErrorMessage(false));
            }
            if ($this->jc_pending_delete_days->Visible && $this->jc_pending_delete_days->Required) {
                if (!$this->jc_pending_delete_days->IsDetailKey && EmptyValue($this->jc_pending_delete_days->FormValue)) {
                    $this->jc_pending_delete_days->addErrorMessage(str_replace("%s", $this->jc_pending_delete_days->caption(), $this->jc_pending_delete_days->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jc_pending_delete_days->FormValue)) {
                $this->jc_pending_delete_days->addErrorMessage($this->jc_pending_delete_days->getErrorMessage(false));
            }
            if ($this->batch_pp_id->Visible && $this->batch_pp_id->Required) {
                if (!$this->batch_pp_id->IsDetailKey && EmptyValue($this->batch_pp_id->FormValue)) {
                    $this->batch_pp_id->addErrorMessage(str_replace("%s", $this->batch_pp_id->caption(), $this->batch_pp_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->batch_pp_id->FormValue)) {
                $this->batch_pp_id->addErrorMessage($this->batch_pp_id->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->id->CurrentValue != "") { // Check field with unique index
            $filter = "(`id` = " . AdjustSql($this->id->CurrentValue, $this->Dbid) . ")";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->id->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->id->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);

        // Check if key value entered
        if ($insertRow && $this->ValidateKey && strval($rsnew['id']) == "") {
            $this->setFailureMessage($Language->phrase("InvalidKeyValue"));
            $insertRow = false;
        }

        // Check for duplicate key
        if ($insertRow && $this->ValidateKey) {
            $filter = $this->getRecordFilter($rsnew);
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
                $this->setFailureMessage($keyErrMsg);
                $insertRow = false;
            }
        }
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // id
        $this->id->setDbValueDef($rsnew, $this->id->CurrentValue, false);

        // cs_min_width
        $this->cs_min_width->setDbValueDef($rsnew, $this->cs_min_width->CurrentValue, strval($this->cs_min_width->CurrentValue) == "");

        // cs_min_qty
        $this->cs_min_qty->setDbValueDef($rsnew, $this->cs_min_qty->CurrentValue, strval($this->cs_min_qty->CurrentValue) == "");

        // payment_sqm
        $this->payment_sqm->setDbValueDef($rsnew, $this->payment_sqm->CurrentValue, strval($this->payment_sqm->CurrentValue) == "");

        // payment_sqm_byepass_category
        $this->payment_sqm_byepass_category->setDbValueDef($rsnew, $this->payment_sqm_byepass_category->CurrentValue, strval($this->payment_sqm_byepass_category->CurrentValue) == "");

        // process_byepass
        $this->process_byepass->setDbValueDef($rsnew, $this->process_byepass->CurrentValue, strval($this->process_byepass->CurrentValue) == "");

        // jc_bom_wastage
        $this->jc_bom_wastage->setDbValueDef($rsnew, $this->jc_bom_wastage->CurrentValue, strval($this->jc_bom_wastage->CurrentValue) == "");

        // bom_1000
        $this->bom_1000->setDbValueDef($rsnew, $this->bom_1000->CurrentValue, strval($this->bom_1000->CurrentValue) == "");

        // batch_authorized_id
        $this->batch_authorized_id->setDbValueDef($rsnew, $this->batch_authorized_id->CurrentValue, strval($this->batch_authorized_id->CurrentValue) == "");

        // tufting_plan_active
        $this->tufting_plan_active->setDbValueDef($rsnew, $this->tufting_plan_active->CurrentValue, strval($this->tufting_plan_active->CurrentValue) == "");

        // tufting_plan_sgrp
        $this->tufting_plan_sgrp->setDbValueDef($rsnew, $this->tufting_plan_sgrp->CurrentValue, false);

        // tufting_plan_loom_group
        $this->tufting_plan_loom_group->setDbValueDef($rsnew, $this->tufting_plan_loom_group->CurrentValue, strval($this->tufting_plan_loom_group->CurrentValue) == "");

        // tufting_performance_percent
        $this->tufting_performance_percent->setDbValueDef($rsnew, $this->tufting_performance_percent->CurrentValue, false);

        // jc_weeks
        $this->jc_weeks->setDbValueDef($rsnew, $this->jc_weeks->CurrentValue, strval($this->jc_weeks->CurrentValue) == "");

        // required_material_overall_update
        $this->required_material_overall_update->setDbValueDef($rsnew, $this->required_material_overall_update->CurrentValue, strval($this->required_material_overall_update->CurrentValue) == "");

        // jc_material_issue
        $this->jc_material_issue->setDbValueDef($rsnew, $this->jc_material_issue->CurrentValue, strval($this->jc_material_issue->CurrentValue) == "");

        // jc_qr
        $this->jc_qr->setDbValueDef($rsnew, $this->jc_qr->CurrentValue, false);

        // jc_mrlot
        $this->jc_mrlot->setDbValueDef($rsnew, $this->jc_mrlot->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // max_jobcard
        $this->max_jobcard->setDbValueDef($rsnew, $this->max_jobcard->CurrentValue, strval($this->max_jobcard->CurrentValue) == "");

        // jc_pending_delete_days
        $this->jc_pending_delete_days->setDbValueDef($rsnew, $this->jc_pending_delete_days->CurrentValue, strval($this->jc_pending_delete_days->CurrentValue) == "");

        // batch_pp_id
        $this->batch_pp_id->setDbValueDef($rsnew, $this->batch_pp_id->CurrentValue, strval($this->batch_pp_id->CurrentValue) == "");
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['id'])) { // id
            $this->id->setFormValue($row['id']);
        }
        if (isset($row['cs_min_width'])) { // cs_min_width
            $this->cs_min_width->setFormValue($row['cs_min_width']);
        }
        if (isset($row['cs_min_qty'])) { // cs_min_qty
            $this->cs_min_qty->setFormValue($row['cs_min_qty']);
        }
        if (isset($row['payment_sqm'])) { // payment_sqm
            $this->payment_sqm->setFormValue($row['payment_sqm']);
        }
        if (isset($row['payment_sqm_byepass_category'])) { // payment_sqm_byepass_category
            $this->payment_sqm_byepass_category->setFormValue($row['payment_sqm_byepass_category']);
        }
        if (isset($row['process_byepass'])) { // process_byepass
            $this->process_byepass->setFormValue($row['process_byepass']);
        }
        if (isset($row['jc_bom_wastage'])) { // jc_bom_wastage
            $this->jc_bom_wastage->setFormValue($row['jc_bom_wastage']);
        }
        if (isset($row['bom_1000'])) { // bom_1000
            $this->bom_1000->setFormValue($row['bom_1000']);
        }
        if (isset($row['batch_authorized_id'])) { // batch_authorized_id
            $this->batch_authorized_id->setFormValue($row['batch_authorized_id']);
        }
        if (isset($row['tufting_plan_active'])) { // tufting_plan_active
            $this->tufting_plan_active->setFormValue($row['tufting_plan_active']);
        }
        if (isset($row['tufting_plan_sgrp'])) { // tufting_plan_sgrp
            $this->tufting_plan_sgrp->setFormValue($row['tufting_plan_sgrp']);
        }
        if (isset($row['tufting_plan_loom_group'])) { // tufting_plan_loom_group
            $this->tufting_plan_loom_group->setFormValue($row['tufting_plan_loom_group']);
        }
        if (isset($row['tufting_performance_percent'])) { // tufting_performance_percent
            $this->tufting_performance_percent->setFormValue($row['tufting_performance_percent']);
        }
        if (isset($row['jc_weeks'])) { // jc_weeks
            $this->jc_weeks->setFormValue($row['jc_weeks']);
        }
        if (isset($row['required_material_overall_update'])) { // required_material_overall_update
            $this->required_material_overall_update->setFormValue($row['required_material_overall_update']);
        }
        if (isset($row['jc_material_issue'])) { // jc_material_issue
            $this->jc_material_issue->setFormValue($row['jc_material_issue']);
        }
        if (isset($row['jc_qr'])) { // jc_qr
            $this->jc_qr->setFormValue($row['jc_qr']);
        }
        if (isset($row['jc_mrlot'])) { // jc_mrlot
            $this->jc_mrlot->setFormValue($row['jc_mrlot']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['max_jobcard'])) { // max_jobcard
            $this->max_jobcard->setFormValue($row['max_jobcard']);
        }
        if (isset($row['jc_pending_delete_days'])) { // jc_pending_delete_days
            $this->jc_pending_delete_days->setFormValue($row['jc_pending_delete_days']);
        }
        if (isset($row['batch_pp_id'])) { // batch_pp_id
            $this->batch_pp_id->setFormValue($row['batch_pp_id']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("carpetsetuplist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_payment_sqm":
                    break;
                case "x_payment_sqm_byepass_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_byepass":
                    break;
                case "x_jc_bom_wastage":
                    break;
                case "x_batch_authorized_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_tufting_plan_active":
                    break;
                case "x_tufting_plan_sgrp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_tufting_plan_loom_group":
                    break;
                case "x_jc_material_issue":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
