<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for carpet_setup
 */
class CarpetSetup extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $cs_min_width;
    public $cs_min_qty;
    public $payment_sqm;
    public $payment_sqm_byepass_category;
    public $process_byepass;
    public $jc_bom_wastage;
    public $bom_1000;
    public $batch_authorized_id;
    public $tufting_plan_active;
    public $tufting_plan_sgrp;
    public $tufting_plan_loom_group;
    public $tufting_performance_percent;
    public $jc_weeks;
    public $required_material_overall_update;
    public $jc_material_issue;
    public $jc_qr;
    public $jc_mrlot;
    public $operator;
    public $datetime;
    public $max_jobcard;
    public $jc_pending_delete_days;
    public $batch_pp_id;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "carpet_setup";
        $this->TableName = 'carpet_setup';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "carpet_setup";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->Required = true; // Required field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // cs_min_width
        $this->cs_min_width = new DbField(
            $this, // Table
            'x_cs_min_width', // Variable name
            'cs_min_width', // Name
            '`cs_min_width`', // Expression
            '`cs_min_width`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cs_min_width`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cs_min_width->addMethod("getDefault", fn() => 0.00);
        $this->cs_min_width->InputTextType = "text";
        $this->cs_min_width->Raw = true;
        $this->cs_min_width->Required = true; // Required field
        $this->cs_min_width->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->cs_min_width->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['cs_min_width'] = &$this->cs_min_width;

        // cs_min_qty
        $this->cs_min_qty = new DbField(
            $this, // Table
            'x_cs_min_qty', // Variable name
            'cs_min_qty', // Name
            '`cs_min_qty`', // Expression
            '`cs_min_qty`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cs_min_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cs_min_qty->addMethod("getDefault", fn() => 1);
        $this->cs_min_qty->InputTextType = "text";
        $this->cs_min_qty->Raw = true;
        $this->cs_min_qty->Required = true; // Required field
        $this->cs_min_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->cs_min_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['cs_min_qty'] = &$this->cs_min_qty;

        // payment_sqm
        $this->payment_sqm = new DbField(
            $this, // Table
            'x_payment_sqm', // Variable name
            'payment_sqm', // Name
            '`payment_sqm`', // Expression
            '`payment_sqm`', // Basic search expression
            200, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->payment_sqm->addMethod("getDefault", fn() => "sqm");
        $this->payment_sqm->InputTextType = "text";
        $this->payment_sqm->Nullable = false; // NOT NULL field
        $this->payment_sqm->Required = true; // Required field
        $this->payment_sqm->setSelectMultiple(false); // Select one
        $this->payment_sqm->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->payment_sqm->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->payment_sqm->Lookup = new Lookup($this->payment_sqm, 'carpet_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->payment_sqm->OptionCount = 2;
        $this->payment_sqm->SearchOperators = ["=", "<>"];
        $this->Fields['payment_sqm'] = &$this->payment_sqm;

        // payment_sqm_byepass_category
        $this->payment_sqm_byepass_category = new DbField(
            $this, // Table
            'x_payment_sqm_byepass_category', // Variable name
            'payment_sqm_byepass_category', // Name
            '`payment_sqm_byepass_category`', // Expression
            '`payment_sqm_byepass_category`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_sqm_byepass_category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->payment_sqm_byepass_category->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->payment_sqm_byepass_category->addMethod("getDefault", fn() => "0");
        $this->payment_sqm_byepass_category->InputTextType = "text";
        $this->payment_sqm_byepass_category->Nullable = false; // NOT NULL field
        $this->payment_sqm_byepass_category->Lookup = new Lookup($this->payment_sqm_byepass_category, 'product_category', false, 'id', ["id","item","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->payment_sqm_byepass_category) . "',COALESCE(`item`,''))");
        $this->payment_sqm_byepass_category->SearchOperators = ["=", "<>"];
        $this->Fields['payment_sqm_byepass_category'] = &$this->payment_sqm_byepass_category;

        // process_byepass
        $this->process_byepass = new DbField(
            $this, // Table
            'x_process_byepass', // Variable name
            'process_byepass', // Name
            '`process_byepass`', // Expression
            '`process_byepass`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_byepass`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process_byepass->addMethod("getDefault", fn() => 0);
        $this->process_byepass->InputTextType = "text";
        $this->process_byepass->Raw = true;
        $this->process_byepass->Nullable = false; // NOT NULL field
        $this->process_byepass->Required = true; // Required field
        $this->process_byepass->setSelectMultiple(false); // Select one
        $this->process_byepass->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process_byepass->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process_byepass->Lookup = new Lookup($this->process_byepass, 'carpet_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->process_byepass->OptionCount = 2;
        $this->process_byepass->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process_byepass->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['process_byepass'] = &$this->process_byepass;

        // jc_bom_wastage
        $this->jc_bom_wastage = new DbField(
            $this, // Table
            'x_jc_bom_wastage', // Variable name
            'jc_bom_wastage', // Name
            '`jc_bom_wastage`', // Expression
            '`jc_bom_wastage`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_bom_wastage`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->jc_bom_wastage->addMethod("getDefault", fn() => 0);
        $this->jc_bom_wastage->InputTextType = "text";
        $this->jc_bom_wastage->Raw = true;
        $this->jc_bom_wastage->Nullable = false; // NOT NULL field
        $this->jc_bom_wastage->Required = true; // Required field
        $this->jc_bom_wastage->setSelectMultiple(false); // Select one
        $this->jc_bom_wastage->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->jc_bom_wastage->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->jc_bom_wastage->Lookup = new Lookup($this->jc_bom_wastage, 'carpet_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->jc_bom_wastage->OptionCount = 2;
        $this->jc_bom_wastage->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_bom_wastage->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jc_bom_wastage'] = &$this->jc_bom_wastage;

        // bom_1000
        $this->bom_1000 = new DbField(
            $this, // Table
            'x_bom_1000', // Variable name
            'bom_1000', // Name
            '`bom_1000`', // Expression
            '`bom_1000`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bom_1000`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bom_1000->addMethod("getDefault", fn() => 0);
        $this->bom_1000->InputTextType = "text";
        $this->bom_1000->Raw = true;
        $this->bom_1000->Nullable = false; // NOT NULL field
        $this->bom_1000->Required = true; // Required field
        $this->bom_1000->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->bom_1000->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['bom_1000'] = &$this->bom_1000;

        // batch_authorized_id
        $this->batch_authorized_id = new DbField(
            $this, // Table
            'x_batch_authorized_id', // Variable name
            'batch_authorized_id', // Name
            '`batch_authorized_id`', // Expression
            '`batch_authorized_id`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_authorized_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->batch_authorized_id->addMethod("getSelectFilter", fn() => "`activated`=1");
        $this->batch_authorized_id->addMethod("getDefault", fn() => "51");
        $this->batch_authorized_id->InputTextType = "text";
        $this->batch_authorized_id->setSelectMultiple(false); // Select one
        $this->batch_authorized_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->batch_authorized_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->batch_authorized_id->Lookup = new Lookup($this->batch_authorized_id, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->batch_authorized_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->batch_authorized_id->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_authorized_id'] = &$this->batch_authorized_id;

        // tufting_plan_active
        $this->tufting_plan_active = new DbField(
            $this, // Table
            'x_tufting_plan_active', // Variable name
            'tufting_plan_active', // Name
            '`tufting_plan_active`', // Expression
            '`tufting_plan_active`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tufting_plan_active`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->tufting_plan_active->addMethod("getDefault", fn() => 1);
        $this->tufting_plan_active->InputTextType = "text";
        $this->tufting_plan_active->Raw = true;
        $this->tufting_plan_active->setSelectMultiple(false); // Select one
        $this->tufting_plan_active->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->tufting_plan_active->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->tufting_plan_active->Lookup = new Lookup($this->tufting_plan_active, 'carpet_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->tufting_plan_active->OptionCount = 2;
        $this->tufting_plan_active->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->tufting_plan_active->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tufting_plan_active'] = &$this->tufting_plan_active;

        // tufting_plan_sgrp
        $this->tufting_plan_sgrp = new DbField(
            $this, // Table
            'x_tufting_plan_sgrp', // Variable name
            'tufting_plan_sgrp', // Name
            '`tufting_plan_sgrp`', // Expression
            '`tufting_plan_sgrp`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tufting_plan_sgrp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->tufting_plan_sgrp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->tufting_plan_sgrp->InputTextType = "text";
        $this->tufting_plan_sgrp->Required = true; // Required field
        $this->tufting_plan_sgrp->setSelectMultiple(true); // Select multiple
        $this->tufting_plan_sgrp->Lookup = new Lookup($this->tufting_plan_sgrp, 'product_group', false, 'id', ["product_group","","",""], '', '', [], [], [], [], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->tufting_plan_sgrp->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['tufting_plan_sgrp'] = &$this->tufting_plan_sgrp;

        // tufting_plan_loom_group
        $this->tufting_plan_loom_group = new DbField(
            $this, // Table
            'x_tufting_plan_loom_group', // Variable name
            'tufting_plan_loom_group', // Name
            '`tufting_plan_loom_group`', // Expression
            '`tufting_plan_loom_group`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tufting_plan_loom_group`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->tufting_plan_loom_group->addMethod("getDefault", fn() => 0);
        $this->tufting_plan_loom_group->InputTextType = "text";
        $this->tufting_plan_loom_group->Raw = true;
        $this->tufting_plan_loom_group->Required = true; // Required field
        $this->tufting_plan_loom_group->setSelectMultiple(false); // Select one
        $this->tufting_plan_loom_group->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->tufting_plan_loom_group->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->tufting_plan_loom_group->Lookup = new Lookup($this->tufting_plan_loom_group, 'carpet_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->tufting_plan_loom_group->OptionCount = 2;
        $this->tufting_plan_loom_group->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->tufting_plan_loom_group->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tufting_plan_loom_group'] = &$this->tufting_plan_loom_group;

        // tufting_performance_percent
        $this->tufting_performance_percent = new DbField(
            $this, // Table
            'x_tufting_performance_percent', // Variable name
            'tufting_performance_percent', // Name
            '`tufting_performance_percent`', // Expression
            '`tufting_performance_percent`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tufting_performance_percent`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tufting_performance_percent->InputTextType = "text";
        $this->tufting_performance_percent->Raw = true;
        $this->tufting_performance_percent->Nullable = false; // NOT NULL field
        $this->tufting_performance_percent->Required = true; // Required field
        $this->tufting_performance_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->tufting_performance_percent->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['tufting_performance_percent'] = &$this->tufting_performance_percent;

        // jc_weeks
        $this->jc_weeks = new DbField(
            $this, // Table
            'x_jc_weeks', // Variable name
            'jc_weeks', // Name
            '`jc_weeks`', // Expression
            '`jc_weeks`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_weeks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_weeks->InputTextType = "text";
        $this->jc_weeks->Raw = true;
        $this->jc_weeks->Nullable = false; // NOT NULL field
        $this->jc_weeks->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_weeks->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jc_weeks'] = &$this->jc_weeks;

        // required_material_overall_update
        $this->required_material_overall_update = new DbField(
            $this, // Table
            'x_required_material_overall_update', // Variable name
            'required_material_overall_update', // Name
            '`required_material_overall_update`', // Expression
            '`required_material_overall_update`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`required_material_overall_update`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->required_material_overall_update->addMethod("getDefault", fn() => 1);
        $this->required_material_overall_update->InputTextType = "text";
        $this->required_material_overall_update->Raw = true;
        $this->required_material_overall_update->Nullable = false; // NOT NULL field
        $this->required_material_overall_update->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->required_material_overall_update->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['required_material_overall_update'] = &$this->required_material_overall_update;

        // jc_material_issue
        $this->jc_material_issue = new DbField(
            $this, // Table
            'x_jc_material_issue', // Variable name
            'jc_material_issue', // Name
            '`jc_material_issue`', // Expression
            '`jc_material_issue`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_material_issue`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->jc_material_issue->addMethod("getDefault", fn() => 0);
        $this->jc_material_issue->InputTextType = "text";
        $this->jc_material_issue->Raw = true;
        $this->jc_material_issue->setSelectMultiple(false); // Select one
        $this->jc_material_issue->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->jc_material_issue->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->jc_material_issue->Lookup = new Lookup($this->jc_material_issue, 'carpet_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->jc_material_issue->OptionCount = 3;
        $this->jc_material_issue->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_material_issue->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_material_issue'] = &$this->jc_material_issue;

        // jc_qr
        $this->jc_qr = new DbField(
            $this, // Table
            'x_jc_qr', // Variable name
            'jc_qr', // Name
            '`jc_qr`', // Expression
            '`jc_qr`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_qr`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_qr->InputTextType = "text";
        $this->jc_qr->Raw = true;
        $this->jc_qr->Nullable = false; // NOT NULL field
        $this->jc_qr->Required = true; // Required field
        $this->jc_qr->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_qr->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jc_qr'] = &$this->jc_qr;

        // jc_mrlot
        $this->jc_mrlot = new DbField(
            $this, // Table
            'x_jc_mrlot', // Variable name
            'jc_mrlot', // Name
            '`jc_mrlot`', // Expression
            '`jc_mrlot`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_mrlot`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_mrlot->InputTextType = "text";
        $this->jc_mrlot->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_mrlot'] = &$this->jc_mrlot;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // max_jobcard
        $this->max_jobcard = new DbField(
            $this, // Table
            'x_max_jobcard', // Variable name
            'max_jobcard', // Name
            '`max_jobcard`', // Expression
            '`max_jobcard`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`max_jobcard`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->max_jobcard->addMethod("getDefault", fn() => 2);
        $this->max_jobcard->InputTextType = "text";
        $this->max_jobcard->Raw = true;
        $this->max_jobcard->Nullable = false; // NOT NULL field
        $this->max_jobcard->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->max_jobcard->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['max_jobcard'] = &$this->max_jobcard;

        // jc_pending_delete_days
        $this->jc_pending_delete_days = new DbField(
            $this, // Table
            'x_jc_pending_delete_days', // Variable name
            'jc_pending_delete_days', // Name
            '`jc_pending_delete_days`', // Expression
            '`jc_pending_delete_days`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_pending_delete_days`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_pending_delete_days->addMethod("getDefault", fn() => 5);
        $this->jc_pending_delete_days->InputTextType = "text";
        $this->jc_pending_delete_days->Raw = true;
        $this->jc_pending_delete_days->Nullable = false; // NOT NULL field
        $this->jc_pending_delete_days->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_pending_delete_days->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jc_pending_delete_days'] = &$this->jc_pending_delete_days;

        // batch_pp_id
        $this->batch_pp_id = new DbField(
            $this, // Table
            'x_batch_pp_id', // Variable name
            'batch_pp_id', // Name
            '`batch_pp_id`', // Expression
            '`batch_pp_id`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_pp_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->batch_pp_id->addMethod("getDefault", fn() => 0);
        $this->batch_pp_id->InputTextType = "text";
        $this->batch_pp_id->Raw = true;
        $this->batch_pp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->batch_pp_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_pp_id'] = &$this->batch_pp_id;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "carpet_setup";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->cs_min_width->DbValue = $row['cs_min_width'];
        $this->cs_min_qty->DbValue = $row['cs_min_qty'];
        $this->payment_sqm->DbValue = $row['payment_sqm'];
        $this->payment_sqm_byepass_category->DbValue = $row['payment_sqm_byepass_category'];
        $this->process_byepass->DbValue = $row['process_byepass'];
        $this->jc_bom_wastage->DbValue = $row['jc_bom_wastage'];
        $this->bom_1000->DbValue = $row['bom_1000'];
        $this->batch_authorized_id->DbValue = $row['batch_authorized_id'];
        $this->tufting_plan_active->DbValue = $row['tufting_plan_active'];
        $this->tufting_plan_sgrp->DbValue = $row['tufting_plan_sgrp'];
        $this->tufting_plan_loom_group->DbValue = $row['tufting_plan_loom_group'];
        $this->tufting_performance_percent->DbValue = $row['tufting_performance_percent'];
        $this->jc_weeks->DbValue = $row['jc_weeks'];
        $this->required_material_overall_update->DbValue = $row['required_material_overall_update'];
        $this->jc_material_issue->DbValue = $row['jc_material_issue'];
        $this->jc_qr->DbValue = $row['jc_qr'];
        $this->jc_mrlot->DbValue = $row['jc_mrlot'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->max_jobcard->DbValue = $row['max_jobcard'];
        $this->jc_pending_delete_days->DbValue = $row['jc_pending_delete_days'];
        $this->batch_pp_id->DbValue = $row['batch_pp_id'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("carpetsetuplist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "carpetsetupview" => $Language->phrase("View"),
            "carpetsetupedit" => $Language->phrase("Edit"),
            "carpetsetupadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "carpetsetuplist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "CarpetSetupView",
            Config("API_ADD_ACTION") => "CarpetSetupAdd",
            Config("API_EDIT_ACTION") => "CarpetSetupEdit",
            Config("API_DELETE_ACTION") => "CarpetSetupDelete",
            Config("API_LIST_ACTION") => "CarpetSetupList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "carpetsetuplist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("carpetsetupview", $parm);
        } else {
            $url = $this->keyUrl("carpetsetupview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "carpetsetupadd?" . $parm;
        } else {
            $url = "carpetsetupadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("carpetsetupedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("carpetsetuplist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("carpetsetupadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("carpetsetuplist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("carpetsetupdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->cs_min_width->setDbValue($row['cs_min_width']);
        $this->cs_min_qty->setDbValue($row['cs_min_qty']);
        $this->payment_sqm->setDbValue($row['payment_sqm']);
        $this->payment_sqm_byepass_category->setDbValue($row['payment_sqm_byepass_category']);
        $this->process_byepass->setDbValue($row['process_byepass']);
        $this->jc_bom_wastage->setDbValue($row['jc_bom_wastage']);
        $this->bom_1000->setDbValue($row['bom_1000']);
        $this->batch_authorized_id->setDbValue($row['batch_authorized_id']);
        $this->tufting_plan_active->setDbValue($row['tufting_plan_active']);
        $this->tufting_plan_sgrp->setDbValue($row['tufting_plan_sgrp']);
        $this->tufting_plan_loom_group->setDbValue($row['tufting_plan_loom_group']);
        $this->tufting_performance_percent->setDbValue($row['tufting_performance_percent']);
        $this->jc_weeks->setDbValue($row['jc_weeks']);
        $this->required_material_overall_update->setDbValue($row['required_material_overall_update']);
        $this->jc_material_issue->setDbValue($row['jc_material_issue']);
        $this->jc_qr->setDbValue($row['jc_qr']);
        $this->jc_mrlot->setDbValue($row['jc_mrlot']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->max_jobcard->setDbValue($row['max_jobcard']);
        $this->jc_pending_delete_days->setDbValue($row['jc_pending_delete_days']);
        $this->batch_pp_id->setDbValue($row['batch_pp_id']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "CarpetSetupList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // cs_min_width

        // cs_min_qty

        // payment_sqm

        // payment_sqm_byepass_category

        // process_byepass

        // jc_bom_wastage

        // bom_1000

        // batch_authorized_id

        // tufting_plan_active

        // tufting_plan_sgrp

        // tufting_plan_loom_group

        // tufting_performance_percent

        // jc_weeks

        // required_material_overall_update

        // jc_material_issue

        // jc_qr

        // jc_mrlot

        // operator

        // datetime
        $this->datetime->CellCssStyle = "white-space: nowrap;";

        // max_jobcard

        // jc_pending_delete_days

        // batch_pp_id

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // cs_min_width
        $this->cs_min_width->ViewValue = $this->cs_min_width->CurrentValue;
        $this->cs_min_width->ViewValue = FormatNumber($this->cs_min_width->ViewValue, $this->cs_min_width->formatPattern());

        // cs_min_qty
        $this->cs_min_qty->ViewValue = $this->cs_min_qty->CurrentValue;
        $this->cs_min_qty->ViewValue = FormatNumber($this->cs_min_qty->ViewValue, $this->cs_min_qty->formatPattern());

        // payment_sqm
        if (strval($this->payment_sqm->CurrentValue) != "") {
            $this->payment_sqm->ViewValue = $this->payment_sqm->optionCaption($this->payment_sqm->CurrentValue);
        } else {
            $this->payment_sqm->ViewValue = null;
        }

        // payment_sqm_byepass_category
        $curVal = strval($this->payment_sqm_byepass_category->CurrentValue);
        if ($curVal != "") {
            $this->payment_sqm_byepass_category->ViewValue = $this->payment_sqm_byepass_category->lookupCacheOption($curVal);
            if ($this->payment_sqm_byepass_category->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->payment_sqm_byepass_category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment_sqm_byepass_category->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->payment_sqm_byepass_category->getSelectFilter($this); // PHP
                $sqlWrk = $this->payment_sqm_byepass_category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->payment_sqm_byepass_category->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->payment_sqm_byepass_category->Lookup->renderViewRow($row);
                        $this->payment_sqm_byepass_category->ViewValue->add($this->payment_sqm_byepass_category->displayValue($arwrk));
                    }
                } else {
                    $this->payment_sqm_byepass_category->ViewValue = $this->payment_sqm_byepass_category->CurrentValue;
                }
            }
        } else {
            $this->payment_sqm_byepass_category->ViewValue = null;
        }

        // process_byepass
        if (strval($this->process_byepass->CurrentValue) != "") {
            $this->process_byepass->ViewValue = $this->process_byepass->optionCaption($this->process_byepass->CurrentValue);
        } else {
            $this->process_byepass->ViewValue = null;
        }

        // jc_bom_wastage
        if (strval($this->jc_bom_wastage->CurrentValue) != "") {
            $this->jc_bom_wastage->ViewValue = $this->jc_bom_wastage->optionCaption($this->jc_bom_wastage->CurrentValue);
        } else {
            $this->jc_bom_wastage->ViewValue = null;
        }

        // bom_1000
        $this->bom_1000->ViewValue = $this->bom_1000->CurrentValue;
        $this->bom_1000->ViewValue = FormatNumber($this->bom_1000->ViewValue, $this->bom_1000->formatPattern());

        // batch_authorized_id
        $curVal = strval($this->batch_authorized_id->CurrentValue);
        if ($curVal != "") {
            $this->batch_authorized_id->ViewValue = $this->batch_authorized_id->lookupCacheOption($curVal);
            if ($this->batch_authorized_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->batch_authorized_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_authorized_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->batch_authorized_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_authorized_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_authorized_id->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_authorized_id->ViewValue = $this->batch_authorized_id->displayValue($arwrk);
                } else {
                    $this->batch_authorized_id->ViewValue = $this->batch_authorized_id->CurrentValue;
                }
            }
        } else {
            $this->batch_authorized_id->ViewValue = null;
        }

        // tufting_plan_active
        if (strval($this->tufting_plan_active->CurrentValue) != "") {
            $this->tufting_plan_active->ViewValue = $this->tufting_plan_active->optionCaption($this->tufting_plan_active->CurrentValue);
        } else {
            $this->tufting_plan_active->ViewValue = null;
        }

        // tufting_plan_sgrp
        $curVal = strval($this->tufting_plan_sgrp->CurrentValue);
        if ($curVal != "") {
            $this->tufting_plan_sgrp->ViewValue = $this->tufting_plan_sgrp->lookupCacheOption($curVal);
            if ($this->tufting_plan_sgrp->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->tufting_plan_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->tufting_plan_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->tufting_plan_sgrp->getSelectFilter($this); // PHP
                $sqlWrk = $this->tufting_plan_sgrp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->tufting_plan_sgrp->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->tufting_plan_sgrp->Lookup->renderViewRow($row);
                        $this->tufting_plan_sgrp->ViewValue->add($this->tufting_plan_sgrp->displayValue($arwrk));
                    }
                } else {
                    $this->tufting_plan_sgrp->ViewValue = $this->tufting_plan_sgrp->CurrentValue;
                }
            }
        } else {
            $this->tufting_plan_sgrp->ViewValue = null;
        }

        // tufting_plan_loom_group
        if (strval($this->tufting_plan_loom_group->CurrentValue) != "") {
            $this->tufting_plan_loom_group->ViewValue = $this->tufting_plan_loom_group->optionCaption($this->tufting_plan_loom_group->CurrentValue);
        } else {
            $this->tufting_plan_loom_group->ViewValue = null;
        }

        // tufting_performance_percent
        $this->tufting_performance_percent->ViewValue = $this->tufting_performance_percent->CurrentValue;
        $this->tufting_performance_percent->ViewValue = FormatNumber($this->tufting_performance_percent->ViewValue, $this->tufting_performance_percent->formatPattern());

        // jc_weeks
        $this->jc_weeks->ViewValue = $this->jc_weeks->CurrentValue;
        $this->jc_weeks->ViewValue = FormatNumber($this->jc_weeks->ViewValue, $this->jc_weeks->formatPattern());

        // required_material_overall_update
        $this->required_material_overall_update->ViewValue = $this->required_material_overall_update->CurrentValue;
        $this->required_material_overall_update->ViewValue = FormatNumber($this->required_material_overall_update->ViewValue, $this->required_material_overall_update->formatPattern());

        // jc_material_issue
        if (strval($this->jc_material_issue->CurrentValue) != "") {
            $this->jc_material_issue->ViewValue = $this->jc_material_issue->optionCaption($this->jc_material_issue->CurrentValue);
        } else {
            $this->jc_material_issue->ViewValue = null;
        }

        // jc_qr
        $this->jc_qr->ViewValue = $this->jc_qr->CurrentValue;
        $this->jc_qr->ViewValue = FormatNumber($this->jc_qr->ViewValue, $this->jc_qr->formatPattern());

        // jc_mrlot
        $this->jc_mrlot->ViewValue = $this->jc_mrlot->CurrentValue;

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // max_jobcard
        $this->max_jobcard->ViewValue = $this->max_jobcard->CurrentValue;
        $this->max_jobcard->ViewValue = FormatNumber($this->max_jobcard->ViewValue, $this->max_jobcard->formatPattern());

        // jc_pending_delete_days
        $this->jc_pending_delete_days->ViewValue = $this->jc_pending_delete_days->CurrentValue;
        $this->jc_pending_delete_days->ViewValue = FormatNumber($this->jc_pending_delete_days->ViewValue, $this->jc_pending_delete_days->formatPattern());

        // batch_pp_id
        $this->batch_pp_id->ViewValue = $this->batch_pp_id->CurrentValue;
        $this->batch_pp_id->ViewValue = FormatNumber($this->batch_pp_id->ViewValue, $this->batch_pp_id->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // cs_min_width
        $this->cs_min_width->HrefValue = "";
        $this->cs_min_width->TooltipValue = "";

        // cs_min_qty
        $this->cs_min_qty->HrefValue = "";
        $this->cs_min_qty->TooltipValue = "";

        // payment_sqm
        $this->payment_sqm->HrefValue = "";
        $this->payment_sqm->TooltipValue = "";

        // payment_sqm_byepass_category
        $this->payment_sqm_byepass_category->HrefValue = "";
        $this->payment_sqm_byepass_category->TooltipValue = "";

        // process_byepass
        $this->process_byepass->HrefValue = "";
        $this->process_byepass->TooltipValue = "";

        // jc_bom_wastage
        $this->jc_bom_wastage->HrefValue = "";
        $this->jc_bom_wastage->TooltipValue = "";

        // bom_1000
        $this->bom_1000->HrefValue = "";
        $this->bom_1000->TooltipValue = "";

        // batch_authorized_id
        $this->batch_authorized_id->HrefValue = "";
        $this->batch_authorized_id->TooltipValue = "";

        // tufting_plan_active
        $this->tufting_plan_active->HrefValue = "";
        $this->tufting_plan_active->TooltipValue = "";

        // tufting_plan_sgrp
        $this->tufting_plan_sgrp->HrefValue = "";
        $this->tufting_plan_sgrp->TooltipValue = "";

        // tufting_plan_loom_group
        $this->tufting_plan_loom_group->HrefValue = "";
        $this->tufting_plan_loom_group->TooltipValue = "";

        // tufting_performance_percent
        $this->tufting_performance_percent->HrefValue = "";
        $this->tufting_performance_percent->TooltipValue = "";

        // jc_weeks
        $this->jc_weeks->HrefValue = "";
        $this->jc_weeks->TooltipValue = "";

        // required_material_overall_update
        $this->required_material_overall_update->HrefValue = "";
        $this->required_material_overall_update->TooltipValue = "";

        // jc_material_issue
        $this->jc_material_issue->HrefValue = "";
        $this->jc_material_issue->TooltipValue = "";

        // jc_qr
        $this->jc_qr->HrefValue = "";
        $this->jc_qr->TooltipValue = "";

        // jc_mrlot
        $this->jc_mrlot->HrefValue = "";
        $this->jc_mrlot->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // max_jobcard
        $this->max_jobcard->HrefValue = "";
        $this->max_jobcard->TooltipValue = "";

        // jc_pending_delete_days
        $this->jc_pending_delete_days->HrefValue = "";
        $this->jc_pending_delete_days->TooltipValue = "";

        // batch_pp_id
        $this->batch_pp_id->HrefValue = "";
        $this->batch_pp_id->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());

        // cs_min_width
        $this->cs_min_width->setupEditAttributes();
        $this->cs_min_width->EditValue = $this->cs_min_width->CurrentValue;
        $this->cs_min_width->PlaceHolder = RemoveHtml($this->cs_min_width->caption());
        if (strval($this->cs_min_width->EditValue) != "" && is_numeric($this->cs_min_width->EditValue)) {
            $this->cs_min_width->EditValue = FormatNumber($this->cs_min_width->EditValue, null);
        }

        // cs_min_qty
        $this->cs_min_qty->setupEditAttributes();
        $this->cs_min_qty->EditValue = $this->cs_min_qty->CurrentValue;
        $this->cs_min_qty->PlaceHolder = RemoveHtml($this->cs_min_qty->caption());
        if (strval($this->cs_min_qty->EditValue) != "" && is_numeric($this->cs_min_qty->EditValue)) {
            $this->cs_min_qty->EditValue = FormatNumber($this->cs_min_qty->EditValue, null);
        }

        // payment_sqm
        $this->payment_sqm->setupEditAttributes();
        $this->payment_sqm->EditValue = $this->payment_sqm->options(true);
        $this->payment_sqm->PlaceHolder = RemoveHtml($this->payment_sqm->caption());

        // payment_sqm_byepass_category
        $this->payment_sqm_byepass_category->PlaceHolder = RemoveHtml($this->payment_sqm_byepass_category->caption());

        // process_byepass
        $this->process_byepass->setupEditAttributes();
        $this->process_byepass->EditValue = $this->process_byepass->options(true);
        $this->process_byepass->PlaceHolder = RemoveHtml($this->process_byepass->caption());

        // jc_bom_wastage
        $this->jc_bom_wastage->setupEditAttributes();
        $this->jc_bom_wastage->EditValue = $this->jc_bom_wastage->options(true);
        $this->jc_bom_wastage->PlaceHolder = RemoveHtml($this->jc_bom_wastage->caption());

        // bom_1000
        $this->bom_1000->setupEditAttributes();
        $this->bom_1000->EditValue = $this->bom_1000->CurrentValue;
        $this->bom_1000->PlaceHolder = RemoveHtml($this->bom_1000->caption());
        if (strval($this->bom_1000->EditValue) != "" && is_numeric($this->bom_1000->EditValue)) {
            $this->bom_1000->EditValue = FormatNumber($this->bom_1000->EditValue, null);
        }

        // batch_authorized_id
        $this->batch_authorized_id->setupEditAttributes();
        $this->batch_authorized_id->PlaceHolder = RemoveHtml($this->batch_authorized_id->caption());

        // tufting_plan_active
        $this->tufting_plan_active->setupEditAttributes();
        $this->tufting_plan_active->EditValue = $this->tufting_plan_active->options(true);
        $this->tufting_plan_active->PlaceHolder = RemoveHtml($this->tufting_plan_active->caption());

        // tufting_plan_sgrp
        $this->tufting_plan_sgrp->setupEditAttributes();
        $this->tufting_plan_sgrp->PlaceHolder = RemoveHtml($this->tufting_plan_sgrp->caption());

        // tufting_plan_loom_group
        $this->tufting_plan_loom_group->setupEditAttributes();
        $this->tufting_plan_loom_group->EditValue = $this->tufting_plan_loom_group->options(true);
        $this->tufting_plan_loom_group->PlaceHolder = RemoveHtml($this->tufting_plan_loom_group->caption());

        // tufting_performance_percent
        $this->tufting_performance_percent->setupEditAttributes();
        $this->tufting_performance_percent->EditValue = $this->tufting_performance_percent->CurrentValue;
        $this->tufting_performance_percent->PlaceHolder = RemoveHtml($this->tufting_performance_percent->caption());
        if (strval($this->tufting_performance_percent->EditValue) != "" && is_numeric($this->tufting_performance_percent->EditValue)) {
            $this->tufting_performance_percent->EditValue = FormatNumber($this->tufting_performance_percent->EditValue, null);
        }

        // jc_weeks
        $this->jc_weeks->setupEditAttributes();
        $this->jc_weeks->EditValue = $this->jc_weeks->CurrentValue;
        $this->jc_weeks->PlaceHolder = RemoveHtml($this->jc_weeks->caption());
        if (strval($this->jc_weeks->EditValue) != "" && is_numeric($this->jc_weeks->EditValue)) {
            $this->jc_weeks->EditValue = FormatNumber($this->jc_weeks->EditValue, null);
        }

        // required_material_overall_update
        $this->required_material_overall_update->setupEditAttributes();
        $this->required_material_overall_update->EditValue = $this->required_material_overall_update->CurrentValue;
        $this->required_material_overall_update->PlaceHolder = RemoveHtml($this->required_material_overall_update->caption());
        if (strval($this->required_material_overall_update->EditValue) != "" && is_numeric($this->required_material_overall_update->EditValue)) {
            $this->required_material_overall_update->EditValue = FormatNumber($this->required_material_overall_update->EditValue, null);
        }

        // jc_material_issue
        $this->jc_material_issue->setupEditAttributes();
        $this->jc_material_issue->EditValue = $this->jc_material_issue->options(true);
        $this->jc_material_issue->PlaceHolder = RemoveHtml($this->jc_material_issue->caption());

        // jc_qr
        $this->jc_qr->setupEditAttributes();
        $this->jc_qr->EditValue = $this->jc_qr->CurrentValue;
        $this->jc_qr->PlaceHolder = RemoveHtml($this->jc_qr->caption());
        if (strval($this->jc_qr->EditValue) != "" && is_numeric($this->jc_qr->EditValue)) {
            $this->jc_qr->EditValue = FormatNumber($this->jc_qr->EditValue, null);
        }

        // jc_mrlot
        $this->jc_mrlot->setupEditAttributes();
        if (!$this->jc_mrlot->Raw) {
            $this->jc_mrlot->CurrentValue = HtmlDecode($this->jc_mrlot->CurrentValue);
        }
        $this->jc_mrlot->EditValue = $this->jc_mrlot->CurrentValue;
        $this->jc_mrlot->PlaceHolder = RemoveHtml($this->jc_mrlot->caption());

        // operator

        // datetime

        // max_jobcard
        $this->max_jobcard->setupEditAttributes();
        $this->max_jobcard->EditValue = $this->max_jobcard->CurrentValue;
        $this->max_jobcard->PlaceHolder = RemoveHtml($this->max_jobcard->caption());
        if (strval($this->max_jobcard->EditValue) != "" && is_numeric($this->max_jobcard->EditValue)) {
            $this->max_jobcard->EditValue = FormatNumber($this->max_jobcard->EditValue, null);
        }

        // jc_pending_delete_days
        $this->jc_pending_delete_days->setupEditAttributes();
        $this->jc_pending_delete_days->EditValue = $this->jc_pending_delete_days->CurrentValue;
        $this->jc_pending_delete_days->PlaceHolder = RemoveHtml($this->jc_pending_delete_days->caption());
        if (strval($this->jc_pending_delete_days->EditValue) != "" && is_numeric($this->jc_pending_delete_days->EditValue)) {
            $this->jc_pending_delete_days->EditValue = FormatNumber($this->jc_pending_delete_days->EditValue, null);
        }

        // batch_pp_id
        $this->batch_pp_id->setupEditAttributes();
        $this->batch_pp_id->EditValue = $this->batch_pp_id->CurrentValue;
        $this->batch_pp_id->PlaceHolder = RemoveHtml($this->batch_pp_id->caption());
        if (strval($this->batch_pp_id->EditValue) != "" && is_numeric($this->batch_pp_id->EditValue)) {
            $this->batch_pp_id->EditValue = FormatNumber($this->batch_pp_id->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->cs_min_width);
                    $doc->exportCaption($this->cs_min_qty);
                    $doc->exportCaption($this->payment_sqm);
                    $doc->exportCaption($this->payment_sqm_byepass_category);
                    $doc->exportCaption($this->process_byepass);
                    $doc->exportCaption($this->jc_bom_wastage);
                    $doc->exportCaption($this->bom_1000);
                    $doc->exportCaption($this->batch_authorized_id);
                    $doc->exportCaption($this->tufting_plan_active);
                    $doc->exportCaption($this->tufting_plan_sgrp);
                    $doc->exportCaption($this->tufting_plan_loom_group);
                    $doc->exportCaption($this->tufting_performance_percent);
                    $doc->exportCaption($this->jc_weeks);
                    $doc->exportCaption($this->required_material_overall_update);
                    $doc->exportCaption($this->jc_material_issue);
                    $doc->exportCaption($this->jc_qr);
                    $doc->exportCaption($this->jc_mrlot);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->max_jobcard);
                    $doc->exportCaption($this->jc_pending_delete_days);
                    $doc->exportCaption($this->batch_pp_id);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->cs_min_width);
                    $doc->exportCaption($this->cs_min_qty);
                    $doc->exportCaption($this->payment_sqm);
                    $doc->exportCaption($this->payment_sqm_byepass_category);
                    $doc->exportCaption($this->process_byepass);
                    $doc->exportCaption($this->jc_bom_wastage);
                    $doc->exportCaption($this->bom_1000);
                    $doc->exportCaption($this->batch_authorized_id);
                    $doc->exportCaption($this->tufting_plan_active);
                    $doc->exportCaption($this->tufting_plan_sgrp);
                    $doc->exportCaption($this->tufting_plan_loom_group);
                    $doc->exportCaption($this->tufting_performance_percent);
                    $doc->exportCaption($this->jc_weeks);
                    $doc->exportCaption($this->required_material_overall_update);
                    $doc->exportCaption($this->jc_material_issue);
                    $doc->exportCaption($this->jc_qr);
                    $doc->exportCaption($this->jc_mrlot);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->max_jobcard);
                    $doc->exportCaption($this->jc_pending_delete_days);
                    $doc->exportCaption($this->batch_pp_id);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->cs_min_width);
                        $doc->exportField($this->cs_min_qty);
                        $doc->exportField($this->payment_sqm);
                        $doc->exportField($this->payment_sqm_byepass_category);
                        $doc->exportField($this->process_byepass);
                        $doc->exportField($this->jc_bom_wastage);
                        $doc->exportField($this->bom_1000);
                        $doc->exportField($this->batch_authorized_id);
                        $doc->exportField($this->tufting_plan_active);
                        $doc->exportField($this->tufting_plan_sgrp);
                        $doc->exportField($this->tufting_plan_loom_group);
                        $doc->exportField($this->tufting_performance_percent);
                        $doc->exportField($this->jc_weeks);
                        $doc->exportField($this->required_material_overall_update);
                        $doc->exportField($this->jc_material_issue);
                        $doc->exportField($this->jc_qr);
                        $doc->exportField($this->jc_mrlot);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->max_jobcard);
                        $doc->exportField($this->jc_pending_delete_days);
                        $doc->exportField($this->batch_pp_id);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->cs_min_width);
                        $doc->exportField($this->cs_min_qty);
                        $doc->exportField($this->payment_sqm);
                        $doc->exportField($this->payment_sqm_byepass_category);
                        $doc->exportField($this->process_byepass);
                        $doc->exportField($this->jc_bom_wastage);
                        $doc->exportField($this->bom_1000);
                        $doc->exportField($this->batch_authorized_id);
                        $doc->exportField($this->tufting_plan_active);
                        $doc->exportField($this->tufting_plan_sgrp);
                        $doc->exportField($this->tufting_plan_loom_group);
                        $doc->exportField($this->tufting_performance_percent);
                        $doc->exportField($this->jc_weeks);
                        $doc->exportField($this->required_material_overall_update);
                        $doc->exportField($this->jc_material_issue);
                        $doc->exportField($this->jc_qr);
                        $doc->exportField($this->jc_mrlot);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->max_jobcard);
                        $doc->exportField($this->jc_pending_delete_days);
                        $doc->exportField($this->batch_pp_id);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
