<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BuyerEdit extends Buyer
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BuyerEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "buyeredit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->user_name->setVisibility();
        $this->_password->setVisibility();
        $this->category->setVisibility();
        $this->sub_category->setVisibility();
        $this->grp->setVisibility();
        $this->name->setVisibility();
        $this->code->setVisibility();
        $this->seller->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->country->setVisibility();
        $this->region->setVisibility();
        $this->city->setVisibility();
        $this->city_name->Visible = false;
        $this->address->setVisibility();
        $this->location->setVisibility();
        $this->reports_to->setVisibility();
        $this->status->setVisibility();
        $this->tax_registration->setVisibility();
        $this->currency->setVisibility();
        $this->port_sea->setVisibility();
        $this->incoterm->setVisibility();
        $this->port_air->setVisibility();
        $this->type->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->uid->Visible = false;
        $this->performance->Visible = false;
        $this->remarks->setVisibility();
        $this->price_percent->setVisibility();
        $this->last_login->Visible = false;
        $this->reg_date->Visible = false;
        $this->reg_device->Visible = false;
        $this->device_id->Visible = false;
        $this->device_token_id->Visible = false;
        $this->cart_number->Visible = false;
        $this->r_text->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'buyer';
        $this->TableName = 'buyer';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (buyer)
        if (!isset($GLOBALS["buyer"]) || $GLOBALS["buyer"]::class == PROJECT_NAMESPACE . "buyer") {
            $GLOBALS["buyer"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'buyer');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "buyerview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->sub_category);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->seller);
        $this->setupLookupOptions($this->country);
        $this->setupLookupOptions($this->region);
        $this->setupLookupOptions($this->city);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->port_sea);
        $this->setupLookupOptions($this->incoterm);
        $this->setupLookupOptions($this->port_air);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("buyerlist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "buyerlist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "buyerlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "buyerlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val, true, $validate);
        }

        // Check field name 'user_name' first before field var 'x_user_name'
        $val = $CurrentForm->hasValue("user_name") ? $CurrentForm->getValue("user_name") : $CurrentForm->getValue("x_user_name");
        if (!$this->user_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->user_name->Visible = false; // Disable update for API request
            } else {
                $this->user_name->setFormValue($val);
            }
        }

        // Check field name 'password' first before field var 'x__password'
        $val = $CurrentForm->hasValue("password") ? $CurrentForm->getValue("password") : $CurrentForm->getValue("x__password");
        if (!$this->_password->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_password->Visible = false; // Disable update for API request
            } else {
                $this->_password->setFormValue($val);
            }
        }

        // Check field name 'category' first before field var 'x_category'
        $val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
        if (!$this->category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->category->Visible = false; // Disable update for API request
            } else {
                $this->category->setFormValue($val);
            }
        }

        // Check field name 'sub_category' first before field var 'x_sub_category'
        $val = $CurrentForm->hasValue("sub_category") ? $CurrentForm->getValue("sub_category") : $CurrentForm->getValue("x_sub_category");
        if (!$this->sub_category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sub_category->Visible = false; // Disable update for API request
            } else {
                $this->sub_category->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'name' first before field var 'x_name'
        $val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
        if (!$this->name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name->Visible = false; // Disable update for API request
            } else {
                $this->name->setFormValue($val);
            }
        }

        // Check field name 'code' first before field var 'x_code'
        $val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
        if (!$this->code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->code->Visible = false; // Disable update for API request
            } else {
                $this->code->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'seller' first before field var 'x_seller'
        $val = $CurrentForm->hasValue("seller") ? $CurrentForm->getValue("seller") : $CurrentForm->getValue("x_seller");
        if (!$this->seller->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->seller->Visible = false; // Disable update for API request
            } else {
                $this->seller->setFormValue($val);
            }
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val);
            }
        }

        // Check field name 'email' first before field var 'x__email'
        $val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
        if (!$this->_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_email->Visible = false; // Disable update for API request
            } else {
                $this->_email->setFormValue($val);
            }
        }

        // Check field name 'country' first before field var 'x_country'
        $val = $CurrentForm->hasValue("country") ? $CurrentForm->getValue("country") : $CurrentForm->getValue("x_country");
        if (!$this->country->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->country->Visible = false; // Disable update for API request
            } else {
                $this->country->setFormValue($val);
            }
        }

        // Check field name 'region' first before field var 'x_region'
        $val = $CurrentForm->hasValue("region") ? $CurrentForm->getValue("region") : $CurrentForm->getValue("x_region");
        if (!$this->region->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->region->Visible = false; // Disable update for API request
            } else {
                $this->region->setFormValue($val);
            }
        }

        // Check field name 'city' first before field var 'x_city'
        $val = $CurrentForm->hasValue("city") ? $CurrentForm->getValue("city") : $CurrentForm->getValue("x_city");
        if (!$this->city->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->city->Visible = false; // Disable update for API request
            } else {
                $this->city->setFormValue($val);
            }
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }

        // Check field name 'location' first before field var 'x_location'
        $val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
        if (!$this->location->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->location->Visible = false; // Disable update for API request
            } else {
                $this->location->setFormValue($val);
            }
        }

        // Check field name 'reports_to' first before field var 'x_reports_to'
        $val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
        if (!$this->reports_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reports_to->Visible = false; // Disable update for API request
            } else {
                $this->reports_to->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'tax_registration' first before field var 'x_tax_registration'
        $val = $CurrentForm->hasValue("tax_registration") ? $CurrentForm->getValue("tax_registration") : $CurrentForm->getValue("x_tax_registration");
        if (!$this->tax_registration->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->tax_registration->Visible = false; // Disable update for API request
            } else {
                $this->tax_registration->setFormValue($val);
            }
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val);
            }
        }

        // Check field name 'port_sea' first before field var 'x_port_sea'
        $val = $CurrentForm->hasValue("port_sea") ? $CurrentForm->getValue("port_sea") : $CurrentForm->getValue("x_port_sea");
        if (!$this->port_sea->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->port_sea->Visible = false; // Disable update for API request
            } else {
                $this->port_sea->setFormValue($val);
            }
        }

        // Check field name 'incoterm' first before field var 'x_incoterm'
        $val = $CurrentForm->hasValue("incoterm") ? $CurrentForm->getValue("incoterm") : $CurrentForm->getValue("x_incoterm");
        if (!$this->incoterm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->incoterm->Visible = false; // Disable update for API request
            } else {
                $this->incoterm->setFormValue($val);
            }
        }

        // Check field name 'port_air' first before field var 'x_port_air'
        $val = $CurrentForm->hasValue("port_air") ? $CurrentForm->getValue("port_air") : $CurrentForm->getValue("x_port_air");
        if (!$this->port_air->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->port_air->Visible = false; // Disable update for API request
            } else {
                $this->port_air->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'price_percent' first before field var 'x_price_percent'
        $val = $CurrentForm->hasValue("price_percent") ? $CurrentForm->getValue("price_percent") : $CurrentForm->getValue("x_price_percent");
        if (!$this->price_percent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price_percent->Visible = false; // Disable update for API request
            } else {
                $this->price_percent->setFormValue($val, true, $validate);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->user_name->CurrentValue = $this->user_name->FormValue;
        $this->_password->CurrentValue = $this->_password->FormValue;
        $this->category->CurrentValue = $this->category->FormValue;
        $this->sub_category->CurrentValue = $this->sub_category->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->name->CurrentValue = $this->name->FormValue;
        $this->code->CurrentValue = $this->code->FormValue;
        $this->seller->CurrentValue = $this->seller->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->_email->CurrentValue = $this->_email->FormValue;
        $this->country->CurrentValue = $this->country->FormValue;
        $this->region->CurrentValue = $this->region->FormValue;
        $this->city->CurrentValue = $this->city->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->location->CurrentValue = $this->location->FormValue;
        $this->reports_to->CurrentValue = $this->reports_to->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->tax_registration->CurrentValue = $this->tax_registration->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->port_sea->CurrentValue = $this->port_sea->FormValue;
        $this->incoterm->CurrentValue = $this->incoterm->FormValue;
        $this->port_air->CurrentValue = $this->port_air->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->price_percent->CurrentValue = $this->price_percent->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->user_name->setDbValue($row['user_name']);
        $this->_password->setDbValue($row['password']);
        $this->category->setDbValue($row['category']);
        $this->sub_category->setDbValue($row['sub_category']);
        $this->grp->setDbValue($row['grp']);
        $this->name->setDbValue($row['name']);
        $this->code->setDbValue($row['code']);
        $this->seller->setDbValue($row['seller']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->country->setDbValue($row['country']);
        $this->region->setDbValue($row['region']);
        $this->city->setDbValue($row['city']);
        if (array_key_exists('EV__city', $row)) {
            $this->city->VirtualValue = $row['EV__city']; // Set up virtual field value
        } else {
            $this->city->VirtualValue = ""; // Clear value
        }
        $this->city_name->setDbValue($row['city_name']);
        $this->address->setDbValue($row['address']);
        $this->location->setDbValue($row['location']);
        if (array_key_exists('EV__location', $row)) {
            $this->location->VirtualValue = $row['EV__location']; // Set up virtual field value
        } else {
            $this->location->VirtualValue = ""; // Clear value
        }
        $this->reports_to->setDbValue($row['reports_to']);
        $this->status->setDbValue($row['status']);
        $this->tax_registration->setDbValue($row['tax_registration']);
        $this->currency->setDbValue($row['currency']);
        $this->port_sea->setDbValue($row['port_sea']);
        $this->incoterm->setDbValue($row['incoterm']);
        $this->port_air->setDbValue($row['port_air']);
        $this->type->setDbValue($row['type']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->uid->setDbValue($row['uid']);
        $this->performance->setDbValue($row['performance']);
        $this->remarks->setDbValue($row['remarks']);
        $this->price_percent->setDbValue($row['price_percent']);
        $this->last_login->setDbValue($row['last_login']);
        $this->reg_date->setDbValue($row['reg_date']);
        $this->reg_device->setDbValue($row['reg_device']);
        $this->device_id->setDbValue($row['device_id']);
        $this->device_token_id->setDbValue($row['device_token_id']);
        $this->cart_number->setDbValue($row['cart_number']);
        $this->r_text->setDbValue($row['r_text']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['user_name'] = $this->user_name->DefaultValue;
        $row['password'] = $this->_password->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['sub_category'] = $this->sub_category->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['seller'] = $this->seller->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['region'] = $this->region->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['tax_registration'] = $this->tax_registration->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['port_sea'] = $this->port_sea->DefaultValue;
        $row['incoterm'] = $this->incoterm->DefaultValue;
        $row['port_air'] = $this->port_air->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['uid'] = $this->uid->DefaultValue;
        $row['performance'] = $this->performance->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['price_percent'] = $this->price_percent->DefaultValue;
        $row['last_login'] = $this->last_login->DefaultValue;
        $row['reg_date'] = $this->reg_date->DefaultValue;
        $row['reg_device'] = $this->reg_device->DefaultValue;
        $row['device_id'] = $this->device_id->DefaultValue;
        $row['device_token_id'] = $this->device_token_id->DefaultValue;
        $row['cart_number'] = $this->cart_number->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // user_name
        $this->user_name->RowCssClass = "row";

        // password
        $this->_password->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // sub_category
        $this->sub_category->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // seller
        $this->seller->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // country
        $this->country->RowCssClass = "row";

        // region
        $this->region->RowCssClass = "row";

        // city
        $this->city->RowCssClass = "row";

        // city_name
        $this->city_name->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // tax_registration
        $this->tax_registration->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // port_sea
        $this->port_sea->RowCssClass = "row";

        // incoterm
        $this->incoterm->RowCssClass = "row";

        // port_air
        $this->port_air->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // performance
        $this->performance->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // price_percent
        $this->price_percent->RowCssClass = "row";

        // last_login
        $this->last_login->RowCssClass = "row";

        // reg_date
        $this->reg_date->RowCssClass = "row";

        // reg_device
        $this->reg_device->RowCssClass = "row";

        // device_id
        $this->device_id->RowCssClass = "row";

        // device_token_id
        $this->device_token_id->RowCssClass = "row";

        // cart_number
        $this->cart_number->RowCssClass = "row";

        // r_text
        $this->r_text->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // user_name
            $this->user_name->ViewValue = $this->user_name->CurrentValue;

            // password
            $this->_password->ViewValue = $this->_password->CurrentValue;

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // sub_category
            $curVal = strval($this->sub_category->CurrentValue);
            if ($curVal != "") {
                $this->sub_category->ViewValue = $this->sub_category->lookupCacheOption($curVal);
                if ($this->sub_category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->sub_category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->sub_category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->sub_category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->sub_category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sub_category->Lookup->renderViewRow($rswrk[0]);
                        $this->sub_category->ViewValue = $this->sub_category->displayValue($arwrk);
                    } else {
                        $this->sub_category->ViewValue = FormatNumber($this->sub_category->CurrentValue, $this->sub_category->formatPattern());
                    }
                }
            } else {
                $this->sub_category->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->grp->Lookup->renderViewRow($row);
                            $this->grp->ViewValue->add($this->grp->displayValue($arwrk));
                        }
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // seller
            $curVal = strval($this->seller->CurrentValue);
            if ($curVal != "") {
                $this->seller->ViewValue = $this->seller->lookupCacheOption($curVal);
                if ($this->seller->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->seller->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->seller->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->seller->getSelectFilter($this); // PHP
                    $sqlWrk = $this->seller->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->seller->Lookup->renderViewRow($rswrk[0]);
                        $this->seller->ViewValue = $this->seller->displayValue($arwrk);
                    } else {
                        $this->seller->ViewValue = FormatNumber($this->seller->CurrentValue, $this->seller->formatPattern());
                    }
                }
            } else {
                $this->seller->ViewValue = null;
            }

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // country
            $curVal = strval($this->country->CurrentValue);
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
                if ($this->country->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                        $this->country->ViewValue = $this->country->displayValue($arwrk);
                    } else {
                        $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                    }
                }
            } else {
                $this->country->ViewValue = null;
            }

            // region
            $curVal = strval($this->region->CurrentValue);
            if ($curVal != "") {
                $this->region->ViewValue = $this->region->lookupCacheOption($curVal);
                if ($this->region->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->region->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->region->Lookup->renderViewRow($rswrk[0]);
                        $this->region->ViewValue = $this->region->displayValue($arwrk);
                    } else {
                        $this->region->ViewValue = FormatNumber($this->region->CurrentValue, $this->region->formatPattern());
                    }
                }
            } else {
                $this->region->ViewValue = null;
            }

            // city
            if ($this->city->VirtualValue != "") {
                $this->city->ViewValue = $this->city->VirtualValue;
            } else {
                $this->city->ViewValue = $this->city->CurrentValue;
                $curVal = strval($this->city->CurrentValue);
                if ($curVal != "") {
                    $this->city->ViewValue = $this->city->lookupCacheOption($curVal);
                    if ($this->city->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->city->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->city->Lookup->renderViewRow($rswrk[0]);
                            $this->city->ViewValue = $this->city->displayValue($arwrk);
                        } else {
                            $this->city->ViewValue = FormatNumber($this->city->CurrentValue, $this->city->formatPattern());
                        }
                    }
                } else {
                    $this->city->ViewValue = null;
                }
            }

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // location
            if ($this->location->VirtualValue != "") {
                $this->location->ViewValue = $this->location->VirtualValue;
            } else {
                $this->location->ViewValue = $this->location->CurrentValue;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->reports_to->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->reports_to->Lookup->renderViewRow($row);
                            $this->reports_to->ViewValue->add($this->reports_to->displayValue($arwrk));
                        }
                    } else {
                        $this->reports_to->ViewValue = $this->reports_to->CurrentValue;
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // tax_registration
            $this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // port_sea
            $curVal = strval($this->port_sea->CurrentValue);
            if ($curVal != "") {
                $this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
                if ($this->port_sea->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->port_sea->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_sea->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->port_sea->getSelectFilter($this); // PHP
                    $sqlWrk = $this->port_sea->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->port_sea->Lookup->renderViewRow($rswrk[0]);
                        $this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
                    } else {
                        $this->port_sea->ViewValue = $this->port_sea->CurrentValue;
                    }
                }
            } else {
                $this->port_sea->ViewValue = null;
            }

            // incoterm
            $curVal = strval($this->incoterm->CurrentValue);
            if ($curVal != "") {
                $this->incoterm->ViewValue = $this->incoterm->lookupCacheOption($curVal);
                if ($this->incoterm->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->incoterm->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->incoterm->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->incoterm->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->incoterm->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->incoterm->Lookup->renderViewRow($row);
                            $this->incoterm->ViewValue->add($this->incoterm->displayValue($arwrk));
                        }
                    } else {
                        $this->incoterm->ViewValue = $this->incoterm->CurrentValue;
                    }
                }
            } else {
                $this->incoterm->ViewValue = null;
            }

            // port_air
            $curVal = strval($this->port_air->CurrentValue);
            if ($curVal != "") {
                $this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
                if ($this->port_air->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->port_air->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_air->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->port_air->getSelectFilter($this); // PHP
                    $sqlWrk = $this->port_air->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->port_air->Lookup->renderViewRow($rswrk[0]);
                        $this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
                    } else {
                        $this->port_air->ViewValue = $this->port_air->CurrentValue;
                    }
                }
            } else {
                $this->port_air->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // performance
            $this->performance->ViewValue = $this->performance->CurrentValue;
            $this->performance->ViewValue = FormatNumber($this->performance->ViewValue, $this->performance->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // price_percent
            $this->price_percent->ViewValue = $this->price_percent->CurrentValue;
            $this->price_percent->ViewValue = FormatNumber($this->price_percent->ViewValue, $this->price_percent->formatPattern());

            // id
            $this->id->HrefValue = "";

            // user_name
            $this->user_name->HrefValue = "";

            // password
            $this->_password->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // sub_category
            $this->sub_category->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // seller
            $this->seller->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // country
            $this->country->HrefValue = "";

            // region
            $this->region->HrefValue = "";

            // city
            $this->city->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // tax_registration
            $this->tax_registration->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // port_sea
            $this->port_sea->HrefValue = "";

            // incoterm
            $this->incoterm->HrefValue = "";

            // port_air
            $this->port_air->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // price_percent
            $this->price_percent->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // user_name
            $this->user_name->setupEditAttributes();
            if (!$this->user_name->Raw) {
                $this->user_name->CurrentValue = HtmlDecode($this->user_name->CurrentValue);
            }
            $this->user_name->EditValue = HtmlEncode($this->user_name->CurrentValue);
            $this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

            // password
            $this->_password->setupEditAttributes();
            if (!$this->_password->Raw) {
                $this->_password->CurrentValue = HtmlDecode($this->_password->CurrentValue);
            }
            $this->_password->EditValue = HtmlEncode($this->_password->CurrentValue);
            $this->_password->PlaceHolder = RemoveHtml($this->_password->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->CurrentValue));
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->CurrentValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // sub_category
            $this->sub_category->setupEditAttributes();
            $curVal = trim(strval($this->sub_category->CurrentValue));
            if ($curVal != "") {
                $this->sub_category->ViewValue = $this->sub_category->lookupCacheOption($curVal);
            } else {
                $this->sub_category->ViewValue = $this->sub_category->Lookup !== null && is_array($this->sub_category->lookupOptions()) && count($this->sub_category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->sub_category->ViewValue !== null) { // Load from cache
                $this->sub_category->EditValue = array_values($this->sub_category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->sub_category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->sub_category->CurrentValue, $this->sub_category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->sub_category->getSelectFilter($this); // PHP
                $sqlWrk = $this->sub_category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->sub_category->EditValue = $arwrk;
            }
            $this->sub_category->PlaceHolder = RemoveHtml($this->sub_category->caption());

            // grp
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // code
            $this->code->setupEditAttributes();
            if (!$this->code->Raw) {
                $this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
            }
            $this->code->EditValue = HtmlEncode($this->code->CurrentValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // seller
            $this->seller->setupEditAttributes();
            $curVal = trim(strval($this->seller->CurrentValue));
            if ($curVal != "") {
                $this->seller->ViewValue = $this->seller->lookupCacheOption($curVal);
            } else {
                $this->seller->ViewValue = $this->seller->Lookup !== null && is_array($this->seller->lookupOptions()) && count($this->seller->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->seller->ViewValue !== null) { // Load from cache
                $this->seller->EditValue = array_values($this->seller->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->seller->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->seller->CurrentValue, $this->seller->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->seller->getSelectFilter($this); // PHP
                $sqlWrk = $this->seller->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->seller->EditValue = $arwrk;
            }
            $this->seller->PlaceHolder = RemoveHtml($this->seller->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // country
            $this->country->setupEditAttributes();
            $curVal = trim(strval($this->country->CurrentValue));
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
            } else {
                $this->country->ViewValue = $this->country->Lookup !== null && is_array($this->country->lookupOptions()) && count($this->country->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->country->ViewValue !== null) { // Load from cache
                $this->country->EditValue = array_values($this->country->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->country->CurrentValue, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->country->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->country->EditValue = $arwrk;
            }
            $this->country->PlaceHolder = RemoveHtml($this->country->caption());

            // region
            $this->region->setupEditAttributes();
            $curVal = trim(strval($this->region->CurrentValue));
            if ($curVal != "") {
                $this->region->ViewValue = $this->region->lookupCacheOption($curVal);
            } else {
                $this->region->ViewValue = $this->region->Lookup !== null && is_array($this->region->lookupOptions()) && count($this->region->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->region->ViewValue !== null) { // Load from cache
                $this->region->EditValue = array_values($this->region->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->region->CurrentValue, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->region->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->region->EditValue = $arwrk;
            }
            $this->region->PlaceHolder = RemoveHtml($this->region->caption());

            // city
            $this->city->setupEditAttributes();
            $this->city->EditValue = $this->city->CurrentValue;
            $curVal = strval($this->city->CurrentValue);
            if ($curVal != "") {
                $this->city->EditValue = $this->city->lookupCacheOption($curVal);
                if ($this->city->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->city->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->city->Lookup->renderViewRow($rswrk[0]);
                        $this->city->EditValue = $this->city->displayValue($arwrk);
                    } else {
                        $this->city->EditValue = HtmlEncode(FormatNumber($this->city->CurrentValue, $this->city->formatPattern()));
                    }
                }
            } else {
                $this->city->EditValue = null;
            }
            $this->city->PlaceHolder = RemoveHtml($this->city->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // location
            $this->location->setupEditAttributes();
            if (!$this->location->Raw) {
                $this->location->CurrentValue = HtmlDecode($this->location->CurrentValue);
            }
            $this->location->EditValue = HtmlEncode($this->location->CurrentValue);
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = trim(strval($this->reports_to->CurrentValue));
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            } else {
                $this->reports_to->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->reports_to->ViewValue !== null) { // Load from cache
                $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            }
            $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // tax_registration
            $this->tax_registration->setupEditAttributes();
            if (!$this->tax_registration->Raw) {
                $this->tax_registration->CurrentValue = HtmlDecode($this->tax_registration->CurrentValue);
            }
            $this->tax_registration->EditValue = HtmlEncode($this->tax_registration->CurrentValue);
            $this->tax_registration->PlaceHolder = RemoveHtml($this->tax_registration->caption());

            // currency
            $this->currency->setupEditAttributes();
            $curVal = trim(strval($this->currency->CurrentValue));
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->CurrentValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // port_sea
            $this->port_sea->setupEditAttributes();
            $curVal = trim(strval($this->port_sea->CurrentValue));
            if ($curVal != "") {
                $this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
            } else {
                $this->port_sea->ViewValue = $this->port_sea->Lookup !== null && is_array($this->port_sea->lookupOptions()) && count($this->port_sea->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->port_sea->ViewValue !== null) { // Load from cache
                $this->port_sea->EditValue = array_values($this->port_sea->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->port_sea->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->port_sea->CurrentValue, $this->port_sea->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->port_sea->getSelectFilter($this); // PHP
                $sqlWrk = $this->port_sea->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->port_sea->EditValue = $arwrk;
            }
            $this->port_sea->PlaceHolder = RemoveHtml($this->port_sea->caption());

            // incoterm
            $this->incoterm->setupEditAttributes();
            $curVal = trim(strval($this->incoterm->CurrentValue));
            if ($curVal != "") {
                $this->incoterm->ViewValue = $this->incoterm->lookupCacheOption($curVal);
            } else {
                $this->incoterm->ViewValue = $this->incoterm->Lookup !== null && is_array($this->incoterm->lookupOptions()) && count($this->incoterm->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->incoterm->ViewValue !== null) { // Load from cache
                $this->incoterm->EditValue = array_values($this->incoterm->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->incoterm->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->incoterm->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->incoterm->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->incoterm->EditValue = $arwrk;
            }
            $this->incoterm->PlaceHolder = RemoveHtml($this->incoterm->caption());

            // port_air
            $this->port_air->setupEditAttributes();
            $curVal = trim(strval($this->port_air->CurrentValue));
            if ($curVal != "") {
                $this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
            } else {
                $this->port_air->ViewValue = $this->port_air->Lookup !== null && is_array($this->port_air->lookupOptions()) && count($this->port_air->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->port_air->ViewValue !== null) { // Load from cache
                $this->port_air->EditValue = array_values($this->port_air->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->port_air->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->port_air->CurrentValue, $this->port_air->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->port_air->getSelectFilter($this); // PHP
                $sqlWrk = $this->port_air->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->port_air->EditValue = $arwrk;
            }
            $this->port_air->PlaceHolder = RemoveHtml($this->port_air->caption());

            // operator

            // datetime

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // price_percent
            $this->price_percent->setupEditAttributes();
            $this->price_percent->EditValue = $this->price_percent->CurrentValue;
            $this->price_percent->PlaceHolder = RemoveHtml($this->price_percent->caption());
            if (strval($this->price_percent->EditValue) != "" && is_numeric($this->price_percent->EditValue)) {
                $this->price_percent->EditValue = FormatNumber($this->price_percent->EditValue, null);
            }

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // user_name
            $this->user_name->HrefValue = "";

            // password
            $this->_password->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // sub_category
            $this->sub_category->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // seller
            $this->seller->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // country
            $this->country->HrefValue = "";

            // region
            $this->region->HrefValue = "";

            // city
            $this->city->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // tax_registration
            $this->tax_registration->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // port_sea
            $this->port_sea->HrefValue = "";

            // incoterm
            $this->incoterm->HrefValue = "";

            // port_air
            $this->port_air->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // price_percent
            $this->price_percent->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->id->FormValue)) {
                $this->id->addErrorMessage($this->id->getErrorMessage(false));
            }
            if ($this->user_name->Visible && $this->user_name->Required) {
                if (!$this->user_name->IsDetailKey && EmptyValue($this->user_name->FormValue)) {
                    $this->user_name->addErrorMessage(str_replace("%s", $this->user_name->caption(), $this->user_name->RequiredErrorMessage));
                }
            }
            if ($this->_password->Visible && $this->_password->Required) {
                if (!$this->_password->IsDetailKey && EmptyValue($this->_password->FormValue)) {
                    $this->_password->addErrorMessage(str_replace("%s", $this->_password->caption(), $this->_password->RequiredErrorMessage));
                }
            }
            if ($this->category->Visible && $this->category->Required) {
                if (!$this->category->IsDetailKey && EmptyValue($this->category->FormValue)) {
                    $this->category->addErrorMessage(str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
                }
            }
            if ($this->sub_category->Visible && $this->sub_category->Required) {
                if (!$this->sub_category->IsDetailKey && EmptyValue($this->sub_category->FormValue)) {
                    $this->sub_category->addErrorMessage(str_replace("%s", $this->sub_category->caption(), $this->sub_category->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if ($this->grp->FormValue == "") {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->name->Visible && $this->name->Required) {
                if (!$this->name->IsDetailKey && EmptyValue($this->name->FormValue)) {
                    $this->name->addErrorMessage(str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
                }
            }
            if ($this->code->Visible && $this->code->Required) {
                if (!$this->code->IsDetailKey && EmptyValue($this->code->FormValue)) {
                    $this->code->addErrorMessage(str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
                }
            }
            if ($this->seller->Visible && $this->seller->Required) {
                if (!$this->seller->IsDetailKey && EmptyValue($this->seller->FormValue)) {
                    $this->seller->addErrorMessage(str_replace("%s", $this->seller->caption(), $this->seller->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->_email->Visible && $this->_email->Required) {
                if (!$this->_email->IsDetailKey && EmptyValue($this->_email->FormValue)) {
                    $this->_email->addErrorMessage(str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
                }
            }
            if ($this->country->Visible && $this->country->Required) {
                if (!$this->country->IsDetailKey && EmptyValue($this->country->FormValue)) {
                    $this->country->addErrorMessage(str_replace("%s", $this->country->caption(), $this->country->RequiredErrorMessage));
                }
            }
            if ($this->region->Visible && $this->region->Required) {
                if (!$this->region->IsDetailKey && EmptyValue($this->region->FormValue)) {
                    $this->region->addErrorMessage(str_replace("%s", $this->region->caption(), $this->region->RequiredErrorMessage));
                }
            }
            if ($this->city->Visible && $this->city->Required) {
                if (!$this->city->IsDetailKey && EmptyValue($this->city->FormValue)) {
                    $this->city->addErrorMessage(str_replace("%s", $this->city->caption(), $this->city->RequiredErrorMessage));
                }
            }
            if ($this->address->Visible && $this->address->Required) {
                if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->location->Visible && $this->location->Required) {
                if (!$this->location->IsDetailKey && EmptyValue($this->location->FormValue)) {
                    $this->location->addErrorMessage(str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
                }
            }
            if ($this->reports_to->Visible && $this->reports_to->Required) {
                if ($this->reports_to->FormValue == "") {
                    $this->reports_to->addErrorMessage(str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->tax_registration->Visible && $this->tax_registration->Required) {
                if (!$this->tax_registration->IsDetailKey && EmptyValue($this->tax_registration->FormValue)) {
                    $this->tax_registration->addErrorMessage(str_replace("%s", $this->tax_registration->caption(), $this->tax_registration->RequiredErrorMessage));
                }
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if ($this->port_sea->Visible && $this->port_sea->Required) {
                if (!$this->port_sea->IsDetailKey && EmptyValue($this->port_sea->FormValue)) {
                    $this->port_sea->addErrorMessage(str_replace("%s", $this->port_sea->caption(), $this->port_sea->RequiredErrorMessage));
                }
            }
            if ($this->incoterm->Visible && $this->incoterm->Required) {
                if ($this->incoterm->FormValue == "") {
                    $this->incoterm->addErrorMessage(str_replace("%s", $this->incoterm->caption(), $this->incoterm->RequiredErrorMessage));
                }
            }
            if ($this->port_air->Visible && $this->port_air->Required) {
                if (!$this->port_air->IsDetailKey && EmptyValue($this->port_air->FormValue)) {
                    $this->port_air->addErrorMessage(str_replace("%s", $this->port_air->caption(), $this->port_air->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->price_percent->Visible && $this->price_percent->Required) {
                if (!$this->price_percent->IsDetailKey && EmptyValue($this->price_percent->FormValue)) {
                    $this->price_percent->addErrorMessage(str_replace("%s", $this->price_percent->caption(), $this->price_percent->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->price_percent->FormValue)) {
                $this->price_percent->addErrorMessage($this->price_percent->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (code)
        if ($this->code->CurrentValue != "") {
            $filterChk = "(`code` = '" . AdjustSql($this->code->CurrentValue, $this->Dbid) . "')";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->code->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->code->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // user_name
        $this->user_name->setDbValueDef($rsnew, $this->user_name->CurrentValue, $this->user_name->ReadOnly);

        // password
        $this->_password->setDbValueDef($rsnew, $this->_password->CurrentValue, $this->_password->ReadOnly);

        // category
        $this->category->setDbValueDef($rsnew, $this->category->CurrentValue, $this->category->ReadOnly);

        // sub_category
        $this->sub_category->setDbValueDef($rsnew, $this->sub_category->CurrentValue, $this->sub_category->ReadOnly);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, $this->grp->ReadOnly);

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, $this->name->ReadOnly);

        // code
        $this->code->setDbValueDef($rsnew, $this->code->CurrentValue, $this->code->ReadOnly);

        // seller
        $this->seller->setDbValueDef($rsnew, $this->seller->CurrentValue, $this->seller->ReadOnly);

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, $this->mobile->ReadOnly);

        // email
        $this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, $this->_email->ReadOnly);

        // country
        $this->country->setDbValueDef($rsnew, $this->country->CurrentValue, $this->country->ReadOnly);

        // region
        $this->region->setDbValueDef($rsnew, $this->region->CurrentValue, $this->region->ReadOnly);

        // city
        $this->city->setDbValueDef($rsnew, $this->city->CurrentValue, $this->city->ReadOnly);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, $this->address->ReadOnly);

        // location
        $this->location->setDbValueDef($rsnew, $this->location->CurrentValue, $this->location->ReadOnly);

        // reports_to
        $this->reports_to->setDbValueDef($rsnew, $this->reports_to->CurrentValue, $this->reports_to->ReadOnly);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly);

        // tax_registration
        $this->tax_registration->setDbValueDef($rsnew, $this->tax_registration->CurrentValue, $this->tax_registration->ReadOnly);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, $this->currency->ReadOnly);

        // port_sea
        $this->port_sea->setDbValueDef($rsnew, $this->port_sea->CurrentValue, $this->port_sea->ReadOnly);

        // incoterm
        $this->incoterm->setDbValueDef($rsnew, $this->incoterm->CurrentValue, $this->incoterm->ReadOnly);

        // port_air
        $this->port_air->setDbValueDef($rsnew, $this->port_air->CurrentValue, $this->port_air->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // price_percent
        $this->price_percent->setDbValueDef($rsnew, $this->price_percent->CurrentValue, $this->price_percent->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['user_name'])) { // user_name
            $this->user_name->CurrentValue = $row['user_name'];
        }
        if (isset($row['password'])) { // password
            $this->_password->CurrentValue = $row['password'];
        }
        if (isset($row['category'])) { // category
            $this->category->CurrentValue = $row['category'];
        }
        if (isset($row['sub_category'])) { // sub_category
            $this->sub_category->CurrentValue = $row['sub_category'];
        }
        if (isset($row['grp'])) { // grp
            $this->grp->CurrentValue = $row['grp'];
        }
        if (isset($row['name'])) { // name
            $this->name->CurrentValue = $row['name'];
        }
        if (isset($row['code'])) { // code
            $this->code->CurrentValue = $row['code'];
        }
        if (isset($row['seller'])) { // seller
            $this->seller->CurrentValue = $row['seller'];
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->CurrentValue = $row['mobile'];
        }
        if (isset($row['email'])) { // email
            $this->_email->CurrentValue = $row['email'];
        }
        if (isset($row['country'])) { // country
            $this->country->CurrentValue = $row['country'];
        }
        if (isset($row['region'])) { // region
            $this->region->CurrentValue = $row['region'];
        }
        if (isset($row['city'])) { // city
            $this->city->CurrentValue = $row['city'];
        }
        if (isset($row['address'])) { // address
            $this->address->CurrentValue = $row['address'];
        }
        if (isset($row['location'])) { // location
            $this->location->CurrentValue = $row['location'];
        }
        if (isset($row['reports_to'])) { // reports_to
            $this->reports_to->CurrentValue = $row['reports_to'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['tax_registration'])) { // tax_registration
            $this->tax_registration->CurrentValue = $row['tax_registration'];
        }
        if (isset($row['currency'])) { // currency
            $this->currency->CurrentValue = $row['currency'];
        }
        if (isset($row['port_sea'])) { // port_sea
            $this->port_sea->CurrentValue = $row['port_sea'];
        }
        if (isset($row['incoterm'])) { // incoterm
            $this->incoterm->CurrentValue = $row['incoterm'];
        }
        if (isset($row['port_air'])) { // port_air
            $this->port_air->CurrentValue = $row['port_air'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['price_percent'])) { // price_percent
            $this->price_percent->CurrentValue = $row['price_percent'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("buyerlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_sub_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_seller":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_country":
                    break;
                case "x_region":
                    break;
                case "x_city":
                    break;
                case "x_location":
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_currency":
                    break;
                case "x_port_sea":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_incoterm":
                    break;
                case "x_port_air":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'buyer');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
