<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BuyerDelete extends Buyer
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BuyerDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "buyerdelete";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->user_name->setVisibility();
        $this->_password->setVisibility();
        $this->category->setVisibility();
        $this->sub_category->setVisibility();
        $this->grp->setVisibility();
        $this->name->setVisibility();
        $this->code->setVisibility();
        $this->seller->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->country->setVisibility();
        $this->region->setVisibility();
        $this->city->Visible = false;
        $this->city_name->setVisibility();
        $this->address->setVisibility();
        $this->location->Visible = false;
        $this->reports_to->setVisibility();
        $this->status->setVisibility();
        $this->tax_registration->setVisibility();
        $this->currency->setVisibility();
        $this->port_sea->setVisibility();
        $this->incoterm->setVisibility();
        $this->port_air->setVisibility();
        $this->type->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->uid->Visible = false;
        $this->performance->setVisibility();
        $this->remarks->setVisibility();
        $this->price_percent->setVisibility();
        $this->last_login->Visible = false;
        $this->reg_date->Visible = false;
        $this->reg_device->Visible = false;
        $this->device_id->Visible = false;
        $this->device_token_id->Visible = false;
        $this->cart_number->Visible = false;
        $this->r_text->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'buyer';
        $this->TableName = 'buyer';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (buyer)
        if (!isset($GLOBALS["buyer"]) || $GLOBALS["buyer"]::class == PROJECT_NAMESPACE . "buyer") {
            $GLOBALS["buyer"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'buyer');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->sub_category);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->seller);
        $this->setupLookupOptions($this->country);
        $this->setupLookupOptions($this->region);
        $this->setupLookupOptions($this->city);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->port_sea);
        $this->setupLookupOptions($this->incoterm);
        $this->setupLookupOptions($this->port_air);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("buyerlist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("buyerlist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->user_name->setDbValue($row['user_name']);
        $this->_password->setDbValue($row['password']);
        $this->category->setDbValue($row['category']);
        $this->sub_category->setDbValue($row['sub_category']);
        $this->grp->setDbValue($row['grp']);
        $this->name->setDbValue($row['name']);
        $this->code->setDbValue($row['code']);
        $this->seller->setDbValue($row['seller']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->country->setDbValue($row['country']);
        $this->region->setDbValue($row['region']);
        $this->city->setDbValue($row['city']);
        if (array_key_exists('EV__city', $row)) {
            $this->city->VirtualValue = $row['EV__city']; // Set up virtual field value
        } else {
            $this->city->VirtualValue = ""; // Clear value
        }
        $this->city_name->setDbValue($row['city_name']);
        $this->address->setDbValue($row['address']);
        $this->location->setDbValue($row['location']);
        if (array_key_exists('EV__location', $row)) {
            $this->location->VirtualValue = $row['EV__location']; // Set up virtual field value
        } else {
            $this->location->VirtualValue = ""; // Clear value
        }
        $this->reports_to->setDbValue($row['reports_to']);
        $this->status->setDbValue($row['status']);
        $this->tax_registration->setDbValue($row['tax_registration']);
        $this->currency->setDbValue($row['currency']);
        $this->port_sea->setDbValue($row['port_sea']);
        $this->incoterm->setDbValue($row['incoterm']);
        $this->port_air->setDbValue($row['port_air']);
        $this->type->setDbValue($row['type']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->uid->setDbValue($row['uid']);
        $this->performance->setDbValue($row['performance']);
        $this->remarks->setDbValue($row['remarks']);
        $this->price_percent->setDbValue($row['price_percent']);
        $this->last_login->setDbValue($row['last_login']);
        $this->reg_date->setDbValue($row['reg_date']);
        $this->reg_device->setDbValue($row['reg_device']);
        $this->device_id->setDbValue($row['device_id']);
        $this->device_token_id->setDbValue($row['device_token_id']);
        $this->cart_number->setDbValue($row['cart_number']);
        $this->r_text->setDbValue($row['r_text']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['user_name'] = $this->user_name->DefaultValue;
        $row['password'] = $this->_password->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['sub_category'] = $this->sub_category->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['seller'] = $this->seller->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['region'] = $this->region->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['tax_registration'] = $this->tax_registration->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['port_sea'] = $this->port_sea->DefaultValue;
        $row['incoterm'] = $this->incoterm->DefaultValue;
        $row['port_air'] = $this->port_air->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['uid'] = $this->uid->DefaultValue;
        $row['performance'] = $this->performance->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['price_percent'] = $this->price_percent->DefaultValue;
        $row['last_login'] = $this->last_login->DefaultValue;
        $row['reg_date'] = $this->reg_date->DefaultValue;
        $row['reg_device'] = $this->reg_device->DefaultValue;
        $row['device_id'] = $this->device_id->DefaultValue;
        $row['device_token_id'] = $this->device_token_id->DefaultValue;
        $row['cart_number'] = $this->cart_number->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // user_name

        // password

        // category

        // sub_category

        // grp

        // name

        // code

        // seller

        // mobile

        // email

        // country

        // region

        // city

        // city_name
        $this->city_name->CellCssStyle = "white-space: nowrap;";

        // address

        // location

        // reports_to

        // status

        // tax_registration

        // currency

        // port_sea

        // incoterm

        // port_air

        // type
        $this->type->CellCssStyle = "white-space: nowrap;";

        // operator

        // datetime

        // uid
        $this->uid->CellCssStyle = "white-space: nowrap;";

        // performance

        // remarks

        // price_percent

        // last_login
        $this->last_login->CellCssStyle = "white-space: nowrap;";

        // reg_date
        $this->reg_date->CellCssStyle = "white-space: nowrap;";

        // reg_device
        $this->reg_device->CellCssStyle = "white-space: nowrap;";

        // device_id
        $this->device_id->CellCssStyle = "white-space: nowrap;";

        // device_token_id
        $this->device_token_id->CellCssStyle = "white-space: nowrap;";

        // cart_number
        $this->cart_number->CellCssStyle = "white-space: nowrap;";

        // r_text
        $this->r_text->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // user_name
            $this->user_name->ViewValue = $this->user_name->CurrentValue;

            // password
            $this->_password->ViewValue = $this->_password->CurrentValue;

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // sub_category
            $curVal = strval($this->sub_category->CurrentValue);
            if ($curVal != "") {
                $this->sub_category->ViewValue = $this->sub_category->lookupCacheOption($curVal);
                if ($this->sub_category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->sub_category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->sub_category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->sub_category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->sub_category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sub_category->Lookup->renderViewRow($rswrk[0]);
                        $this->sub_category->ViewValue = $this->sub_category->displayValue($arwrk);
                    } else {
                        $this->sub_category->ViewValue = FormatNumber($this->sub_category->CurrentValue, $this->sub_category->formatPattern());
                    }
                }
            } else {
                $this->sub_category->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->grp->Lookup->renderViewRow($row);
                            $this->grp->ViewValue->add($this->grp->displayValue($arwrk));
                        }
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // seller
            $curVal = strval($this->seller->CurrentValue);
            if ($curVal != "") {
                $this->seller->ViewValue = $this->seller->lookupCacheOption($curVal);
                if ($this->seller->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->seller->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->seller->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->seller->getSelectFilter($this); // PHP
                    $sqlWrk = $this->seller->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->seller->Lookup->renderViewRow($rswrk[0]);
                        $this->seller->ViewValue = $this->seller->displayValue($arwrk);
                    } else {
                        $this->seller->ViewValue = FormatNumber($this->seller->CurrentValue, $this->seller->formatPattern());
                    }
                }
            } else {
                $this->seller->ViewValue = null;
            }

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // country
            $curVal = strval($this->country->CurrentValue);
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
                if ($this->country->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                        $this->country->ViewValue = $this->country->displayValue($arwrk);
                    } else {
                        $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                    }
                }
            } else {
                $this->country->ViewValue = null;
            }

            // region
            $curVal = strval($this->region->CurrentValue);
            if ($curVal != "") {
                $this->region->ViewValue = $this->region->lookupCacheOption($curVal);
                if ($this->region->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->region->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->region->Lookup->renderViewRow($rswrk[0]);
                        $this->region->ViewValue = $this->region->displayValue($arwrk);
                    } else {
                        $this->region->ViewValue = FormatNumber($this->region->CurrentValue, $this->region->formatPattern());
                    }
                }
            } else {
                $this->region->ViewValue = null;
            }

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->reports_to->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->reports_to->Lookup->renderViewRow($row);
                            $this->reports_to->ViewValue->add($this->reports_to->displayValue($arwrk));
                        }
                    } else {
                        $this->reports_to->ViewValue = $this->reports_to->CurrentValue;
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // tax_registration
            $this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // port_sea
            $curVal = strval($this->port_sea->CurrentValue);
            if ($curVal != "") {
                $this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
                if ($this->port_sea->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->port_sea->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_sea->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->port_sea->getSelectFilter($this); // PHP
                    $sqlWrk = $this->port_sea->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->port_sea->Lookup->renderViewRow($rswrk[0]);
                        $this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
                    } else {
                        $this->port_sea->ViewValue = $this->port_sea->CurrentValue;
                    }
                }
            } else {
                $this->port_sea->ViewValue = null;
            }

            // incoterm
            $curVal = strval($this->incoterm->CurrentValue);
            if ($curVal != "") {
                $this->incoterm->ViewValue = $this->incoterm->lookupCacheOption($curVal);
                if ($this->incoterm->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->incoterm->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->incoterm->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->incoterm->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->incoterm->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->incoterm->Lookup->renderViewRow($row);
                            $this->incoterm->ViewValue->add($this->incoterm->displayValue($arwrk));
                        }
                    } else {
                        $this->incoterm->ViewValue = $this->incoterm->CurrentValue;
                    }
                }
            } else {
                $this->incoterm->ViewValue = null;
            }

            // port_air
            $curVal = strval($this->port_air->CurrentValue);
            if ($curVal != "") {
                $this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
                if ($this->port_air->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->port_air->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_air->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->port_air->getSelectFilter($this); // PHP
                    $sqlWrk = $this->port_air->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->port_air->Lookup->renderViewRow($rswrk[0]);
                        $this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
                    } else {
                        $this->port_air->ViewValue = $this->port_air->CurrentValue;
                    }
                }
            } else {
                $this->port_air->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // performance
            $this->performance->ViewValue = $this->performance->CurrentValue;
            $this->performance->ViewValue = FormatNumber($this->performance->ViewValue, $this->performance->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // price_percent
            $this->price_percent->ViewValue = $this->price_percent->CurrentValue;
            $this->price_percent->ViewValue = FormatNumber($this->price_percent->ViewValue, $this->price_percent->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // user_name
            $this->user_name->HrefValue = "";
            $this->user_name->TooltipValue = "";

            // password
            $this->_password->HrefValue = "";
            $this->_password->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // sub_category
            $this->sub_category->HrefValue = "";
            $this->sub_category->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // name
            $this->name->HrefValue = "";
            $this->name->TooltipValue = "";

            // code
            $this->code->HrefValue = "";
            $this->code->TooltipValue = "";

            // seller
            $this->seller->HrefValue = "";
            $this->seller->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // email
            $this->_email->HrefValue = "";
            $this->_email->TooltipValue = "";

            // country
            $this->country->HrefValue = "";
            $this->country->TooltipValue = "";

            // region
            $this->region->HrefValue = "";
            $this->region->TooltipValue = "";

            // city_name
            $this->city_name->HrefValue = "";
            $this->city_name->TooltipValue = "";

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // tax_registration
            $this->tax_registration->HrefValue = "";
            $this->tax_registration->TooltipValue = "";

            // currency
            $this->currency->HrefValue = "";
            $this->currency->TooltipValue = "";

            // port_sea
            $this->port_sea->HrefValue = "";
            $this->port_sea->TooltipValue = "";

            // incoterm
            $this->incoterm->HrefValue = "";
            $this->incoterm->TooltipValue = "";

            // port_air
            $this->port_air->HrefValue = "";
            $this->port_air->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // performance
            $this->performance->HrefValue = "";
            $this->performance->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // price_percent
            $this->price_percent->HrefValue = "";
            $this->price_percent->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->AuditTrailOnDelete) {
            $this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
            if ($this->AuditTrailOnDelete) {
                $this->writeAuditTrailDummy($Language->phrase("BatchDeleteSuccess")); // Batch delete success
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnDelete) {
                $this->writeAuditTrailDummy($Language->phrase("BatchDeleteRollback")); // Batch delete rollback
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("buyerlist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_sub_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_seller":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_country":
                    break;
                case "x_region":
                    break;
                case "x_city":
                    break;
                case "x_location":
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_currency":
                    break;
                case "x_port_sea":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_incoterm":
                    break;
                case "x_port_air":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'buyer');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
