<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for booking_ref
 */
class BookingRef extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $supplier_id;
    public $ref;
    public $status;
    public $rid;
    public $quantity;
    public $b_quantity;
    public $confirm_quantity;
    public $confirm_pending;
    public $containers;
    public $booking_date;
    public $booking_rate;
    public $booking_currency;
    public $amount;
    public $currency;
    public $confirm_port_eta;
    public $reference;
    public $currency_current_rate;
    public $shipment_date;
    public $our_port;
    public $remarks;
    public $operator;
    public $datetime;
    public $url;
    public $product_code;
    public $packets;
    public $confirm_type;
    public $company_id;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "booking_ref";
        $this->TableName = 'booking_ref';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "booking_ref";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // supplier_id
        $this->supplier_id = new DbField(
            $this, // Table
            'x_supplier_id', // Variable name
            'supplier_id', // Name
            '`supplier_id`', // Expression
            '`supplier_id`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`supplier_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->supplier_id->addMethod("getSelectFilter", fn() => "`status` = 1 and `category` = 1002");
        $this->supplier_id->InputTextType = "text";
        $this->supplier_id->Raw = true;
        $this->supplier_id->Sortable = false; // Allow sort
        $this->supplier_id->setSelectMultiple(false); // Select one
        $this->supplier_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->supplier_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->supplier_id->Lookup = new Lookup($this->supplier_id, 'production_partner', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`code`");
        $this->supplier_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->supplier_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['supplier_id'] = &$this->supplier_id;

        // ref
        $this->ref = new DbField(
            $this, // Table
            'x_ref', // Variable name
            'ref', // Name
            '`ref`', // Expression
            '`ref`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ref->InputTextType = "text";
        $this->ref->IsForeignKey = true; // Foreign key field
        $this->ref->Nullable = false; // NOT NULL field
        $this->ref->Required = true; // Required field
        $this->ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['ref'] = &$this->ref;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 0);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'booking_ref', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 6;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid->addMethod("getSelectFilter", fn() => "`id`>1000");
        $this->rid->addMethod("getLinkPrefix", fn() => "bookingreflist?x_product=");
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->Lookup = new Lookup($this->rid, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product` ASC', '', "`product_code`");
        $this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid'] = &$this->rid;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity'] = &$this->quantity;

        // b_quantity
        $this->b_quantity = new DbField(
            $this, // Table
            'x_b_quantity', // Variable name
            'b_quantity', // Name
            '`b_quantity`', // Expression
            '`b_quantity`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_quantity->InputTextType = "text";
        $this->b_quantity->Raw = true;
        $this->b_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->b_quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_quantity'] = &$this->b_quantity;

        // confirm_quantity
        $this->confirm_quantity = new DbField(
            $this, // Table
            'x_confirm_quantity', // Variable name
            'confirm_quantity', // Name
            '`confirm_quantity`', // Expression
            '`confirm_quantity`', // Basic search expression
            131, // Type
            36, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`confirm_quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->confirm_quantity->addMethod("getDefault", fn() => 0.000);
        $this->confirm_quantity->InputTextType = "text";
        $this->confirm_quantity->Raw = true;
        $this->confirm_quantity->Nullable = false; // NOT NULL field
        $this->confirm_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->confirm_quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['confirm_quantity'] = &$this->confirm_quantity;

        // confirm_pending
        $this->confirm_pending = new DbField(
            $this, // Table
            'x_confirm_pending', // Variable name
            'confirm_pending', // Name
            '`confirm_pending`', // Expression
            '`confirm_pending`', // Basic search expression
            131, // Type
            37, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`confirm_pending`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->confirm_pending->InputTextType = "text";
        $this->confirm_pending->Raw = true;
        $this->confirm_pending->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->confirm_pending->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['confirm_pending'] = &$this->confirm_pending;

        // containers
        $this->containers = new DbField(
            $this, // Table
            'x_containers', // Variable name
            'containers', // Name
            '`containers`', // Expression
            '`containers`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`containers`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->containers->InputTextType = "text";
        $this->containers->Raw = true;
        $this->containers->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->containers->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['containers'] = &$this->containers;

        // booking_date
        $this->booking_date = new DbField(
            $this, // Table
            'x_booking_date', // Variable name
            'booking_date', // Name
            '`booking_date`', // Expression
            CastDateFieldForLike("`booking_date`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`booking_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->booking_date->addMethod("getLinkPrefix", fn() => "bookingreflist?x_booking_date=");
        $this->booking_date->InputTextType = "text";
        $this->booking_date->Raw = true;
        $this->booking_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->booking_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['booking_date'] = &$this->booking_date;

        // booking_rate
        $this->booking_rate = new DbField(
            $this, // Table
            'x_booking_rate', // Variable name
            'booking_rate', // Name
            '`booking_rate`', // Expression
            '`booking_rate`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`booking_rate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->booking_rate->InputTextType = "text";
        $this->booking_rate->Raw = true;
        $this->booking_rate->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->booking_rate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['booking_rate'] = &$this->booking_rate;

        // booking_currency
        $this->booking_currency = new DbField(
            $this, // Table
            'x_booking_currency', // Variable name
            'booking_currency', // Name
            '`booking_currency`', // Expression
            '`booking_currency`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`booking_currency`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->booking_currency->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->booking_currency->InputTextType = "text";
        $this->booking_currency->Raw = true;
        $this->booking_currency->Required = true; // Required field
        $this->booking_currency->setSelectMultiple(false); // Select one
        $this->booking_currency->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->booking_currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->booking_currency->Lookup = new Lookup($this->booking_currency, 'currency', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "`code`");
        $this->booking_currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->booking_currency->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['booking_currency'] = &$this->booking_currency;

        // amount
        $this->amount = new DbField(
            $this, // Table
            'x_amount', // Variable name
            'amount', // Name
            '`amount`', // Expression
            '`amount`', // Basic search expression
            131, // Type
            34, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount->InputTextType = "text";
        $this->amount->Raw = true;
        $this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['amount'] = &$this->amount;

        // currency
        $this->currency = new DbField(
            $this, // Table
            'x_currency', // Variable name
            'currency', // Name
            '`currency`', // Expression
            '`currency`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`currency`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->currency->InputTextType = "text";
        $this->currency->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['currency'] = &$this->currency;

        // confirm_port_eta
        $this->confirm_port_eta = new DbField(
            $this, // Table
            'x_confirm_port_eta', // Variable name
            'confirm_port_eta', // Name
            '`confirm_port_eta`', // Expression
            '`confirm_port_eta`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`confirm_port_eta`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->confirm_port_eta->InputTextType = "text";
        $this->confirm_port_eta->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['confirm_port_eta'] = &$this->confirm_port_eta;

        // reference
        $this->reference = new DbField(
            $this, // Table
            'x_reference', // Variable name
            'reference', // Name
            '`reference`', // Expression
            '`reference`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`reference`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->reference->InputTextType = "text";
        $this->reference->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['reference'] = &$this->reference;

        // currency_current_rate
        $this->currency_current_rate = new DbField(
            $this, // Table
            'x_currency_current_rate', // Variable name
            'currency_current_rate', // Name
            '`currency_current_rate`', // Expression
            '`currency_current_rate`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`currency_current_rate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->currency_current_rate->InputTextType = "text";
        $this->currency_current_rate->Raw = true;
        $this->currency_current_rate->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->currency_current_rate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['currency_current_rate'] = &$this->currency_current_rate;

        // shipment_date
        $this->shipment_date = new DbField(
            $this, // Table
            'x_shipment_date', // Variable name
            'shipment_date', // Name
            '`shipment_date`', // Expression
            CastDateFieldForLike("`shipment_date`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`shipment_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->shipment_date->addMethod("getLinkPrefix", fn() => "bookingreflist?x_shipment_date=");
        $this->shipment_date->InputTextType = "text";
        $this->shipment_date->Raw = true;
        $this->shipment_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->shipment_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['shipment_date'] = &$this->shipment_date;

        // our_port
        $this->our_port = new DbField(
            $this, // Table
            'x_our_port', // Variable name
            'our_port', // Name
            '`our_port`', // Expression
            '`our_port`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`our_port`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->our_port->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->our_port->InputTextType = "text";
        $this->our_port->Raw = true;
        $this->our_port->setSelectMultiple(false); // Select one
        $this->our_port->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->our_port->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->our_port->Lookup = new Lookup($this->our_port, 'port', false, 'id', ["port","code","",""], '', '', [], [], [], [], [], [], false, '`status` ASC', '', "CONCAT(COALESCE(`port`, ''),'" . ValueSeparator(1, $this->our_port) . "',COALESCE(`code`,''))");
        $this->our_port->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->our_port->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['our_port'] = &$this->our_port;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            150, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // url
        $this->url = new DbField(
            $this, // Table
            'x_url', // Variable name
            'url', // Name
            '`url`', // Expression
            '`url`', // Basic search expression
            200, // Type
            61, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`url`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->url->InputTextType = "text";
        $this->url->Nullable = false; // NOT NULL field
        $this->url->Required = true; // Required field
        $this->url->Sortable = false; // Allow sort
        $this->url->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['url'] = &$this->url;

        // product_code
        $this->product_code = new DbField(
            $this, // Table
            'x_product_code', // Variable name
            'product_code', // Name
            '`product_code`', // Expression
            '`product_code`', // Basic search expression
            200, // Type
            300, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_code->InputTextType = "text";
        $this->product_code->Sortable = false; // Allow sort
        $this->product_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_code'] = &$this->product_code;

        // packets
        $this->packets = new DbField(
            $this, // Table
            'x_packets', // Variable name
            'packets', // Name
            '`packets`', // Expression
            '`packets`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packets`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packets->InputTextType = "text";
        $this->packets->Raw = true;
        $this->packets->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packets->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packets'] = &$this->packets;

        // confirm_type
        $this->confirm_type = new DbField(
            $this, // Table
            'x_confirm_type', // Variable name
            'confirm_type', // Name
            '`confirm_type`', // Expression
            '`confirm_type`', // Basic search expression
            200, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`confirm_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->confirm_type->addMethod("getDefault", fn() => "1");
        $this->confirm_type->InputTextType = "text";
        $this->confirm_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->confirm_type->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['confirm_type'] = &$this->confirm_type;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->company_id->addMethod("getSelectFilter", fn() => "`category` = 1 and `status` = 1");
        $this->company_id->addMethod("getDefault", fn() => 200000);
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Nullable = false; // NOT NULL field
        $this->company_id->Lookup = new Lookup($this->company_id, 'buyer_seller_view', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['company_id'] = &$this->company_id;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current master table name
    public function getCurrentMasterTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE"));
    }

    public function setCurrentMasterTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
    }

    // Get master WHERE clause from session values
    public function getMasterFilterFromSession()
    {
        // Master filter
        $masterFilter = "";
        if ($this->getCurrentMasterTable() == "booking_details") {
            $masterTable = Container("booking_details");
            if ($this->ref->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->ref, $this->ref->getSessionValue(), $masterTable->ref->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        return $masterFilter;
    }

    // Get detail WHERE clause from session values
    public function getDetailFilterFromSession()
    {
        // Detail filter
        $detailFilter = "";
        if ($this->getCurrentMasterTable() == "booking_details") {
            $masterTable = Container("booking_details");
            if ($this->ref->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->ref, $this->ref->getSessionValue(), $masterTable->ref->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        return $detailFilter;
    }

    /**
     * Get master filter
     *
     * @param object $masterTable Master Table
     * @param array $keys Detail Keys
     * @return mixed NULL is returned if all keys are empty, Empty string is returned if some keys are empty and is required
     */
    public function getMasterFilter($masterTable, $keys)
    {
        $validKeys = true;
        switch ($masterTable->TableVar) {
            case "booking_details":
                $key = $keys["ref"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->ref->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->ref, $keys["ref"], $this->ref->DataType, $this->Dbid);
                }
                break;
        }
        return null; // All null values and no required fields
    }

    // Get detail filter
    public function getDetailFilter($masterTable)
    {
        switch ($masterTable->TableVar) {
            case "booking_details":
                return GetKeyFilter($this->ref, $masterTable->ref->DbValue, $masterTable->ref->DataType, $masterTable->Dbid);
        }
        return "";
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "booking_ref";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->supplier_id->DbValue = $row['supplier_id'];
        $this->ref->DbValue = $row['ref'];
        $this->status->DbValue = $row['status'];
        $this->rid->DbValue = $row['rid'];
        $this->quantity->DbValue = $row['quantity'];
        $this->b_quantity->DbValue = $row['b_quantity'];
        $this->confirm_quantity->DbValue = $row['confirm_quantity'];
        $this->confirm_pending->DbValue = $row['confirm_pending'];
        $this->containers->DbValue = $row['containers'];
        $this->booking_date->DbValue = $row['booking_date'];
        $this->booking_rate->DbValue = $row['booking_rate'];
        $this->booking_currency->DbValue = $row['booking_currency'];
        $this->amount->DbValue = $row['amount'];
        $this->currency->DbValue = $row['currency'];
        $this->confirm_port_eta->DbValue = $row['confirm_port_eta'];
        $this->reference->DbValue = $row['reference'];
        $this->currency_current_rate->DbValue = $row['currency_current_rate'];
        $this->shipment_date->DbValue = $row['shipment_date'];
        $this->our_port->DbValue = $row['our_port'];
        $this->remarks->DbValue = $row['remarks'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->url->DbValue = $row['url'];
        $this->product_code->DbValue = $row['product_code'];
        $this->packets->DbValue = $row['packets'];
        $this->confirm_type->DbValue = $row['confirm_type'];
        $this->company_id->DbValue = $row['company_id'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("bookingreflist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "bookingrefview" => $Language->phrase("View"),
            "bookingrefedit" => $Language->phrase("Edit"),
            "bookingrefadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "bookingreflist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "BookingRefView",
            Config("API_ADD_ACTION") => "BookingRefAdd",
            Config("API_EDIT_ACTION") => "BookingRefEdit",
            Config("API_DELETE_ACTION") => "BookingRefDelete",
            Config("API_LIST_ACTION") => "BookingRefList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "bookingreflist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("bookingrefview", $parm);
        } else {
            $url = $this->keyUrl("bookingrefview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "bookingrefadd?" . $parm;
        } else {
            $url = "bookingrefadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("bookingrefedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("bookingreflist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("bookingrefadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("bookingreflist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("bookingrefdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        if ($this->getCurrentMasterTable() == "booking_details" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_ref", $this->ref->getSessionValue()); // Use Session Value
        }
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->supplier_id->setDbValue($row['supplier_id']);
        $this->ref->setDbValue($row['ref']);
        $this->status->setDbValue($row['status']);
        $this->rid->setDbValue($row['rid']);
        $this->quantity->setDbValue($row['quantity']);
        $this->b_quantity->setDbValue($row['b_quantity']);
        $this->confirm_quantity->setDbValue($row['confirm_quantity']);
        $this->confirm_pending->setDbValue($row['confirm_pending']);
        $this->containers->setDbValue($row['containers']);
        $this->booking_date->setDbValue($row['booking_date']);
        $this->booking_rate->setDbValue($row['booking_rate']);
        $this->booking_currency->setDbValue($row['booking_currency']);
        $this->amount->setDbValue($row['amount']);
        $this->currency->setDbValue($row['currency']);
        $this->confirm_port_eta->setDbValue($row['confirm_port_eta']);
        $this->reference->setDbValue($row['reference']);
        $this->currency_current_rate->setDbValue($row['currency_current_rate']);
        $this->shipment_date->setDbValue($row['shipment_date']);
        $this->our_port->setDbValue($row['our_port']);
        $this->remarks->setDbValue($row['remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->url->setDbValue($row['url']);
        $this->product_code->setDbValue($row['product_code']);
        $this->packets->setDbValue($row['packets']);
        $this->confirm_type->setDbValue($row['confirm_type']);
        $this->company_id->setDbValue($row['company_id']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "BookingRefList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // supplier_id
        $this->supplier_id->CellCssStyle = "white-space: nowrap;";

        // ref

        // status

        // rid

        // quantity

        // b_quantity

        // confirm_quantity

        // confirm_pending

        // containers

        // booking_date

        // booking_rate

        // booking_currency

        // amount

        // currency

        // confirm_port_eta

        // reference

        // currency_current_rate

        // shipment_date

        // our_port

        // remarks

        // operator

        // datetime

        // url
        $this->url->CellCssStyle = "white-space: nowrap;";

        // product_code
        $this->product_code->CellCssStyle = "white-space: nowrap;";

        // packets

        // confirm_type

        // company_id

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // supplier_id
        $curVal = strval($this->supplier_id->CurrentValue);
        if ($curVal != "") {
            $this->supplier_id->ViewValue = $this->supplier_id->lookupCacheOption($curVal);
            if ($this->supplier_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->supplier_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->supplier_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->supplier_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->supplier_id->Lookup->renderViewRow($rswrk[0]);
                    $this->supplier_id->ViewValue = $this->supplier_id->displayValue($arwrk);
                } else {
                    $this->supplier_id->ViewValue = FormatNumber($this->supplier_id->CurrentValue, $this->supplier_id->formatPattern());
                }
            }
        } else {
            $this->supplier_id->ViewValue = null;
        }

        // ref
        $this->ref->ViewValue = $this->ref->CurrentValue;

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // rid
        $this->rid->ViewValue = $this->rid->CurrentValue;
        $curVal = strval($this->rid->CurrentValue);
        if ($curVal != "") {
            $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
            if ($this->rid->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                    $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                } else {
                    $this->rid->ViewValue = $this->rid->CurrentValue;
                }
            }
        } else {
            $this->rid->ViewValue = null;
        }

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // b_quantity
        $this->b_quantity->ViewValue = $this->b_quantity->CurrentValue;
        $this->b_quantity->ViewValue = FormatNumber($this->b_quantity->ViewValue, $this->b_quantity->formatPattern());
        $this->b_quantity->CssClass = "fw-bold";

        // confirm_quantity
        $this->confirm_quantity->ViewValue = $this->confirm_quantity->CurrentValue;
        $this->confirm_quantity->ViewValue = FormatNumber($this->confirm_quantity->ViewValue, $this->confirm_quantity->formatPattern());

        // confirm_pending
        $this->confirm_pending->ViewValue = $this->confirm_pending->CurrentValue;
        $this->confirm_pending->ViewValue = FormatNumber($this->confirm_pending->ViewValue, $this->confirm_pending->formatPattern());

        // containers
        $this->containers->ViewValue = $this->containers->CurrentValue;
        $this->containers->ViewValue = FormatNumber($this->containers->ViewValue, $this->containers->formatPattern());

        // booking_date
        $this->booking_date->ViewValue = $this->booking_date->CurrentValue;
        $this->booking_date->ViewValue = FormatDateTime($this->booking_date->ViewValue, $this->booking_date->formatPattern());

        // booking_rate
        $this->booking_rate->ViewValue = $this->booking_rate->CurrentValue;
        $this->booking_rate->ViewValue = FormatNumber($this->booking_rate->ViewValue, $this->booking_rate->formatPattern());

        // booking_currency
        $curVal = strval($this->booking_currency->CurrentValue);
        if ($curVal != "") {
            $this->booking_currency->ViewValue = $this->booking_currency->lookupCacheOption($curVal);
            if ($this->booking_currency->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->booking_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->booking_currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->booking_currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->booking_currency->Lookup->renderViewRow($rswrk[0]);
                    $this->booking_currency->ViewValue = $this->booking_currency->displayValue($arwrk);
                } else {
                    $this->booking_currency->ViewValue = $this->booking_currency->CurrentValue;
                }
            }
        } else {
            $this->booking_currency->ViewValue = null;
        }

        // amount
        $this->amount->ViewValue = $this->amount->CurrentValue;
        $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

        // currency
        $this->currency->ViewValue = $this->currency->CurrentValue;

        // confirm_port_eta
        $this->confirm_port_eta->ViewValue = $this->confirm_port_eta->CurrentValue;

        // reference
        $this->reference->ViewValue = $this->reference->CurrentValue;

        // currency_current_rate
        $this->currency_current_rate->ViewValue = $this->currency_current_rate->CurrentValue;
        $this->currency_current_rate->ViewValue = FormatNumber($this->currency_current_rate->ViewValue, $this->currency_current_rate->formatPattern());

        // shipment_date
        $this->shipment_date->ViewValue = $this->shipment_date->CurrentValue;
        $this->shipment_date->ViewValue = FormatDateTime($this->shipment_date->ViewValue, $this->shipment_date->formatPattern());

        // our_port
        $curVal = strval($this->our_port->CurrentValue);
        if ($curVal != "") {
            $this->our_port->ViewValue = $this->our_port->lookupCacheOption($curVal);
            if ($this->our_port->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->our_port->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->our_port->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->our_port->getSelectFilter($this); // PHP
                $sqlWrk = $this->our_port->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->our_port->Lookup->renderViewRow($rswrk[0]);
                    $this->our_port->ViewValue = $this->our_port->displayValue($arwrk);
                } else {
                    $this->our_port->ViewValue = $this->our_port->CurrentValue;
                }
            }
        } else {
            $this->our_port->ViewValue = null;
        }

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // url
        $this->url->ViewValue = $this->url->CurrentValue;

        // product_code
        $this->product_code->ViewValue = $this->product_code->CurrentValue;

        // packets
        $this->packets->ViewValue = $this->packets->CurrentValue;
        $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

        // confirm_type
        $this->confirm_type->ViewValue = $this->confirm_type->CurrentValue;

        // company_id
        $this->company_id->ViewValue = $this->company_id->CurrentValue;
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // supplier_id
        $this->supplier_id->HrefValue = "";
        $this->supplier_id->TooltipValue = "";

        // ref
        $this->ref->HrefValue = "";
        $this->ref->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // rid
        if (!EmptyValue($this->rid->CurrentValue)) {
            $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
            $this->rid->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
            }
        } else {
            $this->rid->HrefValue = "";
        }
        $this->rid->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // b_quantity
        $this->b_quantity->HrefValue = "";
        $this->b_quantity->TooltipValue = "";

        // confirm_quantity
        $this->confirm_quantity->HrefValue = "";
        $this->confirm_quantity->TooltipValue = "";

        // confirm_pending
        $this->confirm_pending->HrefValue = "";
        $this->confirm_pending->TooltipValue = "";

        // containers
        $this->containers->HrefValue = "";
        $this->containers->TooltipValue = "";

        // booking_date
        if (!EmptyValue($this->booking_date->CurrentValue)) {
            $this->booking_date->HrefValue = $this->booking_date->getLinkPrefix() . $this->booking_date->CurrentValue; // Add prefix/suffix
            $this->booking_date->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->booking_date->HrefValue = FullUrl($this->booking_date->HrefValue, "href");
            }
        } else {
            $this->booking_date->HrefValue = "";
        }
        $this->booking_date->TooltipValue = "";

        // booking_rate
        $this->booking_rate->HrefValue = "";
        $this->booking_rate->TooltipValue = "";

        // booking_currency
        $this->booking_currency->HrefValue = "";
        $this->booking_currency->TooltipValue = "";

        // amount
        $this->amount->HrefValue = "";
        $this->amount->TooltipValue = "";

        // currency
        $this->currency->HrefValue = "";
        $this->currency->TooltipValue = "";

        // confirm_port_eta
        $this->confirm_port_eta->HrefValue = "";
        $this->confirm_port_eta->TooltipValue = "";

        // reference
        $this->reference->HrefValue = "";
        $this->reference->TooltipValue = "";

        // currency_current_rate
        $this->currency_current_rate->HrefValue = "";
        $this->currency_current_rate->TooltipValue = "";

        // shipment_date
        if (!EmptyValue($this->shipment_date->CurrentValue)) {
            $this->shipment_date->HrefValue = $this->shipment_date->getLinkPrefix() . $this->shipment_date->CurrentValue; // Add prefix/suffix
            $this->shipment_date->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->shipment_date->HrefValue = FullUrl($this->shipment_date->HrefValue, "href");
            }
        } else {
            $this->shipment_date->HrefValue = "";
        }
        $this->shipment_date->TooltipValue = "";

        // our_port
        $this->our_port->HrefValue = "";
        $this->our_port->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // url
        $this->url->HrefValue = "";
        $this->url->TooltipValue = "";

        // product_code
        $this->product_code->HrefValue = "";
        $this->product_code->TooltipValue = "";

        // packets
        $this->packets->HrefValue = "";
        $this->packets->TooltipValue = "";

        // confirm_type
        $this->confirm_type->HrefValue = "";
        $this->confirm_type->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());

        // supplier_id
        $this->supplier_id->setupEditAttributes();
        $this->supplier_id->PlaceHolder = RemoveHtml($this->supplier_id->caption());

        // ref
        $this->ref->setupEditAttributes();
        if ($this->ref->getSessionValue() != "") {
            $this->ref->CurrentValue = GetForeignKeyValue($this->ref->getSessionValue());
            $this->ref->ViewValue = $this->ref->CurrentValue;
        } else {
            if (!$this->ref->Raw) {
                $this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
            }
            $this->ref->EditValue = $this->ref->CurrentValue;
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());
        }

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // rid
        $this->rid->setupEditAttributes();
        $this->rid->EditValue = $this->rid->CurrentValue;
        $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // b_quantity
        $this->b_quantity->setupEditAttributes();
        $this->b_quantity->EditValue = $this->b_quantity->CurrentValue;
        $this->b_quantity->PlaceHolder = RemoveHtml($this->b_quantity->caption());
        if (strval($this->b_quantity->EditValue) != "" && is_numeric($this->b_quantity->EditValue)) {
            $this->b_quantity->EditValue = FormatNumber($this->b_quantity->EditValue, null);
        }

        // confirm_quantity
        $this->confirm_quantity->setupEditAttributes();
        $this->confirm_quantity->EditValue = $this->confirm_quantity->CurrentValue;
        $this->confirm_quantity->PlaceHolder = RemoveHtml($this->confirm_quantity->caption());
        if (strval($this->confirm_quantity->EditValue) != "" && is_numeric($this->confirm_quantity->EditValue)) {
            $this->confirm_quantity->EditValue = FormatNumber($this->confirm_quantity->EditValue, null);
        }

        // confirm_pending
        $this->confirm_pending->setupEditAttributes();
        $this->confirm_pending->EditValue = $this->confirm_pending->CurrentValue;
        $this->confirm_pending->PlaceHolder = RemoveHtml($this->confirm_pending->caption());
        if (strval($this->confirm_pending->EditValue) != "" && is_numeric($this->confirm_pending->EditValue)) {
            $this->confirm_pending->EditValue = FormatNumber($this->confirm_pending->EditValue, null);
        }

        // containers
        $this->containers->setupEditAttributes();
        $this->containers->EditValue = $this->containers->CurrentValue;
        $this->containers->PlaceHolder = RemoveHtml($this->containers->caption());
        if (strval($this->containers->EditValue) != "" && is_numeric($this->containers->EditValue)) {
            $this->containers->EditValue = FormatNumber($this->containers->EditValue, null);
        }

        // booking_date
        $this->booking_date->setupEditAttributes();
        $this->booking_date->EditValue = FormatDateTime($this->booking_date->CurrentValue, $this->booking_date->formatPattern());
        $this->booking_date->PlaceHolder = RemoveHtml($this->booking_date->caption());

        // booking_rate
        $this->booking_rate->setupEditAttributes();
        $this->booking_rate->EditValue = $this->booking_rate->CurrentValue;
        $this->booking_rate->PlaceHolder = RemoveHtml($this->booking_rate->caption());
        if (strval($this->booking_rate->EditValue) != "" && is_numeric($this->booking_rate->EditValue)) {
            $this->booking_rate->EditValue = FormatNumber($this->booking_rate->EditValue, null);
        }

        // booking_currency
        $this->booking_currency->setupEditAttributes();
        $this->booking_currency->PlaceHolder = RemoveHtml($this->booking_currency->caption());

        // amount
        $this->amount->setupEditAttributes();
        $this->amount->EditValue = $this->amount->CurrentValue;
        $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
        if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
            $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
        }

        // currency
        $this->currency->setupEditAttributes();
        $this->currency->EditValue = $this->currency->CurrentValue;
        $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

        // confirm_port_eta
        $this->confirm_port_eta->setupEditAttributes();
        $this->confirm_port_eta->EditValue = $this->confirm_port_eta->CurrentValue;
        $this->confirm_port_eta->PlaceHolder = RemoveHtml($this->confirm_port_eta->caption());

        // reference
        $this->reference->setupEditAttributes();
        $this->reference->EditValue = $this->reference->CurrentValue;
        $this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

        // currency_current_rate
        $this->currency_current_rate->setupEditAttributes();
        $this->currency_current_rate->EditValue = $this->currency_current_rate->CurrentValue;
        $this->currency_current_rate->PlaceHolder = RemoveHtml($this->currency_current_rate->caption());
        if (strval($this->currency_current_rate->EditValue) != "" && is_numeric($this->currency_current_rate->EditValue)) {
            $this->currency_current_rate->EditValue = FormatNumber($this->currency_current_rate->EditValue, null);
        }

        // shipment_date
        $this->shipment_date->setupEditAttributes();
        $this->shipment_date->EditValue = FormatDateTime($this->shipment_date->CurrentValue, $this->shipment_date->formatPattern());
        $this->shipment_date->PlaceHolder = RemoveHtml($this->shipment_date->caption());

        // our_port
        $this->our_port->setupEditAttributes();
        $this->our_port->PlaceHolder = RemoveHtml($this->our_port->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // operator

        // datetime

        // url
        $this->url->setupEditAttributes();
        if (!$this->url->Raw) {
            $this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
        }
        $this->url->EditValue = $this->url->CurrentValue;
        $this->url->PlaceHolder = RemoveHtml($this->url->caption());

        // product_code
        $this->product_code->setupEditAttributes();
        if (!$this->product_code->Raw) {
            $this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
        }
        $this->product_code->EditValue = $this->product_code->CurrentValue;
        $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

        // packets
        $this->packets->setupEditAttributes();
        $this->packets->EditValue = $this->packets->CurrentValue;
        $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
        if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
            $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
        }

        // confirm_type
        $this->confirm_type->setupEditAttributes();
        if (!$this->confirm_type->Raw) {
            $this->confirm_type->CurrentValue = HtmlDecode($this->confirm_type->CurrentValue);
        }
        $this->confirm_type->EditValue = $this->confirm_type->CurrentValue;
        $this->confirm_type->PlaceHolder = RemoveHtml($this->confirm_type->caption());

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->EditValue = $this->company_id->CurrentValue;
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->quantity->CurrentValue)) {
                $this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->b_quantity->CurrentValue)) {
                $this->b_quantity->Total += $this->b_quantity->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->confirm_quantity->CurrentValue)) {
                $this->confirm_quantity->Total += $this->confirm_quantity->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->containers->CurrentValue)) {
                $this->containers->Total += $this->containers->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->quantity->CurrentValue = $this->quantity->Total;
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());
            $this->quantity->HrefValue = ""; // Clear href value
            $this->b_quantity->CurrentValue = $this->b_quantity->Total;
            $this->b_quantity->ViewValue = $this->b_quantity->CurrentValue;
            $this->b_quantity->ViewValue = FormatNumber($this->b_quantity->ViewValue, $this->b_quantity->formatPattern());
            $this->b_quantity->CssClass = "fw-bold";
            $this->b_quantity->HrefValue = ""; // Clear href value
            $this->confirm_quantity->CurrentValue = $this->confirm_quantity->Total;
            $this->confirm_quantity->ViewValue = $this->confirm_quantity->CurrentValue;
            $this->confirm_quantity->ViewValue = FormatNumber($this->confirm_quantity->ViewValue, $this->confirm_quantity->formatPattern());
            $this->confirm_quantity->HrefValue = ""; // Clear href value
            $this->containers->CurrentValue = $this->containers->Total;
            $this->containers->ViewValue = $this->containers->CurrentValue;
            $this->containers->ViewValue = FormatNumber($this->containers->ViewValue, $this->containers->formatPattern());
            $this->containers->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->supplier_id);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->b_quantity);
                    $doc->exportCaption($this->confirm_quantity);
                    $doc->exportCaption($this->confirm_pending);
                    $doc->exportCaption($this->containers);
                    $doc->exportCaption($this->booking_date);
                    $doc->exportCaption($this->booking_rate);
                    $doc->exportCaption($this->booking_currency);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->currency);
                    $doc->exportCaption($this->confirm_port_eta);
                    $doc->exportCaption($this->reference);
                    $doc->exportCaption($this->currency_current_rate);
                    $doc->exportCaption($this->shipment_date);
                    $doc->exportCaption($this->our_port);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->url);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->confirm_type);
                    $doc->exportCaption($this->company_id);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->b_quantity);
                    $doc->exportCaption($this->confirm_quantity);
                    $doc->exportCaption($this->confirm_pending);
                    $doc->exportCaption($this->containers);
                    $doc->exportCaption($this->booking_date);
                    $doc->exportCaption($this->booking_rate);
                    $doc->exportCaption($this->booking_currency);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->currency);
                    $doc->exportCaption($this->confirm_port_eta);
                    $doc->exportCaption($this->reference);
                    $doc->exportCaption($this->currency_current_rate);
                    $doc->exportCaption($this->shipment_date);
                    $doc->exportCaption($this->our_port);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->confirm_type);
                    $doc->exportCaption($this->company_id);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->supplier_id);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->status);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->b_quantity);
                        $doc->exportField($this->confirm_quantity);
                        $doc->exportField($this->confirm_pending);
                        $doc->exportField($this->containers);
                        $doc->exportField($this->booking_date);
                        $doc->exportField($this->booking_rate);
                        $doc->exportField($this->booking_currency);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->currency);
                        $doc->exportField($this->confirm_port_eta);
                        $doc->exportField($this->reference);
                        $doc->exportField($this->currency_current_rate);
                        $doc->exportField($this->shipment_date);
                        $doc->exportField($this->our_port);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->url);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->confirm_type);
                        $doc->exportField($this->company_id);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->status);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->b_quantity);
                        $doc->exportField($this->confirm_quantity);
                        $doc->exportField($this->confirm_pending);
                        $doc->exportField($this->containers);
                        $doc->exportField($this->booking_date);
                        $doc->exportField($this->booking_rate);
                        $doc->exportField($this->booking_currency);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->currency);
                        $doc->exportField($this->confirm_port_eta);
                        $doc->exportField($this->reference);
                        $doc->exportField($this->currency_current_rate);
                        $doc->exportField($this->shipment_date);
                        $doc->exportField($this->our_port);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->confirm_type);
                        $doc->exportField($this->company_id);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->ref, '');
                $doc->exportAggregate($this->status, '');
                $doc->exportAggregate($this->rid, '');
                $doc->exportAggregate($this->quantity, 'TOTAL');
                $doc->exportAggregate($this->b_quantity, 'TOTAL');
                $doc->exportAggregate($this->confirm_quantity, 'TOTAL');
                $doc->exportAggregate($this->confirm_pending, '');
                $doc->exportAggregate($this->containers, 'TOTAL');
                $doc->exportAggregate($this->booking_date, '');
                $doc->exportAggregate($this->booking_rate, '');
                $doc->exportAggregate($this->booking_currency, '');
                $doc->exportAggregate($this->amount, '');
                $doc->exportAggregate($this->currency, '');
                $doc->exportAggregate($this->confirm_port_eta, '');
                $doc->exportAggregate($this->reference, '');
                $doc->exportAggregate($this->currency_current_rate, '');
                $doc->exportAggregate($this->shipment_date, '');
                $doc->exportAggregate($this->our_port, '');
                $doc->exportAggregate($this->remarks, '');
                $doc->exportAggregate($this->operator, '');
                $doc->exportAggregate($this->datetime, '');
                $doc->exportAggregate($this->packets, '');
                $doc->exportAggregate($this->confirm_type, '');
                $doc->exportAggregate($this->company_id, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
