<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BookingDetailsSearch extends BookingDetails
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BookingDetailsSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "bookingdetailssearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->ref->setVisibility();
        $this->agent->setVisibility();
        $this->product_code->Visible = false;
        $this->supplier->Visible = false;
        $this->quantity->Visible = false;
        $this->b_quantity->setVisibility();
        $this->confirm_quantity->setVisibility();
        $this->port_eta->setVisibility();
        $this->bl_no->setVisibility();
        $this->containers->Visible = false;
        $this->booking_currency->setVisibility();
        $this->amount->setVisibility();
        $this->paid->setVisibility();
        $this->balance->setVisibility();
        $this->remarks->setVisibility();
        $this->status->setVisibility();
        $this->booking_by->setVisibility();
        $this->company_id->setVisibility();
        $this->t_url->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'booking_details';
        $this->TableName = 'booking_details';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (booking_details)
        if (!isset($GLOBALS["booking_details"]) || $GLOBALS["booking_details"]::class == PROJECT_NAMESPACE . "booking_details") {
            $GLOBALS["booking_details"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'booking_details');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "bookingdetailsview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->product_code->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->quantity->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->b_quantity->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->confirm_quantity->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->port_eta->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->bl_no->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->amount->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->paid->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->balance->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->t_url->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->supplier);
        $this->setupLookupOptions($this->booking_currency);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->company_id);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "bookingdetailslist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->ref); // ref
        $this->buildSearchUrl($srchUrl, $this->agent); // agent
        $this->buildSearchUrl($srchUrl, $this->b_quantity); // b_quantity
        $this->buildSearchUrl($srchUrl, $this->confirm_quantity); // confirm_quantity
        $this->buildSearchUrl($srchUrl, $this->port_eta); // port_eta
        $this->buildSearchUrl($srchUrl, $this->bl_no); // bl_no
        $this->buildSearchUrl($srchUrl, $this->booking_currency); // booking_currency
        $this->buildSearchUrl($srchUrl, $this->amount); // amount
        $this->buildSearchUrl($srchUrl, $this->paid); // paid
        $this->buildSearchUrl($srchUrl, $this->balance); // balance
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->booking_by); // booking_by
        $this->buildSearchUrl($srchUrl, $this->company_id); // company_id
        $this->buildSearchUrl($srchUrl, $this->t_url); // t_url
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ref
        if ($this->ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // agent
        if ($this->agent->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // supplier
        if ($this->supplier->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_quantity
        if ($this->b_quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // confirm_quantity
        if ($this->confirm_quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // port_eta
        if ($this->port_eta->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bl_no
        if ($this->bl_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // booking_currency
        if ($this->booking_currency->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // paid
        if ($this->paid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // balance
        if ($this->balance->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // booking_by
        if ($this->booking_by->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_url
        if ($this->t_url->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // supplier
        $this->supplier->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // b_quantity
        $this->b_quantity->RowCssClass = "row";

        // confirm_quantity
        $this->confirm_quantity->RowCssClass = "row";

        // port_eta
        $this->port_eta->RowCssClass = "row";

        // bl_no
        $this->bl_no->RowCssClass = "row";

        // containers
        $this->containers->RowCssClass = "row";

        // booking_currency
        $this->booking_currency->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // paid
        $this->paid->RowCssClass = "row";

        // balance
        $this->balance->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // booking_by
        $this->booking_by->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // t_url
        $this->t_url->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // agent
            $this->agent->ViewValue = $this->agent->CurrentValue;
            $this->agent->ViewValue = FormatNumber($this->agent->ViewValue, $this->agent->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // b_quantity
            $this->b_quantity->ViewValue = $this->b_quantity->CurrentValue;
            $this->b_quantity->ViewValue = FormatNumber($this->b_quantity->ViewValue, $this->b_quantity->formatPattern());
            $this->b_quantity->CssClass = "fw-bold";

            // confirm_quantity
            $this->confirm_quantity->ViewValue = $this->confirm_quantity->CurrentValue;
            $this->confirm_quantity->ViewValue = FormatNumber($this->confirm_quantity->ViewValue, $this->confirm_quantity->formatPattern());

            // port_eta
            $this->port_eta->ViewValue = $this->port_eta->CurrentValue;

            // bl_no
            $this->bl_no->ViewValue = $this->bl_no->CurrentValue;

            // containers
            $this->containers->ViewValue = $this->containers->CurrentValue;
            $this->containers->ViewValue = FormatNumber($this->containers->ViewValue, $this->containers->formatPattern());

            // booking_currency
            $curVal = strval($this->booking_currency->CurrentValue);
            if ($curVal != "") {
                $this->booking_currency->ViewValue = $this->booking_currency->lookupCacheOption($curVal);
                if ($this->booking_currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->booking_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->booking_currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->booking_currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->booking_currency->Lookup->renderViewRow($rswrk[0]);
                        $this->booking_currency->ViewValue = $this->booking_currency->displayValue($arwrk);
                    } else {
                        $this->booking_currency->ViewValue = $this->booking_currency->CurrentValue;
                    }
                }
            } else {
                $this->booking_currency->ViewValue = null;
            }

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // paid
            $this->paid->ViewValue = $this->paid->CurrentValue;
            $this->paid->ViewValue = FormatNumber($this->paid->ViewValue, $this->paid->formatPattern());

            // balance
            $this->balance->ViewValue = $this->balance->CurrentValue;
            $this->balance->ViewValue = FormatNumber($this->balance->ViewValue, $this->balance->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // booking_by
            $this->booking_by->ViewValue = $this->booking_by->CurrentValue;
            $this->booking_by->ViewValue = FormatNumber($this->booking_by->ViewValue, $this->booking_by->formatPattern());

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // t_url
            $this->t_url->ViewValue = $this->t_url->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // ref
            $this->ref->HrefValue = "";
            $this->ref->TooltipValue = "";

            // agent
            $this->agent->HrefValue = "";
            $this->agent->TooltipValue = "";

            // b_quantity
            $this->b_quantity->HrefValue = "";
            $this->b_quantity->TooltipValue = "";

            // confirm_quantity
            $this->confirm_quantity->HrefValue = "";
            $this->confirm_quantity->TooltipValue = "";

            // port_eta
            $this->port_eta->HrefValue = "";
            $this->port_eta->TooltipValue = "";

            // bl_no
            if (!EmptyValue($this->t_url->CurrentValue)) {
                $this->bl_no->HrefValue = $this->t_url->CurrentValue; // Add prefix/suffix
                $this->bl_no->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->bl_no->HrefValue = FullUrl($this->bl_no->HrefValue, "href");
                }
            } else {
                $this->bl_no->HrefValue = "";
            }
            $this->bl_no->TooltipValue = "";

            // booking_currency
            $this->booking_currency->HrefValue = "";
            $this->booking_currency->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // paid
            $this->paid->HrefValue = "";
            $this->paid->TooltipValue = "";

            // balance
            $this->balance->HrefValue = "";
            $this->balance->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // booking_by
            $this->booking_by->HrefValue = "";
            $this->booking_by->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // t_url
            $this->t_url->HrefValue = "";
            $this->t_url->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            if (!$this->id->Raw) {
                $this->id->AdvancedSearch->SearchValue = HtmlDecode($this->id->AdvancedSearch->SearchValue);
            }
            $this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // ref
            $this->ref->setupEditAttributes();
            if (!$this->ref->Raw) {
                $this->ref->AdvancedSearch->SearchValue = HtmlDecode($this->ref->AdvancedSearch->SearchValue);
            }
            $this->ref->EditValue = HtmlEncode($this->ref->AdvancedSearch->SearchValue);
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

            // agent
            $this->agent->setupEditAttributes();
            $this->agent->EditValue = $this->agent->AdvancedSearch->SearchValue;
            $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

            // b_quantity
            $this->b_quantity->setupEditAttributes();
            $this->b_quantity->EditValue = $this->b_quantity->AdvancedSearch->SearchValue;
            $this->b_quantity->PlaceHolder = RemoveHtml($this->b_quantity->caption());

            // confirm_quantity
            $this->confirm_quantity->setupEditAttributes();
            $this->confirm_quantity->EditValue = $this->confirm_quantity->AdvancedSearch->SearchValue;
            $this->confirm_quantity->PlaceHolder = RemoveHtml($this->confirm_quantity->caption());

            // port_eta
            $this->port_eta->setupEditAttributes();
            $this->port_eta->EditValue = HtmlEncode($this->port_eta->AdvancedSearch->SearchValue);
            $this->port_eta->PlaceHolder = RemoveHtml($this->port_eta->caption());

            // bl_no
            $this->bl_no->setupEditAttributes();
            $this->bl_no->EditValue = HtmlEncode($this->bl_no->AdvancedSearch->SearchValue);
            $this->bl_no->PlaceHolder = RemoveHtml($this->bl_no->caption());

            // booking_currency
            $this->booking_currency->setupEditAttributes();
            $curVal = trim(strval($this->booking_currency->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->booking_currency->AdvancedSearch->ViewValue = $this->booking_currency->lookupCacheOption($curVal);
            } else {
                $this->booking_currency->AdvancedSearch->ViewValue = $this->booking_currency->Lookup !== null && is_array($this->booking_currency->lookupOptions()) && count($this->booking_currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->booking_currency->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->booking_currency->EditValue = array_values($this->booking_currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->booking_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->booking_currency->AdvancedSearch->SearchValue, $this->booking_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->booking_currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->booking_currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->booking_currency->EditValue = $arwrk;
            }
            $this->booking_currency->PlaceHolder = RemoveHtml($this->booking_currency->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->AdvancedSearch->SearchValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // paid
            $this->paid->setupEditAttributes();
            $this->paid->EditValue = $this->paid->AdvancedSearch->SearchValue;
            $this->paid->PlaceHolder = RemoveHtml($this->paid->caption());

            // balance
            $this->balance->setupEditAttributes();
            $this->balance->EditValue = $this->balance->AdvancedSearch->SearchValue;
            $this->balance->PlaceHolder = RemoveHtml($this->balance->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // booking_by
            $this->booking_by->setupEditAttributes();
            $this->booking_by->EditValue = $this->booking_by->AdvancedSearch->SearchValue;
            $this->booking_by->PlaceHolder = RemoveHtml($this->booking_by->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->AdvancedSearch->SearchValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // t_url
            $this->t_url->setupEditAttributes();
            if (!$this->t_url->Raw) {
                $this->t_url->AdvancedSearch->SearchValue = HtmlDecode($this->t_url->AdvancedSearch->SearchValue);
            }
            $this->t_url->EditValue = HtmlEncode($this->t_url->AdvancedSearch->SearchValue);
            $this->t_url->PlaceHolder = RemoveHtml($this->t_url->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->agent->AdvancedSearch->SearchValue)) {
            $this->agent->addErrorMessage($this->agent->getErrorMessage(false));
        }
        if (!CheckNumber($this->b_quantity->AdvancedSearch->SearchValue)) {
            $this->b_quantity->addErrorMessage($this->b_quantity->getErrorMessage(false));
        }
        if (!CheckNumber($this->confirm_quantity->AdvancedSearch->SearchValue)) {
            $this->confirm_quantity->addErrorMessage($this->confirm_quantity->getErrorMessage(false));
        }
        if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
            $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->paid->AdvancedSearch->SearchValue)) {
            $this->paid->addErrorMessage($this->paid->getErrorMessage(false));
        }
        if (!CheckNumber($this->balance->AdvancedSearch->SearchValue)) {
            $this->balance->addErrorMessage($this->balance->getErrorMessage(false));
        }
        if (!CheckInteger($this->booking_by->AdvancedSearch->SearchValue)) {
            $this->booking_by->addErrorMessage($this->booking_by->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->ref->AdvancedSearch->load();
        $this->agent->AdvancedSearch->load();
        $this->supplier->AdvancedSearch->load();
        $this->b_quantity->AdvancedSearch->load();
        $this->confirm_quantity->AdvancedSearch->load();
        $this->port_eta->AdvancedSearch->load();
        $this->bl_no->AdvancedSearch->load();
        $this->booking_currency->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->paid->AdvancedSearch->load();
        $this->balance->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->booking_by->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->t_url->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bookingdetailslist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_supplier":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_booking_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
