<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BookingConfirmSearch extends BookingConfirm
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BookingConfirmSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "bookingconfirmsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->supplier->setVisibility();
        $this->confirm_type->setVisibility();
        $this->booking_ref->setVisibility();
        $this->approx_qty->setVisibility();
        $this->packets->setVisibility();
        $this->amount->setVisibility();
        $this->currency->setVisibility();
        $this->date->setVisibility();
        $this->reference->setVisibility();
        $this->date_of_dispatch->setVisibility();
        $this->port_eta->setVisibility();
        $this->bl_no->setVisibility();
        $this->s_line->setVisibility();
        $this->company_id->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->fibc->Visible = false;
        $this->ref->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'booking_confirm';
        $this->TableName = 'booking_confirm';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (booking_confirm)
        if (!isset($GLOBALS["booking_confirm"]) || $GLOBALS["booking_confirm"]::class == PROJECT_NAMESPACE . "booking_confirm") {
            $GLOBALS["booking_confirm"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'booking_confirm');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "bookingconfirmview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->supplier);
        $this->setupLookupOptions($this->confirm_type);
        $this->setupLookupOptions($this->booking_ref);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->s_line);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "bookingconfirmlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->supplier); // supplier
        $this->buildSearchUrl($srchUrl, $this->confirm_type); // confirm_type
        $this->buildSearchUrl($srchUrl, $this->booking_ref); // booking_ref
        $this->buildSearchUrl($srchUrl, $this->approx_qty); // approx_qty
        $this->buildSearchUrl($srchUrl, $this->packets); // packets
        $this->buildSearchUrl($srchUrl, $this->amount); // amount
        $this->buildSearchUrl($srchUrl, $this->currency); // currency
        $this->buildSearchUrl($srchUrl, $this->date); // date
        $this->buildSearchUrl($srchUrl, $this->reference); // reference
        $this->buildSearchUrl($srchUrl, $this->date_of_dispatch); // date_of_dispatch
        $this->buildSearchUrl($srchUrl, $this->port_eta); // port_eta
        $this->buildSearchUrl($srchUrl, $this->bl_no); // bl_no
        $this->buildSearchUrl($srchUrl, $this->s_line); // s_line
        $this->buildSearchUrl($srchUrl, $this->company_id); // company_id
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->ref); // ref
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // supplier
        if ($this->supplier->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // confirm_type
        if ($this->confirm_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // booking_ref
        if ($this->booking_ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // approx_qty
        if ($this->approx_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packets
        if ($this->packets->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // currency
        if ($this->currency->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // date
        if ($this->date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // reference
        if ($this->reference->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // date_of_dispatch
        if ($this->date_of_dispatch->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // port_eta
        if ($this->port_eta->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bl_no
        if ($this->bl_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_line
        if ($this->s_line->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ref
        if ($this->ref->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // supplier
        $this->supplier->RowCssClass = "row";

        // confirm_type
        $this->confirm_type->RowCssClass = "row";

        // booking_ref
        $this->booking_ref->RowCssClass = "row";

        // approx_qty
        $this->approx_qty->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // date
        $this->date->RowCssClass = "row";

        // reference
        $this->reference->RowCssClass = "row";

        // date_of_dispatch
        $this->date_of_dispatch->RowCssClass = "row";

        // port_eta
        $this->port_eta->RowCssClass = "row";

        // bl_no
        $this->bl_no->RowCssClass = "row";

        // s_line
        $this->s_line->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // fibc
        $this->fibc->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // supplier
            $curVal = strval($this->supplier->CurrentValue);
            if ($curVal != "") {
                $this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
                if ($this->supplier->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                    $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                        $this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
                    } else {
                        $this->supplier->ViewValue = $this->supplier->CurrentValue;
                    }
                }
            } else {
                $this->supplier->ViewValue = null;
            }

            // confirm_type
            if (strval($this->confirm_type->CurrentValue) != "") {
                $this->confirm_type->ViewValue = $this->confirm_type->optionCaption($this->confirm_type->CurrentValue);
            } else {
                $this->confirm_type->ViewValue = null;
            }

            // booking_ref
            $curVal = strval($this->booking_ref->CurrentValue);
            if ($curVal != "") {
                $this->booking_ref->ViewValue = $this->booking_ref->lookupCacheOption($curVal);
                if ($this->booking_ref->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->booking_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->booking_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->booking_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->booking_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->booking_ref->ViewValue = $this->booking_ref->displayValue($arwrk);
                    } else {
                        $this->booking_ref->ViewValue = $this->booking_ref->CurrentValue;
                    }
                }
            } else {
                $this->booking_ref->ViewValue = null;
            }

            // approx_qty
            $this->approx_qty->ViewValue = $this->approx_qty->CurrentValue;
            $this->approx_qty->ViewValue = FormatNumber($this->approx_qty->ViewValue, $this->approx_qty->formatPattern());

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // currency
            $this->currency->ViewValue = $this->currency->CurrentValue;
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // date
            $this->date->ViewValue = $this->date->CurrentValue;
            $this->date->ViewValue = FormatDateTime($this->date->ViewValue, $this->date->formatPattern());

            // reference
            $this->reference->ViewValue = $this->reference->CurrentValue;

            // date_of_dispatch
            $this->date_of_dispatch->ViewValue = $this->date_of_dispatch->CurrentValue;
            $this->date_of_dispatch->ViewValue = FormatDateTime($this->date_of_dispatch->ViewValue, $this->date_of_dispatch->formatPattern());

            // port_eta
            $this->port_eta->ViewValue = $this->port_eta->CurrentValue;
            $this->port_eta->ViewValue = FormatDateTime($this->port_eta->ViewValue, $this->port_eta->formatPattern());

            // bl_no
            $this->bl_no->ViewValue = $this->bl_no->CurrentValue;

            // s_line
            $curVal = strval($this->s_line->CurrentValue);
            if ($curVal != "") {
                $this->s_line->ViewValue = $this->s_line->lookupCacheOption($curVal);
                if ($this->s_line->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_line->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_line->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_line->Lookup->renderViewRow($rswrk[0]);
                        $this->s_line->ViewValue = $this->s_line->displayValue($arwrk);
                    } else {
                        $this->s_line->ViewValue = FormatNumber($this->s_line->CurrentValue, $this->s_line->formatPattern());
                    }
                }
            } else {
                $this->s_line->ViewValue = null;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }
            $this->supplier->TooltipValue = "";

            // confirm_type
            $this->confirm_type->HrefValue = "";
            $this->confirm_type->TooltipValue = "";

            // booking_ref
            $this->booking_ref->HrefValue = "";
            $this->booking_ref->TooltipValue = "";

            // approx_qty
            $this->approx_qty->HrefValue = "";
            $this->approx_qty->TooltipValue = "";

            // packets
            $this->packets->HrefValue = "";
            $this->packets->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // currency
            $this->currency->HrefValue = "";
            $this->currency->TooltipValue = "";

            // date
            $this->date->HrefValue = "";
            $this->date->TooltipValue = "";

            // reference
            $this->reference->HrefValue = "";
            $this->reference->TooltipValue = "";

            // date_of_dispatch
            $this->date_of_dispatch->HrefValue = "";
            $this->date_of_dispatch->TooltipValue = "";

            // port_eta
            $this->port_eta->HrefValue = "";
            $this->port_eta->TooltipValue = "";

            // bl_no
            $this->bl_no->HrefValue = "";
            $this->bl_no->TooltipValue = "";

            // s_line
            $this->s_line->HrefValue = "";
            $this->s_line->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // ref
            $this->ref->HrefValue = "";
            $this->ref->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // supplier
            $this->supplier->setupEditAttributes();
            $curVal = trim(strval($this->supplier->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->supplier->AdvancedSearch->ViewValue = $this->supplier->lookupCacheOption($curVal);
            } else {
                $this->supplier->AdvancedSearch->ViewValue = $this->supplier->Lookup !== null && is_array($this->supplier->lookupOptions()) && count($this->supplier->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->supplier->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->supplier->EditValue = array_values($this->supplier->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->supplier->AdvancedSearch->SearchValue, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                $sqlWrk = $this->supplier->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->supplier->EditValue = $arwrk;
            }
            $this->supplier->PlaceHolder = RemoveHtml($this->supplier->caption());

            // confirm_type
            $this->confirm_type->setupEditAttributes();
            $this->confirm_type->EditValue = $this->confirm_type->options(true);
            $this->confirm_type->PlaceHolder = RemoveHtml($this->confirm_type->caption());

            // booking_ref
            $this->booking_ref->setupEditAttributes();
            $curVal = trim(strval($this->booking_ref->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->booking_ref->AdvancedSearch->ViewValue = $this->booking_ref->lookupCacheOption($curVal);
            } else {
                $this->booking_ref->AdvancedSearch->ViewValue = $this->booking_ref->Lookup !== null && is_array($this->booking_ref->lookupOptions()) && count($this->booking_ref->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->booking_ref->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->booking_ref->EditValue = array_values($this->booking_ref->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->booking_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->booking_ref->AdvancedSearch->SearchValue, $this->booking_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->booking_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->booking_ref->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->booking_ref->Lookup->renderViewRow($row);
                }
                $this->booking_ref->EditValue = $arwrk;
            }
            $this->booking_ref->PlaceHolder = RemoveHtml($this->booking_ref->caption());

            // approx_qty
            $this->approx_qty->setupEditAttributes();
            $this->approx_qty->EditValue = $this->approx_qty->AdvancedSearch->SearchValue;
            $this->approx_qty->PlaceHolder = RemoveHtml($this->approx_qty->caption());

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->AdvancedSearch->SearchValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->AdvancedSearch->SearchValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            $this->amount->setupEditAttributes();
            $this->amount->EditValue2 = $this->amount->AdvancedSearch->SearchValue2;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // currency
            $this->currency->setupEditAttributes();
            $this->currency->EditValue = $this->currency->AdvancedSearch->SearchValue;
            $curVal = strval($this->currency->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->currency->EditValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->EditValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->EditValue = HtmlEncode(FormatNumber($this->currency->AdvancedSearch->SearchValue, $this->currency->formatPattern()));
                    }
                }
            } else {
                $this->currency->EditValue = null;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // date
            $this->date->setupEditAttributes();
            $this->date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->date->AdvancedSearch->SearchValue, $this->date->formatPattern()), $this->date->formatPattern()));
            $this->date->PlaceHolder = RemoveHtml($this->date->caption());

            // reference
            $this->reference->setupEditAttributes();
            $this->reference->EditValue = HtmlEncode($this->reference->AdvancedSearch->SearchValue);
            $this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

            // date_of_dispatch
            $this->date_of_dispatch->setupEditAttributes();
            $this->date_of_dispatch->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->date_of_dispatch->AdvancedSearch->SearchValue, $this->date_of_dispatch->formatPattern()), $this->date_of_dispatch->formatPattern()));
            $this->date_of_dispatch->PlaceHolder = RemoveHtml($this->date_of_dispatch->caption());

            // port_eta
            $this->port_eta->setupEditAttributes();
            $this->port_eta->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->port_eta->AdvancedSearch->SearchValue, $this->port_eta->formatPattern()), $this->port_eta->formatPattern()));
            $this->port_eta->PlaceHolder = RemoveHtml($this->port_eta->caption());
            $this->port_eta->setupEditAttributes();
            $this->port_eta->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->port_eta->AdvancedSearch->SearchValue2, $this->port_eta->formatPattern()), $this->port_eta->formatPattern()));
            $this->port_eta->PlaceHolder = RemoveHtml($this->port_eta->caption());

            // bl_no
            $this->bl_no->setupEditAttributes();
            if (!$this->bl_no->Raw) {
                $this->bl_no->AdvancedSearch->SearchValue = HtmlDecode($this->bl_no->AdvancedSearch->SearchValue);
            }
            $this->bl_no->EditValue = HtmlEncode($this->bl_no->AdvancedSearch->SearchValue);
            $this->bl_no->PlaceHolder = RemoveHtml($this->bl_no->caption());

            // s_line
            $this->s_line->setupEditAttributes();
            $curVal = trim(strval($this->s_line->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->s_line->AdvancedSearch->ViewValue = $this->s_line->lookupCacheOption($curVal);
            } else {
                $this->s_line->AdvancedSearch->ViewValue = $this->s_line->Lookup !== null && is_array($this->s_line->lookupOptions()) && count($this->s_line->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_line->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->s_line->EditValue = array_values($this->s_line->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_line->AdvancedSearch->SearchValue, $this->s_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_line->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_line->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_line->EditValue = $arwrk;
            }
            $this->s_line->PlaceHolder = RemoveHtml($this->s_line->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->AdvancedSearch->SearchValue;
            $curVal = strval($this->company_id->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = HtmlEncode(FormatNumber($this->company_id->AdvancedSearch->SearchValue, $this->company_id->formatPattern()));
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // ref
            $this->ref->setupEditAttributes();
            if (!$this->ref->Raw) {
                $this->ref->AdvancedSearch->SearchValue = HtmlDecode($this->ref->AdvancedSearch->SearchValue);
            }
            $this->ref->EditValue = HtmlEncode($this->ref->AdvancedSearch->SearchValue);
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->approx_qty->AdvancedSearch->SearchValue)) {
            $this->approx_qty->addErrorMessage($this->approx_qty->getErrorMessage(false));
        }
        if (!CheckInteger($this->packets->AdvancedSearch->SearchValue)) {
            $this->packets->addErrorMessage($this->packets->getErrorMessage(false));
        }
        if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
            $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->amount->AdvancedSearch->SearchValue2)) {
            $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
        }
        if (!CheckInteger($this->currency->AdvancedSearch->SearchValue)) {
            $this->currency->addErrorMessage($this->currency->getErrorMessage(false));
        }
        if (!CheckDate($this->date->AdvancedSearch->SearchValue, $this->date->formatPattern())) {
            $this->date->addErrorMessage($this->date->getErrorMessage(false));
        }
        if (!CheckDate($this->date_of_dispatch->AdvancedSearch->SearchValue, $this->date_of_dispatch->formatPattern())) {
            $this->date_of_dispatch->addErrorMessage($this->date_of_dispatch->getErrorMessage(false));
        }
        if (!CheckDate($this->port_eta->AdvancedSearch->SearchValue, $this->port_eta->formatPattern())) {
            $this->port_eta->addErrorMessage($this->port_eta->getErrorMessage(false));
        }
        if (!CheckDate($this->port_eta->AdvancedSearch->SearchValue2, $this->port_eta->formatPattern())) {
            $this->port_eta->addErrorMessage($this->port_eta->getErrorMessage(false));
        }
        if (!CheckInteger($this->company_id->AdvancedSearch->SearchValue)) {
            $this->company_id->addErrorMessage($this->company_id->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->supplier->AdvancedSearch->load();
        $this->confirm_type->AdvancedSearch->load();
        $this->booking_ref->AdvancedSearch->load();
        $this->approx_qty->AdvancedSearch->load();
        $this->packets->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->date->AdvancedSearch->load();
        $this->reference->AdvancedSearch->load();
        $this->date_of_dispatch->AdvancedSearch->load();
        $this->port_eta->AdvancedSearch->load();
        $this->bl_no->AdvancedSearch->load();
        $this->s_line->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->ref->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bookingconfirmlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_supplier":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_confirm_type":
                    break;
                case "x_booking_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_line":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
