<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BookingConfirmGrid extends BookingConfirm
{
    use MessagesTrait;

    // Page ID
    public $PageID = "grid";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BookingConfirmGrid";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fbooking_confirmgrid";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "bookingconfirmgrid";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->supplier->setVisibility();
        $this->confirm_type->setVisibility();
        $this->booking_ref->setVisibility();
        $this->approx_qty->setVisibility();
        $this->packets->setVisibility();
        $this->amount->setVisibility();
        $this->currency->setVisibility();
        $this->date->setVisibility();
        $this->reference->setVisibility();
        $this->date_of_dispatch->setVisibility();
        $this->port_eta->setVisibility();
        $this->bl_no->setVisibility();
        $this->s_line->setVisibility();
        $this->company_id->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->fibc->Visible = false;
        $this->ref->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'booking_confirm';
        $this->TableName = 'booking_confirm';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $this->FormActionName .= "_" . $this->FormName;
        $this->OldKeyName .= "_" . $this->FormName;
        $this->FormBlankRowName .= "_" . $this->FormName;
        $this->FormKeyCountName .= "_" . $this->FormName;
        $GLOBALS["Grid"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (booking_confirm)
        if (!isset($GLOBALS["booking_confirm"]) || $GLOBALS["booking_confirm"]::class == PROJECT_NAMESPACE . "booking_confirm") {
            $GLOBALS["booking_confirm"] = &$this;
        }
        $this->AddUrl = "bookingconfirmadd";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'booking_confirm');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;
        unset($GLOBALS["Grid"]);
        if ($url === "") {
            return;
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $ShowOtherOptions = false;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        if (Param("export") !== null) {
            $this->Export = Param("export");
        }

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up master detail parameters
        $this->setupMasterParms();

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->supplier);
        $this->setupLookupOptions($this->confirm_type);
        $this->setupLookupOptions($this->booking_ref);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->s_line);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fbooking_confirmgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Show grid delete link for grid add / grid edit
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $item = $this->ListOptions["griddelete"];
                if ($item) {
                    $item->Visible = $Security->allowDelete(CurrentProjectID() . $this->TableName);
                }
            }
        }

        // Set up sorting order
        $this->setupSortOrder();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }

        // Restore master/detail filter from session
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Restore master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Restore detail filter from session
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Load master record
        if ($this->CurrentMode != "add" && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "booking_details") {
            $masterTbl = Container("booking_details");
            $rsmaster = $masterTbl->loadRs($this->DbMasterFilter)->fetchAssociative();
            $this->MasterRecordExists = $rsmaster !== false;
            if (!$this->MasterRecordExists) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
                $this->terminate("bookingdetailslist"); // Return to master page
                return;
            } else {
                $masterTbl->loadListRowValues($rsmaster);
                $masterTbl->RowType = RowType::MASTER; // Master row
                $masterTbl->renderListRow();
            }
        }

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->TotalRecords = $this->listRecordCount();
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->TotalRecords;
                $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
            } else {
                $this->CurrentFilter = "0=1";
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->GridAddRowCount;
            }
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->TotalRecords; // Display all records
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Exit inline mode
    protected function clearInlineMode()
    {
        $this->approx_qty->FormValue = ""; // Clear form value
        $this->amount->FormValue = ""; // Clear form value
        $this->LastAction = $this->CurrentAction; // Save last action
        $this->CurrentAction = ""; // Clear action
        $_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
    }

    // Switch to grid add mode
    protected function gridAddMode()
    {
        $this->CurrentAction = "gridadd";
        $_SESSION[SESSION_INLINE_MODE] = "gridadd";
        $this->hideFieldsForAddEdit();
    }

    // Switch to grid edit mode
    protected function gridEditMode()
    {
        $this->CurrentAction = "gridedit";
        $_SESSION[SESSION_INLINE_MODE] = "gridedit";
        $this->hideFieldsForAddEdit();
    }

    // Perform update to grid
    public function gridUpdate()
    {
        global $Language, $CurrentForm;
        $gridUpdate = true;

        // Get old result set
        $this->CurrentFilter = $this->buildKeyFilter();
        if ($this->CurrentFilter == "") {
            $this->CurrentFilter = "0=1";
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        if ($rs = $conn->executeQuery($sql)) {
            $rsold = $rs->fetchAllAssociative();
        }

        // Call Grid Updating event
        if (!$this->gridUpdating($rsold)) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();
        $wrkfilter = "";
        $key = "";

        // Update row index and get row key
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Update all rows based on key
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            $CurrentForm->Index = $rowindex;
            $this->setKey($CurrentForm->getValue($this->OldKeyName));
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));

            // Load all values and keys
            if ($rowaction != "insertdelete" && $rowaction != "hide") { // Skip insert then deleted rows / hidden rows for grid edit
                $this->loadFormValues(); // Get form values
                if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
                    $gridUpdate = $this->OldKey != ""; // Key must not be empty
                } else {
                    $gridUpdate = true;
                }

                // Skip empty row
                if ($rowaction == "insert" && $this->emptyRow()) {
                // Validate form and insert/update/delete record
                } elseif ($gridUpdate) {
                    if ($rowaction == "delete") {
                        $this->CurrentFilter = $this->getRecordFilter();
                        $gridUpdate = $this->deleteRows(); // Delete this row
                    } else {
                        if ($rowaction == "insert") {
                            $gridUpdate = $this->addRow(); // Insert this row
                        } else {
                            if ($this->OldKey != "") {
                                $this->SendEmail = false; // Do not send email on update success
                                $gridUpdate = $this->editRow(); // Update this row
                            }
                        } // End update
                        if ($gridUpdate) { // Get inserted or updated filter
                            AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                        }
                    }
                }
                if ($gridUpdate) {
                    if ($key != "") {
                        $key .= ", ";
                    }
                    $key .= $this->OldKey;
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($gridUpdate) {
            $this->FilterForModalActions = $wrkfilter;

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Updated event
            $this->gridUpdated($rsold, $rsnew);
            $this->clearInlineMode(); // Clear inline edit mode
        } else {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
            }
        }
        return $gridUpdate;
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Perform grid add
    public function gridInsert()
    {
        global $Language, $CurrentForm;
        $rowindex = 1;
        $gridInsert = false;
        $conn = $this->getConnection();

        // Call Grid Inserting event
        if (!$this->gridInserting()) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();

        // Init key filter
        $wrkfilter = "";
        $addcnt = 0;
        $key = "";

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Insert all rows
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "" && $rowaction != "insert") {
                continue; // Skip
            }
            $rsold = null;
            if ($rowaction == "insert") {
                $this->OldKey = strval($CurrentForm->getValue($this->OldKeyName));
                $rsold = $this->loadOldRecord(); // Load old record
            }
            $this->loadFormValues(); // Get form values
            if (!$this->emptyRow()) {
                $addcnt++;
                $this->SendEmail = false; // Do not send email on insert success
                $gridInsert = $this->addRow($rsold); // Insert row (already validated by validateGridForm())
                if ($gridInsert) {
                    if ($key != "") {
                        $key .= Config("COMPOSITE_KEY_SEPARATOR");
                    }
                    $key .= $this->id->CurrentValue;

                    // Add filter for this record
                    AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($addcnt == 0) { // No record inserted
            $this->clearInlineMode(); // Clear grid add mode and return
            return true;
        }
        if ($gridInsert) {
            // Get new records
            $this->CurrentFilter = $wrkfilter;
            $this->FilterForModalActions = $wrkfilter;
            $sql = $this->getCurrentSql();
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Inserted event
            $this->gridInserted($rsnew);
            $this->clearInlineMode(); // Clear grid add mode
        } else {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
            }
        }
        return $gridInsert;
    }

    // Check if empty row
    public function emptyRow()
    {
        global $CurrentForm;
        if (
            $CurrentForm->hasValue("x_supplier") &&
            $CurrentForm->hasValue("o_supplier") &&
            $this->supplier->CurrentValue != $this->supplier->DefaultValue &&
            !($this->supplier->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->supplier->CurrentValue == $this->supplier->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_confirm_type") &&
            $CurrentForm->hasValue("o_confirm_type") &&
            $this->confirm_type->CurrentValue != $this->confirm_type->DefaultValue &&
            !($this->confirm_type->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->confirm_type->CurrentValue == $this->confirm_type->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_booking_ref") &&
            $CurrentForm->hasValue("o_booking_ref") &&
            $this->booking_ref->CurrentValue != $this->booking_ref->DefaultValue &&
            !($this->booking_ref->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->booking_ref->CurrentValue == $this->booking_ref->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_approx_qty") &&
            $CurrentForm->hasValue("o_approx_qty") &&
            $this->approx_qty->CurrentValue != $this->approx_qty->DefaultValue &&
            !($this->approx_qty->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->approx_qty->CurrentValue == $this->approx_qty->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_packets") &&
            $CurrentForm->hasValue("o_packets") &&
            $this->packets->CurrentValue != $this->packets->DefaultValue &&
            !($this->packets->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->packets->CurrentValue == $this->packets->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_amount") &&
            $CurrentForm->hasValue("o_amount") &&
            $this->amount->CurrentValue != $this->amount->DefaultValue &&
            !($this->amount->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->amount->CurrentValue == $this->amount->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_currency") &&
            $CurrentForm->hasValue("o_currency") &&
            $this->currency->CurrentValue != $this->currency->DefaultValue &&
            !($this->currency->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->currency->CurrentValue == $this->currency->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_date") &&
            $CurrentForm->hasValue("o_date") &&
            $this->date->CurrentValue != $this->date->DefaultValue &&
            !($this->date->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->date->CurrentValue == $this->date->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_reference") &&
            $CurrentForm->hasValue("o_reference") &&
            $this->reference->CurrentValue != $this->reference->DefaultValue &&
            !($this->reference->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->reference->CurrentValue == $this->reference->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_date_of_dispatch") &&
            $CurrentForm->hasValue("o_date_of_dispatch") &&
            $this->date_of_dispatch->CurrentValue != $this->date_of_dispatch->DefaultValue &&
            !($this->date_of_dispatch->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->date_of_dispatch->CurrentValue == $this->date_of_dispatch->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_port_eta") &&
            $CurrentForm->hasValue("o_port_eta") &&
            $this->port_eta->CurrentValue != $this->port_eta->DefaultValue &&
            !($this->port_eta->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->port_eta->CurrentValue == $this->port_eta->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_bl_no") &&
            $CurrentForm->hasValue("o_bl_no") &&
            $this->bl_no->CurrentValue != $this->bl_no->DefaultValue &&
            !($this->bl_no->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->bl_no->CurrentValue == $this->bl_no->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_s_line") &&
            $CurrentForm->hasValue("o_s_line") &&
            $this->s_line->CurrentValue != $this->s_line->DefaultValue &&
            !($this->s_line->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->s_line->CurrentValue == $this->s_line->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_company_id") &&
            $CurrentForm->hasValue("o_company_id") &&
            $this->company_id->CurrentValue != $this->company_id->DefaultValue &&
            !($this->company_id->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->company_id->CurrentValue == $this->company_id->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_ref") &&
            $CurrentForm->hasValue("o_ref") &&
            $this->ref->CurrentValue != $this->ref->DefaultValue &&
            !($this->ref->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->ref->CurrentValue == $this->ref->getSessionValue())
        ) {
            return false;
        }
        return true;
    }

    // Validate grid form
    public function validateGridForm()
    {
        global $CurrentForm;

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Load default values for emptyRow checking
        $this->loadDefaultValues();

        // Validate all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete" && $rowaction != "hide") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } elseif (!$this->validateForm()) {
                    $this->ValidationErrors[$rowindex] = $this->getValidationErrors();
                    $this->EventCancelled = true;
                    return false;
                }
            }
        }
        return true;
    }

    // Get all form values of the grid
    public function getGridFormValues()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }
        $rows = [];

        // Loop through all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } else {
                    $rows[] = $this->getFieldValues("FormValue"); // Return row as array
                }
            }
        }
        return $rows; // Return as array of array
    }

    // Restore form values for current row
    public function restoreCurrentRowFormValues($idx)
    {
        global $CurrentForm;

        // Get row based on current index
        $CurrentForm->Index = $idx;
        $rowaction = strval($CurrentForm->getValue($this->FormActionName));
        $this->loadFormValues(); // Load form values
        // Set up invalid status correctly
        $this->resetFormError();
        if ($rowaction == "insert" && $this->emptyRow()) {
            // Ignore
        } else {
            $this->validateForm();
        }
    }

    // Reset form status
    public function resetFormError()
    {
        foreach ($this->Fields as $field) {
            $field->clearErrorMessage();
        }
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset master/detail keys
            if ($this->Command == "resetall") {
                $this->setCurrentMasterTable(""); // Clear master table
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
                        $this->ref->setSessionValue("");
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // "griddelete"
        if ($this->AllowAddDeleteRow) {
            $item = &$this->ListOptions->add("griddelete");
            $item->CssClass = "text-nowrap";
            $item->OnLeft = true;
            $item->Visible = false; // Default hidden
        }

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // Set up row action and key
        if ($CurrentForm && is_numeric($this->RowIndex) && $this->RowType != "view") {
            $CurrentForm->Index = $this->RowIndex;
            $actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
            $oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->OldKeyName);
            $blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
            if ($this->RowAction != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
            }
            $oldKey = $this->getKey(false); // Get from OldValue
            if ($oldKeyName != "" && $oldKey != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($oldKey) . "\">";
            }
            if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow()) {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
            }
        }

        // "delete"
        if ($this->AllowAddDeleteRow) {
            if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
                $options = &$this->ListOptions;
                $options->UseButtonGroup = true; // Use button group for grid delete button
                $opt = $options["griddelete"];
                if (!$Security->allowDelete(CurrentProjectID() . $this->TableName) && is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
                    $opt->Body = "&nbsp;";
                } else {
                    $opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-ew-action=\"delete-grid-row\" data-rowindex=\"" . $this->RowIndex . "\">" . $Language->phrase("DeleteLink") . "</a>";
                }
            }
        }
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"booking_confirm\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"booking_confirm\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"booking_confirm\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $option = $this->OtherOptions["addedit"];
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Add
        if ($this->CurrentMode == "view") { // Check view mode
            $item = &$option->add("add");
            $addcaption = HtmlTitle($Language->phrase("AddLink"));
            $this->AddUrl = $this->getAddUrl();
            if ($this->ModalAdd && !IsMobile()) {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"booking_confirm\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
            } else {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
            }
            $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        }
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
            if (in_array($this->CurrentMode, ["add", "copy", "edit"]) && !$this->isConfirm()) { // Check add/copy/edit mode
                if ($this->AllowAddDeleteRow) {
                    $option = $options["addedit"];
                    $option->UseDropDownButton = false;
                    $item = &$option->add("addblankrow");
                    $item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-ew-action=\"add-grid-row\">" . $Language->phrase("AddBlankRow") . "</a>";
                    $item->Visible = $Security->canAdd();
                    $this->ShowOtherOptions = $item->Visible;
                }
            }
            if ($this->CurrentMode == "view") { // Check view mode
                $option = $options["addedit"];
                $item = $option["add"];
                $this->ShowOtherOptions = $item?->Visible ?? false;
            }
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        $this->StartRecord = 1;
        $this->StopRecord = $this->TotalRecords; // Show all records

        // Restore number of post back records
        if ($CurrentForm && ($this->isConfirm() || $this->EventCancelled)) {
            $CurrentForm->resetIndex();
            if ($CurrentForm->hasValue($this->FormKeyCountName) && ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm())) {
                $this->KeyCount = $CurrentForm->getValue($this->FormKeyCountName);
                $this->StopRecord = $this->StartRecord + $this->KeyCount - 1;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_booking_confirm", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }
        if ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm() || $this->isMultiEdit()) {
            $this->RowIndex++;
            $CurrentForm->Index = $this->RowIndex;
            if ($CurrentForm->hasValue($this->FormActionName) && ($this->isConfirm() || $this->EventCancelled)) {
                $this->RowAction = strval($CurrentForm->getValue($this->FormActionName));
            } elseif ($this->isGridAdd()) {
                $this->RowAction = "insert";
            } else {
                $this->RowAction = "";
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->loadRowValues($this->CurrentRow); // Load row values
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
            } else {
                $this->loadRowValues(); // Load default values
                $this->OldKey = "";
            }
        } else {
            $this->loadRowValues($this->CurrentRow); // Load row values
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
        }
        $this->setKey($this->OldKey);
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }
        if ($this->isGridAdd() && $this->EventCancelled && !$CurrentForm->hasValue($this->FormBlankRowName)) { // Insert failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isGridEdit()) { // Grid edit
            if ($this->EventCancelled) {
                $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
            }
            if ($this->RowAction == "insert") {
                $this->RowType = RowType::ADD; // Render add
            } else {
                $this->RowType = RowType::EDIT; // Render edit
            }
        }
        if ($this->isGridEdit() && ($this->RowType == RowType::EDIT || $this->RowType == RowType::ADD) && $this->EventCancelled) { // Update failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isConfirm()) { // Confirm row
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_booking_confirm",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->confirm_type->DefaultValue = $this->confirm_type->getDefault(); // PHP
        $this->confirm_type->OldValue = $this->confirm_type->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $CurrentForm->FormName = $this->FormName;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd()) {
            $this->id->setFormValue($val);
        }

        // Check field name 'supplier' first before field var 'x_supplier'
        $val = $CurrentForm->hasValue("supplier") ? $CurrentForm->getValue("supplier") : $CurrentForm->getValue("x_supplier");
        if (!$this->supplier->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->supplier->Visible = false; // Disable update for API request
            } else {
                $this->supplier->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_supplier")) {
            $this->supplier->setOldValue($CurrentForm->getValue("o_supplier"));
        }

        // Check field name 'confirm_type' first before field var 'x_confirm_type'
        $val = $CurrentForm->hasValue("confirm_type") ? $CurrentForm->getValue("confirm_type") : $CurrentForm->getValue("x_confirm_type");
        if (!$this->confirm_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->confirm_type->Visible = false; // Disable update for API request
            } else {
                $this->confirm_type->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_confirm_type")) {
            $this->confirm_type->setOldValue($CurrentForm->getValue("o_confirm_type"));
        }

        // Check field name 'booking_ref' first before field var 'x_booking_ref'
        $val = $CurrentForm->hasValue("booking_ref") ? $CurrentForm->getValue("booking_ref") : $CurrentForm->getValue("x_booking_ref");
        if (!$this->booking_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->booking_ref->Visible = false; // Disable update for API request
            } else {
                $this->booking_ref->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_booking_ref")) {
            $this->booking_ref->setOldValue($CurrentForm->getValue("o_booking_ref"));
        }

        // Check field name 'approx_qty' first before field var 'x_approx_qty'
        $val = $CurrentForm->hasValue("approx_qty") ? $CurrentForm->getValue("approx_qty") : $CurrentForm->getValue("x_approx_qty");
        if (!$this->approx_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->approx_qty->Visible = false; // Disable update for API request
            } else {
                $this->approx_qty->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_approx_qty")) {
            $this->approx_qty->setOldValue($CurrentForm->getValue("o_approx_qty"));
        }

        // Check field name 'packets' first before field var 'x_packets'
        $val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
        if (!$this->packets->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packets->Visible = false; // Disable update for API request
            } else {
                $this->packets->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_packets")) {
            $this->packets->setOldValue($CurrentForm->getValue("o_packets"));
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_amount")) {
            $this->amount->setOldValue($CurrentForm->getValue("o_amount"));
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_currency")) {
            $this->currency->setOldValue($CurrentForm->getValue("o_currency"));
        }

        // Check field name 'date' first before field var 'x_date'
        $val = $CurrentForm->hasValue("date") ? $CurrentForm->getValue("date") : $CurrentForm->getValue("x_date");
        if (!$this->date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->date->Visible = false; // Disable update for API request
            } else {
                $this->date->setFormValue($val, true, $validate);
            }
            $this->date->CurrentValue = UnFormatDateTime($this->date->CurrentValue, $this->date->formatPattern());
        }
        if ($CurrentForm->hasValue("o_date")) {
            $this->date->setOldValue($CurrentForm->getValue("o_date"));
        }

        // Check field name 'reference' first before field var 'x_reference'
        $val = $CurrentForm->hasValue("reference") ? $CurrentForm->getValue("reference") : $CurrentForm->getValue("x_reference");
        if (!$this->reference->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reference->Visible = false; // Disable update for API request
            } else {
                $this->reference->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_reference")) {
            $this->reference->setOldValue($CurrentForm->getValue("o_reference"));
        }

        // Check field name 'date_of_dispatch' first before field var 'x_date_of_dispatch'
        $val = $CurrentForm->hasValue("date_of_dispatch") ? $CurrentForm->getValue("date_of_dispatch") : $CurrentForm->getValue("x_date_of_dispatch");
        if (!$this->date_of_dispatch->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->date_of_dispatch->Visible = false; // Disable update for API request
            } else {
                $this->date_of_dispatch->setFormValue($val, true, $validate);
            }
            $this->date_of_dispatch->CurrentValue = UnFormatDateTime($this->date_of_dispatch->CurrentValue, $this->date_of_dispatch->formatPattern());
        }
        if ($CurrentForm->hasValue("o_date_of_dispatch")) {
            $this->date_of_dispatch->setOldValue($CurrentForm->getValue("o_date_of_dispatch"));
        }

        // Check field name 'port_eta' first before field var 'x_port_eta'
        $val = $CurrentForm->hasValue("port_eta") ? $CurrentForm->getValue("port_eta") : $CurrentForm->getValue("x_port_eta");
        if (!$this->port_eta->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->port_eta->Visible = false; // Disable update for API request
            } else {
                $this->port_eta->setFormValue($val, true, $validate);
            }
            $this->port_eta->CurrentValue = UnFormatDateTime($this->port_eta->CurrentValue, $this->port_eta->formatPattern());
        }
        if ($CurrentForm->hasValue("o_port_eta")) {
            $this->port_eta->setOldValue($CurrentForm->getValue("o_port_eta"));
        }

        // Check field name 'bl_no' first before field var 'x_bl_no'
        $val = $CurrentForm->hasValue("bl_no") ? $CurrentForm->getValue("bl_no") : $CurrentForm->getValue("x_bl_no");
        if (!$this->bl_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bl_no->Visible = false; // Disable update for API request
            } else {
                $this->bl_no->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_bl_no")) {
            $this->bl_no->setOldValue($CurrentForm->getValue("o_bl_no"));
        }

        // Check field name 's_line' first before field var 'x_s_line'
        $val = $CurrentForm->hasValue("s_line") ? $CurrentForm->getValue("s_line") : $CurrentForm->getValue("x_s_line");
        if (!$this->s_line->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_line->Visible = false; // Disable update for API request
            } else {
                $this->s_line->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_s_line")) {
            $this->s_line->setOldValue($CurrentForm->getValue("o_s_line"));
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_company_id")) {
            $this->company_id->setOldValue($CurrentForm->getValue("o_company_id"));
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_operator")) {
            $this->operator->setOldValue($CurrentForm->getValue("o_operator"));
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
        if ($CurrentForm->hasValue("o_datetime")) {
            $this->datetime->setOldValue($CurrentForm->getValue("o_datetime"));
        }

        // Check field name 'ref' first before field var 'x_ref'
        $val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
        if (!$this->ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ref->Visible = false; // Disable update for API request
            } else {
                $this->ref->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_ref")) {
            $this->ref->setOldValue($CurrentForm->getValue("o_ref"));
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        if (!$this->isGridAdd() && !$this->isAdd()) {
            $this->id->CurrentValue = $this->id->FormValue;
        }
        $this->supplier->CurrentValue = $this->supplier->FormValue;
        $this->confirm_type->CurrentValue = $this->confirm_type->FormValue;
        $this->booking_ref->CurrentValue = $this->booking_ref->FormValue;
        $this->approx_qty->CurrentValue = $this->approx_qty->FormValue;
        $this->packets->CurrentValue = $this->packets->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->date->CurrentValue = $this->date->FormValue;
        $this->date->CurrentValue = UnFormatDateTime($this->date->CurrentValue, $this->date->formatPattern());
        $this->reference->CurrentValue = $this->reference->FormValue;
        $this->date_of_dispatch->CurrentValue = $this->date_of_dispatch->FormValue;
        $this->date_of_dispatch->CurrentValue = UnFormatDateTime($this->date_of_dispatch->CurrentValue, $this->date_of_dispatch->formatPattern());
        $this->port_eta->CurrentValue = $this->port_eta->FormValue;
        $this->port_eta->CurrentValue = UnFormatDateTime($this->port_eta->CurrentValue, $this->port_eta->formatPattern());
        $this->bl_no->CurrentValue = $this->bl_no->FormValue;
        $this->s_line->CurrentValue = $this->s_line->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->ref->CurrentValue = $this->ref->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->supplier->setDbValue($row['supplier']);
        $this->confirm_type->setDbValue($row['confirm_type']);
        $this->booking_ref->setDbValue($row['booking_ref']);
        $this->approx_qty->setDbValue($row['approx_qty']);
        $this->packets->setDbValue($row['packets']);
        $this->amount->setDbValue($row['amount']);
        $this->currency->setDbValue($row['currency']);
        $this->date->setDbValue($row['date']);
        $this->reference->setDbValue($row['reference']);
        $this->date_of_dispatch->setDbValue($row['date_of_dispatch']);
        $this->port_eta->setDbValue($row['port_eta']);
        $this->bl_no->setDbValue($row['bl_no']);
        $this->s_line->setDbValue($row['s_line']);
        $this->company_id->setDbValue($row['company_id']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->fibc->setDbValue($row['fibc']);
        $this->ref->setDbValue($row['ref']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['supplier'] = $this->supplier->DefaultValue;
        $row['confirm_type'] = $this->confirm_type->DefaultValue;
        $row['booking_ref'] = $this->booking_ref->DefaultValue;
        $row['approx_qty'] = $this->approx_qty->DefaultValue;
        $row['packets'] = $this->packets->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['date'] = $this->date->DefaultValue;
        $row['reference'] = $this->reference->DefaultValue;
        $row['date_of_dispatch'] = $this->date_of_dispatch->DefaultValue;
        $row['port_eta'] = $this->port_eta->DefaultValue;
        $row['bl_no'] = $this->bl_no->DefaultValue;
        $row['s_line'] = $this->s_line->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['fibc'] = $this->fibc->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // supplier

        // confirm_type

        // booking_ref

        // approx_qty

        // packets

        // amount

        // currency

        // date

        // reference

        // date_of_dispatch

        // port_eta

        // bl_no

        // s_line

        // company_id

        // operator

        // datetime

        // fibc
        $this->fibc->CellCssStyle = "white-space: nowrap;";

        // ref

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // supplier
            $curVal = strval($this->supplier->CurrentValue);
            if ($curVal != "") {
                $this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
                if ($this->supplier->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                    $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                        $this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
                    } else {
                        $this->supplier->ViewValue = $this->supplier->CurrentValue;
                    }
                }
            } else {
                $this->supplier->ViewValue = null;
            }

            // confirm_type
            if (strval($this->confirm_type->CurrentValue) != "") {
                $this->confirm_type->ViewValue = $this->confirm_type->optionCaption($this->confirm_type->CurrentValue);
            } else {
                $this->confirm_type->ViewValue = null;
            }

            // booking_ref
            $curVal = strval($this->booking_ref->CurrentValue);
            if ($curVal != "") {
                $this->booking_ref->ViewValue = $this->booking_ref->lookupCacheOption($curVal);
                if ($this->booking_ref->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->booking_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->booking_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->booking_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->booking_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->booking_ref->ViewValue = $this->booking_ref->displayValue($arwrk);
                    } else {
                        $this->booking_ref->ViewValue = $this->booking_ref->CurrentValue;
                    }
                }
            } else {
                $this->booking_ref->ViewValue = null;
            }

            // approx_qty
            $this->approx_qty->ViewValue = $this->approx_qty->CurrentValue;
            $this->approx_qty->ViewValue = FormatNumber($this->approx_qty->ViewValue, $this->approx_qty->formatPattern());

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // currency
            $this->currency->ViewValue = $this->currency->CurrentValue;
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // date
            $this->date->ViewValue = $this->date->CurrentValue;
            $this->date->ViewValue = FormatDateTime($this->date->ViewValue, $this->date->formatPattern());

            // reference
            $this->reference->ViewValue = $this->reference->CurrentValue;

            // date_of_dispatch
            $this->date_of_dispatch->ViewValue = $this->date_of_dispatch->CurrentValue;
            $this->date_of_dispatch->ViewValue = FormatDateTime($this->date_of_dispatch->ViewValue, $this->date_of_dispatch->formatPattern());

            // port_eta
            $this->port_eta->ViewValue = $this->port_eta->CurrentValue;
            $this->port_eta->ViewValue = FormatDateTime($this->port_eta->ViewValue, $this->port_eta->formatPattern());

            // bl_no
            $this->bl_no->ViewValue = $this->bl_no->CurrentValue;

            // s_line
            $curVal = strval($this->s_line->CurrentValue);
            if ($curVal != "") {
                $this->s_line->ViewValue = $this->s_line->lookupCacheOption($curVal);
                if ($this->s_line->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_line->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_line->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_line->Lookup->renderViewRow($rswrk[0]);
                        $this->s_line->ViewValue = $this->s_line->displayValue($arwrk);
                    } else {
                        $this->s_line->ViewValue = FormatNumber($this->s_line->CurrentValue, $this->s_line->formatPattern());
                    }
                }
            } else {
                $this->s_line->ViewValue = null;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }
            $this->supplier->TooltipValue = "";

            // confirm_type
            $this->confirm_type->HrefValue = "";
            $this->confirm_type->TooltipValue = "";

            // booking_ref
            $this->booking_ref->HrefValue = "";
            $this->booking_ref->TooltipValue = "";

            // approx_qty
            $this->approx_qty->HrefValue = "";
            $this->approx_qty->TooltipValue = "";

            // packets
            $this->packets->HrefValue = "";
            $this->packets->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // currency
            $this->currency->HrefValue = "";
            $this->currency->TooltipValue = "";

            // date
            $this->date->HrefValue = "";
            $this->date->TooltipValue = "";
            if (!$this->isExport()) {
                $this->date->ViewValue = $this->highlightValue($this->date);
            }

            // reference
            $this->reference->HrefValue = "";
            $this->reference->TooltipValue = "";
            if (!$this->isExport()) {
                $this->reference->ViewValue = $this->highlightValue($this->reference);
            }

            // date_of_dispatch
            $this->date_of_dispatch->HrefValue = "";
            $this->date_of_dispatch->TooltipValue = "";
            if (!$this->isExport()) {
                $this->date_of_dispatch->ViewValue = $this->highlightValue($this->date_of_dispatch);
            }

            // port_eta
            $this->port_eta->HrefValue = "";
            $this->port_eta->TooltipValue = "";
            if (!$this->isExport()) {
                $this->port_eta->ViewValue = $this->highlightValue($this->port_eta);
            }

            // bl_no
            $this->bl_no->HrefValue = "";
            $this->bl_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->bl_no->ViewValue = $this->highlightValue($this->bl_no);
            }

            // s_line
            $this->s_line->HrefValue = "";
            $this->s_line->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
            if (!$this->isExport()) {
                $this->datetime->ViewValue = $this->highlightValue($this->datetime);
            }

            // ref
            $this->ref->HrefValue = "";
            $this->ref->TooltipValue = "";
            if (!$this->isExport()) {
                $this->ref->ViewValue = $this->highlightValue($this->ref);
            }
        } elseif ($this->RowType == RowType::ADD) {
            // id

            // supplier
            $this->supplier->setupEditAttributes();
            $curVal = trim(strval($this->supplier->CurrentValue));
            if ($curVal != "") {
                $this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
            } else {
                $this->supplier->ViewValue = $this->supplier->Lookup !== null && is_array($this->supplier->lookupOptions()) && count($this->supplier->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->supplier->ViewValue !== null) { // Load from cache
                $this->supplier->EditValue = array_values($this->supplier->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->supplier->CurrentValue, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                $sqlWrk = $this->supplier->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->supplier->EditValue = $arwrk;
            }
            $this->supplier->PlaceHolder = RemoveHtml($this->supplier->caption());

            // confirm_type
            $this->confirm_type->setupEditAttributes();
            $this->confirm_type->EditValue = $this->confirm_type->options(true);
            $this->confirm_type->PlaceHolder = RemoveHtml($this->confirm_type->caption());

            // booking_ref
            $this->booking_ref->setupEditAttributes();
            $curVal = trim(strval($this->booking_ref->CurrentValue));
            if ($curVal != "") {
                $this->booking_ref->ViewValue = $this->booking_ref->lookupCacheOption($curVal);
            } else {
                $this->booking_ref->ViewValue = $this->booking_ref->Lookup !== null && is_array($this->booking_ref->lookupOptions()) && count($this->booking_ref->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->booking_ref->ViewValue !== null) { // Load from cache
                $this->booking_ref->EditValue = array_values($this->booking_ref->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->booking_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->booking_ref->CurrentValue, $this->booking_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->booking_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->booking_ref->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->booking_ref->Lookup->renderViewRow($row);
                }
                $this->booking_ref->EditValue = $arwrk;
            }
            $this->booking_ref->PlaceHolder = RemoveHtml($this->booking_ref->caption());

            // approx_qty
            $this->approx_qty->setupEditAttributes();
            $this->approx_qty->EditValue = $this->approx_qty->CurrentValue;
            $this->approx_qty->PlaceHolder = RemoveHtml($this->approx_qty->caption());
            if (strval($this->approx_qty->EditValue) != "" && is_numeric($this->approx_qty->EditValue)) {
                $this->approx_qty->EditValue = FormatNumber($this->approx_qty->EditValue, null);
            }

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->CurrentValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
            if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
                $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
            }

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
                $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
            }

            // currency
            $this->currency->setupEditAttributes();
            $this->currency->EditValue = $this->currency->CurrentValue;
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->EditValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->EditValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->EditValue = HtmlEncode(FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern()));
                    }
                }
            } else {
                $this->currency->EditValue = null;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // date
            $this->date->setupEditAttributes();
            $this->date->EditValue = HtmlEncode(FormatDateTime($this->date->CurrentValue, $this->date->formatPattern()));
            $this->date->PlaceHolder = RemoveHtml($this->date->caption());

            // reference
            $this->reference->setupEditAttributes();
            $this->reference->EditValue = HtmlEncode($this->reference->CurrentValue);
            $this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

            // date_of_dispatch
            $this->date_of_dispatch->setupEditAttributes();
            $this->date_of_dispatch->EditValue = HtmlEncode(FormatDateTime($this->date_of_dispatch->CurrentValue, $this->date_of_dispatch->formatPattern()));
            $this->date_of_dispatch->PlaceHolder = RemoveHtml($this->date_of_dispatch->caption());

            // port_eta
            $this->port_eta->setupEditAttributes();
            $this->port_eta->EditValue = HtmlEncode(FormatDateTime($this->port_eta->CurrentValue, $this->port_eta->formatPattern()));
            $this->port_eta->PlaceHolder = RemoveHtml($this->port_eta->caption());

            // bl_no
            $this->bl_no->setupEditAttributes();
            if (!$this->bl_no->Raw) {
                $this->bl_no->CurrentValue = HtmlDecode($this->bl_no->CurrentValue);
            }
            $this->bl_no->EditValue = HtmlEncode($this->bl_no->CurrentValue);
            $this->bl_no->PlaceHolder = RemoveHtml($this->bl_no->caption());

            // s_line
            $this->s_line->setupEditAttributes();
            $curVal = trim(strval($this->s_line->CurrentValue));
            if ($curVal != "") {
                $this->s_line->ViewValue = $this->s_line->lookupCacheOption($curVal);
            } else {
                $this->s_line->ViewValue = $this->s_line->Lookup !== null && is_array($this->s_line->lookupOptions()) && count($this->s_line->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_line->ViewValue !== null) { // Load from cache
                $this->s_line->EditValue = array_values($this->s_line->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_line->CurrentValue, $this->s_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_line->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_line->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_line->EditValue = $arwrk;
            }
            $this->s_line->PlaceHolder = RemoveHtml($this->s_line->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = HtmlEncode(FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern()));
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // operator

            // datetime

            // ref
            $this->ref->setupEditAttributes();
            if ($this->ref->getSessionValue() != "") {
                $this->ref->CurrentValue = GetForeignKeyValue($this->ref->getSessionValue());
                $this->ref->OldValue = $this->ref->CurrentValue;
                $this->ref->ViewValue = $this->ref->CurrentValue;
            } else {
                if (!$this->ref->Raw) {
                    $this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
                }
                $this->ref->EditValue = HtmlEncode($this->ref->CurrentValue);
                $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());
            }

            // Add refer script

            // id
            $this->id->HrefValue = "";

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }

            // confirm_type
            $this->confirm_type->HrefValue = "";

            // booking_ref
            $this->booking_ref->HrefValue = "";

            // approx_qty
            $this->approx_qty->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // date
            $this->date->HrefValue = "";

            // reference
            $this->reference->HrefValue = "";

            // date_of_dispatch
            $this->date_of_dispatch->HrefValue = "";

            // port_eta
            $this->port_eta->HrefValue = "";

            // bl_no
            $this->bl_no->HrefValue = "";

            // s_line
            $this->s_line->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // ref
            $this->ref->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // supplier
            $this->supplier->setupEditAttributes();
            $curVal = strval($this->supplier->CurrentValue);
            if ($curVal != "") {
                $this->supplier->EditValue = $this->supplier->lookupCacheOption($curVal);
                if ($this->supplier->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                    $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                        $this->supplier->EditValue = $this->supplier->displayValue($arwrk);
                    } else {
                        $this->supplier->EditValue = $this->supplier->CurrentValue;
                    }
                }
            } else {
                $this->supplier->EditValue = null;
            }

            // confirm_type
            $this->confirm_type->setupEditAttributes();
            $this->confirm_type->EditValue = $this->confirm_type->options(true);
            $this->confirm_type->PlaceHolder = RemoveHtml($this->confirm_type->caption());

            // booking_ref
            $this->booking_ref->setupEditAttributes();
            $curVal = strval($this->booking_ref->CurrentValue);
            if ($curVal != "") {
                $this->booking_ref->EditValue = $this->booking_ref->lookupCacheOption($curVal);
                if ($this->booking_ref->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->booking_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->booking_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->booking_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->booking_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->booking_ref->EditValue = $this->booking_ref->displayValue($arwrk);
                    } else {
                        $this->booking_ref->EditValue = $this->booking_ref->CurrentValue;
                    }
                }
            } else {
                $this->booking_ref->EditValue = null;
            }

            // approx_qty
            $this->approx_qty->setupEditAttributes();
            $this->approx_qty->EditValue = $this->approx_qty->CurrentValue;
            $this->approx_qty->PlaceHolder = RemoveHtml($this->approx_qty->caption());
            if (strval($this->approx_qty->EditValue) != "" && is_numeric($this->approx_qty->EditValue)) {
                $this->approx_qty->EditValue = FormatNumber($this->approx_qty->EditValue, null);
            }

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->CurrentValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
            if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
                $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
            }

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
                $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
            }

            // currency
            $this->currency->setupEditAttributes();
            $this->currency->EditValue = $this->currency->CurrentValue;
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->EditValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->EditValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->EditValue = HtmlEncode(FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern()));
                    }
                }
            } else {
                $this->currency->EditValue = null;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // date
            $this->date->setupEditAttributes();
            $this->date->EditValue = HtmlEncode(FormatDateTime($this->date->CurrentValue, $this->date->formatPattern()));
            $this->date->PlaceHolder = RemoveHtml($this->date->caption());

            // reference
            $this->reference->setupEditAttributes();
            $this->reference->EditValue = HtmlEncode($this->reference->CurrentValue);
            $this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

            // date_of_dispatch
            $this->date_of_dispatch->setupEditAttributes();
            $this->date_of_dispatch->EditValue = HtmlEncode(FormatDateTime($this->date_of_dispatch->CurrentValue, $this->date_of_dispatch->formatPattern()));
            $this->date_of_dispatch->PlaceHolder = RemoveHtml($this->date_of_dispatch->caption());

            // port_eta
            $this->port_eta->setupEditAttributes();
            $this->port_eta->EditValue = HtmlEncode(FormatDateTime($this->port_eta->CurrentValue, $this->port_eta->formatPattern()));
            $this->port_eta->PlaceHolder = RemoveHtml($this->port_eta->caption());

            // bl_no
            $this->bl_no->setupEditAttributes();
            if (!$this->bl_no->Raw) {
                $this->bl_no->CurrentValue = HtmlDecode($this->bl_no->CurrentValue);
            }
            $this->bl_no->EditValue = HtmlEncode($this->bl_no->CurrentValue);
            $this->bl_no->PlaceHolder = RemoveHtml($this->bl_no->caption());

            // s_line
            $this->s_line->setupEditAttributes();
            $curVal = trim(strval($this->s_line->CurrentValue));
            if ($curVal != "") {
                $this->s_line->ViewValue = $this->s_line->lookupCacheOption($curVal);
            } else {
                $this->s_line->ViewValue = $this->s_line->Lookup !== null && is_array($this->s_line->lookupOptions()) && count($this->s_line->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_line->ViewValue !== null) { // Load from cache
                $this->s_line->EditValue = array_values($this->s_line->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_line->CurrentValue, $this->s_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_line->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_line->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_line->EditValue = $arwrk;
            }
            $this->s_line->PlaceHolder = RemoveHtml($this->s_line->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = HtmlEncode(FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern()));
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // operator

            // datetime

            // ref
            $this->ref->setupEditAttributes();
            if ($this->ref->getSessionValue() != "") {
                $this->ref->CurrentValue = GetForeignKeyValue($this->ref->getSessionValue());
                $this->ref->OldValue = $this->ref->CurrentValue;
                $this->ref->ViewValue = $this->ref->CurrentValue;
            } else {
                if (!$this->ref->Raw) {
                    $this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
                }
                $this->ref->EditValue = HtmlEncode($this->ref->CurrentValue);
                $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());
            }

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }
            $this->supplier->TooltipValue = "";

            // confirm_type
            $this->confirm_type->HrefValue = "";

            // booking_ref
            $this->booking_ref->HrefValue = "";
            $this->booking_ref->TooltipValue = "";

            // approx_qty
            $this->approx_qty->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // date
            $this->date->HrefValue = "";

            // reference
            $this->reference->HrefValue = "";

            // date_of_dispatch
            $this->date_of_dispatch->HrefValue = "";

            // port_eta
            $this->port_eta->HrefValue = "";

            // bl_no
            $this->bl_no->HrefValue = "";

            // s_line
            $this->s_line->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // ref
            $this->ref->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->supplier->Visible && $this->supplier->Required) {
                if (!$this->supplier->IsDetailKey && EmptyValue($this->supplier->FormValue)) {
                    $this->supplier->addErrorMessage(str_replace("%s", $this->supplier->caption(), $this->supplier->RequiredErrorMessage));
                }
            }
            if ($this->confirm_type->Visible && $this->confirm_type->Required) {
                if (!$this->confirm_type->IsDetailKey && EmptyValue($this->confirm_type->FormValue)) {
                    $this->confirm_type->addErrorMessage(str_replace("%s", $this->confirm_type->caption(), $this->confirm_type->RequiredErrorMessage));
                }
            }
            if ($this->booking_ref->Visible && $this->booking_ref->Required) {
                if (!$this->booking_ref->IsDetailKey && EmptyValue($this->booking_ref->FormValue)) {
                    $this->booking_ref->addErrorMessage(str_replace("%s", $this->booking_ref->caption(), $this->booking_ref->RequiredErrorMessage));
                }
            }
            if ($this->approx_qty->Visible && $this->approx_qty->Required) {
                if (!$this->approx_qty->IsDetailKey && EmptyValue($this->approx_qty->FormValue)) {
                    $this->approx_qty->addErrorMessage(str_replace("%s", $this->approx_qty->caption(), $this->approx_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->approx_qty->FormValue)) {
                $this->approx_qty->addErrorMessage($this->approx_qty->getErrorMessage(false));
            }
            if ($this->packets->Visible && $this->packets->Required) {
                if (!$this->packets->IsDetailKey && EmptyValue($this->packets->FormValue)) {
                    $this->packets->addErrorMessage(str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->packets->FormValue)) {
                $this->packets->addErrorMessage($this->packets->getErrorMessage(false));
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->amount->FormValue)) {
                $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->currency->FormValue)) {
                $this->currency->addErrorMessage($this->currency->getErrorMessage(false));
            }
            if ($this->date->Visible && $this->date->Required) {
                if (!$this->date->IsDetailKey && EmptyValue($this->date->FormValue)) {
                    $this->date->addErrorMessage(str_replace("%s", $this->date->caption(), $this->date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->date->FormValue, $this->date->formatPattern())) {
                $this->date->addErrorMessage($this->date->getErrorMessage(false));
            }
            if ($this->reference->Visible && $this->reference->Required) {
                if (!$this->reference->IsDetailKey && EmptyValue($this->reference->FormValue)) {
                    $this->reference->addErrorMessage(str_replace("%s", $this->reference->caption(), $this->reference->RequiredErrorMessage));
                }
            }
            if ($this->date_of_dispatch->Visible && $this->date_of_dispatch->Required) {
                if (!$this->date_of_dispatch->IsDetailKey && EmptyValue($this->date_of_dispatch->FormValue)) {
                    $this->date_of_dispatch->addErrorMessage(str_replace("%s", $this->date_of_dispatch->caption(), $this->date_of_dispatch->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->date_of_dispatch->FormValue, $this->date_of_dispatch->formatPattern())) {
                $this->date_of_dispatch->addErrorMessage($this->date_of_dispatch->getErrorMessage(false));
            }
            if ($this->port_eta->Visible && $this->port_eta->Required) {
                if (!$this->port_eta->IsDetailKey && EmptyValue($this->port_eta->FormValue)) {
                    $this->port_eta->addErrorMessage(str_replace("%s", $this->port_eta->caption(), $this->port_eta->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->port_eta->FormValue, $this->port_eta->formatPattern())) {
                $this->port_eta->addErrorMessage($this->port_eta->getErrorMessage(false));
            }
            if ($this->bl_no->Visible && $this->bl_no->Required) {
                if (!$this->bl_no->IsDetailKey && EmptyValue($this->bl_no->FormValue)) {
                    $this->bl_no->addErrorMessage(str_replace("%s", $this->bl_no->caption(), $this->bl_no->RequiredErrorMessage));
                }
            }
            if ($this->s_line->Visible && $this->s_line->Required) {
                if (!$this->s_line->IsDetailKey && EmptyValue($this->s_line->FormValue)) {
                    $this->s_line->addErrorMessage(str_replace("%s", $this->s_line->caption(), $this->s_line->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->company_id->FormValue)) {
                $this->company_id->addErrorMessage($this->company_id->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->ref->Visible && $this->ref->Required) {
                if (!$this->ref->IsDetailKey && EmptyValue($this->ref->FormValue)) {
                    $this->ref->addErrorMessage(str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        return $deleteRows;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // confirm_type
        $this->confirm_type->setDbValueDef($rsnew, $this->confirm_type->CurrentValue, $this->confirm_type->ReadOnly);

        // approx_qty
        $this->approx_qty->setDbValueDef($rsnew, $this->approx_qty->CurrentValue, $this->approx_qty->ReadOnly);

        // packets
        $this->packets->setDbValueDef($rsnew, $this->packets->CurrentValue, $this->packets->ReadOnly);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, $this->amount->ReadOnly);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, $this->currency->ReadOnly);

        // date
        $this->date->setDbValueDef($rsnew, UnFormatDateTime($this->date->CurrentValue, $this->date->formatPattern()), $this->date->ReadOnly);

        // reference
        $this->reference->setDbValueDef($rsnew, $this->reference->CurrentValue, $this->reference->ReadOnly);

        // date_of_dispatch
        $this->date_of_dispatch->setDbValueDef($rsnew, UnFormatDateTime($this->date_of_dispatch->CurrentValue, $this->date_of_dispatch->formatPattern()), $this->date_of_dispatch->ReadOnly);

        // port_eta
        $this->port_eta->setDbValueDef($rsnew, UnFormatDateTime($this->port_eta->CurrentValue, $this->port_eta->formatPattern()), $this->port_eta->ReadOnly);

        // bl_no
        $this->bl_no->setDbValueDef($rsnew, $this->bl_no->CurrentValue, $this->bl_no->ReadOnly);

        // s_line
        $this->s_line->setDbValueDef($rsnew, $this->s_line->CurrentValue, $this->s_line->ReadOnly);

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, $this->company_id->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // ref
        if ($this->ref->getSessionValue() != "") {
            $this->ref->ReadOnly = true;
        }
        $this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, $this->ref->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['confirm_type'])) { // confirm_type
            $this->confirm_type->CurrentValue = $row['confirm_type'];
        }
        if (isset($row['approx_qty'])) { // approx_qty
            $this->approx_qty->CurrentValue = $row['approx_qty'];
        }
        if (isset($row['packets'])) { // packets
            $this->packets->CurrentValue = $row['packets'];
        }
        if (isset($row['amount'])) { // amount
            $this->amount->CurrentValue = $row['amount'];
        }
        if (isset($row['currency'])) { // currency
            $this->currency->CurrentValue = $row['currency'];
        }
        if (isset($row['date'])) { // date
            $this->date->CurrentValue = $row['date'];
        }
        if (isset($row['reference'])) { // reference
            $this->reference->CurrentValue = $row['reference'];
        }
        if (isset($row['date_of_dispatch'])) { // date_of_dispatch
            $this->date_of_dispatch->CurrentValue = $row['date_of_dispatch'];
        }
        if (isset($row['port_eta'])) { // port_eta
            $this->port_eta->CurrentValue = $row['port_eta'];
        }
        if (isset($row['bl_no'])) { // bl_no
            $this->bl_no->CurrentValue = $row['bl_no'];
        }
        if (isset($row['s_line'])) { // s_line
            $this->s_line->CurrentValue = $row['s_line'];
        }
        if (isset($row['company_id'])) { // company_id
            $this->company_id->CurrentValue = $row['company_id'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['ref'])) { // ref
            $this->ref->CurrentValue = $row['ref'];
        }
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set up foreign key field value from Session
        if ($this->getCurrentMasterTable() == "booking_details") {
            $this->ref->Visible = true; // Need to insert foreign key
            $this->ref->CurrentValue = $this->ref->getSessionValue();
        }

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // supplier
        $this->supplier->setDbValueDef($rsnew, $this->supplier->CurrentValue, false);

        // confirm_type
        $this->confirm_type->setDbValueDef($rsnew, $this->confirm_type->CurrentValue, strval($this->confirm_type->CurrentValue) == "");

        // booking_ref
        $this->booking_ref->setDbValueDef($rsnew, $this->booking_ref->CurrentValue, false);

        // approx_qty
        $this->approx_qty->setDbValueDef($rsnew, $this->approx_qty->CurrentValue, false);

        // packets
        $this->packets->setDbValueDef($rsnew, $this->packets->CurrentValue, false);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, false);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, false);

        // date
        $this->date->setDbValueDef($rsnew, UnFormatDateTime($this->date->CurrentValue, $this->date->formatPattern()), false);

        // reference
        $this->reference->setDbValueDef($rsnew, $this->reference->CurrentValue, false);

        // date_of_dispatch
        $this->date_of_dispatch->setDbValueDef($rsnew, UnFormatDateTime($this->date_of_dispatch->CurrentValue, $this->date_of_dispatch->formatPattern()), false);

        // port_eta
        $this->port_eta->setDbValueDef($rsnew, UnFormatDateTime($this->port_eta->CurrentValue, $this->port_eta->formatPattern()), false);

        // bl_no
        $this->bl_no->setDbValueDef($rsnew, $this->bl_no->CurrentValue, false);

        // s_line
        $this->s_line->setDbValueDef($rsnew, $this->s_line->CurrentValue, false);

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, false);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // ref
        $this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['supplier'])) { // supplier
            $this->supplier->setFormValue($row['supplier']);
        }
        if (isset($row['confirm_type'])) { // confirm_type
            $this->confirm_type->setFormValue($row['confirm_type']);
        }
        if (isset($row['booking_ref'])) { // booking_ref
            $this->booking_ref->setFormValue($row['booking_ref']);
        }
        if (isset($row['approx_qty'])) { // approx_qty
            $this->approx_qty->setFormValue($row['approx_qty']);
        }
        if (isset($row['packets'])) { // packets
            $this->packets->setFormValue($row['packets']);
        }
        if (isset($row['amount'])) { // amount
            $this->amount->setFormValue($row['amount']);
        }
        if (isset($row['currency'])) { // currency
            $this->currency->setFormValue($row['currency']);
        }
        if (isset($row['date'])) { // date
            $this->date->setFormValue($row['date']);
        }
        if (isset($row['reference'])) { // reference
            $this->reference->setFormValue($row['reference']);
        }
        if (isset($row['date_of_dispatch'])) { // date_of_dispatch
            $this->date_of_dispatch->setFormValue($row['date_of_dispatch']);
        }
        if (isset($row['port_eta'])) { // port_eta
            $this->port_eta->setFormValue($row['port_eta']);
        }
        if (isset($row['bl_no'])) { // bl_no
            $this->bl_no->setFormValue($row['bl_no']);
        }
        if (isset($row['s_line'])) { // s_line
            $this->s_line->setFormValue($row['s_line']);
        }
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['ref'])) { // ref
            $this->ref->setFormValue($row['ref']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        // Hide foreign keys
        $masterTblVar = $this->getCurrentMasterTable();
        if ($masterTblVar == "booking_details") {
            $masterTbl = Container("booking_details");
            $this->ref->Visible = false;
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_supplier":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_confirm_type":
                    break;
                case "x_booking_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_line":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }
}
