<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BookingConfirmEdit extends BookingConfirm
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BookingConfirmEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "bookingconfirmedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->supplier->setVisibility();
        $this->confirm_type->setVisibility();
        $this->booking_ref->setVisibility();
        $this->approx_qty->setVisibility();
        $this->packets->setVisibility();
        $this->amount->setVisibility();
        $this->currency->setVisibility();
        $this->date->setVisibility();
        $this->reference->setVisibility();
        $this->date_of_dispatch->setVisibility();
        $this->port_eta->setVisibility();
        $this->bl_no->setVisibility();
        $this->s_line->setVisibility();
        $this->company_id->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->fibc->Visible = false;
        $this->ref->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'booking_confirm';
        $this->TableName = 'booking_confirm';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (booking_confirm)
        if (!isset($GLOBALS["booking_confirm"]) || $GLOBALS["booking_confirm"]::class == PROJECT_NAMESPACE . "booking_confirm") {
            $GLOBALS["booking_confirm"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'booking_confirm');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "bookingconfirmview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->supplier->Required = false;
        $this->booking_ref->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->supplier);
        $this->setupLookupOptions($this->confirm_type);
        $this->setupLookupOptions($this->booking_ref);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->s_line);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Set up master detail parameters
            $this->setupMasterParms();

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("bookingconfirmlist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "bookingconfirmlist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions && !$this->getCurrentMasterTable()) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "bookingconfirmlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "bookingconfirmlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'supplier' first before field var 'x_supplier'
        $val = $CurrentForm->hasValue("supplier") ? $CurrentForm->getValue("supplier") : $CurrentForm->getValue("x_supplier");
        if (!$this->supplier->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->supplier->Visible = false; // Disable update for API request
            } else {
                $this->supplier->setFormValue($val);
            }
        }

        // Check field name 'confirm_type' first before field var 'x_confirm_type'
        $val = $CurrentForm->hasValue("confirm_type") ? $CurrentForm->getValue("confirm_type") : $CurrentForm->getValue("x_confirm_type");
        if (!$this->confirm_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->confirm_type->Visible = false; // Disable update for API request
            } else {
                $this->confirm_type->setFormValue($val);
            }
        }

        // Check field name 'booking_ref' first before field var 'x_booking_ref'
        $val = $CurrentForm->hasValue("booking_ref") ? $CurrentForm->getValue("booking_ref") : $CurrentForm->getValue("x_booking_ref");
        if (!$this->booking_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->booking_ref->Visible = false; // Disable update for API request
            } else {
                $this->booking_ref->setFormValue($val);
            }
        }

        // Check field name 'approx_qty' first before field var 'x_approx_qty'
        $val = $CurrentForm->hasValue("approx_qty") ? $CurrentForm->getValue("approx_qty") : $CurrentForm->getValue("x_approx_qty");
        if (!$this->approx_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->approx_qty->Visible = false; // Disable update for API request
            } else {
                $this->approx_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'packets' first before field var 'x_packets'
        $val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
        if (!$this->packets->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packets->Visible = false; // Disable update for API request
            } else {
                $this->packets->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'date' first before field var 'x_date'
        $val = $CurrentForm->hasValue("date") ? $CurrentForm->getValue("date") : $CurrentForm->getValue("x_date");
        if (!$this->date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->date->Visible = false; // Disable update for API request
            } else {
                $this->date->setFormValue($val, true, $validate);
            }
            $this->date->CurrentValue = UnFormatDateTime($this->date->CurrentValue, $this->date->formatPattern());
        }

        // Check field name 'reference' first before field var 'x_reference'
        $val = $CurrentForm->hasValue("reference") ? $CurrentForm->getValue("reference") : $CurrentForm->getValue("x_reference");
        if (!$this->reference->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reference->Visible = false; // Disable update for API request
            } else {
                $this->reference->setFormValue($val);
            }
        }

        // Check field name 'date_of_dispatch' first before field var 'x_date_of_dispatch'
        $val = $CurrentForm->hasValue("date_of_dispatch") ? $CurrentForm->getValue("date_of_dispatch") : $CurrentForm->getValue("x_date_of_dispatch");
        if (!$this->date_of_dispatch->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->date_of_dispatch->Visible = false; // Disable update for API request
            } else {
                $this->date_of_dispatch->setFormValue($val, true, $validate);
            }
            $this->date_of_dispatch->CurrentValue = UnFormatDateTime($this->date_of_dispatch->CurrentValue, $this->date_of_dispatch->formatPattern());
        }

        // Check field name 'port_eta' first before field var 'x_port_eta'
        $val = $CurrentForm->hasValue("port_eta") ? $CurrentForm->getValue("port_eta") : $CurrentForm->getValue("x_port_eta");
        if (!$this->port_eta->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->port_eta->Visible = false; // Disable update for API request
            } else {
                $this->port_eta->setFormValue($val, true, $validate);
            }
            $this->port_eta->CurrentValue = UnFormatDateTime($this->port_eta->CurrentValue, $this->port_eta->formatPattern());
        }

        // Check field name 'bl_no' first before field var 'x_bl_no'
        $val = $CurrentForm->hasValue("bl_no") ? $CurrentForm->getValue("bl_no") : $CurrentForm->getValue("x_bl_no");
        if (!$this->bl_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bl_no->Visible = false; // Disable update for API request
            } else {
                $this->bl_no->setFormValue($val);
            }
        }

        // Check field name 's_line' first before field var 'x_s_line'
        $val = $CurrentForm->hasValue("s_line") ? $CurrentForm->getValue("s_line") : $CurrentForm->getValue("x_s_line");
        if (!$this->s_line->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_line->Visible = false; // Disable update for API request
            } else {
                $this->s_line->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'ref' first before field var 'x_ref'
        $val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
        if (!$this->ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ref->Visible = false; // Disable update for API request
            } else {
                $this->ref->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->supplier->CurrentValue = $this->supplier->FormValue;
        $this->confirm_type->CurrentValue = $this->confirm_type->FormValue;
        $this->booking_ref->CurrentValue = $this->booking_ref->FormValue;
        $this->approx_qty->CurrentValue = $this->approx_qty->FormValue;
        $this->packets->CurrentValue = $this->packets->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->date->CurrentValue = $this->date->FormValue;
        $this->date->CurrentValue = UnFormatDateTime($this->date->CurrentValue, $this->date->formatPattern());
        $this->reference->CurrentValue = $this->reference->FormValue;
        $this->date_of_dispatch->CurrentValue = $this->date_of_dispatch->FormValue;
        $this->date_of_dispatch->CurrentValue = UnFormatDateTime($this->date_of_dispatch->CurrentValue, $this->date_of_dispatch->formatPattern());
        $this->port_eta->CurrentValue = $this->port_eta->FormValue;
        $this->port_eta->CurrentValue = UnFormatDateTime($this->port_eta->CurrentValue, $this->port_eta->formatPattern());
        $this->bl_no->CurrentValue = $this->bl_no->FormValue;
        $this->s_line->CurrentValue = $this->s_line->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->ref->CurrentValue = $this->ref->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->supplier->setDbValue($row['supplier']);
        $this->confirm_type->setDbValue($row['confirm_type']);
        $this->booking_ref->setDbValue($row['booking_ref']);
        $this->approx_qty->setDbValue($row['approx_qty']);
        $this->packets->setDbValue($row['packets']);
        $this->amount->setDbValue($row['amount']);
        $this->currency->setDbValue($row['currency']);
        $this->date->setDbValue($row['date']);
        $this->reference->setDbValue($row['reference']);
        $this->date_of_dispatch->setDbValue($row['date_of_dispatch']);
        $this->port_eta->setDbValue($row['port_eta']);
        $this->bl_no->setDbValue($row['bl_no']);
        $this->s_line->setDbValue($row['s_line']);
        $this->company_id->setDbValue($row['company_id']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->fibc->setDbValue($row['fibc']);
        $this->ref->setDbValue($row['ref']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['supplier'] = $this->supplier->DefaultValue;
        $row['confirm_type'] = $this->confirm_type->DefaultValue;
        $row['booking_ref'] = $this->booking_ref->DefaultValue;
        $row['approx_qty'] = $this->approx_qty->DefaultValue;
        $row['packets'] = $this->packets->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['date'] = $this->date->DefaultValue;
        $row['reference'] = $this->reference->DefaultValue;
        $row['date_of_dispatch'] = $this->date_of_dispatch->DefaultValue;
        $row['port_eta'] = $this->port_eta->DefaultValue;
        $row['bl_no'] = $this->bl_no->DefaultValue;
        $row['s_line'] = $this->s_line->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['fibc'] = $this->fibc->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // supplier
        $this->supplier->RowCssClass = "row";

        // confirm_type
        $this->confirm_type->RowCssClass = "row";

        // booking_ref
        $this->booking_ref->RowCssClass = "row";

        // approx_qty
        $this->approx_qty->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // date
        $this->date->RowCssClass = "row";

        // reference
        $this->reference->RowCssClass = "row";

        // date_of_dispatch
        $this->date_of_dispatch->RowCssClass = "row";

        // port_eta
        $this->port_eta->RowCssClass = "row";

        // bl_no
        $this->bl_no->RowCssClass = "row";

        // s_line
        $this->s_line->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // fibc
        $this->fibc->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // supplier
            $curVal = strval($this->supplier->CurrentValue);
            if ($curVal != "") {
                $this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
                if ($this->supplier->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                    $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                        $this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
                    } else {
                        $this->supplier->ViewValue = $this->supplier->CurrentValue;
                    }
                }
            } else {
                $this->supplier->ViewValue = null;
            }

            // confirm_type
            if (strval($this->confirm_type->CurrentValue) != "") {
                $this->confirm_type->ViewValue = $this->confirm_type->optionCaption($this->confirm_type->CurrentValue);
            } else {
                $this->confirm_type->ViewValue = null;
            }

            // booking_ref
            $curVal = strval($this->booking_ref->CurrentValue);
            if ($curVal != "") {
                $this->booking_ref->ViewValue = $this->booking_ref->lookupCacheOption($curVal);
                if ($this->booking_ref->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->booking_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->booking_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->booking_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->booking_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->booking_ref->ViewValue = $this->booking_ref->displayValue($arwrk);
                    } else {
                        $this->booking_ref->ViewValue = $this->booking_ref->CurrentValue;
                    }
                }
            } else {
                $this->booking_ref->ViewValue = null;
            }

            // approx_qty
            $this->approx_qty->ViewValue = $this->approx_qty->CurrentValue;
            $this->approx_qty->ViewValue = FormatNumber($this->approx_qty->ViewValue, $this->approx_qty->formatPattern());

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // currency
            $this->currency->ViewValue = $this->currency->CurrentValue;
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // date
            $this->date->ViewValue = $this->date->CurrentValue;
            $this->date->ViewValue = FormatDateTime($this->date->ViewValue, $this->date->formatPattern());

            // reference
            $this->reference->ViewValue = $this->reference->CurrentValue;

            // date_of_dispatch
            $this->date_of_dispatch->ViewValue = $this->date_of_dispatch->CurrentValue;
            $this->date_of_dispatch->ViewValue = FormatDateTime($this->date_of_dispatch->ViewValue, $this->date_of_dispatch->formatPattern());

            // port_eta
            $this->port_eta->ViewValue = $this->port_eta->CurrentValue;
            $this->port_eta->ViewValue = FormatDateTime($this->port_eta->ViewValue, $this->port_eta->formatPattern());

            // bl_no
            $this->bl_no->ViewValue = $this->bl_no->CurrentValue;

            // s_line
            $curVal = strval($this->s_line->CurrentValue);
            if ($curVal != "") {
                $this->s_line->ViewValue = $this->s_line->lookupCacheOption($curVal);
                if ($this->s_line->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_line->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_line->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_line->Lookup->renderViewRow($rswrk[0]);
                        $this->s_line->ViewValue = $this->s_line->displayValue($arwrk);
                    } else {
                        $this->s_line->ViewValue = FormatNumber($this->s_line->CurrentValue, $this->s_line->formatPattern());
                    }
                }
            } else {
                $this->s_line->ViewValue = null;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // id
            $this->id->HrefValue = "";

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }
            $this->supplier->TooltipValue = "";

            // confirm_type
            $this->confirm_type->HrefValue = "";

            // booking_ref
            $this->booking_ref->HrefValue = "";
            $this->booking_ref->TooltipValue = "";

            // approx_qty
            $this->approx_qty->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // date
            $this->date->HrefValue = "";

            // reference
            $this->reference->HrefValue = "";

            // date_of_dispatch
            $this->date_of_dispatch->HrefValue = "";

            // port_eta
            $this->port_eta->HrefValue = "";

            // bl_no
            $this->bl_no->HrefValue = "";

            // s_line
            $this->s_line->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // ref
            $this->ref->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // supplier
            $this->supplier->setupEditAttributes();
            $curVal = strval($this->supplier->CurrentValue);
            if ($curVal != "") {
                $this->supplier->EditValue = $this->supplier->lookupCacheOption($curVal);
                if ($this->supplier->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                    $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                        $this->supplier->EditValue = $this->supplier->displayValue($arwrk);
                    } else {
                        $this->supplier->EditValue = $this->supplier->CurrentValue;
                    }
                }
            } else {
                $this->supplier->EditValue = null;
            }

            // confirm_type
            $this->confirm_type->setupEditAttributes();
            $this->confirm_type->EditValue = $this->confirm_type->options(true);
            $this->confirm_type->PlaceHolder = RemoveHtml($this->confirm_type->caption());

            // booking_ref
            $this->booking_ref->setupEditAttributes();
            $curVal = strval($this->booking_ref->CurrentValue);
            if ($curVal != "") {
                $this->booking_ref->EditValue = $this->booking_ref->lookupCacheOption($curVal);
                if ($this->booking_ref->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->booking_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->booking_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->booking_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->booking_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->booking_ref->EditValue = $this->booking_ref->displayValue($arwrk);
                    } else {
                        $this->booking_ref->EditValue = $this->booking_ref->CurrentValue;
                    }
                }
            } else {
                $this->booking_ref->EditValue = null;
            }

            // approx_qty
            $this->approx_qty->setupEditAttributes();
            $this->approx_qty->EditValue = $this->approx_qty->CurrentValue;
            $this->approx_qty->PlaceHolder = RemoveHtml($this->approx_qty->caption());
            if (strval($this->approx_qty->EditValue) != "" && is_numeric($this->approx_qty->EditValue)) {
                $this->approx_qty->EditValue = FormatNumber($this->approx_qty->EditValue, null);
            }

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->CurrentValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
            if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
                $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
            }

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
                $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
            }

            // currency
            $this->currency->setupEditAttributes();
            $this->currency->EditValue = $this->currency->CurrentValue;
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->EditValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->EditValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->EditValue = HtmlEncode(FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern()));
                    }
                }
            } else {
                $this->currency->EditValue = null;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // date
            $this->date->setupEditAttributes();
            $this->date->EditValue = HtmlEncode(FormatDateTime($this->date->CurrentValue, $this->date->formatPattern()));
            $this->date->PlaceHolder = RemoveHtml($this->date->caption());

            // reference
            $this->reference->setupEditAttributes();
            $this->reference->EditValue = HtmlEncode($this->reference->CurrentValue);
            $this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

            // date_of_dispatch
            $this->date_of_dispatch->setupEditAttributes();
            $this->date_of_dispatch->EditValue = HtmlEncode(FormatDateTime($this->date_of_dispatch->CurrentValue, $this->date_of_dispatch->formatPattern()));
            $this->date_of_dispatch->PlaceHolder = RemoveHtml($this->date_of_dispatch->caption());

            // port_eta
            $this->port_eta->setupEditAttributes();
            $this->port_eta->EditValue = HtmlEncode(FormatDateTime($this->port_eta->CurrentValue, $this->port_eta->formatPattern()));
            $this->port_eta->PlaceHolder = RemoveHtml($this->port_eta->caption());

            // bl_no
            $this->bl_no->setupEditAttributes();
            if (!$this->bl_no->Raw) {
                $this->bl_no->CurrentValue = HtmlDecode($this->bl_no->CurrentValue);
            }
            $this->bl_no->EditValue = HtmlEncode($this->bl_no->CurrentValue);
            $this->bl_no->PlaceHolder = RemoveHtml($this->bl_no->caption());

            // s_line
            $this->s_line->setupEditAttributes();
            $curVal = trim(strval($this->s_line->CurrentValue));
            if ($curVal != "") {
                $this->s_line->ViewValue = $this->s_line->lookupCacheOption($curVal);
            } else {
                $this->s_line->ViewValue = $this->s_line->Lookup !== null && is_array($this->s_line->lookupOptions()) && count($this->s_line->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_line->ViewValue !== null) { // Load from cache
                $this->s_line->EditValue = array_values($this->s_line->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_line->CurrentValue, $this->s_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_line->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_line->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_line->EditValue = $arwrk;
            }
            $this->s_line->PlaceHolder = RemoveHtml($this->s_line->caption());

            // operator

            // datetime

            // ref
            $this->ref->setupEditAttributes();
            if ($this->ref->getSessionValue() != "") {
                $this->ref->CurrentValue = GetForeignKeyValue($this->ref->getSessionValue());
                $this->ref->ViewValue = $this->ref->CurrentValue;
            } else {
                if (!$this->ref->Raw) {
                    $this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
                }
                $this->ref->EditValue = HtmlEncode($this->ref->CurrentValue);
                $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());
            }

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }
            $this->supplier->TooltipValue = "";

            // confirm_type
            $this->confirm_type->HrefValue = "";

            // booking_ref
            $this->booking_ref->HrefValue = "";
            $this->booking_ref->TooltipValue = "";

            // approx_qty
            $this->approx_qty->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // date
            $this->date->HrefValue = "";

            // reference
            $this->reference->HrefValue = "";

            // date_of_dispatch
            $this->date_of_dispatch->HrefValue = "";

            // port_eta
            $this->port_eta->HrefValue = "";

            // bl_no
            $this->bl_no->HrefValue = "";

            // s_line
            $this->s_line->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // ref
            $this->ref->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->supplier->Visible && $this->supplier->Required) {
                if (!$this->supplier->IsDetailKey && EmptyValue($this->supplier->FormValue)) {
                    $this->supplier->addErrorMessage(str_replace("%s", $this->supplier->caption(), $this->supplier->RequiredErrorMessage));
                }
            }
            if ($this->confirm_type->Visible && $this->confirm_type->Required) {
                if (!$this->confirm_type->IsDetailKey && EmptyValue($this->confirm_type->FormValue)) {
                    $this->confirm_type->addErrorMessage(str_replace("%s", $this->confirm_type->caption(), $this->confirm_type->RequiredErrorMessage));
                }
            }
            if ($this->booking_ref->Visible && $this->booking_ref->Required) {
                if (!$this->booking_ref->IsDetailKey && EmptyValue($this->booking_ref->FormValue)) {
                    $this->booking_ref->addErrorMessage(str_replace("%s", $this->booking_ref->caption(), $this->booking_ref->RequiredErrorMessage));
                }
            }
            if ($this->approx_qty->Visible && $this->approx_qty->Required) {
                if (!$this->approx_qty->IsDetailKey && EmptyValue($this->approx_qty->FormValue)) {
                    $this->approx_qty->addErrorMessage(str_replace("%s", $this->approx_qty->caption(), $this->approx_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->approx_qty->FormValue)) {
                $this->approx_qty->addErrorMessage($this->approx_qty->getErrorMessage(false));
            }
            if ($this->packets->Visible && $this->packets->Required) {
                if (!$this->packets->IsDetailKey && EmptyValue($this->packets->FormValue)) {
                    $this->packets->addErrorMessage(str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->packets->FormValue)) {
                $this->packets->addErrorMessage($this->packets->getErrorMessage(false));
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->amount->FormValue)) {
                $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->currency->FormValue)) {
                $this->currency->addErrorMessage($this->currency->getErrorMessage(false));
            }
            if ($this->date->Visible && $this->date->Required) {
                if (!$this->date->IsDetailKey && EmptyValue($this->date->FormValue)) {
                    $this->date->addErrorMessage(str_replace("%s", $this->date->caption(), $this->date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->date->FormValue, $this->date->formatPattern())) {
                $this->date->addErrorMessage($this->date->getErrorMessage(false));
            }
            if ($this->reference->Visible && $this->reference->Required) {
                if (!$this->reference->IsDetailKey && EmptyValue($this->reference->FormValue)) {
                    $this->reference->addErrorMessage(str_replace("%s", $this->reference->caption(), $this->reference->RequiredErrorMessage));
                }
            }
            if ($this->date_of_dispatch->Visible && $this->date_of_dispatch->Required) {
                if (!$this->date_of_dispatch->IsDetailKey && EmptyValue($this->date_of_dispatch->FormValue)) {
                    $this->date_of_dispatch->addErrorMessage(str_replace("%s", $this->date_of_dispatch->caption(), $this->date_of_dispatch->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->date_of_dispatch->FormValue, $this->date_of_dispatch->formatPattern())) {
                $this->date_of_dispatch->addErrorMessage($this->date_of_dispatch->getErrorMessage(false));
            }
            if ($this->port_eta->Visible && $this->port_eta->Required) {
                if (!$this->port_eta->IsDetailKey && EmptyValue($this->port_eta->FormValue)) {
                    $this->port_eta->addErrorMessage(str_replace("%s", $this->port_eta->caption(), $this->port_eta->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->port_eta->FormValue, $this->port_eta->formatPattern())) {
                $this->port_eta->addErrorMessage($this->port_eta->getErrorMessage(false));
            }
            if ($this->bl_no->Visible && $this->bl_no->Required) {
                if (!$this->bl_no->IsDetailKey && EmptyValue($this->bl_no->FormValue)) {
                    $this->bl_no->addErrorMessage(str_replace("%s", $this->bl_no->caption(), $this->bl_no->RequiredErrorMessage));
                }
            }
            if ($this->s_line->Visible && $this->s_line->Required) {
                if (!$this->s_line->IsDetailKey && EmptyValue($this->s_line->FormValue)) {
                    $this->s_line->addErrorMessage(str_replace("%s", $this->s_line->caption(), $this->s_line->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->ref->Visible && $this->ref->Required) {
                if (!$this->ref->IsDetailKey && EmptyValue($this->ref->FormValue)) {
                    $this->ref->addErrorMessage(str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // confirm_type
        $this->confirm_type->setDbValueDef($rsnew, $this->confirm_type->CurrentValue, $this->confirm_type->ReadOnly);

        // approx_qty
        $this->approx_qty->setDbValueDef($rsnew, $this->approx_qty->CurrentValue, $this->approx_qty->ReadOnly);

        // packets
        $this->packets->setDbValueDef($rsnew, $this->packets->CurrentValue, $this->packets->ReadOnly);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, $this->amount->ReadOnly);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, $this->currency->ReadOnly);

        // date
        $this->date->setDbValueDef($rsnew, UnFormatDateTime($this->date->CurrentValue, $this->date->formatPattern()), $this->date->ReadOnly);

        // reference
        $this->reference->setDbValueDef($rsnew, $this->reference->CurrentValue, $this->reference->ReadOnly);

        // date_of_dispatch
        $this->date_of_dispatch->setDbValueDef($rsnew, UnFormatDateTime($this->date_of_dispatch->CurrentValue, $this->date_of_dispatch->formatPattern()), $this->date_of_dispatch->ReadOnly);

        // port_eta
        $this->port_eta->setDbValueDef($rsnew, UnFormatDateTime($this->port_eta->CurrentValue, $this->port_eta->formatPattern()), $this->port_eta->ReadOnly);

        // bl_no
        $this->bl_no->setDbValueDef($rsnew, $this->bl_no->CurrentValue, $this->bl_no->ReadOnly);

        // s_line
        $this->s_line->setDbValueDef($rsnew, $this->s_line->CurrentValue, $this->s_line->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // ref
        if ($this->ref->getSessionValue() != "") {
            $this->ref->ReadOnly = true;
        }
        $this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, $this->ref->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['confirm_type'])) { // confirm_type
            $this->confirm_type->CurrentValue = $row['confirm_type'];
        }
        if (isset($row['approx_qty'])) { // approx_qty
            $this->approx_qty->CurrentValue = $row['approx_qty'];
        }
        if (isset($row['packets'])) { // packets
            $this->packets->CurrentValue = $row['packets'];
        }
        if (isset($row['amount'])) { // amount
            $this->amount->CurrentValue = $row['amount'];
        }
        if (isset($row['currency'])) { // currency
            $this->currency->CurrentValue = $row['currency'];
        }
        if (isset($row['date'])) { // date
            $this->date->CurrentValue = $row['date'];
        }
        if (isset($row['reference'])) { // reference
            $this->reference->CurrentValue = $row['reference'];
        }
        if (isset($row['date_of_dispatch'])) { // date_of_dispatch
            $this->date_of_dispatch->CurrentValue = $row['date_of_dispatch'];
        }
        if (isset($row['port_eta'])) { // port_eta
            $this->port_eta->CurrentValue = $row['port_eta'];
        }
        if (isset($row['bl_no'])) { // bl_no
            $this->bl_no->CurrentValue = $row['bl_no'];
        }
        if (isset($row['s_line'])) { // s_line
            $this->s_line->CurrentValue = $row['s_line'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['ref'])) { // ref
            $this->ref->CurrentValue = $row['ref'];
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "booking_details") {
                $validMaster = true;
                $masterTbl = Container("booking_details");
                if (($parm = Get("fk_ref", Get("ref"))) !== null) {
                    $masterTbl->ref->setQueryStringValue($parm);
                    $this->ref->QueryStringValue = $masterTbl->ref->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->ref->setSessionValue($this->ref->QueryStringValue);
                    $foreignKeys["ref"] = $this->ref->QueryStringValue;
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "booking_details") {
                $validMaster = true;
                $masterTbl = Container("booking_details");
                if (($parm = Post("fk_ref", Post("ref"))) !== null) {
                    $masterTbl->ref->setFormValue($parm);
                    $this->ref->FormValue = $masterTbl->ref->FormValue;
                    $this->ref->setSessionValue($this->ref->FormValue);
                    $foreignKeys["ref"] = $this->ref->FormValue;
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);
            $this->setSessionWhere($this->getDetailFilterFromSession());

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "booking_details") {
                if (!array_key_exists("ref", $foreignKeys)) { // Not current foreign key
                    $this->ref->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bookingconfirmlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_supplier":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_confirm_type":
                    break;
                case "x_booking_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_line":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
