<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for booking_confirm
 */
class BookingConfirm extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $supplier;
    public $confirm_type;
    public $booking_ref;
    public $approx_qty;
    public $packets;
    public $amount;
    public $currency;
    public $date;
    public $reference;
    public $date_of_dispatch;
    public $port_eta;
    public $bl_no;
    public $s_line;
    public $company_id;
    public $operator;
    public $datetime;
    public $fibc;
    public $ref;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "booking_confirm";
        $this->TableName = 'booking_confirm';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "booking_confirm";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // supplier
        $this->supplier = new DbField(
            $this, // Table
            'x_supplier', // Variable name
            'supplier', // Name
            '`supplier`', // Expression
            '`supplier`', // Basic search expression
            3, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`supplier`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->supplier->addMethod("getSelectFilter", fn() => "`status`=1 and `category` = 1002");
        $this->supplier->addMethod("getLinkPrefix", fn() => "productionpartnerview/");
        $this->supplier->InputTextType = "text";
        $this->supplier->Raw = true;
        $this->supplier->Required = true; // Required field
        $this->supplier->setSelectMultiple(false); // Select one
        $this->supplier->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->supplier->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->supplier->Lookup = new Lookup($this->supplier, 'production_partner', true, 'id', ["name","code","",""], '', '', [], ["x_booking_ref"], [], [], [], [], false, '`category` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->supplier) . "',COALESCE(`code`,''))");
        $this->supplier->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->supplier->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['supplier'] = &$this->supplier;

        // confirm_type
        $this->confirm_type = new DbField(
            $this, // Table
            'x_confirm_type', // Variable name
            'confirm_type', // Name
            '`confirm_type`', // Expression
            '`confirm_type`', // Basic search expression
            200, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`confirm_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->confirm_type->addMethod("getDefault", fn() => "1");
        $this->confirm_type->InputTextType = "text";
        $this->confirm_type->setSelectMultiple(false); // Select one
        $this->confirm_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->confirm_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->confirm_type->Lookup = new Lookup($this->confirm_type, 'booking_confirm', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->confirm_type->OptionCount = 5;
        $this->confirm_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->confirm_type->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['confirm_type'] = &$this->confirm_type;

        // booking_ref
        $this->booking_ref = new DbField(
            $this, // Table
            'x_booking_ref', // Variable name
            'booking_ref', // Name
            '`booking_ref`', // Expression
            '`booking_ref`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`booking_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->booking_ref->addMethod("getSelectFilter", fn() => ((CurrentPageID() == "list") || (CurrentPageID() == "view")) ? "" : "`status` <= 2");
        $this->booking_ref->InputTextType = "text";
        $this->booking_ref->Raw = true;
        $this->booking_ref->Nullable = false; // NOT NULL field
        $this->booking_ref->Required = true; // Required field
        $this->booking_ref->setSelectMultiple(false); // Select one
        $this->booking_ref->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->booking_ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->booking_ref->Lookup = new Lookup($this->booking_ref, 'booking_ref', true, 'id', ["ref","product_code","confirm_pending",""], '', '', ["x_supplier"], [], ["supplier_id"], ["x_supplier_id"], ["b_quantity","booking_currency"], ["x_approx_qty","x_currency"], false, '`ref` ASC', '', "CONCAT(COALESCE(`ref`, ''),'" . ValueSeparator(1, $this->booking_ref) . "',COALESCE(`product_code`,''),'" . ValueSeparator(2, $this->booking_ref) . "',COALESCE(`confirm_pending`,''))");
        $this->booking_ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->booking_ref->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['booking_ref'] = &$this->booking_ref;

        // approx_qty
        $this->approx_qty = new DbField(
            $this, // Table
            'x_approx_qty', // Variable name
            'approx_qty', // Name
            '`approx_qty`', // Expression
            '`approx_qty`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`approx_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->approx_qty->InputTextType = "text";
        $this->approx_qty->Raw = true;
        $this->approx_qty->Required = true; // Required field
        $this->approx_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->approx_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['approx_qty'] = &$this->approx_qty;

        // packets
        $this->packets = new DbField(
            $this, // Table
            'x_packets', // Variable name
            'packets', // Name
            '`packets`', // Expression
            '`packets`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packets`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packets->InputTextType = "text";
        $this->packets->Raw = true;
        $this->packets->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packets->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packets'] = &$this->packets;

        // amount
        $this->amount = new DbField(
            $this, // Table
            'x_amount', // Variable name
            'amount', // Name
            '`amount`', // Expression
            '`amount`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount->InputTextType = "text";
        $this->amount->Raw = true;
        $this->amount->Nullable = false; // NOT NULL field
        $this->amount->Required = true; // Required field
        $this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['amount'] = &$this->amount;

        // currency
        $this->currency = new DbField(
            $this, // Table
            'x_currency', // Variable name
            'currency', // Name
            '`currency`', // Expression
            '`currency`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`currency`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->currency->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->currency->InputTextType = "text";
        $this->currency->Raw = true;
        $this->currency->Required = true; // Required field
        $this->currency->Lookup = new Lookup($this->currency, 'currency', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], true, '`name` ASC', '', "`code`");
        $this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->currency->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['currency'] = &$this->currency;

        // date
        $this->date = new DbField(
            $this, // Table
            'x_date', // Variable name
            'date', // Name
            '`date`', // Expression
            CastDateFieldForLike("`date`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->date->InputTextType = "text";
        $this->date->Raw = true;
        $this->date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['date'] = &$this->date;

        // reference
        $this->reference = new DbField(
            $this, // Table
            'x_reference', // Variable name
            'reference', // Name
            '`reference`', // Expression
            '`reference`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`reference`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->reference->InputTextType = "text";
        $this->reference->Required = true; // Required field
        $this->reference->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['reference'] = &$this->reference;

        // date_of_dispatch
        $this->date_of_dispatch = new DbField(
            $this, // Table
            'x_date_of_dispatch', // Variable name
            'date_of_dispatch', // Name
            '`date_of_dispatch`', // Expression
            CastDateFieldForLike("`date_of_dispatch`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`date_of_dispatch`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->date_of_dispatch->InputTextType = "text";
        $this->date_of_dispatch->Raw = true;
        $this->date_of_dispatch->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->date_of_dispatch->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['date_of_dispatch'] = &$this->date_of_dispatch;

        // port_eta
        $this->port_eta = new DbField(
            $this, // Table
            'x_port_eta', // Variable name
            'port_eta', // Name
            '`port_eta`', // Expression
            CastDateFieldForLike("`port_eta`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`port_eta`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->port_eta->InputTextType = "text";
        $this->port_eta->Raw = true;
        $this->port_eta->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->port_eta->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['port_eta'] = &$this->port_eta;

        // bl_no
        $this->bl_no = new DbField(
            $this, // Table
            'x_bl_no', // Variable name
            'bl_no', // Name
            '`bl_no`', // Expression
            '`bl_no`', // Basic search expression
            200, // Type
            32, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bl_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bl_no->InputTextType = "text";
        $this->bl_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['bl_no'] = &$this->bl_no;

        // s_line
        $this->s_line = new DbField(
            $this, // Table
            'x_s_line', // Variable name
            's_line', // Name
            '`s_line`', // Expression
            '`s_line`', // Basic search expression
            2, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_line`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_line->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->s_line->InputTextType = "text";
        $this->s_line->Raw = true;
        $this->s_line->setSelectMultiple(false); // Select one
        $this->s_line->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_line->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_line->Lookup = new Lookup($this->s_line, 'shipping_line', false, 'id', ["shipping_line","code","",""], '', '', [], [], [], [], [], [], false, '`shipping_line` ASC', '', "CONCAT(COALESCE(`shipping_line`, ''),'" . ValueSeparator(1, $this->s_line) . "',COALESCE(`code`,''))");
        $this->s_line->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_line->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['s_line'] = &$this->s_line;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->company_id->addMethod("getSelectFilter", fn() => "`category`=1");
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Nullable = false; // NOT NULL field
        $this->company_id->Required = true; // Required field
        $this->company_id->Lookup = new Lookup($this->company_id, 'buyer_seller_view', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['company_id'] = &$this->company_id;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->Nullable = false; // NOT NULL field
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // fibc
        $this->fibc = new DbField(
            $this, // Table
            'x_fibc', // Variable name
            'fibc', // Name
            '`fibc`', // Expression
            '`fibc`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fibc`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->fibc->InputTextType = "text";
        $this->fibc->Sortable = false; // Allow sort
        $this->fibc->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['fibc'] = &$this->fibc;

        // ref
        $this->ref = new DbField(
            $this, // Table
            'x_ref', // Variable name
            'ref', // Name
            '`ref`', // Expression
            '`ref`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ref->InputTextType = "text";
        $this->ref->IsForeignKey = true; // Foreign key field
        $this->ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ref'] = &$this->ref;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current master table name
    public function getCurrentMasterTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE"));
    }

    public function setCurrentMasterTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
    }

    // Get master WHERE clause from session values
    public function getMasterFilterFromSession()
    {
        // Master filter
        $masterFilter = "";
        if ($this->getCurrentMasterTable() == "booking_details") {
            $masterTable = Container("booking_details");
            if ($this->ref->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->ref, $this->ref->getSessionValue(), $masterTable->ref->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        return $masterFilter;
    }

    // Get detail WHERE clause from session values
    public function getDetailFilterFromSession()
    {
        // Detail filter
        $detailFilter = "";
        if ($this->getCurrentMasterTable() == "booking_details") {
            $masterTable = Container("booking_details");
            if ($this->ref->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->ref, $this->ref->getSessionValue(), $masterTable->ref->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        return $detailFilter;
    }

    /**
     * Get master filter
     *
     * @param object $masterTable Master Table
     * @param array $keys Detail Keys
     * @return mixed NULL is returned if all keys are empty, Empty string is returned if some keys are empty and is required
     */
    public function getMasterFilter($masterTable, $keys)
    {
        $validKeys = true;
        switch ($masterTable->TableVar) {
            case "booking_details":
                $key = $keys["ref"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->ref->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->ref, $keys["ref"], $this->ref->DataType, $this->Dbid);
                }
                break;
        }
        return null; // All null values and no required fields
    }

    // Get detail filter
    public function getDetailFilter($masterTable)
    {
        switch ($masterTable->TableVar) {
            case "booking_details":
                return GetKeyFilter($this->ref, $masterTable->ref->DbValue, $masterTable->ref->DataType, $masterTable->Dbid);
        }
        return "";
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "booking_confirm";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->supplier->DbValue = $row['supplier'];
        $this->confirm_type->DbValue = $row['confirm_type'];
        $this->booking_ref->DbValue = $row['booking_ref'];
        $this->approx_qty->DbValue = $row['approx_qty'];
        $this->packets->DbValue = $row['packets'];
        $this->amount->DbValue = $row['amount'];
        $this->currency->DbValue = $row['currency'];
        $this->date->DbValue = $row['date'];
        $this->reference->DbValue = $row['reference'];
        $this->date_of_dispatch->DbValue = $row['date_of_dispatch'];
        $this->port_eta->DbValue = $row['port_eta'];
        $this->bl_no->DbValue = $row['bl_no'];
        $this->s_line->DbValue = $row['s_line'];
        $this->company_id->DbValue = $row['company_id'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->fibc->DbValue = $row['fibc'];
        $this->ref->DbValue = $row['ref'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("bookingconfirmlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "bookingconfirmview" => $Language->phrase("View"),
            "bookingconfirmedit" => $Language->phrase("Edit"),
            "bookingconfirmadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "bookingconfirmlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "BookingConfirmView",
            Config("API_ADD_ACTION") => "BookingConfirmAdd",
            Config("API_EDIT_ACTION") => "BookingConfirmEdit",
            Config("API_DELETE_ACTION") => "BookingConfirmDelete",
            Config("API_LIST_ACTION") => "BookingConfirmList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "bookingconfirmlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("bookingconfirmview", $parm);
        } else {
            $url = $this->keyUrl("bookingconfirmview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "bookingconfirmadd?" . $parm;
        } else {
            $url = "bookingconfirmadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("bookingconfirmedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("bookingconfirmlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("bookingconfirmadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("bookingconfirmlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("bookingconfirmdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        if ($this->getCurrentMasterTable() == "booking_details" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_ref", $this->ref->getSessionValue()); // Use Session Value
        }
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->supplier->setDbValue($row['supplier']);
        $this->confirm_type->setDbValue($row['confirm_type']);
        $this->booking_ref->setDbValue($row['booking_ref']);
        $this->approx_qty->setDbValue($row['approx_qty']);
        $this->packets->setDbValue($row['packets']);
        $this->amount->setDbValue($row['amount']);
        $this->currency->setDbValue($row['currency']);
        $this->date->setDbValue($row['date']);
        $this->reference->setDbValue($row['reference']);
        $this->date_of_dispatch->setDbValue($row['date_of_dispatch']);
        $this->port_eta->setDbValue($row['port_eta']);
        $this->bl_no->setDbValue($row['bl_no']);
        $this->s_line->setDbValue($row['s_line']);
        $this->company_id->setDbValue($row['company_id']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->fibc->setDbValue($row['fibc']);
        $this->ref->setDbValue($row['ref']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "BookingConfirmList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // supplier

        // confirm_type

        // booking_ref

        // approx_qty

        // packets

        // amount

        // currency

        // date

        // reference

        // date_of_dispatch

        // port_eta

        // bl_no

        // s_line

        // company_id

        // operator

        // datetime

        // fibc
        $this->fibc->CellCssStyle = "white-space: nowrap;";

        // ref

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // supplier
        $curVal = strval($this->supplier->CurrentValue);
        if ($curVal != "") {
            $this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
            if ($this->supplier->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                    $this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
                } else {
                    $this->supplier->ViewValue = $this->supplier->CurrentValue;
                }
            }
        } else {
            $this->supplier->ViewValue = null;
        }

        // confirm_type
        if (strval($this->confirm_type->CurrentValue) != "") {
            $this->confirm_type->ViewValue = $this->confirm_type->optionCaption($this->confirm_type->CurrentValue);
        } else {
            $this->confirm_type->ViewValue = null;
        }

        // booking_ref
        $curVal = strval($this->booking_ref->CurrentValue);
        if ($curVal != "") {
            $this->booking_ref->ViewValue = $this->booking_ref->lookupCacheOption($curVal);
            if ($this->booking_ref->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->booking_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->booking_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->booking_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->booking_ref->Lookup->renderViewRow($rswrk[0]);
                    $this->booking_ref->ViewValue = $this->booking_ref->displayValue($arwrk);
                } else {
                    $this->booking_ref->ViewValue = $this->booking_ref->CurrentValue;
                }
            }
        } else {
            $this->booking_ref->ViewValue = null;
        }

        // approx_qty
        $this->approx_qty->ViewValue = $this->approx_qty->CurrentValue;
        $this->approx_qty->ViewValue = FormatNumber($this->approx_qty->ViewValue, $this->approx_qty->formatPattern());

        // packets
        $this->packets->ViewValue = $this->packets->CurrentValue;
        $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

        // amount
        $this->amount->ViewValue = $this->amount->CurrentValue;
        $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

        // currency
        $this->currency->ViewValue = $this->currency->CurrentValue;
        $curVal = strval($this->currency->CurrentValue);
        if ($curVal != "") {
            $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            if ($this->currency->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                    $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                } else {
                    $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                }
            }
        } else {
            $this->currency->ViewValue = null;
        }

        // date
        $this->date->ViewValue = $this->date->CurrentValue;
        $this->date->ViewValue = FormatDateTime($this->date->ViewValue, $this->date->formatPattern());

        // reference
        $this->reference->ViewValue = $this->reference->CurrentValue;

        // date_of_dispatch
        $this->date_of_dispatch->ViewValue = $this->date_of_dispatch->CurrentValue;
        $this->date_of_dispatch->ViewValue = FormatDateTime($this->date_of_dispatch->ViewValue, $this->date_of_dispatch->formatPattern());

        // port_eta
        $this->port_eta->ViewValue = $this->port_eta->CurrentValue;
        $this->port_eta->ViewValue = FormatDateTime($this->port_eta->ViewValue, $this->port_eta->formatPattern());

        // bl_no
        $this->bl_no->ViewValue = $this->bl_no->CurrentValue;

        // s_line
        $curVal = strval($this->s_line->CurrentValue);
        if ($curVal != "") {
            $this->s_line->ViewValue = $this->s_line->lookupCacheOption($curVal);
            if ($this->s_line->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_line->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_line->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_line->Lookup->renderViewRow($rswrk[0]);
                    $this->s_line->ViewValue = $this->s_line->displayValue($arwrk);
                } else {
                    $this->s_line->ViewValue = FormatNumber($this->s_line->CurrentValue, $this->s_line->formatPattern());
                }
            }
        } else {
            $this->s_line->ViewValue = null;
        }

        // company_id
        $this->company_id->ViewValue = $this->company_id->CurrentValue;
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // fibc
        $this->fibc->ViewValue = $this->fibc->CurrentValue;

        // ref
        $this->ref->ViewValue = $this->ref->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // supplier
        if (!EmptyValue($this->supplier->CurrentValue)) {
            $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
            $this->supplier->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
            }
        } else {
            $this->supplier->HrefValue = "";
        }
        $this->supplier->TooltipValue = "";

        // confirm_type
        $this->confirm_type->HrefValue = "";
        $this->confirm_type->TooltipValue = "";

        // booking_ref
        $this->booking_ref->HrefValue = "";
        $this->booking_ref->TooltipValue = "";

        // approx_qty
        $this->approx_qty->HrefValue = "";
        $this->approx_qty->TooltipValue = "";

        // packets
        $this->packets->HrefValue = "";
        $this->packets->TooltipValue = "";

        // amount
        $this->amount->HrefValue = "";
        $this->amount->TooltipValue = "";

        // currency
        $this->currency->HrefValue = "";
        $this->currency->TooltipValue = "";

        // date
        $this->date->HrefValue = "";
        $this->date->TooltipValue = "";

        // reference
        $this->reference->HrefValue = "";
        $this->reference->TooltipValue = "";

        // date_of_dispatch
        $this->date_of_dispatch->HrefValue = "";
        $this->date_of_dispatch->TooltipValue = "";

        // port_eta
        $this->port_eta->HrefValue = "";
        $this->port_eta->TooltipValue = "";

        // bl_no
        $this->bl_no->HrefValue = "";
        $this->bl_no->TooltipValue = "";

        // s_line
        $this->s_line->HrefValue = "";
        $this->s_line->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // fibc
        $this->fibc->HrefValue = "";
        $this->fibc->TooltipValue = "";

        // ref
        $this->ref->HrefValue = "";
        $this->ref->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // supplier
        $this->supplier->setupEditAttributes();
        $curVal = strval($this->supplier->CurrentValue);
        if ($curVal != "") {
            $this->supplier->EditValue = $this->supplier->lookupCacheOption($curVal);
            if ($this->supplier->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                    $this->supplier->EditValue = $this->supplier->displayValue($arwrk);
                } else {
                    $this->supplier->EditValue = $this->supplier->CurrentValue;
                }
            }
        } else {
            $this->supplier->EditValue = null;
        }

        // confirm_type
        $this->confirm_type->setupEditAttributes();
        $this->confirm_type->EditValue = $this->confirm_type->options(true);
        $this->confirm_type->PlaceHolder = RemoveHtml($this->confirm_type->caption());

        // booking_ref
        $this->booking_ref->setupEditAttributes();
        $curVal = strval($this->booking_ref->CurrentValue);
        if ($curVal != "") {
            $this->booking_ref->EditValue = $this->booking_ref->lookupCacheOption($curVal);
            if ($this->booking_ref->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->booking_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->booking_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->booking_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->booking_ref->Lookup->renderViewRow($rswrk[0]);
                    $this->booking_ref->EditValue = $this->booking_ref->displayValue($arwrk);
                } else {
                    $this->booking_ref->EditValue = $this->booking_ref->CurrentValue;
                }
            }
        } else {
            $this->booking_ref->EditValue = null;
        }

        // approx_qty
        $this->approx_qty->setupEditAttributes();
        $this->approx_qty->EditValue = $this->approx_qty->CurrentValue;
        $this->approx_qty->PlaceHolder = RemoveHtml($this->approx_qty->caption());
        if (strval($this->approx_qty->EditValue) != "" && is_numeric($this->approx_qty->EditValue)) {
            $this->approx_qty->EditValue = FormatNumber($this->approx_qty->EditValue, null);
        }

        // packets
        $this->packets->setupEditAttributes();
        $this->packets->EditValue = $this->packets->CurrentValue;
        $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
        if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
            $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
        }

        // amount
        $this->amount->setupEditAttributes();
        $this->amount->EditValue = $this->amount->CurrentValue;
        $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
        if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
            $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
        }

        // currency
        $this->currency->setupEditAttributes();
        $this->currency->EditValue = $this->currency->CurrentValue;
        $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

        // date
        $this->date->setupEditAttributes();
        $this->date->EditValue = FormatDateTime($this->date->CurrentValue, $this->date->formatPattern());
        $this->date->PlaceHolder = RemoveHtml($this->date->caption());

        // reference
        $this->reference->setupEditAttributes();
        $this->reference->EditValue = $this->reference->CurrentValue;
        $this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

        // date_of_dispatch
        $this->date_of_dispatch->setupEditAttributes();
        $this->date_of_dispatch->EditValue = FormatDateTime($this->date_of_dispatch->CurrentValue, $this->date_of_dispatch->formatPattern());
        $this->date_of_dispatch->PlaceHolder = RemoveHtml($this->date_of_dispatch->caption());

        // port_eta
        $this->port_eta->setupEditAttributes();
        $this->port_eta->EditValue = FormatDateTime($this->port_eta->CurrentValue, $this->port_eta->formatPattern());
        $this->port_eta->PlaceHolder = RemoveHtml($this->port_eta->caption());

        // bl_no
        $this->bl_no->setupEditAttributes();
        if (!$this->bl_no->Raw) {
            $this->bl_no->CurrentValue = HtmlDecode($this->bl_no->CurrentValue);
        }
        $this->bl_no->EditValue = $this->bl_no->CurrentValue;
        $this->bl_no->PlaceHolder = RemoveHtml($this->bl_no->caption());

        // s_line
        $this->s_line->setupEditAttributes();
        $this->s_line->PlaceHolder = RemoveHtml($this->s_line->caption());

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->EditValue = $this->company_id->CurrentValue;
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // operator

        // datetime

        // fibc
        $this->fibc->setupEditAttributes();
        $this->fibc->EditValue = $this->fibc->CurrentValue;
        $this->fibc->PlaceHolder = RemoveHtml($this->fibc->caption());

        // ref
        $this->ref->setupEditAttributes();
        if ($this->ref->getSessionValue() != "") {
            $this->ref->CurrentValue = GetForeignKeyValue($this->ref->getSessionValue());
            $this->ref->ViewValue = $this->ref->CurrentValue;
        } else {
            if (!$this->ref->Raw) {
                $this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
            }
            $this->ref->EditValue = $this->ref->CurrentValue;
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->supplier);
                    $doc->exportCaption($this->confirm_type);
                    $doc->exportCaption($this->booking_ref);
                    $doc->exportCaption($this->approx_qty);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->currency);
                    $doc->exportCaption($this->date);
                    $doc->exportCaption($this->reference);
                    $doc->exportCaption($this->date_of_dispatch);
                    $doc->exportCaption($this->port_eta);
                    $doc->exportCaption($this->bl_no);
                    $doc->exportCaption($this->s_line);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->ref);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->supplier);
                    $doc->exportCaption($this->confirm_type);
                    $doc->exportCaption($this->booking_ref);
                    $doc->exportCaption($this->approx_qty);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->currency);
                    $doc->exportCaption($this->date);
                    $doc->exportCaption($this->reference);
                    $doc->exportCaption($this->date_of_dispatch);
                    $doc->exportCaption($this->port_eta);
                    $doc->exportCaption($this->bl_no);
                    $doc->exportCaption($this->s_line);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->ref);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->supplier);
                        $doc->exportField($this->confirm_type);
                        $doc->exportField($this->booking_ref);
                        $doc->exportField($this->approx_qty);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->currency);
                        $doc->exportField($this->date);
                        $doc->exportField($this->reference);
                        $doc->exportField($this->date_of_dispatch);
                        $doc->exportField($this->port_eta);
                        $doc->exportField($this->bl_no);
                        $doc->exportField($this->s_line);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->ref);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->supplier);
                        $doc->exportField($this->confirm_type);
                        $doc->exportField($this->booking_ref);
                        $doc->exportField($this->approx_qty);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->currency);
                        $doc->exportField($this->date);
                        $doc->exportField($this->reference);
                        $doc->exportField($this->date_of_dispatch);
                        $doc->exportField($this->port_eta);
                        $doc->exportField($this->bl_no);
                        $doc->exportField($this->s_line);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->ref);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
