<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BookingAdd extends Booking
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BookingAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "bookingadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->booking_by->setVisibility();
        $this->company_id->setVisibility();
        $this->supplier->setVisibility();
        $this->ref->setVisibility();
        $this->status->Visible = false;
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->agent->setVisibility();
        $this->quantity->setVisibility();
        $this->b_quantity->Visible = false;
        $this->confirm_quantity->Visible = false;
        $this->containers->setVisibility();
        $this->booking_rate->setVisibility();
        $this->booking_currency->setVisibility();
        $this->currency_current_rate->setVisibility();
        $this->booking_date->setVisibility();
        $this->shipment_date->setVisibility();
        $this->our_port->setVisibility();
        $this->remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->base_entry->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'booking';
        $this->TableName = 'booking';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (booking)
        if (!isset($GLOBALS["booking"]) || $GLOBALS["booking"]::class == PROJECT_NAMESPACE . "booking") {
            $GLOBALS["booking"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'booking');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "bookingview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->supplier);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->agent);
        $this->setupLookupOptions($this->booking_currency);
        $this->setupLookupOptions($this->our_port);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->base_entry);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Set up master/detail parameters
        // NOTE: Must be after loadOldRecord to prevent master key values being overwritten
        $this->setupMasterParms();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("bookinglist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "bookinglist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "bookingview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions && !$this->getCurrentMasterTable()) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "bookinglist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "bookinglist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->company_id->DefaultValue = $this->company_id->getDefault(); // PHP
        $this->company_id->OldValue = $this->company_id->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'booking_by' first before field var 'x_booking_by'
        $val = $CurrentForm->hasValue("booking_by") ? $CurrentForm->getValue("booking_by") : $CurrentForm->getValue("x_booking_by");
        if (!$this->booking_by->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->booking_by->Visible = false; // Disable update for API request
            } else {
                $this->booking_by->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'supplier' first before field var 'x_supplier'
        $val = $CurrentForm->hasValue("supplier") ? $CurrentForm->getValue("supplier") : $CurrentForm->getValue("x_supplier");
        if (!$this->supplier->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->supplier->Visible = false; // Disable update for API request
            } else {
                $this->supplier->setFormValue($val);
            }
        }

        // Check field name 'ref' first before field var 'x_ref'
        $val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
        if (!$this->ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ref->Visible = false; // Disable update for API request
            } else {
                $this->ref->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }

        // Check field name 'agent' first before field var 'x_agent'
        $val = $CurrentForm->hasValue("agent") ? $CurrentForm->getValue("agent") : $CurrentForm->getValue("x_agent");
        if (!$this->agent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->agent->Visible = false; // Disable update for API request
            } else {
                $this->agent->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'containers' first before field var 'x_containers'
        $val = $CurrentForm->hasValue("containers") ? $CurrentForm->getValue("containers") : $CurrentForm->getValue("x_containers");
        if (!$this->containers->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->containers->Visible = false; // Disable update for API request
            } else {
                $this->containers->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'booking_rate' first before field var 'x_booking_rate'
        $val = $CurrentForm->hasValue("booking_rate") ? $CurrentForm->getValue("booking_rate") : $CurrentForm->getValue("x_booking_rate");
        if (!$this->booking_rate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->booking_rate->Visible = false; // Disable update for API request
            } else {
                $this->booking_rate->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'booking_currency' first before field var 'x_booking_currency'
        $val = $CurrentForm->hasValue("booking_currency") ? $CurrentForm->getValue("booking_currency") : $CurrentForm->getValue("x_booking_currency");
        if (!$this->booking_currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->booking_currency->Visible = false; // Disable update for API request
            } else {
                $this->booking_currency->setFormValue($val);
            }
        }

        // Check field name 'currency_current_rate' first before field var 'x_currency_current_rate'
        $val = $CurrentForm->hasValue("currency_current_rate") ? $CurrentForm->getValue("currency_current_rate") : $CurrentForm->getValue("x_currency_current_rate");
        if (!$this->currency_current_rate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency_current_rate->Visible = false; // Disable update for API request
            } else {
                $this->currency_current_rate->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'booking_date' first before field var 'x_booking_date'
        $val = $CurrentForm->hasValue("booking_date") ? $CurrentForm->getValue("booking_date") : $CurrentForm->getValue("x_booking_date");
        if (!$this->booking_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->booking_date->Visible = false; // Disable update for API request
            } else {
                $this->booking_date->setFormValue($val, true, $validate);
            }
            $this->booking_date->CurrentValue = UnFormatDateTime($this->booking_date->CurrentValue, $this->booking_date->formatPattern());
        }

        // Check field name 'shipment_date' first before field var 'x_shipment_date'
        $val = $CurrentForm->hasValue("shipment_date") ? $CurrentForm->getValue("shipment_date") : $CurrentForm->getValue("x_shipment_date");
        if (!$this->shipment_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shipment_date->Visible = false; // Disable update for API request
            } else {
                $this->shipment_date->setFormValue($val, true, $validate);
            }
            $this->shipment_date->CurrentValue = UnFormatDateTime($this->shipment_date->CurrentValue, $this->shipment_date->formatPattern());
        }

        // Check field name 'our_port' first before field var 'x_our_port'
        $val = $CurrentForm->hasValue("our_port") ? $CurrentForm->getValue("our_port") : $CurrentForm->getValue("x_our_port");
        if (!$this->our_port->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->our_port->Visible = false; // Disable update for API request
            } else {
                $this->our_port->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->booking_by->CurrentValue = $this->booking_by->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->supplier->CurrentValue = $this->supplier->FormValue;
        $this->ref->CurrentValue = $this->ref->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->agent->CurrentValue = $this->agent->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->containers->CurrentValue = $this->containers->FormValue;
        $this->booking_rate->CurrentValue = $this->booking_rate->FormValue;
        $this->booking_currency->CurrentValue = $this->booking_currency->FormValue;
        $this->currency_current_rate->CurrentValue = $this->currency_current_rate->FormValue;
        $this->booking_date->CurrentValue = $this->booking_date->FormValue;
        $this->booking_date->CurrentValue = UnFormatDateTime($this->booking_date->CurrentValue, $this->booking_date->formatPattern());
        $this->shipment_date->CurrentValue = $this->shipment_date->FormValue;
        $this->shipment_date->CurrentValue = UnFormatDateTime($this->shipment_date->CurrentValue, $this->shipment_date->formatPattern());
        $this->our_port->CurrentValue = $this->our_port->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->booking_by->setDbValue($row['booking_by']);
        $this->company_id->setDbValue($row['company_id']);
        $this->supplier->setDbValue($row['supplier']);
        $this->ref->setDbValue($row['ref']);
        $this->status->setDbValue($row['status']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->agent->setDbValue($row['agent']);
        $this->quantity->setDbValue($row['quantity']);
        $this->b_quantity->setDbValue($row['b_quantity']);
        $this->confirm_quantity->setDbValue($row['confirm_quantity']);
        $this->containers->setDbValue($row['containers']);
        $this->booking_rate->setDbValue($row['booking_rate']);
        $this->booking_currency->setDbValue($row['booking_currency']);
        $this->currency_current_rate->setDbValue($row['currency_current_rate']);
        $this->booking_date->setDbValue($row['booking_date']);
        $this->shipment_date->setDbValue($row['shipment_date']);
        $this->our_port->setDbValue($row['our_port']);
        $this->remarks->setDbValue($row['remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->base_entry->setDbValue($row['base_entry']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['booking_by'] = $this->booking_by->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['supplier'] = $this->supplier->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['agent'] = $this->agent->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['b_quantity'] = $this->b_quantity->DefaultValue;
        $row['confirm_quantity'] = $this->confirm_quantity->DefaultValue;
        $row['containers'] = $this->containers->DefaultValue;
        $row['booking_rate'] = $this->booking_rate->DefaultValue;
        $row['booking_currency'] = $this->booking_currency->DefaultValue;
        $row['currency_current_rate'] = $this->currency_current_rate->DefaultValue;
        $row['booking_date'] = $this->booking_date->DefaultValue;
        $row['shipment_date'] = $this->shipment_date->DefaultValue;
        $row['our_port'] = $this->our_port->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['base_entry'] = $this->base_entry->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // booking_by
        $this->booking_by->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // supplier
        $this->supplier->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // b_quantity
        $this->b_quantity->RowCssClass = "row";

        // confirm_quantity
        $this->confirm_quantity->RowCssClass = "row";

        // containers
        $this->containers->RowCssClass = "row";

        // booking_rate
        $this->booking_rate->RowCssClass = "row";

        // booking_currency
        $this->booking_currency->RowCssClass = "row";

        // currency_current_rate
        $this->currency_current_rate->RowCssClass = "row";

        // booking_date
        $this->booking_date->RowCssClass = "row";

        // shipment_date
        $this->shipment_date->RowCssClass = "row";

        // our_port
        $this->our_port->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // base_entry
        $this->base_entry->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // booking_by
            $this->booking_by->ViewValue = $this->booking_by->CurrentValue;
            $this->booking_by->ViewValue = FormatNumber($this->booking_by->ViewValue, $this->booking_by->formatPattern());

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // supplier
            $curVal = strval($this->supplier->CurrentValue);
            if ($curVal != "") {
                $this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
                if ($this->supplier->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                    $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                        $this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
                    } else {
                        $this->supplier->ViewValue = $this->supplier->CurrentValue;
                    }
                }
            } else {
                $this->supplier->ViewValue = null;
            }

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // agent
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->ViewValue = $this->agent->CurrentValue;
                    }
                }
            } else {
                $this->agent->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // b_quantity
            $this->b_quantity->ViewValue = $this->b_quantity->CurrentValue;
            $this->b_quantity->ViewValue = FormatNumber($this->b_quantity->ViewValue, $this->b_quantity->formatPattern());
            $this->b_quantity->CssClass = "fw-bold";

            // confirm_quantity
            $this->confirm_quantity->ViewValue = $this->confirm_quantity->CurrentValue;
            $this->confirm_quantity->ViewValue = FormatNumber($this->confirm_quantity->ViewValue, $this->confirm_quantity->formatPattern());

            // containers
            $this->containers->ViewValue = $this->containers->CurrentValue;
            $this->containers->ViewValue = FormatNumber($this->containers->ViewValue, $this->containers->formatPattern());

            // booking_rate
            $this->booking_rate->ViewValue = $this->booking_rate->CurrentValue;
            $this->booking_rate->ViewValue = FormatNumber($this->booking_rate->ViewValue, $this->booking_rate->formatPattern());

            // booking_currency
            $curVal = strval($this->booking_currency->CurrentValue);
            if ($curVal != "") {
                $this->booking_currency->ViewValue = $this->booking_currency->lookupCacheOption($curVal);
                if ($this->booking_currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->booking_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->booking_currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->booking_currency->Lookup->renderViewRow($rswrk[0]);
                        $this->booking_currency->ViewValue = $this->booking_currency->displayValue($arwrk);
                    } else {
                        $this->booking_currency->ViewValue = $this->booking_currency->CurrentValue;
                    }
                }
            } else {
                $this->booking_currency->ViewValue = null;
            }

            // currency_current_rate
            $this->currency_current_rate->ViewValue = $this->currency_current_rate->CurrentValue;
            $this->currency_current_rate->ViewValue = FormatNumber($this->currency_current_rate->ViewValue, $this->currency_current_rate->formatPattern());

            // booking_date
            $this->booking_date->ViewValue = $this->booking_date->CurrentValue;
            $this->booking_date->ViewValue = FormatDateTime($this->booking_date->ViewValue, $this->booking_date->formatPattern());

            // shipment_date
            $this->shipment_date->ViewValue = $this->shipment_date->CurrentValue;
            $this->shipment_date->ViewValue = FormatDateTime($this->shipment_date->ViewValue, $this->shipment_date->formatPattern());

            // our_port
            $curVal = strval($this->our_port->CurrentValue);
            if ($curVal != "") {
                $this->our_port->ViewValue = $this->our_port->lookupCacheOption($curVal);
                if ($this->our_port->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->our_port->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->our_port->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->our_port->getSelectFilter($this); // PHP
                    $sqlWrk = $this->our_port->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->our_port->Lookup->renderViewRow($rswrk[0]);
                        $this->our_port->ViewValue = $this->our_port->displayValue($arwrk);
                    } else {
                        $this->our_port->ViewValue = $this->our_port->CurrentValue;
                    }
                }
            } else {
                $this->our_port->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // booking_by
            $this->booking_by->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // supplier
            $this->supplier->HrefValue = "";

            // ref
            $this->ref->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_parent"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }

            // agent
            if (!EmptyValue($this->agent->CurrentValue)) {
                $this->agent->HrefValue = $this->agent->getLinkPrefix() . $this->agent->CurrentValue; // Add prefix/suffix
                $this->agent->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->agent->HrefValue = FullUrl($this->agent->HrefValue, "href");
                }
            } else {
                $this->agent->HrefValue = "";
            }

            // quantity
            $this->quantity->HrefValue = "";

            // containers
            $this->containers->HrefValue = "";

            // booking_rate
            $this->booking_rate->HrefValue = "";

            // booking_currency
            $this->booking_currency->HrefValue = "";

            // currency_current_rate
            $this->currency_current_rate->HrefValue = "";

            // booking_date
            $this->booking_date->HrefValue = "";

            // shipment_date
            $this->shipment_date->HrefValue = "";

            // our_port
            $this->our_port->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // booking_by
            $this->booking_by->setupEditAttributes();
            $this->booking_by->EditValue = $this->booking_by->CurrentValue;
            $this->booking_by->PlaceHolder = RemoveHtml($this->booking_by->caption());
            if (strval($this->booking_by->EditValue) != "" && is_numeric($this->booking_by->EditValue)) {
                $this->booking_by->EditValue = FormatNumber($this->booking_by->EditValue, null);
            }

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->CurrentValue));
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->CurrentValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // supplier
            $this->supplier->setupEditAttributes();
            $curVal = trim(strval($this->supplier->CurrentValue));
            if ($curVal != "") {
                $this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
            } else {
                $this->supplier->ViewValue = $this->supplier->Lookup !== null && is_array($this->supplier->lookupOptions()) && count($this->supplier->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->supplier->ViewValue !== null) { // Load from cache
                $this->supplier->EditValue = array_values($this->supplier->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->supplier->CurrentValue, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                $sqlWrk = $this->supplier->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->supplier->EditValue = $arwrk;
            }
            $this->supplier->PlaceHolder = RemoveHtml($this->supplier->caption());

            // ref
            $this->ref->setupEditAttributes();
            if ($this->ref->getSessionValue() != "") {
                $this->ref->CurrentValue = GetForeignKeyValue($this->ref->getSessionValue());
                $this->ref->ViewValue = $this->ref->CurrentValue;
            } else {
                if (!$this->ref->Raw) {
                    $this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
                }
                $this->ref->EditValue = HtmlEncode($this->ref->CurrentValue);
                $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());
            }

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $this->rid->setupEditAttributes();
            $curVal = trim(strval($this->rid->CurrentValue));
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
            } else {
                $this->rid->ViewValue = $this->rid->Lookup !== null && is_array($this->rid->lookupOptions()) && count($this->rid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid->ViewValue !== null) { // Load from cache
                $this->rid->EditValue = array_values($this->rid->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid->CurrentValue, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->rid->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->rid->EditValue = $arwrk;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // agent
            $this->agent->setupEditAttributes();
            $curVal = trim(strval($this->agent->CurrentValue));
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
            } else {
                $this->agent->ViewValue = $this->agent->Lookup !== null && is_array($this->agent->lookupOptions()) && count($this->agent->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->agent->ViewValue !== null) { // Load from cache
                $this->agent->EditValue = array_values($this->agent->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->agent->CurrentValue, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                $sqlWrk = $this->agent->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->agent->EditValue = $arwrk;
            }
            $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // containers
            $this->containers->setupEditAttributes();
            $this->containers->EditValue = $this->containers->CurrentValue;
            $this->containers->PlaceHolder = RemoveHtml($this->containers->caption());
            if (strval($this->containers->EditValue) != "" && is_numeric($this->containers->EditValue)) {
                $this->containers->EditValue = FormatNumber($this->containers->EditValue, null);
            }

            // booking_rate
            $this->booking_rate->setupEditAttributes();
            $this->booking_rate->EditValue = $this->booking_rate->CurrentValue;
            $this->booking_rate->PlaceHolder = RemoveHtml($this->booking_rate->caption());
            if (strval($this->booking_rate->EditValue) != "" && is_numeric($this->booking_rate->EditValue)) {
                $this->booking_rate->EditValue = FormatNumber($this->booking_rate->EditValue, null);
            }

            // booking_currency
            $this->booking_currency->setupEditAttributes();
            $curVal = trim(strval($this->booking_currency->CurrentValue));
            if ($curVal != "") {
                $this->booking_currency->ViewValue = $this->booking_currency->lookupCacheOption($curVal);
            } else {
                $this->booking_currency->ViewValue = $this->booking_currency->Lookup !== null && is_array($this->booking_currency->lookupOptions()) && count($this->booking_currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->booking_currency->ViewValue !== null) { // Load from cache
                $this->booking_currency->EditValue = array_values($this->booking_currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->booking_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->booking_currency->CurrentValue, $this->booking_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->booking_currency->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->booking_currency->EditValue = $arwrk;
            }
            $this->booking_currency->PlaceHolder = RemoveHtml($this->booking_currency->caption());

            // currency_current_rate
            $this->currency_current_rate->setupEditAttributes();
            $this->currency_current_rate->EditValue = $this->currency_current_rate->CurrentValue;
            $this->currency_current_rate->PlaceHolder = RemoveHtml($this->currency_current_rate->caption());
            if (strval($this->currency_current_rate->EditValue) != "" && is_numeric($this->currency_current_rate->EditValue)) {
                $this->currency_current_rate->EditValue = FormatNumber($this->currency_current_rate->EditValue, null);
            }

            // booking_date
            $this->booking_date->setupEditAttributes();
            $this->booking_date->EditValue = HtmlEncode(FormatDateTime($this->booking_date->CurrentValue, $this->booking_date->formatPattern()));
            $this->booking_date->PlaceHolder = RemoveHtml($this->booking_date->caption());

            // shipment_date
            $this->shipment_date->setupEditAttributes();
            $this->shipment_date->EditValue = HtmlEncode(FormatDateTime($this->shipment_date->CurrentValue, $this->shipment_date->formatPattern()));
            $this->shipment_date->PlaceHolder = RemoveHtml($this->shipment_date->caption());

            // our_port
            $this->our_port->setupEditAttributes();
            $curVal = trim(strval($this->our_port->CurrentValue));
            if ($curVal != "") {
                $this->our_port->ViewValue = $this->our_port->lookupCacheOption($curVal);
            } else {
                $this->our_port->ViewValue = $this->our_port->Lookup !== null && is_array($this->our_port->lookupOptions()) && count($this->our_port->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->our_port->ViewValue !== null) { // Load from cache
                $this->our_port->EditValue = array_values($this->our_port->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->our_port->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->our_port->CurrentValue, $this->our_port->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->our_port->getSelectFilter($this); // PHP
                $sqlWrk = $this->our_port->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->our_port->EditValue = $arwrk;
            }
            $this->our_port->PlaceHolder = RemoveHtml($this->our_port->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // operator

            // datetime

            // Add refer script

            // booking_by
            $this->booking_by->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // supplier
            $this->supplier->HrefValue = "";

            // ref
            $this->ref->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_parent"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }

            // agent
            if (!EmptyValue($this->agent->CurrentValue)) {
                $this->agent->HrefValue = $this->agent->getLinkPrefix() . $this->agent->CurrentValue; // Add prefix/suffix
                $this->agent->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->agent->HrefValue = FullUrl($this->agent->HrefValue, "href");
                }
            } else {
                $this->agent->HrefValue = "";
            }

            // quantity
            $this->quantity->HrefValue = "";

            // containers
            $this->containers->HrefValue = "";

            // booking_rate
            $this->booking_rate->HrefValue = "";

            // booking_currency
            $this->booking_currency->HrefValue = "";

            // currency_current_rate
            $this->currency_current_rate->HrefValue = "";

            // booking_date
            $this->booking_date->HrefValue = "";

            // shipment_date
            $this->shipment_date->HrefValue = "";

            // our_port
            $this->our_port->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->booking_by->Visible && $this->booking_by->Required) {
                if (!$this->booking_by->IsDetailKey && EmptyValue($this->booking_by->FormValue)) {
                    $this->booking_by->addErrorMessage(str_replace("%s", $this->booking_by->caption(), $this->booking_by->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->booking_by->FormValue)) {
                $this->booking_by->addErrorMessage($this->booking_by->getErrorMessage(false));
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->supplier->Visible && $this->supplier->Required) {
                if (!$this->supplier->IsDetailKey && EmptyValue($this->supplier->FormValue)) {
                    $this->supplier->addErrorMessage(str_replace("%s", $this->supplier->caption(), $this->supplier->RequiredErrorMessage));
                }
            }
            if ($this->ref->Visible && $this->ref->Required) {
                if (!$this->ref->IsDetailKey && EmptyValue($this->ref->FormValue)) {
                    $this->ref->addErrorMessage(str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->agent->Visible && $this->agent->Required) {
                if (!$this->agent->IsDetailKey && EmptyValue($this->agent->FormValue)) {
                    $this->agent->addErrorMessage(str_replace("%s", $this->agent->caption(), $this->agent->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->containers->Visible && $this->containers->Required) {
                if (!$this->containers->IsDetailKey && EmptyValue($this->containers->FormValue)) {
                    $this->containers->addErrorMessage(str_replace("%s", $this->containers->caption(), $this->containers->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->containers->FormValue)) {
                $this->containers->addErrorMessage($this->containers->getErrorMessage(false));
            }
            if ($this->booking_rate->Visible && $this->booking_rate->Required) {
                if (!$this->booking_rate->IsDetailKey && EmptyValue($this->booking_rate->FormValue)) {
                    $this->booking_rate->addErrorMessage(str_replace("%s", $this->booking_rate->caption(), $this->booking_rate->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->booking_rate->FormValue)) {
                $this->booking_rate->addErrorMessage($this->booking_rate->getErrorMessage(false));
            }
            if ($this->booking_currency->Visible && $this->booking_currency->Required) {
                if (!$this->booking_currency->IsDetailKey && EmptyValue($this->booking_currency->FormValue)) {
                    $this->booking_currency->addErrorMessage(str_replace("%s", $this->booking_currency->caption(), $this->booking_currency->RequiredErrorMessage));
                }
            }
            if ($this->currency_current_rate->Visible && $this->currency_current_rate->Required) {
                if (!$this->currency_current_rate->IsDetailKey && EmptyValue($this->currency_current_rate->FormValue)) {
                    $this->currency_current_rate->addErrorMessage(str_replace("%s", $this->currency_current_rate->caption(), $this->currency_current_rate->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->currency_current_rate->FormValue)) {
                $this->currency_current_rate->addErrorMessage($this->currency_current_rate->getErrorMessage(false));
            }
            if ($this->booking_date->Visible && $this->booking_date->Required) {
                if (!$this->booking_date->IsDetailKey && EmptyValue($this->booking_date->FormValue)) {
                    $this->booking_date->addErrorMessage(str_replace("%s", $this->booking_date->caption(), $this->booking_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->booking_date->FormValue, $this->booking_date->formatPattern())) {
                $this->booking_date->addErrorMessage($this->booking_date->getErrorMessage(false));
            }
            if ($this->shipment_date->Visible && $this->shipment_date->Required) {
                if (!$this->shipment_date->IsDetailKey && EmptyValue($this->shipment_date->FormValue)) {
                    $this->shipment_date->addErrorMessage(str_replace("%s", $this->shipment_date->caption(), $this->shipment_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->shipment_date->FormValue, $this->shipment_date->formatPattern())) {
                $this->shipment_date->addErrorMessage($this->shipment_date->getErrorMessage(false));
            }
            if ($this->our_port->Visible && $this->our_port->Required) {
                if (!$this->our_port->IsDetailKey && EmptyValue($this->our_port->FormValue)) {
                    $this->our_port->addErrorMessage(str_replace("%s", $this->our_port->caption(), $this->our_port->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // booking_by
        $this->booking_by->setDbValueDef($rsnew, $this->booking_by->CurrentValue, false);

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, strval($this->company_id->CurrentValue) == "");

        // supplier
        $this->supplier->setDbValueDef($rsnew, $this->supplier->CurrentValue, false);

        // ref
        $this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, false);

        // agent
        $this->agent->setDbValueDef($rsnew, $this->agent->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // containers
        $this->containers->setDbValueDef($rsnew, $this->containers->CurrentValue, false);

        // booking_rate
        $this->booking_rate->setDbValueDef($rsnew, $this->booking_rate->CurrentValue, false);

        // booking_currency
        $this->booking_currency->setDbValueDef($rsnew, $this->booking_currency->CurrentValue, false);

        // currency_current_rate
        $this->currency_current_rate->setDbValueDef($rsnew, $this->currency_current_rate->CurrentValue, false);

        // booking_date
        $this->booking_date->setDbValueDef($rsnew, UnFormatDateTime($this->booking_date->CurrentValue, $this->booking_date->formatPattern()), false);

        // shipment_date
        $this->shipment_date->setDbValueDef($rsnew, UnFormatDateTime($this->shipment_date->CurrentValue, $this->shipment_date->formatPattern()), false);

        // our_port
        $this->our_port->setDbValueDef($rsnew, $this->our_port->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['booking_by'])) { // booking_by
            $this->booking_by->setFormValue($row['booking_by']);
        }
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
        if (isset($row['supplier'])) { // supplier
            $this->supplier->setFormValue($row['supplier']);
        }
        if (isset($row['ref'])) { // ref
            $this->ref->setFormValue($row['ref']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['rid'])) { // rid
            $this->rid->setFormValue($row['rid']);
        }
        if (isset($row['agent'])) { // agent
            $this->agent->setFormValue($row['agent']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['containers'])) { // containers
            $this->containers->setFormValue($row['containers']);
        }
        if (isset($row['booking_rate'])) { // booking_rate
            $this->booking_rate->setFormValue($row['booking_rate']);
        }
        if (isset($row['booking_currency'])) { // booking_currency
            $this->booking_currency->setFormValue($row['booking_currency']);
        }
        if (isset($row['currency_current_rate'])) { // currency_current_rate
            $this->currency_current_rate->setFormValue($row['currency_current_rate']);
        }
        if (isset($row['booking_date'])) { // booking_date
            $this->booking_date->setFormValue($row['booking_date']);
        }
        if (isset($row['shipment_date'])) { // shipment_date
            $this->shipment_date->setFormValue($row['shipment_date']);
        }
        if (isset($row['our_port'])) { // our_port
            $this->our_port->setFormValue($row['our_port']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "booking_details") {
                $validMaster = true;
                $masterTbl = Container("booking_details");
                if (($parm = Get("fk_ref", Get("ref"))) !== null) {
                    $masterTbl->ref->setQueryStringValue($parm);
                    $this->ref->QueryStringValue = $masterTbl->ref->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->ref->setSessionValue($this->ref->QueryStringValue);
                    $foreignKeys["ref"] = $this->ref->QueryStringValue;
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "booking_details") {
                $validMaster = true;
                $masterTbl = Container("booking_details");
                if (($parm = Post("fk_ref", Post("ref"))) !== null) {
                    $masterTbl->ref->setFormValue($parm);
                    $this->ref->FormValue = $masterTbl->ref->FormValue;
                    $this->ref->setSessionValue($this->ref->FormValue);
                    $foreignKeys["ref"] = $this->ref->FormValue;
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "booking_details") {
                if (!array_key_exists("ref", $foreignKeys)) { // Not current foreign key
                    $this->ref->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bookinglist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_supplier":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_booking_currency":
                    break;
                case "x_our_port":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_base_entry":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
