<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BomList extends Bom
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BomList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fbomlist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "bomlist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->warp_weft->setVisibility();
        $this->m_grp->setVisibility();
        $this->m_sgrp->setVisibility();
        $this->m_product->setVisibility();
        $this->m_rid->setVisibility();
        $this->m_packing->setVisibility();
        $this->m_name->Visible = false;
        $this->quantity_a->setVisibility();
        $this->bom_waste->setVisibility();
        $this->quantity->Visible = false;
        $this->method->setVisibility();
        $this->unit->setVisibility();
        $this->gross_nett->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->packing_type->setVisibility();
        $this->batch_no->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->a_operator->Visible = false;
        $this->a_datetime->Visible = false;
        $this->pp_qty->Visible = false;
        $this->pp_bal->Visible = false;
        $this->pp_id->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'bom';
        $this->TableName = 'bom';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (bom)
        if (!isset($GLOBALS["bom"]) || $GLOBALS["bom"]::class == PROJECT_NAMESPACE . "bom") {
            $GLOBALS["bom"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "bomadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "bomdelete";
        $this->MultiUpdateUrl = "bomupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'bom');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "bomview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->warp_weft);
        $this->setupLookupOptions($this->m_grp);
        $this->setupLookupOptions($this->m_sgrp);
        $this->setupLookupOptions($this->m_product);
        $this->setupLookupOptions($this->m_rid);
        $this->setupLookupOptions($this->m_packing);
        $this->setupLookupOptions($this->method);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->gross_nett);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->a_operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fbomgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Check QueryString parameters
        if (Get("action") !== null) {
            $this->CurrentAction = Get("action");
        } else {
            if (Post("action") !== null && Post("action") !== $this->UserAction) {
                $this->CurrentAction = Post("action"); // Get action
            } elseif (Session(SESSION_INLINE_MODE) == "gridedit") { // Previously in grid edit mode
                if (Get(Config("TABLE_START_REC")) !== null || Get(Config("TABLE_PAGE_NUMBER")) !== null) { // Stay in grid edit mode if paging
                    $this->gridEditMode();
                } else { // Reset grid edit
                    $this->clearInlineMode();
                }
            }
        }

        // Clear inline mode
        if ($this->isCancel()) {
            $this->clearInlineMode();
        }

        // Switch to grid edit mode
        if ($this->isGridEdit()) {
            $this->gridEditMode();
        }

        // Grid Update
        if (IsPost() && ($this->isGridUpdate() || $this->isMultiUpdate() || $this->isGridOverwrite()) && (Session(SESSION_INLINE_MODE) == "gridedit" || Session(SESSION_INLINE_MODE) == "multiedit")) {
            if ($this->validateGridForm()) {
                $gridUpdate = $this->gridUpdate();
            } else {
                $gridUpdate = false;
            }
            if ($gridUpdate) {
                // Handle modal grid edit and multi edit, redirect to list page directly
                if ($this->IsModal && !$this->UseAjaxActions) {
                    $this->terminate("bomlist");
                    return;
                }
            } else {
                $this->EventCancelled = true;
                if ($this->UseAjaxActions) {
                    WriteJson([
                        "success" => false,
                        "validation" => $this->ValidationErrors,
                        "error" => $this->getFailureMessage()
                    ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->isMultiUpdate()) { // Stay in Multi-Edit mode
                    $this->FilterForModalActions = $this->getFilterFromRecords($this->getGridFormValues());
                    $this->multiEditMode();
                } else { // Stay in grid edit mode
                    $this->gridEditMode();
                }
            }
        }

        // Switch to grid add mode
        if ($this->isGridAdd()) {
            $this->gridAddMode();
            // Grid Insert
        } elseif (IsPost() && $this->isGridInsert() && Session(SESSION_INLINE_MODE) == "gridadd") {
            if ($this->validateGridForm()) {
                $gridInsert = $this->gridInsert();
            } else {
                $gridInsert = false;
            }
            if ($gridInsert) {
                // Handle modal grid add, redirect to list page directly
                if ($this->IsModal && !$this->UseAjaxActions) {
                    $this->terminate("bomlist");
                    return;
                }
            } else {
                $this->EventCancelled = true;
                if ($this->UseAjaxActions) {
                    WriteJson([
                        "success" => false,
                        "validation" => $this->ValidationErrors,
                        "error" => $this->getFailureMessage()
                    ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                $this->gridAddMode(); // Stay in grid add mode
            }
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Show grid delete link for grid add / grid edit
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $item = $this->ListOptions["griddelete"];
                if ($item) {
                    $item->Visible = $Security->allowDelete(CurrentProjectID() . $this->TableName);
                }
            }
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }

            // Audit trail on search
            if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
                $searchParm = ServerVar("QUERY_STRING");
                $searchSql = $this->getSessionWhere();
                $this->writeAuditTrailOnSearch($searchParm, $searchSql);
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Exit inline mode
    protected function clearInlineMode()
    {
        $this->quantity_a->FormValue = ""; // Clear form value
        $this->bom_waste->FormValue = ""; // Clear form value
        $this->LastAction = $this->CurrentAction; // Save last action
        $this->CurrentAction = ""; // Clear action
        $_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
    }

    // Switch to grid add mode
    protected function gridAddMode()
    {
        $this->CurrentAction = "gridadd";
        $_SESSION[SESSION_INLINE_MODE] = "gridadd";
        $this->hideFieldsForAddEdit();
    }

    // Switch to grid edit mode
    protected function gridEditMode()
    {
        $this->CurrentAction = "gridedit";
        $_SESSION[SESSION_INLINE_MODE] = "gridedit";
        $this->hideFieldsForAddEdit();
    }

    // Perform update to grid
    public function gridUpdate()
    {
        global $Language, $CurrentForm;
        $gridUpdate = true;

        // Get old result set
        $this->CurrentFilter = $this->buildKeyFilter();
        if ($this->CurrentFilter == "") {
            $this->CurrentFilter = "0=1";
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        if ($rs = $conn->executeQuery($sql)) {
            $rsold = $rs->fetchAllAssociative();
        }

        // Call Grid Updating event
        if (!$this->gridUpdating($rsold)) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }

        // Begin transaction
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->AuditTrailOnEdit) {
            $this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin
        }
        $wrkfilter = "";
        $key = "";

        // Update row index and get row key
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Update all rows based on key
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            $CurrentForm->Index = $rowindex;
            $this->setKey($CurrentForm->getValue($this->OldKeyName));
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));

            // Load all values and keys
            if ($rowaction != "insertdelete" && $rowaction != "hide") { // Skip insert then deleted rows / hidden rows for grid edit
                $this->loadFormValues(); // Get form values
                if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
                    $gridUpdate = $this->OldKey != ""; // Key must not be empty
                } else {
                    $gridUpdate = true;
                }

                // Skip empty row
                if ($rowaction == "insert" && $this->emptyRow()) {
                // Validate form and insert/update/delete record
                } elseif ($gridUpdate) {
                    if ($rowaction == "delete") {
                        $this->CurrentFilter = $this->getRecordFilter();
                        $gridUpdate = $this->deleteRows(); // Delete this row
                    } else {
                        if ($rowaction == "insert") {
                            $gridUpdate = $this->addRow(); // Insert this row
                        } else {
                            if ($this->OldKey != "") {
                                $this->SendEmail = false; // Do not send email on update success
                                $gridUpdate = $this->editRow(); // Update this row
                            }
                        } // End update
                        if ($gridUpdate) { // Get inserted or updated filter
                            AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                        }
                    }
                }
                if ($gridUpdate) {
                    if ($key != "") {
                        $key .= ", ";
                    }
                    $key .= $this->OldKey;
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($gridUpdate) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }
            $this->FilterForModalActions = $wrkfilter;

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Updated event
            $this->gridUpdated($rsold, $rsnew);
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
            }
            if ($this->getSuccessMessage() == "") {
                $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
            }
            $this->clearInlineMode(); // Clear inline edit mode
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
            }
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
            }
        }
        return $gridUpdate;
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Perform grid add
    public function gridInsert()
    {
        global $Language, $CurrentForm;
        $rowindex = 1;
        $gridInsert = false;
        $conn = $this->getConnection();

        // Call Grid Inserting event
        if (!$this->gridInserting()) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }

        // Begin transaction
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Init key filter
        $wrkfilter = "";
        $addcnt = 0;
        if ($this->AuditTrailOnAdd) {
            $this->writeAuditTrailDummy($Language->phrase("BatchInsertBegin")); // Batch insert begin
        }
        $key = "";

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Insert all rows
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "" && $rowaction != "insert") {
                continue; // Skip
            }
            $rsold = null;
            if ($rowaction == "insert") {
                $this->OldKey = strval($CurrentForm->getValue($this->OldKeyName));
                $rsold = $this->loadOldRecord(); // Load old record
            }
            $this->loadFormValues(); // Get form values
            if (!$this->emptyRow()) {
                $addcnt++;
                $this->SendEmail = false; // Do not send email on insert success
                $gridInsert = $this->addRow($rsold); // Insert row (already validated by validateGridForm())
                if ($gridInsert) {
                    if ($key != "") {
                        $key .= Config("COMPOSITE_KEY_SEPARATOR");
                    }
                    $key .= $this->id->CurrentValue;

                    // Add filter for this record
                    AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($addcnt == 0) { // No record inserted
            $this->setFailureMessage($Language->phrase("NoAddRecord"));
            $gridInsert = false;
        }
        if ($gridInsert) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Get new records
            $this->CurrentFilter = $wrkfilter;
            $this->FilterForModalActions = $wrkfilter;
            $sql = $this->getCurrentSql();
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Inserted event
            $this->gridInserted($rsnew);
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailDummy($Language->phrase("BatchInsertSuccess")); // Batch insert success
            }
            if ($this->getSuccessMessage() == "") {
                $this->setSuccessMessage($Language->phrase("InsertSuccess")); // Set up insert success message
            }
            $this->clearInlineMode(); // Clear grid add mode
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailDummy($Language->phrase("BatchInsertRollback")); // Batch insert rollback
            }
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
            }
        }
        return $gridInsert;
    }

    // Check if empty row
    public function emptyRow()
    {
        global $CurrentForm;
        if (
            $CurrentForm->hasValue("x_warp_weft") &&
            $CurrentForm->hasValue("o_warp_weft") &&
            $this->warp_weft->CurrentValue != $this->warp_weft->DefaultValue &&
            !($this->warp_weft->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->warp_weft->CurrentValue == $this->warp_weft->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_m_grp") &&
            $CurrentForm->hasValue("o_m_grp") &&
            $this->m_grp->CurrentValue != $this->m_grp->DefaultValue &&
            !($this->m_grp->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->m_grp->CurrentValue == $this->m_grp->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_m_sgrp") &&
            $CurrentForm->hasValue("o_m_sgrp") &&
            $this->m_sgrp->CurrentValue != $this->m_sgrp->DefaultValue &&
            !($this->m_sgrp->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->m_sgrp->CurrentValue == $this->m_sgrp->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_m_product") &&
            $CurrentForm->hasValue("o_m_product") &&
            $this->m_product->CurrentValue != $this->m_product->DefaultValue &&
            !($this->m_product->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->m_product->CurrentValue == $this->m_product->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_m_rid") &&
            $CurrentForm->hasValue("o_m_rid") &&
            $this->m_rid->CurrentValue != $this->m_rid->DefaultValue &&
            !($this->m_rid->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->m_rid->CurrentValue == $this->m_rid->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_m_packing") &&
            $CurrentForm->hasValue("o_m_packing") &&
            $this->m_packing->CurrentValue != $this->m_packing->DefaultValue &&
            !($this->m_packing->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->m_packing->CurrentValue == $this->m_packing->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_quantity_a") &&
            $CurrentForm->hasValue("o_quantity_a") &&
            $this->quantity_a->CurrentValue != $this->quantity_a->DefaultValue &&
            !($this->quantity_a->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->quantity_a->CurrentValue == $this->quantity_a->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_bom_waste") &&
            $CurrentForm->hasValue("o_bom_waste") &&
            $this->bom_waste->CurrentValue != $this->bom_waste->DefaultValue &&
            !($this->bom_waste->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->bom_waste->CurrentValue == $this->bom_waste->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_method") &&
            $CurrentForm->hasValue("o_method") &&
            $this->method->CurrentValue != $this->method->DefaultValue &&
            !($this->method->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->method->CurrentValue == $this->method->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_unit") &&
            $CurrentForm->hasValue("o_unit") &&
            $this->unit->CurrentValue != $this->unit->DefaultValue &&
            !($this->unit->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->unit->CurrentValue == $this->unit->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_gross_nett") &&
            $CurrentForm->hasValue("o_gross_nett") &&
            $this->gross_nett->CurrentValue != $this->gross_nett->DefaultValue &&
            !($this->gross_nett->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->gross_nett->CurrentValue == $this->gross_nett->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_grp") &&
            $CurrentForm->hasValue("o_grp") &&
            $this->grp->CurrentValue != $this->grp->DefaultValue &&
            !($this->grp->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->grp->CurrentValue == $this->grp->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_s_grp") &&
            $CurrentForm->hasValue("o_s_grp") &&
            $this->s_grp->CurrentValue != $this->s_grp->DefaultValue &&
            !($this->s_grp->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->s_grp->CurrentValue == $this->s_grp->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_product") &&
            $CurrentForm->hasValue("o_product") &&
            $this->product->CurrentValue != $this->product->DefaultValue &&
            !($this->product->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->product->CurrentValue == $this->product->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_rid") &&
            $CurrentForm->hasValue("o_rid") &&
            $this->rid->CurrentValue != $this->rid->DefaultValue &&
            !($this->rid->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->rid->CurrentValue == $this->rid->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_packing_type") &&
            $CurrentForm->hasValue("o_packing_type") &&
            $this->packing_type->CurrentValue != $this->packing_type->DefaultValue &&
            !($this->packing_type->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->packing_type->CurrentValue == $this->packing_type->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_batch_no") &&
            $CurrentForm->hasValue("o_batch_no") &&
            $this->batch_no->CurrentValue != $this->batch_no->DefaultValue &&
            !($this->batch_no->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->batch_no->CurrentValue == $this->batch_no->getSessionValue())
        ) {
            return false;
        }
        return true;
    }

    // Validate grid form
    public function validateGridForm()
    {
        global $CurrentForm;

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Load default values for emptyRow checking
        $this->loadDefaultValues();

        // Validate all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete" && $rowaction != "hide") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } elseif (!$this->validateForm()) {
                    $this->ValidationErrors[$rowindex] = $this->getValidationErrors();
                    $this->EventCancelled = true;
                    return false;
                }
            }
        }
        return true;
    }

    // Get all form values of the grid
    public function getGridFormValues()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }
        $rows = [];

        // Loop through all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } else {
                    $rows[] = $this->getFieldValues("FormValue"); // Return row as array
                }
            }
        }
        return $rows; // Return as array of array
    }

    // Restore form values for current row
    public function restoreCurrentRowFormValues($idx)
    {
        global $CurrentForm;

        // Get row based on current index
        $CurrentForm->Index = $idx;
        $rowaction = strval($CurrentForm->getValue($this->FormActionName));
        $this->loadFormValues(); // Load form values
        // Set up invalid status correctly
        $this->resetFormError();
        if ($rowaction == "insert" && $this->emptyRow()) {
            // Ignore
        } else {
            $this->validateForm();
        }
    }

    // Reset form status
    public function resetFormError()
    {
        foreach ($this->Fields as $field) {
            $field->clearErrorMessage();
        }
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fbomsrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->warp_weft->AdvancedSearch->toJson(), ","); // Field warp_weft
        $filterList = Concat($filterList, $this->m_grp->AdvancedSearch->toJson(), ","); // Field m_grp
        $filterList = Concat($filterList, $this->m_sgrp->AdvancedSearch->toJson(), ","); // Field m_sgrp
        $filterList = Concat($filterList, $this->m_product->AdvancedSearch->toJson(), ","); // Field m_product
        $filterList = Concat($filterList, $this->m_rid->AdvancedSearch->toJson(), ","); // Field m_rid
        $filterList = Concat($filterList, $this->m_packing->AdvancedSearch->toJson(), ","); // Field m_packing
        $filterList = Concat($filterList, $this->bom_waste->AdvancedSearch->toJson(), ","); // Field bom_waste
        $filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
        $filterList = Concat($filterList, $this->method->AdvancedSearch->toJson(), ","); // Field method
        $filterList = Concat($filterList, $this->unit->AdvancedSearch->toJson(), ","); // Field unit
        $filterList = Concat($filterList, $this->gross_nett->AdvancedSearch->toJson(), ","); // Field gross_nett
        $filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
        $filterList = Concat($filterList, $this->s_grp->AdvancedSearch->toJson(), ","); // Field s_grp
        $filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
        $filterList = Concat($filterList, $this->rid->AdvancedSearch->toJson(), ","); // Field rid
        $filterList = Concat($filterList, $this->packing_type->AdvancedSearch->toJson(), ","); // Field packing_type
        $filterList = Concat($filterList, $this->batch_no->AdvancedSearch->toJson(), ","); // Field batch_no
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fbomsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field warp_weft
        $this->warp_weft->AdvancedSearch->SearchValue = @$filter["x_warp_weft"];
        $this->warp_weft->AdvancedSearch->SearchOperator = @$filter["z_warp_weft"];
        $this->warp_weft->AdvancedSearch->SearchCondition = @$filter["v_warp_weft"];
        $this->warp_weft->AdvancedSearch->SearchValue2 = @$filter["y_warp_weft"];
        $this->warp_weft->AdvancedSearch->SearchOperator2 = @$filter["w_warp_weft"];
        $this->warp_weft->AdvancedSearch->save();

        // Field m_grp
        $this->m_grp->AdvancedSearch->SearchValue = @$filter["x_m_grp"];
        $this->m_grp->AdvancedSearch->SearchOperator = @$filter["z_m_grp"];
        $this->m_grp->AdvancedSearch->SearchCondition = @$filter["v_m_grp"];
        $this->m_grp->AdvancedSearch->SearchValue2 = @$filter["y_m_grp"];
        $this->m_grp->AdvancedSearch->SearchOperator2 = @$filter["w_m_grp"];
        $this->m_grp->AdvancedSearch->save();

        // Field m_sgrp
        $this->m_sgrp->AdvancedSearch->SearchValue = @$filter["x_m_sgrp"];
        $this->m_sgrp->AdvancedSearch->SearchOperator = @$filter["z_m_sgrp"];
        $this->m_sgrp->AdvancedSearch->SearchCondition = @$filter["v_m_sgrp"];
        $this->m_sgrp->AdvancedSearch->SearchValue2 = @$filter["y_m_sgrp"];
        $this->m_sgrp->AdvancedSearch->SearchOperator2 = @$filter["w_m_sgrp"];
        $this->m_sgrp->AdvancedSearch->save();

        // Field m_product
        $this->m_product->AdvancedSearch->SearchValue = @$filter["x_m_product"];
        $this->m_product->AdvancedSearch->SearchOperator = @$filter["z_m_product"];
        $this->m_product->AdvancedSearch->SearchCondition = @$filter["v_m_product"];
        $this->m_product->AdvancedSearch->SearchValue2 = @$filter["y_m_product"];
        $this->m_product->AdvancedSearch->SearchOperator2 = @$filter["w_m_product"];
        $this->m_product->AdvancedSearch->save();

        // Field m_rid
        $this->m_rid->AdvancedSearch->SearchValue = @$filter["x_m_rid"];
        $this->m_rid->AdvancedSearch->SearchOperator = @$filter["z_m_rid"];
        $this->m_rid->AdvancedSearch->SearchCondition = @$filter["v_m_rid"];
        $this->m_rid->AdvancedSearch->SearchValue2 = @$filter["y_m_rid"];
        $this->m_rid->AdvancedSearch->SearchOperator2 = @$filter["w_m_rid"];
        $this->m_rid->AdvancedSearch->save();

        // Field m_packing
        $this->m_packing->AdvancedSearch->SearchValue = @$filter["x_m_packing"];
        $this->m_packing->AdvancedSearch->SearchOperator = @$filter["z_m_packing"];
        $this->m_packing->AdvancedSearch->SearchCondition = @$filter["v_m_packing"];
        $this->m_packing->AdvancedSearch->SearchValue2 = @$filter["y_m_packing"];
        $this->m_packing->AdvancedSearch->SearchOperator2 = @$filter["w_m_packing"];
        $this->m_packing->AdvancedSearch->save();

        // Field bom_waste
        $this->bom_waste->AdvancedSearch->SearchValue = @$filter["x_bom_waste"];
        $this->bom_waste->AdvancedSearch->SearchOperator = @$filter["z_bom_waste"];
        $this->bom_waste->AdvancedSearch->SearchCondition = @$filter["v_bom_waste"];
        $this->bom_waste->AdvancedSearch->SearchValue2 = @$filter["y_bom_waste"];
        $this->bom_waste->AdvancedSearch->SearchOperator2 = @$filter["w_bom_waste"];
        $this->bom_waste->AdvancedSearch->save();

        // Field quantity
        $this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
        $this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
        $this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
        $this->quantity->AdvancedSearch->save();

        // Field method
        $this->method->AdvancedSearch->SearchValue = @$filter["x_method"];
        $this->method->AdvancedSearch->SearchOperator = @$filter["z_method"];
        $this->method->AdvancedSearch->SearchCondition = @$filter["v_method"];
        $this->method->AdvancedSearch->SearchValue2 = @$filter["y_method"];
        $this->method->AdvancedSearch->SearchOperator2 = @$filter["w_method"];
        $this->method->AdvancedSearch->save();

        // Field unit
        $this->unit->AdvancedSearch->SearchValue = @$filter["x_unit"];
        $this->unit->AdvancedSearch->SearchOperator = @$filter["z_unit"];
        $this->unit->AdvancedSearch->SearchCondition = @$filter["v_unit"];
        $this->unit->AdvancedSearch->SearchValue2 = @$filter["y_unit"];
        $this->unit->AdvancedSearch->SearchOperator2 = @$filter["w_unit"];
        $this->unit->AdvancedSearch->save();

        // Field gross_nett
        $this->gross_nett->AdvancedSearch->SearchValue = @$filter["x_gross_nett"];
        $this->gross_nett->AdvancedSearch->SearchOperator = @$filter["z_gross_nett"];
        $this->gross_nett->AdvancedSearch->SearchCondition = @$filter["v_gross_nett"];
        $this->gross_nett->AdvancedSearch->SearchValue2 = @$filter["y_gross_nett"];
        $this->gross_nett->AdvancedSearch->SearchOperator2 = @$filter["w_gross_nett"];
        $this->gross_nett->AdvancedSearch->save();

        // Field grp
        $this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
        $this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
        $this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
        $this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
        $this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
        $this->grp->AdvancedSearch->save();

        // Field s_grp
        $this->s_grp->AdvancedSearch->SearchValue = @$filter["x_s_grp"];
        $this->s_grp->AdvancedSearch->SearchOperator = @$filter["z_s_grp"];
        $this->s_grp->AdvancedSearch->SearchCondition = @$filter["v_s_grp"];
        $this->s_grp->AdvancedSearch->SearchValue2 = @$filter["y_s_grp"];
        $this->s_grp->AdvancedSearch->SearchOperator2 = @$filter["w_s_grp"];
        $this->s_grp->AdvancedSearch->save();

        // Field product
        $this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
        $this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
        $this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
        $this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
        $this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
        $this->product->AdvancedSearch->save();

        // Field rid
        $this->rid->AdvancedSearch->SearchValue = @$filter["x_rid"];
        $this->rid->AdvancedSearch->SearchOperator = @$filter["z_rid"];
        $this->rid->AdvancedSearch->SearchCondition = @$filter["v_rid"];
        $this->rid->AdvancedSearch->SearchValue2 = @$filter["y_rid"];
        $this->rid->AdvancedSearch->SearchOperator2 = @$filter["w_rid"];
        $this->rid->AdvancedSearch->save();

        // Field packing_type
        $this->packing_type->AdvancedSearch->SearchValue = @$filter["x_packing_type"];
        $this->packing_type->AdvancedSearch->SearchOperator = @$filter["z_packing_type"];
        $this->packing_type->AdvancedSearch->SearchCondition = @$filter["v_packing_type"];
        $this->packing_type->AdvancedSearch->SearchValue2 = @$filter["y_packing_type"];
        $this->packing_type->AdvancedSearch->SearchOperator2 = @$filter["w_packing_type"];
        $this->packing_type->AdvancedSearch->save();

        // Field batch_no
        $this->batch_no->AdvancedSearch->SearchValue = @$filter["x_batch_no"];
        $this->batch_no->AdvancedSearch->SearchOperator = @$filter["z_batch_no"];
        $this->batch_no->AdvancedSearch->SearchCondition = @$filter["v_batch_no"];
        $this->batch_no->AdvancedSearch->SearchValue2 = @$filter["y_batch_no"];
        $this->batch_no->AdvancedSearch->SearchOperator2 = @$filter["w_batch_no"];
        $this->batch_no->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->warp_weft, $default, false); // warp_weft
        $this->buildSearchSql($where, $this->m_grp, $default, false); // m_grp
        $this->buildSearchSql($where, $this->m_sgrp, $default, false); // m_sgrp
        $this->buildSearchSql($where, $this->m_product, $default, false); // m_product
        $this->buildSearchSql($where, $this->m_rid, $default, false); // m_rid
        $this->buildSearchSql($where, $this->m_packing, $default, false); // m_packing
        $this->buildSearchSql($where, $this->bom_waste, $default, false); // bom_waste
        $this->buildSearchSql($where, $this->quantity, $default, false); // quantity
        $this->buildSearchSql($where, $this->method, $default, false); // method
        $this->buildSearchSql($where, $this->unit, $default, false); // unit
        $this->buildSearchSql($where, $this->gross_nett, $default, false); // gross_nett
        $this->buildSearchSql($where, $this->grp, $default, false); // grp
        $this->buildSearchSql($where, $this->s_grp, $default, false); // s_grp
        $this->buildSearchSql($where, $this->product, $default, false); // product
        $this->buildSearchSql($where, $this->rid, $default, false); // rid
        $this->buildSearchSql($where, $this->packing_type, $default, false); // packing_type
        $this->buildSearchSql($where, $this->batch_no, $default, false); // batch_no
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->warp_weft->AdvancedSearch->save(); // warp_weft
            $this->m_grp->AdvancedSearch->save(); // m_grp
            $this->m_sgrp->AdvancedSearch->save(); // m_sgrp
            $this->m_product->AdvancedSearch->save(); // m_product
            $this->m_rid->AdvancedSearch->save(); // m_rid
            $this->m_packing->AdvancedSearch->save(); // m_packing
            $this->bom_waste->AdvancedSearch->save(); // bom_waste
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->method->AdvancedSearch->save(); // method
            $this->unit->AdvancedSearch->save(); // unit
            $this->gross_nett->AdvancedSearch->save(); // gross_nett
            $this->grp->AdvancedSearch->save(); // grp
            $this->s_grp->AdvancedSearch->save(); // s_grp
            $this->product->AdvancedSearch->save(); // product
            $this->rid->AdvancedSearch->save(); // rid
            $this->packing_type->AdvancedSearch->save(); // packing_type
            $this->batch_no->AdvancedSearch->save(); // batch_no
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->warp_weft->AdvancedSearch->save(); // warp_weft
            $this->m_grp->AdvancedSearch->save(); // m_grp
            $this->m_sgrp->AdvancedSearch->save(); // m_sgrp
            $this->m_product->AdvancedSearch->save(); // m_product
            $this->m_rid->AdvancedSearch->save(); // m_rid
            $this->m_packing->AdvancedSearch->save(); // m_packing
            $this->bom_waste->AdvancedSearch->save(); // bom_waste
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->method->AdvancedSearch->save(); // method
            $this->unit->AdvancedSearch->save(); // unit
            $this->gross_nett->AdvancedSearch->save(); // gross_nett
            $this->grp->AdvancedSearch->save(); // grp
            $this->s_grp->AdvancedSearch->save(); // s_grp
            $this->product->AdvancedSearch->save(); // product
            $this->rid->AdvancedSearch->save(); // rid
            $this->packing_type->AdvancedSearch->save(); // packing_type
            $this->batch_no->AdvancedSearch->save(); // batch_no
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field warp_weft
        $filter = $this->queryBuilderWhere("warp_weft");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->warp_weft, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->warp_weft->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_grp
        $filter = $this->queryBuilderWhere("m_grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_grp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_sgrp
        $filter = $this->queryBuilderWhere("m_sgrp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_sgrp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_sgrp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_product
        $filter = $this->queryBuilderWhere("m_product");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_product, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_product->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_rid
        $filter = $this->queryBuilderWhere("m_rid");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_rid, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_rid->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_packing
        $filter = $this->queryBuilderWhere("m_packing");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_packing, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_packing->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field bom_waste
        $filter = $this->queryBuilderWhere("bom_waste");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->bom_waste, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->bom_waste->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field method
        $filter = $this->queryBuilderWhere("method");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->method, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->method->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field unit
        $filter = $this->queryBuilderWhere("unit");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->unit, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->unit->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field gross_nett
        $filter = $this->queryBuilderWhere("gross_nett");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->gross_nett, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->gross_nett->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field grp
        $filter = $this->queryBuilderWhere("grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->grp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field s_grp
        $filter = $this->queryBuilderWhere("s_grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->s_grp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->s_grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product
        $filter = $this->queryBuilderWhere("product");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field rid
        $filter = $this->queryBuilderWhere("rid");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->rid, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->rid->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field packing_type
        $filter = $this->queryBuilderWhere("packing_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->packing_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->packing_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field batch_no
        $filter = $this->queryBuilderWhere("batch_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->batch_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->batch_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field operator
        $filter = $this->queryBuilderWhere("operator");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->operator, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->operator->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field datetime
        $filter = $this->queryBuilderWhere("datetime");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->datetime, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->datetime->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->id;
        $searchFlds[] = &$this->m_sgrp;
        $searchFlds[] = &$this->m_product;
        $searchFlds[] = &$this->m_rid;
        $searchFlds[] = &$this->quantity_a;
        $searchFlds[] = &$this->quantity;
        $searchFlds[] = &$this->method;
        $searchFlds[] = &$this->gross_nett;
        $searchFlds[] = &$this->grp;
        $searchFlds[] = &$this->product;
        $searchFlds[] = &$this->rid;
        $searchFlds[] = &$this->batch_no;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->warp_weft->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_sgrp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_product->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_rid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_packing->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bom_waste->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->quantity->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->method->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->unit->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->gross_nett->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->s_grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->rid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->packing_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->batch_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->warp_weft->AdvancedSearch->unsetSession();
        $this->m_grp->AdvancedSearch->unsetSession();
        $this->m_sgrp->AdvancedSearch->unsetSession();
        $this->m_product->AdvancedSearch->unsetSession();
        $this->m_rid->AdvancedSearch->unsetSession();
        $this->m_packing->AdvancedSearch->unsetSession();
        $this->bom_waste->AdvancedSearch->unsetSession();
        $this->quantity->AdvancedSearch->unsetSession();
        $this->method->AdvancedSearch->unsetSession();
        $this->unit->AdvancedSearch->unsetSession();
        $this->gross_nett->AdvancedSearch->unsetSession();
        $this->grp->AdvancedSearch->unsetSession();
        $this->s_grp->AdvancedSearch->unsetSession();
        $this->product->AdvancedSearch->unsetSession();
        $this->rid->AdvancedSearch->unsetSession();
        $this->packing_type->AdvancedSearch->unsetSession();
        $this->batch_no->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->warp_weft->AdvancedSearch->load();
        $this->m_grp->AdvancedSearch->load();
        $this->m_sgrp->AdvancedSearch->load();
        $this->m_product->AdvancedSearch->load();
        $this->m_rid->AdvancedSearch->load();
        $this->m_packing->AdvancedSearch->load();
        $this->bom_waste->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->method->AdvancedSearch->load();
        $this->unit->AdvancedSearch->load();
        $this->gross_nett->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->rid->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->batch_no->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
            $defaultSortList = ($this->id->VirtualExpression != "" ? $this->id->VirtualExpression : $this->id->Expression) . " DESC"; // Set up default sort
            if ($this->getSessionOrderByList() == "" && $defaultSortList != "") {
                $this->setSessionOrderByList($defaultSortList);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->warp_weft, $ctrl); // warp_weft
            $this->updateSort($this->m_grp, $ctrl); // m_grp
            $this->updateSort($this->m_sgrp, $ctrl); // m_sgrp
            $this->updateSort($this->m_product, $ctrl); // m_product
            $this->updateSort($this->m_rid, $ctrl); // m_rid
            $this->updateSort($this->m_packing, $ctrl); // m_packing
            $this->updateSort($this->quantity_a, $ctrl); // quantity_a
            $this->updateSort($this->bom_waste, $ctrl); // bom_waste
            $this->updateSort($this->method, $ctrl); // method
            $this->updateSort($this->unit, $ctrl); // unit
            $this->updateSort($this->gross_nett, $ctrl); // gross_nett
            $this->updateSort($this->grp, $ctrl); // grp
            $this->updateSort($this->s_grp, $ctrl); // s_grp
            $this->updateSort($this->product, $ctrl); // product
            $this->updateSort($this->rid, $ctrl); // rid
            $this->updateSort($this->packing_type, $ctrl); // packing_type
            $this->updateSort($this->batch_no, $ctrl); // batch_no
            $this->updateSort($this->operator, $ctrl); // operator
            $this->updateSort($this->datetime, $ctrl); // datetime
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->setSessionOrderByList($orderBy);
                $this->id->setSort("");
                $this->warp_weft->setSort("");
                $this->m_grp->setSort("");
                $this->m_sgrp->setSort("");
                $this->m_product->setSort("");
                $this->m_rid->setSort("");
                $this->m_packing->setSort("");
                $this->m_name->setSort("");
                $this->quantity_a->setSort("");
                $this->bom_waste->setSort("");
                $this->quantity->setSort("");
                $this->method->setSort("");
                $this->unit->setSort("");
                $this->gross_nett->setSort("");
                $this->grp->setSort("");
                $this->s_grp->setSort("");
                $this->product->setSort("");
                $this->rid->setSort("");
                $this->packing_type->setSort("");
                $this->batch_no->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->a_operator->setSort("");
                $this->a_datetime->setSort("");
                $this->pp_qty->setSort("");
                $this->pp_bal->setSort("");
                $this->pp_id->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // "griddelete"
        if ($this->AllowAddDeleteRow) {
            $item = &$this->ListOptions->add("griddelete");
            $item->CssClass = "text-nowrap";
            $item->OnLeft = true;
            $item->Visible = false; // Default hidden
        }

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // Set up row action and key
        if ($CurrentForm && is_numeric($this->RowIndex) && $this->RowType != "view") {
            $CurrentForm->Index = $this->RowIndex;
            $actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
            $oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->OldKeyName);
            $blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
            if ($this->RowAction != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
            }
            $oldKey = $this->getKey(false); // Get from OldValue
            if ($oldKeyName != "" && $oldKey != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($oldKey) . "\">";
            }
            if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow()) {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
            }
        }

        // "delete"
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $options = &$this->ListOptions;
                $options->UseButtonGroup = true; // Use button group for grid delete button
                $opt = $options["griddelete"];
                if (!$Security->allowDelete(CurrentProjectID() . $this->TableName) && is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
                    $opt->Body = "&nbsp;";
                } else {
                    $opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-ew-action=\"delete-grid-row\" data-rowindex=\"" . $this->RowIndex . "\">" . $Language->phrase("DeleteLink") . "</a>";
                }
            }
        }
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"bom\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"bom\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"bom\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fbomlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fbomlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"bom\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $item = &$option->add("gridadd");
        if ($this->ModalGridAdd && !IsMobile()) {
            $item->Body = "<button class=\"ew-add-edit ew-grid-add\" title=\"" . $Language->phrase("GridAddLink", true) . "\" data-caption=\"" . $Language->phrase("GridAddLink", true) . "\" data-ew-action=\"modal\" data-btn=\"AddBtn\" data-url=\"" . HtmlEncode(GetUrl($this->GridAddUrl)) . "\">" . $Language->phrase("GridAddLink") . "</button>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-grid-add\" title=\"" . $Language->phrase("GridAddLink", true) . "\" data-caption=\"" . $Language->phrase("GridAddLink", true) . "\" href=\"" . HtmlEncode(GetUrl($this->GridAddUrl)) . "\">" . $Language->phrase("GridAddLink") . "</a>";
        }
        $item->Visible = $this->GridAddUrl != "" && $Security->canAdd();

        // Add grid edit
        $option = $options["addedit"];
        $item = &$option->add("gridedit");
        if ($this->ModalGridEdit && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-grid-edit\" title=\"" . $Language->phrase("GridEditLink", true) . "\" data-caption=\"" . $Language->phrase("GridEditLink", true) . "\" data-ew-action=\"modal\" data-btn=\"GridSaveLink\" data-url=\"" . HtmlEncode(GetUrl($this->GridEditUrl)) . "\">" . $Language->phrase("GridEditLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-grid-edit\" title=\"" . $Language->phrase("GridEditLink", true) . "\" data-caption=\"" . $Language->phrase("GridEditLink", true) . "\" href=\"" . HtmlEncode(GetUrl($this->GridEditUrl)) . "\">" . $Language->phrase("GridEditLink") . "</a>";
        }
        $item->Visible = $this->GridEditUrl != "" && $Security->canEdit();
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "warp_weft");
            $this->createColumnOption($option, "m_grp");
            $this->createColumnOption($option, "m_sgrp");
            $this->createColumnOption($option, "m_product");
            $this->createColumnOption($option, "m_rid");
            $this->createColumnOption($option, "m_packing");
            $this->createColumnOption($option, "quantity_a");
            $this->createColumnOption($option, "bom_waste");
            $this->createColumnOption($option, "method");
            $this->createColumnOption($option, "unit");
            $this->createColumnOption($option, "gross_nett");
            $this->createColumnOption($option, "grp");
            $this->createColumnOption($option, "s_grp");
            $this->createColumnOption($option, "product");
            $this->createColumnOption($option, "rid");
            $this->createColumnOption($option, "packing_type");
            $this->createColumnOption($option, "batch_no");
            $this->createColumnOption($option, "operator");
            $this->createColumnOption($option, "datetime");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fbomsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fbomsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        if (!$this->isGridAdd() && !$this->isGridEdit() && !$this->isMultiEdit()) { // Not grid add/grid edit/multi edit mode
            $option = $options["action"];
            // Set up list action buttons
            foreach ($this->ListActions as $listAction) {
                if ($listAction->Select == ACTION_MULTIPLE) {
                    $item = &$option->add("custom_" . $listAction->Action);
                    $caption = $listAction->Caption;
                    $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                    $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fbomlist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                    $item->Visible = $listAction->Allowed;
                }
            }

            // Hide multi edit, grid edit and other options
            if ($this->TotalRecords <= 0) {
                $option = $options["addedit"];
                $item = $option["gridedit"];
                if ($item) {
                    $item->Visible = false;
                }
                $option = $options["action"];
                $option->hideAllOptions();
            }
        } else { // Grid add/grid edit/multi edit mode
            // Hide all options first
            foreach ($options as $option) {
                $option->hideAllOptions();
            }
            $pageUrl = $this->pageUrl(false);

            // Grid-Add
            if ($this->isGridAdd()) {
                    if ($this->AllowAddDeleteRow) {
                        // Add add blank row
                        $option = $options["addedit"];
                        $option->UseDropDownButton = false;
                        $item = &$option->add("addblankrow");
                        $item->Body = "<a type=\"button\" class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-ew-action=\"add-grid-row\">" . $Language->phrase("AddBlankRow") . "</a>";
                        $item->Visible = $Security->canAdd();
                    }
                if (!($this->ModalGridAdd && !IsMobile())) {
                    $option = $options["action"];
                    $option->UseDropDownButton = false;
                    // Add grid insert
                    $item = &$option->add("gridinsert");
                    $item->Body = "<button class=\"ew-action ew-grid-insert\" title=\"" . HtmlTitle($Language->phrase("GridInsertLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridInsertLink")) . "\" form=\"fbomlist\" formaction=\"" . GetUrl($this->pageName()) . "\">" . $Language->phrase("GridInsertLink") . "</button>";
                    // Add grid cancel
                    $item = &$option->add("gridcancel");
                    $cancelurl = $this->addMasterUrl($pageUrl . "action=cancel");
                    $item->Body = "<a type=\"button\" class=\"ew-action ew-grid-cancel\" title=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" href=\"" . $cancelurl . "\">" . $Language->phrase("GridCancelLink") . "</a>";
                }
            }

            // Grid-Edit
            if ($this->isGridEdit()) {
                    if ($this->AllowAddDeleteRow) {
                        // Add add blank row
                        $option = $options["addedit"];
                        $option->UseDropDownButton = false;
                        $item = &$option->add("addblankrow");
                        $item->Body = "<button class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-ew-action=\"add-grid-row\">" . $Language->phrase("AddBlankRow") . "</button>";
                        $item->Visible = $Security->canAdd();
                    }
                if (!($this->ModalGridEdit && !IsMobile())) {
                    $option = $options["action"];
                    $option->UseDropDownButton = false;
                        $item = &$option->add("gridsave");
                        $item->Body = "<button class=\"ew-action ew-grid-save\" title=\"" . HtmlTitle($Language->phrase("GridSaveLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridSaveLink")) . "\" form=\"fbomlist\" formaction=\"" . GetUrl($this->pageName()) . "\">" . $Language->phrase("GridSaveLink") . "</button>";
                        $item = &$option->add("gridcancel");
                        $cancelurl = $this->addMasterUrl($pageUrl . "action=cancel");
                        $item->Body = "<a class=\"ew-action ew-grid-cancel\" title=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" href=\"" . $cancelurl . "\">" . $Language->phrase("GridCancelLink") . "</a>";
                }
            }
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }

        // Restore number of post back records
        if ($CurrentForm && ($this->isConfirm() || $this->EventCancelled)) {
            $CurrentForm->resetIndex();
            if ($CurrentForm->hasValue($this->FormKeyCountName) && ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm())) {
                $this->KeyCount = $CurrentForm->getValue($this->FormKeyCountName);
                $this->StopRecord = $this->StartRecord + $this->KeyCount - 1;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_bom", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }
        if ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm() || $this->isMultiEdit()) {
            $this->RowIndex++;
            $CurrentForm->Index = $this->RowIndex;
            if ($CurrentForm->hasValue($this->FormActionName) && ($this->isConfirm() || $this->EventCancelled)) {
                $this->RowAction = strval($CurrentForm->getValue($this->FormActionName));
            } elseif ($this->isGridAdd()) {
                $this->RowAction = "insert";
            } else {
                $this->RowAction = "";
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }
        if ($this->isGridAdd() && $this->EventCancelled && !$CurrentForm->hasValue($this->FormBlankRowName)) { // Insert failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isGridEdit()) { // Grid edit
            if ($this->EventCancelled) {
                $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
            }
            if ($this->RowAction == "insert") {
                $this->RowType = RowType::ADD; // Render add
            } else {
                $this->RowType = RowType::EDIT; // Render edit
            }
        }
        if ($this->isGridEdit() && ($this->RowType == RowType::EDIT || $this->RowType == RowType::ADD) && $this->EventCancelled) { // Update failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_bom",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->method->DefaultValue = $this->method->getDefault(); // PHP
        $this->method->OldValue = $this->method->DefaultValue;
        $this->unit->DefaultValue = $this->unit->getDefault(); // PHP
        $this->unit->OldValue = $this->unit->DefaultValue;
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->s_grp->DefaultValue = $this->s_grp->getDefault(); // PHP
        $this->s_grp->OldValue = $this->s_grp->DefaultValue;
        $this->product->DefaultValue = $this->product->getDefault(); // PHP
        $this->product->OldValue = $this->product->DefaultValue;
        $this->rid->DefaultValue = $this->rid->getDefault(); // PHP
        $this->rid->OldValue = $this->rid->DefaultValue;
        $this->packing_type->DefaultValue = $this->packing_type->getDefault(); // PHP
        $this->packing_type->OldValue = $this->packing_type->DefaultValue;
        $this->batch_no->DefaultValue = $this->batch_no->getDefault(); // PHP
        $this->batch_no->OldValue = $this->batch_no->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->pp_bal->DefaultValue = $this->pp_bal->getDefault(); // PHP
        $this->pp_bal->OldValue = $this->pp_bal->DefaultValue;
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // warp_weft
        if ($this->warp_weft->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->warp_weft->AdvancedSearch->SearchValue != "" || $this->warp_weft->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_grp
        if ($this->m_grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_grp->AdvancedSearch->SearchValue != "" || $this->m_grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_sgrp
        if ($this->m_sgrp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_sgrp->AdvancedSearch->SearchValue != "" || $this->m_sgrp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_product
        if ($this->m_product->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_product->AdvancedSearch->SearchValue != "" || $this->m_product->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_rid
        if ($this->m_rid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_rid->AdvancedSearch->SearchValue != "" || $this->m_rid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_packing
        if ($this->m_packing->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_packing->AdvancedSearch->SearchValue != "" || $this->m_packing->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bom_waste
        if ($this->bom_waste->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bom_waste->AdvancedSearch->SearchValue != "" || $this->bom_waste->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->quantity->AdvancedSearch->SearchValue != "" || $this->quantity->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // method
        if ($this->method->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->method->AdvancedSearch->SearchValue != "" || $this->method->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // unit
        if ($this->unit->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->unit->AdvancedSearch->SearchValue != "" || $this->unit->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // gross_nett
        if ($this->gross_nett->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->gross_nett->AdvancedSearch->SearchValue != "" || $this->gross_nett->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->grp->AdvancedSearch->SearchValue != "" || $this->grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->s_grp->AdvancedSearch->SearchValue != "" || $this->s_grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product->AdvancedSearch->SearchValue != "" || $this->product->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // rid
        if ($this->rid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->rid->AdvancedSearch->SearchValue != "" || $this->rid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->packing_type->AdvancedSearch->SearchValue != "" || $this->packing_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // batch_no
        if ($this->batch_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->batch_no->AdvancedSearch->SearchValue != "" || $this->batch_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd()) {
            $this->id->setFormValue($val);
        }

        // Check field name 'warp_weft' first before field var 'x_warp_weft'
        $val = $CurrentForm->hasValue("warp_weft") ? $CurrentForm->getValue("warp_weft") : $CurrentForm->getValue("x_warp_weft");
        if (!$this->warp_weft->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->warp_weft->Visible = false; // Disable update for API request
            } else {
                $this->warp_weft->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_warp_weft")) {
            $this->warp_weft->setOldValue($CurrentForm->getValue("o_warp_weft"));
        }

        // Check field name 'm_grp' first before field var 'x_m_grp'
        $val = $CurrentForm->hasValue("m_grp") ? $CurrentForm->getValue("m_grp") : $CurrentForm->getValue("x_m_grp");
        if (!$this->m_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_grp->Visible = false; // Disable update for API request
            } else {
                $this->m_grp->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_m_grp")) {
            $this->m_grp->setOldValue($CurrentForm->getValue("o_m_grp"));
        }

        // Check field name 'm_sgrp' first before field var 'x_m_sgrp'
        $val = $CurrentForm->hasValue("m_sgrp") ? $CurrentForm->getValue("m_sgrp") : $CurrentForm->getValue("x_m_sgrp");
        if (!$this->m_sgrp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_sgrp->Visible = false; // Disable update for API request
            } else {
                $this->m_sgrp->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_m_sgrp")) {
            $this->m_sgrp->setOldValue($CurrentForm->getValue("o_m_sgrp"));
        }

        // Check field name 'm_product' first before field var 'x_m_product'
        $val = $CurrentForm->hasValue("m_product") ? $CurrentForm->getValue("m_product") : $CurrentForm->getValue("x_m_product");
        if (!$this->m_product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_product->Visible = false; // Disable update for API request
            } else {
                $this->m_product->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_m_product")) {
            $this->m_product->setOldValue($CurrentForm->getValue("o_m_product"));
        }

        // Check field name 'm_rid' first before field var 'x_m_rid'
        $val = $CurrentForm->hasValue("m_rid") ? $CurrentForm->getValue("m_rid") : $CurrentForm->getValue("x_m_rid");
        if (!$this->m_rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_rid->Visible = false; // Disable update for API request
            } else {
                $this->m_rid->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_m_rid")) {
            $this->m_rid->setOldValue($CurrentForm->getValue("o_m_rid"));
        }

        // Check field name 'm_packing' first before field var 'x_m_packing'
        $val = $CurrentForm->hasValue("m_packing") ? $CurrentForm->getValue("m_packing") : $CurrentForm->getValue("x_m_packing");
        if (!$this->m_packing->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_packing->Visible = false; // Disable update for API request
            } else {
                $this->m_packing->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_m_packing")) {
            $this->m_packing->setOldValue($CurrentForm->getValue("o_m_packing"));
        }

        // Check field name 'quantity_a' first before field var 'x_quantity_a'
        $val = $CurrentForm->hasValue("quantity_a") ? $CurrentForm->getValue("quantity_a") : $CurrentForm->getValue("x_quantity_a");
        if (!$this->quantity_a->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity_a->Visible = false; // Disable update for API request
            } else {
                $this->quantity_a->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_quantity_a")) {
            $this->quantity_a->setOldValue($CurrentForm->getValue("o_quantity_a"));
        }

        // Check field name 'bom_waste' first before field var 'x_bom_waste'
        $val = $CurrentForm->hasValue("bom_waste") ? $CurrentForm->getValue("bom_waste") : $CurrentForm->getValue("x_bom_waste");
        if (!$this->bom_waste->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bom_waste->Visible = false; // Disable update for API request
            } else {
                $this->bom_waste->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_bom_waste")) {
            $this->bom_waste->setOldValue($CurrentForm->getValue("o_bom_waste"));
        }

        // Check field name 'method' first before field var 'x_method'
        $val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
        if (!$this->method->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->method->Visible = false; // Disable update for API request
            } else {
                $this->method->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_method")) {
            $this->method->setOldValue($CurrentForm->getValue("o_method"));
        }

        // Check field name 'unit' first before field var 'x_unit'
        $val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
        if (!$this->unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit->Visible = false; // Disable update for API request
            } else {
                $this->unit->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_unit")) {
            $this->unit->setOldValue($CurrentForm->getValue("o_unit"));
        }

        // Check field name 'gross_nett' first before field var 'x_gross_nett'
        $val = $CurrentForm->hasValue("gross_nett") ? $CurrentForm->getValue("gross_nett") : $CurrentForm->getValue("x_gross_nett");
        if (!$this->gross_nett->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gross_nett->Visible = false; // Disable update for API request
            } else {
                $this->gross_nett->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_gross_nett")) {
            $this->gross_nett->setOldValue($CurrentForm->getValue("o_gross_nett"));
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_grp")) {
            $this->grp->setOldValue($CurrentForm->getValue("o_grp"));
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_s_grp")) {
            $this->s_grp->setOldValue($CurrentForm->getValue("o_s_grp"));
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_product")) {
            $this->product->setOldValue($CurrentForm->getValue("o_product"));
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_rid")) {
            $this->rid->setOldValue($CurrentForm->getValue("o_rid"));
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_packing_type")) {
            $this->packing_type->setOldValue($CurrentForm->getValue("o_packing_type"));
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_batch_no")) {
            $this->batch_no->setOldValue($CurrentForm->getValue("o_batch_no"));
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_operator")) {
            $this->operator->setOldValue($CurrentForm->getValue("o_operator"));
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
        if ($CurrentForm->hasValue("o_datetime")) {
            $this->datetime->setOldValue($CurrentForm->getValue("o_datetime"));
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        if (!$this->isGridAdd() && !$this->isAdd()) {
            $this->id->CurrentValue = $this->id->FormValue;
        }
        $this->warp_weft->CurrentValue = $this->warp_weft->FormValue;
        $this->m_grp->CurrentValue = $this->m_grp->FormValue;
        $this->m_sgrp->CurrentValue = $this->m_sgrp->FormValue;
        $this->m_product->CurrentValue = $this->m_product->FormValue;
        $this->m_rid->CurrentValue = $this->m_rid->FormValue;
        $this->m_packing->CurrentValue = $this->m_packing->FormValue;
        $this->quantity_a->CurrentValue = $this->quantity_a->FormValue;
        $this->bom_waste->CurrentValue = $this->bom_waste->FormValue;
        $this->method->CurrentValue = $this->method->FormValue;
        $this->unit->CurrentValue = $this->unit->FormValue;
        $this->gross_nett->CurrentValue = $this->gross_nett->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
            if (!$this->EventCancelled) {
                $this->HashValue = $this->getRowHash($row); // Get hash value for record
            }
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->warp_weft->setDbValue($row['warp_weft']);
        $this->m_grp->setDbValue($row['m_grp']);
        $this->m_sgrp->setDbValue($row['m_sgrp']);
        $this->m_product->setDbValue($row['m_product']);
        $this->m_rid->setDbValue($row['m_rid']);
        if (array_key_exists('EV__m_rid', $row)) {
            $this->m_rid->VirtualValue = $row['EV__m_rid']; // Set up virtual field value
        } else {
            $this->m_rid->VirtualValue = ""; // Clear value
        }
        $this->m_packing->setDbValue($row['m_packing']);
        $this->m_name->setDbValue($row['m_name']);
        $this->quantity_a->setDbValue($row['quantity_a']);
        $this->bom_waste->setDbValue($row['bom_waste']);
        $this->quantity->setDbValue($row['quantity']);
        $this->method->setDbValue($row['method']);
        $this->unit->setDbValue($row['unit']);
        $this->gross_nett->setDbValue($row['gross_nett']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->pp_qty->setDbValue($row['pp_qty']);
        $this->pp_bal->setDbValue($row['pp_bal']);
        $this->pp_id->setDbValue($row['pp_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['warp_weft'] = $this->warp_weft->DefaultValue;
        $row['m_grp'] = $this->m_grp->DefaultValue;
        $row['m_sgrp'] = $this->m_sgrp->DefaultValue;
        $row['m_product'] = $this->m_product->DefaultValue;
        $row['m_rid'] = $this->m_rid->DefaultValue;
        $row['m_packing'] = $this->m_packing->DefaultValue;
        $row['m_name'] = $this->m_name->DefaultValue;
        $row['quantity_a'] = $this->quantity_a->DefaultValue;
        $row['bom_waste'] = $this->bom_waste->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['method'] = $this->method->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['gross_nett'] = $this->gross_nett->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['pp_qty'] = $this->pp_qty->DefaultValue;
        $row['pp_bal'] = $this->pp_bal->DefaultValue;
        $row['pp_id'] = $this->pp_id->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // warp_weft

        // m_grp

        // m_sgrp

        // m_product

        // m_rid

        // m_packing

        // m_name
        $this->m_name->CellCssStyle = "white-space: nowrap;";

        // quantity_a
        $this->quantity_a->CellCssStyle = "min-width: 100px;";

        // bom_waste
        $this->bom_waste->CellCssStyle = "min-width: 100px;";

        // quantity
        $this->quantity->CellCssStyle = "min-width: 100px;";

        // method
        $this->method->CellCssStyle = "min-width: 100px;";

        // unit
        $this->unit->CellCssStyle = "min-width: 100px;";

        // gross_nett

        // grp

        // s_grp

        // product

        // rid

        // packing_type

        // batch_no

        // operator

        // datetime

        // a_operator

        // a_datetime

        // pp_qty
        $this->pp_qty->CellCssStyle = "white-space: nowrap;";

        // pp_bal
        $this->pp_bal->CellCssStyle = "white-space: nowrap;";

        // pp_id
        $this->pp_id->CellCssStyle = "white-space: nowrap;";

        // Accumulate aggregate value
        if ($this->RowType != RowType::AGGREGATEINIT && $this->RowType != RowType::AGGREGATE && $this->RowType != RowType::PREVIEWFIELD) {
            if (is_numeric($this->quantity_a->CurrentValue)) {
                $this->quantity_a->Total += $this->quantity_a->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->quantity->CurrentValue)) {
                $this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
            }
        }

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // warp_weft
            if (strval($this->warp_weft->CurrentValue) != "") {
                $this->warp_weft->ViewValue = $this->warp_weft->optionCaption($this->warp_weft->CurrentValue);
            } else {
                $this->warp_weft->ViewValue = null;
            }

            // m_grp
            $curVal = strval($this->m_grp->CurrentValue);
            if ($curVal != "") {
                $this->m_grp->ViewValue = $this->m_grp->lookupCacheOption($curVal);
                if ($this->m_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->m_grp->ViewValue = $this->m_grp->displayValue($arwrk);
                    } else {
                        $this->m_grp->ViewValue = FormatNumber($this->m_grp->CurrentValue, $this->m_grp->formatPattern());
                    }
                }
            } else {
                $this->m_grp->ViewValue = null;
            }

            // m_sgrp
            $curVal = strval($this->m_sgrp->CurrentValue);
            if ($curVal != "") {
                $this->m_sgrp->ViewValue = $this->m_sgrp->lookupCacheOption($curVal);
                if ($this->m_sgrp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_sgrp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_sgrp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_sgrp->Lookup->renderViewRow($rswrk[0]);
                        $this->m_sgrp->ViewValue = $this->m_sgrp->displayValue($arwrk);
                    } else {
                        $this->m_sgrp->ViewValue = $this->m_sgrp->CurrentValue;
                    }
                }
            } else {
                $this->m_sgrp->ViewValue = null;
            }

            // m_product
            $curVal = strval($this->m_product->CurrentValue);
            if ($curVal != "") {
                $this->m_product->ViewValue = $this->m_product->lookupCacheOption($curVal);
                if ($this->m_product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_product->Lookup->renderViewRow($rswrk[0]);
                        $this->m_product->ViewValue = $this->m_product->displayValue($arwrk);
                    } else {
                        $this->m_product->ViewValue = $this->m_product->CurrentValue;
                    }
                }
            } else {
                $this->m_product->ViewValue = null;
            }

            // m_rid
            if ($this->m_rid->VirtualValue != "") {
                $this->m_rid->ViewValue = $this->m_rid->VirtualValue;
            } else {
                $this->m_rid->ViewValue = $this->m_rid->CurrentValue;
                $curVal = strval($this->m_rid->CurrentValue);
                if ($curVal != "") {
                    $this->m_rid->ViewValue = $this->m_rid->lookupCacheOption($curVal);
                    if ($this->m_rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->m_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->m_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->m_rid->Lookup->renderViewRow($rswrk[0]);
                            $this->m_rid->ViewValue = $this->m_rid->displayValue($arwrk);
                        } else {
                            $this->m_rid->ViewValue = $this->m_rid->CurrentValue;
                        }
                    }
                } else {
                    $this->m_rid->ViewValue = null;
                }
            }

            // m_packing
            $curVal = strval($this->m_packing->CurrentValue);
            if ($curVal != "") {
                $this->m_packing->ViewValue = $this->m_packing->lookupCacheOption($curVal);
                if ($this->m_packing->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->m_packing->ViewValue = $this->m_packing->displayValue($arwrk);
                    } else {
                        $this->m_packing->ViewValue = FormatNumber($this->m_packing->CurrentValue, $this->m_packing->formatPattern());
                    }
                }
            } else {
                $this->m_packing->ViewValue = null;
            }

            // quantity_a
            $this->quantity_a->ViewValue = $this->quantity_a->CurrentValue;
            $this->quantity_a->ViewValue = FormatNumber($this->quantity_a->ViewValue, $this->quantity_a->formatPattern());

            // bom_waste
            $this->bom_waste->ViewValue = $this->bom_waste->CurrentValue;
            $this->bom_waste->ViewValue = FormatNumber($this->bom_waste->ViewValue, $this->bom_waste->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;

            // method
            $curVal = strval($this->method->CurrentValue);
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
                if ($this->method->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->method->getSelectFilter($this); // PHP
                    $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                        $this->method->ViewValue = $this->method->displayValue($arwrk);
                    } else {
                        $this->method->ViewValue = $this->method->CurrentValue;
                    }
                }
            } else {
                $this->method->ViewValue = null;
            }

            // unit
            $curVal = strval($this->unit->CurrentValue);
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
                if ($this->unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                        $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                    } else {
                        $this->unit->ViewValue = $this->unit->CurrentValue;
                    }
                }
            } else {
                $this->unit->ViewValue = null;
            }

            // gross_nett
            if (strval($this->gross_nett->CurrentValue) != "") {
                $this->gross_nett->ViewValue = $this->gross_nett->optionCaption($this->gross_nett->CurrentValue);
            } else {
                $this->gross_nett->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // batch_no
            $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // warp_weft
            $this->warp_weft->HrefValue = "";
            $this->warp_weft->TooltipValue = "";

            // m_grp
            if (!EmptyValue($this->m_grp->CurrentValue)) {
                $this->m_grp->HrefValue = $this->m_grp->getLinkPrefix() . $this->m_grp->CurrentValue; // Add prefix/suffix
                $this->m_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->m_grp->HrefValue = FullUrl($this->m_grp->HrefValue, "href");
                }
            } else {
                $this->m_grp->HrefValue = "";
            }
            $this->m_grp->TooltipValue = "";

            // m_sgrp
            $this->m_sgrp->HrefValue = "";
            $this->m_sgrp->TooltipValue = "";

            // m_product
            $this->m_product->HrefValue = "";
            $this->m_product->TooltipValue = "";

            // m_rid
            $this->m_rid->HrefValue = "";
            $this->m_rid->TooltipValue = "";
            if (!$this->isExport()) {
                $this->m_rid->ViewValue = $this->highlightValue($this->m_rid);
            }

            // m_packing
            $this->m_packing->HrefValue = "";
            $this->m_packing->TooltipValue = "";

            // quantity_a
            $this->quantity_a->HrefValue = "";
            $this->quantity_a->TooltipValue = "";

            // bom_waste
            $this->bom_waste->HrefValue = "";
            $this->bom_waste->TooltipValue = "";

            // method
            $this->method->HrefValue = "";
            $this->method->TooltipValue = "";

            // unit
            $this->unit->HrefValue = "";
            $this->unit->TooltipValue = "";

            // gross_nett
            $this->gross_nett->HrefValue = "";
            $this->gross_nett->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            $this->product->HrefValue = "";
            $this->product->TooltipValue = "";

            // rid
            $this->rid->HrefValue = "";
            $this->rid->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";
            $this->batch_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->batch_no->ViewValue = $this->highlightValue($this->batch_no);
            }

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
            if (!$this->isExport()) {
                $this->datetime->ViewValue = $this->highlightValue($this->datetime);
            }
        } elseif ($this->RowType == RowType::ADD) {
            // id

            // warp_weft
            $this->warp_weft->setupEditAttributes();
            $this->warp_weft->EditValue = $this->warp_weft->options(true);
            $this->warp_weft->PlaceHolder = RemoveHtml($this->warp_weft->caption());

            // m_grp
            $this->m_grp->setupEditAttributes();
            $curVal = trim(strval($this->m_grp->CurrentValue));
            if ($curVal != "") {
                $this->m_grp->ViewValue = $this->m_grp->lookupCacheOption($curVal);
            } else {
                $this->m_grp->ViewValue = $this->m_grp->Lookup !== null && is_array($this->m_grp->lookupOptions()) && count($this->m_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->m_grp->ViewValue !== null) { // Load from cache
                $this->m_grp->EditValue = array_values($this->m_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->m_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->m_grp->CurrentValue, $this->m_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->m_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->m_grp->EditValue = $arwrk;
            }
            $this->m_grp->PlaceHolder = RemoveHtml($this->m_grp->caption());

            // m_sgrp
            $this->m_sgrp->setupEditAttributes();
            $curVal = trim(strval($this->m_sgrp->CurrentValue));
            if ($curVal != "") {
                $this->m_sgrp->ViewValue = $this->m_sgrp->lookupCacheOption($curVal);
            } else {
                $this->m_sgrp->ViewValue = $this->m_sgrp->Lookup !== null && is_array($this->m_sgrp->lookupOptions()) && count($this->m_sgrp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->m_sgrp->ViewValue !== null) { // Load from cache
                $this->m_sgrp->EditValue = array_values($this->m_sgrp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->m_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->m_sgrp->CurrentValue, $this->m_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->m_sgrp->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_sgrp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->m_sgrp->EditValue = $arwrk;
            }
            $this->m_sgrp->PlaceHolder = RemoveHtml($this->m_sgrp->caption());

            // m_product
            $this->m_product->setupEditAttributes();
            $curVal = trim(strval($this->m_product->CurrentValue));
            if ($curVal != "") {
                $this->m_product->ViewValue = $this->m_product->lookupCacheOption($curVal);
            } else {
                $this->m_product->ViewValue = $this->m_product->Lookup !== null && is_array($this->m_product->lookupOptions()) && count($this->m_product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->m_product->ViewValue !== null) { // Load from cache
                $this->m_product->EditValue = array_values($this->m_product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->m_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->m_product->CurrentValue, $this->m_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->m_product->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->m_product->EditValue = $arwrk;
            }
            $this->m_product->PlaceHolder = RemoveHtml($this->m_product->caption());

            // m_rid
            $this->m_rid->setupEditAttributes();
            $this->m_rid->EditValue = $this->m_rid->CurrentValue;
            $curVal = strval($this->m_rid->CurrentValue);
            if ($curVal != "") {
                $this->m_rid->EditValue = $this->m_rid->lookupCacheOption($curVal);
                if ($this->m_rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->m_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->m_rid->EditValue = $this->m_rid->displayValue($arwrk);
                    } else {
                        $this->m_rid->EditValue = HtmlEncode($this->m_rid->CurrentValue);
                    }
                }
            } else {
                $this->m_rid->EditValue = null;
            }
            $this->m_rid->PlaceHolder = RemoveHtml($this->m_rid->caption());

            // m_packing
            $this->m_packing->setupEditAttributes();
            $curVal = trim(strval($this->m_packing->CurrentValue));
            if ($curVal != "") {
                $this->m_packing->ViewValue = $this->m_packing->lookupCacheOption($curVal);
            } else {
                $this->m_packing->ViewValue = $this->m_packing->Lookup !== null && is_array($this->m_packing->lookupOptions()) && count($this->m_packing->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->m_packing->ViewValue !== null) { // Load from cache
                $this->m_packing->EditValue = array_values($this->m_packing->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->m_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->m_packing->CurrentValue, $this->m_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->m_packing->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_packing->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->m_packing->EditValue = $arwrk;
            }
            $this->m_packing->PlaceHolder = RemoveHtml($this->m_packing->caption());

            // quantity_a
            $this->quantity_a->setupEditAttributes();
            $this->quantity_a->EditValue = $this->quantity_a->CurrentValue;
            $this->quantity_a->PlaceHolder = RemoveHtml($this->quantity_a->caption());
            if (strval($this->quantity_a->EditValue) != "" && is_numeric($this->quantity_a->EditValue)) {
                $this->quantity_a->EditValue = FormatNumber($this->quantity_a->EditValue, null);
            }

            // bom_waste
            $this->bom_waste->setupEditAttributes();
            $this->bom_waste->EditValue = $this->bom_waste->CurrentValue;
            $this->bom_waste->PlaceHolder = RemoveHtml($this->bom_waste->caption());
            if (strval($this->bom_waste->EditValue) != "" && is_numeric($this->bom_waste->EditValue)) {
                $this->bom_waste->EditValue = FormatNumber($this->bom_waste->EditValue, null);
            }

            // method
            $this->method->setupEditAttributes();
            $curVal = trim(strval($this->method->CurrentValue));
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
            } else {
                $this->method->ViewValue = $this->method->Lookup !== null && is_array($this->method->lookupOptions()) && count($this->method->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->method->ViewValue !== null) { // Load from cache
                $this->method->EditValue = array_values($this->method->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->method->CurrentValue, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->method->EditValue = $arwrk;
            }
            $this->method->PlaceHolder = RemoveHtml($this->method->caption());

            // unit
            $this->unit->setupEditAttributes();
            $curVal = trim(strval($this->unit->CurrentValue));
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
            } else {
                $this->unit->ViewValue = $this->unit->Lookup !== null && is_array($this->unit->lookupOptions()) && count($this->unit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->unit->ViewValue !== null) { // Load from cache
                $this->unit->EditValue = array_values($this->unit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->unit->CurrentValue, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->unit->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->unit->EditValue = $arwrk;
            }
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // gross_nett
            $this->gross_nett->setupEditAttributes();
            $this->gross_nett->EditValue = $this->gross_nett->options(true);
            $this->gross_nett->PlaceHolder = RemoveHtml($this->gross_nett->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $this->rid->setupEditAttributes();
            $curVal = trim(strval($this->rid->CurrentValue));
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
            } else {
                $this->rid->ViewValue = $this->rid->Lookup !== null && is_array($this->rid->lookupOptions()) && count($this->rid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid->ViewValue !== null) { // Load from cache
                $this->rid->EditValue = array_values($this->rid->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid->CurrentValue, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->rid->EditValue = $arwrk;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // batch_no
            $this->batch_no->setupEditAttributes();
            $this->batch_no->EditValue = $this->batch_no->CurrentValue;
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->EditValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->EditValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->EditValue = HtmlEncode($this->batch_no->CurrentValue);
                    }
                }
            } else {
                $this->batch_no->EditValue = null;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // operator

            // datetime

            // Add refer script

            // id
            $this->id->HrefValue = "";

            // warp_weft
            $this->warp_weft->HrefValue = "";

            // m_grp
            if (!EmptyValue($this->m_grp->CurrentValue)) {
                $this->m_grp->HrefValue = $this->m_grp->getLinkPrefix() . $this->m_grp->CurrentValue; // Add prefix/suffix
                $this->m_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->m_grp->HrefValue = FullUrl($this->m_grp->HrefValue, "href");
                }
            } else {
                $this->m_grp->HrefValue = "";
            }

            // m_sgrp
            $this->m_sgrp->HrefValue = "";

            // m_product
            $this->m_product->HrefValue = "";

            // m_rid
            $this->m_rid->HrefValue = "";

            // m_packing
            $this->m_packing->HrefValue = "";

            // quantity_a
            $this->quantity_a->HrefValue = "";

            // bom_waste
            $this->bom_waste->HrefValue = "";

            // method
            $this->method->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // gross_nett
            $this->gross_nett->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            $this->product->HrefValue = "";

            // rid
            $this->rid->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // warp_weft
            $this->warp_weft->setupEditAttributes();
            $this->warp_weft->EditValue = $this->warp_weft->options(true);
            $this->warp_weft->PlaceHolder = RemoveHtml($this->warp_weft->caption());

            // m_grp
            $this->m_grp->setupEditAttributes();
            $curVal = strval($this->m_grp->CurrentValue);
            if ($curVal != "") {
                $this->m_grp->EditValue = $this->m_grp->lookupCacheOption($curVal);
                if ($this->m_grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->m_grp->EditValue = $this->m_grp->displayValue($arwrk);
                    } else {
                        $this->m_grp->EditValue = FormatNumber($this->m_grp->CurrentValue, $this->m_grp->formatPattern());
                    }
                }
            } else {
                $this->m_grp->EditValue = null;
            }

            // m_sgrp
            $this->m_sgrp->setupEditAttributes();
            $curVal = strval($this->m_sgrp->CurrentValue);
            if ($curVal != "") {
                $this->m_sgrp->EditValue = $this->m_sgrp->lookupCacheOption($curVal);
                if ($this->m_sgrp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_sgrp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_sgrp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_sgrp->Lookup->renderViewRow($rswrk[0]);
                        $this->m_sgrp->EditValue = $this->m_sgrp->displayValue($arwrk);
                    } else {
                        $this->m_sgrp->EditValue = $this->m_sgrp->CurrentValue;
                    }
                }
            } else {
                $this->m_sgrp->EditValue = null;
            }

            // m_product
            $this->m_product->setupEditAttributes();
            $curVal = strval($this->m_product->CurrentValue);
            if ($curVal != "") {
                $this->m_product->EditValue = $this->m_product->lookupCacheOption($curVal);
                if ($this->m_product->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_product->Lookup->renderViewRow($rswrk[0]);
                        $this->m_product->EditValue = $this->m_product->displayValue($arwrk);
                    } else {
                        $this->m_product->EditValue = $this->m_product->CurrentValue;
                    }
                }
            } else {
                $this->m_product->EditValue = null;
            }

            // m_rid
            $this->m_rid->setupEditAttributes();
            if ($this->m_rid->VirtualValue != "") {
                $this->m_rid->EditValue = $this->m_rid->VirtualValue;
            } else {
                $this->m_rid->EditValue = $this->m_rid->CurrentValue;
                $curVal = strval($this->m_rid->CurrentValue);
                if ($curVal != "") {
                    $this->m_rid->EditValue = $this->m_rid->lookupCacheOption($curVal);
                    if ($this->m_rid->EditValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->m_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->m_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->m_rid->Lookup->renderViewRow($rswrk[0]);
                            $this->m_rid->EditValue = $this->m_rid->displayValue($arwrk);
                        } else {
                            $this->m_rid->EditValue = $this->m_rid->CurrentValue;
                        }
                    }
                } else {
                    $this->m_rid->EditValue = null;
                }
            }

            // m_packing
            $this->m_packing->setupEditAttributes();
            $curVal = strval($this->m_packing->CurrentValue);
            if ($curVal != "") {
                $this->m_packing->EditValue = $this->m_packing->lookupCacheOption($curVal);
                if ($this->m_packing->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->m_packing->EditValue = $this->m_packing->displayValue($arwrk);
                    } else {
                        $this->m_packing->EditValue = FormatNumber($this->m_packing->CurrentValue, $this->m_packing->formatPattern());
                    }
                }
            } else {
                $this->m_packing->EditValue = null;
            }

            // quantity_a
            $this->quantity_a->setupEditAttributes();
            $this->quantity_a->EditValue = $this->quantity_a->CurrentValue;
            $this->quantity_a->PlaceHolder = RemoveHtml($this->quantity_a->caption());
            if (strval($this->quantity_a->EditValue) != "" && is_numeric($this->quantity_a->EditValue)) {
                $this->quantity_a->EditValue = FormatNumber($this->quantity_a->EditValue, null);
            }

            // bom_waste
            $this->bom_waste->setupEditAttributes();
            $this->bom_waste->EditValue = $this->bom_waste->CurrentValue;
            $this->bom_waste->PlaceHolder = RemoveHtml($this->bom_waste->caption());
            if (strval($this->bom_waste->EditValue) != "" && is_numeric($this->bom_waste->EditValue)) {
                $this->bom_waste->EditValue = FormatNumber($this->bom_waste->EditValue, null);
            }

            // method
            $this->method->setupEditAttributes();
            $curVal = trim(strval($this->method->CurrentValue));
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
            } else {
                $this->method->ViewValue = $this->method->Lookup !== null && is_array($this->method->lookupOptions()) && count($this->method->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->method->ViewValue !== null) { // Load from cache
                $this->method->EditValue = array_values($this->method->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->method->CurrentValue, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->method->EditValue = $arwrk;
            }
            $this->method->PlaceHolder = RemoveHtml($this->method->caption());

            // unit
            $this->unit->setupEditAttributes();
            $curVal = trim(strval($this->unit->CurrentValue));
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
            } else {
                $this->unit->ViewValue = $this->unit->Lookup !== null && is_array($this->unit->lookupOptions()) && count($this->unit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->unit->ViewValue !== null) { // Load from cache
                $this->unit->EditValue = array_values($this->unit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->unit->CurrentValue, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->unit->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->unit->EditValue = $arwrk;
            }
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // gross_nett
            $this->gross_nett->setupEditAttributes();
            $this->gross_nett->EditValue = $this->gross_nett->options(true);
            $this->gross_nett->PlaceHolder = RemoveHtml($this->gross_nett->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->EditValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->EditValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->EditValue = null;
            }

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->EditValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->EditValue = null;
            }

            // product
            $this->product->setupEditAttributes();
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->EditValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->EditValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->EditValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->EditValue = null;
            }

            // rid
            $this->rid->setupEditAttributes();
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->EditValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->EditValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->EditValue = null;
            }

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->EditValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->EditValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->EditValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->EditValue = null;
            }

            // batch_no
            $this->batch_no->setupEditAttributes();
            $this->batch_no->EditValue = $this->batch_no->CurrentValue;
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->EditValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->EditValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->EditValue = HtmlEncode($this->batch_no->CurrentValue);
                    }
                }
            } else {
                $this->batch_no->EditValue = null;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // warp_weft
            $this->warp_weft->HrefValue = "";

            // m_grp
            if (!EmptyValue($this->m_grp->CurrentValue)) {
                $this->m_grp->HrefValue = $this->m_grp->getLinkPrefix() . $this->m_grp->CurrentValue; // Add prefix/suffix
                $this->m_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->m_grp->HrefValue = FullUrl($this->m_grp->HrefValue, "href");
                }
            } else {
                $this->m_grp->HrefValue = "";
            }
            $this->m_grp->TooltipValue = "";

            // m_sgrp
            $this->m_sgrp->HrefValue = "";
            $this->m_sgrp->TooltipValue = "";

            // m_product
            $this->m_product->HrefValue = "";
            $this->m_product->TooltipValue = "";

            // m_rid
            $this->m_rid->HrefValue = "";
            $this->m_rid->TooltipValue = "";

            // m_packing
            $this->m_packing->HrefValue = "";
            $this->m_packing->TooltipValue = "";

            // quantity_a
            $this->quantity_a->HrefValue = "";

            // bom_waste
            $this->bom_waste->HrefValue = "";

            // method
            $this->method->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // gross_nett
            $this->gross_nett->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            $this->product->HrefValue = "";
            $this->product->TooltipValue = "";

            // rid
            $this->rid->HrefValue = "";
            $this->rid->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // warp_weft
            $this->warp_weft->setupEditAttributes();
            $this->warp_weft->EditValue = $this->warp_weft->options(true);
            $this->warp_weft->PlaceHolder = RemoveHtml($this->warp_weft->caption());

            // m_grp
            $this->m_grp->setupEditAttributes();
            $this->m_grp->PlaceHolder = RemoveHtml($this->m_grp->caption());

            // m_sgrp
            $this->m_sgrp->setupEditAttributes();
            $this->m_sgrp->PlaceHolder = RemoveHtml($this->m_sgrp->caption());

            // m_product
            $this->m_product->setupEditAttributes();
            $this->m_product->PlaceHolder = RemoveHtml($this->m_product->caption());

            // m_rid
            $this->m_rid->setupEditAttributes();
            $this->m_rid->EditValue = $this->m_rid->AdvancedSearch->SearchValue;
            $this->m_rid->PlaceHolder = RemoveHtml($this->m_rid->caption());

            // m_packing
            $this->m_packing->setupEditAttributes();
            $this->m_packing->PlaceHolder = RemoveHtml($this->m_packing->caption());

            // quantity_a
            $this->quantity_a->setupEditAttributes();
            $this->quantity_a->EditValue = $this->quantity_a->AdvancedSearch->SearchValue;
            $this->quantity_a->PlaceHolder = RemoveHtml($this->quantity_a->caption());
            $this->quantity_a->setupEditAttributes();
            $this->quantity_a->EditValue2 = $this->quantity_a->AdvancedSearch->SearchValue2;
            $this->quantity_a->PlaceHolder = RemoveHtml($this->quantity_a->caption());

            // bom_waste
            $this->bom_waste->setupEditAttributes();
            $this->bom_waste->EditValue = $this->bom_waste->AdvancedSearch->SearchValue;
            $this->bom_waste->PlaceHolder = RemoveHtml($this->bom_waste->caption());

            // method
            $this->method->setupEditAttributes();
            $this->method->PlaceHolder = RemoveHtml($this->method->caption());

            // unit
            $this->unit->setupEditAttributes();
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // gross_nett
            $this->gross_nett->setupEditAttributes();
            $this->gross_nett->EditValue = $this->gross_nett->options(true);
            $this->gross_nett->PlaceHolder = RemoveHtml($this->gross_nett->caption());

            // grp
            $this->grp->setupEditAttributes();
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // batch_no
            $this->batch_no->setupEditAttributes();
            $this->batch_no->EditValue = $this->batch_no->AdvancedSearch->SearchValue;
            $curVal = strval($this->batch_no->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->batch_no->EditValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->EditValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->EditValue = HtmlEncode($this->batch_no->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->batch_no->EditValue = null;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());
            $this->batch_no->setupEditAttributes();
            $this->batch_no->EditValue2 = $this->batch_no->AdvancedSearch->SearchValue2;
            $curVal = strval($this->batch_no->AdvancedSearch->SearchValue2);
            if ($curVal != "") {
                $this->batch_no->EditValue2 = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->EditValue2 === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->EditValue2 = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->EditValue2 = HtmlEncode($this->batch_no->AdvancedSearch->SearchValue2);
                    }
                }
            } else {
                $this->batch_no->EditValue2 = null;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        } elseif ($this->RowType == RowType::AGGREGATEINIT) { // Initialize aggregate row
                    $this->quantity_a->Total = 0; // Initialize total
                    $this->quantity->Total = 0; // Initialize total
        } elseif ($this->RowType == RowType::AGGREGATE) { // Aggregate row
            $this->quantity_a->CurrentValue = $this->quantity_a->Total;
            $this->quantity_a->ViewValue = $this->quantity_a->CurrentValue;
            $this->quantity_a->ViewValue = FormatNumber($this->quantity_a->ViewValue, $this->quantity_a->formatPattern());
            $this->quantity_a->HrefValue = ""; // Clear href value
            $this->quantity->CurrentValue = $this->quantity->Total;
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->HrefValue = ""; // Clear href value
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->warp_weft->Visible && $this->warp_weft->Required) {
                if (!$this->warp_weft->IsDetailKey && EmptyValue($this->warp_weft->FormValue)) {
                    $this->warp_weft->addErrorMessage(str_replace("%s", $this->warp_weft->caption(), $this->warp_weft->RequiredErrorMessage));
                }
            }
            if ($this->m_grp->Visible && $this->m_grp->Required) {
                if (!$this->m_grp->IsDetailKey && EmptyValue($this->m_grp->FormValue)) {
                    $this->m_grp->addErrorMessage(str_replace("%s", $this->m_grp->caption(), $this->m_grp->RequiredErrorMessage));
                }
            }
            if ($this->m_sgrp->Visible && $this->m_sgrp->Required) {
                if (!$this->m_sgrp->IsDetailKey && EmptyValue($this->m_sgrp->FormValue)) {
                    $this->m_sgrp->addErrorMessage(str_replace("%s", $this->m_sgrp->caption(), $this->m_sgrp->RequiredErrorMessage));
                }
            }
            if ($this->m_product->Visible && $this->m_product->Required) {
                if (!$this->m_product->IsDetailKey && EmptyValue($this->m_product->FormValue)) {
                    $this->m_product->addErrorMessage(str_replace("%s", $this->m_product->caption(), $this->m_product->RequiredErrorMessage));
                }
            }
            if ($this->m_rid->Visible && $this->m_rid->Required) {
                if (!$this->m_rid->IsDetailKey && EmptyValue($this->m_rid->FormValue)) {
                    $this->m_rid->addErrorMessage(str_replace("%s", $this->m_rid->caption(), $this->m_rid->RequiredErrorMessage));
                }
            }
            if ($this->m_packing->Visible && $this->m_packing->Required) {
                if (!$this->m_packing->IsDetailKey && EmptyValue($this->m_packing->FormValue)) {
                    $this->m_packing->addErrorMessage(str_replace("%s", $this->m_packing->caption(), $this->m_packing->RequiredErrorMessage));
                }
            }
            if ($this->quantity_a->Visible && $this->quantity_a->Required) {
                if (!$this->quantity_a->IsDetailKey && EmptyValue($this->quantity_a->FormValue)) {
                    $this->quantity_a->addErrorMessage(str_replace("%s", $this->quantity_a->caption(), $this->quantity_a->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity_a->FormValue)) {
                $this->quantity_a->addErrorMessage($this->quantity_a->getErrorMessage(false));
            }
            if ($this->bom_waste->Visible && $this->bom_waste->Required) {
                if (!$this->bom_waste->IsDetailKey && EmptyValue($this->bom_waste->FormValue)) {
                    $this->bom_waste->addErrorMessage(str_replace("%s", $this->bom_waste->caption(), $this->bom_waste->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->bom_waste->FormValue)) {
                $this->bom_waste->addErrorMessage($this->bom_waste->getErrorMessage(false));
            }
            if ($this->method->Visible && $this->method->Required) {
                if (!$this->method->IsDetailKey && EmptyValue($this->method->FormValue)) {
                    $this->method->addErrorMessage(str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
                }
            }
            if ($this->unit->Visible && $this->unit->Required) {
                if (!$this->unit->IsDetailKey && EmptyValue($this->unit->FormValue)) {
                    $this->unit->addErrorMessage(str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
                }
            }
            if ($this->gross_nett->Visible && $this->gross_nett->Required) {
                if (!$this->gross_nett->IsDetailKey && EmptyValue($this->gross_nett->FormValue)) {
                    $this->gross_nett->addErrorMessage(str_replace("%s", $this->gross_nett->caption(), $this->gross_nett->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->AuditTrailOnDelete) {
            $this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        return $deleteRows;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // warp_weft
        $this->warp_weft->setDbValueDef($rsnew, $this->warp_weft->CurrentValue, $this->warp_weft->ReadOnly);

        // quantity_a
        $this->quantity_a->setDbValueDef($rsnew, $this->quantity_a->CurrentValue, $this->quantity_a->ReadOnly);

        // bom_waste
        $this->bom_waste->setDbValueDef($rsnew, $this->bom_waste->CurrentValue, $this->bom_waste->ReadOnly);

        // method
        $this->method->setDbValueDef($rsnew, $this->method->CurrentValue, $this->method->ReadOnly);

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, $this->unit->ReadOnly);

        // gross_nett
        $this->gross_nett->setDbValueDef($rsnew, $this->gross_nett->CurrentValue, $this->gross_nett->ReadOnly);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, $this->batch_no->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['warp_weft'])) { // warp_weft
            $this->warp_weft->CurrentValue = $row['warp_weft'];
        }
        if (isset($row['quantity_a'])) { // quantity_a
            $this->quantity_a->CurrentValue = $row['quantity_a'];
        }
        if (isset($row['bom_waste'])) { // bom_waste
            $this->bom_waste->CurrentValue = $row['bom_waste'];
        }
        if (isset($row['method'])) { // method
            $this->method->CurrentValue = $row['method'];
        }
        if (isset($row['unit'])) { // unit
            $this->unit->CurrentValue = $row['unit'];
        }
        if (isset($row['gross_nett'])) { // gross_nett
            $this->gross_nett->CurrentValue = $row['gross_nett'];
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->CurrentValue = $row['batch_no'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Load row hash
    protected function loadRowHash()
    {
        $filter = $this->getRecordFilter();

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $row = $conn->fetchAssociative($sql);
        $this->HashValue = $row ? $this->getRowHash($row) : ""; // Get hash value for record
    }

    // Get Row Hash
    public function getRowHash($row)
    {
        if (!$row) {
            return "";
        }
        $hash = "";
        $hash .= GetFieldHash($row['warp_weft']); // warp_weft
        $hash .= GetFieldHash($row['quantity_a']); // quantity_a
        $hash .= GetFieldHash($row['bom_waste']); // bom_waste
        $hash .= GetFieldHash($row['method']); // method
        $hash .= GetFieldHash($row['unit']); // unit
        $hash .= GetFieldHash($row['gross_nett']); // gross_nett
        $hash .= GetFieldHash($row['batch_no']); // batch_no
        $hash .= GetFieldHash($row['operator']); // operator
        $hash .= GetFieldHash($row['datetime']); // datetime
        return md5($hash);
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // warp_weft
        $this->warp_weft->setDbValueDef($rsnew, $this->warp_weft->CurrentValue, strval($this->warp_weft->CurrentValue) == "");

        // m_grp
        $this->m_grp->setDbValueDef($rsnew, $this->m_grp->CurrentValue, false);

        // m_sgrp
        $this->m_sgrp->setDbValueDef($rsnew, $this->m_sgrp->CurrentValue, false);

        // m_product
        $this->m_product->setDbValueDef($rsnew, $this->m_product->CurrentValue, false);

        // m_rid
        $this->m_rid->setDbValueDef($rsnew, $this->m_rid->CurrentValue, false);

        // m_packing
        $this->m_packing->setDbValueDef($rsnew, $this->m_packing->CurrentValue, false);

        // quantity_a
        $this->quantity_a->setDbValueDef($rsnew, $this->quantity_a->CurrentValue, false);

        // bom_waste
        $this->bom_waste->setDbValueDef($rsnew, $this->bom_waste->CurrentValue, false);

        // method
        $this->method->setDbValueDef($rsnew, $this->method->CurrentValue, false);

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, false);

        // gross_nett
        $this->gross_nett->setDbValueDef($rsnew, $this->gross_nett->CurrentValue, strval($this->gross_nett->CurrentValue) == "");

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, false);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, strval($this->packing_type->CurrentValue) == "");

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['warp_weft'])) { // warp_weft
            $this->warp_weft->setFormValue($row['warp_weft']);
        }
        if (isset($row['m_grp'])) { // m_grp
            $this->m_grp->setFormValue($row['m_grp']);
        }
        if (isset($row['m_sgrp'])) { // m_sgrp
            $this->m_sgrp->setFormValue($row['m_sgrp']);
        }
        if (isset($row['m_product'])) { // m_product
            $this->m_product->setFormValue($row['m_product']);
        }
        if (isset($row['m_rid'])) { // m_rid
            $this->m_rid->setFormValue($row['m_rid']);
        }
        if (isset($row['m_packing'])) { // m_packing
            $this->m_packing->setFormValue($row['m_packing']);
        }
        if (isset($row['quantity_a'])) { // quantity_a
            $this->quantity_a->setFormValue($row['quantity_a']);
        }
        if (isset($row['bom_waste'])) { // bom_waste
            $this->bom_waste->setFormValue($row['bom_waste']);
        }
        if (isset($row['method'])) { // method
            $this->method->setFormValue($row['method']);
        }
        if (isset($row['unit'])) { // unit
            $this->unit->setFormValue($row['unit']);
        }
        if (isset($row['gross_nett'])) { // gross_nett
            $this->gross_nett->setFormValue($row['gross_nett']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['rid'])) { // rid
            $this->rid->setFormValue($row['rid']);
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->setFormValue($row['packing_type']);
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->setFormValue($row['batch_no']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->warp_weft->AdvancedSearch->load();
        $this->m_grp->AdvancedSearch->load();
        $this->m_sgrp->AdvancedSearch->load();
        $this->m_product->AdvancedSearch->load();
        $this->m_rid->AdvancedSearch->load();
        $this->m_packing->AdvancedSearch->load();
        $this->bom_waste->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->method->AdvancedSearch->load();
        $this->unit->AdvancedSearch->load();
        $this->gross_nett->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->rid->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->batch_no->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fbomlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fbomlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fbomlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fbomlist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fbomsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"bom\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"bomsearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"bomsearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fbomsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_warp_weft":
                    break;
                case "x_m_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_m_sgrp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_m_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_m_rid":
                    break;
                case "x_m_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_method":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_unit":
                    break;
                case "x_gross_nett":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_batch_no":
                    break;
                case "x_operator":
                    break;
                case "x_a_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'bom');
    	$this->OtherOptions["addedit"]->Items["add"]->Visible = False;
    	$this->OtherOptions["addedit"]->Items["gridadd"]->Visible = False;
    	$this->grp->ReadOnly=true;
    	$this->m_name->ReadOnly=true;
    	$this->s_grp->ReadOnly=true;
    	$this->product->ReadOnly=true;
    	$this->rid->ReadOnly=true;
    	$this->packing_type->ReadOnly=true;	
    	$this->batch_no->ReadOnly=true;
    	if((isset($_GET['action']) == 'gridadd') || (isset($_GET['action']) == 'gridedit'))
    	{
    		$this->a_operator->Visible=false;
    		$this->a_datetime->Visible=false;
    	}
        $bbatch_no = (isset($_GET['x_batch_no']) and ($_GET['x_batch_no'] > 0)) ? $_GET['x_batch_no'] : 0;
    	$aa_operator = ExecuteScalar("SELECT ifnull((Select `a_operator` from `bom` where `bom`.`batch_no` = $bbatch_no limit 1),0)");
    	if( ($bbatch_no > 0) && ($aa_operator == 0))
    	{
    		$this->OtherOptions["addedit"]->Items["gridedit"]->Visible = True;
    	}
    	else
    	{
    		$this->OtherOptions["addedit"]->Items["gridedit"]->Visible = False;
    	}
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header) {
    	// Example:
    	//$header = "your header";
    	if(isset($_GET['action'])){
    		if($_GET['action']== 'gridedit')
    		{
    			$this->OtherOptions["addedit"]->Items["addblankrow"]->Visible = FALSE;
    		}
    	}
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered() {
    	// Example:
    	//$this->ListOptions->Items["new"]->Body = "xxx";
        $bomedit = ExecuteScalar("SELECT `bom_edit` FROM `portal_setup` limit 1");
    	$bomeditarr = explode(',', $bomedit);
        $CUID = CurrentUserID();
        if(($this->a_operator->CurrentValue != 0) &&  (!in_array($CUID, $bomeditarr)))
    	{
    	$this->ListOptions->Items["edit"]->Visible = False;
    	$this->ListOptions->Items["copy"]->Visible = False;
    	$this->ListOptions->Items["delete"]->Visible = False;
    	}
    	else
    	{
    	$this->ListOptions->Items["edit"]->Visible = True;
    	$this->ListOptions->Items["copy"]->Visible = True;
    	$this->ListOptions->Items["delete"]->Visible = True;
    	}
        if(($this->a_operator->CurrentValue != 0) && (!in_array($CUID, $bomeditarr)))
        {
        $this->ListOptions->Items["griddelete"]->Visible = False;  
        $this->warp_weft->ReadOnly=true;
        $this->m_grp->ReadOnly=true;
        $this->m_name->ReadOnly=true;
        $this->m_rid->ReadOnly=true;
        $this->quantity_a->ReadOnly=true;
        $this->bom_waste->ReadOnly=true;
        $this->method->ReadOnly=true;
        $this->quantity->ReadOnly=true;
        $this->unit->ReadOnly=true;
        }
        else
        { 
        $this->ListOptions->Items["griddelete"]->Visible = true;
        $this->warp_weft->ReadOnly=false;
        $this->m_grp->ReadOnly=false;
        $this->m_name->ReadOnly=false;
        $this->m_rid->ReadOnly=false;
        $this->quantity_a->ReadOnly=false;
        $this->bom_waste->ReadOnly=false;
        $this->method->ReadOnly=false;
        $this->quantity->ReadOnly=false;
        $this->unit->ReadOnly=false;
        } 
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
