<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BomEdit extends Bom
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BomEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "bomedit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->warp_weft->setVisibility();
        $this->m_grp->setVisibility();
        $this->m_sgrp->setVisibility();
        $this->m_product->setVisibility();
        $this->m_rid->setVisibility();
        $this->m_packing->setVisibility();
        $this->m_name->Visible = false;
        $this->quantity_a->setVisibility();
        $this->bom_waste->setVisibility();
        $this->quantity->Visible = false;
        $this->method->setVisibility();
        $this->unit->setVisibility();
        $this->gross_nett->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->packing_type->setVisibility();
        $this->batch_no->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->a_operator->Visible = false;
        $this->a_datetime->Visible = false;
        $this->pp_qty->Visible = false;
        $this->pp_bal->Visible = false;
        $this->pp_id->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'bom';
        $this->TableName = 'bom';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (bom)
        if (!isset($GLOBALS["bom"]) || $GLOBALS["bom"]::class == PROJECT_NAMESPACE . "bom") {
            $GLOBALS["bom"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'bom');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "bomview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->m_grp->Required = false;
        $this->m_sgrp->Required = false;
        $this->m_product->Required = false;
        $this->m_rid->Required = false;
        $this->grp->Required = false;
        $this->s_grp->Required = false;
        $this->product->Required = false;
        $this->rid->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->warp_weft);
        $this->setupLookupOptions($this->m_grp);
        $this->setupLookupOptions($this->m_sgrp);
        $this->setupLookupOptions($this->m_product);
        $this->setupLookupOptions($this->m_rid);
        $this->setupLookupOptions($this->m_packing);
        $this->setupLookupOptions($this->method);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->gross_nett);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->a_operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("bomlist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "bomlist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "bomlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "bomlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'warp_weft' first before field var 'x_warp_weft'
        $val = $CurrentForm->hasValue("warp_weft") ? $CurrentForm->getValue("warp_weft") : $CurrentForm->getValue("x_warp_weft");
        if (!$this->warp_weft->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->warp_weft->Visible = false; // Disable update for API request
            } else {
                $this->warp_weft->setFormValue($val);
            }
        }

        // Check field name 'm_grp' first before field var 'x_m_grp'
        $val = $CurrentForm->hasValue("m_grp") ? $CurrentForm->getValue("m_grp") : $CurrentForm->getValue("x_m_grp");
        if (!$this->m_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_grp->Visible = false; // Disable update for API request
            } else {
                $this->m_grp->setFormValue($val);
            }
        }

        // Check field name 'm_sgrp' first before field var 'x_m_sgrp'
        $val = $CurrentForm->hasValue("m_sgrp") ? $CurrentForm->getValue("m_sgrp") : $CurrentForm->getValue("x_m_sgrp");
        if (!$this->m_sgrp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_sgrp->Visible = false; // Disable update for API request
            } else {
                $this->m_sgrp->setFormValue($val);
            }
        }

        // Check field name 'm_product' first before field var 'x_m_product'
        $val = $CurrentForm->hasValue("m_product") ? $CurrentForm->getValue("m_product") : $CurrentForm->getValue("x_m_product");
        if (!$this->m_product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_product->Visible = false; // Disable update for API request
            } else {
                $this->m_product->setFormValue($val);
            }
        }

        // Check field name 'm_rid' first before field var 'x_m_rid'
        $val = $CurrentForm->hasValue("m_rid") ? $CurrentForm->getValue("m_rid") : $CurrentForm->getValue("x_m_rid");
        if (!$this->m_rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_rid->Visible = false; // Disable update for API request
            } else {
                $this->m_rid->setFormValue($val);
            }
        }

        // Check field name 'm_packing' first before field var 'x_m_packing'
        $val = $CurrentForm->hasValue("m_packing") ? $CurrentForm->getValue("m_packing") : $CurrentForm->getValue("x_m_packing");
        if (!$this->m_packing->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_packing->Visible = false; // Disable update for API request
            } else {
                $this->m_packing->setFormValue($val);
            }
        }

        // Check field name 'quantity_a' first before field var 'x_quantity_a'
        $val = $CurrentForm->hasValue("quantity_a") ? $CurrentForm->getValue("quantity_a") : $CurrentForm->getValue("x_quantity_a");
        if (!$this->quantity_a->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity_a->Visible = false; // Disable update for API request
            } else {
                $this->quantity_a->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'bom_waste' first before field var 'x_bom_waste'
        $val = $CurrentForm->hasValue("bom_waste") ? $CurrentForm->getValue("bom_waste") : $CurrentForm->getValue("x_bom_waste");
        if (!$this->bom_waste->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bom_waste->Visible = false; // Disable update for API request
            } else {
                $this->bom_waste->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'method' first before field var 'x_method'
        $val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
        if (!$this->method->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->method->Visible = false; // Disable update for API request
            } else {
                $this->method->setFormValue($val);
            }
        }

        // Check field name 'unit' first before field var 'x_unit'
        $val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
        if (!$this->unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit->Visible = false; // Disable update for API request
            } else {
                $this->unit->setFormValue($val);
            }
        }

        // Check field name 'gross_nett' first before field var 'x_gross_nett'
        $val = $CurrentForm->hasValue("gross_nett") ? $CurrentForm->getValue("gross_nett") : $CurrentForm->getValue("x_gross_nett");
        if (!$this->gross_nett->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gross_nett->Visible = false; // Disable update for API request
            } else {
                $this->gross_nett->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->warp_weft->CurrentValue = $this->warp_weft->FormValue;
        $this->m_grp->CurrentValue = $this->m_grp->FormValue;
        $this->m_sgrp->CurrentValue = $this->m_sgrp->FormValue;
        $this->m_product->CurrentValue = $this->m_product->FormValue;
        $this->m_rid->CurrentValue = $this->m_rid->FormValue;
        $this->m_packing->CurrentValue = $this->m_packing->FormValue;
        $this->quantity_a->CurrentValue = $this->quantity_a->FormValue;
        $this->bom_waste->CurrentValue = $this->bom_waste->FormValue;
        $this->method->CurrentValue = $this->method->FormValue;
        $this->unit->CurrentValue = $this->unit->FormValue;
        $this->gross_nett->CurrentValue = $this->gross_nett->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->warp_weft->setDbValue($row['warp_weft']);
        $this->m_grp->setDbValue($row['m_grp']);
        $this->m_sgrp->setDbValue($row['m_sgrp']);
        $this->m_product->setDbValue($row['m_product']);
        $this->m_rid->setDbValue($row['m_rid']);
        if (array_key_exists('EV__m_rid', $row)) {
            $this->m_rid->VirtualValue = $row['EV__m_rid']; // Set up virtual field value
        } else {
            $this->m_rid->VirtualValue = ""; // Clear value
        }
        $this->m_packing->setDbValue($row['m_packing']);
        $this->m_name->setDbValue($row['m_name']);
        $this->quantity_a->setDbValue($row['quantity_a']);
        $this->bom_waste->setDbValue($row['bom_waste']);
        $this->quantity->setDbValue($row['quantity']);
        $this->method->setDbValue($row['method']);
        $this->unit->setDbValue($row['unit']);
        $this->gross_nett->setDbValue($row['gross_nett']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->pp_qty->setDbValue($row['pp_qty']);
        $this->pp_bal->setDbValue($row['pp_bal']);
        $this->pp_id->setDbValue($row['pp_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['warp_weft'] = $this->warp_weft->DefaultValue;
        $row['m_grp'] = $this->m_grp->DefaultValue;
        $row['m_sgrp'] = $this->m_sgrp->DefaultValue;
        $row['m_product'] = $this->m_product->DefaultValue;
        $row['m_rid'] = $this->m_rid->DefaultValue;
        $row['m_packing'] = $this->m_packing->DefaultValue;
        $row['m_name'] = $this->m_name->DefaultValue;
        $row['quantity_a'] = $this->quantity_a->DefaultValue;
        $row['bom_waste'] = $this->bom_waste->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['method'] = $this->method->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['gross_nett'] = $this->gross_nett->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['pp_qty'] = $this->pp_qty->DefaultValue;
        $row['pp_bal'] = $this->pp_bal->DefaultValue;
        $row['pp_id'] = $this->pp_id->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // warp_weft
        $this->warp_weft->RowCssClass = "row";

        // m_grp
        $this->m_grp->RowCssClass = "row";

        // m_sgrp
        $this->m_sgrp->RowCssClass = "row";

        // m_product
        $this->m_product->RowCssClass = "row";

        // m_rid
        $this->m_rid->RowCssClass = "row";

        // m_packing
        $this->m_packing->RowCssClass = "row";

        // m_name
        $this->m_name->RowCssClass = "row";

        // quantity_a
        $this->quantity_a->RowCssClass = "row";

        // bom_waste
        $this->bom_waste->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // method
        $this->method->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // gross_nett
        $this->gross_nett->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // pp_qty
        $this->pp_qty->RowCssClass = "row";

        // pp_bal
        $this->pp_bal->RowCssClass = "row";

        // pp_id
        $this->pp_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // warp_weft
            if (strval($this->warp_weft->CurrentValue) != "") {
                $this->warp_weft->ViewValue = $this->warp_weft->optionCaption($this->warp_weft->CurrentValue);
            } else {
                $this->warp_weft->ViewValue = null;
            }

            // m_grp
            $curVal = strval($this->m_grp->CurrentValue);
            if ($curVal != "") {
                $this->m_grp->ViewValue = $this->m_grp->lookupCacheOption($curVal);
                if ($this->m_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->m_grp->ViewValue = $this->m_grp->displayValue($arwrk);
                    } else {
                        $this->m_grp->ViewValue = FormatNumber($this->m_grp->CurrentValue, $this->m_grp->formatPattern());
                    }
                }
            } else {
                $this->m_grp->ViewValue = null;
            }

            // m_sgrp
            $curVal = strval($this->m_sgrp->CurrentValue);
            if ($curVal != "") {
                $this->m_sgrp->ViewValue = $this->m_sgrp->lookupCacheOption($curVal);
                if ($this->m_sgrp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_sgrp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_sgrp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_sgrp->Lookup->renderViewRow($rswrk[0]);
                        $this->m_sgrp->ViewValue = $this->m_sgrp->displayValue($arwrk);
                    } else {
                        $this->m_sgrp->ViewValue = $this->m_sgrp->CurrentValue;
                    }
                }
            } else {
                $this->m_sgrp->ViewValue = null;
            }

            // m_product
            $curVal = strval($this->m_product->CurrentValue);
            if ($curVal != "") {
                $this->m_product->ViewValue = $this->m_product->lookupCacheOption($curVal);
                if ($this->m_product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_product->Lookup->renderViewRow($rswrk[0]);
                        $this->m_product->ViewValue = $this->m_product->displayValue($arwrk);
                    } else {
                        $this->m_product->ViewValue = $this->m_product->CurrentValue;
                    }
                }
            } else {
                $this->m_product->ViewValue = null;
            }

            // m_rid
            if ($this->m_rid->VirtualValue != "") {
                $this->m_rid->ViewValue = $this->m_rid->VirtualValue;
            } else {
                $this->m_rid->ViewValue = $this->m_rid->CurrentValue;
                $curVal = strval($this->m_rid->CurrentValue);
                if ($curVal != "") {
                    $this->m_rid->ViewValue = $this->m_rid->lookupCacheOption($curVal);
                    if ($this->m_rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->m_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->m_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->m_rid->Lookup->renderViewRow($rswrk[0]);
                            $this->m_rid->ViewValue = $this->m_rid->displayValue($arwrk);
                        } else {
                            $this->m_rid->ViewValue = $this->m_rid->CurrentValue;
                        }
                    }
                } else {
                    $this->m_rid->ViewValue = null;
                }
            }

            // m_packing
            $curVal = strval($this->m_packing->CurrentValue);
            if ($curVal != "") {
                $this->m_packing->ViewValue = $this->m_packing->lookupCacheOption($curVal);
                if ($this->m_packing->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->m_packing->ViewValue = $this->m_packing->displayValue($arwrk);
                    } else {
                        $this->m_packing->ViewValue = FormatNumber($this->m_packing->CurrentValue, $this->m_packing->formatPattern());
                    }
                }
            } else {
                $this->m_packing->ViewValue = null;
            }

            // quantity_a
            $this->quantity_a->ViewValue = $this->quantity_a->CurrentValue;
            $this->quantity_a->ViewValue = FormatNumber($this->quantity_a->ViewValue, $this->quantity_a->formatPattern());

            // bom_waste
            $this->bom_waste->ViewValue = $this->bom_waste->CurrentValue;
            $this->bom_waste->ViewValue = FormatNumber($this->bom_waste->ViewValue, $this->bom_waste->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;

            // method
            $curVal = strval($this->method->CurrentValue);
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
                if ($this->method->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->method->getSelectFilter($this); // PHP
                    $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                        $this->method->ViewValue = $this->method->displayValue($arwrk);
                    } else {
                        $this->method->ViewValue = $this->method->CurrentValue;
                    }
                }
            } else {
                $this->method->ViewValue = null;
            }

            // unit
            $curVal = strval($this->unit->CurrentValue);
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
                if ($this->unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                        $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                    } else {
                        $this->unit->ViewValue = $this->unit->CurrentValue;
                    }
                }
            } else {
                $this->unit->ViewValue = null;
            }

            // gross_nett
            if (strval($this->gross_nett->CurrentValue) != "") {
                $this->gross_nett->ViewValue = $this->gross_nett->optionCaption($this->gross_nett->CurrentValue);
            } else {
                $this->gross_nett->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // batch_no
            $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;

            // id
            $this->id->HrefValue = "";

            // warp_weft
            $this->warp_weft->HrefValue = "";

            // m_grp
            if (!EmptyValue($this->m_grp->CurrentValue)) {
                $this->m_grp->HrefValue = $this->m_grp->getLinkPrefix() . $this->m_grp->CurrentValue; // Add prefix/suffix
                $this->m_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->m_grp->HrefValue = FullUrl($this->m_grp->HrefValue, "href");
                }
            } else {
                $this->m_grp->HrefValue = "";
            }
            $this->m_grp->TooltipValue = "";

            // m_sgrp
            $this->m_sgrp->HrefValue = "";
            $this->m_sgrp->TooltipValue = "";

            // m_product
            $this->m_product->HrefValue = "";
            $this->m_product->TooltipValue = "";

            // m_rid
            $this->m_rid->HrefValue = "";
            $this->m_rid->TooltipValue = "";

            // m_packing
            $this->m_packing->HrefValue = "";
            $this->m_packing->TooltipValue = "";

            // quantity_a
            $this->quantity_a->HrefValue = "";

            // bom_waste
            $this->bom_waste->HrefValue = "";

            // method
            $this->method->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // gross_nett
            $this->gross_nett->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            $this->product->HrefValue = "";
            $this->product->TooltipValue = "";

            // rid
            $this->rid->HrefValue = "";
            $this->rid->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // warp_weft
            $this->warp_weft->setupEditAttributes();
            $this->warp_weft->EditValue = $this->warp_weft->options(true);
            $this->warp_weft->PlaceHolder = RemoveHtml($this->warp_weft->caption());

            // m_grp
            $this->m_grp->setupEditAttributes();
            $curVal = strval($this->m_grp->CurrentValue);
            if ($curVal != "") {
                $this->m_grp->EditValue = $this->m_grp->lookupCacheOption($curVal);
                if ($this->m_grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->m_grp->EditValue = $this->m_grp->displayValue($arwrk);
                    } else {
                        $this->m_grp->EditValue = FormatNumber($this->m_grp->CurrentValue, $this->m_grp->formatPattern());
                    }
                }
            } else {
                $this->m_grp->EditValue = null;
            }

            // m_sgrp
            $this->m_sgrp->setupEditAttributes();
            $curVal = strval($this->m_sgrp->CurrentValue);
            if ($curVal != "") {
                $this->m_sgrp->EditValue = $this->m_sgrp->lookupCacheOption($curVal);
                if ($this->m_sgrp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_sgrp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_sgrp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_sgrp->Lookup->renderViewRow($rswrk[0]);
                        $this->m_sgrp->EditValue = $this->m_sgrp->displayValue($arwrk);
                    } else {
                        $this->m_sgrp->EditValue = $this->m_sgrp->CurrentValue;
                    }
                }
            } else {
                $this->m_sgrp->EditValue = null;
            }

            // m_product
            $this->m_product->setupEditAttributes();
            $curVal = strval($this->m_product->CurrentValue);
            if ($curVal != "") {
                $this->m_product->EditValue = $this->m_product->lookupCacheOption($curVal);
                if ($this->m_product->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_product->Lookup->renderViewRow($rswrk[0]);
                        $this->m_product->EditValue = $this->m_product->displayValue($arwrk);
                    } else {
                        $this->m_product->EditValue = $this->m_product->CurrentValue;
                    }
                }
            } else {
                $this->m_product->EditValue = null;
            }

            // m_rid
            $this->m_rid->setupEditAttributes();
            if ($this->m_rid->VirtualValue != "") {
                $this->m_rid->EditValue = $this->m_rid->VirtualValue;
            } else {
                $this->m_rid->EditValue = $this->m_rid->CurrentValue;
                $curVal = strval($this->m_rid->CurrentValue);
                if ($curVal != "") {
                    $this->m_rid->EditValue = $this->m_rid->lookupCacheOption($curVal);
                    if ($this->m_rid->EditValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->m_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->m_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->m_rid->Lookup->renderViewRow($rswrk[0]);
                            $this->m_rid->EditValue = $this->m_rid->displayValue($arwrk);
                        } else {
                            $this->m_rid->EditValue = $this->m_rid->CurrentValue;
                        }
                    }
                } else {
                    $this->m_rid->EditValue = null;
                }
            }

            // m_packing
            $this->m_packing->setupEditAttributes();
            $curVal = strval($this->m_packing->CurrentValue);
            if ($curVal != "") {
                $this->m_packing->EditValue = $this->m_packing->lookupCacheOption($curVal);
                if ($this->m_packing->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->m_packing->EditValue = $this->m_packing->displayValue($arwrk);
                    } else {
                        $this->m_packing->EditValue = FormatNumber($this->m_packing->CurrentValue, $this->m_packing->formatPattern());
                    }
                }
            } else {
                $this->m_packing->EditValue = null;
            }

            // quantity_a
            $this->quantity_a->setupEditAttributes();
            $this->quantity_a->EditValue = $this->quantity_a->CurrentValue;
            $this->quantity_a->PlaceHolder = RemoveHtml($this->quantity_a->caption());
            if (strval($this->quantity_a->EditValue) != "" && is_numeric($this->quantity_a->EditValue)) {
                $this->quantity_a->EditValue = FormatNumber($this->quantity_a->EditValue, null);
            }

            // bom_waste
            $this->bom_waste->setupEditAttributes();
            $this->bom_waste->EditValue = $this->bom_waste->CurrentValue;
            $this->bom_waste->PlaceHolder = RemoveHtml($this->bom_waste->caption());
            if (strval($this->bom_waste->EditValue) != "" && is_numeric($this->bom_waste->EditValue)) {
                $this->bom_waste->EditValue = FormatNumber($this->bom_waste->EditValue, null);
            }

            // method
            $this->method->setupEditAttributes();
            $curVal = trim(strval($this->method->CurrentValue));
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
            } else {
                $this->method->ViewValue = $this->method->Lookup !== null && is_array($this->method->lookupOptions()) && count($this->method->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->method->ViewValue !== null) { // Load from cache
                $this->method->EditValue = array_values($this->method->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->method->CurrentValue, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->method->EditValue = $arwrk;
            }
            $this->method->PlaceHolder = RemoveHtml($this->method->caption());

            // unit
            $this->unit->setupEditAttributes();
            $curVal = trim(strval($this->unit->CurrentValue));
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
            } else {
                $this->unit->ViewValue = $this->unit->Lookup !== null && is_array($this->unit->lookupOptions()) && count($this->unit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->unit->ViewValue !== null) { // Load from cache
                $this->unit->EditValue = array_values($this->unit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->unit->CurrentValue, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->unit->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->unit->EditValue = $arwrk;
            }
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // gross_nett
            $this->gross_nett->setupEditAttributes();
            $this->gross_nett->EditValue = $this->gross_nett->options(true);
            $this->gross_nett->PlaceHolder = RemoveHtml($this->gross_nett->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->EditValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->EditValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->EditValue = null;
            }

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->EditValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->EditValue = null;
            }

            // product
            $this->product->setupEditAttributes();
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->EditValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->EditValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->EditValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->EditValue = null;
            }

            // rid
            $this->rid->setupEditAttributes();
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->EditValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->EditValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->EditValue = null;
            }

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->EditValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->EditValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->EditValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->EditValue = null;
            }

            // batch_no
            $this->batch_no->setupEditAttributes();
            $this->batch_no->EditValue = $this->batch_no->CurrentValue;
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->EditValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->EditValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->EditValue = HtmlEncode($this->batch_no->CurrentValue);
                    }
                }
            } else {
                $this->batch_no->EditValue = null;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // warp_weft
            $this->warp_weft->HrefValue = "";

            // m_grp
            if (!EmptyValue($this->m_grp->CurrentValue)) {
                $this->m_grp->HrefValue = $this->m_grp->getLinkPrefix() . $this->m_grp->CurrentValue; // Add prefix/suffix
                $this->m_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->m_grp->HrefValue = FullUrl($this->m_grp->HrefValue, "href");
                }
            } else {
                $this->m_grp->HrefValue = "";
            }
            $this->m_grp->TooltipValue = "";

            // m_sgrp
            $this->m_sgrp->HrefValue = "";
            $this->m_sgrp->TooltipValue = "";

            // m_product
            $this->m_product->HrefValue = "";
            $this->m_product->TooltipValue = "";

            // m_rid
            $this->m_rid->HrefValue = "";
            $this->m_rid->TooltipValue = "";

            // m_packing
            $this->m_packing->HrefValue = "";
            $this->m_packing->TooltipValue = "";

            // quantity_a
            $this->quantity_a->HrefValue = "";

            // bom_waste
            $this->bom_waste->HrefValue = "";

            // method
            $this->method->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // gross_nett
            $this->gross_nett->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            $this->product->HrefValue = "";
            $this->product->TooltipValue = "";

            // rid
            $this->rid->HrefValue = "";
            $this->rid->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->warp_weft->Visible && $this->warp_weft->Required) {
                if (!$this->warp_weft->IsDetailKey && EmptyValue($this->warp_weft->FormValue)) {
                    $this->warp_weft->addErrorMessage(str_replace("%s", $this->warp_weft->caption(), $this->warp_weft->RequiredErrorMessage));
                }
            }
            if ($this->m_grp->Visible && $this->m_grp->Required) {
                if (!$this->m_grp->IsDetailKey && EmptyValue($this->m_grp->FormValue)) {
                    $this->m_grp->addErrorMessage(str_replace("%s", $this->m_grp->caption(), $this->m_grp->RequiredErrorMessage));
                }
            }
            if ($this->m_sgrp->Visible && $this->m_sgrp->Required) {
                if (!$this->m_sgrp->IsDetailKey && EmptyValue($this->m_sgrp->FormValue)) {
                    $this->m_sgrp->addErrorMessage(str_replace("%s", $this->m_sgrp->caption(), $this->m_sgrp->RequiredErrorMessage));
                }
            }
            if ($this->m_product->Visible && $this->m_product->Required) {
                if (!$this->m_product->IsDetailKey && EmptyValue($this->m_product->FormValue)) {
                    $this->m_product->addErrorMessage(str_replace("%s", $this->m_product->caption(), $this->m_product->RequiredErrorMessage));
                }
            }
            if ($this->m_rid->Visible && $this->m_rid->Required) {
                if (!$this->m_rid->IsDetailKey && EmptyValue($this->m_rid->FormValue)) {
                    $this->m_rid->addErrorMessage(str_replace("%s", $this->m_rid->caption(), $this->m_rid->RequiredErrorMessage));
                }
            }
            if ($this->m_packing->Visible && $this->m_packing->Required) {
                if (!$this->m_packing->IsDetailKey && EmptyValue($this->m_packing->FormValue)) {
                    $this->m_packing->addErrorMessage(str_replace("%s", $this->m_packing->caption(), $this->m_packing->RequiredErrorMessage));
                }
            }
            if ($this->quantity_a->Visible && $this->quantity_a->Required) {
                if (!$this->quantity_a->IsDetailKey && EmptyValue($this->quantity_a->FormValue)) {
                    $this->quantity_a->addErrorMessage(str_replace("%s", $this->quantity_a->caption(), $this->quantity_a->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity_a->FormValue)) {
                $this->quantity_a->addErrorMessage($this->quantity_a->getErrorMessage(false));
            }
            if ($this->bom_waste->Visible && $this->bom_waste->Required) {
                if (!$this->bom_waste->IsDetailKey && EmptyValue($this->bom_waste->FormValue)) {
                    $this->bom_waste->addErrorMessage(str_replace("%s", $this->bom_waste->caption(), $this->bom_waste->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->bom_waste->FormValue)) {
                $this->bom_waste->addErrorMessage($this->bom_waste->getErrorMessage(false));
            }
            if ($this->method->Visible && $this->method->Required) {
                if (!$this->method->IsDetailKey && EmptyValue($this->method->FormValue)) {
                    $this->method->addErrorMessage(str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
                }
            }
            if ($this->unit->Visible && $this->unit->Required) {
                if (!$this->unit->IsDetailKey && EmptyValue($this->unit->FormValue)) {
                    $this->unit->addErrorMessage(str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
                }
            }
            if ($this->gross_nett->Visible && $this->gross_nett->Required) {
                if (!$this->gross_nett->IsDetailKey && EmptyValue($this->gross_nett->FormValue)) {
                    $this->gross_nett->addErrorMessage(str_replace("%s", $this->gross_nett->caption(), $this->gross_nett->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // warp_weft
        $this->warp_weft->setDbValueDef($rsnew, $this->warp_weft->CurrentValue, $this->warp_weft->ReadOnly);

        // quantity_a
        $this->quantity_a->setDbValueDef($rsnew, $this->quantity_a->CurrentValue, $this->quantity_a->ReadOnly);

        // bom_waste
        $this->bom_waste->setDbValueDef($rsnew, $this->bom_waste->CurrentValue, $this->bom_waste->ReadOnly);

        // method
        $this->method->setDbValueDef($rsnew, $this->method->CurrentValue, $this->method->ReadOnly);

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, $this->unit->ReadOnly);

        // gross_nett
        $this->gross_nett->setDbValueDef($rsnew, $this->gross_nett->CurrentValue, $this->gross_nett->ReadOnly);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, $this->batch_no->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['warp_weft'])) { // warp_weft
            $this->warp_weft->CurrentValue = $row['warp_weft'];
        }
        if (isset($row['quantity_a'])) { // quantity_a
            $this->quantity_a->CurrentValue = $row['quantity_a'];
        }
        if (isset($row['bom_waste'])) { // bom_waste
            $this->bom_waste->CurrentValue = $row['bom_waste'];
        }
        if (isset($row['method'])) { // method
            $this->method->CurrentValue = $row['method'];
        }
        if (isset($row['unit'])) { // unit
            $this->unit->CurrentValue = $row['unit'];
        }
        if (isset($row['gross_nett'])) { // gross_nett
            $this->gross_nett->CurrentValue = $row['gross_nett'];
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->CurrentValue = $row['batch_no'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bomlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_warp_weft":
                    break;
                case "x_m_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_m_sgrp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_m_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_m_rid":
                    break;
                case "x_m_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_method":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_unit":
                    break;
                case "x_gross_nett":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_batch_no":
                    break;
                case "x_operator":
                    break;
                case "x_a_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    PageFieldValidate($this,'bom');
    $this->grp->ReadOnly=true;
    $this->s_grp->ReadOnly=true;
    $this->product->ReadOnly=true;
    $this->rid->ReadOnly=true;
    $this->packing_type->ReadOnly=true;
    $this->batch_no->ReadOnly=true;
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
