<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for bom
 */
class Bom extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $warp_weft;
    public $m_grp;
    public $m_sgrp;
    public $m_product;
    public $m_rid;
    public $m_packing;
    public $m_name;
    public $quantity_a;
    public $bom_waste;
    public $quantity;
    public $method;
    public $unit;
    public $gross_nett;
    public $grp;
    public $s_grp;
    public $product;
    public $rid;
    public $packing_type;
    public $batch_no;
    public $operator;
    public $datetime;
    public $a_operator;
    public $a_datetime;
    public $pp_qty;
    public $pp_bal;
    public $pp_id;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "bom";
        $this->TableName = 'bom';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "bom";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // warp_weft
        $this->warp_weft = new DbField(
            $this, // Table
            'x_warp_weft', // Variable name
            'warp_weft', // Name
            '`warp_weft`', // Expression
            '`warp_weft`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`warp_weft`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->warp_weft->InputTextType = "text";
        $this->warp_weft->Raw = true;
        $this->warp_weft->Nullable = false; // NOT NULL field
        $this->warp_weft->setSelectMultiple(false); // Select one
        $this->warp_weft->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->warp_weft->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->warp_weft->Lookup = new Lookup($this->warp_weft, 'bom', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->warp_weft->OptionCount = 4;
        $this->warp_weft->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->warp_weft->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['warp_weft'] = &$this->warp_weft;

        // m_grp
        $this->m_grp = new DbField(
            $this, // Table
            'x_m_grp', // Variable name
            'm_grp', // Name
            '`m_grp`', // Expression
            '`m_grp`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`m_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->m_grp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->m_grp->addMethod("getLinkPrefix", fn() => "bomlist?x_m_grp=");
        $this->m_grp->InputTextType = "text";
        $this->m_grp->Raw = true;
        $this->m_grp->Nullable = false; // NOT NULL field
        $this->m_grp->Required = true; // Required field
        $this->m_grp->setSelectMultiple(false); // Select one
        $this->m_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->m_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->m_grp->Lookup = new Lookup($this->m_grp, 'grp', false, 'id', ["grp","","",""], '', '', [], ["x_m_sgrp"], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->m_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->m_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['m_grp'] = &$this->m_grp;

        // m_sgrp
        $this->m_sgrp = new DbField(
            $this, // Table
            'x_m_sgrp', // Variable name
            'm_sgrp', // Name
            '`m_sgrp`', // Expression
            '`m_sgrp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`m_sgrp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->m_sgrp->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->m_sgrp->addMethod("getLinkPrefix", fn() => "bomlist?x_m_sgrp=");
        $this->m_sgrp->InputTextType = "text";
        $this->m_sgrp->Raw = true;
        $this->m_sgrp->Nullable = false; // NOT NULL field
        $this->m_sgrp->Required = true; // Required field
        $this->m_sgrp->setSelectMultiple(false); // Select one
        $this->m_sgrp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->m_sgrp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->m_sgrp->Lookup = new Lookup($this->m_sgrp, 'product_group', false, 'id', ["product_group","","",""], '', '', ["x_m_grp"], ["x_m_product","x_m_rid"], ["grp"], ["x_grp"], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->m_sgrp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->m_sgrp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['m_sgrp'] = &$this->m_sgrp;

        // m_product
        $this->m_product = new DbField(
            $this, // Table
            'x_m_product', // Variable name
            'm_product', // Name
            '`m_product`', // Expression
            '`m_product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`m_product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->m_product->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->m_product->InputTextType = "text";
        $this->m_product->Raw = true;
        $this->m_product->Required = true; // Required field
        $this->m_product->setSelectMultiple(false); // Select one
        $this->m_product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->m_product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->m_product->Lookup = new Lookup($this->m_product, 'product_view2', true, 'id', ["product","","",""], '', '', ["x_m_sgrp"], ["x_m_rid"], ["s_grp"], ["x_s_grp"], [], [], false, '`product` ASC', '', "`product`");
        $this->m_product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->m_product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['m_product'] = &$this->m_product;

        // m_rid
        $this->m_rid = new DbField(
            $this, // Table
            'x_m_rid', // Variable name
            'm_rid', // Name
            '`m_rid`', // Expression
            '`m_rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__m_rid', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->m_rid->InputTextType = "text";
        $this->m_rid->Raw = true;
        $this->m_rid->Required = true; // Required field
        $this->m_rid->Lookup = new Lookup($this->m_rid, 'ref', false, 'id', ["product_code","","",""], '', '', ["x_m_product","x_m_sgrp"], [], ["product","s_grp"], ["x_product","x_s_grp"], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->m_rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['m_rid'] = &$this->m_rid;

        // m_packing
        $this->m_packing = new DbField(
            $this, // Table
            'x_m_packing', // Variable name
            'm_packing', // Name
            '`m_packing`', // Expression
            '`m_packing`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`m_packing`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->m_packing->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->m_packing->InputTextType = "text";
        $this->m_packing->Raw = true;
        $this->m_packing->setSelectMultiple(false); // Select one
        $this->m_packing->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->m_packing->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->m_packing->Lookup = new Lookup($this->m_packing, 'packing_type', false, 'id', ["packing","","",""], '', '', [], [], [], [], [], [], false, '`packing` ASC', '', "`packing`");
        $this->m_packing->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->m_packing->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['m_packing'] = &$this->m_packing;

        // m_name
        $this->m_name = new DbField(
            $this, // Table
            'x_m_name', // Variable name
            'm_name', // Name
            '`m_name`', // Expression
            '`m_name`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`m_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->m_name->InputTextType = "text";
        $this->m_name->Sortable = false; // Allow sort
        $this->m_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['m_name'] = &$this->m_name;

        // quantity_a
        $this->quantity_a = new DbField(
            $this, // Table
            'x_quantity_a', // Variable name
            'quantity_a', // Name
            '`quantity_a`', // Expression
            '`quantity_a`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity_a->InputTextType = "text";
        $this->quantity_a->Raw = true;
        $this->quantity_a->Nullable = false; // NOT NULL field
        $this->quantity_a->Required = true; // Required field
        $this->quantity_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['quantity_a'] = &$this->quantity_a;

        // bom_waste
        $this->bom_waste = new DbField(
            $this, // Table
            'x_bom_waste', // Variable name
            'bom_waste', // Name
            '`bom_waste`', // Expression
            '`bom_waste`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bom_waste`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bom_waste->InputTextType = "text";
        $this->bom_waste->Raw = true;
        $this->bom_waste->Nullable = false; // NOT NULL field
        $this->bom_waste->Required = true; // Required field
        $this->bom_waste->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->bom_waste->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['bom_waste'] = &$this->bom_waste;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity'] = &$this->quantity;

        // method
        $this->method = new DbField(
            $this, // Table
            'x_method', // Variable name
            'method', // Name
            '`method`', // Expression
            '`method`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->method->addMethod("getSelectFilter", fn() => "`grp`=21");
        $this->method->addMethod("getDefault", fn() => 23);
        $this->method->InputTextType = "text";
        $this->method->Raw = true;
        $this->method->Required = true; // Required field
        $this->method->setSelectMultiple(false); // Select one
        $this->method->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->method->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->method->Lookup = new Lookup($this->method, 'method', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->method->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['method'] = &$this->method;

        // unit
        $this->unit = new DbField(
            $this, // Table
            'x_unit', // Variable name
            'unit', // Name
            '`unit`', // Expression
            '`unit`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->unit->addMethod("getDefault", fn() => 12);
        $this->unit->InputTextType = "text";
        $this->unit->Raw = true;
        $this->unit->Required = true; // Required field
        $this->unit->setSelectMultiple(false); // Select one
        $this->unit->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->unit->Lookup = new Lookup($this->unit, 'unit', false, 'id', ["sign","description","",""], '', '', [], [], [], [], [], [], false, '`sign` ASC', '', "CONCAT(COALESCE(`sign`, ''),'" . ValueSeparator(1, $this->unit) . "',COALESCE(`description`,''))");
        $this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->unit->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['unit'] = &$this->unit;

        // gross_nett
        $this->gross_nett = new DbField(
            $this, // Table
            'x_gross_nett', // Variable name
            'gross_nett', // Name
            '`gross_nett`', // Expression
            '`gross_nett`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gross_nett`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->gross_nett->InputTextType = "text";
        $this->gross_nett->Raw = true;
        $this->gross_nett->Nullable = false; // NOT NULL field
        $this->gross_nett->setSelectMultiple(false); // Select one
        $this->gross_nett->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->gross_nett->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->gross_nett->Lookup = new Lookup($this->gross_nett, 'bom', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->gross_nett->OptionCount = 3;
        $this->gross_nett->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->gross_nett->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['gross_nett'] = &$this->gross_nett;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->grp->addMethod("getDefault", fn() => (isset($_GET['GRP']))  ? $_GET['GRP'] :'');
        $this->grp->addMethod("getLinkPrefix", fn() => "bomlist?x_grp=");
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], ["x_s_grp"], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->s_grp->addMethod("getDefault", fn() => (isset($_GET['SGRP']))  ? $_GET['SGRP'] : '');
        $this->s_grp->addMethod("getLinkPrefix", fn() => "bomlist?x_s_grp=");
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Nullable = false; // NOT NULL field
        $this->s_grp->Required = true; // Required field
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', false, 'id', ["product_group","","",""], '', '', ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->product->addMethod("getDefault", fn() => (isset($_GET['PROD']))  ? $_GET['PROD'] : '');
        $this->product->addMethod("getLinkPrefix", fn() => "bomlist?x_product=");
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Nullable = false; // NOT NULL field
        $this->product->Required = true; // Required field
        $this->product->setSelectMultiple(false); // Select one
        $this->product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product->Lookup = new Lookup($this->product, 'product_view2', false, 'id', ["product","","",""], '', '', ["x_s_grp"], ["x_rid"], ["s_grp"], ["x_s_grp"], [], [], false, '`product` ASC', '', "`product`");
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['product'] = &$this->product;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->rid->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->rid->addMethod("getDefault", fn() => (isset($_GET['RID']))  ? $_GET['RID'] : '');
        $this->rid->InputTextType = "text";
        $this->rid->Nullable = false; // NOT NULL field
        $this->rid->Required = true; // Required field
        $this->rid->setSelectMultiple(false); // Select one
        $this->rid->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->rid->Lookup = new Lookup($this->rid, 'ref', false, 'id', ["product_code","","",""], '', '', ["x_product"], [], ["product"], ["x_product"], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid->SearchOperators = ["=", "<>"];
        $this->Fields['rid'] = &$this->rid;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->packing_type->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->packing_type->addMethod("getDefault", fn() => (isset($_GET['PT']))  ? $_GET['PT'] : '');
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Raw = true;
        $this->packing_type->Nullable = false; // NOT NULL field
        $this->packing_type->setSelectMultiple(false); // Select one
        $this->packing_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->packing_type->Lookup = new Lookup($this->packing_type, 'packing_type', false, 'id', ["code","packing","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->packing_type) . "',COALESCE(`packing`,''))");
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->batch_no->addMethod("getDefault", fn() => (isset($_GET['BN']))  ? $_GET['BN'] : '');
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Raw = true;
        $this->batch_no->Required = true; // Required field
        $this->batch_no->Lookup = new Lookup($this->batch_no, 'batch_no', false, 'id', ["id","batch_no","description",""], '', '', [], [], [], [], [], [], false, '`batch_no` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->batch_no) . "',COALESCE(`batch_no`,''),'" . ValueSeparator(2, $this->batch_no) . "',COALESCE(`description`,''))");
        $this->batch_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // a_operator
        $this->a_operator = new DbField(
            $this, // Table
            'x_a_operator', // Variable name
            'a_operator', // Name
            '`a_operator`', // Expression
            '`a_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`a_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->a_operator->InputTextType = "text";
        $this->a_operator->Raw = true;
        $this->a_operator->Nullable = false; // NOT NULL field
        $this->a_operator->Required = true; // Required field
        $this->a_operator->setSelectMultiple(false); // Select one
        $this->a_operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->a_operator->Lookup = new Lookup($this->a_operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->a_operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['a_operator'] = &$this->a_operator;

        // a_datetime
        $this->a_datetime = new DbField(
            $this, // Table
            'x_a_datetime', // Variable name
            'a_datetime', // Name
            '`a_datetime`', // Expression
            CastDateFieldForLike("`a_datetime`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`a_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->a_datetime->InputTextType = "text";
        $this->a_datetime->Raw = true;
        $this->a_datetime->Nullable = false; // NOT NULL field
        $this->a_datetime->Required = true; // Required field
        $this->a_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['a_datetime'] = &$this->a_datetime;

        // pp_qty
        $this->pp_qty = new DbField(
            $this, // Table
            'x_pp_qty', // Variable name
            'pp_qty', // Name
            '`pp_qty`', // Expression
            '`pp_qty`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pp_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pp_qty->InputTextType = "text";
        $this->pp_qty->Raw = true;
        $this->pp_qty->Nullable = false; // NOT NULL field
        $this->pp_qty->Sortable = false; // Allow sort
        $this->pp_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pp_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['pp_qty'] = &$this->pp_qty;

        // pp_bal
        $this->pp_bal = new DbField(
            $this, // Table
            'x_pp_bal', // Variable name
            'pp_bal', // Name
            '`pp_bal`', // Expression
            '`pp_bal`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pp_bal`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pp_bal->addMethod("getDefault", fn() => 0.000);
        $this->pp_bal->InputTextType = "text";
        $this->pp_bal->Raw = true;
        $this->pp_bal->Nullable = false; // NOT NULL field
        $this->pp_bal->Sortable = false; // Allow sort
        $this->pp_bal->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pp_bal->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['pp_bal'] = &$this->pp_bal;

        // pp_id
        $this->pp_id = new DbField(
            $this, // Table
            'x_pp_id', // Variable name
            'pp_id', // Name
            '`pp_id`', // Expression
            '`pp_id`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pp_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pp_id->InputTextType = "text";
        $this->pp_id->Nullable = false; // NOT NULL field
        $this->pp_id->Required = true; // Required field
        $this->pp_id->Sortable = false; // Allow sort
        $this->pp_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pp_id'] = &$this->pp_id;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "bom";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT `product_code` FROM ref TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = bom.m_rid LIMIT 1) AS EV__m_rid FROM bom)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->m_rid->AdvancedSearch->SearchValue != "" ||
            $this->m_rid->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->m_rid->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->m_rid->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->warp_weft->DbValue = $row['warp_weft'];
        $this->m_grp->DbValue = $row['m_grp'];
        $this->m_sgrp->DbValue = $row['m_sgrp'];
        $this->m_product->DbValue = $row['m_product'];
        $this->m_rid->DbValue = $row['m_rid'];
        $this->m_packing->DbValue = $row['m_packing'];
        $this->m_name->DbValue = $row['m_name'];
        $this->quantity_a->DbValue = $row['quantity_a'];
        $this->bom_waste->DbValue = $row['bom_waste'];
        $this->quantity->DbValue = $row['quantity'];
        $this->method->DbValue = $row['method'];
        $this->unit->DbValue = $row['unit'];
        $this->gross_nett->DbValue = $row['gross_nett'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->product->DbValue = $row['product'];
        $this->rid->DbValue = $row['rid'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->a_operator->DbValue = $row['a_operator'];
        $this->a_datetime->DbValue = $row['a_datetime'];
        $this->pp_qty->DbValue = $row['pp_qty'];
        $this->pp_bal->DbValue = $row['pp_bal'];
        $this->pp_id->DbValue = $row['pp_id'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("bomlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "bomview" => $Language->phrase("View"),
            "bomedit" => $Language->phrase("Edit"),
            "bomadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "bomlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "BomView",
            Config("API_ADD_ACTION") => "BomAdd",
            Config("API_EDIT_ACTION") => "BomEdit",
            Config("API_DELETE_ACTION") => "BomDelete",
            Config("API_LIST_ACTION") => "BomList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "bomlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("bomview", $parm);
        } else {
            $url = $this->keyUrl("bomview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "bomadd?" . $parm;
        } else {
            $url = "bomadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("bomedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("bomlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("bomadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("bomlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("bomdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->warp_weft->setDbValue($row['warp_weft']);
        $this->m_grp->setDbValue($row['m_grp']);
        $this->m_sgrp->setDbValue($row['m_sgrp']);
        $this->m_product->setDbValue($row['m_product']);
        $this->m_rid->setDbValue($row['m_rid']);
        $this->m_packing->setDbValue($row['m_packing']);
        $this->m_name->setDbValue($row['m_name']);
        $this->quantity_a->setDbValue($row['quantity_a']);
        $this->bom_waste->setDbValue($row['bom_waste']);
        $this->quantity->setDbValue($row['quantity']);
        $this->method->setDbValue($row['method']);
        $this->unit->setDbValue($row['unit']);
        $this->gross_nett->setDbValue($row['gross_nett']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->pp_qty->setDbValue($row['pp_qty']);
        $this->pp_bal->setDbValue($row['pp_bal']);
        $this->pp_id->setDbValue($row['pp_id']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "BomList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // warp_weft

        // m_grp

        // m_sgrp

        // m_product

        // m_rid

        // m_packing

        // m_name
        $this->m_name->CellCssStyle = "white-space: nowrap;";

        // quantity_a
        $this->quantity_a->CellCssStyle = "min-width: 100px;";

        // bom_waste
        $this->bom_waste->CellCssStyle = "min-width: 100px;";

        // quantity
        $this->quantity->CellCssStyle = "min-width: 100px;";

        // method
        $this->method->CellCssStyle = "min-width: 100px;";

        // unit
        $this->unit->CellCssStyle = "min-width: 100px;";

        // gross_nett

        // grp

        // s_grp

        // product

        // rid

        // packing_type

        // batch_no

        // operator

        // datetime

        // a_operator

        // a_datetime

        // pp_qty
        $this->pp_qty->CellCssStyle = "white-space: nowrap;";

        // pp_bal
        $this->pp_bal->CellCssStyle = "white-space: nowrap;";

        // pp_id
        $this->pp_id->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // warp_weft
        if (strval($this->warp_weft->CurrentValue) != "") {
            $this->warp_weft->ViewValue = $this->warp_weft->optionCaption($this->warp_weft->CurrentValue);
        } else {
            $this->warp_weft->ViewValue = null;
        }

        // m_grp
        $curVal = strval($this->m_grp->CurrentValue);
        if ($curVal != "") {
            $this->m_grp->ViewValue = $this->m_grp->lookupCacheOption($curVal);
            if ($this->m_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->m_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->m_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->m_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->m_grp->ViewValue = $this->m_grp->displayValue($arwrk);
                } else {
                    $this->m_grp->ViewValue = FormatNumber($this->m_grp->CurrentValue, $this->m_grp->formatPattern());
                }
            }
        } else {
            $this->m_grp->ViewValue = null;
        }

        // m_sgrp
        $curVal = strval($this->m_sgrp->CurrentValue);
        if ($curVal != "") {
            $this->m_sgrp->ViewValue = $this->m_sgrp->lookupCacheOption($curVal);
            if ($this->m_sgrp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->m_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->m_sgrp->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_sgrp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->m_sgrp->Lookup->renderViewRow($rswrk[0]);
                    $this->m_sgrp->ViewValue = $this->m_sgrp->displayValue($arwrk);
                } else {
                    $this->m_sgrp->ViewValue = $this->m_sgrp->CurrentValue;
                }
            }
        } else {
            $this->m_sgrp->ViewValue = null;
        }

        // m_product
        $curVal = strval($this->m_product->CurrentValue);
        if ($curVal != "") {
            $this->m_product->ViewValue = $this->m_product->lookupCacheOption($curVal);
            if ($this->m_product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->m_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->m_product->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->m_product->Lookup->renderViewRow($rswrk[0]);
                    $this->m_product->ViewValue = $this->m_product->displayValue($arwrk);
                } else {
                    $this->m_product->ViewValue = $this->m_product->CurrentValue;
                }
            }
        } else {
            $this->m_product->ViewValue = null;
        }

        // m_rid
        if ($this->m_rid->VirtualValue != "") {
            $this->m_rid->ViewValue = $this->m_rid->VirtualValue;
        } else {
            $this->m_rid->ViewValue = $this->m_rid->CurrentValue;
            $curVal = strval($this->m_rid->CurrentValue);
            if ($curVal != "") {
                $this->m_rid->ViewValue = $this->m_rid->lookupCacheOption($curVal);
                if ($this->m_rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->m_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->m_rid->ViewValue = $this->m_rid->displayValue($arwrk);
                    } else {
                        $this->m_rid->ViewValue = $this->m_rid->CurrentValue;
                    }
                }
            } else {
                $this->m_rid->ViewValue = null;
            }
        }

        // m_packing
        $curVal = strval($this->m_packing->CurrentValue);
        if ($curVal != "") {
            $this->m_packing->ViewValue = $this->m_packing->lookupCacheOption($curVal);
            if ($this->m_packing->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->m_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->m_packing->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->m_packing->Lookup->renderViewRow($rswrk[0]);
                    $this->m_packing->ViewValue = $this->m_packing->displayValue($arwrk);
                } else {
                    $this->m_packing->ViewValue = FormatNumber($this->m_packing->CurrentValue, $this->m_packing->formatPattern());
                }
            }
        } else {
            $this->m_packing->ViewValue = null;
        }

        // m_name
        $this->m_name->ViewValue = $this->m_name->CurrentValue;

        // quantity_a
        $this->quantity_a->ViewValue = $this->quantity_a->CurrentValue;
        $this->quantity_a->ViewValue = FormatNumber($this->quantity_a->ViewValue, $this->quantity_a->formatPattern());

        // bom_waste
        $this->bom_waste->ViewValue = $this->bom_waste->CurrentValue;
        $this->bom_waste->ViewValue = FormatNumber($this->bom_waste->ViewValue, $this->bom_waste->formatPattern());

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;

        // method
        $curVal = strval($this->method->CurrentValue);
        if ($curVal != "") {
            $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
            if ($this->method->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                    $this->method->ViewValue = $this->method->displayValue($arwrk);
                } else {
                    $this->method->ViewValue = $this->method->CurrentValue;
                }
            }
        } else {
            $this->method->ViewValue = null;
        }

        // unit
        $curVal = strval($this->unit->CurrentValue);
        if ($curVal != "") {
            $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
            if ($this->unit->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                    $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                } else {
                    $this->unit->ViewValue = $this->unit->CurrentValue;
                }
            }
        } else {
            $this->unit->ViewValue = null;
        }

        // gross_nett
        if (strval($this->gross_nett->CurrentValue) != "") {
            $this->gross_nett->ViewValue = $this->gross_nett->optionCaption($this->gross_nett->CurrentValue);
        } else {
            $this->gross_nett->ViewValue = null;
        }

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = $this->grp->CurrentValue;
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $this->product->CurrentValue;
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // rid
        $curVal = strval($this->rid->CurrentValue);
        if ($curVal != "") {
            $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
            if ($this->rid->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                    $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                } else {
                    $this->rid->ViewValue = $this->rid->CurrentValue;
                }
            }
        } else {
            $this->rid->ViewValue = null;
        }

        // packing_type
        $curVal = strval($this->packing_type->CurrentValue);
        if ($curVal != "") {
            $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            if ($this->packing_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                    $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                } else {
                    $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                }
            }
        } else {
            $this->packing_type->ViewValue = null;
        }

        // batch_no
        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
        $curVal = strval($this->batch_no->CurrentValue);
        if ($curVal != "") {
            $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            if ($this->batch_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                }
            }
        } else {
            $this->batch_no->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // a_operator
        $curVal = strval($this->a_operator->CurrentValue);
        if ($curVal != "") {
            $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
            if ($this->a_operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                    $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                } else {
                    $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                }
            }
        } else {
            $this->a_operator->ViewValue = null;
        }

        // a_datetime
        $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;

        // pp_qty
        $this->pp_qty->ViewValue = $this->pp_qty->CurrentValue;
        $this->pp_qty->ViewValue = FormatNumber($this->pp_qty->ViewValue, $this->pp_qty->formatPattern());

        // pp_bal
        $this->pp_bal->ViewValue = $this->pp_bal->CurrentValue;
        $this->pp_bal->ViewValue = FormatNumber($this->pp_bal->ViewValue, $this->pp_bal->formatPattern());

        // pp_id
        $this->pp_id->ViewValue = $this->pp_id->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // warp_weft
        $this->warp_weft->HrefValue = "";
        $this->warp_weft->TooltipValue = "";

        // m_grp
        if (!EmptyValue($this->m_grp->CurrentValue)) {
            $this->m_grp->HrefValue = $this->m_grp->getLinkPrefix() . $this->m_grp->CurrentValue; // Add prefix/suffix
            $this->m_grp->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->m_grp->HrefValue = FullUrl($this->m_grp->HrefValue, "href");
            }
        } else {
            $this->m_grp->HrefValue = "";
        }
        $this->m_grp->TooltipValue = "";

        // m_sgrp
        $this->m_sgrp->HrefValue = "";
        $this->m_sgrp->TooltipValue = "";

        // m_product
        $this->m_product->HrefValue = "";
        $this->m_product->TooltipValue = "";

        // m_rid
        $this->m_rid->HrefValue = "";
        $this->m_rid->TooltipValue = "";

        // m_packing
        $this->m_packing->HrefValue = "";
        $this->m_packing->TooltipValue = "";

        // m_name
        $this->m_name->HrefValue = "";
        $this->m_name->TooltipValue = "";

        // quantity_a
        $this->quantity_a->HrefValue = "";
        $this->quantity_a->TooltipValue = "";

        // bom_waste
        $this->bom_waste->HrefValue = "";
        $this->bom_waste->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // method
        $this->method->HrefValue = "";
        $this->method->TooltipValue = "";

        // unit
        $this->unit->HrefValue = "";
        $this->unit->TooltipValue = "";

        // gross_nett
        $this->gross_nett->HrefValue = "";
        $this->gross_nett->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // s_grp
        $this->s_grp->HrefValue = "";
        $this->s_grp->TooltipValue = "";

        // product
        $this->product->HrefValue = "";
        $this->product->TooltipValue = "";

        // rid
        $this->rid->HrefValue = "";
        $this->rid->TooltipValue = "";

        // packing_type
        $this->packing_type->HrefValue = "";
        $this->packing_type->TooltipValue = "";

        // batch_no
        $this->batch_no->HrefValue = "";
        $this->batch_no->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // a_operator
        $this->a_operator->HrefValue = "";
        $this->a_operator->TooltipValue = "";

        // a_datetime
        $this->a_datetime->HrefValue = "";
        $this->a_datetime->TooltipValue = "";

        // pp_qty
        $this->pp_qty->HrefValue = "";
        $this->pp_qty->TooltipValue = "";

        // pp_bal
        $this->pp_bal->HrefValue = "";
        $this->pp_bal->TooltipValue = "";

        // pp_id
        $this->pp_id->HrefValue = "";
        $this->pp_id->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // warp_weft
        $this->warp_weft->setupEditAttributes();
        $this->warp_weft->EditValue = $this->warp_weft->options(true);
        $this->warp_weft->PlaceHolder = RemoveHtml($this->warp_weft->caption());

        // m_grp
        $this->m_grp->setupEditAttributes();
        $curVal = strval($this->m_grp->CurrentValue);
        if ($curVal != "") {
            $this->m_grp->EditValue = $this->m_grp->lookupCacheOption($curVal);
            if ($this->m_grp->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->m_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->m_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->m_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->m_grp->EditValue = $this->m_grp->displayValue($arwrk);
                } else {
                    $this->m_grp->EditValue = FormatNumber($this->m_grp->CurrentValue, $this->m_grp->formatPattern());
                }
            }
        } else {
            $this->m_grp->EditValue = null;
        }

        // m_sgrp
        $this->m_sgrp->setupEditAttributes();
        $curVal = strval($this->m_sgrp->CurrentValue);
        if ($curVal != "") {
            $this->m_sgrp->EditValue = $this->m_sgrp->lookupCacheOption($curVal);
            if ($this->m_sgrp->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->m_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->m_sgrp->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_sgrp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->m_sgrp->Lookup->renderViewRow($rswrk[0]);
                    $this->m_sgrp->EditValue = $this->m_sgrp->displayValue($arwrk);
                } else {
                    $this->m_sgrp->EditValue = $this->m_sgrp->CurrentValue;
                }
            }
        } else {
            $this->m_sgrp->EditValue = null;
        }

        // m_product
        $this->m_product->setupEditAttributes();
        $curVal = strval($this->m_product->CurrentValue);
        if ($curVal != "") {
            $this->m_product->EditValue = $this->m_product->lookupCacheOption($curVal);
            if ($this->m_product->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->m_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->m_product->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->m_product->Lookup->renderViewRow($rswrk[0]);
                    $this->m_product->EditValue = $this->m_product->displayValue($arwrk);
                } else {
                    $this->m_product->EditValue = $this->m_product->CurrentValue;
                }
            }
        } else {
            $this->m_product->EditValue = null;
        }

        // m_rid
        $this->m_rid->setupEditAttributes();
        if ($this->m_rid->VirtualValue != "") {
            $this->m_rid->EditValue = $this->m_rid->VirtualValue;
        } else {
            $this->m_rid->EditValue = $this->m_rid->CurrentValue;
            $curVal = strval($this->m_rid->CurrentValue);
            if ($curVal != "") {
                $this->m_rid->EditValue = $this->m_rid->lookupCacheOption($curVal);
                if ($this->m_rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->m_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->m_rid->EditValue = $this->m_rid->displayValue($arwrk);
                    } else {
                        $this->m_rid->EditValue = $this->m_rid->CurrentValue;
                    }
                }
            } else {
                $this->m_rid->EditValue = null;
            }
        }

        // m_packing
        $this->m_packing->setupEditAttributes();
        $curVal = strval($this->m_packing->CurrentValue);
        if ($curVal != "") {
            $this->m_packing->EditValue = $this->m_packing->lookupCacheOption($curVal);
            if ($this->m_packing->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->m_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->m_packing->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->m_packing->Lookup->renderViewRow($rswrk[0]);
                    $this->m_packing->EditValue = $this->m_packing->displayValue($arwrk);
                } else {
                    $this->m_packing->EditValue = FormatNumber($this->m_packing->CurrentValue, $this->m_packing->formatPattern());
                }
            }
        } else {
            $this->m_packing->EditValue = null;
        }

        // m_name
        $this->m_name->setupEditAttributes();
        if (!$this->m_name->Raw) {
            $this->m_name->CurrentValue = HtmlDecode($this->m_name->CurrentValue);
        }
        $this->m_name->EditValue = $this->m_name->CurrentValue;
        $this->m_name->PlaceHolder = RemoveHtml($this->m_name->caption());

        // quantity_a
        $this->quantity_a->setupEditAttributes();
        $this->quantity_a->EditValue = $this->quantity_a->CurrentValue;
        $this->quantity_a->PlaceHolder = RemoveHtml($this->quantity_a->caption());
        if (strval($this->quantity_a->EditValue) != "" && is_numeric($this->quantity_a->EditValue)) {
            $this->quantity_a->EditValue = FormatNumber($this->quantity_a->EditValue, null);
        }

        // bom_waste
        $this->bom_waste->setupEditAttributes();
        $this->bom_waste->EditValue = $this->bom_waste->CurrentValue;
        $this->bom_waste->PlaceHolder = RemoveHtml($this->bom_waste->caption());
        if (strval($this->bom_waste->EditValue) != "" && is_numeric($this->bom_waste->EditValue)) {
            $this->bom_waste->EditValue = FormatNumber($this->bom_waste->EditValue, null);
        }

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditCustomAttributes = $this->quantity->getEditCustomAttributes(); // PHP
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // method
        $this->method->setupEditAttributes();
        $this->method->PlaceHolder = RemoveHtml($this->method->caption());

        // unit
        $this->unit->setupEditAttributes();
        $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

        // gross_nett
        $this->gross_nett->setupEditAttributes();
        $this->gross_nett->EditValue = $this->gross_nett->options(true);
        $this->gross_nett->PlaceHolder = RemoveHtml($this->gross_nett->caption());

        // grp
        $this->grp->setupEditAttributes();
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->EditValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->EditValue = $this->grp->CurrentValue;
                }
            }
        } else {
            $this->grp->EditValue = null;
        }

        // s_grp
        $this->s_grp->setupEditAttributes();
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->EditValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                }
            }
        } else {
            $this->s_grp->EditValue = null;
        }

        // product
        $this->product->setupEditAttributes();
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->EditValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->EditValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->EditValue = $this->product->CurrentValue;
                }
            }
        } else {
            $this->product->EditValue = null;
        }

        // rid
        $this->rid->setupEditAttributes();
        $curVal = strval($this->rid->CurrentValue);
        if ($curVal != "") {
            $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
            if ($this->rid->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                    $this->rid->EditValue = $this->rid->displayValue($arwrk);
                } else {
                    $this->rid->EditValue = $this->rid->CurrentValue;
                }
            }
        } else {
            $this->rid->EditValue = null;
        }

        // packing_type
        $this->packing_type->setupEditAttributes();
        $curVal = strval($this->packing_type->CurrentValue);
        if ($curVal != "") {
            $this->packing_type->EditValue = $this->packing_type->lookupCacheOption($curVal);
            if ($this->packing_type->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                    $this->packing_type->EditValue = $this->packing_type->displayValue($arwrk);
                } else {
                    $this->packing_type->EditValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                }
            }
        } else {
            $this->packing_type->EditValue = null;
        }

        // batch_no
        $this->batch_no->setupEditAttributes();
        $this->batch_no->EditValue = $this->batch_no->CurrentValue;
        $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

        // operator

        // datetime

        // a_operator
        $this->a_operator->setupEditAttributes();
        $this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());

        // a_datetime
        $this->a_datetime->setupEditAttributes();
        $this->a_datetime->EditValue = $this->a_datetime->CurrentValue;
        $this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());

        // pp_qty
        $this->pp_qty->setupEditAttributes();
        $this->pp_qty->EditValue = $this->pp_qty->CurrentValue;
        $this->pp_qty->PlaceHolder = RemoveHtml($this->pp_qty->caption());
        if (strval($this->pp_qty->EditValue) != "" && is_numeric($this->pp_qty->EditValue)) {
            $this->pp_qty->EditValue = FormatNumber($this->pp_qty->EditValue, null);
        }

        // pp_bal
        $this->pp_bal->setupEditAttributes();
        $this->pp_bal->EditValue = $this->pp_bal->CurrentValue;
        $this->pp_bal->PlaceHolder = RemoveHtml($this->pp_bal->caption());
        if (strval($this->pp_bal->EditValue) != "" && is_numeric($this->pp_bal->EditValue)) {
            $this->pp_bal->EditValue = FormatNumber($this->pp_bal->EditValue, null);
        }

        // pp_id
        $this->pp_id->setupEditAttributes();
        if (!$this->pp_id->Raw) {
            $this->pp_id->CurrentValue = HtmlDecode($this->pp_id->CurrentValue);
        }
        $this->pp_id->EditValue = $this->pp_id->CurrentValue;
        $this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->quantity_a->CurrentValue)) {
                $this->quantity_a->Total += $this->quantity_a->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->quantity->CurrentValue)) {
                $this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->quantity_a->CurrentValue = $this->quantity_a->Total;
            $this->quantity_a->ViewValue = $this->quantity_a->CurrentValue;
            $this->quantity_a->ViewValue = FormatNumber($this->quantity_a->ViewValue, $this->quantity_a->formatPattern());
            $this->quantity_a->HrefValue = ""; // Clear href value
            $this->quantity->CurrentValue = $this->quantity->Total;
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->warp_weft);
                    $doc->exportCaption($this->m_grp);
                    $doc->exportCaption($this->m_sgrp);
                    $doc->exportCaption($this->m_product);
                    $doc->exportCaption($this->m_rid);
                    $doc->exportCaption($this->m_packing);
                    $doc->exportCaption($this->quantity_a);
                    $doc->exportCaption($this->bom_waste);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->method);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->gross_nett);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->a_operator);
                    $doc->exportCaption($this->a_datetime);
                    $doc->exportCaption($this->pp_qty);
                    $doc->exportCaption($this->pp_bal);
                    $doc->exportCaption($this->pp_id);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->warp_weft);
                    $doc->exportCaption($this->m_grp);
                    $doc->exportCaption($this->m_sgrp);
                    $doc->exportCaption($this->m_product);
                    $doc->exportCaption($this->m_rid);
                    $doc->exportCaption($this->m_packing);
                    $doc->exportCaption($this->quantity_a);
                    $doc->exportCaption($this->bom_waste);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->method);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->gross_nett);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->a_operator);
                    $doc->exportCaption($this->a_datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->warp_weft);
                        $doc->exportField($this->m_grp);
                        $doc->exportField($this->m_sgrp);
                        $doc->exportField($this->m_product);
                        $doc->exportField($this->m_rid);
                        $doc->exportField($this->m_packing);
                        $doc->exportField($this->quantity_a);
                        $doc->exportField($this->bom_waste);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->method);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->gross_nett);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->a_operator);
                        $doc->exportField($this->a_datetime);
                        $doc->exportField($this->pp_qty);
                        $doc->exportField($this->pp_bal);
                        $doc->exportField($this->pp_id);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->warp_weft);
                        $doc->exportField($this->m_grp);
                        $doc->exportField($this->m_sgrp);
                        $doc->exportField($this->m_product);
                        $doc->exportField($this->m_rid);
                        $doc->exportField($this->m_packing);
                        $doc->exportField($this->quantity_a);
                        $doc->exportField($this->bom_waste);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->method);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->gross_nett);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->a_operator);
                        $doc->exportField($this->a_datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->warp_weft, '');
                $doc->exportAggregate($this->m_grp, '');
                $doc->exportAggregate($this->m_sgrp, '');
                $doc->exportAggregate($this->m_product, '');
                $doc->exportAggregate($this->m_rid, '');
                $doc->exportAggregate($this->m_packing, '');
                $doc->exportAggregate($this->quantity_a, 'TOTAL');
                $doc->exportAggregate($this->bom_waste, '');
                $doc->exportAggregate($this->quantity, 'TOTAL');
                $doc->exportAggregate($this->method, '');
                $doc->exportAggregate($this->unit, '');
                $doc->exportAggregate($this->gross_nett, '');
                $doc->exportAggregate($this->grp, '');
                $doc->exportAggregate($this->s_grp, '');
                $doc->exportAggregate($this->product, '');
                $doc->exportAggregate($this->rid, '');
                $doc->exportAggregate($this->packing_type, '');
                $doc->exportAggregate($this->batch_no, '');
                $doc->exportAggregate($this->operator, '');
                $doc->exportAggregate($this->datetime, '');
                $doc->exportAggregate($this->a_operator, '');
                $doc->exportAggregate($this->a_datetime, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'bom');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'bom', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'bom', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'bom', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
