<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BcodeUpdate extends Bcode
{
    use MessagesTrait;

    // Page ID
    public $PageID = "update";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BcodeUpdate";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "bcodeupdate";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->pid->Visible = false;
        $this->po->Visible = false;
        $this->design_id->Visible = false;
        $this->size_cm->Visible = false;
        $this->_barcode->Visible = false;
        $this->process_d->Visible = false;
        $this->buyer_ref->Visible = false;
        $this->order_date->setVisibility();
        $this->despatch_date->Visible = false;
        $this->despatch_week->Visible = false;
        $this->dispatch_week_p->setVisibility();
        $this->loom_plan->Visible = false;
        $this->status->Visible = false;
        $this->buyers_id->Visible = false;
        $this->buyer_uid->Visible = false;
        $this->buyer_loc->setVisibility();
        $this->quantity->Visible = false;
        $this->sqm->Visible = false;
        $this->sqm_u->Visible = false;
        $this->c_sqm->Visible = false;
        $this->weaving_works->setVisibility();
        $this->current_works->setVisibility();
        $this->size_buyer->Visible = false;
        $this->design->Visible = false;
        $this->w_cm->Visible = false;
        $this->l_cm->Visible = false;
        $this->q_sku->Visible = false;
        $this->po_price->setVisibility();
        $this->po_discount->setVisibility();
        $this->po_currency->setVisibility();
        $this->product_type->Visible = false;
        $this->shape->Visible = false;
        $this->payment_plan->Visible = false;
        $this->production_plan->Visible = false;
        $this->datetime->Visible = false;
        $this->completed->setVisibility();
        $this->buyer_po->Visible = false;
        $this->operator->Visible = false;
        $this->jc_no->Visible = false;
        $this->sqm_a->Visible = false;
        $this->_2srm->Visible = false;
        $this->_2srm_a->Visible = false;
        $this->_4srm->Visible = false;
        $this->_4srm_a->Visible = false;
        $this->buyer_tid->Visible = false;
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->batch_no->Visible = false;
        $this->cs->Visible = false;
        $this->process->Visible = false;
        $this->process_c->Visible = false;
        $this->weight->Visible = false;
        $this->remarks->Visible = false;
        $this->p_remarks->Visible = false;
        $this->roll_no->Visible = false;
        $this->qty->Visible = false;
        $this->pl_no->Visible = false;
        $this->category->Visible = false;
        $this->pp_id->Visible = false;
        $this->consignee->Visible = false;
        $this->buyer_barcode->Visible = false;
        $this->design_next->Visible = false;
        $this->_11->Visible = false;
        $this->_12->Visible = false;
        $this->_13->Visible = false;
        $this->_14->Visible = false;
        $this->_15->Visible = false;
        $this->_16->Visible = false;
        $this->_17->Visible = false;
        $this->_18->Visible = false;
        $this->_19->Visible = false;
        $this->_20->Visible = false;
        $this->_21->Visible = false;
        $this->_22->Visible = false;
        $this->_23->Visible = false;
        $this->_24->Visible = false;
        $this->_25->Visible = false;
        $this->_26->Visible = false;
        $this->_27->Visible = false;
        $this->_28->Visible = false;
        $this->_29->Visible = false;
        $this->_30->Visible = false;
        $this->_31->Visible = false;
        $this->_32->Visible = false;
        $this->_33->Visible = false;
        $this->_34->Visible = false;
        $this->_35->Visible = false;
        $this->_36->Visible = false;
        $this->_37->Visible = false;
        $this->_38->Visible = false;
        $this->_39->Visible = false;
        $this->_40->Visible = false;
        $this->_41->Visible = false;
        $this->_42->Visible = false;
        $this->_43->Visible = false;
        $this->_44->Visible = false;
        $this->_45->Visible = false;
        $this->_46->Visible = false;
        $this->_47->Visible = false;
        $this->_48->Visible = false;
        $this->_49->Visible = false;
        $this->_50->Visible = false;
        $this->packing_type->Visible = false;
        $this->qc_weaving->Visible = false;
        $this->roll_no_qty_tmp->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'bcode';
        $this->TableName = 'bcode';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-update-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (bcode)
        if (!isset($GLOBALS["bcode"]) || $GLOBALS["bcode"]::class == PROJECT_NAMESPACE . "bcode") {
            $GLOBALS["bcode"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'bcode');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "bcodeview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-update-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $RecKeys;
    public $Disabled;
    public $UpdateCount = 0;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->design_id);
        $this->setupLookupOptions($this->process_d);
        $this->setupLookupOptions($this->buyer_ref);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->dispatch_week_p);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->weaving_works);
        $this->setupLookupOptions($this->current_works);
        $this->setupLookupOptions($this->design);
        $this->setupLookupOptions($this->po_currency);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->payment_plan);
        $this->setupLookupOptions($this->production_plan);
        $this->setupLookupOptions($this->completed);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->cs);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->process_c);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->pp_id);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Try to load keys from list form
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        if (Post("action") !== null && Post("action") !== "") {
            // Get action
            $this->CurrentAction = Post("action");
            $this->loadFormValues(); // Get form values

            // Validate form
            if (!$this->validateForm()) {
                $this->CurrentAction = "show"; // Form error, reset action
                if (!$this->hasInvalidFields()) { // No fields selected
                    $this->setFailureMessage($Language->phrase("NoFieldSelected"));
                }
            }
        } else {
            $this->loadMultiUpdateValues(); // Load initial values to form
        }
        if (count($this->RecKeys) <= 0) {
            $this->terminate("bcodelist"); // No records selected, return to list
            return;
        }
        if ($this->isUpdate()) {
                if ($this->updateRows()) { // Update Records based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
                    }

                    // Do not return Json for UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                    }
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([
                        "success" => false,
                        "validation" => $this->getValidationErrors(),
                        "error" => $this->getFailureMessage()
                    ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->restoreFormValues(); // Restore form values
                }
        }

        // Render row
        if ($this->isConfirm()) { // Confirm page
            $this->RowType = RowType::VIEW; // Render view
            $this->Disabled = " disabled";
        } else {
            $this->RowType = RowType::EDIT; // Render edit
            $this->Disabled = "";
        }
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load initial values to form if field values are identical in all selected records
    protected function loadMultiUpdateValues()
    {
        $this->CurrentFilter = $this->getFilterFromRecordKeys();

        // Load result set
        if ($rs = $this->loadRecordset()) {
            $i = 1;
            while ($row = $rs->fetch()) {
                if ($i == 1) {
                    $this->order_date->setDbValue($row['order_date']);
                    $this->dispatch_week_p->setDbValue($row['dispatch_week_p']);
                    $this->buyer_loc->setDbValue($row['buyer_loc']);
                    $this->weaving_works->setDbValue($row['weaving_works']);
                    $this->current_works->setDbValue($row['current_works']);
                    $this->po_price->setDbValue($row['po_price']);
                    $this->po_discount->setDbValue($row['po_discount']);
                    $this->po_currency->setDbValue($row['po_currency']);
                    $this->completed->setDbValue($row['completed']);
                } else {
                    if (!CompareValue($this->order_date->DbValue, $row['order_date'])) {
                        $this->order_date->CurrentValue = null;
                    }
                    if (!CompareValue($this->dispatch_week_p->DbValue, $row['dispatch_week_p'])) {
                        $this->dispatch_week_p->CurrentValue = null;
                    }
                    if (!CompareValue($this->buyer_loc->DbValue, $row['buyer_loc'])) {
                        $this->buyer_loc->CurrentValue = null;
                    }
                    if (!CompareValue($this->weaving_works->DbValue, $row['weaving_works'])) {
                        $this->weaving_works->CurrentValue = null;
                    }
                    if (!CompareValue($this->current_works->DbValue, $row['current_works'])) {
                        $this->current_works->CurrentValue = null;
                    }
                    if (!CompareValue($this->po_price->DbValue, $row['po_price'])) {
                        $this->po_price->CurrentValue = null;
                    }
                    if (!CompareValue($this->po_discount->DbValue, $row['po_discount'])) {
                        $this->po_discount->CurrentValue = null;
                    }
                    if (!CompareValue($this->po_currency->DbValue, $row['po_currency'])) {
                        $this->po_currency->CurrentValue = null;
                    }
                    if (!CompareValue($this->completed->DbValue, $row['completed'])) {
                        $this->completed->CurrentValue = null;
                    }
                }
                $i++;
            }
            $rs->free();
        }
    }

    // Set up key value
    protected function setupKeyValues($key)
    {
        $keyFld = $key;
        if (!is_numeric($keyFld)) {
            return false;
        }
        $this->id->OldValue = $keyFld;
        return true;
    }

    // Update all selected rows
    protected function updateRows()
    {
        global $Language;
        $conn = $this->getConnection();
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->AuditTrailOnEdit) {
            $this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin
        }

        // Get old records
        $this->CurrentFilter = $this->getFilterFromRecordKeys(false);
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAllAssociative($sql);

        // Update all rows
        $successKeys = [];
        $failKeys = [];
        foreach ($this->RecKeys as $reckey) {
            if ($this->setupKeyValues($reckey)) {
                $thisKey = $reckey;
                $this->SendEmail = false; // Do not send email on update success
                $this->UpdateCount += 1; // Update record count for records being updated
                $rowUpdated = $this->editRow(); // Update this row
            } else {
                $rowUpdated = false;
            }
            if (!$rowUpdated) {
                if ($this->UseTransaction) { // Update failed
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                $successKeys[] = $thisKey;
            }
        }

        // Check if any rows updated
        if (count($successKeys) > 0) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if update some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("UpdateSomeRecordsFailed")));
            }

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
            }
            return true;
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
            }
            return false;
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'order_date' first before field var 'x_order_date'
        $val = $CurrentForm->hasValue("order_date") ? $CurrentForm->getValue("order_date") : $CurrentForm->getValue("x_order_date");
        if (!$this->order_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->order_date->Visible = false; // Disable update for API request
            } else {
                $this->order_date->setFormValue($val, true, $validate);
            }
            $this->order_date->CurrentValue = UnFormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern());
        }
        $this->order_date->MultiUpdate = $CurrentForm->getValue("u_order_date");

        // Check field name 'dispatch_week_p' first before field var 'x_dispatch_week_p'
        $val = $CurrentForm->hasValue("dispatch_week_p") ? $CurrentForm->getValue("dispatch_week_p") : $CurrentForm->getValue("x_dispatch_week_p");
        if (!$this->dispatch_week_p->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dispatch_week_p->Visible = false; // Disable update for API request
            } else {
                $this->dispatch_week_p->setFormValue($val);
            }
        }
        $this->dispatch_week_p->MultiUpdate = $CurrentForm->getValue("u_dispatch_week_p");

        // Check field name 'buyer_loc' first before field var 'x_buyer_loc'
        $val = $CurrentForm->hasValue("buyer_loc") ? $CurrentForm->getValue("buyer_loc") : $CurrentForm->getValue("x_buyer_loc");
        if (!$this->buyer_loc->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_loc->Visible = false; // Disable update for API request
            } else {
                $this->buyer_loc->setFormValue($val);
            }
        }
        $this->buyer_loc->MultiUpdate = $CurrentForm->getValue("u_buyer_loc");

        // Check field name 'weaving_works' first before field var 'x_weaving_works'
        $val = $CurrentForm->hasValue("weaving_works") ? $CurrentForm->getValue("weaving_works") : $CurrentForm->getValue("x_weaving_works");
        if (!$this->weaving_works->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weaving_works->Visible = false; // Disable update for API request
            } else {
                $this->weaving_works->setFormValue($val);
            }
        }
        $this->weaving_works->MultiUpdate = $CurrentForm->getValue("u_weaving_works");

        // Check field name 'current_works' first before field var 'x_current_works'
        $val = $CurrentForm->hasValue("current_works") ? $CurrentForm->getValue("current_works") : $CurrentForm->getValue("x_current_works");
        if (!$this->current_works->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->current_works->Visible = false; // Disable update for API request
            } else {
                $this->current_works->setFormValue($val);
            }
        }
        $this->current_works->MultiUpdate = $CurrentForm->getValue("u_current_works");

        // Check field name 'po_price' first before field var 'x_po_price'
        $val = $CurrentForm->hasValue("po_price") ? $CurrentForm->getValue("po_price") : $CurrentForm->getValue("x_po_price");
        if (!$this->po_price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_price->Visible = false; // Disable update for API request
            } else {
                $this->po_price->setFormValue($val);
            }
        }
        $this->po_price->MultiUpdate = $CurrentForm->getValue("u_po_price");

        // Check field name 'po_discount' first before field var 'x_po_discount'
        $val = $CurrentForm->hasValue("po_discount") ? $CurrentForm->getValue("po_discount") : $CurrentForm->getValue("x_po_discount");
        if (!$this->po_discount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_discount->Visible = false; // Disable update for API request
            } else {
                $this->po_discount->setFormValue($val, true, $validate);
            }
        }
        $this->po_discount->MultiUpdate = $CurrentForm->getValue("u_po_discount");

        // Check field name 'po_currency' first before field var 'x_po_currency'
        $val = $CurrentForm->hasValue("po_currency") ? $CurrentForm->getValue("po_currency") : $CurrentForm->getValue("x_po_currency");
        if (!$this->po_currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_currency->Visible = false; // Disable update for API request
            } else {
                $this->po_currency->setFormValue($val);
            }
        }
        $this->po_currency->MultiUpdate = $CurrentForm->getValue("u_po_currency");

        // Check field name 'completed' first before field var 'x_completed'
        $val = $CurrentForm->hasValue("completed") ? $CurrentForm->getValue("completed") : $CurrentForm->getValue("x_completed");
        if (!$this->completed->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->completed->Visible = false; // Disable update for API request
            } else {
                $this->completed->setFormValue($val);
            }
        }
        $this->completed->MultiUpdate = $CurrentForm->getValue("u_completed");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->order_date->CurrentValue = $this->order_date->FormValue;
        $this->order_date->CurrentValue = UnFormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern());
        $this->dispatch_week_p->CurrentValue = $this->dispatch_week_p->FormValue;
        $this->buyer_loc->CurrentValue = $this->buyer_loc->FormValue;
        $this->weaving_works->CurrentValue = $this->weaving_works->FormValue;
        $this->current_works->CurrentValue = $this->current_works->FormValue;
        $this->po_price->CurrentValue = $this->po_price->FormValue;
        $this->po_discount->CurrentValue = $this->po_discount->FormValue;
        $this->po_currency->CurrentValue = $this->po_currency->FormValue;
        $this->completed->CurrentValue = $this->completed->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->pid->setDbValue($row['pid']);
        $this->po->setDbValue($row['po']);
        $this->design_id->setDbValue($row['design_id']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->process_d->setDbValue($row['process_d']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        if (array_key_exists('EV__buyer_ref', $row)) {
            $this->buyer_ref->VirtualValue = $row['EV__buyer_ref']; // Set up virtual field value
        } else {
            $this->buyer_ref->VirtualValue = ""; // Clear value
        }
        $this->order_date->setDbValue($row['order_date']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->dispatch_week_p->setDbValue($row['dispatch_week_p']);
        $this->loom_plan->setDbValue($row['loom_plan']);
        $this->status->setDbValue($row['status']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->quantity->setDbValue($row['quantity']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_u->setDbValue($row['sqm_u']);
        $this->c_sqm->setDbValue($row['c_sqm']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->current_works->setDbValue($row['current_works']);
        $this->size_buyer->setDbValue($row['size_buyer']);
        $this->design->setDbValue($row['design']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->po_price->setDbValue($row['po_price']);
        $this->po_discount->setDbValue($row['po_discount']);
        $this->po_currency->setDbValue($row['po_currency']);
        $this->product_type->setDbValue($row['product_type']);
        $this->shape->setDbValue($row['shape']);
        $this->payment_plan->setDbValue($row['payment_plan']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->datetime->setDbValue($row['datetime']);
        $this->completed->setDbValue($row['completed']);
        $this->buyer_po->setDbValue($row['buyer_po']);
        $this->operator->setDbValue($row['operator']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->_2srm->setDbValue($row['2srm']);
        $this->_2srm_a->setDbValue($row['2srm_a']);
        $this->_4srm->setDbValue($row['4srm']);
        $this->_4srm_a->setDbValue($row['4srm_a']);
        $this->buyer_tid->setDbValue($row['buyer_tid']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->cs->setDbValue($row['cs']);
        $this->process->setDbValue($row['process']);
        $this->process_c->setDbValue($row['process_c']);
        $this->weight->setDbValue($row['weight']);
        $this->remarks->setDbValue($row['remarks']);
        $this->p_remarks->setDbValue($row['p_remarks']);
        $this->roll_no->setDbValue($row['roll_no']);
        $this->qty->setDbValue($row['qty']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->category->setDbValue($row['category']);
        $this->pp_id->setDbValue($row['pp_id']);
        $this->consignee->setDbValue($row['consignee']);
        $this->buyer_barcode->setDbValue($row['buyer_barcode']);
        $this->design_next->setDbValue($row['design_next']);
        $this->_11->setDbValue($row['11']);
        $this->_12->setDbValue($row['12']);
        $this->_13->setDbValue($row['13']);
        $this->_14->setDbValue($row['14']);
        $this->_15->setDbValue($row['15']);
        $this->_16->setDbValue($row['16']);
        $this->_17->setDbValue($row['17']);
        $this->_18->setDbValue($row['18']);
        $this->_19->setDbValue($row['19']);
        $this->_20->setDbValue($row['20']);
        $this->_21->setDbValue($row['21']);
        $this->_22->setDbValue($row['22']);
        $this->_23->setDbValue($row['23']);
        $this->_24->setDbValue($row['24']);
        $this->_25->setDbValue($row['25']);
        $this->_26->setDbValue($row['26']);
        $this->_27->setDbValue($row['27']);
        $this->_28->setDbValue($row['28']);
        $this->_29->setDbValue($row['29']);
        $this->_30->setDbValue($row['30']);
        $this->_31->setDbValue($row['31']);
        $this->_32->setDbValue($row['32']);
        $this->_33->setDbValue($row['33']);
        $this->_34->setDbValue($row['34']);
        $this->_35->setDbValue($row['35']);
        $this->_36->setDbValue($row['36']);
        $this->_37->setDbValue($row['37']);
        $this->_38->setDbValue($row['38']);
        $this->_39->setDbValue($row['39']);
        $this->_40->setDbValue($row['40']);
        $this->_41->setDbValue($row['41']);
        $this->_42->setDbValue($row['42']);
        $this->_43->setDbValue($row['43']);
        $this->_44->setDbValue($row['44']);
        $this->_45->setDbValue($row['45']);
        $this->_46->setDbValue($row['46']);
        $this->_47->setDbValue($row['47']);
        $this->_48->setDbValue($row['48']);
        $this->_49->setDbValue($row['49']);
        $this->_50->setDbValue($row['50']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->qc_weaving->setDbValue($row['qc_weaving']);
        $this->roll_no_qty_tmp->setDbValue($row['roll_no_qty_tmp']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['pid'] = $this->pid->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['design_id'] = $this->design_id->DefaultValue;
        $row['size_cm'] = $this->size_cm->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['process_d'] = $this->process_d->DefaultValue;
        $row['buyer_ref'] = $this->buyer_ref->DefaultValue;
        $row['order_date'] = $this->order_date->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['dispatch_week_p'] = $this->dispatch_week_p->DefaultValue;
        $row['loom_plan'] = $this->loom_plan->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['buyers_id'] = $this->buyers_id->DefaultValue;
        $row['buyer_uid'] = $this->buyer_uid->DefaultValue;
        $row['buyer_loc'] = $this->buyer_loc->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['sqm_u'] = $this->sqm_u->DefaultValue;
        $row['c_sqm'] = $this->c_sqm->DefaultValue;
        $row['weaving_works'] = $this->weaving_works->DefaultValue;
        $row['current_works'] = $this->current_works->DefaultValue;
        $row['size_buyer'] = $this->size_buyer->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['po_price'] = $this->po_price->DefaultValue;
        $row['po_discount'] = $this->po_discount->DefaultValue;
        $row['po_currency'] = $this->po_currency->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['payment_plan'] = $this->payment_plan->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['completed'] = $this->completed->DefaultValue;
        $row['buyer_po'] = $this->buyer_po->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['sqm_a'] = $this->sqm_a->DefaultValue;
        $row['2srm'] = $this->_2srm->DefaultValue;
        $row['2srm_a'] = $this->_2srm_a->DefaultValue;
        $row['4srm'] = $this->_4srm->DefaultValue;
        $row['4srm_a'] = $this->_4srm_a->DefaultValue;
        $row['buyer_tid'] = $this->buyer_tid->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['cs'] = $this->cs->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['process_c'] = $this->process_c->DefaultValue;
        $row['weight'] = $this->weight->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['p_remarks'] = $this->p_remarks->DefaultValue;
        $row['roll_no'] = $this->roll_no->DefaultValue;
        $row['qty'] = $this->qty->DefaultValue;
        $row['pl_no'] = $this->pl_no->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['pp_id'] = $this->pp_id->DefaultValue;
        $row['consignee'] = $this->consignee->DefaultValue;
        $row['buyer_barcode'] = $this->buyer_barcode->DefaultValue;
        $row['design_next'] = $this->design_next->DefaultValue;
        $row['11'] = $this->_11->DefaultValue;
        $row['12'] = $this->_12->DefaultValue;
        $row['13'] = $this->_13->DefaultValue;
        $row['14'] = $this->_14->DefaultValue;
        $row['15'] = $this->_15->DefaultValue;
        $row['16'] = $this->_16->DefaultValue;
        $row['17'] = $this->_17->DefaultValue;
        $row['18'] = $this->_18->DefaultValue;
        $row['19'] = $this->_19->DefaultValue;
        $row['20'] = $this->_20->DefaultValue;
        $row['21'] = $this->_21->DefaultValue;
        $row['22'] = $this->_22->DefaultValue;
        $row['23'] = $this->_23->DefaultValue;
        $row['24'] = $this->_24->DefaultValue;
        $row['25'] = $this->_25->DefaultValue;
        $row['26'] = $this->_26->DefaultValue;
        $row['27'] = $this->_27->DefaultValue;
        $row['28'] = $this->_28->DefaultValue;
        $row['29'] = $this->_29->DefaultValue;
        $row['30'] = $this->_30->DefaultValue;
        $row['31'] = $this->_31->DefaultValue;
        $row['32'] = $this->_32->DefaultValue;
        $row['33'] = $this->_33->DefaultValue;
        $row['34'] = $this->_34->DefaultValue;
        $row['35'] = $this->_35->DefaultValue;
        $row['36'] = $this->_36->DefaultValue;
        $row['37'] = $this->_37->DefaultValue;
        $row['38'] = $this->_38->DefaultValue;
        $row['39'] = $this->_39->DefaultValue;
        $row['40'] = $this->_40->DefaultValue;
        $row['41'] = $this->_41->DefaultValue;
        $row['42'] = $this->_42->DefaultValue;
        $row['43'] = $this->_43->DefaultValue;
        $row['44'] = $this->_44->DefaultValue;
        $row['45'] = $this->_45->DefaultValue;
        $row['46'] = $this->_46->DefaultValue;
        $row['47'] = $this->_47->DefaultValue;
        $row['48'] = $this->_48->DefaultValue;
        $row['49'] = $this->_49->DefaultValue;
        $row['50'] = $this->_50->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['qc_weaving'] = $this->qc_weaving->DefaultValue;
        $row['roll_no_qty_tmp'] = $this->roll_no_qty_tmp->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // pid
        $this->pid->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // design_id
        $this->design_id->RowCssClass = "row";

        // size_cm
        $this->size_cm->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // process_d
        $this->process_d->RowCssClass = "row";

        // buyer_ref
        $this->buyer_ref->RowCssClass = "row";

        // order_date
        $this->order_date->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // dispatch_week_p
        $this->dispatch_week_p->RowCssClass = "row";

        // loom_plan
        $this->loom_plan->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // buyers_id
        $this->buyers_id->RowCssClass = "row";

        // buyer_uid
        $this->buyer_uid->RowCssClass = "row";

        // buyer_loc
        $this->buyer_loc->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // sqm_u
        $this->sqm_u->RowCssClass = "row";

        // c_sqm
        $this->c_sqm->RowCssClass = "row";

        // weaving_works
        $this->weaving_works->RowCssClass = "row";

        // current_works
        $this->current_works->RowCssClass = "row";

        // size_buyer
        $this->size_buyer->RowCssClass = "row";

        // design
        $this->design->RowCssClass = "row";

        // w_cm
        $this->w_cm->RowCssClass = "row";

        // l_cm
        $this->l_cm->RowCssClass = "row";

        // q_sku
        $this->q_sku->RowCssClass = "row";

        // po_price
        $this->po_price->RowCssClass = "row";

        // po_discount
        $this->po_discount->RowCssClass = "row";

        // po_currency
        $this->po_currency->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // payment_plan
        $this->payment_plan->RowCssClass = "row";

        // production_plan
        $this->production_plan->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // completed
        $this->completed->RowCssClass = "row";

        // buyer_po
        $this->buyer_po->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // sqm_a
        $this->sqm_a->RowCssClass = "row";

        // 2srm
        $this->_2srm->RowCssClass = "row";

        // 2srm_a
        $this->_2srm_a->RowCssClass = "row";

        // 4srm
        $this->_4srm->RowCssClass = "row";

        // 4srm_a
        $this->_4srm_a->RowCssClass = "row";

        // buyer_tid
        $this->buyer_tid->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // cs
        $this->cs->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // process_c
        $this->process_c->RowCssClass = "row";

        // weight
        $this->weight->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // p_remarks
        $this->p_remarks->RowCssClass = "row";

        // roll_no
        $this->roll_no->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // pl_no
        $this->pl_no->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // pp_id
        $this->pp_id->RowCssClass = "row";

        // consignee
        $this->consignee->RowCssClass = "row";

        // buyer_barcode
        $this->buyer_barcode->RowCssClass = "row";

        // design_next
        $this->design_next->RowCssClass = "row";

        // 11
        $this->_11->RowCssClass = "row";

        // 12
        $this->_12->RowCssClass = "row";

        // 13
        $this->_13->RowCssClass = "row";

        // 14
        $this->_14->RowCssClass = "row";

        // 15
        $this->_15->RowCssClass = "row";

        // 16
        $this->_16->RowCssClass = "row";

        // 17
        $this->_17->RowCssClass = "row";

        // 18
        $this->_18->RowCssClass = "row";

        // 19
        $this->_19->RowCssClass = "row";

        // 20
        $this->_20->RowCssClass = "row";

        // 21
        $this->_21->RowCssClass = "row";

        // 22
        $this->_22->RowCssClass = "row";

        // 23
        $this->_23->RowCssClass = "row";

        // 24
        $this->_24->RowCssClass = "row";

        // 25
        $this->_25->RowCssClass = "row";

        // 26
        $this->_26->RowCssClass = "row";

        // 27
        $this->_27->RowCssClass = "row";

        // 28
        $this->_28->RowCssClass = "row";

        // 29
        $this->_29->RowCssClass = "row";

        // 30
        $this->_30->RowCssClass = "row";

        // 31
        $this->_31->RowCssClass = "row";

        // 32
        $this->_32->RowCssClass = "row";

        // 33
        $this->_33->RowCssClass = "row";

        // 34
        $this->_34->RowCssClass = "row";

        // 35
        $this->_35->RowCssClass = "row";

        // 36
        $this->_36->RowCssClass = "row";

        // 37
        $this->_37->RowCssClass = "row";

        // 38
        $this->_38->RowCssClass = "row";

        // 39
        $this->_39->RowCssClass = "row";

        // 40
        $this->_40->RowCssClass = "row";

        // 41
        $this->_41->RowCssClass = "row";

        // 42
        $this->_42->RowCssClass = "row";

        // 43
        $this->_43->RowCssClass = "row";

        // 44
        $this->_44->RowCssClass = "row";

        // 45
        $this->_45->RowCssClass = "row";

        // 46
        $this->_46->RowCssClass = "row";

        // 47
        $this->_47->RowCssClass = "row";

        // 48
        $this->_48->RowCssClass = "row";

        // 49
        $this->_49->RowCssClass = "row";

        // 50
        $this->_50->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // qc_weaving
        $this->qc_weaving->RowCssClass = "row";

        // roll_no_qty_tmp
        $this->roll_no_qty_tmp->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // pid
            $this->pid->ViewValue = $this->pid->CurrentValue;
            $this->pid->ViewValue = FormatNumber($this->pid->ViewValue, $this->pid->formatPattern());

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // design_id
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->ViewValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->ViewValue = null;
            }

            // size_cm
            $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // process_d
            $curVal = strval($this->process_d->CurrentValue);
            if ($curVal != "") {
                $this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
                if ($this->process_d->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_d->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_d->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process_d->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_d->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_d->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_d->Lookup->renderViewRow($row);
                            $this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
                        }
                    } else {
                        $this->process_d->ViewValue = $this->process_d->CurrentValue;
                    }
                }
            } else {
                $this->process_d->ViewValue = null;
            }

            // buyer_ref
            if ($this->buyer_ref->VirtualValue != "") {
                $this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
            } else {
                $curVal = strval($this->buyer_ref->CurrentValue);
                if ($curVal != "") {
                    $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
                    if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                            $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                        } else {
                            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                        }
                    }
                } else {
                    $this->buyer_ref->ViewValue = null;
                }
            }

            // order_date
            $this->order_date->ViewValue = $this->order_date->CurrentValue;
            $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // dispatch_week_p
            $curVal = strval($this->dispatch_week_p->CurrentValue);
            if ($curVal != "") {
                $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
                if ($this->dispatch_week_p->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->dispatch_week_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->dispatch_week_p->Lookup->renderViewRow($rswrk[0]);
                        $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
                    } else {
                        $this->dispatch_week_p->ViewValue = FormatNumber($this->dispatch_week_p->CurrentValue, $this->dispatch_week_p->formatPattern());
                    }
                }
            } else {
                $this->dispatch_week_p->ViewValue = null;
            }

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // buyer_uid
            $this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;

            // buyer_loc
            $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // sqm_u
            $this->sqm_u->ViewValue = $this->sqm_u->CurrentValue;
            $this->sqm_u->ViewValue = FormatNumber($this->sqm_u->ViewValue, $this->sqm_u->formatPattern());

            // c_sqm
            $this->c_sqm->ViewValue = $this->c_sqm->CurrentValue;
            $this->c_sqm->ViewValue = FormatNumber($this->c_sqm->ViewValue, $this->c_sqm->formatPattern());

            // weaving_works
            $curVal = strval($this->weaving_works->CurrentValue);
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
                if ($this->weaving_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                        $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                    } else {
                        $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                    }
                }
            } else {
                $this->weaving_works->ViewValue = null;
            }

            // current_works
            $curVal = strval($this->current_works->CurrentValue);
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
                if ($this->current_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                        $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                    } else {
                        $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                    }
                }
            } else {
                $this->current_works->ViewValue = null;
            }

            // size_buyer
            $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;
            $this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, $this->q_sku->formatPattern());

            // po_price
            $this->po_price->ViewValue = $this->po_price->CurrentValue;

            // po_discount
            $this->po_discount->ViewValue = $this->po_discount->CurrentValue;
            $this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, $this->po_discount->formatPattern());

            // po_currency
            $curVal = strval($this->po_currency->CurrentValue);
            if ($curVal != "") {
                $this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
                if ($this->po_currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_currency->Lookup->renderViewRow($rswrk[0]);
                        $this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
                    } else {
                        $this->po_currency->ViewValue = FormatNumber($this->po_currency->CurrentValue, $this->po_currency->formatPattern());
                    }
                }
            } else {
                $this->po_currency->ViewValue = null;
            }

            // product_type
            if (strval($this->product_type->CurrentValue) != "") {
                $this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
            } else {
                $this->product_type->ViewValue = null;
            }

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->ViewValue = FormatNumber($this->shape->CurrentValue, $this->shape->formatPattern());
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // payment_plan
            $curVal = strval($this->payment_plan->CurrentValue);
            if ($curVal != "") {
                $this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
                if ($this->payment_plan->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->payment_plan->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_plan->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
                    } else {
                        $this->payment_plan->ViewValue = FormatNumber($this->payment_plan->CurrentValue, $this->payment_plan->formatPattern());
                    }
                }
            } else {
                $this->payment_plan->ViewValue = null;
            }

            // production_plan
            if (strval($this->production_plan->CurrentValue) != "") {
                $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
            } else {
                $this->production_plan->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // completed
            if (strval($this->completed->CurrentValue) != "") {
                $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
            } else {
                $this->completed->ViewValue = null;
            }

            // buyer_po
            $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // cs
            if (strval($this->cs->CurrentValue) != "") {
                $this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
            } else {
                $this->cs->ViewValue = null;
            }

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process->Lookup->renderViewRow($row);
                            $this->process->ViewValue->add($this->process->displayValue($arwrk));
                        }
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // process_c
            $curVal = strval($this->process_c->CurrentValue);
            if ($curVal != "") {
                $this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
                if ($this->process_c->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_c->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_c->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process_c->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_c->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_c->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_c->Lookup->renderViewRow($row);
                            $this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
                        }
                    } else {
                        $this->process_c->ViewValue = $this->process_c->CurrentValue;
                    }
                }
            } else {
                $this->process_c->ViewValue = null;
            }

            // weight
            $this->weight->ViewValue = $this->weight->CurrentValue;
            $this->weight->ViewValue = FormatNumber($this->weight->ViewValue, $this->weight->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // p_remarks
            $this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;
            $this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, $this->roll_no->formatPattern());

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // pl_no
            $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
            $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // pp_id
            $this->pp_id->ViewValue = $this->pp_id->CurrentValue;
            $curVal = strval($this->pp_id->CurrentValue);
            if ($curVal != "") {
                $this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
                if ($this->pp_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pp_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pp_id->Lookup->renderViewRow($rswrk[0]);
                        $this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
                    } else {
                        $this->pp_id->ViewValue = FormatNumber($this->pp_id->CurrentValue, $this->pp_id->formatPattern());
                    }
                }
            } else {
                $this->pp_id->ViewValue = null;
            }

            // 11
            $this->_11->ViewValue = $this->_11->CurrentValue;

            // 12
            $this->_12->ViewValue = $this->_12->CurrentValue;

            // 13
            $this->_13->ViewValue = $this->_13->CurrentValue;

            // 14
            $this->_14->ViewValue = $this->_14->CurrentValue;

            // 15
            $this->_15->ViewValue = $this->_15->CurrentValue;

            // 16
            $this->_16->ViewValue = $this->_16->CurrentValue;

            // 17
            $this->_17->ViewValue = $this->_17->CurrentValue;

            // 18
            $this->_18->ViewValue = $this->_18->CurrentValue;

            // 19
            $this->_19->ViewValue = $this->_19->CurrentValue;

            // 20
            $this->_20->ViewValue = $this->_20->CurrentValue;

            // 21
            $this->_21->ViewValue = $this->_21->CurrentValue;

            // 22
            $this->_22->ViewValue = $this->_22->CurrentValue;

            // 23
            $this->_23->ViewValue = $this->_23->CurrentValue;

            // 24
            $this->_24->ViewValue = $this->_24->CurrentValue;

            // 25
            $this->_25->ViewValue = $this->_25->CurrentValue;

            // 26
            $this->_26->ViewValue = $this->_26->CurrentValue;

            // 27
            $this->_27->ViewValue = $this->_27->CurrentValue;

            // 28
            $this->_28->ViewValue = $this->_28->CurrentValue;

            // 29
            $this->_29->ViewValue = $this->_29->CurrentValue;

            // 30
            $this->_30->ViewValue = $this->_30->CurrentValue;

            // 31
            $this->_31->ViewValue = $this->_31->CurrentValue;

            // 32
            $this->_32->ViewValue = $this->_32->CurrentValue;

            // 33
            $this->_33->ViewValue = $this->_33->CurrentValue;

            // 34
            $this->_34->ViewValue = $this->_34->CurrentValue;

            // 35
            $this->_35->ViewValue = $this->_35->CurrentValue;

            // 36
            $this->_36->ViewValue = $this->_36->CurrentValue;

            // 37
            $this->_37->ViewValue = $this->_37->CurrentValue;

            // 38
            $this->_38->ViewValue = $this->_38->CurrentValue;

            // 39
            $this->_39->ViewValue = $this->_39->CurrentValue;

            // 40
            $this->_40->ViewValue = $this->_40->CurrentValue;

            // 41
            $this->_41->ViewValue = $this->_41->CurrentValue;

            // 42
            $this->_42->ViewValue = $this->_42->CurrentValue;

            // 43
            $this->_43->ViewValue = $this->_43->CurrentValue;

            // 44
            $this->_44->ViewValue = $this->_44->CurrentValue;

            // 45
            $this->_45->ViewValue = $this->_45->CurrentValue;

            // 46
            $this->_46->ViewValue = $this->_46->CurrentValue;

            // 47
            $this->_47->ViewValue = $this->_47->CurrentValue;

            // 48
            $this->_48->ViewValue = $this->_48->CurrentValue;

            // 49
            $this->_49->ViewValue = $this->_49->CurrentValue;

            // 50
            $this->_50->ViewValue = $this->_50->CurrentValue;

            // order_date
            $this->order_date->HrefValue = "";
            $this->order_date->TooltipValue = "";

            // dispatch_week_p
            $this->dispatch_week_p->HrefValue = "";
            $this->dispatch_week_p->TooltipValue = "";

            // buyer_loc
            $this->buyer_loc->HrefValue = "";
            $this->buyer_loc->TooltipValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";
            $this->weaving_works->TooltipValue = "";

            // current_works
            $this->current_works->HrefValue = "";
            $this->current_works->TooltipValue = "";

            // po_price
            $this->po_price->HrefValue = "";
            $this->po_price->TooltipValue = "";

            // po_discount
            $this->po_discount->HrefValue = "";
            $this->po_discount->TooltipValue = "";

            // po_currency
            $this->po_currency->HrefValue = "";
            $this->po_currency->TooltipValue = "";

            // completed
            $this->completed->HrefValue = "";
            $this->completed->TooltipValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // order_date
            $this->order_date->setupEditAttributes();
            $this->order_date->EditValue = HtmlEncode(FormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern()));
            $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

            // dispatch_week_p
            $this->dispatch_week_p->setupEditAttributes();
            $curVal = strval($this->dispatch_week_p->CurrentValue);
            if ($curVal != "") {
                $this->dispatch_week_p->EditValue = $this->dispatch_week_p->lookupCacheOption($curVal);
                if ($this->dispatch_week_p->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->dispatch_week_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->dispatch_week_p->Lookup->renderViewRow($rswrk[0]);
                        $this->dispatch_week_p->EditValue = $this->dispatch_week_p->displayValue($arwrk);
                    } else {
                        $this->dispatch_week_p->EditValue = FormatNumber($this->dispatch_week_p->CurrentValue, $this->dispatch_week_p->formatPattern());
                    }
                }
            } else {
                $this->dispatch_week_p->EditValue = null;
            }

            // buyer_loc
            $this->buyer_loc->setupEditAttributes();
            if (!$this->buyer_loc->Raw) {
                $this->buyer_loc->CurrentValue = HtmlDecode($this->buyer_loc->CurrentValue);
            }
            $this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->CurrentValue);
            $this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

            // weaving_works
            $this->weaving_works->setupEditAttributes();
            $curVal = trim(strval($this->weaving_works->CurrentValue));
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
            } else {
                $this->weaving_works->ViewValue = $this->weaving_works->Lookup !== null && is_array($this->weaving_works->lookupOptions()) && count($this->weaving_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->weaving_works->ViewValue !== null) { // Load from cache
                $this->weaving_works->EditValue = array_values($this->weaving_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->weaving_works->CurrentValue, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->weaving_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->weaving_works->EditValue = $arwrk;
            }
            $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

            // current_works
            $this->current_works->setupEditAttributes();
            $curVal = trim(strval($this->current_works->CurrentValue));
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
            } else {
                $this->current_works->ViewValue = $this->current_works->Lookup !== null && is_array($this->current_works->lookupOptions()) && count($this->current_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->current_works->ViewValue !== null) { // Load from cache
                $this->current_works->EditValue = array_values($this->current_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->current_works->CurrentValue, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->current_works->EditValue = $arwrk;
            }
            $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

            // po_price
            $this->po_price->setupEditAttributes();
            $this->po_price->EditValue = $this->po_price->CurrentValue;

            // po_discount
            $this->po_discount->setupEditAttributes();
            $this->po_discount->EditValue = $this->po_discount->CurrentValue;
            $this->po_discount->PlaceHolder = RemoveHtml($this->po_discount->caption());
            if (strval($this->po_discount->EditValue) != "" && is_numeric($this->po_discount->EditValue)) {
                $this->po_discount->EditValue = FormatNumber($this->po_discount->EditValue, null);
            }

            // po_currency
            $this->po_currency->setupEditAttributes();
            $curVal = strval($this->po_currency->CurrentValue);
            if ($curVal != "") {
                $this->po_currency->EditValue = $this->po_currency->lookupCacheOption($curVal);
                if ($this->po_currency->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_currency->Lookup->renderViewRow($rswrk[0]);
                        $this->po_currency->EditValue = $this->po_currency->displayValue($arwrk);
                    } else {
                        $this->po_currency->EditValue = FormatNumber($this->po_currency->CurrentValue, $this->po_currency->formatPattern());
                    }
                }
            } else {
                $this->po_currency->EditValue = null;
            }

            // completed
            $this->completed->setupEditAttributes();
            $this->completed->EditValue = $this->completed->options(true);
            $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

            // Edit refer script

            // order_date
            $this->order_date->HrefValue = "";

            // dispatch_week_p
            $this->dispatch_week_p->HrefValue = "";
            $this->dispatch_week_p->TooltipValue = "";

            // buyer_loc
            $this->buyer_loc->HrefValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";

            // current_works
            $this->current_works->HrefValue = "";

            // po_price
            $this->po_price->HrefValue = "";
            $this->po_price->TooltipValue = "";

            // po_discount
            $this->po_discount->HrefValue = "";

            // po_currency
            $this->po_currency->HrefValue = "";
            $this->po_currency->TooltipValue = "";

            // completed
            $this->completed->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;
        $updateCnt = 0;
        if ($this->order_date->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->dispatch_week_p->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->buyer_loc->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->weaving_works->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->current_works->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->po_price->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->po_discount->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->po_currency->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->completed->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($updateCnt == 0) {
            return false;
        }

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->order_date->Visible && $this->order_date->Required) {
                if ($this->order_date->MultiUpdate != "" && !$this->order_date->IsDetailKey && EmptyValue($this->order_date->FormValue)) {
                    $this->order_date->addErrorMessage(str_replace("%s", $this->order_date->caption(), $this->order_date->RequiredErrorMessage));
                }
            }
            if ($this->order_date->MultiUpdate != "") {
                if (!CheckDate($this->order_date->FormValue, $this->order_date->formatPattern())) {
                    $this->order_date->addErrorMessage($this->order_date->getErrorMessage(false));
                }
            }
            if ($this->dispatch_week_p->Visible && $this->dispatch_week_p->Required) {
                if ($this->dispatch_week_p->MultiUpdate != "" && !$this->dispatch_week_p->IsDetailKey && EmptyValue($this->dispatch_week_p->FormValue)) {
                    $this->dispatch_week_p->addErrorMessage(str_replace("%s", $this->dispatch_week_p->caption(), $this->dispatch_week_p->RequiredErrorMessage));
                }
            }
            if ($this->buyer_loc->Visible && $this->buyer_loc->Required) {
                if ($this->buyer_loc->MultiUpdate != "" && !$this->buyer_loc->IsDetailKey && EmptyValue($this->buyer_loc->FormValue)) {
                    $this->buyer_loc->addErrorMessage(str_replace("%s", $this->buyer_loc->caption(), $this->buyer_loc->RequiredErrorMessage));
                }
            }
            if ($this->weaving_works->Visible && $this->weaving_works->Required) {
                if ($this->weaving_works->MultiUpdate != "" && !$this->weaving_works->IsDetailKey && EmptyValue($this->weaving_works->FormValue)) {
                    $this->weaving_works->addErrorMessage(str_replace("%s", $this->weaving_works->caption(), $this->weaving_works->RequiredErrorMessage));
                }
            }
            if ($this->current_works->Visible && $this->current_works->Required) {
                if ($this->current_works->MultiUpdate != "" && !$this->current_works->IsDetailKey && EmptyValue($this->current_works->FormValue)) {
                    $this->current_works->addErrorMessage(str_replace("%s", $this->current_works->caption(), $this->current_works->RequiredErrorMessage));
                }
            }
            if ($this->po_price->Visible && $this->po_price->Required) {
                if ($this->po_price->MultiUpdate != "" && !$this->po_price->IsDetailKey && EmptyValue($this->po_price->FormValue)) {
                    $this->po_price->addErrorMessage(str_replace("%s", $this->po_price->caption(), $this->po_price->RequiredErrorMessage));
                }
            }
            if ($this->po_discount->Visible && $this->po_discount->Required) {
                if ($this->po_discount->MultiUpdate != "" && !$this->po_discount->IsDetailKey && EmptyValue($this->po_discount->FormValue)) {
                    $this->po_discount->addErrorMessage(str_replace("%s", $this->po_discount->caption(), $this->po_discount->RequiredErrorMessage));
                }
            }
            if ($this->po_discount->MultiUpdate != "") {
                if (!CheckNumber($this->po_discount->FormValue)) {
                    $this->po_discount->addErrorMessage($this->po_discount->getErrorMessage(false));
                }
            }
            if ($this->po_currency->Visible && $this->po_currency->Required) {
                if ($this->po_currency->MultiUpdate != "" && !$this->po_currency->IsDetailKey && EmptyValue($this->po_currency->FormValue)) {
                    $this->po_currency->addErrorMessage(str_replace("%s", $this->po_currency->caption(), $this->po_currency->RequiredErrorMessage));
                }
            }
            if ($this->completed->Visible && $this->completed->Required) {
                if ($this->completed->MultiUpdate != "" && !$this->completed->IsDetailKey && EmptyValue($this->completed->FormValue)) {
                    $this->completed->addErrorMessage(str_replace("%s", $this->completed->caption(), $this->completed->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // order_date
        $this->order_date->setDbValueDef($rsnew, UnFormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern()), $this->order_date->ReadOnly || $this->order_date->MultiUpdate != "1");

        // buyer_loc
        $this->buyer_loc->setDbValueDef($rsnew, $this->buyer_loc->CurrentValue, $this->buyer_loc->ReadOnly || $this->buyer_loc->MultiUpdate != "1");

        // weaving_works
        $this->weaving_works->setDbValueDef($rsnew, $this->weaving_works->CurrentValue, $this->weaving_works->ReadOnly || $this->weaving_works->MultiUpdate != "1");

        // current_works
        $this->current_works->setDbValueDef($rsnew, $this->current_works->CurrentValue, $this->current_works->ReadOnly || $this->current_works->MultiUpdate != "1");

        // po_discount
        $this->po_discount->setDbValueDef($rsnew, $this->po_discount->CurrentValue, $this->po_discount->ReadOnly || $this->po_discount->MultiUpdate != "1");

        // completed
        $this->completed->setDbValueDef($rsnew, $this->completed->CurrentValue, $this->completed->ReadOnly || $this->completed->MultiUpdate != "1");
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['order_date'])) { // order_date
            $this->order_date->CurrentValue = $row['order_date'];
        }
        if (isset($row['buyer_loc'])) { // buyer_loc
            $this->buyer_loc->CurrentValue = $row['buyer_loc'];
        }
        if (isset($row['weaving_works'])) { // weaving_works
            $this->weaving_works->CurrentValue = $row['weaving_works'];
        }
        if (isset($row['current_works'])) { // current_works
            $this->current_works->CurrentValue = $row['current_works'];
        }
        if (isset($row['po_discount'])) { // po_discount
            $this->po_discount->CurrentValue = $row['po_discount'];
        }
        if (isset($row['completed'])) { // completed
            $this->completed->CurrentValue = $row['completed'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bcodelist"), "", $this->TableVar, true);
        $pageId = "update";
        $Breadcrumb->add("update", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_design_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_d":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_ref":
                    break;
                case "x_despatch_week":
                    break;
                case "x_dispatch_week_p":
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyers_id":
                    break;
                case "x_weaving_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_current_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_design":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_po_currency":
                    break;
                case "x_product_type":
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_payment_plan":
                    break;
                case "x_production_plan":
                    break;
                case "x_completed":
                    break;
                case "x_operator":
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cs":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_c":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pp_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    		PageFieldValidate($this,'bcode');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
