<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BcodeSearch extends Bcode
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BcodeSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "bcodesearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->pid->setVisibility();
        $this->po->setVisibility();
        $this->design_id->setVisibility();
        $this->size_cm->setVisibility();
        $this->_barcode->setVisibility();
        $this->process_d->setVisibility();
        $this->buyer_ref->setVisibility();
        $this->order_date->setVisibility();
        $this->despatch_date->setVisibility();
        $this->despatch_week->setVisibility();
        $this->dispatch_week_p->setVisibility();
        $this->loom_plan->Visible = false;
        $this->status->setVisibility();
        $this->buyers_id->setVisibility();
        $this->buyer_uid->setVisibility();
        $this->buyer_loc->setVisibility();
        $this->quantity->setVisibility();
        $this->sqm->setVisibility();
        $this->sqm_u->setVisibility();
        $this->c_sqm->setVisibility();
        $this->weaving_works->setVisibility();
        $this->current_works->setVisibility();
        $this->size_buyer->setVisibility();
        $this->design->Visible = false;
        $this->w_cm->Visible = false;
        $this->l_cm->Visible = false;
        $this->q_sku->setVisibility();
        $this->po_price->setVisibility();
        $this->po_discount->setVisibility();
        $this->po_currency->setVisibility();
        $this->product_type->setVisibility();
        $this->shape->setVisibility();
        $this->payment_plan->setVisibility();
        $this->production_plan->setVisibility();
        $this->datetime->setVisibility();
        $this->completed->setVisibility();
        $this->buyer_po->setVisibility();
        $this->operator->setVisibility();
        $this->jc_no->setVisibility();
        $this->sqm_a->Visible = false;
        $this->_2srm->Visible = false;
        $this->_2srm_a->Visible = false;
        $this->_4srm->Visible = false;
        $this->_4srm_a->Visible = false;
        $this->buyer_tid->Visible = false;
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->batch_no->setVisibility();
        $this->cs->setVisibility();
        $this->process->Visible = false;
        $this->process_c->Visible = false;
        $this->weight->Visible = false;
        $this->remarks->setVisibility();
        $this->p_remarks->setVisibility();
        $this->roll_no->setVisibility();
        $this->qty->setVisibility();
        $this->pl_no->setVisibility();
        $this->category->setVisibility();
        $this->pp_id->setVisibility();
        $this->consignee->Visible = false;
        $this->buyer_barcode->Visible = false;
        $this->design_next->Visible = false;
        $this->_11->setVisibility();
        $this->_12->setVisibility();
        $this->_13->setVisibility();
        $this->_14->setVisibility();
        $this->_15->setVisibility();
        $this->_16->setVisibility();
        $this->_17->setVisibility();
        $this->_18->setVisibility();
        $this->_19->setVisibility();
        $this->_20->setVisibility();
        $this->_21->setVisibility();
        $this->_22->setVisibility();
        $this->_23->setVisibility();
        $this->_24->setVisibility();
        $this->_25->setVisibility();
        $this->_26->setVisibility();
        $this->_27->setVisibility();
        $this->_28->setVisibility();
        $this->_29->setVisibility();
        $this->_30->setVisibility();
        $this->_31->setVisibility();
        $this->_32->setVisibility();
        $this->_33->setVisibility();
        $this->_34->setVisibility();
        $this->_35->setVisibility();
        $this->_36->setVisibility();
        $this->_37->setVisibility();
        $this->_38->setVisibility();
        $this->_39->setVisibility();
        $this->_40->setVisibility();
        $this->_41->setVisibility();
        $this->_42->setVisibility();
        $this->_43->setVisibility();
        $this->_44->setVisibility();
        $this->_45->setVisibility();
        $this->_46->setVisibility();
        $this->_47->setVisibility();
        $this->_48->setVisibility();
        $this->_49->setVisibility();
        $this->_50->setVisibility();
        $this->packing_type->Visible = false;
        $this->qc_weaving->Visible = false;
        $this->roll_no_qty_tmp->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'bcode';
        $this->TableName = 'bcode';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (bcode)
        if (!isset($GLOBALS["bcode"]) || $GLOBALS["bcode"]::class == PROJECT_NAMESPACE . "bcode") {
            $GLOBALS["bcode"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'bcode');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "bcodeview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->design_id);
        $this->setupLookupOptions($this->process_d);
        $this->setupLookupOptions($this->buyer_ref);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->dispatch_week_p);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->weaving_works);
        $this->setupLookupOptions($this->current_works);
        $this->setupLookupOptions($this->design);
        $this->setupLookupOptions($this->po_currency);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->payment_plan);
        $this->setupLookupOptions($this->production_plan);
        $this->setupLookupOptions($this->completed);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->cs);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->process_c);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->pp_id);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "bcodelist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->pid); // pid
        $this->buildSearchUrl($srchUrl, $this->po); // po
        $this->buildSearchUrl($srchUrl, $this->design_id); // design_id
        $this->buildSearchUrl($srchUrl, $this->size_cm); // size_cm
        $this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
        $this->buildSearchUrl($srchUrl, $this->process_d); // process_d
        $this->buildSearchUrl($srchUrl, $this->buyer_ref); // buyer_ref
        $this->buildSearchUrl($srchUrl, $this->order_date); // order_date
        $this->buildSearchUrl($srchUrl, $this->despatch_date); // despatch_date
        $this->buildSearchUrl($srchUrl, $this->despatch_week); // despatch_week
        $this->buildSearchUrl($srchUrl, $this->dispatch_week_p); // dispatch_week_p
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->buyers_id); // buyers_id
        $this->buildSearchUrl($srchUrl, $this->buyer_uid); // buyer_uid
        $this->buildSearchUrl($srchUrl, $this->buyer_loc); // buyer_loc
        $this->buildSearchUrl($srchUrl, $this->quantity); // quantity
        $this->buildSearchUrl($srchUrl, $this->sqm); // sqm
        $this->buildSearchUrl($srchUrl, $this->sqm_u); // sqm_u
        $this->buildSearchUrl($srchUrl, $this->c_sqm); // c_sqm
        $this->buildSearchUrl($srchUrl, $this->weaving_works); // weaving_works
        $this->buildSearchUrl($srchUrl, $this->current_works); // current_works
        $this->buildSearchUrl($srchUrl, $this->size_buyer); // size_buyer
        $this->buildSearchUrl($srchUrl, $this->q_sku); // q_sku
        $this->buildSearchUrl($srchUrl, $this->po_price); // po_price
        $this->buildSearchUrl($srchUrl, $this->po_discount); // po_discount
        $this->buildSearchUrl($srchUrl, $this->po_currency); // po_currency
        $this->buildSearchUrl($srchUrl, $this->product_type); // product_type
        $this->buildSearchUrl($srchUrl, $this->shape); // shape
        $this->buildSearchUrl($srchUrl, $this->payment_plan); // payment_plan
        $this->buildSearchUrl($srchUrl, $this->production_plan); // production_plan
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->completed); // completed
        $this->buildSearchUrl($srchUrl, $this->buyer_po); // buyer_po
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->jc_no); // jc_no
        $this->buildSearchUrl($srchUrl, $this->batch_no); // batch_no
        $this->buildSearchUrl($srchUrl, $this->cs); // cs
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->p_remarks); // p_remarks
        $this->buildSearchUrl($srchUrl, $this->roll_no); // roll_no
        $this->buildSearchUrl($srchUrl, $this->qty); // qty
        $this->buildSearchUrl($srchUrl, $this->pl_no); // pl_no
        $this->buildSearchUrl($srchUrl, $this->category); // category
        $this->buildSearchUrl($srchUrl, $this->pp_id); // pp_id
        $this->buildSearchUrl($srchUrl, $this->_11); // 11
        $this->buildSearchUrl($srchUrl, $this->_12); // 12
        $this->buildSearchUrl($srchUrl, $this->_13); // 13
        $this->buildSearchUrl($srchUrl, $this->_14); // 14
        $this->buildSearchUrl($srchUrl, $this->_15); // 15
        $this->buildSearchUrl($srchUrl, $this->_16); // 16
        $this->buildSearchUrl($srchUrl, $this->_17); // 17
        $this->buildSearchUrl($srchUrl, $this->_18); // 18
        $this->buildSearchUrl($srchUrl, $this->_19); // 19
        $this->buildSearchUrl($srchUrl, $this->_20); // 20
        $this->buildSearchUrl($srchUrl, $this->_21); // 21
        $this->buildSearchUrl($srchUrl, $this->_22); // 22
        $this->buildSearchUrl($srchUrl, $this->_23); // 23
        $this->buildSearchUrl($srchUrl, $this->_24); // 24
        $this->buildSearchUrl($srchUrl, $this->_25); // 25
        $this->buildSearchUrl($srchUrl, $this->_26); // 26
        $this->buildSearchUrl($srchUrl, $this->_27); // 27
        $this->buildSearchUrl($srchUrl, $this->_28); // 28
        $this->buildSearchUrl($srchUrl, $this->_29); // 29
        $this->buildSearchUrl($srchUrl, $this->_30); // 30
        $this->buildSearchUrl($srchUrl, $this->_31); // 31
        $this->buildSearchUrl($srchUrl, $this->_32); // 32
        $this->buildSearchUrl($srchUrl, $this->_33); // 33
        $this->buildSearchUrl($srchUrl, $this->_34); // 34
        $this->buildSearchUrl($srchUrl, $this->_35); // 35
        $this->buildSearchUrl($srchUrl, $this->_36); // 36
        $this->buildSearchUrl($srchUrl, $this->_37); // 37
        $this->buildSearchUrl($srchUrl, $this->_38); // 38
        $this->buildSearchUrl($srchUrl, $this->_39); // 39
        $this->buildSearchUrl($srchUrl, $this->_40); // 40
        $this->buildSearchUrl($srchUrl, $this->_41); // 41
        $this->buildSearchUrl($srchUrl, $this->_42); // 42
        $this->buildSearchUrl($srchUrl, $this->_43); // 43
        $this->buildSearchUrl($srchUrl, $this->_44); // 44
        $this->buildSearchUrl($srchUrl, $this->_45); // 45
        $this->buildSearchUrl($srchUrl, $this->_46); // 46
        $this->buildSearchUrl($srchUrl, $this->_47); // 47
        $this->buildSearchUrl($srchUrl, $this->_48); // 48
        $this->buildSearchUrl($srchUrl, $this->_49); // 49
        $this->buildSearchUrl($srchUrl, $this->_50); // 50
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pid
        if ($this->pid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po
        if ($this->po->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // design_id
        if ($this->design_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size_cm
        if ($this->size_cm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process_d
        if ($this->process_d->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->process_d->AdvancedSearch->SearchValue)) {
            $this->process_d->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process_d->AdvancedSearch->SearchValue);
        }
        if (is_array($this->process_d->AdvancedSearch->SearchValue2)) {
            $this->process_d->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process_d->AdvancedSearch->SearchValue2);
        }

        // buyer_ref
        if ($this->buyer_ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // order_date
        if ($this->order_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // despatch_date
        if ($this->despatch_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // despatch_week
        if ($this->despatch_week->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dispatch_week_p
        if ($this->dispatch_week_p->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyers_id
        if ($this->buyers_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_uid
        if ($this->buyer_uid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_loc
        if ($this->buyer_loc->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm_u
        if ($this->sqm_u->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // c_sqm
        if ($this->c_sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // weaving_works
        if ($this->weaving_works->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // current_works
        if ($this->current_works->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size_buyer
        if ($this->size_buyer->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // q_sku
        if ($this->q_sku->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_price
        if ($this->po_price->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_discount
        if ($this->po_discount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_currency
        if ($this->po_currency->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_type
        if ($this->product_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // shape
        if ($this->shape->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment_plan
        if ($this->payment_plan->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // production_plan
        if ($this->production_plan->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // completed
        if ($this->completed->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_po
        if ($this->buyer_po->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_no
        if ($this->jc_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // batch_no
        if ($this->batch_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cs
        if ($this->cs->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p_remarks
        if ($this->p_remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // roll_no
        if ($this->roll_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty
        if ($this->qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pl_no
        if ($this->pl_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pp_id
        if ($this->pp_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 11
        if ($this->_11->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 12
        if ($this->_12->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 13
        if ($this->_13->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 14
        if ($this->_14->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 15
        if ($this->_15->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 16
        if ($this->_16->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 17
        if ($this->_17->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 18
        if ($this->_18->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 19
        if ($this->_19->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 20
        if ($this->_20->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 21
        if ($this->_21->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 22
        if ($this->_22->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 23
        if ($this->_23->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 24
        if ($this->_24->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 25
        if ($this->_25->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 26
        if ($this->_26->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 27
        if ($this->_27->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 28
        if ($this->_28->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 29
        if ($this->_29->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 30
        if ($this->_30->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 31
        if ($this->_31->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 32
        if ($this->_32->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 33
        if ($this->_33->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 34
        if ($this->_34->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 35
        if ($this->_35->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 36
        if ($this->_36->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 37
        if ($this->_37->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 38
        if ($this->_38->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 39
        if ($this->_39->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 40
        if ($this->_40->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 41
        if ($this->_41->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 42
        if ($this->_42->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 43
        if ($this->_43->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 44
        if ($this->_44->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 45
        if ($this->_45->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 46
        if ($this->_46->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 47
        if ($this->_47->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 48
        if ($this->_48->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 49
        if ($this->_49->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 50
        if ($this->_50->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // pid
        $this->pid->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // design_id
        $this->design_id->RowCssClass = "row";

        // size_cm
        $this->size_cm->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // process_d
        $this->process_d->RowCssClass = "row";

        // buyer_ref
        $this->buyer_ref->RowCssClass = "row";

        // order_date
        $this->order_date->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // dispatch_week_p
        $this->dispatch_week_p->RowCssClass = "row";

        // loom_plan
        $this->loom_plan->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // buyers_id
        $this->buyers_id->RowCssClass = "row";

        // buyer_uid
        $this->buyer_uid->RowCssClass = "row";

        // buyer_loc
        $this->buyer_loc->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // sqm_u
        $this->sqm_u->RowCssClass = "row";

        // c_sqm
        $this->c_sqm->RowCssClass = "row";

        // weaving_works
        $this->weaving_works->RowCssClass = "row";

        // current_works
        $this->current_works->RowCssClass = "row";

        // size_buyer
        $this->size_buyer->RowCssClass = "row";

        // design
        $this->design->RowCssClass = "row";

        // w_cm
        $this->w_cm->RowCssClass = "row";

        // l_cm
        $this->l_cm->RowCssClass = "row";

        // q_sku
        $this->q_sku->RowCssClass = "row";

        // po_price
        $this->po_price->RowCssClass = "row";

        // po_discount
        $this->po_discount->RowCssClass = "row";

        // po_currency
        $this->po_currency->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // payment_plan
        $this->payment_plan->RowCssClass = "row";

        // production_plan
        $this->production_plan->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // completed
        $this->completed->RowCssClass = "row";

        // buyer_po
        $this->buyer_po->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // sqm_a
        $this->sqm_a->RowCssClass = "row";

        // 2srm
        $this->_2srm->RowCssClass = "row";

        // 2srm_a
        $this->_2srm_a->RowCssClass = "row";

        // 4srm
        $this->_4srm->RowCssClass = "row";

        // 4srm_a
        $this->_4srm_a->RowCssClass = "row";

        // buyer_tid
        $this->buyer_tid->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // cs
        $this->cs->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // process_c
        $this->process_c->RowCssClass = "row";

        // weight
        $this->weight->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // p_remarks
        $this->p_remarks->RowCssClass = "row";

        // roll_no
        $this->roll_no->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // pl_no
        $this->pl_no->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // pp_id
        $this->pp_id->RowCssClass = "row";

        // consignee
        $this->consignee->RowCssClass = "row";

        // buyer_barcode
        $this->buyer_barcode->RowCssClass = "row";

        // design_next
        $this->design_next->RowCssClass = "row";

        // 11
        $this->_11->RowCssClass = "row";

        // 12
        $this->_12->RowCssClass = "row";

        // 13
        $this->_13->RowCssClass = "row";

        // 14
        $this->_14->RowCssClass = "row";

        // 15
        $this->_15->RowCssClass = "row";

        // 16
        $this->_16->RowCssClass = "row";

        // 17
        $this->_17->RowCssClass = "row";

        // 18
        $this->_18->RowCssClass = "row";

        // 19
        $this->_19->RowCssClass = "row";

        // 20
        $this->_20->RowCssClass = "row";

        // 21
        $this->_21->RowCssClass = "row";

        // 22
        $this->_22->RowCssClass = "row";

        // 23
        $this->_23->RowCssClass = "row";

        // 24
        $this->_24->RowCssClass = "row";

        // 25
        $this->_25->RowCssClass = "row";

        // 26
        $this->_26->RowCssClass = "row";

        // 27
        $this->_27->RowCssClass = "row";

        // 28
        $this->_28->RowCssClass = "row";

        // 29
        $this->_29->RowCssClass = "row";

        // 30
        $this->_30->RowCssClass = "row";

        // 31
        $this->_31->RowCssClass = "row";

        // 32
        $this->_32->RowCssClass = "row";

        // 33
        $this->_33->RowCssClass = "row";

        // 34
        $this->_34->RowCssClass = "row";

        // 35
        $this->_35->RowCssClass = "row";

        // 36
        $this->_36->RowCssClass = "row";

        // 37
        $this->_37->RowCssClass = "row";

        // 38
        $this->_38->RowCssClass = "row";

        // 39
        $this->_39->RowCssClass = "row";

        // 40
        $this->_40->RowCssClass = "row";

        // 41
        $this->_41->RowCssClass = "row";

        // 42
        $this->_42->RowCssClass = "row";

        // 43
        $this->_43->RowCssClass = "row";

        // 44
        $this->_44->RowCssClass = "row";

        // 45
        $this->_45->RowCssClass = "row";

        // 46
        $this->_46->RowCssClass = "row";

        // 47
        $this->_47->RowCssClass = "row";

        // 48
        $this->_48->RowCssClass = "row";

        // 49
        $this->_49->RowCssClass = "row";

        // 50
        $this->_50->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // qc_weaving
        $this->qc_weaving->RowCssClass = "row";

        // roll_no_qty_tmp
        $this->roll_no_qty_tmp->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // pid
            $this->pid->ViewValue = $this->pid->CurrentValue;
            $this->pid->ViewValue = FormatNumber($this->pid->ViewValue, $this->pid->formatPattern());

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // design_id
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->ViewValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->ViewValue = null;
            }

            // size_cm
            $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // process_d
            $curVal = strval($this->process_d->CurrentValue);
            if ($curVal != "") {
                $this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
                if ($this->process_d->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_d->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_d->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process_d->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_d->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_d->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_d->Lookup->renderViewRow($row);
                            $this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
                        }
                    } else {
                        $this->process_d->ViewValue = $this->process_d->CurrentValue;
                    }
                }
            } else {
                $this->process_d->ViewValue = null;
            }

            // buyer_ref
            if ($this->buyer_ref->VirtualValue != "") {
                $this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
            } else {
                $curVal = strval($this->buyer_ref->CurrentValue);
                if ($curVal != "") {
                    $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
                    if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                            $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                        } else {
                            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                        }
                    }
                } else {
                    $this->buyer_ref->ViewValue = null;
                }
            }

            // order_date
            $this->order_date->ViewValue = $this->order_date->CurrentValue;
            $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // dispatch_week_p
            $curVal = strval($this->dispatch_week_p->CurrentValue);
            if ($curVal != "") {
                $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
                if ($this->dispatch_week_p->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->dispatch_week_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->dispatch_week_p->Lookup->renderViewRow($rswrk[0]);
                        $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
                    } else {
                        $this->dispatch_week_p->ViewValue = FormatNumber($this->dispatch_week_p->CurrentValue, $this->dispatch_week_p->formatPattern());
                    }
                }
            } else {
                $this->dispatch_week_p->ViewValue = null;
            }

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // buyer_uid
            $this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;

            // buyer_loc
            $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // sqm_u
            $this->sqm_u->ViewValue = $this->sqm_u->CurrentValue;
            $this->sqm_u->ViewValue = FormatNumber($this->sqm_u->ViewValue, $this->sqm_u->formatPattern());

            // c_sqm
            $this->c_sqm->ViewValue = $this->c_sqm->CurrentValue;
            $this->c_sqm->ViewValue = FormatNumber($this->c_sqm->ViewValue, $this->c_sqm->formatPattern());

            // weaving_works
            $curVal = strval($this->weaving_works->CurrentValue);
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
                if ($this->weaving_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                        $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                    } else {
                        $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                    }
                }
            } else {
                $this->weaving_works->ViewValue = null;
            }

            // current_works
            $curVal = strval($this->current_works->CurrentValue);
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
                if ($this->current_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                        $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                    } else {
                        $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                    }
                }
            } else {
                $this->current_works->ViewValue = null;
            }

            // size_buyer
            $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;
            $this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, $this->q_sku->formatPattern());

            // po_price
            $this->po_price->ViewValue = $this->po_price->CurrentValue;

            // po_discount
            $this->po_discount->ViewValue = $this->po_discount->CurrentValue;
            $this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, $this->po_discount->formatPattern());

            // po_currency
            $curVal = strval($this->po_currency->CurrentValue);
            if ($curVal != "") {
                $this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
                if ($this->po_currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_currency->Lookup->renderViewRow($rswrk[0]);
                        $this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
                    } else {
                        $this->po_currency->ViewValue = FormatNumber($this->po_currency->CurrentValue, $this->po_currency->formatPattern());
                    }
                }
            } else {
                $this->po_currency->ViewValue = null;
            }

            // product_type
            if (strval($this->product_type->CurrentValue) != "") {
                $this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
            } else {
                $this->product_type->ViewValue = null;
            }

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->ViewValue = FormatNumber($this->shape->CurrentValue, $this->shape->formatPattern());
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // payment_plan
            $curVal = strval($this->payment_plan->CurrentValue);
            if ($curVal != "") {
                $this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
                if ($this->payment_plan->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->payment_plan->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_plan->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
                    } else {
                        $this->payment_plan->ViewValue = FormatNumber($this->payment_plan->CurrentValue, $this->payment_plan->formatPattern());
                    }
                }
            } else {
                $this->payment_plan->ViewValue = null;
            }

            // production_plan
            if (strval($this->production_plan->CurrentValue) != "") {
                $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
            } else {
                $this->production_plan->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // completed
            if (strval($this->completed->CurrentValue) != "") {
                $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
            } else {
                $this->completed->ViewValue = null;
            }

            // buyer_po
            $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // cs
            if (strval($this->cs->CurrentValue) != "") {
                $this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
            } else {
                $this->cs->ViewValue = null;
            }

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process->Lookup->renderViewRow($row);
                            $this->process->ViewValue->add($this->process->displayValue($arwrk));
                        }
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // process_c
            $curVal = strval($this->process_c->CurrentValue);
            if ($curVal != "") {
                $this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
                if ($this->process_c->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_c->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_c->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process_c->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_c->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_c->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_c->Lookup->renderViewRow($row);
                            $this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
                        }
                    } else {
                        $this->process_c->ViewValue = $this->process_c->CurrentValue;
                    }
                }
            } else {
                $this->process_c->ViewValue = null;
            }

            // weight
            $this->weight->ViewValue = $this->weight->CurrentValue;
            $this->weight->ViewValue = FormatNumber($this->weight->ViewValue, $this->weight->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // p_remarks
            $this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;
            $this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, $this->roll_no->formatPattern());

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // pl_no
            $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
            $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // pp_id
            $this->pp_id->ViewValue = $this->pp_id->CurrentValue;
            $curVal = strval($this->pp_id->CurrentValue);
            if ($curVal != "") {
                $this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
                if ($this->pp_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pp_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pp_id->Lookup->renderViewRow($rswrk[0]);
                        $this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
                    } else {
                        $this->pp_id->ViewValue = FormatNumber($this->pp_id->CurrentValue, $this->pp_id->formatPattern());
                    }
                }
            } else {
                $this->pp_id->ViewValue = null;
            }

            // 11
            $this->_11->ViewValue = $this->_11->CurrentValue;

            // 12
            $this->_12->ViewValue = $this->_12->CurrentValue;

            // 13
            $this->_13->ViewValue = $this->_13->CurrentValue;

            // 14
            $this->_14->ViewValue = $this->_14->CurrentValue;

            // 15
            $this->_15->ViewValue = $this->_15->CurrentValue;

            // 16
            $this->_16->ViewValue = $this->_16->CurrentValue;

            // 17
            $this->_17->ViewValue = $this->_17->CurrentValue;

            // 18
            $this->_18->ViewValue = $this->_18->CurrentValue;

            // 19
            $this->_19->ViewValue = $this->_19->CurrentValue;

            // 20
            $this->_20->ViewValue = $this->_20->CurrentValue;

            // 21
            $this->_21->ViewValue = $this->_21->CurrentValue;

            // 22
            $this->_22->ViewValue = $this->_22->CurrentValue;

            // 23
            $this->_23->ViewValue = $this->_23->CurrentValue;

            // 24
            $this->_24->ViewValue = $this->_24->CurrentValue;

            // 25
            $this->_25->ViewValue = $this->_25->CurrentValue;

            // 26
            $this->_26->ViewValue = $this->_26->CurrentValue;

            // 27
            $this->_27->ViewValue = $this->_27->CurrentValue;

            // 28
            $this->_28->ViewValue = $this->_28->CurrentValue;

            // 29
            $this->_29->ViewValue = $this->_29->CurrentValue;

            // 30
            $this->_30->ViewValue = $this->_30->CurrentValue;

            // 31
            $this->_31->ViewValue = $this->_31->CurrentValue;

            // 32
            $this->_32->ViewValue = $this->_32->CurrentValue;

            // 33
            $this->_33->ViewValue = $this->_33->CurrentValue;

            // 34
            $this->_34->ViewValue = $this->_34->CurrentValue;

            // 35
            $this->_35->ViewValue = $this->_35->CurrentValue;

            // 36
            $this->_36->ViewValue = $this->_36->CurrentValue;

            // 37
            $this->_37->ViewValue = $this->_37->CurrentValue;

            // 38
            $this->_38->ViewValue = $this->_38->CurrentValue;

            // 39
            $this->_39->ViewValue = $this->_39->CurrentValue;

            // 40
            $this->_40->ViewValue = $this->_40->CurrentValue;

            // 41
            $this->_41->ViewValue = $this->_41->CurrentValue;

            // 42
            $this->_42->ViewValue = $this->_42->CurrentValue;

            // 43
            $this->_43->ViewValue = $this->_43->CurrentValue;

            // 44
            $this->_44->ViewValue = $this->_44->CurrentValue;

            // 45
            $this->_45->ViewValue = $this->_45->CurrentValue;

            // 46
            $this->_46->ViewValue = $this->_46->CurrentValue;

            // 47
            $this->_47->ViewValue = $this->_47->CurrentValue;

            // 48
            $this->_48->ViewValue = $this->_48->CurrentValue;

            // 49
            $this->_49->ViewValue = $this->_49->CurrentValue;

            // 50
            $this->_50->ViewValue = $this->_50->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // pid
            $this->pid->HrefValue = "";
            $this->pid->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // design_id
            if (!EmptyValue($this->design_id->CurrentValue)) {
                $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . (!empty($this->design_id->ViewValue) && !is_array($this->design_id->ViewValue) ? RemoveHtml($this->design_id->ViewValue) : $this->design_id->CurrentValue); // Add prefix/suffix
                $this->design_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
                }
            } else {
                $this->design_id->HrefValue = "";
            }
            $this->design_id->TooltipValue = "";

            // size_cm
            $this->size_cm->HrefValue = "";
            $this->size_cm->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // process_d
            $this->process_d->HrefValue = "";
            $this->process_d->TooltipValue = "";

            // buyer_ref
            if (!EmptyValue($this->buyer_ref->CurrentValue)) {
                $this->buyer_ref->HrefValue = $this->buyer_ref->getLinkPrefix() . $this->buyer_ref->CurrentValue; // Add prefix/suffix
                $this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
                }
            } else {
                $this->buyer_ref->HrefValue = "";
            }
            $this->buyer_ref->TooltipValue = "";

            // order_date
            $this->order_date->HrefValue = "";
            $this->order_date->TooltipValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // dispatch_week_p
            $this->dispatch_week_p->HrefValue = "";
            $this->dispatch_week_p->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // buyers_id
            if (!EmptyValue($this->buyers_id->CurrentValue)) {
                $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
                $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
                }
            } else {
                $this->buyers_id->HrefValue = "";
            }
            $this->buyers_id->TooltipValue = "";

            // buyer_uid
            $this->buyer_uid->HrefValue = "";
            $this->buyer_uid->TooltipValue = "";

            // buyer_loc
            $this->buyer_loc->HrefValue = "";
            $this->buyer_loc->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // sqm_u
            $this->sqm_u->HrefValue = "";
            $this->sqm_u->TooltipValue = "";

            // c_sqm
            $this->c_sqm->HrefValue = "";
            $this->c_sqm->TooltipValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";
            $this->weaving_works->TooltipValue = "";

            // current_works
            $this->current_works->HrefValue = "";
            $this->current_works->TooltipValue = "";

            // size_buyer
            $this->size_buyer->HrefValue = "";
            $this->size_buyer->TooltipValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";
            $this->q_sku->TooltipValue = "";

            // po_price
            $this->po_price->HrefValue = "";
            $this->po_price->TooltipValue = "";

            // po_discount
            $this->po_discount->HrefValue = "";
            $this->po_discount->TooltipValue = "";

            // po_currency
            $this->po_currency->HrefValue = "";
            $this->po_currency->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";

            // payment_plan
            $this->payment_plan->HrefValue = "";
            $this->payment_plan->TooltipValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";
            $this->production_plan->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // completed
            $this->completed->HrefValue = "";
            $this->completed->TooltipValue = "";

            // buyer_po
            $this->buyer_po->HrefValue = "";
            $this->buyer_po->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }
            $this->batch_no->TooltipValue = "";

            // cs
            $this->cs->HrefValue = "";
            $this->cs->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // p_remarks
            $this->p_remarks->HrefValue = "";
            $this->p_remarks->TooltipValue = "";

            // roll_no
            $this->roll_no->HrefValue = "";
            $this->roll_no->TooltipValue = "";

            // qty
            $this->qty->HrefValue = "";
            $this->qty->TooltipValue = "";

            // pl_no
            $this->pl_no->HrefValue = "";
            $this->pl_no->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // pp_id
            $this->pp_id->HrefValue = "";
            $this->pp_id->TooltipValue = "";

            // 11
            $this->_11->HrefValue = "";
            $this->_11->TooltipValue = "";

            // 12
            $this->_12->HrefValue = "";
            $this->_12->TooltipValue = "";

            // 13
            $this->_13->HrefValue = "";
            $this->_13->TooltipValue = "";

            // 14
            $this->_14->HrefValue = "";
            $this->_14->TooltipValue = "";

            // 15
            $this->_15->HrefValue = "";
            $this->_15->TooltipValue = "";

            // 16
            $this->_16->HrefValue = "";
            $this->_16->TooltipValue = "";

            // 17
            $this->_17->HrefValue = "";
            $this->_17->TooltipValue = "";

            // 18
            $this->_18->HrefValue = "";
            $this->_18->TooltipValue = "";

            // 19
            $this->_19->HrefValue = "";
            $this->_19->TooltipValue = "";

            // 20
            $this->_20->HrefValue = "";
            $this->_20->TooltipValue = "";

            // 21
            $this->_21->HrefValue = "";
            $this->_21->TooltipValue = "";

            // 22
            $this->_22->HrefValue = "";
            $this->_22->TooltipValue = "";

            // 23
            $this->_23->HrefValue = "";
            $this->_23->TooltipValue = "";

            // 24
            $this->_24->HrefValue = "";
            $this->_24->TooltipValue = "";

            // 25
            $this->_25->HrefValue = "";
            $this->_25->TooltipValue = "";

            // 26
            $this->_26->HrefValue = "";
            $this->_26->TooltipValue = "";

            // 27
            $this->_27->HrefValue = "";
            $this->_27->TooltipValue = "";

            // 28
            $this->_28->HrefValue = "";
            $this->_28->TooltipValue = "";

            // 29
            $this->_29->HrefValue = "";
            $this->_29->TooltipValue = "";

            // 30
            $this->_30->HrefValue = "";
            $this->_30->TooltipValue = "";

            // 31
            $this->_31->HrefValue = "";
            $this->_31->TooltipValue = "";

            // 32
            $this->_32->HrefValue = "";
            $this->_32->TooltipValue = "";

            // 33
            $this->_33->HrefValue = "";
            $this->_33->TooltipValue = "";

            // 34
            $this->_34->HrefValue = "";
            $this->_34->TooltipValue = "";

            // 35
            $this->_35->HrefValue = "";
            $this->_35->TooltipValue = "";

            // 36
            $this->_36->HrefValue = "";
            $this->_36->TooltipValue = "";

            // 37
            $this->_37->HrefValue = "";
            $this->_37->TooltipValue = "";

            // 38
            $this->_38->HrefValue = "";
            $this->_38->TooltipValue = "";

            // 39
            $this->_39->HrefValue = "";
            $this->_39->TooltipValue = "";

            // 40
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";

            // 41
            $this->_41->HrefValue = "";
            $this->_41->TooltipValue = "";

            // 42
            $this->_42->HrefValue = "";
            $this->_42->TooltipValue = "";

            // 43
            $this->_43->HrefValue = "";
            $this->_43->TooltipValue = "";

            // 44
            $this->_44->HrefValue = "";
            $this->_44->TooltipValue = "";

            // 45
            $this->_45->HrefValue = "";
            $this->_45->TooltipValue = "";

            // 46
            $this->_46->HrefValue = "";
            $this->_46->TooltipValue = "";

            // 47
            $this->_47->HrefValue = "";
            $this->_47->TooltipValue = "";

            // 48
            $this->_48->HrefValue = "";
            $this->_48->TooltipValue = "";

            // 49
            $this->_49->HrefValue = "";
            $this->_49->TooltipValue = "";

            // 50
            $this->_50->HrefValue = "";
            $this->_50->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // pid
            $this->pid->setupEditAttributes();
            $this->pid->EditValue = $this->pid->AdvancedSearch->SearchValue;
            $this->pid->PlaceHolder = RemoveHtml($this->pid->caption());

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->AdvancedSearch->SearchValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());
            $this->po->setupEditAttributes();
            $this->po->EditValue2 = $this->po->AdvancedSearch->SearchValue2;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // design_id
            $this->design_id->setupEditAttributes();
            $curVal = trim(strval($this->design_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->design_id->AdvancedSearch->ViewValue = $this->design_id->lookupCacheOption($curVal);
            } else {
                $this->design_id->AdvancedSearch->ViewValue = $this->design_id->Lookup !== null && is_array($this->design_id->lookupOptions()) && count($this->design_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->design_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->design_id->EditValue = array_values($this->design_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->design_id->AdvancedSearch->SearchValue, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->design_id->EditValue = $arwrk;
            }
            $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

            // size_cm
            $this->size_cm->setupEditAttributes();
            if (!$this->size_cm->Raw) {
                $this->size_cm->AdvancedSearch->SearchValue = HtmlDecode($this->size_cm->AdvancedSearch->SearchValue);
            }
            $this->size_cm->EditValue = HtmlEncode($this->size_cm->AdvancedSearch->SearchValue);
            $this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue = $this->_barcode->AdvancedSearch->SearchValue;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue2 = $this->_barcode->AdvancedSearch->SearchValue2;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // process_d
            $curVal = trim(strval($this->process_d->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->process_d->AdvancedSearch->ViewValue = $this->process_d->lookupCacheOption($curVal);
            } else {
                $this->process_d->AdvancedSearch->ViewValue = $this->process_d->Lookup !== null && is_array($this->process_d->lookupOptions()) && count($this->process_d->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process_d->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->process_d->EditValue = array_values($this->process_d->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_d->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_d->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->process_d->getSelectFilter($this); // PHP
                $sqlWrk = $this->process_d->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process_d->EditValue = $arwrk;
            }
            $this->process_d->PlaceHolder = RemoveHtml($this->process_d->caption());

            // buyer_ref
            $this->buyer_ref->setupEditAttributes();
            $this->buyer_ref->EditValue = $this->buyer_ref->AdvancedSearch->SearchValue;
            $this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

            // order_date
            $this->order_date->setupEditAttributes();
            $this->order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->order_date->AdvancedSearch->SearchValue, $this->order_date->formatPattern()), $this->order_date->formatPattern()));
            $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

            // despatch_date
            $this->despatch_date->setupEditAttributes();
            $this->despatch_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->despatch_date->AdvancedSearch->SearchValue, $this->despatch_date->formatPattern()), $this->despatch_date->formatPattern()));
            $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->despatch_week->EditValue = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->AdvancedSearch->SearchValue, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // dispatch_week_p
            $this->dispatch_week_p->setupEditAttributes();
            $curVal = trim(strval($this->dispatch_week_p->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->dispatch_week_p->AdvancedSearch->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
            } else {
                $this->dispatch_week_p->AdvancedSearch->ViewValue = $this->dispatch_week_p->Lookup !== null && is_array($this->dispatch_week_p->lookupOptions()) && count($this->dispatch_week_p->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->dispatch_week_p->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->dispatch_week_p->EditValue = array_values($this->dispatch_week_p->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->dispatch_week_p->AdvancedSearch->SearchValue, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->dispatch_week_p->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->dispatch_week_p->EditValue = $arwrk;
            }
            $this->dispatch_week_p->PlaceHolder = RemoveHtml($this->dispatch_week_p->caption());

            // status
            $this->status->setupEditAttributes();
            $curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
            } else {
                $this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== null && is_array($this->status->lookupOptions()) && count($this->status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->status->EditValue = array_values($this->status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->status->AdvancedSearch->SearchValue, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->status->EditValue = $arwrk;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // buyers_id
            $this->buyers_id->setupEditAttributes();
            $curVal = trim(strval($this->buyers_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            } else {
                $this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->Lookup !== null && is_array($this->buyers_id->lookupOptions()) && count($this->buyers_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyers_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->buyers_id->EditValue = array_values($this->buyers_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyers_id->AdvancedSearch->SearchValue, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->buyers_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyers_id->EditValue = $arwrk;
            }
            $this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

            // buyer_uid
            $this->buyer_uid->setupEditAttributes();
            if (!$this->buyer_uid->Raw) {
                $this->buyer_uid->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_uid->AdvancedSearch->SearchValue);
            }
            $this->buyer_uid->EditValue = HtmlEncode($this->buyer_uid->AdvancedSearch->SearchValue);
            $this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

            // buyer_loc
            $this->buyer_loc->setupEditAttributes();
            if (!$this->buyer_loc->Raw) {
                $this->buyer_loc->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_loc->AdvancedSearch->SearchValue);
            }
            $this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->AdvancedSearch->SearchValue);
            $this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->AdvancedSearch->SearchValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // sqm_u
            $this->sqm_u->setupEditAttributes();
            $this->sqm_u->EditValue = $this->sqm_u->AdvancedSearch->SearchValue;
            $this->sqm_u->PlaceHolder = RemoveHtml($this->sqm_u->caption());

            // c_sqm
            $this->c_sqm->setupEditAttributes();
            $this->c_sqm->EditValue = $this->c_sqm->AdvancedSearch->SearchValue;
            $this->c_sqm->PlaceHolder = RemoveHtml($this->c_sqm->caption());

            // weaving_works
            $this->weaving_works->setupEditAttributes();
            $curVal = trim(strval($this->weaving_works->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->weaving_works->AdvancedSearch->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
            } else {
                $this->weaving_works->AdvancedSearch->ViewValue = $this->weaving_works->Lookup !== null && is_array($this->weaving_works->lookupOptions()) && count($this->weaving_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->weaving_works->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->weaving_works->EditValue = array_values($this->weaving_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->weaving_works->AdvancedSearch->SearchValue, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->weaving_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->weaving_works->EditValue = $arwrk;
            }
            $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

            // current_works
            $this->current_works->setupEditAttributes();
            $curVal = trim(strval($this->current_works->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->current_works->AdvancedSearch->ViewValue = $this->current_works->lookupCacheOption($curVal);
            } else {
                $this->current_works->AdvancedSearch->ViewValue = $this->current_works->Lookup !== null && is_array($this->current_works->lookupOptions()) && count($this->current_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->current_works->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->current_works->EditValue = array_values($this->current_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->current_works->AdvancedSearch->SearchValue, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->current_works->EditValue = $arwrk;
            }
            $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

            // size_buyer
            $this->size_buyer->setupEditAttributes();
            if (!$this->size_buyer->Raw) {
                $this->size_buyer->AdvancedSearch->SearchValue = HtmlDecode($this->size_buyer->AdvancedSearch->SearchValue);
            }
            $this->size_buyer->EditValue = HtmlEncode($this->size_buyer->AdvancedSearch->SearchValue);
            $this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

            // q_sku
            $this->q_sku->setupEditAttributes();
            $this->q_sku->EditValue = $this->q_sku->AdvancedSearch->SearchValue;
            $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

            // po_price
            $this->po_price->setupEditAttributes();
            if (!$this->po_price->Raw) {
                $this->po_price->AdvancedSearch->SearchValue = HtmlDecode($this->po_price->AdvancedSearch->SearchValue);
            }
            $this->po_price->EditValue = HtmlEncode($this->po_price->AdvancedSearch->SearchValue);
            $this->po_price->PlaceHolder = RemoveHtml($this->po_price->caption());

            // po_discount
            $this->po_discount->setupEditAttributes();
            $this->po_discount->EditValue = $this->po_discount->AdvancedSearch->SearchValue;
            $this->po_discount->PlaceHolder = RemoveHtml($this->po_discount->caption());

            // po_currency
            $curVal = trim(strval($this->po_currency->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->po_currency->AdvancedSearch->ViewValue = $this->po_currency->lookupCacheOption($curVal);
            } else {
                $this->po_currency->AdvancedSearch->ViewValue = $this->po_currency->Lookup !== null && is_array($this->po_currency->lookupOptions()) && count($this->po_currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->po_currency->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->po_currency->EditValue = array_values($this->po_currency->lookupOptions());
                if ($this->po_currency->AdvancedSearch->ViewValue == "") {
                    $this->po_currency->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->po_currency->AdvancedSearch->SearchValue, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->po_currency->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->po_currency->Lookup->renderViewRow($rswrk[0]);
                    $this->po_currency->AdvancedSearch->ViewValue = $this->po_currency->displayValue($arwrk);
                } else {
                    $this->po_currency->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->po_currency->EditValue = $arwrk;
            }
            $this->po_currency->PlaceHolder = RemoveHtml($this->po_currency->caption());

            // product_type
            $this->product_type->setupEditAttributes();
            $this->product_type->EditValue = $this->product_type->options(true);
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // shape
            $this->shape->setupEditAttributes();
            $curVal = trim(strval($this->shape->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->shape->AdvancedSearch->ViewValue = $this->shape->lookupCacheOption($curVal);
            } else {
                $this->shape->AdvancedSearch->ViewValue = $this->shape->Lookup !== null && is_array($this->shape->lookupOptions()) && count($this->shape->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shape->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->shape->EditValue = array_values($this->shape->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->shape->AdvancedSearch->SearchValue, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->shape->EditValue = $arwrk;
            }
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // payment_plan
            $this->payment_plan->setupEditAttributes();
            $curVal = trim(strval($this->payment_plan->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->payment_plan->AdvancedSearch->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
            } else {
                $this->payment_plan->AdvancedSearch->ViewValue = $this->payment_plan->Lookup !== null && is_array($this->payment_plan->lookupOptions()) && count($this->payment_plan->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->payment_plan->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->payment_plan->EditValue = array_values($this->payment_plan->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->payment_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->payment_plan->AdvancedSearch->SearchValue, $this->payment_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->payment_plan->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->payment_plan->EditValue = $arwrk;
            }
            $this->payment_plan->PlaceHolder = RemoveHtml($this->payment_plan->caption());

            // production_plan
            $this->production_plan->setupEditAttributes();
            $this->production_plan->EditValue = $this->production_plan->options(true);
            $this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // completed
            $this->completed->setupEditAttributes();
            $this->completed->EditValue = $this->completed->options(true);
            $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

            // buyer_po
            $this->buyer_po->setupEditAttributes();
            if (!$this->buyer_po->Raw) {
                $this->buyer_po->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_po->AdvancedSearch->SearchValue);
            }
            $this->buyer_po->EditValue = HtmlEncode($this->buyer_po->AdvancedSearch->SearchValue);
            $this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            $this->jc_no->EditValue = $this->jc_no->AdvancedSearch->SearchValue;
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

            // batch_no
            $this->batch_no->setupEditAttributes();
            $curVal = trim(strval($this->batch_no->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            } else {
                $this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->Lookup !== null && is_array($this->batch_no->lookupOptions()) && count($this->batch_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->batch_no->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->batch_no->EditValue = array_values($this->batch_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->batch_no->AdvancedSearch->SearchValue, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->batch_no->EditValue = $arwrk;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // cs
            $this->cs->setupEditAttributes();
            $this->cs->EditValue = $this->cs->options(true);
            $this->cs->PlaceHolder = RemoveHtml($this->cs->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // p_remarks
            $this->p_remarks->setupEditAttributes();
            if (!$this->p_remarks->Raw) {
                $this->p_remarks->AdvancedSearch->SearchValue = HtmlDecode($this->p_remarks->AdvancedSearch->SearchValue);
            }
            $this->p_remarks->EditValue = HtmlEncode($this->p_remarks->AdvancedSearch->SearchValue);
            $this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

            // roll_no
            $this->roll_no->setupEditAttributes();
            $this->roll_no->EditValue = $this->roll_no->AdvancedSearch->SearchValue;
            $this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

            // qty
            $this->qty->setupEditAttributes();
            $this->qty->EditValue = $this->qty->AdvancedSearch->SearchValue;
            $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

            // pl_no
            $this->pl_no->setupEditAttributes();
            $this->pl_no->EditValue = $this->pl_no->AdvancedSearch->SearchValue;
            $this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->AdvancedSearch->SearchValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // pp_id
            $this->pp_id->setupEditAttributes();
            $this->pp_id->EditValue = $this->pp_id->AdvancedSearch->SearchValue;
            $curVal = strval($this->pp_id->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->pp_id->EditValue = $this->pp_id->lookupCacheOption($curVal);
                if ($this->pp_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pp_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pp_id->Lookup->renderViewRow($rswrk[0]);
                        $this->pp_id->EditValue = $this->pp_id->displayValue($arwrk);
                    } else {
                        $this->pp_id->EditValue = HtmlEncode(FormatNumber($this->pp_id->AdvancedSearch->SearchValue, $this->pp_id->formatPattern()));
                    }
                }
            } else {
                $this->pp_id->EditValue = null;
            }
            $this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

            // 11
            $this->_11->setupEditAttributes();
            if (!$this->_11->Raw) {
                $this->_11->AdvancedSearch->SearchValue = HtmlDecode($this->_11->AdvancedSearch->SearchValue);
            }
            $this->_11->EditValue = HtmlEncode($this->_11->AdvancedSearch->SearchValue);
            $this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

            // 12
            $this->_12->setupEditAttributes();
            if (!$this->_12->Raw) {
                $this->_12->AdvancedSearch->SearchValue = HtmlDecode($this->_12->AdvancedSearch->SearchValue);
            }
            $this->_12->EditValue = HtmlEncode($this->_12->AdvancedSearch->SearchValue);
            $this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

            // 13
            $this->_13->setupEditAttributes();
            if (!$this->_13->Raw) {
                $this->_13->AdvancedSearch->SearchValue = HtmlDecode($this->_13->AdvancedSearch->SearchValue);
            }
            $this->_13->EditValue = HtmlEncode($this->_13->AdvancedSearch->SearchValue);
            $this->_13->PlaceHolder = RemoveHtml($this->_13->caption());

            // 14
            $this->_14->setupEditAttributes();
            if (!$this->_14->Raw) {
                $this->_14->AdvancedSearch->SearchValue = HtmlDecode($this->_14->AdvancedSearch->SearchValue);
            }
            $this->_14->EditValue = HtmlEncode($this->_14->AdvancedSearch->SearchValue);
            $this->_14->PlaceHolder = RemoveHtml($this->_14->caption());

            // 15
            $this->_15->setupEditAttributes();
            if (!$this->_15->Raw) {
                $this->_15->AdvancedSearch->SearchValue = HtmlDecode($this->_15->AdvancedSearch->SearchValue);
            }
            $this->_15->EditValue = HtmlEncode($this->_15->AdvancedSearch->SearchValue);
            $this->_15->PlaceHolder = RemoveHtml($this->_15->caption());

            // 16
            $this->_16->setupEditAttributes();
            if (!$this->_16->Raw) {
                $this->_16->AdvancedSearch->SearchValue = HtmlDecode($this->_16->AdvancedSearch->SearchValue);
            }
            $this->_16->EditValue = HtmlEncode($this->_16->AdvancedSearch->SearchValue);
            $this->_16->PlaceHolder = RemoveHtml($this->_16->caption());

            // 17
            $this->_17->setupEditAttributes();
            if (!$this->_17->Raw) {
                $this->_17->AdvancedSearch->SearchValue = HtmlDecode($this->_17->AdvancedSearch->SearchValue);
            }
            $this->_17->EditValue = HtmlEncode($this->_17->AdvancedSearch->SearchValue);
            $this->_17->PlaceHolder = RemoveHtml($this->_17->caption());

            // 18
            $this->_18->setupEditAttributes();
            if (!$this->_18->Raw) {
                $this->_18->AdvancedSearch->SearchValue = HtmlDecode($this->_18->AdvancedSearch->SearchValue);
            }
            $this->_18->EditValue = HtmlEncode($this->_18->AdvancedSearch->SearchValue);
            $this->_18->PlaceHolder = RemoveHtml($this->_18->caption());

            // 19
            $this->_19->setupEditAttributes();
            if (!$this->_19->Raw) {
                $this->_19->AdvancedSearch->SearchValue = HtmlDecode($this->_19->AdvancedSearch->SearchValue);
            }
            $this->_19->EditValue = HtmlEncode($this->_19->AdvancedSearch->SearchValue);
            $this->_19->PlaceHolder = RemoveHtml($this->_19->caption());

            // 20
            $this->_20->setupEditAttributes();
            if (!$this->_20->Raw) {
                $this->_20->AdvancedSearch->SearchValue = HtmlDecode($this->_20->AdvancedSearch->SearchValue);
            }
            $this->_20->EditValue = HtmlEncode($this->_20->AdvancedSearch->SearchValue);
            $this->_20->PlaceHolder = RemoveHtml($this->_20->caption());

            // 21
            $this->_21->setupEditAttributes();
            if (!$this->_21->Raw) {
                $this->_21->AdvancedSearch->SearchValue = HtmlDecode($this->_21->AdvancedSearch->SearchValue);
            }
            $this->_21->EditValue = HtmlEncode($this->_21->AdvancedSearch->SearchValue);
            $this->_21->PlaceHolder = RemoveHtml($this->_21->caption());

            // 22
            $this->_22->setupEditAttributes();
            if (!$this->_22->Raw) {
                $this->_22->AdvancedSearch->SearchValue = HtmlDecode($this->_22->AdvancedSearch->SearchValue);
            }
            $this->_22->EditValue = HtmlEncode($this->_22->AdvancedSearch->SearchValue);
            $this->_22->PlaceHolder = RemoveHtml($this->_22->caption());

            // 23
            $this->_23->setupEditAttributes();
            if (!$this->_23->Raw) {
                $this->_23->AdvancedSearch->SearchValue = HtmlDecode($this->_23->AdvancedSearch->SearchValue);
            }
            $this->_23->EditValue = HtmlEncode($this->_23->AdvancedSearch->SearchValue);
            $this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

            // 24
            $this->_24->setupEditAttributes();
            if (!$this->_24->Raw) {
                $this->_24->AdvancedSearch->SearchValue = HtmlDecode($this->_24->AdvancedSearch->SearchValue);
            }
            $this->_24->EditValue = HtmlEncode($this->_24->AdvancedSearch->SearchValue);
            $this->_24->PlaceHolder = RemoveHtml($this->_24->caption());

            // 25
            $this->_25->setupEditAttributes();
            if (!$this->_25->Raw) {
                $this->_25->AdvancedSearch->SearchValue = HtmlDecode($this->_25->AdvancedSearch->SearchValue);
            }
            $this->_25->EditValue = HtmlEncode($this->_25->AdvancedSearch->SearchValue);
            $this->_25->PlaceHolder = RemoveHtml($this->_25->caption());

            // 26
            $this->_26->setupEditAttributes();
            if (!$this->_26->Raw) {
                $this->_26->AdvancedSearch->SearchValue = HtmlDecode($this->_26->AdvancedSearch->SearchValue);
            }
            $this->_26->EditValue = HtmlEncode($this->_26->AdvancedSearch->SearchValue);
            $this->_26->PlaceHolder = RemoveHtml($this->_26->caption());

            // 27
            $this->_27->setupEditAttributes();
            if (!$this->_27->Raw) {
                $this->_27->AdvancedSearch->SearchValue = HtmlDecode($this->_27->AdvancedSearch->SearchValue);
            }
            $this->_27->EditValue = HtmlEncode($this->_27->AdvancedSearch->SearchValue);
            $this->_27->PlaceHolder = RemoveHtml($this->_27->caption());

            // 28
            $this->_28->setupEditAttributes();
            if (!$this->_28->Raw) {
                $this->_28->AdvancedSearch->SearchValue = HtmlDecode($this->_28->AdvancedSearch->SearchValue);
            }
            $this->_28->EditValue = HtmlEncode($this->_28->AdvancedSearch->SearchValue);
            $this->_28->PlaceHolder = RemoveHtml($this->_28->caption());

            // 29
            $this->_29->setupEditAttributes();
            if (!$this->_29->Raw) {
                $this->_29->AdvancedSearch->SearchValue = HtmlDecode($this->_29->AdvancedSearch->SearchValue);
            }
            $this->_29->EditValue = HtmlEncode($this->_29->AdvancedSearch->SearchValue);
            $this->_29->PlaceHolder = RemoveHtml($this->_29->caption());

            // 30
            $this->_30->setupEditAttributes();
            if (!$this->_30->Raw) {
                $this->_30->AdvancedSearch->SearchValue = HtmlDecode($this->_30->AdvancedSearch->SearchValue);
            }
            $this->_30->EditValue = HtmlEncode($this->_30->AdvancedSearch->SearchValue);
            $this->_30->PlaceHolder = RemoveHtml($this->_30->caption());

            // 31
            $this->_31->setupEditAttributes();
            if (!$this->_31->Raw) {
                $this->_31->AdvancedSearch->SearchValue = HtmlDecode($this->_31->AdvancedSearch->SearchValue);
            }
            $this->_31->EditValue = HtmlEncode($this->_31->AdvancedSearch->SearchValue);
            $this->_31->PlaceHolder = RemoveHtml($this->_31->caption());

            // 32
            $this->_32->setupEditAttributes();
            if (!$this->_32->Raw) {
                $this->_32->AdvancedSearch->SearchValue = HtmlDecode($this->_32->AdvancedSearch->SearchValue);
            }
            $this->_32->EditValue = HtmlEncode($this->_32->AdvancedSearch->SearchValue);
            $this->_32->PlaceHolder = RemoveHtml($this->_32->caption());

            // 33
            $this->_33->setupEditAttributes();
            if (!$this->_33->Raw) {
                $this->_33->AdvancedSearch->SearchValue = HtmlDecode($this->_33->AdvancedSearch->SearchValue);
            }
            $this->_33->EditValue = HtmlEncode($this->_33->AdvancedSearch->SearchValue);
            $this->_33->PlaceHolder = RemoveHtml($this->_33->caption());

            // 34
            $this->_34->setupEditAttributes();
            if (!$this->_34->Raw) {
                $this->_34->AdvancedSearch->SearchValue = HtmlDecode($this->_34->AdvancedSearch->SearchValue);
            }
            $this->_34->EditValue = HtmlEncode($this->_34->AdvancedSearch->SearchValue);
            $this->_34->PlaceHolder = RemoveHtml($this->_34->caption());

            // 35
            $this->_35->setupEditAttributes();
            if (!$this->_35->Raw) {
                $this->_35->AdvancedSearch->SearchValue = HtmlDecode($this->_35->AdvancedSearch->SearchValue);
            }
            $this->_35->EditValue = HtmlEncode($this->_35->AdvancedSearch->SearchValue);
            $this->_35->PlaceHolder = RemoveHtml($this->_35->caption());

            // 36
            $this->_36->setupEditAttributes();
            if (!$this->_36->Raw) {
                $this->_36->AdvancedSearch->SearchValue = HtmlDecode($this->_36->AdvancedSearch->SearchValue);
            }
            $this->_36->EditValue = HtmlEncode($this->_36->AdvancedSearch->SearchValue);
            $this->_36->PlaceHolder = RemoveHtml($this->_36->caption());

            // 37
            $this->_37->setupEditAttributes();
            if (!$this->_37->Raw) {
                $this->_37->AdvancedSearch->SearchValue = HtmlDecode($this->_37->AdvancedSearch->SearchValue);
            }
            $this->_37->EditValue = HtmlEncode($this->_37->AdvancedSearch->SearchValue);
            $this->_37->PlaceHolder = RemoveHtml($this->_37->caption());

            // 38
            $this->_38->setupEditAttributes();
            if (!$this->_38->Raw) {
                $this->_38->AdvancedSearch->SearchValue = HtmlDecode($this->_38->AdvancedSearch->SearchValue);
            }
            $this->_38->EditValue = HtmlEncode($this->_38->AdvancedSearch->SearchValue);
            $this->_38->PlaceHolder = RemoveHtml($this->_38->caption());

            // 39
            $this->_39->setupEditAttributes();
            if (!$this->_39->Raw) {
                $this->_39->AdvancedSearch->SearchValue = HtmlDecode($this->_39->AdvancedSearch->SearchValue);
            }
            $this->_39->EditValue = HtmlEncode($this->_39->AdvancedSearch->SearchValue);
            $this->_39->PlaceHolder = RemoveHtml($this->_39->caption());

            // 40
            $this->_40->setupEditAttributes();
            if (!$this->_40->Raw) {
                $this->_40->AdvancedSearch->SearchValue = HtmlDecode($this->_40->AdvancedSearch->SearchValue);
            }
            $this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

            // 41
            $this->_41->setupEditAttributes();
            if (!$this->_41->Raw) {
                $this->_41->AdvancedSearch->SearchValue = HtmlDecode($this->_41->AdvancedSearch->SearchValue);
            }
            $this->_41->EditValue = HtmlEncode($this->_41->AdvancedSearch->SearchValue);
            $this->_41->PlaceHolder = RemoveHtml($this->_41->caption());

            // 42
            $this->_42->setupEditAttributes();
            if (!$this->_42->Raw) {
                $this->_42->AdvancedSearch->SearchValue = HtmlDecode($this->_42->AdvancedSearch->SearchValue);
            }
            $this->_42->EditValue = HtmlEncode($this->_42->AdvancedSearch->SearchValue);
            $this->_42->PlaceHolder = RemoveHtml($this->_42->caption());

            // 43
            $this->_43->setupEditAttributes();
            if (!$this->_43->Raw) {
                $this->_43->AdvancedSearch->SearchValue = HtmlDecode($this->_43->AdvancedSearch->SearchValue);
            }
            $this->_43->EditValue = HtmlEncode($this->_43->AdvancedSearch->SearchValue);
            $this->_43->PlaceHolder = RemoveHtml($this->_43->caption());

            // 44
            $this->_44->setupEditAttributes();
            if (!$this->_44->Raw) {
                $this->_44->AdvancedSearch->SearchValue = HtmlDecode($this->_44->AdvancedSearch->SearchValue);
            }
            $this->_44->EditValue = HtmlEncode($this->_44->AdvancedSearch->SearchValue);
            $this->_44->PlaceHolder = RemoveHtml($this->_44->caption());

            // 45
            $this->_45->setupEditAttributes();
            if (!$this->_45->Raw) {
                $this->_45->AdvancedSearch->SearchValue = HtmlDecode($this->_45->AdvancedSearch->SearchValue);
            }
            $this->_45->EditValue = HtmlEncode($this->_45->AdvancedSearch->SearchValue);
            $this->_45->PlaceHolder = RemoveHtml($this->_45->caption());

            // 46
            $this->_46->setupEditAttributes();
            if (!$this->_46->Raw) {
                $this->_46->AdvancedSearch->SearchValue = HtmlDecode($this->_46->AdvancedSearch->SearchValue);
            }
            $this->_46->EditValue = HtmlEncode($this->_46->AdvancedSearch->SearchValue);
            $this->_46->PlaceHolder = RemoveHtml($this->_46->caption());

            // 47
            $this->_47->setupEditAttributes();
            if (!$this->_47->Raw) {
                $this->_47->AdvancedSearch->SearchValue = HtmlDecode($this->_47->AdvancedSearch->SearchValue);
            }
            $this->_47->EditValue = HtmlEncode($this->_47->AdvancedSearch->SearchValue);
            $this->_47->PlaceHolder = RemoveHtml($this->_47->caption());

            // 48
            $this->_48->setupEditAttributes();
            if (!$this->_48->Raw) {
                $this->_48->AdvancedSearch->SearchValue = HtmlDecode($this->_48->AdvancedSearch->SearchValue);
            }
            $this->_48->EditValue = HtmlEncode($this->_48->AdvancedSearch->SearchValue);
            $this->_48->PlaceHolder = RemoveHtml($this->_48->caption());

            // 49
            $this->_49->setupEditAttributes();
            if (!$this->_49->Raw) {
                $this->_49->AdvancedSearch->SearchValue = HtmlDecode($this->_49->AdvancedSearch->SearchValue);
            }
            $this->_49->EditValue = HtmlEncode($this->_49->AdvancedSearch->SearchValue);
            $this->_49->PlaceHolder = RemoveHtml($this->_49->caption());

            // 50
            $this->_50->setupEditAttributes();
            if (!$this->_50->Raw) {
                $this->_50->AdvancedSearch->SearchValue = HtmlDecode($this->_50->AdvancedSearch->SearchValue);
            }
            $this->_50->EditValue = HtmlEncode($this->_50->AdvancedSearch->SearchValue);
            $this->_50->PlaceHolder = RemoveHtml($this->_50->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->pid->AdvancedSearch->SearchValue)) {
            $this->pid->addErrorMessage($this->pid->getErrorMessage(false));
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue)) {
            $this->_barcode->addErrorMessage($this->_barcode->getErrorMessage(false));
        }
        if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue2)) {
            $this->_barcode->addErrorMessage($this->_barcode->getErrorMessage(false));
        }
        if (!CheckDate($this->order_date->AdvancedSearch->SearchValue, $this->order_date->formatPattern())) {
            $this->order_date->addErrorMessage($this->order_date->getErrorMessage(false));
        }
        if (!CheckDate($this->despatch_date->AdvancedSearch->SearchValue, $this->despatch_date->formatPattern())) {
            $this->despatch_date->addErrorMessage($this->despatch_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->quantity->AdvancedSearch->SearchValue)) {
            $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
            $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm_u->AdvancedSearch->SearchValue)) {
            $this->sqm_u->addErrorMessage($this->sqm_u->getErrorMessage(false));
        }
        if (!CheckNumber($this->c_sqm->AdvancedSearch->SearchValue)) {
            $this->c_sqm->addErrorMessage($this->c_sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->q_sku->AdvancedSearch->SearchValue)) {
            $this->q_sku->addErrorMessage($this->q_sku->getErrorMessage(false));
        }
        if (!CheckNumber($this->po_discount->AdvancedSearch->SearchValue)) {
            $this->po_discount->addErrorMessage($this->po_discount->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->jc_no->AdvancedSearch->SearchValue)) {
            $this->jc_no->addErrorMessage($this->jc_no->getErrorMessage(false));
        }
        if (!CheckInteger($this->roll_no->AdvancedSearch->SearchValue)) {
            $this->roll_no->addErrorMessage($this->roll_no->getErrorMessage(false));
        }
        if (!CheckInteger($this->qty->AdvancedSearch->SearchValue)) {
            $this->qty->addErrorMessage($this->qty->getErrorMessage(false));
        }
        if (!CheckNumber($this->pl_no->AdvancedSearch->SearchValue)) {
            $this->pl_no->addErrorMessage($this->pl_no->getErrorMessage(false));
        }
        if (!CheckInteger($this->pp_id->AdvancedSearch->SearchValue)) {
            $this->pp_id->addErrorMessage($this->pp_id->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->pid->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
        $this->design_id->AdvancedSearch->load();
        $this->size_cm->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->process_d->AdvancedSearch->load();
        $this->buyer_ref->AdvancedSearch->load();
        $this->order_date->AdvancedSearch->load();
        $this->despatch_date->AdvancedSearch->load();
        $this->despatch_week->AdvancedSearch->load();
        $this->dispatch_week_p->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->buyers_id->AdvancedSearch->load();
        $this->buyer_uid->AdvancedSearch->load();
        $this->buyer_loc->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->sqm_u->AdvancedSearch->load();
        $this->c_sqm->AdvancedSearch->load();
        $this->weaving_works->AdvancedSearch->load();
        $this->current_works->AdvancedSearch->load();
        $this->size_buyer->AdvancedSearch->load();
        $this->q_sku->AdvancedSearch->load();
        $this->po_price->AdvancedSearch->load();
        $this->po_discount->AdvancedSearch->load();
        $this->po_currency->AdvancedSearch->load();
        $this->product_type->AdvancedSearch->load();
        $this->shape->AdvancedSearch->load();
        $this->payment_plan->AdvancedSearch->load();
        $this->production_plan->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->completed->AdvancedSearch->load();
        $this->buyer_po->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->jc_no->AdvancedSearch->load();
        $this->batch_no->AdvancedSearch->load();
        $this->cs->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->p_remarks->AdvancedSearch->load();
        $this->roll_no->AdvancedSearch->load();
        $this->qty->AdvancedSearch->load();
        $this->pl_no->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->pp_id->AdvancedSearch->load();
        $this->_11->AdvancedSearch->load();
        $this->_12->AdvancedSearch->load();
        $this->_13->AdvancedSearch->load();
        $this->_14->AdvancedSearch->load();
        $this->_15->AdvancedSearch->load();
        $this->_16->AdvancedSearch->load();
        $this->_17->AdvancedSearch->load();
        $this->_18->AdvancedSearch->load();
        $this->_19->AdvancedSearch->load();
        $this->_20->AdvancedSearch->load();
        $this->_21->AdvancedSearch->load();
        $this->_22->AdvancedSearch->load();
        $this->_23->AdvancedSearch->load();
        $this->_24->AdvancedSearch->load();
        $this->_25->AdvancedSearch->load();
        $this->_26->AdvancedSearch->load();
        $this->_27->AdvancedSearch->load();
        $this->_28->AdvancedSearch->load();
        $this->_29->AdvancedSearch->load();
        $this->_30->AdvancedSearch->load();
        $this->_31->AdvancedSearch->load();
        $this->_32->AdvancedSearch->load();
        $this->_33->AdvancedSearch->load();
        $this->_34->AdvancedSearch->load();
        $this->_35->AdvancedSearch->load();
        $this->_36->AdvancedSearch->load();
        $this->_37->AdvancedSearch->load();
        $this->_38->AdvancedSearch->load();
        $this->_39->AdvancedSearch->load();
        $this->_40->AdvancedSearch->load();
        $this->_41->AdvancedSearch->load();
        $this->_42->AdvancedSearch->load();
        $this->_43->AdvancedSearch->load();
        $this->_44->AdvancedSearch->load();
        $this->_45->AdvancedSearch->load();
        $this->_46->AdvancedSearch->load();
        $this->_47->AdvancedSearch->load();
        $this->_48->AdvancedSearch->load();
        $this->_49->AdvancedSearch->load();
        $this->_50->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bcodelist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_design_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_d":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_ref":
                    break;
                case "x_despatch_week":
                    break;
                case "x_dispatch_week_p":
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyers_id":
                    break;
                case "x_weaving_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_current_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_design":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_po_currency":
                    break;
                case "x_product_type":
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_payment_plan":
                    break;
                case "x_production_plan":
                    break;
                case "x_completed":
                    break;
                case "x_operator":
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cs":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_c":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pp_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    		PageFieldValidate($this,'bcode');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
