<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BcodeSEdit extends BcodeS
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BcodeSEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "bcodesedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->po->setVisibility();
        $this->_barcode->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->pid->Visible = false;
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->weaving_works->setVisibility();
        $this->current_works->setVisibility();
        $this->buyers_id->setVisibility();
        $this->buyer_ref->setVisibility();
        $this->buyer_tid->Visible = false;
        $this->design->Visible = false;
        $this->design_id->setVisibility();
        $this->batch_no->setVisibility();
        $this->l_cm->Visible = false;
        $this->w_cm->Visible = false;
        $this->sqm->setVisibility();
        $this->sqm_a->Visible = false;
        $this->_2srm->Visible = false;
        $this->_2srm_a->Visible = false;
        $this->_4srm->Visible = false;
        $this->_4srm_a->Visible = false;
        $this->shape->setVisibility();
        $this->product_type->setVisibility();
        $this->size_cm->setVisibility();
        $this->size_buyer->setVisibility();
        $this->buyer_uid->setVisibility();
        $this->quantity->setVisibility();
        $this->po_price->setVisibility();
        $this->despatch_week->setVisibility();
        $this->despatch_date->setVisibility();
        $this->payment_plan->Visible = false;
        $this->production_plan->setVisibility();
        $this->status->setVisibility();
        $this->completed->setVisibility();
        $this->buyer_po->setVisibility();
        $this->jc_no->Visible = false;
        $this->pp_id->setVisibility();
        $this->in_id->setVisibility();
        $this->out_id->setVisibility();
        $this->remarks->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'bcode_s';
        $this->TableName = 'bcode_s';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (bcode_s)
        if (!isset($GLOBALS["bcode_s"]) || $GLOBALS["bcode_s"]::class == PROJECT_NAMESPACE . "bcode_s") {
            $GLOBALS["bcode_s"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'bcode_s');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "bcodesview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->_barcode->Required = false;
        $this->sqm->Required = false;
        $this->shape->Required = false;
        $this->product_type->Required = false;
        $this->size_cm->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->weaving_works);
        $this->setupLookupOptions($this->current_works);
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->buyer_ref);
        $this->setupLookupOptions($this->design);
        $this->setupLookupOptions($this->design_id);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->payment_plan);
        $this->setupLookupOptions($this->production_plan);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->completed);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("bcodeslist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "bcodeslist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "bcodeslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "bcodeslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'po' first before field var 'x_po'
        $val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
        if (!$this->po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po->Visible = false; // Disable update for API request
            } else {
                $this->po->setFormValue($val);
            }
        }

        // Check field name 'barcode' first before field var 'x__barcode'
        $val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
        if (!$this->_barcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_barcode->Visible = false; // Disable update for API request
            } else {
                $this->_barcode->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'weaving_works' first before field var 'x_weaving_works'
        $val = $CurrentForm->hasValue("weaving_works") ? $CurrentForm->getValue("weaving_works") : $CurrentForm->getValue("x_weaving_works");
        if (!$this->weaving_works->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weaving_works->Visible = false; // Disable update for API request
            } else {
                $this->weaving_works->setFormValue($val);
            }
        }

        // Check field name 'current_works' first before field var 'x_current_works'
        $val = $CurrentForm->hasValue("current_works") ? $CurrentForm->getValue("current_works") : $CurrentForm->getValue("x_current_works");
        if (!$this->current_works->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->current_works->Visible = false; // Disable update for API request
            } else {
                $this->current_works->setFormValue($val);
            }
        }

        // Check field name 'buyers_id' first before field var 'x_buyers_id'
        $val = $CurrentForm->hasValue("buyers_id") ? $CurrentForm->getValue("buyers_id") : $CurrentForm->getValue("x_buyers_id");
        if (!$this->buyers_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyers_id->Visible = false; // Disable update for API request
            } else {
                $this->buyers_id->setFormValue($val);
            }
        }

        // Check field name 'buyer_ref' first before field var 'x_buyer_ref'
        $val = $CurrentForm->hasValue("buyer_ref") ? $CurrentForm->getValue("buyer_ref") : $CurrentForm->getValue("x_buyer_ref");
        if (!$this->buyer_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_ref->Visible = false; // Disable update for API request
            } else {
                $this->buyer_ref->setFormValue($val);
            }
        }

        // Check field name 'design_id' first before field var 'x_design_id'
        $val = $CurrentForm->hasValue("design_id") ? $CurrentForm->getValue("design_id") : $CurrentForm->getValue("x_design_id");
        if (!$this->design_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->design_id->Visible = false; // Disable update for API request
            } else {
                $this->design_id->setFormValue($val);
            }
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'sqm' first before field var 'x_sqm'
        $val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
        if (!$this->sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm->Visible = false; // Disable update for API request
            } else {
                $this->sqm->setFormValue($val);
            }
        }

        // Check field name 'shape' first before field var 'x_shape'
        $val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
        if (!$this->shape->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shape->Visible = false; // Disable update for API request
            } else {
                $this->shape->setFormValue($val);
            }
        }

        // Check field name 'product_type' first before field var 'x_product_type'
        $val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
        if (!$this->product_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_type->Visible = false; // Disable update for API request
            } else {
                $this->product_type->setFormValue($val);
            }
        }

        // Check field name 'size_cm' first before field var 'x_size_cm'
        $val = $CurrentForm->hasValue("size_cm") ? $CurrentForm->getValue("size_cm") : $CurrentForm->getValue("x_size_cm");
        if (!$this->size_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_cm->Visible = false; // Disable update for API request
            } else {
                $this->size_cm->setFormValue($val);
            }
        }

        // Check field name 'size_buyer' first before field var 'x_size_buyer'
        $val = $CurrentForm->hasValue("size_buyer") ? $CurrentForm->getValue("size_buyer") : $CurrentForm->getValue("x_size_buyer");
        if (!$this->size_buyer->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_buyer->Visible = false; // Disable update for API request
            } else {
                $this->size_buyer->setFormValue($val);
            }
        }

        // Check field name 'buyer_uid' first before field var 'x_buyer_uid'
        $val = $CurrentForm->hasValue("buyer_uid") ? $CurrentForm->getValue("buyer_uid") : $CurrentForm->getValue("x_buyer_uid");
        if (!$this->buyer_uid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_uid->Visible = false; // Disable update for API request
            } else {
                $this->buyer_uid->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val);
            }
        }

        // Check field name 'po_price' first before field var 'x_po_price'
        $val = $CurrentForm->hasValue("po_price") ? $CurrentForm->getValue("po_price") : $CurrentForm->getValue("x_po_price");
        if (!$this->po_price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_price->Visible = false; // Disable update for API request
            } else {
                $this->po_price->setFormValue($val);
            }
        }

        // Check field name 'despatch_week' first before field var 'x_despatch_week'
        $val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
        if (!$this->despatch_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_week->Visible = false; // Disable update for API request
            } else {
                $this->despatch_week->setFormValue($val);
            }
        }

        // Check field name 'despatch_date' first before field var 'x_despatch_date'
        $val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
        if (!$this->despatch_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_date->Visible = false; // Disable update for API request
            } else {
                $this->despatch_date->setFormValue($val, true, $validate);
            }
            $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        }

        // Check field name 'production_plan' first before field var 'x_production_plan'
        $val = $CurrentForm->hasValue("production_plan") ? $CurrentForm->getValue("production_plan") : $CurrentForm->getValue("x_production_plan");
        if (!$this->production_plan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->production_plan->Visible = false; // Disable update for API request
            } else {
                $this->production_plan->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'completed' first before field var 'x_completed'
        $val = $CurrentForm->hasValue("completed") ? $CurrentForm->getValue("completed") : $CurrentForm->getValue("x_completed");
        if (!$this->completed->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->completed->Visible = false; // Disable update for API request
            } else {
                $this->completed->setFormValue($val);
            }
        }

        // Check field name 'buyer_po' first before field var 'x_buyer_po'
        $val = $CurrentForm->hasValue("buyer_po") ? $CurrentForm->getValue("buyer_po") : $CurrentForm->getValue("x_buyer_po");
        if (!$this->buyer_po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_po->Visible = false; // Disable update for API request
            } else {
                $this->buyer_po->setFormValue($val);
            }
        }

        // Check field name 'pp_id' first before field var 'x_pp_id'
        $val = $CurrentForm->hasValue("pp_id") ? $CurrentForm->getValue("pp_id") : $CurrentForm->getValue("x_pp_id");
        if (!$this->pp_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pp_id->Visible = false; // Disable update for API request
            } else {
                $this->pp_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'in_id' first before field var 'x_in_id'
        $val = $CurrentForm->hasValue("in_id") ? $CurrentForm->getValue("in_id") : $CurrentForm->getValue("x_in_id");
        if (!$this->in_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->in_id->Visible = false; // Disable update for API request
            } else {
                $this->in_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'out_id' first before field var 'x_out_id'
        $val = $CurrentForm->hasValue("out_id") ? $CurrentForm->getValue("out_id") : $CurrentForm->getValue("x_out_id");
        if (!$this->out_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->out_id->Visible = false; // Disable update for API request
            } else {
                $this->out_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->po->CurrentValue = $this->po->FormValue;
        $this->_barcode->CurrentValue = $this->_barcode->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->weaving_works->CurrentValue = $this->weaving_works->FormValue;
        $this->current_works->CurrentValue = $this->current_works->FormValue;
        $this->buyers_id->CurrentValue = $this->buyers_id->FormValue;
        $this->buyer_ref->CurrentValue = $this->buyer_ref->FormValue;
        $this->design_id->CurrentValue = $this->design_id->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->sqm->CurrentValue = $this->sqm->FormValue;
        $this->shape->CurrentValue = $this->shape->FormValue;
        $this->product_type->CurrentValue = $this->product_type->FormValue;
        $this->size_cm->CurrentValue = $this->size_cm->FormValue;
        $this->size_buyer->CurrentValue = $this->size_buyer->FormValue;
        $this->buyer_uid->CurrentValue = $this->buyer_uid->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->po_price->CurrentValue = $this->po_price->FormValue;
        $this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
        $this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
        $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        $this->production_plan->CurrentValue = $this->production_plan->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->completed->CurrentValue = $this->completed->FormValue;
        $this->buyer_po->CurrentValue = $this->buyer_po->FormValue;
        $this->pp_id->CurrentValue = $this->pp_id->FormValue;
        $this->in_id->CurrentValue = $this->in_id->FormValue;
        $this->out_id->CurrentValue = $this->out_id->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->po->setDbValue($row['po']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->pid->setDbValue($row['pid']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->current_works->setDbValue($row['current_works']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        $this->buyer_tid->setDbValue($row['buyer_tid']);
        $this->design->setDbValue($row['design']);
        $this->design_id->setDbValue($row['design_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->_2srm->setDbValue($row['2srm']);
        $this->_2srm_a->setDbValue($row['2srm_a']);
        $this->_4srm->setDbValue($row['4srm']);
        $this->_4srm_a->setDbValue($row['4srm_a']);
        $this->shape->setDbValue($row['shape']);
        $this->product_type->setDbValue($row['product_type']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->size_buyer->setDbValue($row['size_buyer']);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->quantity->setDbValue($row['quantity']);
        $this->po_price->setDbValue($row['po_price']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->payment_plan->setDbValue($row['payment_plan']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->status->setDbValue($row['status']);
        $this->completed->setDbValue($row['completed']);
        $this->buyer_po->setDbValue($row['buyer_po']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->pp_id->setDbValue($row['pp_id']);
        $this->in_id->setDbValue($row['in_id']);
        $this->out_id->setDbValue($row['out_id']);
        $this->remarks->setDbValue($row['remarks']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['pid'] = $this->pid->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['weaving_works'] = $this->weaving_works->DefaultValue;
        $row['current_works'] = $this->current_works->DefaultValue;
        $row['buyers_id'] = $this->buyers_id->DefaultValue;
        $row['buyer_ref'] = $this->buyer_ref->DefaultValue;
        $row['buyer_tid'] = $this->buyer_tid->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['design_id'] = $this->design_id->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['sqm_a'] = $this->sqm_a->DefaultValue;
        $row['2srm'] = $this->_2srm->DefaultValue;
        $row['2srm_a'] = $this->_2srm_a->DefaultValue;
        $row['4srm'] = $this->_4srm->DefaultValue;
        $row['4srm_a'] = $this->_4srm_a->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['size_cm'] = $this->size_cm->DefaultValue;
        $row['size_buyer'] = $this->size_buyer->DefaultValue;
        $row['buyer_uid'] = $this->buyer_uid->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['po_price'] = $this->po_price->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['payment_plan'] = $this->payment_plan->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['completed'] = $this->completed->DefaultValue;
        $row['buyer_po'] = $this->buyer_po->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['pp_id'] = $this->pp_id->DefaultValue;
        $row['in_id'] = $this->in_id->DefaultValue;
        $row['out_id'] = $this->out_id->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // pid
        $this->pid->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // weaving_works
        $this->weaving_works->RowCssClass = "row";

        // current_works
        $this->current_works->RowCssClass = "row";

        // buyers_id
        $this->buyers_id->RowCssClass = "row";

        // buyer_ref
        $this->buyer_ref->RowCssClass = "row";

        // buyer_tid
        $this->buyer_tid->RowCssClass = "row";

        // design
        $this->design->RowCssClass = "row";

        // design_id
        $this->design_id->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // l_cm
        $this->l_cm->RowCssClass = "row";

        // w_cm
        $this->w_cm->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // sqm_a
        $this->sqm_a->RowCssClass = "row";

        // 2srm
        $this->_2srm->RowCssClass = "row";

        // 2srm_a
        $this->_2srm_a->RowCssClass = "row";

        // 4srm
        $this->_4srm->RowCssClass = "row";

        // 4srm_a
        $this->_4srm_a->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // size_cm
        $this->size_cm->RowCssClass = "row";

        // size_buyer
        $this->size_buyer->RowCssClass = "row";

        // buyer_uid
        $this->buyer_uid->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // po_price
        $this->po_price->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // payment_plan
        $this->payment_plan->RowCssClass = "row";

        // production_plan
        $this->production_plan->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // completed
        $this->completed->RowCssClass = "row";

        // buyer_po
        $this->buyer_po->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // pp_id
        $this->pp_id->RowCssClass = "row";

        // in_id
        $this->in_id->RowCssClass = "row";

        // out_id
        $this->out_id->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
            $this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, $this->_barcode->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // pid
            $this->pid->ViewValue = $this->pid->CurrentValue;
            $this->pid->ViewValue = FormatNumber($this->pid->ViewValue, $this->pid->formatPattern());

            // weaving_works
            $curVal = strval($this->weaving_works->CurrentValue);
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
                if ($this->weaving_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                        $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                    } else {
                        $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                    }
                }
            } else {
                $this->weaving_works->ViewValue = null;
            }

            // current_works
            $curVal = strval($this->current_works->CurrentValue);
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
                if ($this->current_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                        $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                    } else {
                        $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                    }
                }
            } else {
                $this->current_works->ViewValue = null;
            }

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // buyer_ref
            $curVal = strval($this->buyer_ref->CurrentValue);
            if ($curVal != "") {
                $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
                if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                    } else {
                        $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                    }
                }
            } else {
                $this->buyer_ref->ViewValue = null;
            }

            // buyer_tid
            $this->buyer_tid->ViewValue = $this->buyer_tid->CurrentValue;

            // design_id
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->ViewValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->ViewValue = null;
            }

            // batch_no
            $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
            $this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, $this->batch_no->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->ViewValue = FormatNumber($this->shape->CurrentValue, $this->shape->formatPattern());
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // product_type
            $this->product_type->ViewValue = $this->product_type->CurrentValue;
            $this->product_type->ViewValue = FormatNumber($this->product_type->ViewValue, $this->product_type->formatPattern());

            // size_cm
            $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

            // size_buyer
            $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

            // buyer_uid
            $this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // po_price
            $this->po_price->ViewValue = $this->po_price->CurrentValue;

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // payment_plan
            $curVal = strval($this->payment_plan->CurrentValue);
            if ($curVal != "") {
                $this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
                if ($this->payment_plan->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->payment_plan->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_plan->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
                    } else {
                        $this->payment_plan->ViewValue = FormatNumber($this->payment_plan->CurrentValue, $this->payment_plan->formatPattern());
                    }
                }
            } else {
                $this->payment_plan->ViewValue = null;
            }

            // production_plan
            if (strval($this->production_plan->CurrentValue) != "") {
                $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
            } else {
                $this->production_plan->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // completed
            if (strval($this->completed->CurrentValue) != "") {
                $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
            } else {
                $this->completed->ViewValue = null;
            }

            // buyer_po
            $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // pp_id
            $this->pp_id->ViewValue = $this->pp_id->CurrentValue;
            $this->pp_id->ViewValue = FormatNumber($this->pp_id->ViewValue, $this->pp_id->formatPattern());

            // in_id
            $this->in_id->ViewValue = $this->in_id->CurrentValue;
            $this->in_id->ViewValue = FormatNumber($this->in_id->ViewValue, $this->in_id->formatPattern());

            // out_id
            $this->out_id->ViewValue = $this->out_id->CurrentValue;
            $this->out_id->ViewValue = FormatNumber($this->out_id->ViewValue, $this->out_id->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // id
            $this->id->HrefValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";

            // current_works
            $this->current_works->HrefValue = "";

            // buyers_id
            if (!EmptyValue($this->buyers_id->CurrentValue)) {
                $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
                $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
                }
            } else {
                $this->buyers_id->HrefValue = "";
            }
            $this->buyers_id->TooltipValue = "";

            // buyer_ref
            if (!EmptyValue($this->buyer_ref->CurrentValue)) {
                $this->buyer_ref->HrefValue = $this->buyer_ref->getLinkPrefix() . $this->buyer_ref->CurrentValue; // Add prefix/suffix
                $this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
                }
            } else {
                $this->buyer_ref->HrefValue = "";
            }
            $this->buyer_ref->TooltipValue = "";

            // design_id
            if (!EmptyValue($this->design_id->CurrentValue)) {
                $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . $this->design_id->CurrentValue; // Add prefix/suffix
                $this->design_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
                }
            } else {
                $this->design_id->HrefValue = "";
            }
            $this->design_id->TooltipValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // size_cm
            $this->size_cm->HrefValue = "";
            $this->size_cm->TooltipValue = "";

            // size_buyer
            $this->size_buyer->HrefValue = "";
            $this->size_buyer->TooltipValue = "";

            // buyer_uid
            $this->buyer_uid->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // po_price
            $this->po_price->HrefValue = "";
            $this->po_price->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // completed
            $this->completed->HrefValue = "";

            // buyer_po
            $this->buyer_po->HrefValue = "";

            // pp_id
            $this->pp_id->HrefValue = "";

            // in_id
            $this->in_id->HrefValue = "";

            // out_id
            $this->out_id->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->CurrentValue;
            $this->po->EditValue = FormatNumber($this->po->EditValue, $this->po->formatPattern());

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue = $this->_barcode->CurrentValue;
            $this->_barcode->EditValue = FormatNumber($this->_barcode->EditValue, $this->_barcode->formatPattern());

            // operator

            // datetime

            // weaving_works
            $this->weaving_works->setupEditAttributes();
            $curVal = trim(strval($this->weaving_works->CurrentValue));
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
            } else {
                $this->weaving_works->ViewValue = $this->weaving_works->Lookup !== null && is_array($this->weaving_works->lookupOptions()) && count($this->weaving_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->weaving_works->ViewValue !== null) { // Load from cache
                $this->weaving_works->EditValue = array_values($this->weaving_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->weaving_works->CurrentValue, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->weaving_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->weaving_works->EditValue = $arwrk;
            }
            $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

            // current_works
            $this->current_works->setupEditAttributes();
            $curVal = trim(strval($this->current_works->CurrentValue));
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
            } else {
                $this->current_works->ViewValue = $this->current_works->Lookup !== null && is_array($this->current_works->lookupOptions()) && count($this->current_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->current_works->ViewValue !== null) { // Load from cache
                $this->current_works->EditValue = array_values($this->current_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->current_works->CurrentValue, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->current_works->EditValue = $arwrk;
            }
            $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

            // buyers_id
            $this->buyers_id->setupEditAttributes();
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->EditValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->EditValue = null;
            }

            // buyer_ref
            $this->buyer_ref->setupEditAttributes();
            $curVal = strval($this->buyer_ref->CurrentValue);
            if ($curVal != "") {
                $this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
                if ($this->buyer_ref->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
                    } else {
                        $this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
                    }
                }
            } else {
                $this->buyer_ref->EditValue = null;
            }

            // design_id
            $this->design_id->setupEditAttributes();
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->EditValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->EditValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->EditValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->EditValue = null;
            }

            // batch_no
            $this->batch_no->setupEditAttributes();
            $this->batch_no->EditValue = $this->batch_no->CurrentValue;
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());
            if (strval($this->batch_no->EditValue) != "" && is_numeric($this->batch_no->EditValue)) {
                $this->batch_no->EditValue = FormatNumber($this->batch_no->EditValue, null);
            }

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->CurrentValue;
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, $this->sqm->formatPattern());

            // shape
            $this->shape->setupEditAttributes();
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->EditValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->EditValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->EditValue = FormatNumber($this->shape->CurrentValue, $this->shape->formatPattern());
                    }
                }
            } else {
                $this->shape->EditValue = null;
            }

            // product_type
            $this->product_type->setupEditAttributes();
            $this->product_type->EditValue = $this->product_type->CurrentValue;
            $this->product_type->EditValue = FormatNumber($this->product_type->EditValue, $this->product_type->formatPattern());

            // size_cm
            $this->size_cm->setupEditAttributes();
            $this->size_cm->EditValue = $this->size_cm->CurrentValue;

            // size_buyer
            $this->size_buyer->setupEditAttributes();
            $this->size_buyer->EditValue = $this->size_buyer->CurrentValue;

            // buyer_uid
            $this->buyer_uid->setupEditAttributes();
            if (!$this->buyer_uid->Raw) {
                $this->buyer_uid->CurrentValue = HtmlDecode($this->buyer_uid->CurrentValue);
            }
            $this->buyer_uid->EditValue = HtmlEncode($this->buyer_uid->CurrentValue);
            $this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, $this->quantity->formatPattern());

            // po_price
            $this->po_price->setupEditAttributes();
            $this->po_price->EditValue = $this->po_price->CurrentValue;

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->CurrentValue));
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->ViewValue = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->ViewValue !== null) { // Load from cache
                $this->despatch_week->EditValue = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->CurrentValue, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // despatch_date
            $this->despatch_date->setupEditAttributes();
            $this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern()));
            $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

            // production_plan
            $this->production_plan->setupEditAttributes();
            $this->production_plan->EditValue = $this->production_plan->options(true);
            $this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // completed
            $this->completed->setupEditAttributes();
            $this->completed->EditValue = $this->completed->options(true);
            $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

            // buyer_po
            $this->buyer_po->setupEditAttributes();
            if (!$this->buyer_po->Raw) {
                $this->buyer_po->CurrentValue = HtmlDecode($this->buyer_po->CurrentValue);
            }
            $this->buyer_po->EditValue = HtmlEncode($this->buyer_po->CurrentValue);
            $this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

            // pp_id
            $this->pp_id->setupEditAttributes();
            $this->pp_id->EditValue = $this->pp_id->CurrentValue;
            $this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());
            if (strval($this->pp_id->EditValue) != "" && is_numeric($this->pp_id->EditValue)) {
                $this->pp_id->EditValue = FormatNumber($this->pp_id->EditValue, null);
            }

            // in_id
            $this->in_id->setupEditAttributes();
            $this->in_id->EditValue = $this->in_id->CurrentValue;
            $this->in_id->PlaceHolder = RemoveHtml($this->in_id->caption());
            if (strval($this->in_id->EditValue) != "" && is_numeric($this->in_id->EditValue)) {
                $this->in_id->EditValue = FormatNumber($this->in_id->EditValue, null);
            }

            // out_id
            $this->out_id->setupEditAttributes();
            $this->out_id->EditValue = $this->out_id->CurrentValue;
            $this->out_id->PlaceHolder = RemoveHtml($this->out_id->caption());
            if (strval($this->out_id->EditValue) != "" && is_numeric($this->out_id->EditValue)) {
                $this->out_id->EditValue = FormatNumber($this->out_id->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";

            // current_works
            $this->current_works->HrefValue = "";

            // buyers_id
            if (!EmptyValue($this->buyers_id->CurrentValue)) {
                $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
                $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
                }
            } else {
                $this->buyers_id->HrefValue = "";
            }
            $this->buyers_id->TooltipValue = "";

            // buyer_ref
            if (!EmptyValue($this->buyer_ref->CurrentValue)) {
                $this->buyer_ref->HrefValue = $this->buyer_ref->getLinkPrefix() . $this->buyer_ref->CurrentValue; // Add prefix/suffix
                $this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
                }
            } else {
                $this->buyer_ref->HrefValue = "";
            }
            $this->buyer_ref->TooltipValue = "";

            // design_id
            if (!EmptyValue($this->design_id->CurrentValue)) {
                $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . $this->design_id->CurrentValue; // Add prefix/suffix
                $this->design_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
                }
            } else {
                $this->design_id->HrefValue = "";
            }
            $this->design_id->TooltipValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // size_cm
            $this->size_cm->HrefValue = "";
            $this->size_cm->TooltipValue = "";

            // size_buyer
            $this->size_buyer->HrefValue = "";
            $this->size_buyer->TooltipValue = "";

            // buyer_uid
            $this->buyer_uid->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // po_price
            $this->po_price->HrefValue = "";
            $this->po_price->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // completed
            $this->completed->HrefValue = "";

            // buyer_po
            $this->buyer_po->HrefValue = "";

            // pp_id
            $this->pp_id->HrefValue = "";

            // in_id
            $this->in_id->HrefValue = "";

            // out_id
            $this->out_id->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->po->Visible && $this->po->Required) {
                if (!$this->po->IsDetailKey && EmptyValue($this->po->FormValue)) {
                    $this->po->addErrorMessage(str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
                }
            }
            if ($this->_barcode->Visible && $this->_barcode->Required) {
                if (!$this->_barcode->IsDetailKey && EmptyValue($this->_barcode->FormValue)) {
                    $this->_barcode->addErrorMessage(str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->weaving_works->Visible && $this->weaving_works->Required) {
                if (!$this->weaving_works->IsDetailKey && EmptyValue($this->weaving_works->FormValue)) {
                    $this->weaving_works->addErrorMessage(str_replace("%s", $this->weaving_works->caption(), $this->weaving_works->RequiredErrorMessage));
                }
            }
            if ($this->current_works->Visible && $this->current_works->Required) {
                if (!$this->current_works->IsDetailKey && EmptyValue($this->current_works->FormValue)) {
                    $this->current_works->addErrorMessage(str_replace("%s", $this->current_works->caption(), $this->current_works->RequiredErrorMessage));
                }
            }
            if ($this->buyers_id->Visible && $this->buyers_id->Required) {
                if (!$this->buyers_id->IsDetailKey && EmptyValue($this->buyers_id->FormValue)) {
                    $this->buyers_id->addErrorMessage(str_replace("%s", $this->buyers_id->caption(), $this->buyers_id->RequiredErrorMessage));
                }
            }
            if ($this->buyer_ref->Visible && $this->buyer_ref->Required) {
                if (!$this->buyer_ref->IsDetailKey && EmptyValue($this->buyer_ref->FormValue)) {
                    $this->buyer_ref->addErrorMessage(str_replace("%s", $this->buyer_ref->caption(), $this->buyer_ref->RequiredErrorMessage));
                }
            }
            if ($this->design_id->Visible && $this->design_id->Required) {
                if (!$this->design_id->IsDetailKey && EmptyValue($this->design_id->FormValue)) {
                    $this->design_id->addErrorMessage(str_replace("%s", $this->design_id->caption(), $this->design_id->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->batch_no->FormValue)) {
                $this->batch_no->addErrorMessage($this->batch_no->getErrorMessage(false));
            }
            if ($this->sqm->Visible && $this->sqm->Required) {
                if (!$this->sqm->IsDetailKey && EmptyValue($this->sqm->FormValue)) {
                    $this->sqm->addErrorMessage(str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
                }
            }
            if ($this->shape->Visible && $this->shape->Required) {
                if (!$this->shape->IsDetailKey && EmptyValue($this->shape->FormValue)) {
                    $this->shape->addErrorMessage(str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
                }
            }
            if ($this->product_type->Visible && $this->product_type->Required) {
                if (!$this->product_type->IsDetailKey && EmptyValue($this->product_type->FormValue)) {
                    $this->product_type->addErrorMessage(str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
                }
            }
            if ($this->size_cm->Visible && $this->size_cm->Required) {
                if (!$this->size_cm->IsDetailKey && EmptyValue($this->size_cm->FormValue)) {
                    $this->size_cm->addErrorMessage(str_replace("%s", $this->size_cm->caption(), $this->size_cm->RequiredErrorMessage));
                }
            }
            if ($this->size_buyer->Visible && $this->size_buyer->Required) {
                if (!$this->size_buyer->IsDetailKey && EmptyValue($this->size_buyer->FormValue)) {
                    $this->size_buyer->addErrorMessage(str_replace("%s", $this->size_buyer->caption(), $this->size_buyer->RequiredErrorMessage));
                }
            }
            if ($this->buyer_uid->Visible && $this->buyer_uid->Required) {
                if (!$this->buyer_uid->IsDetailKey && EmptyValue($this->buyer_uid->FormValue)) {
                    $this->buyer_uid->addErrorMessage(str_replace("%s", $this->buyer_uid->caption(), $this->buyer_uid->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if ($this->po_price->Visible && $this->po_price->Required) {
                if (!$this->po_price->IsDetailKey && EmptyValue($this->po_price->FormValue)) {
                    $this->po_price->addErrorMessage(str_replace("%s", $this->po_price->caption(), $this->po_price->RequiredErrorMessage));
                }
            }
            if ($this->despatch_week->Visible && $this->despatch_week->Required) {
                if (!$this->despatch_week->IsDetailKey && EmptyValue($this->despatch_week->FormValue)) {
                    $this->despatch_week->addErrorMessage(str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
                }
            }
            if ($this->despatch_date->Visible && $this->despatch_date->Required) {
                if (!$this->despatch_date->IsDetailKey && EmptyValue($this->despatch_date->FormValue)) {
                    $this->despatch_date->addErrorMessage(str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->despatch_date->FormValue, $this->despatch_date->formatPattern())) {
                $this->despatch_date->addErrorMessage($this->despatch_date->getErrorMessage(false));
            }
            if ($this->production_plan->Visible && $this->production_plan->Required) {
                if (!$this->production_plan->IsDetailKey && EmptyValue($this->production_plan->FormValue)) {
                    $this->production_plan->addErrorMessage(str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->completed->Visible && $this->completed->Required) {
                if (!$this->completed->IsDetailKey && EmptyValue($this->completed->FormValue)) {
                    $this->completed->addErrorMessage(str_replace("%s", $this->completed->caption(), $this->completed->RequiredErrorMessage));
                }
            }
            if ($this->buyer_po->Visible && $this->buyer_po->Required) {
                if (!$this->buyer_po->IsDetailKey && EmptyValue($this->buyer_po->FormValue)) {
                    $this->buyer_po->addErrorMessage(str_replace("%s", $this->buyer_po->caption(), $this->buyer_po->RequiredErrorMessage));
                }
            }
            if ($this->pp_id->Visible && $this->pp_id->Required) {
                if (!$this->pp_id->IsDetailKey && EmptyValue($this->pp_id->FormValue)) {
                    $this->pp_id->addErrorMessage(str_replace("%s", $this->pp_id->caption(), $this->pp_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->pp_id->FormValue)) {
                $this->pp_id->addErrorMessage($this->pp_id->getErrorMessage(false));
            }
            if ($this->in_id->Visible && $this->in_id->Required) {
                if (!$this->in_id->IsDetailKey && EmptyValue($this->in_id->FormValue)) {
                    $this->in_id->addErrorMessage(str_replace("%s", $this->in_id->caption(), $this->in_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->in_id->FormValue)) {
                $this->in_id->addErrorMessage($this->in_id->getErrorMessage(false));
            }
            if ($this->out_id->Visible && $this->out_id->Required) {
                if (!$this->out_id->IsDetailKey && EmptyValue($this->out_id->FormValue)) {
                    $this->out_id->addErrorMessage(str_replace("%s", $this->out_id->caption(), $this->out_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->out_id->FormValue)) {
                $this->out_id->addErrorMessage($this->out_id->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (barcode)
        if ($this->_barcode->CurrentValue != "") {
            $filterChk = "(`barcode` = " . AdjustSql($this->_barcode->CurrentValue, $this->Dbid) . ")";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->_barcode->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->_barcode->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // weaving_works
        $this->weaving_works->setDbValueDef($rsnew, $this->weaving_works->CurrentValue, $this->weaving_works->ReadOnly);

        // current_works
        $this->current_works->setDbValueDef($rsnew, $this->current_works->CurrentValue, $this->current_works->ReadOnly);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, $this->batch_no->ReadOnly);

        // buyer_uid
        $this->buyer_uid->setDbValueDef($rsnew, $this->buyer_uid->CurrentValue, $this->buyer_uid->ReadOnly);

        // despatch_week
        $this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, $this->despatch_week->ReadOnly);

        // despatch_date
        $this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern()), $this->despatch_date->ReadOnly);

        // production_plan
        $this->production_plan->setDbValueDef($rsnew, $this->production_plan->CurrentValue, $this->production_plan->ReadOnly);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly);

        // completed
        $this->completed->setDbValueDef($rsnew, $this->completed->CurrentValue, $this->completed->ReadOnly);

        // buyer_po
        $this->buyer_po->setDbValueDef($rsnew, $this->buyer_po->CurrentValue, $this->buyer_po->ReadOnly);

        // pp_id
        $this->pp_id->setDbValueDef($rsnew, $this->pp_id->CurrentValue, $this->pp_id->ReadOnly);

        // in_id
        $this->in_id->setDbValueDef($rsnew, $this->in_id->CurrentValue, $this->in_id->ReadOnly);

        // out_id
        $this->out_id->setDbValueDef($rsnew, $this->out_id->CurrentValue, $this->out_id->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['weaving_works'])) { // weaving_works
            $this->weaving_works->CurrentValue = $row['weaving_works'];
        }
        if (isset($row['current_works'])) { // current_works
            $this->current_works->CurrentValue = $row['current_works'];
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->CurrentValue = $row['batch_no'];
        }
        if (isset($row['buyer_uid'])) { // buyer_uid
            $this->buyer_uid->CurrentValue = $row['buyer_uid'];
        }
        if (isset($row['despatch_week'])) { // despatch_week
            $this->despatch_week->CurrentValue = $row['despatch_week'];
        }
        if (isset($row['despatch_date'])) { // despatch_date
            $this->despatch_date->CurrentValue = $row['despatch_date'];
        }
        if (isset($row['production_plan'])) { // production_plan
            $this->production_plan->CurrentValue = $row['production_plan'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['completed'])) { // completed
            $this->completed->CurrentValue = $row['completed'];
        }
        if (isset($row['buyer_po'])) { // buyer_po
            $this->buyer_po->CurrentValue = $row['buyer_po'];
        }
        if (isset($row['pp_id'])) { // pp_id
            $this->pp_id->CurrentValue = $row['pp_id'];
        }
        if (isset($row['in_id'])) { // in_id
            $this->in_id->CurrentValue = $row['in_id'];
        }
        if (isset($row['out_id'])) { // out_id
            $this->out_id->CurrentValue = $row['out_id'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bcodeslist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_operator":
                    break;
                case "x_weaving_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_current_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyers_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_ref":
                    break;
                case "x_design":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_design_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    break;
                case "x_despatch_week":
                    break;
                case "x_payment_plan":
                    break;
                case "x_production_plan":
                    break;
                case "x_status":
                    break;
                case "x_completed":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
