<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BcodeOldView extends BcodeOld
{
    use MessagesTrait;

    // Page ID
    public $PageID = "view";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BcodeOldView";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "bcodeoldview";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->pid->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->weaving_works->setVisibility();
        $this->current_works->setVisibility();
        $this->po->setVisibility();
        $this->_barcode->setVisibility();
        $this->buyers_id->setVisibility();
        $this->pp_id->setVisibility();
        $this->buyer_ref->setVisibility();
        $this->buyer_tid->setVisibility();
        $this->design->setVisibility();
        $this->design_id->setVisibility();
        $this->batch_no->setVisibility();
        $this->l_cm->setVisibility();
        $this->w_cm->setVisibility();
        $this->sqm->setVisibility();
        $this->sqm_a->setVisibility();
        $this->_2srm->setVisibility();
        $this->_2srm_a->setVisibility();
        $this->_4srm->setVisibility();
        $this->_4srm_a->setVisibility();
        $this->shape->setVisibility();
        $this->cs->setVisibility();
        $this->product_type->setVisibility();
        $this->size_cm->setVisibility();
        $this->size_buyer->setVisibility();
        $this->buyer_uid->setVisibility();
        $this->buyer_loc->setVisibility();
        $this->quantity->setVisibility();
        $this->po_price->setVisibility();
        $this->despatch_week->setVisibility();
        $this->despatch_date->setVisibility();
        $this->payment_plan->setVisibility();
        $this->production_plan->setVisibility();
        $this->status->setVisibility();
        $this->completed->setVisibility();
        $this->buyer_po->setVisibility();
        $this->jc_no->setVisibility();
        $this->process->setVisibility();
        $this->process_c->setVisibility();
        $this->process_d->setVisibility();
        $this->weight->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->po_currency->setVisibility();
        $this->dispatch_week_p->setVisibility();
        $this->remarks->setVisibility();
        $this->pl_no->setVisibility();
        $this->category->setVisibility();
        $this->roll_no->setVisibility();
        $this->qty->setVisibility();
        $this->consignee->setVisibility();
        $this->buyer_barcode->setVisibility();
        $this->design_next->setVisibility();
        $this->q_sku->setVisibility();
        $this->sqm_u->setVisibility();
        $this->po_discount->setVisibility();
        $this->loom_plan->setVisibility();
        $this->_11->setVisibility();
        $this->_12->setVisibility();
        $this->_13->setVisibility();
        $this->_14->setVisibility();
        $this->_15->setVisibility();
        $this->_16->setVisibility();
        $this->_17->setVisibility();
        $this->_18->setVisibility();
        $this->_19->setVisibility();
        $this->_20->setVisibility();
        $this->_21->setVisibility();
        $this->_22->setVisibility();
        $this->_23->setVisibility();
        $this->_24->setVisibility();
        $this->_25->setVisibility();
        $this->_26->setVisibility();
        $this->_27->setVisibility();
        $this->_28->setVisibility();
        $this->_29->setVisibility();
        $this->_30->setVisibility();
        $this->_31->setVisibility();
        $this->_32->setVisibility();
        $this->_33->setVisibility();
        $this->_34->setVisibility();
        $this->_35->setVisibility();
        $this->_36->setVisibility();
        $this->_37->setVisibility();
        $this->_38->setVisibility();
        $this->_39->setVisibility();
        $this->_40->setVisibility();
        $this->_41->setVisibility();
        $this->_42->setVisibility();
        $this->_43->setVisibility();
        $this->_44->setVisibility();
        $this->_45->setVisibility();
        $this->_46->setVisibility();
        $this->_47->setVisibility();
        $this->_48->setVisibility();
        $this->_49->setVisibility();
        $this->_50->setVisibility();
        $this->c_sqm->setVisibility();
        $this->packing_type->setVisibility();
        $this->order_date->setVisibility();
        $this->qc_weaving->setVisibility();
        $this->p_remarks->setVisibility();
        $this->roll_no_qty_tmp->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'bcode_old';
        $this->TableName = 'bcode_old';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (bcode_old)
        if (!isset($GLOBALS["bcode_old"]) || $GLOBALS["bcode_old"]::class == PROJECT_NAMESPACE . "bcode_old") {
            $GLOBALS["bcode_old"] = &$this;
        }

        // Set up record key
        if (($keyValue = Get("id") ?? Route("id")) !== null) {
            $this->RecKey["id"] = $keyValue;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'bcode_old');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "bcodeoldview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $ExportOptions; // Export options
    public $OtherOptions; // Other options
    public $DisplayRecords = 1;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecKey = [];
    public $IsModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->weaving_works);
        $this->setupLookupOptions($this->current_works);
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->pp_id);
        $this->setupLookupOptions($this->buyer_ref);
        $this->setupLookupOptions($this->design);
        $this->setupLookupOptions($this->design_id);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->cs);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->payment_plan);
        $this->setupLookupOptions($this->production_plan);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->completed);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->process_c);
        $this->setupLookupOptions($this->process_d);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->po_currency);
        $this->setupLookupOptions($this->dispatch_week_p);
        $this->setupLookupOptions($this->category);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }

        // Load current record
        $loadCurrentRecord = false;
        $returnUrl = "";
        $matchRecord = false;
        if (($keyValue = Get("id") ?? Route("id")) !== null) {
            $this->id->setQueryStringValue($keyValue);
            $this->RecKey["id"] = $this->id->QueryStringValue;
        } elseif (Post("id") !== null) {
            $this->id->setFormValue(Post("id"));
            $this->RecKey["id"] = $this->id->FormValue;
        } elseif (IsApi() && ($keyValue = Key(0) ?? Route(2)) !== null) {
            $this->id->setQueryStringValue($keyValue);
            $this->RecKey["id"] = $this->id->QueryStringValue;
        } elseif (!$loadCurrentRecord) {
            $returnUrl = "bcodeoldlist"; // Return to list
        }

        // Get action
        $this->CurrentAction = "show"; // Display
        switch ($this->CurrentAction) {
            case "show": // Get a record to display

                    // Load record based on key
                    if (IsApi()) {
                        $filter = $this->getRecordFilter();
                        $this->CurrentFilter = $filter;
                        $sql = $this->getCurrentSql();
                        $conn = $this->getConnection();
                        $res = ($this->Recordset = ExecuteQuery($sql, $conn));
                    } else {
                        $res = $this->loadRow();
                    }
                    if (!$res) { // Load record based on key
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $returnUrl = "bcodeoldlist"; // No matching record, return to list
                    }
                break;
        }
        if ($returnUrl != "") {
            $this->terminate($returnUrl);
            return;
        }

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Render row
        $this->RowType = RowType::VIEW;
        $this->resetAttributes();
        $this->renderRow();

        // Normal return
        if (IsApi()) {
            if (!$this->isExport()) {
                $row = $this->getRecordsFromRecordset($this->Recordset, true); // Get current record only
                $this->Recordset?->free();
                WriteJson(["success" => true, "action" => Config("API_VIEW_ACTION"), $this->TableVar => $row]);
                $this->terminate(true);
            }
            return;
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Disable Add/Edit/Copy/Delete for Modal and UseAjaxActions
        /*
        if ($this->IsModal && $this->UseAjaxActions) {
            $this->AddUrl = "";
            $this->EditUrl = "";
            $this->CopyUrl = "";
            $this->DeleteUrl = "";
        }
        */
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Set up action default
        $option = $options["action"];
        $option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
        $option->UseDropDownButton = !IsJsonResponse() && false;
        $option->UseButtonGroup = true;
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->pid->setDbValue($row['pid']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->current_works->setDbValue($row['current_works']);
        $this->po->setDbValue($row['po']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->pp_id->setDbValue($row['pp_id']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        if (array_key_exists('EV__buyer_ref', $row)) {
            $this->buyer_ref->VirtualValue = $row['EV__buyer_ref']; // Set up virtual field value
        } else {
            $this->buyer_ref->VirtualValue = ""; // Clear value
        }
        $this->buyer_tid->setDbValue($row['buyer_tid']);
        $this->design->setDbValue($row['design']);
        $this->design_id->setDbValue($row['design_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->_2srm->setDbValue($row['2srm']);
        $this->_2srm_a->setDbValue($row['2srm_a']);
        $this->_4srm->setDbValue($row['4srm']);
        $this->_4srm_a->setDbValue($row['4srm_a']);
        $this->shape->setDbValue($row['shape']);
        $this->cs->setDbValue($row['cs']);
        $this->product_type->setDbValue($row['product_type']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->size_buyer->setDbValue($row['size_buyer']);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->quantity->setDbValue($row['quantity']);
        $this->po_price->setDbValue($row['po_price']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->payment_plan->setDbValue($row['payment_plan']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->status->setDbValue($row['status']);
        $this->completed->setDbValue($row['completed']);
        $this->buyer_po->setDbValue($row['buyer_po']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->process->setDbValue($row['process']);
        $this->process_c->setDbValue($row['process_c']);
        $this->process_d->setDbValue($row['process_d']);
        $this->weight->setDbValue($row['weight']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->po_currency->setDbValue($row['po_currency']);
        $this->dispatch_week_p->setDbValue($row['dispatch_week_p']);
        $this->remarks->setDbValue($row['remarks']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->category->setDbValue($row['category']);
        $this->roll_no->setDbValue($row['roll_no']);
        $this->qty->setDbValue($row['qty']);
        $this->consignee->setDbValue($row['consignee']);
        $this->buyer_barcode->setDbValue($row['buyer_barcode']);
        $this->design_next->setDbValue($row['design_next']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->sqm_u->setDbValue($row['sqm_u']);
        $this->po_discount->setDbValue($row['po_discount']);
        $this->loom_plan->setDbValue($row['loom_plan']);
        $this->_11->setDbValue($row['11']);
        $this->_12->setDbValue($row['12']);
        $this->_13->setDbValue($row['13']);
        $this->_14->setDbValue($row['14']);
        $this->_15->setDbValue($row['15']);
        $this->_16->setDbValue($row['16']);
        $this->_17->setDbValue($row['17']);
        $this->_18->setDbValue($row['18']);
        $this->_19->setDbValue($row['19']);
        $this->_20->setDbValue($row['20']);
        $this->_21->setDbValue($row['21']);
        $this->_22->setDbValue($row['22']);
        $this->_23->setDbValue($row['23']);
        $this->_24->setDbValue($row['24']);
        $this->_25->setDbValue($row['25']);
        $this->_26->setDbValue($row['26']);
        $this->_27->setDbValue($row['27']);
        $this->_28->setDbValue($row['28']);
        $this->_29->setDbValue($row['29']);
        $this->_30->setDbValue($row['30']);
        $this->_31->setDbValue($row['31']);
        $this->_32->setDbValue($row['32']);
        $this->_33->setDbValue($row['33']);
        $this->_34->setDbValue($row['34']);
        $this->_35->setDbValue($row['35']);
        $this->_36->setDbValue($row['36']);
        $this->_37->setDbValue($row['37']);
        $this->_38->setDbValue($row['38']);
        $this->_39->setDbValue($row['39']);
        $this->_40->setDbValue($row['40']);
        $this->_41->setDbValue($row['41']);
        $this->_42->setDbValue($row['42']);
        $this->_43->setDbValue($row['43']);
        $this->_44->setDbValue($row['44']);
        $this->_45->setDbValue($row['45']);
        $this->_46->setDbValue($row['46']);
        $this->_47->setDbValue($row['47']);
        $this->_48->setDbValue($row['48']);
        $this->_49->setDbValue($row['49']);
        $this->_50->setDbValue($row['50']);
        $this->c_sqm->setDbValue($row['c_sqm']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->order_date->setDbValue($row['order_date']);
        $this->qc_weaving->setDbValue($row['qc_weaving']);
        $this->p_remarks->setDbValue($row['p_remarks']);
        $this->roll_no_qty_tmp->setDbValue($row['roll_no_qty_tmp']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['pid'] = $this->pid->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['weaving_works'] = $this->weaving_works->DefaultValue;
        $row['current_works'] = $this->current_works->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['buyers_id'] = $this->buyers_id->DefaultValue;
        $row['pp_id'] = $this->pp_id->DefaultValue;
        $row['buyer_ref'] = $this->buyer_ref->DefaultValue;
        $row['buyer_tid'] = $this->buyer_tid->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['design_id'] = $this->design_id->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['sqm_a'] = $this->sqm_a->DefaultValue;
        $row['2srm'] = $this->_2srm->DefaultValue;
        $row['2srm_a'] = $this->_2srm_a->DefaultValue;
        $row['4srm'] = $this->_4srm->DefaultValue;
        $row['4srm_a'] = $this->_4srm_a->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['cs'] = $this->cs->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['size_cm'] = $this->size_cm->DefaultValue;
        $row['size_buyer'] = $this->size_buyer->DefaultValue;
        $row['buyer_uid'] = $this->buyer_uid->DefaultValue;
        $row['buyer_loc'] = $this->buyer_loc->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['po_price'] = $this->po_price->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['payment_plan'] = $this->payment_plan->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['completed'] = $this->completed->DefaultValue;
        $row['buyer_po'] = $this->buyer_po->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['process_c'] = $this->process_c->DefaultValue;
        $row['process_d'] = $this->process_d->DefaultValue;
        $row['weight'] = $this->weight->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['po_currency'] = $this->po_currency->DefaultValue;
        $row['dispatch_week_p'] = $this->dispatch_week_p->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['pl_no'] = $this->pl_no->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['roll_no'] = $this->roll_no->DefaultValue;
        $row['qty'] = $this->qty->DefaultValue;
        $row['consignee'] = $this->consignee->DefaultValue;
        $row['buyer_barcode'] = $this->buyer_barcode->DefaultValue;
        $row['design_next'] = $this->design_next->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['sqm_u'] = $this->sqm_u->DefaultValue;
        $row['po_discount'] = $this->po_discount->DefaultValue;
        $row['loom_plan'] = $this->loom_plan->DefaultValue;
        $row['11'] = $this->_11->DefaultValue;
        $row['12'] = $this->_12->DefaultValue;
        $row['13'] = $this->_13->DefaultValue;
        $row['14'] = $this->_14->DefaultValue;
        $row['15'] = $this->_15->DefaultValue;
        $row['16'] = $this->_16->DefaultValue;
        $row['17'] = $this->_17->DefaultValue;
        $row['18'] = $this->_18->DefaultValue;
        $row['19'] = $this->_19->DefaultValue;
        $row['20'] = $this->_20->DefaultValue;
        $row['21'] = $this->_21->DefaultValue;
        $row['22'] = $this->_22->DefaultValue;
        $row['23'] = $this->_23->DefaultValue;
        $row['24'] = $this->_24->DefaultValue;
        $row['25'] = $this->_25->DefaultValue;
        $row['26'] = $this->_26->DefaultValue;
        $row['27'] = $this->_27->DefaultValue;
        $row['28'] = $this->_28->DefaultValue;
        $row['29'] = $this->_29->DefaultValue;
        $row['30'] = $this->_30->DefaultValue;
        $row['31'] = $this->_31->DefaultValue;
        $row['32'] = $this->_32->DefaultValue;
        $row['33'] = $this->_33->DefaultValue;
        $row['34'] = $this->_34->DefaultValue;
        $row['35'] = $this->_35->DefaultValue;
        $row['36'] = $this->_36->DefaultValue;
        $row['37'] = $this->_37->DefaultValue;
        $row['38'] = $this->_38->DefaultValue;
        $row['39'] = $this->_39->DefaultValue;
        $row['40'] = $this->_40->DefaultValue;
        $row['41'] = $this->_41->DefaultValue;
        $row['42'] = $this->_42->DefaultValue;
        $row['43'] = $this->_43->DefaultValue;
        $row['44'] = $this->_44->DefaultValue;
        $row['45'] = $this->_45->DefaultValue;
        $row['46'] = $this->_46->DefaultValue;
        $row['47'] = $this->_47->DefaultValue;
        $row['48'] = $this->_48->DefaultValue;
        $row['49'] = $this->_49->DefaultValue;
        $row['50'] = $this->_50->DefaultValue;
        $row['c_sqm'] = $this->c_sqm->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['order_date'] = $this->order_date->DefaultValue;
        $row['qc_weaving'] = $this->qc_weaving->DefaultValue;
        $row['p_remarks'] = $this->p_remarks->DefaultValue;
        $row['roll_no_qty_tmp'] = $this->roll_no_qty_tmp->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->AddUrl = $this->getAddUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();
        $this->ListUrl = $this->getListUrl();
        $this->setupOtherOptions();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // pid

        // grp

        // s_grp

        // weaving_works

        // current_works

        // po

        // barcode

        // buyers_id

        // pp_id

        // buyer_ref

        // buyer_tid

        // design

        // design_id

        // batch_no

        // l_cm

        // w_cm

        // sqm

        // sqm_a

        // 2srm

        // 2srm_a

        // 4srm

        // 4srm_a

        // shape

        // cs

        // product_type

        // size_cm

        // size_buyer

        // buyer_uid

        // buyer_loc

        // quantity

        // po_price

        // despatch_week

        // despatch_date

        // payment_plan

        // production_plan

        // status

        // completed

        // buyer_po

        // jc_no

        // process

        // process_c

        // process_d

        // weight

        // operator

        // datetime

        // po_currency

        // dispatch_week_p

        // remarks

        // pl_no

        // category

        // roll_no

        // qty

        // consignee

        // buyer_barcode

        // design_next

        // q_sku

        // sqm_u

        // po_discount

        // loom_plan

        // 11

        // 12

        // 13

        // 14

        // 15

        // 16

        // 17

        // 18

        // 19

        // 20

        // 21

        // 22

        // 23

        // 24

        // 25

        // 26

        // 27

        // 28

        // 29

        // 30

        // 31

        // 32

        // 33

        // 34

        // 35

        // 36

        // 37

        // 38

        // 39

        // 40

        // 41

        // 42

        // 43

        // 44

        // 45

        // 46

        // 47

        // 48

        // 49

        // 50

        // c_sqm

        // packing_type

        // order_date

        // qc_weaving

        // p_remarks

        // roll_no_qty_tmp

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // pid
            $this->pid->ViewValue = $this->pid->CurrentValue;
            $this->pid->ViewValue = FormatNumber($this->pid->ViewValue, $this->pid->formatPattern());

            // grp
            $this->grp->ViewValue = $this->grp->CurrentValue;
            $this->grp->ViewValue = FormatNumber($this->grp->ViewValue, $this->grp->formatPattern());

            // s_grp
            $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
            $this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, $this->s_grp->formatPattern());

            // weaving_works
            $curVal = strval($this->weaving_works->CurrentValue);
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
                if ($this->weaving_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                        $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                    } else {
                        $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                    }
                }
            } else {
                $this->weaving_works->ViewValue = null;
            }

            // current_works
            $curVal = strval($this->current_works->CurrentValue);
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
                if ($this->current_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                        $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                    } else {
                        $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                    }
                }
            } else {
                $this->current_works->ViewValue = null;
            }

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // pp_id
            $this->pp_id->ViewValue = $this->pp_id->CurrentValue;
            $curVal = strval($this->pp_id->CurrentValue);
            if ($curVal != "") {
                $this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
                if ($this->pp_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pp_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pp_id->Lookup->renderViewRow($rswrk[0]);
                        $this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
                    } else {
                        $this->pp_id->ViewValue = FormatNumber($this->pp_id->CurrentValue, $this->pp_id->formatPattern());
                    }
                }
            } else {
                $this->pp_id->ViewValue = null;
            }

            // buyer_ref
            if ($this->buyer_ref->VirtualValue != "") {
                $this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
            } else {
                $curVal = strval($this->buyer_ref->CurrentValue);
                if ($curVal != "") {
                    $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
                    if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                            $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                        } else {
                            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                        }
                    }
                } else {
                    $this->buyer_ref->ViewValue = null;
                }
            }

            // buyer_tid
            $this->buyer_tid->ViewValue = $this->buyer_tid->CurrentValue;

            // design_id
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->ViewValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->ViewValue = null;
            }

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // sqm_a
            $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
            $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

            // 2srm
            $this->_2srm->ViewValue = $this->_2srm->CurrentValue;
            $this->_2srm->ViewValue = FormatNumber($this->_2srm->ViewValue, $this->_2srm->formatPattern());

            // 2srm_a
            $this->_2srm_a->ViewValue = $this->_2srm_a->CurrentValue;
            $this->_2srm_a->ViewValue = FormatNumber($this->_2srm_a->ViewValue, $this->_2srm_a->formatPattern());

            // 4srm
            $this->_4srm->ViewValue = $this->_4srm->CurrentValue;
            $this->_4srm->ViewValue = FormatNumber($this->_4srm->ViewValue, $this->_4srm->formatPattern());

            // 4srm_a
            $this->_4srm_a->ViewValue = $this->_4srm_a->CurrentValue;
            $this->_4srm_a->ViewValue = FormatNumber($this->_4srm_a->ViewValue, $this->_4srm_a->formatPattern());

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->ViewValue = FormatNumber($this->shape->CurrentValue, $this->shape->formatPattern());
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // cs
            if (strval($this->cs->CurrentValue) != "") {
                $this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
            } else {
                $this->cs->ViewValue = null;
            }

            // product_type
            if (strval($this->product_type->CurrentValue) != "") {
                $this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
            } else {
                $this->product_type->ViewValue = null;
            }

            // size_cm
            $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

            // size_buyer
            $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

            // buyer_uid
            $this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;

            // buyer_loc
            $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // po_price
            $this->po_price->ViewValue = $this->po_price->CurrentValue;

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // payment_plan
            $curVal = strval($this->payment_plan->CurrentValue);
            if ($curVal != "") {
                $this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
                if ($this->payment_plan->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->payment_plan->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_plan->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
                    } else {
                        $this->payment_plan->ViewValue = FormatNumber($this->payment_plan->CurrentValue, $this->payment_plan->formatPattern());
                    }
                }
            } else {
                $this->payment_plan->ViewValue = null;
            }

            // production_plan
            if (strval($this->production_plan->CurrentValue) != "") {
                $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
            } else {
                $this->production_plan->ViewValue = null;
            }

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // completed
            if (strval($this->completed->CurrentValue) != "") {
                $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
            } else {
                $this->completed->ViewValue = null;
            }

            // buyer_po
            $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process->Lookup->renderViewRow($row);
                            $this->process->ViewValue->add($this->process->displayValue($arwrk));
                        }
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // process_c
            $curVal = strval($this->process_c->CurrentValue);
            if ($curVal != "") {
                $this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
                if ($this->process_c->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_c->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_c->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process_c->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_c->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_c->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_c->Lookup->renderViewRow($row);
                            $this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
                        }
                    } else {
                        $this->process_c->ViewValue = $this->process_c->CurrentValue;
                    }
                }
            } else {
                $this->process_c->ViewValue = null;
            }

            // process_d
            $curVal = strval($this->process_d->CurrentValue);
            if ($curVal != "") {
                $this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
                if ($this->process_d->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_d->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_d->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process_d->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_d->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_d->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_d->Lookup->renderViewRow($row);
                            $this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
                        }
                    } else {
                        $this->process_d->ViewValue = $this->process_d->CurrentValue;
                    }
                }
            } else {
                $this->process_d->ViewValue = null;
            }

            // weight
            $this->weight->ViewValue = $this->weight->CurrentValue;
            $this->weight->ViewValue = FormatNumber($this->weight->ViewValue, $this->weight->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // po_currency
            $curVal = strval($this->po_currency->CurrentValue);
            if ($curVal != "") {
                $this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
                if ($this->po_currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_currency->Lookup->renderViewRow($rswrk[0]);
                        $this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
                    } else {
                        $this->po_currency->ViewValue = FormatNumber($this->po_currency->CurrentValue, $this->po_currency->formatPattern());
                    }
                }
            } else {
                $this->po_currency->ViewValue = null;
            }

            // dispatch_week_p
            $curVal = strval($this->dispatch_week_p->CurrentValue);
            if ($curVal != "") {
                $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
                if ($this->dispatch_week_p->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->dispatch_week_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->dispatch_week_p->Lookup->renderViewRow($rswrk[0]);
                        $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
                    } else {
                        $this->dispatch_week_p->ViewValue = FormatNumber($this->dispatch_week_p->CurrentValue, $this->dispatch_week_p->formatPattern());
                    }
                }
            } else {
                $this->dispatch_week_p->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // pl_no
            $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
            $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;
            $this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, $this->roll_no->formatPattern());

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;
            $this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, $this->q_sku->formatPattern());

            // sqm_u
            $this->sqm_u->ViewValue = $this->sqm_u->CurrentValue;
            $this->sqm_u->ViewValue = FormatNumber($this->sqm_u->ViewValue, $this->sqm_u->formatPattern());

            // po_discount
            $this->po_discount->ViewValue = $this->po_discount->CurrentValue;
            $this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, $this->po_discount->formatPattern());

            // 11
            $this->_11->ViewValue = $this->_11->CurrentValue;

            // 12
            $this->_12->ViewValue = $this->_12->CurrentValue;

            // 13
            $this->_13->ViewValue = $this->_13->CurrentValue;

            // 14
            $this->_14->ViewValue = $this->_14->CurrentValue;

            // 15
            $this->_15->ViewValue = $this->_15->CurrentValue;

            // 16
            $this->_16->ViewValue = $this->_16->CurrentValue;

            // 17
            $this->_17->ViewValue = $this->_17->CurrentValue;

            // 18
            $this->_18->ViewValue = $this->_18->CurrentValue;

            // 19
            $this->_19->ViewValue = $this->_19->CurrentValue;

            // 20
            $this->_20->ViewValue = $this->_20->CurrentValue;

            // 21
            $this->_21->ViewValue = $this->_21->CurrentValue;

            // 22
            $this->_22->ViewValue = $this->_22->CurrentValue;

            // 23
            $this->_23->ViewValue = $this->_23->CurrentValue;

            // 24
            $this->_24->ViewValue = $this->_24->CurrentValue;

            // 25
            $this->_25->ViewValue = $this->_25->CurrentValue;

            // 26
            $this->_26->ViewValue = $this->_26->CurrentValue;

            // 27
            $this->_27->ViewValue = $this->_27->CurrentValue;

            // 28
            $this->_28->ViewValue = $this->_28->CurrentValue;

            // 29
            $this->_29->ViewValue = $this->_29->CurrentValue;

            // 30
            $this->_30->ViewValue = $this->_30->CurrentValue;

            // 31
            $this->_31->ViewValue = $this->_31->CurrentValue;

            // 32
            $this->_32->ViewValue = $this->_32->CurrentValue;

            // 33
            $this->_33->ViewValue = $this->_33->CurrentValue;

            // 34
            $this->_34->ViewValue = $this->_34->CurrentValue;

            // 35
            $this->_35->ViewValue = $this->_35->CurrentValue;

            // 36
            $this->_36->ViewValue = $this->_36->CurrentValue;

            // 37
            $this->_37->ViewValue = $this->_37->CurrentValue;

            // 38
            $this->_38->ViewValue = $this->_38->CurrentValue;

            // 39
            $this->_39->ViewValue = $this->_39->CurrentValue;

            // 40
            $this->_40->ViewValue = $this->_40->CurrentValue;

            // 41
            $this->_41->ViewValue = $this->_41->CurrentValue;

            // 42
            $this->_42->ViewValue = $this->_42->CurrentValue;

            // 43
            $this->_43->ViewValue = $this->_43->CurrentValue;

            // 44
            $this->_44->ViewValue = $this->_44->CurrentValue;

            // 45
            $this->_45->ViewValue = $this->_45->CurrentValue;

            // 46
            $this->_46->ViewValue = $this->_46->CurrentValue;

            // 47
            $this->_47->ViewValue = $this->_47->CurrentValue;

            // 48
            $this->_48->ViewValue = $this->_48->CurrentValue;

            // 49
            $this->_49->ViewValue = $this->_49->CurrentValue;

            // 50
            $this->_50->ViewValue = $this->_50->CurrentValue;

            // c_sqm
            $this->c_sqm->ViewValue = $this->c_sqm->CurrentValue;
            $this->c_sqm->ViewValue = FormatNumber($this->c_sqm->ViewValue, $this->c_sqm->formatPattern());

            // order_date
            $this->order_date->ViewValue = $this->order_date->CurrentValue;
            $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

            // p_remarks
            $this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // pid
            $this->pid->HrefValue = "";
            $this->pid->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // buyers_id
            if (!EmptyValue($this->buyers_id->CurrentValue)) {
                $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
                $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
                }
            } else {
                $this->buyers_id->HrefValue = "";
            }
            $this->buyers_id->TooltipValue = "";

            // pp_id
            $this->pp_id->HrefValue = "";
            $this->pp_id->TooltipValue = "";

            // buyer_ref
            if (!EmptyValue($this->buyer_ref->CurrentValue)) {
                $this->buyer_ref->HrefValue = $this->buyer_ref->getLinkPrefix() . $this->buyer_ref->CurrentValue; // Add prefix/suffix
                $this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
                }
            } else {
                $this->buyer_ref->HrefValue = "";
            }
            $this->buyer_ref->TooltipValue = "";

            // buyer_tid
            $this->buyer_tid->HrefValue = "";
            $this->buyer_tid->TooltipValue = "";

            // design_id
            if (!EmptyValue($this->design_id->CurrentValue)) {
                $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . (!empty($this->design_id->ViewValue) && !is_array($this->design_id->ViewValue) ? RemoveHtml($this->design_id->ViewValue) : $this->design_id->CurrentValue); // Add prefix/suffix
                $this->design_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
                }
            } else {
                $this->design_id->HrefValue = "";
            }
            $this->design_id->TooltipValue = "";

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }
            $this->batch_no->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // sqm_a
            $this->sqm_a->HrefValue = "";
            $this->sqm_a->TooltipValue = "";

            // 2srm
            $this->_2srm->HrefValue = "";
            $this->_2srm->TooltipValue = "";

            // 2srm_a
            $this->_2srm_a->HrefValue = "";
            $this->_2srm_a->TooltipValue = "";

            // 4srm
            $this->_4srm->HrefValue = "";
            $this->_4srm->TooltipValue = "";

            // 4srm_a
            $this->_4srm_a->HrefValue = "";
            $this->_4srm_a->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";

            // cs
            $this->cs->HrefValue = "";
            $this->cs->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // size_cm
            $this->size_cm->HrefValue = "";
            $this->size_cm->TooltipValue = "";

            // buyer_uid
            $this->buyer_uid->HrefValue = "";
            $this->buyer_uid->TooltipValue = "";

            // buyer_loc
            $this->buyer_loc->HrefValue = "";
            $this->buyer_loc->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // po_price
            $this->po_price->HrefValue = "";
            $this->po_price->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";

            // payment_plan
            $this->payment_plan->HrefValue = "";
            $this->payment_plan->TooltipValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";
            $this->production_plan->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // completed
            $this->completed->HrefValue = "";
            $this->completed->TooltipValue = "";

            // buyer_po
            $this->buyer_po->HrefValue = "";
            $this->buyer_po->TooltipValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";

            // process
            $this->process->HrefValue = "";
            $this->process->TooltipValue = "";

            // process_c
            $this->process_c->HrefValue = "";
            $this->process_c->TooltipValue = "";

            // process_d
            $this->process_d->HrefValue = "";
            $this->process_d->TooltipValue = "";

            // weight
            $this->weight->HrefValue = "";
            $this->weight->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // po_currency
            $this->po_currency->HrefValue = "";
            $this->po_currency->TooltipValue = "";

            // dispatch_week_p
            $this->dispatch_week_p->HrefValue = "";
            $this->dispatch_week_p->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // pl_no
            $this->pl_no->HrefValue = "";
            $this->pl_no->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // roll_no
            $this->roll_no->HrefValue = "";
            $this->roll_no->TooltipValue = "";

            // qty
            $this->qty->HrefValue = "";
            $this->qty->TooltipValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";
            $this->q_sku->TooltipValue = "";

            // sqm_u
            $this->sqm_u->HrefValue = "";
            $this->sqm_u->TooltipValue = "";

            // po_discount
            $this->po_discount->HrefValue = "";
            $this->po_discount->TooltipValue = "";

            // 11
            $this->_11->HrefValue = "";
            $this->_11->TooltipValue = "";

            // 12
            $this->_12->HrefValue = "";
            $this->_12->TooltipValue = "";

            // 13
            $this->_13->HrefValue = "";
            $this->_13->TooltipValue = "";

            // 14
            $this->_14->HrefValue = "";
            $this->_14->TooltipValue = "";

            // 15
            $this->_15->HrefValue = "";
            $this->_15->TooltipValue = "";

            // 16
            $this->_16->HrefValue = "";
            $this->_16->TooltipValue = "";

            // 17
            $this->_17->HrefValue = "";
            $this->_17->TooltipValue = "";

            // 18
            $this->_18->HrefValue = "";
            $this->_18->TooltipValue = "";

            // 19
            $this->_19->HrefValue = "";
            $this->_19->TooltipValue = "";

            // 20
            $this->_20->HrefValue = "";
            $this->_20->TooltipValue = "";

            // 21
            $this->_21->HrefValue = "";
            $this->_21->TooltipValue = "";

            // 22
            $this->_22->HrefValue = "";
            $this->_22->TooltipValue = "";

            // 23
            $this->_23->HrefValue = "";
            $this->_23->TooltipValue = "";

            // 24
            $this->_24->HrefValue = "";
            $this->_24->TooltipValue = "";

            // 25
            $this->_25->HrefValue = "";
            $this->_25->TooltipValue = "";

            // 26
            $this->_26->HrefValue = "";
            $this->_26->TooltipValue = "";

            // 27
            $this->_27->HrefValue = "";
            $this->_27->TooltipValue = "";

            // 28
            $this->_28->HrefValue = "";
            $this->_28->TooltipValue = "";

            // 29
            $this->_29->HrefValue = "";
            $this->_29->TooltipValue = "";

            // 30
            $this->_30->HrefValue = "";
            $this->_30->TooltipValue = "";

            // 31
            $this->_31->HrefValue = "";
            $this->_31->TooltipValue = "";

            // 32
            $this->_32->HrefValue = "";
            $this->_32->TooltipValue = "";

            // 33
            $this->_33->HrefValue = "";
            $this->_33->TooltipValue = "";

            // 34
            $this->_34->HrefValue = "";
            $this->_34->TooltipValue = "";

            // 35
            $this->_35->HrefValue = "";
            $this->_35->TooltipValue = "";

            // 36
            $this->_36->HrefValue = "";
            $this->_36->TooltipValue = "";

            // 37
            $this->_37->HrefValue = "";
            $this->_37->TooltipValue = "";

            // 38
            $this->_38->HrefValue = "";
            $this->_38->TooltipValue = "";

            // 39
            $this->_39->HrefValue = "";
            $this->_39->TooltipValue = "";

            // 40
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";

            // 41
            $this->_41->HrefValue = "";
            $this->_41->TooltipValue = "";

            // 42
            $this->_42->HrefValue = "";
            $this->_42->TooltipValue = "";

            // 43
            $this->_43->HrefValue = "";
            $this->_43->TooltipValue = "";

            // 44
            $this->_44->HrefValue = "";
            $this->_44->TooltipValue = "";

            // 45
            $this->_45->HrefValue = "";
            $this->_45->TooltipValue = "";

            // 46
            $this->_46->HrefValue = "";
            $this->_46->TooltipValue = "";

            // 47
            $this->_47->HrefValue = "";
            $this->_47->TooltipValue = "";

            // 48
            $this->_48->HrefValue = "";
            $this->_48->TooltipValue = "";

            // 49
            $this->_49->HrefValue = "";
            $this->_49->TooltipValue = "";

            // 50
            $this->_50->HrefValue = "";
            $this->_50->TooltipValue = "";

            // c_sqm
            $this->c_sqm->HrefValue = "";
            $this->c_sqm->TooltipValue = "";

            // order_date
            $this->order_date->HrefValue = "";
            $this->order_date->TooltipValue = "";

            // p_remarks
            $this->p_remarks->HrefValue = "";
            $this->p_remarks->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bcodeoldlist"), "", $this->TableVar, true);
        $pageId = "view";
        $Breadcrumb->add("view", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_weaving_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_current_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyers_id":
                    break;
                case "x_pp_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_ref":
                    break;
                case "x_design":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_design_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cs":
                    break;
                case "x_product_type":
                    break;
                case "x_despatch_week":
                    break;
                case "x_payment_plan":
                    break;
                case "x_production_plan":
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_completed":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_c":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_d":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_po_currency":
                    break;
                case "x_dispatch_week_p":
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }
}
