<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BcodeOldList extends BcodeOld
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BcodeOldList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fbcode_oldlist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "bcodeoldlist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->pid->Visible = false;
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->weaving_works->setVisibility();
        $this->current_works->setVisibility();
        $this->po->setVisibility();
        $this->_barcode->setVisibility();
        $this->buyers_id->setVisibility();
        $this->pp_id->Visible = false;
        $this->buyer_ref->setVisibility();
        $this->buyer_tid->Visible = false;
        $this->design->Visible = false;
        $this->design_id->setVisibility();
        $this->batch_no->setVisibility();
        $this->l_cm->Visible = false;
        $this->w_cm->Visible = false;
        $this->sqm->setVisibility();
        $this->sqm_a->Visible = false;
        $this->_2srm->Visible = false;
        $this->_2srm_a->Visible = false;
        $this->_4srm->Visible = false;
        $this->_4srm_a->Visible = false;
        $this->shape->setVisibility();
        $this->cs->setVisibility();
        $this->product_type->setVisibility();
        $this->size_cm->setVisibility();
        $this->size_buyer->Visible = false;
        $this->buyer_uid->setVisibility();
        $this->buyer_loc->setVisibility();
        $this->quantity->setVisibility();
        $this->po_price->setVisibility();
        $this->despatch_week->setVisibility();
        $this->despatch_date->setVisibility();
        $this->payment_plan->Visible = false;
        $this->production_plan->Visible = false;
        $this->status->setVisibility();
        $this->completed->setVisibility();
        $this->buyer_po->setVisibility();
        $this->jc_no->setVisibility();
        $this->process->Visible = false;
        $this->process_c->Visible = false;
        $this->process_d->setVisibility();
        $this->weight->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->po_currency->setVisibility();
        $this->dispatch_week_p->setVisibility();
        $this->remarks->setVisibility();
        $this->pl_no->setVisibility();
        $this->category->setVisibility();
        $this->roll_no->setVisibility();
        $this->qty->Visible = false;
        $this->consignee->Visible = false;
        $this->buyer_barcode->setVisibility();
        $this->design_next->Visible = false;
        $this->q_sku->setVisibility();
        $this->sqm_u->setVisibility();
        $this->po_discount->setVisibility();
        $this->loom_plan->Visible = false;
        $this->_11->setVisibility();
        $this->_12->setVisibility();
        $this->_13->setVisibility();
        $this->_14->setVisibility();
        $this->_15->setVisibility();
        $this->_16->setVisibility();
        $this->_17->setVisibility();
        $this->_18->setVisibility();
        $this->_19->setVisibility();
        $this->_20->setVisibility();
        $this->_21->setVisibility();
        $this->_22->setVisibility();
        $this->_23->setVisibility();
        $this->_24->setVisibility();
        $this->_25->setVisibility();
        $this->_26->setVisibility();
        $this->_27->setVisibility();
        $this->_28->setVisibility();
        $this->_29->setVisibility();
        $this->_30->setVisibility();
        $this->_31->setVisibility();
        $this->_32->setVisibility();
        $this->_33->setVisibility();
        $this->_34->setVisibility();
        $this->_35->setVisibility();
        $this->_36->setVisibility();
        $this->_37->setVisibility();
        $this->_38->setVisibility();
        $this->_39->setVisibility();
        $this->_40->setVisibility();
        $this->_41->setVisibility();
        $this->_42->setVisibility();
        $this->_43->setVisibility();
        $this->_44->setVisibility();
        $this->_45->setVisibility();
        $this->_46->setVisibility();
        $this->_47->setVisibility();
        $this->_48->setVisibility();
        $this->_49->setVisibility();
        $this->_50->setVisibility();
        $this->c_sqm->Visible = false;
        $this->packing_type->Visible = false;
        $this->order_date->setVisibility();
        $this->qc_weaving->Visible = false;
        $this->p_remarks->Visible = false;
        $this->roll_no_qty_tmp->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'bcode_old';
        $this->TableName = 'bcode_old';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (bcode_old)
        if (!isset($GLOBALS["bcode_old"]) || $GLOBALS["bcode_old"]::class == PROJECT_NAMESPACE . "bcode_old") {
            $GLOBALS["bcode_old"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "bcodeoldadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "bcodeolddelete";
        $this->MultiUpdateUrl = "bcodeoldupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'bcode_old');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "bcodeoldview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 2; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->weaving_works);
        $this->setupLookupOptions($this->current_works);
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->pp_id);
        $this->setupLookupOptions($this->buyer_ref);
        $this->setupLookupOptions($this->design);
        $this->setupLookupOptions($this->design_id);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->cs);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->payment_plan);
        $this->setupLookupOptions($this->production_plan);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->completed);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->process_c);
        $this->setupLookupOptions($this->process_d);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->po_currency);
        $this->setupLookupOptions($this->dispatch_week_p);
        $this->setupLookupOptions($this->category);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fbcode_oldgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fbcode_oldsrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->pid->AdvancedSearch->toJson(), ","); // Field pid
        $filterList = Concat($filterList, $this->weaving_works->AdvancedSearch->toJson(), ","); // Field weaving_works
        $filterList = Concat($filterList, $this->current_works->AdvancedSearch->toJson(), ","); // Field current_works
        $filterList = Concat($filterList, $this->po->AdvancedSearch->toJson(), ","); // Field po
        $filterList = Concat($filterList, $this->_barcode->AdvancedSearch->toJson(), ","); // Field barcode
        $filterList = Concat($filterList, $this->buyers_id->AdvancedSearch->toJson(), ","); // Field buyers_id
        $filterList = Concat($filterList, $this->pp_id->AdvancedSearch->toJson(), ","); // Field pp_id
        $filterList = Concat($filterList, $this->buyer_ref->AdvancedSearch->toJson(), ","); // Field buyer_ref
        $filterList = Concat($filterList, $this->design_id->AdvancedSearch->toJson(), ","); // Field design_id
        $filterList = Concat($filterList, $this->batch_no->AdvancedSearch->toJson(), ","); // Field batch_no
        $filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
        $filterList = Concat($filterList, $this->shape->AdvancedSearch->toJson(), ","); // Field shape
        $filterList = Concat($filterList, $this->cs->AdvancedSearch->toJson(), ","); // Field cs
        $filterList = Concat($filterList, $this->product_type->AdvancedSearch->toJson(), ","); // Field product_type
        $filterList = Concat($filterList, $this->size_cm->AdvancedSearch->toJson(), ","); // Field size_cm
        $filterList = Concat($filterList, $this->size_buyer->AdvancedSearch->toJson(), ","); // Field size_buyer
        $filterList = Concat($filterList, $this->buyer_uid->AdvancedSearch->toJson(), ","); // Field buyer_uid
        $filterList = Concat($filterList, $this->buyer_loc->AdvancedSearch->toJson(), ","); // Field buyer_loc
        $filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
        $filterList = Concat($filterList, $this->po_price->AdvancedSearch->toJson(), ","); // Field po_price
        $filterList = Concat($filterList, $this->despatch_week->AdvancedSearch->toJson(), ","); // Field despatch_week
        $filterList = Concat($filterList, $this->despatch_date->AdvancedSearch->toJson(), ","); // Field despatch_date
        $filterList = Concat($filterList, $this->payment_plan->AdvancedSearch->toJson(), ","); // Field payment_plan
        $filterList = Concat($filterList, $this->production_plan->AdvancedSearch->toJson(), ","); // Field production_plan
        $filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
        $filterList = Concat($filterList, $this->completed->AdvancedSearch->toJson(), ","); // Field completed
        $filterList = Concat($filterList, $this->buyer_po->AdvancedSearch->toJson(), ","); // Field buyer_po
        $filterList = Concat($filterList, $this->jc_no->AdvancedSearch->toJson(), ","); // Field jc_no
        $filterList = Concat($filterList, $this->process_d->AdvancedSearch->toJson(), ","); // Field process_d
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        $filterList = Concat($filterList, $this->po_currency->AdvancedSearch->toJson(), ","); // Field po_currency
        $filterList = Concat($filterList, $this->dispatch_week_p->AdvancedSearch->toJson(), ","); // Field dispatch_week_p
        $filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
        $filterList = Concat($filterList, $this->pl_no->AdvancedSearch->toJson(), ","); // Field pl_no
        $filterList = Concat($filterList, $this->category->AdvancedSearch->toJson(), ","); // Field category
        $filterList = Concat($filterList, $this->roll_no->AdvancedSearch->toJson(), ","); // Field roll_no
        $filterList = Concat($filterList, $this->qty->AdvancedSearch->toJson(), ","); // Field qty
        $filterList = Concat($filterList, $this->q_sku->AdvancedSearch->toJson(), ","); // Field q_sku
        $filterList = Concat($filterList, $this->sqm_u->AdvancedSearch->toJson(), ","); // Field sqm_u
        $filterList = Concat($filterList, $this->po_discount->AdvancedSearch->toJson(), ","); // Field po_discount
        $filterList = Concat($filterList, $this->_11->AdvancedSearch->toJson(), ","); // Field 11
        $filterList = Concat($filterList, $this->_12->AdvancedSearch->toJson(), ","); // Field 12
        $filterList = Concat($filterList, $this->_13->AdvancedSearch->toJson(), ","); // Field 13
        $filterList = Concat($filterList, $this->_14->AdvancedSearch->toJson(), ","); // Field 14
        $filterList = Concat($filterList, $this->_15->AdvancedSearch->toJson(), ","); // Field 15
        $filterList = Concat($filterList, $this->_16->AdvancedSearch->toJson(), ","); // Field 16
        $filterList = Concat($filterList, $this->_17->AdvancedSearch->toJson(), ","); // Field 17
        $filterList = Concat($filterList, $this->_18->AdvancedSearch->toJson(), ","); // Field 18
        $filterList = Concat($filterList, $this->_19->AdvancedSearch->toJson(), ","); // Field 19
        $filterList = Concat($filterList, $this->_20->AdvancedSearch->toJson(), ","); // Field 20
        $filterList = Concat($filterList, $this->_21->AdvancedSearch->toJson(), ","); // Field 21
        $filterList = Concat($filterList, $this->_22->AdvancedSearch->toJson(), ","); // Field 22
        $filterList = Concat($filterList, $this->_23->AdvancedSearch->toJson(), ","); // Field 23
        $filterList = Concat($filterList, $this->_24->AdvancedSearch->toJson(), ","); // Field 24
        $filterList = Concat($filterList, $this->_25->AdvancedSearch->toJson(), ","); // Field 25
        $filterList = Concat($filterList, $this->_26->AdvancedSearch->toJson(), ","); // Field 26
        $filterList = Concat($filterList, $this->_27->AdvancedSearch->toJson(), ","); // Field 27
        $filterList = Concat($filterList, $this->_28->AdvancedSearch->toJson(), ","); // Field 28
        $filterList = Concat($filterList, $this->_29->AdvancedSearch->toJson(), ","); // Field 29
        $filterList = Concat($filterList, $this->_30->AdvancedSearch->toJson(), ","); // Field 30
        $filterList = Concat($filterList, $this->_31->AdvancedSearch->toJson(), ","); // Field 31
        $filterList = Concat($filterList, $this->_32->AdvancedSearch->toJson(), ","); // Field 32
        $filterList = Concat($filterList, $this->_33->AdvancedSearch->toJson(), ","); // Field 33
        $filterList = Concat($filterList, $this->_34->AdvancedSearch->toJson(), ","); // Field 34
        $filterList = Concat($filterList, $this->_35->AdvancedSearch->toJson(), ","); // Field 35
        $filterList = Concat($filterList, $this->_36->AdvancedSearch->toJson(), ","); // Field 36
        $filterList = Concat($filterList, $this->_37->AdvancedSearch->toJson(), ","); // Field 37
        $filterList = Concat($filterList, $this->_38->AdvancedSearch->toJson(), ","); // Field 38
        $filterList = Concat($filterList, $this->_39->AdvancedSearch->toJson(), ","); // Field 39
        $filterList = Concat($filterList, $this->_40->AdvancedSearch->toJson(), ","); // Field 40
        $filterList = Concat($filterList, $this->_41->AdvancedSearch->toJson(), ","); // Field 41
        $filterList = Concat($filterList, $this->_42->AdvancedSearch->toJson(), ","); // Field 42
        $filterList = Concat($filterList, $this->_43->AdvancedSearch->toJson(), ","); // Field 43
        $filterList = Concat($filterList, $this->_44->AdvancedSearch->toJson(), ","); // Field 44
        $filterList = Concat($filterList, $this->_45->AdvancedSearch->toJson(), ","); // Field 45
        $filterList = Concat($filterList, $this->_46->AdvancedSearch->toJson(), ","); // Field 46
        $filterList = Concat($filterList, $this->_47->AdvancedSearch->toJson(), ","); // Field 47
        $filterList = Concat($filterList, $this->_48->AdvancedSearch->toJson(), ","); // Field 48
        $filterList = Concat($filterList, $this->_49->AdvancedSearch->toJson(), ","); // Field 49
        $filterList = Concat($filterList, $this->_50->AdvancedSearch->toJson(), ","); // Field 50
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Query Builder rules
        $rules = $this->queryBuilderRules();
        if ($rules) {
            $filterList = Concat($filterList, "\"" . Config("TABLE_RULES") . "\":\"" . JsEncode($rules) . "\"", ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fbcode_oldsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field pid
        $this->pid->AdvancedSearch->SearchValue = @$filter["x_pid"];
        $this->pid->AdvancedSearch->SearchOperator = @$filter["z_pid"];
        $this->pid->AdvancedSearch->SearchCondition = @$filter["v_pid"];
        $this->pid->AdvancedSearch->SearchValue2 = @$filter["y_pid"];
        $this->pid->AdvancedSearch->SearchOperator2 = @$filter["w_pid"];
        $this->pid->AdvancedSearch->save();

        // Field weaving_works
        $this->weaving_works->AdvancedSearch->SearchValue = @$filter["x_weaving_works"];
        $this->weaving_works->AdvancedSearch->SearchOperator = @$filter["z_weaving_works"];
        $this->weaving_works->AdvancedSearch->SearchCondition = @$filter["v_weaving_works"];
        $this->weaving_works->AdvancedSearch->SearchValue2 = @$filter["y_weaving_works"];
        $this->weaving_works->AdvancedSearch->SearchOperator2 = @$filter["w_weaving_works"];
        $this->weaving_works->AdvancedSearch->save();

        // Field current_works
        $this->current_works->AdvancedSearch->SearchValue = @$filter["x_current_works"];
        $this->current_works->AdvancedSearch->SearchOperator = @$filter["z_current_works"];
        $this->current_works->AdvancedSearch->SearchCondition = @$filter["v_current_works"];
        $this->current_works->AdvancedSearch->SearchValue2 = @$filter["y_current_works"];
        $this->current_works->AdvancedSearch->SearchOperator2 = @$filter["w_current_works"];
        $this->current_works->AdvancedSearch->save();

        // Field po
        $this->po->AdvancedSearch->SearchValue = @$filter["x_po"];
        $this->po->AdvancedSearch->SearchOperator = @$filter["z_po"];
        $this->po->AdvancedSearch->SearchCondition = @$filter["v_po"];
        $this->po->AdvancedSearch->SearchValue2 = @$filter["y_po"];
        $this->po->AdvancedSearch->SearchOperator2 = @$filter["w_po"];
        $this->po->AdvancedSearch->save();

        // Field barcode
        $this->_barcode->AdvancedSearch->SearchValue = @$filter["x__barcode"];
        $this->_barcode->AdvancedSearch->SearchOperator = @$filter["z__barcode"];
        $this->_barcode->AdvancedSearch->SearchCondition = @$filter["v__barcode"];
        $this->_barcode->AdvancedSearch->SearchValue2 = @$filter["y__barcode"];
        $this->_barcode->AdvancedSearch->SearchOperator2 = @$filter["w__barcode"];
        $this->_barcode->AdvancedSearch->save();

        // Field buyers_id
        $this->buyers_id->AdvancedSearch->SearchValue = @$filter["x_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchOperator = @$filter["z_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchCondition = @$filter["v_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchValue2 = @$filter["y_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchOperator2 = @$filter["w_buyers_id"];
        $this->buyers_id->AdvancedSearch->save();

        // Field pp_id
        $this->pp_id->AdvancedSearch->SearchValue = @$filter["x_pp_id"];
        $this->pp_id->AdvancedSearch->SearchOperator = @$filter["z_pp_id"];
        $this->pp_id->AdvancedSearch->SearchCondition = @$filter["v_pp_id"];
        $this->pp_id->AdvancedSearch->SearchValue2 = @$filter["y_pp_id"];
        $this->pp_id->AdvancedSearch->SearchOperator2 = @$filter["w_pp_id"];
        $this->pp_id->AdvancedSearch->save();

        // Field buyer_ref
        $this->buyer_ref->AdvancedSearch->SearchValue = @$filter["x_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchOperator = @$filter["z_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchCondition = @$filter["v_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchValue2 = @$filter["y_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->save();

        // Field design_id
        $this->design_id->AdvancedSearch->SearchValue = @$filter["x_design_id"];
        $this->design_id->AdvancedSearch->SearchOperator = @$filter["z_design_id"];
        $this->design_id->AdvancedSearch->SearchCondition = @$filter["v_design_id"];
        $this->design_id->AdvancedSearch->SearchValue2 = @$filter["y_design_id"];
        $this->design_id->AdvancedSearch->SearchOperator2 = @$filter["w_design_id"];
        $this->design_id->AdvancedSearch->save();

        // Field batch_no
        $this->batch_no->AdvancedSearch->SearchValue = @$filter["x_batch_no"];
        $this->batch_no->AdvancedSearch->SearchOperator = @$filter["z_batch_no"];
        $this->batch_no->AdvancedSearch->SearchCondition = @$filter["v_batch_no"];
        $this->batch_no->AdvancedSearch->SearchValue2 = @$filter["y_batch_no"];
        $this->batch_no->AdvancedSearch->SearchOperator2 = @$filter["w_batch_no"];
        $this->batch_no->AdvancedSearch->save();

        // Field sqm
        $this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
        $this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
        $this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
        $this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
        $this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
        $this->sqm->AdvancedSearch->save();

        // Field shape
        $this->shape->AdvancedSearch->SearchValue = @$filter["x_shape"];
        $this->shape->AdvancedSearch->SearchOperator = @$filter["z_shape"];
        $this->shape->AdvancedSearch->SearchCondition = @$filter["v_shape"];
        $this->shape->AdvancedSearch->SearchValue2 = @$filter["y_shape"];
        $this->shape->AdvancedSearch->SearchOperator2 = @$filter["w_shape"];
        $this->shape->AdvancedSearch->save();

        // Field cs
        $this->cs->AdvancedSearch->SearchValue = @$filter["x_cs"];
        $this->cs->AdvancedSearch->SearchOperator = @$filter["z_cs"];
        $this->cs->AdvancedSearch->SearchCondition = @$filter["v_cs"];
        $this->cs->AdvancedSearch->SearchValue2 = @$filter["y_cs"];
        $this->cs->AdvancedSearch->SearchOperator2 = @$filter["w_cs"];
        $this->cs->AdvancedSearch->save();

        // Field product_type
        $this->product_type->AdvancedSearch->SearchValue = @$filter["x_product_type"];
        $this->product_type->AdvancedSearch->SearchOperator = @$filter["z_product_type"];
        $this->product_type->AdvancedSearch->SearchCondition = @$filter["v_product_type"];
        $this->product_type->AdvancedSearch->SearchValue2 = @$filter["y_product_type"];
        $this->product_type->AdvancedSearch->SearchOperator2 = @$filter["w_product_type"];
        $this->product_type->AdvancedSearch->save();

        // Field size_cm
        $this->size_cm->AdvancedSearch->SearchValue = @$filter["x_size_cm"];
        $this->size_cm->AdvancedSearch->SearchOperator = @$filter["z_size_cm"];
        $this->size_cm->AdvancedSearch->SearchCondition = @$filter["v_size_cm"];
        $this->size_cm->AdvancedSearch->SearchValue2 = @$filter["y_size_cm"];
        $this->size_cm->AdvancedSearch->SearchOperator2 = @$filter["w_size_cm"];
        $this->size_cm->AdvancedSearch->save();

        // Field size_buyer
        $this->size_buyer->AdvancedSearch->SearchValue = @$filter["x_size_buyer"];
        $this->size_buyer->AdvancedSearch->SearchOperator = @$filter["z_size_buyer"];
        $this->size_buyer->AdvancedSearch->SearchCondition = @$filter["v_size_buyer"];
        $this->size_buyer->AdvancedSearch->SearchValue2 = @$filter["y_size_buyer"];
        $this->size_buyer->AdvancedSearch->SearchOperator2 = @$filter["w_size_buyer"];
        $this->size_buyer->AdvancedSearch->save();

        // Field buyer_uid
        $this->buyer_uid->AdvancedSearch->SearchValue = @$filter["x_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->SearchOperator = @$filter["z_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->SearchCondition = @$filter["v_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->SearchValue2 = @$filter["y_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->save();

        // Field buyer_loc
        $this->buyer_loc->AdvancedSearch->SearchValue = @$filter["x_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->SearchOperator = @$filter["z_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->SearchCondition = @$filter["v_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->SearchValue2 = @$filter["y_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->save();

        // Field quantity
        $this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
        $this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
        $this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
        $this->quantity->AdvancedSearch->save();

        // Field po_price
        $this->po_price->AdvancedSearch->SearchValue = @$filter["x_po_price"];
        $this->po_price->AdvancedSearch->SearchOperator = @$filter["z_po_price"];
        $this->po_price->AdvancedSearch->SearchCondition = @$filter["v_po_price"];
        $this->po_price->AdvancedSearch->SearchValue2 = @$filter["y_po_price"];
        $this->po_price->AdvancedSearch->SearchOperator2 = @$filter["w_po_price"];
        $this->po_price->AdvancedSearch->save();

        // Field despatch_week
        $this->despatch_week->AdvancedSearch->SearchValue = @$filter["x_despatch_week"];
        $this->despatch_week->AdvancedSearch->SearchOperator = @$filter["z_despatch_week"];
        $this->despatch_week->AdvancedSearch->SearchCondition = @$filter["v_despatch_week"];
        $this->despatch_week->AdvancedSearch->SearchValue2 = @$filter["y_despatch_week"];
        $this->despatch_week->AdvancedSearch->SearchOperator2 = @$filter["w_despatch_week"];
        $this->despatch_week->AdvancedSearch->save();

        // Field despatch_date
        $this->despatch_date->AdvancedSearch->SearchValue = @$filter["x_despatch_date"];
        $this->despatch_date->AdvancedSearch->SearchOperator = @$filter["z_despatch_date"];
        $this->despatch_date->AdvancedSearch->SearchCondition = @$filter["v_despatch_date"];
        $this->despatch_date->AdvancedSearch->SearchValue2 = @$filter["y_despatch_date"];
        $this->despatch_date->AdvancedSearch->SearchOperator2 = @$filter["w_despatch_date"];
        $this->despatch_date->AdvancedSearch->save();

        // Field payment_plan
        $this->payment_plan->AdvancedSearch->SearchValue = @$filter["x_payment_plan"];
        $this->payment_plan->AdvancedSearch->SearchOperator = @$filter["z_payment_plan"];
        $this->payment_plan->AdvancedSearch->SearchCondition = @$filter["v_payment_plan"];
        $this->payment_plan->AdvancedSearch->SearchValue2 = @$filter["y_payment_plan"];
        $this->payment_plan->AdvancedSearch->SearchOperator2 = @$filter["w_payment_plan"];
        $this->payment_plan->AdvancedSearch->save();

        // Field production_plan
        $this->production_plan->AdvancedSearch->SearchValue = @$filter["x_production_plan"];
        $this->production_plan->AdvancedSearch->SearchOperator = @$filter["z_production_plan"];
        $this->production_plan->AdvancedSearch->SearchCondition = @$filter["v_production_plan"];
        $this->production_plan->AdvancedSearch->SearchValue2 = @$filter["y_production_plan"];
        $this->production_plan->AdvancedSearch->SearchOperator2 = @$filter["w_production_plan"];
        $this->production_plan->AdvancedSearch->save();

        // Field status
        $this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
        $this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
        $this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
        $this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
        $this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
        $this->status->AdvancedSearch->save();

        // Field completed
        $this->completed->AdvancedSearch->SearchValue = @$filter["x_completed"];
        $this->completed->AdvancedSearch->SearchOperator = @$filter["z_completed"];
        $this->completed->AdvancedSearch->SearchCondition = @$filter["v_completed"];
        $this->completed->AdvancedSearch->SearchValue2 = @$filter["y_completed"];
        $this->completed->AdvancedSearch->SearchOperator2 = @$filter["w_completed"];
        $this->completed->AdvancedSearch->save();

        // Field buyer_po
        $this->buyer_po->AdvancedSearch->SearchValue = @$filter["x_buyer_po"];
        $this->buyer_po->AdvancedSearch->SearchOperator = @$filter["z_buyer_po"];
        $this->buyer_po->AdvancedSearch->SearchCondition = @$filter["v_buyer_po"];
        $this->buyer_po->AdvancedSearch->SearchValue2 = @$filter["y_buyer_po"];
        $this->buyer_po->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_po"];
        $this->buyer_po->AdvancedSearch->save();

        // Field jc_no
        $this->jc_no->AdvancedSearch->SearchValue = @$filter["x_jc_no"];
        $this->jc_no->AdvancedSearch->SearchOperator = @$filter["z_jc_no"];
        $this->jc_no->AdvancedSearch->SearchCondition = @$filter["v_jc_no"];
        $this->jc_no->AdvancedSearch->SearchValue2 = @$filter["y_jc_no"];
        $this->jc_no->AdvancedSearch->SearchOperator2 = @$filter["w_jc_no"];
        $this->jc_no->AdvancedSearch->save();

        // Field process_d
        $this->process_d->AdvancedSearch->SearchValue = @$filter["x_process_d"];
        $this->process_d->AdvancedSearch->SearchOperator = @$filter["z_process_d"];
        $this->process_d->AdvancedSearch->SearchCondition = @$filter["v_process_d"];
        $this->process_d->AdvancedSearch->SearchValue2 = @$filter["y_process_d"];
        $this->process_d->AdvancedSearch->SearchOperator2 = @$filter["w_process_d"];
        $this->process_d->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();

        // Field po_currency
        $this->po_currency->AdvancedSearch->SearchValue = @$filter["x_po_currency"];
        $this->po_currency->AdvancedSearch->SearchOperator = @$filter["z_po_currency"];
        $this->po_currency->AdvancedSearch->SearchCondition = @$filter["v_po_currency"];
        $this->po_currency->AdvancedSearch->SearchValue2 = @$filter["y_po_currency"];
        $this->po_currency->AdvancedSearch->SearchOperator2 = @$filter["w_po_currency"];
        $this->po_currency->AdvancedSearch->save();

        // Field dispatch_week_p
        $this->dispatch_week_p->AdvancedSearch->SearchValue = @$filter["x_dispatch_week_p"];
        $this->dispatch_week_p->AdvancedSearch->SearchOperator = @$filter["z_dispatch_week_p"];
        $this->dispatch_week_p->AdvancedSearch->SearchCondition = @$filter["v_dispatch_week_p"];
        $this->dispatch_week_p->AdvancedSearch->SearchValue2 = @$filter["y_dispatch_week_p"];
        $this->dispatch_week_p->AdvancedSearch->SearchOperator2 = @$filter["w_dispatch_week_p"];
        $this->dispatch_week_p->AdvancedSearch->save();

        // Field remarks
        $this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
        $this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
        $this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
        $this->remarks->AdvancedSearch->save();

        // Field pl_no
        $this->pl_no->AdvancedSearch->SearchValue = @$filter["x_pl_no"];
        $this->pl_no->AdvancedSearch->SearchOperator = @$filter["z_pl_no"];
        $this->pl_no->AdvancedSearch->SearchCondition = @$filter["v_pl_no"];
        $this->pl_no->AdvancedSearch->SearchValue2 = @$filter["y_pl_no"];
        $this->pl_no->AdvancedSearch->SearchOperator2 = @$filter["w_pl_no"];
        $this->pl_no->AdvancedSearch->save();

        // Field category
        $this->category->AdvancedSearch->SearchValue = @$filter["x_category"];
        $this->category->AdvancedSearch->SearchOperator = @$filter["z_category"];
        $this->category->AdvancedSearch->SearchCondition = @$filter["v_category"];
        $this->category->AdvancedSearch->SearchValue2 = @$filter["y_category"];
        $this->category->AdvancedSearch->SearchOperator2 = @$filter["w_category"];
        $this->category->AdvancedSearch->save();

        // Field roll_no
        $this->roll_no->AdvancedSearch->SearchValue = @$filter["x_roll_no"];
        $this->roll_no->AdvancedSearch->SearchOperator = @$filter["z_roll_no"];
        $this->roll_no->AdvancedSearch->SearchCondition = @$filter["v_roll_no"];
        $this->roll_no->AdvancedSearch->SearchValue2 = @$filter["y_roll_no"];
        $this->roll_no->AdvancedSearch->SearchOperator2 = @$filter["w_roll_no"];
        $this->roll_no->AdvancedSearch->save();

        // Field qty
        $this->qty->AdvancedSearch->SearchValue = @$filter["x_qty"];
        $this->qty->AdvancedSearch->SearchOperator = @$filter["z_qty"];
        $this->qty->AdvancedSearch->SearchCondition = @$filter["v_qty"];
        $this->qty->AdvancedSearch->SearchValue2 = @$filter["y_qty"];
        $this->qty->AdvancedSearch->SearchOperator2 = @$filter["w_qty"];
        $this->qty->AdvancedSearch->save();

        // Field q_sku
        $this->q_sku->AdvancedSearch->SearchValue = @$filter["x_q_sku"];
        $this->q_sku->AdvancedSearch->SearchOperator = @$filter["z_q_sku"];
        $this->q_sku->AdvancedSearch->SearchCondition = @$filter["v_q_sku"];
        $this->q_sku->AdvancedSearch->SearchValue2 = @$filter["y_q_sku"];
        $this->q_sku->AdvancedSearch->SearchOperator2 = @$filter["w_q_sku"];
        $this->q_sku->AdvancedSearch->save();

        // Field sqm_u
        $this->sqm_u->AdvancedSearch->SearchValue = @$filter["x_sqm_u"];
        $this->sqm_u->AdvancedSearch->SearchOperator = @$filter["z_sqm_u"];
        $this->sqm_u->AdvancedSearch->SearchCondition = @$filter["v_sqm_u"];
        $this->sqm_u->AdvancedSearch->SearchValue2 = @$filter["y_sqm_u"];
        $this->sqm_u->AdvancedSearch->SearchOperator2 = @$filter["w_sqm_u"];
        $this->sqm_u->AdvancedSearch->save();

        // Field po_discount
        $this->po_discount->AdvancedSearch->SearchValue = @$filter["x_po_discount"];
        $this->po_discount->AdvancedSearch->SearchOperator = @$filter["z_po_discount"];
        $this->po_discount->AdvancedSearch->SearchCondition = @$filter["v_po_discount"];
        $this->po_discount->AdvancedSearch->SearchValue2 = @$filter["y_po_discount"];
        $this->po_discount->AdvancedSearch->SearchOperator2 = @$filter["w_po_discount"];
        $this->po_discount->AdvancedSearch->save();

        // Field 11
        $this->_11->AdvancedSearch->SearchValue = @$filter["x__11"];
        $this->_11->AdvancedSearch->SearchOperator = @$filter["z__11"];
        $this->_11->AdvancedSearch->SearchCondition = @$filter["v__11"];
        $this->_11->AdvancedSearch->SearchValue2 = @$filter["y__11"];
        $this->_11->AdvancedSearch->SearchOperator2 = @$filter["w__11"];
        $this->_11->AdvancedSearch->save();

        // Field 12
        $this->_12->AdvancedSearch->SearchValue = @$filter["x__12"];
        $this->_12->AdvancedSearch->SearchOperator = @$filter["z__12"];
        $this->_12->AdvancedSearch->SearchCondition = @$filter["v__12"];
        $this->_12->AdvancedSearch->SearchValue2 = @$filter["y__12"];
        $this->_12->AdvancedSearch->SearchOperator2 = @$filter["w__12"];
        $this->_12->AdvancedSearch->save();

        // Field 13
        $this->_13->AdvancedSearch->SearchValue = @$filter["x__13"];
        $this->_13->AdvancedSearch->SearchOperator = @$filter["z__13"];
        $this->_13->AdvancedSearch->SearchCondition = @$filter["v__13"];
        $this->_13->AdvancedSearch->SearchValue2 = @$filter["y__13"];
        $this->_13->AdvancedSearch->SearchOperator2 = @$filter["w__13"];
        $this->_13->AdvancedSearch->save();

        // Field 14
        $this->_14->AdvancedSearch->SearchValue = @$filter["x__14"];
        $this->_14->AdvancedSearch->SearchOperator = @$filter["z__14"];
        $this->_14->AdvancedSearch->SearchCondition = @$filter["v__14"];
        $this->_14->AdvancedSearch->SearchValue2 = @$filter["y__14"];
        $this->_14->AdvancedSearch->SearchOperator2 = @$filter["w__14"];
        $this->_14->AdvancedSearch->save();

        // Field 15
        $this->_15->AdvancedSearch->SearchValue = @$filter["x__15"];
        $this->_15->AdvancedSearch->SearchOperator = @$filter["z__15"];
        $this->_15->AdvancedSearch->SearchCondition = @$filter["v__15"];
        $this->_15->AdvancedSearch->SearchValue2 = @$filter["y__15"];
        $this->_15->AdvancedSearch->SearchOperator2 = @$filter["w__15"];
        $this->_15->AdvancedSearch->save();

        // Field 16
        $this->_16->AdvancedSearch->SearchValue = @$filter["x__16"];
        $this->_16->AdvancedSearch->SearchOperator = @$filter["z__16"];
        $this->_16->AdvancedSearch->SearchCondition = @$filter["v__16"];
        $this->_16->AdvancedSearch->SearchValue2 = @$filter["y__16"];
        $this->_16->AdvancedSearch->SearchOperator2 = @$filter["w__16"];
        $this->_16->AdvancedSearch->save();

        // Field 17
        $this->_17->AdvancedSearch->SearchValue = @$filter["x__17"];
        $this->_17->AdvancedSearch->SearchOperator = @$filter["z__17"];
        $this->_17->AdvancedSearch->SearchCondition = @$filter["v__17"];
        $this->_17->AdvancedSearch->SearchValue2 = @$filter["y__17"];
        $this->_17->AdvancedSearch->SearchOperator2 = @$filter["w__17"];
        $this->_17->AdvancedSearch->save();

        // Field 18
        $this->_18->AdvancedSearch->SearchValue = @$filter["x__18"];
        $this->_18->AdvancedSearch->SearchOperator = @$filter["z__18"];
        $this->_18->AdvancedSearch->SearchCondition = @$filter["v__18"];
        $this->_18->AdvancedSearch->SearchValue2 = @$filter["y__18"];
        $this->_18->AdvancedSearch->SearchOperator2 = @$filter["w__18"];
        $this->_18->AdvancedSearch->save();

        // Field 19
        $this->_19->AdvancedSearch->SearchValue = @$filter["x__19"];
        $this->_19->AdvancedSearch->SearchOperator = @$filter["z__19"];
        $this->_19->AdvancedSearch->SearchCondition = @$filter["v__19"];
        $this->_19->AdvancedSearch->SearchValue2 = @$filter["y__19"];
        $this->_19->AdvancedSearch->SearchOperator2 = @$filter["w__19"];
        $this->_19->AdvancedSearch->save();

        // Field 20
        $this->_20->AdvancedSearch->SearchValue = @$filter["x__20"];
        $this->_20->AdvancedSearch->SearchOperator = @$filter["z__20"];
        $this->_20->AdvancedSearch->SearchCondition = @$filter["v__20"];
        $this->_20->AdvancedSearch->SearchValue2 = @$filter["y__20"];
        $this->_20->AdvancedSearch->SearchOperator2 = @$filter["w__20"];
        $this->_20->AdvancedSearch->save();

        // Field 21
        $this->_21->AdvancedSearch->SearchValue = @$filter["x__21"];
        $this->_21->AdvancedSearch->SearchOperator = @$filter["z__21"];
        $this->_21->AdvancedSearch->SearchCondition = @$filter["v__21"];
        $this->_21->AdvancedSearch->SearchValue2 = @$filter["y__21"];
        $this->_21->AdvancedSearch->SearchOperator2 = @$filter["w__21"];
        $this->_21->AdvancedSearch->save();

        // Field 22
        $this->_22->AdvancedSearch->SearchValue = @$filter["x__22"];
        $this->_22->AdvancedSearch->SearchOperator = @$filter["z__22"];
        $this->_22->AdvancedSearch->SearchCondition = @$filter["v__22"];
        $this->_22->AdvancedSearch->SearchValue2 = @$filter["y__22"];
        $this->_22->AdvancedSearch->SearchOperator2 = @$filter["w__22"];
        $this->_22->AdvancedSearch->save();

        // Field 23
        $this->_23->AdvancedSearch->SearchValue = @$filter["x__23"];
        $this->_23->AdvancedSearch->SearchOperator = @$filter["z__23"];
        $this->_23->AdvancedSearch->SearchCondition = @$filter["v__23"];
        $this->_23->AdvancedSearch->SearchValue2 = @$filter["y__23"];
        $this->_23->AdvancedSearch->SearchOperator2 = @$filter["w__23"];
        $this->_23->AdvancedSearch->save();

        // Field 24
        $this->_24->AdvancedSearch->SearchValue = @$filter["x__24"];
        $this->_24->AdvancedSearch->SearchOperator = @$filter["z__24"];
        $this->_24->AdvancedSearch->SearchCondition = @$filter["v__24"];
        $this->_24->AdvancedSearch->SearchValue2 = @$filter["y__24"];
        $this->_24->AdvancedSearch->SearchOperator2 = @$filter["w__24"];
        $this->_24->AdvancedSearch->save();

        // Field 25
        $this->_25->AdvancedSearch->SearchValue = @$filter["x__25"];
        $this->_25->AdvancedSearch->SearchOperator = @$filter["z__25"];
        $this->_25->AdvancedSearch->SearchCondition = @$filter["v__25"];
        $this->_25->AdvancedSearch->SearchValue2 = @$filter["y__25"];
        $this->_25->AdvancedSearch->SearchOperator2 = @$filter["w__25"];
        $this->_25->AdvancedSearch->save();

        // Field 26
        $this->_26->AdvancedSearch->SearchValue = @$filter["x__26"];
        $this->_26->AdvancedSearch->SearchOperator = @$filter["z__26"];
        $this->_26->AdvancedSearch->SearchCondition = @$filter["v__26"];
        $this->_26->AdvancedSearch->SearchValue2 = @$filter["y__26"];
        $this->_26->AdvancedSearch->SearchOperator2 = @$filter["w__26"];
        $this->_26->AdvancedSearch->save();

        // Field 27
        $this->_27->AdvancedSearch->SearchValue = @$filter["x__27"];
        $this->_27->AdvancedSearch->SearchOperator = @$filter["z__27"];
        $this->_27->AdvancedSearch->SearchCondition = @$filter["v__27"];
        $this->_27->AdvancedSearch->SearchValue2 = @$filter["y__27"];
        $this->_27->AdvancedSearch->SearchOperator2 = @$filter["w__27"];
        $this->_27->AdvancedSearch->save();

        // Field 28
        $this->_28->AdvancedSearch->SearchValue = @$filter["x__28"];
        $this->_28->AdvancedSearch->SearchOperator = @$filter["z__28"];
        $this->_28->AdvancedSearch->SearchCondition = @$filter["v__28"];
        $this->_28->AdvancedSearch->SearchValue2 = @$filter["y__28"];
        $this->_28->AdvancedSearch->SearchOperator2 = @$filter["w__28"];
        $this->_28->AdvancedSearch->save();

        // Field 29
        $this->_29->AdvancedSearch->SearchValue = @$filter["x__29"];
        $this->_29->AdvancedSearch->SearchOperator = @$filter["z__29"];
        $this->_29->AdvancedSearch->SearchCondition = @$filter["v__29"];
        $this->_29->AdvancedSearch->SearchValue2 = @$filter["y__29"];
        $this->_29->AdvancedSearch->SearchOperator2 = @$filter["w__29"];
        $this->_29->AdvancedSearch->save();

        // Field 30
        $this->_30->AdvancedSearch->SearchValue = @$filter["x__30"];
        $this->_30->AdvancedSearch->SearchOperator = @$filter["z__30"];
        $this->_30->AdvancedSearch->SearchCondition = @$filter["v__30"];
        $this->_30->AdvancedSearch->SearchValue2 = @$filter["y__30"];
        $this->_30->AdvancedSearch->SearchOperator2 = @$filter["w__30"];
        $this->_30->AdvancedSearch->save();

        // Field 31
        $this->_31->AdvancedSearch->SearchValue = @$filter["x__31"];
        $this->_31->AdvancedSearch->SearchOperator = @$filter["z__31"];
        $this->_31->AdvancedSearch->SearchCondition = @$filter["v__31"];
        $this->_31->AdvancedSearch->SearchValue2 = @$filter["y__31"];
        $this->_31->AdvancedSearch->SearchOperator2 = @$filter["w__31"];
        $this->_31->AdvancedSearch->save();

        // Field 32
        $this->_32->AdvancedSearch->SearchValue = @$filter["x__32"];
        $this->_32->AdvancedSearch->SearchOperator = @$filter["z__32"];
        $this->_32->AdvancedSearch->SearchCondition = @$filter["v__32"];
        $this->_32->AdvancedSearch->SearchValue2 = @$filter["y__32"];
        $this->_32->AdvancedSearch->SearchOperator2 = @$filter["w__32"];
        $this->_32->AdvancedSearch->save();

        // Field 33
        $this->_33->AdvancedSearch->SearchValue = @$filter["x__33"];
        $this->_33->AdvancedSearch->SearchOperator = @$filter["z__33"];
        $this->_33->AdvancedSearch->SearchCondition = @$filter["v__33"];
        $this->_33->AdvancedSearch->SearchValue2 = @$filter["y__33"];
        $this->_33->AdvancedSearch->SearchOperator2 = @$filter["w__33"];
        $this->_33->AdvancedSearch->save();

        // Field 34
        $this->_34->AdvancedSearch->SearchValue = @$filter["x__34"];
        $this->_34->AdvancedSearch->SearchOperator = @$filter["z__34"];
        $this->_34->AdvancedSearch->SearchCondition = @$filter["v__34"];
        $this->_34->AdvancedSearch->SearchValue2 = @$filter["y__34"];
        $this->_34->AdvancedSearch->SearchOperator2 = @$filter["w__34"];
        $this->_34->AdvancedSearch->save();

        // Field 35
        $this->_35->AdvancedSearch->SearchValue = @$filter["x__35"];
        $this->_35->AdvancedSearch->SearchOperator = @$filter["z__35"];
        $this->_35->AdvancedSearch->SearchCondition = @$filter["v__35"];
        $this->_35->AdvancedSearch->SearchValue2 = @$filter["y__35"];
        $this->_35->AdvancedSearch->SearchOperator2 = @$filter["w__35"];
        $this->_35->AdvancedSearch->save();

        // Field 36
        $this->_36->AdvancedSearch->SearchValue = @$filter["x__36"];
        $this->_36->AdvancedSearch->SearchOperator = @$filter["z__36"];
        $this->_36->AdvancedSearch->SearchCondition = @$filter["v__36"];
        $this->_36->AdvancedSearch->SearchValue2 = @$filter["y__36"];
        $this->_36->AdvancedSearch->SearchOperator2 = @$filter["w__36"];
        $this->_36->AdvancedSearch->save();

        // Field 37
        $this->_37->AdvancedSearch->SearchValue = @$filter["x__37"];
        $this->_37->AdvancedSearch->SearchOperator = @$filter["z__37"];
        $this->_37->AdvancedSearch->SearchCondition = @$filter["v__37"];
        $this->_37->AdvancedSearch->SearchValue2 = @$filter["y__37"];
        $this->_37->AdvancedSearch->SearchOperator2 = @$filter["w__37"];
        $this->_37->AdvancedSearch->save();

        // Field 38
        $this->_38->AdvancedSearch->SearchValue = @$filter["x__38"];
        $this->_38->AdvancedSearch->SearchOperator = @$filter["z__38"];
        $this->_38->AdvancedSearch->SearchCondition = @$filter["v__38"];
        $this->_38->AdvancedSearch->SearchValue2 = @$filter["y__38"];
        $this->_38->AdvancedSearch->SearchOperator2 = @$filter["w__38"];
        $this->_38->AdvancedSearch->save();

        // Field 39
        $this->_39->AdvancedSearch->SearchValue = @$filter["x__39"];
        $this->_39->AdvancedSearch->SearchOperator = @$filter["z__39"];
        $this->_39->AdvancedSearch->SearchCondition = @$filter["v__39"];
        $this->_39->AdvancedSearch->SearchValue2 = @$filter["y__39"];
        $this->_39->AdvancedSearch->SearchOperator2 = @$filter["w__39"];
        $this->_39->AdvancedSearch->save();

        // Field 40
        $this->_40->AdvancedSearch->SearchValue = @$filter["x__40"];
        $this->_40->AdvancedSearch->SearchOperator = @$filter["z__40"];
        $this->_40->AdvancedSearch->SearchCondition = @$filter["v__40"];
        $this->_40->AdvancedSearch->SearchValue2 = @$filter["y__40"];
        $this->_40->AdvancedSearch->SearchOperator2 = @$filter["w__40"];
        $this->_40->AdvancedSearch->save();

        // Field 41
        $this->_41->AdvancedSearch->SearchValue = @$filter["x__41"];
        $this->_41->AdvancedSearch->SearchOperator = @$filter["z__41"];
        $this->_41->AdvancedSearch->SearchCondition = @$filter["v__41"];
        $this->_41->AdvancedSearch->SearchValue2 = @$filter["y__41"];
        $this->_41->AdvancedSearch->SearchOperator2 = @$filter["w__41"];
        $this->_41->AdvancedSearch->save();

        // Field 42
        $this->_42->AdvancedSearch->SearchValue = @$filter["x__42"];
        $this->_42->AdvancedSearch->SearchOperator = @$filter["z__42"];
        $this->_42->AdvancedSearch->SearchCondition = @$filter["v__42"];
        $this->_42->AdvancedSearch->SearchValue2 = @$filter["y__42"];
        $this->_42->AdvancedSearch->SearchOperator2 = @$filter["w__42"];
        $this->_42->AdvancedSearch->save();

        // Field 43
        $this->_43->AdvancedSearch->SearchValue = @$filter["x__43"];
        $this->_43->AdvancedSearch->SearchOperator = @$filter["z__43"];
        $this->_43->AdvancedSearch->SearchCondition = @$filter["v__43"];
        $this->_43->AdvancedSearch->SearchValue2 = @$filter["y__43"];
        $this->_43->AdvancedSearch->SearchOperator2 = @$filter["w__43"];
        $this->_43->AdvancedSearch->save();

        // Field 44
        $this->_44->AdvancedSearch->SearchValue = @$filter["x__44"];
        $this->_44->AdvancedSearch->SearchOperator = @$filter["z__44"];
        $this->_44->AdvancedSearch->SearchCondition = @$filter["v__44"];
        $this->_44->AdvancedSearch->SearchValue2 = @$filter["y__44"];
        $this->_44->AdvancedSearch->SearchOperator2 = @$filter["w__44"];
        $this->_44->AdvancedSearch->save();

        // Field 45
        $this->_45->AdvancedSearch->SearchValue = @$filter["x__45"];
        $this->_45->AdvancedSearch->SearchOperator = @$filter["z__45"];
        $this->_45->AdvancedSearch->SearchCondition = @$filter["v__45"];
        $this->_45->AdvancedSearch->SearchValue2 = @$filter["y__45"];
        $this->_45->AdvancedSearch->SearchOperator2 = @$filter["w__45"];
        $this->_45->AdvancedSearch->save();

        // Field 46
        $this->_46->AdvancedSearch->SearchValue = @$filter["x__46"];
        $this->_46->AdvancedSearch->SearchOperator = @$filter["z__46"];
        $this->_46->AdvancedSearch->SearchCondition = @$filter["v__46"];
        $this->_46->AdvancedSearch->SearchValue2 = @$filter["y__46"];
        $this->_46->AdvancedSearch->SearchOperator2 = @$filter["w__46"];
        $this->_46->AdvancedSearch->save();

        // Field 47
        $this->_47->AdvancedSearch->SearchValue = @$filter["x__47"];
        $this->_47->AdvancedSearch->SearchOperator = @$filter["z__47"];
        $this->_47->AdvancedSearch->SearchCondition = @$filter["v__47"];
        $this->_47->AdvancedSearch->SearchValue2 = @$filter["y__47"];
        $this->_47->AdvancedSearch->SearchOperator2 = @$filter["w__47"];
        $this->_47->AdvancedSearch->save();

        // Field 48
        $this->_48->AdvancedSearch->SearchValue = @$filter["x__48"];
        $this->_48->AdvancedSearch->SearchOperator = @$filter["z__48"];
        $this->_48->AdvancedSearch->SearchCondition = @$filter["v__48"];
        $this->_48->AdvancedSearch->SearchValue2 = @$filter["y__48"];
        $this->_48->AdvancedSearch->SearchOperator2 = @$filter["w__48"];
        $this->_48->AdvancedSearch->save();

        // Field 49
        $this->_49->AdvancedSearch->SearchValue = @$filter["x__49"];
        $this->_49->AdvancedSearch->SearchOperator = @$filter["z__49"];
        $this->_49->AdvancedSearch->SearchCondition = @$filter["v__49"];
        $this->_49->AdvancedSearch->SearchValue2 = @$filter["y__49"];
        $this->_49->AdvancedSearch->SearchOperator2 = @$filter["w__49"];
        $this->_49->AdvancedSearch->save();

        // Field 50
        $this->_50->AdvancedSearch->SearchValue = @$filter["x__50"];
        $this->_50->AdvancedSearch->SearchOperator = @$filter["z__50"];
        $this->_50->AdvancedSearch->SearchCondition = @$filter["v__50"];
        $this->_50->AdvancedSearch->SearchValue2 = @$filter["y__50"];
        $this->_50->AdvancedSearch->SearchOperator2 = @$filter["w__50"];
        $this->_50->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
        if ($filter[Config("TABLE_RULES")] ?? false) {
            $this->Command = "query"; // Set command for query builder
            $this->setSessionRules($filter[Config("TABLE_RULES")]);
        }
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->pid, $default, false); // pid
        $this->buildSearchSql($where, $this->weaving_works, $default, false); // weaving_works
        $this->buildSearchSql($where, $this->current_works, $default, false); // current_works
        $this->buildSearchSql($where, $this->po, $default, false); // po
        $this->buildSearchSql($where, $this->_barcode, $default, false); // barcode
        $this->buildSearchSql($where, $this->buyers_id, $default, false); // buyers_id
        $this->buildSearchSql($where, $this->pp_id, $default, false); // pp_id
        $this->buildSearchSql($where, $this->buyer_ref, $default, false); // buyer_ref
        $this->buildSearchSql($where, $this->design_id, $default, false); // design_id
        $this->buildSearchSql($where, $this->batch_no, $default, false); // batch_no
        $this->buildSearchSql($where, $this->sqm, $default, false); // sqm
        $this->buildSearchSql($where, $this->shape, $default, false); // shape
        $this->buildSearchSql($where, $this->cs, $default, false); // cs
        $this->buildSearchSql($where, $this->product_type, $default, false); // product_type
        $this->buildSearchSql($where, $this->size_cm, $default, false); // size_cm
        $this->buildSearchSql($where, $this->size_buyer, $default, false); // size_buyer
        $this->buildSearchSql($where, $this->buyer_uid, $default, false); // buyer_uid
        $this->buildSearchSql($where, $this->buyer_loc, $default, false); // buyer_loc
        $this->buildSearchSql($where, $this->quantity, $default, false); // quantity
        $this->buildSearchSql($where, $this->po_price, $default, false); // po_price
        $this->buildSearchSql($where, $this->despatch_week, $default, false); // despatch_week
        $this->buildSearchSql($where, $this->despatch_date, $default, false); // despatch_date
        $this->buildSearchSql($where, $this->payment_plan, $default, false); // payment_plan
        $this->buildSearchSql($where, $this->production_plan, $default, false); // production_plan
        $this->buildSearchSql($where, $this->status, $default, false); // status
        $this->buildSearchSql($where, $this->completed, $default, false); // completed
        $this->buildSearchSql($where, $this->buyer_po, $default, false); // buyer_po
        $this->buildSearchSql($where, $this->jc_no, $default, false); // jc_no
        $this->buildSearchSql($where, $this->process_d, $default, true); // process_d
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime
        $this->buildSearchSql($where, $this->po_currency, $default, false); // po_currency
        $this->buildSearchSql($where, $this->dispatch_week_p, $default, false); // dispatch_week_p
        $this->buildSearchSql($where, $this->remarks, $default, false); // remarks
        $this->buildSearchSql($where, $this->pl_no, $default, false); // pl_no
        $this->buildSearchSql($where, $this->category, $default, false); // category
        $this->buildSearchSql($where, $this->roll_no, $default, false); // roll_no
        $this->buildSearchSql($where, $this->qty, $default, false); // qty
        $this->buildSearchSql($where, $this->q_sku, $default, false); // q_sku
        $this->buildSearchSql($where, $this->sqm_u, $default, false); // sqm_u
        $this->buildSearchSql($where, $this->po_discount, $default, false); // po_discount
        $this->buildSearchSql($where, $this->_11, $default, false); // 11
        $this->buildSearchSql($where, $this->_12, $default, false); // 12
        $this->buildSearchSql($where, $this->_13, $default, false); // 13
        $this->buildSearchSql($where, $this->_14, $default, false); // 14
        $this->buildSearchSql($where, $this->_15, $default, false); // 15
        $this->buildSearchSql($where, $this->_16, $default, false); // 16
        $this->buildSearchSql($where, $this->_17, $default, false); // 17
        $this->buildSearchSql($where, $this->_18, $default, false); // 18
        $this->buildSearchSql($where, $this->_19, $default, false); // 19
        $this->buildSearchSql($where, $this->_20, $default, false); // 20
        $this->buildSearchSql($where, $this->_21, $default, false); // 21
        $this->buildSearchSql($where, $this->_22, $default, false); // 22
        $this->buildSearchSql($where, $this->_23, $default, false); // 23
        $this->buildSearchSql($where, $this->_24, $default, false); // 24
        $this->buildSearchSql($where, $this->_25, $default, false); // 25
        $this->buildSearchSql($where, $this->_26, $default, false); // 26
        $this->buildSearchSql($where, $this->_27, $default, false); // 27
        $this->buildSearchSql($where, $this->_28, $default, false); // 28
        $this->buildSearchSql($where, $this->_29, $default, false); // 29
        $this->buildSearchSql($where, $this->_30, $default, false); // 30
        $this->buildSearchSql($where, $this->_31, $default, false); // 31
        $this->buildSearchSql($where, $this->_32, $default, false); // 32
        $this->buildSearchSql($where, $this->_33, $default, false); // 33
        $this->buildSearchSql($where, $this->_34, $default, false); // 34
        $this->buildSearchSql($where, $this->_35, $default, false); // 35
        $this->buildSearchSql($where, $this->_36, $default, false); // 36
        $this->buildSearchSql($where, $this->_37, $default, false); // 37
        $this->buildSearchSql($where, $this->_38, $default, false); // 38
        $this->buildSearchSql($where, $this->_39, $default, false); // 39
        $this->buildSearchSql($where, $this->_40, $default, false); // 40
        $this->buildSearchSql($where, $this->_41, $default, false); // 41
        $this->buildSearchSql($where, $this->_42, $default, false); // 42
        $this->buildSearchSql($where, $this->_43, $default, false); // 43
        $this->buildSearchSql($where, $this->_44, $default, false); // 44
        $this->buildSearchSql($where, $this->_45, $default, false); // 45
        $this->buildSearchSql($where, $this->_46, $default, false); // 46
        $this->buildSearchSql($where, $this->_47, $default, false); // 47
        $this->buildSearchSql($where, $this->_48, $default, false); // 48
        $this->buildSearchSql($where, $this->_49, $default, false); // 49
        $this->buildSearchSql($where, $this->_50, $default, false); // 50

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->pid->AdvancedSearch->save(); // pid
            $this->weaving_works->AdvancedSearch->save(); // weaving_works
            $this->current_works->AdvancedSearch->save(); // current_works
            $this->po->AdvancedSearch->save(); // po
            $this->_barcode->AdvancedSearch->save(); // barcode
            $this->buyers_id->AdvancedSearch->save(); // buyers_id
            $this->pp_id->AdvancedSearch->save(); // pp_id
            $this->buyer_ref->AdvancedSearch->save(); // buyer_ref
            $this->design_id->AdvancedSearch->save(); // design_id
            $this->batch_no->AdvancedSearch->save(); // batch_no
            $this->sqm->AdvancedSearch->save(); // sqm
            $this->shape->AdvancedSearch->save(); // shape
            $this->cs->AdvancedSearch->save(); // cs
            $this->product_type->AdvancedSearch->save(); // product_type
            $this->size_cm->AdvancedSearch->save(); // size_cm
            $this->size_buyer->AdvancedSearch->save(); // size_buyer
            $this->buyer_uid->AdvancedSearch->save(); // buyer_uid
            $this->buyer_loc->AdvancedSearch->save(); // buyer_loc
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->po_price->AdvancedSearch->save(); // po_price
            $this->despatch_week->AdvancedSearch->save(); // despatch_week
            $this->despatch_date->AdvancedSearch->save(); // despatch_date
            $this->payment_plan->AdvancedSearch->save(); // payment_plan
            $this->production_plan->AdvancedSearch->save(); // production_plan
            $this->status->AdvancedSearch->save(); // status
            $this->completed->AdvancedSearch->save(); // completed
            $this->buyer_po->AdvancedSearch->save(); // buyer_po
            $this->jc_no->AdvancedSearch->save(); // jc_no
            $this->process_d->AdvancedSearch->save(); // process_d
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->po_currency->AdvancedSearch->save(); // po_currency
            $this->dispatch_week_p->AdvancedSearch->save(); // dispatch_week_p
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->pl_no->AdvancedSearch->save(); // pl_no
            $this->category->AdvancedSearch->save(); // category
            $this->roll_no->AdvancedSearch->save(); // roll_no
            $this->qty->AdvancedSearch->save(); // qty
            $this->q_sku->AdvancedSearch->save(); // q_sku
            $this->sqm_u->AdvancedSearch->save(); // sqm_u
            $this->po_discount->AdvancedSearch->save(); // po_discount
            $this->_11->AdvancedSearch->save(); // 11
            $this->_12->AdvancedSearch->save(); // 12
            $this->_13->AdvancedSearch->save(); // 13
            $this->_14->AdvancedSearch->save(); // 14
            $this->_15->AdvancedSearch->save(); // 15
            $this->_16->AdvancedSearch->save(); // 16
            $this->_17->AdvancedSearch->save(); // 17
            $this->_18->AdvancedSearch->save(); // 18
            $this->_19->AdvancedSearch->save(); // 19
            $this->_20->AdvancedSearch->save(); // 20
            $this->_21->AdvancedSearch->save(); // 21
            $this->_22->AdvancedSearch->save(); // 22
            $this->_23->AdvancedSearch->save(); // 23
            $this->_24->AdvancedSearch->save(); // 24
            $this->_25->AdvancedSearch->save(); // 25
            $this->_26->AdvancedSearch->save(); // 26
            $this->_27->AdvancedSearch->save(); // 27
            $this->_28->AdvancedSearch->save(); // 28
            $this->_29->AdvancedSearch->save(); // 29
            $this->_30->AdvancedSearch->save(); // 30
            $this->_31->AdvancedSearch->save(); // 31
            $this->_32->AdvancedSearch->save(); // 32
            $this->_33->AdvancedSearch->save(); // 33
            $this->_34->AdvancedSearch->save(); // 34
            $this->_35->AdvancedSearch->save(); // 35
            $this->_36->AdvancedSearch->save(); // 36
            $this->_37->AdvancedSearch->save(); // 37
            $this->_38->AdvancedSearch->save(); // 38
            $this->_39->AdvancedSearch->save(); // 39
            $this->_40->AdvancedSearch->save(); // 40
            $this->_41->AdvancedSearch->save(); // 41
            $this->_42->AdvancedSearch->save(); // 42
            $this->_43->AdvancedSearch->save(); // 43
            $this->_44->AdvancedSearch->save(); // 44
            $this->_45->AdvancedSearch->save(); // 45
            $this->_46->AdvancedSearch->save(); // 46
            $this->_47->AdvancedSearch->save(); // 47
            $this->_48->AdvancedSearch->save(); // 48
            $this->_49->AdvancedSearch->save(); // 49
            $this->_50->AdvancedSearch->save(); // 50

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->pid->AdvancedSearch->save(); // pid
            $this->weaving_works->AdvancedSearch->save(); // weaving_works
            $this->current_works->AdvancedSearch->save(); // current_works
            $this->po->AdvancedSearch->save(); // po
            $this->_barcode->AdvancedSearch->save(); // barcode
            $this->buyers_id->AdvancedSearch->save(); // buyers_id
            $this->pp_id->AdvancedSearch->save(); // pp_id
            $this->buyer_ref->AdvancedSearch->save(); // buyer_ref
            $this->design_id->AdvancedSearch->save(); // design_id
            $this->batch_no->AdvancedSearch->save(); // batch_no
            $this->sqm->AdvancedSearch->save(); // sqm
            $this->shape->AdvancedSearch->save(); // shape
            $this->cs->AdvancedSearch->save(); // cs
            $this->product_type->AdvancedSearch->save(); // product_type
            $this->size_cm->AdvancedSearch->save(); // size_cm
            $this->size_buyer->AdvancedSearch->save(); // size_buyer
            $this->buyer_uid->AdvancedSearch->save(); // buyer_uid
            $this->buyer_loc->AdvancedSearch->save(); // buyer_loc
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->po_price->AdvancedSearch->save(); // po_price
            $this->despatch_week->AdvancedSearch->save(); // despatch_week
            $this->despatch_date->AdvancedSearch->save(); // despatch_date
            $this->payment_plan->AdvancedSearch->save(); // payment_plan
            $this->production_plan->AdvancedSearch->save(); // production_plan
            $this->status->AdvancedSearch->save(); // status
            $this->completed->AdvancedSearch->save(); // completed
            $this->buyer_po->AdvancedSearch->save(); // buyer_po
            $this->jc_no->AdvancedSearch->save(); // jc_no
            $this->process_d->AdvancedSearch->save(); // process_d
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->po_currency->AdvancedSearch->save(); // po_currency
            $this->dispatch_week_p->AdvancedSearch->save(); // dispatch_week_p
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->pl_no->AdvancedSearch->save(); // pl_no
            $this->category->AdvancedSearch->save(); // category
            $this->roll_no->AdvancedSearch->save(); // roll_no
            $this->qty->AdvancedSearch->save(); // qty
            $this->q_sku->AdvancedSearch->save(); // q_sku
            $this->sqm_u->AdvancedSearch->save(); // sqm_u
            $this->po_discount->AdvancedSearch->save(); // po_discount
            $this->_11->AdvancedSearch->save(); // 11
            $this->_12->AdvancedSearch->save(); // 12
            $this->_13->AdvancedSearch->save(); // 13
            $this->_14->AdvancedSearch->save(); // 14
            $this->_15->AdvancedSearch->save(); // 15
            $this->_16->AdvancedSearch->save(); // 16
            $this->_17->AdvancedSearch->save(); // 17
            $this->_18->AdvancedSearch->save(); // 18
            $this->_19->AdvancedSearch->save(); // 19
            $this->_20->AdvancedSearch->save(); // 20
            $this->_21->AdvancedSearch->save(); // 21
            $this->_22->AdvancedSearch->save(); // 22
            $this->_23->AdvancedSearch->save(); // 23
            $this->_24->AdvancedSearch->save(); // 24
            $this->_25->AdvancedSearch->save(); // 25
            $this->_26->AdvancedSearch->save(); // 26
            $this->_27->AdvancedSearch->save(); // 27
            $this->_28->AdvancedSearch->save(); // 28
            $this->_29->AdvancedSearch->save(); // 29
            $this->_30->AdvancedSearch->save(); // 30
            $this->_31->AdvancedSearch->save(); // 31
            $this->_32->AdvancedSearch->save(); // 32
            $this->_33->AdvancedSearch->save(); // 33
            $this->_34->AdvancedSearch->save(); // 34
            $this->_35->AdvancedSearch->save(); // 35
            $this->_36->AdvancedSearch->save(); // 36
            $this->_37->AdvancedSearch->save(); // 37
            $this->_38->AdvancedSearch->save(); // 38
            $this->_39->AdvancedSearch->save(); // 39
            $this->_40->AdvancedSearch->save(); // 40
            $this->_41->AdvancedSearch->save(); // 41
            $this->_42->AdvancedSearch->save(); // 42
            $this->_43->AdvancedSearch->save(); // 43
            $this->_44->AdvancedSearch->save(); // 44
            $this->_45->AdvancedSearch->save(); // 45
            $this->_46->AdvancedSearch->save(); // 46
            $this->_47->AdvancedSearch->save(); // 47
            $this->_48->AdvancedSearch->save(); // 48
            $this->_49->AdvancedSearch->save(); // 49
            $this->_50->AdvancedSearch->save(); // 50
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field weaving_works
        $filter = $this->queryBuilderWhere("weaving_works");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->weaving_works, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->weaving_works->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field current_works
        $filter = $this->queryBuilderWhere("current_works");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->current_works, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->current_works->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po
        $filter = $this->queryBuilderWhere("po");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field barcode
        $filter = $this->queryBuilderWhere("barcode");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_barcode, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_barcode->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyers_id
        $filter = $this->queryBuilderWhere("buyers_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyers_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyers_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_ref
        $filter = $this->queryBuilderWhere("buyer_ref");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_ref, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_ref->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field design_id
        $filter = $this->queryBuilderWhere("design_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->design_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->design_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field batch_no
        $filter = $this->queryBuilderWhere("batch_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->batch_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->batch_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sqm
        $filter = $this->queryBuilderWhere("sqm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sqm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sqm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field shape
        $filter = $this->queryBuilderWhere("shape");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->shape, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->shape->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cs
        $filter = $this->queryBuilderWhere("cs");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cs, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cs->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product_type
        $filter = $this->queryBuilderWhere("product_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field size_cm
        $filter = $this->queryBuilderWhere("size_cm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->size_cm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->size_cm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_uid
        $filter = $this->queryBuilderWhere("buyer_uid");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_uid, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_uid->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_loc
        $filter = $this->queryBuilderWhere("buyer_loc");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_loc, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_loc->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field quantity
        $filter = $this->queryBuilderWhere("quantity");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->quantity, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->quantity->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_price
        $filter = $this->queryBuilderWhere("po_price");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_price, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_price->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field despatch_week
        $filter = $this->queryBuilderWhere("despatch_week");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->despatch_week, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->despatch_week->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field despatch_date
        $filter = $this->queryBuilderWhere("despatch_date");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->despatch_date, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->despatch_date->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field status
        $filter = $this->queryBuilderWhere("status");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->status, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field completed
        $filter = $this->queryBuilderWhere("completed");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->completed, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->completed->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_po
        $filter = $this->queryBuilderWhere("buyer_po");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_po, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_po->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field jc_no
        $filter = $this->queryBuilderWhere("jc_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->jc_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->jc_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field process_d
        $filter = $this->queryBuilderWhere("process_d");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->process_d, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->process_d->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_currency
        $filter = $this->queryBuilderWhere("po_currency");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_currency, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_currency->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field dispatch_week_p
        $filter = $this->queryBuilderWhere("dispatch_week_p");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->dispatch_week_p, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->dispatch_week_p->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field remarks
        $filter = $this->queryBuilderWhere("remarks");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->remarks, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->remarks->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pl_no
        $filter = $this->queryBuilderWhere("pl_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pl_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pl_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field category
        $filter = $this->queryBuilderWhere("category");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->category, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->category->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field roll_no
        $filter = $this->queryBuilderWhere("roll_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->roll_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->roll_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field q_sku
        $filter = $this->queryBuilderWhere("q_sku");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->q_sku, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->q_sku->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sqm_u
        $filter = $this->queryBuilderWhere("sqm_u");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sqm_u, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sqm_u->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_discount
        $filter = $this->queryBuilderWhere("po_discount");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_discount, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_discount->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 11
        $filter = $this->queryBuilderWhere("11");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_11, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_11->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 12
        $filter = $this->queryBuilderWhere("12");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_12, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_12->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 13
        $filter = $this->queryBuilderWhere("13");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_13, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_13->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 14
        $filter = $this->queryBuilderWhere("14");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_14, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_14->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 15
        $filter = $this->queryBuilderWhere("15");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_15, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_15->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 16
        $filter = $this->queryBuilderWhere("16");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_16, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_16->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 17
        $filter = $this->queryBuilderWhere("17");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_17, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_17->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 18
        $filter = $this->queryBuilderWhere("18");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_18, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_18->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 19
        $filter = $this->queryBuilderWhere("19");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_19, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_19->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 20
        $filter = $this->queryBuilderWhere("20");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_20, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_20->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 21
        $filter = $this->queryBuilderWhere("21");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_21, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_21->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 22
        $filter = $this->queryBuilderWhere("22");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_22, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_22->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 23
        $filter = $this->queryBuilderWhere("23");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_23, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_23->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 24
        $filter = $this->queryBuilderWhere("24");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_24, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_24->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 25
        $filter = $this->queryBuilderWhere("25");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_25, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_25->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 26
        $filter = $this->queryBuilderWhere("26");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_26, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_26->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 27
        $filter = $this->queryBuilderWhere("27");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_27, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_27->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 28
        $filter = $this->queryBuilderWhere("28");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_28, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_28->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 29
        $filter = $this->queryBuilderWhere("29");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_29, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_29->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 30
        $filter = $this->queryBuilderWhere("30");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_30, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_30->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 31
        $filter = $this->queryBuilderWhere("31");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_31, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_31->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 32
        $filter = $this->queryBuilderWhere("32");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_32, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_32->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 33
        $filter = $this->queryBuilderWhere("33");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_33, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_33->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 34
        $filter = $this->queryBuilderWhere("34");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_34, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_34->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 35
        $filter = $this->queryBuilderWhere("35");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_35, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_35->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 36
        $filter = $this->queryBuilderWhere("36");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_36, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_36->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 37
        $filter = $this->queryBuilderWhere("37");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_37, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_37->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 38
        $filter = $this->queryBuilderWhere("38");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_38, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_38->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 39
        $filter = $this->queryBuilderWhere("39");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_39, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_39->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 40
        $filter = $this->queryBuilderWhere("40");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_40, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_40->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 41
        $filter = $this->queryBuilderWhere("41");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_41, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_41->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 42
        $filter = $this->queryBuilderWhere("42");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_42, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_42->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 43
        $filter = $this->queryBuilderWhere("43");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_43, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_43->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 44
        $filter = $this->queryBuilderWhere("44");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_44, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_44->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 45
        $filter = $this->queryBuilderWhere("45");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_45, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_45->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 46
        $filter = $this->queryBuilderWhere("46");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_46, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_46->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 47
        $filter = $this->queryBuilderWhere("47");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_47, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_47->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 48
        $filter = $this->queryBuilderWhere("48");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_48, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_48->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 49
        $filter = $this->queryBuilderWhere("49");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_49, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_49->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 50
        $filter = $this->queryBuilderWhere("50");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_50, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_50->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->id;
        $searchFlds[] = &$this->pid;
        $searchFlds[] = &$this->grp;
        $searchFlds[] = &$this->s_grp;
        $searchFlds[] = &$this->weaving_works;
        $searchFlds[] = &$this->current_works;
        $searchFlds[] = &$this->po;
        $searchFlds[] = &$this->_barcode;
        $searchFlds[] = &$this->buyers_id;
        $searchFlds[] = &$this->pp_id;
        $searchFlds[] = &$this->buyer_ref;
        $searchFlds[] = &$this->buyer_tid;
        $searchFlds[] = &$this->design;
        $searchFlds[] = &$this->design_id;
        $searchFlds[] = &$this->batch_no;
        $searchFlds[] = &$this->l_cm;
        $searchFlds[] = &$this->w_cm;
        $searchFlds[] = &$this->sqm;
        $searchFlds[] = &$this->sqm_a;
        $searchFlds[] = &$this->_2srm;
        $searchFlds[] = &$this->_2srm_a;
        $searchFlds[] = &$this->_4srm;
        $searchFlds[] = &$this->_4srm_a;
        $searchFlds[] = &$this->shape;
        $searchFlds[] = &$this->cs;
        $searchFlds[] = &$this->product_type;
        $searchFlds[] = &$this->size_cm;
        $searchFlds[] = &$this->size_buyer;
        $searchFlds[] = &$this->buyer_uid;
        $searchFlds[] = &$this->buyer_loc;
        $searchFlds[] = &$this->quantity;
        $searchFlds[] = &$this->po_price;
        $searchFlds[] = &$this->despatch_week;
        $searchFlds[] = &$this->despatch_date;
        $searchFlds[] = &$this->payment_plan;
        $searchFlds[] = &$this->production_plan;
        $searchFlds[] = &$this->status;
        $searchFlds[] = &$this->completed;
        $searchFlds[] = &$this->buyer_po;
        $searchFlds[] = &$this->jc_no;
        $searchFlds[] = &$this->process;
        $searchFlds[] = &$this->process_c;
        $searchFlds[] = &$this->process_d;
        $searchFlds[] = &$this->operator;
        $searchFlds[] = &$this->datetime;
        $searchFlds[] = &$this->remarks;
        $searchFlds[] = &$this->category;
        $searchFlds[] = &$this->buyer_barcode;
        $searchFlds[] = &$this->loom_plan;
        $searchFlds[] = &$this->p_remarks;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->weaving_works->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->current_works->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_barcode->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyers_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pp_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_ref->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->design_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->batch_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sqm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->shape->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cs->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->size_cm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->size_buyer->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_uid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_loc->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->quantity->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_price->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->despatch_week->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->despatch_date->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->payment_plan->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->production_plan->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->completed->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_po->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->jc_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->process_d->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_currency->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->dispatch_week_p->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->remarks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pl_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->category->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->roll_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->q_sku->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sqm_u->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_discount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_11->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_12->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_13->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_14->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_15->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_16->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_17->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_18->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_19->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_20->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_21->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_22->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_23->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_24->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_25->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_26->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_27->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_28->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_29->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_30->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_31->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_32->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_33->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_34->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_35->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_36->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_37->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_38->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_39->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_40->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_41->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_42->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_43->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_44->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_45->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_46->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_47->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_48->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_49->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_50->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->pid->AdvancedSearch->unsetSession();
        $this->weaving_works->AdvancedSearch->unsetSession();
        $this->current_works->AdvancedSearch->unsetSession();
        $this->po->AdvancedSearch->unsetSession();
        $this->_barcode->AdvancedSearch->unsetSession();
        $this->buyers_id->AdvancedSearch->unsetSession();
        $this->pp_id->AdvancedSearch->unsetSession();
        $this->buyer_ref->AdvancedSearch->unsetSession();
        $this->design_id->AdvancedSearch->unsetSession();
        $this->batch_no->AdvancedSearch->unsetSession();
        $this->sqm->AdvancedSearch->unsetSession();
        $this->shape->AdvancedSearch->unsetSession();
        $this->cs->AdvancedSearch->unsetSession();
        $this->product_type->AdvancedSearch->unsetSession();
        $this->size_cm->AdvancedSearch->unsetSession();
        $this->size_buyer->AdvancedSearch->unsetSession();
        $this->buyer_uid->AdvancedSearch->unsetSession();
        $this->buyer_loc->AdvancedSearch->unsetSession();
        $this->quantity->AdvancedSearch->unsetSession();
        $this->po_price->AdvancedSearch->unsetSession();
        $this->despatch_week->AdvancedSearch->unsetSession();
        $this->despatch_date->AdvancedSearch->unsetSession();
        $this->payment_plan->AdvancedSearch->unsetSession();
        $this->production_plan->AdvancedSearch->unsetSession();
        $this->status->AdvancedSearch->unsetSession();
        $this->completed->AdvancedSearch->unsetSession();
        $this->buyer_po->AdvancedSearch->unsetSession();
        $this->jc_no->AdvancedSearch->unsetSession();
        $this->process_d->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
        $this->po_currency->AdvancedSearch->unsetSession();
        $this->dispatch_week_p->AdvancedSearch->unsetSession();
        $this->remarks->AdvancedSearch->unsetSession();
        $this->pl_no->AdvancedSearch->unsetSession();
        $this->category->AdvancedSearch->unsetSession();
        $this->roll_no->AdvancedSearch->unsetSession();
        $this->qty->AdvancedSearch->unsetSession();
        $this->q_sku->AdvancedSearch->unsetSession();
        $this->sqm_u->AdvancedSearch->unsetSession();
        $this->po_discount->AdvancedSearch->unsetSession();
        $this->_11->AdvancedSearch->unsetSession();
        $this->_12->AdvancedSearch->unsetSession();
        $this->_13->AdvancedSearch->unsetSession();
        $this->_14->AdvancedSearch->unsetSession();
        $this->_15->AdvancedSearch->unsetSession();
        $this->_16->AdvancedSearch->unsetSession();
        $this->_17->AdvancedSearch->unsetSession();
        $this->_18->AdvancedSearch->unsetSession();
        $this->_19->AdvancedSearch->unsetSession();
        $this->_20->AdvancedSearch->unsetSession();
        $this->_21->AdvancedSearch->unsetSession();
        $this->_22->AdvancedSearch->unsetSession();
        $this->_23->AdvancedSearch->unsetSession();
        $this->_24->AdvancedSearch->unsetSession();
        $this->_25->AdvancedSearch->unsetSession();
        $this->_26->AdvancedSearch->unsetSession();
        $this->_27->AdvancedSearch->unsetSession();
        $this->_28->AdvancedSearch->unsetSession();
        $this->_29->AdvancedSearch->unsetSession();
        $this->_30->AdvancedSearch->unsetSession();
        $this->_31->AdvancedSearch->unsetSession();
        $this->_32->AdvancedSearch->unsetSession();
        $this->_33->AdvancedSearch->unsetSession();
        $this->_34->AdvancedSearch->unsetSession();
        $this->_35->AdvancedSearch->unsetSession();
        $this->_36->AdvancedSearch->unsetSession();
        $this->_37->AdvancedSearch->unsetSession();
        $this->_38->AdvancedSearch->unsetSession();
        $this->_39->AdvancedSearch->unsetSession();
        $this->_40->AdvancedSearch->unsetSession();
        $this->_41->AdvancedSearch->unsetSession();
        $this->_42->AdvancedSearch->unsetSession();
        $this->_43->AdvancedSearch->unsetSession();
        $this->_44->AdvancedSearch->unsetSession();
        $this->_45->AdvancedSearch->unsetSession();
        $this->_46->AdvancedSearch->unsetSession();
        $this->_47->AdvancedSearch->unsetSession();
        $this->_48->AdvancedSearch->unsetSession();
        $this->_49->AdvancedSearch->unsetSession();
        $this->_50->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->pid->AdvancedSearch->load();
        $this->weaving_works->AdvancedSearch->load();
        $this->current_works->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->buyers_id->AdvancedSearch->load();
        $this->pp_id->AdvancedSearch->load();
        $this->buyer_ref->AdvancedSearch->load();
        $this->design_id->AdvancedSearch->load();
        $this->batch_no->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->shape->AdvancedSearch->load();
        $this->cs->AdvancedSearch->load();
        $this->product_type->AdvancedSearch->load();
        $this->size_cm->AdvancedSearch->load();
        $this->size_buyer->AdvancedSearch->load();
        $this->buyer_uid->AdvancedSearch->load();
        $this->buyer_loc->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->po_price->AdvancedSearch->load();
        $this->despatch_week->AdvancedSearch->load();
        $this->despatch_date->AdvancedSearch->load();
        $this->payment_plan->AdvancedSearch->load();
        $this->production_plan->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->completed->AdvancedSearch->load();
        $this->buyer_po->AdvancedSearch->load();
        $this->jc_no->AdvancedSearch->load();
        $this->process_d->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->po_currency->AdvancedSearch->load();
        $this->dispatch_week_p->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->pl_no->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->roll_no->AdvancedSearch->load();
        $this->qty->AdvancedSearch->load();
        $this->q_sku->AdvancedSearch->load();
        $this->sqm_u->AdvancedSearch->load();
        $this->po_discount->AdvancedSearch->load();
        $this->_11->AdvancedSearch->load();
        $this->_12->AdvancedSearch->load();
        $this->_13->AdvancedSearch->load();
        $this->_14->AdvancedSearch->load();
        $this->_15->AdvancedSearch->load();
        $this->_16->AdvancedSearch->load();
        $this->_17->AdvancedSearch->load();
        $this->_18->AdvancedSearch->load();
        $this->_19->AdvancedSearch->load();
        $this->_20->AdvancedSearch->load();
        $this->_21->AdvancedSearch->load();
        $this->_22->AdvancedSearch->load();
        $this->_23->AdvancedSearch->load();
        $this->_24->AdvancedSearch->load();
        $this->_25->AdvancedSearch->load();
        $this->_26->AdvancedSearch->load();
        $this->_27->AdvancedSearch->load();
        $this->_28->AdvancedSearch->load();
        $this->_29->AdvancedSearch->load();
        $this->_30->AdvancedSearch->load();
        $this->_31->AdvancedSearch->load();
        $this->_32->AdvancedSearch->load();
        $this->_33->AdvancedSearch->load();
        $this->_34->AdvancedSearch->load();
        $this->_35->AdvancedSearch->load();
        $this->_36->AdvancedSearch->load();
        $this->_37->AdvancedSearch->load();
        $this->_38->AdvancedSearch->load();
        $this->_39->AdvancedSearch->load();
        $this->_40->AdvancedSearch->load();
        $this->_41->AdvancedSearch->load();
        $this->_42->AdvancedSearch->load();
        $this->_43->AdvancedSearch->load();
        $this->_44->AdvancedSearch->load();
        $this->_45->AdvancedSearch->load();
        $this->_46->AdvancedSearch->load();
        $this->_47->AdvancedSearch->load();
        $this->_48->AdvancedSearch->load();
        $this->_49->AdvancedSearch->load();
        $this->_50->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->_barcode->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
            $defaultSortList = ($this->_barcode->VirtualExpression != "" ? $this->_barcode->VirtualExpression : $this->_barcode->Expression) . " DESC"; // Set up default sort
            if ($this->getSessionOrderByList() == "" && $defaultSortList != "") {
                $this->setSessionOrderByList($defaultSortList);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->weaving_works, $ctrl); // weaving_works
            $this->updateSort($this->current_works, $ctrl); // current_works
            $this->updateSort($this->po, $ctrl); // po
            $this->updateSort($this->_barcode, $ctrl); // barcode
            $this->updateSort($this->buyers_id, $ctrl); // buyers_id
            $this->updateSort($this->buyer_ref, $ctrl); // buyer_ref
            $this->updateSort($this->design_id, $ctrl); // design_id
            $this->updateSort($this->batch_no, $ctrl); // batch_no
            $this->updateSort($this->sqm, $ctrl); // sqm
            $this->updateSort($this->shape, $ctrl); // shape
            $this->updateSort($this->cs, $ctrl); // cs
            $this->updateSort($this->product_type, $ctrl); // product_type
            $this->updateSort($this->size_cm, $ctrl); // size_cm
            $this->updateSort($this->buyer_uid, $ctrl); // buyer_uid
            $this->updateSort($this->buyer_loc, $ctrl); // buyer_loc
            $this->updateSort($this->quantity, $ctrl); // quantity
            $this->updateSort($this->po_price, $ctrl); // po_price
            $this->updateSort($this->despatch_week, $ctrl); // despatch_week
            $this->updateSort($this->despatch_date, $ctrl); // despatch_date
            $this->updateSort($this->status, $ctrl); // status
            $this->updateSort($this->completed, $ctrl); // completed
            $this->updateSort($this->buyer_po, $ctrl); // buyer_po
            $this->updateSort($this->jc_no, $ctrl); // jc_no
            $this->updateSort($this->process_d, $ctrl); // process_d
            $this->updateSort($this->weight, $ctrl); // weight
            $this->updateSort($this->po_currency, $ctrl); // po_currency
            $this->updateSort($this->dispatch_week_p, $ctrl); // dispatch_week_p
            $this->updateSort($this->remarks, $ctrl); // remarks
            $this->updateSort($this->pl_no, $ctrl); // pl_no
            $this->updateSort($this->category, $ctrl); // category
            $this->updateSort($this->roll_no, $ctrl); // roll_no
            $this->updateSort($this->buyer_barcode, $ctrl); // buyer_barcode
            $this->updateSort($this->q_sku, $ctrl); // q_sku
            $this->updateSort($this->sqm_u, $ctrl); // sqm_u
            $this->updateSort($this->po_discount, $ctrl); // po_discount
            $this->updateSort($this->_11, $ctrl); // 11
            $this->updateSort($this->_12, $ctrl); // 12
            $this->updateSort($this->_13, $ctrl); // 13
            $this->updateSort($this->_14, $ctrl); // 14
            $this->updateSort($this->_15, $ctrl); // 15
            $this->updateSort($this->_16, $ctrl); // 16
            $this->updateSort($this->_17, $ctrl); // 17
            $this->updateSort($this->_18, $ctrl); // 18
            $this->updateSort($this->_19, $ctrl); // 19
            $this->updateSort($this->_20, $ctrl); // 20
            $this->updateSort($this->_21, $ctrl); // 21
            $this->updateSort($this->_22, $ctrl); // 22
            $this->updateSort($this->_23, $ctrl); // 23
            $this->updateSort($this->_24, $ctrl); // 24
            $this->updateSort($this->_25, $ctrl); // 25
            $this->updateSort($this->_26, $ctrl); // 26
            $this->updateSort($this->_27, $ctrl); // 27
            $this->updateSort($this->_28, $ctrl); // 28
            $this->updateSort($this->_29, $ctrl); // 29
            $this->updateSort($this->_30, $ctrl); // 30
            $this->updateSort($this->_31, $ctrl); // 31
            $this->updateSort($this->_32, $ctrl); // 32
            $this->updateSort($this->_33, $ctrl); // 33
            $this->updateSort($this->_34, $ctrl); // 34
            $this->updateSort($this->_35, $ctrl); // 35
            $this->updateSort($this->_36, $ctrl); // 36
            $this->updateSort($this->_37, $ctrl); // 37
            $this->updateSort($this->_38, $ctrl); // 38
            $this->updateSort($this->_39, $ctrl); // 39
            $this->updateSort($this->_40, $ctrl); // 40
            $this->updateSort($this->_41, $ctrl); // 41
            $this->updateSort($this->_42, $ctrl); // 42
            $this->updateSort($this->_43, $ctrl); // 43
            $this->updateSort($this->_44, $ctrl); // 44
            $this->updateSort($this->_45, $ctrl); // 45
            $this->updateSort($this->_46, $ctrl); // 46
            $this->updateSort($this->_47, $ctrl); // 47
            $this->updateSort($this->_48, $ctrl); // 48
            $this->updateSort($this->_49, $ctrl); // 49
            $this->updateSort($this->_50, $ctrl); // 50
            $this->updateSort($this->order_date, $ctrl); // order_date
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->setSessionOrderByList($orderBy);
                $this->id->setSort("");
                $this->pid->setSort("");
                $this->grp->setSort("");
                $this->s_grp->setSort("");
                $this->weaving_works->setSort("");
                $this->current_works->setSort("");
                $this->po->setSort("");
                $this->_barcode->setSort("");
                $this->buyers_id->setSort("");
                $this->pp_id->setSort("");
                $this->buyer_ref->setSort("");
                $this->buyer_tid->setSort("");
                $this->design->setSort("");
                $this->design_id->setSort("");
                $this->batch_no->setSort("");
                $this->l_cm->setSort("");
                $this->w_cm->setSort("");
                $this->sqm->setSort("");
                $this->sqm_a->setSort("");
                $this->_2srm->setSort("");
                $this->_2srm_a->setSort("");
                $this->_4srm->setSort("");
                $this->_4srm_a->setSort("");
                $this->shape->setSort("");
                $this->cs->setSort("");
                $this->product_type->setSort("");
                $this->size_cm->setSort("");
                $this->size_buyer->setSort("");
                $this->buyer_uid->setSort("");
                $this->buyer_loc->setSort("");
                $this->quantity->setSort("");
                $this->po_price->setSort("");
                $this->despatch_week->setSort("");
                $this->despatch_date->setSort("");
                $this->payment_plan->setSort("");
                $this->production_plan->setSort("");
                $this->status->setSort("");
                $this->completed->setSort("");
                $this->buyer_po->setSort("");
                $this->jc_no->setSort("");
                $this->process->setSort("");
                $this->process_c->setSort("");
                $this->process_d->setSort("");
                $this->weight->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->po_currency->setSort("");
                $this->dispatch_week_p->setSort("");
                $this->remarks->setSort("");
                $this->pl_no->setSort("");
                $this->category->setSort("");
                $this->roll_no->setSort("");
                $this->qty->setSort("");
                $this->consignee->setSort("");
                $this->buyer_barcode->setSort("");
                $this->design_next->setSort("");
                $this->q_sku->setSort("");
                $this->sqm_u->setSort("");
                $this->po_discount->setSort("");
                $this->loom_plan->setSort("");
                $this->_11->setSort("");
                $this->_12->setSort("");
                $this->_13->setSort("");
                $this->_14->setSort("");
                $this->_15->setSort("");
                $this->_16->setSort("");
                $this->_17->setSort("");
                $this->_18->setSort("");
                $this->_19->setSort("");
                $this->_20->setSort("");
                $this->_21->setSort("");
                $this->_22->setSort("");
                $this->_23->setSort("");
                $this->_24->setSort("");
                $this->_25->setSort("");
                $this->_26->setSort("");
                $this->_27->setSort("");
                $this->_28->setSort("");
                $this->_29->setSort("");
                $this->_30->setSort("");
                $this->_31->setSort("");
                $this->_32->setSort("");
                $this->_33->setSort("");
                $this->_34->setSort("");
                $this->_35->setSort("");
                $this->_36->setSort("");
                $this->_37->setSort("");
                $this->_38->setSort("");
                $this->_39->setSort("");
                $this->_40->setSort("");
                $this->_41->setSort("");
                $this->_42->setSort("");
                $this->_43->setSort("");
                $this->_44->setSort("");
                $this->_45->setSort("");
                $this->_46->setSort("");
                $this->_47->setSort("");
                $this->_48->setSort("");
                $this->_49->setSort("");
                $this->_50->setSort("");
                $this->c_sqm->setSort("");
                $this->packing_type->setSort("");
                $this->order_date->setSort("");
                $this->qc_weaving->setSort("");
                $this->p_remarks->setSort("");
                $this->roll_no_qty_tmp->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"bcode_old\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fbcode_oldlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fbcode_oldlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "weaving_works");
            $this->createColumnOption($option, "current_works");
            $this->createColumnOption($option, "po");
            $this->createColumnOption($option, "barcode");
            $this->createColumnOption($option, "buyers_id");
            $this->createColumnOption($option, "buyer_ref");
            $this->createColumnOption($option, "design_id");
            $this->createColumnOption($option, "batch_no");
            $this->createColumnOption($option, "sqm");
            $this->createColumnOption($option, "shape");
            $this->createColumnOption($option, "cs");
            $this->createColumnOption($option, "product_type");
            $this->createColumnOption($option, "size_cm");
            $this->createColumnOption($option, "buyer_uid");
            $this->createColumnOption($option, "buyer_loc");
            $this->createColumnOption($option, "quantity");
            $this->createColumnOption($option, "po_price");
            $this->createColumnOption($option, "despatch_week");
            $this->createColumnOption($option, "despatch_date");
            $this->createColumnOption($option, "status");
            $this->createColumnOption($option, "completed");
            $this->createColumnOption($option, "buyer_po");
            $this->createColumnOption($option, "jc_no");
            $this->createColumnOption($option, "process_d");
            $this->createColumnOption($option, "weight");
            $this->createColumnOption($option, "po_currency");
            $this->createColumnOption($option, "dispatch_week_p");
            $this->createColumnOption($option, "remarks");
            $this->createColumnOption($option, "pl_no");
            $this->createColumnOption($option, "category");
            $this->createColumnOption($option, "roll_no");
            $this->createColumnOption($option, "buyer_barcode");
            $this->createColumnOption($option, "q_sku");
            $this->createColumnOption($option, "sqm_u");
            $this->createColumnOption($option, "po_discount");
            $this->createColumnOption($option, "11");
            $this->createColumnOption($option, "12");
            $this->createColumnOption($option, "13");
            $this->createColumnOption($option, "14");
            $this->createColumnOption($option, "15");
            $this->createColumnOption($option, "16");
            $this->createColumnOption($option, "17");
            $this->createColumnOption($option, "18");
            $this->createColumnOption($option, "19");
            $this->createColumnOption($option, "20");
            $this->createColumnOption($option, "21");
            $this->createColumnOption($option, "22");
            $this->createColumnOption($option, "23");
            $this->createColumnOption($option, "24");
            $this->createColumnOption($option, "25");
            $this->createColumnOption($option, "26");
            $this->createColumnOption($option, "27");
            $this->createColumnOption($option, "28");
            $this->createColumnOption($option, "29");
            $this->createColumnOption($option, "30");
            $this->createColumnOption($option, "31");
            $this->createColumnOption($option, "32");
            $this->createColumnOption($option, "33");
            $this->createColumnOption($option, "34");
            $this->createColumnOption($option, "35");
            $this->createColumnOption($option, "36");
            $this->createColumnOption($option, "37");
            $this->createColumnOption($option, "38");
            $this->createColumnOption($option, "39");
            $this->createColumnOption($option, "40");
            $this->createColumnOption($option, "41");
            $this->createColumnOption($option, "42");
            $this->createColumnOption($option, "43");
            $this->createColumnOption($option, "44");
            $this->createColumnOption($option, "45");
            $this->createColumnOption($option, "46");
            $this->createColumnOption($option, "47");
            $this->createColumnOption($option, "48");
            $this->createColumnOption($option, "49");
            $this->createColumnOption($option, "50");
            $this->createColumnOption($option, "order_date");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fbcode_oldsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fbcode_oldsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fbcode_oldlist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_bcode_old", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_bcode_old",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pid
        if ($this->pid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pid->AdvancedSearch->SearchValue != "" || $this->pid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // weaving_works
        if ($this->weaving_works->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->weaving_works->AdvancedSearch->SearchValue != "" || $this->weaving_works->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // current_works
        if ($this->current_works->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->current_works->AdvancedSearch->SearchValue != "" || $this->current_works->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po
        if ($this->po->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po->AdvancedSearch->SearchValue != "" || $this->po->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_barcode->AdvancedSearch->SearchValue != "" || $this->_barcode->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyers_id
        if ($this->buyers_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyers_id->AdvancedSearch->SearchValue != "" || $this->buyers_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pp_id
        if ($this->pp_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pp_id->AdvancedSearch->SearchValue != "" || $this->pp_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_ref
        if ($this->buyer_ref->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_ref->AdvancedSearch->SearchValue != "" || $this->buyer_ref->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // design_id
        if ($this->design_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->design_id->AdvancedSearch->SearchValue != "" || $this->design_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // batch_no
        if ($this->batch_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->batch_no->AdvancedSearch->SearchValue != "" || $this->batch_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sqm->AdvancedSearch->SearchValue != "" || $this->sqm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // shape
        if ($this->shape->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->shape->AdvancedSearch->SearchValue != "" || $this->shape->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cs
        if ($this->cs->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cs->AdvancedSearch->SearchValue != "" || $this->cs->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product_type
        if ($this->product_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product_type->AdvancedSearch->SearchValue != "" || $this->product_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // size_cm
        if ($this->size_cm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->size_cm->AdvancedSearch->SearchValue != "" || $this->size_cm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // size_buyer
        if ($this->size_buyer->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->size_buyer->AdvancedSearch->SearchValue != "" || $this->size_buyer->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_uid
        if ($this->buyer_uid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_uid->AdvancedSearch->SearchValue != "" || $this->buyer_uid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_loc
        if ($this->buyer_loc->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_loc->AdvancedSearch->SearchValue != "" || $this->buyer_loc->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->quantity->AdvancedSearch->SearchValue != "" || $this->quantity->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_price
        if ($this->po_price->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_price->AdvancedSearch->SearchValue != "" || $this->po_price->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // despatch_week
        if ($this->despatch_week->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->despatch_week->AdvancedSearch->SearchValue != "" || $this->despatch_week->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // despatch_date
        if ($this->despatch_date->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->despatch_date->AdvancedSearch->SearchValue != "" || $this->despatch_date->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // payment_plan
        if ($this->payment_plan->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->payment_plan->AdvancedSearch->SearchValue != "" || $this->payment_plan->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // production_plan
        if ($this->production_plan->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->production_plan->AdvancedSearch->SearchValue != "" || $this->production_plan->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status->AdvancedSearch->SearchValue != "" || $this->status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // completed
        if ($this->completed->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->completed->AdvancedSearch->SearchValue != "" || $this->completed->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_po
        if ($this->buyer_po->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_po->AdvancedSearch->SearchValue != "" || $this->buyer_po->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // jc_no
        if ($this->jc_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->jc_no->AdvancedSearch->SearchValue != "" || $this->jc_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // process_d
        if ($this->process_d->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->process_d->AdvancedSearch->SearchValue != "" || $this->process_d->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->process_d->AdvancedSearch->SearchValue)) {
            $this->process_d->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process_d->AdvancedSearch->SearchValue);
        }
        if (is_array($this->process_d->AdvancedSearch->SearchValue2)) {
            $this->process_d->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process_d->AdvancedSearch->SearchValue2);
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_currency
        if ($this->po_currency->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_currency->AdvancedSearch->SearchValue != "" || $this->po_currency->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // dispatch_week_p
        if ($this->dispatch_week_p->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->dispatch_week_p->AdvancedSearch->SearchValue != "" || $this->dispatch_week_p->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->remarks->AdvancedSearch->SearchValue != "" || $this->remarks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pl_no
        if ($this->pl_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pl_no->AdvancedSearch->SearchValue != "" || $this->pl_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->category->AdvancedSearch->SearchValue != "" || $this->category->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // roll_no
        if ($this->roll_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->roll_no->AdvancedSearch->SearchValue != "" || $this->roll_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty
        if ($this->qty->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty->AdvancedSearch->SearchValue != "" || $this->qty->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // q_sku
        if ($this->q_sku->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->q_sku->AdvancedSearch->SearchValue != "" || $this->q_sku->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sqm_u
        if ($this->sqm_u->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sqm_u->AdvancedSearch->SearchValue != "" || $this->sqm_u->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_discount
        if ($this->po_discount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_discount->AdvancedSearch->SearchValue != "" || $this->po_discount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 11
        if ($this->_11->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_11->AdvancedSearch->SearchValue != "" || $this->_11->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 12
        if ($this->_12->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_12->AdvancedSearch->SearchValue != "" || $this->_12->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 13
        if ($this->_13->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_13->AdvancedSearch->SearchValue != "" || $this->_13->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 14
        if ($this->_14->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_14->AdvancedSearch->SearchValue != "" || $this->_14->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 15
        if ($this->_15->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_15->AdvancedSearch->SearchValue != "" || $this->_15->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 16
        if ($this->_16->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_16->AdvancedSearch->SearchValue != "" || $this->_16->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 17
        if ($this->_17->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_17->AdvancedSearch->SearchValue != "" || $this->_17->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 18
        if ($this->_18->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_18->AdvancedSearch->SearchValue != "" || $this->_18->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 19
        if ($this->_19->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_19->AdvancedSearch->SearchValue != "" || $this->_19->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 20
        if ($this->_20->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_20->AdvancedSearch->SearchValue != "" || $this->_20->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 21
        if ($this->_21->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_21->AdvancedSearch->SearchValue != "" || $this->_21->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 22
        if ($this->_22->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_22->AdvancedSearch->SearchValue != "" || $this->_22->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 23
        if ($this->_23->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_23->AdvancedSearch->SearchValue != "" || $this->_23->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 24
        if ($this->_24->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_24->AdvancedSearch->SearchValue != "" || $this->_24->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 25
        if ($this->_25->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_25->AdvancedSearch->SearchValue != "" || $this->_25->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 26
        if ($this->_26->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_26->AdvancedSearch->SearchValue != "" || $this->_26->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 27
        if ($this->_27->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_27->AdvancedSearch->SearchValue != "" || $this->_27->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 28
        if ($this->_28->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_28->AdvancedSearch->SearchValue != "" || $this->_28->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 29
        if ($this->_29->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_29->AdvancedSearch->SearchValue != "" || $this->_29->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 30
        if ($this->_30->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_30->AdvancedSearch->SearchValue != "" || $this->_30->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 31
        if ($this->_31->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_31->AdvancedSearch->SearchValue != "" || $this->_31->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 32
        if ($this->_32->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_32->AdvancedSearch->SearchValue != "" || $this->_32->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 33
        if ($this->_33->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_33->AdvancedSearch->SearchValue != "" || $this->_33->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 34
        if ($this->_34->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_34->AdvancedSearch->SearchValue != "" || $this->_34->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 35
        if ($this->_35->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_35->AdvancedSearch->SearchValue != "" || $this->_35->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 36
        if ($this->_36->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_36->AdvancedSearch->SearchValue != "" || $this->_36->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 37
        if ($this->_37->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_37->AdvancedSearch->SearchValue != "" || $this->_37->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 38
        if ($this->_38->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_38->AdvancedSearch->SearchValue != "" || $this->_38->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 39
        if ($this->_39->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_39->AdvancedSearch->SearchValue != "" || $this->_39->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 40
        if ($this->_40->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_40->AdvancedSearch->SearchValue != "" || $this->_40->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 41
        if ($this->_41->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_41->AdvancedSearch->SearchValue != "" || $this->_41->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 42
        if ($this->_42->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_42->AdvancedSearch->SearchValue != "" || $this->_42->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 43
        if ($this->_43->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_43->AdvancedSearch->SearchValue != "" || $this->_43->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 44
        if ($this->_44->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_44->AdvancedSearch->SearchValue != "" || $this->_44->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 45
        if ($this->_45->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_45->AdvancedSearch->SearchValue != "" || $this->_45->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 46
        if ($this->_46->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_46->AdvancedSearch->SearchValue != "" || $this->_46->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 47
        if ($this->_47->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_47->AdvancedSearch->SearchValue != "" || $this->_47->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 48
        if ($this->_48->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_48->AdvancedSearch->SearchValue != "" || $this->_48->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 49
        if ($this->_49->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_49->AdvancedSearch->SearchValue != "" || $this->_49->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 50
        if ($this->_50->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_50->AdvancedSearch->SearchValue != "" || $this->_50->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->pid->setDbValue($row['pid']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->current_works->setDbValue($row['current_works']);
        $this->po->setDbValue($row['po']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->pp_id->setDbValue($row['pp_id']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        if (array_key_exists('EV__buyer_ref', $row)) {
            $this->buyer_ref->VirtualValue = $row['EV__buyer_ref']; // Set up virtual field value
        } else {
            $this->buyer_ref->VirtualValue = ""; // Clear value
        }
        $this->buyer_tid->setDbValue($row['buyer_tid']);
        $this->design->setDbValue($row['design']);
        $this->design_id->setDbValue($row['design_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->_2srm->setDbValue($row['2srm']);
        $this->_2srm_a->setDbValue($row['2srm_a']);
        $this->_4srm->setDbValue($row['4srm']);
        $this->_4srm_a->setDbValue($row['4srm_a']);
        $this->shape->setDbValue($row['shape']);
        $this->cs->setDbValue($row['cs']);
        $this->product_type->setDbValue($row['product_type']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->size_buyer->setDbValue($row['size_buyer']);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->quantity->setDbValue($row['quantity']);
        $this->po_price->setDbValue($row['po_price']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->payment_plan->setDbValue($row['payment_plan']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->status->setDbValue($row['status']);
        $this->completed->setDbValue($row['completed']);
        $this->buyer_po->setDbValue($row['buyer_po']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->process->setDbValue($row['process']);
        $this->process_c->setDbValue($row['process_c']);
        $this->process_d->setDbValue($row['process_d']);
        $this->weight->setDbValue($row['weight']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->po_currency->setDbValue($row['po_currency']);
        $this->dispatch_week_p->setDbValue($row['dispatch_week_p']);
        $this->remarks->setDbValue($row['remarks']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->category->setDbValue($row['category']);
        $this->roll_no->setDbValue($row['roll_no']);
        $this->qty->setDbValue($row['qty']);
        $this->consignee->setDbValue($row['consignee']);
        $this->buyer_barcode->setDbValue($row['buyer_barcode']);
        $this->design_next->setDbValue($row['design_next']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->sqm_u->setDbValue($row['sqm_u']);
        $this->po_discount->setDbValue($row['po_discount']);
        $this->loom_plan->setDbValue($row['loom_plan']);
        $this->_11->setDbValue($row['11']);
        $this->_12->setDbValue($row['12']);
        $this->_13->setDbValue($row['13']);
        $this->_14->setDbValue($row['14']);
        $this->_15->setDbValue($row['15']);
        $this->_16->setDbValue($row['16']);
        $this->_17->setDbValue($row['17']);
        $this->_18->setDbValue($row['18']);
        $this->_19->setDbValue($row['19']);
        $this->_20->setDbValue($row['20']);
        $this->_21->setDbValue($row['21']);
        $this->_22->setDbValue($row['22']);
        $this->_23->setDbValue($row['23']);
        $this->_24->setDbValue($row['24']);
        $this->_25->setDbValue($row['25']);
        $this->_26->setDbValue($row['26']);
        $this->_27->setDbValue($row['27']);
        $this->_28->setDbValue($row['28']);
        $this->_29->setDbValue($row['29']);
        $this->_30->setDbValue($row['30']);
        $this->_31->setDbValue($row['31']);
        $this->_32->setDbValue($row['32']);
        $this->_33->setDbValue($row['33']);
        $this->_34->setDbValue($row['34']);
        $this->_35->setDbValue($row['35']);
        $this->_36->setDbValue($row['36']);
        $this->_37->setDbValue($row['37']);
        $this->_38->setDbValue($row['38']);
        $this->_39->setDbValue($row['39']);
        $this->_40->setDbValue($row['40']);
        $this->_41->setDbValue($row['41']);
        $this->_42->setDbValue($row['42']);
        $this->_43->setDbValue($row['43']);
        $this->_44->setDbValue($row['44']);
        $this->_45->setDbValue($row['45']);
        $this->_46->setDbValue($row['46']);
        $this->_47->setDbValue($row['47']);
        $this->_48->setDbValue($row['48']);
        $this->_49->setDbValue($row['49']);
        $this->_50->setDbValue($row['50']);
        $this->c_sqm->setDbValue($row['c_sqm']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->order_date->setDbValue($row['order_date']);
        $this->qc_weaving->setDbValue($row['qc_weaving']);
        $this->p_remarks->setDbValue($row['p_remarks']);
        $this->roll_no_qty_tmp->setDbValue($row['roll_no_qty_tmp']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['pid'] = $this->pid->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['weaving_works'] = $this->weaving_works->DefaultValue;
        $row['current_works'] = $this->current_works->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['buyers_id'] = $this->buyers_id->DefaultValue;
        $row['pp_id'] = $this->pp_id->DefaultValue;
        $row['buyer_ref'] = $this->buyer_ref->DefaultValue;
        $row['buyer_tid'] = $this->buyer_tid->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['design_id'] = $this->design_id->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['sqm_a'] = $this->sqm_a->DefaultValue;
        $row['2srm'] = $this->_2srm->DefaultValue;
        $row['2srm_a'] = $this->_2srm_a->DefaultValue;
        $row['4srm'] = $this->_4srm->DefaultValue;
        $row['4srm_a'] = $this->_4srm_a->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['cs'] = $this->cs->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['size_cm'] = $this->size_cm->DefaultValue;
        $row['size_buyer'] = $this->size_buyer->DefaultValue;
        $row['buyer_uid'] = $this->buyer_uid->DefaultValue;
        $row['buyer_loc'] = $this->buyer_loc->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['po_price'] = $this->po_price->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['payment_plan'] = $this->payment_plan->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['completed'] = $this->completed->DefaultValue;
        $row['buyer_po'] = $this->buyer_po->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['process_c'] = $this->process_c->DefaultValue;
        $row['process_d'] = $this->process_d->DefaultValue;
        $row['weight'] = $this->weight->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['po_currency'] = $this->po_currency->DefaultValue;
        $row['dispatch_week_p'] = $this->dispatch_week_p->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['pl_no'] = $this->pl_no->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['roll_no'] = $this->roll_no->DefaultValue;
        $row['qty'] = $this->qty->DefaultValue;
        $row['consignee'] = $this->consignee->DefaultValue;
        $row['buyer_barcode'] = $this->buyer_barcode->DefaultValue;
        $row['design_next'] = $this->design_next->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['sqm_u'] = $this->sqm_u->DefaultValue;
        $row['po_discount'] = $this->po_discount->DefaultValue;
        $row['loom_plan'] = $this->loom_plan->DefaultValue;
        $row['11'] = $this->_11->DefaultValue;
        $row['12'] = $this->_12->DefaultValue;
        $row['13'] = $this->_13->DefaultValue;
        $row['14'] = $this->_14->DefaultValue;
        $row['15'] = $this->_15->DefaultValue;
        $row['16'] = $this->_16->DefaultValue;
        $row['17'] = $this->_17->DefaultValue;
        $row['18'] = $this->_18->DefaultValue;
        $row['19'] = $this->_19->DefaultValue;
        $row['20'] = $this->_20->DefaultValue;
        $row['21'] = $this->_21->DefaultValue;
        $row['22'] = $this->_22->DefaultValue;
        $row['23'] = $this->_23->DefaultValue;
        $row['24'] = $this->_24->DefaultValue;
        $row['25'] = $this->_25->DefaultValue;
        $row['26'] = $this->_26->DefaultValue;
        $row['27'] = $this->_27->DefaultValue;
        $row['28'] = $this->_28->DefaultValue;
        $row['29'] = $this->_29->DefaultValue;
        $row['30'] = $this->_30->DefaultValue;
        $row['31'] = $this->_31->DefaultValue;
        $row['32'] = $this->_32->DefaultValue;
        $row['33'] = $this->_33->DefaultValue;
        $row['34'] = $this->_34->DefaultValue;
        $row['35'] = $this->_35->DefaultValue;
        $row['36'] = $this->_36->DefaultValue;
        $row['37'] = $this->_37->DefaultValue;
        $row['38'] = $this->_38->DefaultValue;
        $row['39'] = $this->_39->DefaultValue;
        $row['40'] = $this->_40->DefaultValue;
        $row['41'] = $this->_41->DefaultValue;
        $row['42'] = $this->_42->DefaultValue;
        $row['43'] = $this->_43->DefaultValue;
        $row['44'] = $this->_44->DefaultValue;
        $row['45'] = $this->_45->DefaultValue;
        $row['46'] = $this->_46->DefaultValue;
        $row['47'] = $this->_47->DefaultValue;
        $row['48'] = $this->_48->DefaultValue;
        $row['49'] = $this->_49->DefaultValue;
        $row['50'] = $this->_50->DefaultValue;
        $row['c_sqm'] = $this->c_sqm->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['order_date'] = $this->order_date->DefaultValue;
        $row['qc_weaving'] = $this->qc_weaving->DefaultValue;
        $row['p_remarks'] = $this->p_remarks->DefaultValue;
        $row['roll_no_qty_tmp'] = $this->roll_no_qty_tmp->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // pid

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // weaving_works
        $this->weaving_works->CellCssStyle = "white-space: nowrap;";

        // current_works
        $this->current_works->CellCssStyle = "white-space: nowrap;";

        // po

        // barcode
        $this->_barcode->CellCssStyle = "min-width: 300px;";

        // buyers_id

        // pp_id

        // buyer_ref

        // buyer_tid
        $this->buyer_tid->CellCssStyle = "white-space: nowrap;";

        // design
        $this->design->CellCssStyle = "white-space: nowrap;";

        // design_id

        // batch_no

        // l_cm
        $this->l_cm->CellCssStyle = "white-space: nowrap;";

        // w_cm
        $this->w_cm->CellCssStyle = "white-space: nowrap;";

        // sqm

        // sqm_a
        $this->sqm_a->CellCssStyle = "white-space: nowrap;";

        // 2srm
        $this->_2srm->CellCssStyle = "white-space: nowrap;";

        // 2srm_a
        $this->_2srm_a->CellCssStyle = "white-space: nowrap;";

        // 4srm
        $this->_4srm->CellCssStyle = "white-space: nowrap;";

        // 4srm_a
        $this->_4srm_a->CellCssStyle = "white-space: nowrap;";

        // shape

        // cs

        // product_type

        // size_cm

        // size_buyer

        // buyer_uid
        $this->buyer_uid->CellCssStyle = "min-width: 200px;";

        // buyer_loc

        // quantity

        // po_price

        // despatch_week

        // despatch_date

        // payment_plan

        // production_plan

        // status

        // completed

        // buyer_po

        // jc_no

        // process

        // process_c

        // process_d

        // weight

        // operator

        // datetime

        // po_currency

        // dispatch_week_p

        // remarks

        // pl_no

        // category

        // roll_no

        // qty

        // consignee
        $this->consignee->CellCssStyle = "white-space: nowrap;";

        // buyer_barcode
        $this->buyer_barcode->CellCssStyle = "white-space: nowrap;";

        // design_next
        $this->design_next->CellCssStyle = "white-space: nowrap;";

        // q_sku

        // sqm_u

        // po_discount

        // loom_plan
        $this->loom_plan->CellCssStyle = "white-space: nowrap;";

        // 11
        $this->_11->CellCssStyle = "white-space: nowrap;";

        // 12
        $this->_12->CellCssStyle = "white-space: nowrap;";

        // 13
        $this->_13->CellCssStyle = "white-space: nowrap;";

        // 14
        $this->_14->CellCssStyle = "white-space: nowrap;";

        // 15
        $this->_15->CellCssStyle = "white-space: nowrap;";

        // 16
        $this->_16->CellCssStyle = "white-space: nowrap;";

        // 17
        $this->_17->CellCssStyle = "white-space: nowrap;";

        // 18
        $this->_18->CellCssStyle = "white-space: nowrap;";

        // 19
        $this->_19->CellCssStyle = "white-space: nowrap;";

        // 20
        $this->_20->CellCssStyle = "white-space: nowrap;";

        // 21
        $this->_21->CellCssStyle = "white-space: nowrap;";

        // 22
        $this->_22->CellCssStyle = "white-space: nowrap;";

        // 23
        $this->_23->CellCssStyle = "white-space: nowrap;";

        // 24
        $this->_24->CellCssStyle = "white-space: nowrap;";

        // 25
        $this->_25->CellCssStyle = "white-space: nowrap;";

        // 26
        $this->_26->CellCssStyle = "white-space: nowrap;";

        // 27
        $this->_27->CellCssStyle = "white-space: nowrap;";

        // 28
        $this->_28->CellCssStyle = "white-space: nowrap;";

        // 29
        $this->_29->CellCssStyle = "white-space: nowrap;";

        // 30
        $this->_30->CellCssStyle = "white-space: nowrap;";

        // 31
        $this->_31->CellCssStyle = "white-space: nowrap;";

        // 32
        $this->_32->CellCssStyle = "white-space: nowrap;";

        // 33
        $this->_33->CellCssStyle = "white-space: nowrap;";

        // 34
        $this->_34->CellCssStyle = "white-space: nowrap;";

        // 35
        $this->_35->CellCssStyle = "white-space: nowrap;";

        // 36
        $this->_36->CellCssStyle = "white-space: nowrap;";

        // 37
        $this->_37->CellCssStyle = "white-space: nowrap;";

        // 38
        $this->_38->CellCssStyle = "white-space: nowrap;";

        // 39
        $this->_39->CellCssStyle = "white-space: nowrap;";

        // 40
        $this->_40->CellCssStyle = "white-space: nowrap;";

        // 41
        $this->_41->CellCssStyle = "white-space: nowrap;";

        // 42
        $this->_42->CellCssStyle = "white-space: nowrap;";

        // 43
        $this->_43->CellCssStyle = "white-space: nowrap;";

        // 44
        $this->_44->CellCssStyle = "white-space: nowrap;";

        // 45
        $this->_45->CellCssStyle = "white-space: nowrap;";

        // 46
        $this->_46->CellCssStyle = "white-space: nowrap;";

        // 47
        $this->_47->CellCssStyle = "white-space: nowrap;";

        // 48
        $this->_48->CellCssStyle = "white-space: nowrap;";

        // 49
        $this->_49->CellCssStyle = "white-space: nowrap;";

        // 50
        $this->_50->CellCssStyle = "white-space: nowrap;";

        // c_sqm

        // packing_type
        $this->packing_type->CellCssStyle = "white-space: nowrap;";

        // order_date

        // qc_weaving
        $this->qc_weaving->CellCssStyle = "white-space: nowrap;";

        // p_remarks

        // roll_no_qty_tmp
        $this->roll_no_qty_tmp->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // pid
            $this->pid->ViewValue = $this->pid->CurrentValue;
            $this->pid->ViewValue = FormatNumber($this->pid->ViewValue, $this->pid->formatPattern());

            // weaving_works
            $curVal = strval($this->weaving_works->CurrentValue);
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
                if ($this->weaving_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                        $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                    } else {
                        $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                    }
                }
            } else {
                $this->weaving_works->ViewValue = null;
            }

            // current_works
            $curVal = strval($this->current_works->CurrentValue);
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
                if ($this->current_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                        $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                    } else {
                        $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                    }
                }
            } else {
                $this->current_works->ViewValue = null;
            }

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // pp_id
            $this->pp_id->ViewValue = $this->pp_id->CurrentValue;
            $curVal = strval($this->pp_id->CurrentValue);
            if ($curVal != "") {
                $this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
                if ($this->pp_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pp_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pp_id->Lookup->renderViewRow($rswrk[0]);
                        $this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
                    } else {
                        $this->pp_id->ViewValue = FormatNumber($this->pp_id->CurrentValue, $this->pp_id->formatPattern());
                    }
                }
            } else {
                $this->pp_id->ViewValue = null;
            }

            // buyer_ref
            if ($this->buyer_ref->VirtualValue != "") {
                $this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
            } else {
                $curVal = strval($this->buyer_ref->CurrentValue);
                if ($curVal != "") {
                    $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
                    if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                            $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                        } else {
                            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                        }
                    }
                } else {
                    $this->buyer_ref->ViewValue = null;
                }
            }

            // design_id
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->ViewValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->ViewValue = null;
            }

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->ViewValue = FormatNumber($this->shape->CurrentValue, $this->shape->formatPattern());
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // cs
            if (strval($this->cs->CurrentValue) != "") {
                $this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
            } else {
                $this->cs->ViewValue = null;
            }

            // product_type
            if (strval($this->product_type->CurrentValue) != "") {
                $this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
            } else {
                $this->product_type->ViewValue = null;
            }

            // size_cm
            $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

            // size_buyer
            $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

            // buyer_uid
            $this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;

            // buyer_loc
            $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // po_price
            $this->po_price->ViewValue = $this->po_price->CurrentValue;

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // payment_plan
            $curVal = strval($this->payment_plan->CurrentValue);
            if ($curVal != "") {
                $this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
                if ($this->payment_plan->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->payment_plan->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_plan->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
                    } else {
                        $this->payment_plan->ViewValue = FormatNumber($this->payment_plan->CurrentValue, $this->payment_plan->formatPattern());
                    }
                }
            } else {
                $this->payment_plan->ViewValue = null;
            }

            // production_plan
            if (strval($this->production_plan->CurrentValue) != "") {
                $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
            } else {
                $this->production_plan->ViewValue = null;
            }

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // completed
            if (strval($this->completed->CurrentValue) != "") {
                $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
            } else {
                $this->completed->ViewValue = null;
            }

            // buyer_po
            $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process->Lookup->renderViewRow($row);
                            $this->process->ViewValue->add($this->process->displayValue($arwrk));
                        }
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // process_c
            $curVal = strval($this->process_c->CurrentValue);
            if ($curVal != "") {
                $this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
                if ($this->process_c->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_c->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_c->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process_c->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_c->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_c->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_c->Lookup->renderViewRow($row);
                            $this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
                        }
                    } else {
                        $this->process_c->ViewValue = $this->process_c->CurrentValue;
                    }
                }
            } else {
                $this->process_c->ViewValue = null;
            }

            // process_d
            $curVal = strval($this->process_d->CurrentValue);
            if ($curVal != "") {
                $this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
                if ($this->process_d->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_d->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_d->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process_d->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_d->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_d->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_d->Lookup->renderViewRow($row);
                            $this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
                        }
                    } else {
                        $this->process_d->ViewValue = $this->process_d->CurrentValue;
                    }
                }
            } else {
                $this->process_d->ViewValue = null;
            }

            // weight
            $this->weight->ViewValue = $this->weight->CurrentValue;
            $this->weight->ViewValue = FormatNumber($this->weight->ViewValue, $this->weight->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // po_currency
            $curVal = strval($this->po_currency->CurrentValue);
            if ($curVal != "") {
                $this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
                if ($this->po_currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_currency->Lookup->renderViewRow($rswrk[0]);
                        $this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
                    } else {
                        $this->po_currency->ViewValue = FormatNumber($this->po_currency->CurrentValue, $this->po_currency->formatPattern());
                    }
                }
            } else {
                $this->po_currency->ViewValue = null;
            }

            // dispatch_week_p
            $curVal = strval($this->dispatch_week_p->CurrentValue);
            if ($curVal != "") {
                $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
                if ($this->dispatch_week_p->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->dispatch_week_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->dispatch_week_p->Lookup->renderViewRow($rswrk[0]);
                        $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
                    } else {
                        $this->dispatch_week_p->ViewValue = FormatNumber($this->dispatch_week_p->CurrentValue, $this->dispatch_week_p->formatPattern());
                    }
                }
            } else {
                $this->dispatch_week_p->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // pl_no
            $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
            $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;
            $this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, $this->roll_no->formatPattern());

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // buyer_barcode
            $this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;
            $this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, $this->q_sku->formatPattern());

            // sqm_u
            $this->sqm_u->ViewValue = $this->sqm_u->CurrentValue;
            $this->sqm_u->ViewValue = FormatNumber($this->sqm_u->ViewValue, $this->sqm_u->formatPattern());

            // po_discount
            $this->po_discount->ViewValue = $this->po_discount->CurrentValue;
            $this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, $this->po_discount->formatPattern());

            // 11
            $this->_11->ViewValue = $this->_11->CurrentValue;

            // 12
            $this->_12->ViewValue = $this->_12->CurrentValue;

            // 13
            $this->_13->ViewValue = $this->_13->CurrentValue;

            // 14
            $this->_14->ViewValue = $this->_14->CurrentValue;

            // 15
            $this->_15->ViewValue = $this->_15->CurrentValue;

            // 16
            $this->_16->ViewValue = $this->_16->CurrentValue;

            // 17
            $this->_17->ViewValue = $this->_17->CurrentValue;

            // 18
            $this->_18->ViewValue = $this->_18->CurrentValue;

            // 19
            $this->_19->ViewValue = $this->_19->CurrentValue;

            // 20
            $this->_20->ViewValue = $this->_20->CurrentValue;

            // 21
            $this->_21->ViewValue = $this->_21->CurrentValue;

            // 22
            $this->_22->ViewValue = $this->_22->CurrentValue;

            // 23
            $this->_23->ViewValue = $this->_23->CurrentValue;

            // 24
            $this->_24->ViewValue = $this->_24->CurrentValue;

            // 25
            $this->_25->ViewValue = $this->_25->CurrentValue;

            // 26
            $this->_26->ViewValue = $this->_26->CurrentValue;

            // 27
            $this->_27->ViewValue = $this->_27->CurrentValue;

            // 28
            $this->_28->ViewValue = $this->_28->CurrentValue;

            // 29
            $this->_29->ViewValue = $this->_29->CurrentValue;

            // 30
            $this->_30->ViewValue = $this->_30->CurrentValue;

            // 31
            $this->_31->ViewValue = $this->_31->CurrentValue;

            // 32
            $this->_32->ViewValue = $this->_32->CurrentValue;

            // 33
            $this->_33->ViewValue = $this->_33->CurrentValue;

            // 34
            $this->_34->ViewValue = $this->_34->CurrentValue;

            // 35
            $this->_35->ViewValue = $this->_35->CurrentValue;

            // 36
            $this->_36->ViewValue = $this->_36->CurrentValue;

            // 37
            $this->_37->ViewValue = $this->_37->CurrentValue;

            // 38
            $this->_38->ViewValue = $this->_38->CurrentValue;

            // 39
            $this->_39->ViewValue = $this->_39->CurrentValue;

            // 40
            $this->_40->ViewValue = $this->_40->CurrentValue;

            // 41
            $this->_41->ViewValue = $this->_41->CurrentValue;

            // 42
            $this->_42->ViewValue = $this->_42->CurrentValue;

            // 43
            $this->_43->ViewValue = $this->_43->CurrentValue;

            // 44
            $this->_44->ViewValue = $this->_44->CurrentValue;

            // 45
            $this->_45->ViewValue = $this->_45->CurrentValue;

            // 46
            $this->_46->ViewValue = $this->_46->CurrentValue;

            // 47
            $this->_47->ViewValue = $this->_47->CurrentValue;

            // 48
            $this->_48->ViewValue = $this->_48->CurrentValue;

            // 49
            $this->_49->ViewValue = $this->_49->CurrentValue;

            // 50
            $this->_50->ViewValue = $this->_50->CurrentValue;

            // c_sqm
            $this->c_sqm->ViewValue = $this->c_sqm->CurrentValue;
            $this->c_sqm->ViewValue = FormatNumber($this->c_sqm->ViewValue, $this->c_sqm->formatPattern());

            // order_date
            $this->order_date->ViewValue = $this->order_date->CurrentValue;
            $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

            // p_remarks
            $this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;

            // weaving_works
            $this->weaving_works->HrefValue = "";
            $this->weaving_works->TooltipValue = "";

            // current_works
            $this->current_works->HrefValue = "";
            $this->current_works->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_barcode->ViewValue = $this->highlightValue($this->_barcode);
            }

            // buyers_id
            if (!EmptyValue($this->buyers_id->CurrentValue)) {
                $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
                $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
                }
            } else {
                $this->buyers_id->HrefValue = "";
            }
            $this->buyers_id->TooltipValue = "";

            // buyer_ref
            if (!EmptyValue($this->buyer_ref->CurrentValue)) {
                $this->buyer_ref->HrefValue = $this->buyer_ref->getLinkPrefix() . $this->buyer_ref->CurrentValue; // Add prefix/suffix
                $this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
                }
            } else {
                $this->buyer_ref->HrefValue = "";
            }
            $this->buyer_ref->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_ref->ViewValue = $this->highlightValue($this->buyer_ref);
            }

            // design_id
            if (!EmptyValue($this->design_id->CurrentValue)) {
                $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . (!empty($this->design_id->ViewValue) && !is_array($this->design_id->ViewValue) ? RemoveHtml($this->design_id->ViewValue) : $this->design_id->CurrentValue); // Add prefix/suffix
                $this->design_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
                }
            } else {
                $this->design_id->HrefValue = "";
            }
            $this->design_id->TooltipValue = "";

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }
            $this->batch_no->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";

            // cs
            $this->cs->HrefValue = "";
            $this->cs->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // size_cm
            $this->size_cm->HrefValue = "";
            $this->size_cm->TooltipValue = "";
            if (!$this->isExport()) {
                $this->size_cm->ViewValue = $this->highlightValue($this->size_cm);
            }

            // buyer_uid
            $this->buyer_uid->HrefValue = "";
            $this->buyer_uid->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_uid->ViewValue = $this->highlightValue($this->buyer_uid);
            }

            // buyer_loc
            $this->buyer_loc->HrefValue = "";
            $this->buyer_loc->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_loc->ViewValue = $this->highlightValue($this->buyer_loc);
            }

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // po_price
            $this->po_price->HrefValue = "";
            $this->po_price->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_price->ViewValue = $this->highlightValue($this->po_price);
            }

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";
            if (!$this->isExport()) {
                $this->despatch_date->ViewValue = $this->highlightValue($this->despatch_date);
            }

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // completed
            $this->completed->HrefValue = "";
            $this->completed->TooltipValue = "";

            // buyer_po
            $this->buyer_po->HrefValue = "";
            $this->buyer_po->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_po->ViewValue = $this->highlightValue($this->buyer_po);
            }

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";

            // process_d
            $this->process_d->HrefValue = "";
            $this->process_d->TooltipValue = "";

            // weight
            $this->weight->HrefValue = "";
            $this->weight->TooltipValue = "";

            // po_currency
            $this->po_currency->HrefValue = "";
            $this->po_currency->TooltipValue = "";

            // dispatch_week_p
            $this->dispatch_week_p->HrefValue = "";
            $this->dispatch_week_p->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";
            if (!$this->isExport()) {
                $this->remarks->ViewValue = $this->highlightValue($this->remarks);
            }

            // pl_no
            $this->pl_no->HrefValue = "";
            $this->pl_no->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // roll_no
            $this->roll_no->HrefValue = "";
            $this->roll_no->TooltipValue = "";

            // buyer_barcode
            $this->buyer_barcode->HrefValue = "";
            $this->buyer_barcode->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_barcode->ViewValue = $this->highlightValue($this->buyer_barcode);
            }

            // q_sku
            $this->q_sku->HrefValue = "";
            $this->q_sku->TooltipValue = "";

            // sqm_u
            $this->sqm_u->HrefValue = "";
            $this->sqm_u->TooltipValue = "";

            // po_discount
            $this->po_discount->HrefValue = "";
            $this->po_discount->TooltipValue = "";

            // 11
            $this->_11->HrefValue = "";
            $this->_11->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_11->ViewValue = $this->highlightValue($this->_11);
            }

            // 12
            $this->_12->HrefValue = "";
            $this->_12->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_12->ViewValue = $this->highlightValue($this->_12);
            }

            // 13
            $this->_13->HrefValue = "";
            $this->_13->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_13->ViewValue = $this->highlightValue($this->_13);
            }

            // 14
            $this->_14->HrefValue = "";
            $this->_14->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_14->ViewValue = $this->highlightValue($this->_14);
            }

            // 15
            $this->_15->HrefValue = "";
            $this->_15->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_15->ViewValue = $this->highlightValue($this->_15);
            }

            // 16
            $this->_16->HrefValue = "";
            $this->_16->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_16->ViewValue = $this->highlightValue($this->_16);
            }

            // 17
            $this->_17->HrefValue = "";
            $this->_17->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_17->ViewValue = $this->highlightValue($this->_17);
            }

            // 18
            $this->_18->HrefValue = "";
            $this->_18->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_18->ViewValue = $this->highlightValue($this->_18);
            }

            // 19
            $this->_19->HrefValue = "";
            $this->_19->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_19->ViewValue = $this->highlightValue($this->_19);
            }

            // 20
            $this->_20->HrefValue = "";
            $this->_20->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_20->ViewValue = $this->highlightValue($this->_20);
            }

            // 21
            $this->_21->HrefValue = "";
            $this->_21->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_21->ViewValue = $this->highlightValue($this->_21);
            }

            // 22
            $this->_22->HrefValue = "";
            $this->_22->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_22->ViewValue = $this->highlightValue($this->_22);
            }

            // 23
            $this->_23->HrefValue = "";
            $this->_23->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_23->ViewValue = $this->highlightValue($this->_23);
            }

            // 24
            $this->_24->HrefValue = "";
            $this->_24->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_24->ViewValue = $this->highlightValue($this->_24);
            }

            // 25
            $this->_25->HrefValue = "";
            $this->_25->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_25->ViewValue = $this->highlightValue($this->_25);
            }

            // 26
            $this->_26->HrefValue = "";
            $this->_26->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_26->ViewValue = $this->highlightValue($this->_26);
            }

            // 27
            $this->_27->HrefValue = "";
            $this->_27->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_27->ViewValue = $this->highlightValue($this->_27);
            }

            // 28
            $this->_28->HrefValue = "";
            $this->_28->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_28->ViewValue = $this->highlightValue($this->_28);
            }

            // 29
            $this->_29->HrefValue = "";
            $this->_29->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_29->ViewValue = $this->highlightValue($this->_29);
            }

            // 30
            $this->_30->HrefValue = "";
            $this->_30->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_30->ViewValue = $this->highlightValue($this->_30);
            }

            // 31
            $this->_31->HrefValue = "";
            $this->_31->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_31->ViewValue = $this->highlightValue($this->_31);
            }

            // 32
            $this->_32->HrefValue = "";
            $this->_32->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_32->ViewValue = $this->highlightValue($this->_32);
            }

            // 33
            $this->_33->HrefValue = "";
            $this->_33->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_33->ViewValue = $this->highlightValue($this->_33);
            }

            // 34
            $this->_34->HrefValue = "";
            $this->_34->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_34->ViewValue = $this->highlightValue($this->_34);
            }

            // 35
            $this->_35->HrefValue = "";
            $this->_35->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_35->ViewValue = $this->highlightValue($this->_35);
            }

            // 36
            $this->_36->HrefValue = "";
            $this->_36->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_36->ViewValue = $this->highlightValue($this->_36);
            }

            // 37
            $this->_37->HrefValue = "";
            $this->_37->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_37->ViewValue = $this->highlightValue($this->_37);
            }

            // 38
            $this->_38->HrefValue = "";
            $this->_38->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_38->ViewValue = $this->highlightValue($this->_38);
            }

            // 39
            $this->_39->HrefValue = "";
            $this->_39->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_39->ViewValue = $this->highlightValue($this->_39);
            }

            // 40
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_40->ViewValue = $this->highlightValue($this->_40);
            }

            // 41
            $this->_41->HrefValue = "";
            $this->_41->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_41->ViewValue = $this->highlightValue($this->_41);
            }

            // 42
            $this->_42->HrefValue = "";
            $this->_42->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_42->ViewValue = $this->highlightValue($this->_42);
            }

            // 43
            $this->_43->HrefValue = "";
            $this->_43->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_43->ViewValue = $this->highlightValue($this->_43);
            }

            // 44
            $this->_44->HrefValue = "";
            $this->_44->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_44->ViewValue = $this->highlightValue($this->_44);
            }

            // 45
            $this->_45->HrefValue = "";
            $this->_45->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_45->ViewValue = $this->highlightValue($this->_45);
            }

            // 46
            $this->_46->HrefValue = "";
            $this->_46->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_46->ViewValue = $this->highlightValue($this->_46);
            }

            // 47
            $this->_47->HrefValue = "";
            $this->_47->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_47->ViewValue = $this->highlightValue($this->_47);
            }

            // 48
            $this->_48->HrefValue = "";
            $this->_48->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_48->ViewValue = $this->highlightValue($this->_48);
            }

            // 49
            $this->_49->HrefValue = "";
            $this->_49->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_49->ViewValue = $this->highlightValue($this->_49);
            }

            // 50
            $this->_50->HrefValue = "";
            $this->_50->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_50->ViewValue = $this->highlightValue($this->_50);
            }

            // order_date
            $this->order_date->HrefValue = "";
            $this->order_date->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // weaving_works
            $this->weaving_works->setupEditAttributes();
            $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

            // current_works
            $this->current_works->setupEditAttributes();
            $curVal = trim(strval($this->current_works->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->current_works->AdvancedSearch->ViewValue = $this->current_works->lookupCacheOption($curVal);
            } else {
                $this->current_works->AdvancedSearch->ViewValue = $this->current_works->Lookup !== null && is_array($this->current_works->lookupOptions()) && count($this->current_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->current_works->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->current_works->EditValue = array_values($this->current_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->current_works->AdvancedSearch->SearchValue, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->current_works->EditValue = $arwrk;
            }
            $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->AdvancedSearch->SearchValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());
            $this->po->setupEditAttributes();
            $this->po->EditValue2 = $this->po->AdvancedSearch->SearchValue2;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue = $this->_barcode->AdvancedSearch->SearchValue;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue2 = $this->_barcode->AdvancedSearch->SearchValue2;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // buyers_id
            $this->buyers_id->setupEditAttributes();
            $this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

            // buyer_ref
            $this->buyer_ref->setupEditAttributes();
            $this->buyer_ref->EditValue = $this->buyer_ref->AdvancedSearch->SearchValue;
            $this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

            // design_id
            $this->design_id->setupEditAttributes();
            $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

            // batch_no
            $this->batch_no->setupEditAttributes();
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->AdvancedSearch->SearchValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // shape
            $this->shape->setupEditAttributes();
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // cs
            $this->cs->setupEditAttributes();
            $this->cs->EditValue = $this->cs->options(true);
            $this->cs->PlaceHolder = RemoveHtml($this->cs->caption());

            // product_type
            $this->product_type->setupEditAttributes();
            $this->product_type->EditValue = $this->product_type->options(true);
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // size_cm
            $this->size_cm->setupEditAttributes();
            if (!$this->size_cm->Raw) {
                $this->size_cm->AdvancedSearch->SearchValue = HtmlDecode($this->size_cm->AdvancedSearch->SearchValue);
            }
            $this->size_cm->EditValue = HtmlEncode($this->size_cm->AdvancedSearch->SearchValue);
            $this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

            // buyer_uid
            $this->buyer_uid->setupEditAttributes();
            if (!$this->buyer_uid->Raw) {
                $this->buyer_uid->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_uid->AdvancedSearch->SearchValue);
            }
            $this->buyer_uid->EditValue = HtmlEncode($this->buyer_uid->AdvancedSearch->SearchValue);
            $this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

            // buyer_loc
            $this->buyer_loc->setupEditAttributes();
            if (!$this->buyer_loc->Raw) {
                $this->buyer_loc->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_loc->AdvancedSearch->SearchValue);
            }
            $this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->AdvancedSearch->SearchValue);
            $this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // po_price
            $this->po_price->setupEditAttributes();
            if (!$this->po_price->Raw) {
                $this->po_price->AdvancedSearch->SearchValue = HtmlDecode($this->po_price->AdvancedSearch->SearchValue);
            }
            $this->po_price->EditValue = HtmlEncode($this->po_price->AdvancedSearch->SearchValue);
            $this->po_price->PlaceHolder = RemoveHtml($this->po_price->caption());

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // despatch_date
            $this->despatch_date->setupEditAttributes();
            $this->despatch_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->despatch_date->AdvancedSearch->SearchValue, $this->despatch_date->formatPattern()), $this->despatch_date->formatPattern()));
            $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

            // status
            $this->status->setupEditAttributes();
            $curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
            } else {
                $this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== null && is_array($this->status->lookupOptions()) && count($this->status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->status->EditValue = array_values($this->status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->status->AdvancedSearch->SearchValue, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->status->EditValue = $arwrk;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // completed
            $this->completed->setupEditAttributes();
            $this->completed->EditValue = $this->completed->options(true);
            $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

            // buyer_po
            $this->buyer_po->setupEditAttributes();
            if (!$this->buyer_po->Raw) {
                $this->buyer_po->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_po->AdvancedSearch->SearchValue);
            }
            $this->buyer_po->EditValue = HtmlEncode($this->buyer_po->AdvancedSearch->SearchValue);
            $this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            $this->jc_no->EditValue = $this->jc_no->AdvancedSearch->SearchValue;
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

            // process_d
            $this->process_d->PlaceHolder = RemoveHtml($this->process_d->caption());

            // weight
            $this->weight->setupEditAttributes();
            $this->weight->EditValue = $this->weight->AdvancedSearch->SearchValue;
            $this->weight->PlaceHolder = RemoveHtml($this->weight->caption());

            // po_currency
            $this->po_currency->setupEditAttributes();
            $this->po_currency->PlaceHolder = RemoveHtml($this->po_currency->caption());

            // dispatch_week_p
            $this->dispatch_week_p->setupEditAttributes();
            $this->dispatch_week_p->PlaceHolder = RemoveHtml($this->dispatch_week_p->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // pl_no
            $this->pl_no->setupEditAttributes();
            $this->pl_no->EditValue = $this->pl_no->AdvancedSearch->SearchValue;
            $this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

            // category
            $this->category->setupEditAttributes();
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // roll_no
            $this->roll_no->setupEditAttributes();
            $this->roll_no->EditValue = $this->roll_no->AdvancedSearch->SearchValue;
            $this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

            // buyer_barcode
            $this->buyer_barcode->setupEditAttributes();
            if (!$this->buyer_barcode->Raw) {
                $this->buyer_barcode->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_barcode->AdvancedSearch->SearchValue);
            }
            $this->buyer_barcode->EditValue = HtmlEncode($this->buyer_barcode->AdvancedSearch->SearchValue);
            $this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());

            // q_sku
            $this->q_sku->setupEditAttributes();
            $this->q_sku->EditValue = $this->q_sku->AdvancedSearch->SearchValue;
            $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

            // sqm_u
            $this->sqm_u->setupEditAttributes();
            $this->sqm_u->EditValue = $this->sqm_u->AdvancedSearch->SearchValue;
            $this->sqm_u->PlaceHolder = RemoveHtml($this->sqm_u->caption());

            // po_discount
            $this->po_discount->setupEditAttributes();
            $this->po_discount->EditValue = $this->po_discount->AdvancedSearch->SearchValue;
            $this->po_discount->PlaceHolder = RemoveHtml($this->po_discount->caption());

            // 11
            $this->_11->setupEditAttributes();
            if (!$this->_11->Raw) {
                $this->_11->AdvancedSearch->SearchValue = HtmlDecode($this->_11->AdvancedSearch->SearchValue);
            }
            $this->_11->EditValue = HtmlEncode($this->_11->AdvancedSearch->SearchValue);
            $this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

            // 12
            $this->_12->setupEditAttributes();
            if (!$this->_12->Raw) {
                $this->_12->AdvancedSearch->SearchValue = HtmlDecode($this->_12->AdvancedSearch->SearchValue);
            }
            $this->_12->EditValue = HtmlEncode($this->_12->AdvancedSearch->SearchValue);
            $this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

            // 13
            $this->_13->setupEditAttributes();
            if (!$this->_13->Raw) {
                $this->_13->AdvancedSearch->SearchValue = HtmlDecode($this->_13->AdvancedSearch->SearchValue);
            }
            $this->_13->EditValue = HtmlEncode($this->_13->AdvancedSearch->SearchValue);
            $this->_13->PlaceHolder = RemoveHtml($this->_13->caption());

            // 14
            $this->_14->setupEditAttributes();
            if (!$this->_14->Raw) {
                $this->_14->AdvancedSearch->SearchValue = HtmlDecode($this->_14->AdvancedSearch->SearchValue);
            }
            $this->_14->EditValue = HtmlEncode($this->_14->AdvancedSearch->SearchValue);
            $this->_14->PlaceHolder = RemoveHtml($this->_14->caption());

            // 15
            $this->_15->setupEditAttributes();
            if (!$this->_15->Raw) {
                $this->_15->AdvancedSearch->SearchValue = HtmlDecode($this->_15->AdvancedSearch->SearchValue);
            }
            $this->_15->EditValue = HtmlEncode($this->_15->AdvancedSearch->SearchValue);
            $this->_15->PlaceHolder = RemoveHtml($this->_15->caption());

            // 16
            $this->_16->setupEditAttributes();
            if (!$this->_16->Raw) {
                $this->_16->AdvancedSearch->SearchValue = HtmlDecode($this->_16->AdvancedSearch->SearchValue);
            }
            $this->_16->EditValue = HtmlEncode($this->_16->AdvancedSearch->SearchValue);
            $this->_16->PlaceHolder = RemoveHtml($this->_16->caption());

            // 17
            $this->_17->setupEditAttributes();
            if (!$this->_17->Raw) {
                $this->_17->AdvancedSearch->SearchValue = HtmlDecode($this->_17->AdvancedSearch->SearchValue);
            }
            $this->_17->EditValue = HtmlEncode($this->_17->AdvancedSearch->SearchValue);
            $this->_17->PlaceHolder = RemoveHtml($this->_17->caption());

            // 18
            $this->_18->setupEditAttributes();
            if (!$this->_18->Raw) {
                $this->_18->AdvancedSearch->SearchValue = HtmlDecode($this->_18->AdvancedSearch->SearchValue);
            }
            $this->_18->EditValue = HtmlEncode($this->_18->AdvancedSearch->SearchValue);
            $this->_18->PlaceHolder = RemoveHtml($this->_18->caption());

            // 19
            $this->_19->setupEditAttributes();
            if (!$this->_19->Raw) {
                $this->_19->AdvancedSearch->SearchValue = HtmlDecode($this->_19->AdvancedSearch->SearchValue);
            }
            $this->_19->EditValue = HtmlEncode($this->_19->AdvancedSearch->SearchValue);
            $this->_19->PlaceHolder = RemoveHtml($this->_19->caption());

            // 20
            $this->_20->setupEditAttributes();
            if (!$this->_20->Raw) {
                $this->_20->AdvancedSearch->SearchValue = HtmlDecode($this->_20->AdvancedSearch->SearchValue);
            }
            $this->_20->EditValue = HtmlEncode($this->_20->AdvancedSearch->SearchValue);
            $this->_20->PlaceHolder = RemoveHtml($this->_20->caption());

            // 21
            $this->_21->setupEditAttributes();
            if (!$this->_21->Raw) {
                $this->_21->AdvancedSearch->SearchValue = HtmlDecode($this->_21->AdvancedSearch->SearchValue);
            }
            $this->_21->EditValue = HtmlEncode($this->_21->AdvancedSearch->SearchValue);
            $this->_21->PlaceHolder = RemoveHtml($this->_21->caption());

            // 22
            $this->_22->setupEditAttributes();
            if (!$this->_22->Raw) {
                $this->_22->AdvancedSearch->SearchValue = HtmlDecode($this->_22->AdvancedSearch->SearchValue);
            }
            $this->_22->EditValue = HtmlEncode($this->_22->AdvancedSearch->SearchValue);
            $this->_22->PlaceHolder = RemoveHtml($this->_22->caption());

            // 23
            $this->_23->setupEditAttributes();
            if (!$this->_23->Raw) {
                $this->_23->AdvancedSearch->SearchValue = HtmlDecode($this->_23->AdvancedSearch->SearchValue);
            }
            $this->_23->EditValue = HtmlEncode($this->_23->AdvancedSearch->SearchValue);
            $this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

            // 24
            $this->_24->setupEditAttributes();
            if (!$this->_24->Raw) {
                $this->_24->AdvancedSearch->SearchValue = HtmlDecode($this->_24->AdvancedSearch->SearchValue);
            }
            $this->_24->EditValue = HtmlEncode($this->_24->AdvancedSearch->SearchValue);
            $this->_24->PlaceHolder = RemoveHtml($this->_24->caption());

            // 25
            $this->_25->setupEditAttributes();
            if (!$this->_25->Raw) {
                $this->_25->AdvancedSearch->SearchValue = HtmlDecode($this->_25->AdvancedSearch->SearchValue);
            }
            $this->_25->EditValue = HtmlEncode($this->_25->AdvancedSearch->SearchValue);
            $this->_25->PlaceHolder = RemoveHtml($this->_25->caption());

            // 26
            $this->_26->setupEditAttributes();
            if (!$this->_26->Raw) {
                $this->_26->AdvancedSearch->SearchValue = HtmlDecode($this->_26->AdvancedSearch->SearchValue);
            }
            $this->_26->EditValue = HtmlEncode($this->_26->AdvancedSearch->SearchValue);
            $this->_26->PlaceHolder = RemoveHtml($this->_26->caption());

            // 27
            $this->_27->setupEditAttributes();
            if (!$this->_27->Raw) {
                $this->_27->AdvancedSearch->SearchValue = HtmlDecode($this->_27->AdvancedSearch->SearchValue);
            }
            $this->_27->EditValue = HtmlEncode($this->_27->AdvancedSearch->SearchValue);
            $this->_27->PlaceHolder = RemoveHtml($this->_27->caption());

            // 28
            $this->_28->setupEditAttributes();
            if (!$this->_28->Raw) {
                $this->_28->AdvancedSearch->SearchValue = HtmlDecode($this->_28->AdvancedSearch->SearchValue);
            }
            $this->_28->EditValue = HtmlEncode($this->_28->AdvancedSearch->SearchValue);
            $this->_28->PlaceHolder = RemoveHtml($this->_28->caption());

            // 29
            $this->_29->setupEditAttributes();
            if (!$this->_29->Raw) {
                $this->_29->AdvancedSearch->SearchValue = HtmlDecode($this->_29->AdvancedSearch->SearchValue);
            }
            $this->_29->EditValue = HtmlEncode($this->_29->AdvancedSearch->SearchValue);
            $this->_29->PlaceHolder = RemoveHtml($this->_29->caption());

            // 30
            $this->_30->setupEditAttributes();
            if (!$this->_30->Raw) {
                $this->_30->AdvancedSearch->SearchValue = HtmlDecode($this->_30->AdvancedSearch->SearchValue);
            }
            $this->_30->EditValue = HtmlEncode($this->_30->AdvancedSearch->SearchValue);
            $this->_30->PlaceHolder = RemoveHtml($this->_30->caption());

            // 31
            $this->_31->setupEditAttributes();
            if (!$this->_31->Raw) {
                $this->_31->AdvancedSearch->SearchValue = HtmlDecode($this->_31->AdvancedSearch->SearchValue);
            }
            $this->_31->EditValue = HtmlEncode($this->_31->AdvancedSearch->SearchValue);
            $this->_31->PlaceHolder = RemoveHtml($this->_31->caption());

            // 32
            $this->_32->setupEditAttributes();
            if (!$this->_32->Raw) {
                $this->_32->AdvancedSearch->SearchValue = HtmlDecode($this->_32->AdvancedSearch->SearchValue);
            }
            $this->_32->EditValue = HtmlEncode($this->_32->AdvancedSearch->SearchValue);
            $this->_32->PlaceHolder = RemoveHtml($this->_32->caption());

            // 33
            $this->_33->setupEditAttributes();
            if (!$this->_33->Raw) {
                $this->_33->AdvancedSearch->SearchValue = HtmlDecode($this->_33->AdvancedSearch->SearchValue);
            }
            $this->_33->EditValue = HtmlEncode($this->_33->AdvancedSearch->SearchValue);
            $this->_33->PlaceHolder = RemoveHtml($this->_33->caption());

            // 34
            $this->_34->setupEditAttributes();
            if (!$this->_34->Raw) {
                $this->_34->AdvancedSearch->SearchValue = HtmlDecode($this->_34->AdvancedSearch->SearchValue);
            }
            $this->_34->EditValue = HtmlEncode($this->_34->AdvancedSearch->SearchValue);
            $this->_34->PlaceHolder = RemoveHtml($this->_34->caption());

            // 35
            $this->_35->setupEditAttributes();
            if (!$this->_35->Raw) {
                $this->_35->AdvancedSearch->SearchValue = HtmlDecode($this->_35->AdvancedSearch->SearchValue);
            }
            $this->_35->EditValue = HtmlEncode($this->_35->AdvancedSearch->SearchValue);
            $this->_35->PlaceHolder = RemoveHtml($this->_35->caption());

            // 36
            $this->_36->setupEditAttributes();
            if (!$this->_36->Raw) {
                $this->_36->AdvancedSearch->SearchValue = HtmlDecode($this->_36->AdvancedSearch->SearchValue);
            }
            $this->_36->EditValue = HtmlEncode($this->_36->AdvancedSearch->SearchValue);
            $this->_36->PlaceHolder = RemoveHtml($this->_36->caption());

            // 37
            $this->_37->setupEditAttributes();
            if (!$this->_37->Raw) {
                $this->_37->AdvancedSearch->SearchValue = HtmlDecode($this->_37->AdvancedSearch->SearchValue);
            }
            $this->_37->EditValue = HtmlEncode($this->_37->AdvancedSearch->SearchValue);
            $this->_37->PlaceHolder = RemoveHtml($this->_37->caption());

            // 38
            $this->_38->setupEditAttributes();
            if (!$this->_38->Raw) {
                $this->_38->AdvancedSearch->SearchValue = HtmlDecode($this->_38->AdvancedSearch->SearchValue);
            }
            $this->_38->EditValue = HtmlEncode($this->_38->AdvancedSearch->SearchValue);
            $this->_38->PlaceHolder = RemoveHtml($this->_38->caption());

            // 39
            $this->_39->setupEditAttributes();
            if (!$this->_39->Raw) {
                $this->_39->AdvancedSearch->SearchValue = HtmlDecode($this->_39->AdvancedSearch->SearchValue);
            }
            $this->_39->EditValue = HtmlEncode($this->_39->AdvancedSearch->SearchValue);
            $this->_39->PlaceHolder = RemoveHtml($this->_39->caption());

            // 40
            $this->_40->setupEditAttributes();
            if (!$this->_40->Raw) {
                $this->_40->AdvancedSearch->SearchValue = HtmlDecode($this->_40->AdvancedSearch->SearchValue);
            }
            $this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

            // 41
            $this->_41->setupEditAttributes();
            if (!$this->_41->Raw) {
                $this->_41->AdvancedSearch->SearchValue = HtmlDecode($this->_41->AdvancedSearch->SearchValue);
            }
            $this->_41->EditValue = HtmlEncode($this->_41->AdvancedSearch->SearchValue);
            $this->_41->PlaceHolder = RemoveHtml($this->_41->caption());

            // 42
            $this->_42->setupEditAttributes();
            if (!$this->_42->Raw) {
                $this->_42->AdvancedSearch->SearchValue = HtmlDecode($this->_42->AdvancedSearch->SearchValue);
            }
            $this->_42->EditValue = HtmlEncode($this->_42->AdvancedSearch->SearchValue);
            $this->_42->PlaceHolder = RemoveHtml($this->_42->caption());

            // 43
            $this->_43->setupEditAttributes();
            if (!$this->_43->Raw) {
                $this->_43->AdvancedSearch->SearchValue = HtmlDecode($this->_43->AdvancedSearch->SearchValue);
            }
            $this->_43->EditValue = HtmlEncode($this->_43->AdvancedSearch->SearchValue);
            $this->_43->PlaceHolder = RemoveHtml($this->_43->caption());

            // 44
            $this->_44->setupEditAttributes();
            if (!$this->_44->Raw) {
                $this->_44->AdvancedSearch->SearchValue = HtmlDecode($this->_44->AdvancedSearch->SearchValue);
            }
            $this->_44->EditValue = HtmlEncode($this->_44->AdvancedSearch->SearchValue);
            $this->_44->PlaceHolder = RemoveHtml($this->_44->caption());

            // 45
            $this->_45->setupEditAttributes();
            if (!$this->_45->Raw) {
                $this->_45->AdvancedSearch->SearchValue = HtmlDecode($this->_45->AdvancedSearch->SearchValue);
            }
            $this->_45->EditValue = HtmlEncode($this->_45->AdvancedSearch->SearchValue);
            $this->_45->PlaceHolder = RemoveHtml($this->_45->caption());

            // 46
            $this->_46->setupEditAttributes();
            if (!$this->_46->Raw) {
                $this->_46->AdvancedSearch->SearchValue = HtmlDecode($this->_46->AdvancedSearch->SearchValue);
            }
            $this->_46->EditValue = HtmlEncode($this->_46->AdvancedSearch->SearchValue);
            $this->_46->PlaceHolder = RemoveHtml($this->_46->caption());

            // 47
            $this->_47->setupEditAttributes();
            if (!$this->_47->Raw) {
                $this->_47->AdvancedSearch->SearchValue = HtmlDecode($this->_47->AdvancedSearch->SearchValue);
            }
            $this->_47->EditValue = HtmlEncode($this->_47->AdvancedSearch->SearchValue);
            $this->_47->PlaceHolder = RemoveHtml($this->_47->caption());

            // 48
            $this->_48->setupEditAttributes();
            if (!$this->_48->Raw) {
                $this->_48->AdvancedSearch->SearchValue = HtmlDecode($this->_48->AdvancedSearch->SearchValue);
            }
            $this->_48->EditValue = HtmlEncode($this->_48->AdvancedSearch->SearchValue);
            $this->_48->PlaceHolder = RemoveHtml($this->_48->caption());

            // 49
            $this->_49->setupEditAttributes();
            if (!$this->_49->Raw) {
                $this->_49->AdvancedSearch->SearchValue = HtmlDecode($this->_49->AdvancedSearch->SearchValue);
            }
            $this->_49->EditValue = HtmlEncode($this->_49->AdvancedSearch->SearchValue);
            $this->_49->PlaceHolder = RemoveHtml($this->_49->caption());

            // 50
            $this->_50->setupEditAttributes();
            if (!$this->_50->Raw) {
                $this->_50->AdvancedSearch->SearchValue = HtmlDecode($this->_50->AdvancedSearch->SearchValue);
            }
            $this->_50->EditValue = HtmlEncode($this->_50->AdvancedSearch->SearchValue);
            $this->_50->PlaceHolder = RemoveHtml($this->_50->caption());

            // order_date
            $this->order_date->setupEditAttributes();
            $this->order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->order_date->AdvancedSearch->SearchValue, $this->order_date->formatPattern()), $this->order_date->formatPattern()));
            $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue)) {
            $this->_barcode->addErrorMessage($this->_barcode->getErrorMessage(false));
        }
        if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue2)) {
            $this->_barcode->addErrorMessage($this->_barcode->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->pid->AdvancedSearch->load();
        $this->weaving_works->AdvancedSearch->load();
        $this->current_works->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->buyers_id->AdvancedSearch->load();
        $this->pp_id->AdvancedSearch->load();
        $this->buyer_ref->AdvancedSearch->load();
        $this->design_id->AdvancedSearch->load();
        $this->batch_no->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->shape->AdvancedSearch->load();
        $this->cs->AdvancedSearch->load();
        $this->product_type->AdvancedSearch->load();
        $this->size_cm->AdvancedSearch->load();
        $this->size_buyer->AdvancedSearch->load();
        $this->buyer_uid->AdvancedSearch->load();
        $this->buyer_loc->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->po_price->AdvancedSearch->load();
        $this->despatch_week->AdvancedSearch->load();
        $this->despatch_date->AdvancedSearch->load();
        $this->payment_plan->AdvancedSearch->load();
        $this->production_plan->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->completed->AdvancedSearch->load();
        $this->buyer_po->AdvancedSearch->load();
        $this->jc_no->AdvancedSearch->load();
        $this->process_d->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->po_currency->AdvancedSearch->load();
        $this->dispatch_week_p->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->pl_no->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->roll_no->AdvancedSearch->load();
        $this->qty->AdvancedSearch->load();
        $this->q_sku->AdvancedSearch->load();
        $this->sqm_u->AdvancedSearch->load();
        $this->po_discount->AdvancedSearch->load();
        $this->_11->AdvancedSearch->load();
        $this->_12->AdvancedSearch->load();
        $this->_13->AdvancedSearch->load();
        $this->_14->AdvancedSearch->load();
        $this->_15->AdvancedSearch->load();
        $this->_16->AdvancedSearch->load();
        $this->_17->AdvancedSearch->load();
        $this->_18->AdvancedSearch->load();
        $this->_19->AdvancedSearch->load();
        $this->_20->AdvancedSearch->load();
        $this->_21->AdvancedSearch->load();
        $this->_22->AdvancedSearch->load();
        $this->_23->AdvancedSearch->load();
        $this->_24->AdvancedSearch->load();
        $this->_25->AdvancedSearch->load();
        $this->_26->AdvancedSearch->load();
        $this->_27->AdvancedSearch->load();
        $this->_28->AdvancedSearch->load();
        $this->_29->AdvancedSearch->load();
        $this->_30->AdvancedSearch->load();
        $this->_31->AdvancedSearch->load();
        $this->_32->AdvancedSearch->load();
        $this->_33->AdvancedSearch->load();
        $this->_34->AdvancedSearch->load();
        $this->_35->AdvancedSearch->load();
        $this->_36->AdvancedSearch->load();
        $this->_37->AdvancedSearch->load();
        $this->_38->AdvancedSearch->load();
        $this->_39->AdvancedSearch->load();
        $this->_40->AdvancedSearch->load();
        $this->_41->AdvancedSearch->load();
        $this->_42->AdvancedSearch->load();
        $this->_43->AdvancedSearch->load();
        $this->_44->AdvancedSearch->load();
        $this->_45->AdvancedSearch->load();
        $this->_46->AdvancedSearch->load();
        $this->_47->AdvancedSearch->load();
        $this->_48->AdvancedSearch->load();
        $this->_49->AdvancedSearch->load();
        $this->_50->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fbcode_oldlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fbcode_oldlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fbcode_oldlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fbcode_oldlist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = false;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = false;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = false;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fbcode_oldsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"bcode_old\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"bcodeoldsearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"bcodeoldsearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Query builder button
        $item = &$this->SearchOptions->add("querybuilder");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-query-builder\" title=\"" . $Language->phrase("QueryBuilder", true) . "\" data-table=\"bcode_old\" data-caption=\"" . $Language->phrase("QueryBuilder", true) . "\" data-ew-action=\"modal\" data-url=\"bcodeoldquery\" data-btn=\"SearchBtn\">" . $Language->phrase("QueryBuilder", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-query-builder\" title=\"" . $Language->phrase("QueryBuilder", true) . "\" data-caption=\"" . $Language->phrase("QueryBuilder", true) . "\" href=\"bcodeoldquery\">" . $Language->phrase("QueryBuilder", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fbcode_oldsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_weaving_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_current_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyers_id":
                    break;
                case "x_pp_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_ref":
                    break;
                case "x_design":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_design_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cs":
                    break;
                case "x_product_type":
                    break;
                case "x_despatch_week":
                    break;
                case "x_payment_plan":
                    break;
                case "x_production_plan":
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_completed":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_c":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_d":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_po_currency":
                    break;
                case "x_dispatch_week_p":
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
