<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for bcode_old
 */
class BcodeOld extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $pid;
    public $grp;
    public $s_grp;
    public $weaving_works;
    public $current_works;
    public $po;
    public $_barcode;
    public $buyers_id;
    public $pp_id;
    public $buyer_ref;
    public $buyer_tid;
    public $design;
    public $design_id;
    public $batch_no;
    public $l_cm;
    public $w_cm;
    public $sqm;
    public $sqm_a;
    public $_2srm;
    public $_2srm_a;
    public $_4srm;
    public $_4srm_a;
    public $shape;
    public $cs;
    public $product_type;
    public $size_cm;
    public $size_buyer;
    public $buyer_uid;
    public $buyer_loc;
    public $quantity;
    public $po_price;
    public $despatch_week;
    public $despatch_date;
    public $payment_plan;
    public $production_plan;
    public $status;
    public $completed;
    public $buyer_po;
    public $jc_no;
    public $process;
    public $process_c;
    public $process_d;
    public $weight;
    public $operator;
    public $datetime;
    public $po_currency;
    public $dispatch_week_p;
    public $remarks;
    public $pl_no;
    public $category;
    public $roll_no;
    public $qty;
    public $consignee;
    public $buyer_barcode;
    public $design_next;
    public $q_sku;
    public $sqm_u;
    public $po_discount;
    public $loom_plan;
    public $_11;
    public $_12;
    public $_13;
    public $_14;
    public $_15;
    public $_16;
    public $_17;
    public $_18;
    public $_19;
    public $_20;
    public $_21;
    public $_22;
    public $_23;
    public $_24;
    public $_25;
    public $_26;
    public $_27;
    public $_28;
    public $_29;
    public $_30;
    public $_31;
    public $_32;
    public $_33;
    public $_34;
    public $_35;
    public $_36;
    public $_37;
    public $_38;
    public $_39;
    public $_40;
    public $_41;
    public $_42;
    public $_43;
    public $_44;
    public $_45;
    public $_46;
    public $_47;
    public $_48;
    public $_49;
    public $_50;
    public $c_sqm;
    public $packing_type;
    public $order_date;
    public $qc_weaving;
    public $p_remarks;
    public $roll_no_qty_tmp;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "bcode_old";
        $this->TableName = 'bcode_old';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "bcode_old";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // pid
        $this->pid = new DbField(
            $this, // Table
            'x_pid', // Variable name
            'pid', // Name
            '`pid`', // Expression
            '`pid`', // Basic search expression
            131, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pid->InputTextType = "text";
        $this->pid->Raw = true;
        $this->pid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['pid'] = &$this->pid;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Sortable = false; // Allow sort
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Sortable = false; // Allow sort
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // weaving_works
        $this->weaving_works = new DbField(
            $this, // Table
            'x_weaving_works', // Variable name
            'weaving_works', // Name
            '`weaving_works`', // Expression
            '`weaving_works`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weaving_works`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->weaving_works->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->weaving_works->addMethod("getDefault", fn() => 0);
        $this->weaving_works->InputTextType = "text";
        $this->weaving_works->Raw = true;
        $this->weaving_works->Nullable = false; // NOT NULL field
        $this->weaving_works->Required = true; // Required field
        $this->weaving_works->setSelectMultiple(false); // Select one
        $this->weaving_works->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->weaving_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->weaving_works->Lookup = new Lookup($this->weaving_works, 'godown_table', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->weaving_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->weaving_works->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['weaving_works'] = &$this->weaving_works;

        // current_works
        $this->current_works = new DbField(
            $this, // Table
            'x_current_works', // Variable name
            'current_works', // Name
            '`current_works`', // Expression
            '`current_works`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`current_works`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->current_works->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->current_works->addMethod("getDefault", fn() => 0);
        $this->current_works->InputTextType = "text";
        $this->current_works->Raw = true;
        $this->current_works->Nullable = false; // NOT NULL field
        $this->current_works->Required = true; // Required field
        $this->current_works->setSelectMultiple(false); // Select one
        $this->current_works->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->current_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->current_works->Lookup = new Lookup($this->current_works, 'godown_table', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->current_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->current_works->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['current_works'] = &$this->current_works;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->addMethod("getDefault", fn() => 99999);
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->Required = true; // Required field
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // barcode
        $this->_barcode = new DbField(
            $this, // Table
            'x__barcode', // Variable name
            'barcode', // Name
            '`barcode`', // Expression
            '`barcode`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_barcode->addMethod("getDefault", fn() => 99999);
        $this->_barcode->InputTextType = "text";
        $this->_barcode->Raw = true;
        $this->_barcode->Nullable = false; // NOT NULL field
        $this->_barcode->Required = true; // Required field
        $this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['barcode'] = &$this->_barcode;

        // buyers_id
        $this->buyers_id = new DbField(
            $this, // Table
            'x_buyers_id', // Variable name
            'buyers_id', // Name
            '`buyers_id`', // Expression
            '`buyers_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyers_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyers_id->addMethod("getLinkPrefix", fn() => "bcodelist?x_buyers_id=");
        $this->buyers_id->InputTextType = "text";
        $this->buyers_id->Raw = true;
        $this->buyers_id->setSelectMultiple(false); // Select one
        $this->buyers_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyers_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyers_id->Lookup = new Lookup($this->buyers_id, 'buyer_seller_view', false, 'id', ["name","code","",""], '', '', [], ["x_buyer_ref"], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->buyers_id) . "',COALESCE(`code`,''))");
        $this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyers_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyers_id'] = &$this->buyers_id;

        // pp_id
        $this->pp_id = new DbField(
            $this, // Table
            'x_pp_id', // Variable name
            'pp_id', // Name
            '`pp_id`', // Expression
            '`pp_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pp_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pp_id->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->pp_id->InputTextType = "text";
        $this->pp_id->Raw = true;
        $this->pp_id->Lookup = new Lookup($this->pp_id, 'production_partner', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->pp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pp_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['pp_id'] = &$this->pp_id;

        // buyer_ref
        $this->buyer_ref = new DbField(
            $this, // Table
            'x_buyer_ref', // Variable name
            'buyer_ref', // Name
            '`buyer_ref`', // Expression
            '`buyer_ref`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__buyer_ref', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyer_ref->addMethod("getLinkPrefix", fn() => "bcodelist?x_buyer_ref=");
        $this->buyer_ref->InputTextType = "text";
        $this->buyer_ref->Raw = true;
        $this->buyer_ref->setSelectMultiple(false); // Select one
        $this->buyer_ref->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyer_ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyer_ref->Lookup = new Lookup($this->buyer_ref, 'partner_product_ref', false, 'id', ["partner_ref","barcode","partner_code",""], '', '', ["x_buyers_id"], [], ["partner"], ["x_partner"], [], [], false, '`partner_ref` ASC', '', "CONCAT(COALESCE(`partner_ref`, ''),'" . ValueSeparator(1, $this->buyer_ref) . "',COALESCE(`barcode`,''),'" . ValueSeparator(2, $this->buyer_ref) . "',COALESCE(`partner_code`,''))");
        $this->buyer_ref->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_ref'] = &$this->buyer_ref;

        // buyer_tid
        $this->buyer_tid = new DbField(
            $this, // Table
            'x_buyer_tid', // Variable name
            'buyer_tid', // Name
            '`buyer_tid`', // Expression
            '`buyer_tid`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_tid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_tid->InputTextType = "text";
        $this->buyer_tid->Sortable = false; // Allow sort
        $this->buyer_tid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_tid'] = &$this->buyer_tid;

        // design
        $this->design = new DbField(
            $this, // Table
            'x_design', // Variable name
            'design', // Name
            '`design`', // Expression
            '`design`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design->addMethod("getSelectFilter", fn() => "`product_type`  != 9 and `status` = 1");
        $this->design->InputTextType = "text";
        $this->design->Lookup = new Lookup($this->design, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->design->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->design->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['design'] = &$this->design;

        // design_id
        $this->design_id = new DbField(
            $this, // Table
            'x_design_id', // Variable name
            'design_id', // Name
            '`design_id`', // Expression
            '`design_id`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->design_id->addMethod("getSelectFilter", fn() => "`product_type`  != 9 and `status` = 1");
        $this->design_id->addMethod("getLinkPrefix", fn() => "bcodelist?x_design_id=");
        $this->design_id->InputTextType = "text";
        $this->design_id->Required = true; // Required field
        $this->design_id->setSelectMultiple(false); // Select one
        $this->design_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->design_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->design_id->Lookup = new Lookup($this->design_id, 'ref', false, 'id', ["product_code","","",""], '', '', [], ["x_batch_no"], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->design_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->design_id->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['design_id'] = &$this->design_id;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->batch_no->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->batch_no->addMethod("getLinkPrefix", fn() => "batchnolist?x_id=");
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Raw = true;
        $this->batch_no->Required = true; // Required field
        $this->batch_no->setSelectMultiple(false); // Select one
        $this->batch_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->batch_no->Lookup = new Lookup($this->batch_no, 'batch_no', false, 'id', ["batch_no","","",""], '', '', ["x_design_id"], [], ["rid"], ["x_rid"], [], [], false, '`batch_no` ASC', '', "`batch_no`");
        $this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->batch_no->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // l_cm
        $this->l_cm = new DbField(
            $this, // Table
            'x_l_cm', // Variable name
            'l_cm', // Name
            '`l_cm`', // Expression
            '`l_cm`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`l_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->l_cm->InputTextType = "text";
        $this->l_cm->Raw = true;
        $this->l_cm->Required = true; // Required field
        $this->l_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->l_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['l_cm'] = &$this->l_cm;

        // w_cm
        $this->w_cm = new DbField(
            $this, // Table
            'x_w_cm', // Variable name
            'w_cm', // Name
            '`w_cm`', // Expression
            '`w_cm`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`w_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->w_cm->InputTextType = "text";
        $this->w_cm->Raw = true;
        $this->w_cm->Required = true; // Required field
        $this->w_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->w_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['w_cm'] = &$this->w_cm;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->addMethod("getDefault", fn() => 0);
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->Nullable = false; // NOT NULL field
        $this->sqm->Required = true; // Required field
        $this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['sqm'] = &$this->sqm;

        // sqm_a
        $this->sqm_a = new DbField(
            $this, // Table
            'x_sqm_a', // Variable name
            'sqm_a', // Name
            '`sqm_a`', // Expression
            '`sqm_a`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm_a->InputTextType = "text";
        $this->sqm_a->Raw = true;
        $this->sqm_a->Nullable = false; // NOT NULL field
        $this->sqm_a->Required = true; // Required field
        $this->sqm_a->Sortable = false; // Allow sort
        $this->sqm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['sqm_a'] = &$this->sqm_a;

        // 2srm
        $this->_2srm = new DbField(
            $this, // Table
            'x__2srm', // Variable name
            '2srm', // Name
            '`2srm`', // Expression
            '`2srm`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`2srm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_2srm->InputTextType = "text";
        $this->_2srm->Raw = true;
        $this->_2srm->Nullable = false; // NOT NULL field
        $this->_2srm->Required = true; // Required field
        $this->_2srm->Sortable = false; // Allow sort
        $this->_2srm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_2srm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['2srm'] = &$this->_2srm;

        // 2srm_a
        $this->_2srm_a = new DbField(
            $this, // Table
            'x__2srm_a', // Variable name
            '2srm_a', // Name
            '`2srm_a`', // Expression
            '`2srm_a`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`2srm_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_2srm_a->InputTextType = "text";
        $this->_2srm_a->Raw = true;
        $this->_2srm_a->Nullable = false; // NOT NULL field
        $this->_2srm_a->Required = true; // Required field
        $this->_2srm_a->Sortable = false; // Allow sort
        $this->_2srm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_2srm_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['2srm_a'] = &$this->_2srm_a;

        // 4srm
        $this->_4srm = new DbField(
            $this, // Table
            'x__4srm', // Variable name
            '4srm', // Name
            '`4srm`', // Expression
            '`4srm`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`4srm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_4srm->InputTextType = "text";
        $this->_4srm->Raw = true;
        $this->_4srm->Nullable = false; // NOT NULL field
        $this->_4srm->Required = true; // Required field
        $this->_4srm->Sortable = false; // Allow sort
        $this->_4srm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_4srm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['4srm'] = &$this->_4srm;

        // 4srm_a
        $this->_4srm_a = new DbField(
            $this, // Table
            'x__4srm_a', // Variable name
            '4srm_a', // Name
            '`4srm_a`', // Expression
            '`4srm_a`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`4srm_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_4srm_a->InputTextType = "text";
        $this->_4srm_a->Raw = true;
        $this->_4srm_a->Nullable = false; // NOT NULL field
        $this->_4srm_a->Required = true; // Required field
        $this->_4srm_a->Sortable = false; // Allow sort
        $this->_4srm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_4srm_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['4srm_a'] = &$this->_4srm_a;

        // shape
        $this->shape = new DbField(
            $this, // Table
            'x_shape', // Variable name
            'shape', // Name
            '`shape`', // Expression
            '`shape`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shape`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->shape->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->shape->InputTextType = "text";
        $this->shape->Raw = true;
        $this->shape->Nullable = false; // NOT NULL field
        $this->shape->Required = true; // Required field
        $this->shape->setSelectMultiple(false); // Select one
        $this->shape->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->shape->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->shape->Lookup = new Lookup($this->shape, 'shape', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->shape->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->shape->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['shape'] = &$this->shape;

        // cs
        $this->cs = new DbField(
            $this, // Table
            'x_cs', // Variable name
            'cs', // Name
            '`cs`', // Expression
            '`cs`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cs`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->cs->addMethod("getDefault", fn() => 0);
        $this->cs->InputTextType = "text";
        $this->cs->Raw = true;
        $this->cs->Nullable = false; // NOT NULL field
        $this->cs->setSelectMultiple(false); // Select one
        $this->cs->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->cs->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->cs->Lookup = new Lookup($this->cs, 'bcode_old', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->cs->OptionCount = 2;
        $this->cs->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->cs->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['cs'] = &$this->cs;

        // product_type
        $this->product_type = new DbField(
            $this, // Table
            'x_product_type', // Variable name
            'product_type', // Name
            '`product_type`', // Expression
            '`product_type`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product_type->InputTextType = "text";
        $this->product_type->Raw = true;
        $this->product_type->Nullable = false; // NOT NULL field
        $this->product_type->Required = true; // Required field
        $this->product_type->setSelectMultiple(false); // Select one
        $this->product_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product_type->Lookup = new Lookup($this->product_type, 'bcode_old', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->product_type->OptionCount = 4;
        $this->product_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['product_type'] = &$this->product_type;

        // size_cm
        $this->size_cm = new DbField(
            $this, // Table
            'x_size_cm', // Variable name
            'size_cm', // Name
            '`size_cm`', // Expression
            '`size_cm`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_cm->InputTextType = "text";
        $this->size_cm->Nullable = false; // NOT NULL field
        $this->size_cm->Required = true; // Required field
        $this->size_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['size_cm'] = &$this->size_cm;

        // size_buyer
        $this->size_buyer = new DbField(
            $this, // Table
            'x_size_buyer', // Variable name
            'size_buyer', // Name
            '`size_buyer`', // Expression
            '`size_buyer`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_buyer`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_buyer->InputTextType = "text";
        $this->size_buyer->Required = true; // Required field
        $this->size_buyer->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['size_buyer'] = &$this->size_buyer;

        // buyer_uid
        $this->buyer_uid = new DbField(
            $this, // Table
            'x_buyer_uid', // Variable name
            'buyer_uid', // Name
            '`buyer_uid`', // Expression
            '`buyer_uid`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_uid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_uid->InputTextType = "text";
        $this->buyer_uid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_uid'] = &$this->buyer_uid;

        // buyer_loc
        $this->buyer_loc = new DbField(
            $this, // Table
            'x_buyer_loc', // Variable name
            'buyer_loc', // Name
            '`buyer_loc`', // Expression
            '`buyer_loc`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_loc`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_loc->InputTextType = "text";
        $this->buyer_loc->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_loc'] = &$this->buyer_loc;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->addMethod("getDefault", fn() => 1);
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Required = true; // Required field
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity'] = &$this->quantity;

        // po_price
        $this->po_price = new DbField(
            $this, // Table
            'x_po_price', // Variable name
            'po_price', // Name
            '`po_price`', // Expression
            '`po_price`', // Basic search expression
            200, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_price`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_price->InputTextType = "text";
        $this->po_price->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_price'] = &$this->po_price;

        // despatch_week
        $this->despatch_week = new DbField(
            $this, // Table
            'x_despatch_week', // Variable name
            'despatch_week', // Name
            '`despatch_week`', // Expression
            '`despatch_week`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`despatch_week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->despatch_week->InputTextType = "text";
        $this->despatch_week->Raw = true;
        $this->despatch_week->setSelectMultiple(false); // Select one
        $this->despatch_week->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->despatch_week->Lookup = new Lookup($this->despatch_week, 'not_week', false, 'id', ["wid","wed","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`wid`, ''),'" . ValueSeparator(1, $this->despatch_week) . "',COALESCE(`wed`,''))");
        $this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->despatch_week->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['despatch_week'] = &$this->despatch_week;

        // despatch_date
        $this->despatch_date = new DbField(
            $this, // Table
            'x_despatch_date', // Variable name
            'despatch_date', // Name
            '`despatch_date`', // Expression
            CastDateFieldForLike("`despatch_date`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`despatch_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->despatch_date->InputTextType = "text";
        $this->despatch_date->Raw = true;
        $this->despatch_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->despatch_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['despatch_date'] = &$this->despatch_date;

        // payment_plan
        $this->payment_plan = new DbField(
            $this, // Table
            'x_payment_plan', // Variable name
            'payment_plan', // Name
            '`payment_plan`', // Expression
            '`payment_plan`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_plan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->payment_plan->InputTextType = "text";
        $this->payment_plan->Raw = true;
        $this->payment_plan->setSelectMultiple(false); // Select one
        $this->payment_plan->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->payment_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->payment_plan->Lookup = new Lookup($this->payment_plan, 'payment_plan', false, 'id', ["description","","",""], '', '', [], [], [], [], [], [], false, '`description` ASC', '', "`description`");
        $this->payment_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->payment_plan->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['payment_plan'] = &$this->payment_plan;

        // production_plan
        $this->production_plan = new DbField(
            $this, // Table
            'x_production_plan', // Variable name
            'production_plan', // Name
            '`production_plan`', // Expression
            '`production_plan`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`production_plan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->production_plan->InputTextType = "text";
        $this->production_plan->Raw = true;
        $this->production_plan->setSelectMultiple(false); // Select one
        $this->production_plan->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->production_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->production_plan->Lookup = new Lookup($this->production_plan, 'bcode_old', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->production_plan->OptionCount = 6;
        $this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->production_plan->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['production_plan'] = &$this->production_plan;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getSelectFilter", fn() => "`status` = 1 and `grp` != 1000");
        $this->status->addMethod("getDefault", fn() => 0);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Required = true; // Required field
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'status', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // completed
        $this->completed = new DbField(
            $this, // Table
            'x_completed', // Variable name
            'completed', // Name
            '`completed`', // Expression
            '`completed`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`completed`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->completed->addMethod("getDefault", fn() => 0);
        $this->completed->InputTextType = "text";
        $this->completed->Raw = true;
        $this->completed->setSelectMultiple(false); // Select one
        $this->completed->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->completed->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->completed->Lookup = new Lookup($this->completed, 'bcode_old', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->completed->OptionCount = 2;
        $this->completed->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->completed->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['completed'] = &$this->completed;

        // buyer_po
        $this->buyer_po = new DbField(
            $this, // Table
            'x_buyer_po', // Variable name
            'buyer_po', // Name
            '`buyer_po`', // Expression
            '`buyer_po`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_po->InputTextType = "text";
        $this->buyer_po->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_po'] = &$this->buyer_po;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->addMethod("getDefault", fn() => 99999999);
        $this->jc_no->InputTextType = "text";
        $this->jc_no->Raw = true;
        $this->jc_no->Nullable = false; // NOT NULL field
        $this->jc_no->Required = true; // Required field
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->process->InputTextType = "text";
        $this->process->Lookup = new Lookup($this->process, 'sub_process_type', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['process'] = &$this->process;

        // process_c
        $this->process_c = new DbField(
            $this, // Table
            'x_process_c', // Variable name
            'process_c', // Name
            '`process_c`', // Expression
            '`process_c`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_c`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->process_c->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->process_c->InputTextType = "text";
        $this->process_c->Lookup = new Lookup($this->process_c, 'sub_process_type', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process_c->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['process_c'] = &$this->process_c;

        // process_d
        $this->process_d = new DbField(
            $this, // Table
            'x_process_d', // Variable name
            'process_d', // Name
            '`process_d`', // Expression
            '`process_d`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_d`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->process_d->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->process_d->InputTextType = "text";
        $this->process_d->Lookup = new Lookup($this->process_d, 'sub_process_type', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process_d->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['process_d'] = &$this->process_d;

        // weight
        $this->weight = new DbField(
            $this, // Table
            'x_weight', // Variable name
            'weight', // Name
            '`weight`', // Expression
            '`weight`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->weight->InputTextType = "text";
        $this->weight->Raw = true;
        $this->weight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->weight->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['weight'] = &$this->weight;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // po_currency
        $this->po_currency = new DbField(
            $this, // Table
            'x_po_currency', // Variable name
            'po_currency', // Name
            '`po_currency`', // Expression
            '`po_currency`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_currency`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->po_currency->InputTextType = "text";
        $this->po_currency->Raw = true;
        $this->po_currency->setSelectMultiple(false); // Select one
        $this->po_currency->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->po_currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->po_currency->Lookup = new Lookup($this->po_currency, 'currency', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "`code`");
        $this->po_currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_currency->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_currency'] = &$this->po_currency;

        // dispatch_week_p
        $this->dispatch_week_p = new DbField(
            $this, // Table
            'x_dispatch_week_p', // Variable name
            'dispatch_week_p', // Name
            '`dispatch_week_p`', // Expression
            '`dispatch_week_p`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`dispatch_week_p`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->dispatch_week_p->InputTextType = "text";
        $this->dispatch_week_p->Raw = true;
        $this->dispatch_week_p->setSelectMultiple(false); // Select one
        $this->dispatch_week_p->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->dispatch_week_p->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->dispatch_week_p->Lookup = new Lookup($this->dispatch_week_p, 'not_week', false, 'id', ["wid","wed","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`wid`, ''),'" . ValueSeparator(1, $this->dispatch_week_p) . "',COALESCE(`wed`,''))");
        $this->dispatch_week_p->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->dispatch_week_p->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['dispatch_week_p'] = &$this->dispatch_week_p;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // pl_no
        $this->pl_no = new DbField(
            $this, // Table
            'x_pl_no', // Variable name
            'pl_no', // Name
            '`pl_no`', // Expression
            '`pl_no`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pl_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pl_no->addMethod("getDefault", fn() => 0.00);
        $this->pl_no->InputTextType = "text";
        $this->pl_no->Raw = true;
        $this->pl_no->Nullable = false; // NOT NULL field
        $this->pl_no->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pl_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['pl_no'] = &$this->pl_no;

        // category
        $this->category = new DbField(
            $this, // Table
            'x_category', // Variable name
            'category', // Name
            '`category`', // Expression
            '`category`', // Basic search expression
            200, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->category->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->category->InputTextType = "text";
        $this->category->Nullable = false; // NOT NULL field
        $this->category->Required = true; // Required field
        $this->category->setSelectMultiple(false); // Select one
        $this->category->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->category->Lookup = new Lookup($this->category, 'product_category', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->category->SearchOperators = ["=", "<>"];
        $this->Fields['category'] = &$this->category;

        // roll_no
        $this->roll_no = new DbField(
            $this, // Table
            'x_roll_no', // Variable name
            'roll_no', // Name
            '`roll_no`', // Expression
            '`roll_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`roll_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->roll_no->InputTextType = "text";
        $this->roll_no->Raw = true;
        $this->roll_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->roll_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['roll_no'] = &$this->roll_no;

        // qty
        $this->qty = new DbField(
            $this, // Table
            'x_qty', // Variable name
            'qty', // Name
            '`qty`', // Expression
            '`qty`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty->InputTextType = "text";
        $this->qty->Raw = true;
        $this->qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['qty'] = &$this->qty;

        // consignee
        $this->consignee = new DbField(
            $this, // Table
            'x_consignee', // Variable name
            'consignee', // Name
            '`consignee`', // Expression
            '`consignee`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`consignee`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->consignee->InputTextType = "text";
        $this->consignee->Raw = true;
        $this->consignee->Sortable = false; // Allow sort
        $this->consignee->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->consignee->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['consignee'] = &$this->consignee;

        // buyer_barcode
        $this->buyer_barcode = new DbField(
            $this, // Table
            'x_buyer_barcode', // Variable name
            'buyer_barcode', // Name
            '`buyer_barcode`', // Expression
            '`buyer_barcode`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_barcode->InputTextType = "text";
        $this->buyer_barcode->Sortable = false; // Allow sort
        $this->buyer_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_barcode'] = &$this->buyer_barcode;

        // design_next
        $this->design_next = new DbField(
            $this, // Table
            'x_design_next', // Variable name
            'design_next', // Name
            '`design_next`', // Expression
            '`design_next`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design_next`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design_next->InputTextType = "text";
        $this->design_next->Sortable = false; // Allow sort
        $this->design_next->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['design_next'] = &$this->design_next;

        // q_sku
        $this->q_sku = new DbField(
            $this, // Table
            'x_q_sku', // Variable name
            'q_sku', // Name
            '`q_sku`', // Expression
            '`q_sku`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`q_sku`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->q_sku->addMethod("getDefault", fn() => 1.00);
        $this->q_sku->InputTextType = "text";
        $this->q_sku->Raw = true;
        $this->q_sku->Nullable = false; // NOT NULL field
        $this->q_sku->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->q_sku->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['q_sku'] = &$this->q_sku;

        // sqm_u
        $this->sqm_u = new DbField(
            $this, // Table
            'x_sqm_u', // Variable name
            'sqm_u', // Name
            '`sqm_u`', // Expression
            '`sqm_u`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm_u`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm_u->InputTextType = "text";
        $this->sqm_u->Raw = true;
        $this->sqm_u->Required = true; // Required field
        $this->sqm_u->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm_u->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sqm_u'] = &$this->sqm_u;

        // po_discount
        $this->po_discount = new DbField(
            $this, // Table
            'x_po_discount', // Variable name
            'po_discount', // Name
            '`po_discount`', // Expression
            '`po_discount`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_discount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_discount->addMethod("getDefault", fn() => 0.00);
        $this->po_discount->InputTextType = "text";
        $this->po_discount->Raw = true;
        $this->po_discount->Nullable = false; // NOT NULL field
        $this->po_discount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->po_discount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_discount'] = &$this->po_discount;

        // loom_plan
        $this->loom_plan = new DbField(
            $this, // Table
            'x_loom_plan', // Variable name
            'loom_plan', // Name
            '`loom_plan`', // Expression
            '`loom_plan`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`loom_plan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->loom_plan->addMethod("getDefault", fn() => "0");
        $this->loom_plan->InputTextType = "text";
        $this->loom_plan->Nullable = false; // NOT NULL field
        $this->loom_plan->Sortable = false; // Allow sort
        $this->loom_plan->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['loom_plan'] = &$this->loom_plan;

        // 11
        $this->_11 = new DbField(
            $this, // Table
            'x__11', // Variable name
            '11', // Name
            '`11`', // Expression
            '`11`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`11`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_11->InputTextType = "text";
        $this->_11->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['11'] = &$this->_11;

        // 12
        $this->_12 = new DbField(
            $this, // Table
            'x__12', // Variable name
            '12', // Name
            '`12`', // Expression
            '`12`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`12`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_12->InputTextType = "text";
        $this->_12->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['12'] = &$this->_12;

        // 13
        $this->_13 = new DbField(
            $this, // Table
            'x__13', // Variable name
            '13', // Name
            '`13`', // Expression
            '`13`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`13`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_13->InputTextType = "text";
        $this->_13->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['13'] = &$this->_13;

        // 14
        $this->_14 = new DbField(
            $this, // Table
            'x__14', // Variable name
            '14', // Name
            '`14`', // Expression
            '`14`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`14`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_14->InputTextType = "text";
        $this->_14->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['14'] = &$this->_14;

        // 15
        $this->_15 = new DbField(
            $this, // Table
            'x__15', // Variable name
            '15', // Name
            '`15`', // Expression
            '`15`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`15`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_15->InputTextType = "text";
        $this->_15->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['15'] = &$this->_15;

        // 16
        $this->_16 = new DbField(
            $this, // Table
            'x__16', // Variable name
            '16', // Name
            '`16`', // Expression
            '`16`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`16`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_16->InputTextType = "text";
        $this->_16->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['16'] = &$this->_16;

        // 17
        $this->_17 = new DbField(
            $this, // Table
            'x__17', // Variable name
            '17', // Name
            '`17`', // Expression
            '`17`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`17`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_17->InputTextType = "text";
        $this->_17->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['17'] = &$this->_17;

        // 18
        $this->_18 = new DbField(
            $this, // Table
            'x__18', // Variable name
            '18', // Name
            '`18`', // Expression
            '`18`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`18`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_18->InputTextType = "text";
        $this->_18->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['18'] = &$this->_18;

        // 19
        $this->_19 = new DbField(
            $this, // Table
            'x__19', // Variable name
            '19', // Name
            '`19`', // Expression
            '`19`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`19`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_19->InputTextType = "text";
        $this->_19->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['19'] = &$this->_19;

        // 20
        $this->_20 = new DbField(
            $this, // Table
            'x__20', // Variable name
            '20', // Name
            '`20`', // Expression
            '`20`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`20`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_20->InputTextType = "text";
        $this->_20->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['20'] = &$this->_20;

        // 21
        $this->_21 = new DbField(
            $this, // Table
            'x__21', // Variable name
            '21', // Name
            '`21`', // Expression
            '`21`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`21`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_21->InputTextType = "text";
        $this->_21->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['21'] = &$this->_21;

        // 22
        $this->_22 = new DbField(
            $this, // Table
            'x__22', // Variable name
            '22', // Name
            '`22`', // Expression
            '`22`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`22`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_22->InputTextType = "text";
        $this->_22->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['22'] = &$this->_22;

        // 23
        $this->_23 = new DbField(
            $this, // Table
            'x__23', // Variable name
            '23', // Name
            '`23`', // Expression
            '`23`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`23`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_23->InputTextType = "text";
        $this->_23->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['23'] = &$this->_23;

        // 24
        $this->_24 = new DbField(
            $this, // Table
            'x__24', // Variable name
            '24', // Name
            '`24`', // Expression
            '`24`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`24`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_24->InputTextType = "text";
        $this->_24->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['24'] = &$this->_24;

        // 25
        $this->_25 = new DbField(
            $this, // Table
            'x__25', // Variable name
            '25', // Name
            '`25`', // Expression
            '`25`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`25`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_25->InputTextType = "text";
        $this->_25->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['25'] = &$this->_25;

        // 26
        $this->_26 = new DbField(
            $this, // Table
            'x__26', // Variable name
            '26', // Name
            '`26`', // Expression
            '`26`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`26`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_26->InputTextType = "text";
        $this->_26->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['26'] = &$this->_26;

        // 27
        $this->_27 = new DbField(
            $this, // Table
            'x__27', // Variable name
            '27', // Name
            '`27`', // Expression
            '`27`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`27`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_27->InputTextType = "text";
        $this->_27->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['27'] = &$this->_27;

        // 28
        $this->_28 = new DbField(
            $this, // Table
            'x__28', // Variable name
            '28', // Name
            '`28`', // Expression
            '`28`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`28`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_28->InputTextType = "text";
        $this->_28->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['28'] = &$this->_28;

        // 29
        $this->_29 = new DbField(
            $this, // Table
            'x__29', // Variable name
            '29', // Name
            '`29`', // Expression
            '`29`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`29`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_29->InputTextType = "text";
        $this->_29->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['29'] = &$this->_29;

        // 30
        $this->_30 = new DbField(
            $this, // Table
            'x__30', // Variable name
            '30', // Name
            '`30`', // Expression
            '`30`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`30`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_30->InputTextType = "text";
        $this->_30->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['30'] = &$this->_30;

        // 31
        $this->_31 = new DbField(
            $this, // Table
            'x__31', // Variable name
            '31', // Name
            '`31`', // Expression
            '`31`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`31`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_31->InputTextType = "text";
        $this->_31->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['31'] = &$this->_31;

        // 32
        $this->_32 = new DbField(
            $this, // Table
            'x__32', // Variable name
            '32', // Name
            '`32`', // Expression
            '`32`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`32`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_32->InputTextType = "text";
        $this->_32->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['32'] = &$this->_32;

        // 33
        $this->_33 = new DbField(
            $this, // Table
            'x__33', // Variable name
            '33', // Name
            '`33`', // Expression
            '`33`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`33`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_33->InputTextType = "text";
        $this->_33->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['33'] = &$this->_33;

        // 34
        $this->_34 = new DbField(
            $this, // Table
            'x__34', // Variable name
            '34', // Name
            '`34`', // Expression
            '`34`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`34`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_34->InputTextType = "text";
        $this->_34->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['34'] = &$this->_34;

        // 35
        $this->_35 = new DbField(
            $this, // Table
            'x__35', // Variable name
            '35', // Name
            '`35`', // Expression
            '`35`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`35`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_35->InputTextType = "text";
        $this->_35->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['35'] = &$this->_35;

        // 36
        $this->_36 = new DbField(
            $this, // Table
            'x__36', // Variable name
            '36', // Name
            '`36`', // Expression
            '`36`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`36`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_36->InputTextType = "text";
        $this->_36->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['36'] = &$this->_36;

        // 37
        $this->_37 = new DbField(
            $this, // Table
            'x__37', // Variable name
            '37', // Name
            '`37`', // Expression
            '`37`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`37`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_37->InputTextType = "text";
        $this->_37->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['37'] = &$this->_37;

        // 38
        $this->_38 = new DbField(
            $this, // Table
            'x__38', // Variable name
            '38', // Name
            '`38`', // Expression
            '`38`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`38`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_38->InputTextType = "text";
        $this->_38->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['38'] = &$this->_38;

        // 39
        $this->_39 = new DbField(
            $this, // Table
            'x__39', // Variable name
            '39', // Name
            '`39`', // Expression
            '`39`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`39`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_39->InputTextType = "text";
        $this->_39->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['39'] = &$this->_39;

        // 40
        $this->_40 = new DbField(
            $this, // Table
            'x__40', // Variable name
            '40', // Name
            '`40`', // Expression
            '`40`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`40`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_40->InputTextType = "text";
        $this->_40->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['40'] = &$this->_40;

        // 41
        $this->_41 = new DbField(
            $this, // Table
            'x__41', // Variable name
            '41', // Name
            '`41`', // Expression
            '`41`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`41`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_41->InputTextType = "text";
        $this->_41->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['41'] = &$this->_41;

        // 42
        $this->_42 = new DbField(
            $this, // Table
            'x__42', // Variable name
            '42', // Name
            '`42`', // Expression
            '`42`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`42`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_42->InputTextType = "text";
        $this->_42->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['42'] = &$this->_42;

        // 43
        $this->_43 = new DbField(
            $this, // Table
            'x__43', // Variable name
            '43', // Name
            '`43`', // Expression
            '`43`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`43`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_43->InputTextType = "text";
        $this->_43->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['43'] = &$this->_43;

        // 44
        $this->_44 = new DbField(
            $this, // Table
            'x__44', // Variable name
            '44', // Name
            '`44`', // Expression
            '`44`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`44`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_44->InputTextType = "text";
        $this->_44->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['44'] = &$this->_44;

        // 45
        $this->_45 = new DbField(
            $this, // Table
            'x__45', // Variable name
            '45', // Name
            '`45`', // Expression
            '`45`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`45`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_45->InputTextType = "text";
        $this->_45->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['45'] = &$this->_45;

        // 46
        $this->_46 = new DbField(
            $this, // Table
            'x__46', // Variable name
            '46', // Name
            '`46`', // Expression
            '`46`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`46`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_46->InputTextType = "text";
        $this->_46->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['46'] = &$this->_46;

        // 47
        $this->_47 = new DbField(
            $this, // Table
            'x__47', // Variable name
            '47', // Name
            '`47`', // Expression
            '`47`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`47`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_47->InputTextType = "text";
        $this->_47->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['47'] = &$this->_47;

        // 48
        $this->_48 = new DbField(
            $this, // Table
            'x__48', // Variable name
            '48', // Name
            '`48`', // Expression
            '`48`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`48`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_48->InputTextType = "text";
        $this->_48->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['48'] = &$this->_48;

        // 49
        $this->_49 = new DbField(
            $this, // Table
            'x__49', // Variable name
            '49', // Name
            '`49`', // Expression
            '`49`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`49`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_49->InputTextType = "text";
        $this->_49->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['49'] = &$this->_49;

        // 50
        $this->_50 = new DbField(
            $this, // Table
            'x__50', // Variable name
            '50', // Name
            '`50`', // Expression
            '`50`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`50`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_50->InputTextType = "text";
        $this->_50->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['50'] = &$this->_50;

        // c_sqm
        $this->c_sqm = new DbField(
            $this, // Table
            'x_c_sqm', // Variable name
            'c_sqm', // Name
            '`c_sqm`', // Expression
            '`c_sqm`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`c_sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->c_sqm->addMethod("getDefault", fn() => 0.00);
        $this->c_sqm->InputTextType = "text";
        $this->c_sqm->Raw = true;
        $this->c_sqm->Nullable = false; // NOT NULL field
        $this->c_sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->c_sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['c_sqm'] = &$this->c_sqm;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packing_type->addMethod("getDefault", fn() => 301);
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Raw = true;
        $this->packing_type->Sortable = false; // Allow sort
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_type->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // order_date
        $this->order_date = new DbField(
            $this, // Table
            'x_order_date', // Variable name
            'order_date', // Name
            '`order_date`', // Expression
            CastDateFieldForLike("`order_date`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`order_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->order_date->InputTextType = "text";
        $this->order_date->Raw = true;
        $this->order_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->order_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['order_date'] = &$this->order_date;

        // qc_weaving
        $this->qc_weaving = new DbField(
            $this, // Table
            'x_qc_weaving', // Variable name
            'qc_weaving', // Name
            '`qc_weaving`', // Expression
            CastDateFieldForLike("`qc_weaving`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`qc_weaving`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qc_weaving->InputTextType = "text";
        $this->qc_weaving->Raw = true;
        $this->qc_weaving->Sortable = false; // Allow sort
        $this->qc_weaving->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->qc_weaving->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['qc_weaving'] = &$this->qc_weaving;

        // p_remarks
        $this->p_remarks = new DbField(
            $this, // Table
            'x_p_remarks', // Variable name
            'p_remarks', // Name
            '`p_remarks`', // Expression
            '`p_remarks`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p_remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->p_remarks->addMethod("getDefault", fn() => "--NA--");
        $this->p_remarks->InputTextType = "text";
        $this->p_remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['p_remarks'] = &$this->p_remarks;

        // roll_no_qty_tmp
        $this->roll_no_qty_tmp = new DbField(
            $this, // Table
            'x_roll_no_qty_tmp', // Variable name
            'roll_no_qty_tmp', // Name
            '`roll_no_qty_tmp`', // Expression
            '`roll_no_qty_tmp`', // Basic search expression
            131, // Type
            18, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`roll_no_qty_tmp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->roll_no_qty_tmp->InputTextType = "text";
        $this->roll_no_qty_tmp->Raw = true;
        $this->roll_no_qty_tmp->Nullable = false; // NOT NULL field
        $this->roll_no_qty_tmp->Required = true; // Required field
        $this->roll_no_qty_tmp->Sortable = false; // Allow sort
        $this->roll_no_qty_tmp->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->roll_no_qty_tmp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['roll_no_qty_tmp'] = &$this->roll_no_qty_tmp;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "bcode_old";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT CONCAT(COALESCE(`partner_ref`, ''),'" . ValueSeparator(1, $this->buyer_ref) . "',COALESCE(`barcode`,''),'" . ValueSeparator(2, $this->buyer_ref) . "',COALESCE(`partner_code`,'')) FROM partner_product_ref TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = bcode_old.buyer_ref LIMIT 1) AS EV__buyer_ref FROM bcode_old)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->buyer_ref->AdvancedSearch->SearchValue != "" ||
            $this->buyer_ref->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->buyer_ref->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->buyer_ref->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->pid->DbValue = $row['pid'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->weaving_works->DbValue = $row['weaving_works'];
        $this->current_works->DbValue = $row['current_works'];
        $this->po->DbValue = $row['po'];
        $this->_barcode->DbValue = $row['barcode'];
        $this->buyers_id->DbValue = $row['buyers_id'];
        $this->pp_id->DbValue = $row['pp_id'];
        $this->buyer_ref->DbValue = $row['buyer_ref'];
        $this->buyer_tid->DbValue = $row['buyer_tid'];
        $this->design->DbValue = $row['design'];
        $this->design_id->DbValue = $row['design_id'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->l_cm->DbValue = $row['l_cm'];
        $this->w_cm->DbValue = $row['w_cm'];
        $this->sqm->DbValue = $row['sqm'];
        $this->sqm_a->DbValue = $row['sqm_a'];
        $this->_2srm->DbValue = $row['2srm'];
        $this->_2srm_a->DbValue = $row['2srm_a'];
        $this->_4srm->DbValue = $row['4srm'];
        $this->_4srm_a->DbValue = $row['4srm_a'];
        $this->shape->DbValue = $row['shape'];
        $this->cs->DbValue = $row['cs'];
        $this->product_type->DbValue = $row['product_type'];
        $this->size_cm->DbValue = $row['size_cm'];
        $this->size_buyer->DbValue = $row['size_buyer'];
        $this->buyer_uid->DbValue = $row['buyer_uid'];
        $this->buyer_loc->DbValue = $row['buyer_loc'];
        $this->quantity->DbValue = $row['quantity'];
        $this->po_price->DbValue = $row['po_price'];
        $this->despatch_week->DbValue = $row['despatch_week'];
        $this->despatch_date->DbValue = $row['despatch_date'];
        $this->payment_plan->DbValue = $row['payment_plan'];
        $this->production_plan->DbValue = $row['production_plan'];
        $this->status->DbValue = $row['status'];
        $this->completed->DbValue = $row['completed'];
        $this->buyer_po->DbValue = $row['buyer_po'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->process->DbValue = $row['process'];
        $this->process_c->DbValue = $row['process_c'];
        $this->process_d->DbValue = $row['process_d'];
        $this->weight->DbValue = $row['weight'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->po_currency->DbValue = $row['po_currency'];
        $this->dispatch_week_p->DbValue = $row['dispatch_week_p'];
        $this->remarks->DbValue = $row['remarks'];
        $this->pl_no->DbValue = $row['pl_no'];
        $this->category->DbValue = $row['category'];
        $this->roll_no->DbValue = $row['roll_no'];
        $this->qty->DbValue = $row['qty'];
        $this->consignee->DbValue = $row['consignee'];
        $this->buyer_barcode->DbValue = $row['buyer_barcode'];
        $this->design_next->DbValue = $row['design_next'];
        $this->q_sku->DbValue = $row['q_sku'];
        $this->sqm_u->DbValue = $row['sqm_u'];
        $this->po_discount->DbValue = $row['po_discount'];
        $this->loom_plan->DbValue = $row['loom_plan'];
        $this->_11->DbValue = $row['11'];
        $this->_12->DbValue = $row['12'];
        $this->_13->DbValue = $row['13'];
        $this->_14->DbValue = $row['14'];
        $this->_15->DbValue = $row['15'];
        $this->_16->DbValue = $row['16'];
        $this->_17->DbValue = $row['17'];
        $this->_18->DbValue = $row['18'];
        $this->_19->DbValue = $row['19'];
        $this->_20->DbValue = $row['20'];
        $this->_21->DbValue = $row['21'];
        $this->_22->DbValue = $row['22'];
        $this->_23->DbValue = $row['23'];
        $this->_24->DbValue = $row['24'];
        $this->_25->DbValue = $row['25'];
        $this->_26->DbValue = $row['26'];
        $this->_27->DbValue = $row['27'];
        $this->_28->DbValue = $row['28'];
        $this->_29->DbValue = $row['29'];
        $this->_30->DbValue = $row['30'];
        $this->_31->DbValue = $row['31'];
        $this->_32->DbValue = $row['32'];
        $this->_33->DbValue = $row['33'];
        $this->_34->DbValue = $row['34'];
        $this->_35->DbValue = $row['35'];
        $this->_36->DbValue = $row['36'];
        $this->_37->DbValue = $row['37'];
        $this->_38->DbValue = $row['38'];
        $this->_39->DbValue = $row['39'];
        $this->_40->DbValue = $row['40'];
        $this->_41->DbValue = $row['41'];
        $this->_42->DbValue = $row['42'];
        $this->_43->DbValue = $row['43'];
        $this->_44->DbValue = $row['44'];
        $this->_45->DbValue = $row['45'];
        $this->_46->DbValue = $row['46'];
        $this->_47->DbValue = $row['47'];
        $this->_48->DbValue = $row['48'];
        $this->_49->DbValue = $row['49'];
        $this->_50->DbValue = $row['50'];
        $this->c_sqm->DbValue = $row['c_sqm'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->order_date->DbValue = $row['order_date'];
        $this->qc_weaving->DbValue = $row['qc_weaving'];
        $this->p_remarks->DbValue = $row['p_remarks'];
        $this->roll_no_qty_tmp->DbValue = $row['roll_no_qty_tmp'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("bcodeoldlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "bcodeoldview" => $Language->phrase("View"),
            "bcodeoldedit" => $Language->phrase("Edit"),
            "bcodeoldadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "bcodeoldlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "BcodeOldView",
            Config("API_ADD_ACTION") => "BcodeOldAdd",
            Config("API_EDIT_ACTION") => "BcodeOldEdit",
            Config("API_DELETE_ACTION") => "BcodeOldDelete",
            Config("API_LIST_ACTION") => "BcodeOldList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "bcodeoldlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("bcodeoldview", $parm);
        } else {
            $url = $this->keyUrl("bcodeoldview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "bcodeoldadd?" . $parm;
        } else {
            $url = "bcodeoldadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("bcodeoldedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("bcodeoldlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("bcodeoldadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("bcodeoldlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("bcodeolddelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->pid->setDbValue($row['pid']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->current_works->setDbValue($row['current_works']);
        $this->po->setDbValue($row['po']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->pp_id->setDbValue($row['pp_id']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        $this->buyer_tid->setDbValue($row['buyer_tid']);
        $this->design->setDbValue($row['design']);
        $this->design_id->setDbValue($row['design_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->_2srm->setDbValue($row['2srm']);
        $this->_2srm_a->setDbValue($row['2srm_a']);
        $this->_4srm->setDbValue($row['4srm']);
        $this->_4srm_a->setDbValue($row['4srm_a']);
        $this->shape->setDbValue($row['shape']);
        $this->cs->setDbValue($row['cs']);
        $this->product_type->setDbValue($row['product_type']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->size_buyer->setDbValue($row['size_buyer']);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->quantity->setDbValue($row['quantity']);
        $this->po_price->setDbValue($row['po_price']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->payment_plan->setDbValue($row['payment_plan']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->status->setDbValue($row['status']);
        $this->completed->setDbValue($row['completed']);
        $this->buyer_po->setDbValue($row['buyer_po']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->process->setDbValue($row['process']);
        $this->process_c->setDbValue($row['process_c']);
        $this->process_d->setDbValue($row['process_d']);
        $this->weight->setDbValue($row['weight']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->po_currency->setDbValue($row['po_currency']);
        $this->dispatch_week_p->setDbValue($row['dispatch_week_p']);
        $this->remarks->setDbValue($row['remarks']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->category->setDbValue($row['category']);
        $this->roll_no->setDbValue($row['roll_no']);
        $this->qty->setDbValue($row['qty']);
        $this->consignee->setDbValue($row['consignee']);
        $this->buyer_barcode->setDbValue($row['buyer_barcode']);
        $this->design_next->setDbValue($row['design_next']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->sqm_u->setDbValue($row['sqm_u']);
        $this->po_discount->setDbValue($row['po_discount']);
        $this->loom_plan->setDbValue($row['loom_plan']);
        $this->_11->setDbValue($row['11']);
        $this->_12->setDbValue($row['12']);
        $this->_13->setDbValue($row['13']);
        $this->_14->setDbValue($row['14']);
        $this->_15->setDbValue($row['15']);
        $this->_16->setDbValue($row['16']);
        $this->_17->setDbValue($row['17']);
        $this->_18->setDbValue($row['18']);
        $this->_19->setDbValue($row['19']);
        $this->_20->setDbValue($row['20']);
        $this->_21->setDbValue($row['21']);
        $this->_22->setDbValue($row['22']);
        $this->_23->setDbValue($row['23']);
        $this->_24->setDbValue($row['24']);
        $this->_25->setDbValue($row['25']);
        $this->_26->setDbValue($row['26']);
        $this->_27->setDbValue($row['27']);
        $this->_28->setDbValue($row['28']);
        $this->_29->setDbValue($row['29']);
        $this->_30->setDbValue($row['30']);
        $this->_31->setDbValue($row['31']);
        $this->_32->setDbValue($row['32']);
        $this->_33->setDbValue($row['33']);
        $this->_34->setDbValue($row['34']);
        $this->_35->setDbValue($row['35']);
        $this->_36->setDbValue($row['36']);
        $this->_37->setDbValue($row['37']);
        $this->_38->setDbValue($row['38']);
        $this->_39->setDbValue($row['39']);
        $this->_40->setDbValue($row['40']);
        $this->_41->setDbValue($row['41']);
        $this->_42->setDbValue($row['42']);
        $this->_43->setDbValue($row['43']);
        $this->_44->setDbValue($row['44']);
        $this->_45->setDbValue($row['45']);
        $this->_46->setDbValue($row['46']);
        $this->_47->setDbValue($row['47']);
        $this->_48->setDbValue($row['48']);
        $this->_49->setDbValue($row['49']);
        $this->_50->setDbValue($row['50']);
        $this->c_sqm->setDbValue($row['c_sqm']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->order_date->setDbValue($row['order_date']);
        $this->qc_weaving->setDbValue($row['qc_weaving']);
        $this->p_remarks->setDbValue($row['p_remarks']);
        $this->roll_no_qty_tmp->setDbValue($row['roll_no_qty_tmp']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "BcodeOldList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // pid

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // weaving_works
        $this->weaving_works->CellCssStyle = "white-space: nowrap;";

        // current_works
        $this->current_works->CellCssStyle = "white-space: nowrap;";

        // po

        // barcode
        $this->_barcode->CellCssStyle = "min-width: 300px;";

        // buyers_id

        // pp_id

        // buyer_ref

        // buyer_tid
        $this->buyer_tid->CellCssStyle = "white-space: nowrap;";

        // design
        $this->design->CellCssStyle = "white-space: nowrap;";

        // design_id

        // batch_no

        // l_cm
        $this->l_cm->CellCssStyle = "white-space: nowrap;";

        // w_cm
        $this->w_cm->CellCssStyle = "white-space: nowrap;";

        // sqm

        // sqm_a
        $this->sqm_a->CellCssStyle = "white-space: nowrap;";

        // 2srm
        $this->_2srm->CellCssStyle = "white-space: nowrap;";

        // 2srm_a
        $this->_2srm_a->CellCssStyle = "white-space: nowrap;";

        // 4srm
        $this->_4srm->CellCssStyle = "white-space: nowrap;";

        // 4srm_a
        $this->_4srm_a->CellCssStyle = "white-space: nowrap;";

        // shape

        // cs

        // product_type

        // size_cm

        // size_buyer

        // buyer_uid
        $this->buyer_uid->CellCssStyle = "min-width: 200px;";

        // buyer_loc

        // quantity

        // po_price

        // despatch_week

        // despatch_date

        // payment_plan

        // production_plan

        // status

        // completed

        // buyer_po

        // jc_no

        // process

        // process_c

        // process_d

        // weight

        // operator

        // datetime

        // po_currency

        // dispatch_week_p

        // remarks

        // pl_no

        // category

        // roll_no

        // qty

        // consignee
        $this->consignee->CellCssStyle = "white-space: nowrap;";

        // buyer_barcode
        $this->buyer_barcode->CellCssStyle = "white-space: nowrap;";

        // design_next
        $this->design_next->CellCssStyle = "white-space: nowrap;";

        // q_sku

        // sqm_u

        // po_discount

        // loom_plan
        $this->loom_plan->CellCssStyle = "white-space: nowrap;";

        // 11
        $this->_11->CellCssStyle = "white-space: nowrap;";

        // 12
        $this->_12->CellCssStyle = "white-space: nowrap;";

        // 13
        $this->_13->CellCssStyle = "white-space: nowrap;";

        // 14
        $this->_14->CellCssStyle = "white-space: nowrap;";

        // 15
        $this->_15->CellCssStyle = "white-space: nowrap;";

        // 16
        $this->_16->CellCssStyle = "white-space: nowrap;";

        // 17
        $this->_17->CellCssStyle = "white-space: nowrap;";

        // 18
        $this->_18->CellCssStyle = "white-space: nowrap;";

        // 19
        $this->_19->CellCssStyle = "white-space: nowrap;";

        // 20
        $this->_20->CellCssStyle = "white-space: nowrap;";

        // 21
        $this->_21->CellCssStyle = "white-space: nowrap;";

        // 22
        $this->_22->CellCssStyle = "white-space: nowrap;";

        // 23
        $this->_23->CellCssStyle = "white-space: nowrap;";

        // 24
        $this->_24->CellCssStyle = "white-space: nowrap;";

        // 25
        $this->_25->CellCssStyle = "white-space: nowrap;";

        // 26
        $this->_26->CellCssStyle = "white-space: nowrap;";

        // 27
        $this->_27->CellCssStyle = "white-space: nowrap;";

        // 28
        $this->_28->CellCssStyle = "white-space: nowrap;";

        // 29
        $this->_29->CellCssStyle = "white-space: nowrap;";

        // 30
        $this->_30->CellCssStyle = "white-space: nowrap;";

        // 31
        $this->_31->CellCssStyle = "white-space: nowrap;";

        // 32
        $this->_32->CellCssStyle = "white-space: nowrap;";

        // 33
        $this->_33->CellCssStyle = "white-space: nowrap;";

        // 34
        $this->_34->CellCssStyle = "white-space: nowrap;";

        // 35
        $this->_35->CellCssStyle = "white-space: nowrap;";

        // 36
        $this->_36->CellCssStyle = "white-space: nowrap;";

        // 37
        $this->_37->CellCssStyle = "white-space: nowrap;";

        // 38
        $this->_38->CellCssStyle = "white-space: nowrap;";

        // 39
        $this->_39->CellCssStyle = "white-space: nowrap;";

        // 40
        $this->_40->CellCssStyle = "white-space: nowrap;";

        // 41
        $this->_41->CellCssStyle = "white-space: nowrap;";

        // 42
        $this->_42->CellCssStyle = "white-space: nowrap;";

        // 43
        $this->_43->CellCssStyle = "white-space: nowrap;";

        // 44
        $this->_44->CellCssStyle = "white-space: nowrap;";

        // 45
        $this->_45->CellCssStyle = "white-space: nowrap;";

        // 46
        $this->_46->CellCssStyle = "white-space: nowrap;";

        // 47
        $this->_47->CellCssStyle = "white-space: nowrap;";

        // 48
        $this->_48->CellCssStyle = "white-space: nowrap;";

        // 49
        $this->_49->CellCssStyle = "white-space: nowrap;";

        // 50
        $this->_50->CellCssStyle = "white-space: nowrap;";

        // c_sqm

        // packing_type
        $this->packing_type->CellCssStyle = "white-space: nowrap;";

        // order_date

        // qc_weaving
        $this->qc_weaving->CellCssStyle = "white-space: nowrap;";

        // p_remarks

        // roll_no_qty_tmp
        $this->roll_no_qty_tmp->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // pid
        $this->pid->ViewValue = $this->pid->CurrentValue;
        $this->pid->ViewValue = FormatNumber($this->pid->ViewValue, $this->pid->formatPattern());

        // grp
        $this->grp->ViewValue = $this->grp->CurrentValue;
        $this->grp->ViewValue = FormatNumber($this->grp->ViewValue, $this->grp->formatPattern());

        // s_grp
        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
        $this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, $this->s_grp->formatPattern());

        // weaving_works
        $curVal = strval($this->weaving_works->CurrentValue);
        if ($curVal != "") {
            $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
            if ($this->weaving_works->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                    $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                } else {
                    $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                }
            }
        } else {
            $this->weaving_works->ViewValue = null;
        }

        // current_works
        $curVal = strval($this->current_works->CurrentValue);
        if ($curVal != "") {
            $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
            if ($this->current_works->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                    $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                } else {
                    $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                }
            }
        } else {
            $this->current_works->ViewValue = null;
        }

        // po
        $this->po->ViewValue = $this->po->CurrentValue;
        $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

        // barcode
        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

        // buyers_id
        $curVal = strval($this->buyers_id->CurrentValue);
        if ($curVal != "") {
            $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            if ($this->buyers_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                } else {
                    $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                }
            }
        } else {
            $this->buyers_id->ViewValue = null;
        }

        // pp_id
        $this->pp_id->ViewValue = $this->pp_id->CurrentValue;
        $curVal = strval($this->pp_id->CurrentValue);
        if ($curVal != "") {
            $this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
            if ($this->pp_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pp_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->pp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pp_id->Lookup->renderViewRow($rswrk[0]);
                    $this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
                } else {
                    $this->pp_id->ViewValue = FormatNumber($this->pp_id->CurrentValue, $this->pp_id->formatPattern());
                }
            }
        } else {
            $this->pp_id->ViewValue = null;
        }

        // buyer_ref
        if ($this->buyer_ref->VirtualValue != "") {
            $this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
        } else {
            $curVal = strval($this->buyer_ref->CurrentValue);
            if ($curVal != "") {
                $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
                if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                    } else {
                        $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                    }
                }
            } else {
                $this->buyer_ref->ViewValue = null;
            }
        }

        // buyer_tid
        $this->buyer_tid->ViewValue = $this->buyer_tid->CurrentValue;

        // design
        $this->design->ViewValue = $this->design->CurrentValue;
        $curVal = strval($this->design->CurrentValue);
        if ($curVal != "") {
            $this->design->ViewValue = $this->design->lookupCacheOption($curVal);
            if ($this->design->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->design->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->design->getSelectFilter($this); // PHP
                $sqlWrk = $this->design->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->design->Lookup->renderViewRow($rswrk[0]);
                    $this->design->ViewValue = $this->design->displayValue($arwrk);
                } else {
                    $this->design->ViewValue = $this->design->CurrentValue;
                }
            }
        } else {
            $this->design->ViewValue = null;
        }

        // design_id
        $curVal = strval($this->design_id->CurrentValue);
        if ($curVal != "") {
            $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
            if ($this->design_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                    $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                } else {
                    $this->design_id->ViewValue = $this->design_id->CurrentValue;
                }
            }
        } else {
            $this->design_id->ViewValue = null;
        }

        // batch_no
        $curVal = strval($this->batch_no->CurrentValue);
        if ($curVal != "") {
            $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            if ($this->batch_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                }
            }
        } else {
            $this->batch_no->ViewValue = null;
        }

        // l_cm
        $this->l_cm->ViewValue = $this->l_cm->CurrentValue;
        $this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, $this->l_cm->formatPattern());

        // w_cm
        $this->w_cm->ViewValue = $this->w_cm->CurrentValue;
        $this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, $this->w_cm->formatPattern());

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // sqm_a
        $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
        $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

        // 2srm
        $this->_2srm->ViewValue = $this->_2srm->CurrentValue;
        $this->_2srm->ViewValue = FormatNumber($this->_2srm->ViewValue, $this->_2srm->formatPattern());

        // 2srm_a
        $this->_2srm_a->ViewValue = $this->_2srm_a->CurrentValue;
        $this->_2srm_a->ViewValue = FormatNumber($this->_2srm_a->ViewValue, $this->_2srm_a->formatPattern());

        // 4srm
        $this->_4srm->ViewValue = $this->_4srm->CurrentValue;
        $this->_4srm->ViewValue = FormatNumber($this->_4srm->ViewValue, $this->_4srm->formatPattern());

        // 4srm_a
        $this->_4srm_a->ViewValue = $this->_4srm_a->CurrentValue;
        $this->_4srm_a->ViewValue = FormatNumber($this->_4srm_a->ViewValue, $this->_4srm_a->formatPattern());

        // shape
        $curVal = strval($this->shape->CurrentValue);
        if ($curVal != "") {
            $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            if ($this->shape->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                    $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                } else {
                    $this->shape->ViewValue = FormatNumber($this->shape->CurrentValue, $this->shape->formatPattern());
                }
            }
        } else {
            $this->shape->ViewValue = null;
        }

        // cs
        if (strval($this->cs->CurrentValue) != "") {
            $this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
        } else {
            $this->cs->ViewValue = null;
        }

        // product_type
        if (strval($this->product_type->CurrentValue) != "") {
            $this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
        } else {
            $this->product_type->ViewValue = null;
        }

        // size_cm
        $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

        // size_buyer
        $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

        // buyer_uid
        $this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;

        // buyer_loc
        $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // po_price
        $this->po_price->ViewValue = $this->po_price->CurrentValue;

        // despatch_week
        $curVal = strval($this->despatch_week->CurrentValue);
        if ($curVal != "") {
            $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            if ($this->despatch_week->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                    $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                } else {
                    $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                }
            }
        } else {
            $this->despatch_week->ViewValue = null;
        }

        // despatch_date
        $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
        $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

        // payment_plan
        $curVal = strval($this->payment_plan->CurrentValue);
        if ($curVal != "") {
            $this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
            if ($this->payment_plan->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->payment_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->payment_plan->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->payment_plan->Lookup->renderViewRow($rswrk[0]);
                    $this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
                } else {
                    $this->payment_plan->ViewValue = FormatNumber($this->payment_plan->CurrentValue, $this->payment_plan->formatPattern());
                }
            }
        } else {
            $this->payment_plan->ViewValue = null;
        }

        // production_plan
        if (strval($this->production_plan->CurrentValue) != "") {
            $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
        } else {
            $this->production_plan->ViewValue = null;
        }

        // status
        $curVal = strval($this->status->CurrentValue);
        if ($curVal != "") {
            $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
            if ($this->status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                    $this->status->ViewValue = $this->status->displayValue($arwrk);
                } else {
                    $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                }
            }
        } else {
            $this->status->ViewValue = null;
        }

        // completed
        if (strval($this->completed->CurrentValue) != "") {
            $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
        } else {
            $this->completed->ViewValue = null;
        }

        // buyer_po
        $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
        $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process->Lookup->renderViewRow($row);
                        $this->process->ViewValue->add($this->process->displayValue($arwrk));
                    }
                } else {
                    $this->process->ViewValue = $this->process->CurrentValue;
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // process_c
        $curVal = strval($this->process_c->CurrentValue);
        if ($curVal != "") {
            $this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
            if ($this->process_c->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->process_c->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_c->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->process_c->getSelectFilter($this); // PHP
                $sqlWrk = $this->process_c->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process_c->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process_c->Lookup->renderViewRow($row);
                        $this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
                    }
                } else {
                    $this->process_c->ViewValue = $this->process_c->CurrentValue;
                }
            }
        } else {
            $this->process_c->ViewValue = null;
        }

        // process_d
        $curVal = strval($this->process_d->CurrentValue);
        if ($curVal != "") {
            $this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
            if ($this->process_d->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->process_d->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_d->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->process_d->getSelectFilter($this); // PHP
                $sqlWrk = $this->process_d->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process_d->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process_d->Lookup->renderViewRow($row);
                        $this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
                    }
                } else {
                    $this->process_d->ViewValue = $this->process_d->CurrentValue;
                }
            }
        } else {
            $this->process_d->ViewValue = null;
        }

        // weight
        $this->weight->ViewValue = $this->weight->CurrentValue;
        $this->weight->ViewValue = FormatNumber($this->weight->ViewValue, $this->weight->formatPattern());

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // po_currency
        $curVal = strval($this->po_currency->CurrentValue);
        if ($curVal != "") {
            $this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
            if ($this->po_currency->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->po_currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->po_currency->Lookup->renderViewRow($rswrk[0]);
                    $this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
                } else {
                    $this->po_currency->ViewValue = FormatNumber($this->po_currency->CurrentValue, $this->po_currency->formatPattern());
                }
            }
        } else {
            $this->po_currency->ViewValue = null;
        }

        // dispatch_week_p
        $curVal = strval($this->dispatch_week_p->CurrentValue);
        if ($curVal != "") {
            $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
            if ($this->dispatch_week_p->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->dispatch_week_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->dispatch_week_p->Lookup->renderViewRow($rswrk[0]);
                    $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
                } else {
                    $this->dispatch_week_p->ViewValue = FormatNumber($this->dispatch_week_p->CurrentValue, $this->dispatch_week_p->formatPattern());
                }
            }
        } else {
            $this->dispatch_week_p->ViewValue = null;
        }

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // pl_no
        $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
        $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

        // category
        $curVal = strval($this->category->CurrentValue);
        if ($curVal != "") {
            $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            if ($this->category->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                    $this->category->ViewValue = $this->category->displayValue($arwrk);
                } else {
                    $this->category->ViewValue = $this->category->CurrentValue;
                }
            }
        } else {
            $this->category->ViewValue = null;
        }

        // roll_no
        $this->roll_no->ViewValue = $this->roll_no->CurrentValue;
        $this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, $this->roll_no->formatPattern());

        // qty
        $this->qty->ViewValue = $this->qty->CurrentValue;
        $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

        // consignee
        $this->consignee->ViewValue = $this->consignee->CurrentValue;
        $this->consignee->ViewValue = FormatNumber($this->consignee->ViewValue, $this->consignee->formatPattern());

        // buyer_barcode
        $this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;

        // design_next
        $this->design_next->ViewValue = $this->design_next->CurrentValue;

        // q_sku
        $this->q_sku->ViewValue = $this->q_sku->CurrentValue;
        $this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, $this->q_sku->formatPattern());

        // sqm_u
        $this->sqm_u->ViewValue = $this->sqm_u->CurrentValue;
        $this->sqm_u->ViewValue = FormatNumber($this->sqm_u->ViewValue, $this->sqm_u->formatPattern());

        // po_discount
        $this->po_discount->ViewValue = $this->po_discount->CurrentValue;
        $this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, $this->po_discount->formatPattern());

        // loom_plan
        $this->loom_plan->ViewValue = $this->loom_plan->CurrentValue;

        // 11
        $this->_11->ViewValue = $this->_11->CurrentValue;

        // 12
        $this->_12->ViewValue = $this->_12->CurrentValue;

        // 13
        $this->_13->ViewValue = $this->_13->CurrentValue;

        // 14
        $this->_14->ViewValue = $this->_14->CurrentValue;

        // 15
        $this->_15->ViewValue = $this->_15->CurrentValue;

        // 16
        $this->_16->ViewValue = $this->_16->CurrentValue;

        // 17
        $this->_17->ViewValue = $this->_17->CurrentValue;

        // 18
        $this->_18->ViewValue = $this->_18->CurrentValue;

        // 19
        $this->_19->ViewValue = $this->_19->CurrentValue;

        // 20
        $this->_20->ViewValue = $this->_20->CurrentValue;

        // 21
        $this->_21->ViewValue = $this->_21->CurrentValue;

        // 22
        $this->_22->ViewValue = $this->_22->CurrentValue;

        // 23
        $this->_23->ViewValue = $this->_23->CurrentValue;

        // 24
        $this->_24->ViewValue = $this->_24->CurrentValue;

        // 25
        $this->_25->ViewValue = $this->_25->CurrentValue;

        // 26
        $this->_26->ViewValue = $this->_26->CurrentValue;

        // 27
        $this->_27->ViewValue = $this->_27->CurrentValue;

        // 28
        $this->_28->ViewValue = $this->_28->CurrentValue;

        // 29
        $this->_29->ViewValue = $this->_29->CurrentValue;

        // 30
        $this->_30->ViewValue = $this->_30->CurrentValue;

        // 31
        $this->_31->ViewValue = $this->_31->CurrentValue;

        // 32
        $this->_32->ViewValue = $this->_32->CurrentValue;

        // 33
        $this->_33->ViewValue = $this->_33->CurrentValue;

        // 34
        $this->_34->ViewValue = $this->_34->CurrentValue;

        // 35
        $this->_35->ViewValue = $this->_35->CurrentValue;

        // 36
        $this->_36->ViewValue = $this->_36->CurrentValue;

        // 37
        $this->_37->ViewValue = $this->_37->CurrentValue;

        // 38
        $this->_38->ViewValue = $this->_38->CurrentValue;

        // 39
        $this->_39->ViewValue = $this->_39->CurrentValue;

        // 40
        $this->_40->ViewValue = $this->_40->CurrentValue;

        // 41
        $this->_41->ViewValue = $this->_41->CurrentValue;

        // 42
        $this->_42->ViewValue = $this->_42->CurrentValue;

        // 43
        $this->_43->ViewValue = $this->_43->CurrentValue;

        // 44
        $this->_44->ViewValue = $this->_44->CurrentValue;

        // 45
        $this->_45->ViewValue = $this->_45->CurrentValue;

        // 46
        $this->_46->ViewValue = $this->_46->CurrentValue;

        // 47
        $this->_47->ViewValue = $this->_47->CurrentValue;

        // 48
        $this->_48->ViewValue = $this->_48->CurrentValue;

        // 49
        $this->_49->ViewValue = $this->_49->CurrentValue;

        // 50
        $this->_50->ViewValue = $this->_50->CurrentValue;

        // c_sqm
        $this->c_sqm->ViewValue = $this->c_sqm->CurrentValue;
        $this->c_sqm->ViewValue = FormatNumber($this->c_sqm->ViewValue, $this->c_sqm->formatPattern());

        // packing_type
        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
        $this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, $this->packing_type->formatPattern());

        // order_date
        $this->order_date->ViewValue = $this->order_date->CurrentValue;
        $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

        // qc_weaving
        $this->qc_weaving->ViewValue = $this->qc_weaving->CurrentValue;
        $this->qc_weaving->ViewValue = FormatDateTime($this->qc_weaving->ViewValue, $this->qc_weaving->formatPattern());

        // p_remarks
        $this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;

        // roll_no_qty_tmp
        $this->roll_no_qty_tmp->ViewValue = $this->roll_no_qty_tmp->CurrentValue;
        $this->roll_no_qty_tmp->ViewValue = FormatNumber($this->roll_no_qty_tmp->ViewValue, $this->roll_no_qty_tmp->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // pid
        $this->pid->HrefValue = "";
        $this->pid->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // s_grp
        $this->s_grp->HrefValue = "";
        $this->s_grp->TooltipValue = "";

        // weaving_works
        $this->weaving_works->HrefValue = "";
        $this->weaving_works->TooltipValue = "";

        // current_works
        $this->current_works->HrefValue = "";
        $this->current_works->TooltipValue = "";

        // po
        $this->po->HrefValue = "";
        $this->po->TooltipValue = "";

        // barcode
        $this->_barcode->HrefValue = "";
        $this->_barcode->TooltipValue = "";

        // buyers_id
        if (!EmptyValue($this->buyers_id->CurrentValue)) {
            $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
            $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
            }
        } else {
            $this->buyers_id->HrefValue = "";
        }
        $this->buyers_id->TooltipValue = "";

        // pp_id
        $this->pp_id->HrefValue = "";
        $this->pp_id->TooltipValue = "";

        // buyer_ref
        if (!EmptyValue($this->buyer_ref->CurrentValue)) {
            $this->buyer_ref->HrefValue = $this->buyer_ref->getLinkPrefix() . $this->buyer_ref->CurrentValue; // Add prefix/suffix
            $this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
            }
        } else {
            $this->buyer_ref->HrefValue = "";
        }
        $this->buyer_ref->TooltipValue = "";

        // buyer_tid
        $this->buyer_tid->HrefValue = "";
        $this->buyer_tid->TooltipValue = "";

        // design
        $this->design->HrefValue = "";
        $this->design->TooltipValue = "";

        // design_id
        if (!EmptyValue($this->design_id->CurrentValue)) {
            $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . (!empty($this->design_id->ViewValue) && !is_array($this->design_id->ViewValue) ? RemoveHtml($this->design_id->ViewValue) : $this->design_id->CurrentValue); // Add prefix/suffix
            $this->design_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
            }
        } else {
            $this->design_id->HrefValue = "";
        }
        $this->design_id->TooltipValue = "";

        // batch_no
        if (!EmptyValue($this->batch_no->CurrentValue)) {
            $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
            $this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
            }
        } else {
            $this->batch_no->HrefValue = "";
        }
        $this->batch_no->TooltipValue = "";

        // l_cm
        $this->l_cm->HrefValue = "";
        $this->l_cm->TooltipValue = "";

        // w_cm
        $this->w_cm->HrefValue = "";
        $this->w_cm->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // sqm_a
        $this->sqm_a->HrefValue = "";
        $this->sqm_a->TooltipValue = "";

        // 2srm
        $this->_2srm->HrefValue = "";
        $this->_2srm->TooltipValue = "";

        // 2srm_a
        $this->_2srm_a->HrefValue = "";
        $this->_2srm_a->TooltipValue = "";

        // 4srm
        $this->_4srm->HrefValue = "";
        $this->_4srm->TooltipValue = "";

        // 4srm_a
        $this->_4srm_a->HrefValue = "";
        $this->_4srm_a->TooltipValue = "";

        // shape
        $this->shape->HrefValue = "";
        $this->shape->TooltipValue = "";

        // cs
        $this->cs->HrefValue = "";
        $this->cs->TooltipValue = "";

        // product_type
        $this->product_type->HrefValue = "";
        $this->product_type->TooltipValue = "";

        // size_cm
        $this->size_cm->HrefValue = "";
        $this->size_cm->TooltipValue = "";

        // size_buyer
        $this->size_buyer->HrefValue = "";
        $this->size_buyer->TooltipValue = "";

        // buyer_uid
        $this->buyer_uid->HrefValue = "";
        $this->buyer_uid->TooltipValue = "";

        // buyer_loc
        $this->buyer_loc->HrefValue = "";
        $this->buyer_loc->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // po_price
        $this->po_price->HrefValue = "";
        $this->po_price->TooltipValue = "";

        // despatch_week
        $this->despatch_week->HrefValue = "";
        $this->despatch_week->TooltipValue = "";

        // despatch_date
        $this->despatch_date->HrefValue = "";
        $this->despatch_date->TooltipValue = "";

        // payment_plan
        $this->payment_plan->HrefValue = "";
        $this->payment_plan->TooltipValue = "";

        // production_plan
        $this->production_plan->HrefValue = "";
        $this->production_plan->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // completed
        $this->completed->HrefValue = "";
        $this->completed->TooltipValue = "";

        // buyer_po
        $this->buyer_po->HrefValue = "";
        $this->buyer_po->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // process
        $this->process->HrefValue = "";
        $this->process->TooltipValue = "";

        // process_c
        $this->process_c->HrefValue = "";
        $this->process_c->TooltipValue = "";

        // process_d
        $this->process_d->HrefValue = "";
        $this->process_d->TooltipValue = "";

        // weight
        $this->weight->HrefValue = "";
        $this->weight->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // po_currency
        $this->po_currency->HrefValue = "";
        $this->po_currency->TooltipValue = "";

        // dispatch_week_p
        $this->dispatch_week_p->HrefValue = "";
        $this->dispatch_week_p->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // pl_no
        $this->pl_no->HrefValue = "";
        $this->pl_no->TooltipValue = "";

        // category
        $this->category->HrefValue = "";
        $this->category->TooltipValue = "";

        // roll_no
        $this->roll_no->HrefValue = "";
        $this->roll_no->TooltipValue = "";

        // qty
        $this->qty->HrefValue = "";
        $this->qty->TooltipValue = "";

        // consignee
        $this->consignee->HrefValue = "";
        $this->consignee->TooltipValue = "";

        // buyer_barcode
        $this->buyer_barcode->HrefValue = "";
        $this->buyer_barcode->TooltipValue = "";

        // design_next
        $this->design_next->HrefValue = "";
        $this->design_next->TooltipValue = "";

        // q_sku
        $this->q_sku->HrefValue = "";
        $this->q_sku->TooltipValue = "";

        // sqm_u
        $this->sqm_u->HrefValue = "";
        $this->sqm_u->TooltipValue = "";

        // po_discount
        $this->po_discount->HrefValue = "";
        $this->po_discount->TooltipValue = "";

        // loom_plan
        $this->loom_plan->HrefValue = "";
        $this->loom_plan->TooltipValue = "";

        // 11
        $this->_11->HrefValue = "";
        $this->_11->TooltipValue = "";

        // 12
        $this->_12->HrefValue = "";
        $this->_12->TooltipValue = "";

        // 13
        $this->_13->HrefValue = "";
        $this->_13->TooltipValue = "";

        // 14
        $this->_14->HrefValue = "";
        $this->_14->TooltipValue = "";

        // 15
        $this->_15->HrefValue = "";
        $this->_15->TooltipValue = "";

        // 16
        $this->_16->HrefValue = "";
        $this->_16->TooltipValue = "";

        // 17
        $this->_17->HrefValue = "";
        $this->_17->TooltipValue = "";

        // 18
        $this->_18->HrefValue = "";
        $this->_18->TooltipValue = "";

        // 19
        $this->_19->HrefValue = "";
        $this->_19->TooltipValue = "";

        // 20
        $this->_20->HrefValue = "";
        $this->_20->TooltipValue = "";

        // 21
        $this->_21->HrefValue = "";
        $this->_21->TooltipValue = "";

        // 22
        $this->_22->HrefValue = "";
        $this->_22->TooltipValue = "";

        // 23
        $this->_23->HrefValue = "";
        $this->_23->TooltipValue = "";

        // 24
        $this->_24->HrefValue = "";
        $this->_24->TooltipValue = "";

        // 25
        $this->_25->HrefValue = "";
        $this->_25->TooltipValue = "";

        // 26
        $this->_26->HrefValue = "";
        $this->_26->TooltipValue = "";

        // 27
        $this->_27->HrefValue = "";
        $this->_27->TooltipValue = "";

        // 28
        $this->_28->HrefValue = "";
        $this->_28->TooltipValue = "";

        // 29
        $this->_29->HrefValue = "";
        $this->_29->TooltipValue = "";

        // 30
        $this->_30->HrefValue = "";
        $this->_30->TooltipValue = "";

        // 31
        $this->_31->HrefValue = "";
        $this->_31->TooltipValue = "";

        // 32
        $this->_32->HrefValue = "";
        $this->_32->TooltipValue = "";

        // 33
        $this->_33->HrefValue = "";
        $this->_33->TooltipValue = "";

        // 34
        $this->_34->HrefValue = "";
        $this->_34->TooltipValue = "";

        // 35
        $this->_35->HrefValue = "";
        $this->_35->TooltipValue = "";

        // 36
        $this->_36->HrefValue = "";
        $this->_36->TooltipValue = "";

        // 37
        $this->_37->HrefValue = "";
        $this->_37->TooltipValue = "";

        // 38
        $this->_38->HrefValue = "";
        $this->_38->TooltipValue = "";

        // 39
        $this->_39->HrefValue = "";
        $this->_39->TooltipValue = "";

        // 40
        $this->_40->HrefValue = "";
        $this->_40->TooltipValue = "";

        // 41
        $this->_41->HrefValue = "";
        $this->_41->TooltipValue = "";

        // 42
        $this->_42->HrefValue = "";
        $this->_42->TooltipValue = "";

        // 43
        $this->_43->HrefValue = "";
        $this->_43->TooltipValue = "";

        // 44
        $this->_44->HrefValue = "";
        $this->_44->TooltipValue = "";

        // 45
        $this->_45->HrefValue = "";
        $this->_45->TooltipValue = "";

        // 46
        $this->_46->HrefValue = "";
        $this->_46->TooltipValue = "";

        // 47
        $this->_47->HrefValue = "";
        $this->_47->TooltipValue = "";

        // 48
        $this->_48->HrefValue = "";
        $this->_48->TooltipValue = "";

        // 49
        $this->_49->HrefValue = "";
        $this->_49->TooltipValue = "";

        // 50
        $this->_50->HrefValue = "";
        $this->_50->TooltipValue = "";

        // c_sqm
        $this->c_sqm->HrefValue = "";
        $this->c_sqm->TooltipValue = "";

        // packing_type
        $this->packing_type->HrefValue = "";
        $this->packing_type->TooltipValue = "";

        // order_date
        $this->order_date->HrefValue = "";
        $this->order_date->TooltipValue = "";

        // qc_weaving
        $this->qc_weaving->HrefValue = "";
        $this->qc_weaving->TooltipValue = "";

        // p_remarks
        $this->p_remarks->HrefValue = "";
        $this->p_remarks->TooltipValue = "";

        // roll_no_qty_tmp
        $this->roll_no_qty_tmp->HrefValue = "";
        $this->roll_no_qty_tmp->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // pid
        $this->pid->setupEditAttributes();
        $this->pid->EditValue = $this->pid->CurrentValue;
        $this->pid->EditValue = FormatNumber($this->pid->EditValue, $this->pid->formatPattern());

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->EditValue = $this->grp->CurrentValue;
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());
        if (strval($this->grp->EditValue) != "" && is_numeric($this->grp->EditValue)) {
            $this->grp->EditValue = FormatNumber($this->grp->EditValue, null);
        }

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->EditValue = $this->s_grp->CurrentValue;
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());
        if (strval($this->s_grp->EditValue) != "" && is_numeric($this->s_grp->EditValue)) {
            $this->s_grp->EditValue = FormatNumber($this->s_grp->EditValue, null);
        }

        // weaving_works
        $this->weaving_works->setupEditAttributes();
        $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

        // current_works
        $this->current_works->setupEditAttributes();
        $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;
        $this->po->EditValue = FormatNumber($this->po->EditValue, $this->po->formatPattern());

        // barcode
        $this->_barcode->setupEditAttributes();
        $this->_barcode->EditValue = $this->_barcode->CurrentValue;

        // buyers_id
        $this->buyers_id->setupEditAttributes();
        $curVal = strval($this->buyers_id->CurrentValue);
        if ($curVal != "") {
            $this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
            if ($this->buyers_id->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
                } else {
                    $this->buyers_id->EditValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                }
            }
        } else {
            $this->buyers_id->EditValue = null;
        }

        // pp_id
        $this->pp_id->setupEditAttributes();
        $this->pp_id->EditValue = $this->pp_id->CurrentValue;
        $this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

        // buyer_ref
        $this->buyer_ref->setupEditAttributes();
        if ($this->buyer_ref->VirtualValue != "") {
            $this->buyer_ref->EditValue = $this->buyer_ref->VirtualValue;
        } else {
            $curVal = strval($this->buyer_ref->CurrentValue);
            if ($curVal != "") {
                $this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
                if ($this->buyer_ref->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
                    } else {
                        $this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
                    }
                }
            } else {
                $this->buyer_ref->EditValue = null;
            }
        }

        // buyer_tid
        $this->buyer_tid->setupEditAttributes();
        if (!$this->buyer_tid->Raw) {
            $this->buyer_tid->CurrentValue = HtmlDecode($this->buyer_tid->CurrentValue);
        }
        $this->buyer_tid->EditValue = $this->buyer_tid->CurrentValue;
        $this->buyer_tid->PlaceHolder = RemoveHtml($this->buyer_tid->caption());

        // design
        $this->design->setupEditAttributes();
        if (!$this->design->Raw) {
            $this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
        }
        $this->design->EditValue = $this->design->CurrentValue;
        $this->design->PlaceHolder = RemoveHtml($this->design->caption());

        // design_id
        $this->design_id->setupEditAttributes();
        $curVal = strval($this->design_id->CurrentValue);
        if ($curVal != "") {
            $this->design_id->EditValue = $this->design_id->lookupCacheOption($curVal);
            if ($this->design_id->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                    $this->design_id->EditValue = $this->design_id->displayValue($arwrk);
                } else {
                    $this->design_id->EditValue = $this->design_id->CurrentValue;
                }
            }
        } else {
            $this->design_id->EditValue = null;
        }

        // batch_no
        $this->batch_no->setupEditAttributes();
        $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

        // l_cm
        $this->l_cm->setupEditAttributes();
        $this->l_cm->EditValue = $this->l_cm->CurrentValue;
        $this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());
        if (strval($this->l_cm->EditValue) != "" && is_numeric($this->l_cm->EditValue)) {
            $this->l_cm->EditValue = FormatNumber($this->l_cm->EditValue, null);
        }

        // w_cm
        $this->w_cm->setupEditAttributes();
        $this->w_cm->EditValue = $this->w_cm->CurrentValue;
        $this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());
        if (strval($this->w_cm->EditValue) != "" && is_numeric($this->w_cm->EditValue)) {
            $this->w_cm->EditValue = FormatNumber($this->w_cm->EditValue, null);
        }

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, $this->sqm->formatPattern());

        // sqm_a
        $this->sqm_a->setupEditAttributes();
        $this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
        $this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
        if (strval($this->sqm_a->EditValue) != "" && is_numeric($this->sqm_a->EditValue)) {
            $this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, null);
        }

        // 2srm
        $this->_2srm->setupEditAttributes();
        $this->_2srm->EditValue = $this->_2srm->CurrentValue;
        $this->_2srm->PlaceHolder = RemoveHtml($this->_2srm->caption());
        if (strval($this->_2srm->EditValue) != "" && is_numeric($this->_2srm->EditValue)) {
            $this->_2srm->EditValue = FormatNumber($this->_2srm->EditValue, null);
        }

        // 2srm_a
        $this->_2srm_a->setupEditAttributes();
        $this->_2srm_a->EditValue = $this->_2srm_a->CurrentValue;
        $this->_2srm_a->PlaceHolder = RemoveHtml($this->_2srm_a->caption());
        if (strval($this->_2srm_a->EditValue) != "" && is_numeric($this->_2srm_a->EditValue)) {
            $this->_2srm_a->EditValue = FormatNumber($this->_2srm_a->EditValue, null);
        }

        // 4srm
        $this->_4srm->setupEditAttributes();
        $this->_4srm->EditValue = $this->_4srm->CurrentValue;
        $this->_4srm->PlaceHolder = RemoveHtml($this->_4srm->caption());
        if (strval($this->_4srm->EditValue) != "" && is_numeric($this->_4srm->EditValue)) {
            $this->_4srm->EditValue = FormatNumber($this->_4srm->EditValue, null);
        }

        // 4srm_a
        $this->_4srm_a->setupEditAttributes();
        $this->_4srm_a->EditValue = $this->_4srm_a->CurrentValue;
        $this->_4srm_a->PlaceHolder = RemoveHtml($this->_4srm_a->caption());
        if (strval($this->_4srm_a->EditValue) != "" && is_numeric($this->_4srm_a->EditValue)) {
            $this->_4srm_a->EditValue = FormatNumber($this->_4srm_a->EditValue, null);
        }

        // shape
        $this->shape->setupEditAttributes();
        $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

        // cs
        $this->cs->setupEditAttributes();
        $this->cs->EditValue = $this->cs->options(true);
        $this->cs->PlaceHolder = RemoveHtml($this->cs->caption());

        // product_type
        $this->product_type->setupEditAttributes();
        $this->product_type->EditValue = $this->product_type->options(true);
        $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

        // size_cm
        $this->size_cm->setupEditAttributes();
        $this->size_cm->EditValue = $this->size_cm->CurrentValue;

        // size_buyer
        $this->size_buyer->setupEditAttributes();
        if (!$this->size_buyer->Raw) {
            $this->size_buyer->CurrentValue = HtmlDecode($this->size_buyer->CurrentValue);
        }
        $this->size_buyer->EditValue = $this->size_buyer->CurrentValue;
        $this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

        // buyer_uid
        $this->buyer_uid->setupEditAttributes();
        if (!$this->buyer_uid->Raw) {
            $this->buyer_uid->CurrentValue = HtmlDecode($this->buyer_uid->CurrentValue);
        }
        $this->buyer_uid->EditValue = $this->buyer_uid->CurrentValue;
        $this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

        // buyer_loc
        $this->buyer_loc->setupEditAttributes();
        if (!$this->buyer_loc->Raw) {
            $this->buyer_loc->CurrentValue = HtmlDecode($this->buyer_loc->CurrentValue);
        }
        $this->buyer_loc->EditValue = $this->buyer_loc->CurrentValue;
        $this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, $this->quantity->formatPattern());

        // po_price
        $this->po_price->setupEditAttributes();
        $this->po_price->EditValue = $this->po_price->CurrentValue;

        // despatch_week
        $this->despatch_week->setupEditAttributes();
        $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

        // despatch_date
        $this->despatch_date->setupEditAttributes();
        $this->despatch_date->EditValue = $this->despatch_date->CurrentValue;
        $this->despatch_date->EditValue = FormatDateTime($this->despatch_date->EditValue, $this->despatch_date->formatPattern());

        // payment_plan
        $this->payment_plan->setupEditAttributes();
        $this->payment_plan->PlaceHolder = RemoveHtml($this->payment_plan->caption());

        // production_plan
        $this->production_plan->setupEditAttributes();
        $this->production_plan->EditValue = $this->production_plan->options(true);
        $this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // completed
        $this->completed->setupEditAttributes();
        $this->completed->EditValue = $this->completed->options(true);
        $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

        // buyer_po
        $this->buyer_po->setupEditAttributes();
        if (!$this->buyer_po->Raw) {
            $this->buyer_po->CurrentValue = HtmlDecode($this->buyer_po->CurrentValue);
        }
        $this->buyer_po->EditValue = $this->buyer_po->CurrentValue;
        $this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

        // jc_no
        $this->jc_no->setupEditAttributes();
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;
        $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
        if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
            $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
        }

        // process
        $this->process->PlaceHolder = RemoveHtml($this->process->caption());

        // process_c
        $this->process_c->PlaceHolder = RemoveHtml($this->process_c->caption());

        // process_d
        $this->process_d->PlaceHolder = RemoveHtml($this->process_d->caption());

        // weight
        $this->weight->setupEditAttributes();
        $this->weight->EditValue = $this->weight->CurrentValue;
        $this->weight->PlaceHolder = RemoveHtml($this->weight->caption());
        if (strval($this->weight->EditValue) != "" && is_numeric($this->weight->EditValue)) {
            $this->weight->EditValue = FormatNumber($this->weight->EditValue, null);
        }

        // operator

        // datetime

        // po_currency
        $this->po_currency->setupEditAttributes();
        $curVal = strval($this->po_currency->CurrentValue);
        if ($curVal != "") {
            $this->po_currency->EditValue = $this->po_currency->lookupCacheOption($curVal);
            if ($this->po_currency->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->po_currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->po_currency->Lookup->renderViewRow($rswrk[0]);
                    $this->po_currency->EditValue = $this->po_currency->displayValue($arwrk);
                } else {
                    $this->po_currency->EditValue = FormatNumber($this->po_currency->CurrentValue, $this->po_currency->formatPattern());
                }
            }
        } else {
            $this->po_currency->EditValue = null;
        }

        // dispatch_week_p
        $this->dispatch_week_p->setupEditAttributes();
        $curVal = strval($this->dispatch_week_p->CurrentValue);
        if ($curVal != "") {
            $this->dispatch_week_p->EditValue = $this->dispatch_week_p->lookupCacheOption($curVal);
            if ($this->dispatch_week_p->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->dispatch_week_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->dispatch_week_p->Lookup->renderViewRow($rswrk[0]);
                    $this->dispatch_week_p->EditValue = $this->dispatch_week_p->displayValue($arwrk);
                } else {
                    $this->dispatch_week_p->EditValue = FormatNumber($this->dispatch_week_p->CurrentValue, $this->dispatch_week_p->formatPattern());
                }
            }
        } else {
            $this->dispatch_week_p->EditValue = null;
        }

        // remarks
        $this->remarks->setupEditAttributes();
        if (!$this->remarks->Raw) {
            $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
        }
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // pl_no
        $this->pl_no->setupEditAttributes();
        $this->pl_no->EditValue = $this->pl_no->CurrentValue;
        $this->pl_no->EditValue = FormatNumber($this->pl_no->EditValue, $this->pl_no->formatPattern());

        // category
        $this->category->setupEditAttributes();
        $this->category->PlaceHolder = RemoveHtml($this->category->caption());

        // roll_no
        $this->roll_no->setupEditAttributes();
        $this->roll_no->EditValue = $this->roll_no->CurrentValue;
        $this->roll_no->EditValue = FormatNumber($this->roll_no->EditValue, $this->roll_no->formatPattern());

        // qty
        $this->qty->setupEditAttributes();
        $this->qty->EditValue = $this->qty->CurrentValue;
        $this->qty->EditValue = FormatNumber($this->qty->EditValue, $this->qty->formatPattern());

        // consignee
        $this->consignee->setupEditAttributes();
        $this->consignee->EditValue = $this->consignee->CurrentValue;
        $this->consignee->PlaceHolder = RemoveHtml($this->consignee->caption());
        if (strval($this->consignee->EditValue) != "" && is_numeric($this->consignee->EditValue)) {
            $this->consignee->EditValue = FormatNumber($this->consignee->EditValue, null);
        }

        // buyer_barcode
        $this->buyer_barcode->setupEditAttributes();
        $this->buyer_barcode->EditValue = $this->buyer_barcode->CurrentValue;

        // design_next
        $this->design_next->setupEditAttributes();
        if (!$this->design_next->Raw) {
            $this->design_next->CurrentValue = HtmlDecode($this->design_next->CurrentValue);
        }
        $this->design_next->EditValue = $this->design_next->CurrentValue;
        $this->design_next->PlaceHolder = RemoveHtml($this->design_next->caption());

        // q_sku
        $this->q_sku->setupEditAttributes();
        $this->q_sku->EditValue = $this->q_sku->CurrentValue;
        $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());
        if (strval($this->q_sku->EditValue) != "" && is_numeric($this->q_sku->EditValue)) {
            $this->q_sku->EditValue = FormatNumber($this->q_sku->EditValue, null);
        }

        // sqm_u
        $this->sqm_u->setupEditAttributes();
        $this->sqm_u->EditValue = $this->sqm_u->CurrentValue;
        $this->sqm_u->PlaceHolder = RemoveHtml($this->sqm_u->caption());
        if (strval($this->sqm_u->EditValue) != "" && is_numeric($this->sqm_u->EditValue)) {
            $this->sqm_u->EditValue = FormatNumber($this->sqm_u->EditValue, null);
        }

        // po_discount
        $this->po_discount->setupEditAttributes();
        $this->po_discount->EditValue = $this->po_discount->CurrentValue;
        $this->po_discount->PlaceHolder = RemoveHtml($this->po_discount->caption());
        if (strval($this->po_discount->EditValue) != "" && is_numeric($this->po_discount->EditValue)) {
            $this->po_discount->EditValue = FormatNumber($this->po_discount->EditValue, null);
        }

        // loom_plan
        $this->loom_plan->setupEditAttributes();
        if (!$this->loom_plan->Raw) {
            $this->loom_plan->CurrentValue = HtmlDecode($this->loom_plan->CurrentValue);
        }
        $this->loom_plan->EditValue = $this->loom_plan->CurrentValue;
        $this->loom_plan->PlaceHolder = RemoveHtml($this->loom_plan->caption());

        // 11
        $this->_11->setupEditAttributes();
        if (!$this->_11->Raw) {
            $this->_11->CurrentValue = HtmlDecode($this->_11->CurrentValue);
        }
        $this->_11->EditValue = $this->_11->CurrentValue;
        $this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

        // 12
        $this->_12->setupEditAttributes();
        if (!$this->_12->Raw) {
            $this->_12->CurrentValue = HtmlDecode($this->_12->CurrentValue);
        }
        $this->_12->EditValue = $this->_12->CurrentValue;
        $this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

        // 13
        $this->_13->setupEditAttributes();
        if (!$this->_13->Raw) {
            $this->_13->CurrentValue = HtmlDecode($this->_13->CurrentValue);
        }
        $this->_13->EditValue = $this->_13->CurrentValue;
        $this->_13->PlaceHolder = RemoveHtml($this->_13->caption());

        // 14
        $this->_14->setupEditAttributes();
        if (!$this->_14->Raw) {
            $this->_14->CurrentValue = HtmlDecode($this->_14->CurrentValue);
        }
        $this->_14->EditValue = $this->_14->CurrentValue;
        $this->_14->PlaceHolder = RemoveHtml($this->_14->caption());

        // 15
        $this->_15->setupEditAttributes();
        if (!$this->_15->Raw) {
            $this->_15->CurrentValue = HtmlDecode($this->_15->CurrentValue);
        }
        $this->_15->EditValue = $this->_15->CurrentValue;
        $this->_15->PlaceHolder = RemoveHtml($this->_15->caption());

        // 16
        $this->_16->setupEditAttributes();
        if (!$this->_16->Raw) {
            $this->_16->CurrentValue = HtmlDecode($this->_16->CurrentValue);
        }
        $this->_16->EditValue = $this->_16->CurrentValue;
        $this->_16->PlaceHolder = RemoveHtml($this->_16->caption());

        // 17
        $this->_17->setupEditAttributes();
        if (!$this->_17->Raw) {
            $this->_17->CurrentValue = HtmlDecode($this->_17->CurrentValue);
        }
        $this->_17->EditValue = $this->_17->CurrentValue;
        $this->_17->PlaceHolder = RemoveHtml($this->_17->caption());

        // 18
        $this->_18->setupEditAttributes();
        if (!$this->_18->Raw) {
            $this->_18->CurrentValue = HtmlDecode($this->_18->CurrentValue);
        }
        $this->_18->EditValue = $this->_18->CurrentValue;
        $this->_18->PlaceHolder = RemoveHtml($this->_18->caption());

        // 19
        $this->_19->setupEditAttributes();
        if (!$this->_19->Raw) {
            $this->_19->CurrentValue = HtmlDecode($this->_19->CurrentValue);
        }
        $this->_19->EditValue = $this->_19->CurrentValue;
        $this->_19->PlaceHolder = RemoveHtml($this->_19->caption());

        // 20
        $this->_20->setupEditAttributes();
        if (!$this->_20->Raw) {
            $this->_20->CurrentValue = HtmlDecode($this->_20->CurrentValue);
        }
        $this->_20->EditValue = $this->_20->CurrentValue;
        $this->_20->PlaceHolder = RemoveHtml($this->_20->caption());

        // 21
        $this->_21->setupEditAttributes();
        if (!$this->_21->Raw) {
            $this->_21->CurrentValue = HtmlDecode($this->_21->CurrentValue);
        }
        $this->_21->EditValue = $this->_21->CurrentValue;
        $this->_21->PlaceHolder = RemoveHtml($this->_21->caption());

        // 22
        $this->_22->setupEditAttributes();
        if (!$this->_22->Raw) {
            $this->_22->CurrentValue = HtmlDecode($this->_22->CurrentValue);
        }
        $this->_22->EditValue = $this->_22->CurrentValue;
        $this->_22->PlaceHolder = RemoveHtml($this->_22->caption());

        // 23
        $this->_23->setupEditAttributes();
        if (!$this->_23->Raw) {
            $this->_23->CurrentValue = HtmlDecode($this->_23->CurrentValue);
        }
        $this->_23->EditValue = $this->_23->CurrentValue;
        $this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

        // 24
        $this->_24->setupEditAttributes();
        if (!$this->_24->Raw) {
            $this->_24->CurrentValue = HtmlDecode($this->_24->CurrentValue);
        }
        $this->_24->EditValue = $this->_24->CurrentValue;
        $this->_24->PlaceHolder = RemoveHtml($this->_24->caption());

        // 25
        $this->_25->setupEditAttributes();
        if (!$this->_25->Raw) {
            $this->_25->CurrentValue = HtmlDecode($this->_25->CurrentValue);
        }
        $this->_25->EditValue = $this->_25->CurrentValue;
        $this->_25->PlaceHolder = RemoveHtml($this->_25->caption());

        // 26
        $this->_26->setupEditAttributes();
        if (!$this->_26->Raw) {
            $this->_26->CurrentValue = HtmlDecode($this->_26->CurrentValue);
        }
        $this->_26->EditValue = $this->_26->CurrentValue;
        $this->_26->PlaceHolder = RemoveHtml($this->_26->caption());

        // 27
        $this->_27->setupEditAttributes();
        if (!$this->_27->Raw) {
            $this->_27->CurrentValue = HtmlDecode($this->_27->CurrentValue);
        }
        $this->_27->EditValue = $this->_27->CurrentValue;
        $this->_27->PlaceHolder = RemoveHtml($this->_27->caption());

        // 28
        $this->_28->setupEditAttributes();
        if (!$this->_28->Raw) {
            $this->_28->CurrentValue = HtmlDecode($this->_28->CurrentValue);
        }
        $this->_28->EditValue = $this->_28->CurrentValue;
        $this->_28->PlaceHolder = RemoveHtml($this->_28->caption());

        // 29
        $this->_29->setupEditAttributes();
        if (!$this->_29->Raw) {
            $this->_29->CurrentValue = HtmlDecode($this->_29->CurrentValue);
        }
        $this->_29->EditValue = $this->_29->CurrentValue;
        $this->_29->PlaceHolder = RemoveHtml($this->_29->caption());

        // 30
        $this->_30->setupEditAttributes();
        if (!$this->_30->Raw) {
            $this->_30->CurrentValue = HtmlDecode($this->_30->CurrentValue);
        }
        $this->_30->EditValue = $this->_30->CurrentValue;
        $this->_30->PlaceHolder = RemoveHtml($this->_30->caption());

        // 31
        $this->_31->setupEditAttributes();
        if (!$this->_31->Raw) {
            $this->_31->CurrentValue = HtmlDecode($this->_31->CurrentValue);
        }
        $this->_31->EditValue = $this->_31->CurrentValue;
        $this->_31->PlaceHolder = RemoveHtml($this->_31->caption());

        // 32
        $this->_32->setupEditAttributes();
        if (!$this->_32->Raw) {
            $this->_32->CurrentValue = HtmlDecode($this->_32->CurrentValue);
        }
        $this->_32->EditValue = $this->_32->CurrentValue;
        $this->_32->PlaceHolder = RemoveHtml($this->_32->caption());

        // 33
        $this->_33->setupEditAttributes();
        if (!$this->_33->Raw) {
            $this->_33->CurrentValue = HtmlDecode($this->_33->CurrentValue);
        }
        $this->_33->EditValue = $this->_33->CurrentValue;
        $this->_33->PlaceHolder = RemoveHtml($this->_33->caption());

        // 34
        $this->_34->setupEditAttributes();
        if (!$this->_34->Raw) {
            $this->_34->CurrentValue = HtmlDecode($this->_34->CurrentValue);
        }
        $this->_34->EditValue = $this->_34->CurrentValue;
        $this->_34->PlaceHolder = RemoveHtml($this->_34->caption());

        // 35
        $this->_35->setupEditAttributes();
        if (!$this->_35->Raw) {
            $this->_35->CurrentValue = HtmlDecode($this->_35->CurrentValue);
        }
        $this->_35->EditValue = $this->_35->CurrentValue;
        $this->_35->PlaceHolder = RemoveHtml($this->_35->caption());

        // 36
        $this->_36->setupEditAttributes();
        if (!$this->_36->Raw) {
            $this->_36->CurrentValue = HtmlDecode($this->_36->CurrentValue);
        }
        $this->_36->EditValue = $this->_36->CurrentValue;
        $this->_36->PlaceHolder = RemoveHtml($this->_36->caption());

        // 37
        $this->_37->setupEditAttributes();
        if (!$this->_37->Raw) {
            $this->_37->CurrentValue = HtmlDecode($this->_37->CurrentValue);
        }
        $this->_37->EditValue = $this->_37->CurrentValue;
        $this->_37->PlaceHolder = RemoveHtml($this->_37->caption());

        // 38
        $this->_38->setupEditAttributes();
        if (!$this->_38->Raw) {
            $this->_38->CurrentValue = HtmlDecode($this->_38->CurrentValue);
        }
        $this->_38->EditValue = $this->_38->CurrentValue;
        $this->_38->PlaceHolder = RemoveHtml($this->_38->caption());

        // 39
        $this->_39->setupEditAttributes();
        if (!$this->_39->Raw) {
            $this->_39->CurrentValue = HtmlDecode($this->_39->CurrentValue);
        }
        $this->_39->EditValue = $this->_39->CurrentValue;
        $this->_39->PlaceHolder = RemoveHtml($this->_39->caption());

        // 40
        $this->_40->setupEditAttributes();
        if (!$this->_40->Raw) {
            $this->_40->CurrentValue = HtmlDecode($this->_40->CurrentValue);
        }
        $this->_40->EditValue = $this->_40->CurrentValue;
        $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

        // 41
        $this->_41->setupEditAttributes();
        if (!$this->_41->Raw) {
            $this->_41->CurrentValue = HtmlDecode($this->_41->CurrentValue);
        }
        $this->_41->EditValue = $this->_41->CurrentValue;
        $this->_41->PlaceHolder = RemoveHtml($this->_41->caption());

        // 42
        $this->_42->setupEditAttributes();
        if (!$this->_42->Raw) {
            $this->_42->CurrentValue = HtmlDecode($this->_42->CurrentValue);
        }
        $this->_42->EditValue = $this->_42->CurrentValue;
        $this->_42->PlaceHolder = RemoveHtml($this->_42->caption());

        // 43
        $this->_43->setupEditAttributes();
        if (!$this->_43->Raw) {
            $this->_43->CurrentValue = HtmlDecode($this->_43->CurrentValue);
        }
        $this->_43->EditValue = $this->_43->CurrentValue;
        $this->_43->PlaceHolder = RemoveHtml($this->_43->caption());

        // 44
        $this->_44->setupEditAttributes();
        if (!$this->_44->Raw) {
            $this->_44->CurrentValue = HtmlDecode($this->_44->CurrentValue);
        }
        $this->_44->EditValue = $this->_44->CurrentValue;
        $this->_44->PlaceHolder = RemoveHtml($this->_44->caption());

        // 45
        $this->_45->setupEditAttributes();
        if (!$this->_45->Raw) {
            $this->_45->CurrentValue = HtmlDecode($this->_45->CurrentValue);
        }
        $this->_45->EditValue = $this->_45->CurrentValue;
        $this->_45->PlaceHolder = RemoveHtml($this->_45->caption());

        // 46
        $this->_46->setupEditAttributes();
        if (!$this->_46->Raw) {
            $this->_46->CurrentValue = HtmlDecode($this->_46->CurrentValue);
        }
        $this->_46->EditValue = $this->_46->CurrentValue;
        $this->_46->PlaceHolder = RemoveHtml($this->_46->caption());

        // 47
        $this->_47->setupEditAttributes();
        if (!$this->_47->Raw) {
            $this->_47->CurrentValue = HtmlDecode($this->_47->CurrentValue);
        }
        $this->_47->EditValue = $this->_47->CurrentValue;
        $this->_47->PlaceHolder = RemoveHtml($this->_47->caption());

        // 48
        $this->_48->setupEditAttributes();
        if (!$this->_48->Raw) {
            $this->_48->CurrentValue = HtmlDecode($this->_48->CurrentValue);
        }
        $this->_48->EditValue = $this->_48->CurrentValue;
        $this->_48->PlaceHolder = RemoveHtml($this->_48->caption());

        // 49
        $this->_49->setupEditAttributes();
        if (!$this->_49->Raw) {
            $this->_49->CurrentValue = HtmlDecode($this->_49->CurrentValue);
        }
        $this->_49->EditValue = $this->_49->CurrentValue;
        $this->_49->PlaceHolder = RemoveHtml($this->_49->caption());

        // 50
        $this->_50->setupEditAttributes();
        if (!$this->_50->Raw) {
            $this->_50->CurrentValue = HtmlDecode($this->_50->CurrentValue);
        }
        $this->_50->EditValue = $this->_50->CurrentValue;
        $this->_50->PlaceHolder = RemoveHtml($this->_50->caption());

        // c_sqm
        $this->c_sqm->setupEditAttributes();
        $this->c_sqm->EditValue = $this->c_sqm->CurrentValue;
        $this->c_sqm->PlaceHolder = RemoveHtml($this->c_sqm->caption());
        if (strval($this->c_sqm->EditValue) != "" && is_numeric($this->c_sqm->EditValue)) {
            $this->c_sqm->EditValue = FormatNumber($this->c_sqm->EditValue, null);
        }

        // packing_type
        $this->packing_type->setupEditAttributes();
        $this->packing_type->EditValue = $this->packing_type->CurrentValue;
        $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());
        if (strval($this->packing_type->EditValue) != "" && is_numeric($this->packing_type->EditValue)) {
            $this->packing_type->EditValue = FormatNumber($this->packing_type->EditValue, null);
        }

        // order_date
        $this->order_date->setupEditAttributes();
        $this->order_date->EditValue = FormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern());
        $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

        // qc_weaving
        $this->qc_weaving->setupEditAttributes();
        $this->qc_weaving->EditValue = FormatDateTime($this->qc_weaving->CurrentValue, $this->qc_weaving->formatPattern());
        $this->qc_weaving->PlaceHolder = RemoveHtml($this->qc_weaving->caption());

        // p_remarks
        $this->p_remarks->setupEditAttributes();
        if (!$this->p_remarks->Raw) {
            $this->p_remarks->CurrentValue = HtmlDecode($this->p_remarks->CurrentValue);
        }
        $this->p_remarks->EditValue = $this->p_remarks->CurrentValue;
        $this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

        // roll_no_qty_tmp
        $this->roll_no_qty_tmp->setupEditAttributes();
        $this->roll_no_qty_tmp->EditValue = $this->roll_no_qty_tmp->CurrentValue;
        $this->roll_no_qty_tmp->PlaceHolder = RemoveHtml($this->roll_no_qty_tmp->caption());
        if (strval($this->roll_no_qty_tmp->EditValue) != "" && is_numeric($this->roll_no_qty_tmp->EditValue)) {
            $this->roll_no_qty_tmp->EditValue = FormatNumber($this->roll_no_qty_tmp->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->pid);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->pp_id);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->buyer_tid);
                    $doc->exportCaption($this->design_id);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->sqm_a);
                    $doc->exportCaption($this->_2srm);
                    $doc->exportCaption($this->_2srm_a);
                    $doc->exportCaption($this->_4srm);
                    $doc->exportCaption($this->_4srm_a);
                    $doc->exportCaption($this->shape);
                    $doc->exportCaption($this->cs);
                    $doc->exportCaption($this->product_type);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->buyer_uid);
                    $doc->exportCaption($this->buyer_loc);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->po_price);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->despatch_date);
                    $doc->exportCaption($this->payment_plan);
                    $doc->exportCaption($this->production_plan);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->completed);
                    $doc->exportCaption($this->buyer_po);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->process_c);
                    $doc->exportCaption($this->process_d);
                    $doc->exportCaption($this->weight);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->po_currency);
                    $doc->exportCaption($this->dispatch_week_p);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->pl_no);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->roll_no);
                    $doc->exportCaption($this->qty);
                    $doc->exportCaption($this->q_sku);
                    $doc->exportCaption($this->sqm_u);
                    $doc->exportCaption($this->po_discount);
                    $doc->exportCaption($this->_11);
                    $doc->exportCaption($this->_12);
                    $doc->exportCaption($this->_13);
                    $doc->exportCaption($this->_14);
                    $doc->exportCaption($this->_15);
                    $doc->exportCaption($this->_16);
                    $doc->exportCaption($this->_17);
                    $doc->exportCaption($this->_18);
                    $doc->exportCaption($this->_19);
                    $doc->exportCaption($this->_20);
                    $doc->exportCaption($this->_21);
                    $doc->exportCaption($this->_22);
                    $doc->exportCaption($this->_23);
                    $doc->exportCaption($this->_24);
                    $doc->exportCaption($this->_25);
                    $doc->exportCaption($this->_26);
                    $doc->exportCaption($this->_27);
                    $doc->exportCaption($this->_28);
                    $doc->exportCaption($this->_29);
                    $doc->exportCaption($this->_30);
                    $doc->exportCaption($this->_31);
                    $doc->exportCaption($this->_32);
                    $doc->exportCaption($this->_33);
                    $doc->exportCaption($this->_34);
                    $doc->exportCaption($this->_35);
                    $doc->exportCaption($this->_36);
                    $doc->exportCaption($this->_37);
                    $doc->exportCaption($this->_38);
                    $doc->exportCaption($this->_39);
                    $doc->exportCaption($this->_40);
                    $doc->exportCaption($this->_41);
                    $doc->exportCaption($this->_42);
                    $doc->exportCaption($this->_43);
                    $doc->exportCaption($this->_44);
                    $doc->exportCaption($this->_45);
                    $doc->exportCaption($this->_46);
                    $doc->exportCaption($this->_47);
                    $doc->exportCaption($this->_48);
                    $doc->exportCaption($this->_49);
                    $doc->exportCaption($this->_50);
                    $doc->exportCaption($this->c_sqm);
                    $doc->exportCaption($this->order_date);
                    $doc->exportCaption($this->p_remarks);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->pid);
                    $doc->exportCaption($this->weaving_works);
                    $doc->exportCaption($this->current_works);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->pp_id);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->design_id);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->shape);
                    $doc->exportCaption($this->cs);
                    $doc->exportCaption($this->product_type);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->size_buyer);
                    $doc->exportCaption($this->buyer_uid);
                    $doc->exportCaption($this->buyer_loc);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->po_price);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->despatch_date);
                    $doc->exportCaption($this->payment_plan);
                    $doc->exportCaption($this->production_plan);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->completed);
                    $doc->exportCaption($this->buyer_po);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->process_c);
                    $doc->exportCaption($this->process_d);
                    $doc->exportCaption($this->weight);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->po_currency);
                    $doc->exportCaption($this->dispatch_week_p);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->pl_no);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->roll_no);
                    $doc->exportCaption($this->qty);
                    $doc->exportCaption($this->q_sku);
                    $doc->exportCaption($this->sqm_u);
                    $doc->exportCaption($this->po_discount);
                    $doc->exportCaption($this->_11);
                    $doc->exportCaption($this->_12);
                    $doc->exportCaption($this->_13);
                    $doc->exportCaption($this->_14);
                    $doc->exportCaption($this->_15);
                    $doc->exportCaption($this->_16);
                    $doc->exportCaption($this->_17);
                    $doc->exportCaption($this->_18);
                    $doc->exportCaption($this->_19);
                    $doc->exportCaption($this->_20);
                    $doc->exportCaption($this->_21);
                    $doc->exportCaption($this->_22);
                    $doc->exportCaption($this->_23);
                    $doc->exportCaption($this->_24);
                    $doc->exportCaption($this->_25);
                    $doc->exportCaption($this->_26);
                    $doc->exportCaption($this->_27);
                    $doc->exportCaption($this->_28);
                    $doc->exportCaption($this->_29);
                    $doc->exportCaption($this->_30);
                    $doc->exportCaption($this->_31);
                    $doc->exportCaption($this->_32);
                    $doc->exportCaption($this->_33);
                    $doc->exportCaption($this->_34);
                    $doc->exportCaption($this->_35);
                    $doc->exportCaption($this->_36);
                    $doc->exportCaption($this->_37);
                    $doc->exportCaption($this->_38);
                    $doc->exportCaption($this->_39);
                    $doc->exportCaption($this->_40);
                    $doc->exportCaption($this->_41);
                    $doc->exportCaption($this->_42);
                    $doc->exportCaption($this->_43);
                    $doc->exportCaption($this->_44);
                    $doc->exportCaption($this->_45);
                    $doc->exportCaption($this->_46);
                    $doc->exportCaption($this->_47);
                    $doc->exportCaption($this->_48);
                    $doc->exportCaption($this->_49);
                    $doc->exportCaption($this->_50);
                    $doc->exportCaption($this->c_sqm);
                    $doc->exportCaption($this->order_date);
                    $doc->exportCaption($this->p_remarks);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->pid);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->po);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->pp_id);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->buyer_tid);
                        $doc->exportField($this->design_id);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->sqm_a);
                        $doc->exportField($this->_2srm);
                        $doc->exportField($this->_2srm_a);
                        $doc->exportField($this->_4srm);
                        $doc->exportField($this->_4srm_a);
                        $doc->exportField($this->shape);
                        $doc->exportField($this->cs);
                        $doc->exportField($this->product_type);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->buyer_uid);
                        $doc->exportField($this->buyer_loc);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->po_price);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->despatch_date);
                        $doc->exportField($this->payment_plan);
                        $doc->exportField($this->production_plan);
                        $doc->exportField($this->status);
                        $doc->exportField($this->completed);
                        $doc->exportField($this->buyer_po);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->process);
                        $doc->exportField($this->process_c);
                        $doc->exportField($this->process_d);
                        $doc->exportField($this->weight);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->po_currency);
                        $doc->exportField($this->dispatch_week_p);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->pl_no);
                        $doc->exportField($this->category);
                        $doc->exportField($this->roll_no);
                        $doc->exportField($this->qty);
                        $doc->exportField($this->q_sku);
                        $doc->exportField($this->sqm_u);
                        $doc->exportField($this->po_discount);
                        $doc->exportField($this->_11);
                        $doc->exportField($this->_12);
                        $doc->exportField($this->_13);
                        $doc->exportField($this->_14);
                        $doc->exportField($this->_15);
                        $doc->exportField($this->_16);
                        $doc->exportField($this->_17);
                        $doc->exportField($this->_18);
                        $doc->exportField($this->_19);
                        $doc->exportField($this->_20);
                        $doc->exportField($this->_21);
                        $doc->exportField($this->_22);
                        $doc->exportField($this->_23);
                        $doc->exportField($this->_24);
                        $doc->exportField($this->_25);
                        $doc->exportField($this->_26);
                        $doc->exportField($this->_27);
                        $doc->exportField($this->_28);
                        $doc->exportField($this->_29);
                        $doc->exportField($this->_30);
                        $doc->exportField($this->_31);
                        $doc->exportField($this->_32);
                        $doc->exportField($this->_33);
                        $doc->exportField($this->_34);
                        $doc->exportField($this->_35);
                        $doc->exportField($this->_36);
                        $doc->exportField($this->_37);
                        $doc->exportField($this->_38);
                        $doc->exportField($this->_39);
                        $doc->exportField($this->_40);
                        $doc->exportField($this->_41);
                        $doc->exportField($this->_42);
                        $doc->exportField($this->_43);
                        $doc->exportField($this->_44);
                        $doc->exportField($this->_45);
                        $doc->exportField($this->_46);
                        $doc->exportField($this->_47);
                        $doc->exportField($this->_48);
                        $doc->exportField($this->_49);
                        $doc->exportField($this->_50);
                        $doc->exportField($this->c_sqm);
                        $doc->exportField($this->order_date);
                        $doc->exportField($this->p_remarks);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->pid);
                        $doc->exportField($this->weaving_works);
                        $doc->exportField($this->current_works);
                        $doc->exportField($this->po);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->pp_id);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->design_id);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->shape);
                        $doc->exportField($this->cs);
                        $doc->exportField($this->product_type);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->size_buyer);
                        $doc->exportField($this->buyer_uid);
                        $doc->exportField($this->buyer_loc);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->po_price);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->despatch_date);
                        $doc->exportField($this->payment_plan);
                        $doc->exportField($this->production_plan);
                        $doc->exportField($this->status);
                        $doc->exportField($this->completed);
                        $doc->exportField($this->buyer_po);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->process);
                        $doc->exportField($this->process_c);
                        $doc->exportField($this->process_d);
                        $doc->exportField($this->weight);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->po_currency);
                        $doc->exportField($this->dispatch_week_p);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->pl_no);
                        $doc->exportField($this->category);
                        $doc->exportField($this->roll_no);
                        $doc->exportField($this->qty);
                        $doc->exportField($this->q_sku);
                        $doc->exportField($this->sqm_u);
                        $doc->exportField($this->po_discount);
                        $doc->exportField($this->_11);
                        $doc->exportField($this->_12);
                        $doc->exportField($this->_13);
                        $doc->exportField($this->_14);
                        $doc->exportField($this->_15);
                        $doc->exportField($this->_16);
                        $doc->exportField($this->_17);
                        $doc->exportField($this->_18);
                        $doc->exportField($this->_19);
                        $doc->exportField($this->_20);
                        $doc->exportField($this->_21);
                        $doc->exportField($this->_22);
                        $doc->exportField($this->_23);
                        $doc->exportField($this->_24);
                        $doc->exportField($this->_25);
                        $doc->exportField($this->_26);
                        $doc->exportField($this->_27);
                        $doc->exportField($this->_28);
                        $doc->exportField($this->_29);
                        $doc->exportField($this->_30);
                        $doc->exportField($this->_31);
                        $doc->exportField($this->_32);
                        $doc->exportField($this->_33);
                        $doc->exportField($this->_34);
                        $doc->exportField($this->_35);
                        $doc->exportField($this->_36);
                        $doc->exportField($this->_37);
                        $doc->exportField($this->_38);
                        $doc->exportField($this->_39);
                        $doc->exportField($this->_40);
                        $doc->exportField($this->_41);
                        $doc->exportField($this->_42);
                        $doc->exportField($this->_43);
                        $doc->exportField($this->_44);
                        $doc->exportField($this->_45);
                        $doc->exportField($this->_46);
                        $doc->exportField($this->_47);
                        $doc->exportField($this->_48);
                        $doc->exportField($this->_49);
                        $doc->exportField($this->_50);
                        $doc->exportField($this->c_sqm);
                        $doc->exportField($this->order_date);
                        $doc->exportField($this->p_remarks);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
