<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BcodeEdit extends Bcode
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BcodeEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "bcodeedit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->pid->Visible = false;
        $this->po->setVisibility();
        $this->design_id->setVisibility();
        $this->size_cm->setVisibility();
        $this->_barcode->setVisibility();
        $this->process_d->Visible = false;
        $this->buyer_ref->setVisibility();
        $this->order_date->setVisibility();
        $this->despatch_date->setVisibility();
        $this->despatch_week->setVisibility();
        $this->dispatch_week_p->setVisibility();
        $this->loom_plan->Visible = false;
        $this->status->setVisibility();
        $this->buyers_id->setVisibility();
        $this->buyer_uid->setVisibility();
        $this->buyer_loc->setVisibility();
        $this->quantity->setVisibility();
        $this->sqm->setVisibility();
        $this->sqm_u->setVisibility();
        $this->c_sqm->setVisibility();
        $this->weaving_works->setVisibility();
        $this->current_works->setVisibility();
        $this->size_buyer->setVisibility();
        $this->design->Visible = false;
        $this->w_cm->setVisibility();
        $this->l_cm->setVisibility();
        $this->q_sku->setVisibility();
        $this->po_price->setVisibility();
        $this->po_discount->setVisibility();
        $this->po_currency->setVisibility();
        $this->product_type->setVisibility();
        $this->shape->setVisibility();
        $this->payment_plan->Visible = false;
        $this->production_plan->setVisibility();
        $this->datetime->setVisibility();
        $this->completed->setVisibility();
        $this->buyer_po->setVisibility();
        $this->operator->setVisibility();
        $this->jc_no->setVisibility();
        $this->sqm_a->setVisibility();
        $this->_2srm->Visible = false;
        $this->_2srm_a->setVisibility();
        $this->_4srm->Visible = false;
        $this->_4srm_a->setVisibility();
        $this->buyer_tid->Visible = false;
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->batch_no->setVisibility();
        $this->cs->setVisibility();
        $this->process->Visible = false;
        $this->process_c->Visible = false;
        $this->weight->setVisibility();
        $this->remarks->setVisibility();
        $this->p_remarks->setVisibility();
        $this->roll_no->setVisibility();
        $this->qty->setVisibility();
        $this->pl_no->setVisibility();
        $this->category->setVisibility();
        $this->pp_id->setVisibility();
        $this->consignee->Visible = false;
        $this->buyer_barcode->setVisibility();
        $this->design_next->Visible = false;
        $this->_11->Visible = false;
        $this->_12->Visible = false;
        $this->_13->Visible = false;
        $this->_14->Visible = false;
        $this->_15->Visible = false;
        $this->_16->Visible = false;
        $this->_17->Visible = false;
        $this->_18->Visible = false;
        $this->_19->Visible = false;
        $this->_20->Visible = false;
        $this->_21->Visible = false;
        $this->_22->Visible = false;
        $this->_23->Visible = false;
        $this->_24->Visible = false;
        $this->_25->Visible = false;
        $this->_26->Visible = false;
        $this->_27->Visible = false;
        $this->_28->Visible = false;
        $this->_29->Visible = false;
        $this->_30->Visible = false;
        $this->_31->Visible = false;
        $this->_32->Visible = false;
        $this->_33->Visible = false;
        $this->_34->Visible = false;
        $this->_35->Visible = false;
        $this->_36->Visible = false;
        $this->_37->Visible = false;
        $this->_38->Visible = false;
        $this->_39->Visible = false;
        $this->_40->Visible = false;
        $this->_41->Visible = false;
        $this->_42->Visible = false;
        $this->_43->Visible = false;
        $this->_44->Visible = false;
        $this->_45->Visible = false;
        $this->_46->Visible = false;
        $this->_47->Visible = false;
        $this->_48->Visible = false;
        $this->_49->Visible = false;
        $this->_50->Visible = false;
        $this->packing_type->Visible = false;
        $this->qc_weaving->Visible = false;
        $this->roll_no_qty_tmp->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'bcode';
        $this->TableName = 'bcode';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (bcode)
        if (!isset($GLOBALS["bcode"]) || $GLOBALS["bcode"]::class == PROJECT_NAMESPACE . "bcode") {
            $GLOBALS["bcode"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'bcode');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "bcodeview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->po->Required = false;
        $this->design_id->Required = false;
        $this->size_cm->Required = false;
        $this->_barcode->Required = false;
        $this->quantity->Required = false;
        $this->sqm->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->design_id);
        $this->setupLookupOptions($this->process_d);
        $this->setupLookupOptions($this->buyer_ref);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->dispatch_week_p);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->weaving_works);
        $this->setupLookupOptions($this->current_works);
        $this->setupLookupOptions($this->design);
        $this->setupLookupOptions($this->po_currency);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->payment_plan);
        $this->setupLookupOptions($this->production_plan);
        $this->setupLookupOptions($this->completed);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->cs);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->process_c);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->pp_id);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("bcodelist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "bcodelist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "bcodelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "bcodelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'po' first before field var 'x_po'
        $val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
        if (!$this->po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po->Visible = false; // Disable update for API request
            } else {
                $this->po->setFormValue($val);
            }
        }

        // Check field name 'design_id' first before field var 'x_design_id'
        $val = $CurrentForm->hasValue("design_id") ? $CurrentForm->getValue("design_id") : $CurrentForm->getValue("x_design_id");
        if (!$this->design_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->design_id->Visible = false; // Disable update for API request
            } else {
                $this->design_id->setFormValue($val);
            }
        }

        // Check field name 'size_cm' first before field var 'x_size_cm'
        $val = $CurrentForm->hasValue("size_cm") ? $CurrentForm->getValue("size_cm") : $CurrentForm->getValue("x_size_cm");
        if (!$this->size_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_cm->Visible = false; // Disable update for API request
            } else {
                $this->size_cm->setFormValue($val);
            }
        }

        // Check field name 'barcode' first before field var 'x__barcode'
        $val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
        if (!$this->_barcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_barcode->Visible = false; // Disable update for API request
            } else {
                $this->_barcode->setFormValue($val);
            }
        }

        // Check field name 'buyer_ref' first before field var 'x_buyer_ref'
        $val = $CurrentForm->hasValue("buyer_ref") ? $CurrentForm->getValue("buyer_ref") : $CurrentForm->getValue("x_buyer_ref");
        if (!$this->buyer_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_ref->Visible = false; // Disable update for API request
            } else {
                $this->buyer_ref->setFormValue($val);
            }
        }

        // Check field name 'order_date' first before field var 'x_order_date'
        $val = $CurrentForm->hasValue("order_date") ? $CurrentForm->getValue("order_date") : $CurrentForm->getValue("x_order_date");
        if (!$this->order_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->order_date->Visible = false; // Disable update for API request
            } else {
                $this->order_date->setFormValue($val, true, $validate);
            }
            $this->order_date->CurrentValue = UnFormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern());
        }

        // Check field name 'despatch_date' first before field var 'x_despatch_date'
        $val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
        if (!$this->despatch_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_date->Visible = false; // Disable update for API request
            } else {
                $this->despatch_date->setFormValue($val);
            }
            $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        }

        // Check field name 'despatch_week' first before field var 'x_despatch_week'
        $val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
        if (!$this->despatch_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_week->Visible = false; // Disable update for API request
            } else {
                $this->despatch_week->setFormValue($val);
            }
        }

        // Check field name 'dispatch_week_p' first before field var 'x_dispatch_week_p'
        $val = $CurrentForm->hasValue("dispatch_week_p") ? $CurrentForm->getValue("dispatch_week_p") : $CurrentForm->getValue("x_dispatch_week_p");
        if (!$this->dispatch_week_p->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dispatch_week_p->Visible = false; // Disable update for API request
            } else {
                $this->dispatch_week_p->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'buyers_id' first before field var 'x_buyers_id'
        $val = $CurrentForm->hasValue("buyers_id") ? $CurrentForm->getValue("buyers_id") : $CurrentForm->getValue("x_buyers_id");
        if (!$this->buyers_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyers_id->Visible = false; // Disable update for API request
            } else {
                $this->buyers_id->setFormValue($val);
            }
        }

        // Check field name 'buyer_uid' first before field var 'x_buyer_uid'
        $val = $CurrentForm->hasValue("buyer_uid") ? $CurrentForm->getValue("buyer_uid") : $CurrentForm->getValue("x_buyer_uid");
        if (!$this->buyer_uid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_uid->Visible = false; // Disable update for API request
            } else {
                $this->buyer_uid->setFormValue($val);
            }
        }

        // Check field name 'buyer_loc' first before field var 'x_buyer_loc'
        $val = $CurrentForm->hasValue("buyer_loc") ? $CurrentForm->getValue("buyer_loc") : $CurrentForm->getValue("x_buyer_loc");
        if (!$this->buyer_loc->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_loc->Visible = false; // Disable update for API request
            } else {
                $this->buyer_loc->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val);
            }
        }

        // Check field name 'sqm' first before field var 'x_sqm'
        $val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
        if (!$this->sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm->Visible = false; // Disable update for API request
            } else {
                $this->sqm->setFormValue($val);
            }
        }

        // Check field name 'sqm_u' first before field var 'x_sqm_u'
        $val = $CurrentForm->hasValue("sqm_u") ? $CurrentForm->getValue("sqm_u") : $CurrentForm->getValue("x_sqm_u");
        if (!$this->sqm_u->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm_u->Visible = false; // Disable update for API request
            } else {
                $this->sqm_u->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'c_sqm' first before field var 'x_c_sqm'
        $val = $CurrentForm->hasValue("c_sqm") ? $CurrentForm->getValue("c_sqm") : $CurrentForm->getValue("x_c_sqm");
        if (!$this->c_sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->c_sqm->Visible = false; // Disable update for API request
            } else {
                $this->c_sqm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'weaving_works' first before field var 'x_weaving_works'
        $val = $CurrentForm->hasValue("weaving_works") ? $CurrentForm->getValue("weaving_works") : $CurrentForm->getValue("x_weaving_works");
        if (!$this->weaving_works->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weaving_works->Visible = false; // Disable update for API request
            } else {
                $this->weaving_works->setFormValue($val);
            }
        }

        // Check field name 'current_works' first before field var 'x_current_works'
        $val = $CurrentForm->hasValue("current_works") ? $CurrentForm->getValue("current_works") : $CurrentForm->getValue("x_current_works");
        if (!$this->current_works->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->current_works->Visible = false; // Disable update for API request
            } else {
                $this->current_works->setFormValue($val);
            }
        }

        // Check field name 'size_buyer' first before field var 'x_size_buyer'
        $val = $CurrentForm->hasValue("size_buyer") ? $CurrentForm->getValue("size_buyer") : $CurrentForm->getValue("x_size_buyer");
        if (!$this->size_buyer->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_buyer->Visible = false; // Disable update for API request
            } else {
                $this->size_buyer->setFormValue($val);
            }
        }

        // Check field name 'w_cm' first before field var 'x_w_cm'
        $val = $CurrentForm->hasValue("w_cm") ? $CurrentForm->getValue("w_cm") : $CurrentForm->getValue("x_w_cm");
        if (!$this->w_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->w_cm->Visible = false; // Disable update for API request
            } else {
                $this->w_cm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'l_cm' first before field var 'x_l_cm'
        $val = $CurrentForm->hasValue("l_cm") ? $CurrentForm->getValue("l_cm") : $CurrentForm->getValue("x_l_cm");
        if (!$this->l_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->l_cm->Visible = false; // Disable update for API request
            } else {
                $this->l_cm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'q_sku' first before field var 'x_q_sku'
        $val = $CurrentForm->hasValue("q_sku") ? $CurrentForm->getValue("q_sku") : $CurrentForm->getValue("x_q_sku");
        if (!$this->q_sku->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->q_sku->Visible = false; // Disable update for API request
            } else {
                $this->q_sku->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'po_price' first before field var 'x_po_price'
        $val = $CurrentForm->hasValue("po_price") ? $CurrentForm->getValue("po_price") : $CurrentForm->getValue("x_po_price");
        if (!$this->po_price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_price->Visible = false; // Disable update for API request
            } else {
                $this->po_price->setFormValue($val);
            }
        }

        // Check field name 'po_discount' first before field var 'x_po_discount'
        $val = $CurrentForm->hasValue("po_discount") ? $CurrentForm->getValue("po_discount") : $CurrentForm->getValue("x_po_discount");
        if (!$this->po_discount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_discount->Visible = false; // Disable update for API request
            } else {
                $this->po_discount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'po_currency' first before field var 'x_po_currency'
        $val = $CurrentForm->hasValue("po_currency") ? $CurrentForm->getValue("po_currency") : $CurrentForm->getValue("x_po_currency");
        if (!$this->po_currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_currency->Visible = false; // Disable update for API request
            } else {
                $this->po_currency->setFormValue($val);
            }
        }

        // Check field name 'product_type' first before field var 'x_product_type'
        $val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
        if (!$this->product_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_type->Visible = false; // Disable update for API request
            } else {
                $this->product_type->setFormValue($val);
            }
        }

        // Check field name 'shape' first before field var 'x_shape'
        $val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
        if (!$this->shape->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shape->Visible = false; // Disable update for API request
            } else {
                $this->shape->setFormValue($val);
            }
        }

        // Check field name 'production_plan' first before field var 'x_production_plan'
        $val = $CurrentForm->hasValue("production_plan") ? $CurrentForm->getValue("production_plan") : $CurrentForm->getValue("x_production_plan");
        if (!$this->production_plan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->production_plan->Visible = false; // Disable update for API request
            } else {
                $this->production_plan->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'completed' first before field var 'x_completed'
        $val = $CurrentForm->hasValue("completed") ? $CurrentForm->getValue("completed") : $CurrentForm->getValue("x_completed");
        if (!$this->completed->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->completed->Visible = false; // Disable update for API request
            } else {
                $this->completed->setFormValue($val);
            }
        }

        // Check field name 'buyer_po' first before field var 'x_buyer_po'
        $val = $CurrentForm->hasValue("buyer_po") ? $CurrentForm->getValue("buyer_po") : $CurrentForm->getValue("x_buyer_po");
        if (!$this->buyer_po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_po->Visible = false; // Disable update for API request
            } else {
                $this->buyer_po->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'jc_no' first before field var 'x_jc_no'
        $val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
        if (!$this->jc_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_no->Visible = false; // Disable update for API request
            } else {
                $this->jc_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'sqm_a' first before field var 'x_sqm_a'
        $val = $CurrentForm->hasValue("sqm_a") ? $CurrentForm->getValue("sqm_a") : $CurrentForm->getValue("x_sqm_a");
        if (!$this->sqm_a->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm_a->Visible = false; // Disable update for API request
            } else {
                $this->sqm_a->setFormValue($val, true, $validate);
            }
        }

        // Check field name '2srm_a' first before field var 'x__2srm_a'
        $val = $CurrentForm->hasValue("2srm_a") ? $CurrentForm->getValue("2srm_a") : $CurrentForm->getValue("x__2srm_a");
        if (!$this->_2srm_a->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_2srm_a->Visible = false; // Disable update for API request
            } else {
                $this->_2srm_a->setFormValue($val, true, $validate);
            }
        }

        // Check field name '4srm_a' first before field var 'x__4srm_a'
        $val = $CurrentForm->hasValue("4srm_a") ? $CurrentForm->getValue("4srm_a") : $CurrentForm->getValue("x__4srm_a");
        if (!$this->_4srm_a->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_4srm_a->Visible = false; // Disable update for API request
            } else {
                $this->_4srm_a->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val);
            }
        }

        // Check field name 'cs' first before field var 'x_cs'
        $val = $CurrentForm->hasValue("cs") ? $CurrentForm->getValue("cs") : $CurrentForm->getValue("x_cs");
        if (!$this->cs->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cs->Visible = false; // Disable update for API request
            } else {
                $this->cs->setFormValue($val);
            }
        }

        // Check field name 'weight' first before field var 'x_weight'
        $val = $CurrentForm->hasValue("weight") ? $CurrentForm->getValue("weight") : $CurrentForm->getValue("x_weight");
        if (!$this->weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weight->Visible = false; // Disable update for API request
            } else {
                $this->weight->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'p_remarks' first before field var 'x_p_remarks'
        $val = $CurrentForm->hasValue("p_remarks") ? $CurrentForm->getValue("p_remarks") : $CurrentForm->getValue("x_p_remarks");
        if (!$this->p_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->p_remarks->Visible = false; // Disable update for API request
            } else {
                $this->p_remarks->setFormValue($val);
            }
        }

        // Check field name 'roll_no' first before field var 'x_roll_no'
        $val = $CurrentForm->hasValue("roll_no") ? $CurrentForm->getValue("roll_no") : $CurrentForm->getValue("x_roll_no");
        if (!$this->roll_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->roll_no->Visible = false; // Disable update for API request
            } else {
                $this->roll_no->setFormValue($val);
            }
        }

        // Check field name 'qty' first before field var 'x_qty'
        $val = $CurrentForm->hasValue("qty") ? $CurrentForm->getValue("qty") : $CurrentForm->getValue("x_qty");
        if (!$this->qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty->Visible = false; // Disable update for API request
            } else {
                $this->qty->setFormValue($val);
            }
        }

        // Check field name 'pl_no' first before field var 'x_pl_no'
        $val = $CurrentForm->hasValue("pl_no") ? $CurrentForm->getValue("pl_no") : $CurrentForm->getValue("x_pl_no");
        if (!$this->pl_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pl_no->Visible = false; // Disable update for API request
            } else {
                $this->pl_no->setFormValue($val);
            }
        }

        // Check field name 'category' first before field var 'x_category'
        $val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
        if (!$this->category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->category->Visible = false; // Disable update for API request
            } else {
                $this->category->setFormValue($val);
            }
        }

        // Check field name 'pp_id' first before field var 'x_pp_id'
        $val = $CurrentForm->hasValue("pp_id") ? $CurrentForm->getValue("pp_id") : $CurrentForm->getValue("x_pp_id");
        if (!$this->pp_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pp_id->Visible = false; // Disable update for API request
            } else {
                $this->pp_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'buyer_barcode' first before field var 'x_buyer_barcode'
        $val = $CurrentForm->hasValue("buyer_barcode") ? $CurrentForm->getValue("buyer_barcode") : $CurrentForm->getValue("x_buyer_barcode");
        if (!$this->buyer_barcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_barcode->Visible = false; // Disable update for API request
            } else {
                $this->buyer_barcode->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->po->CurrentValue = $this->po->FormValue;
        $this->design_id->CurrentValue = $this->design_id->FormValue;
        $this->size_cm->CurrentValue = $this->size_cm->FormValue;
        $this->_barcode->CurrentValue = $this->_barcode->FormValue;
        $this->buyer_ref->CurrentValue = $this->buyer_ref->FormValue;
        $this->order_date->CurrentValue = $this->order_date->FormValue;
        $this->order_date->CurrentValue = UnFormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern());
        $this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
        $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        $this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
        $this->dispatch_week_p->CurrentValue = $this->dispatch_week_p->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->buyers_id->CurrentValue = $this->buyers_id->FormValue;
        $this->buyer_uid->CurrentValue = $this->buyer_uid->FormValue;
        $this->buyer_loc->CurrentValue = $this->buyer_loc->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->sqm->CurrentValue = $this->sqm->FormValue;
        $this->sqm_u->CurrentValue = $this->sqm_u->FormValue;
        $this->c_sqm->CurrentValue = $this->c_sqm->FormValue;
        $this->weaving_works->CurrentValue = $this->weaving_works->FormValue;
        $this->current_works->CurrentValue = $this->current_works->FormValue;
        $this->size_buyer->CurrentValue = $this->size_buyer->FormValue;
        $this->w_cm->CurrentValue = $this->w_cm->FormValue;
        $this->l_cm->CurrentValue = $this->l_cm->FormValue;
        $this->q_sku->CurrentValue = $this->q_sku->FormValue;
        $this->po_price->CurrentValue = $this->po_price->FormValue;
        $this->po_discount->CurrentValue = $this->po_discount->FormValue;
        $this->po_currency->CurrentValue = $this->po_currency->FormValue;
        $this->product_type->CurrentValue = $this->product_type->FormValue;
        $this->shape->CurrentValue = $this->shape->FormValue;
        $this->production_plan->CurrentValue = $this->production_plan->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->completed->CurrentValue = $this->completed->FormValue;
        $this->buyer_po->CurrentValue = $this->buyer_po->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->jc_no->CurrentValue = $this->jc_no->FormValue;
        $this->sqm_a->CurrentValue = $this->sqm_a->FormValue;
        $this->_2srm_a->CurrentValue = $this->_2srm_a->FormValue;
        $this->_4srm_a->CurrentValue = $this->_4srm_a->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->cs->CurrentValue = $this->cs->FormValue;
        $this->weight->CurrentValue = $this->weight->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->p_remarks->CurrentValue = $this->p_remarks->FormValue;
        $this->roll_no->CurrentValue = $this->roll_no->FormValue;
        $this->qty->CurrentValue = $this->qty->FormValue;
        $this->pl_no->CurrentValue = $this->pl_no->FormValue;
        $this->category->CurrentValue = $this->category->FormValue;
        $this->pp_id->CurrentValue = $this->pp_id->FormValue;
        $this->buyer_barcode->CurrentValue = $this->buyer_barcode->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->pid->setDbValue($row['pid']);
        $this->po->setDbValue($row['po']);
        $this->design_id->setDbValue($row['design_id']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->process_d->setDbValue($row['process_d']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        if (array_key_exists('EV__buyer_ref', $row)) {
            $this->buyer_ref->VirtualValue = $row['EV__buyer_ref']; // Set up virtual field value
        } else {
            $this->buyer_ref->VirtualValue = ""; // Clear value
        }
        $this->order_date->setDbValue($row['order_date']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->dispatch_week_p->setDbValue($row['dispatch_week_p']);
        $this->loom_plan->setDbValue($row['loom_plan']);
        $this->status->setDbValue($row['status']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->quantity->setDbValue($row['quantity']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_u->setDbValue($row['sqm_u']);
        $this->c_sqm->setDbValue($row['c_sqm']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->current_works->setDbValue($row['current_works']);
        $this->size_buyer->setDbValue($row['size_buyer']);
        $this->design->setDbValue($row['design']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->po_price->setDbValue($row['po_price']);
        $this->po_discount->setDbValue($row['po_discount']);
        $this->po_currency->setDbValue($row['po_currency']);
        $this->product_type->setDbValue($row['product_type']);
        $this->shape->setDbValue($row['shape']);
        $this->payment_plan->setDbValue($row['payment_plan']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->datetime->setDbValue($row['datetime']);
        $this->completed->setDbValue($row['completed']);
        $this->buyer_po->setDbValue($row['buyer_po']);
        $this->operator->setDbValue($row['operator']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->_2srm->setDbValue($row['2srm']);
        $this->_2srm_a->setDbValue($row['2srm_a']);
        $this->_4srm->setDbValue($row['4srm']);
        $this->_4srm_a->setDbValue($row['4srm_a']);
        $this->buyer_tid->setDbValue($row['buyer_tid']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->cs->setDbValue($row['cs']);
        $this->process->setDbValue($row['process']);
        $this->process_c->setDbValue($row['process_c']);
        $this->weight->setDbValue($row['weight']);
        $this->remarks->setDbValue($row['remarks']);
        $this->p_remarks->setDbValue($row['p_remarks']);
        $this->roll_no->setDbValue($row['roll_no']);
        $this->qty->setDbValue($row['qty']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->category->setDbValue($row['category']);
        $this->pp_id->setDbValue($row['pp_id']);
        $this->consignee->setDbValue($row['consignee']);
        $this->buyer_barcode->setDbValue($row['buyer_barcode']);
        $this->design_next->setDbValue($row['design_next']);
        $this->_11->setDbValue($row['11']);
        $this->_12->setDbValue($row['12']);
        $this->_13->setDbValue($row['13']);
        $this->_14->setDbValue($row['14']);
        $this->_15->setDbValue($row['15']);
        $this->_16->setDbValue($row['16']);
        $this->_17->setDbValue($row['17']);
        $this->_18->setDbValue($row['18']);
        $this->_19->setDbValue($row['19']);
        $this->_20->setDbValue($row['20']);
        $this->_21->setDbValue($row['21']);
        $this->_22->setDbValue($row['22']);
        $this->_23->setDbValue($row['23']);
        $this->_24->setDbValue($row['24']);
        $this->_25->setDbValue($row['25']);
        $this->_26->setDbValue($row['26']);
        $this->_27->setDbValue($row['27']);
        $this->_28->setDbValue($row['28']);
        $this->_29->setDbValue($row['29']);
        $this->_30->setDbValue($row['30']);
        $this->_31->setDbValue($row['31']);
        $this->_32->setDbValue($row['32']);
        $this->_33->setDbValue($row['33']);
        $this->_34->setDbValue($row['34']);
        $this->_35->setDbValue($row['35']);
        $this->_36->setDbValue($row['36']);
        $this->_37->setDbValue($row['37']);
        $this->_38->setDbValue($row['38']);
        $this->_39->setDbValue($row['39']);
        $this->_40->setDbValue($row['40']);
        $this->_41->setDbValue($row['41']);
        $this->_42->setDbValue($row['42']);
        $this->_43->setDbValue($row['43']);
        $this->_44->setDbValue($row['44']);
        $this->_45->setDbValue($row['45']);
        $this->_46->setDbValue($row['46']);
        $this->_47->setDbValue($row['47']);
        $this->_48->setDbValue($row['48']);
        $this->_49->setDbValue($row['49']);
        $this->_50->setDbValue($row['50']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->qc_weaving->setDbValue($row['qc_weaving']);
        $this->roll_no_qty_tmp->setDbValue($row['roll_no_qty_tmp']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['pid'] = $this->pid->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['design_id'] = $this->design_id->DefaultValue;
        $row['size_cm'] = $this->size_cm->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['process_d'] = $this->process_d->DefaultValue;
        $row['buyer_ref'] = $this->buyer_ref->DefaultValue;
        $row['order_date'] = $this->order_date->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['dispatch_week_p'] = $this->dispatch_week_p->DefaultValue;
        $row['loom_plan'] = $this->loom_plan->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['buyers_id'] = $this->buyers_id->DefaultValue;
        $row['buyer_uid'] = $this->buyer_uid->DefaultValue;
        $row['buyer_loc'] = $this->buyer_loc->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['sqm_u'] = $this->sqm_u->DefaultValue;
        $row['c_sqm'] = $this->c_sqm->DefaultValue;
        $row['weaving_works'] = $this->weaving_works->DefaultValue;
        $row['current_works'] = $this->current_works->DefaultValue;
        $row['size_buyer'] = $this->size_buyer->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['po_price'] = $this->po_price->DefaultValue;
        $row['po_discount'] = $this->po_discount->DefaultValue;
        $row['po_currency'] = $this->po_currency->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['payment_plan'] = $this->payment_plan->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['completed'] = $this->completed->DefaultValue;
        $row['buyer_po'] = $this->buyer_po->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['sqm_a'] = $this->sqm_a->DefaultValue;
        $row['2srm'] = $this->_2srm->DefaultValue;
        $row['2srm_a'] = $this->_2srm_a->DefaultValue;
        $row['4srm'] = $this->_4srm->DefaultValue;
        $row['4srm_a'] = $this->_4srm_a->DefaultValue;
        $row['buyer_tid'] = $this->buyer_tid->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['cs'] = $this->cs->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['process_c'] = $this->process_c->DefaultValue;
        $row['weight'] = $this->weight->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['p_remarks'] = $this->p_remarks->DefaultValue;
        $row['roll_no'] = $this->roll_no->DefaultValue;
        $row['qty'] = $this->qty->DefaultValue;
        $row['pl_no'] = $this->pl_no->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['pp_id'] = $this->pp_id->DefaultValue;
        $row['consignee'] = $this->consignee->DefaultValue;
        $row['buyer_barcode'] = $this->buyer_barcode->DefaultValue;
        $row['design_next'] = $this->design_next->DefaultValue;
        $row['11'] = $this->_11->DefaultValue;
        $row['12'] = $this->_12->DefaultValue;
        $row['13'] = $this->_13->DefaultValue;
        $row['14'] = $this->_14->DefaultValue;
        $row['15'] = $this->_15->DefaultValue;
        $row['16'] = $this->_16->DefaultValue;
        $row['17'] = $this->_17->DefaultValue;
        $row['18'] = $this->_18->DefaultValue;
        $row['19'] = $this->_19->DefaultValue;
        $row['20'] = $this->_20->DefaultValue;
        $row['21'] = $this->_21->DefaultValue;
        $row['22'] = $this->_22->DefaultValue;
        $row['23'] = $this->_23->DefaultValue;
        $row['24'] = $this->_24->DefaultValue;
        $row['25'] = $this->_25->DefaultValue;
        $row['26'] = $this->_26->DefaultValue;
        $row['27'] = $this->_27->DefaultValue;
        $row['28'] = $this->_28->DefaultValue;
        $row['29'] = $this->_29->DefaultValue;
        $row['30'] = $this->_30->DefaultValue;
        $row['31'] = $this->_31->DefaultValue;
        $row['32'] = $this->_32->DefaultValue;
        $row['33'] = $this->_33->DefaultValue;
        $row['34'] = $this->_34->DefaultValue;
        $row['35'] = $this->_35->DefaultValue;
        $row['36'] = $this->_36->DefaultValue;
        $row['37'] = $this->_37->DefaultValue;
        $row['38'] = $this->_38->DefaultValue;
        $row['39'] = $this->_39->DefaultValue;
        $row['40'] = $this->_40->DefaultValue;
        $row['41'] = $this->_41->DefaultValue;
        $row['42'] = $this->_42->DefaultValue;
        $row['43'] = $this->_43->DefaultValue;
        $row['44'] = $this->_44->DefaultValue;
        $row['45'] = $this->_45->DefaultValue;
        $row['46'] = $this->_46->DefaultValue;
        $row['47'] = $this->_47->DefaultValue;
        $row['48'] = $this->_48->DefaultValue;
        $row['49'] = $this->_49->DefaultValue;
        $row['50'] = $this->_50->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['qc_weaving'] = $this->qc_weaving->DefaultValue;
        $row['roll_no_qty_tmp'] = $this->roll_no_qty_tmp->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // pid
        $this->pid->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // design_id
        $this->design_id->RowCssClass = "row";

        // size_cm
        $this->size_cm->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // process_d
        $this->process_d->RowCssClass = "row";

        // buyer_ref
        $this->buyer_ref->RowCssClass = "row";

        // order_date
        $this->order_date->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // dispatch_week_p
        $this->dispatch_week_p->RowCssClass = "row";

        // loom_plan
        $this->loom_plan->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // buyers_id
        $this->buyers_id->RowCssClass = "row";

        // buyer_uid
        $this->buyer_uid->RowCssClass = "row";

        // buyer_loc
        $this->buyer_loc->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // sqm_u
        $this->sqm_u->RowCssClass = "row";

        // c_sqm
        $this->c_sqm->RowCssClass = "row";

        // weaving_works
        $this->weaving_works->RowCssClass = "row";

        // current_works
        $this->current_works->RowCssClass = "row";

        // size_buyer
        $this->size_buyer->RowCssClass = "row";

        // design
        $this->design->RowCssClass = "row";

        // w_cm
        $this->w_cm->RowCssClass = "row";

        // l_cm
        $this->l_cm->RowCssClass = "row";

        // q_sku
        $this->q_sku->RowCssClass = "row";

        // po_price
        $this->po_price->RowCssClass = "row";

        // po_discount
        $this->po_discount->RowCssClass = "row";

        // po_currency
        $this->po_currency->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // payment_plan
        $this->payment_plan->RowCssClass = "row";

        // production_plan
        $this->production_plan->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // completed
        $this->completed->RowCssClass = "row";

        // buyer_po
        $this->buyer_po->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // sqm_a
        $this->sqm_a->RowCssClass = "row";

        // 2srm
        $this->_2srm->RowCssClass = "row";

        // 2srm_a
        $this->_2srm_a->RowCssClass = "row";

        // 4srm
        $this->_4srm->RowCssClass = "row";

        // 4srm_a
        $this->_4srm_a->RowCssClass = "row";

        // buyer_tid
        $this->buyer_tid->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // cs
        $this->cs->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // process_c
        $this->process_c->RowCssClass = "row";

        // weight
        $this->weight->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // p_remarks
        $this->p_remarks->RowCssClass = "row";

        // roll_no
        $this->roll_no->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // pl_no
        $this->pl_no->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // pp_id
        $this->pp_id->RowCssClass = "row";

        // consignee
        $this->consignee->RowCssClass = "row";

        // buyer_barcode
        $this->buyer_barcode->RowCssClass = "row";

        // design_next
        $this->design_next->RowCssClass = "row";

        // 11
        $this->_11->RowCssClass = "row";

        // 12
        $this->_12->RowCssClass = "row";

        // 13
        $this->_13->RowCssClass = "row";

        // 14
        $this->_14->RowCssClass = "row";

        // 15
        $this->_15->RowCssClass = "row";

        // 16
        $this->_16->RowCssClass = "row";

        // 17
        $this->_17->RowCssClass = "row";

        // 18
        $this->_18->RowCssClass = "row";

        // 19
        $this->_19->RowCssClass = "row";

        // 20
        $this->_20->RowCssClass = "row";

        // 21
        $this->_21->RowCssClass = "row";

        // 22
        $this->_22->RowCssClass = "row";

        // 23
        $this->_23->RowCssClass = "row";

        // 24
        $this->_24->RowCssClass = "row";

        // 25
        $this->_25->RowCssClass = "row";

        // 26
        $this->_26->RowCssClass = "row";

        // 27
        $this->_27->RowCssClass = "row";

        // 28
        $this->_28->RowCssClass = "row";

        // 29
        $this->_29->RowCssClass = "row";

        // 30
        $this->_30->RowCssClass = "row";

        // 31
        $this->_31->RowCssClass = "row";

        // 32
        $this->_32->RowCssClass = "row";

        // 33
        $this->_33->RowCssClass = "row";

        // 34
        $this->_34->RowCssClass = "row";

        // 35
        $this->_35->RowCssClass = "row";

        // 36
        $this->_36->RowCssClass = "row";

        // 37
        $this->_37->RowCssClass = "row";

        // 38
        $this->_38->RowCssClass = "row";

        // 39
        $this->_39->RowCssClass = "row";

        // 40
        $this->_40->RowCssClass = "row";

        // 41
        $this->_41->RowCssClass = "row";

        // 42
        $this->_42->RowCssClass = "row";

        // 43
        $this->_43->RowCssClass = "row";

        // 44
        $this->_44->RowCssClass = "row";

        // 45
        $this->_45->RowCssClass = "row";

        // 46
        $this->_46->RowCssClass = "row";

        // 47
        $this->_47->RowCssClass = "row";

        // 48
        $this->_48->RowCssClass = "row";

        // 49
        $this->_49->RowCssClass = "row";

        // 50
        $this->_50->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // qc_weaving
        $this->qc_weaving->RowCssClass = "row";

        // roll_no_qty_tmp
        $this->roll_no_qty_tmp->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // pid
            $this->pid->ViewValue = $this->pid->CurrentValue;
            $this->pid->ViewValue = FormatNumber($this->pid->ViewValue, $this->pid->formatPattern());

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // design_id
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->ViewValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->ViewValue = null;
            }

            // size_cm
            $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // process_d
            $curVal = strval($this->process_d->CurrentValue);
            if ($curVal != "") {
                $this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
                if ($this->process_d->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_d->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_d->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process_d->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_d->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_d->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_d->Lookup->renderViewRow($row);
                            $this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
                        }
                    } else {
                        $this->process_d->ViewValue = $this->process_d->CurrentValue;
                    }
                }
            } else {
                $this->process_d->ViewValue = null;
            }

            // buyer_ref
            if ($this->buyer_ref->VirtualValue != "") {
                $this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
            } else {
                $curVal = strval($this->buyer_ref->CurrentValue);
                if ($curVal != "") {
                    $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
                    if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                            $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                        } else {
                            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                        }
                    }
                } else {
                    $this->buyer_ref->ViewValue = null;
                }
            }

            // order_date
            $this->order_date->ViewValue = $this->order_date->CurrentValue;
            $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // dispatch_week_p
            $curVal = strval($this->dispatch_week_p->CurrentValue);
            if ($curVal != "") {
                $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
                if ($this->dispatch_week_p->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->dispatch_week_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->dispatch_week_p->Lookup->renderViewRow($rswrk[0]);
                        $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
                    } else {
                        $this->dispatch_week_p->ViewValue = FormatNumber($this->dispatch_week_p->CurrentValue, $this->dispatch_week_p->formatPattern());
                    }
                }
            } else {
                $this->dispatch_week_p->ViewValue = null;
            }

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // buyer_uid
            $this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;

            // buyer_loc
            $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // sqm_u
            $this->sqm_u->ViewValue = $this->sqm_u->CurrentValue;
            $this->sqm_u->ViewValue = FormatNumber($this->sqm_u->ViewValue, $this->sqm_u->formatPattern());

            // c_sqm
            $this->c_sqm->ViewValue = $this->c_sqm->CurrentValue;
            $this->c_sqm->ViewValue = FormatNumber($this->c_sqm->ViewValue, $this->c_sqm->formatPattern());

            // weaving_works
            $curVal = strval($this->weaving_works->CurrentValue);
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
                if ($this->weaving_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                        $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                    } else {
                        $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                    }
                }
            } else {
                $this->weaving_works->ViewValue = null;
            }

            // current_works
            $curVal = strval($this->current_works->CurrentValue);
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
                if ($this->current_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                        $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                    } else {
                        $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                    }
                }
            } else {
                $this->current_works->ViewValue = null;
            }

            // size_buyer
            $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

            // w_cm
            $this->w_cm->ViewValue = $this->w_cm->CurrentValue;
            $this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, $this->w_cm->formatPattern());

            // l_cm
            $this->l_cm->ViewValue = $this->l_cm->CurrentValue;
            $this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, $this->l_cm->formatPattern());

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;
            $this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, $this->q_sku->formatPattern());

            // po_price
            $this->po_price->ViewValue = $this->po_price->CurrentValue;

            // po_discount
            $this->po_discount->ViewValue = $this->po_discount->CurrentValue;
            $this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, $this->po_discount->formatPattern());

            // po_currency
            $curVal = strval($this->po_currency->CurrentValue);
            if ($curVal != "") {
                $this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
                if ($this->po_currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_currency->Lookup->renderViewRow($rswrk[0]);
                        $this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
                    } else {
                        $this->po_currency->ViewValue = FormatNumber($this->po_currency->CurrentValue, $this->po_currency->formatPattern());
                    }
                }
            } else {
                $this->po_currency->ViewValue = null;
            }

            // product_type
            if (strval($this->product_type->CurrentValue) != "") {
                $this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
            } else {
                $this->product_type->ViewValue = null;
            }

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->ViewValue = FormatNumber($this->shape->CurrentValue, $this->shape->formatPattern());
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // payment_plan
            $curVal = strval($this->payment_plan->CurrentValue);
            if ($curVal != "") {
                $this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
                if ($this->payment_plan->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->payment_plan->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_plan->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
                    } else {
                        $this->payment_plan->ViewValue = FormatNumber($this->payment_plan->CurrentValue, $this->payment_plan->formatPattern());
                    }
                }
            } else {
                $this->payment_plan->ViewValue = null;
            }

            // production_plan
            if (strval($this->production_plan->CurrentValue) != "") {
                $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
            } else {
                $this->production_plan->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // completed
            if (strval($this->completed->CurrentValue) != "") {
                $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
            } else {
                $this->completed->ViewValue = null;
            }

            // buyer_po
            $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // sqm_a
            $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
            $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

            // 2srm_a
            $this->_2srm_a->ViewValue = $this->_2srm_a->CurrentValue;
            $this->_2srm_a->ViewValue = FormatNumber($this->_2srm_a->ViewValue, $this->_2srm_a->formatPattern());

            // 4srm_a
            $this->_4srm_a->ViewValue = $this->_4srm_a->CurrentValue;
            $this->_4srm_a->ViewValue = FormatNumber($this->_4srm_a->ViewValue, $this->_4srm_a->formatPattern());

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // cs
            if (strval($this->cs->CurrentValue) != "") {
                $this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
            } else {
                $this->cs->ViewValue = null;
            }

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process->Lookup->renderViewRow($row);
                            $this->process->ViewValue->add($this->process->displayValue($arwrk));
                        }
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // process_c
            $curVal = strval($this->process_c->CurrentValue);
            if ($curVal != "") {
                $this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
                if ($this->process_c->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_c->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_c->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process_c->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_c->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_c->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_c->Lookup->renderViewRow($row);
                            $this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
                        }
                    } else {
                        $this->process_c->ViewValue = $this->process_c->CurrentValue;
                    }
                }
            } else {
                $this->process_c->ViewValue = null;
            }

            // weight
            $this->weight->ViewValue = $this->weight->CurrentValue;
            $this->weight->ViewValue = FormatNumber($this->weight->ViewValue, $this->weight->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // p_remarks
            $this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;
            $this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, $this->roll_no->formatPattern());

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // pl_no
            $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
            $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // pp_id
            $this->pp_id->ViewValue = $this->pp_id->CurrentValue;
            $curVal = strval($this->pp_id->CurrentValue);
            if ($curVal != "") {
                $this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
                if ($this->pp_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pp_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pp_id->Lookup->renderViewRow($rswrk[0]);
                        $this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
                    } else {
                        $this->pp_id->ViewValue = FormatNumber($this->pp_id->CurrentValue, $this->pp_id->formatPattern());
                    }
                }
            } else {
                $this->pp_id->ViewValue = null;
            }

            // buyer_barcode
            $this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;

            // 11
            $this->_11->ViewValue = $this->_11->CurrentValue;

            // 12
            $this->_12->ViewValue = $this->_12->CurrentValue;

            // 13
            $this->_13->ViewValue = $this->_13->CurrentValue;

            // 14
            $this->_14->ViewValue = $this->_14->CurrentValue;

            // 15
            $this->_15->ViewValue = $this->_15->CurrentValue;

            // 16
            $this->_16->ViewValue = $this->_16->CurrentValue;

            // 17
            $this->_17->ViewValue = $this->_17->CurrentValue;

            // 18
            $this->_18->ViewValue = $this->_18->CurrentValue;

            // 19
            $this->_19->ViewValue = $this->_19->CurrentValue;

            // 20
            $this->_20->ViewValue = $this->_20->CurrentValue;

            // 21
            $this->_21->ViewValue = $this->_21->CurrentValue;

            // 22
            $this->_22->ViewValue = $this->_22->CurrentValue;

            // 23
            $this->_23->ViewValue = $this->_23->CurrentValue;

            // 24
            $this->_24->ViewValue = $this->_24->CurrentValue;

            // 25
            $this->_25->ViewValue = $this->_25->CurrentValue;

            // 26
            $this->_26->ViewValue = $this->_26->CurrentValue;

            // 27
            $this->_27->ViewValue = $this->_27->CurrentValue;

            // 28
            $this->_28->ViewValue = $this->_28->CurrentValue;

            // 29
            $this->_29->ViewValue = $this->_29->CurrentValue;

            // 30
            $this->_30->ViewValue = $this->_30->CurrentValue;

            // 31
            $this->_31->ViewValue = $this->_31->CurrentValue;

            // 32
            $this->_32->ViewValue = $this->_32->CurrentValue;

            // 33
            $this->_33->ViewValue = $this->_33->CurrentValue;

            // 34
            $this->_34->ViewValue = $this->_34->CurrentValue;

            // 35
            $this->_35->ViewValue = $this->_35->CurrentValue;

            // 36
            $this->_36->ViewValue = $this->_36->CurrentValue;

            // 37
            $this->_37->ViewValue = $this->_37->CurrentValue;

            // 38
            $this->_38->ViewValue = $this->_38->CurrentValue;

            // 39
            $this->_39->ViewValue = $this->_39->CurrentValue;

            // 40
            $this->_40->ViewValue = $this->_40->CurrentValue;

            // 41
            $this->_41->ViewValue = $this->_41->CurrentValue;

            // 42
            $this->_42->ViewValue = $this->_42->CurrentValue;

            // 43
            $this->_43->ViewValue = $this->_43->CurrentValue;

            // 44
            $this->_44->ViewValue = $this->_44->CurrentValue;

            // 45
            $this->_45->ViewValue = $this->_45->CurrentValue;

            // 46
            $this->_46->ViewValue = $this->_46->CurrentValue;

            // 47
            $this->_47->ViewValue = $this->_47->CurrentValue;

            // 48
            $this->_48->ViewValue = $this->_48->CurrentValue;

            // 49
            $this->_49->ViewValue = $this->_49->CurrentValue;

            // 50
            $this->_50->ViewValue = $this->_50->CurrentValue;

            // id
            $this->id->HrefValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // design_id
            if (!EmptyValue($this->design_id->CurrentValue)) {
                $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . (!empty($this->design_id->EditValue) && !is_array($this->design_id->EditValue) ? RemoveHtml($this->design_id->EditValue) : $this->design_id->CurrentValue); // Add prefix/suffix
                $this->design_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
                }
            } else {
                $this->design_id->HrefValue = "";
            }
            $this->design_id->TooltipValue = "";

            // size_cm
            $this->size_cm->HrefValue = "";
            $this->size_cm->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // buyer_ref
            if (!EmptyValue($this->buyer_ref->CurrentValue)) {
                $this->buyer_ref->HrefValue = $this->buyer_ref->getLinkPrefix() . $this->buyer_ref->CurrentValue; // Add prefix/suffix
                $this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
                }
            } else {
                $this->buyer_ref->HrefValue = "";
            }
            $this->buyer_ref->TooltipValue = "";

            // order_date
            $this->order_date->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // dispatch_week_p
            $this->dispatch_week_p->HrefValue = "";
            $this->dispatch_week_p->TooltipValue = "";

            // status
            $this->status->HrefValue = "";

            // buyers_id
            if (!EmptyValue($this->buyers_id->CurrentValue)) {
                $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
                $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
                }
            } else {
                $this->buyers_id->HrefValue = "";
            }
            $this->buyers_id->TooltipValue = "";

            // buyer_uid
            $this->buyer_uid->HrefValue = "";

            // buyer_loc
            $this->buyer_loc->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // sqm_u
            $this->sqm_u->HrefValue = "";

            // c_sqm
            $this->c_sqm->HrefValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";

            // current_works
            $this->current_works->HrefValue = "";

            // size_buyer
            $this->size_buyer->HrefValue = "";

            // w_cm
            $this->w_cm->HrefValue = "";

            // l_cm
            $this->l_cm->HrefValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";

            // po_price
            $this->po_price->HrefValue = "";
            $this->po_price->TooltipValue = "";

            // po_discount
            $this->po_discount->HrefValue = "";

            // po_currency
            $this->po_currency->HrefValue = "";
            $this->po_currency->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // completed
            $this->completed->HrefValue = "";

            // buyer_po
            $this->buyer_po->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";

            // sqm_a
            $this->sqm_a->HrefValue = "";

            // 2srm_a
            $this->_2srm_a->HrefValue = "";

            // 4srm_a
            $this->_4srm_a->HrefValue = "";

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }

            // cs
            $this->cs->HrefValue = "";

            // weight
            $this->weight->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // p_remarks
            $this->p_remarks->HrefValue = "";

            // roll_no
            $this->roll_no->HrefValue = "";
            $this->roll_no->TooltipValue = "";

            // qty
            $this->qty->HrefValue = "";
            $this->qty->TooltipValue = "";

            // pl_no
            $this->pl_no->HrefValue = "";
            $this->pl_no->TooltipValue = "";

            // category
            $this->category->HrefValue = "";

            // pp_id
            $this->pp_id->HrefValue = "";

            // buyer_barcode
            $this->buyer_barcode->HrefValue = "";
            $this->buyer_barcode->TooltipValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->CurrentValue;
            $this->po->EditValue = FormatNumber($this->po->EditValue, $this->po->formatPattern());

            // design_id
            $this->design_id->setupEditAttributes();
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->EditValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->EditValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->EditValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->EditValue = null;
            }

            // size_cm
            $this->size_cm->setupEditAttributes();
            $this->size_cm->EditValue = $this->size_cm->CurrentValue;

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue = $this->_barcode->CurrentValue;

            // buyer_ref
            $this->buyer_ref->setupEditAttributes();
            if ($this->buyer_ref->VirtualValue != "") {
                $this->buyer_ref->EditValue = $this->buyer_ref->VirtualValue;
            } else {
                $curVal = strval($this->buyer_ref->CurrentValue);
                if ($curVal != "") {
                    $this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
                    if ($this->buyer_ref->EditValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                            $this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
                        } else {
                            $this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
                        }
                    }
                } else {
                    $this->buyer_ref->EditValue = null;
                }
            }

            // order_date
            $this->order_date->setupEditAttributes();
            $this->order_date->EditValue = HtmlEncode(FormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern()));
            $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

            // despatch_date
            $this->despatch_date->setupEditAttributes();
            $this->despatch_date->EditValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->EditValue = FormatDateTime($this->despatch_date->EditValue, $this->despatch_date->formatPattern());

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->CurrentValue));
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->ViewValue = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->ViewValue !== null) { // Load from cache
                $this->despatch_week->EditValue = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->CurrentValue, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // dispatch_week_p
            $this->dispatch_week_p->setupEditAttributes();
            $curVal = strval($this->dispatch_week_p->CurrentValue);
            if ($curVal != "") {
                $this->dispatch_week_p->EditValue = $this->dispatch_week_p->lookupCacheOption($curVal);
                if ($this->dispatch_week_p->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->dispatch_week_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->dispatch_week_p->Lookup->renderViewRow($rswrk[0]);
                        $this->dispatch_week_p->EditValue = $this->dispatch_week_p->displayValue($arwrk);
                    } else {
                        $this->dispatch_week_p->EditValue = FormatNumber($this->dispatch_week_p->CurrentValue, $this->dispatch_week_p->formatPattern());
                    }
                }
            } else {
                $this->dispatch_week_p->EditValue = null;
            }

            // status
            $this->status->setupEditAttributes();
            $curVal = trim(strval($this->status->CurrentValue));
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
            } else {
                $this->status->ViewValue = $this->status->Lookup !== null && is_array($this->status->lookupOptions()) && count($this->status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->status->ViewValue !== null) { // Load from cache
                $this->status->EditValue = array_values($this->status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->status->CurrentValue, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->status->EditValue = $arwrk;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // buyers_id
            $this->buyers_id->setupEditAttributes();
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->EditValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->EditValue = null;
            }

            // buyer_uid
            $this->buyer_uid->setupEditAttributes();
            if (!$this->buyer_uid->Raw) {
                $this->buyer_uid->CurrentValue = HtmlDecode($this->buyer_uid->CurrentValue);
            }
            $this->buyer_uid->EditValue = HtmlEncode($this->buyer_uid->CurrentValue);
            $this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

            // buyer_loc
            $this->buyer_loc->setupEditAttributes();
            if (!$this->buyer_loc->Raw) {
                $this->buyer_loc->CurrentValue = HtmlDecode($this->buyer_loc->CurrentValue);
            }
            $this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->CurrentValue);
            $this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, $this->quantity->formatPattern());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->CurrentValue;
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, $this->sqm->formatPattern());

            // sqm_u
            $this->sqm_u->setupEditAttributes();
            $this->sqm_u->EditValue = $this->sqm_u->CurrentValue;
            $this->sqm_u->PlaceHolder = RemoveHtml($this->sqm_u->caption());
            if (strval($this->sqm_u->EditValue) != "" && is_numeric($this->sqm_u->EditValue)) {
                $this->sqm_u->EditValue = FormatNumber($this->sqm_u->EditValue, null);
            }

            // c_sqm
            $this->c_sqm->setupEditAttributes();
            $this->c_sqm->EditValue = $this->c_sqm->CurrentValue;
            $this->c_sqm->PlaceHolder = RemoveHtml($this->c_sqm->caption());
            if (strval($this->c_sqm->EditValue) != "" && is_numeric($this->c_sqm->EditValue)) {
                $this->c_sqm->EditValue = FormatNumber($this->c_sqm->EditValue, null);
            }

            // weaving_works
            $this->weaving_works->setupEditAttributes();
            $curVal = trim(strval($this->weaving_works->CurrentValue));
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
            } else {
                $this->weaving_works->ViewValue = $this->weaving_works->Lookup !== null && is_array($this->weaving_works->lookupOptions()) && count($this->weaving_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->weaving_works->ViewValue !== null) { // Load from cache
                $this->weaving_works->EditValue = array_values($this->weaving_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->weaving_works->CurrentValue, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->weaving_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->weaving_works->EditValue = $arwrk;
            }
            $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

            // current_works
            $this->current_works->setupEditAttributes();
            $curVal = trim(strval($this->current_works->CurrentValue));
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
            } else {
                $this->current_works->ViewValue = $this->current_works->Lookup !== null && is_array($this->current_works->lookupOptions()) && count($this->current_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->current_works->ViewValue !== null) { // Load from cache
                $this->current_works->EditValue = array_values($this->current_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->current_works->CurrentValue, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->current_works->EditValue = $arwrk;
            }
            $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

            // size_buyer
            $this->size_buyer->setupEditAttributes();
            if (!$this->size_buyer->Raw) {
                $this->size_buyer->CurrentValue = HtmlDecode($this->size_buyer->CurrentValue);
            }
            $this->size_buyer->EditValue = HtmlEncode($this->size_buyer->CurrentValue);
            $this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

            // w_cm
            $this->w_cm->setupEditAttributes();
            $this->w_cm->EditValue = $this->w_cm->CurrentValue;
            $this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());
            if (strval($this->w_cm->EditValue) != "" && is_numeric($this->w_cm->EditValue)) {
                $this->w_cm->EditValue = FormatNumber($this->w_cm->EditValue, null);
            }

            // l_cm
            $this->l_cm->setupEditAttributes();
            $this->l_cm->EditValue = $this->l_cm->CurrentValue;
            $this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());
            if (strval($this->l_cm->EditValue) != "" && is_numeric($this->l_cm->EditValue)) {
                $this->l_cm->EditValue = FormatNumber($this->l_cm->EditValue, null);
            }

            // q_sku
            $this->q_sku->setupEditAttributes();
            $this->q_sku->EditValue = $this->q_sku->CurrentValue;
            $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());
            if (strval($this->q_sku->EditValue) != "" && is_numeric($this->q_sku->EditValue)) {
                $this->q_sku->EditValue = FormatNumber($this->q_sku->EditValue, null);
            }

            // po_price
            $this->po_price->setupEditAttributes();
            $this->po_price->EditValue = $this->po_price->CurrentValue;

            // po_discount
            $this->po_discount->setupEditAttributes();
            $this->po_discount->EditValue = $this->po_discount->CurrentValue;
            $this->po_discount->PlaceHolder = RemoveHtml($this->po_discount->caption());
            if (strval($this->po_discount->EditValue) != "" && is_numeric($this->po_discount->EditValue)) {
                $this->po_discount->EditValue = FormatNumber($this->po_discount->EditValue, null);
            }

            // po_currency
            $this->po_currency->setupEditAttributes();
            $curVal = strval($this->po_currency->CurrentValue);
            if ($curVal != "") {
                $this->po_currency->EditValue = $this->po_currency->lookupCacheOption($curVal);
                if ($this->po_currency->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_currency->Lookup->renderViewRow($rswrk[0]);
                        $this->po_currency->EditValue = $this->po_currency->displayValue($arwrk);
                    } else {
                        $this->po_currency->EditValue = FormatNumber($this->po_currency->CurrentValue, $this->po_currency->formatPattern());
                    }
                }
            } else {
                $this->po_currency->EditValue = null;
            }

            // product_type
            $this->product_type->setupEditAttributes();
            $this->product_type->EditValue = $this->product_type->options(true);
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // shape
            $this->shape->setupEditAttributes();
            $curVal = trim(strval($this->shape->CurrentValue));
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            } else {
                $this->shape->ViewValue = $this->shape->Lookup !== null && is_array($this->shape->lookupOptions()) && count($this->shape->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shape->ViewValue !== null) { // Load from cache
                $this->shape->EditValue = array_values($this->shape->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->shape->CurrentValue, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->shape->EditValue = $arwrk;
            }
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // production_plan
            $this->production_plan->setupEditAttributes();
            $this->production_plan->EditValue = $this->production_plan->options(true);
            $this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());

            // datetime

            // completed
            $this->completed->setupEditAttributes();
            $this->completed->EditValue = $this->completed->options(true);
            $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

            // buyer_po
            $this->buyer_po->setupEditAttributes();
            if (!$this->buyer_po->Raw) {
                $this->buyer_po->CurrentValue = HtmlDecode($this->buyer_po->CurrentValue);
            }
            $this->buyer_po->EditValue = HtmlEncode($this->buyer_po->CurrentValue);
            $this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

            // operator

            // jc_no
            $this->jc_no->setupEditAttributes();
            $this->jc_no->EditValue = $this->jc_no->CurrentValue;
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
            if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
                $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
            }

            // sqm_a
            $this->sqm_a->setupEditAttributes();
            $this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
            $this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
            if (strval($this->sqm_a->EditValue) != "" && is_numeric($this->sqm_a->EditValue)) {
                $this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, null);
            }

            // 2srm_a
            $this->_2srm_a->setupEditAttributes();
            $this->_2srm_a->EditValue = $this->_2srm_a->CurrentValue;
            $this->_2srm_a->PlaceHolder = RemoveHtml($this->_2srm_a->caption());
            if (strval($this->_2srm_a->EditValue) != "" && is_numeric($this->_2srm_a->EditValue)) {
                $this->_2srm_a->EditValue = FormatNumber($this->_2srm_a->EditValue, null);
            }

            // 4srm_a
            $this->_4srm_a->setupEditAttributes();
            $this->_4srm_a->EditValue = $this->_4srm_a->CurrentValue;
            $this->_4srm_a->PlaceHolder = RemoveHtml($this->_4srm_a->caption());
            if (strval($this->_4srm_a->EditValue) != "" && is_numeric($this->_4srm_a->EditValue)) {
                $this->_4srm_a->EditValue = FormatNumber($this->_4srm_a->EditValue, null);
            }

            // batch_no
            $this->batch_no->setupEditAttributes();
            $curVal = trim(strval($this->batch_no->CurrentValue));
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            } else {
                $this->batch_no->ViewValue = $this->batch_no->Lookup !== null && is_array($this->batch_no->lookupOptions()) && count($this->batch_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->batch_no->ViewValue !== null) { // Load from cache
                $this->batch_no->EditValue = array_values($this->batch_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->batch_no->CurrentValue, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->batch_no->EditValue = $arwrk;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // cs
            $this->cs->setupEditAttributes();
            $this->cs->EditValue = $this->cs->options(true);
            $this->cs->PlaceHolder = RemoveHtml($this->cs->caption());

            // weight
            $this->weight->setupEditAttributes();
            $this->weight->EditValue = $this->weight->CurrentValue;
            $this->weight->PlaceHolder = RemoveHtml($this->weight->caption());
            if (strval($this->weight->EditValue) != "" && is_numeric($this->weight->EditValue)) {
                $this->weight->EditValue = FormatNumber($this->weight->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // p_remarks
            $this->p_remarks->setupEditAttributes();
            if (!$this->p_remarks->Raw) {
                $this->p_remarks->CurrentValue = HtmlDecode($this->p_remarks->CurrentValue);
            }
            $this->p_remarks->EditValue = HtmlEncode($this->p_remarks->CurrentValue);
            $this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

            // roll_no
            $this->roll_no->setupEditAttributes();
            $this->roll_no->EditValue = $this->roll_no->CurrentValue;
            $this->roll_no->EditValue = FormatNumber($this->roll_no->EditValue, $this->roll_no->formatPattern());

            // qty
            $this->qty->setupEditAttributes();
            $this->qty->EditValue = $this->qty->CurrentValue;
            $this->qty->EditValue = FormatNumber($this->qty->EditValue, $this->qty->formatPattern());

            // pl_no
            $this->pl_no->setupEditAttributes();
            $this->pl_no->EditValue = $this->pl_no->CurrentValue;
            $this->pl_no->EditValue = FormatNumber($this->pl_no->EditValue, $this->pl_no->formatPattern());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->CurrentValue));
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->CurrentValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // pp_id
            $this->pp_id->setupEditAttributes();
            $this->pp_id->EditValue = $this->pp_id->CurrentValue;
            $curVal = strval($this->pp_id->CurrentValue);
            if ($curVal != "") {
                $this->pp_id->EditValue = $this->pp_id->lookupCacheOption($curVal);
                if ($this->pp_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pp_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pp_id->Lookup->renderViewRow($rswrk[0]);
                        $this->pp_id->EditValue = $this->pp_id->displayValue($arwrk);
                    } else {
                        $this->pp_id->EditValue = HtmlEncode(FormatNumber($this->pp_id->CurrentValue, $this->pp_id->formatPattern()));
                    }
                }
            } else {
                $this->pp_id->EditValue = null;
            }
            $this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

            // buyer_barcode
            $this->buyer_barcode->setupEditAttributes();
            $this->buyer_barcode->EditValue = $this->buyer_barcode->CurrentValue;

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // design_id
            if (!EmptyValue($this->design_id->CurrentValue)) {
                $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . (!empty($this->design_id->EditValue) && !is_array($this->design_id->EditValue) ? RemoveHtml($this->design_id->EditValue) : $this->design_id->CurrentValue); // Add prefix/suffix
                $this->design_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
                }
            } else {
                $this->design_id->HrefValue = "";
            }
            $this->design_id->TooltipValue = "";

            // size_cm
            $this->size_cm->HrefValue = "";
            $this->size_cm->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // buyer_ref
            if (!EmptyValue($this->buyer_ref->CurrentValue)) {
                $this->buyer_ref->HrefValue = $this->buyer_ref->getLinkPrefix() . $this->buyer_ref->CurrentValue; // Add prefix/suffix
                $this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
                }
            } else {
                $this->buyer_ref->HrefValue = "";
            }
            $this->buyer_ref->TooltipValue = "";

            // order_date
            $this->order_date->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // dispatch_week_p
            $this->dispatch_week_p->HrefValue = "";
            $this->dispatch_week_p->TooltipValue = "";

            // status
            $this->status->HrefValue = "";

            // buyers_id
            if (!EmptyValue($this->buyers_id->CurrentValue)) {
                $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
                $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
                }
            } else {
                $this->buyers_id->HrefValue = "";
            }
            $this->buyers_id->TooltipValue = "";

            // buyer_uid
            $this->buyer_uid->HrefValue = "";

            // buyer_loc
            $this->buyer_loc->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // sqm_u
            $this->sqm_u->HrefValue = "";

            // c_sqm
            $this->c_sqm->HrefValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";

            // current_works
            $this->current_works->HrefValue = "";

            // size_buyer
            $this->size_buyer->HrefValue = "";

            // w_cm
            $this->w_cm->HrefValue = "";

            // l_cm
            $this->l_cm->HrefValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";

            // po_price
            $this->po_price->HrefValue = "";
            $this->po_price->TooltipValue = "";

            // po_discount
            $this->po_discount->HrefValue = "";

            // po_currency
            $this->po_currency->HrefValue = "";
            $this->po_currency->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // completed
            $this->completed->HrefValue = "";

            // buyer_po
            $this->buyer_po->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";

            // sqm_a
            $this->sqm_a->HrefValue = "";

            // 2srm_a
            $this->_2srm_a->HrefValue = "";

            // 4srm_a
            $this->_4srm_a->HrefValue = "";

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }

            // cs
            $this->cs->HrefValue = "";

            // weight
            $this->weight->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // p_remarks
            $this->p_remarks->HrefValue = "";

            // roll_no
            $this->roll_no->HrefValue = "";
            $this->roll_no->TooltipValue = "";

            // qty
            $this->qty->HrefValue = "";
            $this->qty->TooltipValue = "";

            // pl_no
            $this->pl_no->HrefValue = "";
            $this->pl_no->TooltipValue = "";

            // category
            $this->category->HrefValue = "";

            // pp_id
            $this->pp_id->HrefValue = "";

            // buyer_barcode
            $this->buyer_barcode->HrefValue = "";
            $this->buyer_barcode->TooltipValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->po->Visible && $this->po->Required) {
                if (!$this->po->IsDetailKey && EmptyValue($this->po->FormValue)) {
                    $this->po->addErrorMessage(str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
                }
            }
            if ($this->design_id->Visible && $this->design_id->Required) {
                if (!$this->design_id->IsDetailKey && EmptyValue($this->design_id->FormValue)) {
                    $this->design_id->addErrorMessage(str_replace("%s", $this->design_id->caption(), $this->design_id->RequiredErrorMessage));
                }
            }
            if ($this->size_cm->Visible && $this->size_cm->Required) {
                if (!$this->size_cm->IsDetailKey && EmptyValue($this->size_cm->FormValue)) {
                    $this->size_cm->addErrorMessage(str_replace("%s", $this->size_cm->caption(), $this->size_cm->RequiredErrorMessage));
                }
            }
            if ($this->_barcode->Visible && $this->_barcode->Required) {
                if (!$this->_barcode->IsDetailKey && EmptyValue($this->_barcode->FormValue)) {
                    $this->_barcode->addErrorMessage(str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
                }
            }
            if ($this->buyer_ref->Visible && $this->buyer_ref->Required) {
                if (!$this->buyer_ref->IsDetailKey && EmptyValue($this->buyer_ref->FormValue)) {
                    $this->buyer_ref->addErrorMessage(str_replace("%s", $this->buyer_ref->caption(), $this->buyer_ref->RequiredErrorMessage));
                }
            }
            if ($this->order_date->Visible && $this->order_date->Required) {
                if (!$this->order_date->IsDetailKey && EmptyValue($this->order_date->FormValue)) {
                    $this->order_date->addErrorMessage(str_replace("%s", $this->order_date->caption(), $this->order_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->order_date->FormValue, $this->order_date->formatPattern())) {
                $this->order_date->addErrorMessage($this->order_date->getErrorMessage(false));
            }
            if ($this->despatch_date->Visible && $this->despatch_date->Required) {
                if (!$this->despatch_date->IsDetailKey && EmptyValue($this->despatch_date->FormValue)) {
                    $this->despatch_date->addErrorMessage(str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
                }
            }
            if ($this->despatch_week->Visible && $this->despatch_week->Required) {
                if (!$this->despatch_week->IsDetailKey && EmptyValue($this->despatch_week->FormValue)) {
                    $this->despatch_week->addErrorMessage(str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
                }
            }
            if ($this->dispatch_week_p->Visible && $this->dispatch_week_p->Required) {
                if (!$this->dispatch_week_p->IsDetailKey && EmptyValue($this->dispatch_week_p->FormValue)) {
                    $this->dispatch_week_p->addErrorMessage(str_replace("%s", $this->dispatch_week_p->caption(), $this->dispatch_week_p->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->buyers_id->Visible && $this->buyers_id->Required) {
                if (!$this->buyers_id->IsDetailKey && EmptyValue($this->buyers_id->FormValue)) {
                    $this->buyers_id->addErrorMessage(str_replace("%s", $this->buyers_id->caption(), $this->buyers_id->RequiredErrorMessage));
                }
            }
            if ($this->buyer_uid->Visible && $this->buyer_uid->Required) {
                if (!$this->buyer_uid->IsDetailKey && EmptyValue($this->buyer_uid->FormValue)) {
                    $this->buyer_uid->addErrorMessage(str_replace("%s", $this->buyer_uid->caption(), $this->buyer_uid->RequiredErrorMessage));
                }
            }
            if ($this->buyer_loc->Visible && $this->buyer_loc->Required) {
                if (!$this->buyer_loc->IsDetailKey && EmptyValue($this->buyer_loc->FormValue)) {
                    $this->buyer_loc->addErrorMessage(str_replace("%s", $this->buyer_loc->caption(), $this->buyer_loc->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if ($this->sqm->Visible && $this->sqm->Required) {
                if (!$this->sqm->IsDetailKey && EmptyValue($this->sqm->FormValue)) {
                    $this->sqm->addErrorMessage(str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
                }
            }
            if ($this->sqm_u->Visible && $this->sqm_u->Required) {
                if (!$this->sqm_u->IsDetailKey && EmptyValue($this->sqm_u->FormValue)) {
                    $this->sqm_u->addErrorMessage(str_replace("%s", $this->sqm_u->caption(), $this->sqm_u->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->sqm_u->FormValue)) {
                $this->sqm_u->addErrorMessage($this->sqm_u->getErrorMessage(false));
            }
            if ($this->c_sqm->Visible && $this->c_sqm->Required) {
                if (!$this->c_sqm->IsDetailKey && EmptyValue($this->c_sqm->FormValue)) {
                    $this->c_sqm->addErrorMessage(str_replace("%s", $this->c_sqm->caption(), $this->c_sqm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->c_sqm->FormValue)) {
                $this->c_sqm->addErrorMessage($this->c_sqm->getErrorMessage(false));
            }
            if ($this->weaving_works->Visible && $this->weaving_works->Required) {
                if (!$this->weaving_works->IsDetailKey && EmptyValue($this->weaving_works->FormValue)) {
                    $this->weaving_works->addErrorMessage(str_replace("%s", $this->weaving_works->caption(), $this->weaving_works->RequiredErrorMessage));
                }
            }
            if ($this->current_works->Visible && $this->current_works->Required) {
                if (!$this->current_works->IsDetailKey && EmptyValue($this->current_works->FormValue)) {
                    $this->current_works->addErrorMessage(str_replace("%s", $this->current_works->caption(), $this->current_works->RequiredErrorMessage));
                }
            }
            if ($this->size_buyer->Visible && $this->size_buyer->Required) {
                if (!$this->size_buyer->IsDetailKey && EmptyValue($this->size_buyer->FormValue)) {
                    $this->size_buyer->addErrorMessage(str_replace("%s", $this->size_buyer->caption(), $this->size_buyer->RequiredErrorMessage));
                }
            }
            if ($this->w_cm->Visible && $this->w_cm->Required) {
                if (!$this->w_cm->IsDetailKey && EmptyValue($this->w_cm->FormValue)) {
                    $this->w_cm->addErrorMessage(str_replace("%s", $this->w_cm->caption(), $this->w_cm->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->w_cm->FormValue)) {
                $this->w_cm->addErrorMessage($this->w_cm->getErrorMessage(false));
            }
            if ($this->l_cm->Visible && $this->l_cm->Required) {
                if (!$this->l_cm->IsDetailKey && EmptyValue($this->l_cm->FormValue)) {
                    $this->l_cm->addErrorMessage(str_replace("%s", $this->l_cm->caption(), $this->l_cm->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->l_cm->FormValue)) {
                $this->l_cm->addErrorMessage($this->l_cm->getErrorMessage(false));
            }
            if ($this->q_sku->Visible && $this->q_sku->Required) {
                if (!$this->q_sku->IsDetailKey && EmptyValue($this->q_sku->FormValue)) {
                    $this->q_sku->addErrorMessage(str_replace("%s", $this->q_sku->caption(), $this->q_sku->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->q_sku->FormValue)) {
                $this->q_sku->addErrorMessage($this->q_sku->getErrorMessage(false));
            }
            if ($this->po_price->Visible && $this->po_price->Required) {
                if (!$this->po_price->IsDetailKey && EmptyValue($this->po_price->FormValue)) {
                    $this->po_price->addErrorMessage(str_replace("%s", $this->po_price->caption(), $this->po_price->RequiredErrorMessage));
                }
            }
            if ($this->po_discount->Visible && $this->po_discount->Required) {
                if (!$this->po_discount->IsDetailKey && EmptyValue($this->po_discount->FormValue)) {
                    $this->po_discount->addErrorMessage(str_replace("%s", $this->po_discount->caption(), $this->po_discount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->po_discount->FormValue)) {
                $this->po_discount->addErrorMessage($this->po_discount->getErrorMessage(false));
            }
            if ($this->po_currency->Visible && $this->po_currency->Required) {
                if (!$this->po_currency->IsDetailKey && EmptyValue($this->po_currency->FormValue)) {
                    $this->po_currency->addErrorMessage(str_replace("%s", $this->po_currency->caption(), $this->po_currency->RequiredErrorMessage));
                }
            }
            if ($this->product_type->Visible && $this->product_type->Required) {
                if (!$this->product_type->IsDetailKey && EmptyValue($this->product_type->FormValue)) {
                    $this->product_type->addErrorMessage(str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
                }
            }
            if ($this->shape->Visible && $this->shape->Required) {
                if (!$this->shape->IsDetailKey && EmptyValue($this->shape->FormValue)) {
                    $this->shape->addErrorMessage(str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
                }
            }
            if ($this->production_plan->Visible && $this->production_plan->Required) {
                if (!$this->production_plan->IsDetailKey && EmptyValue($this->production_plan->FormValue)) {
                    $this->production_plan->addErrorMessage(str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->completed->Visible && $this->completed->Required) {
                if (!$this->completed->IsDetailKey && EmptyValue($this->completed->FormValue)) {
                    $this->completed->addErrorMessage(str_replace("%s", $this->completed->caption(), $this->completed->RequiredErrorMessage));
                }
            }
            if ($this->buyer_po->Visible && $this->buyer_po->Required) {
                if (!$this->buyer_po->IsDetailKey && EmptyValue($this->buyer_po->FormValue)) {
                    $this->buyer_po->addErrorMessage(str_replace("%s", $this->buyer_po->caption(), $this->buyer_po->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->jc_no->Visible && $this->jc_no->Required) {
                if (!$this->jc_no->IsDetailKey && EmptyValue($this->jc_no->FormValue)) {
                    $this->jc_no->addErrorMessage(str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jc_no->FormValue)) {
                $this->jc_no->addErrorMessage($this->jc_no->getErrorMessage(false));
            }
            if ($this->sqm_a->Visible && $this->sqm_a->Required) {
                if (!$this->sqm_a->IsDetailKey && EmptyValue($this->sqm_a->FormValue)) {
                    $this->sqm_a->addErrorMessage(str_replace("%s", $this->sqm_a->caption(), $this->sqm_a->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->sqm_a->FormValue)) {
                $this->sqm_a->addErrorMessage($this->sqm_a->getErrorMessage(false));
            }
            if ($this->_2srm_a->Visible && $this->_2srm_a->Required) {
                if (!$this->_2srm_a->IsDetailKey && EmptyValue($this->_2srm_a->FormValue)) {
                    $this->_2srm_a->addErrorMessage(str_replace("%s", $this->_2srm_a->caption(), $this->_2srm_a->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_2srm_a->FormValue)) {
                $this->_2srm_a->addErrorMessage($this->_2srm_a->getErrorMessage(false));
            }
            if ($this->_4srm_a->Visible && $this->_4srm_a->Required) {
                if (!$this->_4srm_a->IsDetailKey && EmptyValue($this->_4srm_a->FormValue)) {
                    $this->_4srm_a->addErrorMessage(str_replace("%s", $this->_4srm_a->caption(), $this->_4srm_a->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_4srm_a->FormValue)) {
                $this->_4srm_a->addErrorMessage($this->_4srm_a->getErrorMessage(false));
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if ($this->cs->Visible && $this->cs->Required) {
                if (!$this->cs->IsDetailKey && EmptyValue($this->cs->FormValue)) {
                    $this->cs->addErrorMessage(str_replace("%s", $this->cs->caption(), $this->cs->RequiredErrorMessage));
                }
            }
            if ($this->weight->Visible && $this->weight->Required) {
                if (!$this->weight->IsDetailKey && EmptyValue($this->weight->FormValue)) {
                    $this->weight->addErrorMessage(str_replace("%s", $this->weight->caption(), $this->weight->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->weight->FormValue)) {
                $this->weight->addErrorMessage($this->weight->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->p_remarks->Visible && $this->p_remarks->Required) {
                if (!$this->p_remarks->IsDetailKey && EmptyValue($this->p_remarks->FormValue)) {
                    $this->p_remarks->addErrorMessage(str_replace("%s", $this->p_remarks->caption(), $this->p_remarks->RequiredErrorMessage));
                }
            }
            if ($this->roll_no->Visible && $this->roll_no->Required) {
                if (!$this->roll_no->IsDetailKey && EmptyValue($this->roll_no->FormValue)) {
                    $this->roll_no->addErrorMessage(str_replace("%s", $this->roll_no->caption(), $this->roll_no->RequiredErrorMessage));
                }
            }
            if ($this->qty->Visible && $this->qty->Required) {
                if (!$this->qty->IsDetailKey && EmptyValue($this->qty->FormValue)) {
                    $this->qty->addErrorMessage(str_replace("%s", $this->qty->caption(), $this->qty->RequiredErrorMessage));
                }
            }
            if ($this->pl_no->Visible && $this->pl_no->Required) {
                if (!$this->pl_no->IsDetailKey && EmptyValue($this->pl_no->FormValue)) {
                    $this->pl_no->addErrorMessage(str_replace("%s", $this->pl_no->caption(), $this->pl_no->RequiredErrorMessage));
                }
            }
            if ($this->category->Visible && $this->category->Required) {
                if (!$this->category->IsDetailKey && EmptyValue($this->category->FormValue)) {
                    $this->category->addErrorMessage(str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
                }
            }
            if ($this->pp_id->Visible && $this->pp_id->Required) {
                if (!$this->pp_id->IsDetailKey && EmptyValue($this->pp_id->FormValue)) {
                    $this->pp_id->addErrorMessage(str_replace("%s", $this->pp_id->caption(), $this->pp_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->pp_id->FormValue)) {
                $this->pp_id->addErrorMessage($this->pp_id->getErrorMessage(false));
            }
            if ($this->buyer_barcode->Visible && $this->buyer_barcode->Required) {
                if (!$this->buyer_barcode->IsDetailKey && EmptyValue($this->buyer_barcode->FormValue)) {
                    $this->buyer_barcode->addErrorMessage(str_replace("%s", $this->buyer_barcode->caption(), $this->buyer_barcode->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (barcode)
        if ($this->_barcode->CurrentValue != "") {
            $filterChk = "(`barcode` = " . AdjustSql($this->_barcode->CurrentValue, $this->Dbid) . ")";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->_barcode->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->_barcode->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // order_date
        $this->order_date->setDbValueDef($rsnew, UnFormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern()), $this->order_date->ReadOnly);

        // despatch_week
        $this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, $this->despatch_week->ReadOnly);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly);

        // buyer_uid
        $this->buyer_uid->setDbValueDef($rsnew, $this->buyer_uid->CurrentValue, $this->buyer_uid->ReadOnly);

        // buyer_loc
        $this->buyer_loc->setDbValueDef($rsnew, $this->buyer_loc->CurrentValue, $this->buyer_loc->ReadOnly);

        // sqm_u
        $this->sqm_u->setDbValueDef($rsnew, $this->sqm_u->CurrentValue, $this->sqm_u->ReadOnly);

        // c_sqm
        $this->c_sqm->setDbValueDef($rsnew, $this->c_sqm->CurrentValue, $this->c_sqm->ReadOnly);

        // weaving_works
        $this->weaving_works->setDbValueDef($rsnew, $this->weaving_works->CurrentValue, $this->weaving_works->ReadOnly);

        // current_works
        $this->current_works->setDbValueDef($rsnew, $this->current_works->CurrentValue, $this->current_works->ReadOnly);

        // size_buyer
        $this->size_buyer->setDbValueDef($rsnew, $this->size_buyer->CurrentValue, $this->size_buyer->ReadOnly);

        // w_cm
        $this->w_cm->setDbValueDef($rsnew, $this->w_cm->CurrentValue, $this->w_cm->ReadOnly);

        // l_cm
        $this->l_cm->setDbValueDef($rsnew, $this->l_cm->CurrentValue, $this->l_cm->ReadOnly);

        // q_sku
        $this->q_sku->setDbValueDef($rsnew, $this->q_sku->CurrentValue, $this->q_sku->ReadOnly);

        // po_discount
        $this->po_discount->setDbValueDef($rsnew, $this->po_discount->CurrentValue, $this->po_discount->ReadOnly);

        // product_type
        $this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, $this->product_type->ReadOnly);

        // shape
        $this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, $this->shape->ReadOnly);

        // production_plan
        $this->production_plan->setDbValueDef($rsnew, $this->production_plan->CurrentValue, $this->production_plan->ReadOnly);

        // completed
        $this->completed->setDbValueDef($rsnew, $this->completed->CurrentValue, $this->completed->ReadOnly);

        // buyer_po
        $this->buyer_po->setDbValueDef($rsnew, $this->buyer_po->CurrentValue, $this->buyer_po->ReadOnly);

        // jc_no
        $this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, $this->jc_no->ReadOnly);

        // sqm_a
        $this->sqm_a->setDbValueDef($rsnew, $this->sqm_a->CurrentValue, $this->sqm_a->ReadOnly);

        // 2srm_a
        $this->_2srm_a->setDbValueDef($rsnew, $this->_2srm_a->CurrentValue, $this->_2srm_a->ReadOnly);

        // 4srm_a
        $this->_4srm_a->setDbValueDef($rsnew, $this->_4srm_a->CurrentValue, $this->_4srm_a->ReadOnly);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, $this->batch_no->ReadOnly);

        // cs
        $this->cs->setDbValueDef($rsnew, $this->cs->CurrentValue, $this->cs->ReadOnly);

        // weight
        $this->weight->setDbValueDef($rsnew, $this->weight->CurrentValue, $this->weight->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // p_remarks
        $this->p_remarks->setDbValueDef($rsnew, $this->p_remarks->CurrentValue, $this->p_remarks->ReadOnly);

        // category
        $this->category->setDbValueDef($rsnew, $this->category->CurrentValue, $this->category->ReadOnly);

        // pp_id
        $this->pp_id->setDbValueDef($rsnew, $this->pp_id->CurrentValue, $this->pp_id->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['order_date'])) { // order_date
            $this->order_date->CurrentValue = $row['order_date'];
        }
        if (isset($row['despatch_week'])) { // despatch_week
            $this->despatch_week->CurrentValue = $row['despatch_week'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['buyer_uid'])) { // buyer_uid
            $this->buyer_uid->CurrentValue = $row['buyer_uid'];
        }
        if (isset($row['buyer_loc'])) { // buyer_loc
            $this->buyer_loc->CurrentValue = $row['buyer_loc'];
        }
        if (isset($row['sqm_u'])) { // sqm_u
            $this->sqm_u->CurrentValue = $row['sqm_u'];
        }
        if (isset($row['c_sqm'])) { // c_sqm
            $this->c_sqm->CurrentValue = $row['c_sqm'];
        }
        if (isset($row['weaving_works'])) { // weaving_works
            $this->weaving_works->CurrentValue = $row['weaving_works'];
        }
        if (isset($row['current_works'])) { // current_works
            $this->current_works->CurrentValue = $row['current_works'];
        }
        if (isset($row['size_buyer'])) { // size_buyer
            $this->size_buyer->CurrentValue = $row['size_buyer'];
        }
        if (isset($row['w_cm'])) { // w_cm
            $this->w_cm->CurrentValue = $row['w_cm'];
        }
        if (isset($row['l_cm'])) { // l_cm
            $this->l_cm->CurrentValue = $row['l_cm'];
        }
        if (isset($row['q_sku'])) { // q_sku
            $this->q_sku->CurrentValue = $row['q_sku'];
        }
        if (isset($row['po_discount'])) { // po_discount
            $this->po_discount->CurrentValue = $row['po_discount'];
        }
        if (isset($row['product_type'])) { // product_type
            $this->product_type->CurrentValue = $row['product_type'];
        }
        if (isset($row['shape'])) { // shape
            $this->shape->CurrentValue = $row['shape'];
        }
        if (isset($row['production_plan'])) { // production_plan
            $this->production_plan->CurrentValue = $row['production_plan'];
        }
        if (isset($row['completed'])) { // completed
            $this->completed->CurrentValue = $row['completed'];
        }
        if (isset($row['buyer_po'])) { // buyer_po
            $this->buyer_po->CurrentValue = $row['buyer_po'];
        }
        if (isset($row['jc_no'])) { // jc_no
            $this->jc_no->CurrentValue = $row['jc_no'];
        }
        if (isset($row['sqm_a'])) { // sqm_a
            $this->sqm_a->CurrentValue = $row['sqm_a'];
        }
        if (isset($row['2srm_a'])) { // 2srm_a
            $this->_2srm_a->CurrentValue = $row['2srm_a'];
        }
        if (isset($row['4srm_a'])) { // 4srm_a
            $this->_4srm_a->CurrentValue = $row['4srm_a'];
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->CurrentValue = $row['batch_no'];
        }
        if (isset($row['cs'])) { // cs
            $this->cs->CurrentValue = $row['cs'];
        }
        if (isset($row['weight'])) { // weight
            $this->weight->CurrentValue = $row['weight'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['p_remarks'])) { // p_remarks
            $this->p_remarks->CurrentValue = $row['p_remarks'];
        }
        if (isset($row['category'])) { // category
            $this->category->CurrentValue = $row['category'];
        }
        if (isset($row['pp_id'])) { // pp_id
            $this->pp_id->CurrentValue = $row['pp_id'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bcodelist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_design_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_d":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_ref":
                    break;
                case "x_despatch_week":
                    break;
                case "x_dispatch_week_p":
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyers_id":
                    break;
                case "x_weaving_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_current_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_design":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_po_currency":
                    break;
                case "x_product_type":
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_payment_plan":
                    break;
                case "x_production_plan":
                    break;
                case "x_completed":
                    break;
                case "x_operator":
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cs":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_c":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pp_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    		PageFieldValidate($this,'bcode');
    		$this->_barcode->ReadOnly = True;
    			if (($this->status->CurrentValue == 201) || ($this->status->CurrentValue == 202) || ($this->status->CurrentValue == 203) || ($this->status->CurrentValue == 209) || ($this->status->CurrentValue == 11) || ($this->status->CurrentValue == 21) || ($this->status->CurrentValue == 31) || ($this->status->CurrentValue == 41) || ($this->status->CurrentValue == 211))
    			{
    			$this->status->ReadOnly = True;
    			}
    			if (($this->jc_no->CurrentValue > 0 ) && ($this->process_c->CurrentValue == NULL))
    			{
    			$this->jc_no->ReadOnly = False;
    			}
    			else
    			{
    			$this->jc_no->ReadOnly = True;
    			}
    			if ($this->shape->CurrentValue ==  4)
    			{
                $this->sqm_a->ReadOnly = false;
                $this->_2srm_a->ReadOnly = false;
                $this->_4srm_a->ReadOnly = false;
                }
                else
                {
                $this->sqm_a->ReadOnly = true;
                $this->_2srm_a->ReadOnly = true;
                $this->_4srm_a->ReadOnly = true;
                }
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
