<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BarcodeQueryUpdate extends BarcodeQuery
{
    use MessagesTrait;

    // Page ID
    public $PageID = "update";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BarcodeQueryUpdate";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "barcodequeryupdate";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->pl_no->Visible = false;
        $this->po->Visible = false;
        $this->_barcode->Visible = false;
        $this->buyers_id->setVisibility();
        $this->buyer_ref->setVisibility();
        $this->buyer_barcode->setVisibility();
        $this->design_id->setVisibility();
        $this->batch_no->setVisibility();
        $this->category->setVisibility();
        $this->size_cm->Visible = false;
        $this->size_buyer->Visible = false;
        $this->order_date->setVisibility();
        $this->despatch_week->setVisibility();
        $this->sqm->Visible = false;
        $this->buyer_po->setVisibility();
        $this->po_price->setVisibility();
        $this->po_discount->setVisibility();
        $this->po_currency->setVisibility();
        $this->weaving_works->setVisibility();
        $this->current_works->Visible = false;
        $this->consignee->setVisibility();
        $this->jc_no->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->completed->setVisibility();
        $this->remarks->setVisibility();
        $this->buyer_loc->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'barcode_query';
        $this->TableName = 'barcode_query';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-update-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (barcode_query)
        if (!isset($GLOBALS["barcode_query"]) || $GLOBALS["barcode_query"]::class == PROJECT_NAMESPACE . "barcode_query") {
            $GLOBALS["barcode_query"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'barcode_query');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "barcodequeryview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-update-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $RecKeys;
    public $Disabled;
    public $UpdateCount = 0;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->buyer_ref);
        $this->setupLookupOptions($this->design_id);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->po_currency);
        $this->setupLookupOptions($this->weaving_works);
        $this->setupLookupOptions($this->current_works);
        $this->setupLookupOptions($this->consignee);
        $this->setupLookupOptions($this->completed);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Try to load keys from list form
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        if (Post("action") !== null && Post("action") !== "") {
            // Get action
            $this->CurrentAction = Post("action");
            $this->loadFormValues(); // Get form values

            // Validate form
            if (!$this->validateForm()) {
                $this->CurrentAction = "show"; // Form error, reset action
                if (!$this->hasInvalidFields()) { // No fields selected
                    $this->setFailureMessage($Language->phrase("NoFieldSelected"));
                }
            }
        } else {
            $this->loadMultiUpdateValues(); // Load initial values to form
        }
        if (count($this->RecKeys) <= 0) {
            $this->terminate("barcodequerylist"); // No records selected, return to list
            return;
        }
        if ($this->isUpdate()) {
                if ($this->updateRows()) { // Update Records based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
                    }

                    // Do not return Json for UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                    }
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([
                        "success" => false,
                        "validation" => $this->getValidationErrors(),
                        "error" => $this->getFailureMessage()
                    ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->restoreFormValues(); // Restore form values
                }
        }

        // Render row
        if ($this->isConfirm()) { // Confirm page
            $this->RowType = RowType::VIEW; // Render view
            $this->Disabled = " disabled";
        } else {
            $this->RowType = RowType::EDIT; // Render edit
            $this->Disabled = "";
        }
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load initial values to form if field values are identical in all selected records
    protected function loadMultiUpdateValues()
    {
        $this->CurrentFilter = $this->getFilterFromRecordKeys();

        // Load result set
        if ($rs = $this->loadRecordset()) {
            $i = 1;
            while ($row = $rs->fetch()) {
                if ($i == 1) {
                    $this->buyers_id->setDbValue($row['buyers_id']);
                    $this->buyer_ref->setDbValue($row['buyer_ref']);
                    $this->buyer_barcode->setDbValue($row['buyer_barcode']);
                    $this->design_id->setDbValue($row['design_id']);
                    $this->batch_no->setDbValue($row['batch_no']);
                    $this->category->setDbValue($row['category']);
                    $this->order_date->setDbValue($row['order_date']);
                    $this->despatch_week->setDbValue($row['despatch_week']);
                    $this->buyer_po->setDbValue($row['buyer_po']);
                    $this->po_price->setDbValue($row['po_price']);
                    $this->po_discount->setDbValue($row['po_discount']);
                    $this->po_currency->setDbValue($row['po_currency']);
                    $this->weaving_works->setDbValue($row['weaving_works']);
                    $this->consignee->setDbValue($row['consignee']);
                    $this->jc_no->setDbValue($row['jc_no']);
                    $this->completed->setDbValue($row['completed']);
                    $this->remarks->setDbValue($row['remarks']);
                    $this->buyer_loc->setDbValue($row['buyer_loc']);
                } else {
                    if (!CompareValue($this->buyers_id->DbValue, $row['buyers_id'])) {
                        $this->buyers_id->CurrentValue = null;
                    }
                    if (!CompareValue($this->buyer_ref->DbValue, $row['buyer_ref'])) {
                        $this->buyer_ref->CurrentValue = null;
                    }
                    if (!CompareValue($this->buyer_barcode->DbValue, $row['buyer_barcode'])) {
                        $this->buyer_barcode->CurrentValue = null;
                    }
                    if (!CompareValue($this->design_id->DbValue, $row['design_id'])) {
                        $this->design_id->CurrentValue = null;
                    }
                    if (!CompareValue($this->batch_no->DbValue, $row['batch_no'])) {
                        $this->batch_no->CurrentValue = null;
                    }
                    if (!CompareValue($this->category->DbValue, $row['category'])) {
                        $this->category->CurrentValue = null;
                    }
                    if (!CompareValue($this->order_date->DbValue, $row['order_date'])) {
                        $this->order_date->CurrentValue = null;
                    }
                    if (!CompareValue($this->despatch_week->DbValue, $row['despatch_week'])) {
                        $this->despatch_week->CurrentValue = null;
                    }
                    if (!CompareValue($this->buyer_po->DbValue, $row['buyer_po'])) {
                        $this->buyer_po->CurrentValue = null;
                    }
                    if (!CompareValue($this->po_price->DbValue, $row['po_price'])) {
                        $this->po_price->CurrentValue = null;
                    }
                    if (!CompareValue($this->po_discount->DbValue, $row['po_discount'])) {
                        $this->po_discount->CurrentValue = null;
                    }
                    if (!CompareValue($this->po_currency->DbValue, $row['po_currency'])) {
                        $this->po_currency->CurrentValue = null;
                    }
                    if (!CompareValue($this->weaving_works->DbValue, $row['weaving_works'])) {
                        $this->weaving_works->CurrentValue = null;
                    }
                    if (!CompareValue($this->consignee->DbValue, $row['consignee'])) {
                        $this->consignee->CurrentValue = null;
                    }
                    if (!CompareValue($this->jc_no->DbValue, $row['jc_no'])) {
                        $this->jc_no->CurrentValue = null;
                    }
                    if (!CompareValue($this->completed->DbValue, $row['completed'])) {
                        $this->completed->CurrentValue = null;
                    }
                    if (!CompareValue($this->remarks->DbValue, $row['remarks'])) {
                        $this->remarks->CurrentValue = null;
                    }
                    if (!CompareValue($this->buyer_loc->DbValue, $row['buyer_loc'])) {
                        $this->buyer_loc->CurrentValue = null;
                    }
                }
                $i++;
            }
            $rs->free();
        }
    }

    // Set up key value
    protected function setupKeyValues($key)
    {
        $keyFld = $key;
        if (!is_numeric($keyFld)) {
            return false;
        }
        $this->id->OldValue = $keyFld;
        return true;
    }

    // Update all selected rows
    protected function updateRows()
    {
        global $Language;
        $conn = $this->getConnection();
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->AuditTrailOnEdit) {
            $this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin
        }

        // Get old records
        $this->CurrentFilter = $this->getFilterFromRecordKeys(false);
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAllAssociative($sql);

        // Update all rows
        $successKeys = [];
        $failKeys = [];
        foreach ($this->RecKeys as $reckey) {
            if ($this->setupKeyValues($reckey)) {
                $thisKey = $reckey;
                $this->SendEmail = false; // Do not send email on update success
                $this->UpdateCount += 1; // Update record count for records being updated
                $rowUpdated = $this->editRow(); // Update this row
            } else {
                $rowUpdated = false;
            }
            if (!$rowUpdated) {
                if ($this->UseTransaction) { // Update failed
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                $successKeys[] = $thisKey;
            }
        }

        // Check if any rows updated
        if (count($successKeys) > 0) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if update some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("UpdateSomeRecordsFailed")));
            }

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
            }
            return true;
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
            }
            return false;
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'buyers_id' first before field var 'x_buyers_id'
        $val = $CurrentForm->hasValue("buyers_id") ? $CurrentForm->getValue("buyers_id") : $CurrentForm->getValue("x_buyers_id");
        if (!$this->buyers_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyers_id->Visible = false; // Disable update for API request
            } else {
                $this->buyers_id->setFormValue($val);
            }
        }
        $this->buyers_id->MultiUpdate = $CurrentForm->getValue("u_buyers_id");

        // Check field name 'buyer_ref' first before field var 'x_buyer_ref'
        $val = $CurrentForm->hasValue("buyer_ref") ? $CurrentForm->getValue("buyer_ref") : $CurrentForm->getValue("x_buyer_ref");
        if (!$this->buyer_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_ref->Visible = false; // Disable update for API request
            } else {
                $this->buyer_ref->setFormValue($val);
            }
        }
        $this->buyer_ref->MultiUpdate = $CurrentForm->getValue("u_buyer_ref");

        // Check field name 'buyer_barcode' first before field var 'x_buyer_barcode'
        $val = $CurrentForm->hasValue("buyer_barcode") ? $CurrentForm->getValue("buyer_barcode") : $CurrentForm->getValue("x_buyer_barcode");
        if (!$this->buyer_barcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_barcode->Visible = false; // Disable update for API request
            } else {
                $this->buyer_barcode->setFormValue($val);
            }
        }
        $this->buyer_barcode->MultiUpdate = $CurrentForm->getValue("u_buyer_barcode");

        // Check field name 'design_id' first before field var 'x_design_id'
        $val = $CurrentForm->hasValue("design_id") ? $CurrentForm->getValue("design_id") : $CurrentForm->getValue("x_design_id");
        if (!$this->design_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->design_id->Visible = false; // Disable update for API request
            } else {
                $this->design_id->setFormValue($val);
            }
        }
        $this->design_id->MultiUpdate = $CurrentForm->getValue("u_design_id");

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val);
            }
        }
        $this->batch_no->MultiUpdate = $CurrentForm->getValue("u_batch_no");

        // Check field name 'category' first before field var 'x_category'
        $val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
        if (!$this->category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->category->Visible = false; // Disable update for API request
            } else {
                $this->category->setFormValue($val);
            }
        }
        $this->category->MultiUpdate = $CurrentForm->getValue("u_category");

        // Check field name 'order_date' first before field var 'x_order_date'
        $val = $CurrentForm->hasValue("order_date") ? $CurrentForm->getValue("order_date") : $CurrentForm->getValue("x_order_date");
        if (!$this->order_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->order_date->Visible = false; // Disable update for API request
            } else {
                $this->order_date->setFormValue($val, true, $validate);
            }
            $this->order_date->CurrentValue = UnFormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern());
        }
        $this->order_date->MultiUpdate = $CurrentForm->getValue("u_order_date");

        // Check field name 'despatch_week' first before field var 'x_despatch_week'
        $val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
        if (!$this->despatch_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_week->Visible = false; // Disable update for API request
            } else {
                $this->despatch_week->setFormValue($val);
            }
        }
        $this->despatch_week->MultiUpdate = $CurrentForm->getValue("u_despatch_week");

        // Check field name 'buyer_po' first before field var 'x_buyer_po'
        $val = $CurrentForm->hasValue("buyer_po") ? $CurrentForm->getValue("buyer_po") : $CurrentForm->getValue("x_buyer_po");
        if (!$this->buyer_po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_po->Visible = false; // Disable update for API request
            } else {
                $this->buyer_po->setFormValue($val);
            }
        }
        $this->buyer_po->MultiUpdate = $CurrentForm->getValue("u_buyer_po");

        // Check field name 'po_price' first before field var 'x_po_price'
        $val = $CurrentForm->hasValue("po_price") ? $CurrentForm->getValue("po_price") : $CurrentForm->getValue("x_po_price");
        if (!$this->po_price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_price->Visible = false; // Disable update for API request
            } else {
                $this->po_price->setFormValue($val);
            }
        }
        $this->po_price->MultiUpdate = $CurrentForm->getValue("u_po_price");

        // Check field name 'po_discount' first before field var 'x_po_discount'
        $val = $CurrentForm->hasValue("po_discount") ? $CurrentForm->getValue("po_discount") : $CurrentForm->getValue("x_po_discount");
        if (!$this->po_discount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_discount->Visible = false; // Disable update for API request
            } else {
                $this->po_discount->setFormValue($val, true, $validate);
            }
        }
        $this->po_discount->MultiUpdate = $CurrentForm->getValue("u_po_discount");

        // Check field name 'po_currency' first before field var 'x_po_currency'
        $val = $CurrentForm->hasValue("po_currency") ? $CurrentForm->getValue("po_currency") : $CurrentForm->getValue("x_po_currency");
        if (!$this->po_currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_currency->Visible = false; // Disable update for API request
            } else {
                $this->po_currency->setFormValue($val);
            }
        }
        $this->po_currency->MultiUpdate = $CurrentForm->getValue("u_po_currency");

        // Check field name 'weaving_works' first before field var 'x_weaving_works'
        $val = $CurrentForm->hasValue("weaving_works") ? $CurrentForm->getValue("weaving_works") : $CurrentForm->getValue("x_weaving_works");
        if (!$this->weaving_works->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weaving_works->Visible = false; // Disable update for API request
            } else {
                $this->weaving_works->setFormValue($val);
            }
        }
        $this->weaving_works->MultiUpdate = $CurrentForm->getValue("u_weaving_works");

        // Check field name 'consignee' first before field var 'x_consignee'
        $val = $CurrentForm->hasValue("consignee") ? $CurrentForm->getValue("consignee") : $CurrentForm->getValue("x_consignee");
        if (!$this->consignee->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->consignee->Visible = false; // Disable update for API request
            } else {
                $this->consignee->setFormValue($val);
            }
        }
        $this->consignee->MultiUpdate = $CurrentForm->getValue("u_consignee");

        // Check field name 'jc_no' first before field var 'x_jc_no'
        $val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
        if (!$this->jc_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_no->Visible = false; // Disable update for API request
            } else {
                $this->jc_no->setFormValue($val);
            }
        }
        $this->jc_no->MultiUpdate = $CurrentForm->getValue("u_jc_no");

        // Check field name 'completed' first before field var 'x_completed'
        $val = $CurrentForm->hasValue("completed") ? $CurrentForm->getValue("completed") : $CurrentForm->getValue("x_completed");
        if (!$this->completed->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->completed->Visible = false; // Disable update for API request
            } else {
                $this->completed->setFormValue($val);
            }
        }
        $this->completed->MultiUpdate = $CurrentForm->getValue("u_completed");

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }
        $this->remarks->MultiUpdate = $CurrentForm->getValue("u_remarks");

        // Check field name 'buyer_loc' first before field var 'x_buyer_loc'
        $val = $CurrentForm->hasValue("buyer_loc") ? $CurrentForm->getValue("buyer_loc") : $CurrentForm->getValue("x_buyer_loc");
        if (!$this->buyer_loc->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_loc->Visible = false; // Disable update for API request
            } else {
                $this->buyer_loc->setFormValue($val);
            }
        }
        $this->buyer_loc->MultiUpdate = $CurrentForm->getValue("u_buyer_loc");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->buyers_id->CurrentValue = $this->buyers_id->FormValue;
        $this->buyer_ref->CurrentValue = $this->buyer_ref->FormValue;
        $this->buyer_barcode->CurrentValue = $this->buyer_barcode->FormValue;
        $this->design_id->CurrentValue = $this->design_id->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->category->CurrentValue = $this->category->FormValue;
        $this->order_date->CurrentValue = $this->order_date->FormValue;
        $this->order_date->CurrentValue = UnFormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern());
        $this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
        $this->buyer_po->CurrentValue = $this->buyer_po->FormValue;
        $this->po_price->CurrentValue = $this->po_price->FormValue;
        $this->po_discount->CurrentValue = $this->po_discount->FormValue;
        $this->po_currency->CurrentValue = $this->po_currency->FormValue;
        $this->weaving_works->CurrentValue = $this->weaving_works->FormValue;
        $this->consignee->CurrentValue = $this->consignee->FormValue;
        $this->jc_no->CurrentValue = $this->jc_no->FormValue;
        $this->completed->CurrentValue = $this->completed->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->buyer_loc->CurrentValue = $this->buyer_loc->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->po->setDbValue($row['po']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        if (array_key_exists('EV__buyer_ref', $row)) {
            $this->buyer_ref->VirtualValue = $row['EV__buyer_ref']; // Set up virtual field value
        } else {
            $this->buyer_ref->VirtualValue = ""; // Clear value
        }
        $this->buyer_barcode->setDbValue($row['buyer_barcode']);
        $this->design_id->setDbValue($row['design_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->category->setDbValue($row['category']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->size_buyer->setDbValue($row['size_buyer']);
        $this->order_date->setDbValue($row['order_date']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->sqm->setDbValue($row['sqm']);
        $this->buyer_po->setDbValue($row['buyer_po']);
        $this->po_price->setDbValue($row['po_price']);
        $this->po_discount->setDbValue($row['po_discount']);
        $this->po_currency->setDbValue($row['po_currency']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->current_works->setDbValue($row['current_works']);
        $this->consignee->setDbValue($row['consignee']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->completed->setDbValue($row['completed']);
        $this->remarks->setDbValue($row['remarks']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['pl_no'] = $this->pl_no->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['buyers_id'] = $this->buyers_id->DefaultValue;
        $row['buyer_ref'] = $this->buyer_ref->DefaultValue;
        $row['buyer_barcode'] = $this->buyer_barcode->DefaultValue;
        $row['design_id'] = $this->design_id->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['size_cm'] = $this->size_cm->DefaultValue;
        $row['size_buyer'] = $this->size_buyer->DefaultValue;
        $row['order_date'] = $this->order_date->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['buyer_po'] = $this->buyer_po->DefaultValue;
        $row['po_price'] = $this->po_price->DefaultValue;
        $row['po_discount'] = $this->po_discount->DefaultValue;
        $row['po_currency'] = $this->po_currency->DefaultValue;
        $row['weaving_works'] = $this->weaving_works->DefaultValue;
        $row['current_works'] = $this->current_works->DefaultValue;
        $row['consignee'] = $this->consignee->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['completed'] = $this->completed->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['buyer_loc'] = $this->buyer_loc->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // pl_no
        $this->pl_no->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // buyers_id
        $this->buyers_id->RowCssClass = "row";

        // buyer_ref
        $this->buyer_ref->RowCssClass = "row";

        // buyer_barcode
        $this->buyer_barcode->RowCssClass = "row";

        // design_id
        $this->design_id->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // size_cm
        $this->size_cm->RowCssClass = "row";

        // size_buyer
        $this->size_buyer->RowCssClass = "row";

        // order_date
        $this->order_date->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // buyer_po
        $this->buyer_po->RowCssClass = "row";

        // po_price
        $this->po_price->RowCssClass = "row";

        // po_discount
        $this->po_discount->RowCssClass = "row";

        // po_currency
        $this->po_currency->RowCssClass = "row";

        // weaving_works
        $this->weaving_works->RowCssClass = "row";

        // current_works
        $this->current_works->RowCssClass = "row";

        // consignee
        $this->consignee->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // completed
        $this->completed->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // buyer_loc
        $this->buyer_loc->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // pl_no
            $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
            $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
            $this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, $this->_barcode->formatPattern());

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // buyer_ref
            if ($this->buyer_ref->VirtualValue != "") {
                $this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
            } else {
                $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                $curVal = strval($this->buyer_ref->CurrentValue);
                if ($curVal != "") {
                    $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
                    if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                            $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                        } else {
                            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                        }
                    }
                } else {
                    $this->buyer_ref->ViewValue = null;
                }
            }

            // buyer_barcode
            $this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;

            // design_id
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->ViewValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->ViewValue = null;
            }

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // size_cm
            $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

            // size_buyer
            $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

            // order_date
            $this->order_date->ViewValue = $this->order_date->CurrentValue;
            $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // buyer_po
            $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

            // po_price
            $this->po_price->ViewValue = $this->po_price->CurrentValue;

            // po_discount
            $this->po_discount->ViewValue = $this->po_discount->CurrentValue;
            $this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, $this->po_discount->formatPattern());

            // po_currency
            $curVal = strval($this->po_currency->CurrentValue);
            if ($curVal != "") {
                $this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
                if ($this->po_currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->po_currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->po_currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_currency->Lookup->renderViewRow($rswrk[0]);
                        $this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
                    } else {
                        $this->po_currency->ViewValue = FormatNumber($this->po_currency->CurrentValue, $this->po_currency->formatPattern());
                    }
                }
            } else {
                $this->po_currency->ViewValue = null;
            }

            // weaving_works
            $curVal = strval($this->weaving_works->CurrentValue);
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
                if ($this->weaving_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                        $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                    } else {
                        $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                    }
                }
            } else {
                $this->weaving_works->ViewValue = null;
            }

            // current_works
            $curVal = strval($this->current_works->CurrentValue);
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
                if ($this->current_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                        $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                    } else {
                        $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                    }
                }
            } else {
                $this->current_works->ViewValue = null;
            }

            // consignee
            $curVal = strval($this->consignee->CurrentValue);
            if ($curVal != "") {
                $this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
                if ($this->consignee->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignee->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignee->Lookup->renderViewRow($rswrk[0]);
                        $this->consignee->ViewValue = $this->consignee->displayValue($arwrk);
                    } else {
                        $this->consignee->ViewValue = FormatNumber($this->consignee->CurrentValue, $this->consignee->formatPattern());
                    }
                }
            } else {
                $this->consignee->ViewValue = null;
            }

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // completed
            if (strval($this->completed->CurrentValue) != "") {
                $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
            } else {
                $this->completed->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // buyer_loc
            $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

            // buyers_id
            if (!EmptyValue($this->buyers_id->CurrentValue)) {
                $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
                $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
                }
            } else {
                $this->buyers_id->HrefValue = "";
            }
            $this->buyers_id->TooltipValue = "";

            // buyer_ref
            $this->buyer_ref->HrefValue = "";
            $this->buyer_ref->TooltipValue = "";

            // buyer_barcode
            $this->buyer_barcode->HrefValue = "";
            $this->buyer_barcode->TooltipValue = "";

            // design_id
            if (!EmptyValue($this->design_id->CurrentValue)) {
                $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . $this->design_id->CurrentValue; // Add prefix/suffix
                $this->design_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
                }
            } else {
                $this->design_id->HrefValue = "";
            }
            $this->design_id->TooltipValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";
            $this->batch_no->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // order_date
            $this->order_date->HrefValue = "";
            $this->order_date->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // buyer_po
            $this->buyer_po->HrefValue = "";
            $this->buyer_po->TooltipValue = "";

            // po_price
            $this->po_price->HrefValue = "";
            $this->po_price->TooltipValue = "";

            // po_discount
            $this->po_discount->HrefValue = "";
            $this->po_discount->TooltipValue = "";

            // po_currency
            $this->po_currency->HrefValue = "";
            $this->po_currency->TooltipValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";
            $this->weaving_works->TooltipValue = "";

            // consignee
            $this->consignee->HrefValue = "";
            $this->consignee->TooltipValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";

            // completed
            $this->completed->HrefValue = "";
            $this->completed->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // buyer_loc
            $this->buyer_loc->HrefValue = "";
            $this->buyer_loc->TooltipValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // buyers_id
            $this->buyers_id->setupEditAttributes();
            $curVal = trim(strval($this->buyers_id->CurrentValue));
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            } else {
                $this->buyers_id->ViewValue = $this->buyers_id->Lookup !== null && is_array($this->buyers_id->lookupOptions()) && count($this->buyers_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyers_id->ViewValue !== null) { // Load from cache
                $this->buyers_id->EditValue = array_values($this->buyers_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyers_id->CurrentValue, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->buyers_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyers_id->EditValue = $arwrk;
            }
            $this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

            // buyer_ref
            $this->buyer_ref->setupEditAttributes();
            $this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
            $curVal = strval($this->buyer_ref->CurrentValue);
            if ($curVal != "") {
                $this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
                if ($this->buyer_ref->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
                    } else {
                        $this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->CurrentValue);
                    }
                }
            } else {
                $this->buyer_ref->EditValue = null;
            }
            $this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

            // buyer_barcode
            $this->buyer_barcode->setupEditAttributes();
            if (!$this->buyer_barcode->Raw) {
                $this->buyer_barcode->CurrentValue = HtmlDecode($this->buyer_barcode->CurrentValue);
            }
            $this->buyer_barcode->EditValue = HtmlEncode($this->buyer_barcode->CurrentValue);
            $this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());

            // design_id
            $curVal = trim(strval($this->design_id->CurrentValue));
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
            } else {
                $this->design_id->ViewValue = $this->design_id->Lookup !== null && is_array($this->design_id->lookupOptions()) && count($this->design_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->design_id->ViewValue !== null) { // Load from cache
                $this->design_id->EditValue = array_values($this->design_id->lookupOptions());
                if ($this->design_id->ViewValue == "") {
                    $this->design_id->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->design_id->CurrentValue, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                    $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                } else {
                    $this->design_id->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->design_id->EditValue = $arwrk;
            }
            $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

            // batch_no
            $this->batch_no->setupEditAttributes();
            $curVal = trim(strval($this->batch_no->CurrentValue));
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            } else {
                $this->batch_no->ViewValue = $this->batch_no->Lookup !== null && is_array($this->batch_no->lookupOptions()) && count($this->batch_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->batch_no->ViewValue !== null) { // Load from cache
                $this->batch_no->EditValue = array_values($this->batch_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->batch_no->CurrentValue, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->batch_no->EditValue = $arwrk;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->CurrentValue));
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->CurrentValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // order_date
            $this->order_date->setupEditAttributes();
            $this->order_date->EditValue = HtmlEncode(FormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern()));
            $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->CurrentValue));
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->ViewValue = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->ViewValue !== null) { // Load from cache
                $this->despatch_week->EditValue = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->CurrentValue, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // buyer_po
            $this->buyer_po->setupEditAttributes();
            if (!$this->buyer_po->Raw) {
                $this->buyer_po->CurrentValue = HtmlDecode($this->buyer_po->CurrentValue);
            }
            $this->buyer_po->EditValue = HtmlEncode($this->buyer_po->CurrentValue);
            $this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

            // po_price
            $this->po_price->setupEditAttributes();
            if (!$this->po_price->Raw) {
                $this->po_price->CurrentValue = HtmlDecode($this->po_price->CurrentValue);
            }
            $this->po_price->EditValue = HtmlEncode($this->po_price->CurrentValue);
            $this->po_price->PlaceHolder = RemoveHtml($this->po_price->caption());

            // po_discount
            $this->po_discount->setupEditAttributes();
            $this->po_discount->EditValue = $this->po_discount->CurrentValue;
            $this->po_discount->PlaceHolder = RemoveHtml($this->po_discount->caption());
            if (strval($this->po_discount->EditValue) != "" && is_numeric($this->po_discount->EditValue)) {
                $this->po_discount->EditValue = FormatNumber($this->po_discount->EditValue, null);
            }

            // po_currency
            $this->po_currency->setupEditAttributes();
            $curVal = trim(strval($this->po_currency->CurrentValue));
            if ($curVal != "") {
                $this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
            } else {
                $this->po_currency->ViewValue = $this->po_currency->Lookup !== null && is_array($this->po_currency->lookupOptions()) && count($this->po_currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->po_currency->ViewValue !== null) { // Load from cache
                $this->po_currency->EditValue = array_values($this->po_currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->po_currency->CurrentValue, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->po_currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->po_currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->po_currency->EditValue = $arwrk;
            }
            $this->po_currency->PlaceHolder = RemoveHtml($this->po_currency->caption());

            // weaving_works
            $this->weaving_works->setupEditAttributes();
            $curVal = trim(strval($this->weaving_works->CurrentValue));
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
            } else {
                $this->weaving_works->ViewValue = $this->weaving_works->Lookup !== null && is_array($this->weaving_works->lookupOptions()) && count($this->weaving_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->weaving_works->ViewValue !== null) { // Load from cache
                $this->weaving_works->EditValue = array_values($this->weaving_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->weaving_works->CurrentValue, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->weaving_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->weaving_works->EditValue = $arwrk;
            }
            $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

            // consignee
            $this->consignee->setupEditAttributes();
            $curVal = trim(strval($this->consignee->CurrentValue));
            if ($curVal != "") {
                $this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
            } else {
                $this->consignee->ViewValue = $this->consignee->Lookup !== null && is_array($this->consignee->lookupOptions()) && count($this->consignee->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->consignee->ViewValue !== null) { // Load from cache
                $this->consignee->EditValue = array_values($this->consignee->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->consignee->CurrentValue, $this->consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->consignee->getSelectFilter($this); // PHP
                $sqlWrk = $this->consignee->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->consignee->EditValue = $arwrk;
            }
            $this->consignee->PlaceHolder = RemoveHtml($this->consignee->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            $this->jc_no->EditValue = $this->jc_no->CurrentValue;
            $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, $this->jc_no->formatPattern());

            // completed
            $this->completed->setupEditAttributes();
            $this->completed->EditValue = $this->completed->options(true);
            $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // buyer_loc
            $this->buyer_loc->setupEditAttributes();
            if (!$this->buyer_loc->Raw) {
                $this->buyer_loc->CurrentValue = HtmlDecode($this->buyer_loc->CurrentValue);
            }
            $this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->CurrentValue);
            $this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

            // Edit refer script

            // buyers_id
            if (!EmptyValue($this->buyers_id->CurrentValue)) {
                $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
                $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
                }
            } else {
                $this->buyers_id->HrefValue = "";
            }

            // buyer_ref
            $this->buyer_ref->HrefValue = "";

            // buyer_barcode
            $this->buyer_barcode->HrefValue = "";

            // design_id
            if (!EmptyValue($this->design_id->CurrentValue)) {
                $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . $this->design_id->CurrentValue; // Add prefix/suffix
                $this->design_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
                }
            } else {
                $this->design_id->HrefValue = "";
            }

            // batch_no
            $this->batch_no->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // order_date
            $this->order_date->HrefValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // buyer_po
            $this->buyer_po->HrefValue = "";

            // po_price
            $this->po_price->HrefValue = "";

            // po_discount
            $this->po_discount->HrefValue = "";

            // po_currency
            $this->po_currency->HrefValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";

            // consignee
            $this->consignee->HrefValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";

            // completed
            $this->completed->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // buyer_loc
            $this->buyer_loc->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;
        $updateCnt = 0;
        if ($this->buyers_id->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->buyer_ref->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->buyer_barcode->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->design_id->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->batch_no->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->category->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->order_date->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->despatch_week->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->buyer_po->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->po_price->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->po_discount->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->po_currency->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->weaving_works->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->consignee->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->jc_no->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->completed->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->remarks->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->buyer_loc->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($updateCnt == 0) {
            return false;
        }

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->buyers_id->Visible && $this->buyers_id->Required) {
                if ($this->buyers_id->MultiUpdate != "" && !$this->buyers_id->IsDetailKey && EmptyValue($this->buyers_id->FormValue)) {
                    $this->buyers_id->addErrorMessage(str_replace("%s", $this->buyers_id->caption(), $this->buyers_id->RequiredErrorMessage));
                }
            }
            if ($this->buyer_ref->Visible && $this->buyer_ref->Required) {
                if ($this->buyer_ref->MultiUpdate != "" && !$this->buyer_ref->IsDetailKey && EmptyValue($this->buyer_ref->FormValue)) {
                    $this->buyer_ref->addErrorMessage(str_replace("%s", $this->buyer_ref->caption(), $this->buyer_ref->RequiredErrorMessage));
                }
            }
            if ($this->buyer_barcode->Visible && $this->buyer_barcode->Required) {
                if ($this->buyer_barcode->MultiUpdate != "" && !$this->buyer_barcode->IsDetailKey && EmptyValue($this->buyer_barcode->FormValue)) {
                    $this->buyer_barcode->addErrorMessage(str_replace("%s", $this->buyer_barcode->caption(), $this->buyer_barcode->RequiredErrorMessage));
                }
            }
            if ($this->design_id->Visible && $this->design_id->Required) {
                if ($this->design_id->MultiUpdate != "" && !$this->design_id->IsDetailKey && EmptyValue($this->design_id->FormValue)) {
                    $this->design_id->addErrorMessage(str_replace("%s", $this->design_id->caption(), $this->design_id->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if ($this->batch_no->MultiUpdate != "" && !$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if ($this->category->Visible && $this->category->Required) {
                if ($this->category->MultiUpdate != "" && !$this->category->IsDetailKey && EmptyValue($this->category->FormValue)) {
                    $this->category->addErrorMessage(str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
                }
            }
            if ($this->order_date->Visible && $this->order_date->Required) {
                if ($this->order_date->MultiUpdate != "" && !$this->order_date->IsDetailKey && EmptyValue($this->order_date->FormValue)) {
                    $this->order_date->addErrorMessage(str_replace("%s", $this->order_date->caption(), $this->order_date->RequiredErrorMessage));
                }
            }
            if ($this->order_date->MultiUpdate != "") {
                if (!CheckDate($this->order_date->FormValue, $this->order_date->formatPattern())) {
                    $this->order_date->addErrorMessage($this->order_date->getErrorMessage(false));
                }
            }
            if ($this->despatch_week->Visible && $this->despatch_week->Required) {
                if ($this->despatch_week->MultiUpdate != "" && !$this->despatch_week->IsDetailKey && EmptyValue($this->despatch_week->FormValue)) {
                    $this->despatch_week->addErrorMessage(str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
                }
            }
            if ($this->buyer_po->Visible && $this->buyer_po->Required) {
                if ($this->buyer_po->MultiUpdate != "" && !$this->buyer_po->IsDetailKey && EmptyValue($this->buyer_po->FormValue)) {
                    $this->buyer_po->addErrorMessage(str_replace("%s", $this->buyer_po->caption(), $this->buyer_po->RequiredErrorMessage));
                }
            }
            if ($this->po_price->Visible && $this->po_price->Required) {
                if ($this->po_price->MultiUpdate != "" && !$this->po_price->IsDetailKey && EmptyValue($this->po_price->FormValue)) {
                    $this->po_price->addErrorMessage(str_replace("%s", $this->po_price->caption(), $this->po_price->RequiredErrorMessage));
                }
            }
            if ($this->po_discount->Visible && $this->po_discount->Required) {
                if ($this->po_discount->MultiUpdate != "" && !$this->po_discount->IsDetailKey && EmptyValue($this->po_discount->FormValue)) {
                    $this->po_discount->addErrorMessage(str_replace("%s", $this->po_discount->caption(), $this->po_discount->RequiredErrorMessage));
                }
            }
            if ($this->po_discount->MultiUpdate != "") {
                if (!CheckNumber($this->po_discount->FormValue)) {
                    $this->po_discount->addErrorMessage($this->po_discount->getErrorMessage(false));
                }
            }
            if ($this->po_currency->Visible && $this->po_currency->Required) {
                if ($this->po_currency->MultiUpdate != "" && !$this->po_currency->IsDetailKey && EmptyValue($this->po_currency->FormValue)) {
                    $this->po_currency->addErrorMessage(str_replace("%s", $this->po_currency->caption(), $this->po_currency->RequiredErrorMessage));
                }
            }
            if ($this->weaving_works->Visible && $this->weaving_works->Required) {
                if ($this->weaving_works->MultiUpdate != "" && !$this->weaving_works->IsDetailKey && EmptyValue($this->weaving_works->FormValue)) {
                    $this->weaving_works->addErrorMessage(str_replace("%s", $this->weaving_works->caption(), $this->weaving_works->RequiredErrorMessage));
                }
            }
            if ($this->consignee->Visible && $this->consignee->Required) {
                if ($this->consignee->MultiUpdate != "" && !$this->consignee->IsDetailKey && EmptyValue($this->consignee->FormValue)) {
                    $this->consignee->addErrorMessage(str_replace("%s", $this->consignee->caption(), $this->consignee->RequiredErrorMessage));
                }
            }
            if ($this->jc_no->Visible && $this->jc_no->Required) {
                if ($this->jc_no->MultiUpdate != "" && !$this->jc_no->IsDetailKey && EmptyValue($this->jc_no->FormValue)) {
                    $this->jc_no->addErrorMessage(str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
                }
            }
            if ($this->completed->Visible && $this->completed->Required) {
                if ($this->completed->MultiUpdate != "" && !$this->completed->IsDetailKey && EmptyValue($this->completed->FormValue)) {
                    $this->completed->addErrorMessage(str_replace("%s", $this->completed->caption(), $this->completed->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if ($this->remarks->MultiUpdate != "" && !$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->buyer_loc->Visible && $this->buyer_loc->Required) {
                if ($this->buyer_loc->MultiUpdate != "" && !$this->buyer_loc->IsDetailKey && EmptyValue($this->buyer_loc->FormValue)) {
                    $this->buyer_loc->addErrorMessage(str_replace("%s", $this->buyer_loc->caption(), $this->buyer_loc->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // buyers_id
        $this->buyers_id->setDbValueDef($rsnew, $this->buyers_id->CurrentValue, $this->buyers_id->ReadOnly || $this->buyers_id->MultiUpdate != "1");

        // buyer_ref
        $this->buyer_ref->setDbValueDef($rsnew, $this->buyer_ref->CurrentValue, $this->buyer_ref->ReadOnly || $this->buyer_ref->MultiUpdate != "1");

        // buyer_barcode
        $this->buyer_barcode->setDbValueDef($rsnew, $this->buyer_barcode->CurrentValue, $this->buyer_barcode->ReadOnly || $this->buyer_barcode->MultiUpdate != "1");

        // design_id
        $this->design_id->setDbValueDef($rsnew, $this->design_id->CurrentValue, $this->design_id->ReadOnly || $this->design_id->MultiUpdate != "1");

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, $this->batch_no->ReadOnly || $this->batch_no->MultiUpdate != "1");

        // category
        $this->category->setDbValueDef($rsnew, $this->category->CurrentValue, $this->category->ReadOnly || $this->category->MultiUpdate != "1");

        // order_date
        $this->order_date->setDbValueDef($rsnew, UnFormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern()), $this->order_date->ReadOnly || $this->order_date->MultiUpdate != "1");

        // despatch_week
        $this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, $this->despatch_week->ReadOnly || $this->despatch_week->MultiUpdate != "1");

        // buyer_po
        $this->buyer_po->setDbValueDef($rsnew, $this->buyer_po->CurrentValue, $this->buyer_po->ReadOnly || $this->buyer_po->MultiUpdate != "1");

        // po_price
        $this->po_price->setDbValueDef($rsnew, $this->po_price->CurrentValue, $this->po_price->ReadOnly || $this->po_price->MultiUpdate != "1");

        // po_discount
        $this->po_discount->setDbValueDef($rsnew, $this->po_discount->CurrentValue, $this->po_discount->ReadOnly || $this->po_discount->MultiUpdate != "1");

        // po_currency
        $this->po_currency->setDbValueDef($rsnew, $this->po_currency->CurrentValue, $this->po_currency->ReadOnly || $this->po_currency->MultiUpdate != "1");

        // weaving_works
        $this->weaving_works->setDbValueDef($rsnew, $this->weaving_works->CurrentValue, $this->weaving_works->ReadOnly || $this->weaving_works->MultiUpdate != "1");

        // consignee
        $this->consignee->setDbValueDef($rsnew, $this->consignee->CurrentValue, $this->consignee->ReadOnly || $this->consignee->MultiUpdate != "1");

        // completed
        $this->completed->setDbValueDef($rsnew, $this->completed->CurrentValue, $this->completed->ReadOnly || $this->completed->MultiUpdate != "1");

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly || $this->remarks->MultiUpdate != "1");

        // buyer_loc
        $this->buyer_loc->setDbValueDef($rsnew, $this->buyer_loc->CurrentValue, $this->buyer_loc->ReadOnly || $this->buyer_loc->MultiUpdate != "1");
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['buyers_id'])) { // buyers_id
            $this->buyers_id->CurrentValue = $row['buyers_id'];
        }
        if (isset($row['buyer_ref'])) { // buyer_ref
            $this->buyer_ref->CurrentValue = $row['buyer_ref'];
        }
        if (isset($row['buyer_barcode'])) { // buyer_barcode
            $this->buyer_barcode->CurrentValue = $row['buyer_barcode'];
        }
        if (isset($row['design_id'])) { // design_id
            $this->design_id->CurrentValue = $row['design_id'];
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->CurrentValue = $row['batch_no'];
        }
        if (isset($row['category'])) { // category
            $this->category->CurrentValue = $row['category'];
        }
        if (isset($row['order_date'])) { // order_date
            $this->order_date->CurrentValue = $row['order_date'];
        }
        if (isset($row['despatch_week'])) { // despatch_week
            $this->despatch_week->CurrentValue = $row['despatch_week'];
        }
        if (isset($row['buyer_po'])) { // buyer_po
            $this->buyer_po->CurrentValue = $row['buyer_po'];
        }
        if (isset($row['po_price'])) { // po_price
            $this->po_price->CurrentValue = $row['po_price'];
        }
        if (isset($row['po_discount'])) { // po_discount
            $this->po_discount->CurrentValue = $row['po_discount'];
        }
        if (isset($row['po_currency'])) { // po_currency
            $this->po_currency->CurrentValue = $row['po_currency'];
        }
        if (isset($row['weaving_works'])) { // weaving_works
            $this->weaving_works->CurrentValue = $row['weaving_works'];
        }
        if (isset($row['consignee'])) { // consignee
            $this->consignee->CurrentValue = $row['consignee'];
        }
        if (isset($row['completed'])) { // completed
            $this->completed->CurrentValue = $row['completed'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['buyer_loc'])) { // buyer_loc
            $this->buyer_loc->CurrentValue = $row['buyer_loc'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("barcodequerylist"), "", $this->TableVar, true);
        $pageId = "update";
        $Breadcrumb->add("update", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_buyers_id":
                    break;
                case "x_buyer_ref":
                    break;
                case "x_design_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    break;
                case "x_despatch_week":
                    break;
                case "x_po_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_weaving_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_current_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_consignee":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_completed":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'barcode_query');
    	if (($this->jc_no->CurrentValue == 0 ))
    	{
    		$this->weaving_works->ReadOnly = False;
    	}
    	else
    	{
    		$this->weaving_works->ReadOnly = True;
    	}	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
