<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for barcode_query
 */
class BarcodeQuery extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = true;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $pl_no;
    public $po;
    public $_barcode;
    public $buyers_id;
    public $buyer_ref;
    public $buyer_barcode;
    public $design_id;
    public $batch_no;
    public $category;
    public $size_cm;
    public $size_buyer;
    public $order_date;
    public $despatch_week;
    public $sqm;
    public $buyer_po;
    public $po_price;
    public $po_discount;
    public $po_currency;
    public $weaving_works;
    public $current_works;
    public $consignee;
    public $jc_no;
    public $operator;
    public $datetime;
    public $completed;
    public $remarks;
    public $buyer_loc;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "barcode_query";
        $this->TableName = 'barcode_query';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "barcode_query";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // pl_no
        $this->pl_no = new DbField(
            $this, // Table
            'x_pl_no', // Variable name
            'pl_no', // Name
            '`pl_no`', // Expression
            '`pl_no`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pl_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pl_no->addMethod("getDefault", fn() => 0.00);
        $this->pl_no->InputTextType = "text";
        $this->pl_no->Raw = true;
        $this->pl_no->Nullable = false; // NOT NULL field
        $this->pl_no->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pl_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['pl_no'] = &$this->pl_no;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // barcode
        $this->_barcode = new DbField(
            $this, // Table
            'x__barcode', // Variable name
            'barcode', // Name
            '`barcode`', // Expression
            '`barcode`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_barcode->addMethod("getDefault", fn() => 0);
        $this->_barcode->InputTextType = "text";
        $this->_barcode->Raw = true;
        $this->_barcode->Nullable = false; // NOT NULL field
        $this->_barcode->Required = true; // Required field
        $this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['barcode'] = &$this->_barcode;

        // buyers_id
        $this->buyers_id = new DbField(
            $this, // Table
            'x_buyers_id', // Variable name
            'buyers_id', // Name
            '`buyers_id`', // Expression
            '`buyers_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyers_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyers_id->addMethod("getLinkPrefix", fn() => "packinglistnolist?x_buyers_id=");
        $this->buyers_id->InputTextType = "text";
        $this->buyers_id->Raw = true;
        $this->buyers_id->Required = true; // Required field
        $this->buyers_id->setSelectMultiple(false); // Select one
        $this->buyers_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyers_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyers_id->Lookup = new Lookup($this->buyers_id, 'buyer_seller_view', false, 'id', ["name","","",""], '', '', [], ["x_buyer_ref"], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyers_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyers_id'] = &$this->buyers_id;

        // buyer_ref
        $this->buyer_ref = new DbField(
            $this, // Table
            'x_buyer_ref', // Variable name
            'buyer_ref', // Name
            '`buyer_ref`', // Expression
            '`buyer_ref`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__buyer_ref', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_ref->InputTextType = "text";
        $this->buyer_ref->Raw = true;
        $this->buyer_ref->Lookup = new Lookup($this->buyer_ref, 'partner_product_ref', false, 'id', ["partner_ref","barcode","partner_code",""], '', '', ["x_buyers_id"], [], ["partner"], ["x_partner"], ["barcode","rid","batch_no"], ["x_buyer_barcode","x_design_id","x_batch_no"], false, '`partner_ref` ASC', '', "CONCAT(COALESCE(`partner_ref`, ''),'" . ValueSeparator(1, $this->buyer_ref) . "',COALESCE(`barcode`,''),'" . ValueSeparator(2, $this->buyer_ref) . "',COALESCE(`partner_code`,''))");
        $this->buyer_ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_ref'] = &$this->buyer_ref;

        // buyer_barcode
        $this->buyer_barcode = new DbField(
            $this, // Table
            'x_buyer_barcode', // Variable name
            'buyer_barcode', // Name
            '`buyer_barcode`', // Expression
            '`buyer_barcode`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_barcode->InputTextType = "text";
        $this->buyer_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_barcode'] = &$this->buyer_barcode;

        // design_id
        $this->design_id = new DbField(
            $this, // Table
            'x_design_id', // Variable name
            'design_id', // Name
            '`design_id`', // Expression
            '`design_id`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->design_id->addMethod("getSelectFilter", fn() => "`product_type`  != 9 and `status` = 1 and `grp` = 3");
        $this->design_id->addMethod("getLinkPrefix", fn() => "packinglistnolist?x_design_id=");
        $this->design_id->InputTextType = "text";
        $this->design_id->Required = true; // Required field
        $this->design_id->setSelectMultiple(false); // Select one
        $this->design_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->design_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->design_id->Lookup = new Lookup($this->design_id, 'ref', false, 'id', ["product_code","","",""], '', '', [], ["x_batch_no"], [], [], ["category"], ["x_category"], true, '`product_code` ASC', '', "`product_code`");
        $this->design_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->design_id->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['design_id'] = &$this->design_id;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->batch_no->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Raw = true;
        $this->batch_no->Required = true; // Required field
        $this->batch_no->setSelectMultiple(false); // Select one
        $this->batch_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->batch_no->Lookup = new Lookup($this->batch_no, 'batch_no', true, 'id', ["batch_no","","",""], '', '', ["x_design_id"], [], ["rid"], ["x_rid"], [], [], true, '`batch_no` ASC', '', "`batch_no`");
        $this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->batch_no->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // category
        $this->category = new DbField(
            $this, // Table
            'x_category', // Variable name
            'category', // Name
            '`category`', // Expression
            '`category`', // Basic search expression
            200, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->category->InputTextType = "text";
        $this->category->Nullable = false; // NOT NULL field
        $this->category->Required = true; // Required field
        $this->category->setSelectMultiple(false); // Select one
        $this->category->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->category->Lookup = new Lookup($this->category, 'product_category', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], true, '`item` ASC', '', "`item`");
        $this->category->SearchOperators = ["=", "<>"];
        $this->Fields['category'] = &$this->category;

        // size_cm
        $this->size_cm = new DbField(
            $this, // Table
            'x_size_cm', // Variable name
            'size_cm', // Name
            '`size_cm`', // Expression
            '`size_cm`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_cm->InputTextType = "text";
        $this->size_cm->Nullable = false; // NOT NULL field
        $this->size_cm->Required = true; // Required field
        $this->size_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['size_cm'] = &$this->size_cm;

        // size_buyer
        $this->size_buyer = new DbField(
            $this, // Table
            'x_size_buyer', // Variable name
            'size_buyer', // Name
            '`size_buyer`', // Expression
            '`size_buyer`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_buyer`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_buyer->InputTextType = "text";
        $this->size_buyer->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['size_buyer'] = &$this->size_buyer;

        // order_date
        $this->order_date = new DbField(
            $this, // Table
            'x_order_date', // Variable name
            'order_date', // Name
            '`order_date`', // Expression
            CastDateFieldForLike("`order_date`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`order_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->order_date->InputTextType = "text";
        $this->order_date->Raw = true;
        $this->order_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->order_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['order_date'] = &$this->order_date;

        // despatch_week
        $this->despatch_week = new DbField(
            $this, // Table
            'x_despatch_week', // Variable name
            'despatch_week', // Name
            '`despatch_week`', // Expression
            '`despatch_week`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`despatch_week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->despatch_week->InputTextType = "text";
        $this->despatch_week->Raw = true;
        $this->despatch_week->setSelectMultiple(false); // Select one
        $this->despatch_week->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->despatch_week->Lookup = new Lookup($this->despatch_week, 'not_week', false, 'id', ["wid","wed","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`wid`, ''),'" . ValueSeparator(1, $this->despatch_week) . "',COALESCE(`wed`,''))");
        $this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->despatch_week->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['despatch_week'] = &$this->despatch_week;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->Nullable = false; // NOT NULL field
        $this->sqm->Required = true; // Required field
        $this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['sqm'] = &$this->sqm;

        // buyer_po
        $this->buyer_po = new DbField(
            $this, // Table
            'x_buyer_po', // Variable name
            'buyer_po', // Name
            '`buyer_po`', // Expression
            '`buyer_po`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_po->InputTextType = "text";
        $this->buyer_po->Required = true; // Required field
        $this->buyer_po->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_po'] = &$this->buyer_po;

        // po_price
        $this->po_price = new DbField(
            $this, // Table
            'x_po_price', // Variable name
            'po_price', // Name
            '`po_price`', // Expression
            '`po_price`', // Basic search expression
            200, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_price`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_price->InputTextType = "text";
        $this->po_price->Required = true; // Required field
        $this->po_price->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_price'] = &$this->po_price;

        // po_discount
        $this->po_discount = new DbField(
            $this, // Table
            'x_po_discount', // Variable name
            'po_discount', // Name
            '`po_discount`', // Expression
            '`po_discount`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_discount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_discount->addMethod("getDefault", fn() => 0.00);
        $this->po_discount->InputTextType = "text";
        $this->po_discount->Raw = true;
        $this->po_discount->Nullable = false; // NOT NULL field
        $this->po_discount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->po_discount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_discount'] = &$this->po_discount;

        // po_currency
        $this->po_currency = new DbField(
            $this, // Table
            'x_po_currency', // Variable name
            'po_currency', // Name
            '`po_currency`', // Expression
            '`po_currency`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_currency`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->po_currency->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->po_currency->InputTextType = "text";
        $this->po_currency->Raw = true;
        $this->po_currency->Required = true; // Required field
        $this->po_currency->setSelectMultiple(false); // Select one
        $this->po_currency->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->po_currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->po_currency->Lookup = new Lookup($this->po_currency, 'currency', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`code`");
        $this->po_currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_currency->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_currency'] = &$this->po_currency;

        // weaving_works
        $this->weaving_works = new DbField(
            $this, // Table
            'x_weaving_works', // Variable name
            'weaving_works', // Name
            '`weaving_works`', // Expression
            '`weaving_works`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weaving_works`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->weaving_works->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->weaving_works->addMethod("getDefault", fn() => 0);
        $this->weaving_works->InputTextType = "text";
        $this->weaving_works->Raw = true;
        $this->weaving_works->Nullable = false; // NOT NULL field
        $this->weaving_works->Required = true; // Required field
        $this->weaving_works->setSelectMultiple(false); // Select one
        $this->weaving_works->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->weaving_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->weaving_works->Lookup = new Lookup($this->weaving_works, 'godown', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->weaving_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->weaving_works->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['weaving_works'] = &$this->weaving_works;

        // current_works
        $this->current_works = new DbField(
            $this, // Table
            'x_current_works', // Variable name
            'current_works', // Name
            '`current_works`', // Expression
            '`current_works`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`current_works`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->current_works->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->current_works->addMethod("getDefault", fn() => 0);
        $this->current_works->InputTextType = "text";
        $this->current_works->Raw = true;
        $this->current_works->Nullable = false; // NOT NULL field
        $this->current_works->Required = true; // Required field
        $this->current_works->setSelectMultiple(false); // Select one
        $this->current_works->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->current_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->current_works->Lookup = new Lookup($this->current_works, 'godown', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->current_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->current_works->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['current_works'] = &$this->current_works;

        // consignee
        $this->consignee = new DbField(
            $this, // Table
            'x_consignee', // Variable name
            'consignee', // Name
            '`consignee`', // Expression
            '`consignee`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`consignee`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->consignee->addMethod("getSelectFilter", fn() => "`id` >= 1000 and `grp` = 3");
        $this->consignee->InputTextType = "text";
        $this->consignee->Raw = true;
        $this->consignee->Required = true; // Required field
        $this->consignee->setSelectMultiple(false); // Select one
        $this->consignee->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->consignee->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->consignee->Lookup = new Lookup($this->consignee, 'buyer', false, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->consignee) . "',COALESCE(`code`,''))");
        $this->consignee->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->consignee->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['consignee'] = &$this->consignee;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->InputTextType = "text";
        $this->jc_no->Raw = true;
        $this->jc_no->Nullable = false; // NOT NULL field
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // completed
        $this->completed = new DbField(
            $this, // Table
            'x_completed', // Variable name
            'completed', // Name
            '`completed`', // Expression
            '`completed`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`completed`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->completed->addMethod("getDefault", fn() => 0);
        $this->completed->InputTextType = "text";
        $this->completed->Raw = true;
        $this->completed->setSelectMultiple(false); // Select one
        $this->completed->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->completed->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->completed->Lookup = new Lookup($this->completed, 'barcode_query', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->completed->OptionCount = 2;
        $this->completed->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->completed->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['completed'] = &$this->completed;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // buyer_loc
        $this->buyer_loc = new DbField(
            $this, // Table
            'x_buyer_loc', // Variable name
            'buyer_loc', // Name
            '`buyer_loc`', // Expression
            '`buyer_loc`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_loc`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_loc->addMethod("getDefault", fn() => "0");
        $this->buyer_loc->InputTextType = "text";
        $this->buyer_loc->Nullable = false; // NOT NULL field
        $this->buyer_loc->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['buyer_loc'] = &$this->buyer_loc;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "barcode_query";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT CONCAT(COALESCE(`partner_ref`, ''),'" . ValueSeparator(1, $this->buyer_ref) . "',COALESCE(`barcode`,''),'" . ValueSeparator(2, $this->buyer_ref) . "',COALESCE(`partner_code`,'')) FROM partner_product_ref TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = barcode_query.buyer_ref LIMIT 1) AS EV__buyer_ref FROM barcode_query)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->buyer_ref->AdvancedSearch->SearchValue != "" ||
            $this->buyer_ref->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->buyer_ref->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->buyer_ref->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->pl_no->DbValue = $row['pl_no'];
        $this->po->DbValue = $row['po'];
        $this->_barcode->DbValue = $row['barcode'];
        $this->buyers_id->DbValue = $row['buyers_id'];
        $this->buyer_ref->DbValue = $row['buyer_ref'];
        $this->buyer_barcode->DbValue = $row['buyer_barcode'];
        $this->design_id->DbValue = $row['design_id'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->category->DbValue = $row['category'];
        $this->size_cm->DbValue = $row['size_cm'];
        $this->size_buyer->DbValue = $row['size_buyer'];
        $this->order_date->DbValue = $row['order_date'];
        $this->despatch_week->DbValue = $row['despatch_week'];
        $this->sqm->DbValue = $row['sqm'];
        $this->buyer_po->DbValue = $row['buyer_po'];
        $this->po_price->DbValue = $row['po_price'];
        $this->po_discount->DbValue = $row['po_discount'];
        $this->po_currency->DbValue = $row['po_currency'];
        $this->weaving_works->DbValue = $row['weaving_works'];
        $this->current_works->DbValue = $row['current_works'];
        $this->consignee->DbValue = $row['consignee'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->completed->DbValue = $row['completed'];
        $this->remarks->DbValue = $row['remarks'];
        $this->buyer_loc->DbValue = $row['buyer_loc'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("barcodequerylist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "barcodequeryview" => $Language->phrase("View"),
            "barcodequeryedit" => $Language->phrase("Edit"),
            "barcodequeryadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "barcodequerylist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "BarcodeQueryView",
            Config("API_ADD_ACTION") => "BarcodeQueryAdd",
            Config("API_EDIT_ACTION") => "BarcodeQueryEdit",
            Config("API_DELETE_ACTION") => "BarcodeQueryDelete",
            Config("API_LIST_ACTION") => "BarcodeQueryList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "barcodequerylist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("barcodequeryview", $parm);
        } else {
            $url = $this->keyUrl("barcodequeryview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "barcodequeryadd?" . $parm;
        } else {
            $url = "barcodequeryadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("barcodequeryedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("barcodequerylist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("barcodequeryadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("barcodequerylist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("barcodequerydelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->po->setDbValue($row['po']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        $this->buyer_barcode->setDbValue($row['buyer_barcode']);
        $this->design_id->setDbValue($row['design_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->category->setDbValue($row['category']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->size_buyer->setDbValue($row['size_buyer']);
        $this->order_date->setDbValue($row['order_date']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->sqm->setDbValue($row['sqm']);
        $this->buyer_po->setDbValue($row['buyer_po']);
        $this->po_price->setDbValue($row['po_price']);
        $this->po_discount->setDbValue($row['po_discount']);
        $this->po_currency->setDbValue($row['po_currency']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->current_works->setDbValue($row['current_works']);
        $this->consignee->setDbValue($row['consignee']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->completed->setDbValue($row['completed']);
        $this->remarks->setDbValue($row['remarks']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "BarcodeQueryList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // pl_no

        // po

        // barcode

        // buyers_id

        // buyer_ref

        // buyer_barcode

        // design_id

        // batch_no

        // category

        // size_cm

        // size_buyer

        // order_date

        // despatch_week

        // sqm

        // buyer_po

        // po_price

        // po_discount

        // po_currency

        // weaving_works

        // current_works

        // consignee

        // jc_no

        // operator

        // datetime

        // completed

        // remarks

        // buyer_loc

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // pl_no
        $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
        $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

        // po
        $this->po->ViewValue = $this->po->CurrentValue;
        $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

        // barcode
        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
        $this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, $this->_barcode->formatPattern());

        // buyers_id
        $curVal = strval($this->buyers_id->CurrentValue);
        if ($curVal != "") {
            $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            if ($this->buyers_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                } else {
                    $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                }
            }
        } else {
            $this->buyers_id->ViewValue = null;
        }

        // buyer_ref
        if ($this->buyer_ref->VirtualValue != "") {
            $this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
        } else {
            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
            $curVal = strval($this->buyer_ref->CurrentValue);
            if ($curVal != "") {
                $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
                if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                    } else {
                        $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                    }
                }
            } else {
                $this->buyer_ref->ViewValue = null;
            }
        }

        // buyer_barcode
        $this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;

        // design_id
        $curVal = strval($this->design_id->CurrentValue);
        if ($curVal != "") {
            $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
            if ($this->design_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                    $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                } else {
                    $this->design_id->ViewValue = $this->design_id->CurrentValue;
                }
            }
        } else {
            $this->design_id->ViewValue = null;
        }

        // batch_no
        $curVal = strval($this->batch_no->CurrentValue);
        if ($curVal != "") {
            $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            if ($this->batch_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                }
            }
        } else {
            $this->batch_no->ViewValue = null;
        }

        // category
        $curVal = strval($this->category->CurrentValue);
        if ($curVal != "") {
            $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            if ($this->category->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                    $this->category->ViewValue = $this->category->displayValue($arwrk);
                } else {
                    $this->category->ViewValue = $this->category->CurrentValue;
                }
            }
        } else {
            $this->category->ViewValue = null;
        }

        // size_cm
        $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

        // size_buyer
        $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

        // order_date
        $this->order_date->ViewValue = $this->order_date->CurrentValue;
        $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

        // despatch_week
        $curVal = strval($this->despatch_week->CurrentValue);
        if ($curVal != "") {
            $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            if ($this->despatch_week->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                    $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                } else {
                    $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                }
            }
        } else {
            $this->despatch_week->ViewValue = null;
        }

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // buyer_po
        $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

        // po_price
        $this->po_price->ViewValue = $this->po_price->CurrentValue;

        // po_discount
        $this->po_discount->ViewValue = $this->po_discount->CurrentValue;
        $this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, $this->po_discount->formatPattern());

        // po_currency
        $curVal = strval($this->po_currency->CurrentValue);
        if ($curVal != "") {
            $this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
            if ($this->po_currency->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->po_currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->po_currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->po_currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->po_currency->Lookup->renderViewRow($rswrk[0]);
                    $this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
                } else {
                    $this->po_currency->ViewValue = FormatNumber($this->po_currency->CurrentValue, $this->po_currency->formatPattern());
                }
            }
        } else {
            $this->po_currency->ViewValue = null;
        }

        // weaving_works
        $curVal = strval($this->weaving_works->CurrentValue);
        if ($curVal != "") {
            $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
            if ($this->weaving_works->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                    $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                } else {
                    $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                }
            }
        } else {
            $this->weaving_works->ViewValue = null;
        }

        // current_works
        $curVal = strval($this->current_works->CurrentValue);
        if ($curVal != "") {
            $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
            if ($this->current_works->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                    $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                } else {
                    $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                }
            }
        } else {
            $this->current_works->ViewValue = null;
        }

        // consignee
        $curVal = strval($this->consignee->CurrentValue);
        if ($curVal != "") {
            $this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
            if ($this->consignee->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->consignee->getSelectFilter($this); // PHP
                $sqlWrk = $this->consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->consignee->Lookup->renderViewRow($rswrk[0]);
                    $this->consignee->ViewValue = $this->consignee->displayValue($arwrk);
                } else {
                    $this->consignee->ViewValue = FormatNumber($this->consignee->CurrentValue, $this->consignee->formatPattern());
                }
            }
        } else {
            $this->consignee->ViewValue = null;
        }

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
        $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // completed
        if (strval($this->completed->CurrentValue) != "") {
            $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
        } else {
            $this->completed->ViewValue = null;
        }

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // buyer_loc
        $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // pl_no
        $this->pl_no->HrefValue = "";
        $this->pl_no->TooltipValue = "";

        // po
        $this->po->HrefValue = "";
        $this->po->TooltipValue = "";

        // barcode
        $this->_barcode->HrefValue = "";
        $this->_barcode->TooltipValue = "";

        // buyers_id
        if (!EmptyValue($this->buyers_id->CurrentValue)) {
            $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
            $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
            }
        } else {
            $this->buyers_id->HrefValue = "";
        }
        $this->buyers_id->TooltipValue = "";

        // buyer_ref
        $this->buyer_ref->HrefValue = "";
        $this->buyer_ref->TooltipValue = "";

        // buyer_barcode
        $this->buyer_barcode->HrefValue = "";
        $this->buyer_barcode->TooltipValue = "";

        // design_id
        if (!EmptyValue($this->design_id->CurrentValue)) {
            $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . $this->design_id->CurrentValue; // Add prefix/suffix
            $this->design_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
            }
        } else {
            $this->design_id->HrefValue = "";
        }
        $this->design_id->TooltipValue = "";

        // batch_no
        $this->batch_no->HrefValue = "";
        $this->batch_no->TooltipValue = "";

        // category
        $this->category->HrefValue = "";
        $this->category->TooltipValue = "";

        // size_cm
        $this->size_cm->HrefValue = "";
        $this->size_cm->TooltipValue = "";

        // size_buyer
        $this->size_buyer->HrefValue = "";
        $this->size_buyer->TooltipValue = "";

        // order_date
        $this->order_date->HrefValue = "";
        $this->order_date->TooltipValue = "";

        // despatch_week
        $this->despatch_week->HrefValue = "";
        $this->despatch_week->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // buyer_po
        $this->buyer_po->HrefValue = "";
        $this->buyer_po->TooltipValue = "";

        // po_price
        $this->po_price->HrefValue = "";
        $this->po_price->TooltipValue = "";

        // po_discount
        $this->po_discount->HrefValue = "";
        $this->po_discount->TooltipValue = "";

        // po_currency
        $this->po_currency->HrefValue = "";
        $this->po_currency->TooltipValue = "";

        // weaving_works
        $this->weaving_works->HrefValue = "";
        $this->weaving_works->TooltipValue = "";

        // current_works
        $this->current_works->HrefValue = "";
        $this->current_works->TooltipValue = "";

        // consignee
        $this->consignee->HrefValue = "";
        $this->consignee->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // completed
        $this->completed->HrefValue = "";
        $this->completed->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // buyer_loc
        $this->buyer_loc->HrefValue = "";
        $this->buyer_loc->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // pl_no
        $this->pl_no->setupEditAttributes();
        $this->pl_no->EditValue = $this->pl_no->CurrentValue;
        $this->pl_no->EditValue = FormatNumber($this->pl_no->EditValue, $this->pl_no->formatPattern());

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;
        $this->po->EditValue = FormatNumber($this->po->EditValue, $this->po->formatPattern());

        // barcode
        $this->_barcode->setupEditAttributes();
        $this->_barcode->EditValue = $this->_barcode->CurrentValue;
        $this->_barcode->EditValue = FormatNumber($this->_barcode->EditValue, $this->_barcode->formatPattern());

        // buyers_id
        $this->buyers_id->setupEditAttributes();
        $this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

        // buyer_ref
        $this->buyer_ref->setupEditAttributes();
        $this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
        $this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

        // buyer_barcode
        $this->buyer_barcode->setupEditAttributes();
        if (!$this->buyer_barcode->Raw) {
            $this->buyer_barcode->CurrentValue = HtmlDecode($this->buyer_barcode->CurrentValue);
        }
        $this->buyer_barcode->EditValue = $this->buyer_barcode->CurrentValue;
        $this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());

        // design_id
        $this->design_id->setupEditAttributes();
        $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

        // batch_no
        $this->batch_no->setupEditAttributes();
        $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

        // category
        $this->category->setupEditAttributes();
        $this->category->PlaceHolder = RemoveHtml($this->category->caption());

        // size_cm
        $this->size_cm->setupEditAttributes();
        $this->size_cm->EditValue = $this->size_cm->CurrentValue;

        // size_buyer
        $this->size_buyer->setupEditAttributes();
        $this->size_buyer->EditValue = $this->size_buyer->CurrentValue;

        // order_date
        $this->order_date->setupEditAttributes();
        $this->order_date->EditValue = FormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern());
        $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

        // despatch_week
        $this->despatch_week->setupEditAttributes();
        $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, $this->sqm->formatPattern());

        // buyer_po
        $this->buyer_po->setupEditAttributes();
        if (!$this->buyer_po->Raw) {
            $this->buyer_po->CurrentValue = HtmlDecode($this->buyer_po->CurrentValue);
        }
        $this->buyer_po->EditValue = $this->buyer_po->CurrentValue;
        $this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

        // po_price
        $this->po_price->setupEditAttributes();
        if (!$this->po_price->Raw) {
            $this->po_price->CurrentValue = HtmlDecode($this->po_price->CurrentValue);
        }
        $this->po_price->EditValue = $this->po_price->CurrentValue;
        $this->po_price->PlaceHolder = RemoveHtml($this->po_price->caption());

        // po_discount
        $this->po_discount->setupEditAttributes();
        $this->po_discount->EditValue = $this->po_discount->CurrentValue;
        $this->po_discount->PlaceHolder = RemoveHtml($this->po_discount->caption());
        if (strval($this->po_discount->EditValue) != "" && is_numeric($this->po_discount->EditValue)) {
            $this->po_discount->EditValue = FormatNumber($this->po_discount->EditValue, null);
        }

        // po_currency
        $this->po_currency->setupEditAttributes();
        $this->po_currency->PlaceHolder = RemoveHtml($this->po_currency->caption());

        // weaving_works
        $this->weaving_works->setupEditAttributes();
        $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

        // current_works
        $this->current_works->setupEditAttributes();
        $curVal = strval($this->current_works->CurrentValue);
        if ($curVal != "") {
            $this->current_works->EditValue = $this->current_works->lookupCacheOption($curVal);
            if ($this->current_works->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                    $this->current_works->EditValue = $this->current_works->displayValue($arwrk);
                } else {
                    $this->current_works->EditValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                }
            }
        } else {
            $this->current_works->EditValue = null;
        }

        // consignee
        $this->consignee->setupEditAttributes();
        $this->consignee->PlaceHolder = RemoveHtml($this->consignee->caption());

        // jc_no
        $this->jc_no->setupEditAttributes();
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;
        $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, $this->jc_no->formatPattern());

        // operator

        // datetime

        // completed
        $this->completed->setupEditAttributes();
        $this->completed->EditValue = $this->completed->options(true);
        $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        if (!$this->remarks->Raw) {
            $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
        }
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // buyer_loc
        $this->buyer_loc->setupEditAttributes();
        if (!$this->buyer_loc->Raw) {
            $this->buyer_loc->CurrentValue = HtmlDecode($this->buyer_loc->CurrentValue);
        }
        $this->buyer_loc->EditValue = $this->buyer_loc->CurrentValue;
        $this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->pl_no);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->buyer_barcode);
                    $doc->exportCaption($this->design_id);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->size_buyer);
                    $doc->exportCaption($this->order_date);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->buyer_po);
                    $doc->exportCaption($this->po_price);
                    $doc->exportCaption($this->po_discount);
                    $doc->exportCaption($this->po_currency);
                    $doc->exportCaption($this->weaving_works);
                    $doc->exportCaption($this->current_works);
                    $doc->exportCaption($this->consignee);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->completed);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->buyer_loc);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->pl_no);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->buyer_barcode);
                    $doc->exportCaption($this->design_id);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->size_buyer);
                    $doc->exportCaption($this->order_date);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->buyer_po);
                    $doc->exportCaption($this->po_price);
                    $doc->exportCaption($this->po_discount);
                    $doc->exportCaption($this->po_currency);
                    $doc->exportCaption($this->weaving_works);
                    $doc->exportCaption($this->current_works);
                    $doc->exportCaption($this->consignee);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->completed);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->buyer_loc);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->pl_no);
                        $doc->exportField($this->po);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->buyer_barcode);
                        $doc->exportField($this->design_id);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->category);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->size_buyer);
                        $doc->exportField($this->order_date);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->buyer_po);
                        $doc->exportField($this->po_price);
                        $doc->exportField($this->po_discount);
                        $doc->exportField($this->po_currency);
                        $doc->exportField($this->weaving_works);
                        $doc->exportField($this->current_works);
                        $doc->exportField($this->consignee);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->completed);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->buyer_loc);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->pl_no);
                        $doc->exportField($this->po);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->buyer_barcode);
                        $doc->exportField($this->design_id);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->category);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->size_buyer);
                        $doc->exportField($this->order_date);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->buyer_po);
                        $doc->exportField($this->po_price);
                        $doc->exportField($this->po_discount);
                        $doc->exportField($this->po_currency);
                        $doc->exportField($this->weaving_works);
                        $doc->exportField($this->current_works);
                        $doc->exportField($this->consignee);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->completed);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->buyer_loc);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'barcode_query');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'barcode_query', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'barcode_query', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'barcode_query', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
