<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class Barcode2List extends Barcode2
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "Barcode2List";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fbarcode2list";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "barcode2list";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->po->setVisibility();
        $this->_barcode->setVisibility();
        $this->batch_no->setVisibility();
        $this->size_cm->setVisibility();
        $this->sqm->setVisibility();
        $this->sqm_a->setVisibility();
        $this->weight->setVisibility();
        $this->quantity->setVisibility();
        $this->jc_no->setVisibility();
        $this->process_c->setVisibility();
        $this->process_d->setVisibility();
        $this->status->setVisibility();
        $this->buyers_id->setVisibility();
        $this->despatch_week->setVisibility();
        $this->cs->setVisibility();
        $this->weaving_works->setVisibility();
        $this->current_works->setVisibility();
        $this->remarks->setVisibility();
        $this->p_remarks->setVisibility();
        $this->buyer_po->setVisibility();
        $this->buyer_ref->setVisibility();
        $this->design_size->setVisibility();
        $this->buyer_uid->setVisibility();
        $this->buyer_loc->setVisibility();
        $this->order_date->setVisibility();
        $this->completed->setVisibility();
        $this->category->setVisibility();
        $this->pl_no->setVisibility();
        $this->design_id->Visible = false;
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->process->Visible = false;
        $this->id->Visible = false;
        $this->pid->Visible = false;
        $this->shape->Visible = false;
        $this->production_plan->Visible = false;
        $this->_2srm->Visible = false;
        $this->_4srm->Visible = false;
        $this->RefID->Visible = false;
        $this->buyer_tid->Visible = false;
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->product_type->Visible = false;
        $this->w_cm->Visible = false;
        $this->l_cm->Visible = false;
        $this->_2srm_a->Visible = false;
        $this->_4srm_a->Visible = false;
        $this->buyer_barcode->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'barcode2';
        $this->TableName = 'barcode';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (barcode2)
        if (!isset($GLOBALS["barcode2"]) || $GLOBALS["barcode2"]::class == PROJECT_NAMESPACE . "barcode2") {
            $GLOBALS["barcode2"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "barcode2add";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "barcode2delete";
        $this->MultiUpdateUrl = "barcode2update";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'barcode');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "barcode2view"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->design_size->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->process_c);
        $this->setupLookupOptions($this->process_d);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->cs);
        $this->setupLookupOptions($this->weaving_works);
        $this->setupLookupOptions($this->current_works);
        $this->setupLookupOptions($this->buyer_ref);
        $this->setupLookupOptions($this->completed);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->process);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fbarcode2grid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fbarcode2srch");
        }
        $filterList = Concat($filterList, $this->po->AdvancedSearch->toJson(), ","); // Field po
        $filterList = Concat($filterList, $this->_barcode->AdvancedSearch->toJson(), ","); // Field barcode
        $filterList = Concat($filterList, $this->batch_no->AdvancedSearch->toJson(), ","); // Field batch_no
        $filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
        $filterList = Concat($filterList, $this->weight->AdvancedSearch->toJson(), ","); // Field weight
        $filterList = Concat($filterList, $this->jc_no->AdvancedSearch->toJson(), ","); // Field jc_no
        $filterList = Concat($filterList, $this->process_c->AdvancedSearch->toJson(), ","); // Field process_c
        $filterList = Concat($filterList, $this->process_d->AdvancedSearch->toJson(), ","); // Field process_d
        $filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
        $filterList = Concat($filterList, $this->buyers_id->AdvancedSearch->toJson(), ","); // Field buyers_id
        $filterList = Concat($filterList, $this->despatch_week->AdvancedSearch->toJson(), ","); // Field despatch_week
        $filterList = Concat($filterList, $this->cs->AdvancedSearch->toJson(), ","); // Field cs
        $filterList = Concat($filterList, $this->weaving_works->AdvancedSearch->toJson(), ","); // Field weaving_works
        $filterList = Concat($filterList, $this->current_works->AdvancedSearch->toJson(), ","); // Field current_works
        $filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
        $filterList = Concat($filterList, $this->p_remarks->AdvancedSearch->toJson(), ","); // Field p_remarks
        $filterList = Concat($filterList, $this->buyer_po->AdvancedSearch->toJson(), ","); // Field buyer_po
        $filterList = Concat($filterList, $this->buyer_ref->AdvancedSearch->toJson(), ","); // Field buyer_ref
        $filterList = Concat($filterList, $this->design_size->AdvancedSearch->toJson(), ","); // Field design_size
        $filterList = Concat($filterList, $this->buyer_uid->AdvancedSearch->toJson(), ","); // Field buyer_uid
        $filterList = Concat($filterList, $this->buyer_loc->AdvancedSearch->toJson(), ","); // Field buyer_loc
        $filterList = Concat($filterList, $this->order_date->AdvancedSearch->toJson(), ","); // Field order_date
        $filterList = Concat($filterList, $this->completed->AdvancedSearch->toJson(), ","); // Field completed
        $filterList = Concat($filterList, $this->category->AdvancedSearch->toJson(), ","); // Field category
        $filterList = Concat($filterList, $this->pl_no->AdvancedSearch->toJson(), ","); // Field pl_no
        $filterList = Concat($filterList, $this->pid->AdvancedSearch->toJson(), ","); // Field pid
        $filterList = Concat($filterList, $this->buyer_barcode->AdvancedSearch->toJson(), ","); // Field buyer_barcode
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Query Builder rules
        $rules = $this->queryBuilderRules();
        if ($rules) {
            $filterList = Concat($filterList, "\"" . Config("TABLE_RULES") . "\":\"" . JsEncode($rules) . "\"", ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fbarcode2srch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field po
        $this->po->AdvancedSearch->SearchValue = @$filter["x_po"];
        $this->po->AdvancedSearch->SearchOperator = @$filter["z_po"];
        $this->po->AdvancedSearch->SearchCondition = @$filter["v_po"];
        $this->po->AdvancedSearch->SearchValue2 = @$filter["y_po"];
        $this->po->AdvancedSearch->SearchOperator2 = @$filter["w_po"];
        $this->po->AdvancedSearch->save();

        // Field barcode
        $this->_barcode->AdvancedSearch->SearchValue = @$filter["x__barcode"];
        $this->_barcode->AdvancedSearch->SearchOperator = @$filter["z__barcode"];
        $this->_barcode->AdvancedSearch->SearchCondition = @$filter["v__barcode"];
        $this->_barcode->AdvancedSearch->SearchValue2 = @$filter["y__barcode"];
        $this->_barcode->AdvancedSearch->SearchOperator2 = @$filter["w__barcode"];
        $this->_barcode->AdvancedSearch->save();

        // Field batch_no
        $this->batch_no->AdvancedSearch->SearchValue = @$filter["x_batch_no"];
        $this->batch_no->AdvancedSearch->SearchOperator = @$filter["z_batch_no"];
        $this->batch_no->AdvancedSearch->SearchCondition = @$filter["v_batch_no"];
        $this->batch_no->AdvancedSearch->SearchValue2 = @$filter["y_batch_no"];
        $this->batch_no->AdvancedSearch->SearchOperator2 = @$filter["w_batch_no"];
        $this->batch_no->AdvancedSearch->save();

        // Field sqm
        $this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
        $this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
        $this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
        $this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
        $this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
        $this->sqm->AdvancedSearch->save();

        // Field weight
        $this->weight->AdvancedSearch->SearchValue = @$filter["x_weight"];
        $this->weight->AdvancedSearch->SearchOperator = @$filter["z_weight"];
        $this->weight->AdvancedSearch->SearchCondition = @$filter["v_weight"];
        $this->weight->AdvancedSearch->SearchValue2 = @$filter["y_weight"];
        $this->weight->AdvancedSearch->SearchOperator2 = @$filter["w_weight"];
        $this->weight->AdvancedSearch->save();

        // Field jc_no
        $this->jc_no->AdvancedSearch->SearchValue = @$filter["x_jc_no"];
        $this->jc_no->AdvancedSearch->SearchOperator = @$filter["z_jc_no"];
        $this->jc_no->AdvancedSearch->SearchCondition = @$filter["v_jc_no"];
        $this->jc_no->AdvancedSearch->SearchValue2 = @$filter["y_jc_no"];
        $this->jc_no->AdvancedSearch->SearchOperator2 = @$filter["w_jc_no"];
        $this->jc_no->AdvancedSearch->save();

        // Field process_c
        $this->process_c->AdvancedSearch->SearchValue = @$filter["x_process_c"];
        $this->process_c->AdvancedSearch->SearchOperator = @$filter["z_process_c"];
        $this->process_c->AdvancedSearch->SearchCondition = @$filter["v_process_c"];
        $this->process_c->AdvancedSearch->SearchValue2 = @$filter["y_process_c"];
        $this->process_c->AdvancedSearch->SearchOperator2 = @$filter["w_process_c"];
        $this->process_c->AdvancedSearch->save();

        // Field process_d
        $this->process_d->AdvancedSearch->SearchValue = @$filter["x_process_d"];
        $this->process_d->AdvancedSearch->SearchOperator = @$filter["z_process_d"];
        $this->process_d->AdvancedSearch->SearchCondition = @$filter["v_process_d"];
        $this->process_d->AdvancedSearch->SearchValue2 = @$filter["y_process_d"];
        $this->process_d->AdvancedSearch->SearchOperator2 = @$filter["w_process_d"];
        $this->process_d->AdvancedSearch->save();

        // Field status
        $this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
        $this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
        $this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
        $this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
        $this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
        $this->status->AdvancedSearch->save();

        // Field buyers_id
        $this->buyers_id->AdvancedSearch->SearchValue = @$filter["x_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchOperator = @$filter["z_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchCondition = @$filter["v_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchValue2 = @$filter["y_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchOperator2 = @$filter["w_buyers_id"];
        $this->buyers_id->AdvancedSearch->save();

        // Field despatch_week
        $this->despatch_week->AdvancedSearch->SearchValue = @$filter["x_despatch_week"];
        $this->despatch_week->AdvancedSearch->SearchOperator = @$filter["z_despatch_week"];
        $this->despatch_week->AdvancedSearch->SearchCondition = @$filter["v_despatch_week"];
        $this->despatch_week->AdvancedSearch->SearchValue2 = @$filter["y_despatch_week"];
        $this->despatch_week->AdvancedSearch->SearchOperator2 = @$filter["w_despatch_week"];
        $this->despatch_week->AdvancedSearch->save();

        // Field cs
        $this->cs->AdvancedSearch->SearchValue = @$filter["x_cs"];
        $this->cs->AdvancedSearch->SearchOperator = @$filter["z_cs"];
        $this->cs->AdvancedSearch->SearchCondition = @$filter["v_cs"];
        $this->cs->AdvancedSearch->SearchValue2 = @$filter["y_cs"];
        $this->cs->AdvancedSearch->SearchOperator2 = @$filter["w_cs"];
        $this->cs->AdvancedSearch->save();

        // Field weaving_works
        $this->weaving_works->AdvancedSearch->SearchValue = @$filter["x_weaving_works"];
        $this->weaving_works->AdvancedSearch->SearchOperator = @$filter["z_weaving_works"];
        $this->weaving_works->AdvancedSearch->SearchCondition = @$filter["v_weaving_works"];
        $this->weaving_works->AdvancedSearch->SearchValue2 = @$filter["y_weaving_works"];
        $this->weaving_works->AdvancedSearch->SearchOperator2 = @$filter["w_weaving_works"];
        $this->weaving_works->AdvancedSearch->save();

        // Field current_works
        $this->current_works->AdvancedSearch->SearchValue = @$filter["x_current_works"];
        $this->current_works->AdvancedSearch->SearchOperator = @$filter["z_current_works"];
        $this->current_works->AdvancedSearch->SearchCondition = @$filter["v_current_works"];
        $this->current_works->AdvancedSearch->SearchValue2 = @$filter["y_current_works"];
        $this->current_works->AdvancedSearch->SearchOperator2 = @$filter["w_current_works"];
        $this->current_works->AdvancedSearch->save();

        // Field remarks
        $this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
        $this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
        $this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
        $this->remarks->AdvancedSearch->save();

        // Field p_remarks
        $this->p_remarks->AdvancedSearch->SearchValue = @$filter["x_p_remarks"];
        $this->p_remarks->AdvancedSearch->SearchOperator = @$filter["z_p_remarks"];
        $this->p_remarks->AdvancedSearch->SearchCondition = @$filter["v_p_remarks"];
        $this->p_remarks->AdvancedSearch->SearchValue2 = @$filter["y_p_remarks"];
        $this->p_remarks->AdvancedSearch->SearchOperator2 = @$filter["w_p_remarks"];
        $this->p_remarks->AdvancedSearch->save();

        // Field buyer_po
        $this->buyer_po->AdvancedSearch->SearchValue = @$filter["x_buyer_po"];
        $this->buyer_po->AdvancedSearch->SearchOperator = @$filter["z_buyer_po"];
        $this->buyer_po->AdvancedSearch->SearchCondition = @$filter["v_buyer_po"];
        $this->buyer_po->AdvancedSearch->SearchValue2 = @$filter["y_buyer_po"];
        $this->buyer_po->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_po"];
        $this->buyer_po->AdvancedSearch->save();

        // Field buyer_ref
        $this->buyer_ref->AdvancedSearch->SearchValue = @$filter["x_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchOperator = @$filter["z_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchCondition = @$filter["v_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchValue2 = @$filter["y_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->save();

        // Field design_size
        $this->design_size->AdvancedSearch->SearchValue = @$filter["x_design_size"];
        $this->design_size->AdvancedSearch->SearchOperator = @$filter["z_design_size"];
        $this->design_size->AdvancedSearch->SearchCondition = @$filter["v_design_size"];
        $this->design_size->AdvancedSearch->SearchValue2 = @$filter["y_design_size"];
        $this->design_size->AdvancedSearch->SearchOperator2 = @$filter["w_design_size"];
        $this->design_size->AdvancedSearch->save();

        // Field buyer_uid
        $this->buyer_uid->AdvancedSearch->SearchValue = @$filter["x_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->SearchOperator = @$filter["z_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->SearchCondition = @$filter["v_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->SearchValue2 = @$filter["y_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->save();

        // Field buyer_loc
        $this->buyer_loc->AdvancedSearch->SearchValue = @$filter["x_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->SearchOperator = @$filter["z_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->SearchCondition = @$filter["v_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->SearchValue2 = @$filter["y_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->save();

        // Field order_date
        $this->order_date->AdvancedSearch->SearchValue = @$filter["x_order_date"];
        $this->order_date->AdvancedSearch->SearchOperator = @$filter["z_order_date"];
        $this->order_date->AdvancedSearch->SearchCondition = @$filter["v_order_date"];
        $this->order_date->AdvancedSearch->SearchValue2 = @$filter["y_order_date"];
        $this->order_date->AdvancedSearch->SearchOperator2 = @$filter["w_order_date"];
        $this->order_date->AdvancedSearch->save();

        // Field completed
        $this->completed->AdvancedSearch->SearchValue = @$filter["x_completed"];
        $this->completed->AdvancedSearch->SearchOperator = @$filter["z_completed"];
        $this->completed->AdvancedSearch->SearchCondition = @$filter["v_completed"];
        $this->completed->AdvancedSearch->SearchValue2 = @$filter["y_completed"];
        $this->completed->AdvancedSearch->SearchOperator2 = @$filter["w_completed"];
        $this->completed->AdvancedSearch->save();

        // Field category
        $this->category->AdvancedSearch->SearchValue = @$filter["x_category"];
        $this->category->AdvancedSearch->SearchOperator = @$filter["z_category"];
        $this->category->AdvancedSearch->SearchCondition = @$filter["v_category"];
        $this->category->AdvancedSearch->SearchValue2 = @$filter["y_category"];
        $this->category->AdvancedSearch->SearchOperator2 = @$filter["w_category"];
        $this->category->AdvancedSearch->save();

        // Field pl_no
        $this->pl_no->AdvancedSearch->SearchValue = @$filter["x_pl_no"];
        $this->pl_no->AdvancedSearch->SearchOperator = @$filter["z_pl_no"];
        $this->pl_no->AdvancedSearch->SearchCondition = @$filter["v_pl_no"];
        $this->pl_no->AdvancedSearch->SearchValue2 = @$filter["y_pl_no"];
        $this->pl_no->AdvancedSearch->SearchOperator2 = @$filter["w_pl_no"];
        $this->pl_no->AdvancedSearch->save();

        // Field pid
        $this->pid->AdvancedSearch->SearchValue = @$filter["x_pid"];
        $this->pid->AdvancedSearch->SearchOperator = @$filter["z_pid"];
        $this->pid->AdvancedSearch->SearchCondition = @$filter["v_pid"];
        $this->pid->AdvancedSearch->SearchValue2 = @$filter["y_pid"];
        $this->pid->AdvancedSearch->SearchOperator2 = @$filter["w_pid"];
        $this->pid->AdvancedSearch->save();

        // Field buyer_barcode
        $this->buyer_barcode->AdvancedSearch->SearchValue = @$filter["x_buyer_barcode"];
        $this->buyer_barcode->AdvancedSearch->SearchOperator = @$filter["z_buyer_barcode"];
        $this->buyer_barcode->AdvancedSearch->SearchCondition = @$filter["v_buyer_barcode"];
        $this->buyer_barcode->AdvancedSearch->SearchValue2 = @$filter["y_buyer_barcode"];
        $this->buyer_barcode->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_barcode"];
        $this->buyer_barcode->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
        if ($filter[Config("TABLE_RULES")] ?? false) {
            $this->Command = "query"; // Set command for query builder
            $this->setSessionRules($filter[Config("TABLE_RULES")]);
        }
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->po, $default, false); // po
        $this->buildSearchSql($where, $this->_barcode, $default, false); // barcode
        $this->buildSearchSql($where, $this->batch_no, $default, false); // batch_no
        $this->buildSearchSql($where, $this->sqm, $default, false); // sqm
        $this->buildSearchSql($where, $this->weight, $default, false); // weight
        $this->buildSearchSql($where, $this->jc_no, $default, false); // jc_no
        $this->buildSearchSql($where, $this->process_c, $default, true); // process_c
        $this->buildSearchSql($where, $this->process_d, $default, true); // process_d
        $this->buildSearchSql($where, $this->status, $default, false); // status
        $this->buildSearchSql($where, $this->buyers_id, $default, false); // buyers_id
        $this->buildSearchSql($where, $this->despatch_week, $default, false); // despatch_week
        $this->buildSearchSql($where, $this->cs, $default, false); // cs
        $this->buildSearchSql($where, $this->weaving_works, $default, false); // weaving_works
        $this->buildSearchSql($where, $this->current_works, $default, false); // current_works
        $this->buildSearchSql($where, $this->remarks, $default, false); // remarks
        $this->buildSearchSql($where, $this->p_remarks, $default, false); // p_remarks
        $this->buildSearchSql($where, $this->buyer_po, $default, false); // buyer_po
        $this->buildSearchSql($where, $this->buyer_ref, $default, false); // buyer_ref
        $this->buildSearchSql($where, $this->design_size, $default, false); // design_size
        $this->buildSearchSql($where, $this->buyer_uid, $default, false); // buyer_uid
        $this->buildSearchSql($where, $this->buyer_loc, $default, false); // buyer_loc
        $this->buildSearchSql($where, $this->order_date, $default, false); // order_date
        $this->buildSearchSql($where, $this->completed, $default, false); // completed
        $this->buildSearchSql($where, $this->category, $default, false); // category
        $this->buildSearchSql($where, $this->pl_no, $default, false); // pl_no
        $this->buildSearchSql($where, $this->pid, $default, false); // pid
        $this->buildSearchSql($where, $this->buyer_barcode, $default, false); // buyer_barcode

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->po->AdvancedSearch->save(); // po
            $this->_barcode->AdvancedSearch->save(); // barcode
            $this->batch_no->AdvancedSearch->save(); // batch_no
            $this->sqm->AdvancedSearch->save(); // sqm
            $this->weight->AdvancedSearch->save(); // weight
            $this->jc_no->AdvancedSearch->save(); // jc_no
            $this->process_c->AdvancedSearch->save(); // process_c
            $this->process_d->AdvancedSearch->save(); // process_d
            $this->status->AdvancedSearch->save(); // status
            $this->buyers_id->AdvancedSearch->save(); // buyers_id
            $this->despatch_week->AdvancedSearch->save(); // despatch_week
            $this->cs->AdvancedSearch->save(); // cs
            $this->weaving_works->AdvancedSearch->save(); // weaving_works
            $this->current_works->AdvancedSearch->save(); // current_works
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->p_remarks->AdvancedSearch->save(); // p_remarks
            $this->buyer_po->AdvancedSearch->save(); // buyer_po
            $this->buyer_ref->AdvancedSearch->save(); // buyer_ref
            $this->design_size->AdvancedSearch->save(); // design_size
            $this->buyer_uid->AdvancedSearch->save(); // buyer_uid
            $this->buyer_loc->AdvancedSearch->save(); // buyer_loc
            $this->order_date->AdvancedSearch->save(); // order_date
            $this->completed->AdvancedSearch->save(); // completed
            $this->category->AdvancedSearch->save(); // category
            $this->pl_no->AdvancedSearch->save(); // pl_no
            $this->pid->AdvancedSearch->save(); // pid
            $this->buyer_barcode->AdvancedSearch->save(); // buyer_barcode

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->po->AdvancedSearch->save(); // po
            $this->_barcode->AdvancedSearch->save(); // barcode
            $this->batch_no->AdvancedSearch->save(); // batch_no
            $this->sqm->AdvancedSearch->save(); // sqm
            $this->weight->AdvancedSearch->save(); // weight
            $this->jc_no->AdvancedSearch->save(); // jc_no
            $this->process_c->AdvancedSearch->save(); // process_c
            $this->process_d->AdvancedSearch->save(); // process_d
            $this->status->AdvancedSearch->save(); // status
            $this->buyers_id->AdvancedSearch->save(); // buyers_id
            $this->despatch_week->AdvancedSearch->save(); // despatch_week
            $this->cs->AdvancedSearch->save(); // cs
            $this->weaving_works->AdvancedSearch->save(); // weaving_works
            $this->current_works->AdvancedSearch->save(); // current_works
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->p_remarks->AdvancedSearch->save(); // p_remarks
            $this->buyer_po->AdvancedSearch->save(); // buyer_po
            $this->buyer_ref->AdvancedSearch->save(); // buyer_ref
            $this->design_size->AdvancedSearch->save(); // design_size
            $this->buyer_uid->AdvancedSearch->save(); // buyer_uid
            $this->buyer_loc->AdvancedSearch->save(); // buyer_loc
            $this->order_date->AdvancedSearch->save(); // order_date
            $this->completed->AdvancedSearch->save(); // completed
            $this->category->AdvancedSearch->save(); // category
            $this->pl_no->AdvancedSearch->save(); // pl_no
            $this->pid->AdvancedSearch->save(); // pid
            $this->buyer_barcode->AdvancedSearch->save(); // buyer_barcode
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field po
        $filter = $this->queryBuilderWhere("po");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field barcode
        $filter = $this->queryBuilderWhere("barcode");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_barcode, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_barcode->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field batch_no
        $filter = $this->queryBuilderWhere("batch_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->batch_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->batch_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sqm
        $filter = $this->queryBuilderWhere("sqm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sqm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sqm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field weight
        $filter = $this->queryBuilderWhere("weight");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->weight, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->weight->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field jc_no
        $filter = $this->queryBuilderWhere("jc_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->jc_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->jc_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field process_c
        $filter = $this->queryBuilderWhere("process_c");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->process_c, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->process_c->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field process_d
        $filter = $this->queryBuilderWhere("process_d");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->process_d, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->process_d->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field status
        $filter = $this->queryBuilderWhere("status");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->status, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyers_id
        $filter = $this->queryBuilderWhere("buyers_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyers_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyers_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field despatch_week
        $filter = $this->queryBuilderWhere("despatch_week");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->despatch_week, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->despatch_week->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cs
        $filter = $this->queryBuilderWhere("cs");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cs, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cs->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field weaving_works
        $filter = $this->queryBuilderWhere("weaving_works");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->weaving_works, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->weaving_works->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field current_works
        $filter = $this->queryBuilderWhere("current_works");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->current_works, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->current_works->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field remarks
        $filter = $this->queryBuilderWhere("remarks");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->remarks, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->remarks->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field p_remarks
        $filter = $this->queryBuilderWhere("p_remarks");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->p_remarks, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->p_remarks->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_po
        $filter = $this->queryBuilderWhere("buyer_po");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_po, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_po->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_ref
        $filter = $this->queryBuilderWhere("buyer_ref");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_ref, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_ref->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field design_size
        $filter = $this->queryBuilderWhere("design_size");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->design_size, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->design_size->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_uid
        $filter = $this->queryBuilderWhere("buyer_uid");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_uid, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_uid->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_loc
        $filter = $this->queryBuilderWhere("buyer_loc");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_loc, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_loc->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field order_date
        $filter = $this->queryBuilderWhere("order_date");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->order_date, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->order_date->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field completed
        $filter = $this->queryBuilderWhere("completed");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->completed, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->completed->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field category
        $filter = $this->queryBuilderWhere("category");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->category, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->category->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pl_no
        $filter = $this->queryBuilderWhere("pl_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pl_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pl_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_barcode
        $filter = $this->queryBuilderWhere("buyer_barcode");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_barcode, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_barcode->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->po;
        $searchFlds[] = &$this->_barcode;
        $searchFlds[] = &$this->batch_no;
        $searchFlds[] = &$this->sqm;
        $searchFlds[] = &$this->weight;
        $searchFlds[] = &$this->jc_no;
        $searchFlds[] = &$this->process_c;
        $searchFlds[] = &$this->process_d;
        $searchFlds[] = &$this->status;
        $searchFlds[] = &$this->buyers_id;
        $searchFlds[] = &$this->cs;
        $searchFlds[] = &$this->weaving_works;
        $searchFlds[] = &$this->remarks;
        $searchFlds[] = &$this->p_remarks;
        $searchFlds[] = &$this->buyer_po;
        $searchFlds[] = &$this->buyer_ref;
        $searchFlds[] = &$this->design_size;
        $searchFlds[] = &$this->buyer_uid;
        $searchFlds[] = &$this->buyer_loc;
        $searchFlds[] = &$this->completed;
        $searchFlds[] = &$this->pl_no;
        $searchFlds[] = &$this->design_id;
        $searchFlds[] = &$this->buyer_barcode;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->po->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_barcode->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->batch_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sqm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->weight->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->jc_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->process_c->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->process_d->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyers_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->despatch_week->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cs->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->weaving_works->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->current_works->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->remarks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->p_remarks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_po->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_ref->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->design_size->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_uid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_loc->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->order_date->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->completed->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->category->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pl_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_barcode->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->po->AdvancedSearch->unsetSession();
        $this->_barcode->AdvancedSearch->unsetSession();
        $this->batch_no->AdvancedSearch->unsetSession();
        $this->sqm->AdvancedSearch->unsetSession();
        $this->weight->AdvancedSearch->unsetSession();
        $this->jc_no->AdvancedSearch->unsetSession();
        $this->process_c->AdvancedSearch->unsetSession();
        $this->process_d->AdvancedSearch->unsetSession();
        $this->status->AdvancedSearch->unsetSession();
        $this->buyers_id->AdvancedSearch->unsetSession();
        $this->despatch_week->AdvancedSearch->unsetSession();
        $this->cs->AdvancedSearch->unsetSession();
        $this->weaving_works->AdvancedSearch->unsetSession();
        $this->current_works->AdvancedSearch->unsetSession();
        $this->remarks->AdvancedSearch->unsetSession();
        $this->p_remarks->AdvancedSearch->unsetSession();
        $this->buyer_po->AdvancedSearch->unsetSession();
        $this->buyer_ref->AdvancedSearch->unsetSession();
        $this->design_size->AdvancedSearch->unsetSession();
        $this->buyer_uid->AdvancedSearch->unsetSession();
        $this->buyer_loc->AdvancedSearch->unsetSession();
        $this->order_date->AdvancedSearch->unsetSession();
        $this->completed->AdvancedSearch->unsetSession();
        $this->category->AdvancedSearch->unsetSession();
        $this->pl_no->AdvancedSearch->unsetSession();
        $this->pid->AdvancedSearch->unsetSession();
        $this->buyer_barcode->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->po->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->batch_no->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->weight->AdvancedSearch->load();
        $this->jc_no->AdvancedSearch->load();
        $this->process_c->AdvancedSearch->load();
        $this->process_d->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->buyers_id->AdvancedSearch->load();
        $this->despatch_week->AdvancedSearch->load();
        $this->cs->AdvancedSearch->load();
        $this->weaving_works->AdvancedSearch->load();
        $this->current_works->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->p_remarks->AdvancedSearch->load();
        $this->buyer_po->AdvancedSearch->load();
        $this->buyer_ref->AdvancedSearch->load();
        $this->design_size->AdvancedSearch->load();
        $this->buyer_uid->AdvancedSearch->load();
        $this->buyer_loc->AdvancedSearch->load();
        $this->order_date->AdvancedSearch->load();
        $this->completed->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->pl_no->AdvancedSearch->load();
        $this->pid->AdvancedSearch->load();
        $this->buyer_barcode->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->_barcode->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
            $defaultSortList = ($this->_barcode->VirtualExpression != "" ? $this->_barcode->VirtualExpression : $this->_barcode->Expression) . " DESC"; // Set up default sort
            if ($this->getSessionOrderByList() == "" && $defaultSortList != "") {
                $this->setSessionOrderByList($defaultSortList);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->po, $ctrl); // po
            $this->updateSort($this->_barcode, $ctrl); // barcode
            $this->updateSort($this->batch_no, $ctrl); // batch_no
            $this->updateSort($this->size_cm, $ctrl); // size_cm
            $this->updateSort($this->sqm, $ctrl); // sqm
            $this->updateSort($this->sqm_a, $ctrl); // sqm_a
            $this->updateSort($this->weight, $ctrl); // weight
            $this->updateSort($this->quantity, $ctrl); // quantity
            $this->updateSort($this->jc_no, $ctrl); // jc_no
            $this->updateSort($this->process_c, $ctrl); // process_c
            $this->updateSort($this->process_d, $ctrl); // process_d
            $this->updateSort($this->status, $ctrl); // status
            $this->updateSort($this->buyers_id, $ctrl); // buyers_id
            $this->updateSort($this->despatch_week, $ctrl); // despatch_week
            $this->updateSort($this->cs, $ctrl); // cs
            $this->updateSort($this->weaving_works, $ctrl); // weaving_works
            $this->updateSort($this->current_works, $ctrl); // current_works
            $this->updateSort($this->remarks, $ctrl); // remarks
            $this->updateSort($this->p_remarks, $ctrl); // p_remarks
            $this->updateSort($this->buyer_po, $ctrl); // buyer_po
            $this->updateSort($this->buyer_ref, $ctrl); // buyer_ref
            $this->updateSort($this->design_size, $ctrl); // design_size
            $this->updateSort($this->buyer_uid, $ctrl); // buyer_uid
            $this->updateSort($this->buyer_loc, $ctrl); // buyer_loc
            $this->updateSort($this->order_date, $ctrl); // order_date
            $this->updateSort($this->completed, $ctrl); // completed
            $this->updateSort($this->category, $ctrl); // category
            $this->updateSort($this->pl_no, $ctrl); // pl_no
            $this->updateSort($this->buyer_barcode, $ctrl); // buyer_barcode
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->setSessionOrderByList($orderBy);
                $this->po->setSort("");
                $this->_barcode->setSort("");
                $this->batch_no->setSort("");
                $this->size_cm->setSort("");
                $this->sqm->setSort("");
                $this->sqm_a->setSort("");
                $this->weight->setSort("");
                $this->quantity->setSort("");
                $this->jc_no->setSort("");
                $this->process_c->setSort("");
                $this->process_d->setSort("");
                $this->status->setSort("");
                $this->buyers_id->setSort("");
                $this->despatch_week->setSort("");
                $this->cs->setSort("");
                $this->weaving_works->setSort("");
                $this->current_works->setSort("");
                $this->remarks->setSort("");
                $this->p_remarks->setSort("");
                $this->buyer_po->setSort("");
                $this->buyer_ref->setSort("");
                $this->design_size->setSort("");
                $this->buyer_uid->setSort("");
                $this->buyer_loc->setSort("");
                $this->order_date->setSort("");
                $this->completed->setSort("");
                $this->category->setSort("");
                $this->pl_no->setSort("");
                $this->design_id->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->process->setSort("");
                $this->id->setSort("");
                $this->pid->setSort("");
                $this->shape->setSort("");
                $this->production_plan->setSort("");
                $this->_2srm->setSort("");
                $this->_4srm->setSort("");
                $this->RefID->setSort("");
                $this->buyer_tid->setSort("");
                $this->grp->setSort("");
                $this->s_grp->setSort("");
                $this->product_type->setSort("");
                $this->w_cm->setSort("");
                $this->l_cm->setSort("");
                $this->_2srm_a->setSort("");
                $this->_4srm_a->setSort("");
                $this->buyer_barcode->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"barcode2\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fbarcode2list\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fbarcode2list\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "po");
            $this->createColumnOption($option, "barcode");
            $this->createColumnOption($option, "batch_no");
            $this->createColumnOption($option, "size_cm");
            $this->createColumnOption($option, "sqm");
            $this->createColumnOption($option, "sqm_a");
            $this->createColumnOption($option, "weight");
            $this->createColumnOption($option, "quantity");
            $this->createColumnOption($option, "jc_no");
            $this->createColumnOption($option, "process_c");
            $this->createColumnOption($option, "process_d");
            $this->createColumnOption($option, "status");
            $this->createColumnOption($option, "buyers_id");
            $this->createColumnOption($option, "despatch_week");
            $this->createColumnOption($option, "cs");
            $this->createColumnOption($option, "weaving_works");
            $this->createColumnOption($option, "current_works");
            $this->createColumnOption($option, "remarks");
            $this->createColumnOption($option, "p_remarks");
            $this->createColumnOption($option, "buyer_po");
            $this->createColumnOption($option, "buyer_ref");
            $this->createColumnOption($option, "design_size");
            $this->createColumnOption($option, "buyer_uid");
            $this->createColumnOption($option, "buyer_loc");
            $this->createColumnOption($option, "order_date");
            $this->createColumnOption($option, "completed");
            $this->createColumnOption($option, "category");
            $this->createColumnOption($option, "pl_no");
            $this->createColumnOption($option, "buyer_barcode");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fbarcode2srch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fbarcode2srch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fbarcode2list"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_barcode2", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_barcode2",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // po
        if ($this->po->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po->AdvancedSearch->SearchValue != "" || $this->po->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_barcode->AdvancedSearch->SearchValue != "" || $this->_barcode->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // batch_no
        if ($this->batch_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->batch_no->AdvancedSearch->SearchValue != "" || $this->batch_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sqm->AdvancedSearch->SearchValue != "" || $this->sqm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // weight
        if ($this->weight->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->weight->AdvancedSearch->SearchValue != "" || $this->weight->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // jc_no
        if ($this->jc_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->jc_no->AdvancedSearch->SearchValue != "" || $this->jc_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // process_c
        if ($this->process_c->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->process_c->AdvancedSearch->SearchValue != "" || $this->process_c->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->process_c->AdvancedSearch->SearchValue)) {
            $this->process_c->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process_c->AdvancedSearch->SearchValue);
        }
        if (is_array($this->process_c->AdvancedSearch->SearchValue2)) {
            $this->process_c->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process_c->AdvancedSearch->SearchValue2);
        }

        // process_d
        if ($this->process_d->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->process_d->AdvancedSearch->SearchValue != "" || $this->process_d->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->process_d->AdvancedSearch->SearchValue)) {
            $this->process_d->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process_d->AdvancedSearch->SearchValue);
        }
        if (is_array($this->process_d->AdvancedSearch->SearchValue2)) {
            $this->process_d->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process_d->AdvancedSearch->SearchValue2);
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status->AdvancedSearch->SearchValue != "" || $this->status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyers_id
        if ($this->buyers_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyers_id->AdvancedSearch->SearchValue != "" || $this->buyers_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // despatch_week
        if ($this->despatch_week->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->despatch_week->AdvancedSearch->SearchValue != "" || $this->despatch_week->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cs
        if ($this->cs->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cs->AdvancedSearch->SearchValue != "" || $this->cs->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // weaving_works
        if ($this->weaving_works->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->weaving_works->AdvancedSearch->SearchValue != "" || $this->weaving_works->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // current_works
        if ($this->current_works->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->current_works->AdvancedSearch->SearchValue != "" || $this->current_works->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->remarks->AdvancedSearch->SearchValue != "" || $this->remarks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // p_remarks
        if ($this->p_remarks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->p_remarks->AdvancedSearch->SearchValue != "" || $this->p_remarks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_po
        if ($this->buyer_po->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_po->AdvancedSearch->SearchValue != "" || $this->buyer_po->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_ref
        if ($this->buyer_ref->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_ref->AdvancedSearch->SearchValue != "" || $this->buyer_ref->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // design_size
        if ($this->design_size->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->design_size->AdvancedSearch->SearchValue != "" || $this->design_size->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_uid
        if ($this->buyer_uid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_uid->AdvancedSearch->SearchValue != "" || $this->buyer_uid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_loc
        if ($this->buyer_loc->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_loc->AdvancedSearch->SearchValue != "" || $this->buyer_loc->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // order_date
        if ($this->order_date->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->order_date->AdvancedSearch->SearchValue != "" || $this->order_date->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // completed
        if ($this->completed->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->completed->AdvancedSearch->SearchValue != "" || $this->completed->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->category->AdvancedSearch->SearchValue != "" || $this->category->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pl_no
        if ($this->pl_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pl_no->AdvancedSearch->SearchValue != "" || $this->pl_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pid
        if ($this->pid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pid->AdvancedSearch->SearchValue != "" || $this->pid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_barcode
        if ($this->buyer_barcode->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_barcode->AdvancedSearch->SearchValue != "" || $this->buyer_barcode->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->po->setDbValue($row['po']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->batch_no->setDbValue($row['batch_no']);
        if (array_key_exists('EV__batch_no', $row)) {
            $this->batch_no->VirtualValue = $row['EV__batch_no']; // Set up virtual field value
        } else {
            $this->batch_no->VirtualValue = ""; // Clear value
        }
        $this->size_cm->setDbValue($row['size_cm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->weight->setDbValue($row['weight']);
        $this->quantity->setDbValue($row['quantity']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->process_c->setDbValue($row['process_c']);
        $this->process_d->setDbValue($row['process_d']);
        $this->status->setDbValue($row['status']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->cs->setDbValue($row['cs']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->current_works->setDbValue($row['current_works']);
        $this->remarks->setDbValue($row['remarks']);
        $this->p_remarks->setDbValue($row['p_remarks']);
        $this->buyer_po->setDbValue($row['buyer_po']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        $this->design_size->setDbValue($row['design_size']);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->order_date->setDbValue($row['order_date']);
        $this->completed->setDbValue($row['completed']);
        $this->category->setDbValue($row['category']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->design_id->setDbValue($row['design_id']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->process->setDbValue($row['process']);
        $this->id->setDbValue($row['id']);
        $this->pid->setDbValue($row['pid']);
        $this->shape->setDbValue($row['shape']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->_2srm->setDbValue($row['2srm']);
        $this->_4srm->setDbValue($row['4srm']);
        $this->RefID->setDbValue($row['RefID']);
        $this->buyer_tid->setDbValue($row['buyer_tid']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product_type->setDbValue($row['product_type']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->_2srm_a->setDbValue($row['2srm_a']);
        $this->_4srm_a->setDbValue($row['4srm_a']);
        $this->buyer_barcode->setDbValue($row['buyer_barcode']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['po'] = $this->po->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['size_cm'] = $this->size_cm->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['sqm_a'] = $this->sqm_a->DefaultValue;
        $row['weight'] = $this->weight->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['process_c'] = $this->process_c->DefaultValue;
        $row['process_d'] = $this->process_d->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['buyers_id'] = $this->buyers_id->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['cs'] = $this->cs->DefaultValue;
        $row['weaving_works'] = $this->weaving_works->DefaultValue;
        $row['current_works'] = $this->current_works->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['p_remarks'] = $this->p_remarks->DefaultValue;
        $row['buyer_po'] = $this->buyer_po->DefaultValue;
        $row['buyer_ref'] = $this->buyer_ref->DefaultValue;
        $row['design_size'] = $this->design_size->DefaultValue;
        $row['buyer_uid'] = $this->buyer_uid->DefaultValue;
        $row['buyer_loc'] = $this->buyer_loc->DefaultValue;
        $row['order_date'] = $this->order_date->DefaultValue;
        $row['completed'] = $this->completed->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['pl_no'] = $this->pl_no->DefaultValue;
        $row['design_id'] = $this->design_id->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['id'] = $this->id->DefaultValue;
        $row['pid'] = $this->pid->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['2srm'] = $this->_2srm->DefaultValue;
        $row['4srm'] = $this->_4srm->DefaultValue;
        $row['RefID'] = $this->RefID->DefaultValue;
        $row['buyer_tid'] = $this->buyer_tid->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['2srm_a'] = $this->_2srm_a->DefaultValue;
        $row['4srm_a'] = $this->_4srm_a->DefaultValue;
        $row['buyer_barcode'] = $this->buyer_barcode->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // po

        // barcode

        // batch_no

        // size_cm
        $this->size_cm->CellCssStyle = "white-space: nowrap;";

        // sqm

        // sqm_a
        $this->sqm_a->CellCssStyle = "white-space: nowrap;";

        // weight

        // quantity
        $this->quantity->CellCssStyle = "white-space: nowrap;";

        // jc_no

        // process_c

        // process_d

        // status

        // buyers_id
        $this->buyers_id->CellCssStyle = "white-space: nowrap;";

        // despatch_week

        // cs

        // weaving_works

        // current_works

        // remarks

        // p_remarks

        // buyer_po

        // buyer_ref

        // design_size

        // buyer_uid

        // buyer_loc

        // order_date

        // completed

        // category
        $this->category->CellCssStyle = "white-space: nowrap;";

        // pl_no

        // design_id
        $this->design_id->CellCssStyle = "white-space: nowrap;";

        // operator
        $this->operator->CellCssStyle = "white-space: nowrap;";

        // datetime
        $this->datetime->CellCssStyle = "white-space: nowrap;";

        // process
        $this->process->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->CellCssStyle = "white-space: nowrap;";

        // pid
        $this->pid->CellCssStyle = "white-space: nowrap;";

        // shape
        $this->shape->CellCssStyle = "white-space: nowrap;";

        // production_plan
        $this->production_plan->CellCssStyle = "white-space: nowrap;";

        // 2srm
        $this->_2srm->CellCssStyle = "white-space: nowrap;";

        // 4srm
        $this->_4srm->CellCssStyle = "white-space: nowrap;";

        // RefID
        $this->RefID->CellCssStyle = "white-space: nowrap;";

        // buyer_tid
        $this->buyer_tid->CellCssStyle = "white-space: nowrap;";

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // product_type
        $this->product_type->CellCssStyle = "white-space: nowrap;";

        // w_cm
        $this->w_cm->CellCssStyle = "white-space: nowrap;";

        // l_cm
        $this->l_cm->CellCssStyle = "white-space: nowrap;";

        // 2srm_a
        $this->_2srm_a->CellCssStyle = "white-space: nowrap;";

        // 4srm_a
        $this->_4srm_a->CellCssStyle = "white-space: nowrap;";

        // buyer_barcode

        // Accumulate aggregate value
        if ($this->RowType != RowType::AGGREGATEINIT && $this->RowType != RowType::AGGREGATE && $this->RowType != RowType::PREVIEWFIELD) {
            if (is_numeric($this->sqm->CurrentValue)) {
                $this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
            }
        }

        // View row
        if ($this->RowType == RowType::VIEW) {
            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // batch_no
            if ($this->batch_no->VirtualValue != "") {
                $this->batch_no->ViewValue = $this->batch_no->VirtualValue;
            } else {
                $curVal = strval($this->batch_no->CurrentValue);
                if ($curVal != "") {
                    $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                    if ($this->batch_no->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                            $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                        } else {
                            $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                        }
                    }
                } else {
                    $this->batch_no->ViewValue = null;
                }
            }

            // size_cm
            $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // sqm_a
            $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
            $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

            // weight
            $this->weight->ViewValue = $this->weight->CurrentValue;
            $this->weight->ViewValue = FormatNumber($this->weight->ViewValue, $this->weight->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // process_c
            $curVal = strval($this->process_c->CurrentValue);
            if ($curVal != "") {
                $this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
                if ($this->process_c->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_c->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_c->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->process_c->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_c->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_c->Lookup->renderViewRow($row);
                            $this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
                        }
                    } else {
                        $this->process_c->ViewValue = $this->process_c->CurrentValue;
                    }
                }
            } else {
                $this->process_c->ViewValue = null;
            }

            // process_d
            $curVal = strval($this->process_d->CurrentValue);
            if ($curVal != "") {
                $this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
                if ($this->process_d->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_d->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_d->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->process_d->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_d->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_d->Lookup->renderViewRow($row);
                            $this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
                        }
                    } else {
                        $this->process_d->ViewValue = $this->process_d->CurrentValue;
                    }
                }
            } else {
                $this->process_d->ViewValue = null;
            }

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // buyers_id
            $this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->despatch_week->getSelectFilter($this); // PHP
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // cs
            if (strval($this->cs->CurrentValue) != "") {
                $this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
            } else {
                $this->cs->ViewValue = null;
            }

            // weaving_works
            $curVal = strval($this->weaving_works->CurrentValue);
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
                if ($this->weaving_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                        $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                    } else {
                        $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                    }
                }
            } else {
                $this->weaving_works->ViewValue = null;
            }

            // current_works
            $curVal = strval($this->current_works->CurrentValue);
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
                if ($this->current_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                        $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                    } else {
                        $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                    }
                }
            } else {
                $this->current_works->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // p_remarks
            $this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;
            $this->p_remarks->ViewCustomAttributes = $this->p_remarks->getViewCustomAttributes(); // PHP

            // buyer_po
            $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

            // buyer_ref
            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
            $curVal = strval($this->buyer_ref->CurrentValue);
            if ($curVal != "") {
                $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
                if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                    } else {
                        $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                    }
                }
            } else {
                $this->buyer_ref->ViewValue = null;
            }

            // design_size
            $this->design_size->ViewValue = $this->design_size->CurrentValue;

            // buyer_uid
            $this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;

            // buyer_loc
            $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

            // order_date
            $this->order_date->ViewValue = $this->order_date->CurrentValue;
            $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

            // completed
            if (strval($this->completed->CurrentValue) != "") {
                $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
            } else {
                $this->completed->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // pl_no
            $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
            $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

            // buyer_barcode
            $this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_barcode->ViewValue = $this->highlightValue($this->_barcode);
            }

            // batch_no
            $this->batch_no->HrefValue = "";
            $this->batch_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->batch_no->ViewValue = $this->highlightValue($this->batch_no);
            }

            // size_cm
            $this->size_cm->HrefValue = "";
            $this->size_cm->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // sqm_a
            $this->sqm_a->HrefValue = "";
            $this->sqm_a->TooltipValue = "";

            // weight
            $this->weight->HrefValue = "";
            $this->weight->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";

            // process_c
            $this->process_c->HrefValue = "";
            $this->process_c->TooltipValue = "";

            // process_d
            $this->process_d->HrefValue = "";
            $this->process_d->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // buyers_id
            $this->buyers_id->HrefValue = "";
            $this->buyers_id->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // cs
            $this->cs->HrefValue = "";
            $this->cs->TooltipValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";
            $this->weaving_works->TooltipValue = "";

            // current_works
            $this->current_works->HrefValue = "";
            $this->current_works->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";
            if (!$this->isExport()) {
                $this->remarks->ViewValue = $this->highlightValue($this->remarks);
            }

            // p_remarks
            $this->p_remarks->HrefValue = "";
            $this->p_remarks->TooltipValue = "";
            if (!$this->isExport()) {
                $this->p_remarks->ViewValue = $this->highlightValue($this->p_remarks);
            }

            // buyer_po
            $this->buyer_po->HrefValue = "";
            $this->buyer_po->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_po->ViewValue = $this->highlightValue($this->buyer_po);
            }

            // buyer_ref
            $this->buyer_ref->HrefValue = "";
            $this->buyer_ref->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_ref->ViewValue = $this->highlightValue($this->buyer_ref);
            }

            // design_size
            $this->design_size->HrefValue = "";
            $this->design_size->TooltipValue = "";

            // buyer_uid
            $this->buyer_uid->HrefValue = "";
            $this->buyer_uid->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_uid->ViewValue = $this->highlightValue($this->buyer_uid);
            }

            // buyer_loc
            $this->buyer_loc->HrefValue = "";
            $this->buyer_loc->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_loc->ViewValue = $this->highlightValue($this->buyer_loc);
            }

            // order_date
            $this->order_date->HrefValue = "";
            $this->order_date->TooltipValue = "";
            if (!$this->isExport()) {
                $this->order_date->ViewValue = $this->highlightValue($this->order_date);
            }

            // completed
            $this->completed->HrefValue = "";
            $this->completed->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // pl_no
            $this->pl_no->HrefValue = "";
            $this->pl_no->TooltipValue = "";

            // buyer_barcode
            $this->buyer_barcode->HrefValue = "";
            $this->buyer_barcode->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_barcode->ViewValue = $this->highlightValue($this->buyer_barcode);
            }
        } elseif ($this->RowType == RowType::SEARCH) {
            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->AdvancedSearch->SearchValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());
            $this->po->setupEditAttributes();
            $this->po->EditValue2 = $this->po->AdvancedSearch->SearchValue2;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue = $this->_barcode->AdvancedSearch->SearchValue;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue2 = $this->_barcode->AdvancedSearch->SearchValue2;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // batch_no
            $this->batch_no->setupEditAttributes();
            $this->batch_no->EditValue = $this->batch_no->AdvancedSearch->SearchValue;
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // size_cm
            $this->size_cm->setupEditAttributes();
            if (!$this->size_cm->Raw) {
                $this->size_cm->AdvancedSearch->SearchValue = HtmlDecode($this->size_cm->AdvancedSearch->SearchValue);
            }
            $this->size_cm->EditValue = HtmlEncode($this->size_cm->AdvancedSearch->SearchValue);
            $this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->AdvancedSearch->SearchValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // sqm_a
            $this->sqm_a->setupEditAttributes();
            $this->sqm_a->EditValue = $this->sqm_a->AdvancedSearch->SearchValue;
            $this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());

            // weight
            $this->weight->setupEditAttributes();
            $this->weight->EditValue = $this->weight->AdvancedSearch->SearchValue;
            $this->weight->PlaceHolder = RemoveHtml($this->weight->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            $this->jc_no->EditValue = $this->jc_no->AdvancedSearch->SearchValue;
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

            // process_c
            $curVal = trim(strval($this->process_c->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->process_c->AdvancedSearch->ViewValue = $this->process_c->lookupCacheOption($curVal);
            } else {
                $this->process_c->AdvancedSearch->ViewValue = $this->process_c->Lookup !== null && is_array($this->process_c->lookupOptions()) && count($this->process_c->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process_c->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->process_c->EditValue = array_values($this->process_c->lookupOptions());
                if ($this->process_c->AdvancedSearch->ViewValue == "") {
                    $this->process_c->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_c->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_c->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->process_c->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process_c->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process_c->Lookup->renderViewRow($row);
                        $this->process_c->AdvancedSearch->ViewValue->add($this->process_c->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->process_c->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->process_c->EditValue = $arwrk;
            }
            $this->process_c->PlaceHolder = RemoveHtml($this->process_c->caption());
            $curVal = trim(strval($this->process_c->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->process_c->AdvancedSearch->ViewValue2 = $this->process_c->lookupCacheOption($curVal);
            } else {
                $this->process_c->AdvancedSearch->ViewValue2 = $this->process_c->Lookup !== null && is_array($this->process_c->lookupOptions()) && count($this->process_c->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process_c->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->process_c->EditValue2 = array_values($this->process_c->lookupOptions());
                if ($this->process_c->AdvancedSearch->ViewValue2 == "") {
                    $this->process_c->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_c->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_c->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->process_c->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process_c->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process_c->Lookup->renderViewRow($row);
                        $this->process_c->AdvancedSearch->ViewValue2->add($this->process_c->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->process_c->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->process_c->EditValue2 = $arwrk;
            }
            $this->process_c->PlaceHolder = RemoveHtml($this->process_c->caption());

            // process_d
            $curVal = trim(strval($this->process_d->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->process_d->AdvancedSearch->ViewValue = $this->process_d->lookupCacheOption($curVal);
            } else {
                $this->process_d->AdvancedSearch->ViewValue = $this->process_d->Lookup !== null && is_array($this->process_d->lookupOptions()) && count($this->process_d->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process_d->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->process_d->EditValue = array_values($this->process_d->lookupOptions());
                if ($this->process_d->AdvancedSearch->ViewValue == "") {
                    $this->process_d->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_d->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_d->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->process_d->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process_d->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process_d->Lookup->renderViewRow($row);
                        $this->process_d->AdvancedSearch->ViewValue->add($this->process_d->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->process_d->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->process_d->EditValue = $arwrk;
            }
            $this->process_d->PlaceHolder = RemoveHtml($this->process_d->caption());
            $curVal = trim(strval($this->process_d->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->process_d->AdvancedSearch->ViewValue2 = $this->process_d->lookupCacheOption($curVal);
            } else {
                $this->process_d->AdvancedSearch->ViewValue2 = $this->process_d->Lookup !== null && is_array($this->process_d->lookupOptions()) && count($this->process_d->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process_d->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->process_d->EditValue2 = array_values($this->process_d->lookupOptions());
                if ($this->process_d->AdvancedSearch->ViewValue2 == "") {
                    $this->process_d->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_d->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_d->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->process_d->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process_d->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process_d->Lookup->renderViewRow($row);
                        $this->process_d->AdvancedSearch->ViewValue2->add($this->process_d->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->process_d->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->process_d->EditValue2 = $arwrk;
            }
            $this->process_d->PlaceHolder = RemoveHtml($this->process_d->caption());

            // status
            $this->status->setupEditAttributes();
            $curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
            } else {
                $this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== null && is_array($this->status->lookupOptions()) && count($this->status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->status->EditValue = array_values($this->status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->status->AdvancedSearch->SearchValue, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->status->EditValue = $arwrk;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // buyers_id
            $this->buyers_id->setupEditAttributes();
            $this->buyers_id->EditValue = $this->buyers_id->AdvancedSearch->SearchValue;
            $curVal = strval($this->buyers_id->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->EditValue = HtmlEncode(FormatNumber($this->buyers_id->AdvancedSearch->SearchValue, $this->buyers_id->formatPattern()));
                    }
                }
            } else {
                $this->buyers_id->EditValue = null;
            }
            $this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->despatch_week->EditValue = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->AdvancedSearch->SearchValue, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->despatch_week->getSelectFilter($this); // PHP
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->despatch_week->AdvancedSearch->ViewValue2 = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->AdvancedSearch->ViewValue2 = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->despatch_week->EditValue2 = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->AdvancedSearch->SearchValue2, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->despatch_week->getSelectFilter($this); // PHP
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue2 = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // cs
            $this->cs->setupEditAttributes();
            $this->cs->EditValue = $this->cs->options(true);
            $this->cs->PlaceHolder = RemoveHtml($this->cs->caption());

            // weaving_works
            $this->weaving_works->setupEditAttributes();
            $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

            // current_works
            $this->current_works->setupEditAttributes();
            $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // p_remarks
            $this->p_remarks->setupEditAttributes();
            if (!$this->p_remarks->Raw) {
                $this->p_remarks->AdvancedSearch->SearchValue = HtmlDecode($this->p_remarks->AdvancedSearch->SearchValue);
            }
            $this->p_remarks->EditValue = HtmlEncode($this->p_remarks->AdvancedSearch->SearchValue);
            $this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

            // buyer_po
            $this->buyer_po->setupEditAttributes();
            if (!$this->buyer_po->Raw) {
                $this->buyer_po->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_po->AdvancedSearch->SearchValue);
            }
            $this->buyer_po->EditValue = HtmlEncode($this->buyer_po->AdvancedSearch->SearchValue);
            $this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

            // buyer_ref
            $this->buyer_ref->setupEditAttributes();
            $this->buyer_ref->EditValue = $this->buyer_ref->AdvancedSearch->SearchValue;
            $curVal = strval($this->buyer_ref->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
                if ($this->buyer_ref->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
                    } else {
                        $this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->buyer_ref->EditValue = null;
            }
            $this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

            // design_size
            $this->design_size->setupEditAttributes();
            if (!$this->design_size->Raw) {
                $this->design_size->AdvancedSearch->SearchValue = HtmlDecode($this->design_size->AdvancedSearch->SearchValue);
            }
            $this->design_size->EditValue = HtmlEncode($this->design_size->AdvancedSearch->SearchValue);
            $this->design_size->PlaceHolder = RemoveHtml($this->design_size->caption());

            // buyer_uid
            $this->buyer_uid->setupEditAttributes();
            if (!$this->buyer_uid->Raw) {
                $this->buyer_uid->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_uid->AdvancedSearch->SearchValue);
            }
            $this->buyer_uid->EditValue = HtmlEncode($this->buyer_uid->AdvancedSearch->SearchValue);
            $this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

            // buyer_loc
            $this->buyer_loc->setupEditAttributes();
            if (!$this->buyer_loc->Raw) {
                $this->buyer_loc->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_loc->AdvancedSearch->SearchValue);
            }
            $this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->AdvancedSearch->SearchValue);
            $this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

            // order_date
            $this->order_date->setupEditAttributes();
            $this->order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->order_date->AdvancedSearch->SearchValue, $this->order_date->formatPattern()), $this->order_date->formatPattern()));
            $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

            // completed
            $this->completed->setupEditAttributes();
            $this->completed->EditValue = $this->completed->options(true);
            $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

            // category
            $this->category->setupEditAttributes();
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // pl_no
            $this->pl_no->setupEditAttributes();
            $this->pl_no->EditValue = $this->pl_no->AdvancedSearch->SearchValue;
            $this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());
            $this->pl_no->setupEditAttributes();
            $this->pl_no->EditValue2 = $this->pl_no->AdvancedSearch->SearchValue2;
            $this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

            // buyer_barcode
            $this->buyer_barcode->setupEditAttributes();
            if (!$this->buyer_barcode->Raw) {
                $this->buyer_barcode->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_barcode->AdvancedSearch->SearchValue);
            }
            $this->buyer_barcode->EditValue = HtmlEncode($this->buyer_barcode->AdvancedSearch->SearchValue);
            $this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());
        } elseif ($this->RowType == RowType::AGGREGATEINIT) { // Initialize aggregate row
                    $this->sqm->Total = 0; // Initialize total
        } elseif ($this->RowType == RowType::AGGREGATE) { // Aggregate row
            $this->sqm->CurrentValue = $this->sqm->Total;
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());
            $this->sqm->HrefValue = ""; // Clear href value
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckInteger($this->buyers_id->AdvancedSearch->SearchValue)) {
            $this->buyers_id->addErrorMessage($this->buyers_id->getErrorMessage(false));
        }
        if (!CheckInteger($this->design_size->AdvancedSearch->SearchValue)) {
            $this->design_size->addErrorMessage($this->design_size->getErrorMessage(false));
        }
        if (!CheckNumber($this->pl_no->AdvancedSearch->SearchValue)) {
            $this->pl_no->addErrorMessage($this->pl_no->getErrorMessage(false));
        }
        if (!CheckNumber($this->pl_no->AdvancedSearch->SearchValue2)) {
            $this->pl_no->addErrorMessage($this->pl_no->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->po->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->batch_no->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->weight->AdvancedSearch->load();
        $this->jc_no->AdvancedSearch->load();
        $this->process_c->AdvancedSearch->load();
        $this->process_d->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->buyers_id->AdvancedSearch->load();
        $this->despatch_week->AdvancedSearch->load();
        $this->cs->AdvancedSearch->load();
        $this->weaving_works->AdvancedSearch->load();
        $this->current_works->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->p_remarks->AdvancedSearch->load();
        $this->buyer_po->AdvancedSearch->load();
        $this->buyer_ref->AdvancedSearch->load();
        $this->design_size->AdvancedSearch->load();
        $this->buyer_uid->AdvancedSearch->load();
        $this->buyer_loc->AdvancedSearch->load();
        $this->order_date->AdvancedSearch->load();
        $this->completed->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->pl_no->AdvancedSearch->load();
        $this->pid->AdvancedSearch->load();
        $this->buyer_barcode->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fbarcode2list\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fbarcode2list\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fbarcode2list\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fbarcode2list" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fbarcode2srch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"barcode2\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"barcode2search\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"barcode2search\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Query builder button
        $item = &$this->SearchOptions->add("querybuilder");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-query-builder\" title=\"" . $Language->phrase("QueryBuilder", true) . "\" data-table=\"barcode2\" data-caption=\"" . $Language->phrase("QueryBuilder", true) . "\" data-ew-action=\"modal\" data-url=\"barcode2query\" data-btn=\"SearchBtn\">" . $Language->phrase("QueryBuilder", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-query-builder\" title=\"" . $Language->phrase("QueryBuilder", true) . "\" data-caption=\"" . $Language->phrase("QueryBuilder", true) . "\" href=\"barcode2query\">" . $Language->phrase("QueryBuilder", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fbarcode2srch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_batch_no":
                    break;
                case "x_process_c":
                    break;
                case "x_process_d":
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyers_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_despatch_week":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cs":
                    break;
                case "x_weaving_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_current_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_completed":
                    break;
                case "x_category":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered() {
    	// Example:
    	//$this->ListOptions->Items["new"]->Body = "xxx";
    	$us = User_Site();
    	IF ($us == 0)
    	{
    		$loc = "";
    	}
    	else
    	{
    		$loc = "&loc=$us";
    	}	
    			$this->ListOptions->Add("Print Prod. Order"); // Replace abclink with your name of the link
    			$this->ListOptions->Items["Print Prod. Order"]->Body ='<a href="printpo?poid=' . $this->po->CurrentValue . $loc .'&type=d6e4a9b6646c62fc48baa6dd6150d1f7&sp=s" data-bs-original-title ="Print Prod. Order"><i data-phrase="Print Prod. Order"  class="fa fa-print fa-2x ew-icon" ></i></a>';
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
