<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for barcode
 */
class Barcode2 extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $po;
    public $_barcode;
    public $batch_no;
    public $size_cm;
    public $sqm;
    public $sqm_a;
    public $weight;
    public $quantity;
    public $jc_no;
    public $process_c;
    public $process_d;
    public $status;
    public $buyers_id;
    public $despatch_week;
    public $cs;
    public $weaving_works;
    public $current_works;
    public $remarks;
    public $p_remarks;
    public $buyer_po;
    public $buyer_ref;
    public $design_size;
    public $buyer_uid;
    public $buyer_loc;
    public $order_date;
    public $completed;
    public $category;
    public $pl_no;
    public $design_id;
    public $operator;
    public $datetime;
    public $process;
    public $id;
    public $pid;
    public $shape;
    public $production_plan;
    public $_2srm;
    public $_4srm;
    public $RefID;
    public $buyer_tid;
    public $grp;
    public $s_grp;
    public $product_type;
    public $w_cm;
    public $l_cm;
    public $_2srm_a;
    public $_4srm_a;
    public $buyer_barcode;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "barcode2";
        $this->TableName = 'barcode';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "barcode";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // barcode
        $this->_barcode = new DbField(
            $this, // Table
            'x__barcode', // Variable name
            'barcode', // Name
            '`barcode`', // Expression
            '`barcode`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_barcode->addMethod("getDefault", fn() => 0);
        $this->_barcode->InputTextType = "text";
        $this->_barcode->Raw = true;
        $this->_barcode->Nullable = false; // NOT NULL field
        $this->_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['barcode'] = &$this->_barcode;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__batch_no', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Raw = true;
        $this->batch_no->setSelectMultiple(false); // Select one
        $this->batch_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->batch_no->Lookup = new Lookup($this->batch_no, 'batch_no', false, 'id', ["batch_no","","",""], '', '', [], [], [], [], [], [], false, '`description` ASC', '', "`batch_no`");
        $this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->batch_no->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // size_cm
        $this->size_cm = new DbField(
            $this, // Table
            'x_size_cm', // Variable name
            'size_cm', // Name
            '`size_cm`', // Expression
            '`size_cm`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_cm->InputTextType = "text";
        $this->size_cm->Nullable = false; // NOT NULL field
        $this->size_cm->Required = true; // Required field
        $this->size_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['size_cm'] = &$this->size_cm;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->Nullable = false; // NOT NULL field
        $this->sqm->Required = true; // Required field
        $this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['sqm'] = &$this->sqm;

        // sqm_a
        $this->sqm_a = new DbField(
            $this, // Table
            'x_sqm_a', // Variable name
            'sqm_a', // Name
            '`sqm_a`', // Expression
            '`sqm_a`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm_a->InputTextType = "text";
        $this->sqm_a->Raw = true;
        $this->sqm_a->Nullable = false; // NOT NULL field
        $this->sqm_a->Required = true; // Required field
        $this->sqm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['sqm_a'] = &$this->sqm_a;

        // weight
        $this->weight = new DbField(
            $this, // Table
            'x_weight', // Variable name
            'weight', // Name
            '`weight`', // Expression
            '`weight`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->weight->InputTextType = "text";
        $this->weight->Raw = true;
        $this->weight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->weight->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['weight'] = &$this->weight;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Sortable = false; // Allow sort
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity'] = &$this->quantity;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->InputTextType = "text";
        $this->jc_no->Raw = true;
        $this->jc_no->Nullable = false; // NOT NULL field
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // process_c
        $this->process_c = new DbField(
            $this, // Table
            'x_process_c', // Variable name
            'process_c', // Name
            '`process_c`', // Expression
            '`process_c`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_c`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process_c->InputTextType = "text";
        $this->process_c->setSelectMultiple(true); // Select multiple
        $this->process_c->Lookup = new Lookup($this->process_c, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process_c->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['process_c'] = &$this->process_c;

        // process_d
        $this->process_d = new DbField(
            $this, // Table
            'x_process_d', // Variable name
            'process_d', // Name
            '`process_d`', // Expression
            '`process_d`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_d`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process_d->InputTextType = "text";
        $this->process_d->setSelectMultiple(true); // Select multiple
        $this->process_d->Lookup = new Lookup($this->process_d, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process_d->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['process_d'] = &$this->process_d;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getSelectFilter", fn() => "`grp`=1001 and `status` = 1");
        $this->status->addMethod("getDefault", fn() => 0);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'status', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`item`");
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // buyers_id
        $this->buyers_id = new DbField(
            $this, // Table
            'x_buyers_id', // Variable name
            'buyers_id', // Name
            '`buyers_id`', // Expression
            '`buyers_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyers_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyers_id->addMethod("getSelectFilter", fn() => "length(code)>0");
        $this->buyers_id->InputTextType = "text";
        $this->buyers_id->Raw = true;
        $this->buyers_id->Sortable = false; // Allow sort
        $this->buyers_id->Lookup = new Lookup($this->buyers_id, 'buyer_seller_view', true, 'id', ["code","","",""], '', '', [], ["x_buyer_ref"], [], [], [], [], false, '`code` ASC', '', "`code`");
        $this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyers_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyers_id'] = &$this->buyers_id;

        // despatch_week
        $this->despatch_week = new DbField(
            $this, // Table
            'x_despatch_week', // Variable name
            'despatch_week', // Name
            '`despatch_week`', // Expression
            '`despatch_week`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`despatch_week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->despatch_week->addMethod("getSelectFilter", fn() => "`id` >= DATE_FORMAT(NOW(), '%y%u')");
        $this->despatch_week->InputTextType = "text";
        $this->despatch_week->Raw = true;
        $this->despatch_week->setSelectMultiple(false); // Select one
        $this->despatch_week->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->despatch_week->Lookup = new Lookup($this->despatch_week, 'not_week', false, 'id', ["week","wed","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`week`, ''),'" . ValueSeparator(1, $this->despatch_week) . "',COALESCE(`wed`,''))");
        $this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->despatch_week->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['despatch_week'] = &$this->despatch_week;

        // cs
        $this->cs = new DbField(
            $this, // Table
            'x_cs', // Variable name
            'cs', // Name
            '`cs`', // Expression
            '`cs`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cs`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->cs->addMethod("getDefault", fn() => 0);
        $this->cs->InputTextType = "text";
        $this->cs->Raw = true;
        $this->cs->Nullable = false; // NOT NULL field
        $this->cs->setSelectMultiple(false); // Select one
        $this->cs->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->cs->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->cs->Lookup = new Lookup($this->cs, 'barcode2', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->cs->OptionCount = 2;
        $this->cs->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->cs->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['cs'] = &$this->cs;

        // weaving_works
        $this->weaving_works = new DbField(
            $this, // Table
            'x_weaving_works', // Variable name
            'weaving_works', // Name
            '`weaving_works`', // Expression
            '`weaving_works`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weaving_works`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->weaving_works->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->weaving_works->addMethod("getDefault", fn() => 0);
        $this->weaving_works->InputTextType = "text";
        $this->weaving_works->Raw = true;
        $this->weaving_works->Nullable = false; // NOT NULL field
        $this->weaving_works->setSelectMultiple(false); // Select one
        $this->weaving_works->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->weaving_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->weaving_works->Lookup = new Lookup($this->weaving_works, 'godown_table', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`name`");
        $this->weaving_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->weaving_works->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['weaving_works'] = &$this->weaving_works;

        // current_works
        $this->current_works = new DbField(
            $this, // Table
            'x_current_works', // Variable name
            'current_works', // Name
            '`current_works`', // Expression
            '`current_works`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`current_works`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->current_works->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->current_works->addMethod("getDefault", fn() => 0);
        $this->current_works->InputTextType = "text";
        $this->current_works->Raw = true;
        $this->current_works->Nullable = false; // NOT NULL field
        $this->current_works->setSelectMultiple(false); // Select one
        $this->current_works->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->current_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->current_works->Lookup = new Lookup($this->current_works, 'godown_table', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->current_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->current_works->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['current_works'] = &$this->current_works;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // p_remarks
        $this->p_remarks = new DbField(
            $this, // Table
            'x_p_remarks', // Variable name
            'p_remarks', // Name
            '`p_remarks`', // Expression
            '`p_remarks`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p_remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->p_remarks->addMethod("getViewCustomAttributes", fn() => 'onclick="ew.modalDialogShow({btn:\'SaveBtn\',url:\'bcodepremarksedit/'.$this->id->CurrentValue.'\'});"  style="color:blue"');
        $this->p_remarks->addMethod("getDefault", fn() => "--NA--");
        $this->p_remarks->InputTextType = "text";
        $this->p_remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['p_remarks'] = &$this->p_remarks;

        // buyer_po
        $this->buyer_po = new DbField(
            $this, // Table
            'x_buyer_po', // Variable name
            'buyer_po', // Name
            '`buyer_po`', // Expression
            '`buyer_po`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_po->InputTextType = "text";
        $this->buyer_po->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_po'] = &$this->buyer_po;

        // buyer_ref
        $this->buyer_ref = new DbField(
            $this, // Table
            'x_buyer_ref', // Variable name
            'buyer_ref', // Name
            '`buyer_ref`', // Expression
            '`buyer_ref`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_ref->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->buyer_ref->InputTextType = "text";
        $this->buyer_ref->Raw = true;
        $this->buyer_ref->Lookup = new Lookup($this->buyer_ref, 'partner_product_ref', false, 'id', ["partner_ref","barcode","",""], '', '', ["x_buyers_id"], [], ["partner"], ["x_partner"], [], [], false, '`partner_ref` ASC', '', "CONCAT(COALESCE(`partner_ref`, ''),'" . ValueSeparator(1, $this->buyer_ref) . "',COALESCE(`barcode`,''))");
        $this->buyer_ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_ref'] = &$this->buyer_ref;

        // design_size
        $this->design_size = new DbField(
            $this, // Table
            'x_design_size', // Variable name
            'design_size', // Name
            '`design_size`', // Expression
            '`design_size`', // Basic search expression
            200, // Type
            243, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design_size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design_size->InputTextType = "text";
        $this->design_size->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->design_size->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['design_size'] = &$this->design_size;

        // buyer_uid
        $this->buyer_uid = new DbField(
            $this, // Table
            'x_buyer_uid', // Variable name
            'buyer_uid', // Name
            '`buyer_uid`', // Expression
            '`buyer_uid`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_uid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_uid->InputTextType = "text";
        $this->buyer_uid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_uid'] = &$this->buyer_uid;

        // buyer_loc
        $this->buyer_loc = new DbField(
            $this, // Table
            'x_buyer_loc', // Variable name
            'buyer_loc', // Name
            '`buyer_loc`', // Expression
            '`buyer_loc`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_loc`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_loc->addMethod("getDefault", fn() => "0");
        $this->buyer_loc->InputTextType = "text";
        $this->buyer_loc->Nullable = false; // NOT NULL field
        $this->buyer_loc->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['buyer_loc'] = &$this->buyer_loc;

        // order_date
        $this->order_date = new DbField(
            $this, // Table
            'x_order_date', // Variable name
            'order_date', // Name
            '`order_date`', // Expression
            CastDateFieldForLike("`order_date`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`order_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->order_date->InputTextType = "text";
        $this->order_date->Raw = true;
        $this->order_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->order_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['order_date'] = &$this->order_date;

        // completed
        $this->completed = new DbField(
            $this, // Table
            'x_completed', // Variable name
            'completed', // Name
            '`completed`', // Expression
            '`completed`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`completed`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->completed->addMethod("getDefault", fn() => 0);
        $this->completed->InputTextType = "text";
        $this->completed->Raw = true;
        $this->completed->setSelectMultiple(false); // Select one
        $this->completed->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->completed->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->completed->Lookup = new Lookup($this->completed, 'barcode2', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->completed->OptionCount = 2;
        $this->completed->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->completed->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['completed'] = &$this->completed;

        // category
        $this->category = new DbField(
            $this, // Table
            'x_category', // Variable name
            'category', // Name
            '`category`', // Expression
            '`category`', // Basic search expression
            200, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->category->InputTextType = "text";
        $this->category->Nullable = false; // NOT NULL field
        $this->category->Required = true; // Required field
        $this->category->setSelectMultiple(false); // Select one
        $this->category->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->category->Lookup = new Lookup($this->category, 'product_category', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->category->SearchOperators = ["=", "<>"];
        $this->Fields['category'] = &$this->category;

        // pl_no
        $this->pl_no = new DbField(
            $this, // Table
            'x_pl_no', // Variable name
            'pl_no', // Name
            '`pl_no`', // Expression
            '`pl_no`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pl_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pl_no->addMethod("getDefault", fn() => 0.00);
        $this->pl_no->InputTextType = "text";
        $this->pl_no->Raw = true;
        $this->pl_no->Nullable = false; // NOT NULL field
        $this->pl_no->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pl_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['pl_no'] = &$this->pl_no;

        // design_id
        $this->design_id = new DbField(
            $this, // Table
            'x_design_id', // Variable name
            'design_id', // Name
            '`design_id`', // Expression
            '`design_id`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design_id->InputTextType = "text";
        $this->design_id->Sortable = false; // Allow sort
        $this->design_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->design_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['design_id'] = &$this->design_id;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->Sortable = false; // Allow sort
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Sortable = false; // Allow sort
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->process->InputTextType = "text";
        $this->process->Sortable = false; // Allow sort
        $this->process->setSelectMultiple(true); // Select multiple
        $this->process->Lookup = new Lookup($this->process, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['process'] = &$this->process;

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->Sortable = false; // Allow sort
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // pid
        $this->pid = new DbField(
            $this, // Table
            'x_pid', // Variable name
            'pid', // Name
            '`pid`', // Expression
            '`pid`', // Basic search expression
            131, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pid->InputTextType = "text";
        $this->pid->Raw = true;
        $this->pid->Sortable = false; // Allow sort
        $this->pid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['pid'] = &$this->pid;

        // shape
        $this->shape = new DbField(
            $this, // Table
            'x_shape', // Variable name
            'shape', // Name
            '`shape`', // Expression
            '`shape`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shape`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->shape->InputTextType = "text";
        $this->shape->Raw = true;
        $this->shape->Nullable = false; // NOT NULL field
        $this->shape->Required = true; // Required field
        $this->shape->Sortable = false; // Allow sort
        $this->shape->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->shape->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['shape'] = &$this->shape;

        // production_plan
        $this->production_plan = new DbField(
            $this, // Table
            'x_production_plan', // Variable name
            'production_plan', // Name
            '`production_plan`', // Expression
            '`production_plan`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`production_plan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->production_plan->InputTextType = "text";
        $this->production_plan->Raw = true;
        $this->production_plan->Sortable = false; // Allow sort
        $this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->production_plan->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['production_plan'] = &$this->production_plan;

        // 2srm
        $this->_2srm = new DbField(
            $this, // Table
            'x__2srm', // Variable name
            '2srm', // Name
            '`2srm`', // Expression
            '`2srm`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`2srm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_2srm->InputTextType = "text";
        $this->_2srm->Raw = true;
        $this->_2srm->Nullable = false; // NOT NULL field
        $this->_2srm->Required = true; // Required field
        $this->_2srm->Sortable = false; // Allow sort
        $this->_2srm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_2srm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['2srm'] = &$this->_2srm;

        // 4srm
        $this->_4srm = new DbField(
            $this, // Table
            'x__4srm', // Variable name
            '4srm', // Name
            '`4srm`', // Expression
            '`4srm`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`4srm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_4srm->InputTextType = "text";
        $this->_4srm->Raw = true;
        $this->_4srm->Nullable = false; // NOT NULL field
        $this->_4srm->Required = true; // Required field
        $this->_4srm->Sortable = false; // Allow sort
        $this->_4srm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_4srm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['4srm'] = &$this->_4srm;

        // RefID
        $this->RefID = new DbField(
            $this, // Table
            'x_RefID', // Variable name
            'RefID', // Name
            '`RefID`', // Expression
            '`RefID`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`RefID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->RefID->InputTextType = "text";
        $this->RefID->Sortable = false; // Allow sort
        $this->RefID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->RefID->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['RefID'] = &$this->RefID;

        // buyer_tid
        $this->buyer_tid = new DbField(
            $this, // Table
            'x_buyer_tid', // Variable name
            'buyer_tid', // Name
            '`buyer_tid`', // Expression
            '`buyer_tid`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_tid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_tid->InputTextType = "text";
        $this->buyer_tid->Sortable = false; // Allow sort
        $this->buyer_tid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_tid'] = &$this->buyer_tid;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Sortable = false; // Allow sort
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Sortable = false; // Allow sort
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // product_type
        $this->product_type = new DbField(
            $this, // Table
            'x_product_type', // Variable name
            'product_type', // Name
            '`product_type`', // Expression
            '`product_type`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_type->InputTextType = "text";
        $this->product_type->Raw = true;
        $this->product_type->Nullable = false; // NOT NULL field
        $this->product_type->Required = true; // Required field
        $this->product_type->Sortable = false; // Allow sort
        $this->product_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product_type->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['product_type'] = &$this->product_type;

        // w_cm
        $this->w_cm = new DbField(
            $this, // Table
            'x_w_cm', // Variable name
            'w_cm', // Name
            '`w_cm`', // Expression
            '`w_cm`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`w_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->w_cm->InputTextType = "text";
        $this->w_cm->Raw = true;
        $this->w_cm->Sortable = false; // Allow sort
        $this->w_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->w_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['w_cm'] = &$this->w_cm;

        // l_cm
        $this->l_cm = new DbField(
            $this, // Table
            'x_l_cm', // Variable name
            'l_cm', // Name
            '`l_cm`', // Expression
            '`l_cm`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`l_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->l_cm->InputTextType = "text";
        $this->l_cm->Raw = true;
        $this->l_cm->Sortable = false; // Allow sort
        $this->l_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->l_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['l_cm'] = &$this->l_cm;

        // 2srm_a
        $this->_2srm_a = new DbField(
            $this, // Table
            'x__2srm_a', // Variable name
            '2srm_a', // Name
            '`2srm_a`', // Expression
            '`2srm_a`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`2srm_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_2srm_a->InputTextType = "text";
        $this->_2srm_a->Raw = true;
        $this->_2srm_a->Nullable = false; // NOT NULL field
        $this->_2srm_a->Required = true; // Required field
        $this->_2srm_a->Sortable = false; // Allow sort
        $this->_2srm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_2srm_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['2srm_a'] = &$this->_2srm_a;

        // 4srm_a
        $this->_4srm_a = new DbField(
            $this, // Table
            'x__4srm_a', // Variable name
            '4srm_a', // Name
            '`4srm_a`', // Expression
            '`4srm_a`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`4srm_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_4srm_a->InputTextType = "text";
        $this->_4srm_a->Raw = true;
        $this->_4srm_a->Nullable = false; // NOT NULL field
        $this->_4srm_a->Required = true; // Required field
        $this->_4srm_a->Sortable = false; // Allow sort
        $this->_4srm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_4srm_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['4srm_a'] = &$this->_4srm_a;

        // buyer_barcode
        $this->buyer_barcode = new DbField(
            $this, // Table
            'x_buyer_barcode', // Variable name
            'buyer_barcode', // Name
            '`buyer_barcode`', // Expression
            '`buyer_barcode`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_barcode->InputTextType = "text";
        $this->buyer_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_barcode'] = &$this->buyer_barcode;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "barcode";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT `batch_no` FROM batch_no TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = barcode.batch_no LIMIT 1) AS EV__batch_no FROM barcode)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (User_Site() == 0)? "" : "FIND_IN_SET(`weaving_works`, " . User_Site() . ")";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->batch_no->AdvancedSearch->SearchValue != "" ||
            $this->batch_no->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->batch_no->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->batch_no->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->po->DbValue = $row['po'];
        $this->_barcode->DbValue = $row['barcode'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->size_cm->DbValue = $row['size_cm'];
        $this->sqm->DbValue = $row['sqm'];
        $this->sqm_a->DbValue = $row['sqm_a'];
        $this->weight->DbValue = $row['weight'];
        $this->quantity->DbValue = $row['quantity'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->process_c->DbValue = $row['process_c'];
        $this->process_d->DbValue = $row['process_d'];
        $this->status->DbValue = $row['status'];
        $this->buyers_id->DbValue = $row['buyers_id'];
        $this->despatch_week->DbValue = $row['despatch_week'];
        $this->cs->DbValue = $row['cs'];
        $this->weaving_works->DbValue = $row['weaving_works'];
        $this->current_works->DbValue = $row['current_works'];
        $this->remarks->DbValue = $row['remarks'];
        $this->p_remarks->DbValue = $row['p_remarks'];
        $this->buyer_po->DbValue = $row['buyer_po'];
        $this->buyer_ref->DbValue = $row['buyer_ref'];
        $this->design_size->DbValue = $row['design_size'];
        $this->buyer_uid->DbValue = $row['buyer_uid'];
        $this->buyer_loc->DbValue = $row['buyer_loc'];
        $this->order_date->DbValue = $row['order_date'];
        $this->completed->DbValue = $row['completed'];
        $this->category->DbValue = $row['category'];
        $this->pl_no->DbValue = $row['pl_no'];
        $this->design_id->DbValue = $row['design_id'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->process->DbValue = $row['process'];
        $this->id->DbValue = $row['id'];
        $this->pid->DbValue = $row['pid'];
        $this->shape->DbValue = $row['shape'];
        $this->production_plan->DbValue = $row['production_plan'];
        $this->_2srm->DbValue = $row['2srm'];
        $this->_4srm->DbValue = $row['4srm'];
        $this->RefID->DbValue = $row['RefID'];
        $this->buyer_tid->DbValue = $row['buyer_tid'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->product_type->DbValue = $row['product_type'];
        $this->w_cm->DbValue = $row['w_cm'];
        $this->l_cm->DbValue = $row['l_cm'];
        $this->_2srm_a->DbValue = $row['2srm_a'];
        $this->_4srm_a->DbValue = $row['4srm_a'];
        $this->buyer_barcode->DbValue = $row['buyer_barcode'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("barcode2list");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "barcode2view" => $Language->phrase("View"),
            "barcode2edit" => $Language->phrase("Edit"),
            "barcode2add" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "barcode2list";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "Barcode2View",
            Config("API_ADD_ACTION") => "Barcode2Add",
            Config("API_EDIT_ACTION") => "Barcode2Edit",
            Config("API_DELETE_ACTION") => "Barcode2Delete",
            Config("API_LIST_ACTION") => "Barcode2List",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "barcode2list";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("barcode2view", $parm);
        } else {
            $url = $this->keyUrl("barcode2view", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "barcode2add?" . $parm;
        } else {
            $url = "barcode2add";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("barcode2edit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("barcode2list", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("barcode2add", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("barcode2list", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("barcode2delete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->po->setDbValue($row['po']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->weight->setDbValue($row['weight']);
        $this->quantity->setDbValue($row['quantity']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->process_c->setDbValue($row['process_c']);
        $this->process_d->setDbValue($row['process_d']);
        $this->status->setDbValue($row['status']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->cs->setDbValue($row['cs']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->current_works->setDbValue($row['current_works']);
        $this->remarks->setDbValue($row['remarks']);
        $this->p_remarks->setDbValue($row['p_remarks']);
        $this->buyer_po->setDbValue($row['buyer_po']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        $this->design_size->setDbValue($row['design_size']);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->order_date->setDbValue($row['order_date']);
        $this->completed->setDbValue($row['completed']);
        $this->category->setDbValue($row['category']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->design_id->setDbValue($row['design_id']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->process->setDbValue($row['process']);
        $this->id->setDbValue($row['id']);
        $this->pid->setDbValue($row['pid']);
        $this->shape->setDbValue($row['shape']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->_2srm->setDbValue($row['2srm']);
        $this->_4srm->setDbValue($row['4srm']);
        $this->RefID->setDbValue($row['RefID']);
        $this->buyer_tid->setDbValue($row['buyer_tid']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product_type->setDbValue($row['product_type']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->_2srm_a->setDbValue($row['2srm_a']);
        $this->_4srm_a->setDbValue($row['4srm_a']);
        $this->buyer_barcode->setDbValue($row['buyer_barcode']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "Barcode2List";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // po

        // barcode

        // batch_no

        // size_cm
        $this->size_cm->CellCssStyle = "white-space: nowrap;";

        // sqm

        // sqm_a
        $this->sqm_a->CellCssStyle = "white-space: nowrap;";

        // weight

        // quantity
        $this->quantity->CellCssStyle = "white-space: nowrap;";

        // jc_no

        // process_c

        // process_d

        // status

        // buyers_id
        $this->buyers_id->CellCssStyle = "white-space: nowrap;";

        // despatch_week

        // cs

        // weaving_works

        // current_works

        // remarks

        // p_remarks

        // buyer_po

        // buyer_ref

        // design_size

        // buyer_uid

        // buyer_loc

        // order_date

        // completed

        // category
        $this->category->CellCssStyle = "white-space: nowrap;";

        // pl_no

        // design_id
        $this->design_id->CellCssStyle = "white-space: nowrap;";

        // operator
        $this->operator->CellCssStyle = "white-space: nowrap;";

        // datetime
        $this->datetime->CellCssStyle = "white-space: nowrap;";

        // process
        $this->process->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->CellCssStyle = "white-space: nowrap;";

        // pid
        $this->pid->CellCssStyle = "white-space: nowrap;";

        // shape
        $this->shape->CellCssStyle = "white-space: nowrap;";

        // production_plan
        $this->production_plan->CellCssStyle = "white-space: nowrap;";

        // 2srm
        $this->_2srm->CellCssStyle = "white-space: nowrap;";

        // 4srm
        $this->_4srm->CellCssStyle = "white-space: nowrap;";

        // RefID
        $this->RefID->CellCssStyle = "white-space: nowrap;";

        // buyer_tid
        $this->buyer_tid->CellCssStyle = "white-space: nowrap;";

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // product_type
        $this->product_type->CellCssStyle = "white-space: nowrap;";

        // w_cm
        $this->w_cm->CellCssStyle = "white-space: nowrap;";

        // l_cm
        $this->l_cm->CellCssStyle = "white-space: nowrap;";

        // 2srm_a
        $this->_2srm_a->CellCssStyle = "white-space: nowrap;";

        // 4srm_a
        $this->_4srm_a->CellCssStyle = "white-space: nowrap;";

        // buyer_barcode

        // po
        $this->po->ViewValue = $this->po->CurrentValue;
        $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

        // barcode
        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

        // batch_no
        if ($this->batch_no->VirtualValue != "") {
            $this->batch_no->ViewValue = $this->batch_no->VirtualValue;
        } else {
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }
        }

        // size_cm
        $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // sqm_a
        $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
        $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

        // weight
        $this->weight->ViewValue = $this->weight->CurrentValue;
        $this->weight->ViewValue = FormatNumber($this->weight->ViewValue, $this->weight->formatPattern());

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
        $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

        // process_c
        $curVal = strval($this->process_c->CurrentValue);
        if ($curVal != "") {
            $this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
            if ($this->process_c->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->process_c->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_c->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->process_c->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process_c->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process_c->Lookup->renderViewRow($row);
                        $this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
                    }
                } else {
                    $this->process_c->ViewValue = $this->process_c->CurrentValue;
                }
            }
        } else {
            $this->process_c->ViewValue = null;
        }

        // process_d
        $curVal = strval($this->process_d->CurrentValue);
        if ($curVal != "") {
            $this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
            if ($this->process_d->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->process_d->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_d->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->process_d->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process_d->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process_d->Lookup->renderViewRow($row);
                        $this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
                    }
                } else {
                    $this->process_d->ViewValue = $this->process_d->CurrentValue;
                }
            }
        } else {
            $this->process_d->ViewValue = null;
        }

        // status
        $curVal = strval($this->status->CurrentValue);
        if ($curVal != "") {
            $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
            if ($this->status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                    $this->status->ViewValue = $this->status->displayValue($arwrk);
                } else {
                    $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                }
            }
        } else {
            $this->status->ViewValue = null;
        }

        // buyers_id
        $this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
        $curVal = strval($this->buyers_id->CurrentValue);
        if ($curVal != "") {
            $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            if ($this->buyers_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                } else {
                    $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                }
            }
        } else {
            $this->buyers_id->ViewValue = null;
        }

        // despatch_week
        $curVal = strval($this->despatch_week->CurrentValue);
        if ($curVal != "") {
            $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            if ($this->despatch_week->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->despatch_week->getSelectFilter($this); // PHP
                $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                    $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                } else {
                    $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                }
            }
        } else {
            $this->despatch_week->ViewValue = null;
        }

        // cs
        if (strval($this->cs->CurrentValue) != "") {
            $this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
        } else {
            $this->cs->ViewValue = null;
        }

        // weaving_works
        $curVal = strval($this->weaving_works->CurrentValue);
        if ($curVal != "") {
            $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
            if ($this->weaving_works->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                    $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                } else {
                    $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                }
            }
        } else {
            $this->weaving_works->ViewValue = null;
        }

        // current_works
        $curVal = strval($this->current_works->CurrentValue);
        if ($curVal != "") {
            $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
            if ($this->current_works->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                    $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                } else {
                    $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                }
            }
        } else {
            $this->current_works->ViewValue = null;
        }

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // p_remarks
        $this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;
        $this->p_remarks->ViewCustomAttributes = $this->p_remarks->getViewCustomAttributes(); // PHP

        // buyer_po
        $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

        // buyer_ref
        $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
        $curVal = strval($this->buyer_ref->CurrentValue);
        if ($curVal != "") {
            $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
            if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyer_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                } else {
                    $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                }
            }
        } else {
            $this->buyer_ref->ViewValue = null;
        }

        // design_size
        $this->design_size->ViewValue = $this->design_size->CurrentValue;

        // buyer_uid
        $this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;

        // buyer_loc
        $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

        // order_date
        $this->order_date->ViewValue = $this->order_date->CurrentValue;
        $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

        // completed
        if (strval($this->completed->CurrentValue) != "") {
            $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
        } else {
            $this->completed->ViewValue = null;
        }

        // category
        $curVal = strval($this->category->CurrentValue);
        if ($curVal != "") {
            $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            if ($this->category->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                    $this->category->ViewValue = $this->category->displayValue($arwrk);
                } else {
                    $this->category->ViewValue = $this->category->CurrentValue;
                }
            }
        } else {
            $this->category->ViewValue = null;
        }

        // pl_no
        $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
        $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

        // design_id
        $this->design_id->ViewValue = $this->design_id->CurrentValue;

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process->Lookup->renderViewRow($row);
                        $this->process->ViewValue->add($this->process->displayValue($arwrk));
                    }
                } else {
                    $this->process->ViewValue = $this->process->CurrentValue;
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // pid
        $this->pid->ViewValue = $this->pid->CurrentValue;
        $this->pid->ViewValue = FormatNumber($this->pid->ViewValue, $this->pid->formatPattern());

        // shape
        $this->shape->ViewValue = $this->shape->CurrentValue;
        $this->shape->ViewValue = FormatNumber($this->shape->ViewValue, $this->shape->formatPattern());

        // production_plan
        $this->production_plan->ViewValue = $this->production_plan->CurrentValue;
        $this->production_plan->ViewValue = FormatNumber($this->production_plan->ViewValue, $this->production_plan->formatPattern());

        // 2srm
        $this->_2srm->ViewValue = $this->_2srm->CurrentValue;
        $this->_2srm->ViewValue = FormatNumber($this->_2srm->ViewValue, $this->_2srm->formatPattern());

        // 4srm
        $this->_4srm->ViewValue = $this->_4srm->CurrentValue;
        $this->_4srm->ViewValue = FormatNumber($this->_4srm->ViewValue, $this->_4srm->formatPattern());

        // RefID
        $this->RefID->ViewValue = $this->RefID->CurrentValue;

        // buyer_tid
        $this->buyer_tid->ViewValue = $this->buyer_tid->CurrentValue;

        // grp
        $this->grp->ViewValue = $this->grp->CurrentValue;
        $this->grp->ViewValue = FormatNumber($this->grp->ViewValue, $this->grp->formatPattern());

        // s_grp
        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
        $this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, $this->s_grp->formatPattern());

        // product_type
        $this->product_type->ViewValue = $this->product_type->CurrentValue;
        $this->product_type->ViewValue = FormatNumber($this->product_type->ViewValue, $this->product_type->formatPattern());

        // w_cm
        $this->w_cm->ViewValue = $this->w_cm->CurrentValue;
        $this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, $this->w_cm->formatPattern());

        // l_cm
        $this->l_cm->ViewValue = $this->l_cm->CurrentValue;
        $this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, $this->l_cm->formatPattern());

        // 2srm_a
        $this->_2srm_a->ViewValue = $this->_2srm_a->CurrentValue;
        $this->_2srm_a->ViewValue = FormatNumber($this->_2srm_a->ViewValue, $this->_2srm_a->formatPattern());

        // 4srm_a
        $this->_4srm_a->ViewValue = $this->_4srm_a->CurrentValue;
        $this->_4srm_a->ViewValue = FormatNumber($this->_4srm_a->ViewValue, $this->_4srm_a->formatPattern());

        // buyer_barcode
        $this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;

        // po
        $this->po->HrefValue = "";
        $this->po->TooltipValue = "";

        // barcode
        $this->_barcode->HrefValue = "";
        $this->_barcode->TooltipValue = "";

        // batch_no
        $this->batch_no->HrefValue = "";
        $this->batch_no->TooltipValue = "";

        // size_cm
        $this->size_cm->HrefValue = "";
        $this->size_cm->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // sqm_a
        $this->sqm_a->HrefValue = "";
        $this->sqm_a->TooltipValue = "";

        // weight
        $this->weight->HrefValue = "";
        $this->weight->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // process_c
        $this->process_c->HrefValue = "";
        $this->process_c->TooltipValue = "";

        // process_d
        $this->process_d->HrefValue = "";
        $this->process_d->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // buyers_id
        $this->buyers_id->HrefValue = "";
        $this->buyers_id->TooltipValue = "";

        // despatch_week
        $this->despatch_week->HrefValue = "";
        $this->despatch_week->TooltipValue = "";

        // cs
        $this->cs->HrefValue = "";
        $this->cs->TooltipValue = "";

        // weaving_works
        $this->weaving_works->HrefValue = "";
        $this->weaving_works->TooltipValue = "";

        // current_works
        $this->current_works->HrefValue = "";
        $this->current_works->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // p_remarks
        $this->p_remarks->HrefValue = "";
        $this->p_remarks->TooltipValue = "";

        // buyer_po
        $this->buyer_po->HrefValue = "";
        $this->buyer_po->TooltipValue = "";

        // buyer_ref
        $this->buyer_ref->HrefValue = "";
        $this->buyer_ref->TooltipValue = "";

        // design_size
        $this->design_size->HrefValue = "";
        $this->design_size->TooltipValue = "";

        // buyer_uid
        $this->buyer_uid->HrefValue = "";
        $this->buyer_uid->TooltipValue = "";

        // buyer_loc
        $this->buyer_loc->HrefValue = "";
        $this->buyer_loc->TooltipValue = "";

        // order_date
        $this->order_date->HrefValue = "";
        $this->order_date->TooltipValue = "";

        // completed
        $this->completed->HrefValue = "";
        $this->completed->TooltipValue = "";

        // category
        $this->category->HrefValue = "";
        $this->category->TooltipValue = "";

        // pl_no
        $this->pl_no->HrefValue = "";
        $this->pl_no->TooltipValue = "";

        // design_id
        $this->design_id->HrefValue = "";
        $this->design_id->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // process
        $this->process->HrefValue = "";
        $this->process->TooltipValue = "";

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // pid
        $this->pid->HrefValue = "";
        $this->pid->TooltipValue = "";

        // shape
        $this->shape->HrefValue = "";
        $this->shape->TooltipValue = "";

        // production_plan
        $this->production_plan->HrefValue = "";
        $this->production_plan->TooltipValue = "";

        // 2srm
        $this->_2srm->HrefValue = "";
        $this->_2srm->TooltipValue = "";

        // 4srm
        $this->_4srm->HrefValue = "";
        $this->_4srm->TooltipValue = "";

        // RefID
        $this->RefID->HrefValue = "";
        $this->RefID->TooltipValue = "";

        // buyer_tid
        $this->buyer_tid->HrefValue = "";
        $this->buyer_tid->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // s_grp
        $this->s_grp->HrefValue = "";
        $this->s_grp->TooltipValue = "";

        // product_type
        $this->product_type->HrefValue = "";
        $this->product_type->TooltipValue = "";

        // w_cm
        $this->w_cm->HrefValue = "";
        $this->w_cm->TooltipValue = "";

        // l_cm
        $this->l_cm->HrefValue = "";
        $this->l_cm->TooltipValue = "";

        // 2srm_a
        $this->_2srm_a->HrefValue = "";
        $this->_2srm_a->TooltipValue = "";

        // 4srm_a
        $this->_4srm_a->HrefValue = "";
        $this->_4srm_a->TooltipValue = "";

        // buyer_barcode
        $this->buyer_barcode->HrefValue = "";
        $this->buyer_barcode->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;
        $this->po->PlaceHolder = RemoveHtml($this->po->caption());
        if (strval($this->po->EditValue) != "" && is_numeric($this->po->EditValue)) {
            $this->po->EditValue = FormatNumber($this->po->EditValue, null);
        }

        // barcode
        $this->_barcode->setupEditAttributes();
        $this->_barcode->EditValue = $this->_barcode->CurrentValue;
        $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
        if (strval($this->_barcode->EditValue) != "" && is_numeric($this->_barcode->EditValue)) {
            $this->_barcode->EditValue = $this->_barcode->EditValue;
        }

        // batch_no
        $this->batch_no->setupEditAttributes();
        $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

        // size_cm
        $this->size_cm->setupEditAttributes();
        if (!$this->size_cm->Raw) {
            $this->size_cm->CurrentValue = HtmlDecode($this->size_cm->CurrentValue);
        }
        $this->size_cm->EditValue = $this->size_cm->CurrentValue;
        $this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
        if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
        }

        // sqm_a
        $this->sqm_a->setupEditAttributes();
        $this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
        $this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
        if (strval($this->sqm_a->EditValue) != "" && is_numeric($this->sqm_a->EditValue)) {
            $this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, null);
        }

        // weight
        $this->weight->setupEditAttributes();
        $this->weight->EditValue = $this->weight->CurrentValue;
        $this->weight->PlaceHolder = RemoveHtml($this->weight->caption());
        if (strval($this->weight->EditValue) != "" && is_numeric($this->weight->EditValue)) {
            $this->weight->EditValue = FormatNumber($this->weight->EditValue, null);
        }

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // jc_no
        $this->jc_no->setupEditAttributes();
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;
        $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
        if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
            $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
        }

        // process_c
        $this->process_c->setupEditAttributes();
        $this->process_c->PlaceHolder = RemoveHtml($this->process_c->caption());

        // process_d
        $this->process_d->setupEditAttributes();
        $this->process_d->PlaceHolder = RemoveHtml($this->process_d->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // buyers_id
        $this->buyers_id->setupEditAttributes();
        $this->buyers_id->EditValue = $this->buyers_id->CurrentValue;
        $this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

        // despatch_week
        $this->despatch_week->setupEditAttributes();
        $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

        // cs
        $this->cs->setupEditAttributes();
        $this->cs->EditValue = $this->cs->options(true);
        $this->cs->PlaceHolder = RemoveHtml($this->cs->caption());

        // weaving_works
        $this->weaving_works->setupEditAttributes();
        $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

        // current_works
        $this->current_works->setupEditAttributes();
        $curVal = strval($this->current_works->CurrentValue);
        if ($curVal != "") {
            $this->current_works->EditValue = $this->current_works->lookupCacheOption($curVal);
            if ($this->current_works->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                    $this->current_works->EditValue = $this->current_works->displayValue($arwrk);
                } else {
                    $this->current_works->EditValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                }
            }
        } else {
            $this->current_works->EditValue = null;
        }

        // remarks
        $this->remarks->setupEditAttributes();
        if (!$this->remarks->Raw) {
            $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
        }
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // p_remarks
        $this->p_remarks->setupEditAttributes();
        if (!$this->p_remarks->Raw) {
            $this->p_remarks->CurrentValue = HtmlDecode($this->p_remarks->CurrentValue);
        }
        $this->p_remarks->EditValue = $this->p_remarks->CurrentValue;
        $this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

        // buyer_po
        $this->buyer_po->setupEditAttributes();
        if (!$this->buyer_po->Raw) {
            $this->buyer_po->CurrentValue = HtmlDecode($this->buyer_po->CurrentValue);
        }
        $this->buyer_po->EditValue = $this->buyer_po->CurrentValue;
        $this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

        // buyer_ref
        $this->buyer_ref->setupEditAttributes();
        $this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
        $this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

        // design_size
        $this->design_size->setupEditAttributes();
        if (!$this->design_size->Raw) {
            $this->design_size->CurrentValue = HtmlDecode($this->design_size->CurrentValue);
        }
        $this->design_size->EditValue = $this->design_size->CurrentValue;
        $this->design_size->PlaceHolder = RemoveHtml($this->design_size->caption());

        // buyer_uid
        $this->buyer_uid->setupEditAttributes();
        if (!$this->buyer_uid->Raw) {
            $this->buyer_uid->CurrentValue = HtmlDecode($this->buyer_uid->CurrentValue);
        }
        $this->buyer_uid->EditValue = $this->buyer_uid->CurrentValue;
        $this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

        // buyer_loc
        $this->buyer_loc->setupEditAttributes();
        if (!$this->buyer_loc->Raw) {
            $this->buyer_loc->CurrentValue = HtmlDecode($this->buyer_loc->CurrentValue);
        }
        $this->buyer_loc->EditValue = $this->buyer_loc->CurrentValue;
        $this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

        // order_date
        $this->order_date->setupEditAttributes();
        $this->order_date->EditValue = FormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern());
        $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

        // completed
        $this->completed->setupEditAttributes();
        $this->completed->EditValue = $this->completed->options(true);
        $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

        // category
        $this->category->setupEditAttributes();
        $this->category->PlaceHolder = RemoveHtml($this->category->caption());

        // pl_no
        $this->pl_no->setupEditAttributes();
        $this->pl_no->EditValue = $this->pl_no->CurrentValue;
        $this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());
        if (strval($this->pl_no->EditValue) != "" && is_numeric($this->pl_no->EditValue)) {
            $this->pl_no->EditValue = FormatNumber($this->pl_no->EditValue, null);
        }

        // design_id
        $this->design_id->setupEditAttributes();
        if (!$this->design_id->Raw) {
            $this->design_id->CurrentValue = HtmlDecode($this->design_id->CurrentValue);
        }
        $this->design_id->EditValue = $this->design_id->CurrentValue;
        $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

        // operator

        // datetime

        // process
        $this->process->setupEditAttributes();
        $this->process->PlaceHolder = RemoveHtml($this->process->caption());

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());

        // pid
        $this->pid->setupEditAttributes();
        $this->pid->EditValue = $this->pid->CurrentValue;
        $this->pid->PlaceHolder = RemoveHtml($this->pid->caption());
        if (strval($this->pid->EditValue) != "" && is_numeric($this->pid->EditValue)) {
            $this->pid->EditValue = FormatNumber($this->pid->EditValue, null);
        }

        // shape
        $this->shape->setupEditAttributes();
        $this->shape->EditValue = $this->shape->CurrentValue;
        $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());
        if (strval($this->shape->EditValue) != "" && is_numeric($this->shape->EditValue)) {
            $this->shape->EditValue = FormatNumber($this->shape->EditValue, null);
        }

        // production_plan
        $this->production_plan->setupEditAttributes();
        $this->production_plan->EditValue = $this->production_plan->CurrentValue;
        $this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());
        if (strval($this->production_plan->EditValue) != "" && is_numeric($this->production_plan->EditValue)) {
            $this->production_plan->EditValue = FormatNumber($this->production_plan->EditValue, null);
        }

        // 2srm
        $this->_2srm->setupEditAttributes();
        $this->_2srm->EditValue = $this->_2srm->CurrentValue;
        $this->_2srm->PlaceHolder = RemoveHtml($this->_2srm->caption());
        if (strval($this->_2srm->EditValue) != "" && is_numeric($this->_2srm->EditValue)) {
            $this->_2srm->EditValue = FormatNumber($this->_2srm->EditValue, null);
        }

        // 4srm
        $this->_4srm->setupEditAttributes();
        $this->_4srm->EditValue = $this->_4srm->CurrentValue;
        $this->_4srm->PlaceHolder = RemoveHtml($this->_4srm->caption());
        if (strval($this->_4srm->EditValue) != "" && is_numeric($this->_4srm->EditValue)) {
            $this->_4srm->EditValue = FormatNumber($this->_4srm->EditValue, null);
        }

        // RefID
        $this->RefID->setupEditAttributes();
        if (!$this->RefID->Raw) {
            $this->RefID->CurrentValue = HtmlDecode($this->RefID->CurrentValue);
        }
        $this->RefID->EditValue = $this->RefID->CurrentValue;
        $this->RefID->PlaceHolder = RemoveHtml($this->RefID->caption());

        // buyer_tid
        $this->buyer_tid->setupEditAttributes();
        if (!$this->buyer_tid->Raw) {
            $this->buyer_tid->CurrentValue = HtmlDecode($this->buyer_tid->CurrentValue);
        }
        $this->buyer_tid->EditValue = $this->buyer_tid->CurrentValue;
        $this->buyer_tid->PlaceHolder = RemoveHtml($this->buyer_tid->caption());

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->EditValue = $this->grp->CurrentValue;
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());
        if (strval($this->grp->EditValue) != "" && is_numeric($this->grp->EditValue)) {
            $this->grp->EditValue = FormatNumber($this->grp->EditValue, null);
        }

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->EditValue = $this->s_grp->CurrentValue;
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());
        if (strval($this->s_grp->EditValue) != "" && is_numeric($this->s_grp->EditValue)) {
            $this->s_grp->EditValue = FormatNumber($this->s_grp->EditValue, null);
        }

        // product_type
        $this->product_type->setupEditAttributes();
        $this->product_type->EditValue = $this->product_type->CurrentValue;
        $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());
        if (strval($this->product_type->EditValue) != "" && is_numeric($this->product_type->EditValue)) {
            $this->product_type->EditValue = FormatNumber($this->product_type->EditValue, null);
        }

        // w_cm
        $this->w_cm->setupEditAttributes();
        $this->w_cm->EditValue = $this->w_cm->CurrentValue;
        $this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());
        if (strval($this->w_cm->EditValue) != "" && is_numeric($this->w_cm->EditValue)) {
            $this->w_cm->EditValue = FormatNumber($this->w_cm->EditValue, null);
        }

        // l_cm
        $this->l_cm->setupEditAttributes();
        $this->l_cm->EditValue = $this->l_cm->CurrentValue;
        $this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());
        if (strval($this->l_cm->EditValue) != "" && is_numeric($this->l_cm->EditValue)) {
            $this->l_cm->EditValue = FormatNumber($this->l_cm->EditValue, null);
        }

        // 2srm_a
        $this->_2srm_a->setupEditAttributes();
        $this->_2srm_a->EditValue = $this->_2srm_a->CurrentValue;
        $this->_2srm_a->PlaceHolder = RemoveHtml($this->_2srm_a->caption());
        if (strval($this->_2srm_a->EditValue) != "" && is_numeric($this->_2srm_a->EditValue)) {
            $this->_2srm_a->EditValue = FormatNumber($this->_2srm_a->EditValue, null);
        }

        // 4srm_a
        $this->_4srm_a->setupEditAttributes();
        $this->_4srm_a->EditValue = $this->_4srm_a->CurrentValue;
        $this->_4srm_a->PlaceHolder = RemoveHtml($this->_4srm_a->caption());
        if (strval($this->_4srm_a->EditValue) != "" && is_numeric($this->_4srm_a->EditValue)) {
            $this->_4srm_a->EditValue = FormatNumber($this->_4srm_a->EditValue, null);
        }

        // buyer_barcode
        $this->buyer_barcode->setupEditAttributes();
        if (!$this->buyer_barcode->Raw) {
            $this->buyer_barcode->CurrentValue = HtmlDecode($this->buyer_barcode->CurrentValue);
        }
        $this->buyer_barcode->EditValue = $this->buyer_barcode->CurrentValue;
        $this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->sqm->CurrentValue)) {
                $this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->sqm->CurrentValue = $this->sqm->Total;
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());
            $this->sqm->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->weight);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->process_c);
                    $doc->exportCaption($this->process_d);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->cs);
                    $doc->exportCaption($this->weaving_works);
                    $doc->exportCaption($this->current_works);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->p_remarks);
                    $doc->exportCaption($this->buyer_po);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->design_size);
                    $doc->exportCaption($this->buyer_uid);
                    $doc->exportCaption($this->buyer_loc);
                    $doc->exportCaption($this->order_date);
                    $doc->exportCaption($this->completed);
                    $doc->exportCaption($this->pl_no);
                    $doc->exportCaption($this->buyer_barcode);
                } else {
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->sqm_a);
                    $doc->exportCaption($this->weight);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->process_c);
                    $doc->exportCaption($this->process_d);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->cs);
                    $doc->exportCaption($this->weaving_works);
                    $doc->exportCaption($this->current_works);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->p_remarks);
                    $doc->exportCaption($this->buyer_po);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->design_size);
                    $doc->exportCaption($this->buyer_uid);
                    $doc->exportCaption($this->buyer_loc);
                    $doc->exportCaption($this->order_date);
                    $doc->exportCaption($this->completed);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->pl_no);
                    $doc->exportCaption($this->buyer_barcode);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->po);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->weight);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->process_c);
                        $doc->exportField($this->process_d);
                        $doc->exportField($this->status);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->cs);
                        $doc->exportField($this->weaving_works);
                        $doc->exportField($this->current_works);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->p_remarks);
                        $doc->exportField($this->buyer_po);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->design_size);
                        $doc->exportField($this->buyer_uid);
                        $doc->exportField($this->buyer_loc);
                        $doc->exportField($this->order_date);
                        $doc->exportField($this->completed);
                        $doc->exportField($this->pl_no);
                        $doc->exportField($this->buyer_barcode);
                    } else {
                        $doc->exportField($this->po);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->sqm_a);
                        $doc->exportField($this->weight);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->process_c);
                        $doc->exportField($this->process_d);
                        $doc->exportField($this->status);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->cs);
                        $doc->exportField($this->weaving_works);
                        $doc->exportField($this->current_works);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->p_remarks);
                        $doc->exportField($this->buyer_po);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->design_size);
                        $doc->exportField($this->buyer_uid);
                        $doc->exportField($this->buyer_loc);
                        $doc->exportField($this->order_date);
                        $doc->exportField($this->completed);
                        $doc->exportField($this->category);
                        $doc->exportField($this->pl_no);
                        $doc->exportField($this->buyer_barcode);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->po, '');
                $doc->exportAggregate($this->_barcode, '');
                $doc->exportAggregate($this->batch_no, '');
                $doc->exportAggregate($this->size_cm, '');
                $doc->exportAggregate($this->sqm, 'TOTAL');
                $doc->exportAggregate($this->sqm_a, '');
                $doc->exportAggregate($this->weight, '');
                $doc->exportAggregate($this->quantity, '');
                $doc->exportAggregate($this->jc_no, '');
                $doc->exportAggregate($this->process_c, '');
                $doc->exportAggregate($this->process_d, '');
                $doc->exportAggregate($this->status, '');
                $doc->exportAggregate($this->buyers_id, '');
                $doc->exportAggregate($this->despatch_week, '');
                $doc->exportAggregate($this->cs, '');
                $doc->exportAggregate($this->weaving_works, '');
                $doc->exportAggregate($this->current_works, '');
                $doc->exportAggregate($this->remarks, '');
                $doc->exportAggregate($this->p_remarks, '');
                $doc->exportAggregate($this->buyer_po, '');
                $doc->exportAggregate($this->buyer_ref, '');
                $doc->exportAggregate($this->design_size, '');
                $doc->exportAggregate($this->buyer_uid, '');
                $doc->exportAggregate($this->buyer_loc, '');
                $doc->exportAggregate($this->order_date, '');
                $doc->exportAggregate($this->completed, '');
                $doc->exportAggregate($this->category, '');
                $doc->exportAggregate($this->pl_no, '');
                $doc->exportAggregate($this->buyer_barcode, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
