<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BankInfoAdd extends BankInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BankInfoAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "bankinfoadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->grp->Visible = false;
        $this->user_id->setVisibility();
        $this->account_holder_name->setVisibility();
        $this->currency->setVisibility();
        $this->bank_name->setVisibility();
        $this->account_no->setVisibility();
        $this->c_account_no->setVisibility();
        $this->address->setVisibility();
        $this->ifsc->setVisibility();
        $this->swift->setVisibility();
        $this->ad->setVisibility();
        $this->routing->setVisibility();
        $this->routing_swift->setVisibility();
        $this->nostro_account->setVisibility();
        $this->upi->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'bank_info';
        $this->TableName = 'bank_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (bank_info)
        if (!isset($GLOBALS["bank_info"]) || $GLOBALS["bank_info"]::class == PROJECT_NAMESPACE . "bank_info") {
            $GLOBALS["bank_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'bank_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "bankinfoview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->user_id);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Set up master/detail parameters
        // NOTE: Must be after loadOldRecord to prevent master key values being overwritten
        $this->setupMasterParms();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("bankinfolist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "bankinfolist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "bankinfoview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions && !$this->getCurrentMasterTable()) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "bankinfolist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "bankinfolist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'user_id' first before field var 'x_user_id'
        $val = $CurrentForm->hasValue("user_id") ? $CurrentForm->getValue("user_id") : $CurrentForm->getValue("x_user_id");
        if (!$this->user_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->user_id->Visible = false; // Disable update for API request
            } else {
                $this->user_id->setFormValue($val);
            }
        }

        // Check field name 'account_holder_name' first before field var 'x_account_holder_name'
        $val = $CurrentForm->hasValue("account_holder_name") ? $CurrentForm->getValue("account_holder_name") : $CurrentForm->getValue("x_account_holder_name");
        if (!$this->account_holder_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->account_holder_name->Visible = false; // Disable update for API request
            } else {
                $this->account_holder_name->setFormValue($val);
            }
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val);
            }
        }

        // Check field name 'bank_name' first before field var 'x_bank_name'
        $val = $CurrentForm->hasValue("bank_name") ? $CurrentForm->getValue("bank_name") : $CurrentForm->getValue("x_bank_name");
        if (!$this->bank_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_name->Visible = false; // Disable update for API request
            } else {
                $this->bank_name->setFormValue($val);
            }
        }

        // Check field name 'account_no' first before field var 'x_account_no'
        $val = $CurrentForm->hasValue("account_no") ? $CurrentForm->getValue("account_no") : $CurrentForm->getValue("x_account_no");
        if (!$this->account_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->account_no->Visible = false; // Disable update for API request
            } else {
                $this->account_no->setFormValue($val);
            }
        }

        // Check field name 'c_account_no' first before field var 'x_c_account_no'
        $val = $CurrentForm->hasValue("c_account_no") ? $CurrentForm->getValue("c_account_no") : $CurrentForm->getValue("x_c_account_no");
        if (!$this->c_account_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->c_account_no->Visible = false; // Disable update for API request
            } else {
                $this->c_account_no->setFormValue($val);
            }
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }

        // Check field name 'ifsc' first before field var 'x_ifsc'
        $val = $CurrentForm->hasValue("ifsc") ? $CurrentForm->getValue("ifsc") : $CurrentForm->getValue("x_ifsc");
        if (!$this->ifsc->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ifsc->Visible = false; // Disable update for API request
            } else {
                $this->ifsc->setFormValue($val);
            }
        }

        // Check field name 'swift' first before field var 'x_swift'
        $val = $CurrentForm->hasValue("swift") ? $CurrentForm->getValue("swift") : $CurrentForm->getValue("x_swift");
        if (!$this->swift->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->swift->Visible = false; // Disable update for API request
            } else {
                $this->swift->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ad' first before field var 'x_ad'
        $val = $CurrentForm->hasValue("ad") ? $CurrentForm->getValue("ad") : $CurrentForm->getValue("x_ad");
        if (!$this->ad->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ad->Visible = false; // Disable update for API request
            } else {
                $this->ad->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'routing' first before field var 'x_routing'
        $val = $CurrentForm->hasValue("routing") ? $CurrentForm->getValue("routing") : $CurrentForm->getValue("x_routing");
        if (!$this->routing->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->routing->Visible = false; // Disable update for API request
            } else {
                $this->routing->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'routing_swift' first before field var 'x_routing_swift'
        $val = $CurrentForm->hasValue("routing_swift") ? $CurrentForm->getValue("routing_swift") : $CurrentForm->getValue("x_routing_swift");
        if (!$this->routing_swift->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->routing_swift->Visible = false; // Disable update for API request
            } else {
                $this->routing_swift->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'nostro_account' first before field var 'x_nostro_account'
        $val = $CurrentForm->hasValue("nostro_account") ? $CurrentForm->getValue("nostro_account") : $CurrentForm->getValue("x_nostro_account");
        if (!$this->nostro_account->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->nostro_account->Visible = false; // Disable update for API request
            } else {
                $this->nostro_account->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'upi' first before field var 'x_upi'
        $val = $CurrentForm->hasValue("upi") ? $CurrentForm->getValue("upi") : $CurrentForm->getValue("x_upi");
        if (!$this->upi->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->upi->Visible = false; // Disable update for API request
            } else {
                $this->upi->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->user_id->CurrentValue = $this->user_id->FormValue;
        $this->account_holder_name->CurrentValue = $this->account_holder_name->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->bank_name->CurrentValue = $this->bank_name->FormValue;
        $this->account_no->CurrentValue = $this->account_no->FormValue;
        $this->c_account_no->CurrentValue = $this->c_account_no->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->ifsc->CurrentValue = $this->ifsc->FormValue;
        $this->swift->CurrentValue = $this->swift->FormValue;
        $this->ad->CurrentValue = $this->ad->FormValue;
        $this->routing->CurrentValue = $this->routing->FormValue;
        $this->routing_swift->CurrentValue = $this->routing_swift->FormValue;
        $this->nostro_account->CurrentValue = $this->nostro_account->FormValue;
        $this->upi->CurrentValue = $this->upi->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->user_id->setDbValue($row['user_id']);
        $this->account_holder_name->setDbValue($row['account_holder_name']);
        $this->currency->setDbValue($row['currency']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->account_no->setDbValue($row['account_no']);
        $this->c_account_no->setDbValue($row['c_account_no']);
        $this->address->setDbValue($row['address']);
        $this->ifsc->setDbValue($row['ifsc']);
        $this->swift->setDbValue($row['swift']);
        $this->ad->setDbValue($row['ad']);
        $this->routing->setDbValue($row['routing']);
        $this->routing_swift->setDbValue($row['routing_swift']);
        $this->nostro_account->setDbValue($row['nostro_account']);
        $this->upi->setDbValue($row['upi']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['user_id'] = $this->user_id->DefaultValue;
        $row['account_holder_name'] = $this->account_holder_name->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['bank_name'] = $this->bank_name->DefaultValue;
        $row['account_no'] = $this->account_no->DefaultValue;
        $row['c_account_no'] = $this->c_account_no->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['ifsc'] = $this->ifsc->DefaultValue;
        $row['swift'] = $this->swift->DefaultValue;
        $row['ad'] = $this->ad->DefaultValue;
        $row['routing'] = $this->routing->DefaultValue;
        $row['routing_swift'] = $this->routing_swift->DefaultValue;
        $row['nostro_account'] = $this->nostro_account->DefaultValue;
        $row['upi'] = $this->upi->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // user_id
        $this->user_id->RowCssClass = "row";

        // account_holder_name
        $this->account_holder_name->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // bank_name
        $this->bank_name->RowCssClass = "row";

        // account_no
        $this->account_no->RowCssClass = "row";

        // c_account_no
        $this->c_account_no->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // ifsc
        $this->ifsc->RowCssClass = "row";

        // swift
        $this->swift->RowCssClass = "row";

        // ad
        $this->ad->RowCssClass = "row";

        // routing
        $this->routing->RowCssClass = "row";

        // routing_swift
        $this->routing_swift->RowCssClass = "row";

        // nostro_account
        $this->nostro_account->RowCssClass = "row";

        // upi
        $this->upi->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // user_id
            $curVal = strval($this->user_id->CurrentValue);
            if ($curVal != "") {
                $this->user_id->ViewValue = $this->user_id->lookupCacheOption($curVal);
                if ($this->user_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->user_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->user_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->user_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->user_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->user_id->Lookup->renderViewRow($rswrk[0]);
                        $this->user_id->ViewValue = $this->user_id->displayValue($arwrk);
                    } else {
                        $this->user_id->ViewValue = FormatNumber($this->user_id->CurrentValue, $this->user_id->formatPattern());
                    }
                }
            } else {
                $this->user_id->ViewValue = null;
            }

            // account_holder_name
            $this->account_holder_name->ViewValue = $this->account_holder_name->CurrentValue;

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // account_no
            $this->account_no->ViewValue = $Language->phrase("PasswordMask");

            // c_account_no
            $this->c_account_no->ViewValue = $this->c_account_no->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // ifsc
            $this->ifsc->ViewValue = $this->ifsc->CurrentValue;

            // swift
            $this->swift->ViewValue = $this->swift->CurrentValue;

            // ad
            $this->ad->ViewValue = $this->ad->CurrentValue;

            // routing
            $this->routing->ViewValue = $this->routing->CurrentValue;

            // routing_swift
            $this->routing_swift->ViewValue = $this->routing_swift->CurrentValue;

            // nostro_account
            $this->nostro_account->ViewValue = $this->nostro_account->CurrentValue;

            // upi
            $this->upi->ViewValue = $this->upi->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // user_id
            $this->user_id->HrefValue = "";

            // account_holder_name
            $this->account_holder_name->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";

            // account_no
            $this->account_no->HrefValue = "";

            // c_account_no
            $this->c_account_no->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // ifsc
            $this->ifsc->HrefValue = "";

            // swift
            $this->swift->HrefValue = "";

            // ad
            $this->ad->HrefValue = "";

            // routing
            $this->routing->HrefValue = "";

            // routing_swift
            $this->routing_swift->HrefValue = "";

            // nostro_account
            $this->nostro_account->HrefValue = "";

            // upi
            $this->upi->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // user_id
            $this->user_id->setupEditAttributes();
            if ($this->user_id->getSessionValue() != "") {
                $this->user_id->CurrentValue = GetForeignKeyValue($this->user_id->getSessionValue());
                $curVal = strval($this->user_id->CurrentValue);
                if ($curVal != "") {
                    $this->user_id->ViewValue = $this->user_id->lookupCacheOption($curVal);
                    if ($this->user_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->user_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->user_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $lookupFilter = $this->user_id->getSelectFilter($this); // PHP
                        $sqlWrk = $this->user_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->user_id->Lookup->renderViewRow($rswrk[0]);
                            $this->user_id->ViewValue = $this->user_id->displayValue($arwrk);
                        } else {
                            $this->user_id->ViewValue = FormatNumber($this->user_id->CurrentValue, $this->user_id->formatPattern());
                        }
                    }
                } else {
                    $this->user_id->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->user_id->CurrentValue));
                if ($curVal != "") {
                    $this->user_id->ViewValue = $this->user_id->lookupCacheOption($curVal);
                } else {
                    $this->user_id->ViewValue = $this->user_id->Lookup !== null && is_array($this->user_id->lookupOptions()) && count($this->user_id->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->user_id->ViewValue !== null) { // Load from cache
                    $this->user_id->EditValue = array_values($this->user_id->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->user_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->user_id->CurrentValue, $this->user_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->user_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->user_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->user_id->EditValue = $arwrk;
                }
                $this->user_id->PlaceHolder = RemoveHtml($this->user_id->caption());
            }

            // account_holder_name
            $this->account_holder_name->setupEditAttributes();
            if (!$this->account_holder_name->Raw) {
                $this->account_holder_name->CurrentValue = HtmlDecode($this->account_holder_name->CurrentValue);
            }
            $this->account_holder_name->EditValue = HtmlEncode($this->account_holder_name->CurrentValue);
            $this->account_holder_name->PlaceHolder = RemoveHtml($this->account_holder_name->caption());

            // currency
            $this->currency->setupEditAttributes();
            $curVal = trim(strval($this->currency->CurrentValue));
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->CurrentValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // bank_name
            $this->bank_name->setupEditAttributes();
            if (!$this->bank_name->Raw) {
                $this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
            }
            $this->bank_name->EditValue = HtmlEncode($this->bank_name->CurrentValue);
            $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

            // account_no
            $this->account_no->setupEditAttributes();
            $this->account_no->PlaceHolder = RemoveHtml($this->account_no->caption());

            // c_account_no
            $this->c_account_no->setupEditAttributes();
            if (!$this->c_account_no->Raw) {
                $this->c_account_no->CurrentValue = HtmlDecode($this->c_account_no->CurrentValue);
            }
            $this->c_account_no->EditValue = HtmlEncode($this->c_account_no->CurrentValue);
            $this->c_account_no->PlaceHolder = RemoveHtml($this->c_account_no->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // ifsc
            $this->ifsc->setupEditAttributes();
            if (!$this->ifsc->Raw) {
                $this->ifsc->CurrentValue = HtmlDecode($this->ifsc->CurrentValue);
            }
            $this->ifsc->EditValue = HtmlEncode($this->ifsc->CurrentValue);
            $this->ifsc->PlaceHolder = RemoveHtml($this->ifsc->caption());

            // swift
            $this->swift->setupEditAttributes();
            if (!$this->swift->Raw) {
                $this->swift->CurrentValue = HtmlDecode($this->swift->CurrentValue);
            }
            $this->swift->EditValue = HtmlEncode($this->swift->CurrentValue);
            $this->swift->PlaceHolder = RemoveHtml($this->swift->caption());

            // ad
            $this->ad->setupEditAttributes();
            if (!$this->ad->Raw) {
                $this->ad->CurrentValue = HtmlDecode($this->ad->CurrentValue);
            }
            $this->ad->EditValue = HtmlEncode($this->ad->CurrentValue);
            $this->ad->PlaceHolder = RemoveHtml($this->ad->caption());

            // routing
            $this->routing->setupEditAttributes();
            if (!$this->routing->Raw) {
                $this->routing->CurrentValue = HtmlDecode($this->routing->CurrentValue);
            }
            $this->routing->EditValue = HtmlEncode($this->routing->CurrentValue);
            $this->routing->PlaceHolder = RemoveHtml($this->routing->caption());

            // routing_swift
            $this->routing_swift->setupEditAttributes();
            if (!$this->routing_swift->Raw) {
                $this->routing_swift->CurrentValue = HtmlDecode($this->routing_swift->CurrentValue);
            }
            $this->routing_swift->EditValue = HtmlEncode($this->routing_swift->CurrentValue);
            $this->routing_swift->PlaceHolder = RemoveHtml($this->routing_swift->caption());

            // nostro_account
            $this->nostro_account->setupEditAttributes();
            if (!$this->nostro_account->Raw) {
                $this->nostro_account->CurrentValue = HtmlDecode($this->nostro_account->CurrentValue);
            }
            $this->nostro_account->EditValue = HtmlEncode($this->nostro_account->CurrentValue);
            $this->nostro_account->PlaceHolder = RemoveHtml($this->nostro_account->caption());

            // upi
            $this->upi->setupEditAttributes();
            if (!$this->upi->Raw) {
                $this->upi->CurrentValue = HtmlDecode($this->upi->CurrentValue);
            }
            $this->upi->EditValue = HtmlEncode($this->upi->CurrentValue);
            $this->upi->PlaceHolder = RemoveHtml($this->upi->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator

            // datetime

            // Add refer script

            // user_id
            $this->user_id->HrefValue = "";

            // account_holder_name
            $this->account_holder_name->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";

            // account_no
            $this->account_no->HrefValue = "";

            // c_account_no
            $this->c_account_no->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // ifsc
            $this->ifsc->HrefValue = "";

            // swift
            $this->swift->HrefValue = "";

            // ad
            $this->ad->HrefValue = "";

            // routing
            $this->routing->HrefValue = "";

            // routing_swift
            $this->routing_swift->HrefValue = "";

            // nostro_account
            $this->nostro_account->HrefValue = "";

            // upi
            $this->upi->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->user_id->Visible && $this->user_id->Required) {
                if (!$this->user_id->IsDetailKey && EmptyValue($this->user_id->FormValue)) {
                    $this->user_id->addErrorMessage(str_replace("%s", $this->user_id->caption(), $this->user_id->RequiredErrorMessage));
                }
            }
            if ($this->account_holder_name->Visible && $this->account_holder_name->Required) {
                if (!$this->account_holder_name->IsDetailKey && EmptyValue($this->account_holder_name->FormValue)) {
                    $this->account_holder_name->addErrorMessage(str_replace("%s", $this->account_holder_name->caption(), $this->account_holder_name->RequiredErrorMessage));
                }
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if ($this->bank_name->Visible && $this->bank_name->Required) {
                if (!$this->bank_name->IsDetailKey && EmptyValue($this->bank_name->FormValue)) {
                    $this->bank_name->addErrorMessage(str_replace("%s", $this->bank_name->caption(), $this->bank_name->RequiredErrorMessage));
                }
            }
            if ($this->account_no->Visible && $this->account_no->Required) {
                if (!$this->account_no->IsDetailKey && EmptyValue($this->account_no->FormValue)) {
                    $this->account_no->addErrorMessage(str_replace("%s", $this->account_no->caption(), $this->account_no->RequiredErrorMessage));
                }
            }
            if (!$this->account_no->Raw && Config("REMOVE_XSS") && CheckPassword($this->account_no->FormValue)) {
                $this->account_no->addErrorMessage($Language->phrase("InvalidPasswordChars"));
            }
            if ($this->c_account_no->Visible && $this->c_account_no->Required) {
                if (!$this->c_account_no->IsDetailKey && EmptyValue($this->c_account_no->FormValue)) {
                    $this->c_account_no->addErrorMessage(str_replace("%s", $this->c_account_no->caption(), $this->c_account_no->RequiredErrorMessage));
                }
            }
            if ($this->address->Visible && $this->address->Required) {
                if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->ifsc->Visible && $this->ifsc->Required) {
                if (!$this->ifsc->IsDetailKey && EmptyValue($this->ifsc->FormValue)) {
                    $this->ifsc->addErrorMessage(str_replace("%s", $this->ifsc->caption(), $this->ifsc->RequiredErrorMessage));
                }
            }
            if ($this->swift->Visible && $this->swift->Required) {
                if (!$this->swift->IsDetailKey && EmptyValue($this->swift->FormValue)) {
                    $this->swift->addErrorMessage(str_replace("%s", $this->swift->caption(), $this->swift->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->swift->FormValue)) {
                $this->swift->addErrorMessage($this->swift->getErrorMessage(false));
            }
            if ($this->ad->Visible && $this->ad->Required) {
                if (!$this->ad->IsDetailKey && EmptyValue($this->ad->FormValue)) {
                    $this->ad->addErrorMessage(str_replace("%s", $this->ad->caption(), $this->ad->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->ad->FormValue)) {
                $this->ad->addErrorMessage($this->ad->getErrorMessage(false));
            }
            if ($this->routing->Visible && $this->routing->Required) {
                if (!$this->routing->IsDetailKey && EmptyValue($this->routing->FormValue)) {
                    $this->routing->addErrorMessage(str_replace("%s", $this->routing->caption(), $this->routing->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->routing->FormValue)) {
                $this->routing->addErrorMessage($this->routing->getErrorMessage(false));
            }
            if ($this->routing_swift->Visible && $this->routing_swift->Required) {
                if (!$this->routing_swift->IsDetailKey && EmptyValue($this->routing_swift->FormValue)) {
                    $this->routing_swift->addErrorMessage(str_replace("%s", $this->routing_swift->caption(), $this->routing_swift->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->routing_swift->FormValue)) {
                $this->routing_swift->addErrorMessage($this->routing_swift->getErrorMessage(false));
            }
            if ($this->nostro_account->Visible && $this->nostro_account->Required) {
                if (!$this->nostro_account->IsDetailKey && EmptyValue($this->nostro_account->FormValue)) {
                    $this->nostro_account->addErrorMessage(str_replace("%s", $this->nostro_account->caption(), $this->nostro_account->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->nostro_account->FormValue)) {
                $this->nostro_account->addErrorMessage($this->nostro_account->getErrorMessage(false));
            }
            if ($this->upi->Visible && $this->upi->Required) {
                if (!$this->upi->IsDetailKey && EmptyValue($this->upi->FormValue)) {
                    $this->upi->addErrorMessage(str_replace("%s", $this->upi->caption(), $this->upi->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->account_no->CurrentValue != "") { // Check field with unique index
            $filter = "(`account_no` = '" . AdjustSql($this->account_no->CurrentValue, $this->Dbid) . "')";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->account_no->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->account_no->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // user_id
        $this->user_id->setDbValueDef($rsnew, $this->user_id->CurrentValue, false);

        // account_holder_name
        $this->account_holder_name->setDbValueDef($rsnew, $this->account_holder_name->CurrentValue, false);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, false);

        // bank_name
        $this->bank_name->setDbValueDef($rsnew, $this->bank_name->CurrentValue, false);

        // account_no
        if (!IsMaskedPassword($this->account_no->CurrentValue)) {
            $this->account_no->setDbValueDef($rsnew, $this->account_no->CurrentValue, false);
        }

        // c_account_no
        $this->c_account_no->setDbValueDef($rsnew, $this->c_account_no->CurrentValue, false);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, false);

        // ifsc
        $this->ifsc->setDbValueDef($rsnew, $this->ifsc->CurrentValue, false);

        // swift
        $this->swift->setDbValueDef($rsnew, $this->swift->CurrentValue, false);

        // ad
        $this->ad->setDbValueDef($rsnew, $this->ad->CurrentValue, false);

        // routing
        $this->routing->setDbValueDef($rsnew, $this->routing->CurrentValue, false);

        // routing_swift
        $this->routing_swift->setDbValueDef($rsnew, $this->routing_swift->CurrentValue, false);

        // nostro_account
        $this->nostro_account->setDbValueDef($rsnew, $this->nostro_account->CurrentValue, false);

        // upi
        $this->upi->setDbValueDef($rsnew, $this->upi->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['user_id'])) { // user_id
            $this->user_id->setFormValue($row['user_id']);
        }
        if (isset($row['account_holder_name'])) { // account_holder_name
            $this->account_holder_name->setFormValue($row['account_holder_name']);
        }
        if (isset($row['currency'])) { // currency
            $this->currency->setFormValue($row['currency']);
        }
        if (isset($row['bank_name'])) { // bank_name
            $this->bank_name->setFormValue($row['bank_name']);
        }
        if (isset($row['account_no'])) { // account_no
            $this->account_no->setFormValue($row['account_no']);
        }
        if (isset($row['c_account_no'])) { // c_account_no
            $this->c_account_no->setFormValue($row['c_account_no']);
        }
        if (isset($row['address'])) { // address
            $this->address->setFormValue($row['address']);
        }
        if (isset($row['ifsc'])) { // ifsc
            $this->ifsc->setFormValue($row['ifsc']);
        }
        if (isset($row['swift'])) { // swift
            $this->swift->setFormValue($row['swift']);
        }
        if (isset($row['ad'])) { // ad
            $this->ad->setFormValue($row['ad']);
        }
        if (isset($row['routing'])) { // routing
            $this->routing->setFormValue($row['routing']);
        }
        if (isset($row['routing_swift'])) { // routing_swift
            $this->routing_swift->setFormValue($row['routing_swift']);
        }
        if (isset($row['nostro_account'])) { // nostro_account
            $this->nostro_account->setFormValue($row['nostro_account']);
        }
        if (isset($row['upi'])) { // upi
            $this->upi->setFormValue($row['upi']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "production_partner") {
                $validMaster = true;
                $masterTbl = Container("production_partner");
                if (($parm = Get("fk_id", Get("user_id"))) !== null) {
                    $masterTbl->id->setQueryStringValue($parm);
                    $this->user_id->QueryStringValue = $masterTbl->id->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->user_id->setSessionValue($this->user_id->QueryStringValue);
                    $foreignKeys["user_id"] = $this->user_id->QueryStringValue;
                    if (!is_numeric($masterTbl->id->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "production_partner") {
                $validMaster = true;
                $masterTbl = Container("production_partner");
                if (($parm = Post("fk_id", Post("user_id"))) !== null) {
                    $masterTbl->id->setFormValue($parm);
                    $this->user_id->FormValue = $masterTbl->id->FormValue;
                    $this->user_id->setSessionValue($this->user_id->FormValue);
                    $foreignKeys["user_id"] = $this->user_id->FormValue;
                    if (!is_numeric($masterTbl->id->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "production_partner") {
                if (!array_key_exists("user_id", $foreignKeys)) { // Not current foreign key
                    $this->user_id->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bankinfolist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_user_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
