<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BIncentivePpAdd extends BIncentivePp
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BIncentivePpAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "bincentiveppadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->partner->setVisibility();
        $this->category->setVisibility();
        $this->type->setVisibility();
        $this->target_amount->setVisibility();
        $this->target_file->setVisibility();
        $this->file_inc->setVisibility();
        $this->neg_file_inc->setVisibility();
        $this->inc_min_amount->setVisibility();
        $this->inc_max_amount->setVisibility();
        $this->inc_percent->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'b_incentive_pp';
        $this->TableName = 'b_incentive_pp';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (b_incentive_pp)
        if (!isset($GLOBALS["b_incentive_pp"]) || $GLOBALS["b_incentive_pp"]::class == PROJECT_NAMESPACE . "b_incentive_pp") {
            $GLOBALS["b_incentive_pp"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_incentive_pp');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "bincentiveppview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->partner);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->type);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("bincentivepplist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "bincentivepplist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "bincentiveppview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "bincentivepplist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "bincentivepplist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->target_amount->DefaultValue = $this->target_amount->getDefault(); // PHP
        $this->target_amount->OldValue = $this->target_amount->DefaultValue;
        $this->target_file->DefaultValue = $this->target_file->getDefault(); // PHP
        $this->target_file->OldValue = $this->target_file->DefaultValue;
        $this->file_inc->DefaultValue = $this->file_inc->getDefault(); // PHP
        $this->file_inc->OldValue = $this->file_inc->DefaultValue;
        $this->neg_file_inc->DefaultValue = $this->neg_file_inc->getDefault(); // PHP
        $this->neg_file_inc->OldValue = $this->neg_file_inc->DefaultValue;
        $this->inc_min_amount->DefaultValue = $this->inc_min_amount->getDefault(); // PHP
        $this->inc_min_amount->OldValue = $this->inc_min_amount->DefaultValue;
        $this->inc_max_amount->DefaultValue = $this->inc_max_amount->getDefault(); // PHP
        $this->inc_max_amount->OldValue = $this->inc_max_amount->DefaultValue;
        $this->inc_percent->DefaultValue = $this->inc_percent->getDefault(); // PHP
        $this->inc_percent->OldValue = $this->inc_percent->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'partner' first before field var 'x_partner'
        $val = $CurrentForm->hasValue("partner") ? $CurrentForm->getValue("partner") : $CurrentForm->getValue("x_partner");
        if (!$this->partner->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner->Visible = false; // Disable update for API request
            } else {
                $this->partner->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'category' first before field var 'x_category'
        $val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
        if (!$this->category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->category->Visible = false; // Disable update for API request
            } else {
                $this->category->setFormValue($val);
            }
        }

        // Check field name 'type' first before field var 'x_type'
        $val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
        if (!$this->type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->type->Visible = false; // Disable update for API request
            } else {
                $this->type->setFormValue($val);
            }
        }

        // Check field name 'target_amount' first before field var 'x_target_amount'
        $val = $CurrentForm->hasValue("target_amount") ? $CurrentForm->getValue("target_amount") : $CurrentForm->getValue("x_target_amount");
        if (!$this->target_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->target_amount->Visible = false; // Disable update for API request
            } else {
                $this->target_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'target_file' first before field var 'x_target_file'
        $val = $CurrentForm->hasValue("target_file") ? $CurrentForm->getValue("target_file") : $CurrentForm->getValue("x_target_file");
        if (!$this->target_file->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->target_file->Visible = false; // Disable update for API request
            } else {
                $this->target_file->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'file_inc' first before field var 'x_file_inc'
        $val = $CurrentForm->hasValue("file_inc") ? $CurrentForm->getValue("file_inc") : $CurrentForm->getValue("x_file_inc");
        if (!$this->file_inc->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->file_inc->Visible = false; // Disable update for API request
            } else {
                $this->file_inc->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'neg_file_inc' first before field var 'x_neg_file_inc'
        $val = $CurrentForm->hasValue("neg_file_inc") ? $CurrentForm->getValue("neg_file_inc") : $CurrentForm->getValue("x_neg_file_inc");
        if (!$this->neg_file_inc->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->neg_file_inc->Visible = false; // Disable update for API request
            } else {
                $this->neg_file_inc->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'inc_min_amount' first before field var 'x_inc_min_amount'
        $val = $CurrentForm->hasValue("inc_min_amount") ? $CurrentForm->getValue("inc_min_amount") : $CurrentForm->getValue("x_inc_min_amount");
        if (!$this->inc_min_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->inc_min_amount->Visible = false; // Disable update for API request
            } else {
                $this->inc_min_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'inc_max_amount' first before field var 'x_inc_max_amount'
        $val = $CurrentForm->hasValue("inc_max_amount") ? $CurrentForm->getValue("inc_max_amount") : $CurrentForm->getValue("x_inc_max_amount");
        if (!$this->inc_max_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->inc_max_amount->Visible = false; // Disable update for API request
            } else {
                $this->inc_max_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'inc_percent' first before field var 'x_inc_percent'
        $val = $CurrentForm->hasValue("inc_percent") ? $CurrentForm->getValue("inc_percent") : $CurrentForm->getValue("x_inc_percent");
        if (!$this->inc_percent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->inc_percent->Visible = false; // Disable update for API request
            } else {
                $this->inc_percent->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->partner->CurrentValue = $this->partner->FormValue;
        $this->category->CurrentValue = $this->category->FormValue;
        $this->type->CurrentValue = $this->type->FormValue;
        $this->target_amount->CurrentValue = $this->target_amount->FormValue;
        $this->target_file->CurrentValue = $this->target_file->FormValue;
        $this->file_inc->CurrentValue = $this->file_inc->FormValue;
        $this->neg_file_inc->CurrentValue = $this->neg_file_inc->FormValue;
        $this->inc_min_amount->CurrentValue = $this->inc_min_amount->FormValue;
        $this->inc_max_amount->CurrentValue = $this->inc_max_amount->FormValue;
        $this->inc_percent->CurrentValue = $this->inc_percent->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->partner->setDbValue($row['partner']);
        $this->category->setDbValue($row['category']);
        $this->type->setDbValue($row['type']);
        $this->target_amount->setDbValue($row['target_amount']);
        $this->target_file->setDbValue($row['target_file']);
        $this->file_inc->setDbValue($row['file_inc']);
        $this->neg_file_inc->setDbValue($row['neg_file_inc']);
        $this->inc_min_amount->setDbValue($row['inc_min_amount']);
        $this->inc_max_amount->setDbValue($row['inc_max_amount']);
        $this->inc_percent->setDbValue($row['inc_percent']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['partner'] = $this->partner->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['target_amount'] = $this->target_amount->DefaultValue;
        $row['target_file'] = $this->target_file->DefaultValue;
        $row['file_inc'] = $this->file_inc->DefaultValue;
        $row['neg_file_inc'] = $this->neg_file_inc->DefaultValue;
        $row['inc_min_amount'] = $this->inc_min_amount->DefaultValue;
        $row['inc_max_amount'] = $this->inc_max_amount->DefaultValue;
        $row['inc_percent'] = $this->inc_percent->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // partner
        $this->partner->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // target_amount
        $this->target_amount->RowCssClass = "row";

        // target_file
        $this->target_file->RowCssClass = "row";

        // file_inc
        $this->file_inc->RowCssClass = "row";

        // neg_file_inc
        $this->neg_file_inc->RowCssClass = "row";

        // inc_min_amount
        $this->inc_min_amount->RowCssClass = "row";

        // inc_max_amount
        $this->inc_max_amount->RowCssClass = "row";

        // inc_percent
        $this->inc_percent->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // partner
            $this->partner->ViewValue = $this->partner->CurrentValue;
            $curVal = strval($this->partner->CurrentValue);
            if ($curVal != "") {
                $this->partner->ViewValue = $this->partner->lookupCacheOption($curVal);
                if ($this->partner->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner->Lookup->renderViewRow($rswrk[0]);
                        $this->partner->ViewValue = $this->partner->displayValue($arwrk);
                    } else {
                        $this->partner->ViewValue = FormatNumber($this->partner->CurrentValue, $this->partner->formatPattern());
                    }
                }
            } else {
                $this->partner->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // type
            $curVal = strval($this->type->CurrentValue);
            if ($curVal != "") {
                $this->type->ViewValue = $this->type->lookupCacheOption($curVal);
                if ($this->type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->type->Lookup->renderViewRow($rswrk[0]);
                        $this->type->ViewValue = $this->type->displayValue($arwrk);
                    } else {
                        $this->type->ViewValue = FormatNumber($this->type->CurrentValue, $this->type->formatPattern());
                    }
                }
            } else {
                $this->type->ViewValue = null;
            }

            // target_amount
            $this->target_amount->ViewValue = $this->target_amount->CurrentValue;
            $this->target_amount->ViewValue = FormatNumber($this->target_amount->ViewValue, $this->target_amount->formatPattern());

            // target_file
            $this->target_file->ViewValue = $this->target_file->CurrentValue;
            $this->target_file->ViewValue = FormatNumber($this->target_file->ViewValue, $this->target_file->formatPattern());

            // file_inc
            $this->file_inc->ViewValue = $this->file_inc->CurrentValue;
            $this->file_inc->ViewValue = FormatNumber($this->file_inc->ViewValue, $this->file_inc->formatPattern());

            // neg_file_inc
            $this->neg_file_inc->ViewValue = $this->neg_file_inc->CurrentValue;
            $this->neg_file_inc->ViewValue = FormatNumber($this->neg_file_inc->ViewValue, $this->neg_file_inc->formatPattern());

            // inc_min_amount
            $this->inc_min_amount->ViewValue = $this->inc_min_amount->CurrentValue;
            $this->inc_min_amount->ViewValue = FormatNumber($this->inc_min_amount->ViewValue, $this->inc_min_amount->formatPattern());

            // inc_max_amount
            $this->inc_max_amount->ViewValue = $this->inc_max_amount->CurrentValue;
            $this->inc_max_amount->ViewValue = FormatNumber($this->inc_max_amount->ViewValue, $this->inc_max_amount->formatPattern());

            // inc_percent
            $this->inc_percent->ViewValue = $this->inc_percent->CurrentValue;
            $this->inc_percent->ViewValue = FormatNumber($this->inc_percent->ViewValue, $this->inc_percent->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // partner
            $this->partner->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // type
            $this->type->HrefValue = "";

            // target_amount
            $this->target_amount->HrefValue = "";

            // target_file
            $this->target_file->HrefValue = "";

            // file_inc
            $this->file_inc->HrefValue = "";

            // neg_file_inc
            $this->neg_file_inc->HrefValue = "";

            // inc_min_amount
            $this->inc_min_amount->HrefValue = "";

            // inc_max_amount
            $this->inc_max_amount->HrefValue = "";

            // inc_percent
            $this->inc_percent->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // partner
            $this->partner->setupEditAttributes();
            $this->partner->EditValue = $this->partner->CurrentValue;
            $curVal = strval($this->partner->CurrentValue);
            if ($curVal != "") {
                $this->partner->EditValue = $this->partner->lookupCacheOption($curVal);
                if ($this->partner->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner->Lookup->renderViewRow($rswrk[0]);
                        $this->partner->EditValue = $this->partner->displayValue($arwrk);
                    } else {
                        $this->partner->EditValue = HtmlEncode(FormatNumber($this->partner->CurrentValue, $this->partner->formatPattern()));
                    }
                }
            } else {
                $this->partner->EditValue = null;
            }
            $this->partner->PlaceHolder = RemoveHtml($this->partner->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->CurrentValue));
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->CurrentValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // type
            $this->type->setupEditAttributes();
            $curVal = trim(strval($this->type->CurrentValue));
            if ($curVal != "") {
                $this->type->ViewValue = $this->type->lookupCacheOption($curVal);
            } else {
                $this->type->ViewValue = $this->type->Lookup !== null && is_array($this->type->lookupOptions()) && count($this->type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->type->ViewValue !== null) { // Load from cache
                $this->type->EditValue = array_values($this->type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->type->CurrentValue, $this->type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->type->getSelectFilter($this); // PHP
                $sqlWrk = $this->type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->type->EditValue = $arwrk;
            }
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());

            // target_amount
            $this->target_amount->setupEditAttributes();
            $this->target_amount->EditValue = $this->target_amount->CurrentValue;
            $this->target_amount->PlaceHolder = RemoveHtml($this->target_amount->caption());
            if (strval($this->target_amount->EditValue) != "" && is_numeric($this->target_amount->EditValue)) {
                $this->target_amount->EditValue = FormatNumber($this->target_amount->EditValue, null);
            }

            // target_file
            $this->target_file->setupEditAttributes();
            $this->target_file->EditValue = $this->target_file->CurrentValue;
            $this->target_file->PlaceHolder = RemoveHtml($this->target_file->caption());
            if (strval($this->target_file->EditValue) != "" && is_numeric($this->target_file->EditValue)) {
                $this->target_file->EditValue = FormatNumber($this->target_file->EditValue, null);
            }

            // file_inc
            $this->file_inc->setupEditAttributes();
            $this->file_inc->EditValue = $this->file_inc->CurrentValue;
            $this->file_inc->PlaceHolder = RemoveHtml($this->file_inc->caption());
            if (strval($this->file_inc->EditValue) != "" && is_numeric($this->file_inc->EditValue)) {
                $this->file_inc->EditValue = FormatNumber($this->file_inc->EditValue, null);
            }

            // neg_file_inc
            $this->neg_file_inc->setupEditAttributes();
            $this->neg_file_inc->EditValue = $this->neg_file_inc->CurrentValue;
            $this->neg_file_inc->PlaceHolder = RemoveHtml($this->neg_file_inc->caption());
            if (strval($this->neg_file_inc->EditValue) != "" && is_numeric($this->neg_file_inc->EditValue)) {
                $this->neg_file_inc->EditValue = FormatNumber($this->neg_file_inc->EditValue, null);
            }

            // inc_min_amount
            $this->inc_min_amount->setupEditAttributes();
            $this->inc_min_amount->EditValue = $this->inc_min_amount->CurrentValue;
            $this->inc_min_amount->PlaceHolder = RemoveHtml($this->inc_min_amount->caption());
            if (strval($this->inc_min_amount->EditValue) != "" && is_numeric($this->inc_min_amount->EditValue)) {
                $this->inc_min_amount->EditValue = FormatNumber($this->inc_min_amount->EditValue, null);
            }

            // inc_max_amount
            $this->inc_max_amount->setupEditAttributes();
            $this->inc_max_amount->EditValue = $this->inc_max_amount->CurrentValue;
            $this->inc_max_amount->PlaceHolder = RemoveHtml($this->inc_max_amount->caption());
            if (strval($this->inc_max_amount->EditValue) != "" && is_numeric($this->inc_max_amount->EditValue)) {
                $this->inc_max_amount->EditValue = FormatNumber($this->inc_max_amount->EditValue, null);
            }

            // inc_percent
            $this->inc_percent->setupEditAttributes();
            $this->inc_percent->EditValue = $this->inc_percent->CurrentValue;
            $this->inc_percent->PlaceHolder = RemoveHtml($this->inc_percent->caption());
            if (strval($this->inc_percent->EditValue) != "" && is_numeric($this->inc_percent->EditValue)) {
                $this->inc_percent->EditValue = FormatNumber($this->inc_percent->EditValue, null);
            }

            // operator

            // datetime

            // Add refer script

            // partner
            $this->partner->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // type
            $this->type->HrefValue = "";

            // target_amount
            $this->target_amount->HrefValue = "";

            // target_file
            $this->target_file->HrefValue = "";

            // file_inc
            $this->file_inc->HrefValue = "";

            // neg_file_inc
            $this->neg_file_inc->HrefValue = "";

            // inc_min_amount
            $this->inc_min_amount->HrefValue = "";

            // inc_max_amount
            $this->inc_max_amount->HrefValue = "";

            // inc_percent
            $this->inc_percent->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->partner->Visible && $this->partner->Required) {
                if (!$this->partner->IsDetailKey && EmptyValue($this->partner->FormValue)) {
                    $this->partner->addErrorMessage(str_replace("%s", $this->partner->caption(), $this->partner->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->partner->FormValue)) {
                $this->partner->addErrorMessage($this->partner->getErrorMessage(false));
            }
            if ($this->category->Visible && $this->category->Required) {
                if (!$this->category->IsDetailKey && EmptyValue($this->category->FormValue)) {
                    $this->category->addErrorMessage(str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
                }
            }
            if ($this->type->Visible && $this->type->Required) {
                if (!$this->type->IsDetailKey && EmptyValue($this->type->FormValue)) {
                    $this->type->addErrorMessage(str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
                }
            }
            if ($this->target_amount->Visible && $this->target_amount->Required) {
                if (!$this->target_amount->IsDetailKey && EmptyValue($this->target_amount->FormValue)) {
                    $this->target_amount->addErrorMessage(str_replace("%s", $this->target_amount->caption(), $this->target_amount->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->target_amount->FormValue)) {
                $this->target_amount->addErrorMessage($this->target_amount->getErrorMessage(false));
            }
            if ($this->target_file->Visible && $this->target_file->Required) {
                if (!$this->target_file->IsDetailKey && EmptyValue($this->target_file->FormValue)) {
                    $this->target_file->addErrorMessage(str_replace("%s", $this->target_file->caption(), $this->target_file->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->target_file->FormValue)) {
                $this->target_file->addErrorMessage($this->target_file->getErrorMessage(false));
            }
            if ($this->file_inc->Visible && $this->file_inc->Required) {
                if (!$this->file_inc->IsDetailKey && EmptyValue($this->file_inc->FormValue)) {
                    $this->file_inc->addErrorMessage(str_replace("%s", $this->file_inc->caption(), $this->file_inc->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->file_inc->FormValue)) {
                $this->file_inc->addErrorMessage($this->file_inc->getErrorMessage(false));
            }
            if ($this->neg_file_inc->Visible && $this->neg_file_inc->Required) {
                if (!$this->neg_file_inc->IsDetailKey && EmptyValue($this->neg_file_inc->FormValue)) {
                    $this->neg_file_inc->addErrorMessage(str_replace("%s", $this->neg_file_inc->caption(), $this->neg_file_inc->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->neg_file_inc->FormValue)) {
                $this->neg_file_inc->addErrorMessage($this->neg_file_inc->getErrorMessage(false));
            }
            if ($this->inc_min_amount->Visible && $this->inc_min_amount->Required) {
                if (!$this->inc_min_amount->IsDetailKey && EmptyValue($this->inc_min_amount->FormValue)) {
                    $this->inc_min_amount->addErrorMessage(str_replace("%s", $this->inc_min_amount->caption(), $this->inc_min_amount->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->inc_min_amount->FormValue)) {
                $this->inc_min_amount->addErrorMessage($this->inc_min_amount->getErrorMessage(false));
            }
            if ($this->inc_max_amount->Visible && $this->inc_max_amount->Required) {
                if (!$this->inc_max_amount->IsDetailKey && EmptyValue($this->inc_max_amount->FormValue)) {
                    $this->inc_max_amount->addErrorMessage(str_replace("%s", $this->inc_max_amount->caption(), $this->inc_max_amount->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->inc_max_amount->FormValue)) {
                $this->inc_max_amount->addErrorMessage($this->inc_max_amount->getErrorMessage(false));
            }
            if ($this->inc_percent->Visible && $this->inc_percent->Required) {
                if (!$this->inc_percent->IsDetailKey && EmptyValue($this->inc_percent->FormValue)) {
                    $this->inc_percent->addErrorMessage(str_replace("%s", $this->inc_percent->caption(), $this->inc_percent->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->inc_percent->FormValue)) {
                $this->inc_percent->addErrorMessage($this->inc_percent->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // partner
        $this->partner->setDbValueDef($rsnew, $this->partner->CurrentValue, false);

        // category
        $this->category->setDbValueDef($rsnew, $this->category->CurrentValue, false);

        // type
        $this->type->setDbValueDef($rsnew, $this->type->CurrentValue, false);

        // target_amount
        $this->target_amount->setDbValueDef($rsnew, $this->target_amount->CurrentValue, strval($this->target_amount->CurrentValue) == "");

        // target_file
        $this->target_file->setDbValueDef($rsnew, $this->target_file->CurrentValue, strval($this->target_file->CurrentValue) == "");

        // file_inc
        $this->file_inc->setDbValueDef($rsnew, $this->file_inc->CurrentValue, strval($this->file_inc->CurrentValue) == "");

        // neg_file_inc
        $this->neg_file_inc->setDbValueDef($rsnew, $this->neg_file_inc->CurrentValue, strval($this->neg_file_inc->CurrentValue) == "");

        // inc_min_amount
        $this->inc_min_amount->setDbValueDef($rsnew, $this->inc_min_amount->CurrentValue, strval($this->inc_min_amount->CurrentValue) == "");

        // inc_max_amount
        $this->inc_max_amount->setDbValueDef($rsnew, $this->inc_max_amount->CurrentValue, strval($this->inc_max_amount->CurrentValue) == "");

        // inc_percent
        $this->inc_percent->setDbValueDef($rsnew, $this->inc_percent->CurrentValue, strval($this->inc_percent->CurrentValue) == "");

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['partner'])) { // partner
            $this->partner->setFormValue($row['partner']);
        }
        if (isset($row['category'])) { // category
            $this->category->setFormValue($row['category']);
        }
        if (isset($row['type'])) { // type
            $this->type->setFormValue($row['type']);
        }
        if (isset($row['target_amount'])) { // target_amount
            $this->target_amount->setFormValue($row['target_amount']);
        }
        if (isset($row['target_file'])) { // target_file
            $this->target_file->setFormValue($row['target_file']);
        }
        if (isset($row['file_inc'])) { // file_inc
            $this->file_inc->setFormValue($row['file_inc']);
        }
        if (isset($row['neg_file_inc'])) { // neg_file_inc
            $this->neg_file_inc->setFormValue($row['neg_file_inc']);
        }
        if (isset($row['inc_min_amount'])) { // inc_min_amount
            $this->inc_min_amount->setFormValue($row['inc_min_amount']);
        }
        if (isset($row['inc_max_amount'])) { // inc_max_amount
            $this->inc_max_amount->setFormValue($row['inc_max_amount']);
        }
        if (isset($row['inc_percent'])) { // inc_percent
            $this->inc_percent->setFormValue($row['inc_percent']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bincentivepplist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_partner":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
