<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BAccountTypeSearch extends BAccountType
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BAccountTypeSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "baccounttypesearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->location->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->description->setVisibility();
        $this->code->setVisibility();
        $this->minimum->setVisibility();
        $this->maximum->setVisibility();
        $this->int_->setVisibility();
        $this->no_of_emi->setVisibility();
        $this->repay_frequency->setVisibility();
        $this->one_time_charge->setVisibility();
        $this->action_charge->setVisibility();
        $this->month_charge->setVisibility();
        $this->quarter_charge->setVisibility();
        $this->annual_charge->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->repay_period->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'b_account_type';
        $this->TableName = 'b_account_type';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (b_account_type)
        if (!isset($GLOBALS["b_account_type"]) || $GLOBALS["b_account_type"]::class == PROJECT_NAMESPACE . "b_account_type") {
            $GLOBALS["b_account_type"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_type');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "baccounttypeview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->repay_frequency);
        $this->setupLookupOptions($this->one_time_charge);
        $this->setupLookupOptions($this->action_charge);
        $this->setupLookupOptions($this->month_charge);
        $this->setupLookupOptions($this->quarter_charge);
        $this->setupLookupOptions($this->annual_charge);
        $this->setupLookupOptions($this->status);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "baccounttypelist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->location); // location
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
        $this->buildSearchUrl($srchUrl, $this->description); // description
        $this->buildSearchUrl($srchUrl, $this->code); // code
        $this->buildSearchUrl($srchUrl, $this->minimum); // minimum
        $this->buildSearchUrl($srchUrl, $this->maximum); // maximum
        $this->buildSearchUrl($srchUrl, $this->int_); // int_@
        $this->buildSearchUrl($srchUrl, $this->no_of_emi); // no_of_emi
        $this->buildSearchUrl($srchUrl, $this->repay_frequency); // repay_frequency
        $this->buildSearchUrl($srchUrl, $this->one_time_charge); // one_time_charge
        $this->buildSearchUrl($srchUrl, $this->action_charge); // action_charge
        $this->buildSearchUrl($srchUrl, $this->month_charge); // month_charge
        $this->buildSearchUrl($srchUrl, $this->quarter_charge); // quarter_charge
        $this->buildSearchUrl($srchUrl, $this->annual_charge); // annual_charge
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // location
        if ($this->location->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->location->AdvancedSearch->SearchValue)) {
            $this->location->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->location->AdvancedSearch->SearchValue);
        }
        if (is_array($this->location->AdvancedSearch->SearchValue2)) {
            $this->location->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->location->AdvancedSearch->SearchValue2);
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description
        if ($this->description->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // code
        if ($this->code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // minimum
        if ($this->minimum->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // maximum
        if ($this->maximum->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // int_@
        if ($this->int_->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // no_of_emi
        if ($this->no_of_emi->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // repay_frequency
        if ($this->repay_frequency->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // one_time_charge
        if ($this->one_time_charge->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->one_time_charge->AdvancedSearch->SearchValue)) {
            $this->one_time_charge->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->one_time_charge->AdvancedSearch->SearchValue);
        }
        if (is_array($this->one_time_charge->AdvancedSearch->SearchValue2)) {
            $this->one_time_charge->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->one_time_charge->AdvancedSearch->SearchValue2);
        }

        // action_charge
        if ($this->action_charge->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->action_charge->AdvancedSearch->SearchValue)) {
            $this->action_charge->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->action_charge->AdvancedSearch->SearchValue);
        }
        if (is_array($this->action_charge->AdvancedSearch->SearchValue2)) {
            $this->action_charge->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->action_charge->AdvancedSearch->SearchValue2);
        }

        // month_charge
        if ($this->month_charge->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->month_charge->AdvancedSearch->SearchValue)) {
            $this->month_charge->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->month_charge->AdvancedSearch->SearchValue);
        }
        if (is_array($this->month_charge->AdvancedSearch->SearchValue2)) {
            $this->month_charge->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->month_charge->AdvancedSearch->SearchValue2);
        }

        // quarter_charge
        if ($this->quarter_charge->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->quarter_charge->AdvancedSearch->SearchValue)) {
            $this->quarter_charge->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->quarter_charge->AdvancedSearch->SearchValue);
        }
        if (is_array($this->quarter_charge->AdvancedSearch->SearchValue2)) {
            $this->quarter_charge->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->quarter_charge->AdvancedSearch->SearchValue2);
        }

        // annual_charge
        if ($this->annual_charge->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->annual_charge->AdvancedSearch->SearchValue)) {
            $this->annual_charge->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->annual_charge->AdvancedSearch->SearchValue);
        }
        if (is_array($this->annual_charge->AdvancedSearch->SearchValue2)) {
            $this->annual_charge->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->annual_charge->AdvancedSearch->SearchValue2);
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // description
        $this->description->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // minimum
        $this->minimum->RowCssClass = "row";

        // maximum
        $this->maximum->RowCssClass = "row";

        // int_@
        $this->int_->RowCssClass = "row";

        // no_of_emi
        $this->no_of_emi->RowCssClass = "row";

        // repay_frequency
        $this->repay_frequency->RowCssClass = "row";

        // one_time_charge
        $this->one_time_charge->RowCssClass = "row";

        // action_charge
        $this->action_charge->RowCssClass = "row";

        // month_charge
        $this->month_charge->RowCssClass = "row";

        // quarter_charge
        $this->quarter_charge->RowCssClass = "row";

        // annual_charge
        $this->annual_charge->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // repay_period
        $this->repay_period->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->location->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->location->Lookup->renderViewRow($row);
                            $this->location->ViewValue->add($this->location->displayValue($arwrk));
                        }
                    } else {
                        $this->location->ViewValue = $this->location->CurrentValue;
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // minimum
            $this->minimum->ViewValue = $this->minimum->CurrentValue;
            $this->minimum->ViewValue = FormatNumber($this->minimum->ViewValue, $this->minimum->formatPattern());

            // maximum
            $this->maximum->ViewValue = $this->maximum->CurrentValue;
            $this->maximum->ViewValue = FormatNumber($this->maximum->ViewValue, $this->maximum->formatPattern());

            // int_@
            $this->int_->ViewValue = $this->int_->CurrentValue;
            $this->int_->ViewValue = FormatNumber($this->int_->ViewValue, $this->int_->formatPattern());

            // no_of_emi
            $this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
            $this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, $this->no_of_emi->formatPattern());

            // repay_frequency
            if (strval($this->repay_frequency->CurrentValue) != "") {
                $this->repay_frequency->ViewValue = $this->repay_frequency->optionCaption($this->repay_frequency->CurrentValue);
            } else {
                $this->repay_frequency->ViewValue = null;
            }

            // one_time_charge
            $curVal = strval($this->one_time_charge->CurrentValue);
            if ($curVal != "") {
                $this->one_time_charge->ViewValue = $this->one_time_charge->lookupCacheOption($curVal);
                if ($this->one_time_charge->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->one_time_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->one_time_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->one_time_charge->getSelectFilter($this); // PHP
                    $sqlWrk = $this->one_time_charge->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->one_time_charge->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->one_time_charge->Lookup->renderViewRow($row);
                            $this->one_time_charge->ViewValue->add($this->one_time_charge->displayValue($arwrk));
                        }
                    } else {
                        $this->one_time_charge->ViewValue = $this->one_time_charge->CurrentValue;
                    }
                }
            } else {
                $this->one_time_charge->ViewValue = null;
            }

            // action_charge
            $curVal = strval($this->action_charge->CurrentValue);
            if ($curVal != "") {
                $this->action_charge->ViewValue = $this->action_charge->lookupCacheOption($curVal);
                if ($this->action_charge->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->action_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->action_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->action_charge->getSelectFilter($this); // PHP
                    $sqlWrk = $this->action_charge->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->action_charge->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->action_charge->Lookup->renderViewRow($row);
                            $this->action_charge->ViewValue->add($this->action_charge->displayValue($arwrk));
                        }
                    } else {
                        $this->action_charge->ViewValue = $this->action_charge->CurrentValue;
                    }
                }
            } else {
                $this->action_charge->ViewValue = null;
            }

            // month_charge
            $curVal = strval($this->month_charge->CurrentValue);
            if ($curVal != "") {
                $this->month_charge->ViewValue = $this->month_charge->lookupCacheOption($curVal);
                if ($this->month_charge->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->month_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->month_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->month_charge->getSelectFilter($this); // PHP
                    $sqlWrk = $this->month_charge->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->month_charge->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->month_charge->Lookup->renderViewRow($row);
                            $this->month_charge->ViewValue->add($this->month_charge->displayValue($arwrk));
                        }
                    } else {
                        $this->month_charge->ViewValue = $this->month_charge->CurrentValue;
                    }
                }
            } else {
                $this->month_charge->ViewValue = null;
            }

            // quarter_charge
            $curVal = strval($this->quarter_charge->CurrentValue);
            if ($curVal != "") {
                $this->quarter_charge->ViewValue = $this->quarter_charge->lookupCacheOption($curVal);
                if ($this->quarter_charge->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->quarter_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->quarter_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->quarter_charge->getSelectFilter($this); // PHP
                    $sqlWrk = $this->quarter_charge->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->quarter_charge->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->quarter_charge->Lookup->renderViewRow($row);
                            $this->quarter_charge->ViewValue->add($this->quarter_charge->displayValue($arwrk));
                        }
                    } else {
                        $this->quarter_charge->ViewValue = $this->quarter_charge->CurrentValue;
                    }
                }
            } else {
                $this->quarter_charge->ViewValue = null;
            }

            // annual_charge
            $curVal = strval($this->annual_charge->CurrentValue);
            if ($curVal != "") {
                $this->annual_charge->ViewValue = $this->annual_charge->lookupCacheOption($curVal);
                if ($this->annual_charge->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->annual_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->annual_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->annual_charge->getSelectFilter($this); // PHP
                    $sqlWrk = $this->annual_charge->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->annual_charge->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->annual_charge->Lookup->renderViewRow($row);
                            $this->annual_charge->ViewValue->add($this->annual_charge->displayValue($arwrk));
                        }
                    } else {
                        $this->annual_charge->ViewValue = $this->annual_charge->CurrentValue;
                    }
                }
            } else {
                $this->annual_charge->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // description
            $this->description->HrefValue = "";
            $this->description->TooltipValue = "";

            // code
            $this->code->HrefValue = "";
            $this->code->TooltipValue = "";

            // minimum
            $this->minimum->HrefValue = "";
            $this->minimum->TooltipValue = "";

            // maximum
            $this->maximum->HrefValue = "";
            $this->maximum->TooltipValue = "";

            // int_@
            $this->int_->HrefValue = "";
            $this->int_->TooltipValue = "";

            // no_of_emi
            $this->no_of_emi->HrefValue = "";
            $this->no_of_emi->TooltipValue = "";

            // repay_frequency
            $this->repay_frequency->HrefValue = "";
            $this->repay_frequency->TooltipValue = "";

            // one_time_charge
            $this->one_time_charge->HrefValue = "";
            $this->one_time_charge->TooltipValue = "";

            // action_charge
            $this->action_charge->HrefValue = "";
            $this->action_charge->TooltipValue = "";

            // month_charge
            $this->month_charge->HrefValue = "";
            $this->month_charge->TooltipValue = "";

            // quarter_charge
            $this->quarter_charge->HrefValue = "";
            $this->quarter_charge->TooltipValue = "";

            // annual_charge
            $this->annual_charge->HrefValue = "";
            $this->annual_charge->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // location
            $curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->AdvancedSearch->SearchValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // description
            $this->description->setupEditAttributes();
            if (!$this->description->Raw) {
                $this->description->AdvancedSearch->SearchValue = HtmlDecode($this->description->AdvancedSearch->SearchValue);
            }
            $this->description->EditValue = HtmlEncode($this->description->AdvancedSearch->SearchValue);
            $this->description->PlaceHolder = RemoveHtml($this->description->caption());

            // code
            $this->code->setupEditAttributes();
            if (!$this->code->Raw) {
                $this->code->AdvancedSearch->SearchValue = HtmlDecode($this->code->AdvancedSearch->SearchValue);
            }
            $this->code->EditValue = HtmlEncode($this->code->AdvancedSearch->SearchValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // minimum
            $this->minimum->setupEditAttributes();
            $this->minimum->EditValue = $this->minimum->AdvancedSearch->SearchValue;
            $this->minimum->PlaceHolder = RemoveHtml($this->minimum->caption());

            // maximum
            $this->maximum->setupEditAttributes();
            $this->maximum->EditValue = $this->maximum->AdvancedSearch->SearchValue;
            $this->maximum->PlaceHolder = RemoveHtml($this->maximum->caption());

            // int_@
            $this->int_->setupEditAttributes();
            $this->int_->EditValue = $this->int_->AdvancedSearch->SearchValue;
            $this->int_->PlaceHolder = RemoveHtml($this->int_->caption());

            // no_of_emi
            $this->no_of_emi->setupEditAttributes();
            $this->no_of_emi->EditValue = $this->no_of_emi->AdvancedSearch->SearchValue;
            $this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());

            // repay_frequency
            $this->repay_frequency->setupEditAttributes();
            $this->repay_frequency->EditValue = $this->repay_frequency->options(true);
            $this->repay_frequency->PlaceHolder = RemoveHtml($this->repay_frequency->caption());

            // one_time_charge
            $curVal = trim(strval($this->one_time_charge->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->one_time_charge->AdvancedSearch->ViewValue = $this->one_time_charge->lookupCacheOption($curVal);
            } else {
                $this->one_time_charge->AdvancedSearch->ViewValue = $this->one_time_charge->Lookup !== null && is_array($this->one_time_charge->lookupOptions()) && count($this->one_time_charge->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->one_time_charge->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->one_time_charge->EditValue = array_values($this->one_time_charge->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->one_time_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->one_time_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->one_time_charge->getSelectFilter($this); // PHP
                $sqlWrk = $this->one_time_charge->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->one_time_charge->EditValue = $arwrk;
            }
            $this->one_time_charge->PlaceHolder = RemoveHtml($this->one_time_charge->caption());

            // action_charge
            $curVal = trim(strval($this->action_charge->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->action_charge->AdvancedSearch->ViewValue = $this->action_charge->lookupCacheOption($curVal);
            } else {
                $this->action_charge->AdvancedSearch->ViewValue = $this->action_charge->Lookup !== null && is_array($this->action_charge->lookupOptions()) && count($this->action_charge->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->action_charge->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->action_charge->EditValue = array_values($this->action_charge->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->action_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->action_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->action_charge->getSelectFilter($this); // PHP
                $sqlWrk = $this->action_charge->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->action_charge->EditValue = $arwrk;
            }
            $this->action_charge->PlaceHolder = RemoveHtml($this->action_charge->caption());

            // month_charge
            $curVal = trim(strval($this->month_charge->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->month_charge->AdvancedSearch->ViewValue = $this->month_charge->lookupCacheOption($curVal);
            } else {
                $this->month_charge->AdvancedSearch->ViewValue = $this->month_charge->Lookup !== null && is_array($this->month_charge->lookupOptions()) && count($this->month_charge->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->month_charge->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->month_charge->EditValue = array_values($this->month_charge->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->month_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->month_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->month_charge->getSelectFilter($this); // PHP
                $sqlWrk = $this->month_charge->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->month_charge->EditValue = $arwrk;
            }
            $this->month_charge->PlaceHolder = RemoveHtml($this->month_charge->caption());

            // quarter_charge
            $curVal = trim(strval($this->quarter_charge->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->quarter_charge->AdvancedSearch->ViewValue = $this->quarter_charge->lookupCacheOption($curVal);
            } else {
                $this->quarter_charge->AdvancedSearch->ViewValue = $this->quarter_charge->Lookup !== null && is_array($this->quarter_charge->lookupOptions()) && count($this->quarter_charge->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->quarter_charge->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->quarter_charge->EditValue = array_values($this->quarter_charge->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->quarter_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->quarter_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->quarter_charge->getSelectFilter($this); // PHP
                $sqlWrk = $this->quarter_charge->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->quarter_charge->EditValue = $arwrk;
            }
            $this->quarter_charge->PlaceHolder = RemoveHtml($this->quarter_charge->caption());

            // annual_charge
            $curVal = trim(strval($this->annual_charge->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->annual_charge->AdvancedSearch->ViewValue = $this->annual_charge->lookupCacheOption($curVal);
            } else {
                $this->annual_charge->AdvancedSearch->ViewValue = $this->annual_charge->Lookup !== null && is_array($this->annual_charge->lookupOptions()) && count($this->annual_charge->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->annual_charge->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->annual_charge->EditValue = array_values($this->annual_charge->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->annual_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->annual_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->annual_charge->getSelectFilter($this); // PHP
                $sqlWrk = $this->annual_charge->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->annual_charge->EditValue = $arwrk;
            }
            $this->annual_charge->PlaceHolder = RemoveHtml($this->annual_charge->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->minimum->AdvancedSearch->SearchValue)) {
            $this->minimum->addErrorMessage($this->minimum->getErrorMessage(false));
        }
        if (!CheckInteger($this->maximum->AdvancedSearch->SearchValue)) {
            $this->maximum->addErrorMessage($this->maximum->getErrorMessage(false));
        }
        if (!CheckNumber($this->int_->AdvancedSearch->SearchValue)) {
            $this->int_->addErrorMessage($this->int_->getErrorMessage(false));
        }
        if (!CheckInteger($this->no_of_emi->AdvancedSearch->SearchValue)) {
            $this->no_of_emi->addErrorMessage($this->no_of_emi->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->location->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->description->AdvancedSearch->load();
        $this->code->AdvancedSearch->load();
        $this->minimum->AdvancedSearch->load();
        $this->maximum->AdvancedSearch->load();
        $this->int_->AdvancedSearch->load();
        $this->no_of_emi->AdvancedSearch->load();
        $this->repay_frequency->AdvancedSearch->load();
        $this->one_time_charge->AdvancedSearch->load();
        $this->action_charge->AdvancedSearch->load();
        $this->month_charge->AdvancedSearch->load();
        $this->quarter_charge->AdvancedSearch->load();
        $this->annual_charge->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("baccounttypelist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_repay_frequency":
                    break;
                case "x_one_time_charge":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_action_charge":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_month_charge":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_quarter_charge":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_annual_charge":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
