<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BAccountTypeEdit extends BAccountType
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BAccountTypeEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "baccounttypeedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->location->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->description->setVisibility();
        $this->code->setVisibility();
        $this->minimum->setVisibility();
        $this->maximum->setVisibility();
        $this->int_->setVisibility();
        $this->no_of_emi->setVisibility();
        $this->repay_frequency->setVisibility();
        $this->one_time_charge->setVisibility();
        $this->action_charge->setVisibility();
        $this->month_charge->setVisibility();
        $this->quarter_charge->setVisibility();
        $this->annual_charge->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->repay_period->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'b_account_type';
        $this->TableName = 'b_account_type';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (b_account_type)
        if (!isset($GLOBALS["b_account_type"]) || $GLOBALS["b_account_type"]::class == PROJECT_NAMESPACE . "b_account_type") {
            $GLOBALS["b_account_type"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_type');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "baccounttypeview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->repay_frequency);
        $this->setupLookupOptions($this->one_time_charge);
        $this->setupLookupOptions($this->action_charge);
        $this->setupLookupOptions($this->month_charge);
        $this->setupLookupOptions($this->quarter_charge);
        $this->setupLookupOptions($this->annual_charge);
        $this->setupLookupOptions($this->status);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("baccounttypelist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "baccounttypelist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "baccounttypelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "baccounttypelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'location' first before field var 'x_location'
        $val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
        if (!$this->location->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->location->Visible = false; // Disable update for API request
            } else {
                $this->location->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'description' first before field var 'x_description'
        $val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
        if (!$this->description->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description->Visible = false; // Disable update for API request
            } else {
                $this->description->setFormValue($val);
            }
        }

        // Check field name 'code' first before field var 'x_code'
        $val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
        if (!$this->code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->code->Visible = false; // Disable update for API request
            } else {
                $this->code->setFormValue($val);
            }
        }

        // Check field name 'minimum' first before field var 'x_minimum'
        $val = $CurrentForm->hasValue("minimum") ? $CurrentForm->getValue("minimum") : $CurrentForm->getValue("x_minimum");
        if (!$this->minimum->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->minimum->Visible = false; // Disable update for API request
            } else {
                $this->minimum->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'maximum' first before field var 'x_maximum'
        $val = $CurrentForm->hasValue("maximum") ? $CurrentForm->getValue("maximum") : $CurrentForm->getValue("x_maximum");
        if (!$this->maximum->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->maximum->Visible = false; // Disable update for API request
            } else {
                $this->maximum->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'int_@' first before field var 'x_int_'
        $val = $CurrentForm->hasValue("int_@") ? $CurrentForm->getValue("int_@") : $CurrentForm->getValue("x_int_");
        if (!$this->int_->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->int_->Visible = false; // Disable update for API request
            } else {
                $this->int_->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'no_of_emi' first before field var 'x_no_of_emi'
        $val = $CurrentForm->hasValue("no_of_emi") ? $CurrentForm->getValue("no_of_emi") : $CurrentForm->getValue("x_no_of_emi");
        if (!$this->no_of_emi->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->no_of_emi->Visible = false; // Disable update for API request
            } else {
                $this->no_of_emi->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'repay_frequency' first before field var 'x_repay_frequency'
        $val = $CurrentForm->hasValue("repay_frequency") ? $CurrentForm->getValue("repay_frequency") : $CurrentForm->getValue("x_repay_frequency");
        if (!$this->repay_frequency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->repay_frequency->Visible = false; // Disable update for API request
            } else {
                $this->repay_frequency->setFormValue($val);
            }
        }

        // Check field name 'one_time_charge' first before field var 'x_one_time_charge'
        $val = $CurrentForm->hasValue("one_time_charge") ? $CurrentForm->getValue("one_time_charge") : $CurrentForm->getValue("x_one_time_charge");
        if (!$this->one_time_charge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->one_time_charge->Visible = false; // Disable update for API request
            } else {
                $this->one_time_charge->setFormValue($val);
            }
        }

        // Check field name 'action_charge' first before field var 'x_action_charge'
        $val = $CurrentForm->hasValue("action_charge") ? $CurrentForm->getValue("action_charge") : $CurrentForm->getValue("x_action_charge");
        if (!$this->action_charge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->action_charge->Visible = false; // Disable update for API request
            } else {
                $this->action_charge->setFormValue($val);
            }
        }

        // Check field name 'month_charge' first before field var 'x_month_charge'
        $val = $CurrentForm->hasValue("month_charge") ? $CurrentForm->getValue("month_charge") : $CurrentForm->getValue("x_month_charge");
        if (!$this->month_charge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->month_charge->Visible = false; // Disable update for API request
            } else {
                $this->month_charge->setFormValue($val);
            }
        }

        // Check field name 'quarter_charge' first before field var 'x_quarter_charge'
        $val = $CurrentForm->hasValue("quarter_charge") ? $CurrentForm->getValue("quarter_charge") : $CurrentForm->getValue("x_quarter_charge");
        if (!$this->quarter_charge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quarter_charge->Visible = false; // Disable update for API request
            } else {
                $this->quarter_charge->setFormValue($val);
            }
        }

        // Check field name 'annual_charge' first before field var 'x_annual_charge'
        $val = $CurrentForm->hasValue("annual_charge") ? $CurrentForm->getValue("annual_charge") : $CurrentForm->getValue("x_annual_charge");
        if (!$this->annual_charge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->annual_charge->Visible = false; // Disable update for API request
            } else {
                $this->annual_charge->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->location->CurrentValue = $this->location->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->description->CurrentValue = $this->description->FormValue;
        $this->code->CurrentValue = $this->code->FormValue;
        $this->minimum->CurrentValue = $this->minimum->FormValue;
        $this->maximum->CurrentValue = $this->maximum->FormValue;
        $this->int_->CurrentValue = $this->int_->FormValue;
        $this->no_of_emi->CurrentValue = $this->no_of_emi->FormValue;
        $this->repay_frequency->CurrentValue = $this->repay_frequency->FormValue;
        $this->one_time_charge->CurrentValue = $this->one_time_charge->FormValue;
        $this->action_charge->CurrentValue = $this->action_charge->FormValue;
        $this->month_charge->CurrentValue = $this->month_charge->FormValue;
        $this->quarter_charge->CurrentValue = $this->quarter_charge->FormValue;
        $this->annual_charge->CurrentValue = $this->annual_charge->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->location->setDbValue($row['location']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->description->setDbValue($row['description']);
        $this->code->setDbValue($row['code']);
        $this->minimum->setDbValue($row['minimum']);
        $this->maximum->setDbValue($row['maximum']);
        $this->int_->setDbValue($row['int_@']);
        $this->no_of_emi->setDbValue($row['no_of_emi']);
        $this->repay_frequency->setDbValue($row['repay_frequency']);
        $this->one_time_charge->setDbValue($row['one_time_charge']);
        $this->action_charge->setDbValue($row['action_charge']);
        $this->month_charge->setDbValue($row['month_charge']);
        $this->quarter_charge->setDbValue($row['quarter_charge']);
        $this->annual_charge->setDbValue($row['annual_charge']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->repay_period->setDbValue($row['repay_period']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['description'] = $this->description->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['minimum'] = $this->minimum->DefaultValue;
        $row['maximum'] = $this->maximum->DefaultValue;
        $row['int_@'] = $this->int_->DefaultValue;
        $row['no_of_emi'] = $this->no_of_emi->DefaultValue;
        $row['repay_frequency'] = $this->repay_frequency->DefaultValue;
        $row['one_time_charge'] = $this->one_time_charge->DefaultValue;
        $row['action_charge'] = $this->action_charge->DefaultValue;
        $row['month_charge'] = $this->month_charge->DefaultValue;
        $row['quarter_charge'] = $this->quarter_charge->DefaultValue;
        $row['annual_charge'] = $this->annual_charge->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['repay_period'] = $this->repay_period->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // description
        $this->description->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // minimum
        $this->minimum->RowCssClass = "row";

        // maximum
        $this->maximum->RowCssClass = "row";

        // int_@
        $this->int_->RowCssClass = "row";

        // no_of_emi
        $this->no_of_emi->RowCssClass = "row";

        // repay_frequency
        $this->repay_frequency->RowCssClass = "row";

        // one_time_charge
        $this->one_time_charge->RowCssClass = "row";

        // action_charge
        $this->action_charge->RowCssClass = "row";

        // month_charge
        $this->month_charge->RowCssClass = "row";

        // quarter_charge
        $this->quarter_charge->RowCssClass = "row";

        // annual_charge
        $this->annual_charge->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // repay_period
        $this->repay_period->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->location->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->location->Lookup->renderViewRow($row);
                            $this->location->ViewValue->add($this->location->displayValue($arwrk));
                        }
                    } else {
                        $this->location->ViewValue = $this->location->CurrentValue;
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // minimum
            $this->minimum->ViewValue = $this->minimum->CurrentValue;
            $this->minimum->ViewValue = FormatNumber($this->minimum->ViewValue, $this->minimum->formatPattern());

            // maximum
            $this->maximum->ViewValue = $this->maximum->CurrentValue;
            $this->maximum->ViewValue = FormatNumber($this->maximum->ViewValue, $this->maximum->formatPattern());

            // int_@
            $this->int_->ViewValue = $this->int_->CurrentValue;
            $this->int_->ViewValue = FormatNumber($this->int_->ViewValue, $this->int_->formatPattern());

            // no_of_emi
            $this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
            $this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, $this->no_of_emi->formatPattern());

            // repay_frequency
            if (strval($this->repay_frequency->CurrentValue) != "") {
                $this->repay_frequency->ViewValue = $this->repay_frequency->optionCaption($this->repay_frequency->CurrentValue);
            } else {
                $this->repay_frequency->ViewValue = null;
            }

            // one_time_charge
            $curVal = strval($this->one_time_charge->CurrentValue);
            if ($curVal != "") {
                $this->one_time_charge->ViewValue = $this->one_time_charge->lookupCacheOption($curVal);
                if ($this->one_time_charge->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->one_time_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->one_time_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->one_time_charge->getSelectFilter($this); // PHP
                    $sqlWrk = $this->one_time_charge->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->one_time_charge->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->one_time_charge->Lookup->renderViewRow($row);
                            $this->one_time_charge->ViewValue->add($this->one_time_charge->displayValue($arwrk));
                        }
                    } else {
                        $this->one_time_charge->ViewValue = $this->one_time_charge->CurrentValue;
                    }
                }
            } else {
                $this->one_time_charge->ViewValue = null;
            }

            // action_charge
            $curVal = strval($this->action_charge->CurrentValue);
            if ($curVal != "") {
                $this->action_charge->ViewValue = $this->action_charge->lookupCacheOption($curVal);
                if ($this->action_charge->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->action_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->action_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->action_charge->getSelectFilter($this); // PHP
                    $sqlWrk = $this->action_charge->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->action_charge->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->action_charge->Lookup->renderViewRow($row);
                            $this->action_charge->ViewValue->add($this->action_charge->displayValue($arwrk));
                        }
                    } else {
                        $this->action_charge->ViewValue = $this->action_charge->CurrentValue;
                    }
                }
            } else {
                $this->action_charge->ViewValue = null;
            }

            // month_charge
            $curVal = strval($this->month_charge->CurrentValue);
            if ($curVal != "") {
                $this->month_charge->ViewValue = $this->month_charge->lookupCacheOption($curVal);
                if ($this->month_charge->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->month_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->month_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->month_charge->getSelectFilter($this); // PHP
                    $sqlWrk = $this->month_charge->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->month_charge->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->month_charge->Lookup->renderViewRow($row);
                            $this->month_charge->ViewValue->add($this->month_charge->displayValue($arwrk));
                        }
                    } else {
                        $this->month_charge->ViewValue = $this->month_charge->CurrentValue;
                    }
                }
            } else {
                $this->month_charge->ViewValue = null;
            }

            // quarter_charge
            $curVal = strval($this->quarter_charge->CurrentValue);
            if ($curVal != "") {
                $this->quarter_charge->ViewValue = $this->quarter_charge->lookupCacheOption($curVal);
                if ($this->quarter_charge->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->quarter_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->quarter_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->quarter_charge->getSelectFilter($this); // PHP
                    $sqlWrk = $this->quarter_charge->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->quarter_charge->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->quarter_charge->Lookup->renderViewRow($row);
                            $this->quarter_charge->ViewValue->add($this->quarter_charge->displayValue($arwrk));
                        }
                    } else {
                        $this->quarter_charge->ViewValue = $this->quarter_charge->CurrentValue;
                    }
                }
            } else {
                $this->quarter_charge->ViewValue = null;
            }

            // annual_charge
            $curVal = strval($this->annual_charge->CurrentValue);
            if ($curVal != "") {
                $this->annual_charge->ViewValue = $this->annual_charge->lookupCacheOption($curVal);
                if ($this->annual_charge->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->annual_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->annual_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->annual_charge->getSelectFilter($this); // PHP
                    $sqlWrk = $this->annual_charge->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->annual_charge->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->annual_charge->Lookup->renderViewRow($row);
                            $this->annual_charge->ViewValue->add($this->annual_charge->displayValue($arwrk));
                        }
                    } else {
                        $this->annual_charge->ViewValue = $this->annual_charge->CurrentValue;
                    }
                }
            } else {
                $this->annual_charge->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // description
            $this->description->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // minimum
            $this->minimum->HrefValue = "";

            // maximum
            $this->maximum->HrefValue = "";

            // int_@
            $this->int_->HrefValue = "";

            // no_of_emi
            $this->no_of_emi->HrefValue = "";

            // repay_frequency
            $this->repay_frequency->HrefValue = "";

            // one_time_charge
            $this->one_time_charge->HrefValue = "";

            // action_charge
            $this->action_charge->HrefValue = "";

            // month_charge
            $this->month_charge->HrefValue = "";

            // quarter_charge
            $this->quarter_charge->HrefValue = "";

            // annual_charge
            $this->annual_charge->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // location
            $curVal = trim(strval($this->location->CurrentValue));
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // description
            $this->description->setupEditAttributes();
            if (!$this->description->Raw) {
                $this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
            }
            $this->description->EditValue = HtmlEncode($this->description->CurrentValue);
            $this->description->PlaceHolder = RemoveHtml($this->description->caption());

            // code
            $this->code->setupEditAttributes();
            if (!$this->code->Raw) {
                $this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
            }
            $this->code->EditValue = HtmlEncode($this->code->CurrentValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // minimum
            $this->minimum->setupEditAttributes();
            $this->minimum->EditValue = $this->minimum->CurrentValue;
            $this->minimum->PlaceHolder = RemoveHtml($this->minimum->caption());
            if (strval($this->minimum->EditValue) != "" && is_numeric($this->minimum->EditValue)) {
                $this->minimum->EditValue = FormatNumber($this->minimum->EditValue, null);
            }

            // maximum
            $this->maximum->setupEditAttributes();
            $this->maximum->EditValue = $this->maximum->CurrentValue;
            $this->maximum->PlaceHolder = RemoveHtml($this->maximum->caption());
            if (strval($this->maximum->EditValue) != "" && is_numeric($this->maximum->EditValue)) {
                $this->maximum->EditValue = FormatNumber($this->maximum->EditValue, null);
            }

            // int_@
            $this->int_->setupEditAttributes();
            $this->int_->EditValue = $this->int_->CurrentValue;
            $this->int_->PlaceHolder = RemoveHtml($this->int_->caption());
            if (strval($this->int_->EditValue) != "" && is_numeric($this->int_->EditValue)) {
                $this->int_->EditValue = FormatNumber($this->int_->EditValue, null);
            }

            // no_of_emi
            $this->no_of_emi->setupEditAttributes();
            $this->no_of_emi->EditValue = $this->no_of_emi->CurrentValue;
            $this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());
            if (strval($this->no_of_emi->EditValue) != "" && is_numeric($this->no_of_emi->EditValue)) {
                $this->no_of_emi->EditValue = FormatNumber($this->no_of_emi->EditValue, null);
            }

            // repay_frequency
            $this->repay_frequency->setupEditAttributes();
            $this->repay_frequency->EditValue = $this->repay_frequency->options(true);
            $this->repay_frequency->PlaceHolder = RemoveHtml($this->repay_frequency->caption());

            // one_time_charge
            $curVal = trim(strval($this->one_time_charge->CurrentValue));
            if ($curVal != "") {
                $this->one_time_charge->ViewValue = $this->one_time_charge->lookupCacheOption($curVal);
            } else {
                $this->one_time_charge->ViewValue = $this->one_time_charge->Lookup !== null && is_array($this->one_time_charge->lookupOptions()) && count($this->one_time_charge->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->one_time_charge->ViewValue !== null) { // Load from cache
                $this->one_time_charge->EditValue = array_values($this->one_time_charge->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->one_time_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->one_time_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->one_time_charge->getSelectFilter($this); // PHP
                $sqlWrk = $this->one_time_charge->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->one_time_charge->EditValue = $arwrk;
            }
            $this->one_time_charge->PlaceHolder = RemoveHtml($this->one_time_charge->caption());

            // action_charge
            $curVal = trim(strval($this->action_charge->CurrentValue));
            if ($curVal != "") {
                $this->action_charge->ViewValue = $this->action_charge->lookupCacheOption($curVal);
            } else {
                $this->action_charge->ViewValue = $this->action_charge->Lookup !== null && is_array($this->action_charge->lookupOptions()) && count($this->action_charge->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->action_charge->ViewValue !== null) { // Load from cache
                $this->action_charge->EditValue = array_values($this->action_charge->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->action_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->action_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->action_charge->getSelectFilter($this); // PHP
                $sqlWrk = $this->action_charge->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->action_charge->EditValue = $arwrk;
            }
            $this->action_charge->PlaceHolder = RemoveHtml($this->action_charge->caption());

            // month_charge
            $curVal = trim(strval($this->month_charge->CurrentValue));
            if ($curVal != "") {
                $this->month_charge->ViewValue = $this->month_charge->lookupCacheOption($curVal);
            } else {
                $this->month_charge->ViewValue = $this->month_charge->Lookup !== null && is_array($this->month_charge->lookupOptions()) && count($this->month_charge->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->month_charge->ViewValue !== null) { // Load from cache
                $this->month_charge->EditValue = array_values($this->month_charge->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->month_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->month_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->month_charge->getSelectFilter($this); // PHP
                $sqlWrk = $this->month_charge->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->month_charge->EditValue = $arwrk;
            }
            $this->month_charge->PlaceHolder = RemoveHtml($this->month_charge->caption());

            // quarter_charge
            $curVal = trim(strval($this->quarter_charge->CurrentValue));
            if ($curVal != "") {
                $this->quarter_charge->ViewValue = $this->quarter_charge->lookupCacheOption($curVal);
            } else {
                $this->quarter_charge->ViewValue = $this->quarter_charge->Lookup !== null && is_array($this->quarter_charge->lookupOptions()) && count($this->quarter_charge->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->quarter_charge->ViewValue !== null) { // Load from cache
                $this->quarter_charge->EditValue = array_values($this->quarter_charge->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->quarter_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->quarter_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->quarter_charge->getSelectFilter($this); // PHP
                $sqlWrk = $this->quarter_charge->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->quarter_charge->EditValue = $arwrk;
            }
            $this->quarter_charge->PlaceHolder = RemoveHtml($this->quarter_charge->caption());

            // annual_charge
            $curVal = trim(strval($this->annual_charge->CurrentValue));
            if ($curVal != "") {
                $this->annual_charge->ViewValue = $this->annual_charge->lookupCacheOption($curVal);
            } else {
                $this->annual_charge->ViewValue = $this->annual_charge->Lookup !== null && is_array($this->annual_charge->lookupOptions()) && count($this->annual_charge->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->annual_charge->ViewValue !== null) { // Load from cache
                $this->annual_charge->EditValue = array_values($this->annual_charge->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->annual_charge->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->annual_charge->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->annual_charge->getSelectFilter($this); // PHP
                $sqlWrk = $this->annual_charge->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->annual_charge->EditValue = $arwrk;
            }
            $this->annual_charge->PlaceHolder = RemoveHtml($this->annual_charge->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // description
            $this->description->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // minimum
            $this->minimum->HrefValue = "";

            // maximum
            $this->maximum->HrefValue = "";

            // int_@
            $this->int_->HrefValue = "";

            // no_of_emi
            $this->no_of_emi->HrefValue = "";

            // repay_frequency
            $this->repay_frequency->HrefValue = "";

            // one_time_charge
            $this->one_time_charge->HrefValue = "";

            // action_charge
            $this->action_charge->HrefValue = "";

            // month_charge
            $this->month_charge->HrefValue = "";

            // quarter_charge
            $this->quarter_charge->HrefValue = "";

            // annual_charge
            $this->annual_charge->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->location->Visible && $this->location->Required) {
                if ($this->location->FormValue == "") {
                    $this->location->addErrorMessage(str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->description->Visible && $this->description->Required) {
                if (!$this->description->IsDetailKey && EmptyValue($this->description->FormValue)) {
                    $this->description->addErrorMessage(str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
                }
            }
            if ($this->code->Visible && $this->code->Required) {
                if (!$this->code->IsDetailKey && EmptyValue($this->code->FormValue)) {
                    $this->code->addErrorMessage(str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
                }
            }
            if ($this->minimum->Visible && $this->minimum->Required) {
                if (!$this->minimum->IsDetailKey && EmptyValue($this->minimum->FormValue)) {
                    $this->minimum->addErrorMessage(str_replace("%s", $this->minimum->caption(), $this->minimum->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->minimum->FormValue)) {
                $this->minimum->addErrorMessage($this->minimum->getErrorMessage(false));
            }
            if ($this->maximum->Visible && $this->maximum->Required) {
                if (!$this->maximum->IsDetailKey && EmptyValue($this->maximum->FormValue)) {
                    $this->maximum->addErrorMessage(str_replace("%s", $this->maximum->caption(), $this->maximum->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->maximum->FormValue)) {
                $this->maximum->addErrorMessage($this->maximum->getErrorMessage(false));
            }
            if ($this->int_->Visible && $this->int_->Required) {
                if (!$this->int_->IsDetailKey && EmptyValue($this->int_->FormValue)) {
                    $this->int_->addErrorMessage(str_replace("%s", $this->int_->caption(), $this->int_->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->int_->FormValue)) {
                $this->int_->addErrorMessage($this->int_->getErrorMessage(false));
            }
            if ($this->no_of_emi->Visible && $this->no_of_emi->Required) {
                if (!$this->no_of_emi->IsDetailKey && EmptyValue($this->no_of_emi->FormValue)) {
                    $this->no_of_emi->addErrorMessage(str_replace("%s", $this->no_of_emi->caption(), $this->no_of_emi->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->no_of_emi->FormValue)) {
                $this->no_of_emi->addErrorMessage($this->no_of_emi->getErrorMessage(false));
            }
            if ($this->repay_frequency->Visible && $this->repay_frequency->Required) {
                if (!$this->repay_frequency->IsDetailKey && EmptyValue($this->repay_frequency->FormValue)) {
                    $this->repay_frequency->addErrorMessage(str_replace("%s", $this->repay_frequency->caption(), $this->repay_frequency->RequiredErrorMessage));
                }
            }
            if ($this->one_time_charge->Visible && $this->one_time_charge->Required) {
                if ($this->one_time_charge->FormValue == "") {
                    $this->one_time_charge->addErrorMessage(str_replace("%s", $this->one_time_charge->caption(), $this->one_time_charge->RequiredErrorMessage));
                }
            }
            if ($this->action_charge->Visible && $this->action_charge->Required) {
                if ($this->action_charge->FormValue == "") {
                    $this->action_charge->addErrorMessage(str_replace("%s", $this->action_charge->caption(), $this->action_charge->RequiredErrorMessage));
                }
            }
            if ($this->month_charge->Visible && $this->month_charge->Required) {
                if ($this->month_charge->FormValue == "") {
                    $this->month_charge->addErrorMessage(str_replace("%s", $this->month_charge->caption(), $this->month_charge->RequiredErrorMessage));
                }
            }
            if ($this->quarter_charge->Visible && $this->quarter_charge->Required) {
                if ($this->quarter_charge->FormValue == "") {
                    $this->quarter_charge->addErrorMessage(str_replace("%s", $this->quarter_charge->caption(), $this->quarter_charge->RequiredErrorMessage));
                }
            }
            if ($this->annual_charge->Visible && $this->annual_charge->Required) {
                if ($this->annual_charge->FormValue == "") {
                    $this->annual_charge->addErrorMessage(str_replace("%s", $this->annual_charge->caption(), $this->annual_charge->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // location
        $this->location->setDbValueDef($rsnew, $this->location->CurrentValue, $this->location->ReadOnly);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, $this->grp->ReadOnly);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, $this->s_grp->ReadOnly);

        // description
        $this->description->setDbValueDef($rsnew, $this->description->CurrentValue, $this->description->ReadOnly);

        // code
        $this->code->setDbValueDef($rsnew, $this->code->CurrentValue, $this->code->ReadOnly);

        // minimum
        $this->minimum->setDbValueDef($rsnew, $this->minimum->CurrentValue, $this->minimum->ReadOnly);

        // maximum
        $this->maximum->setDbValueDef($rsnew, $this->maximum->CurrentValue, $this->maximum->ReadOnly);

        // int_@
        $this->int_->setDbValueDef($rsnew, $this->int_->CurrentValue, $this->int_->ReadOnly);

        // no_of_emi
        $this->no_of_emi->setDbValueDef($rsnew, $this->no_of_emi->CurrentValue, $this->no_of_emi->ReadOnly);

        // repay_frequency
        $this->repay_frequency->setDbValueDef($rsnew, $this->repay_frequency->CurrentValue, $this->repay_frequency->ReadOnly);

        // one_time_charge
        $this->one_time_charge->setDbValueDef($rsnew, $this->one_time_charge->CurrentValue, $this->one_time_charge->ReadOnly);

        // action_charge
        $this->action_charge->setDbValueDef($rsnew, $this->action_charge->CurrentValue, $this->action_charge->ReadOnly);

        // month_charge
        $this->month_charge->setDbValueDef($rsnew, $this->month_charge->CurrentValue, $this->month_charge->ReadOnly);

        // quarter_charge
        $this->quarter_charge->setDbValueDef($rsnew, $this->quarter_charge->CurrentValue, $this->quarter_charge->ReadOnly);

        // annual_charge
        $this->annual_charge->setDbValueDef($rsnew, $this->annual_charge->CurrentValue, $this->annual_charge->ReadOnly);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['location'])) { // location
            $this->location->CurrentValue = $row['location'];
        }
        if (isset($row['grp'])) { // grp
            $this->grp->CurrentValue = $row['grp'];
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->CurrentValue = $row['s_grp'];
        }
        if (isset($row['description'])) { // description
            $this->description->CurrentValue = $row['description'];
        }
        if (isset($row['code'])) { // code
            $this->code->CurrentValue = $row['code'];
        }
        if (isset($row['minimum'])) { // minimum
            $this->minimum->CurrentValue = $row['minimum'];
        }
        if (isset($row['maximum'])) { // maximum
            $this->maximum->CurrentValue = $row['maximum'];
        }
        if (isset($row['int_@'])) { // int_@
            $this->int_->CurrentValue = $row['int_@'];
        }
        if (isset($row['no_of_emi'])) { // no_of_emi
            $this->no_of_emi->CurrentValue = $row['no_of_emi'];
        }
        if (isset($row['repay_frequency'])) { // repay_frequency
            $this->repay_frequency->CurrentValue = $row['repay_frequency'];
        }
        if (isset($row['one_time_charge'])) { // one_time_charge
            $this->one_time_charge->CurrentValue = $row['one_time_charge'];
        }
        if (isset($row['action_charge'])) { // action_charge
            $this->action_charge->CurrentValue = $row['action_charge'];
        }
        if (isset($row['month_charge'])) { // month_charge
            $this->month_charge->CurrentValue = $row['month_charge'];
        }
        if (isset($row['quarter_charge'])) { // quarter_charge
            $this->quarter_charge->CurrentValue = $row['quarter_charge'];
        }
        if (isset($row['annual_charge'])) { // annual_charge
            $this->annual_charge->CurrentValue = $row['annual_charge'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("baccounttypelist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_repay_frequency":
                    break;
                case "x_one_time_charge":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_action_charge":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_month_charge":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_quarter_charge":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_annual_charge":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
