<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BAccountInfoUpdate extends BAccountInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "update";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BAccountInfoUpdate";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "baccountinfoupdate";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->b_type->setVisibility();
        $this->grp->setVisibility();
        $this->branch->setVisibility();
        $this->category->Visible = false;
        $this->account_type->setVisibility();
        $this->type->setVisibility();
        $this->formal_name->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->image->setVisibility();
        $this->sign_image->setVisibility();
        $this->status->setVisibility();
        $this->aadhaar_no->setVisibility();
        $this->pan_no->setVisibility();
        $this->id_proof->setVisibility();
        $this->agent->setVisibility();
        $this->other_details->setVisibility();
        $this->bank_name->setVisibility();
        $this->bank_ifsc_code->setVisibility();
        $this->bank_account_no->setVisibility();
        $this->account_no->setVisibility();
        $this->loan_amount->setVisibility();
        $this->emi_amount->setVisibility();
        $this->frequency->setVisibility();
        $this->disbursement_amount->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->d_operator->setVisibility();
        $this->d_datetime->setVisibility();
        $this->otp->Visible = false;
        $this->otp_delivery_datetime->Visible = false;
        $this->otp_verify_datetime->Visible = false;
        $this->no_of_emi->setVisibility();
        $this->fund_o->setVisibility();
        $this->fund_o_no->setVisibility();
        $this->int_->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'b_account_info';
        $this->TableName = 'b_account_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-update-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (b_account_info)
        if (!isset($GLOBALS["b_account_info"]) || $GLOBALS["b_account_info"]::class == PROJECT_NAMESPACE . "b_account_info") {
            $GLOBALS["b_account_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "baccountinfoview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $this->sign_image->OldUploadPath = $this->sign_image->getUploadPath(); // PHP
                $this->sign_image->UploadPath = $this->sign_image->OldUploadPath;
                $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
                $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-update-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $RecKeys;
    public $Disabled;
    public $UpdateCount = 0;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->grp->Required = false;
        $this->account_no->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->b_type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->branch);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->agent);
        $this->setupLookupOptions($this->frequency);
        $this->setupLookupOptions($this->fund_o_no);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Try to load keys from list form
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        if (Post("action") !== null && Post("action") !== "") {
            // Get action
            $this->CurrentAction = Post("action");
            $this->loadFormValues(); // Get form values

            // Validate form
            if (!$this->validateForm()) {
                $this->CurrentAction = "show"; // Form error, reset action
                if (!$this->hasInvalidFields()) { // No fields selected
                    $this->setFailureMessage($Language->phrase("NoFieldSelected"));
                }
            }
        } else {
            $this->loadMultiUpdateValues(); // Load initial values to form
        }
        if (count($this->RecKeys) <= 0) {
            $this->terminate("baccountinfolist"); // No records selected, return to list
            return;
        }
        if ($this->isUpdate()) {
                if ($this->updateRows()) { // Update Records based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
                    }

                    // Do not return Json for UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                    }
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([
                        "success" => false,
                        "validation" => $this->getValidationErrors(),
                        "error" => $this->getFailureMessage()
                    ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->restoreFormValues(); // Restore form values
                }
        }

        // Render row
        if ($this->isConfirm()) { // Confirm page
            $this->RowType = RowType::VIEW; // Render view
            $this->Disabled = " disabled";
        } else {
            $this->RowType = RowType::EDIT; // Render edit
            $this->Disabled = "";
        }
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load initial values to form if field values are identical in all selected records
    protected function loadMultiUpdateValues()
    {
        $this->CurrentFilter = $this->getFilterFromRecordKeys();

        // Load result set
        if ($rs = $this->loadRecordset()) {
            $i = 1;
            while ($row = $rs->fetch()) {
                if ($i == 1) {
                    $this->b_type->setDbValue($row['b_type']);
                    $this->grp->setDbValue($row['grp']);
                    $this->branch->setDbValue($row['branch']);
                    $this->account_type->setDbValue($row['account_type']);
                    $this->type->setDbValue($row['type']);
                    $this->formal_name->setDbValue($row['formal_name']);
                    $this->mobile->setDbValue($row['mobile']);
                    $this->_email->setDbValue($row['email']);
                    $this->status->setDbValue($row['status']);
                    $this->aadhaar_no->setDbValue($row['aadhaar_no']);
                    $this->pan_no->setDbValue($row['pan_no']);
                    $this->agent->setDbValue($row['agent']);
                    $this->other_details->setDbValue($row['other_details']);
                    $this->bank_name->setDbValue($row['bank_name']);
                    $this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
                    $this->bank_account_no->setDbValue($row['bank_account_no']);
                    $this->account_no->setDbValue($row['account_no']);
                    $this->loan_amount->setDbValue($row['loan_amount']);
                    $this->emi_amount->setDbValue($row['emi_amount']);
                    $this->frequency->setDbValue($row['frequency']);
                    $this->disbursement_amount->setDbValue($row['disbursement_amount']);
                    $this->operator->setDbValue($row['operator']);
                    $this->datetime->setDbValue($row['datetime']);
                    $this->d_operator->setDbValue($row['d_operator']);
                    $this->d_datetime->setDbValue($row['d_datetime']);
                    $this->no_of_emi->setDbValue($row['no_of_emi']);
                    $this->fund_o->setDbValue($row['fund_o']);
                    $this->fund_o_no->setDbValue($row['fund_o_no']);
                    $this->int_->setDbValue($row['int_@']);
                } else {
                    if (!CompareValue($this->b_type->DbValue, $row['b_type'])) {
                        $this->b_type->CurrentValue = null;
                    }
                    if (!CompareValue($this->grp->DbValue, $row['grp'])) {
                        $this->grp->CurrentValue = null;
                    }
                    if (!CompareValue($this->branch->DbValue, $row['branch'])) {
                        $this->branch->CurrentValue = null;
                    }
                    if (!CompareValue($this->account_type->DbValue, $row['account_type'])) {
                        $this->account_type->CurrentValue = null;
                    }
                    if (!CompareValue($this->type->DbValue, $row['type'])) {
                        $this->type->CurrentValue = null;
                    }
                    if (!CompareValue($this->formal_name->DbValue, $row['formal_name'])) {
                        $this->formal_name->CurrentValue = null;
                    }
                    if (!CompareValue($this->mobile->DbValue, $row['mobile'])) {
                        $this->mobile->CurrentValue = null;
                    }
                    if (!CompareValue($this->_email->DbValue, $row['email'])) {
                        $this->_email->CurrentValue = null;
                    }
                    if (!CompareValue($this->status->DbValue, $row['status'])) {
                        $this->status->CurrentValue = null;
                    }
                    if (!CompareValue($this->aadhaar_no->DbValue, $row['aadhaar_no'])) {
                        $this->aadhaar_no->CurrentValue = null;
                    }
                    if (!CompareValue($this->pan_no->DbValue, $row['pan_no'])) {
                        $this->pan_no->CurrentValue = null;
                    }
                    if (!CompareValue($this->agent->DbValue, $row['agent'])) {
                        $this->agent->CurrentValue = null;
                    }
                    if (!CompareValue($this->other_details->DbValue, $row['other_details'])) {
                        $this->other_details->CurrentValue = null;
                    }
                    if (!CompareValue($this->bank_name->DbValue, $row['bank_name'])) {
                        $this->bank_name->CurrentValue = null;
                    }
                    if (!CompareValue($this->bank_ifsc_code->DbValue, $row['bank_ifsc_code'])) {
                        $this->bank_ifsc_code->CurrentValue = null;
                    }
                    if (!CompareValue($this->bank_account_no->DbValue, $row['bank_account_no'])) {
                        $this->bank_account_no->CurrentValue = null;
                    }
                    if (!CompareValue($this->account_no->DbValue, $row['account_no'])) {
                        $this->account_no->CurrentValue = null;
                    }
                    if (!CompareValue($this->loan_amount->DbValue, $row['loan_amount'])) {
                        $this->loan_amount->CurrentValue = null;
                    }
                    if (!CompareValue($this->emi_amount->DbValue, $row['emi_amount'])) {
                        $this->emi_amount->CurrentValue = null;
                    }
                    if (!CompareValue($this->frequency->DbValue, $row['frequency'])) {
                        $this->frequency->CurrentValue = null;
                    }
                    if (!CompareValue($this->disbursement_amount->DbValue, $row['disbursement_amount'])) {
                        $this->disbursement_amount->CurrentValue = null;
                    }
                    if (!CompareValue($this->operator->DbValue, $row['operator'])) {
                        $this->operator->CurrentValue = null;
                    }
                    if (!CompareValue($this->datetime->DbValue, $row['datetime'])) {
                        $this->datetime->CurrentValue = null;
                    }
                    if (!CompareValue($this->d_operator->DbValue, $row['d_operator'])) {
                        $this->d_operator->CurrentValue = null;
                    }
                    if (!CompareValue($this->d_datetime->DbValue, $row['d_datetime'])) {
                        $this->d_datetime->CurrentValue = null;
                    }
                    if (!CompareValue($this->no_of_emi->DbValue, $row['no_of_emi'])) {
                        $this->no_of_emi->CurrentValue = null;
                    }
                    if (!CompareValue($this->fund_o->DbValue, $row['fund_o'])) {
                        $this->fund_o->CurrentValue = null;
                    }
                    if (!CompareValue($this->fund_o_no->DbValue, $row['fund_o_no'])) {
                        $this->fund_o_no->CurrentValue = null;
                    }
                    if (!CompareValue($this->int_->DbValue, $row['int_@'])) {
                        $this->int_->CurrentValue = null;
                    }
                }
                $i++;
            }
            $rs->free();
        }
    }

    // Set up key value
    protected function setupKeyValues($key)
    {
        $keyFld = $key;
        if (!is_numeric($keyFld)) {
            return false;
        }
        $this->id->OldValue = $keyFld;
        return true;
    }

    // Update all selected rows
    protected function updateRows()
    {
        global $Language;
        $conn = $this->getConnection();
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->AuditTrailOnEdit) {
            $this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin
        }

        // Get old records
        $this->CurrentFilter = $this->getFilterFromRecordKeys(false);
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAllAssociative($sql);

        // Update all rows
        $successKeys = [];
        $failKeys = [];
        foreach ($this->RecKeys as $reckey) {
            if ($this->setupKeyValues($reckey)) {
                $thisKey = $reckey;
                $this->SendEmail = false; // Do not send email on update success
                $this->UpdateCount += 1; // Update record count for records being updated
                $rowUpdated = $this->editRow(); // Update this row
            } else {
                $rowUpdated = false;
            }
            if (!$rowUpdated) {
                if ($this->UseTransaction) { // Update failed
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                $successKeys[] = $thisKey;
            }
        }

        // Check if any rows updated
        if (count($successKeys) > 0) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if update some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("UpdateSomeRecordsFailed")));
            }

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
            }
            return true;
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
            }
            return false;
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->image->Upload->Index = $CurrentForm->Index;
        $this->image->Upload->uploadFile();
        $this->image->CurrentValue = $this->image->Upload->FileName;
        $this->image->MultiUpdate = $CurrentForm->getValue("u_image");
        $this->sign_image->Upload->Index = $CurrentForm->Index;
        $this->sign_image->Upload->uploadFile();
        $this->sign_image->CurrentValue = $this->sign_image->Upload->FileName;
        $this->sign_image->MultiUpdate = $CurrentForm->getValue("u_sign_image");
        $this->id_proof->Upload->Index = $CurrentForm->Index;
        $this->id_proof->Upload->uploadFile();
        $this->id_proof->CurrentValue = $this->id_proof->Upload->FileName;
        $this->id_proof->MultiUpdate = $CurrentForm->getValue("u_id_proof");
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'b_type' first before field var 'x_b_type'
        $val = $CurrentForm->hasValue("b_type") ? $CurrentForm->getValue("b_type") : $CurrentForm->getValue("x_b_type");
        if (!$this->b_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_type->Visible = false; // Disable update for API request
            } else {
                $this->b_type->setFormValue($val);
            }
        }
        $this->b_type->MultiUpdate = $CurrentForm->getValue("u_b_type");

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }
        $this->grp->MultiUpdate = $CurrentForm->getValue("u_grp");

        // Check field name 'branch' first before field var 'x_branch'
        $val = $CurrentForm->hasValue("branch") ? $CurrentForm->getValue("branch") : $CurrentForm->getValue("x_branch");
        if (!$this->branch->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->branch->Visible = false; // Disable update for API request
            } else {
                $this->branch->setFormValue($val);
            }
        }
        $this->branch->MultiUpdate = $CurrentForm->getValue("u_branch");

        // Check field name 'account_type' first before field var 'x_account_type'
        $val = $CurrentForm->hasValue("account_type") ? $CurrentForm->getValue("account_type") : $CurrentForm->getValue("x_account_type");
        if (!$this->account_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->account_type->Visible = false; // Disable update for API request
            } else {
                $this->account_type->setFormValue($val, true, $validate);
            }
        }
        $this->account_type->MultiUpdate = $CurrentForm->getValue("u_account_type");

        // Check field name 'type' first before field var 'x_type'
        $val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
        if (!$this->type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->type->Visible = false; // Disable update for API request
            } else {
                $this->type->setFormValue($val);
            }
        }
        $this->type->MultiUpdate = $CurrentForm->getValue("u_type");

        // Check field name 'formal_name' first before field var 'x_formal_name'
        $val = $CurrentForm->hasValue("formal_name") ? $CurrentForm->getValue("formal_name") : $CurrentForm->getValue("x_formal_name");
        if (!$this->formal_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->formal_name->Visible = false; // Disable update for API request
            } else {
                $this->formal_name->setFormValue($val);
            }
        }
        $this->formal_name->MultiUpdate = $CurrentForm->getValue("u_formal_name");

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val, true, $validate);
            }
        }
        $this->mobile->MultiUpdate = $CurrentForm->getValue("u_mobile");

        // Check field name 'email' first before field var 'x__email'
        $val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
        if (!$this->_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_email->Visible = false; // Disable update for API request
            } else {
                $this->_email->setFormValue($val, true, $validate);
            }
        }
        $this->_email->MultiUpdate = $CurrentForm->getValue("u__email");

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val, true, $validate);
            }
        }
        $this->status->MultiUpdate = $CurrentForm->getValue("u_status");

        // Check field name 'aadhaar_no' first before field var 'x_aadhaar_no'
        $val = $CurrentForm->hasValue("aadhaar_no") ? $CurrentForm->getValue("aadhaar_no") : $CurrentForm->getValue("x_aadhaar_no");
        if (!$this->aadhaar_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->aadhaar_no->Visible = false; // Disable update for API request
            } else {
                $this->aadhaar_no->setFormValue($val, true, $validate);
            }
        }
        $this->aadhaar_no->MultiUpdate = $CurrentForm->getValue("u_aadhaar_no");

        // Check field name 'pan_no' first before field var 'x_pan_no'
        $val = $CurrentForm->hasValue("pan_no") ? $CurrentForm->getValue("pan_no") : $CurrentForm->getValue("x_pan_no");
        if (!$this->pan_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pan_no->Visible = false; // Disable update for API request
            } else {
                $this->pan_no->setFormValue($val, true, $validate);
            }
        }
        $this->pan_no->MultiUpdate = $CurrentForm->getValue("u_pan_no");

        // Check field name 'agent' first before field var 'x_agent'
        $val = $CurrentForm->hasValue("agent") ? $CurrentForm->getValue("agent") : $CurrentForm->getValue("x_agent");
        if (!$this->agent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->agent->Visible = false; // Disable update for API request
            } else {
                $this->agent->setFormValue($val);
            }
        }
        $this->agent->MultiUpdate = $CurrentForm->getValue("u_agent");

        // Check field name 'other_details' first before field var 'x_other_details'
        $val = $CurrentForm->hasValue("other_details") ? $CurrentForm->getValue("other_details") : $CurrentForm->getValue("x_other_details");
        if (!$this->other_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other_details->Visible = false; // Disable update for API request
            } else {
                $this->other_details->setFormValue($val);
            }
        }
        $this->other_details->MultiUpdate = $CurrentForm->getValue("u_other_details");

        // Check field name 'bank_name' first before field var 'x_bank_name'
        $val = $CurrentForm->hasValue("bank_name") ? $CurrentForm->getValue("bank_name") : $CurrentForm->getValue("x_bank_name");
        if (!$this->bank_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_name->Visible = false; // Disable update for API request
            } else {
                $this->bank_name->setFormValue($val);
            }
        }
        $this->bank_name->MultiUpdate = $CurrentForm->getValue("u_bank_name");

        // Check field name 'bank_ifsc_code' first before field var 'x_bank_ifsc_code'
        $val = $CurrentForm->hasValue("bank_ifsc_code") ? $CurrentForm->getValue("bank_ifsc_code") : $CurrentForm->getValue("x_bank_ifsc_code");
        if (!$this->bank_ifsc_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_ifsc_code->Visible = false; // Disable update for API request
            } else {
                $this->bank_ifsc_code->setFormValue($val);
            }
        }
        $this->bank_ifsc_code->MultiUpdate = $CurrentForm->getValue("u_bank_ifsc_code");

        // Check field name 'bank_account_no' first before field var 'x_bank_account_no'
        $val = $CurrentForm->hasValue("bank_account_no") ? $CurrentForm->getValue("bank_account_no") : $CurrentForm->getValue("x_bank_account_no");
        if (!$this->bank_account_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_account_no->Visible = false; // Disable update for API request
            } else {
                $this->bank_account_no->setFormValue($val);
            }
        }
        $this->bank_account_no->MultiUpdate = $CurrentForm->getValue("u_bank_account_no");

        // Check field name 'account_no' first before field var 'x_account_no'
        $val = $CurrentForm->hasValue("account_no") ? $CurrentForm->getValue("account_no") : $CurrentForm->getValue("x_account_no");
        if (!$this->account_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->account_no->Visible = false; // Disable update for API request
            } else {
                $this->account_no->setFormValue($val);
            }
        }
        $this->account_no->MultiUpdate = $CurrentForm->getValue("u_account_no");

        // Check field name 'loan_amount' first before field var 'x_loan_amount'
        $val = $CurrentForm->hasValue("loan_amount") ? $CurrentForm->getValue("loan_amount") : $CurrentForm->getValue("x_loan_amount");
        if (!$this->loan_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->loan_amount->Visible = false; // Disable update for API request
            } else {
                $this->loan_amount->setFormValue($val, true, $validate);
            }
        }
        $this->loan_amount->MultiUpdate = $CurrentForm->getValue("u_loan_amount");

        // Check field name 'emi_amount' first before field var 'x_emi_amount'
        $val = $CurrentForm->hasValue("emi_amount") ? $CurrentForm->getValue("emi_amount") : $CurrentForm->getValue("x_emi_amount");
        if (!$this->emi_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->emi_amount->Visible = false; // Disable update for API request
            } else {
                $this->emi_amount->setFormValue($val, true, $validate);
            }
        }
        $this->emi_amount->MultiUpdate = $CurrentForm->getValue("u_emi_amount");

        // Check field name 'frequency' first before field var 'x_frequency'
        $val = $CurrentForm->hasValue("frequency") ? $CurrentForm->getValue("frequency") : $CurrentForm->getValue("x_frequency");
        if (!$this->frequency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->frequency->Visible = false; // Disable update for API request
            } else {
                $this->frequency->setFormValue($val);
            }
        }
        $this->frequency->MultiUpdate = $CurrentForm->getValue("u_frequency");

        // Check field name 'disbursement_amount' first before field var 'x_disbursement_amount'
        $val = $CurrentForm->hasValue("disbursement_amount") ? $CurrentForm->getValue("disbursement_amount") : $CurrentForm->getValue("x_disbursement_amount");
        if (!$this->disbursement_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->disbursement_amount->Visible = false; // Disable update for API request
            } else {
                $this->disbursement_amount->setFormValue($val, true, $validate);
            }
        }
        $this->disbursement_amount->MultiUpdate = $CurrentForm->getValue("u_disbursement_amount");

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }
        $this->operator->MultiUpdate = $CurrentForm->getValue("u_operator");

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
        $this->datetime->MultiUpdate = $CurrentForm->getValue("u_datetime");

        // Check field name 'd_operator' first before field var 'x_d_operator'
        $val = $CurrentForm->hasValue("d_operator") ? $CurrentForm->getValue("d_operator") : $CurrentForm->getValue("x_d_operator");
        if (!$this->d_operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_operator->Visible = false; // Disable update for API request
            } else {
                $this->d_operator->setFormValue($val);
            }
        }
        $this->d_operator->MultiUpdate = $CurrentForm->getValue("u_d_operator");

        // Check field name 'd_datetime' first before field var 'x_d_datetime'
        $val = $CurrentForm->hasValue("d_datetime") ? $CurrentForm->getValue("d_datetime") : $CurrentForm->getValue("x_d_datetime");
        if (!$this->d_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_datetime->Visible = false; // Disable update for API request
            } else {
                $this->d_datetime->setFormValue($val);
            }
            $this->d_datetime->CurrentValue = UnFormatDateTime($this->d_datetime->CurrentValue, $this->d_datetime->formatPattern());
        }
        $this->d_datetime->MultiUpdate = $CurrentForm->getValue("u_d_datetime");

        // Check field name 'no_of_emi' first before field var 'x_no_of_emi'
        $val = $CurrentForm->hasValue("no_of_emi") ? $CurrentForm->getValue("no_of_emi") : $CurrentForm->getValue("x_no_of_emi");
        if (!$this->no_of_emi->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->no_of_emi->Visible = false; // Disable update for API request
            } else {
                $this->no_of_emi->setFormValue($val, true, $validate);
            }
        }
        $this->no_of_emi->MultiUpdate = $CurrentForm->getValue("u_no_of_emi");

        // Check field name 'fund_o' first before field var 'x_fund_o'
        $val = $CurrentForm->hasValue("fund_o") ? $CurrentForm->getValue("fund_o") : $CurrentForm->getValue("x_fund_o");
        if (!$this->fund_o->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fund_o->Visible = false; // Disable update for API request
            } else {
                $this->fund_o->setFormValue($val, true, $validate);
            }
        }
        $this->fund_o->MultiUpdate = $CurrentForm->getValue("u_fund_o");

        // Check field name 'fund_o_no' first before field var 'x_fund_o_no'
        $val = $CurrentForm->hasValue("fund_o_no") ? $CurrentForm->getValue("fund_o_no") : $CurrentForm->getValue("x_fund_o_no");
        if (!$this->fund_o_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fund_o_no->Visible = false; // Disable update for API request
            } else {
                $this->fund_o_no->setFormValue($val);
            }
        }
        $this->fund_o_no->MultiUpdate = $CurrentForm->getValue("u_fund_o_no");

        // Check field name 'int_@' first before field var 'x_int_'
        $val = $CurrentForm->hasValue("int_@") ? $CurrentForm->getValue("int_@") : $CurrentForm->getValue("x_int_");
        if (!$this->int_->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->int_->Visible = false; // Disable update for API request
            } else {
                $this->int_->setFormValue($val, true, $validate);
            }
        }
        $this->int_->MultiUpdate = $CurrentForm->getValue("u_int_");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }
		$this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
		$this->image->UploadPath = $this->image->OldUploadPath;
		$this->sign_image->OldUploadPath = $this->sign_image->getUploadPath(); // PHP
		$this->sign_image->UploadPath = $this->sign_image->OldUploadPath;
		$this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
		$this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->b_type->CurrentValue = $this->b_type->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->branch->CurrentValue = $this->branch->FormValue;
        $this->account_type->CurrentValue = $this->account_type->FormValue;
        $this->type->CurrentValue = $this->type->FormValue;
        $this->formal_name->CurrentValue = $this->formal_name->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->_email->CurrentValue = $this->_email->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->aadhaar_no->CurrentValue = $this->aadhaar_no->FormValue;
        $this->pan_no->CurrentValue = $this->pan_no->FormValue;
        $this->agent->CurrentValue = $this->agent->FormValue;
        $this->other_details->CurrentValue = $this->other_details->FormValue;
        $this->bank_name->CurrentValue = $this->bank_name->FormValue;
        $this->bank_ifsc_code->CurrentValue = $this->bank_ifsc_code->FormValue;
        $this->bank_account_no->CurrentValue = $this->bank_account_no->FormValue;
        $this->account_no->CurrentValue = $this->account_no->FormValue;
        $this->loan_amount->CurrentValue = $this->loan_amount->FormValue;
        $this->emi_amount->CurrentValue = $this->emi_amount->FormValue;
        $this->frequency->CurrentValue = $this->frequency->FormValue;
        $this->disbursement_amount->CurrentValue = $this->disbursement_amount->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->d_operator->CurrentValue = $this->d_operator->FormValue;
        $this->d_datetime->CurrentValue = $this->d_datetime->FormValue;
        $this->d_datetime->CurrentValue = UnFormatDateTime($this->d_datetime->CurrentValue, $this->d_datetime->formatPattern());
        $this->no_of_emi->CurrentValue = $this->no_of_emi->FormValue;
        $this->fund_o->CurrentValue = $this->fund_o->FormValue;
        $this->fund_o_no->CurrentValue = $this->fund_o_no->FormValue;
        $this->int_->CurrentValue = $this->int_->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->b_type->setDbValue($row['b_type']);
        $this->grp->setDbValue($row['grp']);
        $this->branch->setDbValue($row['branch']);
        $this->category->setDbValue($row['category']);
        $this->account_type->setDbValue($row['account_type']);
        $this->type->setDbValue($row['type']);
        $this->formal_name->setDbValue($row['formal_name']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->sign_image->Upload->DbValue = $row['sign_image'];
        $this->sign_image->setDbValue($this->sign_image->Upload->DbValue);
        $this->status->setDbValue($row['status']);
        $this->aadhaar_no->setDbValue($row['aadhaar_no']);
        $this->pan_no->setDbValue($row['pan_no']);
        $this->id_proof->Upload->DbValue = $row['id_proof'];
        $this->id_proof->setDbValue($this->id_proof->Upload->DbValue);
        $this->agent->setDbValue($row['agent']);
        $this->other_details->setDbValue($row['other_details']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->account_no->setDbValue($row['account_no']);
        $this->loan_amount->setDbValue($row['loan_amount']);
        $this->emi_amount->setDbValue($row['emi_amount']);
        $this->frequency->setDbValue($row['frequency']);
        $this->disbursement_amount->setDbValue($row['disbursement_amount']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->d_operator->setDbValue($row['d_operator']);
        $this->d_datetime->setDbValue($row['d_datetime']);
        $this->otp->setDbValue($row['otp']);
        $this->otp_delivery_datetime->setDbValue($row['otp_delivery_datetime']);
        $this->otp_verify_datetime->setDbValue($row['otp_verify_datetime']);
        $this->no_of_emi->setDbValue($row['no_of_emi']);
        $this->fund_o->setDbValue($row['fund_o']);
        $this->fund_o_no->setDbValue($row['fund_o_no']);
        $this->int_->setDbValue($row['int_@']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['b_type'] = $this->b_type->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['branch'] = $this->branch->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['account_type'] = $this->account_type->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['formal_name'] = $this->formal_name->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['sign_image'] = $this->sign_image->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['aadhaar_no'] = $this->aadhaar_no->DefaultValue;
        $row['pan_no'] = $this->pan_no->DefaultValue;
        $row['id_proof'] = $this->id_proof->DefaultValue;
        $row['agent'] = $this->agent->DefaultValue;
        $row['other_details'] = $this->other_details->DefaultValue;
        $row['bank_name'] = $this->bank_name->DefaultValue;
        $row['bank_ifsc_code'] = $this->bank_ifsc_code->DefaultValue;
        $row['bank_account_no'] = $this->bank_account_no->DefaultValue;
        $row['account_no'] = $this->account_no->DefaultValue;
        $row['loan_amount'] = $this->loan_amount->DefaultValue;
        $row['emi_amount'] = $this->emi_amount->DefaultValue;
        $row['frequency'] = $this->frequency->DefaultValue;
        $row['disbursement_amount'] = $this->disbursement_amount->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['d_operator'] = $this->d_operator->DefaultValue;
        $row['d_datetime'] = $this->d_datetime->DefaultValue;
        $row['otp'] = $this->otp->DefaultValue;
        $row['otp_delivery_datetime'] = $this->otp_delivery_datetime->DefaultValue;
        $row['otp_verify_datetime'] = $this->otp_verify_datetime->DefaultValue;
        $row['no_of_emi'] = $this->no_of_emi->DefaultValue;
        $row['fund_o'] = $this->fund_o->DefaultValue;
        $row['fund_o_no'] = $this->fund_o_no->DefaultValue;
        $row['int_@'] = $this->int_->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // b_type
        $this->b_type->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // branch
        $this->branch->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // account_type
        $this->account_type->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // formal_name
        $this->formal_name->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // sign_image
        $this->sign_image->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // aadhaar_no
        $this->aadhaar_no->RowCssClass = "row";

        // pan_no
        $this->pan_no->RowCssClass = "row";

        // id_proof
        $this->id_proof->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // other_details
        $this->other_details->RowCssClass = "row";

        // bank_name
        $this->bank_name->RowCssClass = "row";

        // bank_ifsc_code
        $this->bank_ifsc_code->RowCssClass = "row";

        // bank_account_no
        $this->bank_account_no->RowCssClass = "row";

        // account_no
        $this->account_no->RowCssClass = "row";

        // loan_amount
        $this->loan_amount->RowCssClass = "row";

        // emi_amount
        $this->emi_amount->RowCssClass = "row";

        // frequency
        $this->frequency->RowCssClass = "row";

        // disbursement_amount
        $this->disbursement_amount->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // d_operator
        $this->d_operator->RowCssClass = "row";

        // d_datetime
        $this->d_datetime->RowCssClass = "row";

        // otp
        $this->otp->RowCssClass = "row";

        // otp_delivery_datetime
        $this->otp_delivery_datetime->RowCssClass = "row";

        // otp_verify_datetime
        $this->otp_verify_datetime->RowCssClass = "row";

        // no_of_emi
        $this->no_of_emi->RowCssClass = "row";

        // fund_o
        $this->fund_o->RowCssClass = "row";

        // fund_o_no
        $this->fund_o_no->RowCssClass = "row";

        // int_@
        $this->int_->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // b_type
            if (strval($this->b_type->CurrentValue) != "") {
                $this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
            } else {
                $this->b_type->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // branch
            $curVal = strval($this->branch->CurrentValue);
            if ($curVal != "") {
                $this->branch->ViewValue = $this->branch->lookupCacheOption($curVal);
                if ($this->branch->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->branch->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->branch->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->branch->getSelectFilter($this); // PHP
                    $sqlWrk = $this->branch->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->branch->Lookup->renderViewRow($rswrk[0]);
                        $this->branch->ViewValue = $this->branch->displayValue($arwrk);
                    } else {
                        $this->branch->ViewValue = FormatNumber($this->branch->CurrentValue, $this->branch->formatPattern());
                    }
                }
            } else {
                $this->branch->ViewValue = null;
            }

            // category
            if (strval($this->category->CurrentValue) != "") {
                $this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
            } else {
                $this->category->ViewValue = null;
            }

            // account_type
            $this->account_type->ViewValue = $this->account_type->CurrentValue;
            $this->account_type->ViewValue = FormatNumber($this->account_type->ViewValue, $this->account_type->formatPattern());

            // type
            $curVal = strval($this->type->CurrentValue);
            if ($curVal != "") {
                $this->type->ViewValue = $this->type->lookupCacheOption($curVal);
                if ($this->type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->type->Lookup->renderViewRow($rswrk[0]);
                        $this->type->ViewValue = $this->type->displayValue($arwrk);
                    } else {
                        $this->type->ViewValue = FormatNumber($this->type->CurrentValue, $this->type->formatPattern());
                    }
                }
            } else {
                $this->type->ViewValue = null;
            }

            // formal_name
            $this->formal_name->ViewValue = $this->formal_name->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // sign_image
            $this->sign_image->UploadPath = $this->sign_image->getUploadPath(); // PHP
            if (!EmptyValue($this->sign_image->Upload->DbValue)) {
                $this->sign_image->ViewValue = $this->sign_image->Upload->DbValue;
            } else {
                $this->sign_image->ViewValue = "";
            }

            // status
            $this->status->ViewValue = $this->status->CurrentValue;
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // pan_no
            $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

            // id_proof
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->ViewValue = "";
            }

            // agent
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->ViewValue = $this->agent->CurrentValue;
                    }
                }
            } else {
                $this->agent->ViewValue = null;
            }

            // other_details
            $this->other_details->ViewValue = $this->other_details->CurrentValue;

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_ifsc_code
            $this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // account_no
            $this->account_no->ViewValue = $this->account_no->CurrentValue;

            // loan_amount
            $this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
            $this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, $this->loan_amount->formatPattern());

            // emi_amount
            $this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
            $this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, $this->emi_amount->formatPattern());

            // frequency
            if (strval($this->frequency->CurrentValue) != "") {
                $this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
            } else {
                $this->frequency->ViewValue = null;
            }

            // disbursement_amount
            $this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
            $this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, $this->disbursement_amount->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // d_operator
            $this->d_operator->ViewValue = $this->d_operator->CurrentValue;
            $this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, $this->d_operator->formatPattern());

            // d_datetime
            $this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
            $this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, $this->d_datetime->formatPattern());

            // otp_delivery_datetime
            $this->otp_delivery_datetime->ViewValue = $this->otp_delivery_datetime->CurrentValue;
            $this->otp_delivery_datetime->ViewValue = FormatDateTime($this->otp_delivery_datetime->ViewValue, $this->otp_delivery_datetime->formatPattern());

            // otp_verify_datetime
            $this->otp_verify_datetime->ViewValue = $this->otp_verify_datetime->CurrentValue;
            $this->otp_verify_datetime->ViewValue = FormatDateTime($this->otp_verify_datetime->ViewValue, $this->otp_verify_datetime->formatPattern());

            // no_of_emi
            $this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
            $this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, $this->no_of_emi->formatPattern());

            // fund_o
            $this->fund_o->ViewValue = $this->fund_o->CurrentValue;
            $this->fund_o->ViewValue = FormatNumber($this->fund_o->ViewValue, $this->fund_o->formatPattern());

            // fund_o_no
            $curVal = strval($this->fund_o_no->CurrentValue);
            if ($curVal != "") {
                $this->fund_o_no->ViewValue = $this->fund_o_no->lookupCacheOption($curVal);
                if ($this->fund_o_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->fund_o_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->fund_o_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->fund_o_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->fund_o_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->fund_o_no->Lookup->renderViewRow($rswrk[0]);
                        $this->fund_o_no->ViewValue = $this->fund_o_no->displayValue($arwrk);
                    } else {
                        $this->fund_o_no->ViewValue = $this->fund_o_no->CurrentValue;
                    }
                }
            } else {
                $this->fund_o_no->ViewValue = null;
            }

            // int_@
            $this->int_->ViewValue = $this->int_->CurrentValue;
            $this->int_->ViewValue = FormatNumber($this->int_->ViewValue, $this->int_->formatPattern());

            // b_type
            $this->b_type->HrefValue = "";
            $this->b_type->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // branch
            $this->branch->HrefValue = "";
            $this->branch->TooltipValue = "";

            // account_type
            $this->account_type->HrefValue = "";
            $this->account_type->TooltipValue = "";

            // type
            $this->type->HrefValue = "";
            $this->type->TooltipValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";
            $this->formal_name->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // email
            $this->_email->HrefValue = "";
            $this->_email->TooltipValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";

            // sign_image
            $this->sign_image->HrefValue = "";
            $this->sign_image->ExportHrefValue = $this->sign_image->UploadPath . $this->sign_image->Upload->DbValue;
            $this->sign_image->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";
            $this->aadhaar_no->TooltipValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";
            $this->pan_no->TooltipValue = "";

            // id_proof
            $this->id_proof->LinkCustomAttributes = $this->id_proof->getLinkCustomAttributes(); // PHP
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->HrefValue = "%u"; // Add prefix/suffix
                $this->id_proof->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->id_proof->HrefValue = FullUrl($this->id_proof->HrefValue, "href");
                }
            } else {
                $this->id_proof->HrefValue = "";
            }
            $this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
            $this->id_proof->TooltipValue = "";

            // agent
            $this->agent->HrefValue = "";
            $this->agent->TooltipValue = "";

            // other_details
            $this->other_details->HrefValue = "";
            $this->other_details->TooltipValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";
            $this->bank_name->TooltipValue = "";

            // bank_ifsc_code
            $this->bank_ifsc_code->HrefValue = "";
            $this->bank_ifsc_code->TooltipValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";
            $this->bank_account_no->TooltipValue = "";

            // account_no
            $this->account_no->HrefValue = "";
            $this->account_no->TooltipValue = "";

            // loan_amount
            $this->loan_amount->HrefValue = "";
            $this->loan_amount->TooltipValue = "";

            // emi_amount
            $this->emi_amount->HrefValue = "";
            $this->emi_amount->TooltipValue = "";

            // frequency
            $this->frequency->HrefValue = "";
            $this->frequency->TooltipValue = "";

            // disbursement_amount
            $this->disbursement_amount->HrefValue = "";
            $this->disbursement_amount->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // d_operator
            $this->d_operator->HrefValue = "";
            $this->d_operator->TooltipValue = "";

            // d_datetime
            $this->d_datetime->HrefValue = "";
            $this->d_datetime->TooltipValue = "";

            // no_of_emi
            $this->no_of_emi->HrefValue = "";
            $this->no_of_emi->TooltipValue = "";

            // fund_o
            $this->fund_o->HrefValue = "";
            $this->fund_o->TooltipValue = "";

            // fund_o_no
            $this->fund_o_no->HrefValue = "";
            $this->fund_o_no->TooltipValue = "";

            // int_@
            $this->int_->HrefValue = "";
            $this->int_->TooltipValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // b_type
            $this->b_type->setupEditAttributes();
            $this->b_type->EditValue = $this->b_type->options(true);
            $this->b_type->PlaceHolder = RemoveHtml($this->b_type->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->EditValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->EditValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->EditValue = null;
            }

            // branch
            $this->branch->setupEditAttributes();
            $curVal = trim(strval($this->branch->CurrentValue));
            if ($curVal != "") {
                $this->branch->ViewValue = $this->branch->lookupCacheOption($curVal);
            } else {
                $this->branch->ViewValue = $this->branch->Lookup !== null && is_array($this->branch->lookupOptions()) && count($this->branch->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->branch->ViewValue !== null) { // Load from cache
                $this->branch->EditValue = array_values($this->branch->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->branch->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->branch->CurrentValue, $this->branch->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->branch->getSelectFilter($this); // PHP
                $sqlWrk = $this->branch->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->branch->EditValue = $arwrk;
            }
            $this->branch->PlaceHolder = RemoveHtml($this->branch->caption());

            // account_type
            $this->account_type->setupEditAttributes();
            $this->account_type->EditValue = $this->account_type->CurrentValue;
            $this->account_type->PlaceHolder = RemoveHtml($this->account_type->caption());
            if (strval($this->account_type->EditValue) != "" && is_numeric($this->account_type->EditValue)) {
                $this->account_type->EditValue = FormatNumber($this->account_type->EditValue, null);
            }

            // type
            $this->type->setupEditAttributes();
            $curVal = trim(strval($this->type->CurrentValue));
            if ($curVal != "") {
                $this->type->ViewValue = $this->type->lookupCacheOption($curVal);
            } else {
                $this->type->ViewValue = $this->type->Lookup !== null && is_array($this->type->lookupOptions()) && count($this->type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->type->ViewValue !== null) { // Load from cache
                $this->type->EditValue = array_values($this->type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->type->CurrentValue, $this->type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->type->getSelectFilter($this); // PHP
                $sqlWrk = $this->type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->type->EditValue = $arwrk;
            }
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());

            // formal_name
            $this->formal_name->setupEditAttributes();
            if (!$this->formal_name->Raw) {
                $this->formal_name->CurrentValue = HtmlDecode($this->formal_name->CurrentValue);
            }
            $this->formal_name->EditValue = HtmlEncode($this->formal_name->CurrentValue);
            $this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->CurrentValue;
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());
            if (strval($this->mobile->EditValue) != "" && is_numeric($this->mobile->EditValue)) {
                $this->mobile->EditValue = FormatNumber($this->mobile->EditValue, null);
            }

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // image
            $this->image->setupEditAttributes();
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->EditValue = $this->image->Upload->DbValue;
            } else {
                $this->image->EditValue = "";
            }
            if (!EmptyValue($this->image->CurrentValue)) {
                $this->image->Upload->FileName = $this->image->CurrentValue;
            }

            // sign_image
            $this->sign_image->setupEditAttributes();
            $this->sign_image->UploadPath = $this->sign_image->getUploadPath(); // PHP
            if (!EmptyValue($this->sign_image->Upload->DbValue)) {
                $this->sign_image->EditValue = $this->sign_image->Upload->DbValue;
            } else {
                $this->sign_image->EditValue = "";
            }
            if (!EmptyValue($this->sign_image->CurrentValue)) {
                $this->sign_image->Upload->FileName = $this->sign_image->CurrentValue;
            }

            // status
            $this->status->setupEditAttributes();
            $this->status->EditCustomAttributes = $this->status->getEditCustomAttributes(); // PHP
            $this->status->EditValue = $this->status->CurrentValue;
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->EditValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->EditValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->EditValue = HtmlEncode(FormatNumber($this->status->CurrentValue, $this->status->formatPattern()));
                    }
                }
            } else {
                $this->status->EditValue = null;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // aadhaar_no
            $this->aadhaar_no->setupEditAttributes();
            if (!$this->aadhaar_no->Raw) {
                $this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
            }
            $this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->CurrentValue);
            $this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

            // pan_no
            $this->pan_no->setupEditAttributes();
            if (!$this->pan_no->Raw) {
                $this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
            }
            $this->pan_no->EditValue = HtmlEncode($this->pan_no->CurrentValue);
            $this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

            // id_proof
            $this->id_proof->setupEditAttributes();
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->EditValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->EditValue = "";
            }
            if (!EmptyValue($this->id_proof->CurrentValue)) {
                $this->id_proof->Upload->FileName = $this->id_proof->CurrentValue;
            }

            // agent
            $this->agent->setupEditAttributes();
            $curVal = trim(strval($this->agent->CurrentValue));
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
            } else {
                $this->agent->ViewValue = $this->agent->Lookup !== null && is_array($this->agent->lookupOptions()) && count($this->agent->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->agent->ViewValue !== null) { // Load from cache
                $this->agent->EditValue = array_values($this->agent->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->agent->CurrentValue, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                $sqlWrk = $this->agent->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->agent->EditValue = $arwrk;
            }
            $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

            // other_details
            $this->other_details->setupEditAttributes();
            if (!$this->other_details->Raw) {
                $this->other_details->CurrentValue = HtmlDecode($this->other_details->CurrentValue);
            }
            $this->other_details->EditValue = HtmlEncode($this->other_details->CurrentValue);
            $this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

            // bank_name
            $this->bank_name->setupEditAttributes();
            if (!$this->bank_name->Raw) {
                $this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
            }
            $this->bank_name->EditValue = HtmlEncode($this->bank_name->CurrentValue);
            $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

            // bank_ifsc_code
            $this->bank_ifsc_code->setupEditAttributes();
            if (!$this->bank_ifsc_code->Raw) {
                $this->bank_ifsc_code->CurrentValue = HtmlDecode($this->bank_ifsc_code->CurrentValue);
            }
            $this->bank_ifsc_code->EditValue = HtmlEncode($this->bank_ifsc_code->CurrentValue);
            $this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

            // bank_account_no
            $this->bank_account_no->setupEditAttributes();
            if (!$this->bank_account_no->Raw) {
                $this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
            }
            $this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->CurrentValue);
            $this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

            // account_no
            $this->account_no->setupEditAttributes();
            $this->account_no->EditCustomAttributes = $this->account_no->getEditCustomAttributes(); // PHP
            $this->account_no->EditValue = $this->account_no->CurrentValue;

            // loan_amount
            $this->loan_amount->setupEditAttributes();
            $this->loan_amount->EditValue = $this->loan_amount->CurrentValue;
            $this->loan_amount->PlaceHolder = RemoveHtml($this->loan_amount->caption());
            if (strval($this->loan_amount->EditValue) != "" && is_numeric($this->loan_amount->EditValue)) {
                $this->loan_amount->EditValue = FormatNumber($this->loan_amount->EditValue, null);
            }

            // emi_amount
            $this->emi_amount->setupEditAttributes();
            $this->emi_amount->EditValue = $this->emi_amount->CurrentValue;
            $this->emi_amount->PlaceHolder = RemoveHtml($this->emi_amount->caption());
            if (strval($this->emi_amount->EditValue) != "" && is_numeric($this->emi_amount->EditValue)) {
                $this->emi_amount->EditValue = FormatNumber($this->emi_amount->EditValue, null);
            }

            // frequency
            $this->frequency->setupEditAttributes();
            $this->frequency->EditValue = $this->frequency->options(true);
            $this->frequency->PlaceHolder = RemoveHtml($this->frequency->caption());

            // disbursement_amount
            $this->disbursement_amount->setupEditAttributes();
            $this->disbursement_amount->EditValue = $this->disbursement_amount->CurrentValue;
            $this->disbursement_amount->PlaceHolder = RemoveHtml($this->disbursement_amount->caption());
            if (strval($this->disbursement_amount->EditValue) != "" && is_numeric($this->disbursement_amount->EditValue)) {
                $this->disbursement_amount->EditValue = FormatNumber($this->disbursement_amount->EditValue, null);
            }

            // operator

            // datetime

            // d_operator

            // d_datetime

            // no_of_emi
            $this->no_of_emi->setupEditAttributes();
            $this->no_of_emi->EditValue = $this->no_of_emi->CurrentValue;
            $this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());
            if (strval($this->no_of_emi->EditValue) != "" && is_numeric($this->no_of_emi->EditValue)) {
                $this->no_of_emi->EditValue = FormatNumber($this->no_of_emi->EditValue, null);
            }

            // fund_o
            $this->fund_o->setupEditAttributes();
            $this->fund_o->EditValue = $this->fund_o->CurrentValue;
            $this->fund_o->PlaceHolder = RemoveHtml($this->fund_o->caption());
            if (strval($this->fund_o->EditValue) != "" && is_numeric($this->fund_o->EditValue)) {
                $this->fund_o->EditValue = FormatNumber($this->fund_o->EditValue, null);
            }

            // fund_o_no
            $this->fund_o_no->setupEditAttributes();
            $curVal = trim(strval($this->fund_o_no->CurrentValue));
            if ($curVal != "") {
                $this->fund_o_no->ViewValue = $this->fund_o_no->lookupCacheOption($curVal);
            } else {
                $this->fund_o_no->ViewValue = $this->fund_o_no->Lookup !== null && is_array($this->fund_o_no->lookupOptions()) && count($this->fund_o_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->fund_o_no->ViewValue !== null) { // Load from cache
                $this->fund_o_no->EditValue = array_values($this->fund_o_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->fund_o_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->fund_o_no->CurrentValue, $this->fund_o_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->fund_o_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->fund_o_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->fund_o_no->EditValue = $arwrk;
            }
            $this->fund_o_no->PlaceHolder = RemoveHtml($this->fund_o_no->caption());

            // int_@
            $this->int_->setupEditAttributes();
            $this->int_->EditValue = $this->int_->CurrentValue;
            $this->int_->PlaceHolder = RemoveHtml($this->int_->caption());
            if (strval($this->int_->EditValue) != "" && is_numeric($this->int_->EditValue)) {
                $this->int_->EditValue = FormatNumber($this->int_->EditValue, null);
            }

            // Edit refer script

            // b_type
            $this->b_type->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // branch
            $this->branch->HrefValue = "";

            // account_type
            $this->account_type->HrefValue = "";

            // type
            $this->type->HrefValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // sign_image
            $this->sign_image->HrefValue = "";
            $this->sign_image->ExportHrefValue = $this->sign_image->UploadPath . $this->sign_image->Upload->DbValue;

            // status
            $this->status->HrefValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";

            // id_proof
            $this->id_proof->LinkCustomAttributes = $this->id_proof->getLinkCustomAttributes(); // PHP
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->HrefValue = "%u"; // Add prefix/suffix
                $this->id_proof->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->id_proof->HrefValue = FullUrl($this->id_proof->HrefValue, "href");
                }
            } else {
                $this->id_proof->HrefValue = "";
            }
            $this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;

            // agent
            $this->agent->HrefValue = "";

            // other_details
            $this->other_details->HrefValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";

            // bank_ifsc_code
            $this->bank_ifsc_code->HrefValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";

            // account_no
            $this->account_no->HrefValue = "";
            $this->account_no->TooltipValue = "";

            // loan_amount
            $this->loan_amount->HrefValue = "";

            // emi_amount
            $this->emi_amount->HrefValue = "";

            // frequency
            $this->frequency->HrefValue = "";

            // disbursement_amount
            $this->disbursement_amount->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // d_operator
            $this->d_operator->HrefValue = "";

            // d_datetime
            $this->d_datetime->HrefValue = "";

            // no_of_emi
            $this->no_of_emi->HrefValue = "";

            // fund_o
            $this->fund_o->HrefValue = "";

            // fund_o_no
            $this->fund_o_no->HrefValue = "";

            // int_@
            $this->int_->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;
        $updateCnt = 0;
        if ($this->b_type->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->grp->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->branch->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->account_type->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->type->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->formal_name->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->mobile->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->_email->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->image->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->sign_image->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->status->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->aadhaar_no->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->pan_no->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->id_proof->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->agent->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->other_details->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->bank_name->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->bank_ifsc_code->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->bank_account_no->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->account_no->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->loan_amount->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->emi_amount->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->frequency->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->disbursement_amount->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->operator->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->datetime->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->d_operator->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->d_datetime->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->no_of_emi->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->fund_o->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->fund_o_no->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->int_->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($updateCnt == 0) {
            return false;
        }

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->b_type->Visible && $this->b_type->Required) {
                if ($this->b_type->MultiUpdate != "" && !$this->b_type->IsDetailKey && EmptyValue($this->b_type->FormValue)) {
                    $this->b_type->addErrorMessage(str_replace("%s", $this->b_type->caption(), $this->b_type->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if ($this->grp->MultiUpdate != "" && !$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->branch->Visible && $this->branch->Required) {
                if ($this->branch->MultiUpdate != "" && !$this->branch->IsDetailKey && EmptyValue($this->branch->FormValue)) {
                    $this->branch->addErrorMessage(str_replace("%s", $this->branch->caption(), $this->branch->RequiredErrorMessage));
                }
            }
            if ($this->account_type->Visible && $this->account_type->Required) {
                if ($this->account_type->MultiUpdate != "" && !$this->account_type->IsDetailKey && EmptyValue($this->account_type->FormValue)) {
                    $this->account_type->addErrorMessage(str_replace("%s", $this->account_type->caption(), $this->account_type->RequiredErrorMessage));
                }
            }
            if ($this->account_type->MultiUpdate != "") {
                if (!CheckInteger($this->account_type->FormValue)) {
                    $this->account_type->addErrorMessage($this->account_type->getErrorMessage(false));
                }
            }
            if ($this->type->Visible && $this->type->Required) {
                if ($this->type->MultiUpdate != "" && !$this->type->IsDetailKey && EmptyValue($this->type->FormValue)) {
                    $this->type->addErrorMessage(str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
                }
            }
            if ($this->formal_name->Visible && $this->formal_name->Required) {
                if ($this->formal_name->MultiUpdate != "" && !$this->formal_name->IsDetailKey && EmptyValue($this->formal_name->FormValue)) {
                    $this->formal_name->addErrorMessage(str_replace("%s", $this->formal_name->caption(), $this->formal_name->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if ($this->mobile->MultiUpdate != "" && !$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->mobile->MultiUpdate != "") {
                if (!CheckInteger($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage($this->mobile->getErrorMessage(false));
                }
            }
            if ($this->_email->Visible && $this->_email->Required) {
                if ($this->_email->MultiUpdate != "" && !$this->_email->IsDetailKey && EmptyValue($this->_email->FormValue)) {
                    $this->_email->addErrorMessage(str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
                }
            }
            if ($this->_email->MultiUpdate != "") {
                if (!CheckEmail($this->_email->FormValue)) {
                    $this->_email->addErrorMessage($this->_email->getErrorMessage(false));
                }
            }
            if ($this->image->Visible && $this->image->Required) {
                if ($this->image->MultiUpdate != "" && $this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
                    $this->image->addErrorMessage(str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
                }
            }
            if ($this->sign_image->Visible && $this->sign_image->Required) {
                if ($this->sign_image->MultiUpdate != "" && $this->sign_image->Upload->FileName == "" && !$this->sign_image->Upload->KeepFile) {
                    $this->sign_image->addErrorMessage(str_replace("%s", $this->sign_image->caption(), $this->sign_image->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if ($this->status->MultiUpdate != "" && !$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->status->MultiUpdate != "") {
                if (!CheckInteger($this->status->FormValue)) {
                    $this->status->addErrorMessage($this->status->getErrorMessage(false));
                }
            }
            if ($this->aadhaar_no->Visible && $this->aadhaar_no->Required) {
                if ($this->aadhaar_no->MultiUpdate != "" && !$this->aadhaar_no->IsDetailKey && EmptyValue($this->aadhaar_no->FormValue)) {
                    $this->aadhaar_no->addErrorMessage(str_replace("%s", $this->aadhaar_no->caption(), $this->aadhaar_no->RequiredErrorMessage));
                }
            }
            if ($this->aadhaar_no->MultiUpdate != "") {
                if (!CheckInteger($this->aadhaar_no->FormValue)) {
                    $this->aadhaar_no->addErrorMessage($this->aadhaar_no->getErrorMessage(false));
                }
            }
            if ($this->pan_no->Visible && $this->pan_no->Required) {
                if ($this->pan_no->MultiUpdate != "" && !$this->pan_no->IsDetailKey && EmptyValue($this->pan_no->FormValue)) {
                    $this->pan_no->addErrorMessage(str_replace("%s", $this->pan_no->caption(), $this->pan_no->RequiredErrorMessage));
                }
            }
            if ($this->id_proof->Visible && $this->id_proof->Required) {
                if ($this->id_proof->MultiUpdate != "" && $this->id_proof->Upload->FileName == "" && !$this->id_proof->Upload->KeepFile) {
                    $this->id_proof->addErrorMessage(str_replace("%s", $this->id_proof->caption(), $this->id_proof->RequiredErrorMessage));
                }
            }
            if ($this->agent->Visible && $this->agent->Required) {
                if ($this->agent->MultiUpdate != "" && !$this->agent->IsDetailKey && EmptyValue($this->agent->FormValue)) {
                    $this->agent->addErrorMessage(str_replace("%s", $this->agent->caption(), $this->agent->RequiredErrorMessage));
                }
            }
            if ($this->other_details->Visible && $this->other_details->Required) {
                if ($this->other_details->MultiUpdate != "" && !$this->other_details->IsDetailKey && EmptyValue($this->other_details->FormValue)) {
                    $this->other_details->addErrorMessage(str_replace("%s", $this->other_details->caption(), $this->other_details->RequiredErrorMessage));
                }
            }
            if ($this->bank_name->Visible && $this->bank_name->Required) {
                if ($this->bank_name->MultiUpdate != "" && !$this->bank_name->IsDetailKey && EmptyValue($this->bank_name->FormValue)) {
                    $this->bank_name->addErrorMessage(str_replace("%s", $this->bank_name->caption(), $this->bank_name->RequiredErrorMessage));
                }
            }
            if ($this->bank_ifsc_code->Visible && $this->bank_ifsc_code->Required) {
                if ($this->bank_ifsc_code->MultiUpdate != "" && !$this->bank_ifsc_code->IsDetailKey && EmptyValue($this->bank_ifsc_code->FormValue)) {
                    $this->bank_ifsc_code->addErrorMessage(str_replace("%s", $this->bank_ifsc_code->caption(), $this->bank_ifsc_code->RequiredErrorMessage));
                }
            }
            if ($this->bank_account_no->Visible && $this->bank_account_no->Required) {
                if ($this->bank_account_no->MultiUpdate != "" && !$this->bank_account_no->IsDetailKey && EmptyValue($this->bank_account_no->FormValue)) {
                    $this->bank_account_no->addErrorMessage(str_replace("%s", $this->bank_account_no->caption(), $this->bank_account_no->RequiredErrorMessage));
                }
            }
            if ($this->account_no->Visible && $this->account_no->Required) {
                if ($this->account_no->MultiUpdate != "" && !$this->account_no->IsDetailKey && EmptyValue($this->account_no->FormValue)) {
                    $this->account_no->addErrorMessage(str_replace("%s", $this->account_no->caption(), $this->account_no->RequiredErrorMessage));
                }
            }
            if ($this->loan_amount->Visible && $this->loan_amount->Required) {
                if ($this->loan_amount->MultiUpdate != "" && !$this->loan_amount->IsDetailKey && EmptyValue($this->loan_amount->FormValue)) {
                    $this->loan_amount->addErrorMessage(str_replace("%s", $this->loan_amount->caption(), $this->loan_amount->RequiredErrorMessage));
                }
            }
            if ($this->loan_amount->MultiUpdate != "") {
                if (!CheckNumber($this->loan_amount->FormValue)) {
                    $this->loan_amount->addErrorMessage($this->loan_amount->getErrorMessage(false));
                }
            }
            if ($this->emi_amount->Visible && $this->emi_amount->Required) {
                if ($this->emi_amount->MultiUpdate != "" && !$this->emi_amount->IsDetailKey && EmptyValue($this->emi_amount->FormValue)) {
                    $this->emi_amount->addErrorMessage(str_replace("%s", $this->emi_amount->caption(), $this->emi_amount->RequiredErrorMessage));
                }
            }
            if ($this->emi_amount->MultiUpdate != "") {
                if (!CheckNumber($this->emi_amount->FormValue)) {
                    $this->emi_amount->addErrorMessage($this->emi_amount->getErrorMessage(false));
                }
            }
            if ($this->frequency->Visible && $this->frequency->Required) {
                if ($this->frequency->MultiUpdate != "" && !$this->frequency->IsDetailKey && EmptyValue($this->frequency->FormValue)) {
                    $this->frequency->addErrorMessage(str_replace("%s", $this->frequency->caption(), $this->frequency->RequiredErrorMessage));
                }
            }
            if ($this->disbursement_amount->Visible && $this->disbursement_amount->Required) {
                if ($this->disbursement_amount->MultiUpdate != "" && !$this->disbursement_amount->IsDetailKey && EmptyValue($this->disbursement_amount->FormValue)) {
                    $this->disbursement_amount->addErrorMessage(str_replace("%s", $this->disbursement_amount->caption(), $this->disbursement_amount->RequiredErrorMessage));
                }
            }
            if ($this->disbursement_amount->MultiUpdate != "") {
                if (!CheckNumber($this->disbursement_amount->FormValue)) {
                    $this->disbursement_amount->addErrorMessage($this->disbursement_amount->getErrorMessage(false));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if ($this->operator->MultiUpdate != "" && !$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if ($this->datetime->MultiUpdate != "" && !$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->d_operator->Visible && $this->d_operator->Required) {
                if ($this->d_operator->MultiUpdate != "" && !$this->d_operator->IsDetailKey && EmptyValue($this->d_operator->FormValue)) {
                    $this->d_operator->addErrorMessage(str_replace("%s", $this->d_operator->caption(), $this->d_operator->RequiredErrorMessage));
                }
            }
            if ($this->d_datetime->Visible && $this->d_datetime->Required) {
                if ($this->d_datetime->MultiUpdate != "" && !$this->d_datetime->IsDetailKey && EmptyValue($this->d_datetime->FormValue)) {
                    $this->d_datetime->addErrorMessage(str_replace("%s", $this->d_datetime->caption(), $this->d_datetime->RequiredErrorMessage));
                }
            }
            if ($this->no_of_emi->Visible && $this->no_of_emi->Required) {
                if ($this->no_of_emi->MultiUpdate != "" && !$this->no_of_emi->IsDetailKey && EmptyValue($this->no_of_emi->FormValue)) {
                    $this->no_of_emi->addErrorMessage(str_replace("%s", $this->no_of_emi->caption(), $this->no_of_emi->RequiredErrorMessage));
                }
            }
            if ($this->no_of_emi->MultiUpdate != "") {
                if (!CheckInteger($this->no_of_emi->FormValue)) {
                    $this->no_of_emi->addErrorMessage($this->no_of_emi->getErrorMessage(false));
                }
            }
            if ($this->fund_o->Visible && $this->fund_o->Required) {
                if ($this->fund_o->MultiUpdate != "" && !$this->fund_o->IsDetailKey && EmptyValue($this->fund_o->FormValue)) {
                    $this->fund_o->addErrorMessage(str_replace("%s", $this->fund_o->caption(), $this->fund_o->RequiredErrorMessage));
                }
            }
            if ($this->fund_o->MultiUpdate != "") {
                if (!CheckNumber($this->fund_o->FormValue)) {
                    $this->fund_o->addErrorMessage($this->fund_o->getErrorMessage(false));
                }
            }
            if ($this->fund_o_no->Visible && $this->fund_o_no->Required) {
                if ($this->fund_o_no->MultiUpdate != "" && !$this->fund_o_no->IsDetailKey && EmptyValue($this->fund_o_no->FormValue)) {
                    $this->fund_o_no->addErrorMessage(str_replace("%s", $this->fund_o_no->caption(), $this->fund_o_no->RequiredErrorMessage));
                }
            }
            if ($this->int_->Visible && $this->int_->Required) {
                if ($this->int_->MultiUpdate != "" && !$this->int_->IsDetailKey && EmptyValue($this->int_->FormValue)) {
                    $this->int_->addErrorMessage(str_replace("%s", $this->int_->caption(), $this->int_->RequiredErrorMessage));
                }
            }
            if ($this->int_->MultiUpdate != "") {
                if (!CheckNumber($this->int_->FormValue)) {
                    $this->int_->addErrorMessage($this->int_->getErrorMessage(false));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (account_no)
        if ($this->account_no->CurrentValue != "") {
            $filterChk = "(`account_no` = '" . AdjustSql($this->account_no->CurrentValue, $this->Dbid) . "')";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->account_no->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->account_no->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        if ($this->image->Visible && !$this->image->Upload->KeepFile) {
            $this->image->UploadPath = $this->image->getUploadPath();
            if (!EmptyValue($this->image->Upload->FileName) && $this->UpdateCount == 1) {
                FixUploadFileNames($this->image);
                $this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, $this->image->ReadOnly || $this->image->MultiUpdate != "1");
            }
        }
        if ($this->sign_image->Visible && !$this->sign_image->Upload->KeepFile) {
            $this->sign_image->UploadPath = $this->sign_image->getUploadPath();
            if (!EmptyValue($this->sign_image->Upload->FileName) && $this->UpdateCount == 1) {
                FixUploadFileNames($this->sign_image);
                $this->sign_image->setDbValueDef($rsnew, $this->sign_image->Upload->FileName, $this->sign_image->ReadOnly || $this->sign_image->MultiUpdate != "1");
            }
        }
        if ($this->id_proof->Visible && !$this->id_proof->Upload->KeepFile) {
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath();
            if (!EmptyValue($this->id_proof->Upload->FileName) && $this->UpdateCount == 1) {
                FixUploadFileNames($this->id_proof);
                $this->id_proof->setDbValueDef($rsnew, $this->id_proof->Upload->FileName, $this->id_proof->ReadOnly || $this->id_proof->MultiUpdate != "1");
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->image->Visible && !$this->image->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->image, $rsnew['image'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->sign_image->Visible && !$this->sign_image->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->sign_image, $rsnew['sign_image'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->id_proof->Visible && !$this->id_proof->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->id_proof, $rsnew['id_proof'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;
        $this->sign_image->OldUploadPath = $this->sign_image->getUploadPath(); // PHP
        $this->sign_image->UploadPath = $this->sign_image->OldUploadPath;
        $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
        $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
        $rsnew = [];

        // b_type
        $this->b_type->setDbValueDef($rsnew, $this->b_type->CurrentValue, $this->b_type->ReadOnly || $this->b_type->MultiUpdate != "1");

        // branch
        $this->branch->setDbValueDef($rsnew, $this->branch->CurrentValue, $this->branch->ReadOnly || $this->branch->MultiUpdate != "1");

        // account_type
        $this->account_type->setDbValueDef($rsnew, $this->account_type->CurrentValue, $this->account_type->ReadOnly || $this->account_type->MultiUpdate != "1");

        // type
        $this->type->setDbValueDef($rsnew, $this->type->CurrentValue, $this->type->ReadOnly || $this->type->MultiUpdate != "1");

        // formal_name
        $this->formal_name->setDbValueDef($rsnew, $this->formal_name->CurrentValue, $this->formal_name->ReadOnly || $this->formal_name->MultiUpdate != "1");

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, $this->mobile->ReadOnly || $this->mobile->MultiUpdate != "1");

        // email
        $this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, $this->_email->ReadOnly || $this->_email->MultiUpdate != "1");

        // image
        if ($this->image->Visible && !$this->image->ReadOnly && strval($this->image->MultiUpdate) == "1" && !$this->image->Upload->KeepFile) {
            if ($this->image->Upload->FileName == "") {
                $rsnew['image'] = null;
            } else {
                FixUploadTempFileNames($this->image);
                $rsnew['image'] = $this->image->Upload->FileName;
            }
            $this->image->ImageWidth = 600; // Resize width
            $this->image->ImageHeight = 600; // Resize height
        }

        // sign_image
        if ($this->sign_image->Visible && !$this->sign_image->ReadOnly && strval($this->sign_image->MultiUpdate) == "1" && !$this->sign_image->Upload->KeepFile) {
            if ($this->sign_image->Upload->FileName == "") {
                $rsnew['sign_image'] = null;
            } else {
                FixUploadTempFileNames($this->sign_image);
                $rsnew['sign_image'] = $this->sign_image->Upload->FileName;
            }
            $this->sign_image->ImageWidth = 300; // Resize width
            $this->sign_image->ImageHeight = 300; // Resize height
        }

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly || $this->status->MultiUpdate != "1");

        // aadhaar_no
        $this->aadhaar_no->setDbValueDef($rsnew, $this->aadhaar_no->CurrentValue, $this->aadhaar_no->ReadOnly || $this->aadhaar_no->MultiUpdate != "1");

        // pan_no
        $this->pan_no->setDbValueDef($rsnew, $this->pan_no->CurrentValue, $this->pan_no->ReadOnly || $this->pan_no->MultiUpdate != "1");

        // id_proof
        if ($this->id_proof->Visible && !$this->id_proof->ReadOnly && strval($this->id_proof->MultiUpdate) == "1" && !$this->id_proof->Upload->KeepFile) {
            if ($this->id_proof->Upload->FileName == "") {
                $rsnew['id_proof'] = null;
            } else {
                FixUploadTempFileNames($this->id_proof);
                $rsnew['id_proof'] = $this->id_proof->Upload->FileName;
            }
            $this->id_proof->ImageWidth = 600; // Resize width
            $this->id_proof->ImageHeight = 600; // Resize height
        }

        // agent
        $this->agent->setDbValueDef($rsnew, $this->agent->CurrentValue, $this->agent->ReadOnly || $this->agent->MultiUpdate != "1");

        // other_details
        $this->other_details->setDbValueDef($rsnew, $this->other_details->CurrentValue, $this->other_details->ReadOnly || $this->other_details->MultiUpdate != "1");

        // bank_name
        $this->bank_name->setDbValueDef($rsnew, $this->bank_name->CurrentValue, $this->bank_name->ReadOnly || $this->bank_name->MultiUpdate != "1");

        // bank_ifsc_code
        $this->bank_ifsc_code->setDbValueDef($rsnew, $this->bank_ifsc_code->CurrentValue, $this->bank_ifsc_code->ReadOnly || $this->bank_ifsc_code->MultiUpdate != "1");

        // bank_account_no
        $this->bank_account_no->setDbValueDef($rsnew, $this->bank_account_no->CurrentValue, $this->bank_account_no->ReadOnly || $this->bank_account_no->MultiUpdate != "1");

        // loan_amount
        $this->loan_amount->setDbValueDef($rsnew, $this->loan_amount->CurrentValue, $this->loan_amount->ReadOnly || $this->loan_amount->MultiUpdate != "1");

        // emi_amount
        $this->emi_amount->setDbValueDef($rsnew, $this->emi_amount->CurrentValue, $this->emi_amount->ReadOnly || $this->emi_amount->MultiUpdate != "1");

        // frequency
        $this->frequency->setDbValueDef($rsnew, $this->frequency->CurrentValue, $this->frequency->ReadOnly || $this->frequency->MultiUpdate != "1");

        // disbursement_amount
        $this->disbursement_amount->setDbValueDef($rsnew, $this->disbursement_amount->CurrentValue, $this->disbursement_amount->ReadOnly || $this->disbursement_amount->MultiUpdate != "1");

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly || $this->operator->MultiUpdate != "1");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly || $this->datetime->MultiUpdate != "1");

        // d_operator
        $this->d_operator->CurrentValue = $this->d_operator->getAutoUpdateValue(); // PHP
        $this->d_operator->setDbValueDef($rsnew, $this->d_operator->CurrentValue, $this->d_operator->ReadOnly || $this->d_operator->MultiUpdate != "1");

        // d_datetime
        $this->d_datetime->CurrentValue = $this->d_datetime->getAutoUpdateValue(); // PHP
        $this->d_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->d_datetime->CurrentValue, $this->d_datetime->formatPattern()), $this->d_datetime->ReadOnly || $this->d_datetime->MultiUpdate != "1");

        // no_of_emi
        $this->no_of_emi->setDbValueDef($rsnew, $this->no_of_emi->CurrentValue, $this->no_of_emi->ReadOnly || $this->no_of_emi->MultiUpdate != "1");

        // fund_o
        $this->fund_o->setDbValueDef($rsnew, $this->fund_o->CurrentValue, $this->fund_o->ReadOnly || $this->fund_o->MultiUpdate != "1");

        // fund_o_no
        $this->fund_o_no->setDbValueDef($rsnew, $this->fund_o_no->CurrentValue, $this->fund_o_no->ReadOnly || $this->fund_o_no->MultiUpdate != "1");

        // int_@
        $this->int_->setDbValueDef($rsnew, $this->int_->CurrentValue, $this->int_->ReadOnly || $this->int_->MultiUpdate != "1");
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['b_type'])) { // b_type
            $this->b_type->CurrentValue = $row['b_type'];
        }
        if (isset($row['branch'])) { // branch
            $this->branch->CurrentValue = $row['branch'];
        }
        if (isset($row['account_type'])) { // account_type
            $this->account_type->CurrentValue = $row['account_type'];
        }
        if (isset($row['type'])) { // type
            $this->type->CurrentValue = $row['type'];
        }
        if (isset($row['formal_name'])) { // formal_name
            $this->formal_name->CurrentValue = $row['formal_name'];
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->CurrentValue = $row['mobile'];
        }
        if (isset($row['email'])) { // email
            $this->_email->CurrentValue = $row['email'];
        }
        if (isset($row['image'])) { // image
            $this->image->CurrentValue = $row['image'];
        }
        if (isset($row['sign_image'])) { // sign_image
            $this->sign_image->CurrentValue = $row['sign_image'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['aadhaar_no'])) { // aadhaar_no
            $this->aadhaar_no->CurrentValue = $row['aadhaar_no'];
        }
        if (isset($row['pan_no'])) { // pan_no
            $this->pan_no->CurrentValue = $row['pan_no'];
        }
        if (isset($row['id_proof'])) { // id_proof
            $this->id_proof->CurrentValue = $row['id_proof'];
        }
        if (isset($row['agent'])) { // agent
            $this->agent->CurrentValue = $row['agent'];
        }
        if (isset($row['other_details'])) { // other_details
            $this->other_details->CurrentValue = $row['other_details'];
        }
        if (isset($row['bank_name'])) { // bank_name
            $this->bank_name->CurrentValue = $row['bank_name'];
        }
        if (isset($row['bank_ifsc_code'])) { // bank_ifsc_code
            $this->bank_ifsc_code->CurrentValue = $row['bank_ifsc_code'];
        }
        if (isset($row['bank_account_no'])) { // bank_account_no
            $this->bank_account_no->CurrentValue = $row['bank_account_no'];
        }
        if (isset($row['loan_amount'])) { // loan_amount
            $this->loan_amount->CurrentValue = $row['loan_amount'];
        }
        if (isset($row['emi_amount'])) { // emi_amount
            $this->emi_amount->CurrentValue = $row['emi_amount'];
        }
        if (isset($row['frequency'])) { // frequency
            $this->frequency->CurrentValue = $row['frequency'];
        }
        if (isset($row['disbursement_amount'])) { // disbursement_amount
            $this->disbursement_amount->CurrentValue = $row['disbursement_amount'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['d_operator'])) { // d_operator
            $this->d_operator->CurrentValue = $row['d_operator'];
        }
        if (isset($row['d_datetime'])) { // d_datetime
            $this->d_datetime->CurrentValue = $row['d_datetime'];
        }
        if (isset($row['no_of_emi'])) { // no_of_emi
            $this->no_of_emi->CurrentValue = $row['no_of_emi'];
        }
        if (isset($row['fund_o'])) { // fund_o
            $this->fund_o->CurrentValue = $row['fund_o'];
        }
        if (isset($row['fund_o_no'])) { // fund_o_no
            $this->fund_o_no->CurrentValue = $row['fund_o_no'];
        }
        if (isset($row['int_@'])) { // int_@
            $this->int_->CurrentValue = $row['int_@'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("baccountinfolist"), "", $this->TableVar, true);
        $pageId = "update";
        $Breadcrumb->add("update", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_b_type":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_branch":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    break;
                case "x_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_frequency":
                    break;
                case "x_fund_o_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'account_info');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
