<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BAccountInfoSearch extends BAccountInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BAccountInfoSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "baccountinfosearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->b_type->setVisibility();
        $this->grp->setVisibility();
        $this->branch->setVisibility();
        $this->category->setVisibility();
        $this->account_type->setVisibility();
        $this->type->setVisibility();
        $this->formal_name->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->image->setVisibility();
        $this->sign_image->setVisibility();
        $this->status->setVisibility();
        $this->aadhaar_no->setVisibility();
        $this->pan_no->setVisibility();
        $this->id_proof->setVisibility();
        $this->agent->setVisibility();
        $this->other_details->setVisibility();
        $this->bank_name->setVisibility();
        $this->bank_ifsc_code->setVisibility();
        $this->bank_account_no->setVisibility();
        $this->account_no->setVisibility();
        $this->loan_amount->setVisibility();
        $this->emi_amount->setVisibility();
        $this->frequency->setVisibility();
        $this->disbursement_amount->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->d_operator->setVisibility();
        $this->d_datetime->setVisibility();
        $this->otp->Visible = false;
        $this->otp_delivery_datetime->Visible = false;
        $this->otp_verify_datetime->Visible = false;
        $this->no_of_emi->setVisibility();
        $this->fund_o->setVisibility();
        $this->fund_o_no->setVisibility();
        $this->int_->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'b_account_info';
        $this->TableName = 'b_account_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (b_account_info)
        if (!isset($GLOBALS["b_account_info"]) || $GLOBALS["b_account_info"]::class == PROJECT_NAMESPACE . "b_account_info") {
            $GLOBALS["b_account_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "baccountinfoview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $this->sign_image->OldUploadPath = $this->sign_image->getUploadPath(); // PHP
                $this->sign_image->UploadPath = $this->sign_image->OldUploadPath;
                $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
                $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->b_type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->branch);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->agent);
        $this->setupLookupOptions($this->frequency);
        $this->setupLookupOptions($this->fund_o_no);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "baccountinfolist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->b_type); // b_type
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->branch); // branch
        $this->buildSearchUrl($srchUrl, $this->category); // category
        $this->buildSearchUrl($srchUrl, $this->account_type); // account_type
        $this->buildSearchUrl($srchUrl, $this->type); // type
        $this->buildSearchUrl($srchUrl, $this->formal_name); // formal_name
        $this->buildSearchUrl($srchUrl, $this->mobile); // mobile
        $this->buildSearchUrl($srchUrl, $this->_email); // email
        $this->buildSearchUrl($srchUrl, $this->image); // image
        $this->buildSearchUrl($srchUrl, $this->sign_image); // sign_image
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->aadhaar_no); // aadhaar_no
        $this->buildSearchUrl($srchUrl, $this->pan_no); // pan_no
        $this->buildSearchUrl($srchUrl, $this->id_proof); // id_proof
        $this->buildSearchUrl($srchUrl, $this->agent); // agent
        $this->buildSearchUrl($srchUrl, $this->other_details); // other_details
        $this->buildSearchUrl($srchUrl, $this->bank_name); // bank_name
        $this->buildSearchUrl($srchUrl, $this->bank_ifsc_code); // bank_ifsc_code
        $this->buildSearchUrl($srchUrl, $this->bank_account_no); // bank_account_no
        $this->buildSearchUrl($srchUrl, $this->account_no); // account_no
        $this->buildSearchUrl($srchUrl, $this->loan_amount); // loan_amount
        $this->buildSearchUrl($srchUrl, $this->emi_amount); // emi_amount
        $this->buildSearchUrl($srchUrl, $this->frequency); // frequency
        $this->buildSearchUrl($srchUrl, $this->disbursement_amount); // disbursement_amount
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->d_operator); // d_operator
        $this->buildSearchUrl($srchUrl, $this->d_datetime); // d_datetime
        $this->buildSearchUrl($srchUrl, $this->no_of_emi); // no_of_emi
        $this->buildSearchUrl($srchUrl, $this->fund_o); // fund_o
        $this->buildSearchUrl($srchUrl, $this->fund_o_no); // fund_o_no
        $this->buildSearchUrl($srchUrl, $this->int_); // int_@
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // b_type
        if ($this->b_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // branch
        if ($this->branch->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // account_type
        if ($this->account_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // type
        if ($this->type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // formal_name
        if ($this->formal_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // email
        if ($this->_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // image
        if ($this->image->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sign_image
        if ($this->sign_image->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // aadhaar_no
        if ($this->aadhaar_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pan_no
        if ($this->pan_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // id_proof
        if ($this->id_proof->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // agent
        if ($this->agent->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // other_details
        if ($this->other_details->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bank_name
        if ($this->bank_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bank_ifsc_code
        if ($this->bank_ifsc_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bank_account_no
        if ($this->bank_account_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // account_no
        if ($this->account_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // loan_amount
        if ($this->loan_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // emi_amount
        if ($this->emi_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // frequency
        if ($this->frequency->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // disbursement_amount
        if ($this->disbursement_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_operator
        if ($this->d_operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_datetime
        if ($this->d_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // no_of_emi
        if ($this->no_of_emi->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // fund_o
        if ($this->fund_o->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // fund_o_no
        if ($this->fund_o_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // int_@
        if ($this->int_->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // b_type
        $this->b_type->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // branch
        $this->branch->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // account_type
        $this->account_type->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // formal_name
        $this->formal_name->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // sign_image
        $this->sign_image->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // aadhaar_no
        $this->aadhaar_no->RowCssClass = "row";

        // pan_no
        $this->pan_no->RowCssClass = "row";

        // id_proof
        $this->id_proof->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // other_details
        $this->other_details->RowCssClass = "row";

        // bank_name
        $this->bank_name->RowCssClass = "row";

        // bank_ifsc_code
        $this->bank_ifsc_code->RowCssClass = "row";

        // bank_account_no
        $this->bank_account_no->RowCssClass = "row";

        // account_no
        $this->account_no->RowCssClass = "row";

        // loan_amount
        $this->loan_amount->RowCssClass = "row";

        // emi_amount
        $this->emi_amount->RowCssClass = "row";

        // frequency
        $this->frequency->RowCssClass = "row";

        // disbursement_amount
        $this->disbursement_amount->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // d_operator
        $this->d_operator->RowCssClass = "row";

        // d_datetime
        $this->d_datetime->RowCssClass = "row";

        // otp
        $this->otp->RowCssClass = "row";

        // otp_delivery_datetime
        $this->otp_delivery_datetime->RowCssClass = "row";

        // otp_verify_datetime
        $this->otp_verify_datetime->RowCssClass = "row";

        // no_of_emi
        $this->no_of_emi->RowCssClass = "row";

        // fund_o
        $this->fund_o->RowCssClass = "row";

        // fund_o_no
        $this->fund_o_no->RowCssClass = "row";

        // int_@
        $this->int_->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // b_type
            if (strval($this->b_type->CurrentValue) != "") {
                $this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
            } else {
                $this->b_type->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // branch
            $curVal = strval($this->branch->CurrentValue);
            if ($curVal != "") {
                $this->branch->ViewValue = $this->branch->lookupCacheOption($curVal);
                if ($this->branch->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->branch->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->branch->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->branch->getSelectFilter($this); // PHP
                    $sqlWrk = $this->branch->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->branch->Lookup->renderViewRow($rswrk[0]);
                        $this->branch->ViewValue = $this->branch->displayValue($arwrk);
                    } else {
                        $this->branch->ViewValue = FormatNumber($this->branch->CurrentValue, $this->branch->formatPattern());
                    }
                }
            } else {
                $this->branch->ViewValue = null;
            }

            // category
            if (strval($this->category->CurrentValue) != "") {
                $this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
            } else {
                $this->category->ViewValue = null;
            }

            // account_type
            $this->account_type->ViewValue = $this->account_type->CurrentValue;
            $this->account_type->ViewValue = FormatNumber($this->account_type->ViewValue, $this->account_type->formatPattern());

            // type
            $curVal = strval($this->type->CurrentValue);
            if ($curVal != "") {
                $this->type->ViewValue = $this->type->lookupCacheOption($curVal);
                if ($this->type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->type->Lookup->renderViewRow($rswrk[0]);
                        $this->type->ViewValue = $this->type->displayValue($arwrk);
                    } else {
                        $this->type->ViewValue = FormatNumber($this->type->CurrentValue, $this->type->formatPattern());
                    }
                }
            } else {
                $this->type->ViewValue = null;
            }

            // formal_name
            $this->formal_name->ViewValue = $this->formal_name->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // sign_image
            $this->sign_image->UploadPath = $this->sign_image->getUploadPath(); // PHP
            if (!EmptyValue($this->sign_image->Upload->DbValue)) {
                $this->sign_image->ViewValue = $this->sign_image->Upload->DbValue;
            } else {
                $this->sign_image->ViewValue = "";
            }

            // status
            $this->status->ViewValue = $this->status->CurrentValue;
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // pan_no
            $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

            // id_proof
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->ViewValue = "";
            }

            // agent
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->ViewValue = $this->agent->CurrentValue;
                    }
                }
            } else {
                $this->agent->ViewValue = null;
            }

            // other_details
            $this->other_details->ViewValue = $this->other_details->CurrentValue;

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_ifsc_code
            $this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // account_no
            $this->account_no->ViewValue = $this->account_no->CurrentValue;

            // loan_amount
            $this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
            $this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, $this->loan_amount->formatPattern());

            // emi_amount
            $this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
            $this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, $this->emi_amount->formatPattern());

            // frequency
            if (strval($this->frequency->CurrentValue) != "") {
                $this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
            } else {
                $this->frequency->ViewValue = null;
            }

            // disbursement_amount
            $this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
            $this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, $this->disbursement_amount->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // d_operator
            $this->d_operator->ViewValue = $this->d_operator->CurrentValue;
            $this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, $this->d_operator->formatPattern());

            // d_datetime
            $this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
            $this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, $this->d_datetime->formatPattern());

            // otp_delivery_datetime
            $this->otp_delivery_datetime->ViewValue = $this->otp_delivery_datetime->CurrentValue;
            $this->otp_delivery_datetime->ViewValue = FormatDateTime($this->otp_delivery_datetime->ViewValue, $this->otp_delivery_datetime->formatPattern());

            // otp_verify_datetime
            $this->otp_verify_datetime->ViewValue = $this->otp_verify_datetime->CurrentValue;
            $this->otp_verify_datetime->ViewValue = FormatDateTime($this->otp_verify_datetime->ViewValue, $this->otp_verify_datetime->formatPattern());

            // no_of_emi
            $this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
            $this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, $this->no_of_emi->formatPattern());

            // fund_o
            $this->fund_o->ViewValue = $this->fund_o->CurrentValue;
            $this->fund_o->ViewValue = FormatNumber($this->fund_o->ViewValue, $this->fund_o->formatPattern());

            // fund_o_no
            $curVal = strval($this->fund_o_no->CurrentValue);
            if ($curVal != "") {
                $this->fund_o_no->ViewValue = $this->fund_o_no->lookupCacheOption($curVal);
                if ($this->fund_o_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->fund_o_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->fund_o_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->fund_o_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->fund_o_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->fund_o_no->Lookup->renderViewRow($rswrk[0]);
                        $this->fund_o_no->ViewValue = $this->fund_o_no->displayValue($arwrk);
                    } else {
                        $this->fund_o_no->ViewValue = $this->fund_o_no->CurrentValue;
                    }
                }
            } else {
                $this->fund_o_no->ViewValue = null;
            }

            // int_@
            $this->int_->ViewValue = $this->int_->CurrentValue;
            $this->int_->ViewValue = FormatNumber($this->int_->ViewValue, $this->int_->formatPattern());

            // b_type
            $this->b_type->HrefValue = "";
            $this->b_type->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // branch
            $this->branch->HrefValue = "";
            $this->branch->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // account_type
            $this->account_type->HrefValue = "";
            $this->account_type->TooltipValue = "";

            // type
            $this->type->HrefValue = "";
            $this->type->TooltipValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";
            $this->formal_name->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // email
            $this->_email->HrefValue = "";
            $this->_email->TooltipValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";

            // sign_image
            $this->sign_image->HrefValue = "";
            $this->sign_image->ExportHrefValue = $this->sign_image->UploadPath . $this->sign_image->Upload->DbValue;
            $this->sign_image->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";
            $this->aadhaar_no->TooltipValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";
            $this->pan_no->TooltipValue = "";

            // id_proof
            $this->id_proof->LinkCustomAttributes = $this->id_proof->getLinkCustomAttributes(); // PHP
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->HrefValue = "%u"; // Add prefix/suffix
                $this->id_proof->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->id_proof->HrefValue = FullUrl($this->id_proof->HrefValue, "href");
                }
            } else {
                $this->id_proof->HrefValue = "";
            }
            $this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
            $this->id_proof->TooltipValue = "";

            // agent
            $this->agent->HrefValue = "";
            $this->agent->TooltipValue = "";

            // other_details
            $this->other_details->HrefValue = "";
            $this->other_details->TooltipValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";
            $this->bank_name->TooltipValue = "";

            // bank_ifsc_code
            $this->bank_ifsc_code->HrefValue = "";
            $this->bank_ifsc_code->TooltipValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";
            $this->bank_account_no->TooltipValue = "";

            // account_no
            $this->account_no->HrefValue = "";
            $this->account_no->TooltipValue = "";

            // loan_amount
            $this->loan_amount->HrefValue = "";
            $this->loan_amount->TooltipValue = "";

            // emi_amount
            $this->emi_amount->HrefValue = "";
            $this->emi_amount->TooltipValue = "";

            // frequency
            $this->frequency->HrefValue = "";
            $this->frequency->TooltipValue = "";

            // disbursement_amount
            $this->disbursement_amount->HrefValue = "";
            $this->disbursement_amount->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // d_operator
            $this->d_operator->HrefValue = "";
            $this->d_operator->TooltipValue = "";

            // d_datetime
            $this->d_datetime->HrefValue = "";
            $this->d_datetime->TooltipValue = "";

            // no_of_emi
            $this->no_of_emi->HrefValue = "";
            $this->no_of_emi->TooltipValue = "";

            // fund_o
            $this->fund_o->HrefValue = "";
            $this->fund_o->TooltipValue = "";

            // fund_o_no
            $this->fund_o_no->HrefValue = "";
            $this->fund_o_no->TooltipValue = "";

            // int_@
            $this->int_->HrefValue = "";
            $this->int_->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // b_type
            $this->b_type->setupEditAttributes();
            $this->b_type->EditValue = $this->b_type->options(true);
            $this->b_type->PlaceHolder = RemoveHtml($this->b_type->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // branch
            $this->branch->setupEditAttributes();
            $curVal = trim(strval($this->branch->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->branch->AdvancedSearch->ViewValue = $this->branch->lookupCacheOption($curVal);
            } else {
                $this->branch->AdvancedSearch->ViewValue = $this->branch->Lookup !== null && is_array($this->branch->lookupOptions()) && count($this->branch->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->branch->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->branch->EditValue = array_values($this->branch->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->branch->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->branch->AdvancedSearch->SearchValue, $this->branch->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->branch->getSelectFilter($this); // PHP
                $sqlWrk = $this->branch->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->branch->EditValue = $arwrk;
            }
            $this->branch->PlaceHolder = RemoveHtml($this->branch->caption());

            // category
            $this->category->setupEditAttributes();
            $this->category->EditValue = $this->category->options(true);
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // account_type
            $this->account_type->setupEditAttributes();
            $this->account_type->EditValue = $this->account_type->AdvancedSearch->SearchValue;
            $this->account_type->PlaceHolder = RemoveHtml($this->account_type->caption());

            // type
            $this->type->setupEditAttributes();
            $curVal = trim(strval($this->type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->type->AdvancedSearch->ViewValue = $this->type->lookupCacheOption($curVal);
            } else {
                $this->type->AdvancedSearch->ViewValue = $this->type->Lookup !== null && is_array($this->type->lookupOptions()) && count($this->type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->type->EditValue = array_values($this->type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->type->AdvancedSearch->SearchValue, $this->type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->type->getSelectFilter($this); // PHP
                $sqlWrk = $this->type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->type->EditValue = $arwrk;
            }
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());

            // formal_name
            $this->formal_name->setupEditAttributes();
            if (!$this->formal_name->Raw) {
                $this->formal_name->AdvancedSearch->SearchValue = HtmlDecode($this->formal_name->AdvancedSearch->SearchValue);
            }
            $this->formal_name->EditValue = HtmlEncode($this->formal_name->AdvancedSearch->SearchValue);
            $this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->AdvancedSearch->SearchValue;
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->AdvancedSearch->SearchValue = HtmlDecode($this->_email->AdvancedSearch->SearchValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->AdvancedSearch->SearchValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // image
            $this->image->setupEditAttributes();
            if (!$this->image->Raw) {
                $this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
            }
            $this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
            $this->image->PlaceHolder = RemoveHtml($this->image->caption());

            // sign_image
            $this->sign_image->setupEditAttributes();
            if (!$this->sign_image->Raw) {
                $this->sign_image->AdvancedSearch->SearchValue = HtmlDecode($this->sign_image->AdvancedSearch->SearchValue);
            }
            $this->sign_image->EditValue = HtmlEncode($this->sign_image->AdvancedSearch->SearchValue);
            $this->sign_image->PlaceHolder = RemoveHtml($this->sign_image->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditCustomAttributes = $this->status->getEditCustomAttributes(); // PHP
            $this->status->EditValue = $this->status->AdvancedSearch->SearchValue;
            $curVal = strval($this->status->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->status->EditValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->EditValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->EditValue = HtmlEncode(FormatNumber($this->status->AdvancedSearch->SearchValue, $this->status->formatPattern()));
                    }
                }
            } else {
                $this->status->EditValue = null;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // aadhaar_no
            $this->aadhaar_no->setupEditAttributes();
            if (!$this->aadhaar_no->Raw) {
                $this->aadhaar_no->AdvancedSearch->SearchValue = HtmlDecode($this->aadhaar_no->AdvancedSearch->SearchValue);
            }
            $this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->AdvancedSearch->SearchValue);
            $this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

            // pan_no
            $this->pan_no->setupEditAttributes();
            if (!$this->pan_no->Raw) {
                $this->pan_no->AdvancedSearch->SearchValue = HtmlDecode($this->pan_no->AdvancedSearch->SearchValue);
            }
            $this->pan_no->EditValue = HtmlEncode($this->pan_no->AdvancedSearch->SearchValue);
            $this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

            // id_proof
            $this->id_proof->setupEditAttributes();
            if (!$this->id_proof->Raw) {
                $this->id_proof->AdvancedSearch->SearchValue = HtmlDecode($this->id_proof->AdvancedSearch->SearchValue);
            }
            $this->id_proof->EditValue = HtmlEncode($this->id_proof->AdvancedSearch->SearchValue);
            $this->id_proof->PlaceHolder = RemoveHtml($this->id_proof->caption());

            // agent
            $this->agent->setupEditAttributes();
            $curVal = trim(strval($this->agent->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->agent->AdvancedSearch->ViewValue = $this->agent->lookupCacheOption($curVal);
            } else {
                $this->agent->AdvancedSearch->ViewValue = $this->agent->Lookup !== null && is_array($this->agent->lookupOptions()) && count($this->agent->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->agent->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->agent->EditValue = array_values($this->agent->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->agent->AdvancedSearch->SearchValue, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                $sqlWrk = $this->agent->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->agent->EditValue = $arwrk;
            }
            $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

            // other_details
            $this->other_details->setupEditAttributes();
            if (!$this->other_details->Raw) {
                $this->other_details->AdvancedSearch->SearchValue = HtmlDecode($this->other_details->AdvancedSearch->SearchValue);
            }
            $this->other_details->EditValue = HtmlEncode($this->other_details->AdvancedSearch->SearchValue);
            $this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

            // bank_name
            $this->bank_name->setupEditAttributes();
            if (!$this->bank_name->Raw) {
                $this->bank_name->AdvancedSearch->SearchValue = HtmlDecode($this->bank_name->AdvancedSearch->SearchValue);
            }
            $this->bank_name->EditValue = HtmlEncode($this->bank_name->AdvancedSearch->SearchValue);
            $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

            // bank_ifsc_code
            $this->bank_ifsc_code->setupEditAttributes();
            if (!$this->bank_ifsc_code->Raw) {
                $this->bank_ifsc_code->AdvancedSearch->SearchValue = HtmlDecode($this->bank_ifsc_code->AdvancedSearch->SearchValue);
            }
            $this->bank_ifsc_code->EditValue = HtmlEncode($this->bank_ifsc_code->AdvancedSearch->SearchValue);
            $this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

            // bank_account_no
            $this->bank_account_no->setupEditAttributes();
            if (!$this->bank_account_no->Raw) {
                $this->bank_account_no->AdvancedSearch->SearchValue = HtmlDecode($this->bank_account_no->AdvancedSearch->SearchValue);
            }
            $this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->AdvancedSearch->SearchValue);
            $this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

            // account_no
            $this->account_no->setupEditAttributes();
            $this->account_no->EditCustomAttributes = $this->account_no->getEditCustomAttributes(); // PHP
            if (!$this->account_no->Raw) {
                $this->account_no->AdvancedSearch->SearchValue = HtmlDecode($this->account_no->AdvancedSearch->SearchValue);
            }
            $this->account_no->EditValue = HtmlEncode($this->account_no->AdvancedSearch->SearchValue);
            $this->account_no->PlaceHolder = RemoveHtml($this->account_no->caption());

            // loan_amount
            $this->loan_amount->setupEditAttributes();
            $this->loan_amount->EditValue = $this->loan_amount->AdvancedSearch->SearchValue;
            $this->loan_amount->PlaceHolder = RemoveHtml($this->loan_amount->caption());

            // emi_amount
            $this->emi_amount->setupEditAttributes();
            $this->emi_amount->EditValue = $this->emi_amount->AdvancedSearch->SearchValue;
            $this->emi_amount->PlaceHolder = RemoveHtml($this->emi_amount->caption());

            // frequency
            $this->frequency->setupEditAttributes();
            $this->frequency->EditValue = $this->frequency->options(true);
            $this->frequency->PlaceHolder = RemoveHtml($this->frequency->caption());

            // disbursement_amount
            $this->disbursement_amount->setupEditAttributes();
            $this->disbursement_amount->EditValue = $this->disbursement_amount->AdvancedSearch->SearchValue;
            $this->disbursement_amount->PlaceHolder = RemoveHtml($this->disbursement_amount->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // d_operator
            $this->d_operator->setupEditAttributes();
            $this->d_operator->EditValue = $this->d_operator->AdvancedSearch->SearchValue;
            $this->d_operator->PlaceHolder = RemoveHtml($this->d_operator->caption());

            // d_datetime
            $this->d_datetime->setupEditAttributes();
            $this->d_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->d_datetime->AdvancedSearch->SearchValue, $this->d_datetime->formatPattern()), $this->d_datetime->formatPattern()));
            $this->d_datetime->PlaceHolder = RemoveHtml($this->d_datetime->caption());

            // no_of_emi
            $this->no_of_emi->setupEditAttributes();
            $this->no_of_emi->EditValue = $this->no_of_emi->AdvancedSearch->SearchValue;
            $this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());

            // fund_o
            $this->fund_o->setupEditAttributes();
            $this->fund_o->EditValue = $this->fund_o->AdvancedSearch->SearchValue;
            $this->fund_o->PlaceHolder = RemoveHtml($this->fund_o->caption());

            // fund_o_no
            $this->fund_o_no->setupEditAttributes();
            $curVal = trim(strval($this->fund_o_no->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->fund_o_no->AdvancedSearch->ViewValue = $this->fund_o_no->lookupCacheOption($curVal);
            } else {
                $this->fund_o_no->AdvancedSearch->ViewValue = $this->fund_o_no->Lookup !== null && is_array($this->fund_o_no->lookupOptions()) && count($this->fund_o_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->fund_o_no->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->fund_o_no->EditValue = array_values($this->fund_o_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->fund_o_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->fund_o_no->AdvancedSearch->SearchValue, $this->fund_o_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->fund_o_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->fund_o_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->fund_o_no->EditValue = $arwrk;
            }
            $this->fund_o_no->PlaceHolder = RemoveHtml($this->fund_o_no->caption());

            // int_@
            $this->int_->setupEditAttributes();
            $this->int_->EditValue = $this->int_->AdvancedSearch->SearchValue;
            $this->int_->PlaceHolder = RemoveHtml($this->int_->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->account_type->AdvancedSearch->SearchValue)) {
            $this->account_type->addErrorMessage($this->account_type->getErrorMessage(false));
        }
        if (!CheckInteger($this->mobile->AdvancedSearch->SearchValue)) {
            $this->mobile->addErrorMessage($this->mobile->getErrorMessage(false));
        }
        if (!CheckInteger($this->status->AdvancedSearch->SearchValue)) {
            $this->status->addErrorMessage($this->status->getErrorMessage(false));
        }
        if (!CheckInteger($this->aadhaar_no->AdvancedSearch->SearchValue)) {
            $this->aadhaar_no->addErrorMessage($this->aadhaar_no->getErrorMessage(false));
        }
        if (!CheckNumber($this->loan_amount->AdvancedSearch->SearchValue)) {
            $this->loan_amount->addErrorMessage($this->loan_amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->emi_amount->AdvancedSearch->SearchValue)) {
            $this->emi_amount->addErrorMessage($this->emi_amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->disbursement_amount->AdvancedSearch->SearchValue)) {
            $this->disbursement_amount->addErrorMessage($this->disbursement_amount->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->d_operator->AdvancedSearch->SearchValue)) {
            $this->d_operator->addErrorMessage($this->d_operator->getErrorMessage(false));
        }
        if (!CheckDate($this->d_datetime->AdvancedSearch->SearchValue, $this->d_datetime->formatPattern())) {
            $this->d_datetime->addErrorMessage($this->d_datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->no_of_emi->AdvancedSearch->SearchValue)) {
            $this->no_of_emi->addErrorMessage($this->no_of_emi->getErrorMessage(false));
        }
        if (!CheckNumber($this->fund_o->AdvancedSearch->SearchValue)) {
            $this->fund_o->addErrorMessage($this->fund_o->getErrorMessage(false));
        }
        if (!CheckNumber($this->int_->AdvancedSearch->SearchValue)) {
            $this->int_->addErrorMessage($this->int_->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->b_type->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->branch->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->account_type->AdvancedSearch->load();
        $this->type->AdvancedSearch->load();
        $this->formal_name->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->_email->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->sign_image->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->aadhaar_no->AdvancedSearch->load();
        $this->pan_no->AdvancedSearch->load();
        $this->id_proof->AdvancedSearch->load();
        $this->agent->AdvancedSearch->load();
        $this->other_details->AdvancedSearch->load();
        $this->bank_name->AdvancedSearch->load();
        $this->bank_ifsc_code->AdvancedSearch->load();
        $this->bank_account_no->AdvancedSearch->load();
        $this->account_no->AdvancedSearch->load();
        $this->loan_amount->AdvancedSearch->load();
        $this->emi_amount->AdvancedSearch->load();
        $this->frequency->AdvancedSearch->load();
        $this->disbursement_amount->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->d_operator->AdvancedSearch->load();
        $this->d_datetime->AdvancedSearch->load();
        $this->no_of_emi->AdvancedSearch->load();
        $this->fund_o->AdvancedSearch->load();
        $this->fund_o_no->AdvancedSearch->load();
        $this->int_->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("baccountinfolist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_b_type":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_branch":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    break;
                case "x_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_frequency":
                    break;
                case "x_fund_o_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'account_info');	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
