<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BAccountInfoList extends BAccountInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BAccountInfoList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fb_account_infolist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "baccountinfolist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->b_type->setVisibility();
        $this->grp->setVisibility();
        $this->branch->setVisibility();
        $this->category->Visible = false;
        $this->account_type->setVisibility();
        $this->type->setVisibility();
        $this->formal_name->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->Visible = false;
        $this->image->Visible = false;
        $this->sign_image->Visible = false;
        $this->status->Visible = false;
        $this->aadhaar_no->Visible = false;
        $this->pan_no->Visible = false;
        $this->id_proof->Visible = false;
        $this->agent->setVisibility();
        $this->other_details->Visible = false;
        $this->bank_name->Visible = false;
        $this->bank_ifsc_code->Visible = false;
        $this->bank_account_no->Visible = false;
        $this->account_no->setVisibility();
        $this->loan_amount->setVisibility();
        $this->emi_amount->setVisibility();
        $this->frequency->setVisibility();
        $this->disbursement_amount->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->setVisibility();
        $this->d_operator->Visible = false;
        $this->d_datetime->Visible = false;
        $this->otp->Visible = false;
        $this->otp_delivery_datetime->setVisibility();
        $this->otp_verify_datetime->setVisibility();
        $this->no_of_emi->setVisibility();
        $this->fund_o->setVisibility();
        $this->fund_o_no->setVisibility();
        $this->int_->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'b_account_info';
        $this->TableName = 'b_account_info';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (b_account_info)
        if (!isset($GLOBALS["b_account_info"]) || $GLOBALS["b_account_info"]::class == PROJECT_NAMESPACE . "b_account_info") {
            $GLOBALS["b_account_info"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "baccountinfoadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "baccountinfodelete";
        $this->MultiUpdateUrl = "baccountinfoupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "baccountinfoview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $this->sign_image->OldUploadPath = $this->sign_image->getUploadPath(); // PHP
                $this->sign_image->UploadPath = $this->sign_image->OldUploadPath;
                $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
                $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->d_operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->d_datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "20,50,100,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->b_type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->branch);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->agent);
        $this->setupLookupOptions($this->frequency);
        $this->setupLookupOptions($this->fund_o_no);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fb_account_infogrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);

        // Export selected records
        if ($this->isExport()) {
            $this->CurrentFilter = $this->buildExportSelectedFilter();
        }
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }

            // Audit trail on search
            if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
                $searchParm = ServerVar("QUERY_STRING");
                $searchSql = $this->getSessionWhere();
                $this->writeAuditTrailOnSearch($searchParm, $searchSql);
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fb_account_infosrch");
        }
        $filterList = Concat($filterList, $this->b_type->AdvancedSearch->toJson(), ","); // Field b_type
        $filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
        $filterList = Concat($filterList, $this->branch->AdvancedSearch->toJson(), ","); // Field branch
        $filterList = Concat($filterList, $this->category->AdvancedSearch->toJson(), ","); // Field category
        $filterList = Concat($filterList, $this->account_type->AdvancedSearch->toJson(), ","); // Field account_type
        $filterList = Concat($filterList, $this->type->AdvancedSearch->toJson(), ","); // Field type
        $filterList = Concat($filterList, $this->formal_name->AdvancedSearch->toJson(), ","); // Field formal_name
        $filterList = Concat($filterList, $this->mobile->AdvancedSearch->toJson(), ","); // Field mobile
        $filterList = Concat($filterList, $this->_email->AdvancedSearch->toJson(), ","); // Field email
        $filterList = Concat($filterList, $this->image->AdvancedSearch->toJson(), ","); // Field image
        $filterList = Concat($filterList, $this->sign_image->AdvancedSearch->toJson(), ","); // Field sign_image
        $filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
        $filterList = Concat($filterList, $this->aadhaar_no->AdvancedSearch->toJson(), ","); // Field aadhaar_no
        $filterList = Concat($filterList, $this->pan_no->AdvancedSearch->toJson(), ","); // Field pan_no
        $filterList = Concat($filterList, $this->id_proof->AdvancedSearch->toJson(), ","); // Field id_proof
        $filterList = Concat($filterList, $this->agent->AdvancedSearch->toJson(), ","); // Field agent
        $filterList = Concat($filterList, $this->other_details->AdvancedSearch->toJson(), ","); // Field other_details
        $filterList = Concat($filterList, $this->bank_name->AdvancedSearch->toJson(), ","); // Field bank_name
        $filterList = Concat($filterList, $this->bank_ifsc_code->AdvancedSearch->toJson(), ","); // Field bank_ifsc_code
        $filterList = Concat($filterList, $this->bank_account_no->AdvancedSearch->toJson(), ","); // Field bank_account_no
        $filterList = Concat($filterList, $this->account_no->AdvancedSearch->toJson(), ","); // Field account_no
        $filterList = Concat($filterList, $this->loan_amount->AdvancedSearch->toJson(), ","); // Field loan_amount
        $filterList = Concat($filterList, $this->emi_amount->AdvancedSearch->toJson(), ","); // Field emi_amount
        $filterList = Concat($filterList, $this->frequency->AdvancedSearch->toJson(), ","); // Field frequency
        $filterList = Concat($filterList, $this->disbursement_amount->AdvancedSearch->toJson(), ","); // Field disbursement_amount
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        $filterList = Concat($filterList, $this->d_operator->AdvancedSearch->toJson(), ","); // Field d_operator
        $filterList = Concat($filterList, $this->d_datetime->AdvancedSearch->toJson(), ","); // Field d_datetime
        $filterList = Concat($filterList, $this->no_of_emi->AdvancedSearch->toJson(), ","); // Field no_of_emi
        $filterList = Concat($filterList, $this->fund_o->AdvancedSearch->toJson(), ","); // Field fund_o
        $filterList = Concat($filterList, $this->fund_o_no->AdvancedSearch->toJson(), ","); // Field fund_o_no
        $filterList = Concat($filterList, $this->int_->AdvancedSearch->toJson(), ","); // Field int_@
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fb_account_infosrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field b_type
        $this->b_type->AdvancedSearch->SearchValue = @$filter["x_b_type"];
        $this->b_type->AdvancedSearch->SearchOperator = @$filter["z_b_type"];
        $this->b_type->AdvancedSearch->SearchCondition = @$filter["v_b_type"];
        $this->b_type->AdvancedSearch->SearchValue2 = @$filter["y_b_type"];
        $this->b_type->AdvancedSearch->SearchOperator2 = @$filter["w_b_type"];
        $this->b_type->AdvancedSearch->save();

        // Field grp
        $this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
        $this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
        $this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
        $this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
        $this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
        $this->grp->AdvancedSearch->save();

        // Field branch
        $this->branch->AdvancedSearch->SearchValue = @$filter["x_branch"];
        $this->branch->AdvancedSearch->SearchOperator = @$filter["z_branch"];
        $this->branch->AdvancedSearch->SearchCondition = @$filter["v_branch"];
        $this->branch->AdvancedSearch->SearchValue2 = @$filter["y_branch"];
        $this->branch->AdvancedSearch->SearchOperator2 = @$filter["w_branch"];
        $this->branch->AdvancedSearch->save();

        // Field category
        $this->category->AdvancedSearch->SearchValue = @$filter["x_category"];
        $this->category->AdvancedSearch->SearchOperator = @$filter["z_category"];
        $this->category->AdvancedSearch->SearchCondition = @$filter["v_category"];
        $this->category->AdvancedSearch->SearchValue2 = @$filter["y_category"];
        $this->category->AdvancedSearch->SearchOperator2 = @$filter["w_category"];
        $this->category->AdvancedSearch->save();

        // Field account_type
        $this->account_type->AdvancedSearch->SearchValue = @$filter["x_account_type"];
        $this->account_type->AdvancedSearch->SearchOperator = @$filter["z_account_type"];
        $this->account_type->AdvancedSearch->SearchCondition = @$filter["v_account_type"];
        $this->account_type->AdvancedSearch->SearchValue2 = @$filter["y_account_type"];
        $this->account_type->AdvancedSearch->SearchOperator2 = @$filter["w_account_type"];
        $this->account_type->AdvancedSearch->save();

        // Field type
        $this->type->AdvancedSearch->SearchValue = @$filter["x_type"];
        $this->type->AdvancedSearch->SearchOperator = @$filter["z_type"];
        $this->type->AdvancedSearch->SearchCondition = @$filter["v_type"];
        $this->type->AdvancedSearch->SearchValue2 = @$filter["y_type"];
        $this->type->AdvancedSearch->SearchOperator2 = @$filter["w_type"];
        $this->type->AdvancedSearch->save();

        // Field formal_name
        $this->formal_name->AdvancedSearch->SearchValue = @$filter["x_formal_name"];
        $this->formal_name->AdvancedSearch->SearchOperator = @$filter["z_formal_name"];
        $this->formal_name->AdvancedSearch->SearchCondition = @$filter["v_formal_name"];
        $this->formal_name->AdvancedSearch->SearchValue2 = @$filter["y_formal_name"];
        $this->formal_name->AdvancedSearch->SearchOperator2 = @$filter["w_formal_name"];
        $this->formal_name->AdvancedSearch->save();

        // Field mobile
        $this->mobile->AdvancedSearch->SearchValue = @$filter["x_mobile"];
        $this->mobile->AdvancedSearch->SearchOperator = @$filter["z_mobile"];
        $this->mobile->AdvancedSearch->SearchCondition = @$filter["v_mobile"];
        $this->mobile->AdvancedSearch->SearchValue2 = @$filter["y_mobile"];
        $this->mobile->AdvancedSearch->SearchOperator2 = @$filter["w_mobile"];
        $this->mobile->AdvancedSearch->save();

        // Field email
        $this->_email->AdvancedSearch->SearchValue = @$filter["x__email"];
        $this->_email->AdvancedSearch->SearchOperator = @$filter["z__email"];
        $this->_email->AdvancedSearch->SearchCondition = @$filter["v__email"];
        $this->_email->AdvancedSearch->SearchValue2 = @$filter["y__email"];
        $this->_email->AdvancedSearch->SearchOperator2 = @$filter["w__email"];
        $this->_email->AdvancedSearch->save();

        // Field image
        $this->image->AdvancedSearch->SearchValue = @$filter["x_image"];
        $this->image->AdvancedSearch->SearchOperator = @$filter["z_image"];
        $this->image->AdvancedSearch->SearchCondition = @$filter["v_image"];
        $this->image->AdvancedSearch->SearchValue2 = @$filter["y_image"];
        $this->image->AdvancedSearch->SearchOperator2 = @$filter["w_image"];
        $this->image->AdvancedSearch->save();

        // Field sign_image
        $this->sign_image->AdvancedSearch->SearchValue = @$filter["x_sign_image"];
        $this->sign_image->AdvancedSearch->SearchOperator = @$filter["z_sign_image"];
        $this->sign_image->AdvancedSearch->SearchCondition = @$filter["v_sign_image"];
        $this->sign_image->AdvancedSearch->SearchValue2 = @$filter["y_sign_image"];
        $this->sign_image->AdvancedSearch->SearchOperator2 = @$filter["w_sign_image"];
        $this->sign_image->AdvancedSearch->save();

        // Field status
        $this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
        $this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
        $this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
        $this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
        $this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
        $this->status->AdvancedSearch->save();

        // Field aadhaar_no
        $this->aadhaar_no->AdvancedSearch->SearchValue = @$filter["x_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->SearchOperator = @$filter["z_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->SearchCondition = @$filter["v_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->SearchValue2 = @$filter["y_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->SearchOperator2 = @$filter["w_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->save();

        // Field pan_no
        $this->pan_no->AdvancedSearch->SearchValue = @$filter["x_pan_no"];
        $this->pan_no->AdvancedSearch->SearchOperator = @$filter["z_pan_no"];
        $this->pan_no->AdvancedSearch->SearchCondition = @$filter["v_pan_no"];
        $this->pan_no->AdvancedSearch->SearchValue2 = @$filter["y_pan_no"];
        $this->pan_no->AdvancedSearch->SearchOperator2 = @$filter["w_pan_no"];
        $this->pan_no->AdvancedSearch->save();

        // Field id_proof
        $this->id_proof->AdvancedSearch->SearchValue = @$filter["x_id_proof"];
        $this->id_proof->AdvancedSearch->SearchOperator = @$filter["z_id_proof"];
        $this->id_proof->AdvancedSearch->SearchCondition = @$filter["v_id_proof"];
        $this->id_proof->AdvancedSearch->SearchValue2 = @$filter["y_id_proof"];
        $this->id_proof->AdvancedSearch->SearchOperator2 = @$filter["w_id_proof"];
        $this->id_proof->AdvancedSearch->save();

        // Field agent
        $this->agent->AdvancedSearch->SearchValue = @$filter["x_agent"];
        $this->agent->AdvancedSearch->SearchOperator = @$filter["z_agent"];
        $this->agent->AdvancedSearch->SearchCondition = @$filter["v_agent"];
        $this->agent->AdvancedSearch->SearchValue2 = @$filter["y_agent"];
        $this->agent->AdvancedSearch->SearchOperator2 = @$filter["w_agent"];
        $this->agent->AdvancedSearch->save();

        // Field other_details
        $this->other_details->AdvancedSearch->SearchValue = @$filter["x_other_details"];
        $this->other_details->AdvancedSearch->SearchOperator = @$filter["z_other_details"];
        $this->other_details->AdvancedSearch->SearchCondition = @$filter["v_other_details"];
        $this->other_details->AdvancedSearch->SearchValue2 = @$filter["y_other_details"];
        $this->other_details->AdvancedSearch->SearchOperator2 = @$filter["w_other_details"];
        $this->other_details->AdvancedSearch->save();

        // Field bank_name
        $this->bank_name->AdvancedSearch->SearchValue = @$filter["x_bank_name"];
        $this->bank_name->AdvancedSearch->SearchOperator = @$filter["z_bank_name"];
        $this->bank_name->AdvancedSearch->SearchCondition = @$filter["v_bank_name"];
        $this->bank_name->AdvancedSearch->SearchValue2 = @$filter["y_bank_name"];
        $this->bank_name->AdvancedSearch->SearchOperator2 = @$filter["w_bank_name"];
        $this->bank_name->AdvancedSearch->save();

        // Field bank_ifsc_code
        $this->bank_ifsc_code->AdvancedSearch->SearchValue = @$filter["x_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->SearchOperator = @$filter["z_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->SearchCondition = @$filter["v_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->SearchValue2 = @$filter["y_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->SearchOperator2 = @$filter["w_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->save();

        // Field bank_account_no
        $this->bank_account_no->AdvancedSearch->SearchValue = @$filter["x_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchOperator = @$filter["z_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchCondition = @$filter["v_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchValue2 = @$filter["y_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchOperator2 = @$filter["w_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->save();

        // Field account_no
        $this->account_no->AdvancedSearch->SearchValue = @$filter["x_account_no"];
        $this->account_no->AdvancedSearch->SearchOperator = @$filter["z_account_no"];
        $this->account_no->AdvancedSearch->SearchCondition = @$filter["v_account_no"];
        $this->account_no->AdvancedSearch->SearchValue2 = @$filter["y_account_no"];
        $this->account_no->AdvancedSearch->SearchOperator2 = @$filter["w_account_no"];
        $this->account_no->AdvancedSearch->save();

        // Field loan_amount
        $this->loan_amount->AdvancedSearch->SearchValue = @$filter["x_loan_amount"];
        $this->loan_amount->AdvancedSearch->SearchOperator = @$filter["z_loan_amount"];
        $this->loan_amount->AdvancedSearch->SearchCondition = @$filter["v_loan_amount"];
        $this->loan_amount->AdvancedSearch->SearchValue2 = @$filter["y_loan_amount"];
        $this->loan_amount->AdvancedSearch->SearchOperator2 = @$filter["w_loan_amount"];
        $this->loan_amount->AdvancedSearch->save();

        // Field emi_amount
        $this->emi_amount->AdvancedSearch->SearchValue = @$filter["x_emi_amount"];
        $this->emi_amount->AdvancedSearch->SearchOperator = @$filter["z_emi_amount"];
        $this->emi_amount->AdvancedSearch->SearchCondition = @$filter["v_emi_amount"];
        $this->emi_amount->AdvancedSearch->SearchValue2 = @$filter["y_emi_amount"];
        $this->emi_amount->AdvancedSearch->SearchOperator2 = @$filter["w_emi_amount"];
        $this->emi_amount->AdvancedSearch->save();

        // Field frequency
        $this->frequency->AdvancedSearch->SearchValue = @$filter["x_frequency"];
        $this->frequency->AdvancedSearch->SearchOperator = @$filter["z_frequency"];
        $this->frequency->AdvancedSearch->SearchCondition = @$filter["v_frequency"];
        $this->frequency->AdvancedSearch->SearchValue2 = @$filter["y_frequency"];
        $this->frequency->AdvancedSearch->SearchOperator2 = @$filter["w_frequency"];
        $this->frequency->AdvancedSearch->save();

        // Field disbursement_amount
        $this->disbursement_amount->AdvancedSearch->SearchValue = @$filter["x_disbursement_amount"];
        $this->disbursement_amount->AdvancedSearch->SearchOperator = @$filter["z_disbursement_amount"];
        $this->disbursement_amount->AdvancedSearch->SearchCondition = @$filter["v_disbursement_amount"];
        $this->disbursement_amount->AdvancedSearch->SearchValue2 = @$filter["y_disbursement_amount"];
        $this->disbursement_amount->AdvancedSearch->SearchOperator2 = @$filter["w_disbursement_amount"];
        $this->disbursement_amount->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();

        // Field d_operator
        $this->d_operator->AdvancedSearch->SearchValue = @$filter["x_d_operator"];
        $this->d_operator->AdvancedSearch->SearchOperator = @$filter["z_d_operator"];
        $this->d_operator->AdvancedSearch->SearchCondition = @$filter["v_d_operator"];
        $this->d_operator->AdvancedSearch->SearchValue2 = @$filter["y_d_operator"];
        $this->d_operator->AdvancedSearch->SearchOperator2 = @$filter["w_d_operator"];
        $this->d_operator->AdvancedSearch->save();

        // Field d_datetime
        $this->d_datetime->AdvancedSearch->SearchValue = @$filter["x_d_datetime"];
        $this->d_datetime->AdvancedSearch->SearchOperator = @$filter["z_d_datetime"];
        $this->d_datetime->AdvancedSearch->SearchCondition = @$filter["v_d_datetime"];
        $this->d_datetime->AdvancedSearch->SearchValue2 = @$filter["y_d_datetime"];
        $this->d_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_d_datetime"];
        $this->d_datetime->AdvancedSearch->save();

        // Field no_of_emi
        $this->no_of_emi->AdvancedSearch->SearchValue = @$filter["x_no_of_emi"];
        $this->no_of_emi->AdvancedSearch->SearchOperator = @$filter["z_no_of_emi"];
        $this->no_of_emi->AdvancedSearch->SearchCondition = @$filter["v_no_of_emi"];
        $this->no_of_emi->AdvancedSearch->SearchValue2 = @$filter["y_no_of_emi"];
        $this->no_of_emi->AdvancedSearch->SearchOperator2 = @$filter["w_no_of_emi"];
        $this->no_of_emi->AdvancedSearch->save();

        // Field fund_o
        $this->fund_o->AdvancedSearch->SearchValue = @$filter["x_fund_o"];
        $this->fund_o->AdvancedSearch->SearchOperator = @$filter["z_fund_o"];
        $this->fund_o->AdvancedSearch->SearchCondition = @$filter["v_fund_o"];
        $this->fund_o->AdvancedSearch->SearchValue2 = @$filter["y_fund_o"];
        $this->fund_o->AdvancedSearch->SearchOperator2 = @$filter["w_fund_o"];
        $this->fund_o->AdvancedSearch->save();

        // Field fund_o_no
        $this->fund_o_no->AdvancedSearch->SearchValue = @$filter["x_fund_o_no"];
        $this->fund_o_no->AdvancedSearch->SearchOperator = @$filter["z_fund_o_no"];
        $this->fund_o_no->AdvancedSearch->SearchCondition = @$filter["v_fund_o_no"];
        $this->fund_o_no->AdvancedSearch->SearchValue2 = @$filter["y_fund_o_no"];
        $this->fund_o_no->AdvancedSearch->SearchOperator2 = @$filter["w_fund_o_no"];
        $this->fund_o_no->AdvancedSearch->save();

        // Field int_@
        $this->int_->AdvancedSearch->SearchValue = @$filter["x_int_"];
        $this->int_->AdvancedSearch->SearchOperator = @$filter["z_int_"];
        $this->int_->AdvancedSearch->SearchCondition = @$filter["v_int_"];
        $this->int_->AdvancedSearch->SearchValue2 = @$filter["y_int_"];
        $this->int_->AdvancedSearch->SearchOperator2 = @$filter["w_int_"];
        $this->int_->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->b_type, $default, false); // b_type
        $this->buildSearchSql($where, $this->grp, $default, false); // grp
        $this->buildSearchSql($where, $this->branch, $default, false); // branch
        $this->buildSearchSql($where, $this->category, $default, false); // category
        $this->buildSearchSql($where, $this->account_type, $default, false); // account_type
        $this->buildSearchSql($where, $this->type, $default, false); // type
        $this->buildSearchSql($where, $this->formal_name, $default, false); // formal_name
        $this->buildSearchSql($where, $this->mobile, $default, false); // mobile
        $this->buildSearchSql($where, $this->_email, $default, false); // email
        $this->buildSearchSql($where, $this->image, $default, false); // image
        $this->buildSearchSql($where, $this->sign_image, $default, false); // sign_image
        $this->buildSearchSql($where, $this->status, $default, false); // status
        $this->buildSearchSql($where, $this->aadhaar_no, $default, false); // aadhaar_no
        $this->buildSearchSql($where, $this->pan_no, $default, false); // pan_no
        $this->buildSearchSql($where, $this->id_proof, $default, false); // id_proof
        $this->buildSearchSql($where, $this->agent, $default, false); // agent
        $this->buildSearchSql($where, $this->other_details, $default, false); // other_details
        $this->buildSearchSql($where, $this->bank_name, $default, false); // bank_name
        $this->buildSearchSql($where, $this->bank_ifsc_code, $default, false); // bank_ifsc_code
        $this->buildSearchSql($where, $this->bank_account_no, $default, false); // bank_account_no
        $this->buildSearchSql($where, $this->account_no, $default, false); // account_no
        $this->buildSearchSql($where, $this->loan_amount, $default, false); // loan_amount
        $this->buildSearchSql($where, $this->emi_amount, $default, false); // emi_amount
        $this->buildSearchSql($where, $this->frequency, $default, false); // frequency
        $this->buildSearchSql($where, $this->disbursement_amount, $default, false); // disbursement_amount
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime
        $this->buildSearchSql($where, $this->d_operator, $default, false); // d_operator
        $this->buildSearchSql($where, $this->d_datetime, $default, false); // d_datetime
        $this->buildSearchSql($where, $this->no_of_emi, $default, false); // no_of_emi
        $this->buildSearchSql($where, $this->fund_o, $default, false); // fund_o
        $this->buildSearchSql($where, $this->fund_o_no, $default, false); // fund_o_no
        $this->buildSearchSql($where, $this->int_, $default, false); // int_@

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->b_type->AdvancedSearch->save(); // b_type
            $this->grp->AdvancedSearch->save(); // grp
            $this->branch->AdvancedSearch->save(); // branch
            $this->category->AdvancedSearch->save(); // category
            $this->account_type->AdvancedSearch->save(); // account_type
            $this->type->AdvancedSearch->save(); // type
            $this->formal_name->AdvancedSearch->save(); // formal_name
            $this->mobile->AdvancedSearch->save(); // mobile
            $this->_email->AdvancedSearch->save(); // email
            $this->image->AdvancedSearch->save(); // image
            $this->sign_image->AdvancedSearch->save(); // sign_image
            $this->status->AdvancedSearch->save(); // status
            $this->aadhaar_no->AdvancedSearch->save(); // aadhaar_no
            $this->pan_no->AdvancedSearch->save(); // pan_no
            $this->id_proof->AdvancedSearch->save(); // id_proof
            $this->agent->AdvancedSearch->save(); // agent
            $this->other_details->AdvancedSearch->save(); // other_details
            $this->bank_name->AdvancedSearch->save(); // bank_name
            $this->bank_ifsc_code->AdvancedSearch->save(); // bank_ifsc_code
            $this->bank_account_no->AdvancedSearch->save(); // bank_account_no
            $this->account_no->AdvancedSearch->save(); // account_no
            $this->loan_amount->AdvancedSearch->save(); // loan_amount
            $this->emi_amount->AdvancedSearch->save(); // emi_amount
            $this->frequency->AdvancedSearch->save(); // frequency
            $this->disbursement_amount->AdvancedSearch->save(); // disbursement_amount
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->d_operator->AdvancedSearch->save(); // d_operator
            $this->d_datetime->AdvancedSearch->save(); // d_datetime
            $this->no_of_emi->AdvancedSearch->save(); // no_of_emi
            $this->fund_o->AdvancedSearch->save(); // fund_o
            $this->fund_o_no->AdvancedSearch->save(); // fund_o_no
            $this->int_->AdvancedSearch->save(); // int_@

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->b_type->AdvancedSearch->save(); // b_type
            $this->grp->AdvancedSearch->save(); // grp
            $this->branch->AdvancedSearch->save(); // branch
            $this->category->AdvancedSearch->save(); // category
            $this->account_type->AdvancedSearch->save(); // account_type
            $this->type->AdvancedSearch->save(); // type
            $this->formal_name->AdvancedSearch->save(); // formal_name
            $this->mobile->AdvancedSearch->save(); // mobile
            $this->_email->AdvancedSearch->save(); // email
            $this->image->AdvancedSearch->save(); // image
            $this->sign_image->AdvancedSearch->save(); // sign_image
            $this->status->AdvancedSearch->save(); // status
            $this->aadhaar_no->AdvancedSearch->save(); // aadhaar_no
            $this->pan_no->AdvancedSearch->save(); // pan_no
            $this->id_proof->AdvancedSearch->save(); // id_proof
            $this->agent->AdvancedSearch->save(); // agent
            $this->other_details->AdvancedSearch->save(); // other_details
            $this->bank_name->AdvancedSearch->save(); // bank_name
            $this->bank_ifsc_code->AdvancedSearch->save(); // bank_ifsc_code
            $this->bank_account_no->AdvancedSearch->save(); // bank_account_no
            $this->account_no->AdvancedSearch->save(); // account_no
            $this->loan_amount->AdvancedSearch->save(); // loan_amount
            $this->emi_amount->AdvancedSearch->save(); // emi_amount
            $this->frequency->AdvancedSearch->save(); // frequency
            $this->disbursement_amount->AdvancedSearch->save(); // disbursement_amount
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->d_operator->AdvancedSearch->save(); // d_operator
            $this->d_datetime->AdvancedSearch->save(); // d_datetime
            $this->no_of_emi->AdvancedSearch->save(); // no_of_emi
            $this->fund_o->AdvancedSearch->save(); // fund_o
            $this->fund_o_no->AdvancedSearch->save(); // fund_o_no
            $this->int_->AdvancedSearch->save(); // int_@
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field b_type
        $filter = $this->queryBuilderWhere("b_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field grp
        $filter = $this->queryBuilderWhere("grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->grp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field branch
        $filter = $this->queryBuilderWhere("branch");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->branch, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->branch->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field account_type
        $filter = $this->queryBuilderWhere("account_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->account_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->account_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field type
        $filter = $this->queryBuilderWhere("type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field formal_name
        $filter = $this->queryBuilderWhere("formal_name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->formal_name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->formal_name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field mobile
        $filter = $this->queryBuilderWhere("mobile");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->mobile, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->mobile->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field agent
        $filter = $this->queryBuilderWhere("agent");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->agent, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->agent->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field account_no
        $filter = $this->queryBuilderWhere("account_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->account_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->account_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field loan_amount
        $filter = $this->queryBuilderWhere("loan_amount");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->loan_amount, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->loan_amount->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field emi_amount
        $filter = $this->queryBuilderWhere("emi_amount");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->emi_amount, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->emi_amount->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field frequency
        $filter = $this->queryBuilderWhere("frequency");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->frequency, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->frequency->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field disbursement_amount
        $filter = $this->queryBuilderWhere("disbursement_amount");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->disbursement_amount, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->disbursement_amount->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field datetime
        $filter = $this->queryBuilderWhere("datetime");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->datetime, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->datetime->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field no_of_emi
        $filter = $this->queryBuilderWhere("no_of_emi");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->no_of_emi, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->no_of_emi->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field fund_o
        $filter = $this->queryBuilderWhere("fund_o");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->fund_o, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->fund_o->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field fund_o_no
        $filter = $this->queryBuilderWhere("fund_o_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->fund_o_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->fund_o_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field int_@
        $filter = $this->queryBuilderWhere("int_@");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->int_, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->int_->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->id;
        $searchFlds[] = &$this->category;
        $searchFlds[] = &$this->formal_name;
        $searchFlds[] = &$this->_email;
        $searchFlds[] = &$this->image;
        $searchFlds[] = &$this->sign_image;
        $searchFlds[] = &$this->aadhaar_no;
        $searchFlds[] = &$this->pan_no;
        $searchFlds[] = &$this->id_proof;
        $searchFlds[] = &$this->agent;
        $searchFlds[] = &$this->other_details;
        $searchFlds[] = &$this->bank_name;
        $searchFlds[] = &$this->bank_ifsc_code;
        $searchFlds[] = &$this->bank_account_no;
        $searchFlds[] = &$this->account_no;
        $searchFlds[] = &$this->fund_o_no;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->b_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->branch->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->category->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->account_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->formal_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->mobile->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_email->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->image->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sign_image->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->aadhaar_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pan_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->id_proof->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->agent->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->other_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bank_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bank_ifsc_code->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bank_account_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->account_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->loan_amount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->emi_amount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->frequency->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->disbursement_amount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->no_of_emi->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->fund_o->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->fund_o_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->int_->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->b_type->AdvancedSearch->unsetSession();
        $this->grp->AdvancedSearch->unsetSession();
        $this->branch->AdvancedSearch->unsetSession();
        $this->category->AdvancedSearch->unsetSession();
        $this->account_type->AdvancedSearch->unsetSession();
        $this->type->AdvancedSearch->unsetSession();
        $this->formal_name->AdvancedSearch->unsetSession();
        $this->mobile->AdvancedSearch->unsetSession();
        $this->_email->AdvancedSearch->unsetSession();
        $this->image->AdvancedSearch->unsetSession();
        $this->sign_image->AdvancedSearch->unsetSession();
        $this->status->AdvancedSearch->unsetSession();
        $this->aadhaar_no->AdvancedSearch->unsetSession();
        $this->pan_no->AdvancedSearch->unsetSession();
        $this->id_proof->AdvancedSearch->unsetSession();
        $this->agent->AdvancedSearch->unsetSession();
        $this->other_details->AdvancedSearch->unsetSession();
        $this->bank_name->AdvancedSearch->unsetSession();
        $this->bank_ifsc_code->AdvancedSearch->unsetSession();
        $this->bank_account_no->AdvancedSearch->unsetSession();
        $this->account_no->AdvancedSearch->unsetSession();
        $this->loan_amount->AdvancedSearch->unsetSession();
        $this->emi_amount->AdvancedSearch->unsetSession();
        $this->frequency->AdvancedSearch->unsetSession();
        $this->disbursement_amount->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
        $this->d_operator->AdvancedSearch->unsetSession();
        $this->d_datetime->AdvancedSearch->unsetSession();
        $this->no_of_emi->AdvancedSearch->unsetSession();
        $this->fund_o->AdvancedSearch->unsetSession();
        $this->fund_o_no->AdvancedSearch->unsetSession();
        $this->int_->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->b_type->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->branch->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->account_type->AdvancedSearch->load();
        $this->type->AdvancedSearch->load();
        $this->formal_name->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->_email->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->sign_image->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->aadhaar_no->AdvancedSearch->load();
        $this->pan_no->AdvancedSearch->load();
        $this->id_proof->AdvancedSearch->load();
        $this->agent->AdvancedSearch->load();
        $this->other_details->AdvancedSearch->load();
        $this->bank_name->AdvancedSearch->load();
        $this->bank_ifsc_code->AdvancedSearch->load();
        $this->bank_account_no->AdvancedSearch->load();
        $this->account_no->AdvancedSearch->load();
        $this->loan_amount->AdvancedSearch->load();
        $this->emi_amount->AdvancedSearch->load();
        $this->frequency->AdvancedSearch->load();
        $this->disbursement_amount->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->d_operator->AdvancedSearch->load();
        $this->d_datetime->AdvancedSearch->load();
        $this->no_of_emi->AdvancedSearch->load();
        $this->fund_o->AdvancedSearch->load();
        $this->fund_o_no->AdvancedSearch->load();
        $this->int_->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id); // id
            $this->updateSort($this->b_type); // b_type
            $this->updateSort($this->grp); // grp
            $this->updateSort($this->branch); // branch
            $this->updateSort($this->account_type); // account_type
            $this->updateSort($this->type); // type
            $this->updateSort($this->formal_name); // formal_name
            $this->updateSort($this->mobile); // mobile
            $this->updateSort($this->agent); // agent
            $this->updateSort($this->account_no); // account_no
            $this->updateSort($this->loan_amount); // loan_amount
            $this->updateSort($this->emi_amount); // emi_amount
            $this->updateSort($this->frequency); // frequency
            $this->updateSort($this->disbursement_amount); // disbursement_amount
            $this->updateSort($this->datetime); // datetime
            $this->updateSort($this->otp_delivery_datetime); // otp_delivery_datetime
            $this->updateSort($this->otp_verify_datetime); // otp_verify_datetime
            $this->updateSort($this->no_of_emi); // no_of_emi
            $this->updateSort($this->fund_o); // fund_o
            $this->updateSort($this->fund_o_no); // fund_o_no
            $this->updateSort($this->int_); // int_@
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->b_type->setSort("");
                $this->grp->setSort("");
                $this->branch->setSort("");
                $this->category->setSort("");
                $this->account_type->setSort("");
                $this->type->setSort("");
                $this->formal_name->setSort("");
                $this->mobile->setSort("");
                $this->_email->setSort("");
                $this->image->setSort("");
                $this->sign_image->setSort("");
                $this->status->setSort("");
                $this->aadhaar_no->setSort("");
                $this->pan_no->setSort("");
                $this->id_proof->setSort("");
                $this->agent->setSort("");
                $this->other_details->setSort("");
                $this->bank_name->setSort("");
                $this->bank_ifsc_code->setSort("");
                $this->bank_account_no->setSort("");
                $this->account_no->setSort("");
                $this->loan_amount->setSort("");
                $this->emi_amount->setSort("");
                $this->frequency->setSort("");
                $this->disbursement_amount->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->d_operator->setSort("");
                $this->d_datetime->setSort("");
                $this->otp->setSort("");
                $this->otp_delivery_datetime->setSort("");
                $this->otp_verify_datetime->setSort("");
                $this->no_of_emi->setSort("");
                $this->fund_o->setSort("");
                $this->fund_o_no->setSort("");
                $this->int_->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = true;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"b_account_info\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"b_account_info\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"b_account_info\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fb_account_infolist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fb_account_infolist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"b_account_info\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Add multi update
        $item = &$option->add("multiupdate");
        $item->Body = "<button type=\"button\" class=\"ew-action ew-multi-update\" title=\"" .
            $Language->phrase("UpdateSelectedLink", true) . "\" data-table=\"b_account_info\" data-caption=\"" .
            $Language->phrase("UpdateSelectedLink", true) . "\" form=\"fb_account_infolist\" data-ew-action=\"" .
            ($this->ModalUpdate && !IsMobile() ? "modal" : "submit") . "\"" .
            ($this->ModalUpdate && !IsMobile() ? " data-action=\"update\"" : "") .
            ($this->UseAjaxActions ? " data-ajax=\"true\"" : "") .
            " data-url=\"" . GetUrl($this->MultiUpdateUrl) . "\">" . $Language->phrase("UpdateSelectedLink") . "</button>";
        $item->Visible = $Security->canEdit();

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "b_type");
            $this->createColumnOption($option, "grp");
            $this->createColumnOption($option, "branch");
            $this->createColumnOption($option, "account_type");
            $this->createColumnOption($option, "type");
            $this->createColumnOption($option, "formal_name");
            $this->createColumnOption($option, "mobile");
            $this->createColumnOption($option, "agent");
            $this->createColumnOption($option, "account_no");
            $this->createColumnOption($option, "loan_amount");
            $this->createColumnOption($option, "emi_amount");
            $this->createColumnOption($option, "frequency");
            $this->createColumnOption($option, "disbursement_amount");
            $this->createColumnOption($option, "datetime");
            $this->createColumnOption($option, "otp_delivery_datetime");
            $this->createColumnOption($option, "otp_verify_datetime");
            $this->createColumnOption($option, "no_of_emi");
            $this->createColumnOption($option, "fund_o");
            $this->createColumnOption($option, "fund_o_no");
            $this->createColumnOption($option, "int_@");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fb_account_infosrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fb_account_infosrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fb_account_infolist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_b_account_info", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_b_account_info",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // b_type
        if ($this->b_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_type->AdvancedSearch->SearchValue != "" || $this->b_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->grp->AdvancedSearch->SearchValue != "" || $this->grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // branch
        if ($this->branch->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->branch->AdvancedSearch->SearchValue != "" || $this->branch->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->category->AdvancedSearch->SearchValue != "" || $this->category->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // account_type
        if ($this->account_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->account_type->AdvancedSearch->SearchValue != "" || $this->account_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // type
        if ($this->type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->type->AdvancedSearch->SearchValue != "" || $this->type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // formal_name
        if ($this->formal_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->formal_name->AdvancedSearch->SearchValue != "" || $this->formal_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->mobile->AdvancedSearch->SearchValue != "" || $this->mobile->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // email
        if ($this->_email->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_email->AdvancedSearch->SearchValue != "" || $this->_email->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // image
        if ($this->image->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->image->AdvancedSearch->SearchValue != "" || $this->image->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sign_image
        if ($this->sign_image->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sign_image->AdvancedSearch->SearchValue != "" || $this->sign_image->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status->AdvancedSearch->SearchValue != "" || $this->status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // aadhaar_no
        if ($this->aadhaar_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->aadhaar_no->AdvancedSearch->SearchValue != "" || $this->aadhaar_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pan_no
        if ($this->pan_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pan_no->AdvancedSearch->SearchValue != "" || $this->pan_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // id_proof
        if ($this->id_proof->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id_proof->AdvancedSearch->SearchValue != "" || $this->id_proof->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // agent
        if ($this->agent->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->agent->AdvancedSearch->SearchValue != "" || $this->agent->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // other_details
        if ($this->other_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->other_details->AdvancedSearch->SearchValue != "" || $this->other_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bank_name
        if ($this->bank_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bank_name->AdvancedSearch->SearchValue != "" || $this->bank_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bank_ifsc_code
        if ($this->bank_ifsc_code->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bank_ifsc_code->AdvancedSearch->SearchValue != "" || $this->bank_ifsc_code->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bank_account_no
        if ($this->bank_account_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bank_account_no->AdvancedSearch->SearchValue != "" || $this->bank_account_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // account_no
        if ($this->account_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->account_no->AdvancedSearch->SearchValue != "" || $this->account_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // loan_amount
        if ($this->loan_amount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->loan_amount->AdvancedSearch->SearchValue != "" || $this->loan_amount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // emi_amount
        if ($this->emi_amount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->emi_amount->AdvancedSearch->SearchValue != "" || $this->emi_amount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // frequency
        if ($this->frequency->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->frequency->AdvancedSearch->SearchValue != "" || $this->frequency->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // disbursement_amount
        if ($this->disbursement_amount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->disbursement_amount->AdvancedSearch->SearchValue != "" || $this->disbursement_amount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_operator
        if ($this->d_operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_operator->AdvancedSearch->SearchValue != "" || $this->d_operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_datetime
        if ($this->d_datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_datetime->AdvancedSearch->SearchValue != "" || $this->d_datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // no_of_emi
        if ($this->no_of_emi->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->no_of_emi->AdvancedSearch->SearchValue != "" || $this->no_of_emi->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // fund_o
        if ($this->fund_o->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->fund_o->AdvancedSearch->SearchValue != "" || $this->fund_o->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // fund_o_no
        if ($this->fund_o_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->fund_o_no->AdvancedSearch->SearchValue != "" || $this->fund_o_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // int_@
        if ($this->int_->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->int_->AdvancedSearch->SearchValue != "" || $this->int_->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->b_type->setDbValue($row['b_type']);
        $this->grp->setDbValue($row['grp']);
        $this->branch->setDbValue($row['branch']);
        $this->category->setDbValue($row['category']);
        $this->account_type->setDbValue($row['account_type']);
        $this->type->setDbValue($row['type']);
        $this->formal_name->setDbValue($row['formal_name']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->sign_image->Upload->DbValue = $row['sign_image'];
        $this->sign_image->setDbValue($this->sign_image->Upload->DbValue);
        $this->status->setDbValue($row['status']);
        $this->aadhaar_no->setDbValue($row['aadhaar_no']);
        $this->pan_no->setDbValue($row['pan_no']);
        $this->id_proof->Upload->DbValue = $row['id_proof'];
        $this->id_proof->setDbValue($this->id_proof->Upload->DbValue);
        $this->agent->setDbValue($row['agent']);
        $this->other_details->setDbValue($row['other_details']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->account_no->setDbValue($row['account_no']);
        $this->loan_amount->setDbValue($row['loan_amount']);
        $this->emi_amount->setDbValue($row['emi_amount']);
        $this->frequency->setDbValue($row['frequency']);
        $this->disbursement_amount->setDbValue($row['disbursement_amount']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->d_operator->setDbValue($row['d_operator']);
        $this->d_datetime->setDbValue($row['d_datetime']);
        $this->otp->setDbValue($row['otp']);
        $this->otp_delivery_datetime->setDbValue($row['otp_delivery_datetime']);
        $this->otp_verify_datetime->setDbValue($row['otp_verify_datetime']);
        $this->no_of_emi->setDbValue($row['no_of_emi']);
        $this->fund_o->setDbValue($row['fund_o']);
        $this->fund_o_no->setDbValue($row['fund_o_no']);
        $this->int_->setDbValue($row['int_@']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['b_type'] = $this->b_type->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['branch'] = $this->branch->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['account_type'] = $this->account_type->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['formal_name'] = $this->formal_name->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['sign_image'] = $this->sign_image->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['aadhaar_no'] = $this->aadhaar_no->DefaultValue;
        $row['pan_no'] = $this->pan_no->DefaultValue;
        $row['id_proof'] = $this->id_proof->DefaultValue;
        $row['agent'] = $this->agent->DefaultValue;
        $row['other_details'] = $this->other_details->DefaultValue;
        $row['bank_name'] = $this->bank_name->DefaultValue;
        $row['bank_ifsc_code'] = $this->bank_ifsc_code->DefaultValue;
        $row['bank_account_no'] = $this->bank_account_no->DefaultValue;
        $row['account_no'] = $this->account_no->DefaultValue;
        $row['loan_amount'] = $this->loan_amount->DefaultValue;
        $row['emi_amount'] = $this->emi_amount->DefaultValue;
        $row['frequency'] = $this->frequency->DefaultValue;
        $row['disbursement_amount'] = $this->disbursement_amount->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['d_operator'] = $this->d_operator->DefaultValue;
        $row['d_datetime'] = $this->d_datetime->DefaultValue;
        $row['otp'] = $this->otp->DefaultValue;
        $row['otp_delivery_datetime'] = $this->otp_delivery_datetime->DefaultValue;
        $row['otp_verify_datetime'] = $this->otp_verify_datetime->DefaultValue;
        $row['no_of_emi'] = $this->no_of_emi->DefaultValue;
        $row['fund_o'] = $this->fund_o->DefaultValue;
        $row['fund_o_no'] = $this->fund_o_no->DefaultValue;
        $row['int_@'] = $this->int_->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // b_type

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // branch

        // category

        // account_type

        // type

        // formal_name

        // mobile

        // email

        // image

        // sign_image

        // status

        // aadhaar_no

        // pan_no

        // id_proof

        // agent

        // other_details

        // bank_name

        // bank_ifsc_code

        // bank_account_no

        // account_no

        // loan_amount

        // emi_amount

        // frequency

        // disbursement_amount

        // operator

        // datetime

        // d_operator

        // d_datetime

        // otp
        $this->otp->CellCssStyle = "white-space: nowrap;";

        // otp_delivery_datetime
        $this->otp_delivery_datetime->CellCssStyle = "white-space: nowrap;";

        // otp_verify_datetime
        $this->otp_verify_datetime->CellCssStyle = "white-space: nowrap;";

        // no_of_emi

        // fund_o

        // fund_o_no

        // int_@

        // Accumulate aggregate value
        if ($this->RowType != RowType::AGGREGATEINIT && $this->RowType != RowType::AGGREGATE && $this->RowType != RowType::PREVIEWFIELD) {
            if (is_numeric($this->loan_amount->CurrentValue)) {
                $this->loan_amount->Total += $this->loan_amount->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->emi_amount->CurrentValue)) {
                $this->emi_amount->Total += $this->emi_amount->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->disbursement_amount->CurrentValue)) {
                $this->disbursement_amount->Total += $this->disbursement_amount->CurrentValue; // Accumulate total
            }
        }

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // b_type
            if (strval($this->b_type->CurrentValue) != "") {
                $this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
            } else {
                $this->b_type->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // branch
            $curVal = strval($this->branch->CurrentValue);
            if ($curVal != "") {
                $this->branch->ViewValue = $this->branch->lookupCacheOption($curVal);
                if ($this->branch->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->branch->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->branch->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->branch->getSelectFilter($this); // PHP
                    $sqlWrk = $this->branch->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->branch->Lookup->renderViewRow($rswrk[0]);
                        $this->branch->ViewValue = $this->branch->displayValue($arwrk);
                    } else {
                        $this->branch->ViewValue = FormatNumber($this->branch->CurrentValue, $this->branch->formatPattern());
                    }
                }
            } else {
                $this->branch->ViewValue = null;
            }

            // category
            if (strval($this->category->CurrentValue) != "") {
                $this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
            } else {
                $this->category->ViewValue = null;
            }

            // account_type
            $this->account_type->ViewValue = $this->account_type->CurrentValue;
            $this->account_type->ViewValue = FormatNumber($this->account_type->ViewValue, $this->account_type->formatPattern());

            // type
            $curVal = strval($this->type->CurrentValue);
            if ($curVal != "") {
                $this->type->ViewValue = $this->type->lookupCacheOption($curVal);
                if ($this->type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->type->Lookup->renderViewRow($rswrk[0]);
                        $this->type->ViewValue = $this->type->displayValue($arwrk);
                    } else {
                        $this->type->ViewValue = FormatNumber($this->type->CurrentValue, $this->type->formatPattern());
                    }
                }
            } else {
                $this->type->ViewValue = null;
            }

            // formal_name
            $this->formal_name->ViewValue = $this->formal_name->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // sign_image
            $this->sign_image->UploadPath = $this->sign_image->getUploadPath(); // PHP
            if (!EmptyValue($this->sign_image->Upload->DbValue)) {
                $this->sign_image->ViewValue = $this->sign_image->Upload->DbValue;
            } else {
                $this->sign_image->ViewValue = "";
            }

            // status
            $this->status->ViewValue = $this->status->CurrentValue;
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // pan_no
            $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

            // id_proof
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->ViewValue = "";
            }

            // agent
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->ViewValue = $this->agent->CurrentValue;
                    }
                }
            } else {
                $this->agent->ViewValue = null;
            }

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_ifsc_code
            $this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // account_no
            $this->account_no->ViewValue = $this->account_no->CurrentValue;

            // loan_amount
            $this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
            $this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, $this->loan_amount->formatPattern());

            // emi_amount
            $this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
            $this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, $this->emi_amount->formatPattern());

            // frequency
            if (strval($this->frequency->CurrentValue) != "") {
                $this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
            } else {
                $this->frequency->ViewValue = null;
            }

            // disbursement_amount
            $this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
            $this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, $this->disbursement_amount->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // d_operator
            $this->d_operator->ViewValue = $this->d_operator->CurrentValue;
            $this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, $this->d_operator->formatPattern());

            // d_datetime
            $this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
            $this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, $this->d_datetime->formatPattern());

            // otp_delivery_datetime
            $this->otp_delivery_datetime->ViewValue = $this->otp_delivery_datetime->CurrentValue;
            $this->otp_delivery_datetime->ViewValue = FormatDateTime($this->otp_delivery_datetime->ViewValue, $this->otp_delivery_datetime->formatPattern());

            // otp_verify_datetime
            $this->otp_verify_datetime->ViewValue = $this->otp_verify_datetime->CurrentValue;
            $this->otp_verify_datetime->ViewValue = FormatDateTime($this->otp_verify_datetime->ViewValue, $this->otp_verify_datetime->formatPattern());

            // no_of_emi
            $this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
            $this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, $this->no_of_emi->formatPattern());

            // fund_o
            $this->fund_o->ViewValue = $this->fund_o->CurrentValue;
            $this->fund_o->ViewValue = FormatNumber($this->fund_o->ViewValue, $this->fund_o->formatPattern());

            // fund_o_no
            $curVal = strval($this->fund_o_no->CurrentValue);
            if ($curVal != "") {
                $this->fund_o_no->ViewValue = $this->fund_o_no->lookupCacheOption($curVal);
                if ($this->fund_o_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->fund_o_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->fund_o_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->fund_o_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->fund_o_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->fund_o_no->Lookup->renderViewRow($rswrk[0]);
                        $this->fund_o_no->ViewValue = $this->fund_o_no->displayValue($arwrk);
                    } else {
                        $this->fund_o_no->ViewValue = $this->fund_o_no->CurrentValue;
                    }
                }
            } else {
                $this->fund_o_no->ViewValue = null;
            }

            // int_@
            $this->int_->ViewValue = $this->int_->CurrentValue;
            $this->int_->ViewValue = FormatNumber($this->int_->ViewValue, $this->int_->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // b_type
            $this->b_type->HrefValue = "";
            $this->b_type->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // branch
            $this->branch->HrefValue = "";
            $this->branch->TooltipValue = "";

            // account_type
            $this->account_type->HrefValue = "";
            $this->account_type->TooltipValue = "";

            // type
            $this->type->HrefValue = "";
            $this->type->TooltipValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";
            $this->formal_name->TooltipValue = "";
            if (!$this->isExport()) {
                $this->formal_name->ViewValue = $this->highlightValue($this->formal_name);
            }

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // agent
            $this->agent->HrefValue = "";
            $this->agent->TooltipValue = "";

            // account_no
            $this->account_no->HrefValue = "";
            $this->account_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->account_no->ViewValue = $this->highlightValue($this->account_no);
            }

            // loan_amount
            $this->loan_amount->HrefValue = "";
            $this->loan_amount->TooltipValue = "";

            // emi_amount
            $this->emi_amount->HrefValue = "";
            $this->emi_amount->TooltipValue = "";

            // frequency
            $this->frequency->HrefValue = "";
            $this->frequency->TooltipValue = "";

            // disbursement_amount
            $this->disbursement_amount->HrefValue = "";
            $this->disbursement_amount->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
            if (!$this->isExport()) {
                $this->datetime->ViewValue = $this->highlightValue($this->datetime);
            }

            // otp_delivery_datetime
            $this->otp_delivery_datetime->HrefValue = "";
            $this->otp_delivery_datetime->TooltipValue = "";

            // otp_verify_datetime
            $this->otp_verify_datetime->HrefValue = "";
            $this->otp_verify_datetime->TooltipValue = "";

            // no_of_emi
            $this->no_of_emi->HrefValue = "";
            $this->no_of_emi->TooltipValue = "";

            // fund_o
            $this->fund_o->HrefValue = "";
            $this->fund_o->TooltipValue = "";

            // fund_o_no
            $this->fund_o_no->HrefValue = "";
            $this->fund_o_no->TooltipValue = "";

            // int_@
            $this->int_->HrefValue = "";
            $this->int_->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // b_type
            $this->b_type->setupEditAttributes();
            $this->b_type->EditValue = $this->b_type->options(true);
            $this->b_type->PlaceHolder = RemoveHtml($this->b_type->caption());

            // grp
            $this->grp->setupEditAttributes();
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // branch
            $this->branch->setupEditAttributes();
            $this->branch->PlaceHolder = RemoveHtml($this->branch->caption());

            // account_type
            $this->account_type->setupEditAttributes();
            $this->account_type->EditValue = $this->account_type->AdvancedSearch->SearchValue;
            $this->account_type->PlaceHolder = RemoveHtml($this->account_type->caption());

            // type
            $this->type->setupEditAttributes();
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());

            // formal_name
            $this->formal_name->setupEditAttributes();
            if (!$this->formal_name->Raw) {
                $this->formal_name->AdvancedSearch->SearchValue = HtmlDecode($this->formal_name->AdvancedSearch->SearchValue);
            }
            $this->formal_name->EditValue = HtmlEncode($this->formal_name->AdvancedSearch->SearchValue);
            $this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->AdvancedSearch->SearchValue;
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // agent
            $this->agent->setupEditAttributes();
            $curVal = trim(strval($this->agent->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->agent->AdvancedSearch->ViewValue = $this->agent->lookupCacheOption($curVal);
            } else {
                $this->agent->AdvancedSearch->ViewValue = $this->agent->Lookup !== null && is_array($this->agent->lookupOptions()) && count($this->agent->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->agent->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->agent->EditValue = array_values($this->agent->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->agent->AdvancedSearch->SearchValue, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                $sqlWrk = $this->agent->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->agent->EditValue = $arwrk;
            }
            $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

            // account_no
            $this->account_no->setupEditAttributes();
            $this->account_no->EditCustomAttributes = $this->account_no->getEditCustomAttributes(); // PHP
            if (!$this->account_no->Raw) {
                $this->account_no->AdvancedSearch->SearchValue = HtmlDecode($this->account_no->AdvancedSearch->SearchValue);
            }
            $this->account_no->EditValue = HtmlEncode($this->account_no->AdvancedSearch->SearchValue);
            $this->account_no->PlaceHolder = RemoveHtml($this->account_no->caption());

            // loan_amount
            $this->loan_amount->setupEditAttributes();
            $this->loan_amount->EditValue = $this->loan_amount->AdvancedSearch->SearchValue;
            $this->loan_amount->PlaceHolder = RemoveHtml($this->loan_amount->caption());

            // emi_amount
            $this->emi_amount->setupEditAttributes();
            $this->emi_amount->EditValue = $this->emi_amount->AdvancedSearch->SearchValue;
            $this->emi_amount->PlaceHolder = RemoveHtml($this->emi_amount->caption());

            // frequency
            $this->frequency->setupEditAttributes();
            $this->frequency->EditValue = $this->frequency->options(true);
            $this->frequency->PlaceHolder = RemoveHtml($this->frequency->caption());

            // disbursement_amount
            $this->disbursement_amount->setupEditAttributes();
            $this->disbursement_amount->EditValue = $this->disbursement_amount->AdvancedSearch->SearchValue;
            $this->disbursement_amount->PlaceHolder = RemoveHtml($this->disbursement_amount->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // otp_delivery_datetime
            $this->otp_delivery_datetime->setupEditAttributes();
            $this->otp_delivery_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->otp_delivery_datetime->AdvancedSearch->SearchValue, $this->otp_delivery_datetime->formatPattern()), $this->otp_delivery_datetime->formatPattern()));
            $this->otp_delivery_datetime->PlaceHolder = RemoveHtml($this->otp_delivery_datetime->caption());

            // otp_verify_datetime
            $this->otp_verify_datetime->setupEditAttributes();
            $this->otp_verify_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->otp_verify_datetime->AdvancedSearch->SearchValue, $this->otp_verify_datetime->formatPattern()), $this->otp_verify_datetime->formatPattern()));
            $this->otp_verify_datetime->PlaceHolder = RemoveHtml($this->otp_verify_datetime->caption());

            // no_of_emi
            $this->no_of_emi->setupEditAttributes();
            $this->no_of_emi->EditValue = $this->no_of_emi->AdvancedSearch->SearchValue;
            $this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());

            // fund_o
            $this->fund_o->setupEditAttributes();
            $this->fund_o->EditValue = $this->fund_o->AdvancedSearch->SearchValue;
            $this->fund_o->PlaceHolder = RemoveHtml($this->fund_o->caption());

            // fund_o_no
            $this->fund_o_no->setupEditAttributes();
            $this->fund_o_no->PlaceHolder = RemoveHtml($this->fund_o_no->caption());

            // int_@
            $this->int_->setupEditAttributes();
            $this->int_->EditValue = $this->int_->AdvancedSearch->SearchValue;
            $this->int_->PlaceHolder = RemoveHtml($this->int_->caption());
        } elseif ($this->RowType == RowType::AGGREGATEINIT) { // Initialize aggregate row
                    $this->loan_amount->Total = 0; // Initialize total
                    $this->emi_amount->Total = 0; // Initialize total
                    $this->disbursement_amount->Total = 0; // Initialize total
        } elseif ($this->RowType == RowType::AGGREGATE) { // Aggregate row
            $this->loan_amount->CurrentValue = $this->loan_amount->Total;
            $this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
            $this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, $this->loan_amount->formatPattern());
            $this->loan_amount->HrefValue = ""; // Clear href value
            $this->emi_amount->CurrentValue = $this->emi_amount->Total;
            $this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
            $this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, $this->emi_amount->formatPattern());
            $this->emi_amount->HrefValue = ""; // Clear href value
            $this->disbursement_amount->CurrentValue = $this->disbursement_amount->Total;
            $this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
            $this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, $this->disbursement_amount->formatPattern());
            $this->disbursement_amount->HrefValue = ""; // Clear href value
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->b_type->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->branch->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->account_type->AdvancedSearch->load();
        $this->type->AdvancedSearch->load();
        $this->formal_name->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->_email->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->sign_image->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->aadhaar_no->AdvancedSearch->load();
        $this->pan_no->AdvancedSearch->load();
        $this->id_proof->AdvancedSearch->load();
        $this->agent->AdvancedSearch->load();
        $this->other_details->AdvancedSearch->load();
        $this->bank_name->AdvancedSearch->load();
        $this->bank_ifsc_code->AdvancedSearch->load();
        $this->bank_account_no->AdvancedSearch->load();
        $this->account_no->AdvancedSearch->load();
        $this->loan_amount->AdvancedSearch->load();
        $this->emi_amount->AdvancedSearch->load();
        $this->frequency->AdvancedSearch->load();
        $this->disbursement_amount->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->d_operator->AdvancedSearch->load();
        $this->d_datetime->AdvancedSearch->load();
        $this->no_of_emi->AdvancedSearch->load();
        $this->fund_o->AdvancedSearch->load();
        $this->fund_o_no->AdvancedSearch->load();
        $this->int_->AdvancedSearch->load();
    }

    // Build export filter for selected records
    protected function buildExportSelectedFilter()
    {
        global $Language;
        $wrkFilter = "";
        if ($this->isExport()) {
            $wrkFilter = $this->getFilterFromRecordKeys();
        }
        return $wrkFilter;
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fb_account_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fb_account_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fb_account_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fb_account_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fb_account_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fb_account_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            }
        } elseif (SameText($type, "html")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" form=\"fb_account_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"html\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToHtml") . "</button>";
        } elseif (SameText($type, "xml")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" form=\"fb_account_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"xml\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToXml") . "</button>";
        } elseif (SameText($type, "csv")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" form=\"fb_account_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"csv\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToCsv") . "</button>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fb_account_infolist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="true"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" form=\"fb_account_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"print\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("PrinterFriendly") . "</button>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fb_account_infosrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"b_account_info\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"baccountinfosearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"baccountinfosearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fb_account_infosrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_b_type":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_branch":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    break;
                case "x_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_frequency":
                    break;
                case "x_fund_o_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'account_info');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered() {
    	// Example:
    	//$this->ListOptions->Items["new"]->Body = "xxx";
    	$this->ListOptions->Add("View Ledger Book"); // Replace abclink with your name of the link
    	$this->ListOptions->Items["View Ledger Book"]->Body = '<a href="ledgerlist?ID='.$this->id->CurrentValue.'" data-bs-original-title ="View Ledger Book"><i data-phrase="View Ledger Book"  class="fa fa-list fa-2x ew-icon" ></i></a>';
    $app_test = 1;
    $no_of_emi = $this->no_of_emi->CurrentValue;
    $coll_log = ExecuteScalar("SELECT count(`account_no`) FROM `collection_log` WHERE `account_no` = " . $this->id->CurrentValue);
    if ($this->grp->CurrentValue == 130102)
    {
    $int_log_tmp = ExecuteScalar("SELECT count(`account_no`) FROM `b_account_int_log_tmp` WHERE `account_no` = " . $this->id->CurrentValue);
    $int_log = ExecuteScalar("SELECT count(`account_no`) FROM `b_account_int_log` WHERE `account_no` = " . $this->id->CurrentValue);
    	if (($this->fund_o_no->CurrentValue == null))
    	{
    		$this->ListOptions->Add("Link Security Account"); 
    		$this->ListOptions->Items["Link Security Account"]->Body = '<a href="/baccountinfoedit?id=' . $this->id->CurrentValue . '" data-bs-original-title ="Link Security Account"><i data-phrase="Link Security Account"  style="color:red" class="fa fa-info-circle fa-2x ew-icon" ></i></a>';
    		$app_test = 0;
    	}
    	if ( ($int_log_tmp == 0) )
    	{
    		$this->ListOptions->Add("Create Interest Log"); 
    		$this->ListOptions->Items["Create Interest Log"]->Body = '<a href="/baccountintlogtmplist" data-bs-original-title ="Create Interest Log"><i data-phrase="Create Interest Log"  style="color:IndianRed" class="fa fa-info-circle fa-2x ew-icon" ></i></a>';
    		$app_test = 0;
    	}	
    	elseif ( ($int_log_tmp < $no_of_emi) && ($this->status->CurrentValue < 120) )
    	{
    		$this->ListOptions->Add("Tmp Int Log Error"); 
    		$this->ListOptions->Items["Tmp Int Log Error"]->Body = '<a href="/baccountintlogtmplist?x_account_no_id=' . $this->id->CurrentValue . '" data-bs-original-title ="Tmp Int Log Error"><i data-phrase="Tmp Int Log Error"  style="color:DarkRed" class="fa fa-info-circle fa-2x ew-icon" ></i></a>';
    		$app_test = 0;	
    	}
    	if ( ($int_log < $no_of_emi) && ($this->status->CurrentValue >= 120) && ($this->status->CurrentValue < 122) )
    	{
    		$this->ListOptions->Add("Int Log Error"); 
    		$this->ListOptions->Items["Int Log Error"]->Body = '<a href="/baccountintloglist?x_account_no_id=' . $this->id->CurrentValue . '" data-bs-original-title ="Int Log Error"><i data-phrase="Int Log Error"  style="color:DarkRed" class="fa fa-info-circle fa-2x ew-icon" ></i></a>';
    		$app_test = 0;	
    	}
    	if ( ($coll_log < $int_log) && ($this->status->CurrentValue >= 120) && ($this->status->CurrentValue < 122) )
    	{
    		$this->ListOptions->Add("Collection Log Error"); 
    		$this->ListOptions->Items["Collection Log Error"]->Body = '<a href="/collectionloglist?x_account_no=' . $this->id->CurrentValue . '" data-bs-original-title ="Collection Log Error"><i data-phrase="Collection Log Error"  style="color:Blue" class="fa fa-info-circle fa-2x ew-icon" ></i></a>';
    	}
    }
    	if ( ($this->grp->CurrentValue == 130101) || ($this->grp->CurrentValue == 130102))
    	{
    		if ( $this->status->CurrentValue < 103 )
    		{
    			$this->ListOptions->Add("Send OTP"); 
    			$this->ListOptions->Items["Send OTP"]->Body = '<a href="autoprogramme?apcid=043485b042179e1b0547288346a47044&id=' . $this->id->CurrentValue . '" data-bs-original-title ="Send OTP"><i data-phrase="Send OTP"  class="fa fa-thumbs-up fa-2x ew-icon" ></i></a>';
    		}
    		if (($this->status->CurrentValue == 103) && (CurrentUserID() == 51) && ($app_test == 1) )
    		{
    			$this->ListOptions->Add("Reject/Approve"); 
    			$this->ListOptions->Items["Reject/Approve"]->Body = '<a href="autoprogramme?apcid=0dd989c64c054921672af61a0c7a5e95&id=' . $this->id->CurrentValue . '" data-bs-original-title ="Reject/Approve"><i data-phrase="Reject/Approve"  class="fa fa-thumbs-up fa-2x ew-icon"  style="color:orange"></i></a>';
    		}
    		if (($this->status->CurrentValue > 110) && ($this->status->CurrentValue < 121) && (CurrentUserID() == 51))
    		{
    			$this->ListOptions->Add("Disburse"); 
    			$this->ListOptions->Items["Disburse"]->Body = '<a href="autoprogramme?apcid=7602980244b8793fb90d3bfb3bef1639&id=' . $this->id->CurrentValue . '" data-bs-original-title ="Disburse"><i data-phrase="Disburse"  class="fa fa-thumbs-up fa-2x ew-icon"  style="color:red"></i></a>';
    		}
    	}
    	if ( ($coll_log < ($this->loan_amount->CurrentValue / $this->emi_amount->CurrentValue)) && ($this->status->CurrentValue >= 120) && ($this->status->CurrentValue < 122) && ($this->grp->CurrentValue == 130101) )
    	{
    		$this->ListOptions->Add("Collection Log Error"); 
    		$this->ListOptions->Items["Collection Log Error"]->Body = '<a href="/collectionloglist?x_account_no=' . $this->id->CurrentValue . '" data-bs-original-title ="Collection Log Error"><i data-phrase="Collection Log Error"  style="color:Blue" class="fa fa-info-circle fa-2x ew-icon" ></i></a>';
    	}
    	if (($this->status->CurrentValue > 120) && ($this->status->CurrentValue < 122) && (CurrentUserID() == 51))
    		{
    			$this->ListOptions->Add("Close Account"); 
    			$this->ListOptions->Items["Close Account"]->Body = '<a href="autoprogramme?apcid=b5ab45423ffb576accdb554b967cdad5&id=' . $this->id->CurrentValue . '" data-bs-original-title ="Close Account"><i data-phrase="Close Account"  class="fa fa-thumbs-up fa-2x ew-icon"  style="color:yellow"></i></a>';
    		}		
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
