<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BAccountInfoAgentEdit extends BAccountInfoAgent
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BAccountInfoAgentEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "baccountinfoagentedit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->b_type->setVisibility();
        $this->grp->setVisibility();
        $this->account_type->setVisibility();
        $this->aadhaar_no->setVisibility();
        $this->account_no->Visible = false;
        $this->formal_name->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->Visible = false;
        $this->image->setVisibility();
        $this->status->Visible = false;
        $this->pan_no->setVisibility();
        $this->id_proof->setVisibility();
        $this->agent->Visible = false;
        $this->other_details->Visible = false;
        $this->loan_amount->Visible = false;
        $this->int_->setVisibility();
        $this->disbursement_amount->Visible = false;
        $this->emi_amount->Visible = false;
        $this->no_of_emi->Visible = false;
        $this->frequency->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->otp->Visible = false;
        $this->otp_delivery_datetime->Visible = false;
        $this->otp_verify_datetime->Visible = false;
        $this->fund_o->Visible = false;
        $this->fund_o_no->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'b_account_info_agent';
        $this->TableName = 'b_account_info_agent';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (b_account_info_agent)
        if (!isset($GLOBALS["b_account_info_agent"]) || $GLOBALS["b_account_info_agent"]::class == PROJECT_NAMESPACE . "b_account_info_agent") {
            $GLOBALS["b_account_info_agent"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_info_agent');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "baccountinfoagentview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
                $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->grp->Required = false;
        $this->aadhaar_no->Required = false;
        $this->formal_name->Required = false;
        $this->mobile->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->b_type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->account_type);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->agent);
        $this->setupLookupOptions($this->frequency);
        $this->setupLookupOptions($this->fund_o_no);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Load record by position
        $loadByPosition = false;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
                if (!$loadByQuery || Get(Config("TABLE_START_REC")) !== null || Get(Config("TABLE_PAGE_NUMBER")) !== null) {
                    $loadByPosition = true;
                }
            }

            // Load result set
            if ($this->isShow()) {
                if (!$this->IsModal) { // Normal edit page
                    $this->StartRecord = 1; // Initialize start position
                    $this->Recordset = $this->loadRecordset(); // Load records
                    if ($this->TotalRecords <= 0) { // No record found
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("baccountinfoagentlist"); // Return to list page
                        return;
                    } elseif ($loadByPosition) { // Load record by position
                        $this->setupStartRecord(); // Set up start record position
                        // Point to current record
                        if ($this->StartRecord <= $this->TotalRecords) {
                            $this->fetch($this->StartRecord);
                            // Redirect to correct record
                            $this->loadRowValues($this->CurrentRow);
                            $url = $this->getCurrentUrl();
                            $this->terminate($url);
                            return;
                        }
                    } else { // Match key values
                        if ($this->id->CurrentValue != null) {
                            while ($this->fetch()) {
                                if (SameString($this->id->CurrentValue, $this->CurrentRow['id'])) {
                                    $this->setStartRecordNumber($this->StartRecord); // Save record position
                                    $loaded = true;
                                    break;
                                } else {
                                    $this->StartRecord++;
                                }
                            }
                        }
                    }

                    // Load current row values
                    if ($loaded) {
                        $this->loadRowValues($this->CurrentRow);
                    }
                } else {
                    // Load current record
                    $loaded = $this->loadRow();
                } // End modal checking
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                if (!$this->IsModal) { // Normal edit page
                    if (!$loaded) {
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("baccountinfoagentlist"); // Return to list page
                        return;
                    } else {
                    }
                } else { // Modal edit page
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("baccountinfoagentlist"); // No matching record, return to list
                        return;
                    }
                } // End modal checking
                break;
            case "update": // Update
                $returnUrl = "baccountinfoagentlist";
                if (GetPageName($returnUrl) == "baccountinfoagentlist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "baccountinfoagentlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "baccountinfoagentlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();
        if (!$this->IsModal) { // Normal view page
            $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, "", $this->RecordRange, $this->AutoHidePager, false, false);
            $this->Pager->PageNumberName = Config("TABLE_PAGE_NUMBER");
            $this->Pager->PagePhraseId = "Record"; // Show as record
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->image->Upload->Index = $CurrentForm->Index;
        $this->image->Upload->uploadFile();
        $this->image->CurrentValue = $this->image->Upload->FileName;
        $this->id_proof->Upload->Index = $CurrentForm->Index;
        $this->id_proof->Upload->uploadFile();
        $this->id_proof->CurrentValue = $this->id_proof->Upload->FileName;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'b_type' first before field var 'x_b_type'
        $val = $CurrentForm->hasValue("b_type") ? $CurrentForm->getValue("b_type") : $CurrentForm->getValue("x_b_type");
        if (!$this->b_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_type->Visible = false; // Disable update for API request
            } else {
                $this->b_type->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'account_type' first before field var 'x_account_type'
        $val = $CurrentForm->hasValue("account_type") ? $CurrentForm->getValue("account_type") : $CurrentForm->getValue("x_account_type");
        if (!$this->account_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->account_type->Visible = false; // Disable update for API request
            } else {
                $this->account_type->setFormValue($val);
            }
        }

        // Check field name 'aadhaar_no' first before field var 'x_aadhaar_no'
        $val = $CurrentForm->hasValue("aadhaar_no") ? $CurrentForm->getValue("aadhaar_no") : $CurrentForm->getValue("x_aadhaar_no");
        if (!$this->aadhaar_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->aadhaar_no->Visible = false; // Disable update for API request
            } else {
                $this->aadhaar_no->setFormValue($val);
            }
        }

        // Check field name 'formal_name' first before field var 'x_formal_name'
        $val = $CurrentForm->hasValue("formal_name") ? $CurrentForm->getValue("formal_name") : $CurrentForm->getValue("x_formal_name");
        if (!$this->formal_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->formal_name->Visible = false; // Disable update for API request
            } else {
                $this->formal_name->setFormValue($val);
            }
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val);
            }
        }

        // Check field name 'pan_no' first before field var 'x_pan_no'
        $val = $CurrentForm->hasValue("pan_no") ? $CurrentForm->getValue("pan_no") : $CurrentForm->getValue("x_pan_no");
        if (!$this->pan_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pan_no->Visible = false; // Disable update for API request
            } else {
                $this->pan_no->setFormValue($val);
            }
        }

        // Check field name 'int_@' first before field var 'x_int_'
        $val = $CurrentForm->hasValue("int_@") ? $CurrentForm->getValue("int_@") : $CurrentForm->getValue("x_int_");
        if (!$this->int_->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->int_->Visible = false; // Disable update for API request
            } else {
                $this->int_->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
		$this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
		$this->image->UploadPath = $this->image->OldUploadPath;
		$this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
		$this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->b_type->CurrentValue = $this->b_type->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->account_type->CurrentValue = $this->account_type->FormValue;
        $this->aadhaar_no->CurrentValue = $this->aadhaar_no->FormValue;
        $this->formal_name->CurrentValue = $this->formal_name->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->pan_no->CurrentValue = $this->pan_no->FormValue;
        $this->int_->CurrentValue = $this->int_->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }

        // Check if valid User ID
        if ($res) {
            $res = $this->showOptionLink("edit");
            if (!$res) {
                $userIdMsg = DeniedMessage();
                $this->setFailureMessage($userIdMsg);
            }
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->b_type->setDbValue($row['b_type']);
        $this->grp->setDbValue($row['grp']);
        $this->account_type->setDbValue($row['account_type']);
        $this->aadhaar_no->setDbValue($row['aadhaar_no']);
        $this->account_no->setDbValue($row['account_no']);
        $this->formal_name->setDbValue($row['formal_name']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->status->setDbValue($row['status']);
        $this->pan_no->setDbValue($row['pan_no']);
        $this->id_proof->Upload->DbValue = $row['id_proof'];
        $this->id_proof->setDbValue($this->id_proof->Upload->DbValue);
        $this->agent->setDbValue($row['agent']);
        $this->other_details->setDbValue($row['other_details']);
        $this->loan_amount->setDbValue($row['loan_amount']);
        $this->int_->setDbValue($row['int_@']);
        $this->disbursement_amount->setDbValue($row['disbursement_amount']);
        $this->emi_amount->setDbValue($row['emi_amount']);
        $this->no_of_emi->setDbValue($row['no_of_emi']);
        $this->frequency->setDbValue($row['frequency']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->otp->setDbValue($row['otp']);
        $this->otp_delivery_datetime->setDbValue($row['otp_delivery_datetime']);
        $this->otp_verify_datetime->setDbValue($row['otp_verify_datetime']);
        $this->fund_o->setDbValue($row['fund_o']);
        $this->fund_o_no->setDbValue($row['fund_o_no']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['b_type'] = $this->b_type->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['account_type'] = $this->account_type->DefaultValue;
        $row['aadhaar_no'] = $this->aadhaar_no->DefaultValue;
        $row['account_no'] = $this->account_no->DefaultValue;
        $row['formal_name'] = $this->formal_name->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['pan_no'] = $this->pan_no->DefaultValue;
        $row['id_proof'] = $this->id_proof->DefaultValue;
        $row['agent'] = $this->agent->DefaultValue;
        $row['other_details'] = $this->other_details->DefaultValue;
        $row['loan_amount'] = $this->loan_amount->DefaultValue;
        $row['int_@'] = $this->int_->DefaultValue;
        $row['disbursement_amount'] = $this->disbursement_amount->DefaultValue;
        $row['emi_amount'] = $this->emi_amount->DefaultValue;
        $row['no_of_emi'] = $this->no_of_emi->DefaultValue;
        $row['frequency'] = $this->frequency->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['otp'] = $this->otp->DefaultValue;
        $row['otp_delivery_datetime'] = $this->otp_delivery_datetime->DefaultValue;
        $row['otp_verify_datetime'] = $this->otp_verify_datetime->DefaultValue;
        $row['fund_o'] = $this->fund_o->DefaultValue;
        $row['fund_o_no'] = $this->fund_o_no->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // b_type
        $this->b_type->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // account_type
        $this->account_type->RowCssClass = "row";

        // aadhaar_no
        $this->aadhaar_no->RowCssClass = "row";

        // account_no
        $this->account_no->RowCssClass = "row";

        // formal_name
        $this->formal_name->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // pan_no
        $this->pan_no->RowCssClass = "row";

        // id_proof
        $this->id_proof->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // other_details
        $this->other_details->RowCssClass = "row";

        // loan_amount
        $this->loan_amount->RowCssClass = "row";

        // int_@
        $this->int_->RowCssClass = "row";

        // disbursement_amount
        $this->disbursement_amount->RowCssClass = "row";

        // emi_amount
        $this->emi_amount->RowCssClass = "row";

        // no_of_emi
        $this->no_of_emi->RowCssClass = "row";

        // frequency
        $this->frequency->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // otp
        $this->otp->RowCssClass = "row";

        // otp_delivery_datetime
        $this->otp_delivery_datetime->RowCssClass = "row";

        // otp_verify_datetime
        $this->otp_verify_datetime->RowCssClass = "row";

        // fund_o
        $this->fund_o->RowCssClass = "row";

        // fund_o_no
        $this->fund_o_no->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // b_type
            if (strval($this->b_type->CurrentValue) != "") {
                $this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
            } else {
                $this->b_type->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // account_type
            $curVal = strval($this->account_type->CurrentValue);
            if ($curVal != "") {
                $this->account_type->ViewValue = $this->account_type->lookupCacheOption($curVal);
                if ($this->account_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->account_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->account_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->account_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->account_type->Lookup->renderViewRow($rswrk[0]);
                        $this->account_type->ViewValue = $this->account_type->displayValue($arwrk);
                    } else {
                        $this->account_type->ViewValue = FormatNumber($this->account_type->CurrentValue, $this->account_type->formatPattern());
                    }
                }
            } else {
                $this->account_type->ViewValue = null;
            }

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // account_no
            $this->account_no->ViewValue = $this->account_no->CurrentValue;

            // formal_name
            $this->formal_name->ViewValue = $this->formal_name->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // status
            $this->status->ViewValue = $this->status->CurrentValue;
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // pan_no
            $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

            // id_proof
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->ViewValue = "";
            }

            // agent
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->ViewValue = $this->agent->CurrentValue;
                    }
                }
            } else {
                $this->agent->ViewValue = null;
            }

            // loan_amount
            $this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
            $this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, $this->loan_amount->formatPattern());

            // int_@
            $this->int_->ViewValue = $this->int_->CurrentValue;
            $this->int_->ViewValue = FormatNumber($this->int_->ViewValue, $this->int_->formatPattern());

            // disbursement_amount
            $this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
            $this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, $this->disbursement_amount->formatPattern());

            // emi_amount
            $this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
            $this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, $this->emi_amount->formatPattern());

            // no_of_emi
            $this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
            $this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, $this->no_of_emi->formatPattern());

            // frequency
            if (strval($this->frequency->CurrentValue) != "") {
                $this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
            } else {
                $this->frequency->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // otp_delivery_datetime
            $this->otp_delivery_datetime->ViewValue = $this->otp_delivery_datetime->CurrentValue;
            $this->otp_delivery_datetime->ViewValue = FormatDateTime($this->otp_delivery_datetime->ViewValue, $this->otp_delivery_datetime->formatPattern());

            // otp_verify_datetime
            $this->otp_verify_datetime->ViewValue = $this->otp_verify_datetime->CurrentValue;
            $this->otp_verify_datetime->ViewValue = FormatDateTime($this->otp_verify_datetime->ViewValue, $this->otp_verify_datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // b_type
            $this->b_type->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // account_type
            $this->account_type->HrefValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";
            $this->aadhaar_no->TooltipValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";
            $this->formal_name->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // pan_no
            $this->pan_no->HrefValue = "";
            $this->pan_no->TooltipValue = "";

            // id_proof
            $this->id_proof->HrefValue = "";
            $this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;

            // int_@
            $this->int_->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;
            $this->id->EditValue = FormatNumber($this->id->EditValue, $this->id->formatPattern());

            // b_type
            $this->b_type->setupEditAttributes();
            $this->b_type->EditValue = $this->b_type->options(true);
            $this->b_type->PlaceHolder = RemoveHtml($this->b_type->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->EditValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->EditValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->EditValue = null;
            }

            // account_type
            $this->account_type->setupEditAttributes();
            $curVal = trim(strval($this->account_type->CurrentValue));
            if ($curVal != "") {
                $this->account_type->ViewValue = $this->account_type->lookupCacheOption($curVal);
            } else {
                $this->account_type->ViewValue = $this->account_type->Lookup !== null && is_array($this->account_type->lookupOptions()) && count($this->account_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->account_type->ViewValue !== null) { // Load from cache
                $this->account_type->EditValue = array_values($this->account_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->account_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->account_type->CurrentValue, $this->account_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->account_type->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->account_type->EditValue = $arwrk;
            }
            $this->account_type->PlaceHolder = RemoveHtml($this->account_type->caption());

            // aadhaar_no
            $this->aadhaar_no->setupEditAttributes();
            $this->aadhaar_no->EditValue = $this->aadhaar_no->CurrentValue;

            // formal_name
            $this->formal_name->setupEditAttributes();
            $this->formal_name->EditValue = $this->formal_name->CurrentValue;

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->CurrentValue;
            $this->mobile->EditValue = FormatNumber($this->mobile->EditValue, $this->mobile->formatPattern());

            // image
            $this->image->setupEditAttributes();
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->EditValue = $this->image->Upload->DbValue;
            } else {
                $this->image->EditValue = "";
            }
            if (!EmptyValue($this->image->CurrentValue)) {
                $this->image->Upload->FileName = $this->image->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->image);
            }

            // pan_no
            $this->pan_no->setupEditAttributes();
            $this->pan_no->EditValue = $this->pan_no->CurrentValue;

            // id_proof
            $this->id_proof->setupEditAttributes();
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->EditValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->EditValue = "";
            }
            if (!EmptyValue($this->id_proof->CurrentValue)) {
                $this->id_proof->Upload->FileName = $this->id_proof->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->id_proof);
            }

            // int_@
            $this->int_->setupEditAttributes();
            $this->int_->EditValue = $this->int_->CurrentValue;
            $this->int_->PlaceHolder = RemoveHtml($this->int_->caption());
            if (strval($this->int_->EditValue) != "" && is_numeric($this->int_->EditValue)) {
                $this->int_->EditValue = FormatNumber($this->int_->EditValue, null);
            }

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // b_type
            $this->b_type->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // account_type
            $this->account_type->HrefValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";
            $this->aadhaar_no->TooltipValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";
            $this->formal_name->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // pan_no
            $this->pan_no->HrefValue = "";
            $this->pan_no->TooltipValue = "";

            // id_proof
            $this->id_proof->HrefValue = "";
            $this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;

            // int_@
            $this->int_->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->b_type->Visible && $this->b_type->Required) {
                if (!$this->b_type->IsDetailKey && EmptyValue($this->b_type->FormValue)) {
                    $this->b_type->addErrorMessage(str_replace("%s", $this->b_type->caption(), $this->b_type->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->account_type->Visible && $this->account_type->Required) {
                if (!$this->account_type->IsDetailKey && EmptyValue($this->account_type->FormValue)) {
                    $this->account_type->addErrorMessage(str_replace("%s", $this->account_type->caption(), $this->account_type->RequiredErrorMessage));
                }
            }
            if ($this->aadhaar_no->Visible && $this->aadhaar_no->Required) {
                if (!$this->aadhaar_no->IsDetailKey && EmptyValue($this->aadhaar_no->FormValue)) {
                    $this->aadhaar_no->addErrorMessage(str_replace("%s", $this->aadhaar_no->caption(), $this->aadhaar_no->RequiredErrorMessage));
                }
            }
            if ($this->formal_name->Visible && $this->formal_name->Required) {
                if (!$this->formal_name->IsDetailKey && EmptyValue($this->formal_name->FormValue)) {
                    $this->formal_name->addErrorMessage(str_replace("%s", $this->formal_name->caption(), $this->formal_name->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->image->Visible && $this->image->Required) {
                if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
                    $this->image->addErrorMessage(str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
                }
            }
            if ($this->pan_no->Visible && $this->pan_no->Required) {
                if (!$this->pan_no->IsDetailKey && EmptyValue($this->pan_no->FormValue)) {
                    $this->pan_no->addErrorMessage(str_replace("%s", $this->pan_no->caption(), $this->pan_no->RequiredErrorMessage));
                }
            }
            if ($this->id_proof->Visible && $this->id_proof->Required) {
                if ($this->id_proof->Upload->FileName == "" && !$this->id_proof->Upload->KeepFile) {
                    $this->id_proof->addErrorMessage(str_replace("%s", $this->id_proof->caption(), $this->id_proof->RequiredErrorMessage));
                }
            }
            if ($this->int_->Visible && $this->int_->Required) {
                if (!$this->int_->IsDetailKey && EmptyValue($this->int_->FormValue)) {
                    $this->int_->addErrorMessage(str_replace("%s", $this->int_->caption(), $this->int_->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->int_->FormValue)) {
                $this->int_->addErrorMessage($this->int_->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->image->Visible && !$this->image->Upload->KeepFile) {
            $this->image->UploadPath = $this->image->getUploadPath();
            if (!EmptyValue($this->image->Upload->FileName)) {
                FixUploadFileNames($this->image);
                $this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, $this->image->ReadOnly);
            }
        }
        if ($this->id_proof->Visible && !$this->id_proof->Upload->KeepFile) {
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath();
            if (!EmptyValue($this->id_proof->Upload->FileName)) {
                FixUploadFileNames($this->id_proof);
                $this->id_proof->setDbValueDef($rsnew, $this->id_proof->Upload->FileName, $this->id_proof->ReadOnly);
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->image->Visible && !$this->image->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->image, $rsnew['image'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->id_proof->Visible && !$this->id_proof->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->id_proof, $rsnew['id_proof'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;
        $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
        $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
        $rsnew = [];

        // b_type
        $this->b_type->setDbValueDef($rsnew, $this->b_type->CurrentValue, $this->b_type->ReadOnly);

        // account_type
        $this->account_type->setDbValueDef($rsnew, $this->account_type->CurrentValue, $this->account_type->ReadOnly);

        // image
        if ($this->image->Visible && !$this->image->ReadOnly && !$this->image->Upload->KeepFile) {
            if ($this->image->Upload->FileName == "") {
                $rsnew['image'] = null;
            } else {
                FixUploadTempFileNames($this->image);
                $rsnew['image'] = $this->image->Upload->FileName;
            }
            $this->image->ImageWidth = 600; // Resize width
            $this->image->ImageHeight = 600; // Resize height
        }

        // id_proof
        if ($this->id_proof->Visible && !$this->id_proof->ReadOnly && !$this->id_proof->Upload->KeepFile) {
            if ($this->id_proof->Upload->FileName == "") {
                $rsnew['id_proof'] = null;
            } else {
                FixUploadTempFileNames($this->id_proof);
                $rsnew['id_proof'] = $this->id_proof->Upload->FileName;
            }
            $this->id_proof->ImageWidth = 600; // Resize width
            $this->id_proof->ImageHeight = 600; // Resize height
        }

        // int_@
        $this->int_->setDbValueDef($rsnew, $this->int_->CurrentValue, $this->int_->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['b_type'])) { // b_type
            $this->b_type->CurrentValue = $row['b_type'];
        }
        if (isset($row['account_type'])) { // account_type
            $this->account_type->CurrentValue = $row['account_type'];
        }
        if (isset($row['image'])) { // image
            $this->image->CurrentValue = $row['image'];
        }
        if (isset($row['id_proof'])) { // id_proof
            $this->id_proof->CurrentValue = $row['id_proof'];
        }
        if (isset($row['int_@'])) { // int_@
            $this->int_->CurrentValue = $row['int_@'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->agent->CurrentValue);
        }
        return true;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("baccountinfoagentlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_b_type":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_account_type":
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_frequency":
                    break;
                case "x_fund_o_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'b_account_info_agent');		
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
