<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BAccountInfoAgentAdd extends BAccountInfoAgent
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BAccountInfoAgentAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "baccountinfoagentadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->b_type->setVisibility();
        $this->grp->setVisibility();
        $this->account_type->setVisibility();
        $this->aadhaar_no->setVisibility();
        $this->account_no->Visible = false;
        $this->formal_name->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->image->Visible = false;
        $this->status->setVisibility();
        $this->pan_no->setVisibility();
        $this->id_proof->Visible = false;
        $this->agent->Visible = false;
        $this->other_details->setVisibility();
        $this->loan_amount->setVisibility();
        $this->int_->setVisibility();
        $this->disbursement_amount->setVisibility();
        $this->emi_amount->setVisibility();
        $this->no_of_emi->setVisibility();
        $this->frequency->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->otp->Visible = false;
        $this->otp_delivery_datetime->Visible = false;
        $this->otp_verify_datetime->Visible = false;
        $this->fund_o->Visible = false;
        $this->fund_o_no->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'b_account_info_agent';
        $this->TableName = 'b_account_info_agent';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (b_account_info_agent)
        if (!isset($GLOBALS["b_account_info_agent"]) || $GLOBALS["b_account_info_agent"]::class == PROJECT_NAMESPACE . "b_account_info_agent") {
            $GLOBALS["b_account_info_agent"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_info_agent');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "baccountinfoagentview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
                $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->b_type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->account_type);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->agent);
        $this->setupLookupOptions($this->frequency);
        $this->setupLookupOptions($this->fund_o_no);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("baccountinfoagentlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = autoprogramme?apcid=ad92301430dc5fe354e6d0b1946e537f;

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "baccountinfoagentlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "baccountinfoagentlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->b_type->DefaultValue = $this->b_type->getDefault(); // PHP
        $this->b_type->OldValue = $this->b_type->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->no_of_emi->DefaultValue = $this->no_of_emi->getDefault(); // PHP
        $this->no_of_emi->OldValue = $this->no_of_emi->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->fund_o->DefaultValue = $this->fund_o->getDefault(); // PHP
        $this->fund_o->OldValue = $this->fund_o->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");

        // Check field name 'b_type' first before field var 'x_b_type'
        $val = $CurrentForm->hasValue("b_type") ? $CurrentForm->getValue("b_type") : $CurrentForm->getValue("x_b_type");
        if (!$this->b_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_type->Visible = false; // Disable update for API request
            } else {
                $this->b_type->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'account_type' first before field var 'x_account_type'
        $val = $CurrentForm->hasValue("account_type") ? $CurrentForm->getValue("account_type") : $CurrentForm->getValue("x_account_type");
        if (!$this->account_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->account_type->Visible = false; // Disable update for API request
            } else {
                $this->account_type->setFormValue($val);
            }
        }

        // Check field name 'aadhaar_no' first before field var 'x_aadhaar_no'
        $val = $CurrentForm->hasValue("aadhaar_no") ? $CurrentForm->getValue("aadhaar_no") : $CurrentForm->getValue("x_aadhaar_no");
        if (!$this->aadhaar_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->aadhaar_no->Visible = false; // Disable update for API request
            } else {
                $this->aadhaar_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'formal_name' first before field var 'x_formal_name'
        $val = $CurrentForm->hasValue("formal_name") ? $CurrentForm->getValue("formal_name") : $CurrentForm->getValue("x_formal_name");
        if (!$this->formal_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->formal_name->Visible = false; // Disable update for API request
            } else {
                $this->formal_name->setFormValue($val);
            }
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'email' first before field var 'x__email'
        $val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
        if (!$this->_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_email->Visible = false; // Disable update for API request
            } else {
                $this->_email->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pan_no' first before field var 'x_pan_no'
        $val = $CurrentForm->hasValue("pan_no") ? $CurrentForm->getValue("pan_no") : $CurrentForm->getValue("x_pan_no");
        if (!$this->pan_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pan_no->Visible = false; // Disable update for API request
            } else {
                $this->pan_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'other_details' first before field var 'x_other_details'
        $val = $CurrentForm->hasValue("other_details") ? $CurrentForm->getValue("other_details") : $CurrentForm->getValue("x_other_details");
        if (!$this->other_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other_details->Visible = false; // Disable update for API request
            } else {
                $this->other_details->setFormValue($val);
            }
        }

        // Check field name 'loan_amount' first before field var 'x_loan_amount'
        $val = $CurrentForm->hasValue("loan_amount") ? $CurrentForm->getValue("loan_amount") : $CurrentForm->getValue("x_loan_amount");
        if (!$this->loan_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->loan_amount->Visible = false; // Disable update for API request
            } else {
                $this->loan_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'int_@' first before field var 'x_int_'
        $val = $CurrentForm->hasValue("int_@") ? $CurrentForm->getValue("int_@") : $CurrentForm->getValue("x_int_");
        if (!$this->int_->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->int_->Visible = false; // Disable update for API request
            } else {
                $this->int_->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'disbursement_amount' first before field var 'x_disbursement_amount'
        $val = $CurrentForm->hasValue("disbursement_amount") ? $CurrentForm->getValue("disbursement_amount") : $CurrentForm->getValue("x_disbursement_amount");
        if (!$this->disbursement_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->disbursement_amount->Visible = false; // Disable update for API request
            } else {
                $this->disbursement_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'emi_amount' first before field var 'x_emi_amount'
        $val = $CurrentForm->hasValue("emi_amount") ? $CurrentForm->getValue("emi_amount") : $CurrentForm->getValue("x_emi_amount");
        if (!$this->emi_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->emi_amount->Visible = false; // Disable update for API request
            } else {
                $this->emi_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'no_of_emi' first before field var 'x_no_of_emi'
        $val = $CurrentForm->hasValue("no_of_emi") ? $CurrentForm->getValue("no_of_emi") : $CurrentForm->getValue("x_no_of_emi");
        if (!$this->no_of_emi->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->no_of_emi->Visible = false; // Disable update for API request
            } else {
                $this->no_of_emi->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'frequency' first before field var 'x_frequency'
        $val = $CurrentForm->hasValue("frequency") ? $CurrentForm->getValue("frequency") : $CurrentForm->getValue("x_frequency");
        if (!$this->frequency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->frequency->Visible = false; // Disable update for API request
            } else {
                $this->frequency->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->b_type->CurrentValue = $this->b_type->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->account_type->CurrentValue = $this->account_type->FormValue;
        $this->aadhaar_no->CurrentValue = $this->aadhaar_no->FormValue;
        $this->formal_name->CurrentValue = $this->formal_name->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->_email->CurrentValue = $this->_email->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->pan_no->CurrentValue = $this->pan_no->FormValue;
        $this->other_details->CurrentValue = $this->other_details->FormValue;
        $this->loan_amount->CurrentValue = $this->loan_amount->FormValue;
        $this->int_->CurrentValue = $this->int_->FormValue;
        $this->disbursement_amount->CurrentValue = $this->disbursement_amount->FormValue;
        $this->emi_amount->CurrentValue = $this->emi_amount->FormValue;
        $this->no_of_emi->CurrentValue = $this->no_of_emi->FormValue;
        $this->frequency->CurrentValue = $this->frequency->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }

        // Check if valid User ID
        if ($res) {
            $res = $this->showOptionLink("add");
            if (!$res) {
                $userIdMsg = DeniedMessage();
                $this->setFailureMessage($userIdMsg);
            }
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->b_type->setDbValue($row['b_type']);
        $this->grp->setDbValue($row['grp']);
        $this->account_type->setDbValue($row['account_type']);
        $this->aadhaar_no->setDbValue($row['aadhaar_no']);
        $this->account_no->setDbValue($row['account_no']);
        $this->formal_name->setDbValue($row['formal_name']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->status->setDbValue($row['status']);
        $this->pan_no->setDbValue($row['pan_no']);
        $this->id_proof->Upload->DbValue = $row['id_proof'];
        $this->id_proof->setDbValue($this->id_proof->Upload->DbValue);
        $this->agent->setDbValue($row['agent']);
        $this->other_details->setDbValue($row['other_details']);
        $this->loan_amount->setDbValue($row['loan_amount']);
        $this->int_->setDbValue($row['int_@']);
        $this->disbursement_amount->setDbValue($row['disbursement_amount']);
        $this->emi_amount->setDbValue($row['emi_amount']);
        $this->no_of_emi->setDbValue($row['no_of_emi']);
        $this->frequency->setDbValue($row['frequency']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->otp->setDbValue($row['otp']);
        $this->otp_delivery_datetime->setDbValue($row['otp_delivery_datetime']);
        $this->otp_verify_datetime->setDbValue($row['otp_verify_datetime']);
        $this->fund_o->setDbValue($row['fund_o']);
        $this->fund_o_no->setDbValue($row['fund_o_no']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['b_type'] = $this->b_type->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['account_type'] = $this->account_type->DefaultValue;
        $row['aadhaar_no'] = $this->aadhaar_no->DefaultValue;
        $row['account_no'] = $this->account_no->DefaultValue;
        $row['formal_name'] = $this->formal_name->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['pan_no'] = $this->pan_no->DefaultValue;
        $row['id_proof'] = $this->id_proof->DefaultValue;
        $row['agent'] = $this->agent->DefaultValue;
        $row['other_details'] = $this->other_details->DefaultValue;
        $row['loan_amount'] = $this->loan_amount->DefaultValue;
        $row['int_@'] = $this->int_->DefaultValue;
        $row['disbursement_amount'] = $this->disbursement_amount->DefaultValue;
        $row['emi_amount'] = $this->emi_amount->DefaultValue;
        $row['no_of_emi'] = $this->no_of_emi->DefaultValue;
        $row['frequency'] = $this->frequency->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['otp'] = $this->otp->DefaultValue;
        $row['otp_delivery_datetime'] = $this->otp_delivery_datetime->DefaultValue;
        $row['otp_verify_datetime'] = $this->otp_verify_datetime->DefaultValue;
        $row['fund_o'] = $this->fund_o->DefaultValue;
        $row['fund_o_no'] = $this->fund_o_no->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // b_type
        $this->b_type->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // account_type
        $this->account_type->RowCssClass = "row";

        // aadhaar_no
        $this->aadhaar_no->RowCssClass = "row";

        // account_no
        $this->account_no->RowCssClass = "row";

        // formal_name
        $this->formal_name->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // pan_no
        $this->pan_no->RowCssClass = "row";

        // id_proof
        $this->id_proof->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // other_details
        $this->other_details->RowCssClass = "row";

        // loan_amount
        $this->loan_amount->RowCssClass = "row";

        // int_@
        $this->int_->RowCssClass = "row";

        // disbursement_amount
        $this->disbursement_amount->RowCssClass = "row";

        // emi_amount
        $this->emi_amount->RowCssClass = "row";

        // no_of_emi
        $this->no_of_emi->RowCssClass = "row";

        // frequency
        $this->frequency->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // otp
        $this->otp->RowCssClass = "row";

        // otp_delivery_datetime
        $this->otp_delivery_datetime->RowCssClass = "row";

        // otp_verify_datetime
        $this->otp_verify_datetime->RowCssClass = "row";

        // fund_o
        $this->fund_o->RowCssClass = "row";

        // fund_o_no
        $this->fund_o_no->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // b_type
            if (strval($this->b_type->CurrentValue) != "") {
                $this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
            } else {
                $this->b_type->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // account_type
            $curVal = strval($this->account_type->CurrentValue);
            if ($curVal != "") {
                $this->account_type->ViewValue = $this->account_type->lookupCacheOption($curVal);
                if ($this->account_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->account_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->account_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->account_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->account_type->Lookup->renderViewRow($rswrk[0]);
                        $this->account_type->ViewValue = $this->account_type->displayValue($arwrk);
                    } else {
                        $this->account_type->ViewValue = FormatNumber($this->account_type->CurrentValue, $this->account_type->formatPattern());
                    }
                }
            } else {
                $this->account_type->ViewValue = null;
            }

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // account_no
            $this->account_no->ViewValue = $this->account_no->CurrentValue;

            // formal_name
            $this->formal_name->ViewValue = $this->formal_name->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // status
            $this->status->ViewValue = $this->status->CurrentValue;
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // pan_no
            $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

            // id_proof
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->ViewValue = "";
            }

            // agent
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->ViewValue = $this->agent->CurrentValue;
                    }
                }
            } else {
                $this->agent->ViewValue = null;
            }

            // other_details
            $this->other_details->ViewValue = $this->other_details->CurrentValue;

            // loan_amount
            $this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
            $this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, $this->loan_amount->formatPattern());

            // int_@
            $this->int_->ViewValue = $this->int_->CurrentValue;
            $this->int_->ViewValue = FormatNumber($this->int_->ViewValue, $this->int_->formatPattern());

            // disbursement_amount
            $this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
            $this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, $this->disbursement_amount->formatPattern());

            // emi_amount
            $this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
            $this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, $this->emi_amount->formatPattern());

            // no_of_emi
            $this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
            $this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, $this->no_of_emi->formatPattern());

            // frequency
            if (strval($this->frequency->CurrentValue) != "") {
                $this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
            } else {
                $this->frequency->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // otp_delivery_datetime
            $this->otp_delivery_datetime->ViewValue = $this->otp_delivery_datetime->CurrentValue;
            $this->otp_delivery_datetime->ViewValue = FormatDateTime($this->otp_delivery_datetime->ViewValue, $this->otp_delivery_datetime->formatPattern());

            // otp_verify_datetime
            $this->otp_verify_datetime->ViewValue = $this->otp_verify_datetime->CurrentValue;
            $this->otp_verify_datetime->ViewValue = FormatDateTime($this->otp_verify_datetime->ViewValue, $this->otp_verify_datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // b_type
            $this->b_type->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // account_type
            $this->account_type->HrefValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";
            $this->aadhaar_no->TooltipValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";
            $this->formal_name->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // email
            $this->_email->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";
            $this->pan_no->TooltipValue = "";

            // other_details
            $this->other_details->HrefValue = "";

            // loan_amount
            $this->loan_amount->HrefValue = "";

            // int_@
            $this->int_->HrefValue = "";

            // disbursement_amount
            $this->disbursement_amount->HrefValue = "";

            // emi_amount
            $this->emi_amount->HrefValue = "";

            // no_of_emi
            $this->no_of_emi->HrefValue = "";

            // frequency
            $this->frequency->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // id

            // b_type
            $this->b_type->setupEditAttributes();
            $this->b_type->EditValue = $this->b_type->options(true);
            $this->b_type->PlaceHolder = RemoveHtml($this->b_type->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // account_type
            $this->account_type->setupEditAttributes();
            $curVal = trim(strval($this->account_type->CurrentValue));
            if ($curVal != "") {
                $this->account_type->ViewValue = $this->account_type->lookupCacheOption($curVal);
            } else {
                $this->account_type->ViewValue = $this->account_type->Lookup !== null && is_array($this->account_type->lookupOptions()) && count($this->account_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->account_type->ViewValue !== null) { // Load from cache
                $this->account_type->EditValue = array_values($this->account_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->account_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->account_type->CurrentValue, $this->account_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->account_type->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->account_type->EditValue = $arwrk;
            }
            $this->account_type->PlaceHolder = RemoveHtml($this->account_type->caption());

            // aadhaar_no
            $this->aadhaar_no->setupEditAttributes();
            if (!$this->aadhaar_no->Raw) {
                $this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
            }
            $this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->CurrentValue);
            $this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

            // formal_name
            $this->formal_name->setupEditAttributes();
            if (!$this->formal_name->Raw) {
                $this->formal_name->CurrentValue = HtmlDecode($this->formal_name->CurrentValue);
            }
            $this->formal_name->EditValue = HtmlEncode($this->formal_name->CurrentValue);
            $this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->CurrentValue;
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());
            if (strval($this->mobile->EditValue) != "" && is_numeric($this->mobile->EditValue)) {
                $this->mobile->EditValue = FormatNumber($this->mobile->EditValue, null);
            }

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditCustomAttributes = $this->status->getEditCustomAttributes(); // PHP
            $this->status->EditValue = $this->status->CurrentValue;
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->EditValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->EditValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->EditValue = HtmlEncode(FormatNumber($this->status->CurrentValue, $this->status->formatPattern()));
                    }
                }
            } else {
                $this->status->EditValue = null;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // pan_no
            $this->pan_no->setupEditAttributes();
            if (!$this->pan_no->Raw) {
                $this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
            }
            $this->pan_no->EditValue = HtmlEncode($this->pan_no->CurrentValue);
            $this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

            // other_details
            $this->other_details->setupEditAttributes();
            $this->other_details->EditValue = HtmlEncode($this->other_details->CurrentValue);
            $this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

            // loan_amount
            $this->loan_amount->setupEditAttributes();
            $this->loan_amount->EditValue = $this->loan_amount->CurrentValue;
            $this->loan_amount->PlaceHolder = RemoveHtml($this->loan_amount->caption());
            if (strval($this->loan_amount->EditValue) != "" && is_numeric($this->loan_amount->EditValue)) {
                $this->loan_amount->EditValue = FormatNumber($this->loan_amount->EditValue, null);
            }

            // int_@
            $this->int_->setupEditAttributes();
            $this->int_->EditValue = $this->int_->CurrentValue;
            $this->int_->PlaceHolder = RemoveHtml($this->int_->caption());
            if (strval($this->int_->EditValue) != "" && is_numeric($this->int_->EditValue)) {
                $this->int_->EditValue = FormatNumber($this->int_->EditValue, null);
            }

            // disbursement_amount
            $this->disbursement_amount->setupEditAttributes();
            $this->disbursement_amount->EditValue = $this->disbursement_amount->CurrentValue;
            $this->disbursement_amount->PlaceHolder = RemoveHtml($this->disbursement_amount->caption());
            if (strval($this->disbursement_amount->EditValue) != "" && is_numeric($this->disbursement_amount->EditValue)) {
                $this->disbursement_amount->EditValue = FormatNumber($this->disbursement_amount->EditValue, null);
            }

            // emi_amount
            $this->emi_amount->setupEditAttributes();
            $this->emi_amount->EditValue = $this->emi_amount->CurrentValue;
            $this->emi_amount->PlaceHolder = RemoveHtml($this->emi_amount->caption());
            if (strval($this->emi_amount->EditValue) != "" && is_numeric($this->emi_amount->EditValue)) {
                $this->emi_amount->EditValue = FormatNumber($this->emi_amount->EditValue, null);
            }

            // no_of_emi
            $this->no_of_emi->setupEditAttributes();
            $this->no_of_emi->EditValue = $this->no_of_emi->CurrentValue;
            $this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());
            if (strval($this->no_of_emi->EditValue) != "" && is_numeric($this->no_of_emi->EditValue)) {
                $this->no_of_emi->EditValue = FormatNumber($this->no_of_emi->EditValue, null);
            }

            // frequency
            $this->frequency->setupEditAttributes();
            $this->frequency->EditValue = $this->frequency->options(true);
            $this->frequency->PlaceHolder = RemoveHtml($this->frequency->caption());

            // operator

            // datetime

            // Add refer script

            // id
            $this->id->HrefValue = "";

            // b_type
            $this->b_type->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // account_type
            $this->account_type->HrefValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";

            // other_details
            $this->other_details->HrefValue = "";

            // loan_amount
            $this->loan_amount->HrefValue = "";

            // int_@
            $this->int_->HrefValue = "";

            // disbursement_amount
            $this->disbursement_amount->HrefValue = "";

            // emi_amount
            $this->emi_amount->HrefValue = "";

            // no_of_emi
            $this->no_of_emi->HrefValue = "";

            // frequency
            $this->frequency->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->b_type->Visible && $this->b_type->Required) {
                if (!$this->b_type->IsDetailKey && EmptyValue($this->b_type->FormValue)) {
                    $this->b_type->addErrorMessage(str_replace("%s", $this->b_type->caption(), $this->b_type->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->account_type->Visible && $this->account_type->Required) {
                if (!$this->account_type->IsDetailKey && EmptyValue($this->account_type->FormValue)) {
                    $this->account_type->addErrorMessage(str_replace("%s", $this->account_type->caption(), $this->account_type->RequiredErrorMessage));
                }
            }
            if ($this->aadhaar_no->Visible && $this->aadhaar_no->Required) {
                if (!$this->aadhaar_no->IsDetailKey && EmptyValue($this->aadhaar_no->FormValue)) {
                    $this->aadhaar_no->addErrorMessage(str_replace("%s", $this->aadhaar_no->caption(), $this->aadhaar_no->RequiredErrorMessage));
                }
            }
            if ($this->formal_name->Visible && $this->formal_name->Required) {
                if (!$this->formal_name->IsDetailKey && EmptyValue($this->formal_name->FormValue)) {
                    $this->formal_name->addErrorMessage(str_replace("%s", $this->formal_name->caption(), $this->formal_name->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->mobile->FormValue)) {
                $this->mobile->addErrorMessage($this->mobile->getErrorMessage(false));
            }
            if ($this->_email->Visible && $this->_email->Required) {
                if (!$this->_email->IsDetailKey && EmptyValue($this->_email->FormValue)) {
                    $this->_email->addErrorMessage(str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
                }
            }
            if (!CheckEmail($this->_email->FormValue)) {
                $this->_email->addErrorMessage($this->_email->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->status->FormValue)) {
                $this->status->addErrorMessage($this->status->getErrorMessage(false));
            }
            if ($this->pan_no->Visible && $this->pan_no->Required) {
                if (!$this->pan_no->IsDetailKey && EmptyValue($this->pan_no->FormValue)) {
                    $this->pan_no->addErrorMessage(str_replace("%s", $this->pan_no->caption(), $this->pan_no->RequiredErrorMessage));
                }
            }
            if ($this->other_details->Visible && $this->other_details->Required) {
                if (!$this->other_details->IsDetailKey && EmptyValue($this->other_details->FormValue)) {
                    $this->other_details->addErrorMessage(str_replace("%s", $this->other_details->caption(), $this->other_details->RequiredErrorMessage));
                }
            }
            if ($this->loan_amount->Visible && $this->loan_amount->Required) {
                if (!$this->loan_amount->IsDetailKey && EmptyValue($this->loan_amount->FormValue)) {
                    $this->loan_amount->addErrorMessage(str_replace("%s", $this->loan_amount->caption(), $this->loan_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->loan_amount->FormValue)) {
                $this->loan_amount->addErrorMessage($this->loan_amount->getErrorMessage(false));
            }
            if ($this->int_->Visible && $this->int_->Required) {
                if (!$this->int_->IsDetailKey && EmptyValue($this->int_->FormValue)) {
                    $this->int_->addErrorMessage(str_replace("%s", $this->int_->caption(), $this->int_->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->int_->FormValue)) {
                $this->int_->addErrorMessage($this->int_->getErrorMessage(false));
            }
            if ($this->disbursement_amount->Visible && $this->disbursement_amount->Required) {
                if (!$this->disbursement_amount->IsDetailKey && EmptyValue($this->disbursement_amount->FormValue)) {
                    $this->disbursement_amount->addErrorMessage(str_replace("%s", $this->disbursement_amount->caption(), $this->disbursement_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->disbursement_amount->FormValue)) {
                $this->disbursement_amount->addErrorMessage($this->disbursement_amount->getErrorMessage(false));
            }
            if ($this->emi_amount->Visible && $this->emi_amount->Required) {
                if (!$this->emi_amount->IsDetailKey && EmptyValue($this->emi_amount->FormValue)) {
                    $this->emi_amount->addErrorMessage(str_replace("%s", $this->emi_amount->caption(), $this->emi_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->emi_amount->FormValue)) {
                $this->emi_amount->addErrorMessage($this->emi_amount->getErrorMessage(false));
            }
            if ($this->no_of_emi->Visible && $this->no_of_emi->Required) {
                if (!$this->no_of_emi->IsDetailKey && EmptyValue($this->no_of_emi->FormValue)) {
                    $this->no_of_emi->addErrorMessage(str_replace("%s", $this->no_of_emi->caption(), $this->no_of_emi->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->no_of_emi->FormValue)) {
                $this->no_of_emi->addErrorMessage($this->no_of_emi->getErrorMessage(false));
            }
            if ($this->frequency->Visible && $this->frequency->Required) {
                if (!$this->frequency->IsDetailKey && EmptyValue($this->frequency->FormValue)) {
                    $this->frequency->addErrorMessage(str_replace("%s", $this->frequency->caption(), $this->frequency->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check if valid User ID
        if (
            !EmptyValue($Security->currentUserID()) &&
            !$Security->isAdmin() && // Non system admin
            !$Security->isValidUserID($this->agent->CurrentValue)
        ) {
            $userIdMsg = str_replace("%c", CurrentUserID(), $Language->phrase("UnAuthorizedUserID"));
            $userIdMsg = str_replace("%u", strval($this->agent->CurrentValue), $userIdMsg);
            $this->setFailureMessage($userIdMsg);
            return false;
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;
        $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
        $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // b_type
        $this->b_type->setDbValueDef($rsnew, $this->b_type->CurrentValue, strval($this->b_type->CurrentValue) == "");

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // account_type
        $this->account_type->setDbValueDef($rsnew, $this->account_type->CurrentValue, false);

        // aadhaar_no
        $this->aadhaar_no->setDbValueDef($rsnew, $this->aadhaar_no->CurrentValue, false);

        // formal_name
        $this->formal_name->setDbValueDef($rsnew, $this->formal_name->CurrentValue, false);

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, false);

        // email
        $this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // pan_no
        $this->pan_no->setDbValueDef($rsnew, $this->pan_no->CurrentValue, false);

        // other_details
        $this->other_details->setDbValueDef($rsnew, $this->other_details->CurrentValue, false);

        // loan_amount
        $this->loan_amount->setDbValueDef($rsnew, $this->loan_amount->CurrentValue, strval($this->loan_amount->CurrentValue) == "");

        // int_@
        $this->int_->setDbValueDef($rsnew, $this->int_->CurrentValue, false);

        // disbursement_amount
        $this->disbursement_amount->setDbValueDef($rsnew, $this->disbursement_amount->CurrentValue, strval($this->disbursement_amount->CurrentValue) == "");

        // emi_amount
        $this->emi_amount->setDbValueDef($rsnew, $this->emi_amount->CurrentValue, strval($this->emi_amount->CurrentValue) == "");

        // no_of_emi
        $this->no_of_emi->setDbValueDef($rsnew, $this->no_of_emi->CurrentValue, strval($this->no_of_emi->CurrentValue) == "");

        // frequency
        $this->frequency->setDbValueDef($rsnew, $this->frequency->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // agent
        if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin
            $rsnew['agent'] = CurrentUserID();
        }
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['b_type'])) { // b_type
            $this->b_type->setFormValue($row['b_type']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['account_type'])) { // account_type
            $this->account_type->setFormValue($row['account_type']);
        }
        if (isset($row['aadhaar_no'])) { // aadhaar_no
            $this->aadhaar_no->setFormValue($row['aadhaar_no']);
        }
        if (isset($row['formal_name'])) { // formal_name
            $this->formal_name->setFormValue($row['formal_name']);
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->setFormValue($row['mobile']);
        }
        if (isset($row['email'])) { // email
            $this->_email->setFormValue($row['email']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['pan_no'])) { // pan_no
            $this->pan_no->setFormValue($row['pan_no']);
        }
        if (isset($row['other_details'])) { // other_details
            $this->other_details->setFormValue($row['other_details']);
        }
        if (isset($row['loan_amount'])) { // loan_amount
            $this->loan_amount->setFormValue($row['loan_amount']);
        }
        if (isset($row['int_@'])) { // int_@
            $this->int_->setFormValue($row['int_@']);
        }
        if (isset($row['disbursement_amount'])) { // disbursement_amount
            $this->disbursement_amount->setFormValue($row['disbursement_amount']);
        }
        if (isset($row['emi_amount'])) { // emi_amount
            $this->emi_amount->setFormValue($row['emi_amount']);
        }
        if (isset($row['no_of_emi'])) { // no_of_emi
            $this->no_of_emi->setFormValue($row['no_of_emi']);
        }
        if (isset($row['frequency'])) { // frequency
            $this->frequency->setFormValue($row['frequency']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['agent'])) { // agent
            $this->agent->setFormValue($row['agent']);
        }
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->agent->CurrentValue);
        }
        return true;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("baccountinfoagentlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_b_type":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_account_type":
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_frequency":
                    break;
                case "x_fund_o_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'b_account_info_agent');	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
