<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for b_account_info
 */
class BAccountInfo extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = true;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $b_type;
    public $grp;
    public $branch;
    public $category;
    public $account_type;
    public $type;
    public $formal_name;
    public $mobile;
    public $_email;
    public $image;
    public $sign_image;
    public $status;
    public $aadhaar_no;
    public $pan_no;
    public $id_proof;
    public $agent;
    public $other_details;
    public $bank_name;
    public $bank_ifsc_code;
    public $bank_account_no;
    public $account_no;
    public $loan_amount;
    public $emi_amount;
    public $frequency;
    public $disbursement_amount;
    public $operator;
    public $datetime;
    public $d_operator;
    public $d_datetime;
    public $otp;
    public $otp_delivery_datetime;
    public $otp_verify_datetime;
    public $no_of_emi;
    public $fund_o;
    public $fund_o_no;
    public $int_;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "b_account_info";
        $this->TableName = 'b_account_info';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "b_account_info";
        $this->Dbid = 'DB';
        $this->ExportAll = false;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->addMethod("getDefault", fn() => 0);
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // b_type
        $this->b_type = new DbField(
            $this, // Table
            'x_b_type', // Variable name
            'b_type', // Name
            '`b_type`', // Expression
            '`b_type`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->b_type->addMethod("getDefault", fn() => 0);
        $this->b_type->InputTextType = "text";
        $this->b_type->Raw = true;
        $this->b_type->Nullable = false; // NOT NULL field
        $this->b_type->setSelectMultiple(false); // Select one
        $this->b_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->b_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->b_type->Lookup = new Lookup($this->b_type, 'b_account_info', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->b_type->OptionCount = 2;
        $this->b_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->b_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['b_type'] = &$this->b_type;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`id`>9");
        $this->grp->addMethod("getDefault", fn() => 10104);
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->Sortable = false; // Allow sort
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'account_grp', false, 'id', ["ref","","",""], '', '', [], [], [], [], [], [], false, '`ref` ASC', '', "`ref`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // branch
        $this->branch = new DbField(
            $this, // Table
            'x_branch', // Variable name
            'branch', // Name
            '`branch`', // Expression
            '`branch`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`branch`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->branch->addMethod("getSelectFilter", fn() => "`id` > 10");
        $this->branch->addMethod("getDefault", fn() => 101);
        $this->branch->InputTextType = "text";
        $this->branch->Raw = true;
        $this->branch->Required = true; // Required field
        $this->branch->setSelectMultiple(false); // Select one
        $this->branch->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->branch->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->branch->Lookup = new Lookup($this->branch, 'godown', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->branch->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->branch->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['branch'] = &$this->branch;

        // category
        $this->category = new DbField(
            $this, // Table
            'x_category', // Variable name
            'category', // Name
            '`category`', // Expression
            '`category`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->category->addMethod("getDefault", fn() => 1);
        $this->category->InputTextType = "text";
        $this->category->Raw = true;
        $this->category->Nullable = false; // NOT NULL field
        $this->category->Required = true; // Required field
        $this->category->setSelectMultiple(false); // Select one
        $this->category->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->category->Lookup = new Lookup($this->category, 'b_account_info', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->category->OptionCount = 5;
        $this->category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->category->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['category'] = &$this->category;

        // account_type
        $this->account_type = new DbField(
            $this, // Table
            'x_account_type', // Variable name
            'account_type', // Name
            '`account_type`', // Expression
            '`account_type`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`account_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->account_type->InputTextType = "text";
        $this->account_type->Raw = true;
        $this->account_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->account_type->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['account_type'] = &$this->account_type;

        // type
        $this->type = new DbField(
            $this, // Table
            'x_type', // Variable name
            'type', // Name
            '`type`', // Expression
            '`type`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->type->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->type->addMethod("getDefault", fn() => 0);
        $this->type->InputTextType = "text";
        $this->type->Raw = true;
        $this->type->setSelectMultiple(false); // Select one
        $this->type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->type->Lookup = new Lookup($this->type, 'b_account_type', false, 'id', ["description","code","",""], '', '', [], [], [], [], [], [], false, '`description` ASC', '', "CONCAT(COALESCE(`description`, ''),'" . ValueSeparator(1, $this->type) . "',COALESCE(`code`,''))");
        $this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['type'] = &$this->type;

        // formal_name
        $this->formal_name = new DbField(
            $this, // Table
            'x_formal_name', // Variable name
            'formal_name', // Name
            '`formal_name`', // Expression
            '`formal_name`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`formal_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->formal_name->InputTextType = "text";
        $this->formal_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['formal_name'] = &$this->formal_name;

        // mobile
        $this->mobile = new DbField(
            $this, // Table
            'x_mobile', // Variable name
            'mobile', // Name
            '`mobile`', // Expression
            '`mobile`', // Basic search expression
            21, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`mobile`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->mobile->InputTextType = "text";
        $this->mobile->Raw = true;
        $this->mobile->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->mobile->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['mobile'] = &$this->mobile;

        // email
        $this->_email = new DbField(
            $this, // Table
            'x__email', // Variable name
            'email', // Name
            '`email`', // Expression
            '`email`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_email->InputTextType = "text";
        $this->_email->DefaultErrorMessage = $Language->phrase("IncorrectEmail");
        $this->_email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['email'] = &$this->_email;

        // image
        $this->image = new DbField(
            $this, // Table
            'x_image', // Variable name
            'image', // Name
            '`image`', // Expression
            '`image`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`image`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'FILE' // Edit Tag
        );
        $this->image->addMethod("getUploadPath", fn() => '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/');
        $this->image->InputTextType = "text";
        $this->image->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['image'] = &$this->image;

        // sign_image
        $this->sign_image = new DbField(
            $this, // Table
            'x_sign_image', // Variable name
            'sign_image', // Name
            '`sign_image`', // Expression
            '`sign_image`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`sign_image`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'FILE' // Edit Tag
        );
        $this->sign_image->addMethod("getUploadPath", fn() => '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/');
        $this->sign_image->InputTextType = "text";
        $this->sign_image->UploadMultiple = true;
        $this->sign_image->Upload->UploadMultiple = true;
        $this->sign_image->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sign_image'] = &$this->sign_image;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->status->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->status->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->status->addMethod("getDefault", fn() => 101);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Required = true; // Required field
        $this->status->Lookup = new Lookup($this->status, 'b_status_view2', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // aadhaar_no
        $this->aadhaar_no = new DbField(
            $this, // Table
            'x_aadhaar_no', // Variable name
            'aadhaar_no', // Name
            '`aadhaar_no`', // Expression
            '`aadhaar_no`', // Basic search expression
            200, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`aadhaar_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->aadhaar_no->InputTextType = "text";
        $this->aadhaar_no->Required = true; // Required field
        $this->aadhaar_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->aadhaar_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['aadhaar_no'] = &$this->aadhaar_no;

        // pan_no
        $this->pan_no = new DbField(
            $this, // Table
            'x_pan_no', // Variable name
            'pan_no', // Name
            '`pan_no`', // Expression
            '`pan_no`', // Basic search expression
            200, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pan_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pan_no->InputTextType = "text";
        $this->pan_no->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->pan_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pan_no'] = &$this->pan_no;

        // id_proof
        $this->id_proof = new DbField(
            $this, // Table
            'x_id_proof', // Variable name
            'id_proof', // Name
            '`id_proof`', // Expression
            '`id_proof`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`id_proof`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'FILE' // Edit Tag
        );
        $this->id_proof->addMethod("getLinkCustomAttributes", fn() => 'download');
        $this->id_proof->addMethod("getUploadPath", fn() => '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/');
        $this->id_proof->InputTextType = "text";
        $this->id_proof->UploadMultiple = true;
        $this->id_proof->Upload->UploadMultiple = true;
        $this->id_proof->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['id_proof'] = &$this->id_proof;

        // agent
        $this->agent = new DbField(
            $this, // Table
            'x_agent', // Variable name
            'agent', // Name
            '`agent`', // Expression
            '`agent`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`agent`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->agent->addMethod("getSelectFilter", fn() => "`userlevel` = 1001");
        $this->agent->InputTextType = "text";
        $this->agent->setSelectMultiple(false); // Select one
        $this->agent->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->agent->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->agent->Lookup = new Lookup($this->agent, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->agent->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['agent'] = &$this->agent;

        // other_details
        $this->other_details = new DbField(
            $this, // Table
            'x_other_details', // Variable name
            'other_details', // Name
            '`other_details`', // Expression
            '`other_details`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`other_details`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->other_details->InputTextType = "text";
        $this->other_details->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['other_details'] = &$this->other_details;

        // bank_name
        $this->bank_name = new DbField(
            $this, // Table
            'x_bank_name', // Variable name
            'bank_name', // Name
            '`bank_name`', // Expression
            '`bank_name`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bank_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bank_name->InputTextType = "text";
        $this->bank_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['bank_name'] = &$this->bank_name;

        // bank_ifsc_code
        $this->bank_ifsc_code = new DbField(
            $this, // Table
            'x_bank_ifsc_code', // Variable name
            'bank_ifsc_code', // Name
            '`bank_ifsc_code`', // Expression
            '`bank_ifsc_code`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bank_ifsc_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bank_ifsc_code->InputTextType = "text";
        $this->bank_ifsc_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['bank_ifsc_code'] = &$this->bank_ifsc_code;

        // bank_account_no
        $this->bank_account_no = new DbField(
            $this, // Table
            'x_bank_account_no', // Variable name
            'bank_account_no', // Name
            '`bank_account_no`', // Expression
            '`bank_account_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bank_account_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bank_account_no->InputTextType = "text";
        $this->bank_account_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['bank_account_no'] = &$this->bank_account_no;

        // account_no
        $this->account_no = new DbField(
            $this, // Table
            'x_account_no', // Variable name
            'account_no', // Name
            '`account_no`', // Expression
            '`account_no`', // Basic search expression
            200, // Type
            16, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`account_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->account_no->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->account_no->InputTextType = "text";
        $this->account_no->Nullable = false; // NOT NULL field
        $this->account_no->Required = true; // Required field
        $this->account_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['account_no'] = &$this->account_no;

        // loan_amount
        $this->loan_amount = new DbField(
            $this, // Table
            'x_loan_amount', // Variable name
            'loan_amount', // Name
            '`loan_amount`', // Expression
            '`loan_amount`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`loan_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->loan_amount->InputTextType = "text";
        $this->loan_amount->Raw = true;
        $this->loan_amount->Nullable = false; // NOT NULL field
        $this->loan_amount->Required = true; // Required field
        $this->loan_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->loan_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['loan_amount'] = &$this->loan_amount;

        // emi_amount
        $this->emi_amount = new DbField(
            $this, // Table
            'x_emi_amount', // Variable name
            'emi_amount', // Name
            '`emi_amount`', // Expression
            '`emi_amount`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`emi_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->emi_amount->InputTextType = "text";
        $this->emi_amount->Raw = true;
        $this->emi_amount->Nullable = false; // NOT NULL field
        $this->emi_amount->Required = true; // Required field
        $this->emi_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->emi_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['emi_amount'] = &$this->emi_amount;

        // frequency
        $this->frequency = new DbField(
            $this, // Table
            'x_frequency', // Variable name
            'frequency', // Name
            '`frequency`', // Expression
            '`frequency`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`frequency`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->frequency->addMethod("getDefault", fn() => 0.00);
        $this->frequency->InputTextType = "text";
        $this->frequency->Raw = true;
        $this->frequency->Required = true; // Required field
        $this->frequency->setSelectMultiple(false); // Select one
        $this->frequency->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->frequency->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->frequency->Lookup = new Lookup($this->frequency, 'b_account_info', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->frequency->OptionCount = 8;
        $this->frequency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->frequency->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['frequency'] = &$this->frequency;

        // disbursement_amount
        $this->disbursement_amount = new DbField(
            $this, // Table
            'x_disbursement_amount', // Variable name
            'disbursement_amount', // Name
            '`disbursement_amount`', // Expression
            '`disbursement_amount`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`disbursement_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->disbursement_amount->InputTextType = "text";
        $this->disbursement_amount->Raw = true;
        $this->disbursement_amount->Nullable = false; // NOT NULL field
        $this->disbursement_amount->Required = true; // Required field
        $this->disbursement_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->disbursement_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['disbursement_amount'] = &$this->disbursement_amount;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // d_operator
        $this->d_operator = new DbField(
            $this, // Table
            'x_d_operator', // Variable name
            'd_operator', // Name
            '`d_operator`', // Expression
            '`d_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->d_operator->InputTextType = "text";
        $this->d_operator->Raw = true;
        $this->d_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_operator'] = &$this->d_operator;

        // d_datetime
        $this->d_datetime = new DbField(
            $this, // Table
            'x_d_datetime', // Variable name
            'd_datetime', // Name
            '`d_datetime`', // Expression
            CastDateFieldForLike("`d_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`d_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->d_datetime->InputTextType = "text";
        $this->d_datetime->Raw = true;
        $this->d_datetime->Nullable = false; // NOT NULL field
        $this->d_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->d_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_datetime'] = &$this->d_datetime;

        // otp
        $this->otp = new DbField(
            $this, // Table
            'x_otp', // Variable name
            'otp', // Name
            '`otp`', // Expression
            '`otp`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`otp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->otp->InputTextType = "text";
        $this->otp->Raw = true;
        $this->otp->Sortable = false; // Allow sort
        $this->otp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->otp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['otp'] = &$this->otp;

        // otp_delivery_datetime
        $this->otp_delivery_datetime = new DbField(
            $this, // Table
            'x_otp_delivery_datetime', // Variable name
            'otp_delivery_datetime', // Name
            '`otp_delivery_datetime`', // Expression
            CastDateFieldForLike("`otp_delivery_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`otp_delivery_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->otp_delivery_datetime->InputTextType = "text";
        $this->otp_delivery_datetime->Raw = true;
        $this->otp_delivery_datetime->Sortable = false; // Allow sort
        $this->otp_delivery_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->otp_delivery_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['otp_delivery_datetime'] = &$this->otp_delivery_datetime;

        // otp_verify_datetime
        $this->otp_verify_datetime = new DbField(
            $this, // Table
            'x_otp_verify_datetime', // Variable name
            'otp_verify_datetime', // Name
            '`otp_verify_datetime`', // Expression
            CastDateFieldForLike("`otp_verify_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`otp_verify_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->otp_verify_datetime->InputTextType = "text";
        $this->otp_verify_datetime->Raw = true;
        $this->otp_verify_datetime->Sortable = false; // Allow sort
        $this->otp_verify_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->otp_verify_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['otp_verify_datetime'] = &$this->otp_verify_datetime;

        // no_of_emi
        $this->no_of_emi = new DbField(
            $this, // Table
            'x_no_of_emi', // Variable name
            'no_of_emi', // Name
            '`no_of_emi`', // Expression
            '`no_of_emi`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`no_of_emi`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->no_of_emi->addMethod("getDefault", fn() => 0);
        $this->no_of_emi->InputTextType = "text";
        $this->no_of_emi->Raw = true;
        $this->no_of_emi->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->no_of_emi->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['no_of_emi'] = &$this->no_of_emi;

        // fund_o
        $this->fund_o = new DbField(
            $this, // Table
            'x_fund_o', // Variable name
            'fund_o', // Name
            '`fund_o`', // Expression
            '`fund_o`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fund_o`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fund_o->addMethod("getDefault", fn() => 0.00);
        $this->fund_o->InputTextType = "text";
        $this->fund_o->Raw = true;
        $this->fund_o->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->fund_o->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['fund_o'] = &$this->fund_o;

        // fund_o_no
        $this->fund_o_no = new DbField(
            $this, // Table
            'x_fund_o_no', // Variable name
            'fund_o_no', // Name
            '`fund_o_no`', // Expression
            '`fund_o_no`', // Basic search expression
            200, // Type
            16, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fund_o_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->fund_o_no->addMethod("getSelectFilter", fn() => "`grp`= 230401");
        $this->fund_o_no->InputTextType = "text";
        $this->fund_o_no->setSelectMultiple(false); // Select one
        $this->fund_o_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->fund_o_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->fund_o_no->Lookup = new Lookup($this->fund_o_no, 'b_account_info', false, 'id', ["formal_name","bank_account_no","",""], '', '', [], [], [], [], [], [], false, '`formal_name` ASC', '', "CONCAT(COALESCE(`formal_name`, ''),'" . ValueSeparator(1, $this->fund_o_no) . "',COALESCE(`bank_account_no`,''))");
        $this->fund_o_no->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['fund_o_no'] = &$this->fund_o_no;

        // int_@
        $this->int_ = new DbField(
            $this, // Table
            'x_int_', // Variable name
            'int_@', // Name
            '`int_@`', // Expression
            '`int_@`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`int_@`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->int_->InputTextType = "text";
        $this->int_->Raw = true;
        $this->int_->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->int_->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['int_@'] = &$this->int_;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "b_account_info";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->b_type->DbValue = $row['b_type'];
        $this->grp->DbValue = $row['grp'];
        $this->branch->DbValue = $row['branch'];
        $this->category->DbValue = $row['category'];
        $this->account_type->DbValue = $row['account_type'];
        $this->type->DbValue = $row['type'];
        $this->formal_name->DbValue = $row['formal_name'];
        $this->mobile->DbValue = $row['mobile'];
        $this->_email->DbValue = $row['email'];
        $this->image->Upload->DbValue = $row['image'];
        $this->sign_image->Upload->DbValue = $row['sign_image'];
        $this->status->DbValue = $row['status'];
        $this->aadhaar_no->DbValue = $row['aadhaar_no'];
        $this->pan_no->DbValue = $row['pan_no'];
        $this->id_proof->Upload->DbValue = $row['id_proof'];
        $this->agent->DbValue = $row['agent'];
        $this->other_details->DbValue = $row['other_details'];
        $this->bank_name->DbValue = $row['bank_name'];
        $this->bank_ifsc_code->DbValue = $row['bank_ifsc_code'];
        $this->bank_account_no->DbValue = $row['bank_account_no'];
        $this->account_no->DbValue = $row['account_no'];
        $this->loan_amount->DbValue = $row['loan_amount'];
        $this->emi_amount->DbValue = $row['emi_amount'];
        $this->frequency->DbValue = $row['frequency'];
        $this->disbursement_amount->DbValue = $row['disbursement_amount'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->d_operator->DbValue = $row['d_operator'];
        $this->d_datetime->DbValue = $row['d_datetime'];
        $this->otp->DbValue = $row['otp'];
        $this->otp_delivery_datetime->DbValue = $row['otp_delivery_datetime'];
        $this->otp_verify_datetime->DbValue = $row['otp_verify_datetime'];
        $this->no_of_emi->DbValue = $row['no_of_emi'];
        $this->fund_o->DbValue = $row['fund_o'];
        $this->fund_o_no->DbValue = $row['fund_o_no'];
        $this->int_->DbValue = $row['int_@'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['image']) ? [] : [$row['image']];
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->image->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->image->oldPhysicalUploadPath() . $oldFile);
            }
        }
        $this->sign_image->OldUploadPath = $this->sign_image->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['sign_image']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['sign_image']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->sign_image->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->sign_image->oldPhysicalUploadPath() . $oldFile);
            }
        }
        $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['id_proof']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['id_proof']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->id_proof->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->id_proof->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("baccountinfolist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "baccountinfoview" => $Language->phrase("View"),
            "baccountinfoedit" => $Language->phrase("Edit"),
            "baccountinfoadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "baccountinfolist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "BAccountInfoView",
            Config("API_ADD_ACTION") => "BAccountInfoAdd",
            Config("API_EDIT_ACTION") => "BAccountInfoEdit",
            Config("API_DELETE_ACTION") => "BAccountInfoDelete",
            Config("API_LIST_ACTION") => "BAccountInfoList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "baccountinfolist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("baccountinfoview", $parm);
        } else {
            $url = $this->keyUrl("baccountinfoview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "baccountinfoadd?" . $parm;
        } else {
            $url = "baccountinfoadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("baccountinfoedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("baccountinfolist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("baccountinfoadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("baccountinfolist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("baccountinfodelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->b_type->setDbValue($row['b_type']);
        $this->grp->setDbValue($row['grp']);
        $this->branch->setDbValue($row['branch']);
        $this->category->setDbValue($row['category']);
        $this->account_type->setDbValue($row['account_type']);
        $this->type->setDbValue($row['type']);
        $this->formal_name->setDbValue($row['formal_name']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->image->Upload->DbValue = $row['image'];
        $this->sign_image->Upload->DbValue = $row['sign_image'];
        $this->status->setDbValue($row['status']);
        $this->aadhaar_no->setDbValue($row['aadhaar_no']);
        $this->pan_no->setDbValue($row['pan_no']);
        $this->id_proof->Upload->DbValue = $row['id_proof'];
        $this->agent->setDbValue($row['agent']);
        $this->other_details->setDbValue($row['other_details']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->account_no->setDbValue($row['account_no']);
        $this->loan_amount->setDbValue($row['loan_amount']);
        $this->emi_amount->setDbValue($row['emi_amount']);
        $this->frequency->setDbValue($row['frequency']);
        $this->disbursement_amount->setDbValue($row['disbursement_amount']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->d_operator->setDbValue($row['d_operator']);
        $this->d_datetime->setDbValue($row['d_datetime']);
        $this->otp->setDbValue($row['otp']);
        $this->otp_delivery_datetime->setDbValue($row['otp_delivery_datetime']);
        $this->otp_verify_datetime->setDbValue($row['otp_verify_datetime']);
        $this->no_of_emi->setDbValue($row['no_of_emi']);
        $this->fund_o->setDbValue($row['fund_o']);
        $this->fund_o_no->setDbValue($row['fund_o_no']);
        $this->int_->setDbValue($row['int_@']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "BAccountInfoList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // b_type

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // branch

        // category

        // account_type

        // type

        // formal_name

        // mobile

        // email

        // image

        // sign_image

        // status

        // aadhaar_no

        // pan_no

        // id_proof

        // agent

        // other_details

        // bank_name

        // bank_ifsc_code

        // bank_account_no

        // account_no

        // loan_amount

        // emi_amount

        // frequency

        // disbursement_amount

        // operator

        // datetime

        // d_operator

        // d_datetime

        // otp
        $this->otp->CellCssStyle = "white-space: nowrap;";

        // otp_delivery_datetime
        $this->otp_delivery_datetime->CellCssStyle = "white-space: nowrap;";

        // otp_verify_datetime
        $this->otp_verify_datetime->CellCssStyle = "white-space: nowrap;";

        // no_of_emi

        // fund_o

        // fund_o_no

        // int_@

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // b_type
        if (strval($this->b_type->CurrentValue) != "") {
            $this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
        } else {
            $this->b_type->ViewValue = null;
        }

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // branch
        $curVal = strval($this->branch->CurrentValue);
        if ($curVal != "") {
            $this->branch->ViewValue = $this->branch->lookupCacheOption($curVal);
            if ($this->branch->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->branch->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->branch->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->branch->getSelectFilter($this); // PHP
                $sqlWrk = $this->branch->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->branch->Lookup->renderViewRow($rswrk[0]);
                    $this->branch->ViewValue = $this->branch->displayValue($arwrk);
                } else {
                    $this->branch->ViewValue = FormatNumber($this->branch->CurrentValue, $this->branch->formatPattern());
                }
            }
        } else {
            $this->branch->ViewValue = null;
        }

        // category
        if (strval($this->category->CurrentValue) != "") {
            $this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
        } else {
            $this->category->ViewValue = null;
        }

        // account_type
        $this->account_type->ViewValue = $this->account_type->CurrentValue;
        $this->account_type->ViewValue = FormatNumber($this->account_type->ViewValue, $this->account_type->formatPattern());

        // type
        $curVal = strval($this->type->CurrentValue);
        if ($curVal != "") {
            $this->type->ViewValue = $this->type->lookupCacheOption($curVal);
            if ($this->type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->type->getSelectFilter($this); // PHP
                $sqlWrk = $this->type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->type->Lookup->renderViewRow($rswrk[0]);
                    $this->type->ViewValue = $this->type->displayValue($arwrk);
                } else {
                    $this->type->ViewValue = FormatNumber($this->type->CurrentValue, $this->type->formatPattern());
                }
            }
        } else {
            $this->type->ViewValue = null;
        }

        // formal_name
        $this->formal_name->ViewValue = $this->formal_name->CurrentValue;

        // mobile
        $this->mobile->ViewValue = $this->mobile->CurrentValue;
        $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

        // email
        $this->_email->ViewValue = $this->_email->CurrentValue;

        // image
        $this->image->UploadPath = $this->image->getUploadPath(); // PHP
        if (!EmptyValue($this->image->Upload->DbValue)) {
            $this->image->ViewValue = $this->image->Upload->DbValue;
        } else {
            $this->image->ViewValue = "";
        }

        // sign_image
        $this->sign_image->UploadPath = $this->sign_image->getUploadPath(); // PHP
        if (!EmptyValue($this->sign_image->Upload->DbValue)) {
            $this->sign_image->ViewValue = $this->sign_image->Upload->DbValue;
        } else {
            $this->sign_image->ViewValue = "";
        }

        // status
        $this->status->ViewValue = $this->status->CurrentValue;
        $curVal = strval($this->status->CurrentValue);
        if ($curVal != "") {
            $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
            if ($this->status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                    $this->status->ViewValue = $this->status->displayValue($arwrk);
                } else {
                    $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                }
            }
        } else {
            $this->status->ViewValue = null;
        }

        // aadhaar_no
        $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

        // pan_no
        $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

        // id_proof
        $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
        if (!EmptyValue($this->id_proof->Upload->DbValue)) {
            $this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
        } else {
            $this->id_proof->ViewValue = "";
        }

        // agent
        $curVal = strval($this->agent->CurrentValue);
        if ($curVal != "") {
            $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
            if ($this->agent->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                    $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                } else {
                    $this->agent->ViewValue = $this->agent->CurrentValue;
                }
            }
        } else {
            $this->agent->ViewValue = null;
        }

        // other_details
        $this->other_details->ViewValue = $this->other_details->CurrentValue;

        // bank_name
        $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

        // bank_ifsc_code
        $this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;

        // bank_account_no
        $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

        // account_no
        $this->account_no->ViewValue = $this->account_no->CurrentValue;

        // loan_amount
        $this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
        $this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, $this->loan_amount->formatPattern());

        // emi_amount
        $this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
        $this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, $this->emi_amount->formatPattern());

        // frequency
        if (strval($this->frequency->CurrentValue) != "") {
            $this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
        } else {
            $this->frequency->ViewValue = null;
        }

        // disbursement_amount
        $this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
        $this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, $this->disbursement_amount->formatPattern());

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // d_operator
        $this->d_operator->ViewValue = $this->d_operator->CurrentValue;
        $this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, $this->d_operator->formatPattern());

        // d_datetime
        $this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
        $this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, $this->d_datetime->formatPattern());

        // otp
        $this->otp->ViewValue = $this->otp->CurrentValue;
        $this->otp->ViewValue = FormatNumber($this->otp->ViewValue, $this->otp->formatPattern());

        // otp_delivery_datetime
        $this->otp_delivery_datetime->ViewValue = $this->otp_delivery_datetime->CurrentValue;
        $this->otp_delivery_datetime->ViewValue = FormatDateTime($this->otp_delivery_datetime->ViewValue, $this->otp_delivery_datetime->formatPattern());

        // otp_verify_datetime
        $this->otp_verify_datetime->ViewValue = $this->otp_verify_datetime->CurrentValue;
        $this->otp_verify_datetime->ViewValue = FormatDateTime($this->otp_verify_datetime->ViewValue, $this->otp_verify_datetime->formatPattern());

        // no_of_emi
        $this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
        $this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, $this->no_of_emi->formatPattern());

        // fund_o
        $this->fund_o->ViewValue = $this->fund_o->CurrentValue;
        $this->fund_o->ViewValue = FormatNumber($this->fund_o->ViewValue, $this->fund_o->formatPattern());

        // fund_o_no
        $curVal = strval($this->fund_o_no->CurrentValue);
        if ($curVal != "") {
            $this->fund_o_no->ViewValue = $this->fund_o_no->lookupCacheOption($curVal);
            if ($this->fund_o_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->fund_o_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->fund_o_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->fund_o_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->fund_o_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->fund_o_no->Lookup->renderViewRow($rswrk[0]);
                    $this->fund_o_no->ViewValue = $this->fund_o_no->displayValue($arwrk);
                } else {
                    $this->fund_o_no->ViewValue = $this->fund_o_no->CurrentValue;
                }
            }
        } else {
            $this->fund_o_no->ViewValue = null;
        }

        // int_@
        $this->int_->ViewValue = $this->int_->CurrentValue;
        $this->int_->ViewValue = FormatNumber($this->int_->ViewValue, $this->int_->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // b_type
        $this->b_type->HrefValue = "";
        $this->b_type->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // branch
        $this->branch->HrefValue = "";
        $this->branch->TooltipValue = "";

        // category
        $this->category->HrefValue = "";
        $this->category->TooltipValue = "";

        // account_type
        $this->account_type->HrefValue = "";
        $this->account_type->TooltipValue = "";

        // type
        $this->type->HrefValue = "";
        $this->type->TooltipValue = "";

        // formal_name
        $this->formal_name->HrefValue = "";
        $this->formal_name->TooltipValue = "";

        // mobile
        $this->mobile->HrefValue = "";
        $this->mobile->TooltipValue = "";

        // email
        $this->_email->HrefValue = "";
        $this->_email->TooltipValue = "";

        // image
        $this->image->HrefValue = "";
        $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
        $this->image->TooltipValue = "";

        // sign_image
        $this->sign_image->HrefValue = "";
        $this->sign_image->ExportHrefValue = $this->sign_image->UploadPath . $this->sign_image->Upload->DbValue;
        $this->sign_image->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // aadhaar_no
        $this->aadhaar_no->HrefValue = "";
        $this->aadhaar_no->TooltipValue = "";

        // pan_no
        $this->pan_no->HrefValue = "";
        $this->pan_no->TooltipValue = "";

        // id_proof
        $this->id_proof->LinkCustomAttributes = $this->id_proof->getLinkCustomAttributes(); // PHP
        $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
        if (!EmptyValue($this->id_proof->Upload->DbValue)) {
            $this->id_proof->HrefValue = "%u"; // Add prefix/suffix
            $this->id_proof->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->id_proof->HrefValue = FullUrl($this->id_proof->HrefValue, "href");
            }
        } else {
            $this->id_proof->HrefValue = "";
        }
        $this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
        $this->id_proof->TooltipValue = "";

        // agent
        $this->agent->HrefValue = "";
        $this->agent->TooltipValue = "";

        // other_details
        $this->other_details->HrefValue = "";
        $this->other_details->TooltipValue = "";

        // bank_name
        $this->bank_name->HrefValue = "";
        $this->bank_name->TooltipValue = "";

        // bank_ifsc_code
        $this->bank_ifsc_code->HrefValue = "";
        $this->bank_ifsc_code->TooltipValue = "";

        // bank_account_no
        $this->bank_account_no->HrefValue = "";
        $this->bank_account_no->TooltipValue = "";

        // account_no
        $this->account_no->HrefValue = "";
        $this->account_no->TooltipValue = "";

        // loan_amount
        $this->loan_amount->HrefValue = "";
        $this->loan_amount->TooltipValue = "";

        // emi_amount
        $this->emi_amount->HrefValue = "";
        $this->emi_amount->TooltipValue = "";

        // frequency
        $this->frequency->HrefValue = "";
        $this->frequency->TooltipValue = "";

        // disbursement_amount
        $this->disbursement_amount->HrefValue = "";
        $this->disbursement_amount->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // d_operator
        $this->d_operator->HrefValue = "";
        $this->d_operator->TooltipValue = "";

        // d_datetime
        $this->d_datetime->HrefValue = "";
        $this->d_datetime->TooltipValue = "";

        // otp
        $this->otp->HrefValue = "";
        $this->otp->TooltipValue = "";

        // otp_delivery_datetime
        $this->otp_delivery_datetime->HrefValue = "";
        $this->otp_delivery_datetime->TooltipValue = "";

        // otp_verify_datetime
        $this->otp_verify_datetime->HrefValue = "";
        $this->otp_verify_datetime->TooltipValue = "";

        // no_of_emi
        $this->no_of_emi->HrefValue = "";
        $this->no_of_emi->TooltipValue = "";

        // fund_o
        $this->fund_o->HrefValue = "";
        $this->fund_o->TooltipValue = "";

        // fund_o_no
        $this->fund_o_no->HrefValue = "";
        $this->fund_o_no->TooltipValue = "";

        // int_@
        $this->int_->HrefValue = "";
        $this->int_->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->EditValue = FormatNumber($this->id->EditValue, $this->id->formatPattern());

        // b_type
        $this->b_type->setupEditAttributes();
        $this->b_type->EditValue = $this->b_type->options(true);
        $this->b_type->PlaceHolder = RemoveHtml($this->b_type->caption());

        // grp
        $this->grp->setupEditAttributes();
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->EditValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->EditValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->EditValue = null;
        }

        // branch
        $this->branch->setupEditAttributes();
        $this->branch->PlaceHolder = RemoveHtml($this->branch->caption());

        // category
        $this->category->setupEditAttributes();
        $this->category->EditValue = $this->category->options(true);
        $this->category->PlaceHolder = RemoveHtml($this->category->caption());

        // account_type
        $this->account_type->setupEditAttributes();
        $this->account_type->EditValue = $this->account_type->CurrentValue;
        $this->account_type->PlaceHolder = RemoveHtml($this->account_type->caption());
        if (strval($this->account_type->EditValue) != "" && is_numeric($this->account_type->EditValue)) {
            $this->account_type->EditValue = FormatNumber($this->account_type->EditValue, null);
        }

        // type
        $this->type->setupEditAttributes();
        $this->type->PlaceHolder = RemoveHtml($this->type->caption());

        // formal_name
        $this->formal_name->setupEditAttributes();
        if (!$this->formal_name->Raw) {
            $this->formal_name->CurrentValue = HtmlDecode($this->formal_name->CurrentValue);
        }
        $this->formal_name->EditValue = $this->formal_name->CurrentValue;
        $this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

        // mobile
        $this->mobile->setupEditAttributes();
        $this->mobile->EditValue = $this->mobile->CurrentValue;
        $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());
        if (strval($this->mobile->EditValue) != "" && is_numeric($this->mobile->EditValue)) {
            $this->mobile->EditValue = FormatNumber($this->mobile->EditValue, null);
        }

        // email
        $this->_email->setupEditAttributes();
        if (!$this->_email->Raw) {
            $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
        }
        $this->_email->EditValue = $this->_email->CurrentValue;
        $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

        // image
        $this->image->setupEditAttributes();
        $this->image->UploadPath = $this->image->getUploadPath(); // PHP
        if (!EmptyValue($this->image->Upload->DbValue)) {
            $this->image->EditValue = $this->image->Upload->DbValue;
        } else {
            $this->image->EditValue = "";
        }
        if (!EmptyValue($this->image->CurrentValue)) {
            $this->image->Upload->FileName = $this->image->CurrentValue;
        }

        // sign_image
        $this->sign_image->setupEditAttributes();
        $this->sign_image->UploadPath = $this->sign_image->getUploadPath(); // PHP
        if (!EmptyValue($this->sign_image->Upload->DbValue)) {
            $this->sign_image->EditValue = $this->sign_image->Upload->DbValue;
        } else {
            $this->sign_image->EditValue = "";
        }
        if (!EmptyValue($this->sign_image->CurrentValue)) {
            $this->sign_image->Upload->FileName = $this->sign_image->CurrentValue;
        }

        // status
        $this->status->setupEditAttributes();
        $this->status->EditCustomAttributes = $this->status->getEditCustomAttributes(); // PHP
        $this->status->EditValue = $this->status->CurrentValue;
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // aadhaar_no
        $this->aadhaar_no->setupEditAttributes();
        if (!$this->aadhaar_no->Raw) {
            $this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
        }
        $this->aadhaar_no->EditValue = $this->aadhaar_no->CurrentValue;
        $this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

        // pan_no
        $this->pan_no->setupEditAttributes();
        if (!$this->pan_no->Raw) {
            $this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
        }
        $this->pan_no->EditValue = $this->pan_no->CurrentValue;
        $this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

        // id_proof
        $this->id_proof->setupEditAttributes();
        $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
        if (!EmptyValue($this->id_proof->Upload->DbValue)) {
            $this->id_proof->EditValue = $this->id_proof->Upload->DbValue;
        } else {
            $this->id_proof->EditValue = "";
        }
        if (!EmptyValue($this->id_proof->CurrentValue)) {
            $this->id_proof->Upload->FileName = $this->id_proof->CurrentValue;
        }

        // agent
        $this->agent->setupEditAttributes();
        $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

        // other_details
        $this->other_details->setupEditAttributes();
        if (!$this->other_details->Raw) {
            $this->other_details->CurrentValue = HtmlDecode($this->other_details->CurrentValue);
        }
        $this->other_details->EditValue = $this->other_details->CurrentValue;
        $this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

        // bank_name
        $this->bank_name->setupEditAttributes();
        if (!$this->bank_name->Raw) {
            $this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
        }
        $this->bank_name->EditValue = $this->bank_name->CurrentValue;
        $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

        // bank_ifsc_code
        $this->bank_ifsc_code->setupEditAttributes();
        if (!$this->bank_ifsc_code->Raw) {
            $this->bank_ifsc_code->CurrentValue = HtmlDecode($this->bank_ifsc_code->CurrentValue);
        }
        $this->bank_ifsc_code->EditValue = $this->bank_ifsc_code->CurrentValue;
        $this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

        // bank_account_no
        $this->bank_account_no->setupEditAttributes();
        if (!$this->bank_account_no->Raw) {
            $this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
        }
        $this->bank_account_no->EditValue = $this->bank_account_no->CurrentValue;
        $this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

        // account_no
        $this->account_no->setupEditAttributes();
        $this->account_no->EditCustomAttributes = $this->account_no->getEditCustomAttributes(); // PHP
        $this->account_no->EditValue = $this->account_no->CurrentValue;

        // loan_amount
        $this->loan_amount->setupEditAttributes();
        $this->loan_amount->EditValue = $this->loan_amount->CurrentValue;
        $this->loan_amount->PlaceHolder = RemoveHtml($this->loan_amount->caption());
        if (strval($this->loan_amount->EditValue) != "" && is_numeric($this->loan_amount->EditValue)) {
            $this->loan_amount->EditValue = FormatNumber($this->loan_amount->EditValue, null);
        }

        // emi_amount
        $this->emi_amount->setupEditAttributes();
        $this->emi_amount->EditValue = $this->emi_amount->CurrentValue;
        $this->emi_amount->PlaceHolder = RemoveHtml($this->emi_amount->caption());
        if (strval($this->emi_amount->EditValue) != "" && is_numeric($this->emi_amount->EditValue)) {
            $this->emi_amount->EditValue = FormatNumber($this->emi_amount->EditValue, null);
        }

        // frequency
        $this->frequency->setupEditAttributes();
        $this->frequency->EditValue = $this->frequency->options(true);
        $this->frequency->PlaceHolder = RemoveHtml($this->frequency->caption());

        // disbursement_amount
        $this->disbursement_amount->setupEditAttributes();
        $this->disbursement_amount->EditValue = $this->disbursement_amount->CurrentValue;
        $this->disbursement_amount->PlaceHolder = RemoveHtml($this->disbursement_amount->caption());
        if (strval($this->disbursement_amount->EditValue) != "" && is_numeric($this->disbursement_amount->EditValue)) {
            $this->disbursement_amount->EditValue = FormatNumber($this->disbursement_amount->EditValue, null);
        }

        // operator

        // datetime

        // d_operator

        // d_datetime

        // otp
        $this->otp->setupEditAttributes();
        $this->otp->EditValue = $this->otp->CurrentValue;
        $this->otp->PlaceHolder = RemoveHtml($this->otp->caption());
        if (strval($this->otp->EditValue) != "" && is_numeric($this->otp->EditValue)) {
            $this->otp->EditValue = FormatNumber($this->otp->EditValue, null);
        }

        // otp_delivery_datetime
        $this->otp_delivery_datetime->setupEditAttributes();
        $this->otp_delivery_datetime->EditValue = FormatDateTime($this->otp_delivery_datetime->CurrentValue, $this->otp_delivery_datetime->formatPattern());
        $this->otp_delivery_datetime->PlaceHolder = RemoveHtml($this->otp_delivery_datetime->caption());

        // otp_verify_datetime
        $this->otp_verify_datetime->setupEditAttributes();
        $this->otp_verify_datetime->EditValue = FormatDateTime($this->otp_verify_datetime->CurrentValue, $this->otp_verify_datetime->formatPattern());
        $this->otp_verify_datetime->PlaceHolder = RemoveHtml($this->otp_verify_datetime->caption());

        // no_of_emi
        $this->no_of_emi->setupEditAttributes();
        $this->no_of_emi->EditValue = $this->no_of_emi->CurrentValue;
        $this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());
        if (strval($this->no_of_emi->EditValue) != "" && is_numeric($this->no_of_emi->EditValue)) {
            $this->no_of_emi->EditValue = FormatNumber($this->no_of_emi->EditValue, null);
        }

        // fund_o
        $this->fund_o->setupEditAttributes();
        $this->fund_o->EditValue = $this->fund_o->CurrentValue;
        $this->fund_o->PlaceHolder = RemoveHtml($this->fund_o->caption());
        if (strval($this->fund_o->EditValue) != "" && is_numeric($this->fund_o->EditValue)) {
            $this->fund_o->EditValue = FormatNumber($this->fund_o->EditValue, null);
        }

        // fund_o_no
        $this->fund_o_no->setupEditAttributes();
        $this->fund_o_no->PlaceHolder = RemoveHtml($this->fund_o_no->caption());

        // int_@
        $this->int_->setupEditAttributes();
        $this->int_->EditValue = $this->int_->CurrentValue;
        $this->int_->PlaceHolder = RemoveHtml($this->int_->caption());
        if (strval($this->int_->EditValue) != "" && is_numeric($this->int_->EditValue)) {
            $this->int_->EditValue = FormatNumber($this->int_->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->loan_amount->CurrentValue)) {
                $this->loan_amount->Total += $this->loan_amount->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->emi_amount->CurrentValue)) {
                $this->emi_amount->Total += $this->emi_amount->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->disbursement_amount->CurrentValue)) {
                $this->disbursement_amount->Total += $this->disbursement_amount->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->loan_amount->CurrentValue = $this->loan_amount->Total;
            $this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
            $this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, $this->loan_amount->formatPattern());
            $this->loan_amount->HrefValue = ""; // Clear href value
            $this->emi_amount->CurrentValue = $this->emi_amount->Total;
            $this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
            $this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, $this->emi_amount->formatPattern());
            $this->emi_amount->HrefValue = ""; // Clear href value
            $this->disbursement_amount->CurrentValue = $this->disbursement_amount->Total;
            $this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
            $this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, $this->disbursement_amount->formatPattern());
            $this->disbursement_amount->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->b_type);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->branch);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->account_type);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->formal_name);
                    $doc->exportCaption($this->mobile);
                    $doc->exportCaption($this->_email);
                    $doc->exportCaption($this->image);
                    $doc->exportCaption($this->sign_image);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->aadhaar_no);
                    $doc->exportCaption($this->pan_no);
                    $doc->exportCaption($this->id_proof);
                    $doc->exportCaption($this->agent);
                    $doc->exportCaption($this->other_details);
                    $doc->exportCaption($this->bank_name);
                    $doc->exportCaption($this->bank_ifsc_code);
                    $doc->exportCaption($this->bank_account_no);
                    $doc->exportCaption($this->account_no);
                    $doc->exportCaption($this->loan_amount);
                    $doc->exportCaption($this->emi_amount);
                    $doc->exportCaption($this->frequency);
                    $doc->exportCaption($this->disbursement_amount);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->d_operator);
                    $doc->exportCaption($this->d_datetime);
                    $doc->exportCaption($this->otp_delivery_datetime);
                    $doc->exportCaption($this->otp_verify_datetime);
                    $doc->exportCaption($this->no_of_emi);
                    $doc->exportCaption($this->fund_o);
                    $doc->exportCaption($this->fund_o_no);
                    $doc->exportCaption($this->int_);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->b_type);
                    $doc->exportCaption($this->branch);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->account_type);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->formal_name);
                    $doc->exportCaption($this->mobile);
                    $doc->exportCaption($this->_email);
                    $doc->exportCaption($this->image);
                    $doc->exportCaption($this->sign_image);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->aadhaar_no);
                    $doc->exportCaption($this->pan_no);
                    $doc->exportCaption($this->id_proof);
                    $doc->exportCaption($this->agent);
                    $doc->exportCaption($this->bank_name);
                    $doc->exportCaption($this->bank_ifsc_code);
                    $doc->exportCaption($this->bank_account_no);
                    $doc->exportCaption($this->account_no);
                    $doc->exportCaption($this->loan_amount);
                    $doc->exportCaption($this->emi_amount);
                    $doc->exportCaption($this->frequency);
                    $doc->exportCaption($this->disbursement_amount);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->d_operator);
                    $doc->exportCaption($this->d_datetime);
                    $doc->exportCaption($this->otp_delivery_datetime);
                    $doc->exportCaption($this->otp_verify_datetime);
                    $doc->exportCaption($this->no_of_emi);
                    $doc->exportCaption($this->fund_o);
                    $doc->exportCaption($this->fund_o_no);
                    $doc->exportCaption($this->int_);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->b_type);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->branch);
                        $doc->exportField($this->category);
                        $doc->exportField($this->account_type);
                        $doc->exportField($this->type);
                        $doc->exportField($this->formal_name);
                        $doc->exportField($this->mobile);
                        $doc->exportField($this->_email);
                        $doc->exportField($this->image);
                        $doc->exportField($this->sign_image);
                        $doc->exportField($this->status);
                        $doc->exportField($this->aadhaar_no);
                        $doc->exportField($this->pan_no);
                        $doc->exportField($this->id_proof);
                        $doc->exportField($this->agent);
                        $doc->exportField($this->other_details);
                        $doc->exportField($this->bank_name);
                        $doc->exportField($this->bank_ifsc_code);
                        $doc->exportField($this->bank_account_no);
                        $doc->exportField($this->account_no);
                        $doc->exportField($this->loan_amount);
                        $doc->exportField($this->emi_amount);
                        $doc->exportField($this->frequency);
                        $doc->exportField($this->disbursement_amount);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->d_operator);
                        $doc->exportField($this->d_datetime);
                        $doc->exportField($this->otp_delivery_datetime);
                        $doc->exportField($this->otp_verify_datetime);
                        $doc->exportField($this->no_of_emi);
                        $doc->exportField($this->fund_o);
                        $doc->exportField($this->fund_o_no);
                        $doc->exportField($this->int_);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->b_type);
                        $doc->exportField($this->branch);
                        $doc->exportField($this->category);
                        $doc->exportField($this->account_type);
                        $doc->exportField($this->type);
                        $doc->exportField($this->formal_name);
                        $doc->exportField($this->mobile);
                        $doc->exportField($this->_email);
                        $doc->exportField($this->image);
                        $doc->exportField($this->sign_image);
                        $doc->exportField($this->status);
                        $doc->exportField($this->aadhaar_no);
                        $doc->exportField($this->pan_no);
                        $doc->exportField($this->id_proof);
                        $doc->exportField($this->agent);
                        $doc->exportField($this->bank_name);
                        $doc->exportField($this->bank_ifsc_code);
                        $doc->exportField($this->bank_account_no);
                        $doc->exportField($this->account_no);
                        $doc->exportField($this->loan_amount);
                        $doc->exportField($this->emi_amount);
                        $doc->exportField($this->frequency);
                        $doc->exportField($this->disbursement_amount);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->d_operator);
                        $doc->exportField($this->d_datetime);
                        $doc->exportField($this->otp_delivery_datetime);
                        $doc->exportField($this->otp_verify_datetime);
                        $doc->exportField($this->no_of_emi);
                        $doc->exportField($this->fund_o);
                        $doc->exportField($this->fund_o_no);
                        $doc->exportField($this->int_);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->b_type, '');
                $doc->exportAggregate($this->branch, '');
                $doc->exportAggregate($this->category, '');
                $doc->exportAggregate($this->account_type, '');
                $doc->exportAggregate($this->type, '');
                $doc->exportAggregate($this->formal_name, '');
                $doc->exportAggregate($this->mobile, '');
                $doc->exportAggregate($this->_email, '');
                $doc->exportAggregate($this->image, '');
                $doc->exportAggregate($this->sign_image, '');
                $doc->exportAggregate($this->status, '');
                $doc->exportAggregate($this->aadhaar_no, '');
                $doc->exportAggregate($this->pan_no, '');
                $doc->exportAggregate($this->id_proof, '');
                $doc->exportAggregate($this->agent, '');
                $doc->exportAggregate($this->bank_name, '');
                $doc->exportAggregate($this->bank_ifsc_code, '');
                $doc->exportAggregate($this->bank_account_no, '');
                $doc->exportAggregate($this->account_no, '');
                $doc->exportAggregate($this->loan_amount, 'TOTAL');
                $doc->exportAggregate($this->emi_amount, 'TOTAL');
                $doc->exportAggregate($this->frequency, '');
                $doc->exportAggregate($this->disbursement_amount, 'TOTAL');
                $doc->exportAggregate($this->operator, '');
                $doc->exportAggregate($this->datetime, '');
                $doc->exportAggregate($this->d_operator, '');
                $doc->exportAggregate($this->d_datetime, '');
                $doc->exportAggregate($this->otp_delivery_datetime, '');
                $doc->exportAggregate($this->otp_verify_datetime, '');
                $doc->exportAggregate($this->no_of_emi, '');
                $doc->exportAggregate($this->fund_o, '');
                $doc->exportAggregate($this->fund_o_no, '');
                $doc->exportAggregate($this->int_, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'image') {
            $fldName = "image";
            $fileNameFld = "image";
        } elseif ($fldparm == 'sign_image') {
            $fldName = "sign_image";
            $fileNameFld = "sign_image";
        } elseif ($fldparm == 'id_proof') {
            $fldName = "id_proof";
            $fileNameFld = "id_proof";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'b_account_info');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'b_account_info', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'b_account_info', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'b_account_info', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
