<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class BAccountCompiledSearch extends BAccountCompiled
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BAccountCompiledSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "baccountcompiledsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->grp->setVisibility();
        $this->account_no->setVisibility();
        $this->formal_name->setVisibility();
        $this->balance->setVisibility();
        $this->loan_amount->setVisibility();
        $this->emi_amount->setVisibility();
        $this->no_of_emi->setVisibility();
        $this->disbursement_amount->setVisibility();
        $this->frequency->setVisibility();
        $this->status->setVisibility();
        $this->end_date->setVisibility();
        $this->due_emi->setVisibility();
        $this->branch->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'b_account_compiled';
        $this->TableName = 'b_account_compiled';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (b_account_compiled)
        if (!isset($GLOBALS["b_account_compiled"]) || $GLOBALS["b_account_compiled"]::class == PROJECT_NAMESPACE . "b_account_compiled") {
            $GLOBALS["b_account_compiled"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_compiled');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "baccountcompiledview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->balance->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->due_emi->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->frequency);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->branch);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "baccountcompiledlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->account_no); // account_no
        $this->buildSearchUrl($srchUrl, $this->formal_name); // formal_name
        $this->buildSearchUrl($srchUrl, $this->balance); // balance
        $this->buildSearchUrl($srchUrl, $this->loan_amount); // loan_amount
        $this->buildSearchUrl($srchUrl, $this->emi_amount); // emi_amount
        $this->buildSearchUrl($srchUrl, $this->no_of_emi); // no_of_emi
        $this->buildSearchUrl($srchUrl, $this->disbursement_amount); // disbursement_amount
        $this->buildSearchUrl($srchUrl, $this->frequency); // frequency
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->end_date); // end_date
        $this->buildSearchUrl($srchUrl, $this->due_emi); // due_emi
        $this->buildSearchUrl($srchUrl, $this->branch); // branch
        $this->buildSearchUrl($srchUrl, $this->mobile); // mobile
        $this->buildSearchUrl($srchUrl, $this->_email); // email
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // account_no
        if ($this->account_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // formal_name
        if ($this->formal_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // balance
        if ($this->balance->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // loan_amount
        if ($this->loan_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // emi_amount
        if ($this->emi_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // no_of_emi
        if ($this->no_of_emi->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // disbursement_amount
        if ($this->disbursement_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // frequency
        if ($this->frequency->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // end_date
        if ($this->end_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // due_emi
        if ($this->due_emi->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // branch
        if ($this->branch->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // email
        if ($this->_email->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // account_no
        $this->account_no->RowCssClass = "row";

        // formal_name
        $this->formal_name->RowCssClass = "row";

        // balance
        $this->balance->RowCssClass = "row";

        // loan_amount
        $this->loan_amount->RowCssClass = "row";

        // emi_amount
        $this->emi_amount->RowCssClass = "row";

        // no_of_emi
        $this->no_of_emi->RowCssClass = "row";

        // disbursement_amount
        $this->disbursement_amount->RowCssClass = "row";

        // frequency
        $this->frequency->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // end_date
        $this->end_date->RowCssClass = "row";

        // due_emi
        $this->due_emi->RowCssClass = "row";

        // branch
        $this->branch->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // account_no
            $this->account_no->ViewValue = $this->account_no->CurrentValue;

            // formal_name
            $this->formal_name->ViewValue = $this->formal_name->CurrentValue;

            // balance
            $this->balance->ViewValue = $this->balance->CurrentValue;
            $this->balance->ViewValue = FormatNumber($this->balance->ViewValue, $this->balance->formatPattern());

            // loan_amount
            $this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
            $this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, $this->loan_amount->formatPattern());

            // emi_amount
            $this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
            $this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, $this->emi_amount->formatPattern());

            // no_of_emi
            $this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
            $this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, $this->no_of_emi->formatPattern());

            // disbursement_amount
            $this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
            $this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, $this->disbursement_amount->formatPattern());

            // frequency
            if (strval($this->frequency->CurrentValue) != "") {
                $this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
            } else {
                $this->frequency->ViewValue = null;
            }

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // end_date
            $this->end_date->ViewValue = $this->end_date->CurrentValue;
            $this->end_date->ViewValue = FormatDateTime($this->end_date->ViewValue, $this->end_date->formatPattern());

            // due_emi
            $this->due_emi->ViewValue = $this->due_emi->CurrentValue;
            $this->due_emi->ViewValue = FormatNumber($this->due_emi->ViewValue, $this->due_emi->formatPattern());

            // branch
            $curVal = strval($this->branch->CurrentValue);
            if ($curVal != "") {
                $this->branch->ViewValue = $this->branch->lookupCacheOption($curVal);
                if ($this->branch->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->branch->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->branch->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->branch->getSelectFilter($this); // PHP
                    $sqlWrk = $this->branch->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->branch->Lookup->renderViewRow($rswrk[0]);
                        $this->branch->ViewValue = $this->branch->displayValue($arwrk);
                    } else {
                        $this->branch->ViewValue = FormatNumber($this->branch->CurrentValue, $this->branch->formatPattern());
                    }
                }
            } else {
                $this->branch->ViewValue = null;
            }

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // account_no
            $this->account_no->HrefValue = "";
            $this->account_no->TooltipValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";
            $this->formal_name->TooltipValue = "";

            // balance
            $this->balance->HrefValue = "";
            $this->balance->TooltipValue = "";

            // loan_amount
            $this->loan_amount->HrefValue = "";
            $this->loan_amount->TooltipValue = "";

            // emi_amount
            $this->emi_amount->HrefValue = "";
            $this->emi_amount->TooltipValue = "";

            // no_of_emi
            $this->no_of_emi->HrefValue = "";
            $this->no_of_emi->TooltipValue = "";

            // disbursement_amount
            $this->disbursement_amount->HrefValue = "";
            $this->disbursement_amount->TooltipValue = "";

            // frequency
            $this->frequency->HrefValue = "";
            $this->frequency->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // end_date
            $this->end_date->HrefValue = "";
            $this->end_date->TooltipValue = "";

            // due_emi
            $this->due_emi->HrefValue = "";
            $this->due_emi->TooltipValue = "";

            // branch
            $this->branch->HrefValue = "";
            $this->branch->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // email
            $this->_email->HrefValue = "";
            $this->_email->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // account_no
            $this->account_no->setupEditAttributes();
            if (!$this->account_no->Raw) {
                $this->account_no->AdvancedSearch->SearchValue = HtmlDecode($this->account_no->AdvancedSearch->SearchValue);
            }
            $this->account_no->EditValue = HtmlEncode($this->account_no->AdvancedSearch->SearchValue);
            $this->account_no->PlaceHolder = RemoveHtml($this->account_no->caption());

            // formal_name
            $this->formal_name->setupEditAttributes();
            if (!$this->formal_name->Raw) {
                $this->formal_name->AdvancedSearch->SearchValue = HtmlDecode($this->formal_name->AdvancedSearch->SearchValue);
            }
            $this->formal_name->EditValue = HtmlEncode($this->formal_name->AdvancedSearch->SearchValue);
            $this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

            // balance
            $this->balance->setupEditAttributes();
            $this->balance->EditValue = $this->balance->AdvancedSearch->SearchValue;
            $this->balance->PlaceHolder = RemoveHtml($this->balance->caption());

            // loan_amount
            $this->loan_amount->setupEditAttributes();
            $this->loan_amount->EditValue = $this->loan_amount->AdvancedSearch->SearchValue;
            $this->loan_amount->PlaceHolder = RemoveHtml($this->loan_amount->caption());

            // emi_amount
            $this->emi_amount->setupEditAttributes();
            $this->emi_amount->EditValue = $this->emi_amount->AdvancedSearch->SearchValue;
            $this->emi_amount->PlaceHolder = RemoveHtml($this->emi_amount->caption());

            // no_of_emi
            $this->no_of_emi->setupEditAttributes();
            $this->no_of_emi->EditValue = $this->no_of_emi->AdvancedSearch->SearchValue;
            $this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());

            // disbursement_amount
            $this->disbursement_amount->setupEditAttributes();
            $this->disbursement_amount->EditValue = $this->disbursement_amount->AdvancedSearch->SearchValue;
            $this->disbursement_amount->PlaceHolder = RemoveHtml($this->disbursement_amount->caption());

            // frequency
            $this->frequency->EditValue = $this->frequency->options(false);
            $this->frequency->PlaceHolder = RemoveHtml($this->frequency->caption());

            // status
            $this->status->setupEditAttributes();
            $curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
            } else {
                $this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== null && is_array($this->status->lookupOptions()) && count($this->status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->status->EditValue = array_values($this->status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->status->AdvancedSearch->SearchValue, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->status->EditValue = $arwrk;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // end_date
            $this->end_date->setupEditAttributes();
            $this->end_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->end_date->AdvancedSearch->SearchValue, $this->end_date->formatPattern()), $this->end_date->formatPattern()));
            $this->end_date->PlaceHolder = RemoveHtml($this->end_date->caption());

            // due_emi
            $this->due_emi->setupEditAttributes();
            $this->due_emi->EditValue = $this->due_emi->AdvancedSearch->SearchValue;
            $this->due_emi->PlaceHolder = RemoveHtml($this->due_emi->caption());

            // branch
            $this->branch->setupEditAttributes();
            $curVal = trim(strval($this->branch->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->branch->AdvancedSearch->ViewValue = $this->branch->lookupCacheOption($curVal);
            } else {
                $this->branch->AdvancedSearch->ViewValue = $this->branch->Lookup !== null && is_array($this->branch->lookupOptions()) && count($this->branch->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->branch->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->branch->EditValue = array_values($this->branch->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->branch->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->branch->AdvancedSearch->SearchValue, $this->branch->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->branch->getSelectFilter($this); // PHP
                $sqlWrk = $this->branch->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->branch->EditValue = $arwrk;
            }
            $this->branch->PlaceHolder = RemoveHtml($this->branch->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->AdvancedSearch->SearchValue;
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->AdvancedSearch->SearchValue = HtmlDecode($this->_email->AdvancedSearch->SearchValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->AdvancedSearch->SearchValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckNumber($this->balance->AdvancedSearch->SearchValue)) {
            $this->balance->addErrorMessage($this->balance->getErrorMessage(false));
        }
        if (!CheckNumber($this->loan_amount->AdvancedSearch->SearchValue)) {
            $this->loan_amount->addErrorMessage($this->loan_amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->emi_amount->AdvancedSearch->SearchValue)) {
            $this->emi_amount->addErrorMessage($this->emi_amount->getErrorMessage(false));
        }
        if (!CheckInteger($this->no_of_emi->AdvancedSearch->SearchValue)) {
            $this->no_of_emi->addErrorMessage($this->no_of_emi->getErrorMessage(false));
        }
        if (!CheckNumber($this->disbursement_amount->AdvancedSearch->SearchValue)) {
            $this->disbursement_amount->addErrorMessage($this->disbursement_amount->getErrorMessage(false));
        }
        if (!CheckDate($this->end_date->AdvancedSearch->SearchValue, $this->end_date->formatPattern())) {
            $this->end_date->addErrorMessage($this->end_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->due_emi->AdvancedSearch->SearchValue)) {
            $this->due_emi->addErrorMessage($this->due_emi->getErrorMessage(false));
        }
        if (!CheckInteger($this->mobile->AdvancedSearch->SearchValue)) {
            $this->mobile->addErrorMessage($this->mobile->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->grp->AdvancedSearch->load();
        $this->account_no->AdvancedSearch->load();
        $this->formal_name->AdvancedSearch->load();
        $this->balance->AdvancedSearch->load();
        $this->loan_amount->AdvancedSearch->load();
        $this->emi_amount->AdvancedSearch->load();
        $this->no_of_emi->AdvancedSearch->load();
        $this->disbursement_amount->AdvancedSearch->load();
        $this->frequency->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->end_date->AdvancedSearch->load();
        $this->due_emi->AdvancedSearch->load();
        $this->branch->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->_email->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("baccountcompiledlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_frequency":
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_branch":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
