<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ApcEdit extends Apc
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ApcEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "apcedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->apcid->setVisibility();
        $this->grp->setVisibility();
        $this->code->setVisibility();
        $this->description->setVisibility();
        $this->cron->setVisibility();
        $this->next_cycle->setVisibility();
        $this->delay->setVisibility();
        $this->delay_method->setVisibility();
        $this->last_updated->setVisibility();
        $this->user_level->setVisibility();
        $this->_visible->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->status->setVisibility();
        $this->order_by->setVisibility();
        $this->url->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'apc';
        $this->TableName = 'apc';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (apc)
        if (!isset($GLOBALS["apc"]) || $GLOBALS["apc"]::class == PROJECT_NAMESPACE . "apc") {
            $GLOBALS["apc"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'apc');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "apcview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['apcid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->last_updated->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->cron);
        $this->setupLookupOptions($this->delay_method);
        $this->setupLookupOptions($this->user_level);
        $this->setupLookupOptions($this->_visible);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->status);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("apcid") ?? Key(0) ?? Route(2)) !== null) {
                $this->apcid->setQueryStringValue($keyValue);
                $this->apcid->setOldValue($this->apcid->QueryStringValue);
            } elseif (Post("apcid") !== null) {
                $this->apcid->setFormValue(Post("apcid"));
                $this->apcid->setOldValue($this->apcid->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("apcid") ?? Route("apcid")) !== null) {
                    $this->apcid->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->apcid->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("apclist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "apclist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "apclist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "apclist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'apcid' first before field var 'x_apcid'
        $val = $CurrentForm->hasValue("apcid") ? $CurrentForm->getValue("apcid") : $CurrentForm->getValue("x_apcid");
        if (!$this->apcid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->apcid->Visible = false; // Disable update for API request
            } else {
                $this->apcid->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_apcid")) {
            $this->apcid->setOldValue($CurrentForm->getValue("o_apcid"));
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'code' first before field var 'x_code'
        $val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
        if (!$this->code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->code->Visible = false; // Disable update for API request
            } else {
                $this->code->setFormValue($val);
            }
        }

        // Check field name 'description' first before field var 'x_description'
        $val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
        if (!$this->description->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description->Visible = false; // Disable update for API request
            } else {
                $this->description->setFormValue($val);
            }
        }

        // Check field name 'cron' first before field var 'x_cron'
        $val = $CurrentForm->hasValue("cron") ? $CurrentForm->getValue("cron") : $CurrentForm->getValue("x_cron");
        if (!$this->cron->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cron->Visible = false; // Disable update for API request
            } else {
                $this->cron->setFormValue($val);
            }
        }

        // Check field name 'next_cycle' first before field var 'x_next_cycle'
        $val = $CurrentForm->hasValue("next_cycle") ? $CurrentForm->getValue("next_cycle") : $CurrentForm->getValue("x_next_cycle");
        if (!$this->next_cycle->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->next_cycle->Visible = false; // Disable update for API request
            } else {
                $this->next_cycle->setFormValue($val, true, $validate);
            }
            $this->next_cycle->CurrentValue = UnFormatDateTime($this->next_cycle->CurrentValue, $this->next_cycle->formatPattern());
        }

        // Check field name 'delay' first before field var 'x_delay'
        $val = $CurrentForm->hasValue("delay") ? $CurrentForm->getValue("delay") : $CurrentForm->getValue("x_delay");
        if (!$this->delay->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delay->Visible = false; // Disable update for API request
            } else {
                $this->delay->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'delay_method' first before field var 'x_delay_method'
        $val = $CurrentForm->hasValue("delay_method") ? $CurrentForm->getValue("delay_method") : $CurrentForm->getValue("x_delay_method");
        if (!$this->delay_method->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delay_method->Visible = false; // Disable update for API request
            } else {
                $this->delay_method->setFormValue($val);
            }
        }

        // Check field name 'last_updated' first before field var 'x_last_updated'
        $val = $CurrentForm->hasValue("last_updated") ? $CurrentForm->getValue("last_updated") : $CurrentForm->getValue("x_last_updated");
        if (!$this->last_updated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->last_updated->Visible = false; // Disable update for API request
            } else {
                $this->last_updated->setFormValue($val);
            }
        }

        // Check field name 'user_level' first before field var 'x_user_level'
        $val = $CurrentForm->hasValue("user_level") ? $CurrentForm->getValue("user_level") : $CurrentForm->getValue("x_user_level");
        if (!$this->user_level->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->user_level->Visible = false; // Disable update for API request
            } else {
                $this->user_level->setFormValue($val);
            }
        }

        // Check field name 'visible' first before field var 'x__visible'
        $val = $CurrentForm->hasValue("visible") ? $CurrentForm->getValue("visible") : $CurrentForm->getValue("x__visible");
        if (!$this->_visible->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_visible->Visible = false; // Disable update for API request
            } else {
                $this->_visible->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'order_by' first before field var 'x_order_by'
        $val = $CurrentForm->hasValue("order_by") ? $CurrentForm->getValue("order_by") : $CurrentForm->getValue("x_order_by");
        if (!$this->order_by->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->order_by->Visible = false; // Disable update for API request
            } else {
                $this->order_by->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'url' first before field var 'x_url'
        $val = $CurrentForm->hasValue("url") ? $CurrentForm->getValue("url") : $CurrentForm->getValue("x_url");
        if (!$this->url->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->url->Visible = false; // Disable update for API request
            } else {
                $this->url->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->apcid->CurrentValue = $this->apcid->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->code->CurrentValue = $this->code->FormValue;
        $this->description->CurrentValue = $this->description->FormValue;
        $this->cron->CurrentValue = $this->cron->FormValue;
        $this->next_cycle->CurrentValue = $this->next_cycle->FormValue;
        $this->next_cycle->CurrentValue = UnFormatDateTime($this->next_cycle->CurrentValue, $this->next_cycle->formatPattern());
        $this->delay->CurrentValue = $this->delay->FormValue;
        $this->delay_method->CurrentValue = $this->delay_method->FormValue;
        $this->last_updated->CurrentValue = $this->last_updated->FormValue;
        $this->user_level->CurrentValue = $this->user_level->FormValue;
        $this->_visible->CurrentValue = $this->_visible->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->status->CurrentValue = $this->status->FormValue;
        $this->order_by->CurrentValue = $this->order_by->FormValue;
        $this->url->CurrentValue = $this->url->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->apcid->setDbValue($row['apcid']);
        $this->grp->setDbValue($row['grp']);
        $this->code->setDbValue($row['code']);
        $this->description->setDbValue($row['description']);
        $this->cron->setDbValue($row['cron']);
        $this->next_cycle->setDbValue($row['next_cycle']);
        $this->delay->setDbValue($row['delay']);
        $this->delay_method->setDbValue($row['delay_method']);
        $this->last_updated->setDbValue($row['last_updated']);
        $this->user_level->setDbValue($row['user_level']);
        $this->_visible->setDbValue($row['visible']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->status->setDbValue($row['status']);
        $this->order_by->setDbValue($row['order_by']);
        $this->url->setDbValue($row['url']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['apcid'] = $this->apcid->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['description'] = $this->description->DefaultValue;
        $row['cron'] = $this->cron->DefaultValue;
        $row['next_cycle'] = $this->next_cycle->DefaultValue;
        $row['delay'] = $this->delay->DefaultValue;
        $row['delay_method'] = $this->delay_method->DefaultValue;
        $row['last_updated'] = $this->last_updated->DefaultValue;
        $row['user_level'] = $this->user_level->DefaultValue;
        $row['visible'] = $this->_visible->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['order_by'] = $this->order_by->DefaultValue;
        $row['url'] = $this->url->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // apcid
        $this->apcid->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // description
        $this->description->RowCssClass = "row";

        // cron
        $this->cron->RowCssClass = "row";

        // next_cycle
        $this->next_cycle->RowCssClass = "row";

        // delay
        $this->delay->RowCssClass = "row";

        // delay_method
        $this->delay_method->RowCssClass = "row";

        // last_updated
        $this->last_updated->RowCssClass = "row";

        // user_level
        $this->user_level->RowCssClass = "row";

        // visible
        $this->_visible->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // order_by
        $this->order_by->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // apcid
            $this->apcid->ViewValue = $this->apcid->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->grp->Lookup->renderViewRow($row);
                            $this->grp->ViewValue->add($this->grp->displayValue($arwrk));
                        }
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // cron
            if (strval($this->cron->CurrentValue) != "") {
                $this->cron->ViewValue = $this->cron->optionCaption($this->cron->CurrentValue);
            } else {
                $this->cron->ViewValue = null;
            }

            // next_cycle
            $this->next_cycle->ViewValue = $this->next_cycle->CurrentValue;
            $this->next_cycle->ViewValue = FormatDateTime($this->next_cycle->ViewValue, $this->next_cycle->formatPattern());

            // delay
            $this->delay->ViewValue = $this->delay->CurrentValue;

            // delay_method
            if (strval($this->delay_method->CurrentValue) != "") {
                $this->delay_method->ViewValue = $this->delay_method->optionCaption($this->delay_method->CurrentValue);
            } else {
                $this->delay_method->ViewValue = null;
            }

            // last_updated
            $this->last_updated->ViewValue = $this->last_updated->CurrentValue;

            // user_level
            $curVal = strval($this->user_level->CurrentValue);
            if ($curVal != "") {
                $this->user_level->ViewValue = $this->user_level->lookupCacheOption($curVal);
                if ($this->user_level->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->user_level->Lookup->getTable()->Fields["userlevelid"]->searchExpression(), "=", trim($wrk), $this->user_level->Lookup->getTable()->Fields["userlevelid"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->user_level->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->user_level->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->user_level->Lookup->renderViewRow($row);
                            $this->user_level->ViewValue->add($this->user_level->displayValue($arwrk));
                        }
                    } else {
                        $this->user_level->ViewValue = $this->user_level->CurrentValue;
                    }
                }
            } else {
                $this->user_level->ViewValue = null;
            }

            // visible
            if (strval($this->_visible->CurrentValue) != "") {
                $this->_visible->ViewValue = $this->_visible->optionCaption($this->_visible->CurrentValue);
            } else {
                $this->_visible->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // order_by
            $this->order_by->ViewValue = $this->order_by->CurrentValue;
            $this->order_by->ViewValue = FormatNumber($this->order_by->ViewValue, $this->order_by->formatPattern());

            // url
            $this->url->ViewValue = $this->url->CurrentValue;

            // apcid
            $this->apcid->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // description
            if (!EmptyValue($this->id->CurrentValue)) {
                $this->description->HrefValue = $this->description->getLinkPrefix() . $this->id->CurrentValue; // Add prefix/suffix
                $this->description->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
                }
            } else {
                $this->description->HrefValue = "";
            }

            // cron
            $this->cron->HrefValue = "";

            // next_cycle
            $this->next_cycle->HrefValue = "";

            // delay
            $this->delay->HrefValue = "";

            // delay_method
            $this->delay_method->HrefValue = "";

            // last_updated
            $this->last_updated->HrefValue = "";
            $this->last_updated->TooltipValue = "";

            // user_level
            $this->user_level->HrefValue = "";

            // visible
            $this->_visible->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // order_by
            $this->order_by->HrefValue = "";

            // url
            $this->url->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // apcid
            $this->apcid->setupEditAttributes();
            $this->apcid->EditValue = $this->apcid->CurrentValue;
            $this->apcid->PlaceHolder = RemoveHtml($this->apcid->caption());

            // grp
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // code
            $this->code->setupEditAttributes();
            $this->code->EditValue = HtmlEncode($this->code->CurrentValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // description
            $this->description->setupEditAttributes();
            if (!$this->description->Raw) {
                $this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
            }
            $this->description->EditValue = HtmlEncode($this->description->CurrentValue);
            $this->description->PlaceHolder = RemoveHtml($this->description->caption());

            // cron
            $this->cron->setupEditAttributes();
            $this->cron->EditValue = $this->cron->options(true);
            $this->cron->PlaceHolder = RemoveHtml($this->cron->caption());

            // next_cycle
            $this->next_cycle->setupEditAttributes();
            $this->next_cycle->EditValue = HtmlEncode(FormatDateTime($this->next_cycle->CurrentValue, $this->next_cycle->formatPattern()));
            $this->next_cycle->PlaceHolder = RemoveHtml($this->next_cycle->caption());

            // delay
            $this->delay->setupEditAttributes();
            $this->delay->EditValue = $this->delay->CurrentValue;
            $this->delay->PlaceHolder = RemoveHtml($this->delay->caption());
            if (strval($this->delay->EditValue) != "" && is_numeric($this->delay->EditValue)) {
                $this->delay->EditValue = $this->delay->EditValue;
            }

            // delay_method
            $this->delay_method->setupEditAttributes();
            $this->delay_method->EditValue = $this->delay_method->options(true);
            $this->delay_method->PlaceHolder = RemoveHtml($this->delay_method->caption());

            // last_updated
            $this->last_updated->setupEditAttributes();
            $this->last_updated->EditValue = $this->last_updated->CurrentValue;

            // user_level
            $curVal = trim(strval($this->user_level->CurrentValue));
            if ($curVal != "") {
                $this->user_level->ViewValue = $this->user_level->lookupCacheOption($curVal);
            } else {
                $this->user_level->ViewValue = $this->user_level->Lookup !== null && is_array($this->user_level->lookupOptions()) && count($this->user_level->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->user_level->ViewValue !== null) { // Load from cache
                $this->user_level->EditValue = array_values($this->user_level->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->user_level->Lookup->getTable()->Fields["userlevelid"]->searchExpression(), "=", trim($wrk), $this->user_level->Lookup->getTable()->Fields["userlevelid"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->user_level->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->user_level->EditValue = $arwrk;
            }
            $this->user_level->PlaceHolder = RemoveHtml($this->user_level->caption());

            // visible
            $this->_visible->setupEditAttributes();
            $this->_visible->EditValue = $this->_visible->options(true);
            $this->_visible->PlaceHolder = RemoveHtml($this->_visible->caption());

            // operator

            // datetime

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // order_by
            $this->order_by->setupEditAttributes();
            $this->order_by->EditValue = $this->order_by->CurrentValue;
            $this->order_by->PlaceHolder = RemoveHtml($this->order_by->caption());
            if (strval($this->order_by->EditValue) != "" && is_numeric($this->order_by->EditValue)) {
                $this->order_by->EditValue = FormatNumber($this->order_by->EditValue, null);
            }

            // url
            $this->url->setupEditAttributes();
            if (!$this->url->Raw) {
                $this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
            }
            $this->url->EditValue = HtmlEncode($this->url->CurrentValue);
            $this->url->PlaceHolder = RemoveHtml($this->url->caption());

            // Edit refer script

            // apcid
            $this->apcid->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // description
            if (!EmptyValue($this->id->CurrentValue)) {
                $this->description->HrefValue = $this->description->getLinkPrefix() . $this->id->CurrentValue; // Add prefix/suffix
                $this->description->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
                }
            } else {
                $this->description->HrefValue = "";
            }

            // cron
            $this->cron->HrefValue = "";

            // next_cycle
            $this->next_cycle->HrefValue = "";

            // delay
            $this->delay->HrefValue = "";

            // delay_method
            $this->delay_method->HrefValue = "";

            // last_updated
            $this->last_updated->HrefValue = "";
            $this->last_updated->TooltipValue = "";

            // user_level
            $this->user_level->HrefValue = "";

            // visible
            $this->_visible->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // order_by
            $this->order_by->HrefValue = "";

            // url
            $this->url->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->apcid->Visible && $this->apcid->Required) {
                if (!$this->apcid->IsDetailKey && EmptyValue($this->apcid->FormValue)) {
                    $this->apcid->addErrorMessage(str_replace("%s", $this->apcid->caption(), $this->apcid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->apcid->FormValue)) {
                $this->apcid->addErrorMessage($this->apcid->getErrorMessage(false));
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if ($this->grp->FormValue == "") {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->code->Visible && $this->code->Required) {
                if (!$this->code->IsDetailKey && EmptyValue($this->code->FormValue)) {
                    $this->code->addErrorMessage(str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
                }
            }
            if ($this->description->Visible && $this->description->Required) {
                if (!$this->description->IsDetailKey && EmptyValue($this->description->FormValue)) {
                    $this->description->addErrorMessage(str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
                }
            }
            if ($this->cron->Visible && $this->cron->Required) {
                if (!$this->cron->IsDetailKey && EmptyValue($this->cron->FormValue)) {
                    $this->cron->addErrorMessage(str_replace("%s", $this->cron->caption(), $this->cron->RequiredErrorMessage));
                }
            }
            if ($this->next_cycle->Visible && $this->next_cycle->Required) {
                if (!$this->next_cycle->IsDetailKey && EmptyValue($this->next_cycle->FormValue)) {
                    $this->next_cycle->addErrorMessage(str_replace("%s", $this->next_cycle->caption(), $this->next_cycle->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->next_cycle->FormValue, $this->next_cycle->formatPattern())) {
                $this->next_cycle->addErrorMessage($this->next_cycle->getErrorMessage(false));
            }
            if ($this->delay->Visible && $this->delay->Required) {
                if (!$this->delay->IsDetailKey && EmptyValue($this->delay->FormValue)) {
                    $this->delay->addErrorMessage(str_replace("%s", $this->delay->caption(), $this->delay->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->delay->FormValue)) {
                $this->delay->addErrorMessage($this->delay->getErrorMessage(false));
            }
            if ($this->delay_method->Visible && $this->delay_method->Required) {
                if (!$this->delay_method->IsDetailKey && EmptyValue($this->delay_method->FormValue)) {
                    $this->delay_method->addErrorMessage(str_replace("%s", $this->delay_method->caption(), $this->delay_method->RequiredErrorMessage));
                }
            }
            if ($this->last_updated->Visible && $this->last_updated->Required) {
                if (!$this->last_updated->IsDetailKey && EmptyValue($this->last_updated->FormValue)) {
                    $this->last_updated->addErrorMessage(str_replace("%s", $this->last_updated->caption(), $this->last_updated->RequiredErrorMessage));
                }
            }
            if ($this->user_level->Visible && $this->user_level->Required) {
                if ($this->user_level->FormValue == "") {
                    $this->user_level->addErrorMessage(str_replace("%s", $this->user_level->caption(), $this->user_level->RequiredErrorMessage));
                }
            }
            if ($this->_visible->Visible && $this->_visible->Required) {
                if (!$this->_visible->IsDetailKey && EmptyValue($this->_visible->FormValue)) {
                    $this->_visible->addErrorMessage(str_replace("%s", $this->_visible->caption(), $this->_visible->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->order_by->Visible && $this->order_by->Required) {
                if (!$this->order_by->IsDetailKey && EmptyValue($this->order_by->FormValue)) {
                    $this->order_by->addErrorMessage(str_replace("%s", $this->order_by->caption(), $this->order_by->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->order_by->FormValue)) {
                $this->order_by->addErrorMessage($this->order_by->getErrorMessage(false));
            }
            if ($this->url->Visible && $this->url->Required) {
                if (!$this->url->IsDetailKey && EmptyValue($this->url->FormValue)) {
                    $this->url->addErrorMessage(str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (apcid)
        if ($this->apcid->CurrentValue != "") {
            $filterChk = "(`apcid` = " . AdjustSql($this->apcid->CurrentValue, $this->Dbid) . ")";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->apcid->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->apcid->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);

        // Check for duplicate key when key changed
        if ($updateRow) {
            $newKeyFilter = $this->getRecordFilter($rsnew);
            if ($newKeyFilter != $oldKeyFilter) {
                $rsChk = $this->loadRs($newKeyFilter)->fetch();
                if ($rsChk !== false) {
                    $keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
                    $this->setFailureMessage($keyErrMsg);
                    $updateRow = false;
                }
            }
        }
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // apcid
        $this->apcid->setDbValueDef($rsnew, $this->apcid->CurrentValue, $this->apcid->ReadOnly);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, $this->grp->ReadOnly);

        // code
        $this->code->setDbValueDef($rsnew, $this->code->CurrentValue, $this->code->ReadOnly);

        // description
        $this->description->setDbValueDef($rsnew, $this->description->CurrentValue, $this->description->ReadOnly);

        // cron
        $this->cron->setDbValueDef($rsnew, $this->cron->CurrentValue, $this->cron->ReadOnly);

        // next_cycle
        $this->next_cycle->setDbValueDef($rsnew, UnFormatDateTime($this->next_cycle->CurrentValue, $this->next_cycle->formatPattern()), $this->next_cycle->ReadOnly);

        // delay
        $this->delay->setDbValueDef($rsnew, $this->delay->CurrentValue, $this->delay->ReadOnly);

        // delay_method
        $this->delay_method->setDbValueDef($rsnew, $this->delay_method->CurrentValue, $this->delay_method->ReadOnly);

        // user_level
        $this->user_level->setDbValueDef($rsnew, $this->user_level->CurrentValue, $this->user_level->ReadOnly);

        // visible
        $this->_visible->setDbValueDef($rsnew, $this->_visible->CurrentValue, $this->_visible->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly);

        // order_by
        $this->order_by->setDbValueDef($rsnew, $this->order_by->CurrentValue, $this->order_by->ReadOnly);

        // url
        $this->url->setDbValueDef($rsnew, $this->url->CurrentValue, $this->url->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['apcid'])) { // apcid
            $this->apcid->CurrentValue = $row['apcid'];
        }
        if (isset($row['grp'])) { // grp
            $this->grp->CurrentValue = $row['grp'];
        }
        if (isset($row['code'])) { // code
            $this->code->CurrentValue = $row['code'];
        }
        if (isset($row['description'])) { // description
            $this->description->CurrentValue = $row['description'];
        }
        if (isset($row['cron'])) { // cron
            $this->cron->CurrentValue = $row['cron'];
        }
        if (isset($row['next_cycle'])) { // next_cycle
            $this->next_cycle->CurrentValue = $row['next_cycle'];
        }
        if (isset($row['delay'])) { // delay
            $this->delay->CurrentValue = $row['delay'];
        }
        if (isset($row['delay_method'])) { // delay_method
            $this->delay_method->CurrentValue = $row['delay_method'];
        }
        if (isset($row['user_level'])) { // user_level
            $this->user_level->CurrentValue = $row['user_level'];
        }
        if (isset($row['visible'])) { // visible
            $this->_visible->CurrentValue = $row['visible'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['order_by'])) { // order_by
            $this->order_by->CurrentValue = $row['order_by'];
        }
        if (isset($row['url'])) { // url
            $this->url->CurrentValue = $row['url'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("apclist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cron":
                    break;
                case "x_delay_method":
                    break;
                case "x_user_level":
                    break;
                case "x__visible":
                    break;
                case "x_operator":
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
