<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class AdminAdd extends Admin
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "AdminAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "adminadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->mobile->setVisibility();
        $this->formal_name->setVisibility();
        $this->_password->setVisibility();
        $this->user_name->setVisibility();
        $this->address->setVisibility();
        $this->category->setVisibility();
        $this->_email->setVisibility();
        $this->company_id->setVisibility();
        $this->pp_id->setVisibility();
        $this->site->setVisibility();
        $this->reports_to->setVisibility();
        $this->_userlevel->setVisibility();
        $this->activated->setVisibility();
        $this->_profile->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->reg_ip->setVisibility();
        $this->profile_old->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'admin';
        $this->TableName = 'admin';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (admin)
        if (!isset($GLOBALS["admin"]) || $GLOBALS["admin"]::class == PROJECT_NAMESPACE . "admin") {
            $GLOBALS["admin"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'admin');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "adminview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->pp_id);
        $this->setupLookupOptions($this->site);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->_userlevel);
        $this->setupLookupOptions($this->activated);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("adminlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "adminlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "adminview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "adminlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "adminlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->company_id->DefaultValue = $this->company_id->getDefault(); // PHP
        $this->company_id->OldValue = $this->company_id->DefaultValue;
        $this->_userlevel->DefaultValue = $this->_userlevel->getDefault(); // PHP
        $this->_userlevel->OldValue = $this->_userlevel->DefaultValue;
        $this->activated->DefaultValue = $this->activated->getDefault(); // PHP
        $this->activated->OldValue = $this->activated->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val);
            }
        }

        // Check field name 'formal_name' first before field var 'x_formal_name'
        $val = $CurrentForm->hasValue("formal_name") ? $CurrentForm->getValue("formal_name") : $CurrentForm->getValue("x_formal_name");
        if (!$this->formal_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->formal_name->Visible = false; // Disable update for API request
            } else {
                $this->formal_name->setFormValue($val);
            }
        }

        // Check field name 'password' first before field var 'x__password'
        $val = $CurrentForm->hasValue("password") ? $CurrentForm->getValue("password") : $CurrentForm->getValue("x__password");
        if (!$this->_password->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_password->Visible = false; // Disable update for API request
            } else {
                $this->_password->setFormValue($val);
            }
        }

        // Check field name 'user_name' first before field var 'x_user_name'
        $val = $CurrentForm->hasValue("user_name") ? $CurrentForm->getValue("user_name") : $CurrentForm->getValue("x_user_name");
        if (!$this->user_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->user_name->Visible = false; // Disable update for API request
            } else {
                $this->user_name->setFormValue($val);
            }
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }

        // Check field name 'category' first before field var 'x_category'
        $val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
        if (!$this->category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->category->Visible = false; // Disable update for API request
            } else {
                $this->category->setFormValue($val);
            }
        }

        // Check field name 'email' first before field var 'x__email'
        $val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
        if (!$this->_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_email->Visible = false; // Disable update for API request
            } else {
                $this->_email->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'pp_id' first before field var 'x_pp_id'
        $val = $CurrentForm->hasValue("pp_id") ? $CurrentForm->getValue("pp_id") : $CurrentForm->getValue("x_pp_id");
        if (!$this->pp_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pp_id->Visible = false; // Disable update for API request
            } else {
                $this->pp_id->setFormValue($val);
            }
        }

        // Check field name 'site' first before field var 'x_site'
        $val = $CurrentForm->hasValue("site") ? $CurrentForm->getValue("site") : $CurrentForm->getValue("x_site");
        if (!$this->site->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->site->Visible = false; // Disable update for API request
            } else {
                $this->site->setFormValue($val);
            }
        }

        // Check field name 'reports_to' first before field var 'x_reports_to'
        $val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
        if (!$this->reports_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reports_to->Visible = false; // Disable update for API request
            } else {
                $this->reports_to->setFormValue($val);
            }
        }

        // Check field name 'userlevel' first before field var 'x__userlevel'
        $val = $CurrentForm->hasValue("userlevel") ? $CurrentForm->getValue("userlevel") : $CurrentForm->getValue("x__userlevel");
        if (!$this->_userlevel->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_userlevel->Visible = false; // Disable update for API request
            } else {
                $this->_userlevel->setFormValue($val);
            }
        }

        // Check field name 'activated' first before field var 'x_activated'
        $val = $CurrentForm->hasValue("activated") ? $CurrentForm->getValue("activated") : $CurrentForm->getValue("x_activated");
        if (!$this->activated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->activated->Visible = false; // Disable update for API request
            } else {
                $this->activated->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'reg_ip' first before field var 'x_reg_ip'
        $val = $CurrentForm->hasValue("reg_ip") ? $CurrentForm->getValue("reg_ip") : $CurrentForm->getValue("x_reg_ip");
        if (!$this->reg_ip->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reg_ip->Visible = false; // Disable update for API request
            } else {
                $this->reg_ip->setFormValue($val);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->formal_name->CurrentValue = $this->formal_name->FormValue;
        $this->_password->CurrentValue = $this->_password->FormValue;
        $this->user_name->CurrentValue = $this->user_name->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->category->CurrentValue = $this->category->FormValue;
        $this->_email->CurrentValue = $this->_email->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->pp_id->CurrentValue = $this->pp_id->FormValue;
        $this->site->CurrentValue = $this->site->FormValue;
        $this->reports_to->CurrentValue = $this->reports_to->FormValue;
        $this->_userlevel->CurrentValue = $this->_userlevel->FormValue;
        $this->activated->CurrentValue = $this->activated->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->reg_ip->CurrentValue = $this->reg_ip->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }

        // Check if valid User ID
        if ($res) {
            $res = $this->showOptionLink("add");
            if (!$res) {
                $userIdMsg = DeniedMessage();
                $this->setFailureMessage($userIdMsg);
            }
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->mobile->setDbValue($row['mobile']);
        $this->formal_name->setDbValue($row['formal_name']);
        $this->_password->setDbValue($row['password']);
        $this->user_name->setDbValue($row['user_name']);
        $this->address->setDbValue($row['address']);
        $this->category->setDbValue($row['category']);
        $this->_email->setDbValue($row['email']);
        $this->company_id->setDbValue($row['company_id']);
        $this->pp_id->setDbValue($row['pp_id']);
        $this->site->setDbValue($row['site']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->_userlevel->setDbValue($row['userlevel']);
        $this->activated->setDbValue($row['activated']);
        $this->_profile->setDbValue($row['profile']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->reg_ip->setDbValue($row['reg_ip']);
        $this->profile_old->setDbValue($row['profile_old']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['formal_name'] = $this->formal_name->DefaultValue;
        $row['password'] = $this->_password->DefaultValue;
        $row['user_name'] = $this->user_name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['pp_id'] = $this->pp_id->DefaultValue;
        $row['site'] = $this->site->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['userlevel'] = $this->_userlevel->DefaultValue;
        $row['activated'] = $this->activated->DefaultValue;
        $row['profile'] = $this->_profile->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['reg_ip'] = $this->reg_ip->DefaultValue;
        $row['profile_old'] = $this->profile_old->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // formal_name
        $this->formal_name->RowCssClass = "row";

        // password
        $this->_password->RowCssClass = "row";

        // user_name
        $this->user_name->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // pp_id
        $this->pp_id->RowCssClass = "row";

        // site
        $this->site->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // userlevel
        $this->_userlevel->RowCssClass = "row";

        // activated
        $this->activated->RowCssClass = "row";

        // profile
        $this->_profile->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // reg_ip
        $this->reg_ip->RowCssClass = "row";

        // profile_old
        $this->profile_old->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // formal_name
            $this->formal_name->ViewValue = $this->formal_name->CurrentValue;

            // password
            $this->_password->ViewValue = $Language->phrase("PasswordMask");

            // user_name
            $this->user_name->ViewValue = $this->user_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = $this->company_id->CurrentValue;
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // pp_id
            $curVal = strval($this->pp_id->CurrentValue);
            if ($curVal != "") {
                $this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
                if ($this->pp_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->pp_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pp_id->Lookup->renderViewRow($rswrk[0]);
                        $this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
                    } else {
                        $this->pp_id->ViewValue = $this->pp_id->CurrentValue;
                    }
                }
            } else {
                $this->pp_id->ViewValue = null;
            }

            // site
            $curVal = strval($this->site->CurrentValue);
            if ($curVal != "") {
                $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
                if ($this->site->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->site->getSelectFilter($this); // PHP
                    $sqlWrk = $this->site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->site->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->site->Lookup->renderViewRow($row);
                            $this->site->ViewValue->add($this->site->displayValue($arwrk));
                        }
                    } else {
                        $this->site->ViewValue = $this->site->CurrentValue;
                    }
                }
            } else {
                $this->site->ViewValue = null;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = $this->reports_to->CurrentValue;
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // userlevel
            if ($Security->canAdmin()) { // System admin
                $curVal = strval($this->_userlevel->CurrentValue);
                if ($curVal != "") {
                    $this->_userlevel->ViewValue = $this->_userlevel->lookupCacheOption($curVal);
                    if ($this->_userlevel->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->_userlevel->Lookup->getTable()->Fields["userlevelid"]->searchExpression(), "=", $curVal, $this->_userlevel->Lookup->getTable()->Fields["userlevelid"]->searchDataType(), "");
                        $lookupFilter = $this->_userlevel->getSelectFilter($this); // PHP
                        $sqlWrk = $this->_userlevel->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->_userlevel->Lookup->renderViewRow($rswrk[0]);
                            $this->_userlevel->ViewValue = $this->_userlevel->displayValue($arwrk);
                        } else {
                            $this->_userlevel->ViewValue = $this->_userlevel->CurrentValue;
                        }
                    }
                } else {
                    $this->_userlevel->ViewValue = null;
                }
            } else {
                $this->_userlevel->ViewValue = $Language->phrase("PasswordMask");
            }

            // activated
            if (strval($this->activated->CurrentValue) != "") {
                $this->activated->ViewValue = $this->activated->optionCaption($this->activated->CurrentValue);
            } else {
                $this->activated->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // reg_ip
            $this->reg_ip->ViewValue = $this->reg_ip->CurrentValue;

            // mobile
            $this->mobile->HrefValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";

            // password
            $this->_password->HrefValue = "";

            // user_name
            $this->user_name->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // pp_id
            $this->pp_id->HrefValue = "";

            // site
            $this->site->HrefValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";

            // userlevel
            $this->_userlevel->HrefValue = "";

            // activated
            $this->activated->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // reg_ip
            $this->reg_ip->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->CurrentValue;
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());
            if (strval($this->mobile->EditValue) != "" && is_numeric($this->mobile->EditValue)) {
                $this->mobile->EditValue = $this->mobile->EditValue;
            }

            // formal_name
            $this->formal_name->setupEditAttributes();
            if (!$this->formal_name->Raw) {
                $this->formal_name->CurrentValue = HtmlDecode($this->formal_name->CurrentValue);
            }
            $this->formal_name->EditValue = HtmlEncode($this->formal_name->CurrentValue);
            $this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

            // password
            $this->_password->setupEditAttributes(["class" => "ew-password-strength"]);
            $this->_password->PlaceHolder = RemoveHtml($this->_password->caption());

            // user_name
            $this->user_name->setupEditAttributes();
            if (!$this->user_name->Raw) {
                $this->user_name->CurrentValue = HtmlDecode($this->user_name->CurrentValue);
            }
            $this->user_name->EditValue = HtmlEncode($this->user_name->CurrentValue);
            $this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->CurrentValue));
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->CurrentValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // company_id
            $curVal = trim(strval($this->company_id->CurrentValue));
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
                if ($this->company_id->ViewValue == "") {
                    $this->company_id->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->CurrentValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // pp_id
            $this->pp_id->setupEditAttributes();
            $curVal = trim(strval($this->pp_id->CurrentValue));
            if ($curVal != "") {
                $this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
            } else {
                $this->pp_id->ViewValue = $this->pp_id->Lookup !== null && is_array($this->pp_id->lookupOptions()) && count($this->pp_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pp_id->ViewValue !== null) { // Load from cache
                $this->pp_id->EditValue = array_values($this->pp_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pp_id->CurrentValue, $this->pp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->pp_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pp_id->EditValue = $arwrk;
            }
            $this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

            // site
            $curVal = trim(strval($this->site->CurrentValue));
            if ($curVal != "") {
                $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
            } else {
                $this->site->ViewValue = $this->site->Lookup !== null && is_array($this->site->lookupOptions()) && count($this->site->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->site->ViewValue !== null) { // Load from cache
                $this->site->EditValue = array_values($this->site->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->site->getSelectFilter($this); // PHP
                $sqlWrk = $this->site->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->site->EditValue = $arwrk;
            }
            $this->site->PlaceHolder = RemoveHtml($this->site->caption());

            // reports_to
            $this->reports_to->setupEditAttributes();
            if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin
                if (trim(strval($this->reports_to->CurrentValue)) == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->reports_to->CurrentValue, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll();
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            } else {
                $curVal = trim(strval($this->reports_to->CurrentValue));
                if ($curVal != "") {
                    $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                } else {
                    $this->reports_to->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->reports_to->ViewValue !== null) { // Load from cache
                    $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->reports_to->CurrentValue, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->reports_to->EditValue = $arwrk;
                }
                $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());
            }

            // userlevel
            $this->_userlevel->setupEditAttributes();
            if (!$Security->canAdmin()) { // System admin
                $this->_userlevel->EditValue = $Language->phrase("PasswordMask");
            } else {
                $curVal = trim(strval($this->_userlevel->CurrentValue));
                if ($curVal != "") {
                    $this->_userlevel->ViewValue = $this->_userlevel->lookupCacheOption($curVal);
                } else {
                    $this->_userlevel->ViewValue = $this->_userlevel->Lookup !== null && is_array($this->_userlevel->lookupOptions()) && count($this->_userlevel->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->_userlevel->ViewValue !== null) { // Load from cache
                    $this->_userlevel->EditValue = array_values($this->_userlevel->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->_userlevel->Lookup->getTable()->Fields["userlevelid"]->searchExpression(), "=", $this->_userlevel->CurrentValue, $this->_userlevel->Lookup->getTable()->Fields["userlevelid"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->_userlevel->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_userlevel->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->_userlevel->EditValue = $arwrk;
                }
                $this->_userlevel->PlaceHolder = RemoveHtml($this->_userlevel->caption());
            }

            // activated
            $this->activated->setupEditAttributes();
            $this->activated->EditValue = $this->activated->options(true);
            $this->activated->PlaceHolder = RemoveHtml($this->activated->caption());

            // operator

            // datetime

            // reg_ip

            // Add refer script

            // mobile
            $this->mobile->HrefValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";

            // password
            $this->_password->HrefValue = "";

            // user_name
            $this->user_name->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // pp_id
            $this->pp_id->HrefValue = "";

            // site
            $this->site->HrefValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";

            // userlevel
            $this->_userlevel->HrefValue = "";

            // activated
            $this->activated->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // reg_ip
            $this->reg_ip->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->formal_name->Visible && $this->formal_name->Required) {
                if (!$this->formal_name->IsDetailKey && EmptyValue($this->formal_name->FormValue)) {
                    $this->formal_name->addErrorMessage(str_replace("%s", $this->formal_name->caption(), $this->formal_name->RequiredErrorMessage));
                }
            }
            if ($this->_password->Visible && $this->_password->Required) {
                if (!$this->_password->IsDetailKey && EmptyValue($this->_password->FormValue)) {
                    $this->_password->addErrorMessage(str_replace("%s", $this->_password->caption(), $this->_password->RequiredErrorMessage));
                }
            }
            if (!$this->_password->Raw && Config("REMOVE_XSS") && CheckPassword($this->_password->FormValue)) {
                $this->_password->addErrorMessage($Language->phrase("InvalidPasswordChars"));
            }
            if ($this->user_name->Visible && $this->user_name->Required) {
                if (!$this->user_name->IsDetailKey && EmptyValue($this->user_name->FormValue)) {
                    $this->user_name->addErrorMessage(str_replace("%s", $this->user_name->caption(), $this->user_name->RequiredErrorMessage));
                }
            }
            if (!$this->user_name->Raw && Config("REMOVE_XSS") && CheckUsername($this->user_name->FormValue)) {
                $this->user_name->addErrorMessage($Language->phrase("InvalidUsernameChars"));
            }
            if ($this->address->Visible && $this->address->Required) {
                if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->category->Visible && $this->category->Required) {
                if (!$this->category->IsDetailKey && EmptyValue($this->category->FormValue)) {
                    $this->category->addErrorMessage(str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
                }
            }
            if ($this->_email->Visible && $this->_email->Required) {
                if (!$this->_email->IsDetailKey && EmptyValue($this->_email->FormValue)) {
                    $this->_email->addErrorMessage(str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
                }
            }
            if (!CheckEmail($this->_email->FormValue)) {
                $this->_email->addErrorMessage($this->_email->getErrorMessage(false));
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->pp_id->Visible && $this->pp_id->Required) {
                if (!$this->pp_id->IsDetailKey && EmptyValue($this->pp_id->FormValue)) {
                    $this->pp_id->addErrorMessage(str_replace("%s", $this->pp_id->caption(), $this->pp_id->RequiredErrorMessage));
                }
            }
            if ($this->site->Visible && $this->site->Required) {
                if ($this->site->FormValue == "") {
                    $this->site->addErrorMessage(str_replace("%s", $this->site->caption(), $this->site->RequiredErrorMessage));
                }
            }
            if ($this->reports_to->Visible && $this->reports_to->Required) {
                if (!$this->reports_to->IsDetailKey && EmptyValue($this->reports_to->FormValue)) {
                    $this->reports_to->addErrorMessage(str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
                }
            }
            if ($this->_userlevel->Visible && $this->_userlevel->Required) {
                if ($Security->canAdmin() && !$this->_userlevel->IsDetailKey && EmptyValue($this->_userlevel->FormValue)) {
                    $this->_userlevel->addErrorMessage(str_replace("%s", $this->_userlevel->caption(), $this->_userlevel->RequiredErrorMessage));
                }
            }
            if ($this->activated->Visible && $this->activated->Required) {
                if (!$this->activated->IsDetailKey && EmptyValue($this->activated->FormValue)) {
                    $this->activated->addErrorMessage(str_replace("%s", $this->activated->caption(), $this->activated->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->reg_ip->Visible && $this->reg_ip->Required) {
                if (!$this->reg_ip->IsDetailKey && EmptyValue($this->reg_ip->FormValue)) {
                    $this->reg_ip->addErrorMessage(str_replace("%s", $this->reg_ip->caption(), $this->reg_ip->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check if valid User ID
        if (
            !EmptyValue($Security->currentUserID()) &&
            !$Security->isAdmin() && // Non system admin
            !$Security->isValidUserID($this->id->CurrentValue)
        ) {
            $userIdMsg = str_replace("%c", CurrentUserID(), $Language->phrase("UnAuthorizedUserID"));
            $userIdMsg = str_replace("%u", strval($this->id->CurrentValue), $userIdMsg);
            $this->setFailureMessage($userIdMsg);
            return false;
        }

        // Check if valid Parent User ID
        if (
            !EmptyValue($Security->currentUserID()) &&
            !EmptyValue($this->reports_to->CurrentValue) && // Allow empty value
            !$Security->isAdmin() && // Non system admin
            !$Security->isValidUserID($this->reports_to->CurrentValue)
        ) {
            $parentUserIdMsg = str_replace("%c", CurrentUserID(), $Language->phrase("UnAuthorizedParentUserID"));
            $parentUserIdMsg = str_replace("%p", strval($this->reports_to->CurrentValue), $parentUserIdMsg);
            $this->setFailureMessage($parentUserIdMsg);
            return false;
        }
        if ($this->user_name->CurrentValue != "") { // Check field with unique index
            $filter = "(`user_name` = '" . AdjustSql($this->user_name->CurrentValue, $this->Dbid) . "')";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->user_name->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->user_name->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, false);

        // formal_name
        $this->formal_name->setDbValueDef($rsnew, $this->formal_name->CurrentValue, false);

        // password
        if (!IsMaskedPassword($this->_password->CurrentValue)) {
            $this->_password->setDbValueDef($rsnew, $this->_password->CurrentValue, false);
        }

        // user_name
        $this->user_name->setDbValueDef($rsnew, $this->user_name->CurrentValue, false);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, false);

        // category
        $this->category->setDbValueDef($rsnew, $this->category->CurrentValue, false);

        // email
        $this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, false);

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, false);

        // pp_id
        $this->pp_id->setDbValueDef($rsnew, $this->pp_id->CurrentValue, strval($this->pp_id->CurrentValue) == "");

        // site
        $this->site->setDbValueDef($rsnew, $this->site->CurrentValue, strval($this->site->CurrentValue) == "");

        // reports_to
        $this->reports_to->setDbValueDef($rsnew, $this->reports_to->CurrentValue, strval($this->reports_to->CurrentValue) == "");

        // userlevel
        if ($Security->canAdmin()) { // System admin
            $this->_userlevel->setDbValueDef($rsnew, $this->_userlevel->CurrentValue, strval($this->_userlevel->CurrentValue) == "");
        }

        // activated
        $this->activated->setDbValueDef($rsnew, $this->activated->CurrentValue, strval($this->activated->CurrentValue) == "");

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // reg_ip
        $this->reg_ip->CurrentValue = $this->reg_ip->getAutoUpdateValue(); // PHP
        $this->reg_ip->setDbValueDef($rsnew, $this->reg_ip->CurrentValue, false);

        // id
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['mobile'])) { // mobile
            $this->mobile->setFormValue($row['mobile']);
        }
        if (isset($row['formal_name'])) { // formal_name
            $this->formal_name->setFormValue($row['formal_name']);
        }
        if (isset($row['password'])) { // password
            $this->_password->setFormValue($row['password']);
        }
        if (isset($row['user_name'])) { // user_name
            $this->user_name->setFormValue($row['user_name']);
        }
        if (isset($row['address'])) { // address
            $this->address->setFormValue($row['address']);
        }
        if (isset($row['category'])) { // category
            $this->category->setFormValue($row['category']);
        }
        if (isset($row['email'])) { // email
            $this->_email->setFormValue($row['email']);
        }
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
        if (isset($row['pp_id'])) { // pp_id
            $this->pp_id->setFormValue($row['pp_id']);
        }
        if (isset($row['site'])) { // site
            $this->site->setFormValue($row['site']);
        }
        if (isset($row['reports_to'])) { // reports_to
            $this->reports_to->setFormValue($row['reports_to']);
        }
        if (isset($row['userlevel'])) { // userlevel
            $this->_userlevel->setFormValue($row['userlevel']);
        }
        if (isset($row['activated'])) { // activated
            $this->activated->setFormValue($row['activated']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['reg_ip'])) { // reg_ip
            $this->reg_ip->setFormValue($row['reg_ip']);
        }
        if (isset($row['id'])) { // id
            $this->id->setFormValue($row['id']);
        }
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->id->CurrentValue);
        }
        return true;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("adminlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pp_id":
                    break;
                case "x_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__userlevel":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_activated":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
