/*!
  * Tempus Dominus v6.9.4 (https://getdatepicker.com/)
  * Copyright 2013-2023 Jonathan Peterson
  * Licensed under MIT (https://github.com/Eonasdan/tempus-dominus/blob/master/LICENSE)
  */
var tempusDominus=function(e,t){"use strict";function s(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}function i(e){if(e&&e.__esModule)return e;var t=Object.create(null);return e&&Object.keys(e).forEach((function(s){if("default"!==s){var i=Object.getOwnPropertyDescriptor(e,s);Object.defineProperty(t,s,i.get?i:{enumerable:!0,get:function(){return e[s]}})}})),t.default=e,t}var a=s(e),o=i(t);class TdError extends Error{}const n="tempus-dominus";class Namespace{}Namespace.NAME=n,Namespace.dataKey="td",Namespace.events=new class Events{constructor(){this.key=".td",this.change=`change${this.key}`,this.update=`update${this.key}`,this.error=`error${this.key}`,this.show=`show${this.key}`,this.hide=`hide${this.key}`,this.blur=`blur${this.key}`,this.focus=`focus${this.key}`,this.keyup=`keyup${this.key}`,this.keydown=`keydown${this.key}`}},Namespace.css=new class Css{constructor(){this.widget=`${n}-widget`,this.calendarHeader="calendar-header",this.switch="picker-switch",this.toolbar="toolbar",this.noHighlight="no-highlight",this.sideBySide="timepicker-sbs",this.previous="previous",this.next="next",this.disabled="disabled",this.old="old",this.new="new",this.active="active",this.dateContainer="date-container",this.decadesContainer=`${this.dateContainer}-decades`,this.decade="decade",this.yearsContainer=`${this.dateContainer}-years`,this.year="year",this.monthsContainer=`${this.dateContainer}-months`,this.month="month",this.daysContainer=`${this.dateContainer}-days`,this.day="day",this.calendarWeeks="cw",this.dayOfTheWeek="dow",this.today="today",this.weekend="weekend",this.rangeIn="range-in",this.rangeStart="range-start",this.rangeEnd="range-end",this.timeContainer="time-container",this.separator="separator",this.clockContainer=`${this.timeContainer}-clock`,this.hourContainer=`${this.timeContainer}-hour`,this.minuteContainer=`${this.timeContainer}-minute`,this.secondContainer=`${this.timeContainer}-second`,this.hour="hour",this.minute="minute",this.second="second",this.toggleMeridiem="toggleMeridiem",this.show="show",this.collapsing="td-collapsing",this.collapse="td-collapse",this.inline="inline",this.lightTheme="light",this.darkTheme="dark",this.isDarkPreferredQuery="(prefers-color-scheme: dark)"}},Namespace.errorMessages=new class ErrorMessages{constructor(){this.base="TD:",this.failedToSetInvalidDate="Failed to set invalid date",this.failedToParseInput="Failed parse input field"}unexpectedOption(e){const t=new TdError(`${this.base} Unexpected option: ${e} does not match a known option.`);throw t.code=1,t}unexpectedOptions(e){const t=new TdError(`${this.base}: ${e.join(", ")}`);throw t.code=1,t}unexpectedOptionValue(e,t,s){const i=new TdError(`${this.base} Unexpected option value: ${e} does not accept a value of "${t}". Valid values are: ${s.join(", ")}`);throw i.code=2,i}typeMismatch(e,t,s){const i=new TdError(`${this.base} Mismatch types: ${e} has a type of ${t} instead of the required ${s}`);throw i.code=3,i}numbersOutOfRange(e,t,s){const i=new TdError(`${this.base} ${e} expected an array of number between ${t} and ${s}.`);throw i.code=4,i}failedToParseDate(e,t,s=!1){const i=new TdError(`${this.base} Could not correctly parse "${t}" to a date for ${e}.`);if(i.code=5,!s)throw i;console.warn(i)}mustProvideElement(){const e=new TdError(`${this.base} No element was provided.`);throw e.code=6,e}subscribeMismatch(){const e=new TdError(`${this.base} The subscribed events does not match the number of callbacks`);throw e.code=7,e}conflictingConfiguration(e){const t=new TdError(`${this.base} A configuration value conflicts with another rule. ${e}`);throw t.code=8,t}customDateFormatError(e){const t=new TdError(`${this.base} Custom Date Format: ${e}`);throw t.code=9,t}dateString(){console.warn(`${this.base} Using a string for date options is not recommended unless you specify an ISO string or use the customDateFormat plugin.`)}deprecatedWarning(e,t){console.warn(`${this.base} Warning ${e} is deprecated and will be removed in a future version. ${t}`)}throwError(e){const t=new TdError(`${this.base} ${e}`);throw t.code=9,t}};var r,c={...{dateFormats:{LTS:"h:mm:ss T",LT:"h:mm T",L:"MM/dd/yyyy",LL:"MMMM d, yyyy",LLL:"MMMM d, yyyy h:mm T",LLLL:"dddd, MMMM d, yyyy h:mm T"},format:"L LT",locale:"default",hourCycle:void 0,ordinal:e=>{const t=["th","st","nd","rd"],s=e%100;return`[${e}${t[(s-20)%10]||t[s]||t[0]}]`}}};!function(e){e.seconds="seconds",e.minutes="minutes",e.hours="hours",e.date="date",e.month="month",e.year="year"}(r||(r={}));const d={month:"2-digit",day:"2-digit",year:"numeric",hour:"2-digit",minute:"2-digit",second:"2-digit"},l=e=>{switch(e){case"date":return{dateStyle:"short"};case"month":return{month:"numeric",year:"numeric"};case"year":return{year:"numeric"}}},h=e=>{if(!e)return"h12";const t={hour:"2-digit",minute:"2-digit",numberingSystem:"latn"},s=(new DateTime).setLocalization({locale:e});s.hours=0;const i=s.parts(void 0,t).hour;if("12"===i)return"h12";if("24"===i)return"h24";s.hours=23;const a=s.parts(void 0,t).hour;return"00"===i&&"11"===a?"h11":"00"===i&&"23"===a?"h23":void console.warn(`couldn't determine hour cycle for ${e}. start: ${i}. end: ${a}`)};class DateTime extends Date{constructor(){super(...arguments),this.localization=c,this.nonLeapLadder=[0,31,59,90,120,151,181,212,243,273,304,334],this.leapLadder=[0,31,60,91,121,152,182,213,244,274,305,335],this.dateTimeRegex=/(\[[^[\]]*])|y{1,4}|M{1,4}|d{1,4}|H{1,2}|h{1,2}|t|T|m{1,2}|s{1,2}|f{3}/g,this.formattingTokens=/(\[[^[\]]*])|([-_:/.,()\s]+)|(T|t|yyyy|yy?|MM?M?M?|Do|dd?d?d?|hh?|HH?|mm?|ss?)/g,this.match2=/\d\d/,this.match3=/\d{3}/,this.match4=/\d{4}/,this.match1to2=/\d\d?/,this.matchSigned=/[+-]?\d+/,this.matchOffset=/[+-]\d\d:?(\d\d)?|Z/,this.matchWord=/[^\d_:/,\-()\s]+/,this.zoneExpressions=[this.matchOffset,(e,t)=>{e.offset=this.offsetFromString(t)}],this.expressions={t:{pattern:void 0,parser:(e,t)=>{e.afternoon=this.meridiemMatch(t)}},T:{pattern:void 0,parser:(e,t)=>{e.afternoon=this.meridiemMatch(t)}},fff:{pattern:this.match3,parser:(e,t)=>{e.milliseconds=+t}},s:{pattern:this.match1to2,parser:this.addInput("seconds")},ss:{pattern:this.match1to2,parser:this.addInput("seconds")},m:{pattern:this.match1to2,parser:this.addInput("minutes")},mm:{pattern:this.match1to2,parser:this.addInput("minutes")},H:{pattern:this.match1to2,parser:this.addInput("hours")},h:{pattern:this.match1to2,parser:this.addInput("hours")},HH:{pattern:this.match1to2,parser:this.addInput("hours")},hh:{pattern:this.match1to2,parser:this.addInput("hours")},d:{pattern:this.match1to2,parser:this.addInput("day")},dd:{pattern:this.match2,parser:this.addInput("day")},Do:{pattern:this.matchWord,parser:(e,t)=>{if(e.day=+(t.match(/\d+/)[0]||1),this.localization.ordinal)for(let s=1;s<=31;s+=1)this.localization.ordinal(s).replace(/[[\]]/g,"")===t&&(e.day=s)}},M:{pattern:this.match1to2,parser:this.addInput("month")},MM:{pattern:this.match2,parser:this.addInput("month")},MMM:{pattern:this.matchWord,parser:(e,t)=>{const s=this.getAllMonths(),i=(this.getAllMonths("short")||s.map((e=>e.slice(0,3)))).indexOf(t)+1;if(i<1)throw new Error;e.month=i%12||i}},MMMM:{pattern:this.matchWord,parser:(e,t)=>{const s=this.getAllMonths().indexOf(t)+1;if(s<1)throw new Error;e.month=s%12||s}},y:{pattern:this.matchSigned,parser:this.addInput("year")},yy:{pattern:this.match2,parser:(e,t)=>{e.year=this.parseTwoDigitYear(+t)}},yyyy:{pattern:this.match4,parser:this.addInput("year")}}}setLocale(e){return this.localization||(this.localization=c,this.localization.locale=e),this}setLocalization(e){return this.localization=e,this}static convert(e,t="default",s=void 0){if(!e)throw new Error("A date is required");return s||((s=c).locale=t),new DateTime(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds(),e.getMilliseconds()).setLocalization(s)}get clone(){return new DateTime(this.year,this.month,this.date,this.hours,this.minutes,this.seconds,this.getMilliseconds()).setLocalization(this.localization)}static isValid(e){return void 0!==e&&"null"!==JSON.stringify(e)&&e.constructor.name===DateTime.name}startOf(e,t=0){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);switch(e){case"seconds":this.setMilliseconds(0);break;case"minutes":this.setSeconds(0,0);break;case"hours":this.setMinutes(0,0,0);break;case"date":this.setHours(0,0,0,0);break;case"weekDay":{if(this.startOf(r.date),this.weekDay===t)break;const e=(this.weekDay-t+7)%7;this.manipulate(-1*e,r.date);break}case"month":this.startOf(r.date),this.setDate(1);break;case"year":this.startOf(r.date),this.setMonth(0,1)}return this}endOf(e,t=0){if(void 0===this[e])throw new Error(`Unit '${e}' is not valid`);switch(e){case"seconds":this.setMilliseconds(999);break;case"minutes":this.setSeconds(59,999);break;case"hours":this.setMinutes(59,59,999);break;case"date":this.setHours(23,59,59,999);break;case"weekDay":{this.endOf(r.date);const e=6+t;if(this.weekDay===e)break;this.manipulate(e-this.weekDay,r.date);break}case"month":this.endOf(r.date),this.manipulate(1,r.month),this.setDate(0);break;case"year":this.endOf(r.date),this.setMonth(11,31)}return this}manipulate(e,t){if(void 0===this[t])throw new Error(`Unit '${t}' is not valid`);return this[t]+=e,this}isBefore(e,t){if(!DateTime.isValid(e))return!1;if(!t)return this.valueOf()<e.valueOf();if(void 0===this[t])throw new Error(`Unit '${t}' is not valid`);return this.clone.startOf(t).valueOf()<e.clone.startOf(t).valueOf()}isAfter(e,t){if(!DateTime.isValid(e))return!1;if(!t)return this.valueOf()>e.valueOf();if(void 0===this[t])throw new Error(`Unit '${t}' is not valid`);return this.clone.startOf(t).valueOf()>e.clone.startOf(t).valueOf()}isSame(e,t){if(!DateTime.isValid(e))return!1;if(!t)return this.valueOf()===e.valueOf();if(void 0===this[t])throw new Error(`Unit '${t}' is not valid`);return e=DateTime.convert(e),this.clone.startOf(t).valueOf()===e.startOf(t).valueOf()}isBetween(e,t,s,i="()"){if(!DateTime.isValid(e)||!DateTime.isValid(t))return!1;if(s&&void 0===this[s])throw new Error(`Unit '${s}' is not valid`);const a="("===i[0],o=")"===i[1],n=a?this.isAfter(e,s):!this.isBefore(e,s),r=o?this.isBefore(t,s):!this.isAfter(t,s);return n&&r}parts(e=this.localization.locale,t={dateStyle:"full",timeStyle:"long"}){const s={};return new Intl.DateTimeFormat(e,t).formatToParts(this).filter((e=>"literal"!==e.type)).forEach((e=>s[e.type]=e.value)),s}get seconds(){return this.getSeconds()}set seconds(e){this.setSeconds(e)}get secondsFormatted(){return this.parts(void 0,d).second}get minutes(){return this.getMinutes()}set minutes(e){this.setMinutes(e)}get minutesFormatted(){return this.parts(void 0,d).minute}get hours(){return this.getHours()}set hours(e){this.setHours(e)}getHoursFormatted(e="h12"){return this.parts(void 0,{...d,hourCycle:e}).hour}meridiem(e=this.localization.locale){return new Intl.DateTimeFormat(e,{hour:"numeric",hour12:!0}).formatToParts(this).find((e=>"dayPeriod"===e.type))?.value}get date(){return this.getDate()}set date(e){this.setDate(e)}get dateFormatted(){return this.parts(void 0,d).day}get weekDay(){return this.getDay()}get month(){return this.getMonth()}set month(e){const t=new Date(this.year,e+1);t.setDate(0);const s=t.getDate();this.date>s&&(this.date=s),this.setMonth(e)}get monthFormatted(){return this.parts(void 0,d).month}get year(){return this.getFullYear()}set year(e){this.setFullYear(e)}get week(){const e=this.computeOrdinal(),t=this.getUTCDay();let s=Math.floor((e-t+10)/7);return s<1?s=this.weeksInWeekYear():s>this.weeksInWeekYear()&&(s=1),s}weeksInWeekYear(){const e=(this.year+Math.floor(this.year/4)-Math.floor(this.year/100)+Math.floor(this.year/400))%7,t=this.year-1,s=(t+Math.floor(t/4)-Math.floor(t/100)+Math.floor(t/400))%7;return 4===e||3===s?53:52}get isLeapYear(){return this.year%4==0&&(this.year%100!=0||this.year%400==0)}computeOrdinal(){return this.date+(this.isLeapYear?this.leapLadder:this.nonLeapLadder)[this.month]}getAllMonths(e="long"){const t=new Intl.DateTimeFormat(this.localization.locale,{month:e}).format;return[...Array(12).keys()].map((e=>t(new Date(2021,e))))}replaceTokens(e,t){return e.replace(/(\[[^[\]]*])|(LTS?|l{1,4}|L{1,4})/g,((e,s,i)=>{const a=i&&i.toUpperCase();return s||t[a]||c.dateFormats[a]}))}parseTwoDigitYear(e){return e+(e>68?1900:2e3)}offsetFromString(e){if(!e)return 0;if("Z"===e)return 0;const[t,s,i]=e.match(/([+-]|\d\d)/g),a=60*+s+(+i||0);return 0===a?0:"+"===t?-a:a}zoneInformation(e,t){let s=e.parts(this.localization.locale,{timeZoneName:"longOffset"}).timeZoneName.replace("GMT","").replace(":","");const i=s.includes("-");return s=s.replace("-",""),"z"===t?s=s.substring(1,2):"zz"===t&&(s=s.substring(0,2)),`${i?"-":""}${s}`}addInput(e){return(t,s)=>{t[e]=+s}}getLocaleAfternoon(){return new Intl.DateTimeFormat(this.localization.locale,{hour:"numeric",hour12:!0}).formatToParts(new Date(2022,3,4,13)).find((e=>"dayPeriod"===e.type))?.value?.replace(/\s+/g," ")}meridiemMatch(e){return e.toLowerCase()===this.getLocaleAfternoon().toLowerCase()}correctHours(e){const{afternoon:t}=e;if(void 0!==t){const{hours:s}=e;t?s<12&&(e.hours+=12):12===s&&(e.hours=0),delete e.afternoon}}makeParser(e){const t=(e=this.replaceTokens(e,this.localization.dateFormats)).match(this.formattingTokens),{length:s}=t,i=[];for(let e=0;e<s;e+=1){const s=t[e],a=this.expressions[s];i[e]=a?.parser?a:s.replace(/^\[[^[\]]*]$/g,"")}return e=>{const t={hours:0,minutes:0,seconds:0,milliseconds:0};for(let a=0,o=0;a<s;a+=1){const s=i[a];if("string"==typeof s)o+=s.length;else{const i=e.slice(o);let a=i;if(s.pattern){a=s.pattern.exec(i)[0]}s.parser.call(this,t,a),e=e.replace(a,"")}}return this.correctHours(t),t}}static fromString(e,t){t?.format||Namespace.errorMessages.customDateFormatError("No format was provided");try{const s=new DateTime;if(s.setLocalization(t),["x","X"].indexOf(t.format)>-1)return new DateTime(("X"===t.format?1e3:1)*+e);e=e.replace(/\s+/g," ");const i=s.makeParser(t.format),{year:a,month:o,day:n,hours:r,minutes:c,seconds:d,milliseconds:l,zone:h}=i(e),p=n||(a||o?1:s.getDate()),u=a||s.getFullYear();let m=0;return a&&!o||(m=o>0?o-1:s.getMonth()),h?new DateTime(Date.UTC(u,m,p,r,c,d,l+60*h.offset*1e3)):new DateTime(u,m,p,r,c,d,l)}catch(s){Namespace.errorMessages.customDateFormatError(`Unable to parse provided input: ${e}, format: ${t.format}`)}}format(e,t=this.localization.locale){if(e&&"object"==typeof e)return new Intl.DateTimeFormat(t,e).format(this);const s=this.replaceTokens(e||this.localization.format||`${c.dateFormats.L}, ${c.dateFormats.LT}`,this.localization.dateFormats),i=e=>new Intl.DateTimeFormat(this.localization.locale,e).format(this);this.localization.hourCycle||(this.localization.hourCycle=h(this.localization.locale));const a=this.localization.hourCycle.startsWith("h1")?"h24":this.localization.hourCycle,o=this.localization.hourCycle.startsWith("h2")?"h12":this.localization.hourCycle,n={y:this.year,yy:i({year:"2-digit"}),yyyy:this.year,M:i({month:"numeric"}),MM:this.monthFormatted,MMM:this.getAllMonths("short")[this.getMonth()],MMMM:this.getAllMonths()[this.getMonth()],d:this.date,dd:this.dateFormatted,ddd:i({weekday:"short"}),dddd:i({weekday:"long"}),H:this.getHours(),HH:this.getHoursFormatted(a),h:this.hours>12?this.hours-12:this.hours,hh:this.getHoursFormatted(o),t:this.meridiem(),T:this.meridiem().toUpperCase(),m:this.minutes,mm:this.minutesFormatted,s:this.seconds,ss:this.secondsFormatted,fff:this.getMilliseconds()};return s.replace(this.dateTimeRegex,((e,t)=>t||n[e])).replace(/\[/g,"").replace(/]/g,"")}}class ServiceLocator{constructor(){this.cache=new Map}locate(e){const t=this.cache.get(e);if(t)return t;const s=new e;return this.cache.set(e,s),s}}let p;const u=[{name:"calendar",className:Namespace.css.daysContainer,unit:r.month,step:1},{name:"months",className:Namespace.css.monthsContainer,unit:r.year,step:1},{name:"years",className:Namespace.css.yearsContainer,unit:r.year,step:10},{name:"decades",className:Namespace.css.decadesContainer,unit:r.year,step:100}];class OptionsStore{constructor(){this._currentCalendarViewMode=0,this._viewDate=new DateTime,this.minimumCalendarViewMode=0,this.currentView="calendar"}get currentCalendarViewMode(){return this._currentCalendarViewMode}set currentCalendarViewMode(e){this._currentCalendarViewMode=e,this.currentView=u[e].name}get viewDate(){return this._viewDate}set viewDate(e){this._viewDate=e,this.options&&(this.options.viewDate=e)}refreshCurrentView(){this.currentView=u[this.currentCalendarViewMode].name}get isTwelveHour(){return["h12","h11"].includes(this.options.localization.hourCycle)}}class Validation{constructor(){this.optionsStore=p.locate(OptionsStore)}isValid(e,t){if(!this._enabledDisabledDatesIsValid(t,e))return!1;if(t!==r.month&&t!==r.year&&this.optionsStore.options.restrictions.daysOfWeekDisabled?.length>0&&-1!==this.optionsStore.options.restrictions.daysOfWeekDisabled.indexOf(e.weekDay))return!1;if(!this._minMaxIsValid(t,e))return!1;if(t===r.hours||t===r.minutes||t===r.seconds){if(!this._enabledDisabledHoursIsValid(e))return!1;if(0!==this.optionsStore.options.restrictions.disabledTimeIntervals?.filter((t=>e.isBetween(t.from,t.to))).length)return!1}return!0}_enabledDisabledDatesIsValid(e,t){return e!==r.date||!(this.optionsStore.options.restrictions.disabledDates.length>0&&this._isInDisabledDates(t))&&!(this.optionsStore.options.restrictions.enabledDates.length>0&&!this._isInEnabledDates(t))}_isInDisabledDates(e){return!(!this.optionsStore.options.restrictions.disabledDates||0===this.optionsStore.options.restrictions.disabledDates.length)&&!!this.optionsStore.options.restrictions.disabledDates.find((t=>t.isSame(e,r.date)))}_isInEnabledDates(e){return!this.optionsStore.options.restrictions.enabledDates||0===this.optionsStore.options.restrictions.enabledDates.length||!!this.optionsStore.options.restrictions.enabledDates.find((t=>t.isSame(e,r.date)))}_minMaxIsValid(e,t){return(!this.optionsStore.options.restrictions.minDate||!t.isBefore(this.optionsStore.options.restrictions.minDate,e))&&(!this.optionsStore.options.restrictions.maxDate||!t.isAfter(this.optionsStore.options.restrictions.maxDate,e))}_enabledDisabledHoursIsValid(e){return!(this.optionsStore.options.restrictions.disabledHours.length>0&&this._isInDisabledHours(e))&&!(this.optionsStore.options.restrictions.enabledHours.length>0&&!this._isInEnabledHours(e))}_isInDisabledHours(e){if(!this.optionsStore.options.restrictions.disabledHours||0===this.optionsStore.options.restrictions.disabledHours.length)return!1;const t=e.hours;return this.optionsStore.options.restrictions.disabledHours.includes(t)}_isInEnabledHours(e){if(!this.optionsStore.options.restrictions.enabledHours||0===this.optionsStore.options.restrictions.enabledHours.length)return!0;const t=e.hours;return this.optionsStore.options.restrictions.enabledHours.includes(t)}dateRangeIsValid(e,t,s){if(!this.optionsStore.options.dateRange)return!0;if(2!==e.length&&1!==t)return!0;const i=e[0].clone;if(i.isSame(s,r.date))return!0;for(i.manipulate(1,r.date);!i.isSame(s,r.date);){if(!this.isValid(i,r.date))return!1;i.manipulate(1,r.date)}return!0}}class EventEmitter{constructor(){this.subscribers=[]}subscribe(e){return this.subscribers.push(e),this.unsubscribe.bind(this,this.subscribers.length-1)}unsubscribe(e){this.subscribers.splice(e,1)}emit(e){this.subscribers.forEach((t=>{t(e)}))}destroy(){this.subscribers=null,this.subscribers=[]}}class EventEmitters{constructor(){this.triggerEvent=new EventEmitter,this.viewUpdate=new EventEmitter,this.updateDisplay=new EventEmitter,this.action=new EventEmitter,this.updateViewDate=new EventEmitter}destroy(){this.triggerEvent.destroy(),this.viewUpdate.destroy(),this.updateDisplay.destroy(),this.action.destroy(),this.updateViewDate.destroy()}}const m={clear:"Clear selection",close:"Close the picker",dateFormats:c.dateFormats,dayViewHeaderFormat:{month:"long",year:"2-digit"},decrementHour:"Decrement Hour",decrementMinute:"Decrement Minute",decrementSecond:"Decrement Second",format:c.format,hourCycle:c.hourCycle,incrementHour:"Increment Hour",incrementMinute:"Increment Minute",incrementSecond:"Increment Second",locale:c.locale,maxWeekdayLength:0,nextCentury:"Next Century",nextDecade:"Next Decade",nextMonth:"Next Month",nextYear:"Next Year",ordinal:c.ordinal,pickHour:"Pick Hour",pickMinute:"Pick Minute",pickSecond:"Pick Second",previousCentury:"Previous Century",previousDecade:"Previous Decade",previousMonth:"Previous Month",previousYear:"Previous Year",selectDate:"Select Date",selectDecade:"Select Decade",selectMonth:"Select Month",selectTime:"Select Time",selectYear:"Select Year",startOfTheWeek:0,today:"Go to today",toggleMeridiem:"Toggle Meridiem"},y={allowInputToggle:!1,container:void 0,dateRange:!1,debug:!1,defaultDate:void 0,display:{icons:{type:"icons",time:"fa-solid fa-clock",date:"fa-solid fa-calendar",up:"fa-solid fa-arrow-up",down:"fa-solid fa-arrow-down",previous:"fa-solid fa-chevron-left",next:"fa-solid fa-chevron-right",today:"fa-solid fa-calendar-check",clear:"fa-solid fa-trash",close:"fa-solid fa-xmark"},sideBySide:!1,calendarWeeks:!1,viewMode:"calendar",toolbarPlacement:"bottom",keepOpen:!1,buttons:{today:!1,clear:!1,close:!1},components:{calendar:!0,date:!0,month:!0,year:!0,decades:!0,clock:!0,hours:!0,minutes:!0,seconds:!1,useTwentyfourHour:void 0},inline:!1,theme:"auto",placement:"bottom"},keepInvalid:!1,localization:m,meta:{},multipleDates:!1,multipleDatesSeparator:"; ",promptTimeOnDateChange:!1,promptTimeOnDateChangeTransitionDelay:200,restrictions:{minDate:void 0,maxDate:void 0,disabledDates:[],enabledDates:[],daysOfWeekDisabled:[],disabledTimeIntervals:[],disabledHours:[],enabledHours:[]},stepping:1,useCurrent:!0,viewDate:new DateTime},g={...m};function v(e,t){if(!e)return null;if(e.constructor.name===DateTime.name)return e;if(e.constructor.name===Date.name)return DateTime.convert(e);if("string"==typeof e){const s=DateTime.fromString(e,t);return"null"===JSON.stringify(s)?null:s}return null}function f(e,t,s){"string"==typeof e&&"input"!==t&&Namespace.errorMessages.dateString();const i=v(e,s);return i||Namespace.errorMessages.failedToParseDate(t,e,"input"===t),i}function S(e,t,s,i=c){Array.isArray(t)||Namespace.errorMessages.typeMismatch(e,s,"array of DateTime or Date");for(let s=0;s<t.length;s++){const a=f(t[s],e,i);a.setLocalization(i),t[s]=a}}function w(e,t,s){Array.isArray(t)&&!t.some((e=>"number"!=typeof e))||Namespace.errorMessages.typeMismatch(e,s,"array of numbers")}function D(e){return({value:t,providedType:s,localization:i})=>{const a=f(t,e,i);if(void 0!==a)return a.setLocalization(i),a}}function b(e){const t=D(e);return e=>void 0===e.value?e.value:t(e)}function C(e,t,s){return({value:i,providedType:a})=>void 0===i?[]:(w(e,i,a),i.some((e=>e<t||e>s))&&Namespace.errorMessages.numbersOutOfRange(e,t,s),i)}function _(e){return C(e,0,23)}function k(e){return({value:t,providedType:s,localization:i})=>void 0===t?[]:(S(e,t,s,i),t)}function N(e){return({value:t,path:s})=>(e.includes(t)||Namespace.errorMessages.unexpectedOptionValue(s.substring(1),t,e),t)}const E=Object.freeze({defaultDate:D("defaultDate"),viewDate:D("viewDate"),minDate:b("restrictions.minDate"),maxDate:b("restrictions.maxDate"),disabledHours:_("restrictions.disabledHours"),enabledHours:_("restrictions.enabledHours"),disabledDates:k("restrictions.disabledDates"),enabledDates:k("restrictions.enabledDates"),daysOfWeekDisabled:C("restrictions.daysOfWeekDisabled",0,6),disabledTimeIntervals:({key:e,value:t,providedType:s,localization:i})=>{if(void 0===t)return[];Array.isArray(t)||Namespace.errorMessages.typeMismatch(e,s,"array of { from: DateTime|Date, to: DateTime|Date }");const a=t;for(let t=0;t<a.length;t++)Object.keys(a[t]).forEach((s=>{const o=`${e}[${t}].${s}`,n=f(a[t][s],o,i);n.setLocalization(i),a[t][s]=n}));return a},toolbarPlacement:N(["top","bottom","default"]),type:N(["icons","sprites"]),viewMode:N(["clock","calendar","months","years","decades"]),theme:N(["light","dark","auto"]),placement:N(["top","bottom"]),meta:({value:e})=>e,dayViewHeaderFormat:({value:e})=>e,container:({value:e,path:t})=>(e&&!(e instanceof HTMLElement||e instanceof Element||e?.appendChild)&&Namespace.errorMessages.typeMismatch(t.substring(1),typeof e,"HTMLElement"),e),useTwentyfourHour:({value:e,path:t,providedType:s,defaultType:i})=>{if(Namespace.errorMessages.deprecatedWarning("useTwentyfourHour",'Please use "options.localization.hourCycle" instead'),void 0===e||"boolean"===s)return e;Namespace.errorMessages.typeMismatch(t,s,i)},hourCycle:N(["h11","h12","h23","h24"])}),T=({value:e,defaultType:t,providedType:s,path:i})=>{switch(t){case"boolean":return"true"===e||!0===e;case"number":return+e;case"string":return e.toString();case"object":return{};case"function":return e;default:Namespace.errorMessages.typeMismatch(i,s,t)}};function M(e){return(E[e.key]||T)(e)}class OptionConverter{static deepCopy(e){const t={};return Object.keys(e).forEach((s=>{const i=e[s];i instanceof DateTime?t[s]=i.clone:i instanceof Date?t[s]=new Date(i.valueOf()):(t[s]=i,"object"!=typeof i||i instanceof HTMLElement||i instanceof Element||Array.isArray(i)||(t[s]=OptionConverter.deepCopy(i)))})),t}static objectPath(e,t){return"."===e.charAt(0)&&(e=e.slice(1)),e?e.split(".").reduce(((e,t)=>OptionConverter.isValue(e)||OptionConverter.isValue(e[t])?e[t]:void 0),t):t}static spread(e,t,s,i=""){const a=OptionConverter.objectPath(i,y),o=Object.keys(e).filter((e=>!Object.keys(a).includes(e)));if(o.length>0){const e=OptionConverter.getFlattenDefaultOptions(),t=o.map((t=>{let s=`"${i}.${t}" in not a known option.`;const a=e.find((e=>e.includes(t)));return a&&(s+=` Did you mean "${a}"?`),s}));Namespace.errorMessages.unexpectedOptions(t)}Object.keys(e).filter((e=>"__proto__"!==e&&"constructor"!==e)).forEach((o=>{"."===(i+=`.${o}`).charAt(0)&&(i=i.slice(1));const n=a[o],r=typeof e[o],c=typeof n,d=e[o];if(null==d)return t[o]=d,void(i=i.substring(0,i.lastIndexOf(`.${o}`)));"object"!=typeof n||Array.isArray(e[o])||n instanceof Date||OptionConverter.ignoreProperties.includes(o)?t[o]=OptionConverter.processKey(o,d,r,c,i,s):OptionConverter.spread(e[o],t[o],s,i),i=i.substring(0,i.lastIndexOf(`.${o}`))}))}static processKey(e,t,s,i,a,o){return M({key:e,value:t,providedType:s,defaultType:i,path:a,localization:o})}static _mergeOptions(e,t){const s=OptionConverter.deepCopy(t),i="default"!==t.localization?.locale?t.localization:e?.localization||y.localization;return OptionConverter.spread(e,s,i,""),s}static _dataToOptions(e,t){const s=JSON.parse(JSON.stringify(e.dataset));if(s?.tdTargetInput&&delete s.tdTargetInput,s?.tdTargetToggle&&delete s.tdTargetToggle,!s||0===Object.keys(s).length)return t;const i={},a=e=>{const t={};return Object.keys(e).forEach((e=>{t[e.toLowerCase()]=e})),t},o=this.normalizeObject(a),n=a(t);return Object.keys(s).filter((e=>e.startsWith(Namespace.dataKey))).map((e=>e.substring(2))).forEach((e=>{let a=n[e.toLowerCase()];if(e.includes("_")){const r=e.split("_");a=n[r[0].toLowerCase()],void 0!==a&&t[a].constructor===Object&&(i[a]=o(r,1,t[a],s[`td${e}`]))}else void 0!==a&&(i[a]=s[`td${e}`])})),this._mergeOptions(i,t)}static normalizeObject(e){const t=(s,i,a,o)=>{const n=e(a)[s[i].toLowerCase()],r={};return void 0===n||(a[n]?.constructor===Object?(i++,r[n]=t(s,i,a[n],o)):r[n]=o),r};return t}static _dateTypeCheck(e,t){return v(e,t)}static _typeCheckDateArray(e,t,s,i){return S(e,t,s,i)}static _typeCheckNumberArray(e,t,s){return w(e,t,s)}static dateConversion(e,t,s){return f(e,t,s)}static getFlattenDefaultOptions(){if(this._flattenDefaults)return this._flattenDefaults;const e=(t,s=[])=>Array.isArray(t)?[]:Object(t)===t?Object.entries(t).flatMap((([t,i])=>e(i,[...s,t]))):s.join(".");return this._flattenDefaults=e(y),this._flattenDefaults}static _validateConflicts(e){!e.display.sideBySide||e.display.components.clock&&(e.display.components.hours||e.display.components.minutes||e.display.components.seconds)||Namespace.errorMessages.conflictingConfiguration("Cannot use side by side mode without the clock components"),e.restrictions.minDate&&e.restrictions.maxDate&&(e.restrictions.minDate.isAfter(e.restrictions.maxDate)&&Namespace.errorMessages.conflictingConfiguration("minDate is after maxDate"),e.restrictions.maxDate.isBefore(e.restrictions.minDate)&&Namespace.errorMessages.conflictingConfiguration("maxDate is before minDate")),e.multipleDates&&e.dateRange&&Namespace.errorMessages.conflictingConfiguration('Cannot uss option "multipleDates" with "dateRange"')}}OptionConverter.ignoreProperties=["meta","dayViewHeaderFormat","container","dateForms","ordinal"],OptionConverter.isValue=e=>null!=e;class Dates{constructor(){this._dates=[],this.optionsStore=p.locate(OptionsStore),this.validation=p.locate(Validation),this._eventEmitters=p.locate(EventEmitters)}get picked(){return[...this._dates]}get lastPicked(){return this._dates[this.lastPickedIndex]?.clone}get lastPickedIndex(){return 0===this._dates.length?0:this._dates.length-1}formatInput(e){return e?(e.localization=this.optionsStore.options.localization,e.format()):""}parseInput(e){try{return OptionConverter.dateConversion(e,"input",this.optionsStore.options.localization)}catch(t){return void this._eventEmitters.triggerEvent.emit({type:Namespace.events.error,reason:Namespace.errorMessages.failedToParseInput,format:this.optionsStore.options.localization.format,value:e})}}setFromInput(e,t){if(!e)return void this.setValue(void 0,t);const s=this.parseInput(e);s&&(s.setLocalization(this.optionsStore.options.localization),this.setValue(s,t))}add(e){this._dates.push(e)}isPicked(e,t){if(!DateTime.isValid(e))return!1;if(!t)return void 0!==this._dates.find((t=>t.isSame(e)));const s=l(t),i=e.format(s);return void 0!==this._dates.map((e=>e.format(s))).find((e=>e===i))}pickedIndex(e,t){if(!DateTime.isValid(e))return-1;if(!t)return this._dates.map((e=>e.valueOf())).indexOf(e.valueOf());const s=l(t),i=e.format(s);return this._dates.map((e=>e.format(s))).indexOf(i)}clear(){this.optionsStore.unset=!0,this._eventEmitters.triggerEvent.emit({type:Namespace.events.change,date:void 0,oldDate:this.lastPicked,isClear:!0,isValid:!0}),this._dates=[],this.optionsStore.input&&(this.optionsStore.input.value=""),this._eventEmitters.updateDisplay.emit("all")}static getStartEndYear(e,t){const s=e/10,i=Math.floor(t/e)*e;return[i,i+9*s,Math.floor(t/s)*s]}updateInput(e){if(!this.optionsStore.input)return;let t=this.formatInput(e);(this.optionsStore.options.multipleDates||this.optionsStore.options.dateRange)&&(t=this._dates.map((e=>this.formatInput(e))).join(this.optionsStore.options.multipleDatesSeparator)),this.optionsStore.input.value!=t&&(this.optionsStore.input.value=t)}setValue(e,t){const s=void 0===t,i=!e&&s;let a=this.optionsStore.unset?null:this._dates[t]?.clone;if(!a&&!this.optionsStore.unset&&s&&i&&(a=this.lastPicked),e&&a?.isSame(e))return void this.updateInput(e);if(!e)return void this._setValueNull(i,t,a);t=t||0,e=e.clone,1!==this.optionsStore.options.stepping&&(e.minutes=Math.round(e.minutes/this.optionsStore.options.stepping)*this.optionsStore.options.stepping,e.startOf(r.minutes));const o=s=>{this._dates[t]=e,this._eventEmitters.updateViewDate.emit(e.clone),this.updateInput(e),this.optionsStore.unset=!1,this._eventEmitters.updateDisplay.emit("all"),this._eventEmitters.triggerEvent.emit({type:Namespace.events.change,date:e,oldDate:a,isClear:i,isValid:s})};this.validation.isValid(e)&&this.validation.dateRangeIsValid(this.picked,t,e)?o(!0):(this.optionsStore.options.keepInvalid&&o(!1),this._eventEmitters.triggerEvent.emit({type:Namespace.events.error,reason:Namespace.errorMessages.failedToSetInvalidDate,date:e,oldDate:a}))}_setValueNull(e,t,s){!this.optionsStore.options.multipleDates||1===this._dates.length||e?(this.optionsStore.unset=!0,this._dates=[]):this._dates.splice(t,1),this.updateInput(),this._eventEmitters.triggerEvent.emit({type:Namespace.events.change,date:void 0,oldDate:s,isClear:e,isValid:!0}),this._eventEmitters.updateDisplay.emit("all")}}var L;!function(e){e.next="next",e.previous="previous",e.changeCalendarView="changeCalendarView",e.selectMonth="selectMonth",e.selectYear="selectYear",e.selectDecade="selectDecade",e.selectDay="selectDay",e.selectHour="selectHour",e.selectMinute="selectMinute",e.selectSecond="selectSecond",e.incrementHours="incrementHours",e.incrementMinutes="incrementMinutes",e.incrementSeconds="incrementSeconds",e.decrementHours="decrementHours",e.decrementMinutes="decrementMinutes",e.decrementSeconds="decrementSeconds",e.toggleMeridiem="toggleMeridiem",e.togglePicker="togglePicker",e.showClock="showClock",e.showHours="showHours",e.showMinutes="showMinutes",e.showSeconds="showSeconds",e.clear="clear",e.close="close",e.today="today"}(L||(L={}));var V=L;class DateDisplay{constructor(){this.optionsStore=p.locate(OptionsStore),this.dates=p.locate(Dates),this.validation=p.locate(Validation)}getPicker(){const e=document.createElement("div");if(e.classList.add(Namespace.css.daysContainer),e.append(...this._daysOfTheWeek()),this.optionsStore.options.display.calendarWeeks){const t=document.createElement("div");t.classList.add(Namespace.css.calendarWeeks,Namespace.css.noHighlight),e.appendChild(t)}const{rangeHoverEvent:t,rangeHoverOutEvent:s}=this.handleMouseEvents(e);for(let i=0;i<42;i++){if(0!==i&&i%7==0&&this.optionsStore.options.display.calendarWeeks){const t=document.createElement("div");t.classList.add(Namespace.css.calendarWeeks,Namespace.css.noHighlight),e.appendChild(t)}const a=document.createElement("div");a.setAttribute("data-action",V.selectDay),e.appendChild(a),matchMedia("(hover: hover)").matches&&this.optionsStore.options.dateRange&&(a.addEventListener("mouseover",t),a.addEventListener("mouseout",s))}return e}_update(e,t){const s=e.getElementsByClassName(Namespace.css.daysContainer)[0];this._updateCalendarView(s);const i=this.optionsStore.viewDate.clone.startOf(r.month).startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek).manipulate(12,r.hours);this._handleCalendarWeeks(s,i.clone),s.querySelectorAll(`[data-action="${V.selectDay}"]`).forEach((e=>{const s=[];s.push(Namespace.css.day),i.isBefore(this.optionsStore.viewDate,r.month)&&s.push(Namespace.css.old),i.isAfter(this.optionsStore.viewDate,r.month)&&s.push(Namespace.css.new),this.optionsStore.unset||this.optionsStore.options.dateRange||!this.dates.isPicked(i,r.date)||s.push(Namespace.css.active),this.validation.isValid(i,r.date)||s.push(Namespace.css.disabled),i.isSame(new DateTime,r.date)&&s.push(Namespace.css.today),0!==i.weekDay&&6!==i.weekDay||s.push(Namespace.css.weekend),this._handleDateRange(i,s),t(r.date,i,s,e),e.classList.remove(...e.classList),e.classList.add(...s),e.setAttribute("data-value",this._dateToDataValue(i)),e.setAttribute("data-day",`${i.date}`),e.innerText=i.parts(void 0,{day:"numeric"}).day,i.manipulate(1,r.date)}))}_dateToDataValue(e){return DateTime.isValid(e)?`${e.year}-${e.month.toString().padStart(2,"0")}-${e.date.toString().padStart(2,"0")}`:""}_handleDateRange(e,t){const s=this.dates.picked[0],i=this.dates.picked[1];this.optionsStore.options.dateRange&&(e.isBetween(s,i,r.date)&&t.push(Namespace.css.rangeIn),e.isSame(s,r.date)&&t.push(Namespace.css.rangeStart),e.isSame(i,r.date)&&t.push(Namespace.css.rangeEnd))}handleMouseEvents(e){return{rangeHoverEvent:t=>{const s=t?.currentTarget;if(1!==this.dates.picked.length||s.classList.contains(Namespace.css.disabled))return;const i=[...e.querySelectorAll(".day")],a=s.getAttribute("data-value"),o=DateTime.fromString(a,{format:"yyyy-MM-dd"}),n=i.findIndex((e=>e.getAttribute("data-value")===a)),c=this.dates.picked[0],d=this.dates.picked[1],l=this._dateToDataValue(c),h=i.findIndex((e=>e.getAttribute("data-value")===l)),p=i[h];let u;o.isSame(c,r.date)||s.classList.remove(Namespace.css.rangeStart),o.isSame(d,r.date)||s.classList.remove(Namespace.css.rangeEnd),o.isBefore(c)?(s.classList.add(Namespace.css.rangeStart),p?.classList.remove(Namespace.css.rangeStart),p?.classList.add(Namespace.css.rangeEnd),u=(e,t)=>t>n&&t<h):(s.classList.add(Namespace.css.rangeEnd),p?.classList.remove(Namespace.css.rangeEnd),p?.classList.add(Namespace.css.rangeStart),u=(e,t)=>t<n&&t>h),i.filter(u).forEach((e=>{e.classList.add(Namespace.css.rangeIn)}))},rangeHoverOutEvent:t=>{const s=[...e.querySelectorAll(".day")];if(1===this.dates.picked.length&&s.forEach((e=>e.classList.remove(Namespace.css.rangeIn))),1!==this.dates.picked.length)return;const i=t?.currentTarget,a=new DateTime(i.getAttribute("data-value"));a.isSame(this.dates.picked[0],r.date)||i.classList.remove(Namespace.css.rangeStart),a.isSame(this.dates.picked[1],r.date)||i.classList.remove(Namespace.css.rangeEnd)}}}_updateCalendarView(e){if("calendar"!==this.optionsStore.currentView)return;const[t,s,i]=e.parentElement.getElementsByClassName(Namespace.css.calendarHeader)[0].getElementsByTagName("div");s.setAttribute(Namespace.css.daysContainer,this.optionsStore.viewDate.format(this.optionsStore.options.localization.dayViewHeaderFormat)),this.optionsStore.options.display.components.month?s.classList.remove(Namespace.css.disabled):s.classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,r.month),r.month)?t.classList.remove(Namespace.css.disabled):t.classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,r.month),r.month)?i.classList.remove(Namespace.css.disabled):i.classList.add(Namespace.css.disabled)}_daysOfTheWeek(){const e=this.optionsStore.viewDate.clone.startOf("weekDay",this.optionsStore.options.localization.startOfTheWeek).startOf(r.date),t=[];if(document.createElement("div"),this.optionsStore.options.display.calendarWeeks){const e=document.createElement("div");e.classList.add(Namespace.css.calendarWeeks,Namespace.css.noHighlight),e.innerText="#",t.push(e)}for(let s=0;s<7;s++){const s=document.createElement("div");s.classList.add(Namespace.css.dayOfTheWeek,Namespace.css.noHighlight);let i=e.format({weekday:"short"});this.optionsStore.options.localization.maxWeekdayLength>0&&(i=i.substring(0,this.optionsStore.options.localization.maxWeekdayLength)),s.innerText=i,e.manipulate(1,r.date),t.push(s)}return t}_handleCalendarWeeks(e,t){[...e.querySelectorAll(`.${Namespace.css.calendarWeeks}`)].filter((e=>"#"!==e.innerText)).forEach((e=>{e.innerText=`${t.week}`,t.manipulate(7,r.date)}))}}class MonthDisplay{constructor(){this.optionsStore=p.locate(OptionsStore),this.dates=p.locate(Dates),this.validation=p.locate(Validation)}getPicker(){const e=document.createElement("div");e.classList.add(Namespace.css.monthsContainer);for(let t=0;t<12;t++){const t=document.createElement("div");t.setAttribute("data-action",V.selectMonth),e.appendChild(t)}return e}_update(e,t){const s=e.getElementsByClassName(Namespace.css.monthsContainer)[0];if("months"===this.optionsStore.currentView){const[e,t,i]=s.parentElement.getElementsByClassName(Namespace.css.calendarHeader)[0].getElementsByTagName("div");t.setAttribute(Namespace.css.monthsContainer,this.optionsStore.viewDate.format({year:"numeric"})),this.optionsStore.options.display.components.year?t.classList.remove(Namespace.css.disabled):t.classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,r.year),r.year)?e.classList.remove(Namespace.css.disabled):e.classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,r.year),r.year)?i.classList.remove(Namespace.css.disabled):i.classList.add(Namespace.css.disabled)}const i=this.optionsStore.viewDate.clone.startOf(r.year);s.querySelectorAll(`[data-action="${V.selectMonth}"]`).forEach(((e,s)=>{const a=[];a.push(Namespace.css.month),!this.optionsStore.unset&&this.dates.isPicked(i,r.month)&&a.push(Namespace.css.active),this.validation.isValid(i,r.month)||a.push(Namespace.css.disabled),t(r.month,i,a,e),e.classList.remove(...e.classList),e.classList.add(...a),e.setAttribute("data-value",`${s}`),e.innerText=`${i.format({month:"short"})}`,i.manipulate(1,r.month)}))}}class YearDisplay{constructor(){this.optionsStore=p.locate(OptionsStore),this.dates=p.locate(Dates),this.validation=p.locate(Validation)}getPicker(){const e=document.createElement("div");e.classList.add(Namespace.css.yearsContainer);for(let t=0;t<12;t++){const t=document.createElement("div");t.setAttribute("data-action",V.selectYear),e.appendChild(t)}return e}_update(e,t){this._startYear=this.optionsStore.viewDate.clone.manipulate(-1,r.year),this._endYear=this.optionsStore.viewDate.clone.manipulate(10,r.year);const s=e.getElementsByClassName(Namespace.css.yearsContainer)[0];if("years"===this.optionsStore.currentView){const[e,t,i]=s.parentElement.getElementsByClassName(Namespace.css.calendarHeader)[0].getElementsByTagName("div");t.setAttribute(Namespace.css.yearsContainer,`${this._startYear.format({year:"numeric"})}-${this._endYear.format({year:"numeric"})}`),this.optionsStore.options.display.components.decades?t.classList.remove(Namespace.css.disabled):t.classList.add(Namespace.css.disabled),this.validation.isValid(this._startYear,r.year)?e.classList.remove(Namespace.css.disabled):e.classList.add(Namespace.css.disabled),this.validation.isValid(this._endYear,r.year)?i.classList.remove(Namespace.css.disabled):i.classList.add(Namespace.css.disabled)}const i=this.optionsStore.viewDate.clone.startOf(r.year).manipulate(-1,r.year);s.querySelectorAll(`[data-action="${V.selectYear}"]`).forEach((e=>{const s=[];s.push(Namespace.css.year),!this.optionsStore.unset&&this.dates.isPicked(i,r.year)&&s.push(Namespace.css.active),this.validation.isValid(i,r.year)||s.push(Namespace.css.disabled),t(r.year,i,s,e),e.classList.remove(...e.classList),e.classList.add(...s),e.setAttribute("data-value",`${i.year}`),e.innerText=i.format({year:"numeric"}),i.manipulate(1,r.year)}))}}class DecadeDisplay{constructor(){this.optionsStore=p.locate(OptionsStore),this.dates=p.locate(Dates),this.validation=p.locate(Validation)}getPicker(){const e=document.createElement("div");e.classList.add(Namespace.css.decadesContainer);for(let t=0;t<12;t++){const t=document.createElement("div");t.setAttribute("data-action",V.selectDecade),e.appendChild(t)}return e}_update(e,t){const[s,i]=Dates.getStartEndYear(100,this.optionsStore.viewDate.year);this._startDecade=this.optionsStore.viewDate.clone.startOf(r.year),this._startDecade.year=s,this._endDecade=this.optionsStore.viewDate.clone.startOf(r.year),this._endDecade.year=i;const a=e.getElementsByClassName(Namespace.css.decadesContainer)[0],[o,n,c]=a.parentElement.getElementsByClassName(Namespace.css.calendarHeader)[0].getElementsByTagName("div");"decades"===this.optionsStore.currentView&&(n.setAttribute(Namespace.css.decadesContainer,`${this._startDecade.format({year:"numeric"})}-${this._endDecade.format({year:"numeric"})}`),this.validation.isValid(this._startDecade,r.year)?o.classList.remove(Namespace.css.disabled):o.classList.add(Namespace.css.disabled),this.validation.isValid(this._endDecade,r.year)?c.classList.remove(Namespace.css.disabled):c.classList.add(Namespace.css.disabled));const d=this.dates.picked.map((e=>e.year));a.querySelectorAll(`[data-action="${V.selectDecade}"]`).forEach(((e,s)=>{if(0===s)return e.classList.add(Namespace.css.old),this._startDecade.year-10<0?(e.textContent=" ",o.classList.add(Namespace.css.disabled),e.classList.add(Namespace.css.disabled),void e.setAttribute("data-value","")):(e.innerText=this._startDecade.clone.manipulate(-10,r.year).format({year:"numeric"}),void e.setAttribute("data-value",`${this._startDecade.year}`));const i=[];i.push(Namespace.css.decade);const a=this._startDecade.year,n=this._startDecade.year+9;!this.optionsStore.unset&&d.filter((e=>e>=a&&e<=n)).length>0&&i.push(Namespace.css.active),this.validation.isValid(this._startDecade,r.year)||this.validation.isValid(this._startDecade.clone.manipulate(10,r.year),r.year)||i.push(Namespace.css.disabled),t("decade",this._startDecade,i,e),e.classList.remove(...e.classList),e.classList.add(...i),e.setAttribute("data-value",`${this._startDecade.year}`),e.innerText=`${this._startDecade.format({year:"numeric"})}`,this._startDecade.manipulate(10,r.year)}))}}class TimeDisplay{constructor(){this._gridColumns="",this.optionsStore=p.locate(OptionsStore),this.dates=p.locate(Dates),this.validation=p.locate(Validation)}getPicker(e){const t=document.createElement("div");return t.classList.add(Namespace.css.clockContainer),t.append(...this._grid(e)),t}_update(e){const t=e.getElementsByClassName(Namespace.css.clockContainer)[0];let s=this.dates.lastPicked?.clone;if(!s&&this.optionsStore.options.useCurrent&&(s=this.optionsStore.viewDate.clone),t.querySelectorAll(".disabled").forEach((e=>e.classList.remove(Namespace.css.disabled))),this.optionsStore.options.display.components.hours&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,r.hours),r.hours)||t.querySelector(`[data-action=${V.incrementHours}]`).classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,r.hours),r.hours)||t.querySelector(`[data-action=${V.decrementHours}]`).classList.add(Namespace.css.disabled),t.querySelector(`[data-time-component=${r.hours}]`).innerText=s?s.getHoursFormatted(this.optionsStore.options.localization.hourCycle):"--"),this.optionsStore.options.display.components.minutes&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,r.minutes),r.minutes)||t.querySelector(`[data-action=${V.incrementMinutes}]`).classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,r.minutes),r.minutes)||t.querySelector(`[data-action=${V.decrementMinutes}]`).classList.add(Namespace.css.disabled),t.querySelector(`[data-time-component=${r.minutes}]`).innerText=s?s.minutesFormatted:"--"),this.optionsStore.options.display.components.seconds&&(this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(1,r.seconds),r.seconds)||t.querySelector(`[data-action=${V.incrementSeconds}]`).classList.add(Namespace.css.disabled),this.validation.isValid(this.optionsStore.viewDate.clone.manipulate(-1,r.seconds),r.seconds)||t.querySelector(`[data-action=${V.decrementSeconds}]`).classList.add(Namespace.css.disabled),t.querySelector(`[data-time-component=${r.seconds}]`).innerText=s?s.secondsFormatted:"--"),this.optionsStore.isTwelveHour){const e=t.querySelector(`[data-action=${V.toggleMeridiem}]`),i=(s||this.optionsStore.viewDate).clone;e.innerText=i.meridiem(),this.validation.isValid(i.manipulate(i.hours>=12?-12:12,r.hours))?e.classList.remove(Namespace.css.disabled):e.classList.add(Namespace.css.disabled)}t.style.gridTemplateAreas=`"${this._gridColumns}"`}_grid(e){this._gridColumns="";const t=[],s=[],i=[],a=document.createElement("div"),o=e(this.optionsStore.options.display.icons.up),n=e(this.optionsStore.options.display.icons.down);a.classList.add(Namespace.css.separator,Namespace.css.noHighlight);const c=a.cloneNode(!0);c.innerHTML=":";const d=(e=!1)=>e?c.cloneNode(!0):a.cloneNode(!0);if(this.optionsStore.options.display.components.hours){let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementHour),e.setAttribute("data-action",V.incrementHours),e.appendChild(o.cloneNode(!0)),t.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickHour),e.setAttribute("data-action",V.showHours),e.setAttribute("data-time-component",r.hours),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementHour),e.setAttribute("data-action",V.decrementHours),e.appendChild(n.cloneNode(!0)),i.push(e),this._gridColumns+="a"}if(this.optionsStore.options.display.components.minutes){this._gridColumns+=" a",this.optionsStore.options.display.components.hours&&(t.push(d()),s.push(d(!0)),i.push(d()),this._gridColumns+=" a");let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementMinute),e.setAttribute("data-action",V.incrementMinutes),e.appendChild(o.cloneNode(!0)),t.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickMinute),e.setAttribute("data-action",V.showMinutes),e.setAttribute("data-time-component",r.minutes),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementMinute),e.setAttribute("data-action",V.decrementMinutes),e.appendChild(n.cloneNode(!0)),i.push(e)}if(this.optionsStore.options.display.components.seconds){this._gridColumns+=" a",this.optionsStore.options.display.components.minutes&&(t.push(d()),s.push(d(!0)),i.push(d()),this._gridColumns+=" a");let e=document.createElement("div");e.setAttribute("title",this.optionsStore.options.localization.incrementSecond),e.setAttribute("data-action",V.incrementSeconds),e.appendChild(o.cloneNode(!0)),t.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.pickSecond),e.setAttribute("data-action",V.showSeconds),e.setAttribute("data-time-component",r.seconds),s.push(e),e=document.createElement("div"),e.setAttribute("title",this.optionsStore.options.localization.decrementSecond),e.setAttribute("data-action",V.decrementSeconds),e.appendChild(n.cloneNode(!0)),i.push(e)}if(this.optionsStore.isTwelveHour){this._gridColumns+=" a";let e=d();t.push(e);const a=document.createElement("button");a.setAttribute("type","button"),a.setAttribute("title",this.optionsStore.options.localization.toggleMeridiem),a.setAttribute("data-action",V.toggleMeridiem),a.setAttribute("tabindex","-1"),Namespace.css.toggleMeridiem.includes(",")?a.classList.add(...Namespace.css.toggleMeridiem.split(",")):a.classList.add(Namespace.css.toggleMeridiem),e=document.createElement("div"),e.classList.add(Namespace.css.noHighlight),e.appendChild(a),s.push(e),e=d(),i.push(e)}return this._gridColumns=this._gridColumns.trim(),[...t,...s,...i]}}class HourDisplay{constructor(){this.optionsStore=p.locate(OptionsStore),this.validation=p.locate(Validation)}getPicker(){const e=document.createElement("div");e.classList.add(Namespace.css.hourContainer);for(let t=0;t<(this.optionsStore.isTwelveHour?12:24);t++){const t=document.createElement("div");t.setAttribute("data-action",V.selectHour),e.appendChild(t)}return e}_update(e,t){const s=e.getElementsByClassName(Namespace.css.hourContainer)[0],i=this.optionsStore.viewDate.clone.startOf(r.date);s.querySelectorAll(`[data-action="${V.selectHour}"]`).forEach((e=>{const s=[];s.push(Namespace.css.hour),this.validation.isValid(i,r.hours)||s.push(Namespace.css.disabled),t(r.hours,i,s,e),e.classList.remove(...e.classList),e.classList.add(...s),e.setAttribute("data-value",`${i.hours}`),e.innerText=i.getHoursFormatted(this.optionsStore.options.localization.hourCycle),i.manipulate(1,r.hours)}))}}class MinuteDisplay{constructor(){this.optionsStore=p.locate(OptionsStore),this.validation=p.locate(Validation)}getPicker(){const e=document.createElement("div");e.classList.add(Namespace.css.minuteContainer);const t=1===this.optionsStore.options.stepping?5:this.optionsStore.options.stepping;for(let s=0;s<60/t;s++){const t=document.createElement("div");t.setAttribute("data-action",V.selectMinute),e.appendChild(t)}return e}_update(e,t){const s=e.getElementsByClassName(Namespace.css.minuteContainer)[0],i=this.optionsStore.viewDate.clone.startOf(r.hours),a=1===this.optionsStore.options.stepping?5:this.optionsStore.options.stepping;s.querySelectorAll(`[data-action="${V.selectMinute}"]`).forEach((e=>{const s=[];s.push(Namespace.css.minute),this.validation.isValid(i,r.minutes)||s.push(Namespace.css.disabled),t(r.minutes,i,s,e),e.classList.remove(...e.classList),e.classList.add(...s),e.setAttribute("data-value",`${i.minutes}`),e.innerText=i.minutesFormatted,i.manipulate(a,r.minutes)}))}}class secondDisplay{constructor(){this.optionsStore=p.locate(OptionsStore),this.validation=p.locate(Validation)}getPicker(){const e=document.createElement("div");e.classList.add(Namespace.css.secondContainer);for(let t=0;t<12;t++){const t=document.createElement("div");t.setAttribute("data-action",V.selectSecond),e.appendChild(t)}return e}_update(e,t){const s=e.getElementsByClassName(Namespace.css.secondContainer)[0],i=this.optionsStore.viewDate.clone.startOf(r.minutes);s.querySelectorAll(`[data-action="${V.selectSecond}"]`).forEach((e=>{const s=[];s.push(Namespace.css.second),this.validation.isValid(i,r.seconds)||s.push(Namespace.css.disabled),t(r.seconds,i,s,e),e.classList.remove(...e.classList),e.classList.add(...s),e.setAttribute("data-value",`${i.seconds}`),e.innerText=i.secondsFormatted,i.manipulate(5,r.seconds)}))}}class Collapse{static toggle(e){e.classList.contains(Namespace.css.show)?this.hide(e):this.show(e)}static showImmediately(e){e.classList.remove(Namespace.css.collapsing),e.classList.add(Namespace.css.collapse,Namespace.css.show),e.style.height=""}static show(e){if(e.classList.contains(Namespace.css.collapsing)||e.classList.contains(Namespace.css.show))return;e.style.height="0",e.classList.remove(Namespace.css.collapse),e.classList.add(Namespace.css.collapsing),setTimeout((()=>{Collapse.showImmediately(e)}),this.getTransitionDurationFromElement(e)),e.style.height=`${e.scrollHeight}px`}static hideImmediately(e){e&&(e.classList.remove(Namespace.css.collapsing,Namespace.css.show),e.classList.add(Namespace.css.collapse))}static hide(e){if(e.classList.contains(Namespace.css.collapsing)||!e.classList.contains(Namespace.css.show))return;e.style.height=`${e.getBoundingClientRect().height}px`;e.offsetHeight,e.classList.remove(Namespace.css.collapse,Namespace.css.show),e.classList.add(Namespace.css.collapsing),e.style.height="",setTimeout((()=>{Collapse.hideImmediately(e)}),this.getTransitionDurationFromElement(e))}}Collapse.getTransitionDurationFromElement=e=>{if(!e)return 0;let{transitionDuration:t,transitionDelay:s}=window.getComputedStyle(e);const i=Number.parseFloat(t),a=Number.parseFloat(s);return i||a?(t=t.split(",")[0],s=s.split(",")[0],1e3*(Number.parseFloat(t)+Number.parseFloat(s))):0};class Display{constructor(){this._isVisible=!1,this._documentClickEvent=e=>{this.optionsStore.options.debug||window.debug||!this._isVisible||e.composedPath().includes(this.widget)||e.composedPath()?.includes(this.optionsStore.element)||this.hide()},this._actionsClickEvent=e=>{this._eventEmitters.action.emit({e:e})},this.optionsStore=p.locate(OptionsStore),this.validation=p.locate(Validation),this.dates=p.locate(Dates),this.dateDisplay=p.locate(DateDisplay),this.monthDisplay=p.locate(MonthDisplay),this.yearDisplay=p.locate(YearDisplay),this.decadeDisplay=p.locate(DecadeDisplay),this.timeDisplay=p.locate(TimeDisplay),this.hourDisplay=p.locate(HourDisplay),this.minuteDisplay=p.locate(MinuteDisplay),this.secondDisplay=p.locate(secondDisplay),this._eventEmitters=p.locate(EventEmitters),this._widget=void 0,this._eventEmitters.updateDisplay.subscribe((e=>{this._update(e)}))}get widget(){return this._widget}get dateContainer(){return this.widget?.querySelector(`div.${Namespace.css.dateContainer}`)}get timeContainer(){return this.widget?.querySelector(`div.${Namespace.css.timeContainer}`)}get isVisible(){return this._isVisible}_update(e){if(this.widget)switch(e){case r.seconds:this.secondDisplay._update(this.widget,this.paint);break;case r.minutes:this.minuteDisplay._update(this.widget,this.paint);break;case r.hours:this.hourDisplay._update(this.widget,this.paint);break;case r.date:this.dateDisplay._update(this.widget,this.paint);break;case r.month:this.monthDisplay._update(this.widget,this.paint);break;case r.year:this.yearDisplay._update(this.widget,this.paint);break;case"decade":this.decadeDisplay._update(this.widget,this.paint);break;case"clock":if(!this._hasTime)break;this.timeDisplay._update(this.widget),this._update(r.hours),this._update(r.minutes),this._update(r.seconds);break;case"calendar":this._update(r.date),this._update(r.year),this._update(r.month),this.decadeDisplay._update(this.widget,this.paint),this._updateCalendarHeader();break;case"all":this._hasTime&&this._update("clock"),this._hasDate&&this._update("calendar")}}paint(e,t,s,i){}show(){if(null==this.widget){if(this._showSetDefaultIfNeeded(),this._buildWidget(),this._updateTheme(),this._showSetupViewMode(),this.optionsStore.options.display.inline)this.optionsStore.element.appendChild(this.widget);else{const e=this.optionsStore.options?.container||document.body,t=this.optionsStore.options?.display?.placement||"bottom";e.appendChild(this.widget),this.createPopup(this.optionsStore.element,this.widget,{modifiers:[{name:"eventListeners",enabled:!0}],placement:"rtl"===document.documentElement.dir?`${t}-end`:`${t}-start`}).then()}"clock"==this.optionsStore.options.display.viewMode&&this._eventEmitters.action.emit({e:null,action:V.showClock}),this.widget.querySelectorAll("[data-action]").forEach((e=>e.addEventListener("click",this._actionsClickEvent))),this._hasTime&&this.optionsStore.options.display.sideBySide&&(this.timeDisplay._update(this.widget),this.widget.getElementsByClassName(Namespace.css.clockContainer)[0].style.display="grid")}this.widget.classList.add(Namespace.css.show),this.optionsStore.options.display.inline||(this.updatePopup(),document.addEventListener("click",this._documentClickEvent)),this._eventEmitters.triggerEvent.emit({type:Namespace.events.show}),this._isVisible=!0}_showSetupViewMode(){const e=this._hasTime&&!this._hasDate;e?(this.optionsStore.currentView="clock",this._eventEmitters.action.emit({e:null,action:V.showClock})):this.optionsStore.currentCalendarViewMode||(this.optionsStore.currentCalendarViewMode=this.optionsStore.minimumCalendarViewMode),e||"clock"===this.optionsStore.options.display.viewMode||(this._hasTime&&(this.optionsStore.options.display.sideBySide?Collapse.show(this.timeContainer):Collapse.hideImmediately(this.timeContainer)),Collapse.show(this.dateContainer)),this._hasDate&&this._showMode()}_showSetDefaultIfNeeded(){if(0==this.dates.picked.length){if(this.optionsStore.options.useCurrent&&!this.optionsStore.options.defaultDate){const e=(new DateTime).setLocalization(this.optionsStore.options.localization);if(!this.optionsStore.options.keepInvalid){let t=0,s=1;for(this.optionsStore.options.restrictions.maxDate?.isBefore(e)&&(s=-1);!this.validation.isValid(e)&&t>31;)e.manipulate(s,r.date),t++}this.dates.setValue(e)}this.optionsStore.options.defaultDate&&this.dates.setValue(this.optionsStore.options.defaultDate)}}async createPopup(e,t,s){let i;if(window?.Popper)i=window?.Popper?.createPopper;else{const{createPopper:e}=await import("@popperjs/core");i=e}i&&(this._popperInstance=i(e,t,s))}updatePopup(){this._popperInstance?.update()}_showMode(e){if(!this.widget)return;if(e){const t=Math.max(this.optionsStore.minimumCalendarViewMode,Math.min(3,this.optionsStore.currentCalendarViewMode+e));if(this.optionsStore.currentCalendarViewMode==t)return;this.optionsStore.currentCalendarViewMode=t}this.widget.querySelectorAll(`.${Namespace.css.dateContainer} > div:not(.${Namespace.css.calendarHeader}), .${Namespace.css.timeContainer} > div:not(.${Namespace.css.clockContainer})`).forEach((e=>e.style.display="none"));const t=u[this.optionsStore.currentCalendarViewMode],s=this.widget.querySelector(`.${t.className}`);switch(t.className){case Namespace.css.decadesContainer:this.decadeDisplay._update(this.widget,this.paint);break;case Namespace.css.yearsContainer:this.yearDisplay._update(this.widget,this.paint);break;case Namespace.css.monthsContainer:this.monthDisplay._update(this.widget,this.paint);break;case Namespace.css.daysContainer:this.dateDisplay._update(this.widget,this.paint)}s.style.display="grid",this.optionsStore.options.display.sideBySide&&(this.widget.querySelectorAll(`.${Namespace.css.clockContainer}`)[0].style.display="grid"),this._updateCalendarHeader(),this._eventEmitters.viewUpdate.emit()}_updateTheme(e){if(this.widget){if(e){if(this.optionsStore.options.display.theme===e)return;this.optionsStore.options.display.theme=e}this.widget.classList.remove("light","dark"),this.widget.classList.add(this._getThemeClass()),"auto"===this.optionsStore.options.display.theme?window.matchMedia(Namespace.css.isDarkPreferredQuery).addEventListener("change",(()=>this._updateTheme())):window.matchMedia(Namespace.css.isDarkPreferredQuery).removeEventListener("change",(()=>this._updateTheme()))}}_getThemeClass(){const e=this.optionsStore.options.display.theme||"auto",t=window.matchMedia&&window.matchMedia(Namespace.css.isDarkPreferredQuery).matches;switch(e){case"light":return Namespace.css.lightTheme;case"dark":return Namespace.css.darkTheme;case"auto":return t?Namespace.css.darkTheme:Namespace.css.lightTheme}}_updateCalendarHeader(){if(!this._hasDate)return;const e=[...this.widget.querySelector(`.${Namespace.css.dateContainer} div[style*="display: grid"]`).classList].find((e=>e.startsWith(Namespace.css.dateContainer))),[t,s,i]=this.widget.getElementsByClassName(Namespace.css.calendarHeader)[0].getElementsByTagName("div");switch(e){case Namespace.css.decadesContainer:t.setAttribute("title",this.optionsStore.options.localization.previousCentury),s.setAttribute("title",""),i.setAttribute("title",this.optionsStore.options.localization.nextCentury);break;case Namespace.css.yearsContainer:t.setAttribute("title",this.optionsStore.options.localization.previousDecade),s.setAttribute("title",this.optionsStore.options.localization.selectDecade),i.setAttribute("title",this.optionsStore.options.localization.nextDecade);break;case Namespace.css.monthsContainer:t.setAttribute("title",this.optionsStore.options.localization.previousYear),s.setAttribute("title",this.optionsStore.options.localization.selectYear),i.setAttribute("title",this.optionsStore.options.localization.nextYear);break;case Namespace.css.daysContainer:t.setAttribute("title",this.optionsStore.options.localization.previousMonth),s.setAttribute("title",this.optionsStore.options.localization.selectMonth),i.setAttribute("title",this.optionsStore.options.localization.nextMonth),s.setAttribute(e,this.optionsStore.viewDate.format(this.optionsStore.options.localization.dayViewHeaderFormat))}s.innerText=s.getAttribute(e)}hide(){this.widget&&this._isVisible&&(this.widget.classList.remove(Namespace.css.show),this._isVisible&&(this._eventEmitters.triggerEvent.emit({type:Namespace.events.hide,date:this.optionsStore.unset?null:this.dates.lastPicked?.clone}),this._isVisible=!1),document.removeEventListener("click",this._documentClickEvent))}toggle(){return this._isVisible?this.hide():this.show()}_dispose(){document.removeEventListener("click",this._documentClickEvent),this.widget&&(this.widget.querySelectorAll("[data-action]").forEach((e=>e.removeEventListener("click",this._actionsClickEvent))),this.widget.parentNode.removeChild(this.widget),this._widget=void 0)}_buildWidget(){const e=document.createElement("div");e.classList.add(Namespace.css.widget);const t=document.createElement("div");t.classList.add(Namespace.css.dateContainer),t.append(this.getHeadTemplate(),this.decadeDisplay.getPicker(),this.yearDisplay.getPicker(),this.monthDisplay.getPicker(),this.dateDisplay.getPicker());const s=document.createElement("div");s.classList.add(Namespace.css.timeContainer),s.appendChild(this.timeDisplay.getPicker(this._iconTag.bind(this))),s.appendChild(this.hourDisplay.getPicker()),s.appendChild(this.minuteDisplay.getPicker()),s.appendChild(this.secondDisplay.getPicker());const i=document.createElement("div");if(i.classList.add(Namespace.css.toolbar),i.append(...this.getToolbarElements()),this.optionsStore.options.display.inline&&e.classList.add(Namespace.css.inline),this.optionsStore.options.display.calendarWeeks&&e.classList.add("calendarWeeks"),this.optionsStore.options.display.sideBySide&&this._hasDateAndTime)return void this._buildWidgetSideBySide(e,t,s,i);"top"===this.optionsStore.options.display.toolbarPlacement&&e.appendChild(i);const a=(t,s,i,a)=>{t&&(s&&(i.classList.add(Namespace.css.collapse),a&&i.classList.add(Namespace.css.show)),e.appendChild(i))};a(this._hasDate,this._hasTime,t,"clock"!==this.optionsStore.options.display.viewMode),a(this._hasTime,this._hasDate,s,"clock"===this.optionsStore.options.display.viewMode),"bottom"===this.optionsStore.options.display.toolbarPlacement&&e.appendChild(i);const o=document.createElement("div");o.classList.add("arrow"),o.setAttribute("data-popper-arrow",""),e.appendChild(o),this._widget=e}_buildWidgetSideBySide(e,t,s,i){e.classList.add(Namespace.css.sideBySide),"top"===this.optionsStore.options.display.toolbarPlacement&&e.appendChild(i);const a=document.createElement("div");a.classList.add("td-row"),t.classList.add("td-half"),s.classList.add("td-half"),a.appendChild(t),a.appendChild(s),e.appendChild(a),"bottom"===this.optionsStore.options.display.toolbarPlacement&&e.appendChild(i),this._widget=e}get _hasTime(){return this.optionsStore.options.display.components.clock&&(this.optionsStore.options.display.components.hours||this.optionsStore.options.display.components.minutes||this.optionsStore.options.display.components.seconds)}get _hasDate(){return this.optionsStore.options.display.components.calendar&&(this.optionsStore.options.display.components.year||this.optionsStore.options.display.components.month||this.optionsStore.options.display.components.date)}get _hasDateAndTime(){return this._hasDate&&this._hasTime}getToolbarElements(){const e=[];if(this.optionsStore.options.display.buttons.today){const t=document.createElement("div");t.setAttribute("data-action",V.today),t.setAttribute("title",this.optionsStore.options.localization.today),t.appendChild(this._iconTag(this.optionsStore.options.display.icons.today)),e.push(t)}if(!this.optionsStore.options.display.sideBySide&&this._hasDate&&this._hasTime){let t,s;"clock"===this.optionsStore.options.display.viewMode?(t=this.optionsStore.options.localization.selectDate,s=this.optionsStore.options.display.icons.date):(t=this.optionsStore.options.localization.selectTime,s=this.optionsStore.options.display.icons.time);const i=document.createElement("div");i.setAttribute("data-action",V.togglePicker),i.setAttribute("title",t),i.appendChild(this._iconTag(s)),e.push(i)}if(this.optionsStore.options.display.buttons.clear){const t=document.createElement("div");t.setAttribute("data-action",V.clear),t.setAttribute("title",this.optionsStore.options.localization.clear),t.appendChild(this._iconTag(this.optionsStore.options.display.icons.clear)),e.push(t)}if(this.optionsStore.options.display.buttons.close){const t=document.createElement("div");t.setAttribute("data-action",V.close),t.setAttribute("title",this.optionsStore.options.localization.close),t.appendChild(this._iconTag(this.optionsStore.options.display.icons.close)),e.push(t)}return e}getHeadTemplate(){const e=document.createElement("div");e.classList.add(Namespace.css.calendarHeader);const t=document.createElement("div");t.classList.add(Namespace.css.previous),t.setAttribute("data-action",V.previous),t.appendChild(this._iconTag(this.optionsStore.options.display.icons["rtl"===document.documentElement.dir?"next":"previous"]));const s=document.createElement("div");s.classList.add(Namespace.css.switch),s.setAttribute("data-action",V.changeCalendarView);const i=document.createElement("div");return i.classList.add(Namespace.css.next),i.setAttribute("data-action",V.next),i.appendChild(this._iconTag(this.optionsStore.options.display.icons["rtl"===document.documentElement.dir?"previous":"next"])),e.append(t,s,i),e}_iconTag(e){if("sprites"===this.optionsStore.options.display.icons.type){const t=document.createElementNS("http://www.w3.org/2000/svg","svg"),s=document.createElementNS("http://www.w3.org/2000/svg","use");return s.setAttribute("xlink:href",e),s.setAttribute("href",e),t.appendChild(s),t}const t=document.createElement("i");return t.classList.add(...e.split(" ")),t}_rebuild(){const e=this._isVisible;this._dispose(),e&&this.show()}refreshCurrentView(){switch(this._isVisible||this._dispose(),this.optionsStore.currentView){case"clock":this._update("clock");break;case"calendar":this._update(r.date);break;case"months":this._update(r.month);break;case"years":this._update(r.year);break;case"decades":this._update("decade")}}}class Actions{constructor(){this.optionsStore=p.locate(OptionsStore),this.dates=p.locate(Dates),this.validation=p.locate(Validation),this.display=p.locate(Display),this._eventEmitters=p.locate(EventEmitters),this._eventEmitters.action.subscribe((e=>{this.do(e.e,e.action)}))}do(e,t){const s=e?.currentTarget;if(s?.classList?.contains(Namespace.css.disabled))return;t=t||s?.dataset?.action;const i=(this.dates.lastPicked||this.optionsStore.viewDate).clone;switch(t){case V.next:case V.previous:this.handleNextPrevious(t);break;case V.changeCalendarView:this.display._showMode(1),this.display._updateCalendarHeader();break;case V.selectMonth:case V.selectYear:case V.selectDecade:this.handleSelectCalendarMode(t,s);break;case V.selectDay:this.handleSelectDay(s);break;case V.selectHour:{let t=+s.dataset.value;i.hours>=12&&this.optionsStore.isTwelveHour&&(t+=12),i.hours=t,this.dates.setValue(i,this.dates.lastPickedIndex),this.hideOrClock(e);break}case V.selectMinute:i.minutes=+s.dataset.value,this.dates.setValue(i,this.dates.lastPickedIndex),this.hideOrClock(e);break;case V.selectSecond:i.seconds=+s.dataset.value,this.dates.setValue(i,this.dates.lastPickedIndex),this.hideOrClock(e);break;case V.incrementHours:this.manipulateAndSet(i,r.hours);break;case V.incrementMinutes:this.manipulateAndSet(i,r.minutes,this.optionsStore.options.stepping);break;case V.incrementSeconds:this.manipulateAndSet(i,r.seconds);break;case V.decrementHours:this.manipulateAndSet(i,r.hours,-1);break;case V.decrementMinutes:this.manipulateAndSet(i,r.minutes,-1*this.optionsStore.options.stepping);break;case V.decrementSeconds:this.manipulateAndSet(i,r.seconds,-1);break;case V.toggleMeridiem:this.manipulateAndSet(i,r.hours,this.dates.lastPicked.hours>=12?-12:12);break;case V.togglePicker:this.handleToggle(s);break;case V.showClock:case V.showHours:case V.showMinutes:case V.showSeconds:this.optionsStore.options.display.sideBySide||"clock"===this.optionsStore.currentView||(Collapse.hideImmediately(this.display.dateContainer),Collapse.showImmediately(this.display.timeContainer)),this.handleShowClockContainers(t);break;case V.clear:this.dates.setValue(null),this.display._updateCalendarHeader();break;case V.close:this.display.hide();break;case V.today:{const e=(new DateTime).setLocalization(this.optionsStore.options.localization);this._eventEmitters.updateViewDate.emit(e),this.validation.isValid(e,r.date)&&this.dates.setValue(e,this.dates.lastPickedIndex);break}}}handleShowClockContainers(e){if(!this.display._hasTime)return void Namespace.errorMessages.throwError("Cannot show clock containers when time is disabled.");this.optionsStore.currentView="clock",this.display.widget.querySelectorAll(`.${Namespace.css.timeContainer} > div`).forEach((e=>e.style.display="none"));let t="";switch(e){case V.showClock:t=Namespace.css.clockContainer,this.display._update("clock");break;case V.showHours:t=Namespace.css.hourContainer,this.display._update(r.hours);break;case V.showMinutes:t=Namespace.css.minuteContainer,this.display._update(r.minutes);break;case V.showSeconds:t=Namespace.css.secondContainer,this.display._update(r.seconds)}this.display.widget.getElementsByClassName(t)[0].style.display="grid"}handleNextPrevious(e){const{unit:t,step:s}=u[this.optionsStore.currentCalendarViewMode];e===V.next?this.optionsStore.viewDate.manipulate(s,t):this.optionsStore.viewDate.manipulate(-1*s,t),this._eventEmitters.viewUpdate.emit(),this.display._showMode()}hideOrClock(e){this.optionsStore.isTwelveHour||this.optionsStore.options.display.components.minutes||this.optionsStore.options.display.keepOpen||this.optionsStore.options.display.inline?this.do(e,V.showClock):this.display.hide()}manipulateAndSet(e,t,s=1){const i=e.manipulate(s,t);this.validation.isValid(i,t)&&this.dates.setValue(i,this.dates.lastPickedIndex)}handleSelectCalendarMode(e,t){const s=+t.dataset.value;switch(e){case V.selectMonth:this.optionsStore.viewDate.month=s;break;case V.selectYear:case V.selectDecade:this.optionsStore.viewDate.year=s}this.optionsStore.currentCalendarViewMode===this.optionsStore.minimumCalendarViewMode?(this.dates.setValue(this.optionsStore.viewDate,this.dates.lastPickedIndex),this.optionsStore.options.display.inline||this.display.hide()):this.display._showMode(-1)}handleToggle(e){e.getAttribute("title")===this.optionsStore.options.localization.selectDate?(e.setAttribute("title",this.optionsStore.options.localization.selectTime),e.innerHTML=this.display._iconTag(this.optionsStore.options.display.icons.time).outerHTML,this.display._updateCalendarHeader(),this.optionsStore.refreshCurrentView()):(e.setAttribute("title",this.optionsStore.options.localization.selectDate),e.innerHTML=this.display._iconTag(this.optionsStore.options.display.icons.date).outerHTML,this.display._hasTime&&(this.handleShowClockContainers(V.showClock),this.display._update("clock"))),this.display.widget.querySelectorAll(`.${Namespace.css.dateContainer}, .${Namespace.css.timeContainer}`).forEach((e=>Collapse.toggle(e))),this._eventEmitters.viewUpdate.emit()}handleSelectDay(e){const t=this.optionsStore.viewDate.clone;e.classList.contains(Namespace.css.old)&&t.manipulate(-1,r.month),e.classList.contains(Namespace.css.new)&&t.manipulate(1,r.month),t.date=+e.dataset.day,this.optionsStore.options.dateRange?this.handleDateRange(t):this.optionsStore.options.multipleDates?this.handleMultiDate(t):this.dates.setValue(t,this.dates.lastPickedIndex),this.display._hasTime||this.optionsStore.options.display.keepOpen||this.optionsStore.options.display.inline||this.optionsStore.options.multipleDates||this.optionsStore.options.dateRange||this.display.hide()}handleMultiDate(e){let t=this.dates.pickedIndex(e,r.date);-1!==t?this.dates.setValue(null,t):(t=this.dates.lastPickedIndex+1,0===this.dates.picked.length&&(t=0),this.dates.setValue(e,t))}handleDateRange(e){switch(this.dates.picked.length){case 2:this.dates.clear();break;case 1:{const t=this.dates.picked[0];if(e.getTime()===t.getTime()){this.dates.clear();break}return e.isBefore(t)?(this.dates.setValue(e,0),void this.dates.setValue(t,1)):void this.dates.setValue(e,1)}}this.dates.setValue(e,0)}}class TempusDominus{constructor(e,t={}){this._subscribers={},this._isDisabled=!1,this._inputChangeEvent=e=>{const t=e?.detail;if(t)return;const s=()=>{this.dates.lastPicked&&(this.optionsStore.viewDate=this.dates.lastPicked.clone)},i=this.optionsStore.input.value;if(this.optionsStore.options.multipleDates||this.optionsStore.options.dateRange)try{const e=i.split(this.optionsStore.options.multipleDatesSeparator);for(let t=0;t<e.length;t++)this.dates.setFromInput(e[t],t);s()}catch{console.warn("TD: Something went wrong trying to set the multipleDates values from the input field.")}else this.dates.setFromInput(i,0),s()},this._toggleClickEvent=()=>{this.optionsStore.element?.disabled||this.optionsStore.input?.disabled||"INPUT"===this._toggle.nodeName&&"text"===this._toggle?.type&&this.optionsStore.options.allowInputToggle||this.toggle()},this._openClickEvent=()=>{this.optionsStore.element?.disabled||this.optionsStore.input?.disabled||this.display.isVisible||this.show()},p=new ServiceLocator,this._eventEmitters=p.locate(EventEmitters),this.optionsStore=p.locate(OptionsStore),this.display=p.locate(Display),this.dates=p.locate(Dates),this.actions=p.locate(Actions),e||Namespace.errorMessages.mustProvideElement(),this.optionsStore.element=e,this._initializeOptions(t,y,!0),this.optionsStore.viewDate.setLocalization(this.optionsStore.options.localization),this.optionsStore.unset=!0,this._initializeInput(),this._initializeToggle(),this.optionsStore.options.display.inline&&this.display.show(),this._eventEmitters.triggerEvent.subscribe((e=>{this._triggerEvent(e)})),this._eventEmitters.viewUpdate.subscribe((()=>{this._viewUpdate()})),this._eventEmitters.updateViewDate.subscribe((e=>{this.viewDate=e}))}get viewDate(){return this.optionsStore.viewDate}set viewDate(e){this.optionsStore.viewDate=e,this.optionsStore.viewDate.setLocalization(this.optionsStore.options.localization),this.display._update("clock"===this.optionsStore.currentView?"clock":"calendar")}updateOptions(e,t=!1){t?this._initializeOptions(e,y):this._initializeOptions(e,this.optionsStore.options),this.optionsStore.viewDate.setLocalization(this.optionsStore.options.localization),this.display.refreshCurrentView()}toggle(){this._isDisabled||this.display.toggle()}show(){this._isDisabled||this.display.show()}hide(){this.display.hide()}disable(){this._isDisabled=!0,this.optionsStore.input?.setAttribute("disabled","disabled"),this.display.hide()}enable(){this._isDisabled=!1,this.optionsStore.input?.removeAttribute("disabled")}clear(){this.optionsStore.input.value="",this.dates.clear()}subscribe(e,t){let s;"string"==typeof e&&(e=[e]),s=Array.isArray(t)?t:[t],e.length!==s.length&&Namespace.errorMessages.subscribeMismatch();const i=[];for(let t=0;t<e.length;t++){const a=e[t];if(Array.isArray(this._subscribers[a])||(this._subscribers[a]=[]),this._subscribers[a].push(s[t]),i.push({unsubscribe:this._unsubscribe.bind(this,a,this._subscribers[a].length-1)}),1===e.length)return i[0]}return i}dispose(){this.display.hide(),this.display._dispose(),this._eventEmitters.destroy(),this.optionsStore.input?.removeEventListener("change",this._inputChangeEvent),this.optionsStore.options.allowInputToggle&&(this.optionsStore.input?.removeEventListener("click",this._openClickEvent),this.optionsStore.input?.removeEventListener("focus",this._openClickEvent)),this._toggle?.removeEventListener("click",this._toggleClickEvent),this._subscribers={}}locale(e){const t=O[e];t&&this.updateOptions({localization:t})}_triggerEvent(e){e.viewMode=this.optionsStore.currentView;const t=e.type===Namespace.events.change;if(t){const{date:t,oldDate:s,isClear:i}=e;if(t&&s&&t.isSame(s)||!i&&!t&&!s)return;this._handleAfterChangeEvent(e),this.optionsStore.input?.dispatchEvent(new CustomEvent("change",{detail:e}))}if(this.optionsStore.element.dispatchEvent(new CustomEvent(e.type,{detail:e})),window.jQuery){const s=window.jQuery;t&&this.optionsStore.input?s(this.optionsStore.input).trigger(e):s(this.optionsStore.element).trigger(e)}this._publish(e)}_publish(e){Array.isArray(this._subscribers[e.type])&&this._subscribers[e.type].forEach((t=>{t(e)}))}_viewUpdate(){this._triggerEvent({type:Namespace.events.update,viewDate:this.optionsStore.viewDate.clone})}_unsubscribe(e,t){this._subscribers[e].splice(t,1)}_initializeOptions(e,t,s=!1){let i=OptionConverter.deepCopy(e);i=OptionConverter._mergeOptions(i,t),s&&(i=OptionConverter._dataToOptions(this.optionsStore.element,i)),OptionConverter._validateConflicts(i),i.viewDate=i.viewDate.setLocalization(i.localization),this.optionsStore.viewDate.isSame(i.viewDate)||(this.optionsStore.viewDate=i.viewDate),i.display.components.year&&(this.optionsStore.minimumCalendarViewMode=2),i.display.components.month&&(this.optionsStore.minimumCalendarViewMode=1),i.display.components.date&&(this.optionsStore.minimumCalendarViewMode=0),this.optionsStore.currentCalendarViewMode=Math.max(this.optionsStore.minimumCalendarViewMode,this.optionsStore.currentCalendarViewMode),u[this.optionsStore.currentCalendarViewMode].name!==i.display.viewMode&&(this.optionsStore.currentCalendarViewMode=Math.max(u.findIndex((e=>e.name===i.display.viewMode)),this.optionsStore.minimumCalendarViewMode)),this.display?.isVisible&&this.display._update("all"),i.display.components.useTwentyfourHour&&void 0===i.localization.hourCycle?i.localization.hourCycle="h24":void 0===i.localization.hourCycle&&(i.localization.hourCycle=h(i.localization.locale)),this.optionsStore.options=i,i.restrictions.maxDate&&this.viewDate.isAfter(i.restrictions.maxDate)&&(this.viewDate=i.restrictions.maxDate.clone),i.restrictions.minDate&&this.viewDate.isBefore(i.restrictions.minDate)&&(this.viewDate=i.restrictions.minDate.clone)}_initializeInput(){if("INPUT"==this.optionsStore.element.tagName)this.optionsStore.input=this.optionsStore.element;else{const e=this.optionsStore.element.dataset.tdTargetInput;this.optionsStore.input=null==e||"nearest"==e?this.optionsStore.element.querySelector("input"):this.optionsStore.element.querySelector(e)}this.optionsStore.input&&(!this.optionsStore.input.value&&this.optionsStore.options.defaultDate&&(this.optionsStore.input.value=this.dates.formatInput(this.optionsStore.options.defaultDate)),this.optionsStore.input.addEventListener("change",this._inputChangeEvent),this.optionsStore.options.allowInputToggle&&(this.optionsStore.input.addEventListener("click",this._openClickEvent),this.optionsStore.input.addEventListener("focus",this._openClickEvent)),this.optionsStore.input.value&&this._inputChangeEvent())}_initializeToggle(){if(this.optionsStore.options.display.inline)return;let e=this.optionsStore.element.dataset.tdTargetToggle;"nearest"==e&&(e='[data-td-toggle="datetimepicker"]'),this._toggle=null==e?this.optionsStore.element:this.optionsStore.element.querySelector(e),this._toggle.addEventListener("click",this._toggleClickEvent)}_handleAfterChangeEvent(e){!this.optionsStore.options.promptTimeOnDateChange||this.optionsStore.options.multipleDates||this.optionsStore.options.display.inline||this.optionsStore.options.display.sideBySide||!this.display._hasTime||this.display.widget?.getElementsByClassName(Namespace.css.show)[0].classList.contains(Namespace.css.timeContainer)||!e.oldDate&&this.optionsStore.options.useCurrent||e.oldDate&&e.date?.isSame(e.oldDate)||(clearTimeout(this._currentPromptTimeTimeout),this._currentPromptTimeTimeout=setTimeout((()=>{this.display.widget&&this._eventEmitters.action.emit({e:{currentTarget:this.display.widget.querySelector('[data-action="togglePicker"]')},action:V.togglePicker})}),this.optionsStore.options.promptTimeOnDateChangeTransitionDelay))}}const O={},A=e=>{O[e.name]||(O[e.name]=e.localization)},$=e=>{const t=O[e];t&&(y.localization=t)},z=function(e,t=void 0){return e?(e.installed||(e(t,{TempusDominus:TempusDominus,Dates:Dates,Display:Display,DateTime:DateTime,Namespace:Namespace},x),e.installed=!0),x):x},H="6.9.4",x={TempusDominus:TempusDominus,extend:z,loadLocale:A,locale:$,Namespace:Namespace,DefaultOptions:y,DateTime:DateTime,Unit:r,version:H,DefaultEnLocalization:g};const I={__proto__:null,TempusDominus:TempusDominus,extend:z,loadLocale:A,locale:$,Namespace:Namespace,DefaultOptions:y,DateTime:DateTime,get Unit(){return r},version:H,DefaultEnLocalization:g};I.extend(((e,t,s)=>{t.Dates.prototype.setFromInput=function(e,t){let i=this.optionsStore.options.localization.locale,a=this.optionsStore.options.localization.format;if(a){let n={locale:i},r=new s.DateTime(o.DateTime.fromFormat(e,a,n).toJSDate());if(r&&r.getTime()==r.getTime()){let e=s.DateTime.convert(r,"",this.optionsStore.options.localization);this.setValue(e,t)}else console.error("Luxon failed to parse the input date.")}else console.error("Missing format.")},t.Dates.prototype.formatInput=function(e){let t=this.optionsStore.options.localization.locale,s=this.optionsStore.options.localization.format;if(s){let i={locale:t,outputCalendar:"gregory"};return e?o.DateTime.fromJSDate(e,i).toFormat(s):""}console.error("Missing format.")}})),
/*!
   * Tempus Dominus v6.9.4 (https://getdatepicker.com/)
    * Copyright 2013-2021 Jonathan Peterson
    * Licensed under MIT (https://github.com/Eonasdan/tempus-dominus/blob/master/LICENSE)
    */
I.jQueryInterface=function(e,t){return 1===this.length?I.jQueryHandleThis(this,e,t):this.each((function(){I.jQueryHandleThis(this,e,t)}))},I.jQueryHandleThis=function(e,t,s){let i=a.default(e).data(I.Namespace.dataKey);if("object"==typeof t&&(t=a.default.extend({},I.DefaultOptions,t)),i||(i=new I.TempusDominus(a.default(e)[0],t),a.default(e).data(I.Namespace.dataKey,i)),"string"==typeof t){if(void 0===i[t])throw new Error(`No method named "${t}"`);if(void 0===s)return i[t]();{"date"===t&&(i.isDateUpdateThroughDateOptionFromClientCode=!0);const e=i[t](s);return i.isDateUpdateThroughDateOptionFromClientCode=!1,e}}};const P="tempusDominus",F=a.default.fn[P];return a.default.fn[P]=I.jQueryInterface,a.default.fn[P].Constructor=I.TempusDominus,a.default.fn[P].noConflict=function(){return a.default.fn[P]=F,I.jQueryInterface},I}(jQuery,luxon);
//# sourceMappingURL=tempus-dominus.min.js.map