<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class WorldCityIndiaController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/worldcityindialist[/{id}]", [PermissionMiddleware::class], "list.world_city_india")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "WorldCityIndiaList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/worldcityindiaadd[/{id}]", [PermissionMiddleware::class], "add.world_city_india")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "WorldCityIndiaAdd");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/worldcityindiasearch", [PermissionMiddleware::class], "search.world_city_india")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "WorldCityIndiaSearch");
    }
}
