<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class WorldCityController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/worldcitylist[/{id}]", [PermissionMiddleware::class], "list.world_city")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "WorldCityList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/worldcityadd[/{id}]", [PermissionMiddleware::class], "add.world_city")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "WorldCityAdd");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/worldcitysearch", [PermissionMiddleware::class], "search.world_city")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "WorldCitySearch");
    }
}
