<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class WhatsappSetupController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/whatsappsetuplist[/{id}]", [PermissionMiddleware::class], "list.whatsapp_setup")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "WhatsappSetupList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/whatsappsetupadd[/{id}]", [PermissionMiddleware::class], "add.whatsapp_setup")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "WhatsappSetupAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/whatsappsetupview[/{id}]", [PermissionMiddleware::class], "view.whatsapp_setup")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "WhatsappSetupView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/whatsappsetupedit[/{id}]", [PermissionMiddleware::class], "edit.whatsapp_setup")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "WhatsappSetupEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/whatsappsetupdelete[/{id}]", [PermissionMiddleware::class], "delete.whatsapp_setup")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "WhatsappSetupDelete");
    }
}
