<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class VehicleInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/vehicleinfolist[/{id}]", [PermissionMiddleware::class], "list.vehicle_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VehicleInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/vehicleinfoadd[/{id}]", [PermissionMiddleware::class], "add.vehicle_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VehicleInfoAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/vehicleinfoaddopt", [PermissionMiddleware::class], "addopt.vehicle_info")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VehicleInfoAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/vehicleinfoview[/{id}]", [PermissionMiddleware::class], "view.vehicle_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VehicleInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/vehicleinfoedit[/{id}]", [PermissionMiddleware::class], "edit.vehicle_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VehicleInfoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/vehicleinfodelete[/{id}]", [PermissionMiddleware::class], "delete.vehicle_info")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VehicleInfoDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/vehicleinfosearch", [PermissionMiddleware::class], "search.vehicle_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VehicleInfoSearch");
    }
}
